<!-- SPDX-License-Identifier: CC-BY-4.0 -->
<!-- Copyright Contributors to the OpenColorIO Project. -->

February 03, 2020

Host: Michael Dolan

Rotating Secretary: Michael Dolan

Attendees:
  * [X] Mark Boorer (_TSC_) - Industrial Light & Magic
  * [ ] Sean Cooper (_TSC_) - DNEG
  * [X] Michael Dolan (_TSC Chair_) - Epic Games
  * [X] Larry Gritz (_TSC_) - Sony Pictures Imageworks
  * [X] Patrick Hodoul (_TSC_) - Autodesk
  * [ ] John Mertic - Academy Software Foundation / Linux Foundation
  * [X] Carl Rand (_TSC_) - Weta Digital
  * [X] Doug Walker (_TSC Chief Architect_) - Autodesk
  * [X] Kevin Wheatley (_TSC_) - Framestore
  * [X] Bernard Lefebvre - Autodesk
  * [X] Carol Payne - Netflix
  * [X] Mei Chu - Sony Pictures Imageworks

# **OCIO TSC Meeting Notes**

* ASWF Plenary Meeting recap
    - Michael and Doug gave brief (~5 minute) update to ASWF governing board, 
      TAC, and stakeholders on Jan 30th.
    - Overview of the project, the last year, and the coming year of development.
    - Interesting discussion around how ASWF can support USD.

* ASWF GSoC discussion
    - Polled Slack for project ideas for ASWF's application to Google Summer of 
      Code, and submitted PR to: 
      `https://github.com/AcademySoftwareFoundation/tac/blob/main/gsoc/README.md`_
    - In summary, four projects initially proposed:
          - Add Metal, Vulkan, or CUDA language support to GPU renderer
          - Restore Java bindings
          - Add OCIO support to FFmpeg or another FOSS project
          - Develop GUI for interactive OCIO config authoring and visualization
    - The initial projects and mentors are for the application, but can be ammended 
      anytime. Larry is submitting application on Wednesday.
    - Larry: Mentorship involves guiding students, checking in, grading their 
      contributions, etc.
          - If we're admitted to GSoC, students will submit proposals for projects,
            which could be something we've proposed, or something else.
          - It's good to set a minimum threshhold of requirements for who to accept. 
            For example, having students submit a trivial PR. Sorting through 
            applications can take too long otherwise.
          - Also good opportunity to find rough edges around building the library, 
            having students submit fixes or issues for issues they encounter.
    
* Python bindings
    - Michael: Resumed work on pybind11 bindings. Got everything up to date with 
      main.
    - Mei Chu (Imageworks) is interested in helping with this work, potentially 
      designing unit tests to start.
          - Mei: Looking forward to getting more involved in OCIO
    - Patrick: Is any work needed to support binding work? RGB array class for example?
          - Michael: For now I am planning to wrap everything as-is, but we can change
            that later if it makes sense.
          - The only issue in the API is the private destructor, which I'm making 
            public.
          - Mark: Not opposed to making the destructor public, but we might also want
            to consider changing how the API managaes memory. It currently only 
            supports shared_ptr. Most libraries don't impose this design like OCIO does.
          - Patrick: Memory management is especially critical on Windows with dynamic 
            libraries. We could consider other approaches.
          - Mark: ColorSpace objects shouldn't always need to be managed by shared_ptr, 
            for example. OCIO can control how to manage memory internally, but the API
            could allow users to decide how to manage objects they create.
          - The previous Python bindings were complicated by this too. Had to tie 
            the lifecycle of Python objects to the config to prevent deletion.
          - Michael: With the current pybind11 approach, changing memory management 
            later wouldn't require a lot of reworking in the binding code.
