/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 */

#undef NDEBUG  // get assert in release mode

#include <cassert>

#include "../sh4lt/ipcs/sysv-shm.hpp"
#include "../sh4lt/logger/console.hpp"

auto main() -> int {
  using namespace sh4lt;
  logger::Console logger;
  {
    sysVShm shm(1234, 1024, &logger, /*owner = */ true);
    assert(shm);
  }
  {
    sysVShm shm(1234, 1024, &logger, /*owner = */ true);
    assert(shm);
  }
  { //write read
    sysVShm shm_writer(1234, sizeof(int), &logger, /*owner = */ true);
    assert(shm_writer);
    sysVShm shm_reader(1234, sizeof(int), &logger, /*owner = */ false);
    assert(shm_reader);
    *(int *)shm_writer.get_mem() = 7;
    assert(7 == *(int *)shm_reader.get_mem());
  }
  
  return 0;
}

