// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause

#ifndef vtkMPI_h
#define vtkMPI_h

#ifndef USE_STDARG
#define USE_STDARG
#include "vtk_mpi.h"
#undef USE_STDARG
#else
#include "vtk_mpi.h"
#endif

#include "vtkParallelMPIModule.h" // For export macro
#include "vtkSystemIncludes.h"

VTK_ABI_NAMESPACE_BEGIN
class VTKPARALLELMPI_EXPORT vtkMPICommunicatorOpaqueComm
{
public:
  vtkMPICommunicatorOpaqueComm(MPI_Comm* handle = nullptr);

  MPI_Comm* GetHandle();

  friend class vtkMPICommunicator;
  friend class vtkMPIController;

protected:
  MPI_Comm* Handle;
};

class VTKPARALLELMPI_EXPORT vtkMPICommunicatorReceiveDataInfo
{
public:
  vtkMPICommunicatorReceiveDataInfo() { this->Handle = nullptr; }
  MPI_Datatype DataType;
  MPI_Status Status;
  MPI_Comm* Handle;
};

class VTKPARALLELMPI_EXPORT vtkMPIOpaqueFileHandle
{
public:
  vtkMPIOpaqueFileHandle()
    : Handle(MPI_FILE_NULL)
  {
  }
  MPI_File Handle;
};

//-----------------------------------------------------------------------------
class vtkMPICommunicatorOpaqueRequest
{
public:
  MPI_Request Handle;
};

VTK_ABI_NAMESPACE_END
#endif // vtkMPI_h
// VTK-HeaderTest-Exclude: vtkMPI.h
