# Помочь FastAPI - Получить помощь

Нравится ли Вам **FastAPI**?

Хотели бы Вы помочь FastAPI, его пользователям и автору?

Может быть у Вас возникли трудности с **FastAPI** и Вам нужна помощь?

Есть несколько очень простых способов оказания помощи (иногда достаточно всего лишь одного или двух кликов).

И также есть несколько способов получить помощь.

## Подписаться на новостную рассылку

Вы можете подписаться на редкую [новостную рассылку **FastAPI и его друзья**](newsletter.md){.internal-link target=_blank} и быть в курсе о:

* Новостях о FastAPI и его друзьях 🚀
* Руководствах 📝
* Возможностях ✨
* Исправлениях 🚨
* Подсказках и хитростях ✅

## Подписаться на FastAPI в Twitter

<a href="https://twitter.com/fastapi" class="external-link" target="_blank">Подписаться на @fastapi в **Twitter**</a> для получения наисвежайших новостей о **FastAPI**. 🐦

## Добавить **FastAPI** звезду на GitHub

Вы можете добавить FastAPI "звезду" на GitHub (кликнуть на кнопку звезды в верхнем правом углу экрана): <a href="https://github.com/tiangolo/fastapi" class="external-link" target="_blank">https://github.com/tiangolo/fastapi</a>. ⭐️

Чем больше звёзд, тем легче другим пользователям найти нас и увидеть, что проект уже стал полезным для многих.

## Отслеживать свежие выпуски в репозитории на GitHub

Вы можете "отслеживать" FastAPI на GitHub (кликните по кнопке "watch" наверху справа): <a href="https://github.com/tiangolo/fastapi" class="external-link" target="_blank">https://github.com/tiangolo/fastapi</a>. 👀

Там же Вы можете указать в настройках - "Releases only".

С такой настройкой Вы будете получать уведомления на вашу электронную почту каждый раз, когда появится новый релиз (новая версия) **FastAPI** с исправлениями ошибок и новыми возможностями.

## Связаться с автором

Можно связаться со <a href="https://tiangolo.com" class="external-link" target="_blank">мной (Себястьян Рамирез / `tiangolo`)</a>, автором FastAPI.

Вы можете:

* <a href="https://github.com/tiangolo" class="external-link" target="_blank">Подписаться на меня на **GitHub**</a>.
    * Посмотреть другие мои проекты с открытым кодом, которые могут быть полезны Вам.
    * Подписавшись на меня Вы сможете получать уведомления, что я создал новый проект с открытым кодом,.
* <a href="https://twitter.com/tiangolo" class="external-link" target="_blank">Подписаться на меня в **Twitter**</a> или в <a href="https://fosstodon.org/@tiangolo" class="external-link" target="_blank">Mastodon</a>.
    * Поделиться со мной, как Вы используете FastAPI (я обожаю читать про это).
    * Получать уведомления, когда я делаю объявления и представляю новые инструменты.
    * Вы также можете <a href="https://twitter.com/fastapi" class="external-link" target="_blank">подписаться на @fastapi в Twitter</a> (это отдельный аккаунт).
* <a href="https://www.linkedin.com/in/tiangolo/" class="external-link" target="_blank">Подписаться на меня в **Linkedin**</a>.
    * Получать уведомления, когда я делаю объявления и представляю новые инструменты (правда чаще всего я использую Twitter 🤷‍♂).
* Читать, что я пишу (или подписаться на меня) в <a href="https://dev.to/tiangolo" class="external-link" target="_blank">**Dev.to**</a> или в <a href="https://medium.com/@tiangolo" class="external-link" target="_blank">**Medium**</a>.
    * Читать другие идеи, статьи и читать об инструментах созданных мной.
    * Подпишитесь на меня, чтобы прочитать, когда я опубликую что-нибудь новое.

## Оставить сообщение в Twitter о **FastAPI**

<a href="https://twitter.com/compose/tweet?text=I'm loving @fastapi because... https://github.com/tiangolo/fastapi" class="external-link" target="_blank">Оставьте сообщение в Twitter о **FastAPI**</a> и позвольте мне и другим узнать - почему он Вам нравится. 🎉

Я люблю узнавать о том, как **FastAPI** используется, что Вам понравилось в нём, в каких проектах/компаниях Вы используете его и т.п.

## Оставить голос за FastAPI

* <a href="https://www.slant.co/options/34241/~fastapi-review" class="external-link" target="_blank">Голосуйте за **FastAPI** в Slant</a>.
* <a href="https://alternativeto.net/software/fastapi/" class="external-link" target="_blank">Голосуйте за **FastAPI** в AlternativeTo</a>.
* <a href="https://stackshare.io/pypi-fastapi" class="external-link" target="_blank">Расскажите, как Вы используете **FastAPI** на StackShare</a>.

## Помочь другим с их проблемами на GitHub

Вы можете посмотреть, какие <a href="https://github.com/tiangolo/fastapi/issues" class="external-link" target="_blank">проблемы</a> испытывают другие люди и попытаться помочь им. Чаще всего это вопросы, на которые, весьма вероятно, Вы уже знаете ответ. 🤓

Если Вы будете много помогать людям с решением их проблем, Вы можете стать официальным [Экспертом FastAPI](fastapi-people.md#experts){.internal-link target=_blank}. 🎉

Только помните, самое важное при этом - доброта. Столкнувшись с проблемой, люди расстраиваются и часто задают вопросы не лучшим образом, но постарайтесь быть максимально доброжелательным. 🤗

Идея сообщества **FastAPI** в том, чтобы быть добродушным и гостеприимными. Не допускайте издевательств или неуважительного поведения по отношению к другим. Мы должны заботиться друг о друге.

---

Как помочь другим с их проблемами:

### Понять вопрос

* Удостоверьтесь, что поняли **цель** и обстоятельства случая вопрошающего.

* Затем проверьте, что вопрос (в подавляющем большинстве - это вопросы) Вам **ясен**.

* Во многих случаях вопрос касается решения, которое пользователь придумал сам, но может быть и решение **получше**. Если Вы поймёте проблему и обстоятельства случая, то сможете предложить **альтернативное решение**.

* Ежели вопрос Вам непонятен, запросите больше **деталей**.

### Воспроизвести проблему

В большинстве случаев есть что-то связанное с **исходным кодом** вопрошающего.

И во многих случаях будет предоставлен только фрагмент этого кода, которого недостаточно для **воспроизведения проблемы**.

* Попросите предоставить <a href="https://stackoverflow.com/help/minimal-reproducible-example" class="external-link" target="_blank">минимальный воспроизводимый пример</a>, который можно **скопировать** и запустить локально дабы увидеть такую же ошибку, или поведение, или лучше понять обстоятельства случая.

* Если на Вас нахлынуло великодушие, то можете попытаться **создать похожий пример** самостоятельно, основываясь только на описании проблемы. Но имейте в виду, что это может занять много времени и, возможно, стоит сначала позадавать вопросы для прояснения проблемы.

### Предложить решение

* После того как Вы поняли вопрос, Вы можете дать **ответ**.

* Следует понять **основную проблему и обстоятельства случая**, потому что может быть решение лучше, чем то, которое пытались реализовать.

### Попросить закрыть проблему

Если Вам ответили, высоки шансы, что Вам удалось решить проблему, поздравляю, **Вы - герой**! 🦸

* В таком случае, если вопрос решён, попросите **закрыть проблему**.

## Отслеживать репозиторий на GitHub

Вы можете "отслеживать" FastAPI на GitHub (кликните по кнопке "watch" наверху справа): <a href="https://github.com/tiangolo/fastapi" class="external-link" target="_blank">https://github.com/tiangolo/fastapi</a>. 👀

Если Вы выберете "Watching" вместо "Releases only", то будете получать уведомления когда кто-либо попросит о помощи с решением его проблемы.

Тогда Вы можете попробовать решить эту проблему.

## Запросить помощь с решением проблемы

Вы можете <a href="https://github.com/tiangolo/fastapi/issues/new/choose" class="external-link" target="_blank">создать новый запрос с просьбой о помощи</a> в репозитории на GitHub, например:

* Задать **вопрос** или попросить помощи в решении **проблемы**.
* Предложить новое **улучшение**.

**Заметка**: Если Вы создаёте подобные запросы, то я попрошу Вас также оказывать аналогичную помощь другим. 😉

## Проверять пул-реквесты

Вы можете помочь мне проверять пул-реквесты других участников.

И повторюсь, постарайтесь быть доброжелательным. 🤗

---

О том, что нужно иметь в виду при проверке пул-реквестов:

### Понять проблему

* Во-первых, убедитесь, что **поняли проблему**, которую пул-реквест пытается решить. Для этого может потребоваться продолжительное обсуждение.

* Также есть вероятность, что пул-реквест не актуален, так как проблему можно решить **другим путём**. В таком случае Вы можете указать на этот факт.

### Не переживайте о стиле

* Не стоит слишком беспокоиться о таких вещах, как стиль сообщений в коммитах или количество коммитов. При слиянии пул-реквеста с основной веткой, я буду сжимать и настраивать всё вручную.

* Также не беспокойтесь о правилах стиля, для проверки сего есть автоматизированные инструменты.

И если всё же потребуется какой-то другой стиль, я попрошу Вас об этом напрямую или добавлю сам коммиты с необходимыми изменениями.

### Проверить код

* Проверьте и прочитайте код, посмотрите, какой он имеет смысл, **запустите его локально** и посмотрите, действительно ли он решает поставленную задачу.

* Затем, используя **комментарий**, сообщите, что Вы сделали проверку, тогда я буду знать, что Вы действительно проверили код.

!!! Информация
    К сожалению, я не могу так просто доверять пул-реквестам, у которых уже есть несколько одобрений.

    Бывали случаи, что пул-реквесты имели 3, 5 или больше одобрений, вероятно из-за привлекательного описания, но когда я проверял эти пул-реквесты, они оказывались сломаны, содержали ошибки или вовсе не решали проблему, которую, как они утверждали, должны были решить. 😅

    Потому это действительно важно - проверять и запускать код, и комментарием уведомлять меня, что Вы проделали эти действия. 🤓

* Если Вы считаете, что пул-реквест можно упростить, то можете попросить об этом, но не нужно быть слишком придирчивым, может быть много субъективных точек зрения (и у меня тоже будет своя 🙈), поэтому будет лучше, если Вы сосредоточитесь на фундаментальных вещах.

### Тестировать

* Помогите мне проверить, что у пул-реквеста есть **тесты**.

* Проверьте, что тесты **падали** до пул-реквеста. 🚨

* Затем проверьте, что  тесты **не валятся** после пул-реквеста. ✅

* Многие пул-реквесты не имеют тестов, Вы можете **напомнить** о необходимости добавления тестов или даже **предложить** какие-либо свои тесты. Это одна из тех вещей, которые отнимают много времени и Вы можете помочь с этим.

* Затем добавьте комментарий, что Вы испробовали в ходе проверки. Таким образом я буду знать, как Вы произвели проверку. 🤓

## Создать пул-реквест

Вы можете [сделать вклад](contributing.md){.internal-link target=_blank} в код фреймворка используя пул-реквесты, например:

* Исправить опечатку, которую Вы нашли в документации.
* Поделиться статьёй, видео или подкастом о FastAPI, которые Вы создали или нашли  <a href="https://github.com/tiangolo/fastapi/edit/master/docs/en/data/external_links.yml" class="external-link" target="_blank">изменив этот файл</a>.
    * Убедитесь, что Вы добавили свою ссылку в начало соответствующего раздела.
* Помочь с [переводом документации](contributing.md#translations){.internal-link target=_blank} на Ваш язык.
    * Вы также можете проверять переводы сделанные другими.
* Предложить новые разделы документации.
* Исправить существующуе проблемы/баги.
    * Убедитесь, что добавили тесты.
* Добавить новую возможность.
    * Убедитесь, что добавили тесты.
    * Убедитесь, что добавили документацию, если она необходима.

## Помочь поддерживать FastAPI

Помогите мне поддерживать **FastAPI**! 🤓

Предстоит ещё много работы и, по большей части, **ВЫ** можете её сделать.

Основные задачи, которые Вы можете выполнить прямо сейчас:

* [Помочь другим с их проблемами на GitHub](#help-others-with-issues-in-github){.internal-link target=_blank} (смотрите вышестоящую секцию).
* [Проверить пул-реквесты](#review-pull-requests){.internal-link target=_blank} (смотрите вышестоящую секцию).

Эти две задачи **отнимают больше всего времени**. Это основная работа по поддержке FastAPI.

Если Вы можете помочь мне с этим, **Вы помогаете поддерживать FastAPI**  и следить за тем, чтобы он продолжал **развиваться быстрее и лучше**. 🚀

## Подключиться к чату

Подключайтесь к  👥 <a href="https://discord.gg/VQjSZaeJmf" class="external-link" target="_blank"> чату в Discord</a> 👥 и общайтесь с другими участниками сообщества FastAPI.

!!! Подсказка
    Вопросы по проблемам с фреймворком лучше задавать в <a href="https://github.com/tiangolo/fastapi/issues/new/choose" class="external-link" target="_blank">GitHub issues</a>, так больше шансов, что Вы получите помощь от [Экспертов FastAPI](fastapi-people.md#experts){.internal-link target=_blank}.

    Используйте этот чат только для бесед на отвлечённые темы.

### Не использовать чаты для вопросов

Имейте в виду, что чаты позволяют больше "свободного общения", потому там легко задавать вопросы, которые слишком общие и на которые труднее ответить, так что Вы можете не получить нужные Вам ответы.

В разделе "проблемы" на GitHub, есть шаблон, который поможет Вам написать вопрос правильно, чтобы Вам было легче получить хороший ответ или даже решить проблему самостоятельно, прежде чем Вы зададите вопрос. В GitHub я могу быть уверен, что всегда отвечаю на всё, даже если это займет какое-то время. И я не могу сделать то же самое в чатах. 😅

Кроме того, общение в чатах не так легкодоступно для поиска, как в GitHub, потому вопросы и ответы могут потеряться среди другого общения. И только проблемы решаемые на GitHub учитываются в получении лычки [Эксперт FastAPI](fastapi-people.md#experts){.internal-link target=_blank}, так что весьма вероятно, что Вы получите больше внимания на GitHub.

С другой стороны, в чатах тысячи пользователей, а значит есть большие шансы в любое время найти там кого-то, с кем можно поговорить. 😄

## Спонсировать автора

Вы также можете оказать мне финансовую поддержку посредством <a href="https://github.com/sponsors/tiangolo" class="external-link" target="_blank">спонсорства через GitHub</a>.

Там можно просто купить мне кофе ☕️ в знак благодарности. 😄

А ещё Вы можете стать Серебряным или Золотым спонсором для FastAPI. 🏅🎉

## Спонсировать инструменты, на которых зиждется мощь FastAPI

Как Вы могли заметить в документации, FastAPI опирается на плечи титанов: Starlette и Pydantic.

Им тоже можно оказать спонсорскую поддержку:

* <a href="https://github.com/sponsors/samuelcolvin" class="external-link" target="_blank">Samuel Colvin (Pydantic)</a>
* <a href="https://github.com/sponsors/encode" class="external-link" target="_blank">Encode (Starlette, Uvicorn)</a>

---

Благодарствую! 🚀
