// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// automatically generated by the FlatBuffers compiler, do not modify
// swiftlint:disable all
// swiftformat:disable all

import FlatBuffers

public enum org_apache_arrow_flatbuf_SparseMatrixCompressedAxis: Int16, Enum, Verifiable {
  public typealias T = Int16
  public static var byteSize: Int { return MemoryLayout<Int16>.size }
  public var value: Int16 { return self.rawValue }
  case row = 0
  case column = 1

  public static var max: org_apache_arrow_flatbuf_SparseMatrixCompressedAxis { return .column }
  public static var min: org_apache_arrow_flatbuf_SparseMatrixCompressedAxis { return .row }
}


public enum org_apache_arrow_flatbuf_SparseTensorIndex: UInt8, UnionEnum {
  public typealias T = UInt8

  public init?(value: T) {
    self.init(rawValue: value)
  }

  public static var byteSize: Int { return MemoryLayout<UInt8>.size }
  public var value: UInt8 { return self.rawValue }
  case none_ = 0
  case sparsetensorindexcoo = 1
  case sparsematrixindexcsx = 2
  case sparsetensorindexcsf = 3

  public static var max: org_apache_arrow_flatbuf_SparseTensorIndex { return .sparsetensorindexcsf }
  public static var min: org_apache_arrow_flatbuf_SparseTensorIndex { return .none_ }
}


///  ----------------------------------------------------------------------
///  EXPERIMENTAL: Data structures for sparse tensors
///  Coordinate (COO) format of sparse tensor index.
/// 
///  COO's index list are represented as a NxM matrix,
///  where N is the number of non-zero values,
///  and M is the number of dimensions of a sparse tensor.
/// 
///  indicesBuffer stores the location and size of the data of this indices
///  matrix.  The value type and the stride of the indices matrix is
///  specified in indicesType and indicesStrides fields.
/// 
///  For example, let X be a 2x3x4x5 tensor, and it has the following
///  6 non-zero values:
///  ```text
///    X[0, 1, 2, 0] := 1
///    X[1, 1, 2, 3] := 2
///    X[0, 2, 1, 0] := 3
///    X[0, 1, 3, 0] := 4
///    X[0, 1, 2, 1] := 5
///    X[1, 2, 0, 4] := 6
///  ```
///  In COO format, the index matrix of X is the following 4x6 matrix:
///  ```text
///    [[0, 0, 0, 0, 1, 1],
///     [1, 1, 1, 2, 1, 2],
///     [2, 2, 3, 1, 2, 0],
///     [0, 1, 0, 0, 3, 4]]
///  ```
///  When isCanonical is true, the indices is sorted in lexicographical order
///  (row-major order), and it does not have duplicated entries.  Otherwise,
///  the indices may not be sorted, or may have duplicated entries.
public struct org_apache_arrow_flatbuf_SparseTensorIndexCOO: FlatBufferObject, Verifiable {

  static func validateVersion() { FlatBuffersVersion_23_1_4() }
  public var __buffer: ByteBuffer! { return _accessor.bb }
  private var _accessor: Table

  public static func getRootAsSparseTensorIndexCOO(bb: ByteBuffer) -> org_apache_arrow_flatbuf_SparseTensorIndexCOO { return org_apache_arrow_flatbuf_SparseTensorIndexCOO(Table(bb: bb, position: Int32(bb.read(def: UOffset.self, position: bb.reader)) + Int32(bb.reader))) }

  private init(_ t: Table) { _accessor = t }
  public init(_ bb: ByteBuffer, o: Int32) { _accessor = Table(bb: bb, position: o) }

  private enum VTOFFSET: VOffset {
    case indicesType = 4
    case indicesStrides = 6
    case indicesBuffer = 8
    case isCanonical = 10
    var v: Int32 { Int32(self.rawValue) }
    var p: VOffset { self.rawValue }
  }

  ///  The type of values in indicesBuffer
  public var indicesType: org_apache_arrow_flatbuf_Int! { let o = _accessor.offset(VTOFFSET.indicesType.v); return org_apache_arrow_flatbuf_Int(_accessor.bb, o: _accessor.indirect(o + _accessor.postion)) }
  ///  Non-negative byte offsets to advance one value cell along each dimension
  ///  If omitted, default to row-major order (C-like).
  public var hasIndicesStrides: Bool { let o = _accessor.offset(VTOFFSET.indicesStrides.v); return o == 0 ? false : true }
  public var indicesStridesCount: Int32 { let o = _accessor.offset(VTOFFSET.indicesStrides.v); return o == 0 ? 0 : _accessor.vector(count: o) }
  public func indicesStrides(at index: Int32) -> Int64 { let o = _accessor.offset(VTOFFSET.indicesStrides.v); return o == 0 ? 0 : _accessor.directRead(of: Int64.self, offset: _accessor.vector(at: o) + index * 8) }
  public var indicesStrides: [Int64] { return _accessor.getVector(at: VTOFFSET.indicesStrides.v) ?? [] }
  ///  The location and size of the indices matrix's data
  public var indicesBuffer: org_apache_arrow_flatbuf_Buffer! { let o = _accessor.offset(VTOFFSET.indicesBuffer.v); return _accessor.readBuffer(of: org_apache_arrow_flatbuf_Buffer.self, at: o) }
  public var mutableIndicesBuffer: org_apache_arrow_flatbuf_Buffer_Mutable! { let o = _accessor.offset(VTOFFSET.indicesBuffer.v); return org_apache_arrow_flatbuf_Buffer_Mutable(_accessor.bb, o: o + _accessor.postion) }
  ///  This flag is true if and only if the indices matrix is sorted in
  ///  row-major order, and does not have duplicated entries.
  ///  This sort order is the same as of Tensorflow's SparseTensor,
  ///  but it is inverse order of SciPy's canonical coo_matrix
  ///  (SciPy employs column-major order for its coo_matrix).
  public var isCanonical: Bool { let o = _accessor.offset(VTOFFSET.isCanonical.v); return o == 0 ? false : 0 != _accessor.readBuffer(of: Byte.self, at: o) }
  public static func startSparseTensorIndexCOO(_ fbb: inout FlatBufferBuilder) -> UOffset { fbb.startTable(with: 4) }
  public static func add(indicesType: Offset, _ fbb: inout FlatBufferBuilder) { fbb.add(offset: indicesType, at: VTOFFSET.indicesType.p) }
  public static func addVectorOf(indicesStrides: Offset, _ fbb: inout FlatBufferBuilder) { fbb.add(offset: indicesStrides, at: VTOFFSET.indicesStrides.p) }
  public static func add(indicesBuffer: org_apache_arrow_flatbuf_Buffer?, _ fbb: inout FlatBufferBuilder) { guard let indicesBuffer = indicesBuffer else { return }; fbb.create(struct: indicesBuffer, position: VTOFFSET.indicesBuffer.p) }
  public static func add(isCanonical: Bool, _ fbb: inout FlatBufferBuilder) { fbb.add(element: isCanonical, def: false,
   at: VTOFFSET.isCanonical.p) }
  public static func endSparseTensorIndexCOO(_ fbb: inout FlatBufferBuilder, start: UOffset) -> Offset { let end = Offset(offset: fbb.endTable(at: start)); fbb.require(table: end, fields: [4, 8]); return end }
  public static func createSparseTensorIndexCOO(
    _ fbb: inout FlatBufferBuilder,
    indicesTypeOffset indicesType: Offset,
    indicesStridesVectorOffset indicesStrides: Offset = Offset(),
    indicesBuffer: org_apache_arrow_flatbuf_Buffer,
    isCanonical: Bool = false
  ) -> Offset {
    let __start = org_apache_arrow_flatbuf_SparseTensorIndexCOO.startSparseTensorIndexCOO(&fbb)
    org_apache_arrow_flatbuf_SparseTensorIndexCOO.add(indicesType: indicesType, &fbb)
    org_apache_arrow_flatbuf_SparseTensorIndexCOO.addVectorOf(indicesStrides: indicesStrides, &fbb)
    org_apache_arrow_flatbuf_SparseTensorIndexCOO.add(indicesBuffer: indicesBuffer, &fbb)
    org_apache_arrow_flatbuf_SparseTensorIndexCOO.add(isCanonical: isCanonical, &fbb)
    return org_apache_arrow_flatbuf_SparseTensorIndexCOO.endSparseTensorIndexCOO(&fbb, start: __start)
  }

  public static func verify<T>(_ verifier: inout Verifier, at position: Int, of type: T.Type) throws where T: Verifiable {
    var _v = try verifier.visitTable(at: position)
    try _v.visit(field: VTOFFSET.indicesType.p, fieldName: "indicesType", required: true, type: ForwardOffset<org_apache_arrow_flatbuf_Int>.self)
    try _v.visit(field: VTOFFSET.indicesStrides.p, fieldName: "indicesStrides", required: false, type: ForwardOffset<Vector<Int64, Int64>>.self)
    try _v.visit(field: VTOFFSET.indicesBuffer.p, fieldName: "indicesBuffer", required: true, type: org_apache_arrow_flatbuf_Buffer.self)
    try _v.visit(field: VTOFFSET.isCanonical.p, fieldName: "isCanonical", required: false, type: Bool.self)
    _v.finish()
  }
}

///  Compressed Sparse format, that is matrix-specific.
public struct org_apache_arrow_flatbuf_SparseMatrixIndexCSX: FlatBufferObject, Verifiable {

  static func validateVersion() { FlatBuffersVersion_23_1_4() }
  public var __buffer: ByteBuffer! { return _accessor.bb }
  private var _accessor: Table

  public static func getRootAsSparseMatrixIndexCSX(bb: ByteBuffer) -> org_apache_arrow_flatbuf_SparseMatrixIndexCSX { return org_apache_arrow_flatbuf_SparseMatrixIndexCSX(Table(bb: bb, position: Int32(bb.read(def: UOffset.self, position: bb.reader)) + Int32(bb.reader))) }

  private init(_ t: Table) { _accessor = t }
  public init(_ bb: ByteBuffer, o: Int32) { _accessor = Table(bb: bb, position: o) }

  private enum VTOFFSET: VOffset {
    case compressedAxis = 4
    case indptrType = 6
    case indptrBuffer = 8
    case indicesType = 10
    case indicesBuffer = 12
    var v: Int32 { Int32(self.rawValue) }
    var p: VOffset { self.rawValue }
  }

  ///  Which axis, row or column, is compressed
  public var compressedAxis: org_apache_arrow_flatbuf_SparseMatrixCompressedAxis { let o = _accessor.offset(VTOFFSET.compressedAxis.v); return o == 0 ? .row : org_apache_arrow_flatbuf_SparseMatrixCompressedAxis(rawValue: _accessor.readBuffer(of: Int16.self, at: o)) ?? .row }
  ///  The type of values in indptrBuffer
  public var indptrType: org_apache_arrow_flatbuf_Int! { let o = _accessor.offset(VTOFFSET.indptrType.v); return org_apache_arrow_flatbuf_Int(_accessor.bb, o: _accessor.indirect(o + _accessor.postion)) }
  ///  indptrBuffer stores the location and size of indptr array that
  ///  represents the range of the rows.
  ///  The i-th row spans from `indptr[i]` to `indptr[i+1]` in the data.
  ///  The length of this array is 1 + (the number of rows), and the type
  ///  of index value is long.
  /// 
  ///  For example, let X be the following 6x4 matrix:
  ///  ```text
  ///    X := [[0, 1, 2, 0],
  ///          [0, 0, 3, 0],
  ///          [0, 4, 0, 5],
  ///          [0, 0, 0, 0],
  ///          [6, 0, 7, 8],
  ///          [0, 9, 0, 0]].
  ///  ```
  ///  The array of non-zero values in X is:
  ///  ```text
  ///    values(X) = [1, 2, 3, 4, 5, 6, 7, 8, 9].
  ///  ```
  ///  And the indptr of X is:
  ///  ```text
  ///    indptr(X) = [0, 2, 3, 5, 5, 8, 10].
  ///  ```
  public var indptrBuffer: org_apache_arrow_flatbuf_Buffer! { let o = _accessor.offset(VTOFFSET.indptrBuffer.v); return _accessor.readBuffer(of: org_apache_arrow_flatbuf_Buffer.self, at: o) }
  public var mutableIndptrBuffer: org_apache_arrow_flatbuf_Buffer_Mutable! { let o = _accessor.offset(VTOFFSET.indptrBuffer.v); return org_apache_arrow_flatbuf_Buffer_Mutable(_accessor.bb, o: o + _accessor.postion) }
  ///  The type of values in indicesBuffer
  public var indicesType: org_apache_arrow_flatbuf_Int! { let o = _accessor.offset(VTOFFSET.indicesType.v); return org_apache_arrow_flatbuf_Int(_accessor.bb, o: _accessor.indirect(o + _accessor.postion)) }
  ///  indicesBuffer stores the location and size of the array that
  ///  contains the column indices of the corresponding non-zero values.
  ///  The type of index value is long.
  /// 
  ///  For example, the indices of the above X is:
  ///  ```text
  ///    indices(X) = [1, 2, 2, 1, 3, 0, 2, 3, 1].
  ///  ```
  ///  Note that the indices are sorted in lexicographical order for each row.
  public var indicesBuffer: org_apache_arrow_flatbuf_Buffer! { let o = _accessor.offset(VTOFFSET.indicesBuffer.v); return _accessor.readBuffer(of: org_apache_arrow_flatbuf_Buffer.self, at: o) }
  public var mutableIndicesBuffer: org_apache_arrow_flatbuf_Buffer_Mutable! { let o = _accessor.offset(VTOFFSET.indicesBuffer.v); return org_apache_arrow_flatbuf_Buffer_Mutable(_accessor.bb, o: o + _accessor.postion) }
  public static func startSparseMatrixIndexCSX(_ fbb: inout FlatBufferBuilder) -> UOffset { fbb.startTable(with: 5) }
  public static func add(compressedAxis: org_apache_arrow_flatbuf_SparseMatrixCompressedAxis, _ fbb: inout FlatBufferBuilder) { fbb.add(element: compressedAxis.rawValue, def: 0, at: VTOFFSET.compressedAxis.p) }
  public static func add(indptrType: Offset, _ fbb: inout FlatBufferBuilder) { fbb.add(offset: indptrType, at: VTOFFSET.indptrType.p) }
  public static func add(indptrBuffer: org_apache_arrow_flatbuf_Buffer?, _ fbb: inout FlatBufferBuilder) { guard let indptrBuffer = indptrBuffer else { return }; fbb.create(struct: indptrBuffer, position: VTOFFSET.indptrBuffer.p) }
  public static func add(indicesType: Offset, _ fbb: inout FlatBufferBuilder) { fbb.add(offset: indicesType, at: VTOFFSET.indicesType.p) }
  public static func add(indicesBuffer: org_apache_arrow_flatbuf_Buffer?, _ fbb: inout FlatBufferBuilder) { guard let indicesBuffer = indicesBuffer else { return }; fbb.create(struct: indicesBuffer, position: VTOFFSET.indicesBuffer.p) }
  public static func endSparseMatrixIndexCSX(_ fbb: inout FlatBufferBuilder, start: UOffset) -> Offset { let end = Offset(offset: fbb.endTable(at: start)); fbb.require(table: end, fields: [6, 8, 10, 12]); return end }
  public static func createSparseMatrixIndexCSX(
    _ fbb: inout FlatBufferBuilder,
    compressedAxis: org_apache_arrow_flatbuf_SparseMatrixCompressedAxis = .row,
    indptrTypeOffset indptrType: Offset,
    indptrBuffer: org_apache_arrow_flatbuf_Buffer,
    indicesTypeOffset indicesType: Offset,
    indicesBuffer: org_apache_arrow_flatbuf_Buffer
  ) -> Offset {
    let __start = org_apache_arrow_flatbuf_SparseMatrixIndexCSX.startSparseMatrixIndexCSX(&fbb)
    org_apache_arrow_flatbuf_SparseMatrixIndexCSX.add(compressedAxis: compressedAxis, &fbb)
    org_apache_arrow_flatbuf_SparseMatrixIndexCSX.add(indptrType: indptrType, &fbb)
    org_apache_arrow_flatbuf_SparseMatrixIndexCSX.add(indptrBuffer: indptrBuffer, &fbb)
    org_apache_arrow_flatbuf_SparseMatrixIndexCSX.add(indicesType: indicesType, &fbb)
    org_apache_arrow_flatbuf_SparseMatrixIndexCSX.add(indicesBuffer: indicesBuffer, &fbb)
    return org_apache_arrow_flatbuf_SparseMatrixIndexCSX.endSparseMatrixIndexCSX(&fbb, start: __start)
  }

  public static func verify<T>(_ verifier: inout Verifier, at position: Int, of type: T.Type) throws where T: Verifiable {
    var _v = try verifier.visitTable(at: position)
    try _v.visit(field: VTOFFSET.compressedAxis.p, fieldName: "compressedAxis", required: false, type: org_apache_arrow_flatbuf_SparseMatrixCompressedAxis.self)
    try _v.visit(field: VTOFFSET.indptrType.p, fieldName: "indptrType", required: true, type: ForwardOffset<org_apache_arrow_flatbuf_Int>.self)
    try _v.visit(field: VTOFFSET.indptrBuffer.p, fieldName: "indptrBuffer", required: true, type: org_apache_arrow_flatbuf_Buffer.self)
    try _v.visit(field: VTOFFSET.indicesType.p, fieldName: "indicesType", required: true, type: ForwardOffset<org_apache_arrow_flatbuf_Int>.self)
    try _v.visit(field: VTOFFSET.indicesBuffer.p, fieldName: "indicesBuffer", required: true, type: org_apache_arrow_flatbuf_Buffer.self)
    _v.finish()
  }
}

///  Compressed Sparse Fiber (CSF) sparse tensor index.
public struct org_apache_arrow_flatbuf_SparseTensorIndexCSF: FlatBufferObject, Verifiable {

  static func validateVersion() { FlatBuffersVersion_23_1_4() }
  public var __buffer: ByteBuffer! { return _accessor.bb }
  private var _accessor: Table

  public static func getRootAsSparseTensorIndexCSF(bb: ByteBuffer) -> org_apache_arrow_flatbuf_SparseTensorIndexCSF { return org_apache_arrow_flatbuf_SparseTensorIndexCSF(Table(bb: bb, position: Int32(bb.read(def: UOffset.self, position: bb.reader)) + Int32(bb.reader))) }

  private init(_ t: Table) { _accessor = t }
  public init(_ bb: ByteBuffer, o: Int32) { _accessor = Table(bb: bb, position: o) }

  private enum VTOFFSET: VOffset {
    case indptrType = 4
    case indptrBuffers = 6
    case indicesType = 8
    case indicesBuffers = 10
    case axisOrder = 12
    var v: Int32 { Int32(self.rawValue) }
    var p: VOffset { self.rawValue }
  }

  ///  CSF is a generalization of compressed sparse row (CSR) index.
  ///  See [smith2017knl](http://shaden.io/pub-files/smith2017knl.pdf)
  /// 
  ///  CSF index recursively compresses each dimension of a tensor into a set
  ///  of prefix trees. Each path from a root to leaf forms one tensor
  ///  non-zero index. CSF is implemented with two arrays of buffers and one
  ///  arrays of integers.
  /// 
  ///  For example, let X be a 2x3x4x5 tensor and let it have the following
  ///  8 non-zero values:
  ///  ```text
  ///    X[0, 0, 0, 1] := 1
  ///    X[0, 0, 0, 2] := 2
  ///    X[0, 1, 0, 0] := 3
  ///    X[0, 1, 0, 2] := 4
  ///    X[0, 1, 1, 0] := 5
  ///    X[1, 1, 1, 0] := 6
  ///    X[1, 1, 1, 1] := 7
  ///    X[1, 1, 1, 2] := 8
  ///  ```
  ///  As a prefix tree this would be represented as:
  ///  ```text
  ///          0          1
  ///         / \         |
  ///        0   1        1
  ///       /   / \       |
  ///      0   0   1      1
  ///     /|  /|   |    /| |
  ///    1 2 0 2   0   0 1 2
  ///  ```
  ///  The type of values in indptrBuffers
  public var indptrType: org_apache_arrow_flatbuf_Int! { let o = _accessor.offset(VTOFFSET.indptrType.v); return org_apache_arrow_flatbuf_Int(_accessor.bb, o: _accessor.indirect(o + _accessor.postion)) }
  ///  indptrBuffers stores the sparsity structure.
  ///  Each two consecutive dimensions in a tensor correspond to a buffer in
  ///  indptrBuffers. A pair of consecutive values at `indptrBuffers[dim][i]`
  ///  and `indptrBuffers[dim][i + 1]` signify a range of nodes in
  ///  `indicesBuffers[dim + 1]` who are children of `indicesBuffers[dim][i]` node.
  /// 
  ///  For example, the indptrBuffers for the above X is:
  ///  ```text
  ///    indptrBuffer(X) = [
  ///                        [0, 2, 3],
  ///                        [0, 1, 3, 4],
  ///                        [0, 2, 4, 5, 8]
  ///                      ].
  ///  ```
  public var hasIndptrBuffers: Bool { let o = _accessor.offset(VTOFFSET.indptrBuffers.v); return o == 0 ? false : true }
  public var indptrBuffersCount: Int32 { let o = _accessor.offset(VTOFFSET.indptrBuffers.v); return o == 0 ? 0 : _accessor.vector(count: o) }
  public func indptrBuffers(at index: Int32) -> org_apache_arrow_flatbuf_Buffer? { let o = _accessor.offset(VTOFFSET.indptrBuffers.v); return o == 0 ? nil : _accessor.directRead(of: org_apache_arrow_flatbuf_Buffer.self, offset: _accessor.vector(at: o) + index * 16) }
  public func mutableIndptrBuffers(at index: Int32) -> org_apache_arrow_flatbuf_Buffer_Mutable? { let o = _accessor.offset(VTOFFSET.indptrBuffers.v); return o == 0 ? nil : org_apache_arrow_flatbuf_Buffer_Mutable(_accessor.bb, o: _accessor.vector(at: o) + index * 16) }
  ///  The type of values in indicesBuffers
  public var indicesType: org_apache_arrow_flatbuf_Int! { let o = _accessor.offset(VTOFFSET.indicesType.v); return org_apache_arrow_flatbuf_Int(_accessor.bb, o: _accessor.indirect(o + _accessor.postion)) }
  ///  indicesBuffers stores values of nodes.
  ///  Each tensor dimension corresponds to a buffer in indicesBuffers.
  ///  For example, the indicesBuffers for the above X is:
  ///  ```text
  ///    indicesBuffer(X) = [
  ///                         [0, 1],
  ///                         [0, 1, 1],
  ///                         [0, 0, 1, 1],
  ///                         [1, 2, 0, 2, 0, 0, 1, 2]
  ///                       ].
  ///  ```
  public var hasIndicesBuffers: Bool { let o = _accessor.offset(VTOFFSET.indicesBuffers.v); return o == 0 ? false : true }
  public var indicesBuffersCount: Int32 { let o = _accessor.offset(VTOFFSET.indicesBuffers.v); return o == 0 ? 0 : _accessor.vector(count: o) }
  public func indicesBuffers(at index: Int32) -> org_apache_arrow_flatbuf_Buffer? { let o = _accessor.offset(VTOFFSET.indicesBuffers.v); return o == 0 ? nil : _accessor.directRead(of: org_apache_arrow_flatbuf_Buffer.self, offset: _accessor.vector(at: o) + index * 16) }
  public func mutableIndicesBuffers(at index: Int32) -> org_apache_arrow_flatbuf_Buffer_Mutable? { let o = _accessor.offset(VTOFFSET.indicesBuffers.v); return o == 0 ? nil : org_apache_arrow_flatbuf_Buffer_Mutable(_accessor.bb, o: _accessor.vector(at: o) + index * 16) }
  ///  axisOrder stores the sequence in which dimensions were traversed to
  ///  produce the prefix tree.
  ///  For example, the axisOrder for the above X is:
  ///  ```text
  ///    axisOrder(X) = [0, 1, 2, 3].
  ///  ```
  public var hasAxisOrder: Bool { let o = _accessor.offset(VTOFFSET.axisOrder.v); return o == 0 ? false : true }
  public var axisOrderCount: Int32 { let o = _accessor.offset(VTOFFSET.axisOrder.v); return o == 0 ? 0 : _accessor.vector(count: o) }
  public func axisOrder(at index: Int32) -> Int32 { let o = _accessor.offset(VTOFFSET.axisOrder.v); return o == 0 ? 0 : _accessor.directRead(of: Int32.self, offset: _accessor.vector(at: o) + index * 4) }
  public var axisOrder: [Int32] { return _accessor.getVector(at: VTOFFSET.axisOrder.v) ?? [] }
  public static func startSparseTensorIndexCSF(_ fbb: inout FlatBufferBuilder) -> UOffset { fbb.startTable(with: 5) }
  public static func add(indptrType: Offset, _ fbb: inout FlatBufferBuilder) { fbb.add(offset: indptrType, at: VTOFFSET.indptrType.p) }
  public static func addVectorOf(indptrBuffers: Offset, _ fbb: inout FlatBufferBuilder) { fbb.add(offset: indptrBuffers, at: VTOFFSET.indptrBuffers.p) }
  public static func startVectorOfIndptrBuffers(_ size: Int, in builder: inout FlatBufferBuilder) {
    builder.startVector(size * MemoryLayout<org_apache_arrow_flatbuf_Buffer>.size, elementSize: MemoryLayout<org_apache_arrow_flatbuf_Buffer>.alignment)
  }
  public static func add(indicesType: Offset, _ fbb: inout FlatBufferBuilder) { fbb.add(offset: indicesType, at: VTOFFSET.indicesType.p) }
  public static func addVectorOf(indicesBuffers: Offset, _ fbb: inout FlatBufferBuilder) { fbb.add(offset: indicesBuffers, at: VTOFFSET.indicesBuffers.p) }
  public static func startVectorOfIndicesBuffers(_ size: Int, in builder: inout FlatBufferBuilder) {
    builder.startVector(size * MemoryLayout<org_apache_arrow_flatbuf_Buffer>.size, elementSize: MemoryLayout<org_apache_arrow_flatbuf_Buffer>.alignment)
  }
  public static func addVectorOf(axisOrder: Offset, _ fbb: inout FlatBufferBuilder) { fbb.add(offset: axisOrder, at: VTOFFSET.axisOrder.p) }
  public static func endSparseTensorIndexCSF(_ fbb: inout FlatBufferBuilder, start: UOffset) -> Offset { let end = Offset(offset: fbb.endTable(at: start)); fbb.require(table: end, fields: [4, 6, 8, 10, 12]); return end }
  public static func createSparseTensorIndexCSF(
    _ fbb: inout FlatBufferBuilder,
    indptrTypeOffset indptrType: Offset,
    indptrBuffersVectorOffset indptrBuffers: Offset,
    indicesTypeOffset indicesType: Offset,
    indicesBuffersVectorOffset indicesBuffers: Offset,
    axisOrderVectorOffset axisOrder: Offset
  ) -> Offset {
    let __start = org_apache_arrow_flatbuf_SparseTensorIndexCSF.startSparseTensorIndexCSF(&fbb)
    org_apache_arrow_flatbuf_SparseTensorIndexCSF.add(indptrType: indptrType, &fbb)
    org_apache_arrow_flatbuf_SparseTensorIndexCSF.addVectorOf(indptrBuffers: indptrBuffers, &fbb)
    org_apache_arrow_flatbuf_SparseTensorIndexCSF.add(indicesType: indicesType, &fbb)
    org_apache_arrow_flatbuf_SparseTensorIndexCSF.addVectorOf(indicesBuffers: indicesBuffers, &fbb)
    org_apache_arrow_flatbuf_SparseTensorIndexCSF.addVectorOf(axisOrder: axisOrder, &fbb)
    return org_apache_arrow_flatbuf_SparseTensorIndexCSF.endSparseTensorIndexCSF(&fbb, start: __start)
  }

  public static func verify<T>(_ verifier: inout Verifier, at position: Int, of type: T.Type) throws where T: Verifiable {
    var _v = try verifier.visitTable(at: position)
    try _v.visit(field: VTOFFSET.indptrType.p, fieldName: "indptrType", required: true, type: ForwardOffset<org_apache_arrow_flatbuf_Int>.self)
    try _v.visit(field: VTOFFSET.indptrBuffers.p, fieldName: "indptrBuffers", required: true, type: ForwardOffset<Vector<org_apache_arrow_flatbuf_Buffer, org_apache_arrow_flatbuf_Buffer>>.self)
    try _v.visit(field: VTOFFSET.indicesType.p, fieldName: "indicesType", required: true, type: ForwardOffset<org_apache_arrow_flatbuf_Int>.self)
    try _v.visit(field: VTOFFSET.indicesBuffers.p, fieldName: "indicesBuffers", required: true, type: ForwardOffset<Vector<org_apache_arrow_flatbuf_Buffer, org_apache_arrow_flatbuf_Buffer>>.self)
    try _v.visit(field: VTOFFSET.axisOrder.p, fieldName: "axisOrder", required: true, type: ForwardOffset<Vector<Int32, Int32>>.self)
    _v.finish()
  }
}

public struct org_apache_arrow_flatbuf_SparseTensor: FlatBufferObject, Verifiable {

  static func validateVersion() { FlatBuffersVersion_23_1_4() }
  public var __buffer: ByteBuffer! { return _accessor.bb }
  private var _accessor: Table

  public static func getRootAsSparseTensor(bb: ByteBuffer) -> org_apache_arrow_flatbuf_SparseTensor { return org_apache_arrow_flatbuf_SparseTensor(Table(bb: bb, position: Int32(bb.read(def: UOffset.self, position: bb.reader)) + Int32(bb.reader))) }

  private init(_ t: Table) { _accessor = t }
  public init(_ bb: ByteBuffer, o: Int32) { _accessor = Table(bb: bb, position: o) }

  private enum VTOFFSET: VOffset {
    case typeType = 4
    case type = 6
    case shape = 8
    case nonZeroLength = 10
    case sparseIndexType = 12
    case sparseIndex = 14
    case data = 16
    var v: Int32 { Int32(self.rawValue) }
    var p: VOffset { self.rawValue }
  }

  public var typeType: org_apache_arrow_flatbuf_Type_ { let o = _accessor.offset(VTOFFSET.typeType.v); return o == 0 ? .none_ : org_apache_arrow_flatbuf_Type_(rawValue: _accessor.readBuffer(of: UInt8.self, at: o)) ?? .none_ }
  ///  The type of data contained in a value cell.
  ///  Currently only fixed-width value types are supported,
  ///  no strings or nested types.
  public func type<T: FlatbuffersInitializable>(type: T.Type) -> T! { let o = _accessor.offset(VTOFFSET.type.v); return _accessor.union(o) }
  ///  The dimensions of the tensor, optionally named.
  public var hasShape: Bool { let o = _accessor.offset(VTOFFSET.shape.v); return o == 0 ? false : true }
  public var shapeCount: Int32 { let o = _accessor.offset(VTOFFSET.shape.v); return o == 0 ? 0 : _accessor.vector(count: o) }
  public func shape(at index: Int32) -> org_apache_arrow_flatbuf_TensorDim? { let o = _accessor.offset(VTOFFSET.shape.v); return o == 0 ? nil : org_apache_arrow_flatbuf_TensorDim(_accessor.bb, o: _accessor.indirect(_accessor.vector(at: o) + index * 4)) }
  ///  The number of non-zero values in a sparse tensor.
  public var nonZeroLength: Int64 { let o = _accessor.offset(VTOFFSET.nonZeroLength.v); return o == 0 ? 0 : _accessor.readBuffer(of: Int64.self, at: o) }
  public var sparseIndexType: org_apache_arrow_flatbuf_SparseTensorIndex { let o = _accessor.offset(VTOFFSET.sparseIndexType.v); return o == 0 ? .none_ : org_apache_arrow_flatbuf_SparseTensorIndex(rawValue: _accessor.readBuffer(of: UInt8.self, at: o)) ?? .none_ }
  ///  Sparse tensor index
  public func sparseIndex<T: FlatbuffersInitializable>(type: T.Type) -> T! { let o = _accessor.offset(VTOFFSET.sparseIndex.v); return _accessor.union(o) }
  ///  The location and size of the tensor's data
  public var data: org_apache_arrow_flatbuf_Buffer! { let o = _accessor.offset(VTOFFSET.data.v); return _accessor.readBuffer(of: org_apache_arrow_flatbuf_Buffer.self, at: o) }
  public var mutableData: org_apache_arrow_flatbuf_Buffer_Mutable! { let o = _accessor.offset(VTOFFSET.data.v); return org_apache_arrow_flatbuf_Buffer_Mutable(_accessor.bb, o: o + _accessor.postion) }
  public static func startSparseTensor(_ fbb: inout FlatBufferBuilder) -> UOffset { fbb.startTable(with: 7) }
  public static func add(typeType: org_apache_arrow_flatbuf_Type_, _ fbb: inout FlatBufferBuilder) { fbb.add(element: typeType.rawValue, def: 0, at: VTOFFSET.typeType.p) }
  public static func add(type: Offset, _ fbb: inout FlatBufferBuilder) { fbb.add(offset: type, at: VTOFFSET.type.p) }
  public static func addVectorOf(shape: Offset, _ fbb: inout FlatBufferBuilder) { fbb.add(offset: shape, at: VTOFFSET.shape.p) }
  public static func add(nonZeroLength: Int64, _ fbb: inout FlatBufferBuilder) { fbb.add(element: nonZeroLength, def: 0, at: VTOFFSET.nonZeroLength.p) }
  public static func add(sparseIndexType: org_apache_arrow_flatbuf_SparseTensorIndex, _ fbb: inout FlatBufferBuilder) { fbb.add(element: sparseIndexType.rawValue, def: 0, at: VTOFFSET.sparseIndexType.p) }
  public static func add(sparseIndex: Offset, _ fbb: inout FlatBufferBuilder) { fbb.add(offset: sparseIndex, at: VTOFFSET.sparseIndex.p) }
  public static func add(data: org_apache_arrow_flatbuf_Buffer?, _ fbb: inout FlatBufferBuilder) { guard let data = data else { return }; fbb.create(struct: data, position: VTOFFSET.data.p) }
  public static func endSparseTensor(_ fbb: inout FlatBufferBuilder, start: UOffset) -> Offset { let end = Offset(offset: fbb.endTable(at: start)); fbb.require(table: end, fields: [6, 8, 14, 16]); return end }
  public static func createSparseTensor(
    _ fbb: inout FlatBufferBuilder,
    typeType: org_apache_arrow_flatbuf_Type_ = .none_,
    typeOffset type: Offset,
    shapeVectorOffset shape: Offset,
    nonZeroLength: Int64 = 0,
    sparseIndexType: org_apache_arrow_flatbuf_SparseTensorIndex = .none_,
    sparseIndexOffset sparseIndex: Offset,
    data: org_apache_arrow_flatbuf_Buffer
  ) -> Offset {
    let __start = org_apache_arrow_flatbuf_SparseTensor.startSparseTensor(&fbb)
    org_apache_arrow_flatbuf_SparseTensor.add(typeType: typeType, &fbb)
    org_apache_arrow_flatbuf_SparseTensor.add(type: type, &fbb)
    org_apache_arrow_flatbuf_SparseTensor.addVectorOf(shape: shape, &fbb)
    org_apache_arrow_flatbuf_SparseTensor.add(nonZeroLength: nonZeroLength, &fbb)
    org_apache_arrow_flatbuf_SparseTensor.add(sparseIndexType: sparseIndexType, &fbb)
    org_apache_arrow_flatbuf_SparseTensor.add(sparseIndex: sparseIndex, &fbb)
    org_apache_arrow_flatbuf_SparseTensor.add(data: data, &fbb)
    return org_apache_arrow_flatbuf_SparseTensor.endSparseTensor(&fbb, start: __start)
  }

  public static func verify<T>(_ verifier: inout Verifier, at position: Int, of type: T.Type) throws where T: Verifiable {
    var _v = try verifier.visitTable(at: position)
    try _v.visit(unionKey: VTOFFSET.typeType.p, unionField: VTOFFSET.type.p, unionKeyName: "typeType", fieldName: "type", required: true, completion: { (verifier, key: org_apache_arrow_flatbuf_Type_, pos) in
      switch key {
      case .none_:
        break // NOTE - SWIFT doesnt support none
      case .null:
        try ForwardOffset<org_apache_arrow_flatbuf_Null>.verify(&verifier, at: pos, of: org_apache_arrow_flatbuf_Null.self)
      case .int:
        try ForwardOffset<org_apache_arrow_flatbuf_Int>.verify(&verifier, at: pos, of: org_apache_arrow_flatbuf_Int.self)
      case .floatingpoint:
        try ForwardOffset<org_apache_arrow_flatbuf_FloatingPoint>.verify(&verifier, at: pos, of: org_apache_arrow_flatbuf_FloatingPoint.self)
      case .binary:
        try ForwardOffset<org_apache_arrow_flatbuf_Binary>.verify(&verifier, at: pos, of: org_apache_arrow_flatbuf_Binary.self)
      case .utf8:
        try ForwardOffset<org_apache_arrow_flatbuf_Utf8>.verify(&verifier, at: pos, of: org_apache_arrow_flatbuf_Utf8.self)
      case .bool:
        try ForwardOffset<org_apache_arrow_flatbuf_Bool>.verify(&verifier, at: pos, of: org_apache_arrow_flatbuf_Bool.self)
      case .decimal:
        try ForwardOffset<org_apache_arrow_flatbuf_Decimal>.verify(&verifier, at: pos, of: org_apache_arrow_flatbuf_Decimal.self)
      case .date:
        try ForwardOffset<org_apache_arrow_flatbuf_Date>.verify(&verifier, at: pos, of: org_apache_arrow_flatbuf_Date.self)
      case .time:
        try ForwardOffset<org_apache_arrow_flatbuf_Time>.verify(&verifier, at: pos, of: org_apache_arrow_flatbuf_Time.self)
      case .timestamp:
        try ForwardOffset<org_apache_arrow_flatbuf_Timestamp>.verify(&verifier, at: pos, of: org_apache_arrow_flatbuf_Timestamp.self)
      case .interval:
        try ForwardOffset<org_apache_arrow_flatbuf_Interval>.verify(&verifier, at: pos, of: org_apache_arrow_flatbuf_Interval.self)
      case .list:
        try ForwardOffset<org_apache_arrow_flatbuf_List>.verify(&verifier, at: pos, of: org_apache_arrow_flatbuf_List.self)
      case .struct_:
        try ForwardOffset<org_apache_arrow_flatbuf_Struct_>.verify(&verifier, at: pos, of: org_apache_arrow_flatbuf_Struct_.self)
      case .union:
        try ForwardOffset<org_apache_arrow_flatbuf_Union>.verify(&verifier, at: pos, of: org_apache_arrow_flatbuf_Union.self)
      case .fixedsizebinary:
        try ForwardOffset<org_apache_arrow_flatbuf_FixedSizeBinary>.verify(&verifier, at: pos, of: org_apache_arrow_flatbuf_FixedSizeBinary.self)
      case .fixedsizelist:
        try ForwardOffset<org_apache_arrow_flatbuf_FixedSizeList>.verify(&verifier, at: pos, of: org_apache_arrow_flatbuf_FixedSizeList.self)
      case .map:
        try ForwardOffset<org_apache_arrow_flatbuf_Map>.verify(&verifier, at: pos, of: org_apache_arrow_flatbuf_Map.self)
      case .duration:
        try ForwardOffset<org_apache_arrow_flatbuf_Duration>.verify(&verifier, at: pos, of: org_apache_arrow_flatbuf_Duration.self)
      case .largebinary:
        try ForwardOffset<org_apache_arrow_flatbuf_LargeBinary>.verify(&verifier, at: pos, of: org_apache_arrow_flatbuf_LargeBinary.self)
      case .largeutf8:
        try ForwardOffset<org_apache_arrow_flatbuf_LargeUtf8>.verify(&verifier, at: pos, of: org_apache_arrow_flatbuf_LargeUtf8.self)
      case .largelist:
        try ForwardOffset<org_apache_arrow_flatbuf_LargeList>.verify(&verifier, at: pos, of: org_apache_arrow_flatbuf_LargeList.self)
      case .runendencoded:
        try ForwardOffset<org_apache_arrow_flatbuf_RunEndEncoded>.verify(&verifier, at: pos, of: org_apache_arrow_flatbuf_RunEndEncoded.self)
      }
    })
    try _v.visit(field: VTOFFSET.shape.p, fieldName: "shape", required: true, type: ForwardOffset<Vector<ForwardOffset<org_apache_arrow_flatbuf_TensorDim>, org_apache_arrow_flatbuf_TensorDim>>.self)
    try _v.visit(field: VTOFFSET.nonZeroLength.p, fieldName: "nonZeroLength", required: false, type: Int64.self)
    try _v.visit(unionKey: VTOFFSET.sparseIndexType.p, unionField: VTOFFSET.sparseIndex.p, unionKeyName: "sparseIndexType", fieldName: "sparseIndex", required: true, completion: { (verifier, key: org_apache_arrow_flatbuf_SparseTensorIndex, pos) in
      switch key {
      case .none_:
        break // NOTE - SWIFT doesnt support none
      case .sparsetensorindexcoo:
        try ForwardOffset<org_apache_arrow_flatbuf_SparseTensorIndexCOO>.verify(&verifier, at: pos, of: org_apache_arrow_flatbuf_SparseTensorIndexCOO.self)
      case .sparsematrixindexcsx:
        try ForwardOffset<org_apache_arrow_flatbuf_SparseMatrixIndexCSX>.verify(&verifier, at: pos, of: org_apache_arrow_flatbuf_SparseMatrixIndexCSX.self)
      case .sparsetensorindexcsf:
        try ForwardOffset<org_apache_arrow_flatbuf_SparseTensorIndexCSF>.verify(&verifier, at: pos, of: org_apache_arrow_flatbuf_SparseTensorIndexCSF.self)
      }
    })
    try _v.visit(field: VTOFFSET.data.p, fieldName: "data", required: true, type: org_apache_arrow_flatbuf_Buffer.self)
    _v.finish()
  }
}

