% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table.R
\name{arrow_table}
\alias{arrow_table}
\title{Create an Arrow Table}
\usage{
arrow_table(..., schema = NULL)
}
\arguments{
\item{...}{A \code{data.frame} or a named set of Arrays or vectors. If given a
mixture of data.frames and named vectors, the inputs will be autospliced together
(see examples). Alternatively, you can provide a single Arrow IPC
\code{InputStream}, \code{Message}, \code{Buffer}, or R \code{raw} object containing a \code{Buffer}.}

\item{schema}{a \link{Schema}, or \code{NULL} (the default) to infer the schema from
the data in \code{...}. When providing an Arrow IPC buffer, \code{schema} is required.}
}
\description{
Create an Arrow Table
}
\examples{
tbl <- arrow_table(name = rownames(mtcars), mtcars)
dim(tbl)
dim(head(tbl))
names(tbl)
tbl$mpg
tbl[["cyl"]]
as.data.frame(tbl[4:8, c("gear", "hp", "wt")])
}
\seealso{
\link{Table}
}
