import importlib
from types import ModuleType

import pytest
from sqlmodel import create_engine

from ...conftest import PrintMock, needs_py310


@pytest.fixture(
    name="mod",
    params=[
        pytest.param("tutorial003_py39"),
        pytest.param("tutorial003_py310", marks=needs_py310),
    ],
)
def get_module(request: pytest.FixtureRequest) -> ModuleType:
    mod = importlib.import_module(f"docs_src.tutorial.where.{request.param}")
    mod.sqlite_url = "sqlite://"
    mod.engine = create_engine(mod.sqlite_url)
    return mod


def test_tutorial(print_mock: PrintMock, mod: ModuleType):
    mod.main()

    expected_calls = [
        [{"id": 6, "name": "Dr. Weird", "secret_name": "Steve Weird", "age": 36}],
        [{"id": 3, "name": "Rusty-Man", "secret_name": "Tommy Sharp", "age": 48}],
        [
            {
                "id": 7,
                "name": "Captain North America",
                "secret_name": "Esteban Rogelios",
                "age": 93,
            }
        ],
    ]
    calls = print_mock.calls
    for call in expected_calls:
        assert call in calls, "This expected item should be in the list"
        # Now that this item was checked, remove it from the list
        calls.pop(calls.index(call))
    assert len(calls) == 0, "The list should only have the expected items"
