
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "rnnoise_data.h"


#ifndef USE_WEIGHTS_FILE

#define WEIGHTS_conv1_weights_float_DEFINED
#define WEIGHTS_conv1_weights_float_TYPE WEIGHT_TYPE_float
static const float conv1_weights_float[24960] = {
    0.06526219099760056, 0.02702118083834648, -0.008111446164548397, -0.011081395670771599, -0.015120693482458591, 0.08287966251373291, 0.002029698109254241, 0.004506699740886688,
    -0.060060568153858185, -0.009777453728020191, 0.03926355764269829, 0.0322529636323452, -0.029918665066361427, 0.01026501227170229, -0.007168326992541552, -0.009934849105775356,
    -0.06733239442110062, 0.01720660924911499, -0.005776511039584875, -0.022854240611195564, 0.02561025507748127, 0.008629871532320976, 0.15009047091007233, -0.15936961770057678,
    0.03556709736585617, -0.01835417002439499, 0.04623595252633095, -0.008341367356479168, -0.006820769514888525, -0.04151718690991402, -0.09561210870742798, -0.041254326701164246,
    -0.012727652676403522, -0.005099799484014511, -0.018561862409114838, -0.000879080907907337, 0.0029339927714318037, 0.14488518238067627, 0.04636368528008461, 0.013861625455319881,
    -0.04339374229311943, -3.97173389501404e-05, -0.02693171799182892, -0.0019979074131697416, -0.023343592882156372, 0.03898384049534798, -0.02241535671055317, 0.027274852618575096,
    -0.14218199253082275, 0.002049614442512393, -0.029794173315167427, 0.0051327841356396675, 0.09823697805404663, 0.026636775583028793, -0.00807929877191782, -0.009807443246245384,
    -0.006922957021743059, -0.05144019424915314, 0.026424169540405273, -0.005063458811491728, 0.023713629692792892, 0.01465026754885912, 0.11085853725671768, -0.042436011135578156,
    0.04030296206474304, 0.01988839916884899, 0.028382111340761185, 0.04373958706855774, 0.012227284722030163, -0.0341188944876194, -0.07128880172967911, -0.025957457721233368,
    -0.014026949182152748, 0.04689619317650795, 0.04401915520429611, -0.004312883596867323, -0.12555910646915436, -0.13483980298042297, 0.03892827406525612, -0.12883664667606354,
    0.08175982534885406, -0.06339336186647415, 0.01637948304414749, 0.08987613022327423, 0.04566674679517746, 0.02713415026664734, 0.03229557350277901, -0.017621705308556557,
    -0.019512226805090904, 0.0385468564927578, 0.04313219338655472, -0.031245995312929153, 0.016961002722382545, 0.008306080475449562, 0.045008618384599686, -0.04536009207367897,
    0.0008388736168853939, 0.02066131681203842, -0.07768937200307846, -0.02306126058101654, 0.02007981948554516, -0.030399054288864136, -0.0014036803040653467, -0.02405906468629837,
    -0.02948862500488758, 0.04524243250489235, -0.07177724689245224, 0.034898869693279266, -0.03838556259870529, 0.0576724074780941, -0.0880269855260849, -0.08806613832712173,
    -0.013296344317495823, 0.04959532618522644, 0.03751600161194801, -0.05633506923913956, -0.01928607001900673, 0.017498312518000603, -0.0054725524969398975, -0.001613143365830183,
    -0.006752923596650362, -0.016122395172715187, 0.0359351672232151, 0.026024436578154564, -0.021070750430226326, 0.001061504939571023, 0.019477659836411476, -0.041859809309244156,
    0.004951484501361847, -0.0761776715517044, 0.017391372472047806, -0.026537511497735977, 0.046913765370845795, -0.02538525126874447, -0.00341888889670372, 0.036907535046339035,
    0.006429579108953476, -0.0030749975703656673, -0.010632386431097984, -0.0706666111946106, -0.050984784960746765, -0.017979368567466736, -0.06812922656536102, -0.049703020602464676,
    0.023001516237854958, -0.05121510475873947, 0.01788102276623249, 0.0690302699804306, 0.07240768522024155, 0.060985200107097626, 0.1405392736196518, -0.1065979078412056,
    -0.07650541514158249, -0.012143917381763458, 0.053634170442819595, -0.0138534652069211, -0.004157820250838995, 0.044413235038518906, -0.13688969612121582, 0.020477963611483574,
    -0.05615932121872902, -0.074203260242939, -0.013452376239001751, 0.025403058156371117, -0.06539437919855118, 0.043350547552108765, -0.014091338962316513, 0.031995732337236404,
    -0.020078333094716072, 0.009056581184267998, -0.010031149722635746, -0.004081293474882841, 0.03590191900730133, 0.04727897047996521, -0.046503156423568726, -0.010735140182077885,
    0.01354302279651165, -0.01921810209751129, 0.005793233867734671, 0.01170283555984497, -0.020101044327020645, -0.1389797180891037, -0.012128775008022785, -1.1492691555758938e-05,
    0.04965822026133537, 0.017458785325288773, 0.01754525676369667, 0.08925670385360718, 0.021708881482481956, -0.018115047365427017, 0.08219485729932785, 0.031508296728134155,
    0.019105125218629837, -0.05900121107697487, 0.02906716614961624, 0.09326662868261337, -0.04897715523838997, 0.0060066888108849525, 0.026302551850676537, 0.03852182626724243,
    0.021606773138046265, 0.04822685942053795, 0.042985595762729645, -0.03575341776013374, -0.011365387588739395, 0.012320537120103836, 0.017263023182749748, 0.06114097684621811,
    0.008518592454493046, 0.0452466756105423, -0.03031991422176361, -0.00843227282166481, 0.028963180258870125, 0.01003594696521759, -0.02436002343893051, 0.011715688742697239,
    0.042434774339199066, -0.03042585216462612, 0.029800860211253166, -0.027914714068174362, -0.01794036477804184, 0.004149437882006168, -0.04107373580336571, 0.018851744011044502,
    -0.029163571074604988, 0.056805409491062164, -0.10747130960226059, 0.0029032318852841854, 0.017002908512949944, -0.016622241586446762, 0.06304872781038284, 0.08171286433935165,
    -0.02153668738901615, 0.024002093821763992, 0.0708993673324585, 0.007620916236191988, 0.04959644004702568, -0.04508305341005325, -0.08193941414356232, -0.011315050534904003,
    0.00934398453682661, -0.00826849602162838, -0.05389004945755005, 0.09272538870573044, -0.0239744633436203, 0.0077977366745471954, 0.013457252644002438, 0.04340813308954239,
    -0.006173748057335615, 0.010172145441174507, 0.014392256736755371, 0.02049265429377556, 0.05187767744064331, 0.011106249876320362, -0.04252048581838608, 8.226570207625628e-05,
    -0.02343343198299408, -0.01393070537596941, -0.007134081795811653, 0.04664292559027672, -0.041272759437561035, 0.006354580633342266, -0.045811206102371216, 0.029608914628624916,
    0.01590222865343094, -0.04026738181710243, -0.010078838095068932, 0.024213097989559174, -0.07315701246261597, -0.03171244636178017, 0.046075668185949326, -0.012211705558001995,
    0.02430889755487442, -0.03873896226286888, -0.0012374158250167966, -0.020543908700346947, -0.00011103889846708626, 0.0026417227927595377, -0.05251021310687065, 0.04718094319105148,
    -0.004837907385081053, -0.017351943999528885, -0.03257010132074356, -0.015040279366075993, 0.05670735985040665, -0.035223934799432755, -0.07330092787742615, 0.0499633252620697,
    0.08409642428159714, 0.01286370400339365, -0.0034251960460096598, 0.004385584499686956, -0.0016351123340427876, -0.12267229706048965, -0.008853264153003693, 0.0284767784178257,
    -0.03007776476442814, 0.01379022654145956, 0.005012117326259613, -0.002036729361861944, -0.056342851370573044, 0.007862291298806667, -0.007533060386776924, 0.006824993994086981,
    -0.0731651708483696, -0.005507483147084713, -0.02326294779777527, 0.0336184948682785, -0.10678280144929886, -0.07188642024993896, 0.09262962639331818, 0.011082397773861885,
    -0.0009679184295237064, -0.02378583699464798, 0.031361550092697144, -0.05182654410600662, 0.052157722413539886, -0.039742521941661835, 0.037708982825279236, -0.018906278535723686,
    0.0568002313375473, 0.08365487307310104, 0.003682471113279462, -0.0728173553943634, -0.004381741397082806, 0.0022526062093675137, 0.08100983500480652, -0.02067001536488533,
    -0.010592726990580559, 0.09470704197883606, 0.05354584753513336, 0.08081082999706268, 0.14884233474731445, -0.11732025444507599, 0.010564698837697506, 0.10329054296016693,
    0.0333276242017746, -0.07465813308954239, -0.08279040455818176, -0.017821593210101128, -0.04959266632795334, -0.048392154276371, 0.03822704032063484, 0.03620070591568947,
    -0.03042128123342991, -0.030504561960697174, 0.09358814358711243, 0.015656577423214912, 0.019663913175463676, -0.008886505849659443, 0.08700664341449738, -0.1117040291428566,
    -0.031263984739780426, -0.003091149963438511, -0.02941419743001461, 0.0076438006944954395, 0.01994115486741066, -0.003825654275715351, -0.0806111991405487, -0.10051651298999786,
    0.05250662937760353, 0.0070497565902769566, -0.051562536507844925, 0.032191984355449677, 0.019380463287234306, -0.0371752567589283, -0.08422967791557312, -0.004727386403828859,
    -5.231605427979957e-06, 0.06582585722208023, 0.04836343228816986, 0.10377312451601028, -0.020975271239876747, -0.053873009979724884, 0.03986900672316551, -0.00966279860585928,
    0.028789468109607697, 0.018918752670288086, -0.04342703893780708, -0.026095252484083176, -0.025958465412259102, 0.02320087142288685, 0.008978461846709251, -0.009738796390593052,
    0.09720800071954727, 0.13512149453163147, 0.0287293903529644, -0.019872231408953667, 0.0018909904174506664, 0.017685770988464355, 0.009899108670651913, -0.003534517250955105,
    0.05219010263681412, 0.023936057463288307, -0.0024058527778834105, 0.009102451615035534, -0.02619016356766224, 0.03966505080461502, -0.03528255969285965, -0.05203203856945038,
    0.05849761888384819, -0.07340268790721893, -0.00031562766525894403, 0.023084694519639015, -0.07840324938297272, 0.019524522125720978, -0.0646141916513443, 0.15362070500850677,
    -0.020042333751916885, 0.02684776671230793, 0.0466146320104599, -0.047338977456092834, -0.026645507663488388, -0.0502600222826004, -0.02008037641644478, 0.07383067160844803,
    0.01028677448630333, -0.034948691725730896, 0.008937470614910126, 0.01564967632293701, 0.049660056829452515, 0.08741534501314163, 0.027038024738430977, -0.05519914627075195,
    0.0020589325577020645, -0.004664716310799122, 0.04415828734636307, -0.045653171837329865, -0.03223918378353119, -0.03883634880185127, 0.06643272191286087, -0.015350112691521645,
    0.01182695385068655, -0.07908589392900467, -0.04680611565709114, 0.02337721921503544, 0.09163421392440796, -0.054230671375989914, -0.03132637217640877, -0.012341290712356567,
    -0.023401273414492607, -0.007222320884466171, 0.04577019065618515, -0.060817260295152664, 0.014170159585773945, 0.034563660621643066, -0.01826172135770321, -0.029054807499051094,
    0.015253117308020592, -0.03794695809483528, 6.569314427906647e-05, -0.031679749488830566, -0.049746979027986526, 0.050680216401815414, -0.05617653578519821, 0.004542169626802206,
    0.06467255204916, 0.019165415316820145, -0.010759910568594933, -0.04715057089924812, -0.04946513473987579, 0.0726175531744957, 0.03663797676563263, -0.06927713006734848,
    0.05287313088774681, 0.01998041570186615, 0.006074218545109034, -0.04105919599533081, 0.0659220740199089, 0.027792857959866524, 0.039462070912122726, -0.04322708770632744,
    -0.00012782130215782672, 0.056953344494104385, 0.03553079068660736, 0.05058909207582474, 0.08561790734529495, -0.014026368968188763, 0.03572366014122963, -0.02789660170674324,
    -0.013807659968733788, 0.03337058797478676, 0.008650301024317741, -0.03359782695770264, 0.0016362123424187303, -0.02616986632347107, 0.1131407618522644, -0.0394967645406723,
    0.00671387929469347, -0.09642821550369263, 0.006383111234754324, -0.02136262319982052, -0.006551850587129593, 0.0626169890165329, -0.06864499300718307, 0.08581208437681198,
    -0.009506585076451302, 0.0007481938228011131, -9.394757216796279e-05, -0.10204929113388062, 0.00245635025203228, 0.023247551172971725, -0.05804714187979698, 0.0286568570882082,
    -0.007151851896196604, -0.024284727871418, -0.15253856778144836, 0.0659993514418602, 0.005050338339060545, 0.004198477137833834, 0.02881278097629547, -0.005148154683411121,
    -0.013023467734456062, 0.01135238353163004, 0.06556126475334167, 0.10415623337030411, -0.011466765776276588, -0.008642871864140034, 0.053119733929634094, 0.01903180405497551,
    -0.08280547708272934, 0.03871658071875572, -0.006185127887874842, 0.0523577444255352, -0.013420159928500652, -0.03018471784889698, 0.01523100957274437, -0.038681864738464355,
    0.008419109508395195, -0.025499043986201286, 0.06975019723176956, 0.05140963941812515, 0.02144324593245983, 0.10913246124982834, -0.04642930254340172, -0.043381817638874054,
    -0.02669118344783783, 0.013638135977089405, 0.013714286498725414, 0.050067126750946045, 0.0032342374324798584, 0.019783375784754753, 0.05090395361185074, -0.003428184660151601,
    0.048212602734565735, 0.018933895975351334, 0.04216102883219719, 0.017787333577871323, -0.0024512317031621933, -0.03056000918149948, 0.05057873949408531, 0.0712103471159935,
    0.04081607609987259, -0.06453914195299149, 0.018619101494550705, 0.058729883283376694, -0.04000738635659218, 0.061482444405555725, 0.07091176509857178, 0.0348493792116642,
    0.03273149952292442, -0.05176075920462608, 0.00826703105121851, 0.03962409868836403, 0.042697980999946594, -0.06908538192510605, 0.027193233370780945, -0.04857021942734718,
    -0.02610430121421814, 0.037894073873758316, -0.12923528254032135, 0.08776114135980606, -0.0023076364304870367, 0.02857302688062191, -0.03567947447299957, -0.013733702711760998,
    0.00867032166570425, -0.04837307333946228, 0.10337254405021667, 0.0684930831193924, 0.036855071783065796, 0.0451149120926857, -0.030482929199934006, -0.07491334527730942,
    -0.015401357784867287, -0.02213912084698677, 0.029811909422278404, 0.027550049126148224, -0.01837940886616707, 0.018689457327127457, 0.005285096820443869, -0.12284577637910843,
    -0.023501504212617874, -0.05407086759805679, 0.029141398146748543, 0.019369060173630714, 0.03845852240920067, 0.034697212278842926, -0.017273584380745888, -0.05334409326314926,
    0.03214195743203163, -0.08065835386514664, 0.03234636411070824, 0.010479709133505821, 0.030654234811663628, 0.015827415511012077, -0.07108142971992493, 0.03412191569805145,
    0.04177339747548103, 0.020651008933782578, -0.20653995871543884, -0.011378307826817036, -0.035240959376096725, 0.02570585161447525, -0.04843369498848915, 0.10300520062446594,
    -0.003265444189310074, 0.015154878608882427, -0.11299780756235123, 0.03875374794006348, -0.01831727847456932, -0.060059770941734314, 0.01942427270114422, -0.08742642402648926,
    0.018900789320468903, -0.05763139948248863, 0.010005615651607513, 0.05043838545680046, 0.006538890302181244, 0.06352490186691284, -0.031658340245485306, 0.027209917083382607,
    0.015502736903727055, -0.007218823302537203, 0.07701239734888077, 0.029003363102674484, -0.03382094204425812, 0.016375645995140076, 0.04359418898820877, -0.007984199561178684,
    -0.015950260683894157, 0.004809441976249218, -0.006193127948790789, -0.00419658562168479, 0.10828562080860138, -0.028419358655810356, 0.00946967676281929, 0.005570603534579277,
    0.13258765637874603, -0.09543929994106293, 0.13770824670791626, 0.01927746832370758, -0.05649970844388008, -0.008518965914845467, -0.004755872767418623, 0.008019614964723587,
    0.026077348738908768, -0.014429922215640545, 0.010525766760110855, 0.03811682388186455, 0.08929160982370377, 0.014072589576244354, -0.05407620966434479, 0.030549271032214165,
    -0.10230633616447449, 0.0634162575006485, -0.023431669920682907, 0.020459039136767387, 0.029934460297226906, 0.061205729842185974, -0.08369547873735428, -0.06438224762678146,
    0.004791872575879097, -0.015449166297912598, -0.051864732056856155, -0.008637525141239166, 0.011572564952075481, -0.05296482890844345, -0.004280540160834789, -0.05515153333544731,
    0.012544524855911732, -0.06848407536745071, 0.05817563086748123, 0.013505116105079651, -0.011380567215383053, -0.09427729994058609, 0.03888488560914993, -0.013845425099134445,
    -0.05644902586936951, 0.002419369528070092, 0.00131297018378973, 0.014860566705465317, 0.06756392121315002, 0.018625911325216293, 0.06647693365812302, 0.06686311960220337,
    -0.005206436384469271, -0.048559509217739105, -0.06256823241710663, -0.019073233008384705, 0.017253682017326355, -0.04066045582294464, 0.08462108671665192, -0.026101654395461082,
    0.01741071417927742, 0.057800281792879105, 0.006885472219437361, -0.10420671850442886, -0.03660530224442482, -0.009600121527910233, -0.01579449512064457, 0.08665198087692261,
    -0.14073395729064941, -0.015982067212462425, 0.0018169911345466971, 0.04180899262428284, 0.0268392376601696, -0.10319250822067261, 0.06498565524816513, 0.06050889194011688,
    -0.04085205867886543, -0.0008730062982067466, -0.10936471819877625, -0.010600585490465164, 0.03385394439101219, -0.055626869201660156, -0.03210687264800072, -0.01922476291656494,
    -0.047736816108226776, 0.008960088714957237, 0.06070924550294876, -0.03381849080324173, -0.0788421630859375, -0.012017923407256603, 0.057721760123968124, 0.033543266355991364,
    -0.05532175302505493, 0.005493889097124338, 0.1613098680973053, 0.027462642639875412, 0.020174656063318253, 0.04461397975683212, 0.04812835156917572, 0.05056443437933922,
    0.0027206698432564735, 0.0655401200056076, 0.03205327317118645, -0.01776762865483761, -0.058790918439626694, -0.044832516461610794, -0.005976383108645678, -0.1348087638616562,
    -0.022942202165722847, 0.018601154908537865, -0.03892171382904053, -0.009045637212693691, 0.06822867691516876, -0.003239057492464781, 0.13767752051353455, -0.021576235070824623,
    0.017971767112612724, 0.03190083056688309, 0.002548984717577696, -0.02439146302640438, -0.055819712579250336, 0.035942092537879944, -0.03102586790919304, -0.012387643568217754,
    -0.0407252199947834, 0.08840418606996536, 0.045843787491321564, -0.06844593584537506, -0.030651524662971497, 0.04790722578763962, 0.015617151744663715, -0.027447089552879333,
    0.005232119932770729, -0.019710084423422813, -0.02283652126789093, 0.0910651758313179, -0.029128940775990486, 0.007291770540177822, -0.023122070357203484, -0.02452041767537594,
    -0.02002929151058197, -0.04575258865952492, -0.02813882753252983, -0.011291039176285267, -0.09057164937257767, 0.10177749395370483, 0.04748782142996788, 0.06316906958818436,
    -0.04764450713992119, 0.010592703707516193, -0.011173754930496216, -0.0635257288813591, -0.016019249334931374, -0.012889066711068153, 0.017385415732860565, 0.0032528771553188562,
    -0.011417643167078495, 0.012337404303252697, 0.014671473763883114, 0.011137413792312145, -0.05964362993836403, 0.036824241280555725, -0.005286365281790495, 0.034531716257333755,
    -0.006798510905355215, -0.00664084916934371, -0.018994541838765144, -0.012518036179244518, 0.013492483645677567, 0.06135252118110657, -0.030696319416165352, -0.0057998583652079105,
    0.13936559855937958, 0.06896571069955826, 0.008776446804404259, 0.016454165801405907, -0.07633256912231445, -0.023103175684809685, -0.10031946003437042, 0.11981674283742905,
    -0.008641967549920082, 0.021338149905204773, 0.03246830403804779, -0.03374137356877327, 0.003028839360922575, 0.0393192283809185, -0.06871447712182999, 0.039794448763132095,
    0.012171764858067036, -0.04043697193264961, 0.053059447556734085, 0.05770977586507797, 0.07907234132289886, 0.04405296966433525, -0.06072729453444481, 0.0451710969209671,
    0.07437614351511002, 0.02166666090488434, 0.00552679318934679, 0.04044757038354874, -0.08167845755815506, 0.08210019767284393, 0.039670899510383606, 0.05647081136703491,
    -0.04353512451052666, 0.06712488830089569, 0.09064935147762299, -0.018176265060901642, -0.10703510791063309, 0.11034911125898361, 0.00929814763367176, -0.03513955697417259,
    -0.03220430016517639, 0.04321852698922157, -0.009298623539507389, -0.011985568329691887, 0.019007952883839607, -0.0017637463752180338, 0.02164633199572563, -0.016705244779586792,
    0.05194397643208504, 0.003906184108927846, -0.11905760318040848, -0.04803469404578209, 0.016184888780117035, -0.0026079146191477776, -0.014061752706766129, -0.04987262189388275,
    0.07202651351690292, 0.004316376987844706, -0.12475086003541946, -0.043708860874176025, 0.027918027713894844, 0.17337548732757568, 0.01000990904867649, -0.08693838864564896,
    0.014829898253083229, -0.0796220451593399, -0.002435548696666956, -0.001505660475231707, -0.07727008312940598, 0.0226309634745121, -0.05857681855559349, 0.06758660078048706,
    -0.003438989631831646, -0.021187707781791687, -0.050213634967803955, 0.03139237314462662, -0.03360210359096527, 0.03718861564993858, -0.008835452608764172, -0.010575516149401665,
    -0.027414951473474503, 0.056285351514816284, -0.02432677149772644, 0.02305748127400875, -0.03200332075357437, 0.04854283481836319, 0.03643759340047836, 0.033895231783390045,
    -0.10608909279108047, -0.06078854575753212, 0.05461820214986801, -0.04626303166151047, -0.005941840820014477, -0.010727409273386002, 0.015470486134290695, 0.01674824394285679,
    -0.03671916946768761, 0.0495147779583931, -0.0030568214133381844, 0.09400560706853867, 0.045913927257061005, -0.051727570593357086, 0.05234212428331375, 0.028796639293432236,
    -0.0044219885021448135, 0.0015801868867129087, -0.012664113193750381, 0.051563844084739685, 0.03632741793990135, -0.048141706734895706, -0.03378627449274063, 0.04687127098441124,
    0.0006147664389573038, 0.0043732887133955956, 0.02309197001159191, 0.017872052267193794, -0.02332676760852337, -0.045730412006378174, 0.00030560672166757286, -0.04921768233180046,
    -0.038618624210357666, -0.0002565679023973644, 0.01955600455403328, -0.013317412696778774, 0.014480642043054104, 0.019112518057227135, -0.02359507605433464, 0.0018055711407214403,
    0.002442063996568322, -0.010092625394463539, -0.021662168204784393, 0.02587149664759636, -0.038770049810409546, 0.036720048636198044, 0.09570158272981644, -0.05834927782416344,
    -0.035401858389377594, -0.04941784590482712, 0.015214033424854279, -0.0029686151538044214, -0.061817508190870285, -0.10307040065526962, 0.03381849080324173, -0.024988897144794464,
    -0.04676565155386925, 0.006710533984005451, 0.05069712549448013, 0.04668113589286804, 0.016105514019727707, -0.03645028918981552, 0.02284933440387249, -0.09507909417152405,
    0.05628815293312073, -0.001883067423477769, 0.0012924603652209044, -0.04817952215671539, -0.10558187961578369, -0.01697886548936367, -0.00024181279877666384, -0.02272149547934532,
    -0.041615210473537445, -0.12938129901885986, -0.11940658092498779, 9.880759898805991e-05, 0.03054559975862503, -0.09629528224468231, 0.024269942194223404, -0.0006359201506711543,
    -0.04184575751423836, 0.07200565189123154, -0.028830114752054214, -0.0012759536039084196, 0.004263400565832853, -0.05250793322920799, -0.04492901638150215, -0.03242235630750656,
    -0.06266042590141296, -0.01499214768409729, 0.028226183727383614, 0.03224744275212288, -0.0014693626435473561, 0.03909888118505478, -0.01950540766119957, -0.03917412459850311,
    -0.006058315746486187, 0.053495198488235474, 0.06791982799768448, 0.014112398028373718, 0.01233077421784401, -0.05529406666755676, -0.03215734660625458, 0.11689002066850662,
    -0.046369440853595734, 0.05776046961545944, 0.0025203560944646597, 0.06042344868183136, -0.05790026858448982, -0.002296609338372946, -0.007974399253726006, -0.04628033936023712,
    0.03546678274869919, 0.03477049991488457, 0.07229331880807877, 0.012425340712070465, -0.09824365377426147, 0.024143770337104797, -0.07073760777711868, -0.047911617904901505,
    -0.019243625923991203, -0.02863939478993416, 0.01900552026927471, 0.01235227845609188, 0.012453700415790081, -0.005391523241996765, 0.0033314451575279236, 0.024611342698335648,
    0.09050000458955765, 0.009651868604123592, -0.10306939482688904, 0.06613325327634811, -0.03867103531956673, 0.0395340733230114, -0.07975062727928162, 0.00437155133113265,
    -0.0025390000082552433, 0.0058259060606360435, 0.08043456077575684, 0.1080380454659462, 0.060407232493162155, -0.05558190867304802, -0.04743552953004837, 0.023190267384052277,
    -0.0332300029695034, -0.003431192133575678, -0.006980235688388348, -0.06646796315908432, -5.587159648712259e-06, -0.013086829334497452, -0.035339921712875366, 0.053152911365032196,
    -0.02815321646630764, 0.028986822813749313, 0.02790021151304245, 0.02021224983036518, -0.011445021256804466, 0.09280353784561157, 0.04119168967008591, 0.017002707347273827,
    -0.01587645895779133, -0.004558251239359379, -0.013431258499622345, 0.0054207174107432365, 0.08404198288917542, 0.006676891818642616, 0.009813034906983376, -0.013657406903803349,
    -0.005872942507266998, -0.0714203491806984, 0.01224479265511036, -0.0009905960178002715, 0.06552338600158691, 0.06256221979856491, 0.04723934829235077, -0.02048918977379799,
    -0.04552077874541283, -0.04001984745264053, -0.006012969184666872, -0.03421254828572273, -0.004569412674754858, -0.031884416937828064, 0.007569002453237772, -0.033408939838409424,
    -0.031384918838739395, -0.01769319735467434, 0.07466758042573929, -0.014462779276072979, -0.0593140535056591, -0.023714425042271614, 0.02723902463912964, -0.023084484040737152,
    -0.0566788949072361, -0.022226164117455482, -0.021716376766562462, -0.05821231007575989, 0.017526885494589806, 0.002433628309518099, 0.08678416162729263, 0.033020734786987305,
    -0.0006070704548619688, 0.12677206099033356, -0.04556658864021301, -0.011741559021174908, 0.07624194771051407, 0.10777925699949265, -0.07455622404813766, -0.03997389227151871,
    0.07201835513114929, 0.015359503217041492, 0.014190873131155968, 0.035858191549777985, 0.012101225554943085, -0.024434704333543777, -0.008491714484989643, -0.0029433774761855602,
    -0.040603794157505035, 0.04333264380693436, -0.07803239673376083, 0.07084563374519348, 0.03674883767962456, 0.008095523342490196, 0.07228104770183563, 0.022966790944337845,
    0.039712853729724884, -0.08271332085132599, -0.0654427707195282, 0.07411825656890869, 0.02179773896932602, 0.0010446695378050208, 0.057051923125982285, 0.0009707466815598309,
    -0.024811111390590668, -0.05802115425467491, 0.02369030751287937, 0.052664920687675476, 0.060744237154722214, 0.02554270438849926, 0.03967313468456268, 0.05124345049262047,
    0.011480363085865974, -0.026708364486694336, -0.004431986715644598, 0.03042517974972725, -0.008886917494237423, 0.042961474508047104, -0.0838657096028328, -0.01758948341012001,
    0.10021176934242249, 0.022236501798033714, -0.0006911444361321628, -0.022931795567274094, -0.028717447072267532, -0.0032343443017452955, 0.029071854427456856, -0.010393091477453709,
    0.038314130157232285, -0.031281884759664536, -0.1555299609899521, -0.0063434140756726265, -0.0244611669331789, -0.0027232959400862455, -0.010569003410637379, -0.011662589386105537,
    0.039473071694374084, -0.008807958103716373, -0.020645707845687866, -0.025628091767430305, 0.04870743677020073, 0.017787035554647446, 0.00028497903258539736, 0.020757196471095085,
    -0.033259786665439606, 0.006645259913057089, 0.05779920518398285, 0.005727423820644617, -0.06755875796079636, -0.03946860879659653, 0.04286957532167435, -0.1184527650475502,
    -0.04094024747610092, -0.04120223596692085, -0.04218907654285431, 0.0168322641402483, 0.0416703037917614, 0.008584314957261086, 0.020629798993468285, -0.026195546612143517,
    0.02582661435008049, 0.008538331836462021, 0.00486992159858346, -0.03603100776672363, -0.05135748162865639, 0.08706975728273392, 0.015727944672107697, 0.02715330943465233,
    -0.0176423117518425, 0.025839176028966904, 0.030225159600377083, 0.029727622866630554, -0.025569988414645195, -0.03807364031672478, -0.04756473749876022, 0.03529171645641327,
    -0.002026716945692897, 0.02762637659907341, 0.09585981070995331, 0.010634927079081535, 0.0012492705136537552, 0.13232368230819702, 0.01567717455327511, 0.04799574241042137,
    0.054921336472034454, -0.06780264526605606, 0.08371862024068832, 0.014813837595283985, -0.08017513155937195, -0.03629026934504509, -0.10228727012872696, 0.08742476254701614,
    0.05289263278245926, -0.007887297309935093, 0.10566754639148712, 0.06936972588300705, -0.021047910675406456, -0.004550229758024216, 0.004931967239826918, 0.08343161642551422,
    -0.06295686215162277, -0.12680764496326447, 0.026198646053671837, 0.03942627087235451, 0.053943902254104614, -0.12741877138614655, 0.005111171398311853, -0.030375532805919647,
    -0.010979637503623962, 0.04570154845714569, -0.05877837538719177, 0.01989557035267353, 0.0249463077634573, -0.017589235678315163, -0.002455518115311861, 0.013373167254030704,
    -0.029195528477430344, -0.03062973916530609, -0.06004009768366814, 0.022546472027897835, 0.08665622770786285, -0.04389972612261772, -0.08402928709983826, -0.018193816766142845,
    -0.07351112365722656, 0.004719468764960766, -0.009746319614350796, 0.022944079712033272, 0.01090884581208229, -0.03939296677708626, 0.018453972414135933, -0.09597665816545486,
    -0.017496977001428604, 0.0002595279074739665, -0.014747131615877151, 0.04298423230648041, 0.009329886175692081, -0.029975131154060364, 0.06501342356204987, -0.03387116268277168,
    0.033744148910045624, 0.013248302042484283, -0.0066194310784339905, -0.001301064738072455, -0.031131871044635773, 0.02350723184645176, -0.016668038442730904, 0.030077213421463966,
    -0.06338117271661758, 0.006314273923635483, 0.04778246954083443, -0.02849993109703064, 0.0904793068766594, -0.004617668222635984, -0.03147713094949722, 0.005093153566122055,
    -0.03911442682147026, 0.028687281534075737, 0.014461478218436241, -0.06431558728218079, 0.006204132456332445, -0.11899669468402863, 0.05783699080348015, 0.01850164867937565,
    0.07279912382364273, -0.033107053488492966, -0.034828271716833115, 0.07704496383666992, -0.021534712985157967, 0.01756819151341915, 0.0028752535581588745, 0.01861567050218582,
    0.011854536831378937, -0.048439644277095795, 0.03239054977893829, 0.042018990963697433, 0.010304439812898636, -0.03687198832631111, -0.043645765632390976, 0.08191021531820297,
    -0.006063908338546753, -0.001520661753602326, 0.036110423505306244, -0.0016075433231890202, -0.009991857223212719, -0.015802446752786636, 0.017679793760180473, 0.04082785174250603,
    -0.04369216039776802, 0.06939247250556946, 0.020346546545624733, -0.02329009771347046, 0.0020070134196430445, 0.005894130561500788, 0.009290670044720173, -0.00296162161976099,
    0.03816027194261551, 0.006606350652873516, 0.007964850403368473, 0.013184860348701477, 0.08740395307540894, -0.0611761249601841, 0.13350741565227509, -0.03138433024287224,
    -0.04615708440542221, 0.041391246020793915, -0.03475493937730789, 0.052564430981874466, -0.006401590071618557, -0.05478793755173683, 0.046327315270900726, -0.014526885002851486,
    -0.036038145422935486, 0.024933619424700737, -0.08152884244918823, -0.04885387793183327, -0.014937429688870907, 0.0011955060763284564, 0.04225568473339081, -0.09189093858003616,
    -0.12615375220775604, -0.012850615195930004, -0.001992651727050543, -0.019003838300704956, -0.08482640981674194, -0.08156885206699371, -0.050371576100587845, -0.026913965120911598,
    0.01181599497795105, 0.10579331964254379, 0.0005361969815567136, -0.02421537972986698, -0.015425603836774826, 0.07439547032117844, 0.07504148781299591, -0.018452610820531845,
    -0.028271684423089027, 0.03023630566895008, -0.036812249571084976, 0.09615569561719894, 0.02646944858133793, -0.06434191763401031, -0.04555835574865341, 0.009756557643413544,
    0.03811313956975937, -0.012715320102870464, 0.045618630945682526, 0.018218861892819405, -0.0343291237950325, 0.019855253398418427, 0.0864400640130043, -0.00560159282758832,
    0.03384334221482277, 0.013832618482410908, -0.02512415684759617, 0.003242109902203083, -0.051793958991765976, 0.0010975931072607636, 0.051947493106126785, 0.07007934153079987,
    -0.02605358697474003, -0.033348385244607925, 0.039488788694143295, -0.008027246221899986, 0.005929274950176477, 0.0027989454101771116, 0.0022483805660158396, -0.0006401906721293926,
    -0.0008188488427549601, 0.031124262139201164, -0.012572006322443485, -0.01600731536746025, -0.09318795800209045, -0.03805507346987724, 0.020982159301638603, 0.0057393768802285194,
    0.04278382658958435, 0.026549240574240685, -0.002062570070847869, -0.023002928122878075, -0.019564172253012657, -0.022010158747434616, -0.03949795663356781, 0.06633809208869934,
    0.02494838647544384, -0.00947510078549385, 0.00882358755916357, 0.005232684314250946, -0.00040240693488158286, 0.13972820341587067, -0.025170017033815384, 0.05050918459892273,
    -0.09247423708438873, 0.015833426266908646, 0.005633878521621227, 0.00563278142362833, 0.011029340326786041, 0.014267812483012676, 0.07318595796823502, -0.015685774385929108,
    0.037630751729011536, -0.002040691440925002, 0.03797940909862518, -0.05972092226147652, 0.030118649825453758, -0.051475223153829575, 0.020979275926947594, 0.021208465099334717,
    -0.0543130487203598, -0.0010194244096055627, -0.030156102031469345, 0.007117317058146, 0.010727065615355968, -0.008593420498073101, -0.012618142180144787, -0.039601486176252365,
    0.026591237634420395, -0.00764092430472374, -0.00042619704618118703, -0.011663347482681274, -0.024244867265224457, 0.024882959201931953, 0.03773026540875435, -0.016345784068107605,
    0.0770178735256195, -0.06671073287725449, 0.043751850724220276, -0.0010811096290126443, -0.014643141999840736, 0.04898890107870102, 0.0022109237033873796, 0.010641399770975113,
    -0.02935718558728695, 0.051557641476392746, 0.11614315211772919, -0.019863061606884003, 0.04327472671866417, 0.034111540764570236, -0.041565511375665665, -0.0732952430844307,
    0.047205280512571335, -0.0388534814119339, 0.0003298802475910634, -0.003028402803465724, 0.03977694362401962, 0.01507529616355896, 0.0586409792304039, -0.04785635322332382,
    -0.023734360933303833, 0.04056287556886673, 0.00521437032148242, -0.03505320847034454, -0.057652655988931656, -0.0016913881991058588, -0.02822570502758026, -0.01002097874879837,
    0.018089212477207184, -0.11707733571529388, 0.13351933658123016, -0.001548723434098065, -0.009489906020462513, -0.02320409193634987, -0.08025985956192017, -0.036879513412714005,
    0.00926518440246582, -0.007635581772774458, -0.018913349136710167, -0.09155148267745972, 0.006759276147931814, 0.017375841736793518, 0.013678072951734066, 0.024362724274396896,
    0.08112234622240067, 0.03986205905675888, 0.07205957919359207, -0.05483327433466911, -0.023574931547045708, -0.017296019941568375, -0.0019631176255643368, -0.0016875190194696188,
    0.018175998702645302, -0.023187799379229546, -0.005762422922998667, 0.07221317291259766, 0.011141207069158554, -0.0700143575668335, 0.07769371569156647, -0.03497973084449768,
    -0.03107980452477932, -0.0543903112411499, -0.058761514723300934, -0.04922274500131607, -0.008034179918467999, 0.004587018396705389, 0.006462272256612778, 0.05648823082447052,
    0.02736884169280529, 0.009872659109532833, -0.03158220648765564, 0.023777509108185768, 0.062269072979688644, -0.007238059304654598, -0.02498592808842659, 0.05440255627036095,
    0.0410308912396431, -0.019044330343604088, -0.024738185107707977, -0.0652216374874115, -0.06443164497613907, -0.004577350802719593, -0.03043137863278389, -0.0415506586432457,
    0.014865714125335217, 0.0026731479447335005, 0.04044308140873909, -0.025698939338326454, -0.042189739644527435, -0.0313701368868351, -0.16370365023612976, 0.03823230043053627,
    -0.06200680136680603, 0.08264230191707611, 0.02139396034181118, -0.06597208231687546, 0.041341960430145264, -0.0418674610555172, 0.07797328382730484, 0.024885287508368492,
    -0.022649014368653297, 0.02827732264995575, 0.07208365947008133, -0.003207511268556118, 0.05981470271945, -0.008666196838021278, -0.009314625523984432, 0.06149379163980484,
    0.013747558929026127, -0.011496378108859062, -0.00969394575804472, 0.014468546956777573, -0.04316578060388565, -0.004621722269803286, 0.026856299489736557, -0.0033202774357050657,
    0.060892924666404724, -0.01914401538670063, 0.033941395580768585, -0.010457322001457214, 0.001219973899424076, 0.009160985238850117, 0.031257160007953644, 0.047952208667993546,
    -0.056274376809597015, -0.07483915984630585, 0.03629079833626747, 0.011760354042053223, -0.03166303038597107, -0.004379322752356529, 0.03420979902148247, 0.03308970853686333,
    -0.03168543428182602, 0.012475499883294106, -0.04301007091999054, -0.05141139402985573, 0.0315060019493103, -0.07748078554868698, 0.03743080049753189, 0.00876778457313776,
    0.05875067785382271, -0.01281624287366867, 0.07981204986572266, 0.018536794930696487, 0.02195602096617222, 0.034864895045757294, -0.0625724270939827, 0.08099906891584396,
    -0.0017895180499181151, -0.027121834456920624, -0.024419255554676056, 0.044450219720602036, -0.06462801247835159, 0.03804045170545578, 0.11450138688087463, 0.09021171182394028,
    0.007785840425640345, 0.07812770456075668, 0.07713466137647629, -0.006094141397625208, 0.19926640391349792, -0.032640378922224045, 0.059649933129549026, -0.07041534781455994,
    -0.006649274844676256, 0.03892352432012558, -0.008116771467030048, 0.06340859085321426, -0.03850385174155235, -0.00034385797334834933, 0.10086043924093246, 0.0026539412792772055,
    -0.08225060999393463, 0.011397815309464931, -0.0377805121243, 0.10871091485023499, -0.030374161899089813, 0.011966735124588013, 0.03623557463288307, 0.007675604894757271,
    -0.012185882776975632, 0.019257046282291412, -0.03939793258905411, -0.019794054329395294, 0.12100329995155334, 0.02758699096739292, 0.05220169201493263, -0.022463783621788025,
    0.016293523833155632, -0.05506693199276924, 0.05724085867404938, 0.04443858563899994, 0.017986547201871872, -0.014675612561404705, 0.049265675246715546, -0.0951690673828125,
    -0.034655485302209854, -0.05759228765964508, -0.05114613100886345, 0.012951592914760113, 0.06123647093772888, -0.02852340042591095, 0.08695866167545319, -0.04759342595934868,
    -0.003539430210366845, -0.02431853488087654, -0.03760317713022232, -0.02343582548201084, -0.05997810140252113, 0.03860412538051605, 0.021999482065439224, -0.02085406519472599,
    -0.0407521016895771, 0.021225327625870705, 0.07463990151882172, 0.036693066358566284, 0.005493832752108574, -0.0604744516313076, -0.02841700240969658, 0.039904288947582245,
    0.04246059060096741, 0.038504090160131454, 0.005250174552202225, -0.002200191607698798, 0.002419017720967531, -0.09215109050273895, -0.041933298110961914, -0.013914227485656738,
    0.06993891298770905, 0.014913319610059261, 0.035155486315488815, 0.039278969168663025, -0.021534476429224014, 0.0015637027099728584, -0.00865265354514122, 0.109062060713768,
    -0.007018447387963533, 0.015164532698690891, 0.037029415369033813, -0.0242599006742239, 0.030238039791584015, -0.00810993742197752, -0.07799694687128067, 0.0917092114686966,
    -0.0028590376023203135, -0.030296895653009415, -0.059164732694625854, 0.04296460747718811, -0.023809675127267838, -0.021852368488907814, -0.04149942100048065, -0.030132686719298363,
    0.0032682642340660095, -0.032746169716119766, -0.0068189180456101894, 0.06438154727220535, -0.04859378561377525, 0.03706808760762215, 0.09900663793087006, -0.004351352341473103,
    -0.03951963037252426, -0.011291194707155228, -0.1088353842496872, -0.0854504257440567, -0.06940139085054398, 0.023772766813635826, -0.05276026204228401, 0.019979307428002357,
    0.0645333006978035, 0.024815872311592102, -0.026500210165977478, 0.021616540849208832, -0.05062829330563545, 0.07070420682430267, 0.01168912649154663, -0.012610751204192638,
    0.04327434301376343, -0.0040465909987688065, -0.04973442852497101, -0.04566671699285507, 0.04449280723929405, -0.01502298004925251, -0.002450809581205249, -0.03846818208694458,
    -0.03829262778162956, -0.07003576308488846, 0.05252882465720177, -0.04876197129487991, 0.03869665414094925, 0.03629558905959129, -0.019657354801893234, -0.01783672533929348,
    0.06675853580236435, -0.04169977828860283, -0.08848828077316284, 0.05018520727753639, 0.04798411950469017, 0.016670983284711838, -0.10157453268766403, 0.07517461478710175,
    0.024843771010637283, 0.03989511355757713, -0.07801993191242218, -0.04414523392915726, 0.05589227378368378, -0.015610435046255589, -0.023144681006669998, 0.03166617080569267,
    0.023684853687882423, -0.0005478832754306495, 0.0478467158973217, -0.03553310036659241, 0.03474104776978493, -0.037491053342819214, 0.008727299980819225, 0.08831074833869934,
    0.03299257904291153, -0.06290160119533539, -0.07179412990808487, 0.01691698655486107, -0.020389476791024208, 0.010519854724407196, -0.028877388685941696, 0.12059186398983002,
    -0.011489767581224442, 0.02112298086285591, 0.008632170967757702, 0.04683856666088104, -0.02535102888941765, -0.012531599029898643, 0.042612474411726, 0.012908711098134518,
    -0.03799622505903244, 0.04873579367995262, -0.05852748453617096, -0.12703053653240204, -0.014958522282540798, 0.009149488992989063, 0.06331705302000046, -0.04771169647574425,
    -0.005279259756207466, -0.058724161237478256, 0.0551760271191597, 0.023119425401091576, -0.024410678073763847, 0.04427177086472511, -0.057356808334589005, 0.011801420710980892,
    0.054746028035879135, 0.009173951111733913, -0.021268585696816444, 0.04839692637324333, 0.10889734327793121, -0.011863538064062595, -0.024424251168966293, -0.00848400592803955,
    0.05929547920823097, -0.013193762861192226, 0.013817553408443928, -0.08427870273590088, -0.014580249786376953, 0.016055628657341003, -0.0007543336250819266, 0.01989653892815113,
    -0.04299064725637436, -0.012325895018875599, -0.050762806087732315, 0.01685675047338009, 0.006672278977930546, 0.006201751995831728, 0.07644646614789963, -0.10443595051765442,
    -0.08247873932123184, 0.06642729043960571, 0.002487404039129615, 0.01468319445848465, 0.008099684491753578, -0.05429280176758766, 0.022032033652067184, -0.08287820965051651,
    -0.0482308566570282, -0.038440413773059845, -0.02618570812046528, -0.04838412627577782, -0.009875796735286713, -0.06515417248010635, -0.06957323849201202, -0.02818112075328827,
    -0.014511511661112309, -0.028748994693160057, 0.16885967552661896, -0.009022981859743595, 0.02100163884460926, 0.09260506927967072, 0.06047048792243004, 0.013434944674372673,
    -0.010329299606382847, -0.026124440133571625, -0.06642533838748932, -0.009217748418450356, 0.07232546806335449, 0.03010818175971508, -0.03330651670694351, -0.007190917152911425,
    0.011125292629003525, 0.009419919922947884, 0.001125004724599421, -0.038756657391786575, 0.01481891144067049, -0.005883316975086927, 0.015187796205282211, 0.0031728155445307493,
    0.039772551506757736, 0.02945137582719326, 0.09147216379642487, -0.023421650752425194, -0.06833784282207489, -0.08901666849851608, -0.06199856847524643, -0.14211207628250122,
    -0.039033349603414536, -0.11353310197591782, 0.00029512782930396497, -0.021354930475354195, -0.013626490719616413, 0.026424862444400787, 0.100316621363163, 0.004838737193495035,
    -0.06780149042606354, 0.012715015560388565, -0.046758487820625305, 0.04484966769814491, -0.01279910746961832, -0.08424899727106094, -0.06687609851360321, -0.00705027487128973,
    0.010976847261190414, 0.014943648129701614, -0.02000170573592186, -0.023712554946541786, 0.07544635981321335, 0.0779801458120346, -0.00628079054877162, 0.08964236825704575,
    0.0027140157762914896, 0.06970855593681335, 0.10222648084163666, -0.07202530652284622, 0.005695511121302843, -0.02451571263372898, -0.012710650451481342, -0.11457394063472748,
    0.010897341184318066, -0.005775293800979853, 0.13443604111671448, -0.004224044270813465, 0.011318091303110123, 0.00953938253223896, 0.03419765084981918, -0.00822562724351883,
    -0.03566170483827591, -0.004374669399112463, -0.04491255804896355, 0.060691334307193756, 0.06574130803346634, 0.034874849021434784, 0.0313371866941452, -0.056715235114097595,
    -0.004407553933560848, 0.012719226069748402, 0.024472171440720558, 0.14865927398204803, 0.05747012421488762, -0.11933209747076035, -0.02771030366420746, 0.061442647129297256,
    0.09271818399429321, -0.014631198719143867, 0.002094805473461747, 0.011914844624698162, 0.09041706472635269, -0.062189940363168716, -0.030225073918700218, -0.025397514924407005,
    -0.023604633286595345, -0.04191005602478981, -0.04958853870630264, 0.048101089894771576, -0.014196843840181828, -0.03894655033946037, 0.0018267967971041799, 0.05409606918692589,
    5.13405138917733e-05, 0.03320898115634918, 0.04097435623407364, 0.007320272270590067, 0.017175018787384033, 0.02006208710372448, -0.026872264221310616, 0.0829010158777237,
    0.04456785321235657, 0.012497905641794205, 0.0035997049417346716, -0.002714061178267002, 0.05872279405593872, -0.059089213609695435, 0.05342571809887886, -0.016150886192917824,
    0.01603938825428486, -0.024360714480280876, 0.08266065269708633, -0.01662767492234707, 0.014847840182483196, -0.06601125001907349, 0.03450492024421692, 0.026897192001342773,
    -0.06922410428524017, -0.07703127712011337, -0.0635613277554512, 0.022842926904559135, 0.03963533416390419, -0.06520236283540726, 0.056567709892988205, 0.01533625740557909,
    0.016060445457696915, 0.005450120661407709, 0.007043956778943539, 0.0729205533862114, 0.0016007445519790053, 0.007142276503145695, -0.04810388758778572, 0.03133280202746391,
    -0.06985606998205185, 0.020343612879514694, -0.019842060282826424, -0.02655959129333496, 9.49866353039397e-06, 0.022854745388031006, -0.07611674070358276, -0.026075690984725952,
    -0.07692471891641617, 0.007497846614569426, 0.08431566506624222, 0.019618745893239975, -0.05762195587158203, 0.04317982867360115, 0.053510814905166626, -0.02332829125225544,
    0.0737495943903923, -0.026445329189300537, 0.06512339413166046, -0.07150714099407196, -0.016606029123067856, -0.008305512368679047, -0.04940088465809822, -0.009450491517782211,
    -0.006138944532722235, 0.007813462056219578, 0.037595950067043304, 0.008557051420211792, -0.0655842125415802, -0.012581371702253819, 0.025699706748127937, -0.03550058975815773,
    -0.013661392033100128, -0.07665025442838669, -0.03316672518849373, 0.04742652550339699, -0.014911862090229988, 0.03971081227064133, 0.08033836632966995, 0.01294749602675438,
    0.01989143155515194, -0.06358860433101654, -0.08634192496538162, -0.003994334954768419, -0.02403389848768711, -0.009798337705433369, 0.04053867608308792, 0.09421126544475555,
    -0.007778604980558157, -0.028383607044816017, -0.0472160205245018, 0.0051561747677624226, -0.010512485168874264, 0.021498706191778183, 0.02301216311752796, 0.003848457708954811,
    0.0062634823843836784, -0.06495965272188187, -0.02094062604010105, -0.002254592254757881, -0.00723122525960207, -0.011456158943474293, -0.06059935688972473, 0.009753040969371796,
    -0.018570346757769585, -0.02624634839594364, -0.011955361813306808, -0.09117099642753601, -0.07608616352081299, 0.08514993637800217, -0.005292448680847883, 0.03155956789851189,
    -0.001713540405035019, 0.03443797677755356, -0.014787272550165653, -0.05516588315367699, -0.03839647024869919, 0.04767162352800369, -0.050460971891880035, 0.02127295732498169,
    0.05893753096461296, -0.008192230947315693, 0.16103895008563995, -0.007606917060911655, 0.05991244688630104, -0.002600796055048704, -0.011066457256674767, -0.046719204634428024,
    -0.018646076321601868, 0.008513551205396652, 0.030037302523851395, 0.008083109743893147, -0.028333161026239395, -0.03944196552038193, 0.001234347582794726, 0.04679768532514572,
    -0.060543663799762726, 0.040597815066576004, 0.06492756307125092, -0.006629711017012596, -0.03149815648794174, 0.03744945302605629, -0.05783554166555405, 0.06125657260417938,
    0.0058938669972121716, -0.1049874871969223, -0.04760321229696274, 0.005025877617299557, 0.006541733164340258, 0.014661041088402271, 0.05098237842321396, -0.0004135231429245323,
    -0.0413014218211174, -0.08927763998508453, 0.015097538940608501, 0.01835482567548752, -0.0606878325343132, -0.06850950419902802, 0.05502627417445183, -0.005112740211188793,
    0.018596583977341652, -0.01880730502307415, -0.005395284853875637, -0.07641581445932388, -0.060259636491537094, -0.03774628788232803, 0.00442021107301116, 0.09301085770130157,
    0.11702410876750946, 0.06424307823181152, 0.035822127014398575, -0.049904610961675644, 0.02522006258368492, 0.0038723722100257874, 0.04727822542190552, 0.015801245346665382,
    -0.041596561670303345, -0.07667947560548782, 0.01101665198802948, 0.02131754159927368, 0.004205240402370691, -0.05904046818614006, -0.03876711428165436, -0.01540929265320301,
    0.023943975567817688, 0.03891022875905037, 0.007386758457869291, 0.07245966792106628, -0.01484618429094553, -0.015361945144832134, -0.00917897094041109, 0.030648604035377502,
    0.014991723001003265, 0.028546318411827087, 0.024530772119760513, -0.0336386002600193, 0.015595869161188602, -0.013782057911157608, 0.12045585364103317, -0.053316377103328705,
    0.0661037266254425, -0.0007108508143573999, 0.07721425592899323, 0.04512539133429527, 0.012720775790512562, -0.03549669310450554, -0.007359388750046492, -0.023649044334888458,
    0.0075399926863610744, -0.009095135144889355, -0.004465228877961636, -0.1146380603313446, -0.010908824391663074, 0.005754618439823389, -0.17453721165657043, -0.07150992751121521,
    -0.034317560493946075, -0.020449573174118996, -0.02847685106098652, -0.051440224051475525, -0.046978142112493515, 0.03284149616956711, 0.06685054302215576, -0.028460245579481125,
    -0.01925104856491089, -0.0535256452858448, -0.04400567337870598, 0.0152907595038414, 0.040209632366895676, 0.07618053257465363, -0.07221827656030655, -0.07891923934221268,
    -0.011697002686560154, -0.021516522392630577, -0.022718053311109543, 0.10995951294898987, 0.06170685589313507, -0.03830970451235771, -0.015262078493833542, 0.08176832646131516,
    -0.019279368221759796, 0.04376829043030739, 0.021416697651147842, 0.01963525451719761, -0.025691919028759003, 0.02727005071938038, 0.0218370258808136, -0.00715538440272212,
    -0.10250929743051529, -0.009495384059846401, -0.08685758709907532, -0.018953274935483932, -0.04013233631849289, -0.010190349072217941, 0.053066592663526535, -0.09045491367578506,
    -0.010355385951697826, 0.04291423410177231, -0.003813178976997733, -0.022368311882019043, -0.0352340005338192, 0.028159249573946, -0.04158693179488182, -0.14443254470825195,
    0.003955281805247068, -0.005826415028423071, -0.015004399232566357, -0.09779906272888184, -0.03151189163327217, 0.010242766700685024, -0.01762022264301777, -0.038656868040561676,
    0.019733143970370293, -0.039889492094516754, 0.043003104627132416, -0.033661138266325, 0.020086131989955902, -0.021109553053975105, 0.006312657613307238, -0.10005033761262894,
    -0.016808675602078438, 0.0013499034103006124, -0.017389632761478424, -0.07443030178546906, 0.040272146463394165, 0.019502995535731316, -0.003832014510408044, 0.030584564432501793,
    -0.06488559395074844, 0.0018918004352599382, -0.022568659856915474, -0.033152930438518524, 0.03905807435512543, -0.008588922210037708, -0.025899531319737434, 0.06759113073348999,
    0.05764579772949219, -0.01390459667891264, -0.08183865249156952, -0.017007559537887573, -0.023573361337184906, 0.006324354559183121, -0.04749986529350281, 0.047629233449697495,
    -0.03156689181923866, 0.07439372688531876, -0.012092684395611286, -0.014313798397779465, -0.012849549762904644, 0.06517346948385239, 0.0035378821194171906, -0.020351016893982887,
    -0.005067621357738972, -0.00657935393974185, -0.017200445756316185, -0.004195593763142824, 0.044650811702013016, -0.013400730676949024, -0.0026383253280073404, 0.020456047728657722,
    0.10615313053131104, -0.05349327251315117, -0.05678720399737358, -0.007197433151304722, -0.015552512370049953, -0.007500356063246727, -0.029614347964525223, 0.10925836861133575,
    -0.07242349535226822, -0.08413341641426086, -0.05954558402299881, 0.004285715986043215, 0.010527778416872025, 0.026949729770421982, 0.0555705651640892, -0.02556886151432991,
    0.04487626627087593, -0.07757876813411713, 0.0461384654045105, 0.016909807920455933, -0.05006060376763344, -0.016684679314494133, 0.003974059596657753, 0.03035937249660492,
    0.014524243772029877, -0.043820060789585114, -0.03112887218594551, 0.014103940688073635, -0.008787943981587887, 0.09240976721048355, 0.08942678570747375, 0.00742439366877079,
    -0.00940629281103611, -0.0029055846389383078, -0.02225603722035885, -0.1107630729675293, 0.03548521548509598, -0.014917214401066303, 0.017456751316785812, -0.06658996641635895,
    -0.029681669548153877, -0.04277116432785988, 0.034400440752506256, 0.014422504231333733, 0.02343388833105564, -0.03148379549384117, 0.022326787933707237, 0.014004364609718323,
    -0.027923699468374252, -0.01578432321548462, -0.02283063717186451, 0.06087054684758186, 0.09108477830886841, -0.09064085781574249, -0.04060933366417885, -0.014354217797517776,
    -0.008354170247912407, -0.024561993777751923, 0.0644826889038086, -0.001871338696219027, 0.009578144177794456, 0.02879476547241211, 0.003022379707545042, -0.14078302681446075,
    0.051003191620111465, -0.0032113222405314445, -0.018581651151180267, 0.012930408120155334, 0.04960489645600319, 0.029227953404188156, 0.053861312568187714, 0.11460771411657333,
    -0.03925498202443123, 0.022965125739574432, -0.048743750900030136, 0.014928419142961502, -0.014323345385491848, 0.023932214826345444, -0.026037754490971565, -0.10096446424722672,
    0.029202144593000412, -0.013593128882348537, -0.037986546754837036, -0.07016832381486893, 0.008539963513612747, -0.09258285909891129, 0.00038031471194699407, -0.06477262079715729,
    -0.05912608280777931, -0.1097932904958725, 0.055061448365449905, -0.028407007455825806, -0.026615167036652565, 0.0008217623690143228, 0.06823950260877609, 0.017761411145329475,
    0.015384955331683159, 0.005816273856908083, 0.08268728107213974, -0.06883665174245834, 0.062978595495224, 0.012231656350195408, -0.057925619184970856, -0.05772751569747925,
    0.038529910147190094, 0.056348323822021484, -0.013281190767884254, -0.01856417767703533, -0.04658157378435135, 0.0023374822922050953, 0.010809415020048618, -0.07442688941955566,
    -0.027191029861569405, -0.03202821686863899, 0.032415494322776794, -0.0017313940916210413, -0.012442628853023052, -0.10777772963047028, 0.03900034353137016, -0.0038463363889604807,
    -0.04322604089975357, 0.013309184461832047, 0.03698907047510147, 0.006926529109477997, -0.09845828264951706, 0.07571753859519958, 0.10533872991800308, 0.012692992575466633,
    -0.02029654197394848, 0.01934361457824707, -0.055936481803655624, -0.0010966822737827897, 0.019974207505583763, -0.028474068269133568, -0.03132975473999977, 0.06947995722293854,
    -0.006542326416820288, 0.13982073962688446, 0.016276918351650238, 0.04174713417887688, -0.035058002918958664, 0.018859414383769035, -0.042141519486904144, 0.0676615834236145,
    0.04064428061246872, 0.20154806971549988, -0.04564580321311951, -0.09238003194332123, 0.030844461172819138, 0.028016209602355957, -0.043304312974214554, -0.037681944668293,
    -0.005906162783503532, 0.07706153392791748, -0.08124502003192902, 0.020486116409301758, 0.03599756583571434, 0.014803492464125156, 0.10216694325208664, -0.01981177367269993,
    -0.02181900106370449, -0.028144273906946182, -0.09497453272342682, -0.01448360737413168, 0.10581104457378387, 0.0028983112424612045, 0.014003287069499493, -0.02864716574549675,
    -0.012972057797014713, 0.0551094114780426, -0.16172990202903748, 0.023784229531884193, -0.02959098108112812, 0.0356694720685482, 0.02456577494740486, 0.0946509912610054,
    -0.03344196453690529, 8.288414392154664e-05, -0.044974200427532196, -0.017973804846405983, -0.08479858189821243, -0.07057662308216095, 0.016086546704173088, -0.058206863701343536,
    -0.026366719976067543, -0.04222039133310318, 0.053459618240594864, 0.05620165541768074, -0.045440807938575745, -0.051270995289087296, -0.0574527271091938, -0.09291227906942368,
    -0.025374699383974075, 0.03311348706483841, 0.09527046978473663, -0.020368298515677452, -0.03429470583796501, -0.022899536415934563, -0.015045487321913242, -0.0009803082793951035,
    0.04069021716713905, -0.03292663022875786, -0.020567188039422035, 0.13661673665046692, 0.04214826226234436, 0.10008428245782852, -0.01882360689342022, 0.052604734897613525,
    0.03421969339251518, -0.07970865070819855, 0.0013236640952527523, 0.009078416042029858, -0.033538009971380234, 0.0217499490827322, -0.016091657802462578, -0.00393257662653923,
    0.05958365648984909, -0.039277009665966034, -0.007803206332027912, 0.006033021025359631, 0.008047702722251415, -0.10751133412122726, 0.03646594285964966, -0.0007196005317382514,
    -0.03826811537146568, -0.03852241486310959, 0.07657310366630554, 0.03183608502149582, 0.0485902801156044, 0.022749271243810654, -0.033158451318740845, 0.012317799031734467,
    -0.03663231432437897, 0.03659801185131073, 0.043084245175123215, -0.019415007904171944, -0.002024454763159156, 0.03500606492161751, -0.05424008145928383, -0.005352138075977564,
    -0.09591035544872284, -0.0458541139960289, 0.06174924224615097, -0.005229708272963762, -0.01944865472614765, 0.02582806907594204, -0.014722301624715328, -0.0003200857900083065,
    -0.09021428227424622, 0.033151015639305115, 0.02370283007621765, -0.11588814854621887, -0.03532295674085617, -0.10157200694084167, -0.056369006633758545, 0.015429331921041012,
    0.037375789135694504, -0.01879284530878067, -0.08759916573762894, -0.007742153014987707, -0.004288087133318186, -0.03820323571562767, -0.11351889371871948, -0.05078698694705963,
    -0.046332575380802155, 0.019162070006132126, -0.018773294985294342, -0.03654871881008148, -0.0205733273178339, 0.043822646141052246, 0.13835085928440094, -0.02082904614508152,
    -0.0056481994688510895, 0.03007679246366024, 0.043120428919792175, 0.10689081996679306, 0.0021766882855445147, -0.025146370753645897, 0.042005445808172226, 0.0182690117508173,
    -0.00925894733518362, -0.040027640759944916, -0.01869911327958107, -0.010491861961781979, -0.0250473003834486, -0.06075448542833328, 0.011353510431945324, -0.004615759011358023,
    0.04225781559944153, 0.0409732349216938, 0.03654791787266731, 0.010084801353514194, 0.12306522578001022, -0.017821243032813072, 0.036636706441640854, 0.07655126601457596,
    0.03514394909143448, -0.04382626712322235, 0.006219983100891113, 0.01378608401864767, -0.00210171309299767, 0.0004788672085851431, 0.016460930928587914, 0.046850454062223434,
    0.03031845949590206, 0.06215308606624603, -0.006064883433282375, 0.07277557998895645, -0.11047321557998657, -0.007166820112615824, 0.029981885105371475, -0.02226616069674492,
    -0.03632109612226486, -0.014337306842207909, -0.014778759330511093, -0.08546201139688492, -0.05610990524291992, 0.05982942134141922, -0.023516833782196045, -0.08248977363109589,
    0.006715090479701757, 0.039987023919820786, -0.03147970139980316, 0.01757478527724743, 0.008885935880243778, -0.03639785572886467, 0.002966964617371559, -0.07493358850479126,
    -0.007073082495480776, -0.02998831681907177, 0.0068089826963841915, -0.01163183618336916, -0.017467403784394264, 0.040235914289951324, 0.0034114541485905647, -0.032549284398555756,
    -0.015125208534300327, -0.013874118216335773, 0.01465188805013895, 0.07245813310146332, 0.016969900578260422, -0.009877246804535389, 0.03586313873529434, -0.02184276282787323,
    0.017617253586649895, 0.0026594202499836683, -0.027628561481833458, -0.04680589586496353, -0.027728939428925514, 0.04676685854792595, 0.07364773750305176, -0.010972983203828335,
    -0.001143810572102666, 0.05669727176427841, -0.019939647987484932, 0.0018108721124008298, -0.024434523656964302, 0.028804192319512367, 0.017584217712283134, -0.08086813241243362,
    0.002735354471951723, 0.0017444792902097106, 0.006874879356473684, -0.009679015725851059, 0.0948454737663269, -0.0030045118182897568, 0.03747188672423363, 0.019668973982334137,
    0.0027994089759886265, 0.10857474058866501, 0.017302770167589188, 0.018078936263918877, -0.026362478733062744, 0.02290857955813408, -0.012726446613669395, -0.002253509359434247,
    -0.03440649062395096, 0.03328800946474075, -0.061677005141973495, 0.07724262773990631, -0.04296145215630531, -0.05239418148994446, 0.0206442903727293, 0.01607600599527359,
    0.002654461655765772, 0.0012629454722627997, 0.018948545679450035, 0.00018776151409838349, 0.024873916059732437, -0.061670273542404175, 0.005849543958902359, -0.020157869905233383,
    -0.03871415928006172, 0.08110737055540085, 0.038274165242910385, 0.009093004278838634, 0.0024467066396027803, 0.05166549235582352, -0.06240217015147209, 0.019525935873389244,
    0.011522495187819004, 0.04351386800408363, -0.1048167273402214, -0.07606449723243713, 0.11003629863262177, 0.03903387114405632, 0.03082449361681938, 0.021687235683202744,
    0.02473749965429306, -0.08583570271730423, 0.052188221365213394, 0.0006483503966592252, -0.0031500738114118576, -0.09958680719137192, -0.03611709550023079, -0.03064083680510521,
    0.009960303083062172, 0.06473319977521896, 0.0018324046395719051, -0.039577580988407135, -0.005470796953886747, 0.13371187448501587, 0.011822433210909367, 0.007986709475517273,
    -0.01401516143232584, -0.014317880384624004, -0.01347370631992817, 0.07145800441503525, -0.010274084284901619, -0.006451127585023642, 0.02441704273223877, 0.0866602212190628,
    0.013793103396892548, 0.09189275652170181, -0.04902438819408417, -0.05754125118255615, -0.00023161839635577053, -0.07425976544618607, -0.0166693776845932, 0.007779951673001051,
    -0.04574483633041382, -0.1222514733672142, 0.0054280441254377365, 0.05484852194786072, -0.0006704170955345035, -0.04820704087615013, 0.04319843277335167, 0.019332941621541977,
    0.01984400674700737, -0.013003534637391567, 0.0010782325407490134, 0.02966189943253994, -0.10050907731056213, -0.048482827842235565, 0.03463469818234444, 0.15855494141578674,
    0.10328260064125061, -0.014160554856061935, -0.047204311937093735, -0.06587985157966614, -0.051444970071315765, 0.08253496885299683, 0.019081884995102882, -0.05729827284812927,
    0.03628414869308472, -0.03112335316836834, -0.03030049055814743, 0.14069229364395142, -0.03196583315730095, -0.029001381248235703, -0.037492137402296066, -0.012409727089107037,
    -0.02060963399708271, -0.037666983902454376, 0.04946662113070488, -0.07894110679626465, 0.055130377411842346, -0.019342107698321342, 0.051558718085289, 0.0037039208691567183,
    -0.03866048902273178, -0.06490205228328705, 0.013756022788584232, 0.020491084083914757, 0.04620710015296936, 0.07371882349252701, -0.011095106601715088, -0.12162812799215317,
    0.01941535249352455, 0.05343250185251236, 0.09133323282003403, -0.012808210216462612, -0.04048559442162514, 0.06036375090479851, 0.04976240172982216, -0.03825901448726654,
    -0.03947778791189194, -0.11559607833623886, 0.015023494139313698, -0.0029808934777975082, -0.036283209919929504, -0.06066685542464256, 0.035501111298799515, 0.09462800621986389,
    -0.010805279947817326, 0.049960747361183167, -0.020695995539426804, 0.0533127635717392, -0.05537731572985649, 0.08796931803226471, 0.047602664679288864, -0.0015373786445707083,
    -0.0019654836505651474, -0.006029635202139616, -0.0035431659780442715, -0.04982699453830719, -0.05676999315619469, -0.026222245767712593, 0.018520327284932137, -0.06779799610376358,
    0.017809685319662094, -0.014609409496188164, 0.009738813154399395, -0.03610721975564957, 0.04042694717645645, 0.025928666815161705, -0.07719234377145767, -0.029819630086421967,
    0.01674969494342804, 0.05930952727794647, 0.14768408238887787, -0.028137262910604477, 0.0032858415506780148, 0.05440160632133484, -0.012860743328928947, -0.08638902008533478,
    0.019154459238052368, 0.07780060917139053, -0.19394294917583466, -0.07644952088594437, 0.04416443407535553, -0.01426544226706028, -0.0011956283124163747, 0.04003322497010231,
    0.030738912522792816, -0.09206674247980118, 0.09796956181526184, -0.0368843749165535, 0.09384079277515411, 0.044773586094379425, -0.04714098200201988, 0.042700815945863724,
    0.029683563858270645, 0.050070736557245255, -0.0222953911870718, 0.01981227844953537, -0.009582719765603542, -0.020441114902496338, 0.10676711052656174, 0.08738914877176285,
    -0.025931116193532944, 0.04879605025053024, -0.03923998028039932, 0.08365806192159653, -0.03551792353391647, -0.030743995681405067, 0.03884242847561836, -0.0029738307930529118,
    -0.1390107423067093, -0.053480539470911026, -0.01212460920214653, 0.034318696707487106, 0.003977293614298105, -0.08686483651399612, 0.03283232823014259, 0.0031537460163235664,
    -0.041289836168289185, -0.017889833077788353, 0.06869379431009293, -0.04214341938495636, -0.021992355585098267, -0.02326958440244198, -0.03477159142494202, -0.18299491703510284,
    0.01645135134458542, 0.07084342837333679, 0.04331875592470169, 0.0638965368270874, -0.04920131713151932, 0.02389070950448513, -0.038692280650138855, -0.028102628886699677,
    -0.014881597831845284, 0.07253390550613403, -0.026818929240107536, -0.013608446344733238, 0.02754678949713707, -0.025711921975016594, 0.10711555927991867, 0.016390210017561913,
    0.03833124041557312, 0.006548665463924408, 0.008605489507317543, 0.03446388989686966, 0.015655625611543655, 0.055960748344659805, 0.07984103262424469, 0.008767452090978622,
    -0.09054151177406311, 0.02690497599542141, -0.05714326724410057, -0.07473871111869812, 0.08223476260900497, -0.015143959783017635, 0.03376785293221474, -0.027317792177200317,
    -0.0013321754522621632, 0.011152535676956177, -0.0541783906519413, 0.01427940372377634, 0.0400596559047699, -0.02458520606160164, 0.08892039954662323, 0.029571134597063065,
    -0.05472744628787041, 0.08640791475772858, 0.01707649417221546, 0.04302108660340309, 0.01670142076909542, 0.019829025492072105, -0.055783044546842575, 0.07242114096879959,
    0.017613699659705162, -0.024019237607717514, -0.02457757294178009, -0.028925692662596703, -0.023781275376677513, -0.01724379137158394, -0.04758365824818611, 0.06387622654438019,
    -0.037397146224975586, -0.0385839007794857, -0.011793348006904125, -0.04381360113620758, -0.00721766147762537, -0.03367427736520767, 0.03871907666325569, 0.0629502460360527,
    -0.034022387117147446, -0.0313849002122879, -0.03393377736210823, -0.05071667581796646, 0.010681546293199062, 0.026061780750751495, 0.13778012990951538, 0.04760349914431572,
    -0.025732723996043205, 0.08381945639848709, -0.1774185448884964, 0.004322698339819908, 0.07994435727596283, -0.010599087923765182, 0.048072315752506256, 0.045485083013772964,
    0.003468794282525778, 0.010708699934184551, -0.01669176295399666, 0.005352841690182686, 0.025190426036715508, -0.048476818948984146, -0.014473196119070053, -0.008681925013661385,
    0.06665296852588654, 0.04486335813999176, 0.024030577391386032, -0.011821608059108257, -0.05715271458029747, 0.011842189356684685, -0.021887127310037613, 0.12342951446771622,
    -0.03242802619934082, 0.030027087777853012, -0.0720621719956398, -0.01618322543799877, -0.058244045823812485, -0.03314631059765816, -0.021305860951542854, 0.026914536952972412,
    -0.012698676437139511, 0.028096362948417664, -0.06395462155342102, 0.021914105862379074, -0.0005552893853746355, 0.04295043274760246, 0.05662417411804199, 0.01711243949830532,
    0.0535874180495739, -0.03641323000192642, -0.02265181578695774, -0.06147398427128792, 0.023781608790159225, 0.003946960903704166, 0.05975862219929695, -0.03543228656053543,
    0.017492884770035744, -0.09147700667381287, -0.031093211844563484, 0.010492511093616486, 0.03127426281571388, 0.019501540809869766, 0.008275911211967468, 0.10941905528306961,
    -0.024418458342552185, -0.1104743480682373, -0.029630720615386963, -0.02874126099050045, -0.00456124497577548, 0.17112942039966583, -0.037035491317510605, 0.019720477983355522,
    0.014196590520441532, -0.07783505320549011, 0.0017703577177599072, 0.07001850008964539, 0.04446801543235779, -0.06377042829990387, -0.009423854760825634, -0.027607154101133347,
    0.05458305403590202, -0.02752564288675785, 0.08609229326248169, -0.03908475115895271, -0.09283173829317093, -0.030968906357884407, 0.03724675253033638, 0.023793496191501617,
    -0.07326091825962067, 0.002524735638871789, -0.0422004796564579, -0.058590251952409744, -0.02502378262579441, -0.07462949305772781, -0.13933348655700684, 0.08714628219604492,
    -0.0462801419198513, 0.08003456145524979, 0.04352080076932907, 0.05155721679329872, -0.028048794716596603, 0.0473153255879879, 0.10742419213056564, 0.02060750499367714,
    0.04925026372075081, -0.06623152643442154, 0.029590710997581482, -0.007928848266601562, 0.07099445164203644, -0.03216532617807388, 0.02752886712551117, -0.008263780735433102,
    0.12191130965948105, 0.0368182472884655, 0.027464617043733597, -0.16588447988033295, -0.08567550033330917, 0.042355217039585114, 0.041778936982154846, -0.02131453901529312,
    -0.03208652138710022, -0.031343743205070496, -0.1178031861782074, -0.04968470335006714, -0.05618780106306076, -0.0715467557311058, -0.029725296422839165, 0.03817211091518402,
    -0.05785297229886055, -0.04455329105257988, -0.005008256994187832, 0.08768557757139206, 0.0030848567839711905, -0.005100995767861605, 0.07633981853723526, -0.013078116811811924,
    -0.0165872722864151, 0.15343496203422546, 0.14972923696041107, -0.002002331195399165, 0.03978557512164116, -0.02625083364546299, 0.08633249998092651, 0.006811428349465132,
    -0.02395612932741642, -0.0775483101606369, -0.017664844170212746, 0.03376078978180885, -0.006039224565029144, 0.03399275988340378, 0.10787015408277512, -0.005391462706029415,
    -0.030596613883972168, -0.030135169625282288, 0.04630820453166962, 0.004374878015369177, -0.008518396876752377, 0.10492869466543198, -0.07385167479515076, 0.03542587533593178,
    0.03889383003115654, -0.04007360339164734, -0.0711435005068779, -0.038714710623025894, -0.01674766093492508, -0.01005061250180006, -0.021268771961331367, -0.007910036481916904,
    0.006662519183009863, 0.005779268220067024, -0.07437798380851746, 0.040788523852825165, -0.00039898621616885066, -0.001912782434374094, 0.024649305269122124, -0.051551658660173416,
    -0.01202421635389328, 0.0659051164984703, 0.038472000509500504, 0.038214072585105896, -0.02835368551313877, -0.058088429272174835, -0.042821213603019714, -0.01656443253159523,
    -0.037517208606004715, -0.027644718065857887, 0.0037858043797314167, -0.03664617985486984, -0.023696616291999817, 0.011575696058571339, 0.04754338413476944, 0.05169101804494858,
    0.062394123524427414, -0.029748691245913506, 0.05950625240802765, -0.07417123019695282, 0.04029219597578049, -0.0431705079972744, -0.005191910080611706, 0.029394742101430893,
    -0.002210005186498165, 0.03295549005270004, -0.010838552378118038, 0.048450667411088943, -0.03986086696386337, 0.004373803269118071, 0.03020448237657547, 0.031575389206409454,
    0.04927779361605644, 0.024956777691841125, -0.10750768333673477, -0.0334639698266983, 0.026773234829306602, -0.056264735758304596, 0.008413092233240604, 0.05724584311246872,
    -0.03307482227683067, -0.010418129153549671, -0.07477772980928421, -0.10313430428504944, 0.07246892154216766, -0.0047893160954117775, -0.03611598163843155, -0.09626112133264542,
    0.024093791842460632, -0.026882154867053032, 0.015479563735425472, 0.03503073751926422, 0.04440378397703171, 0.005184678360819817, 0.049037761986255646, 0.020563025027513504,
    0.03417181223630905, 0.046726033091545105, 0.0642903670668602, 0.023955699056386948, -0.08037345856428146, -0.03729032725095749, 0.03799714893102646, -0.05347692593932152,
    -0.047946710139513016, -0.023719513788819313, -0.05010561645030975, 0.05444178730249405, -0.019923334941267967, 0.017004946246743202, 0.0136349992826581, 0.04172775521874428,
    0.0977022796869278, -0.0041335043497383595, -0.03380541130900383, -0.038322363048791885, -0.025933125987648964, 0.037971701472997665, 0.03275999799370766, -0.024131441488862038,
    0.015364757739007473, -0.10589531064033508, 0.003851630724966526, -0.12193921208381653, 0.010023369453847408, -0.013366476632654667, 0.03420552238821983, 0.056894849985837936,
    0.019605789333581924, -0.030241167172789574, -0.16886714100837708, -0.03961249813437462, 0.018468650057911873, -0.1043659970164299, -0.02408681809902191, -0.020315375179052353,
    -0.036689311265945435, 0.006063866429030895, 0.022344643250107765, 0.0015095222042873502, -0.059803906828165054, 0.08700797706842422, -0.028208820149302483, 0.013410814106464386,
    -0.01922089233994484, -0.012897360138595104, 0.017599130049347878, -0.013311241753399372, -0.11028233170509338, 0.010601785033941269, 0.006128267850726843, 0.08326743543148041,
    -0.005661594215780497, -0.03824754059314728, 0.021877868101000786, -0.02411271631717682, 0.0011552817886695266, -0.10376547276973724, -0.027782157063484192, 0.08053053915500641,
    -0.048116520047187805, 0.05450568348169327, -0.014975479803979397, 0.08665455877780914, 0.11553147435188293, 0.09915351122617722, 0.04522796720266342, -0.006349784322082996,
    0.014248888939619064, -0.07161733508110046, 0.061583511531353, 0.05420470982789993, 0.009812770411372185, -0.04982220008969307, 0.005854669958353043, -0.040351804345846176,
    0.017771555110812187, -0.08306320756673813, 0.025574300438165665, 0.0068033915013074875, 0.06368514150381088, 0.010295474901795387, 0.03985682502388954, -0.18449808657169342,
    -0.09070630371570587, 0.060095060616731644, -0.015688566491007805, 0.08315911889076233, 0.03837038576602936, -0.015423698350787163, -0.016559496521949768, -0.04432186856865883,
    -0.03857435658574104, -0.10296332836151123, -0.09512137621641159, -0.0665186196565628, 0.024769233539700508, -0.005274985451251268, 0.06516070663928986, -0.03025163523852825,
    0.09745953977108002, 0.1241811215877533, 0.014628353528678417, -0.01805143803358078, 0.031028468161821365, 0.039912451058626175, 0.06022582948207855, -0.03818083181977272,
    -0.0027370466850697994, 0.05132325366139412, 0.006883182097226381, 0.0026149724144488573, -0.004157213028520346, 0.029543200507760048, -0.011320489458739758, -0.051514431834220886,
    0.022740613669157028, 0.007906576618552208, 0.05485878512263298, 0.03942194953560829, 0.04069394990801811, 0.08825064450502396, 0.09825431555509567, -0.07340320944786072,
    0.00621172646060586, 0.0776403620839119, -0.025755515322089195, -0.018633143976330757, 0.06821485608816147, -0.05410871282219887, -0.08809603750705719, -0.00363055313937366,
    0.05141918733716011, -0.0031383251771330833, -0.025881391018629074, 0.022253241389989853, -0.0553080290555954, 0.04804661124944687, -0.05024591460824013, -0.023212211206555367,
    0.06309490650892258, -0.024804409593343735, 0.07797237485647202, -0.03659558668732643, 0.016320504248142242, -0.13108405470848083, -0.006530403159558773, -0.09694505482912064,
    -0.010649248026311398, -0.1210908368229866, -0.005171637982130051, 0.008802234195172787, 0.03489990904927254, 0.01850794441998005, -0.03099570982158184, -0.029727753251791,
    0.032193057239055634, 0.1348547786474228, 0.1299269050359726, -0.06668009608983994, -0.04328073188662529, 0.06638195365667343, 0.03365568444132805, 0.042718853801488876,
    -0.03585217893123627, 0.0008478887029923499, 0.03210088983178139, 0.04938770458102226, -0.03211059421300888, 0.09539318084716797, -0.0011469785822555423, 0.01551220752298832,
    0.1244477927684784, -0.015041815117001534, 0.06515519320964813, -0.053365983068943024, -0.04212116077542305, -0.06226411461830139, 0.10779981315135956, -0.03967539593577385,
    -0.016274703666567802, 0.037027496844530106, 0.03756386786699295, -0.016058819368481636, 0.021233657374978065, 0.06162435933947563, -0.09771579504013062, 0.1202859878540039,
    0.032862305641174316, 0.05160799250006676, -0.005741209723055363, 0.04636817425489426, -0.010271630249917507, 0.04132769629359245, -0.018626807257533073, 0.0038536975625902414,
    -0.06613440811634064, -0.023007823154330254, -0.00698433630168438, -0.07347928732633591, 0.004380061756819487, -0.053098034113645554, -0.03042621538043022, -0.07668130099773407,
    0.024242866784334183, -0.08707106113433838, 0.014965148642659187, 0.004702012985944748, 0.022992616519331932, -0.02484261989593506, 0.0014741455670446157, 0.20958790183067322,
    0.12953977286815643, 0.015785852447152138, -0.0768532007932663, -0.10482136905193329, -0.02372506819665432, -0.039532650262117386, -0.02990332804620266, -0.019929882138967514,
    0.043256230652332306, -0.014248059131205082, 0.030040496960282326, 0.021701179444789886, 0.04132269322872162, -0.07952369004487991, 0.043767049908638, -0.026102064177393913,
    -0.04179597273468971, 0.06707360595464706, 0.07754357159137726, -0.0002603745961096138, -0.01864793337881565, -0.030854469165205956, -0.05002138018608093, 0.0882076695561409,
    -0.05664664879441261, -0.06921035796403885, -0.0743352398276329, 0.009218848310410976, -0.10316432267427444, 0.048957448452711105, 0.013716788031160831, 0.017889464274048805,
    0.011728005483746529, 0.08386999368667603, -0.02885049767792225, -0.025677012279629707, -0.03969510272145271, 0.0151961799710989, 0.08812376856803894, -0.010327459312975407,
    -0.054278627038002014, -0.04246574640274048, 0.15380705893039703, 0.013393196277320385, -0.014138685539364815, -0.013880372978746891, 0.056606799364089966, -0.021571869030594826,
    -0.03556348383426666, 0.010809849947690964, -0.028995119035243988, -0.014003144577145576, -0.015161399729549885, 0.06757964938879013, 0.0658114030957222, -0.03626040741801262,
    -0.11148104816675186, -0.02100725658237934, -0.06592431664466858, -0.06284680962562561, -0.004597293678671122, -0.018672918900847435, -0.04420683532953262, 0.0647020936012268,
    -0.009461093693971634, -0.07314877957105637, -0.04094697907567024, -0.08986937999725342, 0.06116063892841339, 0.06659014523029327, -0.0007168379379436374, 0.08099927008152008,
    -0.006863438989967108, 0.04465581476688385, -0.1340063065290451, 0.023455286398530006, -0.05974488705396652, -0.10065838694572449, -0.0001237534306710586, 0.01032978668808937,
    -0.07543616741895676, -0.02504301443696022, 0.0069534871727228165, 0.022917238995432854, 0.023712243884801865, 0.05458952486515045, -0.06529166549444199, 0.07672020047903061,
    0.0386970154941082, 0.012887511402368546, 0.022720476612448692, -0.0324869230389595, 0.0242503359913826, -0.06774580478668213, -0.04799960181117058, -0.03426812216639519,
    0.0074331690557301044, -0.026405688375234604, 0.07973694801330566, 0.047537676990032196, -0.03364909067749977, -0.02286660671234131, -0.04368862882256508, 0.12071883678436279,
    -0.0032318304292857647, -0.000802433118224144, -0.023547932505607605, -0.021367622539401054, 0.06071042641997337, 0.06923873722553253, -0.049629587680101395, -0.02161415107548237,
    0.0708584114909172, 0.07159387320280075, -0.06835472583770752, 0.05759907141327858, -0.004540936090052128, -0.056078385561704636, -0.01895463652908802, 0.025266369804739952,
    0.013338498771190643, -0.081101194024086, -0.008894586004316807, -0.006782725919038057, -0.023932622745633125, 0.06849386543035507, 0.016977809369564056, -0.11208166927099228,
    -0.10577990859746933, -0.11495745182037354, 0.03059890680015087, -0.08258563280105591, -0.06341227144002914, -0.009821568615734577, -0.08763597160577774, 0.00531827611848712,
    0.0006516544963233173, -0.0005853468901477754, 0.0485704131424427, -0.033540237694978714, 0.04149001091718674, -0.034569259732961655, 0.06414651870727539, -0.02962985634803772,
    0.0303202997893095, 0.008581629022955894, 0.07283619046211243, 0.023869574069976807, -0.09406807273626328, -0.12329134345054626, 0.04000348225235939, 0.06468964368104935,
    -0.03330661356449127, 0.056254491209983826, 0.068636953830719, 0.00026413373416289687, 0.06992653757333755, -0.005928833968937397, 0.03726154938340187, -0.019245363771915436,
    -0.012503827922046185, 0.025027446448802948, 0.004478264134377241, -0.03183826804161072, -0.029346350580453873, -0.003873099572956562, 0.0519803911447525, 0.06172547489404678,
    -0.11343509703874588, -0.009459815919399261, -0.07419952750205994, 0.035250917077064514, 0.0870257094502449, -0.03583468124270439, 0.026369955390691757, 0.007721395697444677,
    -0.07043706625699997, -0.06617783010005951, -0.01620844379067421, -0.12408377975225449, 0.0038251159712672234, -0.05577000230550766, 0.006584903225302696, -0.0006019980064593256,
    -0.04303446784615517, 0.04028034955263138, 0.019220620393753052, -0.03476153686642647, 0.1268637329339981, -0.033776357769966125, -0.06943817436695099, 0.023540087044239044,
    -0.012102277018129826, 0.004170921631157398, 0.03648607060313225, -0.054816439747810364, -0.024579182267189026, 0.010514937341213226, 0.03517744317650795, -0.09808294475078583,
    -0.04962556064128876, 0.06472580134868622, 0.05976045876741409, -0.038636766374111176, 0.05645156279206276, -0.06171618774533272, 0.03281800448894501, -0.002606584457680583,
    -0.012512553483247757, 0.008358079008758068, 0.060572851449251175, 0.00363473710604012, -0.03161894530057907, 0.11083943396806717, 0.016809435561299324, 0.02796950377523899,
    -0.009886814281344414, -0.06981120258569717, 0.022631874307990074, 0.08542375266551971, -0.09227437525987625, 0.02890847809612751, 0.031502798199653625, -0.012087509967386723,
    -0.03143493831157684, -0.07480235397815704, 0.11405263841152191, -0.013199427165091038, 0.03109462931752205, -0.08878850936889648, -0.11074677109718323, 0.05341882258653641,
    -0.02335388958454132, -0.005092079285532236, 0.034990034997463226, 0.07209637016057968, -0.06774049997329712, 0.02535540983080864, 0.029102569445967674, -0.020146215334534645,
    -0.05365872383117676, 0.0555025190114975, 0.03417866677045822, -0.07752425968647003, -0.02401345781981945, -0.04377492144703865, 0.03552732989192009, -0.10286252200603485,
    -0.06845465302467346, 0.02557394467294216, -0.060700319707393646, -0.006151093170046806, 0.012452738359570503, -0.0014230250380933285, -0.0009237860213033855, 0.005594732239842415,
    0.0903993472456932, 0.046719156205654144, 0.08024873584508896, 0.14189258217811584, -0.016092265024781227, -0.036511749029159546, -0.042334068566560745, 0.0396822951734066,
    -0.0037733400240540504, 0.008012180216610432, 0.004561633337289095, 0.02696846053004265, 0.012605654075741768, -0.017695346847176552, -0.0306593868881464, -0.04778701812028885,
    -0.05259290710091591, 0.06677968800067902, 0.006198645569384098, 0.05060134083032608, -0.007276154588907957, 0.02729371190071106, 0.016301024705171585, 0.06589511036872864,
    -0.07256777584552765, -0.001344083109870553, -0.033500976860523224, -0.05771264061331749, -0.0025575135368853807, -0.09917125105857849, 0.05286501720547676, 0.005706751253455877,
    0.047503747045993805, 0.05831048637628555, 0.054364800453186035, -0.0165102556347847, 0.034399524331092834, -0.05035910755395889, -0.06348567456007004, -0.04294382035732269,
    -0.17339925467967987, 0.07383622229099274, 0.08450859040021896, 0.025672588497400284, 0.11782810837030411, 0.04383227229118347, -0.016587404534220695, 0.04276546090841293,
    0.08911886811256409, -0.028085336089134216, -0.005910482257604599, 0.0020898832008242607, -0.011237071827054024, -0.03963116928935051, -0.05272333323955536, 0.007053975015878677,
    0.0335589237511158, -0.03278770670294762, -0.0009102023905143142, -0.03425029292702675, 0.06647360324859619, 0.008317005820572376, 0.0664169043302536, 0.08021505922079086,
    -0.05431064963340759, 0.08295078575611115, 0.002312204334884882, -0.09143003076314926, -0.06260110437870026, 0.034179653972387314, 0.04211026057600975, 0.05256980285048485,
    0.030983304604887962, -0.029378408566117287, 0.00833637360483408, 0.03505510091781616, 0.13474014401435852, -0.04906868934631348, -0.0534890852868557, 0.03254158794879913,
    -0.005793738178908825, 0.01259227842092514, -0.09825897961854935, 0.00031230883905664086, 0.015449942089617252, 0.11554738879203796, -0.022026346996426582, -0.039554327726364136,
    0.04206318408250809, 0.10122901201248169, -0.06619922816753387, -0.05042870342731476, -0.03831770271062851, -0.09915721416473389, -0.03437959775328636, -0.06909900158643723,
    -0.0037119186017662287, 0.019332684576511383, 0.09639031440019608, -0.010322201065719128, -0.007046108599752188, 0.08593201637268066, -0.05721992254257202, -0.021343359723687172,
    -0.021983249112963676, 0.07190979272127151, 0.024912048131227493, -0.04316125437617302, 0.0409720353782177, 0.13546383380889893, 0.007242222782224417, 0.06613948196172714,
    -0.030971435829997063, 0.105283722281456, -0.058207523077726364, 0.0019251302583143115, 0.022758977487683296, -0.025048410519957542, -0.05717749521136284, -0.047734085470438004,
    0.050953470170497894, -0.02708297222852707, 0.07973802089691162, -0.0390058271586895, -0.05577985942363739, 0.09054236114025116, -0.03665363788604736, 0.05364285781979561,
    0.05097370594739914, -0.026849862188100815, 0.1093495786190033, -0.08443993330001831, 0.008579316549003124, 0.0452604815363884, -0.06171467900276184, 0.02533761039376259,
    -0.0238020196557045, 0.05451783537864685, 0.000932557974010706, 0.059012629091739655, -0.11214440315961838, -0.07749374955892563, 0.013998294249176979, 0.053993452340364456,
    -0.00591112207621336, 0.07057856023311615, 0.05527224764227867, 0.14622382819652557, -0.016848154366016388, -0.07927680760622025, -0.03914545103907585, 0.04043468087911606,
    -0.10324309021234512, -0.017666518688201904, 0.033319421112537384, -0.05160936713218689, 0.04653362184762955, -0.034869007766246796, -0.005349603947252035, 0.04076644778251648,
    -0.029448706656694412, 0.056159451603889465, -0.02514026314020157, -0.05297110229730606, -0.06465962529182434, -0.01748392917215824, -0.010540085844695568, -0.023207390680909157,
    -0.05047743767499924, -0.12335871160030365, 0.10043072700500488, -0.03332044556736946, 0.00404599541798234, -0.006803684402257204, 0.0026992515195161104, 0.020271893590688705,
    -0.08847086876630783, -0.04238594323396683, -0.00042136447154916823, 0.014583118259906769, -0.0480448454618454, -0.049125444144010544, 0.03628775104880333, 0.003535693511366844,
    0.021788299083709717, 0.0030216583982110023, 0.015493419021368027, 0.007943595759570599, -0.026843661442399025, -0.07935438305139542, -0.027646958827972412, -0.04593603312969208,
    -0.1310158222913742, 0.03791336715221405, -0.05942186340689659, -0.044826727360486984, -0.012324743904173374, -0.014732012525200844, -0.02221573330461979, -0.060482971370220184,
    0.043063823133707047, 0.04499496892094612, -0.06175808236002922, -0.009161458350718021, -0.07332152873277664, -0.05687512457370758, 0.021898986771702766, -0.049801651388406754,
    -0.026817072182893753, -0.028679585084319115, 0.016164399683475494, -0.068409264087677, 0.013668278232216835, -0.035087406635284424, 0.033707648515701294, 0.03062376193702221,
    0.0009547345107421279, -0.053656164556741714, -0.024013111367821693, 0.06730399280786514, 0.02602943778038025, -0.012992577627301216, -0.04798191413283348, -0.020319072529673576,
    -0.05162510648369789, -0.024589089676737785, 0.029628412798047066, -0.020734217017889023, 0.007700878195464611, -0.07497064769268036, -0.11507798731327057, 0.14239779114723206,
    -0.03295418620109558, 0.012775205075740814, 0.06728983670473099, 0.03515252470970154, -0.03304457291960716, 0.027344949543476105, -0.08499416708946228, -0.03158532455563545,
    0.0029775197617709637, 0.09271156042814255, 0.03272783011198044, 0.06230910122394562, 0.024300673976540565, -0.06918517500162125, 0.0276201032102108, -0.044114600867033005,
    -0.007030769716948271, 0.053073931485414505, 0.05459938943386078, 0.0113459387794137, 0.07902988791465759, -0.007374725770205259, -0.0425921268761158, -0.12591588497161865,
    0.03424593806266785, 0.04636085033416748, -0.040635962039232254, -0.12057717889547348, 0.08830735087394714, -0.09911560267210007, -0.009080439805984497, -0.012990626506507397,
    0.013658448122441769, -0.07342703640460968, 0.007514582015573978, 0.018304338678717613, -0.019917460158467293, -0.022789396345615387, -0.048918697983026505, -0.018289271742105484,
    -0.04168644919991493, 0.01769573986530304, 0.07769283652305603, 0.012888443656265736, 0.11282142251729965, 0.026203209534287453, -0.04607732221484184, 0.027389084920287132,
    0.0486283078789711, 0.014062298461794853, 0.005726065021008253, -0.07180513441562653, -0.05563341826200485, 0.22220586240291595, 0.001622751820832491, -0.02673337049782276,
    0.05177957937121391, 0.08925988525152206, -0.10678933560848236, 0.02395213395357132, -0.03822031989693642, -0.07782444357872009, -0.015279378741979599, 0.02854561246931553,
    0.04445669427514076, 0.0707789808511734, 0.030851276591420174, -0.012248161248862743, 0.021328266710042953, 0.09464111924171448, -0.04414794221520424, -0.008351096883416176,
    -0.006383908912539482, -0.06706441938877106, 0.025924332439899445, -0.0012201007921248674, 0.030469125136733055, 0.006843547336757183, -0.007977070286870003, -3.450651638559066e-05,
    0.08062256872653961, -0.0066099571995437145, 0.07573536783456802, 0.009566175751388073, -0.018984928727149963, -0.015581957064568996, -0.01081504300236702, 0.02512257918715477,
    0.0959177166223526, 0.02416406199336052, 0.025972478091716766, -0.09866312146186829, 0.0351853147149086, -0.06058895215392113, 0.016851630061864853, 0.037197262048721313,
    -0.011057676747441292, 0.09831999987363815, 0.09087828546762466, 0.024488572031259537, -0.01327388547360897, -0.07622243463993073, 0.023776793852448463, 0.04638522118330002,
    -0.025977618992328644, 0.020720401778817177, 0.06109003350138664, 0.039445921778678894, 0.0031943805515766144, -0.15179890394210815, -0.06370525807142258, 0.010967908427119255,
    -0.00038310466334223747, 0.011730333790183067, -0.0026287671644240618, 0.10290404409170151, -0.0013100375654175878, 0.050437863916158676, 0.04301159083843231, 0.04906481131911278,
    -0.02712167240679264, 0.03990809619426727, 0.0763261616230011, 0.023275231942534447, 0.0033122417517006397, -0.017055250704288483, 0.013118203729391098, 0.027395173907279968,
    0.009759458713233471, 0.05649691820144653, -0.0286002978682518, -0.0685335099697113, -0.02110631763935089, -0.012626996263861656, 0.017322193831205368, -0.02112915739417076,
    -0.14088445901870728, -0.014551764354109764, 0.13355037569999695, -0.027427732944488525, -0.00929971132427454, 0.026674266904592514, -0.011550325900316238, -0.04402416944503784,
    0.023704098537564278, 0.057356130331754684, -0.04025043547153473, -0.01672184281051159, 0.04996522516012192, 0.017823295667767525, -0.00013657078670803457, 0.21043850481510162,
    0.13587629795074463, -0.0513509102165699, 0.01760210655629635, 0.1279403120279312, -0.04127948358654976, 0.005276297219097614, -0.024666307494044304, -0.012243316508829594,
    0.01888619177043438, -0.04198595881462097, -0.015766091644763947, 0.07013945281505585, -0.024248363450169563, 0.01898818649351597, -0.1308034360408783, 0.010676246136426926,
    -0.017310693860054016, 0.07625532150268555, 0.07317260652780533, -0.04604126140475273, -0.052186038345098495, -0.022995728999376297, 0.09375640749931335, 0.026457341387867928,
    -0.0026285613421350718, -0.026571674272418022, -0.027881070971488953, 0.001478508929722011, -0.03291260078549385, 0.12869073450565338, 0.021820582449436188, -0.042003508657217026,
    0.0035474386531859636, -0.022972347214818, -0.027153896167874336, -0.09988526254892349, -0.05364948511123657, -0.02884819731116295, 0.023532720282673836, 0.061803750693798065,
    0.1302025020122528, -0.08513130247592926, 0.00702297268435359, 0.03204694017767906, 0.032800376415252686, -0.041508473455905914, -0.013725843280553818, -0.062380146235227585,
    0.11745008826255798, 0.0341193787753582, -0.019329726696014404, -0.11242011189460754, 0.028567848727107048, 0.04301706328988075, -0.048380088061094284, 0.059716567397117615,
    0.028088295832276344, -0.020450320094823837, 0.029868120327591896, -0.010459678247570992, 0.08208823949098587, -0.0166542399674654, -0.03504209220409393, 0.02578667178750038,
    -0.006983403116464615, 0.12520447373390198, -0.09826450794935226, -0.101387619972229, -0.04321059584617615, 0.09220308810472488, 0.0876859799027443, 0.00906385574489832,
    0.004339839797466993, -0.0071457610465586185, -0.03288985788822174, 0.033718518912792206, 0.03527657687664032, -0.03882840275764465, -0.05612638592720032, -0.01626601442694664,
    0.045174870640039444, -0.08228442072868347, -0.09374192357063293, 0.02326027862727642, 0.011213231831789017, -0.07451852411031723, 0.05859905853867531, -0.014800463803112507,
    0.016986416652798653, -0.027009032666683197, -0.027327047660946846, 0.0088966004550457, -0.07733109593391418, 0.01783841662108898, 0.023406632244586945, -0.0070718321949243546,
    0.016251640394330025, -0.07521986961364746, 0.032361648976802826, 0.0360129289329052, 0.03559267148375511, -0.02651672251522541, 0.06498588621616364, 0.005617359187453985,
    0.008343085646629333, 0.044808074831962585, 0.0002202839677920565, 0.0030889399349689484, -0.011293387040495872, 0.05129768326878548, 0.04112764820456505, -0.06097230687737465,
    -0.047808825969696045, 0.040862977504730225, -0.05978037044405937, 0.00998455099761486, 0.007838881574571133, -0.032326504588127136, -0.02668493241071701, -0.004912324249744415,
    -0.009682604111731052, 0.033331070095300674, -0.0036798471119254827, 0.008986852131783962, -0.04410963132977486, -0.024219589307904243, -0.025155335664749146, 0.0130620077252388,
    -0.03720371797680855, 0.0038967824075371027, 0.05668768286705017, 0.0148536441847682, 0.024536671116948128, 0.0025843812618404627, 0.07622694969177246, -0.035142987966537476,
    0.03199606388807297, 0.015332639217376709, -0.02760908752679825, 0.009889165870845318, 0.02372654527425766, 0.02049650065600872, 0.02310834266245365, 0.021072223782539368,
    0.037474293261766434, 0.013302246108651161, -0.064595527946949, 0.03985394164919853, 0.0017292894190177321, 0.024987420067191124, -0.08849075436592102, 0.020989365875720978,
    -0.07484731078147888, 0.004267924930900335, -0.051869262009859085, -0.04607795923948288, -0.007745701819658279, 0.03481126204133034, 0.027500469237565994, -0.016633011400699615,
    -0.00207629450596869, -0.09084080159664154, -0.06887903809547424, 0.03216942399740219, 0.05581517145037651, -0.05140441656112671, -0.012519096955657005, 0.06849627941846848,
    -0.048969149589538574, -0.022513339295983315, -0.07823986560106277, -0.07342679053544998, -0.0784403458237648, -0.06525196135044098, -0.0376187302172184, 0.02428257279098034,
    0.005298982374370098, 0.03686584532260895, -0.03805163502693176, 0.01920895464718342, 0.022740095853805542, -0.07298039644956589, -0.0001959873625310138, -0.0030882940627634525,
    0.026839911937713623, 0.02999093383550644, 0.03889481723308563, 0.022057639434933662, -0.008447784930467606, -0.012288234196603298, 0.05151019245386124, -0.01495110522955656,
    0.030048701912164688, -0.04338560253381729, -0.050417281687259674, -0.06738800555467606, 0.04489422217011452, -0.021222909912467003, 0.008053782396018505, 0.027879012748599052,
    0.00483158091083169, -0.042133815586566925, -0.028453024104237556, 0.014848913066089153, 0.055790454149246216, 0.0058092097751796246, 0.01569758541882038, -0.005256636533886194,
    0.009768498130142689, 0.0038203271105885506, -0.08678460121154785, 0.010957635939121246, 0.010283084586262703, -0.04498925805091858, 0.03319650515913963, -0.01342485100030899,
    0.040266405791044235, -0.013510260730981827, -0.006948149297386408, 0.019912611693143845, 0.08003212511539459, -0.02127494290471077, 0.03797614574432373, -0.026585381478071213,
    0.07041279971599579, -0.02467821165919304, -0.012957270257174969, 0.03323560580611229, -0.00436032097786665, 0.03596224635839462, 0.015263604000210762, 0.017775636166334152,
    0.011156465858221054, 0.023318612948060036, 0.010734474286437035, -0.015966903418302536, -0.01573755405843258, 0.0016702678985893726, 0.03998401761054993, -0.023245953023433685,
    -0.019518885761499405, 0.03091399557888508, -0.06353304535150528, -0.01617688313126564, 0.012202098034322262, -0.025850888341665268, 0.009410268627107143, 0.07028813660144806,
    -0.0012829178012907505, 0.02755480259656906, 0.03933090344071388, -0.011944741010665894, -0.059357039630413055, 0.013798680156469345, -0.019477898254990578, -0.04591076448559761,
    0.0265369676053524, -0.0020826959516853094, 0.02807396836578846, -0.0075984313152730465, 0.012735430151224136, -0.05111589655280113, 0.030171243473887444, -0.015008033253252506,
    0.04077023267745972, -0.005470608826726675, 0.0062407017685472965, -0.024883128702640533, 0.05134114623069763, -0.01897766813635826, -0.02414127252995968, 0.05487750098109245,
    -0.020056894049048424, -0.0018347793957218528, -0.06857018172740936, 0.03833898529410362, -0.019012467935681343, 0.02853476256132126, -0.0072960685938596725, 0.007614961825311184,
    -0.08154378831386566, -0.008633279241621494, 6.778255919925869e-05, -0.027765510603785515, 0.05572344362735748, 0.018079547211527824, -0.027462607249617577, -0.034573428332805634,
    0.013664883561432362, -0.009952926076948643, -0.006668055430054665, -0.05459942668676376, 0.07858294993638992, 0.012361523695290089, 0.006001618225127459, 0.002054479205980897,
    -0.05112903565168381, -0.010581727139651775, -0.04737594351172447, -0.05739806219935417, -0.002274543046951294, -0.0049261911772191525, -0.015534283593297005, 0.0019035818986594677,
    -0.03078511171042919, 0.020898643881082535, -0.01664586178958416, 0.006828790530562401, 0.049746982753276825, -0.009795517660677433, -0.038813266903162, 0.052927229553461075,
    0.028714055195450783, 0.0328502357006073, 0.03443899005651474, 0.0030521773733198643, -0.005156269297003746, 0.023124927654862404, 0.005474676378071308, -0.037266407161951065,
    -0.03767331689596176, -0.0436713881790638, -0.01929856836795807, -0.037870921194553375, 0.06134491041302681, 0.050062742084264755, 0.0001150248062913306, -0.00425252690911293,
    -0.021415971219539642, -0.018690267577767372, -0.0017158066621050239, 0.01620529592037201, -0.027112752199172974, -0.02571990340948105, -0.001097827567718923, 0.029259590432047844,
    0.012604722753167152, -0.02761080488562584, -0.027270138263702393, -0.009301245212554932, 0.012746341526508331, -0.054318975657224655, 0.0014566021272912621, -0.02798748016357422,
    0.04047485813498497, -0.014484666287899017, -0.08202633261680603, 0.010240042582154274, 0.017626553773880005, 0.025151031091809273, -0.008038888685405254, -0.023933790624141693,
    0.031169919297099113, -0.011537650600075722, 0.01932554319500923, -0.007480214815586805, 0.03568018600344658, -0.02053256146609783, 0.003154042409732938, -0.007083880715072155,
    -0.02563563734292984, 0.00564016355201602, 0.019936438649892807, 0.0420781709253788, -0.004227390978485346, -0.047578658908605576, 0.02768004685640335, 0.035268355160951614,
    0.02206134982407093, -0.005416005849838257, 0.010768949054181576, 0.016227103769779205, 0.005116985645145178, 0.023212261497974396, -0.029271744191646576, -0.013277017511427402,
    0.02140280418097973, -0.02225181646645069, 0.03416163846850395, 0.01325598731637001, -0.04623149707913399, -0.016458377242088318, -0.009421287104487419, 0.0550210177898407,
    0.02503831684589386, -0.005873131100088358, -0.031000753864645958, 0.0020154633093625307, 0.035565104335546494, 0.03648829460144043, -0.02873102016746998, 0.04584228992462158,
    -0.04849978908896446, 0.07955273985862732, 0.030930843204259872, -0.001659852801822126, 0.00848870724439621, -0.0419364869594574, -0.020229626446962357, -0.012033394537866116,
    -0.014936869032680988, -0.03884073346853256, 0.007997625507414341, -0.06337568908929825, 0.03174963220953941, -0.016525687649846077, -0.011172892525792122, -0.0025880734901875257,
    -0.05936526879668236, 0.003443018766120076, 0.04288041591644287, -0.00759090343490243, -0.0321526862680912, 0.009004397317767143, 0.018222222104668617, 0.024245409294962883,
    0.02442253567278385, 0.07099716365337372, 0.04410398751497269, 0.02771654538810253, -0.03453628718852997, 0.011333184316754341, 0.010702895000576973, -0.05630699545145035,
    -0.047129180282354355, -0.01608704775571823, 0.012211925350129604, 0.03544902428984642, 0.027213312685489655, 0.057303428649902344, 0.028977325186133385, 0.07197757065296173,
    0.06064252555370331, -0.05482529103755951, -0.0036737367045134306, -0.012490304186940193, -0.004306386224925518, -0.008526284247636795, -0.0131992744281888, -0.012004567310214043,
    -0.019589750096201897, 0.004893203265964985, 0.023695215582847595, -0.0002566217735875398, -0.01719070039689541, -0.0011499739484861493, -0.005795456934720278, 0.048023421317338943,
    0.014305692166090012, 0.008705692365765572, -0.050775233656167984, 0.009808090515434742, -0.05994565412402153, 0.03273538500070572, -0.04825896769762039, 0.02793033979833126,
    -0.020959539338946342, 0.0013494474114850163, 0.01471676118671894, -0.04501921311020851, 0.046517372131347656, 0.019451115280389786, 0.05550632253289223, 0.0025186040438711643,
    0.007096779067069292, 0.003003836376592517, 0.0005025950376875699, -0.05347840487957001, 0.015361456200480461, -0.02823086641728878, -0.03391922637820244, -0.00618528900668025,
    0.016540002077817917, -0.028369810432195663, -0.020562078803777695, 0.06211782246828079, 0.023198679089546204, 0.0063384356908500195, -0.018005067482590675, -0.02651648037135601,
    0.04674561694264412, 0.023496286943554878, -0.0330083854496479, -0.005010867491364479, -0.001295256894081831, -0.05204794555902481, 0.005503620021045208, 0.00873705092817545,
    -9.61586702032946e-05, 0.01972135901451111, -0.03739108890295029, 0.003149908035993576, -0.0029766205698251724, 0.014920709654688835, 0.0025317061226814985, 0.023887407034635544,
    -0.04291076958179474, 0.0151733523234725, 0.006735482253134251, 0.029824860394001007, -0.028493069112300873, -0.015578113496303558, -0.040543075650930405, 0.017736593261361122,
    -0.05393999069929123, 0.007825752720236778, -0.027173228561878204, -0.0002721651690080762, -0.04417160525918007, 0.011753312312066555, -0.01356805581599474, -0.024950364604592323,
    0.015654902905225754, -0.028318557888269424, 0.014399157837033272, 0.017362942919135094, 0.02808579057455063, 0.04646088927984238, -0.004411691799759865, -0.03884662315249443,
    0.011712701991200447, -0.006483353208750486, 0.026465902104973793, 0.02597716450691223, 0.007382004987448454, 0.08065220713615417, 0.015169447287917137, 0.02442113496363163,
    0.006486581172794104, 0.024479590356349945, -0.044622864574193954, -0.020092669874429703, -0.01696697622537613, 0.01710953563451767, -0.03174300119280815, 0.03457466885447502,
    -0.036253686994314194, -0.012522634118795395, -0.06408466398715973, -0.017700115218758583, 0.06038267910480499, 0.0056417337618768215, 0.025206508114933968, 0.019203267991542816,
    -0.028045205399394035, 0.008339130319654942, 0.013218321837484837, 0.001624520169571042, 0.025664083659648895, -0.030259698629379272, -0.03516991809010506, 0.00915076956152916,
    0.005994265433400869, 0.025056054815649986, -0.027495374903082848, -0.027293384075164795, -0.009128190577030182, -0.1302504986524582, -0.013211348094046116, -0.025167660787701607,
    0.02569301426410675, 0.01109074056148529, 0.017436068505048752, 0.0006504939519800246, 0.029056865721940994, 0.01634129323065281, 0.020223230123519897, 0.0018631876446306705,
    0.04066389426589012, 0.013957041315734386, -0.05266065523028374, -0.007459028623998165, 0.004994003102183342, -0.01848086714744568, -0.019325992092490196, 0.038412097841501236,
    -0.029716499149799347, -0.011297842487692833, -0.011906756088137627, -0.013585511595010757, -0.0328851044178009, 0.03364146500825882, -0.001295318710617721, 0.03357360139489174,
    0.00045912896166555583, -0.02595360577106476, -0.028455590829253197, -0.0601983517408371, -0.005740365944802761, 0.0010430733673274517, 0.017929308116436005, -0.009071827866137028,
    -0.0004151912871748209, 0.03825479745864868, 0.02079014480113983, 0.016433769837021828, -0.005880482494831085, 0.021926412358880043, -0.023952428251504898, -0.04450865462422371,
    -0.024401037022471428, 0.029012531042099, -0.0159318745136261, 0.012784506194293499, 0.01555650494992733, -0.0302521251142025, -0.03711026906967163, -0.02676388993859291,
    -0.025566544383764267, 0.033698808401823044, -0.022232720628380775, -0.0035802978090941906, 0.051713816821575165, 0.05609690025448799, 0.014508510939776897, 0.034674227237701416,
    -0.002966460073366761, -0.006448420695960522, -0.035217031836509705, -0.03520669415593147, 0.017483914270997047, 0.01343566458672285, 0.014921994879841805, 0.00021041519357822835,
    -0.04897522181272507, 0.03040742501616478, -1.2757722288370132e-05, -0.025521615520119667, 0.026477981358766556, 0.02397978864610195, 0.050438329577445984, 0.024520359933376312,
    -0.02830391190946102, -0.012616662308573723, -0.007513049524277449, -0.007887285202741623, -0.03695414587855339, 0.016856608912348747, 0.001956556225195527, -0.053329046815633774,
    0.04747772961854935, 0.00879397988319397, -0.03194793313741684, -0.055669985711574554, 0.018542582169175148, 0.00799560360610485, -0.003211010480299592, -0.013690807856619358,
    0.006846362259238958, -0.03345410153269768, -0.02431345172226429, -0.05122615396976471, 0.035739172250032425, -0.02426680363714695, -0.01472418662160635, -0.028293108567595482,
    -0.04355160519480705, 0.030540550127625465, 0.015354646369814873, 0.017441442236304283, -0.06013195216655731, -0.015408642590045929, 0.012848113663494587, -0.005492291413247585,
    -0.02109333872795105, 0.01416073739528656, 0.029779328033328056, -0.0008930608746595681, 0.06280874460935593, -0.021023916080594063, 0.0016542403027415276, 0.002633733442053199,
    -0.017484912648797035, 0.029157305136322975, -0.02648995630443096, 0.008372103795409203, 0.03097662329673767, 0.0429752878844738, -0.018467184156179428, -0.017072588205337524,
    -0.039890874177217484, -0.019003532826900482, -0.009098769165575504, -0.015138315036892891, 0.03600053861737251, 0.0005867020227015018, -0.021806612610816956, -0.0006465320475399494,
    -0.05369626358151436, -0.0376213937997818, -0.00614418787881732, -0.033304981887340546, 0.03746510669589043, 0.02776736207306385, 0.016662312671542168, 0.009504553861916065,
    -0.033964622765779495, 0.019836513325572014, 0.01444568857550621, -0.014327729120850563, 0.022204874083399773, -0.04684607684612274, -0.026326704770326614, 0.005558351054787636,
    -0.05162014067173004, -0.020145514979958534, 0.025519313290715218, -0.010258246213197708, -0.06657478958368301, -0.005933201406151056, -0.02042493410408497, -0.019620083272457123,
    -0.0448862724006176, 0.030969547107815742, 0.03292250260710716, -0.0653628334403038, -0.04767914116382599, -0.011410988867282867, 0.023317446932196617, 0.03578932210803032,
    0.008335648104548454, 0.005227882880717516, -0.025283951312303543, 0.01740802265703678, 0.025420228019356728, 0.04455001279711723, -0.047148752957582474, -0.00897978339344263,
    0.02968910150229931, 0.022426674142479897, -0.035023096948862076, 0.0013291585491970181, -0.008915071375668049, 0.006829399149864912, -0.006778067909181118, 0.0036502708680927753,
    0.023713111877441406, 0.05978507548570633, 0.0068257818929851055, 0.019811909645795822, 0.015440061688423157, -0.0417778417468071, -0.03391408920288086, 0.06025051325559616,
    0.026903873309493065, 0.010857895947992802, 0.009691300801932812, 0.02331332117319107, -0.0186153631657362, -0.004701158031821251, 0.018418261781334877, 0.025692185387015343,
    0.061416324228048325, -0.01301336195319891, -0.0204844418913126, 0.007487023249268532, -0.013456464745104313, -0.0368785597383976, -0.03519780933856964, -0.018323048949241638,
    -0.01209938246756792, 0.00805412232875824, -0.0013021716149523854, -0.03668999671936035, 0.03634817525744438, -0.018007997423410416, -0.00010574113548500463, 0.02630225010216236,
    0.013194156810641289, 0.03910748288035393, 0.019374439492821693, 0.05678969621658325, 0.013799781911075115, 0.03196774423122406, -0.02334098517894745, -0.02611500211060047,
    -0.029565181583166122, -0.0214339978992939, -0.007284215185791254, 0.007201104424893856, 0.007988668978214264, -0.014793982729315758, -0.05309604853391647, -0.0018045180477201939,
    0.03803080692887306, -0.025166820734739304, -0.007033772300928831, 0.0303950197994709, 0.03787876293063164, 0.021463904529809952, -0.039600830525159836, 0.004351105075329542,
    -0.010655506514012814, 0.008538734167814255, 0.011979843489825726, -0.013084089383482933, -0.00022458091552834958, 0.023050203919410706, -0.005394880659878254, -0.013664014637470245,
    0.019140733405947685, -0.02095135860145092, -0.017798999324440956, -0.021355293691158295, -0.0007273604278452694, -0.018418891355395317, -0.022876154631376266, -0.03251335397362709,
    0.0034229254815727472, 0.010068862698972225, 0.007076505571603775, -0.00897109042853117, -0.02664525993168354, -0.03228025510907173, 0.014186878688633442, -0.005966347176581621,
    0.03274714946746826, -0.0324004702270031, -0.012935550883412361, 0.03790850192308426, 0.010306214913725853, -0.007847747765481472, -0.04454873129725456, -0.009859574027359486,
    0.04100409150123596, 0.017528368160128593, 0.02655790187418461, -0.0003882233577314764, 0.004826630000025034, -0.007974975742399693, 0.03666071966290474, -0.03506002202630043,
    -0.014865024015307426, 0.04804287850856781, 0.008618799038231373, 0.0070198834873735905, 0.03548780083656311, -0.03207538649439812, -0.066877581179142, 0.009765123948454857,
    -0.015530181117355824, -0.06123320758342743, 0.012744360603392124, 0.03000337816774845, 0.04961217939853668, -0.008935621939599514, -0.008735044859349728, -0.035736083984375,
    0.00554316770285368, 0.005367318633943796, 0.015351438894867897, -0.042130179703235626, 0.004990581423044205, -0.035042427480220795, 0.007821272127330303, -0.007082143798470497,
    -0.0015451748622581363, -0.037927623838186264, 0.021678656339645386, -0.016182703897356987, 0.05393010377883911, -0.024538306519389153, -0.013801179826259613, -0.016261303797364235,
    -0.06022104248404503, -0.024127554148435593, 0.013170771300792694, -0.021640656515955925, 0.05775392800569534, 0.008129083551466465, -0.04131468012928963, 0.02487112581729889,
    -0.018817147240042686, -0.021028537303209305, 0.008981933817267418, 0.006735897623002529, 0.0050074253231287, -0.043201811611652374, 0.03969429433345795, 0.02888355776667595,
    -0.011359971947968006, -0.0017367639811709523, 0.01668287068605423, -0.00864628329873085, 0.02672896906733513, 0.0384831577539444, 0.026255054399371147, -0.008687699213624,
    -0.013884696178138256, -0.06344570219516754, 0.009392112493515015, 0.009689640253782272, -0.018078593537211418, 0.013827440328896046, -0.02719011716544628, -0.0129523491486907,
    -0.002216232242062688, 0.03629619628190994, 0.002376591321080923, -0.029775530099868774, 0.018076928332448006, -0.08401792496442795, 0.024484900757670403, 0.02980063296854496,
    -0.011951431632041931, 0.010821790434420109, 0.01440470851957798, -0.005076046101748943, -0.003201517043635249, 0.02946074865758419, 0.04944940283894539, 0.0037623641546815634,
    0.0077550699934363365, 0.020056219771504402, 0.026796288788318634, 0.03352360799908638, -0.06346486508846283, -0.003812006674706936, 0.009389830753207207, 0.002293976256623864,
    -0.0006640100618824363, -0.025251761078834534, 0.015378225594758987, 0.009378010407090187, 0.04560454562306404, -0.0022754676174372435, 0.03825664147734642, 0.014048376120626926,
    -0.06370357424020767, 0.007875258103013039, 0.020284118130803108, -0.003615533234551549, 0.024318911135196686, -0.002213104860857129, 0.02135457471013069, 0.0076496354304254055,
    -0.053219132125377655, -0.02515801601111889, -0.020289096981287003, 0.046597328037023544, -0.002316662110388279, -0.03979286178946495, 0.004526056349277496, -0.01175533328205347,
    -0.003050033701583743, -0.01936936564743519, 0.029744992032647133, -0.04169218987226486, 0.009471330791711807, -0.02239430695772171, 0.005475092679262161, 0.036267220973968506,
    0.00934933964163065, -0.008952022530138493, -0.060199812054634094, -0.02129320427775383, -0.0005801800871267915, -0.03393769636750221, 0.013080216012895107, -0.004995305556803942,
    -0.027574818581342697, 0.0058326637372374535, -0.022915571928024292, -0.006307411007583141, -0.02895531989634037, 0.011351983062922955, 0.006570946425199509, -0.0035929405130445957,
    -0.011346753686666489, 0.005813275463879108, -0.011631122790277004, -0.018827037885785103, 0.034241508692502975, -0.004989146254956722, 0.0005433726473711431, 0.06175358220934868,
    -0.009327181614935398, -0.015130833722651005, -0.004401782061904669, 0.014839653857052326, -0.04117238521575928, -0.0024048711638897657, -0.04965783655643463, 0.010961506515741348,
    0.01136278547346592, 0.00216560042463243, 0.0439181886613369, -0.016108747571706772, -0.009118468500673771, -0.010077405720949173, 0.01880747638642788, 0.034172479063272476,
    0.008414559997618198, -0.01364047173410654, -0.025555502623319626, 0.01575891673564911, 0.027920234948396683, -0.0007491326541639864, 0.03440044820308685, 0.029576491564512253,
    -0.018857374787330627, 0.03755352273583412, -0.011345879174768925, -0.012780497781932354, -0.00512970145791769, -0.024921325966715813, 0.02639644220471382, 0.0010384421329945326,
    -0.012709270231425762, 0.006767083425074816, -0.03610871359705925, -0.0011736236046999693, 0.027137715369462967, 0.04583973437547684, 0.00489908317103982, 0.00018176894809585065,
    0.014019074849784374, 0.0343012809753418, -0.041749004274606705, 0.004778514616191387, 0.019044304266572, -0.011178234592080116, -0.004791609011590481, 0.03950173407793045,
    0.054945770651102066, -0.0397900752723217, -0.019648507237434387, -0.0033970782533288, -0.020248686894774437, -0.08476721495389938, 0.022561699151992798, -0.02330610901117325,
    0.0267453882843256, 0.01843493990600109, -0.012616435997188091, -0.0385434664785862, 0.031023092567920685, 0.021959640085697174, -0.012550721876323223, 0.01273405458778143,
    0.005706963129341602, 0.03607090935111046, -0.007493008393794298, 0.027365176007151604, -0.017189865931868553, 0.018046768382191658, -0.044066090136766434, -0.01372841838747263,
    -0.04799463972449303, 0.016931837424635887, 0.056885819882154465, -0.002360462211072445, -0.06353556364774704, 0.0055852849036455154, 0.018584897741675377, -0.0017579988343641162,
    -0.01908072829246521, 0.03145885095000267, -0.026517491787672043, 0.004921065643429756, 0.018832022324204445, -0.009128590114414692, 0.015571553260087967, 0.008781109005212784,
    -0.036439456045627594, -0.027332648634910583, 0.01639636792242527, -0.01975099928677082, 0.031036866828799248, -0.0028675987850874662, 0.0009091755491681397, -0.01248948648571968,
    -0.0014323473442345858, -0.01761528290808201, 0.01675989292562008, -0.020461713895201683, 0.02252962626516819, 0.04997465759515762, 0.04165613651275635, -0.00399372074753046,
    -0.0019137774361297488, -0.02565966360270977, -0.03796897456049919, 0.006587645970284939, 0.01494150422513485, 0.011796544305980206, -0.015050754882395267, 0.04573111608624458,
    0.01567818410694599, -0.027563897892832756, 0.04144798964262009, -0.008372096344828606, -0.023965954780578613, 0.02423553727567196, -0.04205668717622757, 0.03061121702194214,
    0.01718369871377945, 0.03295634314417839, 0.029603037983179092, -0.017796291038393974, -0.07333198934793472, 0.024857506155967712, -0.0005311804707162082, -0.04830125719308853,
    0.0017453047912567854, 0.03083251602947712, -0.03406491130590439, 0.009717387147247791, -0.006526332348585129, 0.04784995689988136, -0.009923592209815979, 0.008505985140800476,
    -0.010868041776120663, -0.0014399108476936817, 0.02549511194229126, -0.024034788832068443, -0.03199712187051773, -0.023278754204511642, 0.028630001470446587, -0.02841503545641899,
    -0.011128202080726624, 0.0027223776560276747, 0.010951297357678413, -0.0002895260404329747, 0.037102196365594864, -0.00909709557890892, -0.009551557712256908, 0.07482753694057465,
    0.013251717202365398, 0.015550058335065842, -0.00768350251019001, 0.02845062129199505, 0.011120261624455452, -0.020069770514965057, -0.01322402898222208, 0.015218399465084076,
    -0.003285033395513892, -0.028584783896803856, 4.3434451072243974e-05, -0.0014422870008274913, -0.0028379394207149744, -0.025025442242622375, -0.002383587881922722, -0.05417969450354576,
    -0.029365506023168564, -0.021274367347359657, 0.012729906477034092, 0.010083070956170559, -0.009775467216968536, 0.035420432686805725, -0.02331615425646305, -0.014451739378273487,
    -0.05272515118122101, 0.03596656396985054, -0.03237283229827881, 0.014605758711695671, 0.009543649852275848, 0.0696818009018898, 0.015035408549010754, 0.0002631954848766327,
    0.0010741306468844414, 0.03919653594493866, -0.026181144639849663, -0.02826935611665249, -0.0025413809344172478, -0.013803604990243912, 0.010058592073619366, -0.02533675730228424,
    0.030649615451693535, -0.05406135320663452, -0.022235333919525146, 0.0011685204226523638, 0.055997926741838455, 0.012345122173428535, -0.023608366027474403, -0.012000050395727158,
    0.007772794459015131, 0.00047887416440062225, -0.004850868135690689, -0.017972826957702637, 0.03012572042644024, 0.008385180495679379, 0.005052443593740463, 0.0027906654868274927,
    0.02317093312740326, -0.01126446109265089, 0.005306325387209654, -0.010571824386715889, -0.0008851226884871721, -0.07402894645929337, 0.013952414505183697, 0.009070434607565403,
    0.01134402398020029, 0.033239949494600296, 0.004543776623904705, 0.006061197724193335, 0.007577233016490936, -0.01968524046242237, 0.0014625353505834937, 0.03319806978106499,
    0.010633531026542187, -0.04038713127374649, -0.04152191802859306, 0.003414193168282509, 0.04939316213130951, -0.005716213956475258, -0.028488611802458763, 0.00595363974571228,
    0.008590876124799252, 0.022690756246447563, 0.02039911411702633, -0.019083920866250992, -0.007729768753051758, -0.0033529887441545725, -0.004857784137129784, 0.014972629025578499,
    0.0029692789539694786, -0.0021226496901363134, -0.012721562758088112, -0.046790484338998795, -0.018572965636849403, -0.022922229021787643, -0.039190202951431274, 0.028440089896321297,
    -0.022404968738555908, -0.016523541882634163, -0.017467252910137177, 0.03720760717988014, 0.009031836874783039, 0.003127872245386243, -0.008950904943048954, 0.01945614255964756,
    0.003336119232699275, -0.006735403556376696, -0.019242338836193085, -0.0393858477473259, -0.02361827716231346, 0.0030774425249546766, -0.011949255131185055, 0.019378598779439926,
    -0.03694436326622963, -0.016312576830387115, -0.022862868383526802, 0.039741888642311096, 0.012661915272474289, -0.0032087378203868866, 0.013573037460446358, 0.014492134563624859,
    0.007509881630539894, -0.013898399658501148, -0.02790227346122265, 0.004637186415493488, 0.06435977667570114, -0.011495708487927914, -0.038995563983917236, 0.02479669824242592,
    0.020019713789224625, -0.0021144626662135124, 0.003125877818092704, -0.02875111624598503, 0.019598133862018585, -0.018351813778281212, 0.0023858160711824894, 0.0065871127881109715,
    -0.0032892839517444372, -0.0014549324987456203, 0.02496485225856304, -0.008294609375298023, 0.044051311910152435, 0.03821427747607231, -0.02073570340871811, 0.020346062257885933,
    0.03497042879462242, -0.013152855448424816, -0.01780782639980316, 0.013612141832709312, 0.008065992034971714, -0.030610352754592896, 0.036421649158000946, -0.002743628341704607,
    -0.00777802150696516, 0.025624997913837433, -0.006967145949602127, -0.027495568618178368, 0.0007116475026123226, -0.03640637546777725, 0.03772309795022011, -0.026288744062185287,
    0.001824389910325408, -0.016148962080478668, 0.01311727985739708, 0.03132737800478935, 0.001303843455389142, -0.0015265593538060784, -0.019077517092227936, -0.01479224395006895,
    0.015340092591941357, 0.04475289583206177, 0.041584089398384094, 0.011708476580679417, -0.020441750064492226, -0.013829255476593971, 0.020592117682099342, 0.003567751497030258,
    -0.014227409847080708, -0.004256132058799267, -0.006028789095580578, 0.03007308579981327, 0.020890526473522186, 0.03373538702726364, -0.03684090077877045, 0.03486780822277069,
    -0.012014979496598244, 0.00400084862485528, 0.023062938824295998, 0.005679352208971977, 0.0121639808639884, -0.04698805883526802, 0.023552777245640755, -0.03386452794075012,
    -0.026107193902134895, -0.008332997560501099, -0.014837694354355335, -0.007381130009889603, 0.030939890071749687, 0.07065553963184357, 0.014791532419621944, -0.04448316991329193,
    0.016890181228518486, 0.024066874757409096, 0.005558242555707693, -0.002750617219135165, 0.022880682721734047, -0.015624518506228924, -0.0029775679577142, 0.020654795691370964,
    0.01098051480948925, -0.008280819281935692, -0.012389183975756168, -0.013810964301228523, 0.010187597945332527, 0.0018126987852156162, 0.005064848810434341, -0.0060709691606462,
    0.00357807707041502, 0.035068027675151825, 0.02999509684741497, -0.03473056107759476, -0.023026222363114357, 0.04652047157287598, -0.00638778880238533, 0.008289842866361141,
    -0.043177176266908646, -0.024017928168177605, 0.039120327681303024, -0.049888987094163895, 0.007463175803422928, 0.015619231387972832, -0.01727181300520897, 0.002419114112854004,
    0.006733978167176247, 0.005249708890914917, -0.013595851138234138, -0.021397193893790245, 0.002901684958487749, -0.03695604205131531, -0.013542287983000278, -0.011147599667310715,
    -0.03374556824564934, -0.02553684264421463, -0.017788255587220192, -0.013269729912281036, -0.02138208970427513, -0.010486823506653309, 0.002580088097602129, 0.021567704156041145,
    -0.019824665039777756, -0.0013935337774455547, -0.023592690005898476, 0.027904333546757698, 0.023765860125422478, 0.01743393950164318, 0.007595687638968229, -0.013149077072739601,
    -0.014482450671494007, -0.02691187709569931, 0.0070350393652915955, 0.004729097243398428, 0.005260992795228958, -0.006372870411723852, 0.0115745784714818, 0.0153113454580307,
    0.0016484662191942334, -0.053940750658512115, -0.03549714386463165, 0.002738119103014469, 0.009524522349238396, -0.0203815009444952, 0.022674039006233215, -0.004629224073141813,
    -0.009262524545192719, 0.0008692277478985488, 0.003365600947290659, -0.00118087453301996, 0.017038973048329353, -0.01271893735975027, -0.042759209871292114, 0.007917367853224277,
    -0.02042626217007637, -0.019922729581594467, -0.004583125468343496, 0.03377996012568474, -0.01896657608449459, 0.007893702946603298, -0.003488068236038089, -0.016380731016397476,
    -0.01957685872912407, -2.7628375391941518e-05, 0.02113051526248455, 0.014180393889546394, -0.010095265693962574, -0.04381212964653969, 0.0005345283425413072, -0.012469159439206123,
    0.0170418880879879, -0.015658121556043625, -0.02473444864153862, 0.018432075157761574, 0.024368999525904655, -0.009753139689564705, -0.01372123695909977, 0.001966246170923114,
    -0.021297939121723175, 0.0028365403413772583, -0.024712085723876953, 0.016226300969719887, -0.0004318753781262785, 0.030635826289653778, -0.0012400278355926275, 0.030163779854774475,
    0.03326959162950516, 0.030247004702687263, -0.032269757241010666, -0.014657735824584961, 0.0056111873127520084, -0.04770457372069359, -0.01215415634214878, 0.034555450081825256,
    -0.011964958161115646, -0.015447516925632954, -0.00936305895447731, 0.016798987984657288, -0.025223281234502792, -0.033180899918079376, -0.006768547464162111, -0.0025860429741442204,
    -0.0029445569962263107, -0.022143933922052383, -0.004467923194169998, -0.00613543763756752, -0.024378295987844467, 0.0032628467306494713, 0.035438548773527145, -0.017965052276849747,
    -0.02046716772019863, 0.03427179157733917, -0.0034759368281811476, 0.032027844339609146, -0.014379117637872696, 0.012481724843382835, -0.00046131692943163216, -0.01530004758387804,
    -0.05021953582763672, 0.019649270921945572, -0.01407336350530386, -0.027013564482331276, 0.012325960211455822, -0.04084661230444908, 0.047960467636585236, -0.002370714908465743,
    -0.001925501273944974, 0.010496101342141628, -0.017075372859835625, 0.0035746588837355375, 0.01397442352026701, -0.04278940334916115, 0.02541620284318924, 0.013290134258568287,
    -0.014145989902317524, -0.008594980463385582, -0.03774964064359665, 0.0253595057874918, -0.04989736154675484, -0.010216022841632366, -0.02414819970726967, 0.002315865596756339,
    0.0010666337329894304, -0.030746212229132652, -0.01693974994122982, 0.015045245178043842, -0.0033591517712920904, 0.02627437189221382, 0.02124682441353798, 0.021355949342250824,
    -0.009539766237139702, 0.018288075923919678, 0.01961524970829487, 0.016266334801912308, 0.0795997679233551, -0.012794096022844315, 0.019430896267294884, 0.034255970269441605,
    0.019526025280356407, -0.01743360050022602, 0.015587854199111462, 0.05268329009413719, -0.012816411443054676, 0.0206566471606493, -0.010717210359871387, 0.006375604774802923,
    0.002114154864102602, 0.04784659296274185, 0.022160254418849945, 0.005543542094528675, 0.009886295534670353, 0.01751832664012909, 0.022774357348680496, -0.03274989500641823,
    -0.006064757239073515, -0.013225539587438107, 0.0103522390127182, -0.017984885722398758, -0.0020077049266546965, -0.004918488208204508, 0.02391011081635952, -0.0461074635386467,
    -0.021433448418974876, 0.016022177413105965, 0.010716908611357212, 0.013123155571520329, 0.032733697444200516, 0.017093850299715996, 0.016731830313801765, -0.009682470932602882,
    0.006339577026665211, 0.04663851112127304, -0.06322009861469269, -0.051628727465867996, 0.005570118315517902, 0.020176587626338005, 0.05604497343301773, -0.009970388375222683,
    0.030258070677518845, -0.02268243208527565, -0.07096906751394272, 0.005507032386958599, 0.00976018700748682, 0.015879102051258087, -0.042183954268693924, 0.04587230831384659,
    0.026464881375432014, 0.0056169480085372925, 0.01706261746585369, -0.007403422147035599, 0.0029940097592771053, -0.011770444922149181, -0.05986812338232994, -0.02227115072309971,
    0.00910949520766735, -0.004640162456780672, -0.03726637735962868, 0.02769332192838192, -0.025897573679685593, 0.04201916977763176, 0.004270531702786684, -0.006304888054728508,
    -0.015415717847645283, 0.025865750387310982, 0.03178767114877701, 0.0031543178483843803, 0.021587731316685677, 0.005238262005150318, 0.001387308002449572, -0.026302775368094444,
    -0.016209935769438744, -0.018166618421673775, -0.012862468138337135, 0.024201538413763046, 0.004749699961394072, -2.6240011266054353e-06, -0.02057676762342453, -0.03140143305063248,
    -0.019615396857261658, 0.026879027485847473, -0.017595075070858, -0.004688183311372995, 0.016789289191365242, -0.05177412927150726, 0.0011237021535634995, -0.010107920505106449,
    0.0281620342284441, 0.022105256095528603, -0.004308605100959539, -0.017072806134819984, -0.06920098513364792, 0.007943951524794102, -0.014931391924619675, 0.014646775089204311,
    0.010000500828027725, -0.011870582588016987, 0.01045524887740612, 0.014395770616829395, 0.0027675360906869173, -0.0194441769272089, -0.015986263751983643, 0.019073879346251488,
    0.004022364970296621, 0.012440687976777554, -0.017832495272159576, -0.02370365895330906, -0.003995224367827177, 0.024912115186452866, -0.016088638454675674, -0.015943095088005066,
    0.0543370358645916, -0.013056376948952675, -0.03168186545372009, 0.0656181201338768, 0.010939447209239006, -0.028349246829748154, -0.0017242926405742764, 4.2593856051098555e-05,
    0.028580762445926666, 0.011357275769114494, -0.003181640524417162, 0.018318047747015953, 0.0179641954600811, 0.0035289605148136616, 0.009344954043626785, 0.0016048570396378636,
    -0.028338493779301643, 0.014006172306835651, -0.00489242747426033, -0.007772978860884905, -0.01321803592145443, -0.024947140365839005, -0.044337198138237, -0.00400672247633338,
    -0.0058644600212574005, -0.024579236283898354, -0.018104933202266693, -0.004385667387396097, -0.011396068148314953, -0.019238613545894623, 0.0050215707160532475, 0.006469035986810923,
    -0.01849759928882122, -0.004922713618725538, 0.023797383531928062, -0.012231968343257904, -0.025949599221348763, 0.00942238513380289, 0.02761804312467575, 0.011431739665567875,
    0.056608930230140686, 0.0036677373573184013, -0.00988710206001997, -0.0008025858551263809, -0.022173766046762466, -0.032437779009342194, -0.0066398452036082745, -0.034691158682107925,
    0.03037126176059246, 0.009647028520703316, -0.00893433578312397, 0.022774191573262215, 0.010632134974002838, -0.0040290760807693005, 0.02831578440964222, -0.007322872523218393,
    -0.006364883854985237, 0.025346998125314713, 0.022762402892112732, -0.015468793921172619, -0.012502211146056652, 0.04056296497583389, -0.02590775303542614, -0.0029160541016608477,
    -0.04128016531467438, -0.009484885260462761, -0.02549727074801922, 0.0035146877635270357, 0.05882679671049118, -0.0026547841262072325, -0.014848827384412289, -0.0030862686689943075,
    0.003256414318457246, 0.009631886146962643, -0.004685127642005682, -0.008322296664118767, 0.027523016557097435, -0.05283164232969284, -0.006259453482925892, -0.002922528190538287,
    -0.009861381724476814, -0.026355618610978127, -0.027489185333251953, -0.017445959150791168, 0.005538996774703264, -0.0018090931698679924, -0.009910529479384422, -0.012789041735231876,
    -0.018004845827817917, 0.026935573667287827, 0.01492228638380766, 0.02532116509974003, -0.0064203073270618916, 0.043024126440286636, -0.013328743167221546, 0.024659032002091408,
    0.010381295345723629, -0.026481155306100845, -0.01968441717326641, 0.01936114765703678, 0.029334988445043564, -0.017164604738354683, 0.00021091195230837911, -0.01778092235326767,
    -0.008331909775733948, 7.444296352332458e-05, -0.0013651297194883227, -0.0035233974922448397, -0.03240391984581947, -0.010618525557219982, 0.02369064837694168, -0.019431134685873985,
    -0.0002630914968904108, 0.011220877058804035, -0.01640581525862217, -0.012711076997220516, -0.02061106637120247, -0.0057035936042666435, -0.01497616060078144, 0.007210579235106707,
    -0.009468567557632923, 0.023758532479405403, 0.016218524426221848, -0.036412596702575684, 0.047718461602926254, -0.05570457875728607, -0.026118893176317215, -0.022909436374902725,
    0.036350347101688385, 0.01146845892071724, 0.0004982422105967999, 0.015498287044465542, -0.021899346262216568, 0.005828494671732187, -0.03001117892563343, -0.0017676642164587975,
    0.026129908859729767, -0.02370251715183258, -0.0054085091687738895, -0.018828170374035835, 0.049471475183963776, -0.018166957423090935, -0.006848829332739115, -0.01998499222099781,
    -0.0018721126252785325, 0.013100254349410534, 0.011493967846035957, 0.012631222605705261, -0.015544593334197998, -0.024661194533109665, -0.02831118553876877, -0.017043307423591614,
    -0.024692969396710396, 0.0061772773042321205, -0.019857438281178474, -0.03473857417702675, 0.0010121231898665428, -0.0006604064838029444, 0.033330947160720825, -0.03803519532084465,
    0.0005649083759635687, 0.009711566381156445, 0.00021243497030809522, 0.016814976930618286, -0.03251203894615173, -0.002716662595048547, 0.015512683428823948, -0.02675076760351658,
    0.01835523545742035, -0.00818642321974039, -0.02459697797894478, -0.0002210497041232884, 0.037770435214042664, 0.006548776291310787, -0.03128798305988312, 0.006725313141942024,
    -0.02471381053328514, -0.007163142319768667, -0.01994585432112217, 0.020580273121595383, -0.038871243596076965, -0.008069543167948723, 0.0033639611210674047, -0.009658562950789928,
    0.002205515978857875, 0.016094136983156204, 0.02035372331738472, -0.010035146959125996, -0.00836022850126028, -0.02638634666800499, -0.04748966172337532, 0.0203084833920002,
    -0.013206589967012405, -0.012405135668814182, -0.0026633208617568016, 0.03369063138961792, 0.008782947435975075, 0.016205135732889175, -0.008918043226003647, -0.0011237954022362828,
    -0.010501423850655556, -0.006559725850820541, 0.002326879184693098, -0.017151597887277603, -0.024462994188070297, -0.07800839841365814, 0.020992321893572807, -0.025899743661284447,
    0.0649372860789299, 0.028316397219896317, 0.027623476460576057, 0.0013166398275643587, 0.0004371305403765291, -0.04150465875864029, 0.011068124324083328, 0.004358266014605761,
    -0.00987291056662798, -0.011007290333509445, -0.042552728205919266, 0.029238883405923843, 0.020791595801711082, -0.0015197066823020577, -0.0002626554050948471, -0.005624440964311361,
    -0.015090743079781532, -0.016029173508286476, -0.00399379339069128, -0.00808221660554409, 0.009312347508966923, -0.020114220678806305, 0.010409223847091198, 0.01806860975921154,
    0.0026529969181865454, -0.003911158535629511, 0.01990273781120777, 0.003641416085883975, -0.042526278644800186, -0.003952637314796448, -0.037614379078149796, 0.01745022088289261,
    -0.0017994403606280684, -0.05069100484251976, 0.0003953255363740027, -0.0015882004518061876, -0.00560621777549386, 0.0012166807428002357, -0.0030543922912329435, 0.0014474689960479736,
    0.014157659374177456, -0.03599858656525612, 0.003945633769035339, 0.022711265832185745, 0.016151754185557365, -0.04475227743387222, -0.004713832400739193, 0.00493230763822794,
    0.021069923415780067, -0.014303603209555149, -0.03680076822638512, -0.006312189158052206, -0.006442784331738949, -0.00513148307800293, 0.018306180834770203, -0.0060149990022182465,
    -0.015642888844013214, 0.006285287905484438, 0.026210544630885124, 0.006495712324976921, 0.05079137906432152, -0.03359794244170189, 0.008154104463756084, 0.001110662124119699,
    0.015996409580111504, -0.03759341686964035, -0.02065686322748661, 0.0028310271445661783, -0.020646091550588608, -0.004171600565314293, -0.04953882843255997, -0.02216930314898491,
    0.018965549767017365, 0.006305085029453039, 0.04727127030491829, 0.014888455159962177, 0.021250398829579353, 0.042114757001399994, -0.010973084717988968, 0.009493508376181126,
    -0.014696655794978142, 0.0034362871665507555, -0.033461567014455795, 0.019257675856351852, 0.02470945380628109, 0.00035420438507571816, 0.0234646275639534, 0.0021587798837572336,
    -0.020213942974805832, 0.01552970428019762, 0.004899889696389437, -0.002778506139293313, -0.00013835202844347805, -0.027424830943346024, 0.011397183872759342, -0.00548573350533843,
    0.03751849755644798, -0.025492792949080467, 0.0027067139744758606, -0.05213703215122223, -0.004213227890431881, 0.0018143184715881944, -0.004459510091692209, 0.024349171668291092,
    0.011315511539578438, -0.03138931095600128, -0.04092700406908989, -0.022929074242711067, 0.02238040789961815, 0.04532477259635925, 0.00476989196613431, -0.01461185421794653,
    0.015201440081000328, -0.005162409972399473, 0.02736515924334526, -0.031058043241500854, -0.02821146883070469, 0.010864116251468658, 0.0046440428122878075, -0.019875740632414818,
    0.004391388967633247, -0.021702840924263, -0.011503920890390873, -0.020455796271562576, 0.004309976939111948, 0.028811510652303696, 0.010203435085713863, 0.010834457352757454,
    0.02151206135749817, -0.012778263539075851, -0.013375443406403065, 0.023831920698285103, -0.01668532006442547, 0.061485275626182556, 0.01124994084239006, -0.01314874179661274,
    -0.025774789974093437, 0.001305665704421699, -0.013239066116511822, -0.03595900535583496, 0.01347790565341711, 0.018173009157180786, -0.012250152416527271, -0.013156010769307613,
    0.018915506079792976, 0.0354728177189827, 0.00808795727789402, 0.004612030927091837, 0.030503137037158012, -0.012283808551728725, 0.007647728081792593, -0.01589474268257618,
    0.020244669169187546, 0.036509111523628235, -0.0051687718369066715, -0.0038558172527700663, -0.009329267777502537, 0.01341336965560913, 0.04002512991428375, 0.04049859941005707,
    -0.033436015248298645, -0.016802379861474037, 0.007911460474133492, 0.038519904017448425, -0.006863556802272797, 0.0008843540563248098, -0.008536551147699356, 0.0151298763230443,
    -0.01966768316924572, 0.03482300043106079, -0.005616394337266684, -0.007216923870146275, -0.006266816519200802, 0.03707388788461685, 0.005833772011101246, 0.011294313706457615,
    -0.013834480196237564, 0.010329015552997589, -0.010874067433178425, -0.027010029181838036, 0.021287567913532257, -0.04003208130598068, 0.017987485975027084, 0.008406583219766617,
    -0.010659749619662762, -0.003964935429394245, 0.0013606465654447675, 0.014262414537370205, 0.0689498707652092, 0.008903616108000278, 0.038243506103754044, 0.010149515233933926,
    0.006702801212668419, -0.015110519714653492, 0.045888207852840424, -0.02003076858818531, 0.02745155058801174, -0.028020091354846954, -0.005549625027924776, -0.0046116020530462265,
    0.022256743162870407, -0.05765688791871071, -0.013734300620853901, -0.01696854829788208, -0.005255023017525673, -0.031088730320334435, 0.005884718615561724, -0.004991986323148012,
    0.01215045340359211, 0.027314741164445877, 0.016223188489675522, -0.0017818495398387313, 0.032658651471138, -0.04570600762963295, -0.0016265049343928695, -0.002906736684963107,
    -0.009576551616191864, 0.00951189361512661, -0.009346903301775455, 0.02499435655772686, -0.004723144695162773, -0.007500846870243549, 0.00016585657431278378, -0.013338918797671795,
    -0.008154136128723621, -0.004762810654938221, -0.004439786076545715, -0.01803424395620823, -0.0220156442373991, -0.011876300908625126, -0.005764125380665064, 0.015302830375730991,
    0.006774134933948517, 0.021946460008621216, 0.004194116219878197, 0.007948257029056549, -0.0031685112044215202, -0.027917655184864998, -0.004163603764027357, 0.016605056822299957,
    -0.032484330236911774, 0.0141757195815444, -0.016360141336917877, 0.02002117969095707, -0.0026782352942973375, -0.009714676067233086, -0.013369446620345116, 0.02144596353173256,
    -0.010231697000563145, -0.026866745203733444, 0.02121123857796192, -0.03372271731495857, -0.039240866899490356, -0.042114462703466415, 0.000340080849127844, -0.01819097250699997,
    -0.014562363736331463, -0.011823296546936035, -0.004295238759368658, 0.018381251022219658, -0.015073373913764954, -0.03318171203136444, 0.010297098197042942, 0.018198523670434952,
    0.008843005634844303, -0.06008139252662659, -0.009185695089399815, -0.01431906409561634, -0.0010900269262492657, 0.01936100609600544, 0.009001979604363441, -0.01225909125059843,
    0.011710829101502895, 0.020484190434217453, -0.003033853368833661, 0.04147251695394516, -0.021723004058003426, 0.0032493819016963243, 0.023647863417863846, -0.0032980579417198896,
    -0.003153870813548565, 0.0022884232457727194, 0.000983858248218894, 0.0013449100079014897, -0.04432880878448486, 0.0074542188085615635, -0.04406772181391716, 0.02568362094461918,
    -0.05355009064078331, 0.008945170789957047, -0.03088287264108658, -0.03642917424440384, 0.038731735199689865, 0.008056443184614182, 0.008762938901782036, -0.023008424788713455,
    0.008458999916911125, -0.026280242949724197, 0.010641722939908504, -0.010643946006894112, -0.013902196660637856, 0.05095622316002846, -0.02283400483429432, 0.006958167999982834,
    0.002182147465646267, -0.0159278716892004, -0.001973408507183194, 0.006194452289491892, -0.02153358981013298, -0.0033281000796705484, -0.013043095357716084, -0.03298111632466316,
    -0.05656179413199425, 0.014098546467721462, -0.007436116226017475, -0.013533039018511772, 0.05847926810383797, -0.0397174134850502, -0.0021526911295950413, 0.009228486567735672,
    0.006642465479671955, 0.006228582933545113, -0.00023089283786248416, -0.01708560436964035, -0.03980391472578049, -0.033486831933259964, -0.005538859870284796, 0.013848971575498581,
    0.012000331655144691, 0.026041150093078613, -0.01927446946501732, 0.02136678621172905, 0.005422355607151985, 0.023708557710051537, 0.0068405079655349255, -0.011419261805713177,
    0.01344645582139492, -0.02369493618607521, -0.006280860863626003, -0.008079632185399532, -0.00416931789368391, -0.006897313520312309, 0.03082524798810482, 0.005024835467338562,
    0.049124304205179214, -0.007564818020910025, 0.00929650291800499, 0.017369916662573814, 0.0026342440396547318, -0.004907727241516113, -0.01982242800295353, 0.02915901690721512,
    -0.0019450340187177062, -0.03548508882522583, -0.043404243886470795, 0.040009334683418274, 0.03411785513162613, -0.011002684943377972, -0.032684966921806335, -0.03405318781733513,
    -0.03049432672560215, -0.01780349388718605, -0.004691873677074909, -0.023298384621739388, -0.018184402957558632, 0.014548862352967262, 0.07748603075742722, 0.029126925393939018,
    0.018896199762821198, 0.01497992966324091, -0.017268750816583633, -0.007142952643334866, 0.037712644785642624, -0.000987958163022995, -0.010751305148005486, -0.010031694546341896,
    0.006354955956339836, 0.021287377923727036, -0.015247378498315811, 0.023268913850188255, 0.024777749553322792, 0.013010339811444283, 0.030726095661520958, -0.008604846894741058,
    -0.008581430651247501, 0.025495048612356186, 0.007252081762999296, -0.01901523768901825, -0.029406387358903885, 0.07026755064725876, -0.02537287026643753, 0.009486822411417961,
    0.005503216292709112, -0.016701744869351387, -0.006844441872090101, 0.01903730258345604, -0.01551608182489872, 0.018993305042386055, -0.015701133757829666, 0.03190809488296509,
    -0.0037255152128636837, -0.024982616305351257, -0.009594723582267761, -0.003489510389044881, 0.014355014078319073, -0.010465872474014759, -0.016168124973773956, -0.02398102916777134,
    0.03135962784290314, 0.0034436951391398907, 0.021156176924705505, 0.0013346862979233265, -0.015263672918081284, -0.04699387773871422, 0.00019246607553213835, -0.03411721810698509,
    -0.04152156040072441, -0.001020910101942718, 0.01954411342740059, 0.014925114810466766, -0.04876421391963959, 0.011980603449046612, -0.010849079117178917, 0.024547526612877846,
    -0.011990022845566273, 0.028197232633829117, 0.02446654811501503, -0.006542057264596224, 0.013876569457352161, 0.03773423284292221, -0.0056290095672011375, 0.01166163757443428,
    0.025836557149887085, 0.01806788519024849, 0.028462903574109077, -0.023281048983335495, -0.020318808034062386, -0.011671248823404312, -0.0072395773604512215, 0.024987822398543358,
    0.013427052646875381, -0.008790315128862858, 0.0320204421877861, 0.003772654803469777, 0.05406506359577179, -0.006738896016031504, 0.02601126953959465, -0.0021354977507144213,
    -0.05644531920552254, 0.020301736891269684, 0.029473911970853806, -0.0012794587528333068, -0.02043091505765915, -0.03278138488531113, 0.029644671827554703, 0.002506507094949484,
    -0.005731440149247646, 0.010038335807621479, 0.04274148494005203, -0.021222924813628197, -0.0006133709684945643, -0.010314961895346642, -0.006615784950554371, -0.016003601253032684,
    0.019174257293343544, 0.018577685579657555, -0.008590887300670147, 0.0491383858025074, -0.0075008561834692955, 0.0032776675652712584, -0.0027700713835656643, -0.04672626033425331,
    -0.0018424048321321607, -0.008346665650606155, -0.003955492749810219, -0.004766435362398624, 0.006476018577814102, 0.001965693663805723, 0.01953667588531971, 0.003902639029547572,
    0.031537558883428574, 0.017847182229161263, -0.032384708523750305, -0.008768179453909397, -0.008035419508814812, 0.012800964526832104, 0.027119938284158707, 0.01832689717411995,
    -0.01621311716735363, 0.0013452176935970783, -0.022360075265169144, -0.011605839245021343, -0.00213272194378078, 0.014250253327190876, 0.02066776342689991, -0.0008012044127099216,
    -0.03933968394994736, -0.004274515900760889, -0.0049757929518818855, 0.0027764916885644197, -0.0073651885613799095, 0.018208712339401245, -0.013056766241788864, 0.00513344444334507,
    0.014620422385632992, -0.0009962822077795863, 0.023719660937786102, 0.0024581188336014748, -0.021404560655355453, 0.0035327423829585314, -0.042328063398599625, 0.006062373518943787,
    -0.037080131471157074, -0.03175033628940582, -0.04327408969402313, 0.02619991824030876, 0.016807198524475098, -0.023832352831959724, 0.03072751872241497, 0.02602502331137657,
    0.021246567368507385, 0.012572373263537884, -0.015599663369357586, 0.018713947385549545, 0.015050007961690426, 0.009654351510107517, 0.011443333700299263, -0.012079606764018536,
    -0.0032611293718218803, -0.0015259856591001153, -0.010828766040503979, 0.02243306301534176, -0.023244069889187813, -0.028005046769976616, -0.006329666823148727, 0.010662863031029701,
    0.004287380259484053, -0.0078072817996144295, -0.03448719531297684, 0.0009387176833115518, 0.006715856492519379, -0.007053499575704336, 0.03866135701537132, 0.06508924067020416,
    -0.018872162327170372, -0.013893663883209229, -0.028570441529154778, -0.013540060259401798, 0.023110445588827133, 0.0023518851958215237, 0.0002016530343098566, -0.03984314575791359,
    0.019422536715865135, -0.05886399373412132, -0.034526076167821884, 0.011925924569368362, -0.019017571583390236, 0.013154127635061741, 0.03906124457716942, 0.002433061832562089,
    -0.008336802944540977, -0.004804184194654226, -0.014576400630176067, -0.03579086810350418, -0.015983639284968376, 0.025598464533686638, 0.031719692051410675, -0.009616274386644363,
    0.02711939997971058, 0.009496758691966534, 0.01400375459343195, -0.0010909810662269592, 0.04887060821056366, -0.012302923016250134, -0.0053572217002511024, 0.006628045812249184,
    -0.01787666790187359, -0.007727691438049078, 0.0193889532238245, -0.00961157027631998, 0.031083019450306892, -0.006414364092051983, -0.010451380163431168, -0.0022347953636199236,
    -0.013717224821448326, -0.021191030740737915, -0.0315978042781353, -0.027171725407242775, 0.003712136298418045, 0.03731841966509819, 0.031148122623562813, 0.012116809375584126,
    -0.005355574656277895, 0.027070874348282814, 0.0037949024699628353, 0.007889856584370136, 0.025448523461818695, 0.004463823512196541, 0.014444952830672264, 0.023013534024357796,
    -0.017566971480846405, 0.004605736583471298, -0.0066201644949615, 0.010543364100158215, -0.0013955319300293922, 0.004610753618180752, 0.04138476401567459, 0.019953729584813118,
    0.0028799690771847963, -0.03832343965768814, 0.048200156539678574, 0.009642133489251137, -0.02392854355275631, 0.008463316597044468, -0.02391745336353779, -0.024589594453573227,
    0.01148094143718481, -0.012648450210690498, -0.04736165702342987, 0.01627826690673828, -0.011372852139174938, 0.016867468133568764, 0.06700506061315536, 0.03838447108864784,
    0.027539068832993507, -0.005702892784029245, -0.031217064708471298, -0.0032398817129433155, 0.04266177862882614, -0.027140585705637932, -0.022141262888908386, -0.02349812537431717,
    0.015377664007246494, 0.025054555386304855, -0.022813409566879272, 0.019454605877399445, 0.017053784802556038, -0.006348344963043928, 0.02825886942446232, 0.0023853203747421503,
    0.01637335680425167, 0.00555863231420517, -0.05853988602757454, 0.009631088934838772, -0.03997410833835602, 0.055180635303258896, -0.013544144108891487, -0.020051172003149986,
    -0.03546861186623573, 0.007217239122837782, -0.02607431821525097, 0.01590997539460659, -0.02684628777205944, 0.021430307999253273, -0.015534107573330402, 0.005531965289264917,
    0.0505070723593235, 0.009408014826476574, 0.014062948524951935, -0.004102766513824463, 0.0038689037319272757, 0.024912022054195404, -0.006085474509745836, 0.005714846309274435,
    0.04306414723396301, -0.04034193977713585, 0.026363812386989594, -0.0032279312144964933, -0.013304841704666615, -0.006676143035292625, -0.0014752390561625361, 0.013644170947372913,
    -0.0018589176470413804, -0.03607342392206192, 0.006743157748132944, -0.05980002135038376, -0.0728706568479538, -0.006544013973325491, 0.003395693376660347, 0.01851877011358738,
    0.007503469008952379, 0.03380458056926727, 0.04429119452834129, 0.0063490294851362705, 0.03524307906627655, 0.0027862892020493746, -0.011846841312944889, -0.01655203104019165,
    -0.00966047216206789, -0.026785938069224358, -0.0032822205685079098, -0.030072232708334923, 0.005411933641880751, 0.013538234867155552, -0.023729581385850906, -0.048316843807697296,
    -0.016210298985242844, 0.02868429385125637, -0.011196834035217762, -0.003952462691813707, 0.05738585814833641, -0.00887179747223854, 0.035229116678237915, 0.025463130325078964,
    -0.021214714273810387, -0.02274368889629841, 0.004400680307298899, -0.005551896058022976, -0.03255311772227287, 0.003189376788213849, -0.018855031579732895, -0.0068631661124527454,
    0.011243550106883049, -0.014241751283407211, -0.04595309495925903, 0.009131919592618942, 0.02717704139649868, 0.024912968277931213, -0.029910022392868996, -0.01206846535205841,
    -0.007735305931419134, -0.014106914401054382, 0.021931124851107597, 0.0061280447989702225, -0.01568072848021984, -0.008872022852301598, -0.01228069793432951, 0.011187491938471794,
    -0.0020337915048003197, 0.010275518521666527, -0.015346311964094639, 0.042953282594680786, 0.051315467804670334, -0.00373856327496469, 0.003222211729735136, -0.0005317827453836799,
    -0.009882408194243908, 0.019570641219615936, 0.003897946560755372, 0.009530163370072842, 0.011284980922937393, -0.003593873931095004, 0.050657372921705246, -0.00027269753627479076,
    0.011177551001310349, 0.0029742480255663395, 0.005897911731153727, -0.020302744582295418, -0.009113077074289322, 0.031442128121852875, 0.004973920527845621, 0.018637754023075104,
    0.0025839435402303934, 0.00259308866225183, 0.030981961637735367, 0.00915786437690258, -0.06612351536750793, 0.022898202762007713, -0.00661583011969924, 0.016040373593568802,
    0.0013748693745583296, -0.012163168750703335, -0.019978614524006844, 0.004633808042854071, -0.025127669796347618, 0.03175041079521179, 0.007127438671886921, 0.018218157812952995,
    0.028636157512664795, -0.00754539854824543, -0.036110423505306244, -0.0010546003468334675, -0.026724182069301605, -0.021739492192864418, -0.0036746670957654715, 0.010372373275458813,
    -0.015063999220728874, 0.023043718189001083, -0.002498030196875334, -0.016583161428570747, 0.0017825273098424077, 0.05701090767979622, -0.01947305165231228, 0.0038544777780771255,
    -0.024875735864043236, -0.006258870474994183, -0.008346593007445335, 0.008171020075678825, -0.020193597301840782, 0.015297958627343178, 0.03592366725206375, -0.013372335582971573,
    0.038299694657325745, -0.02562837488949299, -0.06178294122219086, 0.020437372848391533, -0.04509221389889717, -0.01325902622193098, 0.005095569882541895, 0.025712523609399796,
    0.008507492952048779, 0.010047117248177528, 0.011460306122899055, -0.036670759320259094, -0.005825358908623457, 0.03634081780910492, 0.014001643285155296, 0.013695004396140575,
    -7.98706169007346e-05, -0.04872512072324753, -0.011698991060256958, -0.040909167379140854, 0.01472495961934328, -0.003235948970541358, 0.008319946937263012, 0.0037904775235801935,
    0.01567048951983452, -0.0076100812293589115, -5.670341124641709e-05, 0.005354978144168854, 0.01401608344167471, 0.016767002642154694, 0.032398950308561325, 0.004899794701486826,
    0.023454023525118828, -0.00501486798748374, -0.029774969443678856, -0.026028811931610107, 0.010827693156898022, 0.02953190915286541, -0.010281533002853394, 0.006808948237448931,
    0.054338887333869934, 0.0030459787230938673, -0.048150353133678436, -0.04363676905632019, 0.0030062126461416483, -0.005045232363045216, -0.03465290740132332, -0.00410844711586833,
    -0.05338587611913681, 0.01621108315885067, -0.0031397077254951, -0.01045819092541933, -0.0015514325350522995, 0.03073267824947834, 0.011168183758854866, -0.033599283546209335,
    0.022407954558730125, -0.04511352255940437, -0.01941191963851452, -0.005664457567036152, 0.014985328540205956, 0.010275168344378471, 0.006789685692638159, 0.032034169882535934,
    0.0553804412484169, 0.02256288379430771, 0.01013947557657957, -0.03565629571676254, -0.03599083796143532, 0.0005855569615960121, 0.011484568007290363, 0.025342712178826332,
    -0.005856583826243877, -0.02143721468746662, 0.024350708350539207, 0.010648516938090324, 0.025422068312764168, -0.00579495495185256, -0.02717130444943905, -0.044761598110198975,
    0.018951278179883957, 0.029482536017894745, 0.0025716337841004133, -0.00030093855457380414, -0.017354203388094902, 0.015797335654497147, 0.0820961445569992, 0.012980455532670021,
    -0.003642228664830327, 0.007266986183822155, 0.0021652060095220804, 0.013903516344726086, 0.006080696824938059, -0.028446562588214874, 0.013782952912151814, 0.013916817493736744,
    0.010111989453434944, 0.012450611218810081, 0.023175956681370735, 0.02050746977329254, 0.023888399824500084, -0.010808574967086315, 0.026440059766173363, -0.0035026553086936474,
    0.00842397939413786, -0.023866577073931694, 0.029553648084402084, -0.01506788656115532, -0.020697519183158875, 0.05341422185301781, 0.01989736780524254, -0.03423107787966728,
    -0.041540082544088364, 0.035548530519008636, -0.02358604036271572, -0.0013051033020019531, -0.01500086858868599, -0.012224359437823296, -0.0017306136433035135, -0.00931160245090723,
    0.03950244188308716, -0.01991483010351658, 0.01961214654147625, -0.021407580003142357, 0.011499706655740738, -0.010543682612478733, -0.016059402376413345, -0.05567755550146103,
    -0.03078029677271843, -0.0072941770777106285, 0.028958044946193695, 0.019214913249015808, -0.018923815339803696, 0.030002031475305557, -0.007284138351678848, 0.021519944071769714,
    -0.0564904548227787, -0.020138651132583618, -0.0048064677976071835, 0.02174529619514942, -0.011431535705924034, -0.004728303290903568, 0.003574807895347476, -0.010382269509136677,
    0.04164408519864082, 0.03634360060095787, 0.03606896102428436, 0.0010982766980305314, -0.007210360374301672, 0.0012261344818398356, -0.01492347102612257, 0.017039716243743896,
    0.00805065780878067, 0.012232812121510506, 0.024032417684793472, -0.026918159797787666, -0.004820923320949078, 0.035707712173461914, 0.00513980258256197, 0.023372331634163857,
    0.019211186096072197, 0.025735963135957718, 0.032265253365039825, 0.012545277364552021, 0.015246850438416004, -0.03064083866775036, -0.0013799989828839898, 0.008839416317641735,
    -0.005912418011575937, -0.003670924110338092, -0.014355286955833435, -0.01167982630431652, 0.04589889571070671, -0.028321145102381706, -0.02083708718419075, -0.01391358207911253,
    0.0248264167457819, 0.050391148775815964, -0.009037226438522339, -0.009247291833162308, 0.05736290663480759, 0.03605813905596733, -0.015647083520889282, -0.0016458709724247456,
    0.004068060778081417, -0.005413850303739309, 0.01267891377210617, -0.005109032150357962, 0.042117513716220856, -0.026564208790659904, 0.01992471143603325, -0.0083672646433115,
    0.0057601057924330235, 0.015416841953992844, 0.03411790356040001, 0.06221550703048706, 0.033792126923799515, 0.0025976041797548532, 0.0224736537784338, -0.018477415665984154,
    0.010660030879080296, 0.0005201644962653518, 0.006822590250521898, 0.04224292188882828, -0.009027697145938873, 0.017916858196258545, 0.007871313951909542, 0.01434240024536848,
    -0.009635986760258675, 0.012909586541354656, -0.005890110041946173, -0.0024842675775289536, -0.019546644762158394, -0.015231495723128319, 0.046321868896484375, 0.007493744138628244,
    0.02006427012383938, 0.0073661161586642265, 0.04050157591700554, 0.027839193120598793, -0.03888718783855438, 0.030332809314131737, 0.010881142690777779, -0.00531422533094883,
    0.006096214521676302, -0.0073325843550264835, -0.007099176291376352, 0.05675451457500458, 0.021680200472474098, 0.005094781052321196, -0.0003838827833533287, -0.00991765409708023,
    0.0530334897339344, 0.02600286900997162, -0.036777567118406296, 0.008503158576786518, -0.03499624505639076, -0.012164364568889141, -0.010992113500833511, -0.011175906285643578,
    0.015998780727386475, 0.028974449262022972, 0.005220428109169006, -0.01644657738506794, -0.01983494684100151, -0.011769991368055344, -0.011013123206794262, -0.012504405342042446,
    -0.02179618738591671, -0.023175019770860672, -0.0014393605524674058, -0.02173299342393875, -0.0005940285627730191, -0.012637472711503506, 0.00978140439838171, 0.04531116038560867,
    0.09199651330709457, -0.037294019013643265, -0.004905484616756439, -0.015123013406991959, 0.03515409678220749, -0.007173126097768545, 0.053053367882966995, 0.013262399472296238,
    -0.022681573405861855, 0.0028025126084685326, 0.00486052967607975, -0.005526047199964523, -0.010690810158848763, -0.01662597618997097, 0.03931969404220581, 0.007358422502875328,
    0.0018505759071558714, -0.014524524100124836, 0.012409629300236702, 0.043473340570926666, 0.000593892764300108, 0.009261752478778362, 0.0022683830466121435, -0.016655784100294113,
    -0.022512415423989296, -0.04095804691314697, -0.004465858452022076, -0.015686092898249626, -0.023178722709417343, -0.002751603489741683, -0.060341428965330124, -0.02726370096206665,
    0.053736474364995956, 0.008222324773669243, -0.017956029623746872, -0.0030245152302086353, 0.02995692752301693, 0.03482893481850624, -0.00639589037746191, -0.025463441386818886,
    -0.02468222752213478, -0.004437701310962439, -0.013296280056238174, -0.025063656270503998, 0.03387655317783356, -0.010553060099482536, 0.01076739002019167, 0.0032558974344283342,
    -0.03259297087788582, -0.03236626833677292, 0.018889183178544044, -0.027304265648126602, -0.0024099957663565874, -0.07209140062332153, -0.006102945189923048, 0.044438719749450684,
    -0.004816201515495777, -0.04520333558320999, 0.005657432600855827, -0.008958512917160988, 0.028989892452955246, 0.009873921051621437, 0.00831043440848589, 0.019383884966373444,
    -0.022546174004673958, -0.025539260357618332, -0.008253021165728569, -0.03872358798980713, -0.07184640318155289, 0.029964350163936615, -0.016427986323833466, 0.0016079474007710814,
    -0.02811894565820694, -0.0037219251971691847, -0.008233431726694107, -0.03718986362218857, -0.01618356816470623, -0.025771312415599823, -0.005409902893006802, -0.021517544984817505,
    0.03909926488995552, 0.014816157519817352, -0.04258989542722702, -0.007753669284284115, 0.0007060603820718825, 0.0432170145213604, -0.023870201781392097, 0.02631520852446556,
    0.03703993186354637, -0.010254909284412861, -0.018711669370532036, 0.012685357592999935, 0.023616328835487366, -0.011789694428443909, -0.04316769167780876, -0.010052261874079704,
    0.018828319385647774, -0.024352774024009705, -0.02066163904964924, 0.02222907729446888, -0.012303819879889488, 0.015544664114713669, -0.019453104585409164, 0.037625644356012344,
    -0.0034512889105826616, -0.03711484372615814, 0.00299095269292593, -0.022821074351668358, 0.040216099470853806, 0.01957835629582405, -0.01524331420660019, -0.0011743046343326569,
    -0.01151785533875227, -0.03806668892502785, 0.009148547425866127, 0.04762262850999832, -0.014979945495724678, -0.00354643352329731, -0.001072608632966876, -0.0016119136707857251,
    0.04632066190242767, -9.361125557916239e-05, 0.007767089176923037, 0.0009728375589475036, -0.043242305517196655, -0.038987692445516586, 0.026554781943559647, -0.010593154467642307,
    0.021564306691288948, 0.02746826782822609, -0.00054588244529441, 0.06357309967279434, 0.05429549142718315, 0.03990408033132553, 0.001788520603440702, 0.028956172987818718,
    -0.033459778875112534, -0.01321702916175127, 0.027722790837287903, -0.06849932670593262, -0.0007971420418471098, -0.0295580867677927, -0.04182666167616844, -0.028523307293653488,
    -0.020135490223765373, -0.03148554638028145, -0.006672508083283901, -0.008811665698885918, -0.013278049416840076, 0.003556719981133938, 0.002492535160854459, -0.0008886506548151374,
    -0.004203746095299721, 0.0087418332695961, -0.02819172851741314, -0.03645910322666168, -0.018175913020968437, -0.02019815891981125, 0.0185993742197752, 0.03467777371406555,
    -0.007655843626707792, -0.0017945191357284784, 0.025890234857797623, 0.00047725968761369586, 0.05661825090646744, -0.0043165422976017, -0.014398502185940742, 0.019870063289999962,
    -0.039890676736831665, -0.016869010403752327, -0.04078439250588417, -0.014712769538164139, 0.04391012713313103, -0.010990388691425323, 0.0023601260036230087, -0.029746415093541145,
    0.009320894256234169, 0.054304275661706924, -0.016615871340036392, 0.012770324014127254, 0.008373758755624294, 0.010038991458714008, -0.015133571811020374, -0.00754883186891675,
    0.028685323894023895, 0.00013166983262635767, -0.010803508572280407, -0.0042168512009084225, 0.008698823861777782, -0.026523806154727936, 0.03695359826087952, -0.03219344839453697,
    0.020481402054429054, 0.02714809775352478, 0.01666371524333954, 0.036599982529878616, 0.04610235244035721, 0.018633384257555008, -0.02929104119539261, 0.04068923741579056,
    -0.0012617363827303052, 0.018704773858189583, 0.01678154617547989, -0.031514059752225876, 0.005054704379290342, 0.0046669612638652325, 0.028383363038301468, -0.009119244292378426,
    0.010750017128884792, -0.019344210624694824, -0.023470396175980568, -0.0014341493370011449, -0.00927367527037859, -0.05694291740655899, 0.0028591956943273544, -0.005981567315757275,
    0.038889966905117035, 0.024470137432217598, 0.02407745271921158, -0.03920046240091324, -0.020698145031929016, -0.020384255796670914, 0.01216055080294609, 0.01039733737707138,
    0.027927743270993233, 0.024876831099390984, -0.021564248949289322, -0.015933360904455185, -0.0019704941660165787, 0.05252937972545624, -0.026961229741573334, 0.03158974274992943,
    -0.03001917339861393, 0.026788316667079926, -0.024082381278276443, -0.010054395534098148, -0.009797235950827599, 0.0023040666710585356, -0.0031861623283475637, 0.03208707645535469,
    0.037254780530929565, 0.016599031165242195, 0.01888136751949787, -0.05513330176472664, -0.0086382906883955, -0.03373788669705391, 0.01328718475997448, -0.028214316815137863,
    0.030086901038885117, 0.03923534229397774, 0.008670954033732414, -0.049647364765405655, 0.022999372333288193, -0.03716498240828514, 0.01604057103395462, 0.019753703847527504,
    -0.009704185649752617, -0.0057984329760074615, -0.011370383203029633, 0.011599753051996231, -0.0506606362760067, 0.020325202494859695, 0.039054423570632935, 1.3913750990468543e-05,
    -0.01655980572104454, -0.014633169397711754, -0.010108633898198605, -0.021674461662769318, 0.01451018638908863, 0.0591520331799984, 0.004478879738599062, -0.0215718112885952,
    -0.01091571245342493, -0.013446668162941933, -0.010138150304555893, 0.005777750629931688, 0.010422294959425926, 0.02455051802098751, 0.05576573684811592, -0.02484707161784172,
    -0.0050441799685359, 0.02501106821000576, -0.017201444134116173, -0.02861352637410164, 0.007133765146136284, -0.07595395296812057, -0.04256649687886238, 0.044663507491350174,
    0.0015900665894150734, -0.005394534673541784, -0.01301990170031786, -0.0329173319041729, -0.007082163821905851, 0.008074050769209862, -0.033680275082588196, -0.007767713628709316,
    -0.00011810489377239719, -0.007083479315042496, -0.0022537161130458117, 0.022064222022891045, -0.016319790855050087, 0.02445576712489128, -0.011253832839429379, -0.01977534405887127,
    -0.005628094542771578, 0.016423696652054787, -0.03279193490743637, -0.009604321792721748, 0.018098175525665283, -0.05058710649609566, 0.001136322971433401, 0.029961761087179184,
    -0.0037041984032839537, 0.009658675640821457, -0.02117268182337284, -0.016583550721406937, 0.007564783561974764, -0.0055529833771288395, 0.005913310684263706, 0.00914816651493311,
    0.009150970727205276, 0.022720759734511375, 0.03581118956208229, 0.02051195688545704, 0.04015069082379341, -0.010107303969562054, -0.013109731487929821, 0.03079964965581894,
    0.00021242776711005718, -0.023252375423908234, -0.009210167452692986, 0.0034845410846173763, -0.016392230987548828, 0.016452334821224213, -0.016530588269233704, -0.019724206998944283,
    0.028246797621250153, -0.019033359363675117, -0.0045768460258841515, 0.04105734825134277, -0.004646922927349806, 0.05188852921128273, -0.010749658569693565, -0.0007832737755961716,
    0.03185977414250374, -0.0012383287539705634, -0.03593096509575844, -0.0187828466296196, 0.02514423243701458, 0.0394226536154747, -0.012200312688946724, -0.006095772609114647,
    0.016836894676089287, -0.00446839677169919, -0.033885981887578964, 0.016544900834560394, -0.021644581109285355, -0.008847339078783989, -0.023092547431588173, -0.015476295724511147,
    0.051931098103523254, -0.027878616005182266, 0.0007891113054938614, -0.002768192207440734, 0.02495153248310089, -0.027873309329152107, -0.014170784503221512, 0.017227618023753166,
    -0.0297566968947649, -0.008449148386716843, 0.004145506303757429, 0.01809423416852951, 0.014090748503804207, -0.007368175778537989, -0.020038479939103127, 0.014574446715414524,
    0.02617431804537773, -0.01762908510863781, 0.011945029720664024, 0.011587027460336685, -0.01992533728480339, -0.07076212763786316, 0.018848780542612076, -0.0058770072646439075,
    -0.016946127638220787, 0.01374590490013361, 0.0067200916819274426, 0.0016020959010347724, 0.024944990873336792, -0.02504739724099636, -0.0399947427213192, -0.010964118875563145,
    -0.0469285249710083, 0.010778123512864113, -0.0026182630099356174, 0.014564241282641888, 0.0016516543691977859, -0.01840999349951744, 0.014629180543124676, -0.0006629775161854923,
    0.015221972018480301, 0.00699187908321619, -0.0061525520868599415, -0.04096125438809395, -0.011361138895154, -0.051551301032304764, -0.0081509193405509, 0.0003867825726047158,
    -0.009460811503231525, -0.027268681675195694, 0.020335573703050613, 0.01171319279819727, -0.03818731755018234, -0.019349193200469017, 0.026389772072434425, 0.0076903728768229485,
    0.014436054043471813, 0.04452686011791229, 0.014323958195745945, 0.0149824358522892, 0.003349865786731243, -0.009233538992702961, 0.020406195893883705, -0.005266355350613594,
    -0.023456135764718056, -0.006287379190325737, -0.0045670135878026485, 0.028067883104085922, -0.012117884121835232, 0.03749750182032585, 0.016997555270791054, 0.031026391312479973,
    0.01674349419772625, -0.005855259485542774, -0.05034914240241051, 0.0039284913800656796, -0.00043296697549521923, -0.01847224310040474, -0.012776940129697323, -0.01783265732228756,
    -0.012351798824965954, -0.023731939494609833, -0.013994112610816956, 0.008463159203529358, 0.017358602955937386, -0.004922889638692141, 0.04722120612859726, 0.02109336107969284,
    -0.015824053436517715, -0.0230593029409647, -0.009323971346020699, 0.031688254326581955, 0.01271181832998991, 0.03470761328935623, -0.06678618490695953, 0.03405657783150673,
    0.034248244017362595, -0.018088847398757935, -0.011087985709309578, 0.002595091937109828, -0.029053321108222008, 0.008662409149110317, 0.01571967639029026, -0.008533788844943047,
    -0.004394558724015951, -0.014023387804627419, -0.042579930275678635, 0.04359978437423706, 0.004184558056294918, -0.017863275483250618, 0.023320836946368217, 0.017858900129795074,
    0.025470111519098282, 0.018862219527363777, -0.0007779476582072675, -0.002777769463136792, -0.01186541747301817, -0.03504480794072151, -0.03089102916419506, 0.000558525207452476,
    0.02748391404747963, -0.02688019722700119, -0.0036262739449739456, 0.05108800157904625, 0.013484816066920757, -0.0234215147793293, -0.03286467492580414, 0.014433716423809528,
    0.0428912378847599, -0.0051492671482264996, 0.02907034009695053, -0.004184913355857134, -0.027591759338974953, 0.01374337449669838, 0.0012425117893144488, -0.011809066869318485,
    -0.00791552197188139, 0.013943176716566086, 0.008644615299999714, 0.022426702082157135, -0.02206459268927574, -0.10583510249853134, 0.010970543138682842, -0.019625019282102585,
    -0.0013971275184303522, 0.05804194137454033, -0.0406675860285759, 0.01853969320654869, 0.013845333829522133, -0.007516816258430481, -0.00046065147034823895, -0.02076081931591034,
    0.01128201000392437, 0.007718964945524931, 0.006657812278717756, -0.02805902250111103, 0.07365512102842331, 0.01725618913769722, 0.02159218117594719, 0.03411920741200447,
    -0.030847257003188133, -0.004165733233094215, -0.008406580425798893, -0.021538464352488518, 0.01635093241930008, 0.03170452639460564, 0.0029399695340543985, 0.023454926908016205,
    -0.01803937740623951, -0.01622597873210907, -0.02841501124203205, -0.0052425130270421505, -0.012461776845157146, -0.008109144866466522, -0.004686887841671705, -0.0006638976628892124,
    0.06375278532505035, 0.010948621667921543, 0.060762085020542145, 0.034769970923662186, 0.03161586448550224, -0.02387918159365654, 0.03896547108888626, 0.04109862074255943,
    0.04491246119141579, -0.026956189423799515, 0.018447525799274445, 0.022990038618445396, 0.04933183267712593, -0.039712417870759964, 0.011859348975121975, -0.0011506229639053345,
    0.023918485268950462, -0.016516849398612976, 0.021517861634492874, -0.01157741341739893, -0.011096994392573833, 0.0017997274408116937, -0.015525797381997108, -0.015130299143493176,
    -0.02185961604118347, 0.018365759402513504, 0.011643502861261368, 0.008621906861662865, 0.01496258657425642, 0.02141270413994789, -0.030626559630036354, -0.0016162216197699308,
    -0.005408336408436298, -0.013998948037624359, 0.009907948784530163, -0.02584039606153965, -0.019042955711483955, 0.012117014266550541, 0.0001732030650600791, -0.031478144228458405,
    0.006543985102325678, 0.043259818106889725, 0.013583363965153694, 0.007953782565891743, -0.01798817329108715, -0.061123378574848175, 0.022411158308386803, 0.011163500137627125,
    -0.06469805538654327, -0.0021120181772857904, -0.02795356698334217, -0.020370323210954666, -0.022878875955939293, -0.018690230324864388, 0.014928407967090607, -0.010679845698177814,
    -0.0249362513422966, 0.0281009953469038, -0.009868315421044827, 0.00841772835701704, 0.009260262362658978, 0.019940411671996117, 0.028514891862869263, -0.01003135647624731,
    0.006262637209147215, -0.019426411017775536, -0.003230602014809847, 0.04521465674042702, -0.0007679872214794159, 0.03473546355962753, 0.0072176093235611916, -0.01019771583378315,
    0.01115006860345602, -0.0174334105104208, 0.015996133908629417, 0.01803000457584858, 0.019262492656707764, -0.0012798403622582555, -0.008486557751893997, 0.0017271782271564007,
    -0.019607674330472946, -0.018963562324643135, 0.02850821055471897, -0.027988024055957794, -0.012986643239855766, 0.015660643577575684, -0.003421288449317217, -0.013937040232121944,
    -0.029205122962594032, 0.002041586907580495, -0.012586168013513088, 0.009219219908118248, -0.015234001912176609, 0.008492567576467991, 0.044121526181697845, -0.020589236170053482,
    0.002711466746404767, -0.002978287637233734, 0.005740445107221603, 0.006994887720793486, 0.037652093917131424, -0.03573654964566231, 0.004125120118260384, -0.019051706418395042,
    0.04999912902712822, 0.05055559426546097, -0.05193258076906204, -0.017563117668032646, -0.038991834968328476, 0.02386055700480938, 0.02296009473502636, 0.022662779316306114,
    0.019047921523451805, -0.0014656021958217025, -0.0027346783317625523, 0.012251201085746288, 0.008634950034320354, 0.016426851972937584, -0.002316477242857218, -0.018657615408301353,
    -0.017203614115715027, -2.589183350210078e-05, 0.030001696199178696, 0.03840038552880287, 0.032845307141542435, -0.01374108251184225, -0.010605206713080406, -0.007245537359267473,
    -0.03513629361987114, 0.012450138106942177, -0.027858279645442963, 0.008311363868415356, -0.011784153059124947, 0.009236199781298637, 0.03795721381902695, -0.017526360228657722,
    0.027475059032440186, 0.058139171451330185, -0.0013881007907912135, -0.013884871266782284, 0.021964456886053085, -0.014414869248867035, -0.008595102466642857, 0.008776376955211163,
    0.04510391503572464, -0.02655026689171791, 0.02012799307703972, 0.015323718078434467, 0.004691294860094786, -0.004589641932398081, -0.05732063576579094, 0.034071289002895355,
    0.0075513990595936775, 0.030926065519452095, -0.022311067208647728, 0.0022776219993829727, -0.03745756670832634, -0.037460342049598694, -0.005755470599979162, 0.04193127527832985,
    -0.03591155633330345, 0.04515238106250763, -0.006512342486530542, 0.008009621873497963, 0.003082800656557083, 0.00984539370983839, 0.0011204590555280447, -0.023391369730234146,
    0.011213709600269794, 0.006706695072352886, -0.03830863535404205, -0.004309969488531351, -0.024722091853618622, 0.0011951240012422204, -0.056471165269613266, 0.012432098388671875,
    -0.024892795830965042, -0.007538493722677231, -0.05068490654230118, -0.03686811402440071, -0.03135251998901367, -0.00031410405063070357, 0.06200206279754639, 0.02738076262176037,
    -0.011001463048160076, 0.00724051333963871, -0.028213009238243103, 0.008453239686787128, -0.04334264248609543, 0.003117944812402129, -0.0045739226043224335, -0.002450210740789771,
    0.05721557140350342, 0.009697779081761837, -0.02098628506064415, -0.028209179639816284, 0.04141448438167572, -0.06326807290315628, -0.03884243592619896, -0.02414834499359131,
    0.025083361193537712, 0.029896298423409462, 0.009319227188825607, -0.01141247060149908, -0.0025971997529268265, -0.013847212307155132, -0.003554552560672164, 0.027977336198091507,
    0.015199719928205013, 0.016725772991776466, 0.02531607635319233, -0.0021164813078939915, -0.04219454899430275, -0.005957427900284529, -0.008875289000570774, -0.030056623741984367,
    -0.010373453609645367, -0.030641354620456696, -0.0190721545368433, -0.029826121404767036, -0.0017573356162756681, -0.00237251166254282, -0.040648460388183594, 0.04957078397274017,
    -0.019298970699310303, 0.08763688057661057, 0.006317701190710068, 0.018989628180861473, 0.028294794261455536, 0.07468503713607788, 0.04107914865016937, 0.007267044857144356,
    0.026397204026579857, -0.003131169592961669, 0.025570135563611984, 0.033760398626327515, 0.007052736356854439, 0.013314444571733475, 0.012860381975769997, 0.0019335522083565593,
    -0.028951816260814667, 0.010383250191807747, -0.0023463580291718245, -0.026229120790958405, -0.012557742185890675, -0.005784642416983843, -0.03597021847963333, 0.02144894376397133,
    -0.03692648932337761, 0.0026704841293394566, 0.05169010907411575, 0.01387351006269455, 0.039637383073568344, 0.07881024479866028, -0.02873392403125763, -0.020787687972187996,
    0.0007238435209728777, -0.00745379226282239, -0.011165198870003223, 0.05038127303123474, -0.025755945593118668, -0.04302814230322838, -0.01115896925330162, -0.019551998004317284,
    0.02515898086130619, -0.002728976309299469, 0.014175541698932648, 0.027587732300162315, 0.034860894083976746, -0.017275720834732056, 0.02743685059249401, 0.029332509264349937,
    -0.01686719059944153, -0.0007798881852068007, 0.008198064751923084, -0.009811421856284142, 0.014856535010039806, -0.005423068068921566, 0.017639271914958954, -0.012262789532542229,
    -0.0001260645076399669, 0.029579583555459976, 0.004893421195447445, 0.032086364924907684, -0.028520138934254646, -0.016444720327854156, -0.049656517803668976, 0.07140973210334778,
    0.019078580662608147, 0.025676459074020386, 0.015521801076829433, -0.0003961608454119414, 0.05033641308546066, -0.001517649507150054, -0.003060764167457819, 0.0137157728895545,
    -0.021664122119545937, 0.0044145407155156136, 0.0305938757956028, 0.029475264251232147, -0.020505283027887344, -0.030448822304606438, -0.0008684723870828748, -0.028194095939397812,
    -0.0002735808084253222, 0.026996498927474022, -0.016246501356363297, 0.04087596759200096, -0.028675319626927376, 0.02125452272593975, 0.009070572443306446, 0.0008374546305276453,
    0.03244118019938469, 0.026219001039862633, -0.0148637555539608, 0.057987358421087265, 0.028185755014419556, 0.004408599343150854, -0.01771785132586956, 0.012329376302659512,
    -0.04184059798717499, 0.016148345544934273, 0.02517298236489296, 0.0075072916224598885, -0.012822399847209454, 0.03921715170145035, 0.0012681446969509125, -0.0011799613712355494,
    0.036835890263319016, -0.03589199483394623, 0.02229490876197815, -0.015766702592372894, -0.03216297924518585, 0.006969545502215624, -0.032212693244218826, -0.008573523722589016,
    -0.00845912005752325, -0.040739547461271286, -0.038957614451646805, 0.00985218770802021, 0.021352505311369896, -0.0259815976023674, -0.031853027641773224, -0.01489019114524126,
    -0.006562881637364626, -0.015225839801132679, -0.005369872320443392, 0.009308540262281895, 0.06126580759882927, -0.05058373510837555, 0.017668364569544792, -0.020242774859070778,
    -0.04536375030875206, 0.028652917593717575, 0.00601274985820055, -0.01841181516647339, 0.04054156318306923, -0.056653980165719986, -0.0005868492880836129, -0.0178061593323946,
    0.02434004284441471, 0.02835799939930439, -0.010285359807312489, -0.018478969112038612, -0.0008970052585937083, 0.014239399693906307, 0.05188482627272606, 0.019620252773165703,
    -0.014154802076518536, -0.04791555181145668, -0.01070514228194952, -0.04735420644283295, 0.047929611057043076, -0.015520738437771797, -0.0388774611055851, -0.011906127445399761,
    0.02081351727247238, 0.03752577304840088, -0.02262702025473118, 0.006726754829287529, 0.013986080884933472, 0.013865373097360134, 0.014676319435238838, -0.00997219793498516,
    0.01637241803109646, -0.0010839771712198853, 0.007952796295285225, -0.0014802520163357258, -0.008297337219119072, -0.007280005607753992, 0.011300631798803806, 0.011730621568858624,
    0.003946583718061447, 0.01138241495937109, 0.014828136190772057, -0.004820016212761402, -0.010826447047293186, -0.000284964480670169, -0.027975820004940033, -0.01675550825893879,
    0.029460718855261803, 0.03668695315718651, 0.019397009164094925, -0.005512358620762825, 0.016234315931797028, 0.018785696476697922, -0.04741726070642471, 0.013761501759290695,
    0.008786161430180073, 0.0265731792896986, 0.06608374416828156, -0.007902175188064575, -0.04937542602419853, -0.02668275125324726, -0.02653919719159603, 0.0008353531593456864,
    -0.016168437898159027, -0.028820861130952835, -0.0004007579991593957, -0.03928997740149498, 0.020376835018396378, 0.029138285666704178, -0.005588177125900984, -0.028459813445806503,
    -0.02372722513973713, -0.02005343697965145, 0.031234968453645706, -0.014173365198075771, -0.006789945997297764, 0.00878196768462658, -0.035081759095191956, 0.04280271381139755,
    0.02202078327536583, -0.04764930158853531, -0.02978757955133915, 0.013014009222388268, 0.022172609344124794, -0.06213322654366493, 0.007159613538533449, -0.024940168485045433,
    0.042430225759744644, 0.01875085011124611, 0.008363106288015842, 0.014477142132818699, 0.01316004153341055, -0.04246737062931061, 0.010035282000899315, -0.03436695784330368,
    0.04481028392910957, -0.007660452742129564, 0.013393289409577847, -0.04567503556609154, -0.025684073567390442, 0.014919289387762547, 0.02105391025543213, -0.01628481037914753,
    0.013542463071644306, 0.004730698652565479, 0.02546195313334465, 0.006332830060273409, -0.02003757655620575, -0.020579159259796143, 0.005678440444171429, 0.018617169931530952,
    0.009439331479370594, 0.036656975746154785, 0.042996715754270554, -0.01015094667673111, 0.02208254113793373, 0.049311671406030655, 0.011495593003928661, 0.010715976357460022,
    -0.01509199570864439, -0.032995082437992096, 0.006029827054589987, -0.005272623151540756, -0.010964254848659039, 0.030892422422766685, -0.03178483620285988, -0.0165950208902359,
    -0.04084101691842079, -0.0016038039466366172, 0.027269693091511726, 0.013995682820677757, -0.044041115790605545, 0.02539185993373394, 0.017773734405636787, 0.0004099687503185123,
    0.009234935976564884, 0.03309261426329613, 0.006820350419729948, 0.029430771246552467, 0.0010548513382673264, 0.07364588975906372, 0.05300242453813553, 0.017908217385411263,
    -0.02690815180540085, 0.011375081725418568, -0.01358606293797493, 0.06462044268846512, 0.02625589817762375, -0.057553406804800034, -0.029621919617056847, -0.031156333163380623,
    -0.007145969197154045, -0.023504363372921944, 0.022972261533141136, 0.015451029874384403, -0.010115643963217735, 0.023681441321969032, 0.04806861653923988, -0.009200619533658028,
    -0.014685502275824547, 0.004893774166703224, 0.015497086569666862, 0.013599212281405926, 0.008674881421029568, -0.008133221417665482, 0.03705020248889923, 0.015443996526300907,
    -0.012485001236200333, -0.03565644845366478, 0.03241771087050438, 0.002396690659224987, 0.08502786606550217, 0.0013403422199189663, 0.02214132435619831, 0.03395522013306618,
    -0.031442560255527496, -0.01596805453300476, 0.009642799384891987, -0.012091830372810364, 0.026886843144893646, 0.019240232184529305, -0.02259240485727787, 0.04639910161495209,
    -0.014305122196674347, 0.03219938650727272, 0.0015611052513122559, -0.022101271897554398, 0.005413437727838755, -0.043185412883758545, -0.021708736196160316, 0.0006695552146993577,
    -0.00318660750053823, 0.018652526661753654, 0.03984452411532402, -0.01379360631108284, -0.021268509328365326, 0.036915816366672516, 0.023578228428959846, 0.025428658351302147,
    0.00995126273483038, 0.018742216750979424, -0.04253189265727997, -0.011797319166362286, -0.0010581058450043201, -0.013631626963615417, 0.004168157931417227, -0.024429738521575928,
    0.015853190794587135, 0.026080673560500145, -0.03560461103916168, 0.009955832734704018, -0.018592169508337975, -0.02648332342505455, 0.03365083038806915, 0.02262212336063385,
    -0.018917759880423546, 0.03508282080292702, 0.02686939761042595, 0.003903876757249236, -0.0020554023794829845, 0.02586173638701439, -0.00963913556188345, 0.02681143581867218,
    0.0005945163429714739, 0.0019294708035886288, 0.022024214267730713, 0.008932766504585743, 0.011882582679390907, 0.003325224854052067, 0.009025359526276588, 0.009880462661385536,
    -0.001295094145461917, -0.0072257728315889835, -0.01048081461340189, -0.016281701624393463, -0.04272918403148651, 0.002295447513461113, -0.04315141215920448, 0.029613012447953224,
    -0.012742109596729279, -0.025622569024562836, 0.003489105496555567, -0.010612989775836468, -0.003124467097222805, -0.056981928646564484, -0.02762482315301895, -0.011786243878304958,
    -0.043833352625370026, -0.019378075376152992, 0.03324425220489502, 0.00846230611205101, 0.018710993230342865, 0.039637092500925064, 0.005870099179446697, -0.010386120527982712,
    -0.02734638936817646, 0.035057224333286285, -0.022228941321372986, -0.000247416173806414, -0.0360245443880558, 0.02594856545329094, -0.038852863013744354, 0.01928488165140152,
    -0.06689979881048203, -0.0052747949957847595, -0.052071984857320786, -0.005976186133921146, 0.0010325240436941385, -0.007205665111541748, 0.04838845878839493, -0.023177722468972206,
    0.05422959849238396, 0.049269769340753555, 5.620628940050665e-07, -0.018543818965554237, -0.0036192438565194607, 0.024535899981856346, -0.011592698283493519, 0.061531662940979004,
    -0.024689974263310432, -0.03824908286333084, 0.007519785314798355, -0.019546663388609886, 0.026015566661953926, 0.039971478283405304, -0.03303402662277222, -0.015890752896666527,
    0.03238862752914429, 0.005287683568894863, -0.00934298150241375, 0.07061659544706345, -0.04293835535645485, 0.0018859121482819319, 0.01785583607852459, 0.04441714659333229,
    -0.005445630755275488, 0.03172469884157181, 0.024442972615361214, -0.005898650735616684, 0.006492101587355137, 0.006970976013690233, -0.034136563539505005, -0.0021132847759872675,
    0.031211772933602333, -0.00533116003498435, 0.012613698840141296, 0.007567871827632189, -0.009084533900022507, 0.013307435438036919, 0.01213966403156519, 0.0032925966661423445,
    0.024744482710957527, 0.05493297055363655, 0.025684542953968048, 0.008579439483582973, 0.002568256575614214, 0.007200820837169886, -0.020562851801514626, -0.026425695046782494,
    0.016812719404697418, -0.005871239583939314, -0.008921553380787373, 0.007333480753004551, 0.03287956118583679, 0.0007952245068736374, -0.024926766753196716, -0.008011909201741219,
    0.02026055008172989, -1.4471709619101603e-05, 0.008505100384354591, -0.0003776823577936739, -0.0169727373868227, -0.02714947611093521, 0.023140965029597282, -0.002007201313972473,
    0.0068360730074346066, -0.0034624168183654547, -0.008071626536548138, 0.016171852126717567, 0.009034162387251854, 0.01316797360777855, -0.010723922401666641, -0.007099571637809277,
    0.03364027291536331, 0.025090163573622704, 0.017619093880057335, 0.00041491517913527787, -0.010431887581944466, -0.005155900027602911, 0.01194201409816742, -0.010881251655519009,
    -0.0339258536696434, 0.01894119754433632, -0.008593620732426643, -0.020319240167737007, 0.010208338499069214, 0.01206650584936142, -0.0018122325418516994, -0.00549993384629488,
    0.018813686445355415, 0.0036730088759213686, 0.027770282700657845, 0.053497668355703354, -0.0009340716642327607, -0.011952619068324566, -0.029622863978147507, 0.03455555811524391,
    0.038389332592487335, 0.03317045047879219, 0.0011937720701098442, -0.005766134709119797, -0.013475610874593258, 0.007141408510506153, 0.015532190911471844, -0.053268056362867355,
    -0.0442589670419693, 0.013700048439204693, -0.011747827753424644, -0.02029312402009964, -0.035447053611278534, -0.021455498412251472, -0.010316897183656693, -0.02467845194041729,
    -0.032302532345056534, -0.0035650788340717554, -0.0047081513330340385, 0.009719877503812313, 0.018174799159169197, 0.03031843528151512, -0.006542701739817858, 0.017358407378196716,
    -0.01824260503053665, 0.0070193191058933735, -0.012504814192652702, -0.03464674577116966, 0.0006858690176159143, -0.002265509683638811, 0.0444641038775444, -0.014009561389684677,
    -0.001181615749374032, -0.005323219113051891, 0.001229692716151476, 0.025131922215223312, 0.011125395074486732, 0.009921440854668617, 0.02576037123799324, -0.025489671155810356,
    0.007830040529370308, 0.0009491578093729913, 0.020415639504790306, 0.040097516030073166, 0.007620100397616625, 1.963847898878157e-05, 0.014788554981350899, -0.015582534484565258,
    -0.015143058262765408, -0.00028889678651466966, 0.012181384488940239, 0.015693578869104385, 0.02178223803639412, 0.014052208513021469, -0.011751842685043812, 0.029126040637493134,
    0.006268635392189026, 0.024065367877483368, -0.00446265609934926, 0.004452893510460854, -0.018553173169493675, 0.002610008465126157, -0.020764393731951714, 0.01759595051407814,
    -0.008000320754945278, 0.004801695700734854, -0.01675187423825264, 0.022631416097283363, -0.014647871255874634, 0.011526507325470448, -0.010326852090656757, -0.003120221896097064,
    -0.0005215734126977623, -0.04125872999429703, 0.01765626110136509, 0.011122646741569042, -0.011638340540230274, -0.0019431606633588672, -0.010979140177369118, 0.02365412935614586,
    -0.009571182541549206, 0.002587366383522749, -0.007312732748687267, 0.004829170182347298, -0.011105281300842762, 0.012849047780036926, -0.0014147124020382762, 0.000744577613659203,
    -0.014929312281310558, -0.008445619605481625, -0.0080953324213624, -0.016803031787276268, -0.006820274516940117, -0.00742122158408165, -0.016633329913020134, -0.0013640562538057566,
    -0.019426923245191574, 0.02108587883412838, -0.037098392844200134, -0.005312116350978613, 0.009310952387750149, -0.024518730118870735, 0.0010754341492429376, -0.0001773526455508545,
    0.0063097476959228516, -0.007902557030320168, 0.02243238128721714, 0.005324424244463444, -0.0023847573902457952, -0.011256246827542782, -0.008818111382424831, -0.008268673904240131,
    0.0004483910743147135, 0.006131043191999197, 0.0030068946070969105, 0.013834460638463497, -0.007380193565040827, -0.015126548707485199, -0.0019115391187369823, -0.0004168587038293481,
    -0.007762865629047155, 0.00970008596777916, 0.002119222888723016, 0.00840578693896532, 0.0077920351177453995, 0.01304713636636734, -0.010500096715986729, 0.009641358628869057,
    -0.012953422963619232, 0.00848652794957161, 0.023494679480791092, 0.004167438950389624, 0.03586232662200928, -0.00032600597478449345, 0.00793276447802782, -0.009981732815504074,
    0.010529356077313423, -0.0020044532138854265, 0.022781573235988617, 0.013261127285659313, 0.003459702478721738, -0.011050759814679623, -0.005974560044705868, -0.012536836788058281,
    -0.009333609603345394, -0.0197704266756773, -0.0049009318463504314, 0.002974218223243952, 0.019215524196624756, -0.038174621760845184, -0.014078941196203232, -0.006093717645853758,
    -0.016278252005577087, -0.003573054913431406, -0.0021663904190063477, 0.011352069675922394, 0.0015516391722485423, 0.01911146193742752, -0.004184185527265072, 0.0012333843624219298,
    0.02787487767636776, 0.004045508801937103, -0.0010139687219634652, 0.013758805580437183, 0.017681024968624115, 0.0017582080326974392, -0.0020165559835731983, -0.006922454107552767,
    -0.0011037648655474186, 0.003834634553641081, 0.008285420946776867, -0.0032189954072237015, 0.00397098483517766, 0.03115464560687542, -0.0004108439607080072, -0.0016715326346457005,
    -0.016165519133210182, -0.040465500205755234, -0.0014325513038784266, -0.08468865603208542, 0.058106400072574615, -0.026369715109467506, 0.018695883452892303, 0.08232514560222626,
    -0.048528362065553665, 0.043570056557655334, 0.019823482260107994, 0.04398185759782791, -0.02880903333425522, -0.05617634579539299, -0.0551508367061615, 0.026192959398031235,
    -0.005681701935827732, -0.06434883922338486, 0.054006148129701614, 0.00250354316085577, 0.004508419428020716, 0.0024015684612095356, -0.019491389393806458, -0.048397984355688095,
    -0.005133527331054211, 0.010977651923894882, -0.023131776601076126, -0.05746592581272125, 7.555771844636183e-06, -0.05467316508293152, 0.017652025446295738, 0.03863103315234184,
    0.03882352262735367, -0.04798213392496109, 0.06248130649328232, 0.027309341356158257, -0.03003671020269394, 0.048262760043144226, 0.041682783514261246, -0.01344306766986847,
    0.012054631486535072, -0.04150071367621422, -0.0007157534128054976, 0.02642035111784935, 0.046175647526979446, 0.019993755966424942, -0.05992279574275017, -0.050485759973526,
    -0.031996533274650574, -0.06892140954732895, 0.049976736307144165, 0.004330337513238192, 0.05918769910931587, 0.10833846777677536, 0.003919433336704969, 0.017770808190107346,
    -0.03155180811882019, 0.025301368907094002, 0.0025047152303159237, 0.04744084179401398, 0.0045251259580254555, 0.022747883573174477, -0.004212606698274612, -0.08384684473276138,
    0.004795482382178307, 0.02675596997141838, 0.0094031086191535, 0.04443507641553879, -0.050572723150253296, -0.05600783973932266, -0.03295763209462166, -0.03264965862035751,
    0.029738649725914, 0.05507194250822067, 0.08228065073490143, 0.028417011722922325, -0.028295518830418587, -0.008647470735013485, -0.0020385445095598698, 0.00982695072889328,
    -0.028615254908800125, 0.03115367330610752, -0.03297090902924538, -0.021677369251847267, -0.01099600363522768, -0.030166763812303543, 0.04810990020632744, -0.059363629668951035,
    0.03785582259297371, -0.00956730730831623, -0.0059951432049274445, 0.014210810884833336, 0.04744040593504906, -0.0009728838340379298, -0.035470083355903625, -0.06869345903396606,
    -0.06801838427782059, -0.08327919244766235, 0.015088825486600399, -0.015444853343069553, 0.021463802084326744, 0.03633078187704086, -0.01944706030189991, 0.046264320611953735,
    0.03446708992123604, -0.034972891211509705, -0.009318161755800247, -0.05206536874175072, -0.06346290558576584, 0.04643382504582405, -0.02220533974468708, -0.008169555105268955,
    0.01164464745670557, -0.05519062280654907, -0.014743583276867867, -0.0013555273180827498, 0.074619360268116, 0.006708154454827309, -0.023167628794908524, -0.019906066358089447,
    -0.0242625679820776, 0.03837209194898605, -0.0015824590809643269, -0.024274958297610283, 0.026106957346200943, 0.058038294315338135, 0.05581691861152649, -0.06013892590999603,
    0.014583333395421505, -0.07718242704868317, -0.006508378311991692, -0.022959042340517044, 0.04029378294944763, 0.004372673574835062, 0.054654330015182495, 0.007754056248813868,
    0.022446079179644585, 0.018477557227015495, 0.07835467904806137, -0.010822029784321785, -0.03722968325018883, -0.013891623355448246, -0.03442012146115303, -0.033019956201314926,
    -0.050200846046209335, -0.03500073030591011, 0.00748061528429389, 0.013002987951040268, 0.01695951074361801, -0.010664612986147404, -0.005401131231337786, -0.05808856338262558,
    -0.0254798736423254, 0.02088632620871067, 0.0890745148062706, 0.08974534273147583, -0.013484841212630272, 0.044815097004175186, 0.016358641907572746, 0.07141519337892532,
    0.0502195805311203, 0.019026704132556915, -0.0020512607879936695, -0.05371404439210892, -0.01709854044020176, -0.012973993085324764, -0.01650436781346798, -0.032919418066740036,
    0.0027616946026682854, 0.04172501340508461, 0.013483534567058086, -0.03589532524347305, 0.04177897796034813, 0.04486191272735596, -0.07313904911279678, 0.0060528055764734745,
    0.02906099706888199, -0.030615484341979027, 0.003725024638697505, 0.013561215251684189, -0.05869624391198158, -0.006879803258925676, -0.047356411814689636, -0.05963936820626259,
    0.01910684071481228, 0.056642066687345505, 0.020327476784586906, 0.04276919364929199, -0.01076805405318737, 0.06261633336544037, -0.03293290734291077, 0.02033216319978237,
    0.04897871986031532, -0.0007693858933635056, -0.022693151608109474, -0.022875932976603508, 0.0524592287838459, -0.032555658370256424, -0.058444131165742874, 0.01571197807788849,
    0.04389909654855728, 0.026979960501194, 0.013721747323870659, 0.0060872663743793964, -0.02159029431641102, -0.021406812593340874, 0.012716464698314667, -0.023423371836543083,
    -0.001483933418057859, -0.01650991290807724, -0.03595474362373352, 0.04471801966428757, -0.018771439790725708, 0.061650436371564865, -0.01604064367711544, -0.08623416721820831,
    0.05614534020423889, 0.05563401058316231, 0.02209766022861004, -0.030089719220995903, 0.015746010467410088, -0.029305599629878998, 0.08001017570495605, -0.027136603370308876,
    -0.007840346544981003, -0.09635122120380402, -0.0017547780880704522, -0.007003383245319128, -0.032225869596004486, 0.01835988461971283, 0.03675641492009163, 0.026844611391425133,
    -0.0077653685584664345, 0.003405302297323942, 0.00805103313177824, -0.020522788166999817, -0.043478723615407944, 0.018732652068138123, -0.04885753244161606, 0.03313048556447029,
    0.003568307962268591, -0.00017709530948195606, 0.0512961782515049, 0.08291354030370712, -0.08242405951023102, -0.0009695091866888106, 0.07210393249988556, -0.008435520343482494,
    -0.04762463644146919, 0.014755167067050934, 0.014426068402826786, 0.020941486582159996, 0.008863291703164577, -0.05694660544395447, -0.02836054377257824, 0.010668507777154446,
    -0.020651770755648613, 0.04832467809319496, -0.014856565743684769, 0.006745892111212015, 0.01215515285730362, -0.011178291402757168, 0.03182901814579964, 0.024651966989040375,
    0.053437571972608566, 0.004662561696022749, 0.03489086031913757, 0.008937480859458447, 0.002920307219028473, -0.005674854852259159, 0.07515835016965866, -0.021233469247817993,
    -0.054384324699640274, -0.043689146637916565, -0.003850066103041172, 0.09174104034900665, 0.003086721757426858, -0.05118585377931595, -0.053287800401449203, 0.011613347567617893,
    0.06684194505214691, 0.00890438910573721, 0.06122157350182533, 0.048130277544260025, -0.06310480833053589, 0.029145946726202965, -0.0017731565749272704, 0.010853498242795467,
    -0.013011448085308075, 0.03742334246635437, -0.054569512605667114, 0.021237144246697426, -0.0012996563455089927, -0.023146776482462883, 0.03667818009853363, 0.03420264646410942,
    -0.025388941168785095, 0.03655340522527695, 0.002956625772640109, -0.02787940576672554, -0.0326656773686409, 0.0452357716858387, 0.0435895137488842, 0.02504478581249714,
    0.08832644671201706, -0.006664998829364777, -0.08116143941879272, 0.000531758472789079, -0.07724960893392563, 0.0036625186912715435, 0.05262862145900726, -0.09999076277017593,
    0.03845386952161789, 0.1026797816157341, 0.008808964863419533, 0.023157943040132523, -0.00462802080437541, 0.029088197275996208, 0.0006065090419724584, 0.08220638334751129,
    0.00621424475684762, -0.013325630687177181, -0.01360820047557354, -0.0297696590423584, -0.0029223232995718718, -0.029688946902751923, 0.010390670038759708, 0.09647904336452484,
    -0.0089044738560915, -0.016490859910845757, -0.13174287974834442, -0.0014139307895675302, -0.006675753742456436, -0.050439272075891495, 0.004866462666541338, 0.06043429300189018,
    -0.010842589661478996, 0.051782745867967606, -0.05163221433758736, 0.012443277053534985, 0.03884951397776604, -0.006958646234124899, -0.03236197307705879, 0.07727885991334915,
    -0.0057107238098979, -0.041418321430683136, 0.04918709769845009, -0.09933124482631683, -0.023467931896448135, -0.011018146760761738, 0.0217161625623703, 0.03931039199233055,
    0.04091913253068924, -0.0019566724076867104, 0.07222535461187363, -0.03720255568623543, -0.05504237487912178, -0.056232694536447525, 0.03263172507286072, -0.045686449855566025,
    -0.01779463142156601, -0.04117640480399132, -0.044642671942710876, 0.007258774247020483, 0.0016988132847473025, -0.0620516873896122, -0.04062751308083534, -0.028884144499897957,
    -0.01537716668099165, 0.038858190178871155, -0.08863566815853119, 0.02053518407046795, -0.03012964315712452, 0.005307661835104227, 0.01922798715531826, -0.06753010302782059,
    -0.02505144290626049, 0.01750831864774227, -0.11547376960515976, 0.06409672647714615, 0.05115573853254318, -0.05079912394285202, -0.021751590073108673, 0.04825663939118385,
    0.01230713538825512, 0.08420158177614212, -0.030464770272374153, -0.028669293969869614, 0.03607964143157005, 0.04055913910269737, -0.03960380330681801, 0.03673247992992401,
    0.03961646556854248, -0.05793529003858566, -0.00042420634417794645, -0.07244961708784103, 0.006166243460029364, 0.04813607782125473, 0.08321654051542282, 0.02394820749759674,
    0.01718744821846485, 0.002134801587089896, 0.009840701706707478, 0.026389388367533684, -0.06363003700971603, 0.00713311554864049, 0.03384467214345932, 0.024011705070734024,
    0.046285003423690796, -0.011194244958460331, 0.027929382398724556, -0.04475836455821991, -0.03075813688337803, 0.002713123569265008, 0.029378661885857582, -0.018944459035992622,
    -0.05271761864423752, 0.042461369186639786, 0.03286591172218323, -0.02408178150653839, 0.031085321679711342, -0.030147189274430275, -0.03735983744263649, -0.028387198224663734,
    0.039789412170648575, 0.010020172223448753, -0.009307831525802612, -0.00913678016513586, -0.009267502464354038, -0.05078201740980148, 0.15707598626613617, 0.030579840764403343,
    -0.009176613762974739, 0.048978205770254135, -0.07801561802625656, -0.009828486479818821, 0.001515085343271494, 0.03142750263214111, 0.009546446613967419, 0.04927929863333702,
    0.05313713103532791, 0.012047914788126945, 0.010890579782426357, 0.009051414206624031, 0.02219797670841217, 0.026029223576188087, 0.011787427589297295, -0.007346803788095713,
    0.07007201761007309, 0.03155798837542534, -0.04574054479598999, 0.007867885753512383, -0.041268352419137955, -0.05032031610608101, 0.020121697336435318, 0.014307502657175064,
    0.08170918375253677, 0.028092237189412117, -0.02988172322511673, 0.05993248149752617, -0.06163638085126877, 0.028390638530254364, 0.09812767058610916, -0.013756129890680313,
    0.0471588559448719, -0.03632451593875885, -0.06208798289299011, -0.042743176221847534, -0.02552245743572712, 0.01812528446316719, 0.03455953672528267, 0.01991247944533825,
    -0.03715556487441063, -0.06497541815042496, 0.054228801280260086, -0.009963737800717354, 0.021276455372571945, -0.03662151098251343, -0.02845987305045128, 0.0002519143745303154,
    0.02604297362267971, 0.05741479992866516, -0.05454865097999573, -0.00018913179519586265, -0.003121813992038369, -0.007542097475379705, -0.022408632561564445, -0.08467841148376465,
    -0.013685441575944424, 0.0032023251987993717, -0.012546638958156109, -0.05280075594782829, 0.021553436294198036, -0.009445063769817352, 0.024090830236673355, 0.029167812317609787,
    0.007596180308610201, -0.04475827142596245, 0.08663342893123627, -0.027673153206706047, 0.039912328124046326, 0.008190118707716465, -0.07994785159826279, 0.12600070238113403,
    -0.017986763268709183, 0.03369636461138725, -0.023053333163261414, 0.003400699468329549, 0.001957029104232788, -0.06323672086000443, 0.0920901820063591, -0.008513704873621464,
    -0.02936309576034546, -0.027283359318971634, 0.03875530883669853, 0.019094986841082573, 0.02250375598669052, -0.05201607570052147, -0.08023789525032043, 0.01300280075520277,
    -0.031807221472263336, -0.014925436116755009, 0.06507263332605362, -0.02236282080411911, -0.019997484982013702, -0.027774982154369354, -0.03571191430091858, -0.04586077108979225,
    0.05650884285569191, -0.000774722546339035, -0.001624132739380002, 0.0886898934841156, 0.028152702376246452, 0.06038739159703255, -0.02518393099308014, 0.016842877492308617,
    -0.023648440837860107, 0.057771045714616776, -0.016093315556645393, -0.009112809784710407, -0.044504959136247635, -8.882700058165938e-06, -0.013591928407549858, 0.013695158995687962,
    0.011422530747950077, -0.020500024780631065, 0.06390341371297836, -0.02670925483107567, 0.040435951203107834, -0.0016483227955177426, 0.003563836682587862, -0.030575260519981384,
    0.11033224314451218, -0.05775880813598633, 0.02290310710668564, -0.05599866434931755, -0.052104055881500244, 0.03779766336083412, 0.055938802659511566, -0.08527539670467377,
    -0.05014411360025406, -0.04311558976769447, 0.05931194871664047, 0.03985951468348503, 0.020868554711341858, -0.05294908210635185, -0.043078113347291946, 0.028940165415406227,
    0.023621881380677223, -0.06716088205575943, -0.006557035725563765, -0.007998224347829819, -0.0581703819334507, 0.01410476304590702, -0.003077792702242732, -0.06304033100605011,
    -0.005829831585288048, -0.01876566745340824, -0.03353720158338547, 0.030107533559203148, -0.05686134099960327, -0.011416660621762276, 0.04636571183800697, -0.04290133714675903,
    0.08571815490722656, 0.02631497196853161, 0.02585628256201744, -0.011243173852562904, -0.05691314861178398, 0.060391493141651154, 0.11595702171325684, -0.032032739371061325,
    0.029558751732110977, 0.016413137316703796, -0.004142283461987972, 0.013651817105710506, -0.07985106110572815, 0.046067725867033005, -0.004973452538251877, -0.07019353657960892,
    -0.00021010656200814992, -0.06851170212030411, 0.0067079639993608, -0.012658081017434597, 0.0032012269366532564, -0.005905702710151672, -0.06446844339370728, 0.002534101251512766,
    -0.022450385615229607, 0.05226089432835579, 0.000753127271309495, 0.05078468471765518, 0.0101909339427948, 0.007728156168013811, -0.046185389161109924, -0.014076678082346916,
    0.00015947705833241343, 0.046572040766477585, 0.012583550997078419, -0.010240500792860985, 0.007785534951835871, 0.0364728607237339, 0.01786629669368267, -0.01801937259733677,
    0.0037959921173751354, -0.07184057682752609, -0.11022678762674332, -0.03153381496667862, 0.028247814625501633, 0.061487190425395966, 0.029023444280028343, -0.14540110528469086,
    -0.00720068858936429, 0.005737693049013615, 0.02529710903763771, -0.008462682366371155, -0.06889559328556061, -0.037577975541353226, 0.04510018229484558, 0.019698351621627808,
    -0.0543023981153965, -0.007536658085882664, 0.005581368692219257, 0.01797219179570675, 0.0017799998167902231, -0.034553077071905136, -0.036359284073114395, 0.03026026114821434,
    0.06723689287900925, -0.06990183889865875, 0.08364931493997574, 0.015421959571540356, -0.013131161220371723, -0.014794832095503807, 0.03520592674612999, 0.01060731615871191,
    -0.03748275712132454, 0.09547723829746246, 0.008678995072841644, 0.05618318170309067, -0.061438463628292084, 0.040276702493429184, -0.04687705636024475, -0.006047336384654045,
    -0.020184757187962532, -0.0028508442919701338, 0.03309985622763634, 0.047658536583185196, -0.02466399222612381, 0.0402093306183815, -0.011978143826127052, 0.04388599470257759,
    0.010898515582084656, 0.012934868223965168, 0.012454649433493614, 0.005428177770227194, -0.0458763986825943, -0.017613887786865234, -0.011637375690042973, 0.106475830078125,
    0.005685843527317047, -0.015097865834832191, -0.025846870616078377, -0.013932782225310802, 0.0158816110342741, 0.03970937430858612, -0.028514890000224113, -0.0011625130428001285,
    0.06546837836503983, -0.0834033414721489, -0.010208316147327423, -0.02564854733645916, -0.00932377204298973, -0.015298954211175442, 0.06653962284326553, 0.11728613823652267,
    0.06977364420890808, 0.008438206277787685, 0.011754849925637245, -0.03834718093276024, -0.01860322616994381, -0.05735691636800766, -0.0012837493559345603, -0.06593011319637299,
    -0.019036153331398964, 0.002755439141765237, 0.03298240527510643, -0.012150243856012821, 0.07742805033922195, 0.037731338292360306, -0.04650478437542915, 0.06552719324827194,
    -0.11531669646501541, -0.026007192209362984, 0.00029614113736897707, -0.007584280800074339, -0.05853448435664177, -0.052390217781066895, 0.047355785965919495, -0.028648192062973976,
    0.03649849444627762, -0.01441081240773201, -0.051312416791915894, -0.030342452228069305, 0.039810795336961746, 0.0025452261324971914, -0.022620268166065216, -0.04191705584526062,
    -0.02583969011902809, -0.0497073195874691, 0.04849965125322342, -0.03919867053627968, -0.042753372341394424, 0.03205358609557152, 0.015407649800181389, 0.02934730239212513,
    -0.010539675131440163, 0.015202600508928299, 0.05379849299788475, -0.007786446250975132, -0.037645962089300156, -0.007137779612094164, -0.059399377554655075, -0.07302258163690567,
    0.03102145530283451, 0.008384522050619125, -0.0030910265631973743, 0.04834761843085289, 0.016202274709939957, -0.027441242709755898, 0.007511838339269161, -0.004147525876760483,
    0.033411748707294464, 0.012831462547183037, 0.16913409531116486, -0.02417636476457119, -0.008522232063114643, -0.00027740313089452684, 0.024087635800242424, 0.1638011783361435,
    -0.019100820645689964, 0.005943635478615761, 0.05747072771191597, 0.018452942371368408, -0.05506102740764618, 0.017838062718510628, -0.041455451399087906, -0.015743738040328026,
    0.05134504660964012, 0.012239491567015648, -0.011797023005783558, 0.02940727025270462, -0.08323242515325546, -0.05311096832156181, 0.007205063942819834, 0.04144143685698509,
    0.08456642925739288, 0.04407151788473129, -0.056535229086875916, 0.06373808532953262, 0.0017513369675725698, 0.053158365190029144, 0.05533979460597038, 0.008843750692903996,
    -0.09142062067985535, 0.019975600764155388, 0.04653943330049515, 0.004446294158697128, -0.10233567655086517, 0.06183943152427673, -0.02251671813428402, -0.022058771923184395,
    -0.01656661555171013, -0.01064041443169117, 0.05095454677939415, -0.036187104880809784, 0.010893323458731174, -0.012274239212274551, -0.03541864827275276, 0.03646872192621231,
    0.03843512386083603, -0.0004775291890837252, 0.006221668794751167, 0.004548285622149706, 0.06974568963050842, 0.012929587624967098, -0.03538487106561661, -0.16228289902210236,
    -0.005936415400356054, -0.050077080726623535, -0.08722429722547531, 0.09400258958339691, 0.01328117772936821, 0.049533698707818985, -0.016842884942889214, 0.10467983037233353,
    -0.01337515003979206, 0.07036767899990082, 0.03415750712156296, -0.004938875790685415, -0.011336944997310638, -0.020346947014331818, -0.1336238533258438, 0.05894845724105835,
    -0.013323364779353142, -0.10032496601343155, 0.09790194779634476, -0.02491184137761593, -0.017375769093632698, 0.03585765138268471, -0.0343783013522625, 0.041113436222076416,
    0.028133004903793335, 0.012680673971772194, 0.1038551852107048, 0.04688761383295059, 0.006193539127707481, 0.0477432981133461, -0.02802090533077717, 0.09006047248840332,
    -0.035958074033260345, -0.011621400713920593, 0.07324449717998505, 0.040518488734960556, -0.028523743152618408, -0.004723261576145887, 0.11102406680583954, 0.010219257324934006,
    0.0014428686117753386, -0.09370396286249161, -0.019463825970888138, 0.009977436624467373, -0.06655165553092957, 0.015301186591386795, -0.015251543372869492, -0.03575305640697479,
    -0.1001514419913292, -0.029623840004205704, 0.045876532793045044, -0.07672851532697678, 0.02850160375237465, 0.061202287673950195, 0.036066934466362, -0.028088757768273354,
    0.033834103494882584, -0.04263323172926903, 0.03504030406475067, 0.02785256691277027, 0.041136838495731354, -0.01981365866959095, 0.006840281188488007, -0.05182678997516632,
    0.010223290883004665, 0.05497736111283302, -0.015330648981034756, -0.0559006966650486, -0.02651217207312584, -0.05417841300368309, 0.04644396901130676, -0.0015415276866406202,
    -0.034361422061920166, -0.01080586388707161, -0.06801258772611618, -0.03570031002163887, -0.06049761176109314, 0.03227424994111061, -0.03882722556591034, -0.10702896863222122,
    -0.012041914276778698, -0.006938194390386343, 0.020551079884171486, -0.02225506119430065, -0.026024915277957916, 0.06114136800169945, -0.034314095973968506, -0.040341414511203766,
    0.010088765993714333, 0.05535457655787468, 0.04030749946832657, -0.00033485880703665316, -0.02843145653605461, 0.020264072343707085, 0.0663428008556366, 0.03137720003724098,
    0.03884707763791084, 0.02742452546954155, -0.034974582493305206, 0.02034914679825306, -0.060135554522275925, -0.05713562294840813, 0.02755543403327465, -0.007868053391575813,
    -0.07105587422847748, 0.0059461514465510845, -0.021314090117812157, 0.049351971596479416, -0.04767227917909622, 0.006416069343686104, -0.0029043976683169603, 0.038506705313920975,
    -0.027774658054113388, 0.0458030141890049, -0.03706026077270508, -0.03990521281957626, -0.00659945560619235, 0.040305737406015396, 0.02092110551893711, 0.006094739306718111,
    -0.03875469043850899, -0.03375143185257912, 0.005285938736051321, 0.012548635713756084, -0.004641667474061251, 0.029788175597786903, -0.07452946156263351, 0.06486649066209793,
    0.010968538001179695, 0.11608032882213593, -0.07022595405578613, 0.01591268740594387, -0.07119426876306534, 0.06024666130542755, -0.052140165120363235, 0.06738369911909103,
    -0.03219321370124817, -0.030797408893704414, 0.03505392000079155, 0.03396940976381302, 0.019895395264029503, 0.025620639324188232, -0.035381559282541275, -0.017058810219168663,
    -0.006789179518818855, -0.026887189596891403, -0.011150184087455273, 0.003294461639598012, -0.03150850534439087, -0.01883542537689209, -0.05468736216425896, -0.02930529974400997,
    0.03987755626440048, -0.02476871944963932, -0.02842589281499386, -0.030780630186200142, -0.01253616251051426, -0.009176394902169704, -0.021344834938645363, -0.03263406455516815,
    -0.05791248008608818, 0.0323643684387207, -0.008887787349522114, 0.07152917981147766, 0.02503819391131401, -0.02999478578567505, -0.027905471622943878, -0.018045661970973015,
    -0.004399182740598917, 0.1650167852640152, -0.1338670551776886, -0.020296059548854828, 0.031297773122787476, -0.10338088124990463, 0.04716138914227486, -0.03123837523162365,
    0.019937552511692047, 0.03564021363854408, -0.016569912433624268, 0.004184247460216284, 0.01897585019469261, -0.0074801938608288765, -0.07525449246168137, 0.0028173148166388273,
    0.049308329820632935, 0.01686941832304001, 0.043873127549886703, 0.012805202975869179, -0.0054201893508434296, 0.016546396538615227, -0.039736308157444, 0.03691182658076286,
    -0.002924008062109351, 0.08850164711475372, 0.012628016993403435, -0.06855301558971405, -0.021386591717600822, -0.009408818557858467, 0.04094870388507843, -0.02272583544254303,
    0.043716806918382645, -0.0808442160487175, 0.023923661559820175, 0.029049629345536232, 0.006694435141980648, -0.01979745551943779, 0.0086252111941576, 0.059181325137615204,
    -0.035725414752960205, 0.02429244853556156, 0.033188872039318085, 0.012768993154168129, -0.02802314981818199, 0.03880764916539192, -0.035838186740875244, 0.005447264760732651,
    -0.0015394026413559914, 0.028137801215052605, -0.049093473702669144, -0.052012644708156586, -0.052552349865436554, 0.00683171208947897, 0.05085751414299011, 0.04265926778316498,
    0.030760955065488815, -0.05090208724141121, -0.07376394420862198, -0.01085473969578743, 0.030930187553167343, 0.043546367436647415, 0.013537348248064518, -0.0023067921865731478,
    0.012190609239041805, 0.06880299001932144, -0.010937856510281563, 0.10003167390823364, 0.06462559849023819, -0.00754157081246376, 0.012165420688688755, -0.02889160066843033,
    -0.07524312287569046, 0.00454543624073267, 0.0324736051261425, 0.1052992045879364, -0.0016778337303549051, -0.043268218636512756, 0.020780839025974274, 0.0603158213198185,
    0.04516934975981712, -0.09328159689903259, 0.07881193608045578, 0.03122718073427677, 0.008329639211297035, -0.046060189604759216, 0.041626691818237305, 0.0509122796356678,
    0.04609471932053566, -0.015090101398527622, 0.046730536967515945, -0.015457960776984692, 0.012739964760839939, 0.051075223833322525, -0.016911344602704048, -0.0671975240111351,
    -0.019186779856681824, 0.019504617899656296, 0.02014320157468319, -0.019028587266802788, -0.0034830193035304546, -0.03378354385495186, -0.038760956376791, -0.06670082360506058,
    -0.04438731074333191, -0.015590072609484196, 0.03314172476530075, 0.02004958689212799, -0.06552121788263321, -0.035629238933324814, -0.018159307539463043, -0.03235446289181709,
    -0.009673037566244602, 0.06657223403453827, 0.010321203619241714, 0.014490429311990738, -0.04701673239469528, 0.005414173472672701, 0.03189149498939514, -0.057234786450862885,
    0.12511706352233887, -0.03658772632479668, 0.013989693485200405, 0.025756973773241043, -0.035552989691495895, 0.02068997547030449, -0.019655924290418625, -0.07160255312919617,
    -0.0037292076740413904, -0.1550186276435852, -0.09139440208673477, 0.04359529912471771, -0.04574939236044884, 0.047953587025403976, -0.012391719967126846, -0.007366749458014965,
    0.04452276974916458, 0.06580474227666855, 0.007580439560115337, 0.07493430376052856, 0.02983802929520607, -0.007558922749012709, 0.0760727971792221, 0.1317756623029709,
    -0.005597983952611685, 0.0017822399968281388, -0.05856342241168022, 0.010528024286031723, 0.03982924297451973, 0.07629230618476868, -0.04513590410351753, 0.061185840517282486,
    0.032912950962781906, 0.021843580529093742, -0.0029473050963133574, 0.024680374190211296, -0.03298627585172653, 0.03833521530032158, -0.04113633558154106, -0.030347198247909546,
    -0.002509998856112361, -0.0490608736872673, 0.015737805515527725, -0.02108822390437126, 0.02235124260187149, -0.05432238057255745, -0.04187821224331856, 0.014246959239244461,
    -0.02875356189906597, -0.011283423751592636, 0.06917592883110046, -0.011432582512497902, 0.0307935643941164, -0.0006762302946299314, 0.009132524952292442, -0.06430986523628235,
    0.048980239778757095, 0.012364651076495647, -0.016147980466485023, -0.07151539623737335, -0.060248177498579025, -0.01697412133216858, -0.05807992443442345, 0.019133683294057846,
    0.05193192511796951, -0.10012809932231903, -0.0801527127623558, -0.030032116919755936, 0.00846402533352375, 0.018718384206295013, 0.027038978412747383, 0.03789212927222252,
    0.11414775997400284, 0.08117617666721344, 0.03936683014035225, 0.14631088078022003, 0.05222581699490547, 0.062295474112033844, -0.03674567490816116, -0.002757316455245018,
    0.06769386678934097, 0.03579561412334442, 0.07529154419898987, -0.046829137951135635, -0.02886563539505005, -0.021704677492380142, -0.03233413025736809, 0.08488854765892029,
    0.039689529687166214, -0.04762212932109833, 0.01963590458035469, -0.03898654505610466, 0.019655520096421242, -0.05416494235396385, -0.01624980755150318, -0.16526976227760315,
    0.044768620282411575, -0.01145152747631073, 0.1859455704689026, 0.06053651496767998, 0.04251228645443916, 0.09076543152332306, 0.031257931143045425, -0.12103361636400223,
    -0.01970427855849266, 0.06648878008127213, 0.034133270382881165, -0.06522350758314133, -0.07502756267786026, 0.023004937916994095, 0.04999516159296036, -0.038342926651239395,
    -0.019767029210925102, 0.010350305587053299, 0.013052372261881828, 0.041723910719156265, 0.05211237445473671, 0.0010580501984804869, -0.017172610387206078, -0.07196732610464096,
    -0.008511125110089779, 0.010293428786098957, 0.017065392807126045, 0.053141072392463684, 0.054811201989650726, -0.00388886034488678, -0.0038529234007000923, -0.12310226261615753,
    -0.05884714797139168, -0.01402896549552679, -0.08699417859315872, 0.04837717115879059, 0.04169861972332001, 0.055118199437856674, -0.06366049498319626, -0.023808728903532028,
    -0.013780522160232067, 0.09335643798112869, -0.0077949524857103825, -0.017717186361551285, 0.020434191450476646, -0.07896558940410614, -0.01459239237010479, -0.0748482421040535,
    0.02830905094742775, -0.02045130729675293, -0.015202183276414871, 0.007262160535901785, 0.039767950773239136, 0.05596226081252098, 0.060173291712999344, -0.03518012911081314,
    -0.013441512361168861, -0.0014182134764268994, -0.03137103095650673, -0.013621575199067593, -0.043957095593214035, 0.053460218012332916, -0.07937201112508774, 0.06551560014486313,
    0.029415739700198174, -0.07015611976385117, -0.0749286338686943, 0.03328341245651245, 0.011376318521797657, -0.02099578082561493, -0.03666262328624725, -0.04951135069131851,
    0.03256101533770561, 0.008589807897806168, -0.0837714672088623, -0.046675510704517365, -0.018387699499726295, -0.04194805026054382, -0.041413575410842896, -0.06876363605260849,
    0.012175208888947964, -0.03225156292319298, -0.014423636719584465, -0.053645938634872437, 0.05323304980993271, 0.05341627448797226, 0.033820051699876785, -0.008346468210220337,
    -0.009770926088094711, 0.038219746202230453, 0.01141365710645914, -0.05205080285668373, 0.05797192081809044, -0.0026969118043780327, -0.12403566390275955, 0.01180795393884182,
    0.020686278119683266, -0.012106901034712791, -0.06016270071268082, -0.12255103141069412, -0.007629237603396177, 0.05031765624880791, 0.010110381990671158, 0.05627502501010895,
    0.04626252129673958, 0.06421402096748352, 0.046791791915893555, 0.024816837161779404, 0.05870768427848816, -0.016801469027996063, 0.012726902961730957, -0.0006460524746216834,
    0.11654198169708252, -0.011181969195604324, 0.15898184478282928, -0.004818216431885958, 0.039261478930711746, 0.044624704867601395, 0.021878229454159737, -0.03425984084606171,
    0.008666614070534706, -0.024238331243395805, -0.06997050344944, 0.02154550701379776, 0.017207447439432144, 0.015690742060542107, 0.047824446111917496, 0.16835808753967285,
    0.05888627842068672, 0.028808631002902985, 0.057486239820718765, 0.03374790772795677, 0.00721302255988121, 0.06668668240308762, -0.000587007321882993, 0.030231798067688942,
    -0.08626501262187958, -0.018316520377993584, -0.006263945251703262, -0.050865042954683304, -0.030294915661215782, -0.016776500269770622, 0.035076677799224854, 0.0005290521075949073,
    -0.07819952815771103, -0.026208410039544106, 0.04480624571442604, 0.073312908411026, -0.040002863854169846, -0.046606503427028656, 0.010539421811699867, -0.026584770530462265,
    0.02689032256603241, -0.05000689998269081, 0.11483876407146454, 0.017384998500347137, -0.002068231115117669, 0.013105885125696659, -0.024741651490330696, -0.14008218050003052,
    -0.09876513481140137, -0.005640141200274229, -0.017200930044054985, 0.007231949362903833, -0.0041703395545482635, -0.034387823194265366, -0.0739855170249939, 0.024688899517059326,
    -0.023672889918088913, 0.0013795684790238738, 0.03560204058885574, 0.009821158833801746, -0.06813523918390274, 0.06464828550815582, 0.04048491269350052, -0.029452692717313766,
    -0.03583003953099251, 0.02771526388823986, 0.043540190905332565, -0.09539168328046799, -0.01163156982511282, 0.09709715843200684, -0.11075786501169205, -0.07553701847791672,
    0.09353941679000854, -0.007640657015144825, 0.03920109570026398, 0.014199991710484028, 0.012201393023133278, -0.03138430044054985, 0.059307362884283066, -0.029402893036603928,
    0.08834975212812424, -0.06567862629890442, 0.015742959454655647, 0.012709653936326504, 0.022743046283721924, -0.044244345277547836, 0.06556537747383118, 0.0014982138527557254,
    0.0455898679792881, 0.012255889363586903, 0.14290708303451538, -0.00021216660388745368, 0.009498142637312412, 0.02555380016565323, 0.020464325323700905, 0.105867400765419,
    -0.015383309684693813, 0.09696168452501297, 0.027690941467881203, -0.003196899313479662, 0.04602385684847832, 0.0045084282755851746, -0.03898610919713974, -0.02499144710600376,
    -0.012601582333445549, -0.02205536887049675, -0.05214006081223488, 0.011553054675459862, 0.0010739476419985294, -0.03531460091471672, -0.11495643109083176, 0.015017824247479439,
    -0.025624657049775124, 0.06239132583141327, 0.1124759390950203, -0.033027227967977524, 0.005376336630433798, 0.007233716081827879, -0.025262920185923576, -0.05672990530729294,
    -0.07914650440216064, -0.0942152664065361, 0.01514909602701664, 0.09212443977594376, 0.04784049466252327, -0.04566685110330582, -0.01007436029613018, 0.02601473033428192,
    -0.007004925981163979, 0.01264978013932705, -0.027556737884879112, 0.06976202130317688, -0.042928215116262436, -0.012480426579713821, -0.018154779449105263, -0.047002583742141724,
    0.011874193325638771, -0.011780316941440105, 0.03264498710632324, 0.03202880173921585, 0.051606737077236176, -0.028325552120804787, -0.07780467718839645, -0.10421581566333771,
    0.03748363256454468, 0.013184860348701477, -0.14424198865890503, -0.025302516296505928, -0.04541181027889252, 0.009775051847100258, -0.04390725493431091, 0.15269623696804047,
    0.0035193313378840685, -0.026077957823872566, 0.022654343396425247, 0.041719965636730194, 0.04006706178188324, 0.009586866945028305, 0.10014603286981583, 0.12386347353458405,
    -0.0888490155339241, 0.04236100614070892, 0.07931157946586609, -0.02105395309627056, -0.038079630583524704, 0.037754591554403305, 0.04130488261580467, -0.03773341327905655,
    0.04609940946102142, 0.02744414284825325, 0.04721521958708763, -0.03583986312150955, -0.01712772250175476, 0.00589126069098711, -0.008153068833053112, -0.03236650675535202,
    -0.014840616844594479, 0.01633506454527378, 0.0489521361887455, -0.01184105221182108, -0.012158474884927273, -0.014541848562657833, -0.036191511899232864, 0.08446089178323746,
    0.026219019666314125, -0.08340032398700714, 0.052652906626462936, 0.006576898042112589, -0.0904153510928154, 0.014580637216567993, 0.0637676939368248, 0.03400333970785141,
    -0.05485756695270538, 0.03229251131415367, -0.028621163219213486, -0.08110896497964859, 0.04260539636015892, -0.028181180357933044, 0.009122148156166077, 0.10168345272541046,
    0.11244379729032516, 0.03518524393439293, 0.025362275540828705, 0.01127876527607441, 0.09597992151975632, -0.039914146065711975, 0.0020213648676872253, -0.04303121566772461,
    -0.06309811770915985, -0.016225356608629227, 0.008639435283839703, 0.019470954313874245, 0.001989822369068861, 0.07520921528339386, 0.04403100907802582, 0.020373789593577385,
    0.0842127650976181, -0.09071994572877884, -0.16972675919532776, -0.0011071031913161278, -0.028120946139097214, -0.00525111798197031, 0.011897385120391846, -0.05058541148900986,
    -0.023609865456819534, -0.06457393616437912, 0.04724811390042305, -0.011033685877919197, 0.04099192097783089, -0.012797427363693714, -0.11558183282613754, 0.02740330621600151,
    -0.09015187621116638, -0.04394340142607689, -0.05926525592803955, 0.021345501765608788, 0.03957528993487358, 0.023968692868947983, 0.059721264988183975, 0.008866118267178535,
    -0.07550729811191559, -0.013833694159984589, 0.08917167782783508, 0.018270272761583328, -0.03240726515650749, -0.08385200798511505, -0.0006437792326323688, -0.07810688018798828,
    -0.17399172484874725, 0.04176625981926918, -0.0006884342292323709, 0.03534838929772377, 0.0780426487326622, -0.05944779887795448, -0.05711468681693077, -0.0016224845312535763,
    0.036115486174821854, -0.09427808970212936, -0.00038024564855732024, -0.1258525401353836, -0.04828740656375885, 0.006235521286725998, 0.012229995802044868, 0.007268233224749565,
    0.027474308386445045, 0.029246337711811066, 0.028318237513303757, 0.002134104259312153, 0.06716053187847137, -0.03712281212210655, 0.009074640460312366, -0.044263679534196854,
    0.03550323471426964, -0.06500280648469925, -0.14625416696071625, -0.0661669671535492, -0.010858914814889431, -0.04018956422805786, -0.056955914944410324, 0.014654011465609074,
    -0.029264619573950768, -0.04925147071480751, 0.019702434539794922, 0.044849079102277756, 0.009429773315787315, -0.03419693559408188, 0.0047576515935361385, 0.12755952775478363,
    -0.09580203145742416, 0.01627274975180626, 0.07530021667480469, 0.002469820436090231, 0.05380905792117119, 0.025761615484952927, -0.015424512326717377, -0.029656406491994858,
    0.03416334465146065, -0.021832512691617012, 0.04314270615577698, -0.022550934925675392, -0.12050026655197144, -0.027227794751524925, -0.0008395052864216268, 0.015771683305501938,
    0.05843237042427063, -0.05104372650384903, -0.04416845738887787, -0.011016429401934147, 0.027154497802257538, 0.018247351050376892, 0.025450298562645912, 0.029902290552854538,
    -0.05904441699385643, 0.13777685165405273, 0.13926079869270325, -0.01042445283383131, -0.08641525357961655, 0.023761648684740067, -0.07107028365135193, 0.06061026453971863,
    -0.00684332475066185, 0.06623446941375732, 0.0014377861516550183, 0.02320554293692112, 0.0145824383944273, -0.14388565719127655, 0.12448935955762863, -0.023100046440958977,
    0.07056285440921783, 0.029211150482296944, 0.01643289066851139, 0.00910801999270916, 0.04495929554104805, -0.007576410658657551, -0.03795713931322098, 0.03881857544183731,
    0.06966514885425568, 0.053812816739082336, 3.491891402518377e-05, -0.024746466428041458, -0.017752813175320625, -0.013381694443523884, 0.02961851842701435, -0.0036678703036159277,
    0.04579104483127594, -0.014428559690713882, 0.22590970993041992, 0.05971967801451683, -0.05881568044424057, -0.023961089551448822, -0.0006903965841047466, 0.038186442106962204,
    -0.052286311984062195, 0.01978759653866291, 0.1016753688454628, -0.021241914480924606, 0.06303920596837997, -0.031105706468224525, -0.08073370903730392, 0.02924777939915657,
    0.0030532418750226498, -0.03852976858615875, -0.03259410709142685, -0.05122549086809158, -0.007017218973487616, 0.04347856715321541, 0.12109807133674622, -0.03985811769962311,
    0.04659160226583481, -0.11289908736944199, 0.0522807240486145, -0.01731479912996292, -0.00442334171384573, 0.18699434399604797, 0.024417923763394356, 0.039732396602630615,
    -0.05372084677219391, 0.030282409861683846, -0.02241082303225994, -0.000826011470053345, 0.02148517221212387, 0.03425867110490799, -0.03412953391671181, 0.033678553998470306,
    0.08188270777463913, -0.06528358906507492, 0.03349820151925087, 0.11716226488351822, 0.021298516541719437, -0.0010179114760830998, -0.016382215544581413, -0.09931039810180664,
    0.024854468181729317, 0.04662087559700012, -0.048029277473688126, 0.0594431571662426, 0.00019251885532867163, 0.043373219668865204, -0.09412684291601181, 0.173679918050766,
    -0.054394375532865524, -0.05852854251861572, -0.00429404154419899, 0.027204278856515884, 0.07512496411800385, 0.024071209132671356, 0.04607916250824928, -0.20096689462661743,
    -0.06810999661684036, -0.06114479899406433, 0.05337817221879959, 0.09137728065252304, -0.05097635090351105, -0.07438281178474426, 0.07679909467697144, 0.14877504110336304,
    -0.07642347365617752, -0.0791938379406929, 0.028725944459438324, 0.059852760285139084, 0.051769159734249115, 0.038248855620622635, 0.08258723467588425, -0.011597870849072933,
    0.0038989773020148277, -0.04430295154452324, -0.012536538764834404, 0.042175088077783585, -0.015259013511240482, 0.05495576187968254, -0.017252681776881218, -0.04125093296170235,
    -0.0554688386619091, -0.02332981489598751, -0.019356833770871162, -0.044174809008836746, 0.03576896712183952, 0.033246759325265884, -0.02678181231021881, -0.07661452144384384,
    -0.09517905116081238, -0.18138635158538818, 0.12424863874912262, 0.025346195325255394, 0.06722544878721237, -0.03495160490274429, -0.04634714126586914, -0.007654014974832535,
    -0.018778694793581963, 0.004206942394375801, -0.06470774859189987, 0.06479713320732117, 0.03992456942796707, -0.1272842139005661, -0.16315250098705292, -0.050738539546728134,
    -0.008892382495105267, 0.0422140471637249, 0.022312099114060402, 0.025580348446965218, -0.00313947768881917, -0.026554692536592484, -0.037701740860939026, -0.03175679221749306,
    0.0373043566942215, 0.0056334384717047215, 0.008012799546122551, -0.09222687780857086, -0.011502539739012718, -0.04714137688279152, -0.02336990088224411, -0.061713844537734985,
    0.059664562344551086, 0.012584722600877285, -0.2492426186800003, -0.02329590916633606, 0.010088836774230003, -0.034338146448135376, 0.08288376778364182, -0.049844175577163696,
    -0.04325622692704201, 0.04169198498129845, -0.015516363084316254, -0.010759438388049603, -0.01731998659670353, -0.010669495910406113, 0.05267007276415825, -0.023731805384159088,
    -0.03400517255067825, -0.01706068217754364, -0.02218030020594597, -0.010283498093485832, -0.011770593002438545, -0.04518328234553337, 0.005110759753733873, -0.05822565034031868,
    0.11029066890478134, -0.10927779972553253, -0.06650648266077042, 0.02166733331978321, 0.02945036254823208, -0.009957886300981045, -0.0007503871456719935, -0.039214346557855606,
    0.09263759106397629, -0.03821755200624466, -0.0017787686083465815, 0.04038463160395622, -0.0663917288184166, 0.026192735880613327, 0.014127868227660656, 0.04113464429974556,
    -0.062788225710392, -0.055580511689186096, -0.08463425934314728, -0.0018319322261959314, -0.019204363226890564, -0.02888919971883297, 0.009597263298928738, -0.017055334523320198,
    0.019471636041998863, 0.03406151384115219, -0.010067888535559177, 0.018805526196956635, -0.06323026120662689, 0.018630124628543854, -0.04105949029326439, -0.15327920019626617,
    -0.0010344964684918523, 0.041005369275808334, 0.20218399167060852, -0.0034643204417079687, 0.07491299510002136, 0.0193757526576519, -0.03296130150556564, -0.04777896776795387,
    -0.03496589884161949, -0.09708942472934723, 0.021605394780635834, 0.09406785666942596, -0.01728384755551815, 0.030351337045431137, 0.07172304391860962, -0.04259803146123886,
    -0.049344684928655624, 0.03144405037164688, 0.03971602022647858, 0.11957138776779175, -0.044218286871910095, 0.03365107998251915, -0.03636075183749199, 0.0420193150639534,
    0.012682076543569565, 0.061490029096603394, -0.039069630205631256, 0.0005112300859764218, -0.025796497240662575, 0.053236644715070724, 0.030420804396271706, 0.03152884170413017,
    -0.07182687520980835, 0.04428781941533089, 0.08714671432971954, 0.01935473643243313, -0.008229712024331093, 0.00555963022634387, -0.023396508768200874, -0.02400607243180275,
    -0.10011798143386841, 0.12242060899734497, 0.09044149518013, 0.018265375867486, 0.034876853227615356, -0.04137656092643738, 0.09241360425949097, -0.08167976886034012,
    0.027162129059433937, 0.11677001416683197, -0.027179744094610214, -0.07520265132188797, -0.040354885160923004, 0.01843547634780407, -0.019018255174160004, 0.07913156598806381,
    -0.10680065304040909, -0.004240423906594515, 0.0009399541886523366, 0.023931536823511124, 0.03309730812907219, -8.364864333998412e-05, -0.08157677948474884, -0.08291715383529663,
    0.02138979732990265, 0.045265503227710724, -0.04897795990109444, -0.019685495644807816, -0.03800056874752045, -0.046132974326610565, -0.04149492830038071, 0.06959564238786697,
    0.0321623794734478, -0.08718717098236084, 0.20818783342838287, -0.001038702204823494, 0.0174260251224041, 0.05596788600087166, -0.015318386256694794, 0.023752914741635323,
    -0.06089521199464798, -0.052965909242630005, -0.04072755575180054, 0.03230592980980873, -0.021808965131640434, 0.03993573412299156, 0.1626967042684555, -0.0060524772852659225,
    -0.061935603618621826, 0.07441000640392303, 0.018076324835419655, 0.04145181551575661, 0.06407047808170319, 0.08033322542905807, -0.06438450515270233, -0.10328973829746246,
    -0.008786485530436039, -0.033811114728450775, -0.09145741909742355, 0.018033351749181747, -0.026737909764051437, 0.03583801910281181, 0.003974603489041328, -0.13347294926643372,
    0.11769121885299683, -0.06620559841394424, -0.025637159124016762, 0.11926139146089554, -0.11091309785842896, 0.09165403991937637, 0.019772212952375412, -0.02223595418035984,
    -0.0716145783662796, -0.0843401849269867, -0.14518748223781586, -0.1076108068227768, -0.009394153021275997, -0.11396878212690353, -0.021588783711194992, 0.0028436079155653715,
    0.008389253169298172, 0.01235195156186819, 0.037106797099113464, -0.03044474869966507, -0.0018347916193306446, -0.0127290403470397, -0.03352682664990425, 0.04581749066710472,
    -0.039272796362638474, -0.01672711968421936, 0.15526442229747772, -0.1153285801410675, 0.022408876568078995, 0.02795320376753807, -0.06034362316131592, 0.18128091096878052,
    0.012444022111594677, -0.09774674475193024, 0.049141716212034225, 0.07822903245687485, 0.03705872222781181, 0.0647546797990799, 0.13913531601428986, -0.17692485451698303,
    -0.05504206195473671, -0.10642921924591064, 0.07078585028648376, 0.011554358527064323, 0.057096049189567566, 0.049974557012319565, 0.047490086406469345, -0.030803032219409943,
    -0.002587707247585058, -0.08578051626682281, -0.07021408528089523, -0.03497055545449257, -0.05945376679301262, -0.01386493630707264, 0.10435960441827774, 0.05298777297139168,
    -0.025590837001800537, -0.025614045560359955, 0.05939699709415436, -0.05025003105401993, 0.043486226350069046, -0.006367749068886042, -0.029367417097091675, 0.01073252223432064,
    0.08588569611310959, -0.04384348914027214, 0.1293172687292099, -0.03398294746875763, -0.04612034931778908, 0.045303620398044586, -0.06742272526025772, -0.021011529490351677,
    -0.0039099412970244884, 0.014907813630998135, 0.03386824578046799, -0.0925958976149559, 0.0009214790188707411, 0.033663176000118256, 0.131681427359581, 0.025594456121325493,
    -0.03446086868643761, -0.0087617551907897, -0.05195603892207146, 0.01609976589679718, 0.09642557054758072, -0.0028025396168231964, -0.09556093066930771, -0.06611371785402298,
    -0.02606387995183468, 0.07907894253730774, 0.018616031855344772, 0.001010886742733419, 0.012331320904195309, 0.01367097906768322, 0.040894486010074615, -0.010008392855525017,
    0.03854432329535484, 0.026420148089528084, -0.12817300856113434, 0.025774333626031876, -0.017256896942853928, 0.0027938426937907934, -0.05600253865122795, -0.02936835214495659,
    -0.022256983444094658, 0.05072441324591637, 0.05566417798399925, 0.04012726619839668, -0.056989625096321106, 0.05092652514576912, 0.04386499524116516, -0.04412602633237839,
    -0.040639299899339676, -0.034902423620224, -0.07168618589639664, 0.12880051136016846, 0.01897512748837471, -0.010800924152135849, -0.17652778327465057, -0.1292664110660553,
    0.004242749884724617, 0.005884422454982996, -0.03166887164115906, 0.026229748502373695, -0.09075235575437546, 0.0820712149143219, -0.05476456508040428, -0.007785413879901171,
    0.02571270428597927, 0.020912567153573036, 0.03874549642205238, 0.10704255849123001, 0.0032383385114371777, 0.061440609395504, 0.014749455265700817, 0.0008120306883938611,
    -0.129001647233963, -0.062065012753009796, 0.01840340532362461, 0.14039471745491028, 0.00747012160718441, -0.026857152581214905, 0.033114466816186905, 0.08962143212556839,
    0.0004519496578723192, 0.13415195047855377, -0.009447683580219746, 0.044809065759181976, 0.02419646456837654, 0.007378711365163326, 0.030455276370048523, 0.031111644580960274,
    -0.043653082102537155, -0.02783379890024662, -0.05631237477064133, 0.04892412945628166, 0.0403013601899147, 0.027746306732296944, 0.03478655591607094, 0.16619256138801575,
    0.10681131482124329, -0.06184806674718857, 0.057635243982076645, -0.001402855385094881, 0.00917857512831688, -0.039173148572444916, 0.046800632029771805, -0.13905787467956543,
    -0.017584197223186493, -0.07246854901313782, 0.03433328866958618, -0.0022026028018444777, 0.04831947386264801, -0.025659851729869843, 0.02019350230693817, 0.010577620007097721,
    -0.03556201234459877, 0.03460808843374252, -0.1426362842321396, -0.014727909117937088, 0.02311680093407631, -0.0517009012401104, -0.02615102380514145, -0.01944870315492153,
    -0.018028775230050087, -0.009546664543449879, 0.013334427028894424, -0.025978444144129753, 0.03555624186992645, -0.004010570235550404, -0.0056467982940375805, -0.023978862911462784,
    0.10159323364496231, -0.043440163135528564, 0.08303316682577133, -0.009831591509282589, -0.031224047765135765, -0.043436042964458466, -0.009383496828377247, -0.023510029539465904,
    -0.034417420625686646, 0.0026205715257674456, 0.039846308529376984, 0.0339205302298069, -0.0072573828510940075, -0.006415191572159529, -0.04339883476495743, -0.10602900385856628,
    0.024340106174349785, 0.004495272412896156, -0.004261321388185024, -0.012766698375344276, 3.5124237911077216e-05, 0.037815291434526443, 0.06766749173402786, -0.03267742320895195,
    -0.01911320723593235, -0.024197911843657494, -0.01576302945613861, 0.023779701441526413, -0.011445512063801289, -0.009125947952270508, -0.02246081456542015, -0.059083692729473114,
    0.016060376539826393, -0.057231273502111435, 0.07026475667953491, -0.08235464990139008, -0.1053430363535881, -0.034822091460227966, 0.005490294191986322, 0.018712326884269714,
    0.017948228865861893, -0.02857944369316101, 0.01902984268963337, 0.009436717256903648, -0.011212581768631935, 0.05573520436882973, 0.07563618570566177, 0.016842933371663094,
    -0.07975208759307861, -0.0405283086001873, 0.038824327290058136, 0.014402513392269611, 0.023657307028770447, 0.0029792420100420713, 0.019696148112416267, -0.08950523287057877,
    -0.09086361527442932, -0.007481895852833986, -0.01637062057852745, 0.04167195409536362, -0.00025524350348860025, -0.07720854878425598, -0.038286950439214706, -0.06245476007461548,
    -0.08302953839302063, 0.07572384923696518, 0.027679191902279854, 0.09889999032020569, -0.0348321869969368, -0.031737469136714935, 0.01759962923824787, -0.02077248878777027,
    0.03791886940598488, -0.09931302815675735, 0.15749774873256683, -0.06935034692287445, -0.00827938225120306, 0.055368006229400635, -0.0225903932005167, -0.029459236189723015,
    0.041532427072525024, 0.014592137187719345, -0.0638861358165741, 0.043182287365198135, 0.0016281879507005215, -0.07089905440807343, -0.024212531745433807, -0.16738997399806976,
    -0.031094100326299667, 0.014928851276636124, -0.18448805809020996, 0.23966093361377716, -0.11184858530759811, 0.06812098622322083, 0.04994356259703636, -0.05125489458441734,
    -0.01744111441075802, 0.022116364911198616, 0.06874136626720428, -0.08474412560462952, -0.02791859582066536, 0.031013138592243195, 0.04346638545393944, 0.0018802861450240016,
    0.0027445273008197546, -0.14229701459407806, 0.05085686966776848, 0.006541771348565817, -0.06910829991102219, 0.07799917459487915, 0.022698888555169106, -0.04279867187142372,
    0.017083462327718735, 0.024234803393483162, 0.02195323258638382, -0.06799245625734329, 0.036286499351263046, -0.08618569374084473, -0.003026555059477687, 0.06989032030105591,
    0.06303999572992325, -0.02807200327515602, 0.026827068999409676, 0.0007104557589627802, 0.06017313897609711, -0.01089442241936922, -0.06513172388076782, -0.08564276248216629,
    0.056624822318553925, 0.08503439277410507, -0.02716340869665146, 0.04528717324137688, -0.04064907133579254, 0.02745204232633114, 0.11584301292896271, 0.0456840805709362,
    -0.08801117539405823, 0.09512774646282196, 0.05608971416950226, 0.06128370761871338, -0.02363118901848793, -0.03738841414451599, 0.00014645246847067028, 0.09329842776060104,
    -0.031611740589141846, -0.04092365503311157, 0.1319567710161209, -0.013973202556371689, 0.032864708453416824, 0.009037968702614307, 0.028817297890782356, 0.10427206009626389,
    0.05616934597492218, -0.12858320772647858, 0.02237510122358799, 0.10401900857686996, -0.07710385322570801, -0.01589277572929859, -0.08964372426271439, -0.06244095042347908,
    0.0580742284655571, -0.016402840614318848, 0.007263793610036373, -0.054254624992609024, -0.08026576042175293, 0.027378682047128677, -0.05384897440671921, -0.08107660710811615,
    -0.03849341720342636, -0.0663314014673233, 0.01793692447245121, -0.0343613363802433, 0.018696503713726997, 0.06218587979674339, 0.03038763999938965, -0.0028346232138574123,
    -0.0630052387714386, 0.006824002601206303, 0.04541269317269325, 0.009038981050252914, 0.030028732493519783, -0.049587611109018326, 0.08898664265871048, -0.05349263921380043,
    0.061533138155937195, 0.10737800598144531, 0.050884000957012177, 0.08242613077163696, 0.001001799595542252, -0.02046111971139908, 0.06250520050525665, -0.025874076411128044,
    -0.13430355489253998, 0.11629326641559601, 0.04642022028565407, 0.08328408002853394, 0.009104347787797451, -0.10543115437030792, 0.020261896774172783, 0.007394347805529833,
    -0.1078333854675293, -0.0781264454126358, 0.15814469754695892, -0.06825927644968033, 0.0007828925154171884, 0.014350266195833683, -0.02240859903395176, -0.02743745781481266,
    -0.040711432695388794, 0.005354645196348429, 0.11062599718570709, 0.0027937458362430334, -0.034788828343153, -0.026064900681376457, 0.010404334403574467, 0.277195006608963,
    -0.0022241142578423023, -0.006005154922604561, -0.12923158705234528, 0.022099558264017105, -0.07672256976366043, 0.050700873136520386, 0.03391282260417938, -0.08784989267587662,
    0.007160125765949488, 0.1487898826599121, 0.00803182553499937, -0.08261118084192276, 0.102462999522686, 0.04051833227276802, 0.02651767060160637, -0.014241490513086319,
    0.07518240064382553, 0.0021587808150798082, 0.059466417878866196, 0.04004165157675743, 0.06725557148456573, -0.030589470639824867, -0.03677554056048393, -0.0821678563952446,
    -0.037986405193805695, -0.035276465117931366, -0.02369113638997078, -0.07553766667842865, -0.03147824853658676, -0.06512614339590073, -0.02364957518875599, 0.10199283063411713,
    0.03850191831588745, 0.036077432334423065, -0.0393037311732769, -0.04732055217027664, 0.05484698340296745, 0.02858854830265045, -0.10784624516963959, 0.04933873191475868,
    0.017696546390652657, -0.03329065814614296, -0.05635335296392441, -0.01417457964271307, -0.1092662513256073, 0.007668926380574703, -0.04881664738059044, -0.06399034708738327,
    -0.10971195995807648, 0.06482075154781342, -0.060565050691366196, -0.1238832026720047, -0.032462045550346375, -0.03688166290521622, 0.06924555450677872, 0.0256546251475811,
    0.18941549956798553, -0.12114809453487396, 0.047912873327732086, 0.007022560108453035, 0.055225029587745667, -0.054413408041000366, 0.026108264923095703, 0.10472650825977325,
    0.028281480073928833, -0.1408757120370865, 0.053514815866947174, -0.0003576765302568674, 0.008024069480597973, 0.05642855167388916, -0.017809325829148293, 0.015827080234885216,
    0.09155727177858353, -0.1308552771806717, -0.10216905921697617, -0.01038438268005848, -0.016361519694328308, 0.01704154722392559, 0.025255590677261353, 0.08929716795682907,
    -0.06746120750904083, 0.004642982501536608, -0.0011795799946412444, 0.02558106929063797, -0.009045775048434734, 0.03193503990769386, 0.09886802732944489, -0.011176256462931633,
    0.13896971940994263, -0.05288303643465042, 0.0177647452801466, 0.06123938411474228, 0.05967889353632927, -0.05381881818175316, 0.03750859200954437, -0.0721643716096878,
    0.03449273854494095, -0.014072776772081852, -0.06918720155954361, 0.06213326379656792, -0.040083300322294235, -0.005497882142663002, 0.06214867904782295, -0.08660674095153809,
    -0.07264865189790726, 0.12394950538873672, 0.06027302145957947, 0.058020010590553284, 0.07717639207839966, -0.028697069734334946, 0.054789260029792786, 0.007233071140944958,
    -0.06410371512174606, -0.04298241436481476, 0.03609011694788933, 0.14708071947097778, 0.032377056777477264, 0.0317075289785862, -0.018363460898399353, -0.07711376994848251,
    0.006522418465465307, 0.006399550475180149, -0.01179835107177496, 0.020815206691622734, -0.017194462940096855, -0.02206772193312645, 0.03212481364607811, -0.16746953129768372,
    0.03425659239292145, -0.05477738007903099, 0.12819403409957886, -0.1992897093296051, 0.06236136332154274, -0.07771505415439606, -0.020909849554300308, -0.04315857216715813,
    -0.09232892096042633, 0.039096783846616745, -0.029942195862531662, -0.06669966131448746, -0.0012188851833343506, -0.033285804092884064, 0.033249735832214355, 0.004136829636991024,
    0.0766879990696907, -0.03128504753112793, 0.0605519562959671, 0.00949439499527216, -0.06043536216020584, 0.024785814806818962, -0.038890548050403595, -0.09404134750366211,
    -0.04569679871201515, 0.018685614690184593, -0.022302471101284027, -0.03308793529868126, -0.183428093791008, -0.002185211284086108, -0.02850852534174919, 0.044787563383579254,
    -0.015921367332339287, 0.1042189970612526, 0.037023358047008514, -0.05519275367259979, 0.026854319497942924, 0.046223971992731094, -0.07741952687501907, 0.047224368900060654,
    -0.0019271624041721225, 0.0004885446978732944, -0.04875350371003151, -0.04171537235379219, -0.15612542629241943, -0.013233347795903683, -0.044487111270427704, -0.043422721326351166,
    -0.13229621946811676, 0.021589070558547974, -0.008929653093218803, -0.0830702856183052, -0.031893324106931686, 0.12284184992313385, -0.0014989377232268453, -0.09575140476226807,
    0.14145444333553314, 0.10436581075191498, 0.07695556432008743, 0.017894400283694267, -0.10485982149839401, -0.031862612813711166, 0.03156350553035736, 0.007003698498010635,
    0.028842002153396606, 0.020780839025974274, -0.06316345930099487, -0.03212590515613556, -0.006752419751137495, 0.07368674874305725, -0.011913483962416649, 0.028657466173171997,
    0.02443111501634121, -3.8722868339391425e-05, 0.1353989690542221, -0.10039537400007248, -0.03454975038766861, 0.06320430338382721, 0.05678873136639595, -0.1885928362607956,
    -0.021634386852383614, 0.0795794427394867, 0.025412878021597862, -0.0032879223581403494, 0.024696271866559982, -0.016289057210087776, 0.0914614200592041, 0.008130853995680809,
    0.16008983552455902, -0.02141146920621395, -0.009177196770906448, 0.056965239346027374, -0.010918337851762772, -0.04067939892411232, 0.01889893040060997, -0.038349591195583344,
    0.003604174591600895, -0.05676267668604851, -0.06028632074594498, 0.04925468564033508, -0.06528487801551819, -0.06398860365152359, 0.01465654093772173, -0.006416240241378546,
    0.08872051537036896, 0.13565875589847565, 0.001897062174975872, -0.00850291084498167, 0.16353446245193481, -0.0957782194018364, -0.01310369186103344, 0.030677953734993935,
    -0.012626927345991135, -0.08258233219385147, -0.00038287832285277545, -0.10517214238643646, 0.03200531005859375, 0.0567735880613327, -0.0496097132563591, 9.355216025141999e-05,
    0.001919532660394907, 0.031540051102638245, -0.10040349513292313, 0.009480372071266174, -0.012313604354858398, 0.03936637565493584, -0.04252050817012787, -0.05047336593270302,
    0.012812945060431957, -0.062227871268987656, 0.15868209302425385, -0.01885017193853855, 0.05815260484814644, 0.04449346661567688, 0.038151320070028305, 0.1422056406736374,
    -0.002337173093110323, -0.021296214312314987, -0.02092946693301201, -0.10363250225782394, -0.023658277466893196, 0.01117907464504242, -0.062090206891298294, 0.0003699015942402184,
    0.1366347223520279, -0.05105763301253319, -0.07169739156961441, 0.008960139006376266, 0.004296467173844576, 0.004304284229874611, 0.04336588457226753, -0.09611845016479492,
    -0.004857746418565512, -0.016448505222797394, -0.048418909311294556, 0.12274129688739777, 0.004219437949359417, 0.12472712248563766, -0.016834750771522522, -0.00425546383485198,
    0.0010472005233168602, 0.07407566159963608, 0.0982179045677185, 0.012931178323924541, 0.006306859664618969, 0.06313072144985199, 0.011758747510612011, -0.036064498126506805,
    0.007095810491591692, 0.03515824303030968, 0.0270937979221344, -0.03166039288043976, -0.06287303566932678, -0.0905384048819542, 0.07870695739984512, -0.008084995672106743,
    0.04741194099187851, -0.050043217837810516, -0.05951984226703644, 0.09724175930023193, -0.06890631467103958, 0.15418748557567596, -0.04831554368138313, -0.014170217327773571,
    0.008291468024253845, 0.03885900601744652, 0.011395188979804516, -0.010685553774237633, -0.09671898931264877, 0.016029873862862587, 0.06797821819782257, -0.03869141638278961,
    0.06625962257385254, 0.07988402247428894, 0.048544131219387054, 0.037350814789533615, -0.03065909631550312, -0.0018674893071874976, 0.10902255773544312, 0.006053572054952383,
    0.10085103660821915, 0.0890737846493721, -0.16795256733894348, -0.0009608598775230348, -0.06992984563112259, -0.04389861971139908, -0.010457666590809822, 0.15999725461006165,
    -0.014308693818747997, -0.0510161817073822, 0.12320877611637115, 0.03849314525723457, -0.05690516158938408, -0.02490493282675743, 0.019665474072098732, -0.017709065228700638,
    0.09309881925582886, 0.07329728454351425, -0.05613299086689949, -0.01970072276890278, -0.06944242864847183, 0.12346450239419937, -0.015109873376786709, 0.0961068794131279,
    0.08889605849981308, -0.019853591918945312, -0.1284680813550949, -0.01150769367814064, -0.03788963705301285, 0.16842249035835266, 0.014850311912596226, -0.055680662393569946,
    0.15158531069755554, 0.06199578195810318, -0.025832245126366615, 0.014489268884062767, 0.12321005761623383, 0.03684922307729721, -0.020959440618753433, -0.0498351976275444,
    0.013168449513614178, -0.021293682977557182, -0.052983012050390244, -0.013460615649819374, 0.008182446472346783, -0.05171842500567436, 0.043659910559654236, 0.02562073804438114,
    -0.0435369648039341, -0.04229532927274704, 0.01987040974199772, 0.03962768614292145, -0.0273428987711668, -0.0314580462872982, -0.0499599315226078, 0.15082696080207825,
    0.03231632336974144, 0.041782230138778687, 0.09143340587615967, 0.23834459483623505, -0.05472162365913391, -0.04882119596004486, 0.01702878624200821, 0.08456192165613174,
    0.04906441271305084, -0.07198923081159592, 0.015120958909392357, -0.04312529414892197, 0.01192252803593874, 0.0094972625374794, 1.1732528037100565e-05, 0.10481350123882294,
    0.09932563453912735, 0.09277261793613434, -0.04390663653612137, -0.09744708985090256, 0.029355308040976524, -0.024709708988666534, 0.04786895215511322, 0.005709475371986628,
    -0.018024183809757233, 0.012073644436895847, 0.03705127537250519, 0.08177843689918518, -0.0588911734521389, 0.13308949768543243, 0.028211146593093872, -0.019052745774388313,
    -0.08756411075592041, 0.025497308000922203, -0.05875613912940025, -0.0006727105937898159, 0.0012115606805309653, 0.03375619277358055, -0.023689601570367813, -0.04261690378189087,
    -0.04282011464238167, -0.10661427676677704, -0.08379393070936203, 0.014664252288639545, -0.008551692590117455, -0.024741485714912415, -0.04523520544171333, 0.11151866614818573,
    0.01049562357366085, -0.16083502769470215, 0.0063865771517157555, 0.04252573475241661, 0.02163863368332386, -0.2149639129638672, 0.050237227231264114, 0.2143802046775818,
    -0.04091419279575348, -0.08235980570316315, -0.05566317215561867, -0.020906122401356697, -0.010883806273341179, -0.07423939555883408, 0.011633682064712048, 0.044471777975559235,
    -0.01251447107642889, 0.14647091925144196, 0.03927788510918617, -0.11568222939968109, -0.054411303251981735, 0.0376240536570549, 0.08430219441652298, 0.0913170650601387,
    0.04196510091423988, 0.08164496719837189, 0.15098454058170319, 0.0062273661606013775, 0.08371478319168091, 0.06595524400472641, -0.055948421359062195, -0.15384632349014282,
    -0.021372484043240547, 0.07725623995065689, 0.10037662833929062, -0.03803832083940506, 0.025489894673228264, -0.06853238493204117, -0.022546865046024323, -0.015525486320257187,
    0.0028797867707908154, 0.055294279009103775, 0.009269319474697113, 0.01763208582997322, -0.03405829519033432, 0.010602741502225399, -0.09939432144165039, 0.04695195332169533,
    0.09654294699430466, 0.043917763978242874, -0.1400822103023529, 0.15384817123413086, 0.0021043887827545404, -0.06088205426931381, 0.10143063962459564, -0.10131467133760452,
    0.017819909378886223, 0.08196386694908142, -0.02094019018113613, -0.05022071674466133, -0.0275721475481987, 0.03706839308142662, 0.02726546861231327, -0.011997378431260586,
    0.13303358852863312, -0.030582508072257042, -0.08323021233081818, 0.08471254259347916, 0.006375804077833891, -0.0177016444504261, 0.021317748352885246, -0.014907019212841988,
    0.008736195974051952, -0.1687079221010208, 0.10709001123905182, 0.03776181489229202, -0.012870623730123043, -0.0046427324414253235, 0.007502355147153139, -0.234122171998024,
    -0.06070541962981224, 0.09717560559511185, -0.1449495255947113, -0.06713516265153885, -0.17222318053245544, 0.038023944944143295, -0.08438006043434143, -0.11543169617652893,
    0.05203322693705559, -0.20664942264556885, 0.0037256779614835978, 0.21099960803985596, -0.016595859080553055, -0.017530035227537155, 0.0112836305052042, -0.09957287460565567,
    0.1760040670633316, 0.07383649051189423, 0.09242989122867584, -0.0719095766544342, 0.08106371760368347, 0.06938516348600388, 0.019699661061167717, -0.001431572251021862,
    -0.0557870976626873, 0.026476047933101654, -0.08483804017305374, 0.04329101741313934, -0.03568693622946739, -0.06931962072849274, 0.016261111944913864, -0.020473526790738106,
    -0.09831029176712036, -0.07555533945560455, -0.026224618777632713, -0.04982814937829971, -0.012101797387003899, 0.02462305687367916, 0.1498783826828003, 0.031790826469659805,
    -0.027734339237213135, 0.05088639631867409, -0.03912697732448578, 0.042116403579711914, 0.0006469613290391862, -0.036310646682977676, -0.06519963592290878, 0.015590094961225986,
    0.1638784408569336, -0.04521625116467476, 0.02323220856487751, -0.10760219395160675, 0.02091454714536667, -0.06408948451280594, -0.04831342771649361, -0.09034322947263718,
    -0.11000331491231918, 0.05295143648982048, -0.006904006469994783, -0.002993563190102577, 0.13356754183769226, -0.0605674609541893, 0.0027070301584899426, 0.06615594774484634,
    0.015090745873749256, 0.1382489949464798, -0.0367424376308918, -0.06229125335812569, -0.01679355278611183, -0.011975341476500034, 0.010979639366269112, 0.09133094549179077,
    0.035710155963897705, 0.14058098196983337, -0.1528790295124054, -0.09981121122837067, 0.0193084254860878, -0.020091136917471886, -0.007193104363977909, 0.06924434751272202,
    -0.04161274805665016, 0.0002635437122080475, 0.06837914884090424, -0.01566131040453911, 0.04293114319443703, -0.03171210736036301, -0.028841562569141388, 0.007814770564436913,
    0.032481562346220016, 0.054507795721292496, -0.014727435074746609, 0.051422957330942154, -0.016345899552106857, -0.14042136073112488, -0.07614484429359436, 0.11303312331438065,
    0.01640835776925087, 0.08399872481822968, -0.03801470622420311, 0.15525543689727783, -0.0038206407334655523, -0.019510304555296898, 0.030832145363092422, 0.041856035590171814,
    -0.11222856491804123, 0.06314829736948013, -0.013847650028765202, -0.021100245416164398, 0.02636871673166752, 0.10773255676031113, 0.03258628025650978, -0.03122624382376671,
    0.14683550596237183, -0.09178317338228226, 0.005206563510000706, -0.13774007558822632, -0.004012993536889553, 0.0027397165540605783, 0.040159016847610474, 0.056155335158109665,
    -0.00984912645071745, -0.1237432211637497, -0.09786144644021988, 0.013971846550703049, -0.007024300750344992, 0.00031104389927349985, -0.025172516703605652, 0.11428514868021011,
    0.023075129836797714, -0.1443973034620285, -0.12744854390621185, -0.24015609920024872, 0.011618639342486858, 0.1458253562450409, -0.01242467574775219, -0.0982871875166893,
    0.1188400611281395, -0.033168766647577286, 0.01980050839483738, 0.16937576234340668, 0.08231693506240845, -0.011514994315803051, 0.0007098939968273044, -0.11158660054206848,
    0.07544603943824768, -0.0001328653161181137, 0.024273918941617012, -0.08410046994686127, -0.18665654957294464, 0.05171164125204086, -0.009868970140814781, -0.015953978523612022,
    -0.010974589735269547, -0.04029329493641853, -0.10789220780134201, -0.1135539785027504, 0.09008414298295975, -0.10377661883831024, -0.07675198465585709, -0.015828635543584824,
    0.02844219096004963, -0.033775389194488525, -0.025380222126841545, 0.03650428354740143, 0.039023373275995255, 0.0039084129966795444, 0.08499179780483246, -0.005098754074424505,
    0.08828935772180557, -0.017278028652071953, -0.11153411120176315, 0.014452377334237099, -0.05688714608550072, 0.04156539589166641, 0.09450946748256683, -0.06319523602724075,
    0.10538790374994278, 0.05962925776839256, 0.05215739458799362, -0.07306507974863052, -0.014194396324455738, 0.09031452238559723, 0.029649682343006134, 0.03760756179690361,
    0.018753547221422195, 0.059361595660448074, 0.03588295727968216, -0.011439865455031395, 0.012488665990531445, -0.07671522349119186, -0.017636314034461975, 0.021899249404668808,
    0.019397646188735962, 0.07065104693174362, 0.03490506485104561, -0.05127541720867157, 0.07098868489265442, -0.06415323168039322, -0.004408258479088545, 0.06934646517038345,
    0.03549642115831375, 0.009648622944951057, 0.16081269085407257, 0.08278606832027435, 0.0866846963763237, 0.022378193214535713, -0.07246285676956177, -0.09925326704978943,
    0.0075528924353420734, 0.005002460442483425, 0.000697850831784308, -0.039853211492300034, 0.0467161126434803, -0.11118634790182114, 0.044238608330488205, -0.003146348986774683,
    0.07760685682296753, -0.011975069530308247, -0.011293530464172363, 0.04522430896759033, -0.15975035727024078, 0.1134735718369484, 0.08008639514446259, 0.033050425350666046,
    -0.023854471743106842, -0.030463138595223427, -0.027269981801509857, -0.08455698937177658, -0.045186273753643036, -0.06594731658697128, 0.015640536323189735, 0.08229798823595047,
    -0.02806066907942295, -0.0006842224393039942, -0.050597354769706726, 0.010068031027913094, 0.04387769475579262, 0.016624415293335915, 0.009588904678821564, -0.019729968160390854,
    0.10985952615737915, -0.10571934282779694, 0.1860637366771698, 0.10007628053426743, 0.050470057874917984, -0.031751763075590134, -0.016635650768876076, -0.008534272201359272,
    -0.018172256648540497, -0.16302569210529327, -0.047987200319767, 0.017268255352973938, -0.026185398921370506, -0.03764015808701515, -0.019229751080274582, 0.1561657190322876,
    0.12011508643627167, -0.0023310210090130568, 0.06181032955646515, 0.08615037798881531, 0.07141213119029999, -0.014027210883796215, -0.04333706200122833, 0.11483239382505417,
    0.010644560679793358, 0.03383486717939377, 0.012602216564118862, 0.06597445160150528, 0.01016400195658207, -0.06858738511800766, -0.021956419572234154, 0.0025312467478215694,
    0.1053796038031578, -0.06303615123033524, 0.025731980800628662, -0.04974089190363884, 0.19539549946784973, -0.09540987014770508, -0.06706827133893967, 0.04272039979696274,
    -0.044359710067510605, 0.02016289345920086, 0.06326428800821304, -0.22295667231082916, 0.1593419760465622, 0.011519625782966614, -0.025447634980082512, -0.030005672946572304,
    0.058506712317466736, 0.06563360244035721, 0.09688620269298553, -0.06391259282827377, 0.06524388492107391, -0.0005185421323403716, -0.032297104597091675, -0.08049920201301575,
    0.14028765261173248, -0.0914807990193367, -0.04867500066757202, -0.0019207003060728312, 0.052547045052051544, -0.0722198337316513, 0.03977711871266365, -0.013497562147676945,
    -0.01462109386920929, 0.1675427258014679, 0.008337235078215599, 0.048132818192243576, -0.0036995445843786, -0.06605006754398346, 0.06959506869316101, 0.06788385659456253,
    0.14293356239795685, -0.01922505721449852, 0.06323052197694778, 0.030385490506887436, 0.04162950441241264, -0.008254329673945904, 0.07418830692768097, 0.007754988968372345,
    -0.057430192828178406, -0.06652746349573135, 0.011623438447713852, 0.014953541569411755, -0.010540823452174664, -0.06858792901039124, 0.08527462184429169, 0.0329383984208107,
    0.03447809815406799, 0.032459039241075516, -0.14988751709461212, 0.03586427494883537, -0.004837972577661276, -0.043191295117139816, 0.012944978661835194, 0.05122600495815277,
    -0.031238293275237083, -0.057097069919109344, -0.020719144493341446, -0.01994333043694496, 0.0010352429235354066, 0.10349069535732269, -0.15438944101333618, -0.03365439176559448,
    -0.0674559697508812, 0.027631964534521103, -0.06603174656629562, -0.08975160121917725, 0.08342538774013519, -0.023783070966601372, 0.04985129088163376, 0.13545949757099152,
    -0.023707395419478416, -0.03238743916153908, 9.75335351540707e-05, -0.09203056246042252, 0.08796572685241699, -0.26201656460762024, -0.05911814793944359, -0.0014868708094581962,
    0.03700161725282669, 0.025105033069849014, 0.0277473796159029, 0.10007742792367935, 0.04470433294773102, 0.10977095365524292, 0.015534170903265476, 0.0364561565220356,
    0.010156488977372646, -0.02753468230366707, 0.2311650514602661, -0.015345651656389236, -0.03248544782400131, -0.07787889987230301, -0.0739506334066391, -0.04174995794892311,
    0.04594278708100319, -0.16471418738365173, 0.09043797850608826, 0.05995144695043564, -0.05266253650188446, -0.038875557482242584, 0.041561949998140335, -0.2489006519317627,
    0.012372107245028019, 0.09231266379356384, 0.11034491658210754, 0.18086661398410797, 0.11520064622163773, 0.12934166193008423, -0.02770061232149601, 0.09838120639324188,
    -0.10574167966842651, -0.06794437021017075, -0.006409602705389261, 0.038237180560827255, 0.030671562999486923, -0.020025646314024925, 0.0221351757645607, 0.02648160420358181,
    0.055226925760507584, 0.07205855846405029, -0.06295592337846756, 0.01563924551010132, -0.10283225029706955, 0.006921719294041395, -0.10217279195785522, 0.10793077945709229,
    0.03395086154341698, -0.005039186216890812, 0.06309507042169571, -0.07907237857580185, 0.12881867587566376, 0.07612176984548569, 0.11807256937026978, 0.15087510645389557,
    0.08387099206447601, 0.015477954410016537, -0.035059187561273575, -0.002232941100373864, 0.016220884397625923, 0.04985132813453674, -0.050037283450365067, -0.021403318271040916,
    0.15721073746681213, 0.09832371771335602, 0.08205404132604599, -0.0043840366415679455, 0.1405334323644638, -0.010314024984836578, -0.006694030947983265, -0.02863641083240509,
    -0.04025876522064209, 0.024026134982705116, 0.021937459707260132, 0.0738045796751976, -0.0663033202290535, -0.11038648337125778, -0.0469178669154644, -0.05798168107867241,
    0.056707028299570084, -0.05071895942091942, 0.1069069504737854, 0.04381371662020683, -0.006191764026880264, -0.10767500847578049, -0.07056749612092972, -0.02167779766023159,
    0.13066460192203522, -0.235611230134964, -0.045727454125881195, -0.026080984622240067, -0.02559812180697918, 0.09549834579229355, 0.11720965802669525, 0.08407240360975266,
    0.05558472499251366, 0.11780112236738205, 0.10081130266189575, 0.058840300887823105, 0.04939932003617287, 0.010320440866053104, -0.009161903522908688, -0.05442524328827858,
    -0.020732609555125237, 0.01736341044306755, 0.01021027285605669, 0.04015326872467995, -0.10047215223312378, 0.04359389841556549, -0.02086675725877285, -0.06883448362350464,
    -0.047681473195552826, -0.061177808791399, -0.004381420090794563, 0.007063261233270168, -0.052115920931100845, -0.035206589847803116, 0.047353293746709824, 0.027212878689169884,
    -0.09294247627258301, -0.09411691129207611, 0.016549641266465187, -0.17332974076271057, 0.00859137438237667, 0.22088798880577087, -0.09136540442705154, -0.030938364565372467,
    0.05412638559937477, 0.07222423702478409, -0.06266403943300247, 0.1187279224395752, -0.1645558923482895, 0.03978447616100311, 0.010003267787396908, -3.519224628689699e-05,
    0.005776470992714167, -0.05734168738126755, 0.14558817446231842, -0.02642931044101715, -0.01602286286652088, -0.009363093413412571, 0.016635827720165253, -0.05529387667775154,
    0.002067832974717021, -0.12948261201381683, 0.03362138196825981, -0.03713088855147362, -0.03619984909892082, -0.0001377394364681095, 0.0062035988084971905, 0.23009270429611206,
    0.09749096632003784, -0.022196859121322632, -0.093809574842453, -0.2067924439907074, -0.006765525322407484, 0.08180227130651474, -0.05072607472538948, -0.016316333785653114,
    -0.006361335515975952, -0.05184825882315636, 0.04422301799058914, -0.1417234092950821, 0.11102396249771118, -0.05298484489321709, 0.01574072241783142, 0.0962563157081604,
    0.0020818719640374184, -0.05077621713280678, -0.0030672550201416016, -0.06775077432394028, 0.07185158878564835, 0.006784784607589245, -0.05640869960188866, -0.004227585159242153,
    -0.025109007954597473, -0.07040420919656754, -0.021816052496433258, 0.14600662887096405, -0.015129542909562588, 0.010211209766566753, 0.007885518483817577, 0.10916052013635635,
    -0.058656249195337296, 0.060999222099781036, -0.09031354635953903, 0.03629758954048157, -0.0518835112452507, 0.008098180405795574, 0.19945991039276123, -0.010603288188576698,
    -0.10051178932189941, -0.11889868229627609, 0.12305676192045212, 0.045819349586963654, 0.03628527745604515, -0.04052817076444626, 0.018886886537075043, 0.07099021971225739,
    -0.08619876205921173, -0.01750226691365242, -0.00799835380166769, -0.10710232704877853, -0.0852077528834343, 0.04879123345017433, -0.0004251148202456534, -0.05213790014386177,
    -0.07166989892721176, -0.13019917905330658, 0.09136418253183365, -0.017227858304977417, -0.09168335795402527, -0.0056564342230558395, 0.0191703699529171, 0.013496625237166882,
    -0.04912630468606949, -0.05295129865407944, -0.040783267468214035, -0.04842087998986244, 0.03287940472364426, 0.006796169560402632, 0.09538985043764114, 0.1679600328207016,
    0.049273598939180374, 0.19160036742687225, -0.08265421539545059, 0.13373783230781555, -0.03461626172065735, -0.0634528398513794, 0.028211932629346848, 0.08748475462198257,
    -0.06985335052013397, -0.040049485862255096, -0.028766155242919922, -0.05123155936598778, -0.07763086259365082, 0.14414477348327637, -0.1388644129037857, -0.03615182265639305,
    -0.0927184596657753, 0.059781406074762344, 0.04011409729719162, 0.014830817468464375, 0.009465501643717289, -0.005105362273752689, -0.0986616462469101, -0.042918264865875244,
    -0.08082012832164764, 0.0017972122877836227, 0.08641590923070908, 0.04144076630473137, -0.07533900439739227, -0.045686833560466766, -0.11790941655635834, -0.001851284527219832,
    -0.029000654816627502, -0.0124064851552248, 0.09130673855543137, -0.059796158224344254, 0.10162943601608276, 0.11878546327352524, -0.03603509068489075, 0.022327503189444542,
    0.049115799367427826, 0.009374727495014668, -0.024678323417901993, 0.00681225024163723, -0.032478634268045425, 0.0130689088255167, 0.03635057806968689, 0.000884321634657681,
    0.0018746982095763087, 0.038770273327827454, -0.06487445533275604, 0.025571154430508614, 0.010918677784502506, 0.012569649145007133, -0.07648671418428421, -0.17128396034240723,
    -0.0008746117237024009, -0.11228721588850021, -0.10187172144651413, 0.004908463917672634, -0.06073681637644768, 0.07455098628997803, 0.022655637934803963, -0.09493602067232132,
    -0.005545608699321747, -0.024494323879480362, 0.0739118903875351, -0.10118319094181061, 0.04536096379160881, 0.009893588721752167, -0.05333385989069939, -0.028798997402191162,
    -0.03196358680725098, 0.024944260716438293, 0.06226362660527229, -0.10494186729192734, 0.04113813489675522, 0.05982041358947754, -0.03147296607494354, 0.05211881548166275,
    -0.10234992951154709, 0.05383163318037987, 0.05450427532196045, 0.22099348902702332, -0.1369156539440155, -0.12231972813606262, 0.03437865525484085, -0.07506208121776581,
    -0.07520393282175064, -0.02264837548136711, 0.025612719357013702, 0.01593131013214588, -0.07149897515773773, 0.02690966986119747, 0.10993023961782455, 0.12271293252706528,
    -0.1512926071882248, 0.03077453188598156, -0.03475315123796463, -0.004576733335852623, -0.054947782307863235, 0.07880881428718567, -0.041123781353235245, -0.009771623648703098,
    -0.02495167776942253, -0.1054116040468216, 0.005535091273486614, -0.0793367549777031, -0.061946455389261246, 0.09123365581035614, -0.030748263001441956, 0.07709804177284241,
    -0.08247560262680054, 0.047982387244701385, 0.0488097183406353, -0.009883329272270203, -0.016014153137803078, -0.04153173416852951, 0.010982324369251728, -0.011630703695118427,
    0.09450186043977737, -0.10236945748329163, -0.0029836674220860004, -0.16461096704006195, 0.06490123271942139, -0.018899444490671158, -0.04165757820010185, -0.02027035690844059,
    0.022564085200428963, 0.09346530586481094, 0.051250770688056946, -0.06752348691225052, 0.11843754351139069, -0.04198334738612175, -0.09482881426811218, -0.067784383893013,
    -0.009893183596432209, -0.011391527019441128, -0.0484541691839695, 0.07112644612789154, 0.04128352552652359, 0.2503337264060974, 0.0072610825300216675, -0.021246707066893578,
    -0.0937536433339119, 0.04136129468679428, 0.038927868008613586, -0.02706598863005638, -0.08435699343681335, -0.005538336466997862, 0.029807716608047485, -0.13885314762592316,
    0.05414358898997307, -0.042660556733608246, -0.02623581513762474, 0.07858646661043167, -0.08042296022176743, 0.01823566108942032, -0.16632774472236633, -0.07446874678134918,
    0.008443702012300491, 0.031296998262405396, -0.000519213848747313, -0.060071997344493866, 0.062403853982686996, 0.05072982609272003, 0.03341043367981911, 0.006678983103483915,
    0.06306461244821548, 0.05131353437900543, -0.06326975673437119, 0.028712531551718712, -0.0025709932669997215, -0.03864176198840141, 0.03966810554265976, -0.011963749304413795,
    0.04278555512428284, -0.04017665982246399, 0.058985188603401184, 0.013399772346019745, -0.001380432047881186, -0.018561240285634995, -0.04638213664293289, 0.01005407702177763,
    0.08940885961055756, 0.04151296243071556, 0.11726605892181396, 0.25330451130867004, -0.019377514719963074, -0.0019327207701280713, -0.05208778381347656, 0.010358561761677265,
    0.12279162555932999, -0.10456451773643494, 0.023331917822360992, -0.0732186809182167, -0.01707047037780285, 0.10503228008747101, 0.02347949706017971, -0.0060335369780659676,
    -0.022526318207383156, 0.052736781537532806, -0.018369967117905617, -0.12450644373893738, 0.012061206623911858, 0.06430024653673172, 0.08348578214645386, -0.02407044544816017,
    -0.06546211987733841, -0.02329161763191223, 0.0075074732303619385, 0.07187911123037338, -0.0023948168382048607, -0.1493614912033081, 0.015380335971713066, -0.007496563717722893,
    -0.0016982110682874918, -0.023881645873188972, 0.07491316646337509, 0.0703008845448494, -0.007651501800864935, -0.036481525748968124, -0.09072627872228622, -0.03579597920179367,
    -0.21813099086284637, 0.01304687187075615, -0.04471724107861519, 0.021794645115733147, 0.15870964527130127, 0.027393626049160957, -0.05531363934278488, -0.055682335048913956,
    -0.03142857551574707, 0.01822747103869915, 0.039517052471637726, 0.09140165895223618, 0.011493265628814697, -0.19068025052547455, 0.022460004314780235, 0.01478294376283884,
    -0.02910546027123928, 0.060569025576114655, -0.008301467634737492, 0.00604002270847559, 0.03883165866136551, 0.0509306825697422, 0.1306171715259552, 0.02156035415828228,
    -0.04545608535408974, 0.009236441925168037, -0.0155353844165802, -0.024976247921586037, 0.034559719264507294, -0.07004964351654053, -0.10670910030603409, 0.01660909317433834,
    -0.034190643578767776, 0.005971459671854973, -0.07884292304515839, -0.07835614681243896, 0.020483866333961487, -0.0008899800595827401, 0.025737667456269264, 0.0460706502199173,
    0.004243073984980583, -0.02196625806391239, -0.13720165193080902, 0.05604013800621033, 0.027421260252594948, 0.12375365942716599, -0.035017404705286026, 0.023209046572446823,
    0.1116807758808136, 0.04032503813505173, 0.030752118676900864, 0.007652968633919954, -0.13196434080600739, -0.09544675797224045, -0.030043914914131165, -0.0922083631157875,
    0.1268836408853531, 0.09755052626132965, -0.04007395729422569, 0.039128921926021576, -0.12832726538181305, 0.20903140306472778, -0.15762360394001007, -0.027802500873804092,
    -0.04436773434281349, -0.018086055293679237, 0.014510233886539936, -0.02337443269789219, 0.0945424810051918, 0.12305090576410294, 0.03374341130256653, -0.009040881879627705,
    0.05741006135940552, 0.09226487576961517, -0.06890766322612762, -0.014568180777132511, 0.01030527800321579, -0.041024740785360336, -0.08957000076770782, -0.025226004421710968,
    0.025701289996504784, -0.009693299420177937, 0.015778427943587303, 0.010981605388224125, 0.03411225229501724, -0.012947787530720234, 0.026967547833919525, 0.1214129701256752,
    -0.022110190242528915, 0.02051866240799427, 0.03480873256921768, -0.11408776789903641, 0.08759535849094391, -0.0638044998049736, 0.012829802930355072, 0.026824144646525383,
    0.11235681921243668, -0.06694386154413223, 0.012954235076904297, -0.05008883774280548, 0.0039703818038105965, 0.0019347546622157097, 0.10149993002414703, -0.05619683861732483,
    -0.05085751414299011, 0.014291834086179733, 0.019216254353523254, 0.0021294315811246634, -0.07949616760015488, 0.08675336092710495, -0.04167397692799568, -0.011825631372630596,
    -0.016584133729338646, 0.015762921422719955, 0.07294291257858276, -0.13263043761253357, -0.05978382006287575, -0.06457031518220901, 0.06792855262756348, 0.041624363511800766,
    0.04762173444032669, 0.01528090238571167, -0.08406531810760498, 0.02903643622994423, 0.08419390022754669, -0.07011457532644272, 0.006931439507752657, -0.10158652067184448,
    -0.05105940252542496, -0.024582067504525185, 0.10894187539815903, 0.01043248362839222, -0.03652764856815338, -0.07878653705120087, 0.015390931628644466, 0.02689223922789097,
    -0.002958463504910469, 0.031124426051974297, 0.004061166197061539, 0.03724578022956848, -0.010739448480308056, -0.006085332948714495, -0.019230978563427925, 0.025539029389619827,
    0.11132362484931946, 0.014917001128196716, -0.025395700708031654, 0.0054139308631420135, 0.021035192534327507, 0.009954622946679592, 0.02681836672127247, -0.05768565088510513,
    -0.045136820524930954, 0.08173643797636032, -0.029573949053883553, 0.019963935017585754, -0.08288329094648361, -0.026462862268090248, -0.058974504470825195, -0.06542665511369705,
    0.0083082290366292, 0.06073146313428879, 0.0322316512465477, -0.18390235304832458, -0.11119423061609268, -0.021321790292859077, 0.006446882616728544, -0.09761212766170502,
    -0.016743097454309464, 0.014042403548955917, 0.08847490698099136, -0.026904409751296043, 0.04599427431821823, -0.08216670900583267, 0.043000999838113785, -0.005140875931829214,
    0.043195512145757675, 0.054335325956344604, 0.011912483721971512, 0.015500606037676334, -0.026040267199277878, -0.10235022008419037, 0.11806695908308029, -0.15555822849273682,
    0.07734941691160202, 0.05765708163380623, 0.010609341785311699, 0.024910692125558853, -0.017964376136660576, -0.12670762836933136, -0.14009708166122437, -0.0532352477312088,
    -0.09064546972513199, 0.020956117659807205, 0.023047342896461487, 0.017791513353586197, 0.011048461310565472, 0.02544907107949257, -0.007445630617439747, -0.034105442464351654,
    0.006735580507665873, -0.05821755528450012, 0.04367255046963692, 0.06609191000461578, 0.0647839903831482, -0.08614060282707214, -0.054737694561481476, 0.1299934983253479,
    -0.002672049915418029, 0.05448482185602188, 0.010553000494837761, -0.02603130042552948, 0.08281756937503815, -0.037195537239313126, -0.007384804543107748, -0.19077955186367035,
    -0.08991879969835281, 0.05492575094103813, -0.14347149431705475, -0.15695953369140625, 0.15703275799751282, -0.13871429860591888, 0.01423995103687048, -0.026180725544691086,
    0.05828484520316124, 0.019887039437890053, -0.04676458612084389, 0.0068448069505393505, 0.014321352355182171, -0.017705541104078293, 0.0665963739156723, -0.050618719309568405,
    -0.050855450332164764, -0.0889412984251976, 0.09120473265647888, 0.05039133131504059, 0.15445992350578308, 0.08545921742916107, -4.357695797807537e-05, -0.00013266126916278154,
    0.06554979830980301, 0.007460434455424547, -0.0030753277242183685, -0.17316870391368866, -0.08049566298723221, 0.26145443320274353, 0.03272464871406555, 0.05940898880362511,
    -0.052010368555784225, 0.07454565167427063, -0.11908789724111557, 0.05395680293440819, -0.06026946008205414, -0.010376282967627048, -0.14181111752986908, -0.044589076191186905,
    0.16086119413375854, 0.10797476768493652, 0.005842147395014763, 0.024106629192829132, -0.019243722781538963, -0.04602988064289093, -0.0507676899433136, -0.07153730094432831,
    -0.0174437016248703, 0.010685923509299755, 0.1616850644350052, 0.029112745076417923, -0.03105853497982025, 0.1996418982744217, 0.0024897127877920866, 0.07371912151575089,
    0.1321108341217041, -0.014947774820029736, 0.03414004668593407, -0.016017822548747063, 0.018162231892347336, 0.08328479528427124, 0.0233816709369421, 0.026795638725161552,
    0.06259050220251083, 0.11261963844299316, 0.057687096297740936, -0.11888424307107925, 0.042011808604002, -0.02276488021016121, 0.009607240557670593, -0.06271813809871674,
    -0.03950274735689163, 0.03833296149969101, 0.014030621387064457, -0.11672239750623703, -0.14128156006336212, 0.018271638080477715, 0.09342679381370544, 0.029607268050312996,
    -0.02568589150905609, -0.05302702635526657, 0.10123220086097717, 0.0011147857876494527, 0.06531500816345215, -0.1946852207183838, -0.13432060182094574, 0.05176028236746788,
    -0.11007733643054962, -0.07554197311401367, 0.06563562154769897, 0.056506168097257614, -0.11208684742450714, 0.013998388312757015, 0.11837844550609589, 0.04649507999420166,
    0.007050672546029091, -0.03402293100953102, -0.042342860251665115, 0.14877116680145264, 0.020059511065483093, 0.15751029551029205, -0.05169770494103432, 0.06361459195613861,
    0.06575924903154373, 0.02891433797776699, 0.00018584317876957357, -0.02592349983751774, 0.07116088271141052, -0.04332824423909187, -0.0030406732112169266, -0.05041651055216789,
    -0.09735545516014099, 0.014863641001284122, 0.13359244167804718, -0.0440497025847435, 0.0591854527592659, -0.0030169186647981405, -0.07859725505113602, 0.0014932862250134349,
    -0.02737751230597496, 0.03752274811267853, 0.013856417499482632, 0.003392444457858801, -0.06296973675489426, -0.05792837589979172, 0.04041559621691704, 0.13799357414245605,
    -0.043926604092121124, -0.07539264112710953, 0.07192447036504745, 0.23265643417835236, 0.009146496653556824, -0.16012997925281525, 0.038766223937273026, -0.019080638885498047,
    0.020676977932453156, 0.0024367666337639093, 0.03439506143331528, -0.04991408810019493, -0.037413954734802246, 0.018779294565320015, -0.05335747078061104, -0.06486457586288452,
    -0.027987845242023468, 0.07193409651517868, -0.03888959437608719, -0.058042388409376144, -0.07056187093257904, -0.05845552310347557, 0.07235952466726303, -0.03730237856507301,
    0.06613471359014511, 0.0472232960164547, -0.0702376663684845, -0.0877617597579956, -0.08286605030298233, 0.3502753973007202, -0.013053974136710167, -0.1466953456401825,
    0.043825507164001465, 0.03046947903931141, 0.01376253366470337, -0.036622583866119385, -0.04166796803474426, 0.03003411553800106, 0.10810601711273193, -0.01276735682040453,
    0.18173854053020477, -0.039555780589580536, -0.01854633539915085, -0.011535563506186008, 0.05700886994600296, -0.03318947181105614, 0.03710270673036575, -0.0735732913017273,
    0.025263285264372826, -0.0872940719127655, -0.0204206220805645, -0.12806127965450287, 0.026799820363521576, -0.12839962542057037, -0.07510434091091156, 0.09873808175325394,
    0.03806334361433983, -0.06491945683956146, 0.06146271526813507, 0.018339578062295914, 0.05213836953043938, 0.026574647054076195, 0.03256746008992195, 0.0017015935154631734,
    0.052018437534570694, 0.062252387404441833, 0.06512285768985748, -0.0018486444605514407, 0.030219990760087967, 0.019039304926991463, -0.020644698292016983, -0.09107554703950882,
    -0.013346120715141296, -0.07785811275243759, -0.020840326324105263, -0.048018746078014374, -0.08030636608600616, 0.048324815928936005, -0.01466529443860054, -0.021985607221722603,
    -0.01572699099779129, 0.021393999457359314, -0.004164199810475111, -0.014453551732003689, -0.044661808758974075, -0.1325693279504776, 0.10859119892120361, 0.030049070715904236,
    -0.020082278177142143, 0.014458488672971725, -0.07880545407533646, 0.025830060243606567, -0.06813691556453705, 0.0175018310546875, 0.09924699366092682, -0.05764958634972572,
    -0.02553013153374195, 0.017522523179650307, -0.00957762636244297, -0.03494107350707054, 0.012225324288010597, -0.10467910766601562, 0.0605648048222065, -0.027818839997053146,
    0.02567409910261631, 0.041872017085552216, -0.006569163873791695, -0.001143289147876203, -0.011843523941934109, -0.05603092908859253, -0.02554040029644966, 0.013227145187556744,
    -0.013239704072475433, 0.06591621786355972, 0.009858541190624237, 0.02618655003607273, -0.025245992466807365, 0.018140025436878204, 0.007922383025288582, 0.0030123621691018343,
    -0.0632820799946785, 0.062303055077791214, -0.05815451219677925, 0.00556631525978446, -0.03152472525835037, -0.028388014063239098, 0.002105183433741331, 0.0002118593401974067,
    -0.02649972029030323, 0.033360280096530914, 0.008555744774639606, -0.03458765521645546, -0.03351718932390213, 0.01302399579435587, 0.01609904132783413, -0.031604114919900894,
    0.04295937716960907, 0.04035510495305061, -0.03396608307957649, 0.0261983722448349, -0.009033549576997757, -0.03590461611747742, 0.046492915600538254, -0.0010433223797008395,
    0.014386662282049656, -0.019252920523285866, 0.014604685828089714, 0.012124059721827507, -0.009505543857812881, -0.01937282457947731, -0.04009397700428963, 0.06433960050344467,
    -0.03863643854856491, -0.009434299543499947, -0.039162129163742065, -0.03697461262345314, 0.04298799857497215, 0.05935252830386162, -0.013779946602880955, 0.0341680571436882,
    -0.05157056823372841, 0.0022451861295849085, -0.07667552679777145, -0.03734828904271126, 0.03549696505069733, -0.039683371782302856, -0.005645263008773327, 0.0016541066579520702,
    -0.026143938302993774, -0.030822178348898888, 0.0030956175178289413, 0.010205616243183613, 0.025025511160492897, -0.052118752151727676, -0.018979422748088837, -0.020595144480466843,
    -0.0069108870811760426, -0.028091514483094215, -0.0020799082703888416, 0.035484448075294495, 0.04732714965939522, -0.06068643182516098, -0.004790321458131075, 0.022184276953339577,
    0.015507430769503117, 0.0032062074169516563, -0.02140570618212223, 0.03430628031492233, 0.004190108273178339, 0.009063618257641792, -0.0001601098192622885, -0.02763543650507927,
    -0.0275044497102499, -0.0692262202501297, 0.028495194390416145, 0.02182345651090145, -0.021415816619992256, 0.04551484435796738, 0.03565195947885513, 0.08270525187253952,
    -0.011304041370749474, 0.014455163851380348, 0.006117698736488819, -0.0032808391842991114, -0.007051275111734867, 0.049888186156749725, 0.03478825464844704, -0.0037157891783863306,
    0.022654376924037933, -0.023038217797875404, -0.03667875751852989, -0.014604046009480953, 0.02907421812415123, -0.047834113240242004, -0.029624786227941513, -0.0869937539100647,
    0.012290334329009056, 0.015149437822401524, -0.008286545984447002, 0.03399401903152466, 0.06574371457099915, 0.00024200441839639097, 0.05243464931845665, -0.05706169456243515,
    0.05150928348302841, -0.02782631665468216, -0.0029904686380177736, -0.007165694609284401, -0.034285202622413635, 0.07608138769865036, -0.006397755816578865, 0.020364318042993546,
    0.010572013445198536, -0.01755029521882534, 0.022727908566594124, -0.023429270833730698, -0.033050402998924255, -0.027364881709218025, -0.0013326947810128331, -0.013867663219571114,
    0.03187118098139763, 0.04378360137343407, -0.016555137932300568, -0.02111707627773285, 0.029851699247956276, -0.05612599477171898, -0.01817413605749607, 0.030255142599344254,
    0.006386857014149427, 0.05061498284339905, 0.028937552124261856, -0.019060488790273666, -0.05940721184015274, 0.02044600434601307, -0.003028769278898835, -0.010298844426870346,
    -0.01706147938966751, 0.008658726699650288, 0.038101501762866974, -0.01716694049537182, -0.03682918846607208, -0.043283749371767044, 0.02538381516933441, -0.017845522612333298,
    -0.043027084320783615, -0.00569858867675066, 0.05599319562315941, -0.007135198917239904, -0.010278386995196342, -0.0037576581817120314, -0.01273359265178442, -0.01889723911881447,
    -0.04755707085132599, -0.012241069227457047, -0.013193764723837376, 0.0013503886293619871, -0.00781935639679432, -0.02786124311387539, -0.016575975343585014, -0.02296135015785694,
    -0.07458851486444473, -0.021407783031463623, 0.016452237963676453, -0.024250337854027748, 0.03771533444523811, 0.0394313707947731, 0.025415675714612007, -0.039311427623033524,
    -0.003665343625470996, 0.052001673728227615, 0.06344805657863617, -0.037431709468364716, 0.02651386335492134, 0.03952985629439354, 0.038001205772161484, 0.020396964624524117,
    -0.0784493014216423, -0.011986038647592068, 0.007928680628538132, -0.033920031040906906, 0.033582013100385666, -0.0576171837747097, -0.006968739442527294, 0.011740664951503277,
    -0.012797358445823193, 0.00777102867141366, -0.04443551227450371, 0.0069173709489405155, 0.00024860998382791877, -0.07871074974536896, -0.026260988786816597, 0.05641479790210724,
    0.023167841136455536, 0.04765843227505684, 0.06898228079080582, 0.011485416442155838, 0.029266633093357086, 0.030918097123503685, 0.013274364173412323, -0.004982423968613148,
    -0.03463943302631378, -0.024811996147036552, 0.008901160210371017, 0.011643578298389912, 0.006529428064823151, -0.004692180082201958, 0.04352593049407005, -0.001612153835594654,
    0.0010422394843772054, 0.01190387923270464, -0.013828391209244728, 0.03965037316083908, -0.029071304947137833, 0.013065067119896412, -0.007868225686252117, 0.058718640357255936,
    0.014132462441921234, -0.029625924304127693, -0.02535802498459816, 0.0027230633422732353, 0.014008784666657448, -0.09411726891994476, 0.05961815267801285, 0.0030714909080415964,
    -0.008504531346261501, -0.04754958301782608, 0.02760647051036358, 0.003194259712472558, 0.005547509528696537, 0.036308854818344116, 0.0069757248274981976, 0.031480494886636734,
    -0.015397073701024055, -0.021770332008600235, 0.06763613969087601, 0.02785155177116394, 0.06308145076036453, -0.004839962348341942, -0.02081228233873844, 0.07236052304506302,
    -0.00541665917262435, 0.013329935260117054, 0.04269063100218773, 0.0230058953166008, -0.027646366506814957, -0.03502852842211723, 0.004089789465069771, 0.012892727740108967,
    0.046902112662792206, 0.04171966388821602, 0.0400555282831192, -0.02796943672001362, 0.04120337963104248, -0.06204314902424812, 0.0547223724424839, -0.015685051679611206,
    -0.004883195739239454, 0.028077563270926476, 0.05375570431351662, -0.007031315937638283, 0.014294521883130074, 0.03215620294213295, 0.024119127541780472, 0.008961117826402187,
    0.001997224288061261, -0.012194894254207611, -0.04019590839743614, 0.02398502826690674, 0.01884721964597702, 0.013938994146883488, 0.02730901911854744, 0.04951618239283562,
    -0.03463677316904068, 0.058098964393138885, 0.10620518773794174, 0.019364282488822937, 0.02191186137497425, -0.03962969034910202, 0.00823222752660513, 0.023129472509026527,
    -0.009128615260124207, 0.0047461120411753654, -0.007387279067188501, -0.03617379441857338, 0.015650968998670578, 0.012858027592301369, 0.005425128620117903, 0.017922477796673775,
    -0.052597448229789734, 0.00616407347843051, 0.04495267942547798, 0.010242649354040623, 0.020092571154236794, -0.00209140800870955, -0.035305723547935486, 0.005700476001948118,
    0.04019574075937271, -0.00779077410697937, -0.01991487853229046, 0.016097916290163994, 0.03461548686027527, -0.037633080035448074, -0.025157662108540535, 0.007755944039672613,
    -0.03663523122668266, -0.006706997286528349, 0.007665908429771662, -0.003664781106635928, -0.01823345385491848, 0.07330834120512009, 0.08032140135765076, 0.005839422345161438,
    0.030907904729247093, -0.039589665830135345, 0.013140770606696606, -0.019049080088734627, 0.023728884756565094, 0.0398629866540432, -0.023174118250608444, -0.020642930641770363,
    -0.04731825366616249, -0.050048381090164185, -0.000492454506456852, -0.005862741265445948, -0.04247124493122101, -0.0047337873838841915, -0.0382150262594223, 0.0170141588896513,
    -0.026430463418364525, 0.012056992389261723, -0.016441449522972107, -0.01904461905360222, -0.028489328920841217, 0.0013333129463717341, 0.00936137419193983, 0.034467630088329315,
    0.025881079956889153, -0.028204428032040596, 0.007566528860479593, 0.0002583686728030443, -0.018838269636034966, -0.0071012480184435844, 0.0022672549821436405, 0.0011562687577679753,
    -0.0005590435466729105, -0.041407689452171326, 0.03734291344881058, 0.010367415845394135, 0.013770618475973606, 0.02912996895611286, -0.006734631955623627, 0.027068819850683212,
    0.01997998356819153, 0.03370334208011627, -0.025332937017083168, 0.005612606648355722, -0.0007441983325406909, -0.03757903352379799, -0.04748403653502464, -0.024818047881126404,
    0.061406806111335754, -0.005638554692268372, 0.001842453726567328, -0.011043425649404526, 0.014303330332040787, -0.06429444998502731, 0.009113743901252747, 0.03885442391037941,
    -0.006218001712113619, 0.01957559958100319, -0.010077053681015968, -0.01941582001745701, 0.0134420869871974, 0.05472833663225174, 0.017405664548277855, 0.034149330109357834,
    -0.06179601326584816, 0.04667694866657257, 0.040128033608198166, 0.041751448065042496, -0.008836515247821808, 0.023976709693670273, -0.016908593475818634, 0.004945489577949047,
    -0.0013697592075914145, 0.012138141319155693, -0.05078645050525665, -0.027919620275497437, -0.03832647576928139, -0.00951005145907402, 0.016727369278669357, -0.006253471598029137,
    -0.00027983303880319, -0.01401466317474842, -0.016475223004817963, -0.007617264520376921, 0.023627551272511482, 0.10542160272598267, -0.019320247694849968, -0.028433024883270264,
    -0.013253907673060894, 0.00034814138780348003, 0.04640772566199303, -0.016981832683086395, -0.017780426889657974, 0.07466777414083481, 0.018177008256316185, -0.01548660546541214,
    0.00046358382678590715, -0.024974694475531578, -0.016956131905317307, 0.018802370876073837, 0.001706309849396348, -0.0462077371776104, -0.06644211709499359, 0.004074339754879475,
    0.0024237362667918205, -0.017880138009786606, -0.05305582657456398, -0.011960521340370178, 0.0665399506688118, 0.031836945563554764, 0.019335834309458733, -0.02301838994026184,
    -0.030797891318798065, 0.02755502611398697, -0.012952182441949844, -0.04912010207772255, 0.019838426262140274, -0.011651942506432533, -0.05561240389943123, -0.015488331206142902,
    0.036271847784519196, -0.006141075398772955, 0.003406692296266556, -0.006324432790279388, -0.00880824588239193, -0.07969401776790619, -0.04533899948000908, -0.0030136832501739264,
    -0.007546375971287489, 0.0015397382667288184, 0.030174924060702324, -0.027765581384301186, 0.02008560299873352, 0.041565585881471634, 0.01820923388004303, 0.06235316023230553,
    0.011190655641257763, 1.9850340322591364e-05, -0.02793108858168125, -0.0091248769313097, -0.020853694528341293, 0.006308038253337145, -0.013473441824316978, 0.06333548575639725,
    0.0355045422911644, -0.004041776061058044, -0.018278129398822784, -0.052053019404411316, 0.040496621280908585, 0.046498335897922516, -0.00809535663574934, 0.012018128298223019,
    0.00870214682072401, 0.022269699722528458, -0.01404919009655714, 0.025608954951167107, 0.002460873918607831, 0.00341598829254508, 0.03839903697371483, 0.013047085143625736,
    -0.003790282877162099, 0.014546136371791363, 0.016620580106973648, -0.02455972321331501, 0.01048748567700386, 0.018198741599917412, 0.014346952550113201, -0.02076796256005764,
    -0.03120342455804348, 0.029388124123215675, 0.016383929178118706, -0.03436265140771866, -0.020186368376016617, 0.03939705342054367, -0.05305762216448784, 0.026131408289074898,
    -0.0036401592660695314, -0.003791949711740017, 0.003906646743416786, 0.01004786230623722, 0.10248670727014542, 0.030979547649621964, 0.024993931874632835, 0.03737713396549225,
    0.025477128103375435, 0.004526314791291952, -0.010996822267770767, -0.006655476056039333, 0.0012320990208536386, 0.022460147738456726, -0.01370636560022831, -0.01029509399086237,
    -0.021928543224930763, -0.008492007851600647, 0.05497733876109123, -0.025330623611807823, 0.021659988909959793, 0.04460449889302254, 0.020678462460637093, 0.028338490054011345,
    0.02534598670899868, -0.029671810567378998, 0.0002975554671138525, -0.027691945433616638, -0.027052519842982292, 0.04680679365992546, 0.010447792708873749, -0.024741457775235176,
    -0.01075762789696455, 0.03161364421248436, 0.009415382519364357, 0.023671993985772133, 0.004854751285165548, 0.0363868772983551, -0.045883242040872574, -0.02417347952723503,
    0.003426474751904607, -0.009279356338083744, -0.004332926589995623, 0.03449145331978798, 0.04642680287361145, -0.03185933455824852, -0.017000148072838783, -0.006624988745898008,
    -0.03901936858892441, 0.023774579167366028, -0.028822775930166245, -0.035058945417404175, 0.022591285407543182, 0.04390023276209831, -0.030229680240154266, -0.00809191819280386,
    -0.01864105835556984, 0.00986124575138092, -0.03751826658844948, -0.0012365375878289342, 0.05195048823952675, -0.050544679164886475, 0.02915746532380581, 0.01215631328523159,
    0.0077147819101810455, 0.051845449954271317, -0.03576979786157608, -0.034237928688526154, 0.02452978678047657, 0.06810819357633591, -0.0309439767152071, 0.04552982375025749,
    0.0028725049924105406, -0.0064882938750088215, -0.006054598838090897, 0.0008523220894858241, -0.009637686423957348, 0.008505800738930702, -0.007902777753770351, 0.022515732795000076,
    -0.0757627934217453, -0.04103271663188934, -0.04966573789715767, 0.0033974468242377043, 0.007836507633328438, 0.01044375915080309, 0.004411778412759304, -0.0030603494960814714,
    -0.07335406541824341, 0.03703964874148369, 0.0361773744225502, 0.0236786101013422, 0.04566727578639984, -0.05082641914486885, -0.05328910052776337, 0.007634889800101519,
    0.01649550162255764, -0.009164983406662941, 0.050852056592702866, 0.009082973934710026, 0.060363613069057465, 0.004845357500016689, 0.03549496829509735, -0.09157367795705795,
    -0.0065533132292330265, -0.0051428573206067085, 0.012788093648850918, -0.05818349868059158, -0.04552134871482849, -0.03222157061100006, -0.022210553288459778, 0.009264564141631126,
    -0.018203740939497948, -0.058948367834091187, -0.016155416145920753, -0.0034392541274428368, 0.005982383619993925, 0.02917376533150673, -0.05376555398106575, -0.04881569370627403,
    0.030449988320469856, -0.014875615946948528, 0.03809535130858421, -0.0032751034013926983, -0.025912413373589516, 0.011342634446918964, -0.03550076484680176, 0.00595964677631855,
    0.013118576258420944, 0.011729047633707523, 0.03166293725371361, -0.0019330838695168495, 0.06874293088912964, -0.030334463343024254, -0.042437657713890076, 0.01437682006508112,
    0.022190634161233902, 0.004828164819628, 0.019188253208994865, 0.051124658435583115, 0.02262754552066326, -0.02916734851896763, 0.018172655254602432, 0.00258871098048985,
    0.07354014366865158, 0.03472274914383888, -0.030566299334168434, 0.0019945271778851748, 0.03675183653831482, -0.028401751071214676, 0.008746533654630184, -0.058827921748161316,
    0.02924446389079094, -0.00823487900197506, 0.0023539296817034483, -0.003689049044623971, -0.015542520210146904, -0.0004048280534334481, 0.04895234853029251, 0.007074304856359959,
    -0.0008894245838746428, 0.0650096982717514, 0.011105816811323166, -0.004640346858650446, -0.017664866521954536, 0.058367770165205, -0.03602708503603935, -0.06106186285614967,
    -0.0008721784106455743, -0.03668024390935898, 0.003219054313376546, -0.0024482649751007557, -0.01852266490459442, -0.005475111771374941, -0.03755205124616623, -0.005376323126256466,
    -0.020146818831562996, -0.07279879599809647, -0.0023864340037107468, -0.03161972016096115, 0.03165394440293312, -0.030402231961488724, -0.007640035357326269, 0.0022803584579378366,
    -0.04658355936408043, -0.0011077631497755647, -0.030851634219288826, -0.03542238846421242, 0.03882528841495514, -0.005430982448160648, -0.0059721642173826694, -0.047295942902565,
    0.06102164089679718, -0.0024860412813723087, -0.027177372947335243, 0.014494207687675953, -0.0012748130830004811, 0.030323397368192673, 0.0036881952546536922, -0.02349192090332508,
    0.04707442596554756, 0.03517558425664902, -0.031210899353027344, -0.010350439697504044, -0.05925453454256058, 0.06122881919145584, 0.05344401299953461, -0.0006688698776997626,
    0.024298131465911865, -0.00017548887990415096, -0.01911894604563713, 0.014899310655891895, 0.010142733342945576, 0.044513337314128876, -0.004140675067901611, -0.006205589510500431,
    0.042393628507852554, 0.018779151141643524, 0.032253291457891464, 0.014289934188127518, 0.006454207934439182, -0.012156532146036625, 0.02317730151116848, -0.04173935204744339,
    -0.009690891019999981, 0.021680479869246483, -0.02266545780003071, 0.0025835030246526003, 0.029675565659999847, -0.03491813689470291, 0.009948638267815113, 0.007297674659639597,
    -0.03999081254005432, -0.048358380794525146, 0.005981463938951492, 0.022126400843262672, 0.07179166376590729, 0.05788792669773102, 0.03109564259648323, -0.011587378568947315,
    -0.0021907927002757788, -0.008840970695018768, 0.020966295152902603, -0.05122449994087219, 0.0020487739238888025, -0.019318731501698494, 0.04867058992385864, 0.03247586265206337,
    0.014271872118115425, -0.04724502190947533, 0.039642345160245895, -0.03250579908490181, 0.05680490657687187, -0.030810294672846794, 0.022973259910941124, -0.027650730684399605,
    -0.04390833154320717, 0.004925678018480539, 0.044231656938791275, -0.0338345468044281, 0.08240224421024323, -0.023758886381983757, -0.030941441655158997, 0.0278449896723032,
    -0.0066481647081673145, -0.00250033987686038, -0.018049169331789017, 0.03952272981405258, -0.01445514615625143, -0.0018494061660021544, -0.006638879422098398, 0.0022399425506591797,
    -0.03496851399540901, -0.007247639819979668, 0.015399756841361523, 0.012681770138442516, 0.027789471670985222, 0.01600734144449234, -0.011152757331728935, -0.015187997370958328,
    0.0059376549907028675, -0.059416960924863815, 0.012317872606217861, 0.003300188574939966, -0.009382365271449089, 0.029652005061507225, -0.0011519977124407887, -0.005562774837017059,
    -0.03255218639969826, -0.01745159551501274, -0.0013993780594319105, -0.018965231254696846, 0.006396153476089239, -0.07002784311771393, 0.004367777146399021, 0.07008477300405502,
    0.029607897624373436, 0.012941918335855007, -0.0004268547345418483, 0.01379949040710926, -0.03367177024483681, 0.0747392475605011, 0.05379367992281914, -0.014330950565636158,
    0.03107414022088051, 0.020440982654690742, 0.04283031448721886, 0.006516029126942158, -0.0317608043551445, 0.05257045477628708, 0.028742274269461632, 0.014118362218141556,
    0.04825720563530922, -0.01761947013437748, 0.01918799616396427, -0.011782580055296421, 0.020578593015670776, -0.018639380112290382, 0.015612000599503517, -0.03235984221100807,
    -0.0427754670381546, 0.012591020204126835, -0.023028548806905746, 0.012964460067451, 0.0229670200496912, 0.010446426458656788, 0.015599685721099377, -0.022749120369553566,
    0.055858731269836426, -0.026547454297542572, 0.014080413617193699, -0.030696464702486992, -0.023883681744337082, -0.06838579475879669, -0.03452489525079727, -0.007658215239644051,
    0.017210792750120163, 0.004203776363283396, 0.02941102348268032, -0.041690900921821594, -0.008987504988908768, -0.013647469691932201, -0.010473968461155891, 0.022921932861208916,
    0.021527744829654694, -0.039002660661935806, -0.025580374523997307, -0.032237403094768524, -0.01822281815111637, -0.012530526146292686, -0.003857196308672428, -0.02558126300573349,
    0.03203833848237991, -0.0044984216801822186, -0.027348531410098076, 0.033222366124391556, -0.009068182669579983, 0.0005081549752503633, -0.010086123831570148, -0.025516390800476074,
    0.018637100234627724, 0.05292418599128723, -0.03416072577238083, -0.03654072433710098, 0.040068455040454865, 0.02040996216237545, -0.026393670588731766, 0.02030438371002674,
    -0.0276572797447443, -0.014804358594119549, -0.002563914516940713, 0.012996722012758255, 0.012934298254549503, 0.0120116351172328, -0.02626318670809269, 0.0009481220040470362,
    -0.00021331716561689973, 0.009949343279004097, -0.006673953030258417, -0.013703436590731144, -0.03203367441892624, -0.0572766438126564, 0.020120585337281227, 0.006249959114938974,
    0.015535389073193073, 0.043821364641189575, -0.010449232533574104, 0.018339239060878754, 0.08882901817560196, 0.04079360514879227, 0.04721013084053993, -0.014946907758712769,
    0.013113905675709248, -0.011013726703822613, 0.017375024035573006, -0.019108112901449203, 0.001517498167231679, -0.02450311928987503, 0.01566586084663868, -0.015067252330482006,
    -0.06002268195152283, -0.008420840837061405, -0.04738038033246994, -0.017592960968613625, 0.06387169659137726, -0.007488643284887075, 0.025077400729060173, 0.0003212354495190084,
    0.0039192731492221355, -0.014742940664291382, -0.014275486581027508, -0.061467040330171585, 0.0039142402820289135, -0.005152267403900623, 0.04960334673523903, 0.008695310913026333,
    0.0003677316417451948, -0.012120991945266724, 0.006092431955039501, -0.0062406351789832115, 0.014791233465075493, -0.055814627557992935, 0.052124086767435074, 0.008482437580823898,
    -0.042680177837610245, 0.015539838932454586, -0.009054308757185936, -0.03541729971766472, 0.07169179618358612, 0.012807127088308334, -0.03687431290745735, -0.0011565802851691842,
    0.003707891097292304, 0.030874034389853477, -0.0059643457643687725, -0.01860777474939823, 0.008317634463310242, 0.006325508467853069, -0.029143666848540306, -0.027566952630877495,
    -0.05311068147420883, -0.009394424967467785, 0.06497233361005783, 0.006619004067033529, -0.047861237078905106, -0.0071618095971643925, 0.015311100520193577, 0.052856337279081345,
    -0.02727263793349266, 0.023557143285870552, 0.0038284827023744583, -0.016592128202319145, 0.015776317566633224, 0.01275484450161457, 0.00715236971154809, 0.05884038284420967,
    0.014750379137694836, 0.012312224134802818, 0.05364849790930748, 0.005435981787741184, -0.01220192015171051, 0.06893695145845413, 0.004957948811352253, 0.005900378804653883,
    -0.008166532032191753, 0.0208925548940897, 0.008869390934705734, 0.0038089381996542215, -0.041899845004081726, 0.030003083869814873, 0.019042592495679855, -0.03925448656082153,
    -0.021161504089832306, 0.023175284266471863, -0.016344476491212845, -0.0013735066168010235, -0.03431205078959465, 0.03386887535452843, 0.03214414045214653, 0.03982367739081383,
    -0.014112063683569431, -0.027801208198070526, 0.04869644343852997, 0.03985745459794998, 0.006650339346379042, -0.03579212352633476, -0.007624011021107435, -0.00584034901112318,
    0.0011977223912253976, -0.016318870708346367, 0.02528260089457035, 0.01818876527249813, -0.09868418425321579, -0.018570177257061005, -0.023511555045843124, -0.022360481321811676,
    -0.021178895607590675, -0.02427183836698532, -0.0220210999250412, -0.0029877035412937403, -0.05849449709057808, -0.023416895419359207, 0.012653899379074574, -0.014022385701537132,
    0.023674843832850456, 0.03515245392918587, 0.015247908420860767, -0.02973710000514984, 0.00823518168181181, -0.02228769287467003, 0.037668514996767044, -0.0025472580455243587,
    -0.024278853088617325, -0.00033204565988853574, 0.02794027514755726, 0.007344897836446762, 0.09272901713848114, -0.045640744268894196, 0.012984152883291245, -0.021235309541225433,
    0.029011279344558716, 0.01770392619073391, -0.04287892207503319, 0.05129947513341904, -0.028516732156276703, 0.008952583186328411, -0.020068388432264328, -0.02936488576233387,
    -0.004852545913308859, 0.003524139756336808, 9.578888420946896e-05, 0.01389568392187357, 0.043511081486940384, -0.029632017016410828, 0.009385643526911736, -0.03722132742404938,
    -0.004431489855051041, -0.020495612174272537, 0.02330709993839264, -0.03780123591423035, -0.032474908977746964, 0.007796586491167545, -0.008977050893008709, -0.019723843783140182,
    -0.007296381052583456, 0.04934613034129143, -0.046820465475320816, -0.005217570811510086, 0.019104940816760063, 0.04443265497684479, 0.02294381521642208, 0.004886303097009659,
    0.011991280131042004, 0.02511347085237503, -0.05251842737197876, -0.0009697751374915242, -0.014853802509605885, 0.015743711963295937, -0.03337624669075012, -0.021370986476540565,
    0.026749512180685997, -0.0659785121679306, -0.04848010092973709, -0.023870650678873062, 0.012455059215426445, 0.00901744980365038, 0.01593884639441967, 0.020420018583536148,
    0.008086283691227436, 0.013381563127040863, 0.01672430709004402, -0.016803111881017685, 0.04292451590299606, 0.018161598592996597, -0.009592092595994473, -0.031010663136839867,
    0.0139571912586689, 0.02058103121817112, 0.0019648894667625427, -0.00045594642870128155, -0.0020334236323833466, -0.012468564324080944, -0.007497531361877918, 0.04187841713428497,
    0.005864650942385197, 0.026927338913083076, 0.04459569603204727, -0.006489756051450968, -0.01868809387087822, -0.05690174549818039, 0.02224515564739704, 0.011766877956688404,
    -0.057250719517469406, -0.05812584608793259, -0.03686417639255524, -0.005344489589333534, 0.021001620218157768, -0.010848202742636204, -0.024790985509753227, -0.04239685460925102,
    0.011787254363298416, 0.04320760443806648, -9.323361882707104e-05, -0.006842952687293291, 0.00041217225953005254, -0.0331045500934124, -0.03001955896615982, 0.0179264098405838,
    0.00019042397616431117, -0.07169840484857559, -0.014039549976587296, -0.037021346390247345, 0.046644922345876694, -0.018697867169976234, -0.031230008229613304, 0.02279139682650566,
    0.0036929447669535875, -0.006420548539608717, -0.016346801072359085, 0.014904080890119076, 0.01029177289456129, -0.0019257970852777362, 0.028855113312602043, -0.0013048716355115175,
    0.009372605010867119, -0.012560051865875721, 0.036585185676813126, 0.011105595156550407, 0.045777831226587296, -0.02416282892227173, -0.0024633405264467, 0.009162752889096737,
    -0.045627299696207047, -0.008563785813748837, 0.03502899780869484, 0.05867166444659233, 0.06024951487779617, -0.036879006773233414, 0.007462210021913052, -0.03219003975391388,
    -0.020500371232628822, 0.04335674270987511, -0.02166413888335228, 0.022740675136446953, 0.09851346909999847, 0.041835393756628036, -0.0068077570758759975, 0.019419802352786064,
    0.0012749109882861376, -0.05147234722971916, -0.006188200321048498, -0.058711614459753036, 0.06087535619735718, 0.0018926744814962149, 0.04057123512029648, 0.0032965722493827343,
    0.05725356191396713, 0.04144876077771187, -0.003887588158249855, -0.00031274199136532843, 0.013596338219940662, -0.0027864340227097273, 0.0337684266269207, -0.003844119841232896,
    -0.046461571007966995, -0.06990507990121841, -0.010894916020333767, -0.030560137704014778, -0.014318794012069702, 0.01632603444159031, 0.0142576415091753, -0.013380355201661587,
    -0.04329138994216919, -0.02038963884115219, 0.0010835736757144332, -0.009972740896046162, 0.008220507763326168, -0.0023823082447052, 0.027870867401361465, -0.03928043693304062,
    0.03733666613698006, -0.04251226782798767, 0.01281925942748785, -0.011141277849674225, -0.02390078455209732, -0.012737162411212921, -0.006287182681262493, -0.028864268213510513,
    0.012364650145173073, -0.02406044863164425, 0.032851140946149826, 0.000545866321772337, -0.008286395110189915, -0.013908833265304565, 0.0040018633008003235, -0.053051527589559555,
    -0.031191691756248474, -0.011347835883498192, -0.0514635406434536, 0.05389080569148064, 0.028561577200889587, -0.007418322842568159, -0.008478793315589428, 0.03129318729043007,
    -0.026242392137646675, -0.03227957710623741, 0.017361557111144066, 0.011977008543908596, -0.005217189900577068, -0.058643490076065063, 0.021355940029025078, 0.010273960418999195,
    -0.016135646030306816, 0.0005441359826363623, -0.04196208342909813, 0.004904396366328001, 0.028786418959498405, -0.003901710966601968, -0.02569049969315529, -0.02941492199897766,
    0.05028656870126724, -0.006240407936275005, 0.05347286909818649, 0.03946780413389206, 0.0023618629202246666, 0.009161185473203659, -0.0054969219490885735, 0.03581515699625015,
    0.05045618116855621, -0.023785242810845375, -0.016925735399127007, 0.004165230318903923, 0.018755478784441948, 0.005875702947378159, 0.020293138921260834, -0.04370424896478653,
    0.0052440958097577095, -0.018903007730841637, 0.007219830062240362, -0.01707059144973755, 0.013826070353388786, -0.019669286906719208, 0.04336937144398689, 0.03178445249795914,
    0.018884381279349327, 0.030121617019176483, 0.01745040901005268, -0.06681057810783386, -0.01931208372116089, 0.03972227871417999, -0.039923764765262604, 0.01902689039707184,
    -0.027152955532073975, -0.0011958234244957566, 0.04944652318954468, 0.003192321630194783, 0.027463342994451523, 0.028742941096425056, -0.011060262098908424, 0.0011386830592527986,
    -0.022172313183546066, -0.010371509939432144, 0.0008659216691739857, 0.026637142524123192, -0.04468501731753349, -0.01405976340174675, 0.020795710384845734, 0.016569415107369423,
    0.033017974346876144, -0.0024296005722135305, -0.012736472301185131, 0.0328899621963501, 0.08345583826303482, 0.014641037210822105, 0.01841334067285061, 0.03776658698916435,
    -0.001817098236642778, -0.03418236970901489, 0.016478348523378372, 0.0016949380515143275, 0.0016019745962694287, -0.05033494159579277, -0.002952338894829154, 0.010858162306249142,
    -0.03736186400055885, -0.027544450014829636, -0.009618669748306274, -0.006594759412109852, 0.06320444494485855, 0.004847488831728697, -0.0039192019030451775, -0.02666725218296051,
    -0.0031891795806586742, 0.027541939169168472, -0.032343678176403046, -0.021309377625584602, -0.010300267487764359, -0.010471625253558159, -0.03803076222538948, -0.009824906475841999,
    0.0054406942799687386, -0.007940668612718582, -0.009281262755393982, 0.002089404035359621, -0.016587737947702408, -0.023205697536468506, -0.019126970320940018, -0.0006134763243608177,
    -0.04744413122534752, 0.0015384253347292542, -0.050057947635650635, 0.012083608657121658, 0.04130161553621292, -0.008798915892839432, 0.035944972187280655, 0.030134910717606544,
    0.007394575513899326, 0.009230455383658409, -0.0165485180914402, -0.017265239730477333, -0.04353941231966019, 0.009124214760959148, 0.022783102467656136, 0.0012381593696773052,
    -0.04473114013671875, 0.012270142324268818, -0.027991635724902153, 0.05143275111913681, -0.03125613555312157, 0.03294583782553673, 0.028358813375234604, 0.08765266090631485,
    0.009816169738769531, 0.0009328299202024937, -0.04881477355957031, -0.0009705227566882968, 0.030223282054066658, -0.011797827668488026, 0.04608629271388054, -0.03156415373086929,
    0.0011260753963142633, -0.010962662287056446, 0.05314919352531433, 0.002557984320446849, -0.0486040934920311, -0.02294893004000187, -0.004435340873897076, 0.0020293083507567644,
    0.043989673256874084, 0.03569495677947998, 0.014904486015439034, -0.008996936492621899, -0.004880022257566452, -0.0067325783893466, 0.005000068806111813, -0.027553681284189224,
    -0.023619920015335083, 0.034164801239967346, -0.043917104601860046, 0.014171119779348373, -0.04037787765264511, 0.01102942693978548, 0.031717173755168915, -0.05187958478927612,
    -0.025144752115011215, 0.0006088885711506009, 0.0042645931243896484, -0.0012767622247338295, -0.043296925723552704, 0.03935704752802849, 0.06657148897647858, -0.006109068635851145,
    -0.038656797260046005, 0.019677046686410904, 0.009307111613452435, 0.052534446120262146, 0.02469453774392605, 0.011318095959722996, -0.00492912158370018, -0.01659756526350975,
    0.014751533977687359, 0.005173589568585157, -0.005785179790109396, -0.023175271227955818, -0.030066173523664474, 0.004852682817727327, -0.0267803855240345, 0.009889683686196804,
    0.01693829894065857, -0.029196960851550102, 0.025038661435246468, -0.010008472949266434, 0.0030327460262924433, 0.024005426093935966, 0.008742690086364746, 0.001713613630272448,
    -0.020706577226519585, 0.018780354410409927, 0.02554510347545147, 0.004495162516832352, 0.03689415380358696, -0.014229610562324524, 0.05182287096977234, 0.014264573343098164,
    0.024412056431174278, 0.01705262064933777, -0.009551146067678928, 0.042255938053131104, 0.02887360006570816, 0.041910987347364426, 0.004093171562999487, -0.00794520415365696,
    -0.0007176998187787831, 0.021041644737124443, 0.00810316950082779, -0.0042986683547496796, -0.017923424020409584, 0.012419781647622585, 0.015100061893463135, -0.05934292450547218,
    0.024401793256402016, 0.04909678176045418, 0.03309880197048187, 0.0022623296827077866, -0.038965947926044464, 0.01810433156788349, -0.0014104984002187848, -0.011618614196777344,
    0.02322513610124588, 0.02158023975789547, 0.0038519445806741714, -0.013197499327361584, -0.01512854266911745, -0.014792373403906822, 0.01737542264163494, 0.02351818047463894,
    0.02104387804865837, 0.062109194695949554, -0.016310149803757668, 0.027850734069943428, 0.004857450723648071, 0.040030982345342636, 0.04980082809925079, -0.018393030390143394,
    -0.012424815446138382, -0.011910125613212585, -0.014230266213417053, -0.003820570185780525, 0.06365790218114853, 0.020697494968771935, 0.012773443013429642, 0.06412708759307861,
    0.002144403988495469, 2.6442981834406964e-05, 0.01875455118715763, -0.048485733568668365, -0.03966521844267845, -0.03187420964241028, -0.047368407249450684, -0.052057500928640366,
    0.03648212179541588, 0.004450349137187004, -0.0005012954352423549, -0.029950225725769997, -0.014926563948392868, 0.06085539236664772, 0.004238910973072052, 0.06235732510685921,
    -0.015034612268209457, 0.011008413508534431, -0.02086838334798813, -0.011175645515322685, -0.00589711032807827, -0.011393175460398197, 0.005439838860183954, 0.004399881698191166,
    -0.03559938818216324, 0.0232325941324234, 0.035336703062057495, -0.008617288433015347, -0.012301868759095669, -0.02214796468615532, -0.04365791380405426, -0.0267618540674448,
    -0.037747208029031754, -0.004556299652904272, -0.009654970839619637, -0.0008850068552419543, -0.005808195564895868, -0.021458201110363007, -0.0018053518142551184, -0.017426123842597008,
    0.019546814262866974, 0.051371507346630096, -0.0026035041082650423, -0.04715782403945923, 0.031163297593593597, -0.07118875533342361, -0.013851015828549862, -0.029257019981741905,
    0.012925040908157825, 0.041403964161872864, -0.027769986540079117, 0.023037180304527283, 0.03576471656560898, 0.03584270551800728, 0.008356359787285328, -0.012469062581658363,
    -0.020293185487389565, -0.06245141103863716, -0.02376331016421318, -0.00022898726456332952, -0.00019242441339883953, 0.00855875015258789, 0.0383048839867115, -0.03866864740848541,
    0.056661494076251984, 0.04029899835586548, 0.010940425097942352, 0.04773031547665596, 0.02177364006638527, 0.004217612091451883, -0.00957141537219286, -0.006790917832404375,
    0.05877290666103363, 0.020630845800042152, 0.009887388907372952, 0.007160690147429705, 0.07238592207431793, -0.017124272882938385, 0.023059362545609474, -0.03659331053495407,
    -0.020096110180020332, -0.012206783518195152, -0.001459694467484951, -0.014253770001232624, -0.017544521018862724, -0.03501889109611511, -0.005050371866673231, -0.029649225994944572,
    0.01228369865566492, 0.06260839104652405, -0.04254455491900444, -0.005677464883774519, 0.012620617635548115, -0.03589462861418724, -0.00033227025414817035, 0.04956530034542084,
    -0.023662447929382324, -0.006799662485718727, 0.017884885892271996, 0.008306670002639294, -0.022664131596684456, -0.009162623435258865, -0.02353535406291485, 0.01335977390408516,
    0.037784162908792496, 0.03885212168097496, 0.02306065522134304, 0.00823367852717638, -0.009664181619882584, -0.031713634729385376, -0.03599339723587036, 0.021431628614664078,
    -8.202597382478416e-05, -0.01767205446958542, -0.05645129457116127, -0.0035888904239982367, -0.016519621014595032, 0.030633538961410522, 0.009619024582207203, -0.0066295284777879715,
    0.002216109074652195, 0.030011547729372978, 0.031233379617333412, 0.03346047177910805, -0.025736840441823006, -0.01768493466079235, -0.01205892488360405, -0.01385948434472084,
    -0.029774704948067665, -0.01286492682993412, -0.0070964922197163105, -0.009164152666926384, 0.043105293065309525, 0.04572412744164467, 0.007975280284881592, -0.023164136335253716,
    -0.009736863896250725, 0.0017292947741225362, 0.010344278067350388, 0.006462995894253254, -0.007294883951544762, -0.04325622692704201, -0.022660251706838608, -0.014857198111712933,
    -0.004432108718901873, -0.03403139486908913, -0.020243478938937187, -0.008399033918976784, -0.0025054961442947388, 0.0015208401018753648, 0.002484058728441596, -0.022999070584774017,
    -0.041280705481767654, 0.06514906883239746, 0.031142432242631912, 0.049020230770111084, -0.006736998446285725, 0.0061995782889425755, 0.014395950362086296, 0.04153071716427803,
    0.02632044441998005, 0.0020544424187391996, 0.002461011288687587, 0.030049094930291176, 0.028783919289708138, -0.025952793657779694, 0.03749461472034454, 0.032667744904756546,
    0.015605688095092773, -0.004475945141166449, 0.005983306095004082, 0.03297562152147293, 0.027189090847969055, -0.014661343768239021, -0.020764831453561783, -0.015678150579333305,
    -0.02095925807952881, 0.011306705884635448, 0.008554608561098576, -0.003588921157643199, -0.036605555564165115, -0.021727271378040314, -4.777973663294688e-05, 0.02129596285521984,
    0.003282102756202221, 0.015518958680331707, 0.030639370903372765, 0.03138888254761696, 0.0453965924680233, -0.06443018466234207, -0.02581222541630268, 0.02920440211892128,
    0.09293112903833389, 0.034162864089012146, 0.031460389494895935, -0.04254485294222832, -0.030024854466319084, 0.01322884764522314, -0.03038281761109829, -0.01762988232076168,
    0.08559679239988327, -0.03293425962328911, 0.01610179804265499, -0.002185491845011711, 0.12736858427524567, 0.009666508994996548, 0.00945950485765934, 0.008533918298780918,
    -0.016185306012630463, 0.007546576205641031, -0.052996501326560974, -0.0031976185273379087, 0.0008507401798851788, -0.004868181422352791, 0.0304301418364048, -0.019451197236776352,
    -0.04332801699638367, -0.004455921705812216, -0.05653724819421768, -0.014945253729820251, -0.028793830424547195, 0.01024127472192049, 0.011765541508793831, -0.052720531821250916,
    -0.0016114077297970653, 0.021291397511959076, -0.03616002947092056, 0.0015321511309593916, -0.03550049662590027, -0.012826348654925823, 0.00671957666054368, -0.0052429866045713425,
    -0.011127959005534649, -0.01898852176964283, 0.01948716677725315, 0.011072024703025818, -0.022995462641119957, 0.02103634551167488, 0.01535043679177761, 0.02722751535475254,
    0.0037116436287760735, -0.002734796144068241, -0.057662881910800934, -0.010671623982489109, -0.010954647324979305, 0.012139364145696163, 0.02182825095951557, -0.025648469105362892,
    0.010625969618558884, 0.03598027303814888, 0.02225925587117672, 0.014532840810716152, 0.005719763692468405, 0.017635362222790718, 0.0025130929425358772, 0.029829811304807663,
    0.007816736586391926, 0.01709126867353916, 0.04017314687371254, 0.04403672367334366, 0.01410379447042942, 0.0182170532643795, -0.012604705058038235, 0.01458621583878994,
    0.006409766618162394, -0.035016342997550964, -0.004160388372838497, 0.015565989539027214, 0.017637543380260468, -0.006857024505734444, 0.01544644869863987, -0.0031444693449884653,
    0.01934955269098282, 0.02304058149456978, -0.03756250813603401, 0.005357152782380581, 0.03559144213795662, -0.03132779896259308, 0.003582046367228031, 0.005763399880379438,
    -0.02096693590283394, 0.04845815896987915, -0.03464934229850769, -0.007379069924354553, 0.007131829392164946, -0.037008754909038544, -0.00540544418618083, 0.00914609432220459,
    -0.01750866509974003, -0.04794064909219742, -0.01340223103761673, -0.01112360879778862, -0.033618152141571045, 0.01975378580391407, -0.010599368251860142, 0.05227803811430931,
    0.02053053118288517, -0.012647119350731373, 0.016313334926962852, 0.0014578355476260185, 0.04460911825299263, -0.031746432185173035, 0.014397567138075829, 0.005459057632833719,
    0.004607518203556538, -0.003305370919406414, -0.021116720512509346, 0.005589812528342009, 0.0005400663358159363, 0.012399351224303246, -0.015163778327405453, 0.003853422589600086,
    -0.013334596529603004, -0.030423840507864952, 0.02894658036530018, 0.0006000186549499631, -0.005611799657344818, 0.016290578991174698, 0.0678492933511734, -0.020389841869473457,
    0.013135410845279694, 0.033031973987817764, 0.018934078514575958, 0.010273943655192852, 0.001262563280761242, -0.024494528770446777, 0.02503964863717556, -0.010794744826853275,
    -0.02493353933095932, -0.010456196032464504, 0.04024339094758034, 0.028399422764778137, 0.09760446846485138, -0.011216645129024982, -0.00914029125124216, 0.02123189903795719,
    -0.006078402511775494, -0.016539311036467552, -0.01732894591987133, -0.007328396663069725, 0.05991898849606514, 0.03138117119669914, -0.010725246742367744, -0.03861197829246521,
    0.02704738639295101, -0.0018483784515410662, 0.0006661659572273493, 0.006866113282740116, -0.012154333293437958, 0.03649958223104477, 0.02467195875942707, 0.031956691294908524,
    0.028372621163725853, 0.03518378362059593, 0.00844764057546854, -0.03762660175561905, 0.0015671133296564221, -0.0001299984724028036, -0.03525541350245476, 0.022869067266583443,
    0.005828522145748138, 0.016824955120682716, -0.06086358055472374, -0.00607075123116374, 0.02182886190712452, 0.007749577052891254, -0.002009260468184948, 0.018228327855467796,
    0.013055275194346905, 0.005872436799108982, -0.011215493083000183, -0.008021621964871883, -0.016250422224402428, -0.01902766339480877, 0.0371377095580101, 0.024877823889255524,
    -0.026727896183729172, 0.0028786538168787956, -0.011640675365924835, -0.03437379002571106, 0.007062198594212532, -0.0645759105682373, 0.0003512896364554763, -0.005113611463457346,
    0.02156137488782406, -0.017445573583245277, 0.03277040272951126, 0.014708731323480606, -0.022898059338331223, 0.01267787255346775, -0.03027983009815216, -0.03121039643883705,
    0.038987260311841965, 0.024522297084331512, -0.016326365992426872, 0.008511858060956001, -0.021305399015545845, -0.003321697236970067, -0.0039133368991315365, 0.018141238018870354,
    0.008010273799300194, -0.01167132705450058, -0.031773582100868225, -0.027822257950901985, -0.018046192824840546, 0.07152903079986572, 0.01359217707067728, 0.05361149087548256,
    0.03849277272820473, 0.02156652696430683, -0.010851358994841576, -0.03775912523269653, 0.03306231275200844, 0.03822064772248268, -0.010950866155326366, -0.045963890850543976,
    0.037385452538728714, 0.0116188395768404, 0.03817451372742653, -0.014424460008740425, 0.011010040529072285, 0.022922629490494728, 0.015928905457258224, 0.024570059031248093,
    0.001274592475965619, -0.01315429899841547, -0.021799251437187195, -0.011516395024955273, 0.021637165918946266, 0.005518066696822643, 0.004965954925864935, -0.026642313227057457,
    -0.043393973261117935, -0.009693372994661331, 0.00816105492413044, -0.03575728088617325, -0.027857866138219833, 0.016639122739434242, 0.03321988135576248, -0.012074718251824379,
    0.011549138464033604, 0.01881987787783146, -0.0006636290927417576, 0.03684252128005028, 0.011085882782936096, 0.017002124339342117, 0.04090823605656624, -0.02404337376356125,
    -0.02366439439356327, -0.04471822828054428, -0.05605868995189667, -0.033479660749435425, -0.007273335941135883, 0.003328331746160984, -0.020162994042038918, 0.003193780081346631,
    -0.01012143399566412, -0.04272245615720749, -0.021200401708483696, -0.0049666850827634335, 0.11459586769342422, -0.02797124907374382, 0.05586019158363342, -0.0003436111146584153,
    -0.009775359183549881, -0.0013049684930592775, -0.0171973779797554, 0.013855410739779472, 0.024810701608657837, -0.04481891542673111, 0.001363849500194192, 0.002419868251308799,
    0.022325394675135612, 0.017614202573895454, -0.015836471691727638, -0.04463139548897743, -0.04647718742489815, -0.00780286593362689, 0.0021927393972873688, 0.022984284907579422,
    -0.014432845637202263, -0.012299742549657822, -0.00025311869103461504, 0.023353632539510727, 0.008170678280293941, -0.015376373194158077, -0.009563191793859005, -0.0024600462056696415,
    -0.0006965175271034241, -0.01360602118074894, -0.0046608648262917995, -0.0006720131495967507, 0.017323240637779236, -0.03161146491765976, -0.0037553950678557158, -0.024535534903407097,
    0.03545733913779259, 0.034817859530448914, -0.04713386297225952, -0.02839846909046173, -0.014670322649180889, -0.002948235021904111, -0.01534848939627409, -0.008915232494473457,
    -0.035108670592308044, 0.03222184628248215, -0.023177774623036385, 0.058123454451560974, -0.04859745129942894, 0.047361552715301514, 0.03703474625945091, 0.035419195890426636,
    0.021557027474045753, -0.013761366717517376, 0.009912722744047642, 0.08143152296543121, -0.004217242822051048, 0.0031632878817617893, -0.024706540629267693, 0.04563606157898903,
    0.004727252759039402, -0.05617968738079071, -0.023064929991960526, 0.026226317510008812, -0.038281094282865524, -0.027262171730399132, 0.020945100113749504, -0.01844773069024086,
    -0.004727596882730722, -0.025458792224526405, -0.05680138245224953, 0.0017403548117727041, 0.012715177610516548, -0.05238102003931999, -0.001450349809601903, -0.033595457673072815,
    0.01981436088681221, -0.02228986658155918, 0.003790999297052622, 0.0034104324877262115, -0.002513051265850663, -0.006037256680428982, -0.04149196296930313, 0.03438301011919975,
    -0.030071163550019264, -0.00262941955588758, -0.02207891270518303, -0.002530081430450082, 0.005426036659628153, 0.0007819110178388655, -0.0073767164722085, -0.036828748881816864,
    0.07064533233642578, -0.01662612333893776, 0.014234691858291626, -0.011049318127334118, 0.03748295083642006, 0.006128339096903801, -0.0404551699757576, -0.0185993704944849,
    -0.00911235623061657, 0.013209753669798374, -0.020918024703860283, -0.08497803658246994, 0.04746902361512184, 0.011765394359827042, -0.040082499384880066, 0.0010002849157899618,
    0.018385590985417366, 6.111008406151086e-05, -0.032983891665935516, -0.022008061408996582, -0.02659429982304573, 0.027303563430905342, -0.06194612756371498, 0.006588211748749018,
    -0.045857787132263184, 0.022131258621811867, -0.030608750879764557, 0.001055973581969738, -0.07344406843185425, 0.006073330529034138, -0.0025034414138644934, -0.029290419071912766,
    0.050339456647634506, -0.008669947274029255, -0.01349952444434166, 0.014870921149849892, 0.09291630238294601, -0.003455538535490632, 0.011549756862223148, 0.01930578239262104,
    0.013678018003702164, -0.015478411689400673, 0.0007490947609767318, -0.048216093331575394, -0.023162677884101868, -0.01452371384948492, 0.009391686879098415, 0.0014533069916069508,
    -0.008847644552588463, 0.014187532477080822, -0.01188019011169672, 0.03799622505903244, -0.008416014723479748, 0.04043055325746536, -0.008971907198429108, 0.021620435640215874,
    0.013438527472317219, 0.035935211926698685, 0.016790635883808136, -0.014832747168838978, 0.01571073569357395, 0.010446848347783089, 0.0005893813795410097, 0.031594205647706985,
    0.04793236032128334, 0.03490229696035385, 0.014236965216696262, -0.001515229931101203, -0.02685757726430893, -0.009359602816402912, -0.01962255872786045, -0.005516997072845697,
    -0.028516635298728943, 0.009786542505025864, -0.005864845123142004, 0.020433945581316948, 0.030339475721120834, 0.04019339010119438, 0.04189269617199898, -0.034337520599365234,
    0.02731727808713913, 0.027563858777284622, -0.007416253909468651, -0.0037296717055141926, 0.05245276167988777, -0.018148090690374374, 0.07336152344942093, 0.0034118201583623886,
    -0.010745051316916943, -0.016019809991121292, 0.007471684366464615, 0.01842215657234192, 0.02362190932035446, -0.01941676437854767, 0.0363958366215229, -0.03302759677171707,
    -0.011952620930969715, -0.04010447487235069, 0.014870545826852322, -0.00011434430052759126, -0.009455597959458828, 0.055121179670095444, 0.10993749648332596, -0.004652939271181822,
    0.036448635160923004, 0.015704980120062828, 0.01226970087736845, -0.006048923823982477, -0.0018081377493217587, 0.04185832664370537, -0.009142013266682625, 0.035051796585321426,
    0.04196265712380409, -0.01361784152686596, 0.02152879163622856, 0.008073229342699051, 0.01907545141875744, 0.059116605669260025, 0.013235880061984062, 0.024066327139735222,
    -0.041596245020627975, 0.03025464527308941, -0.008635618723928928, 0.007406058255583048, 0.03380238264799118, -0.015943653881549835, 0.05477374047040939, 0.0064560347236692905,
    0.01783275604248047, -0.069646917283535, 0.045435093343257904, 0.02109309285879135, -0.018437080085277557, -0.03773783519864082, 0.07320370525121689, -0.060785554349422455,
    -0.08083547651767731, -0.00427436176687479, 0.043031543493270874, 0.03854558244347572, -0.03309641405940056, 0.04747713357210159, 0.008333897218108177, 0.03940065577626228,
    -0.014977128244936466, 0.014698452316224575, 0.007838993333280087, 0.014302854426205158, 0.025616135448217392, 0.05306091904640198, -0.008208196610212326, -0.0017659931909292936,
    0.016399690881371498, 0.02034793607890606, 0.016336679458618164, -0.02946086972951889, 0.034192848950624466, 0.00032217445550486445, 0.0027648278046399355, 0.002802872098982334,
    0.0003741771506611258, 0.056273166090250015, 0.024414775893092155, -0.006216112058609724, 0.10574796795845032, 0.03399374708533287, 0.008974334225058556, 0.039964813739061356,
    -0.03238833695650101, 0.0014192580711096525, 0.0062383199110627174, -0.0355173796415329, -0.03499868884682655, -0.017598573118448257, 0.004488175269216299, -0.008103260770440102,
    -0.009106909856200218, 0.0792941078543663, 0.04868655279278755, -0.03505837917327881, -0.04098697751760483, -0.02950727939605713, 0.009656785055994987, -0.014423291198909283,
    -0.04786450415849686, 0.0537525974214077, 0.01881449855864048, -0.021460803225636482, 0.04163002967834473, -0.010435273870825768, 0.017618294805288315, -0.038066212087869644,
    -0.0031893420964479446, 0.004066219087690115, -0.035104237496852875, -0.00014100589032750577, -0.01858898624777794, 0.016141870990395546, 0.012601202353835106, 0.030653825029730797,
    0.0223303884267807, 0.02944193035364151, -0.007823613472282887, 0.006879740860313177, -0.02972310781478882, -0.03244301304221153, -0.02117428183555603, -0.009429080411791801,
    0.004650407005101442, 0.019500065594911575, 0.001946252305060625, -0.01724405214190483, -0.008877168409526348, -0.0027551588136702776, 0.006995307747274637, 0.018664807081222534,
    0.03924167901277542, -0.00039349604048766196, 0.006896034814417362, -0.04476628825068474, 0.040512267500162125, -0.03974493592977524, 0.02816789411008358, -0.02277476340532303,
    0.004613103345036507, 0.03360044211149216, 0.035760264843702316, -0.01408524252474308, -0.016847115010023117, -0.023198965936899185, -0.002550607081502676, -0.02363155409693718,
    0.010449809022247791, -0.020641524344682693, -0.08674070984125137, 0.005679194815456867, 0.02191486954689026, -0.008386610075831413, 0.025876691564917564, 0.03986068814992905,
    -0.01691800355911255, -0.04880928248167038, -0.005166967399418354, -0.00891900435090065, 0.01048723328858614, -0.0002853568294085562, -0.046463437378406525, -0.008051763288676739,
    -0.023914027959108353, -0.0008264737552963197, -0.002298039849847555, 0.03134646266698837, -0.05771956592798233, -0.032285455614328384, -0.002795206615701318, 0.02109815925359726,
    -0.006952598690986633, -0.005281528923660517, 0.023745886981487274, -0.0191646721214056, -0.005341748241335154, 0.019954370334744453, 0.031652893871068954, -0.02477097325026989,
    0.017171720042824745, -0.010293920524418354, -0.05248631164431572, 0.027599530294537544, 0.03019179031252861, -0.03204143047332764, 0.012717020697891712, -0.008682392537593842,
    0.020457740873098373, -0.028677573427557945, 0.01981721632182598, 0.046551089733839035, 0.023580165579915047, 0.019989538937807083, 0.07753727585077286, -0.035121724009513855,
    0.03277406468987465, -0.00042979774298146367, -0.03915620967745781, -0.03513896465301514, -0.010931172408163548, 0.01746140606701374, 0.015511369332671165, -0.033164769411087036,
    0.010953093878924847, 0.0033901764545589685, -0.0038972373586148024, -0.016759652644395828, 0.10130978375673294, -0.036236777901649475, -0.004363753367215395, 0.03398141637444496,
    0.010082200169563293, -0.03137064352631569, 0.025073988363146782, -0.044625312089920044, 0.018133755773305893, -0.01565863937139511, -0.018843311816453934, -0.029662948101758957,
    0.013553383760154247, 0.012301373295485973, 0.0012071883538737893, 0.0233048927038908, 0.013659337535500526, 0.006260290276259184, 0.007586078718304634, 0.0320252999663353,
    -0.0196361243724823, -0.01505199633538723, -0.033564187586307526, 0.006480667740106583, 0.005619431845843792, 0.0022917462047189474, -0.031877100467681885, 0.05087871477007866,
    0.0038797156885266304, -0.02533980831503868, 0.007072174455970526, -0.021992120891809464, 0.026794128119945526, 0.023726094514131546, 0.045536383986473083, 0.03805750608444214,
    0.02620912343263626, -0.03422904014587402, 0.05589357390999794, -0.024254605174064636, -0.001591438427567482, 0.0027390087489038706, -0.029225490987300873, 0.024689679965376854,
    0.049973245710134506, -0.05371852591633797, -0.03133596479892731, 0.010752362199127674, -0.023595711216330528, -0.022881770506501198, -0.028891688212752342, 0.013894306495785713,
    0.01308868732303381, 0.006115315947681665, 0.02243603952229023, -0.03186555579304695, -0.0185677669942379, -0.0320199690759182, 0.010189017280936241, 0.0423695370554924,
    0.012804358266294003, 0.04167677462100983, -0.016906343400478363, 0.02320449985563755, -0.019264597445726395, -0.006396540906280279, -0.009489808231592178, -0.015769321471452713,
    -0.0075742448680102825, 0.017299558967351913, -0.08101166784763336, 0.008988154120743275, 0.02470647729933262, 0.053703729063272476, -0.010770201683044434, -0.017600927501916885,
    0.013516080565750599, 0.00025742067373357713, 0.003294202033430338, -0.010697467252612114, -0.03188787028193474, -0.007608058862388134, -0.034354958683252335, 0.032403912395238876,
    0.04920399188995361, 0.037682708352804184, 0.014069335535168648, 0.007287874352186918, 0.023708339780569077, 0.006119193509221077, 0.0029133211355656385, -0.02490054816007614,
    -0.005967038683593273, 0.006004514172673225, -0.006047618109732866, -0.011497056111693382, 0.005581654608249664, -0.011442690156400204, 0.027015525847673416, 0.04290477931499481,
    0.005179567262530327, -0.0011739624897018075, 0.05037148296833038, 0.013103578239679337, -0.04635605216026306, -0.05566053465008736, 0.0056011127308011055, 0.01302358042448759,
    0.01396249234676361, 0.03249738737940788, -0.0027402746491134167, 0.02636023610830307, -0.007726813200861216, 0.03592811897397041, -0.02015755884349346, 0.006488699000328779,
    -0.08114973455667496, -0.012089354917407036, 0.006322555709630251, 0.011471682228147984, 0.007785712368786335, -0.019903918728232384, 0.0017415916081517935, 0.0003640976792667061,
    -0.06403759866952896, -0.015203013084828854, -0.024524139240384102, -0.050898145884275436, 0.07664646953344345, 0.02858731895685196, -0.024449912831187248, 0.06556601822376251,
    0.0030811838805675507, -0.03682020679116249, -0.00893942080438137, -0.008013931103050709, -0.0015890572685748339, 0.025981562212109566, -0.007470902521163225, 0.017040099948644638,
    -0.05347425490617752, 0.05678696185350418, -0.024181170389056206, -0.03132418170571327, 0.02766941860318184, -0.0042481389828026295, -0.030283935368061066, -0.04411514848470688,
    0.024527594447135925, -0.00564155075699091, -0.009087947197258472, -0.015620171092450619, 0.02263304591178894, 0.01294304896146059, 0.03156719729304314, -0.011364622041583061,
    0.02514738216996193, -0.002749451668933034, -0.024368910118937492, 0.03198634460568428, 0.025774473324418068, -0.013215279206633568, 0.030964793637394905, -0.0353834331035614,
    -0.007841439917683601, 0.019243106245994568, 0.031561754643917084, -0.005764405708760023, -0.03600173071026802, -0.02341519296169281, 0.00239477283321321, -0.02218148484826088,
    -0.006807164289057255, 0.06612219661474228, 0.015872295945882797, -0.009330932050943375, 0.021164247766137123, 0.019118905067443848, -0.010218583047389984, 0.04058654606342316,
    -0.05077216029167175, -0.00845555029809475, 0.008740941062569618, 0.04407607764005661, -0.01362515240907669, 0.03493086248636246, -0.013524528592824936, -0.015009082853794098,
    -0.011187130585312843, -0.005875815637409687, 0.012891632504761219, -0.010957297869026661, -0.05576139688491821, 0.029494961723685265, -0.04003671556711197, 0.02408337965607643,
    0.025293512269854546, -0.008101161569356918, -0.015815474092960358, -0.02113826759159565, 0.01023621391505003, -0.053223323076963425, 0.0338585264980793, -0.013090000487864017,
    -0.022107765078544617, 0.01361154019832611, 0.012701442465186119, -0.0227898471057415, 0.02390674315392971, 0.025523902848362923, -0.00825860071927309, -0.017950886860489845,
    0.0052902838215231895, -0.011947737075388432, -0.03178057074546814, 0.03884005919098854, -0.04330958053469658, 0.01990078017115593, -0.049582019448280334, 0.007776318583637476,
    0.059405457228422165, 0.04359011724591255, 0.01936308853328228, 0.00827038660645485, 0.022131284698843956, -0.02384103834629059, -0.07348483800888062, 0.0016433120472356677,
    -0.030521459877490997, 0.016805728897452354, -0.002763281809166074, -0.054563675075769424, -0.018717031925916672, 0.003959250170737505, -0.028415387496352196, 0.03220750018954277,
    0.03142325207591057, -0.027702970430254936, 0.029272008687257767, 0.03596080094575882, -0.01165090873837471, 0.019027721136808395, 0.00021715568436775357, -0.013105418533086777,
    -0.013581810519099236, -0.07306801527738571, -0.005408119410276413, 0.05171670392155647, -0.014315623790025711, -0.008312864229083061, 0.0047579435631632805, 0.0088009899482131,
    -0.03923673555254936, 0.0199611596763134, 7.217391248559579e-05, -0.008406896144151688, 0.1221063882112503, 0.0012250179424881935, 0.006989835761487484, 0.03211287781596184,
    -0.010234861634671688, 0.0002965817984659225, -0.04254619777202606, -0.024034496396780014, -0.037957094609737396, 0.016759637743234634, -0.03626079857349396, 0.02562432736158371,
    -0.025326628237962723, 0.06075142323970795, 0.0016365961637347937, 0.013095645233988762, 0.0015839487314224243, 0.027429087087512016, 0.006575723644345999, 0.004532611463218927,
    -0.04000120982527733, -0.010597307235002518, -0.01506282202899456, 0.02645336091518402, -0.03879806399345398, 0.02384236454963684, 0.029909184202551842, 0.04051092639565468,
    0.03382440656423569, -0.02118208259344101, -0.026763249188661575, -0.036319054663181305, 0.023224152624607086, -0.016604917123913765, 0.015196496620774269, 0.02859390340745449,
    -0.006502453703433275, -0.022142991423606873, 0.040917400270700455, 0.019871355965733528, 0.006744115147739649, -0.03803759440779686, 0.008350986056029797, -0.0006542708142660558,
    0.040583740919828415, 0.06749812513589859, 0.02727782353758812, 0.03022594004869461, -0.008720552548766136, -0.07256177067756653, 0.01663854345679283, -0.03813517466187477,
    0.006396282929927111, -0.005680092144757509, 0.014326322823762894, 0.038673728704452515, 0.020383425056934357, 0.05779062584042549, 0.044879477471113205, -0.01800111122429371,
    0.008721422404050827, -0.009387527592480183, 0.010419566184282303, 0.02059885486960411, 0.021051768213510513, -0.027624936774373055, 0.03875428065657616, -0.017802171409130096,
    -0.0009845762979239225, -0.010919736698269844, -0.014619877561926842, 0.003138364991173148, -0.010576154105365276, 0.04224863648414612, 0.011894789524376392, 0.004824858158826828,
    -0.04556741937994957, 0.04648936539888382, -0.005763338878750801, 0.007861082442104816, 0.020887617021799088, -0.01323898509144783, -0.015399089083075523, 0.021566791459918022,
    0.019700028002262115, 0.00245407922193408, -0.01859966479241848, -0.021428097039461136, 0.010743862949311733, 0.004718612413853407, -0.005232605617493391, -0.019341031089425087,
    -0.06366179883480072, -0.02889922447502613, 0.027607174590229988, 0.017370406538248062, -0.01001102477312088, 0.05102774500846863, -0.024716127663850784, 0.0010518048657104373,
    -0.011297502554953098, 0.012678871862590313, -0.0017526875017210841, 0.05104663595557213, -0.019710715860128403, 0.0013800866436213255, -0.01069142296910286, 0.00034177242196165025,
    0.032053131610155106, 0.005903166718780994, 0.02964027225971222, -0.015677765011787415, 0.00202458375133574, 0.02662830613553524, -0.02840704284608364, 0.024746231734752655,
    0.005297422409057617, 0.017645226791501045, 0.026619868353009224, -0.005069108679890633, 0.007261489983648062, -0.00994556862860918, 0.0034181983210146427, 0.04585697874426842,
    -0.032810766249895096, -0.0165973212569952, 0.009684007614850998, 0.00020353742002043873, 0.04645324498414993, 0.0192637387663126, -0.06594353169202805, 0.0006953291012905538,
    0.003883835393935442, 0.036679573357105255, 0.017886245623230934, 0.000877452315762639, -0.025908678770065308, -0.0065984237007796764, 0.018767977133393288, 0.022590119391679764,
    0.03517128527164459, 0.0486271008849144, -0.014028945006430149, -0.007622245233505964, 0.062143005430698395, 0.05341973900794983, -0.015820054337382317, -0.01585574448108673,
    0.009204369969666004, -0.04060770571231842, 0.0090174600481987, 0.005916674621403217, 5.7079332691500895e-06, 0.015978816896677017, -0.017823785543441772, -0.019055692479014397,
    -0.011073729954659939, 0.05959443747997284, 0.043778881430625916, -0.032896943390369415, -0.014637663960456848, -0.05132767930626869, 0.026817964389920235, -0.0009369494509883225,
    0.01953481324017048, 0.05916425213217735, 0.021346308290958405, 0.05208616331219673, -0.004082037135958672, -0.0051326146349310875, 0.01928163506090641, 0.037782590836286545,
    0.033616919070482254, 0.06887736171483994, 0.02278473973274231, 0.060626208782196045, -0.0009284702246077359, 0.019689636304974556, -0.011435594409704208, -0.03378376364707947,
    -0.029197754338383675, 0.006508626509457827, 0.016076162457466125, 0.0405658558011055, -0.016460804268717766, -0.0053307777270674706, 0.030037613585591316, 0.01506998110562563,
    -0.015050383284687996, -0.029680833220481873, 0.012967867776751518, 0.012429448775947094, -0.024763045832514763, -0.01423609908670187, -0.032953035086393356, -0.029372191056609154,
    -0.00424568634480238, 0.01603568159043789, -0.017342600971460342, 0.013933255337178707, 0.026933273300528526, -0.010151450522243977, -0.003141604596748948, -0.010481313802301884,
    -0.03689952567219734, 0.040381718426942825, 0.02988995611667633, 0.014997501857578754, 0.005320118274539709, -0.00842966977506876, 0.04239160194993019, 0.0010758878197520971,
    -0.04248442128300667, -0.0619129054248333, -0.0007760766893625259, 0.028625650331377983, -0.008222542703151703, -0.012050346471369267, -0.05363032594323158, -0.011177091859281063,
    -0.044013626873493195, -0.06136934831738472, -0.01721903868019581, 0.014956316910684109, -0.04565632715821266, 0.011353322304785252, -0.043047163635492325, -0.021401094272732735,
    -0.036878567188978195, -0.0602899044752121, 0.010906096547842026, -0.01671983301639557, -0.0020524081774055958, -0.010768093168735504, -0.001749243470840156, 0.01864931546151638,
    -0.02707427181303501, -0.009195233695209026, 0.0533948577940464, -0.011342418380081654, 0.02956964075565338, -0.055905040353536606, -0.025496788322925568, 0.02632681280374527,
    -0.04340378940105438, 0.01245898101478815, -0.04381013661623001, 0.02486375905573368, -0.05463571846485138, -0.015599510632455349, -0.001997800776734948, 0.001899225520901382,
    0.004888830240815878, 0.023538175970315933, 0.02540356107056141, -0.01548716239631176, 0.03250936418771744, -0.00045183856855146587, -0.019230512902140617, -0.01141386479139328,
    -0.005229612812399864, 0.0012878774432465434, -0.014718694612383842, 0.025844069197773933, 0.020595036447048187, -0.014075401239097118, -0.013569370843470097, 0.014250262640416622,
    -0.03936135768890381, 0.003841566387563944, -0.037631429731845856, -0.010222436860203743, -0.0234723761677742, -0.017980048432946205, -0.04597350209951401, 0.007982873357832432,
    -0.023054378107190132, -0.02586750127375126, 0.016320722177624702, 0.014615495689213276, 0.014029530808329582, 0.004123575985431671, -0.011380406096577644, 0.030355529859662056,
    -0.022248027846217155, -0.008445856161415577, -0.02484946884214878, 0.033224109560251236, -0.09945887327194214, 0.03799811750650406, -0.027443980798125267, 0.002515990287065506,
    -0.021608226001262665, 0.029758304357528687, -0.027697185054421425, -0.004527666140347719, -0.006557876709848642, -0.03069123812019825, 0.009339304640889168, -0.0009163998765870929,
    0.05005185678601265, -0.005118976812809706, -0.02396257594227791, 0.03964182361960411, -0.030871188268065453, 0.018457552418112755, 0.0038951674941927195, 0.036386147141456604,
    -0.06904701143503189, -0.027722947299480438, -0.012421645224094391, 0.0062307980842888355, -0.05095371976494789, -0.03503132238984108, 0.0029752023983746767, 0.0028859430458396673,
    -0.016408512368798256, -0.010250587947666645, 0.0003755219513550401, -0.004531647078692913, -0.025494925677776337, 0.02996433526277542, 0.01212986372411251, 0.0006794627988711,
    -0.01852036453783512, -0.04767752066254616, -0.03980933502316475, 0.001466266461648047, 0.006248852703720331, -0.021430011838674545, 0.016887467354536057, 0.03149586543440819,
    0.03008432127535343, 0.036993157118558884, 0.011211485601961613, 0.014190005138516426, -0.012773905880749226, -0.01748051866889, -0.04211864992976189, 0.013015779666602612,
    0.02809167467057705, -0.009782197885215282, 0.06114383041858673, 0.007795782294124365, 0.01394681353121996, -0.0637749657034874, 0.03299040347337723, 0.012130338698625565,
    -0.019006220623850822, -0.014733525924384594, -0.026401374489068985, 0.07167073339223862, 0.007343829143792391, 0.021791057661175728, -0.08333749324083328, 0.014275949448347092,
    -0.046553835272789, -0.04992023482918739, -0.027912970632314682, -0.06447508931159973, -0.04487095773220062, 0.03860970214009285, 0.00021687081607524306, -0.0021073496900498867,
    0.030764147639274597, -0.04430067166686058, 0.01893857680261135, -0.03258078172802925, -0.020090484991669655, -0.010514206252992153, -0.04116164892911911, 0.026533188298344612,
    -0.045568689703941345, -0.0023399272467941046, 0.031298208981752396, -0.028659986332058907, 0.05108639970421791, 7.082345837261528e-05, -0.03319475054740906, 0.010572261177003384,
    -0.03694295138120651, -0.00010664937872206792, 0.0016817533178254962, -0.030489599332213402, 0.05042533949017525, 0.007775443606078625, -0.06006753817200661, -0.040183961391448975,
    -0.0010456206509843469, -0.01895487681031227, -0.0025560823269188404, -0.03866041451692581, 0.0036175025161355734, -0.010961507447063923, 0.021383211016654968, 0.018141591921448708,
    -0.027799513190984726, 0.029660820960998535, -0.022881677374243736, -0.0007649499457329512, 0.01102241687476635, 0.025337327271699905, 0.0030669707339257, -0.011890562251210213,
    0.03805219382047653, -0.02443903312087059, -0.02072942443192005, 2.5860465029836632e-05, 0.021576404571533203, 0.025028608739376068, 0.022861916571855545, -0.0294185858219862,
    -0.002813326893374324, -0.005952248815447092, 0.006489538121968508, 0.037687771022319794, 0.011158510111272335, -0.031216980889439583, 0.026749499142169952, -0.021560214459896088,
    0.02144891582429409, -0.000979405827820301, 0.027753690257668495, -0.004143998026847839, -0.03360966593027115, 0.009708692319691181, 0.027096377685666084, 0.015679113566875458,
    0.029325272887945175, 0.04414135217666626, -0.044197551906108856, -0.06495744735002518, 0.022906897589564323, 0.004776392597705126, -0.029716411605477333, -0.015234848484396935,
    -0.04883549362421036, 0.01819668710231781, 0.0031111249700188637, -0.021538952365517616, -0.018646663054823875, -0.05205928906798363, 0.007711685262620449, -0.04001740738749504,
    0.017603401094675064, 0.026406701654195786, -0.02832636423408985, 0.018312104046344757, -0.023924361914396286, -0.005811604205518961, -0.0024418593384325504, 0.01736168935894966,
    0.008218280039727688, 0.025622637942433357, -0.039655063301324844, 0.015733515843749046, 0.012304146774113178, 0.03981694206595421, -0.013074129819869995, 0.006043639965355396,
    -0.006772033404558897, 0.004290413111448288, 0.032008808106184006, -0.02003938890993595, -0.0010032856371253729, -0.028103230521082878, 0.00815295148640871, -0.0219118595123291,
    -0.024799076840281487, -0.018060386180877686, -0.0018175215227529407, -0.03232815861701965, -0.0025327391922473907, -0.01158057153224945, -0.03238309174776077, -0.005561810452491045,
    0.051086656749248505, -0.022077392786741257, 0.018616793677210808, 0.023757625371217728, -0.032516684383153915, 0.010395549237728119, -0.016331618651747704, -0.018991079181432724,
    -0.0570572093129158, -0.0537993498146534, 0.014443974010646343, -0.0006060526939108968, -0.039577778428792953, -0.04042883962392807, -0.011644024401903152, 0.022169092670083046,
    0.0030457109678536654, 0.03954729065299034, 0.022439364343881607, -0.004238942172378302, 0.004946253262460232, -0.019041016697883606, -0.0013841524487361312, 0.003951048944145441,
    -0.03095622919499874, -4.8170786612899974e-05, 0.016911499202251434, 0.02381562627851963, 0.0421200729906559, 0.003336007008329034, -0.004886446055024862, 0.019817885011434555,
    0.019029434770345688, -0.00811079517006874, -0.017960643395781517, -0.03205974027514458, 0.06692666560411453, 0.00262713385745883, 0.029133465141057968, 0.005431861151009798,
    0.030863044783473015, -0.05984809994697571, 0.005195508245378733, 0.04744105041027069, 0.02209295704960823, 0.0006465703481808305, -0.031519580632448196, -0.039088279008865356,
    -0.010333143174648285, 0.03950341045856476, -0.016606908291578293, -0.003655392676591873, -0.02221670374274254, 0.0021143448539078236, 0.08453323692083359, -0.015138177201151848,
    0.007122301030904055, -0.04809366166591644, 0.006547705270349979, -0.008526709862053394, 0.04336940869688988, 0.015312467701733112, 0.005865755490958691, 0.004834156017750502,
    0.01885657012462616, 0.002079386729747057, -0.045284971594810486, -0.07446855306625366, 0.08670791983604431, 0.0051205833442509174, -0.02250397577881813, -0.027259811758995056,
    0.03282959759235382, -0.017377503216266632, -0.04273553937673569, -0.032935936003923416, -0.0633917823433876, 0.025252019986510277, 0.023965632542967796, -0.029551159590482712,
    0.039981354027986526, -0.00718287006020546, 0.017255976796150208, 0.025620650500059128, -0.029144948348402977, -0.0060007511638104916, 0.05940407142043114, -0.02729308232665062,
    -0.035673838108778, 0.0010344880865886807, 0.012535318732261658, -0.022382047027349472, -0.05246992036700249, 0.03778601437807083, -0.02765888161957264, -0.0010737255215644836,
    0.015675237402319908, -0.020508985966444016, 0.012285510078072548, -0.0036966493353247643, 0.008713268674910069, 0.01605161651968956, 0.0018062039744108915, -0.025081278756260872,
    0.0344216413795948, -0.02049248106777668, 0.005972780287265778, -0.005897084716707468, 0.011452131904661655, -0.012233564630150795, -0.010579186491668224, -0.031543999910354614,
    -0.0029014938045293093, -0.013964162208139896, -0.012130838818848133, 0.019382890313863754, 0.0019003301858901978, -0.03737524896860123, -0.066233329474926, -0.01757783442735672,
    0.00946537684649229, 0.002496918197721243, 0.025215845555067062, 0.0025381045415997505, -0.015377907082438469, -0.03608053922653198, -0.00010924517846433446, -0.003334301756694913,
    -0.032973337918519974, 0.022380337119102478, -0.045700278133153915, 0.023608943447470665, -0.0138552812859416, 0.011065867729485035, -0.05665050074458122, 0.004530010279268026,
    -0.03362308442592621, 0.0008854354964569211, -0.003916523419320583, 0.0027369798626750708, -0.0007754669059067965, -0.028044939041137695, -0.008168322965502739, -0.01755719818174839,
    0.032280441373586655, -0.030911885201931, -0.004162317607551813, 0.05184442177414894, 0.006078174803406, -0.03150688856840134, -0.011317756958305836, -0.004560247529298067,
    -0.06239887699484825, -0.00897931307554245, -0.0018959313165396452, -0.0651387870311737, -0.028994763270020485, 0.018554318696260452, 0.008380786515772343, 0.022812141105532646,
    0.0182835403829813, 0.014573740772902966, 0.0010550286388024688, 0.010625320486724377, 0.013343284837901592, -0.03542740270495415, -0.004030588082969189, -0.007509741932153702,
    0.001949611702002585, -0.02423899620771408, 0.0025602844543755054, 0.0017674049595370889, 0.01033610850572586, -0.009550314396619797, -0.013747093267738819, -0.006362957879900932,
    -0.006114667747169733, 0.03896660357713699, -0.01928658038377762, 0.003874717280268669, -0.02231176756322384, 0.009624536149203777, 0.022759150713682175, -0.004435026086866856,
    -0.01410482544451952, -0.03687898442149162, -0.04695073142647743, -0.008970928378403187, 0.05075451731681824, 0.006084660068154335, -0.010625463910400867, 0.008652767166495323,
    -0.031149663031101227, -0.024980701506137848, 0.007423277944326401, 0.006709964945912361, 0.035671036690473557, 0.009964601136744022, -0.0240399781614542, -0.0061014373786747456,
    0.04367692768573761, -0.06624442338943481, -0.0002580263535492122, 0.006585647352039814, 0.010045013390481472, 0.03854053467512131, -0.01655922457575798, 0.02848179079592228,
    -0.004381686449050903, -0.03177749365568161, -0.036609403789043427, -0.011044755578041077, -0.013226031325757504, 0.0040423753671348095, 0.1157226487994194, -0.014186457730829716,
    -0.026587635278701782, 0.020408183336257935, -0.03014337457716465, 0.03898918628692627, -0.07601950317621231, 0.04003889858722687, -0.03920565918087959, -0.008270038291811943,
    0.040769338607788086, -0.008874229155480862, -0.023040229454636574, 0.0690600648522377, 0.019925611093640327, -0.03461507707834244, -0.03356940671801567, 0.0234747976064682,
    -0.01338308583945036, 0.038494788110256195, 0.02129419334232807, -0.0076818885281682014, -0.06942341476678848, 0.07060378044843674, -0.012391908094286919, 0.011548573151230812,
    -0.005621657706797123, 0.004950247704982758, 0.0164214875549078, 0.007001345045864582, -0.023454776033759117, -0.0014666600618511438, -0.02382555976510048, -0.0053885444067418575,
    0.03340659290552139, 0.03569558635354042, -0.017448779195547104, 0.014045406132936478, -0.015581329353153706, -4.464219091460109e-05, 0.031120942905545235, -0.027316313236951828,
    -0.010657754726707935, -0.005022372119128704, 0.028089934960007668, -0.004020958673208952, -0.04121711477637291, 0.012951342388987541, 0.01164233312010765, 0.03116728365421295,
    -0.10231871157884598, -0.029070790857076645, 0.011608719825744629, 0.0073884017765522, -0.02511453814804554, 0.03760170564055443, 0.040397368371486664, -0.03240908682346344,
    -0.007770388852804899, 0.03531721234321594, -0.0011599279241636395, -0.00037141135544516146, -0.0286761075258255, 0.01678312197327614, 0.05003834143280983, 0.022982828319072723,
    0.0056899613700807095, 0.01045732107013464, 0.0033640891779214144, 0.006885889917612076, 0.025041496381163597, -0.025609226897358894, 0.04531979188323021, 0.01729491911828518,
    0.020342035219073296, 0.034629203379154205, 0.00838090106844902, 0.043936047703027725, 0.09188760817050934, 0.04370487853884697, -0.027661440894007683, -0.023122360929846764,
    -0.011038361117243767, -0.013101578690111637, -0.004734778311103582, -0.0031039181631058455, 0.018785972148180008, -0.005360974930226803, -0.029318917542696, -0.00804696325212717,
    -0.07915178686380386, 0.03815493732690811, -0.02307802438735962, -0.005662511568516493, -0.01975717954337597, 0.05192046985030174, 0.021640822291374207, 0.030872490257024765,
    0.017680473625659943, 0.002700872253626585, 0.030238159000873566, 0.03629383444786072, 0.004130400251597166, -0.004543099086731672, -0.04731100797653198, -0.007448646705597639,
    0.012699902057647705, -0.004151778761297464, 0.006103310734033585, 0.04634435474872589, -0.04128926992416382, -0.055854979902505875, 0.011222009547054768, 0.0029593780636787415,
    -0.01585244946181774, -0.00965810939669609, -0.008333596400916576, -0.012227958999574184, -0.028435606509447098, -0.008066017180681229, 0.019693966954946518, -0.014594287611544132,
    0.005569711327552795, 0.013588913716375828, -0.013919007033109665, 0.004766147118061781, 0.07979733496904373, -0.0023008768912404776, 0.03858785703778267, -0.06398779153823853,
    -0.06067840754985809, -0.014931491576135159, 0.018320389091968536, 0.08038321137428284, -0.03833596780896187, 0.011557159945368767, -0.04948442429304123, -0.05595119297504425,
    0.016637714579701424, 0.03957740217447281, -0.002302630338817835, -0.06776906549930573, 0.01830350235104561, -0.018045492470264435, 0.007884247228503227, 0.020957427099347115,
    -0.04408474266529083, -0.02051672153174877, 0.02346373163163662, -0.0009745234856382012, -0.0009960163151845336, -0.006239353679120541, 0.013902571983635426, 0.018633846193552017,
    -0.004866775590926409, -0.0019414197886362672, 0.0330948680639267, -0.010335161350667477, 0.004676374141126871, -0.013181088492274284, 0.04252849891781807, -0.0008892517653293908,
    0.018500080332159996, -0.009488691575825214, -0.008064289577305317, -0.003463401459157467, 0.01768033392727375, -0.025344952940940857, 0.0008416822529397905, -0.009908844716846943,
    0.032799411565065384, -0.009529600851237774, 0.032518420368433, 0.008758096024394035, -0.000908905582036823, 0.00970795564353466, -0.0455164834856987, 0.06230811029672623,
    -0.03262404724955559, 0.03820737823843956, 0.009228521957993507, -0.019405284896492958, -0.07077263295650482, 0.03315442427992821, 0.011605487205088139, 0.0012728545116260648,
    -0.024265792220830917, -0.033020272850990295, 0.02179376222193241, 0.04845457524061203, -0.015418240800499916, 0.06063482165336609, 0.03478125110268593, 0.0007048573461361229,
    -0.025066399946808815, 0.012853982858359814, 0.0042416430078446865, -0.028106877580285072, 0.017996568232774734, -0.03470384702086449, -0.008485609665513039, -0.011541380546987057,
    -0.008192205801606178, 0.011106273159384727, -0.03366762772202492, 0.02688387967646122, 0.028234921395778656, -0.025308378040790558, 0.00017293947166763246, -0.00788414478302002,
    0.025958316400647163, -0.00430655712261796, 0.009119837544858456, 0.015485499985516071, 0.011614369228482246, -0.02909223549067974, 0.007874875329434872, 0.03127032518386841,
    -0.04160677641630173, 0.015295344404876232, -0.03755291551351547, 0.03191773220896721, -0.044312622398138046, 0.0479431115090847, -0.020044192671775818, 0.02831351011991501,
    0.031089896336197853, 0.02298619970679283, 0.003792122472077608, -0.03527179732918739, 0.012150672264397144, 0.03478463366627693, 0.00048107237671501935, -0.02846081182360649,
    -0.05396045744419098, 0.011821476742625237, 0.011625767685472965, -0.015785878524184227, 0.01044276263564825, -0.02519870176911354, 0.019550064578652382, 0.0037906586658209562,
    -0.025808772072196007, 0.010768298991024494, 0.022977357730269432, -0.0010595200583338737, -0.020920787006616592, -0.015570159070193768, -0.013678569346666336, 0.0329204723238945,
    0.016201598569750786, 0.03208860754966736, 0.007530042435973883, -0.010578369721770287, -0.034493036568164825, -0.024395914748311043, -0.007124133408069611, -0.02686811238527298,
    -0.030705712735652924, 0.01715654321014881, -0.03724091500043869, 0.0002163384051527828, 0.004309241194278002, 0.010418293066322803, 0.008290797472000122, 0.0054772766306996346,
    0.027199922129511833, 0.01618240214884281, -0.002615065546706319, 0.027615394443273544, -0.02939368039369583, -0.02587771601974964, 0.047237250953912735, 0.007820839062333107,
    0.014463947154581547, 0.01147295068949461, -0.0010459041222929955, -0.00715623376891017, -0.0293605737388134, 0.0005932141211815178, -0.02063816785812378, -0.032960135489702225,
    0.027115529403090477, 0.04645425081253052, -0.006705040577799082, -0.0012955531710758805, 0.023358069360256195, 0.030748048797249794, -0.004439227283000946, 0.024961775168776512,
    -0.027250617742538452, -0.0027348254807293415, 0.02430889941751957, -0.008970498107373714, 0.02422294020652771, -0.03337413817644119, -0.01491576712578535, 0.014911550097167492,
    -0.04199985787272453, 0.029738012701272964, -0.004942380823194981, 0.019647160544991493, 0.02443625032901764, 0.003178588580340147, 0.010221149772405624, -0.04959626868367195,
    -0.00337293092161417, -0.02556638792157173, -0.02733786217868328, -0.0443265475332737, 0.007382460869848728, -0.006154306698590517, -0.02402161806821823, -0.017406318336725235,
    0.012753484770655632, 0.04755225032567978, 0.027660641819238663, -0.03338884562253952, 0.023233314976096153, 0.00043774943333119154, 0.014682098291814327, 0.0167376846075058,
    -0.02040719799697399, 0.009653396904468536, 0.01164232287555933, 0.011039728298783302, 0.02828882448375225, -0.012645223177969456, 0.011676016263663769, -0.03241143748164177,
    0.0325586162507534, -0.04613198712468147, 0.00016526930266991258, -0.010089562274515629, 0.07019764184951782, 0.008556521497666836, -0.0209936685860157, 0.05242238566279411,
    -0.01684778369963169, -0.07845930010080338, -0.008988053537905216, -0.02172648161649704, 0.06154465302824974, -0.0069190263748168945, 0.003341994248330593, 0.012381056323647499,
    -0.03177068755030632, -0.025235837325453758, -0.021142512559890747, -0.005694415420293808, -0.022541146725416183, 0.0039144535548985004, -0.012701178900897503, 0.019280530512332916,
    0.004119393415749073, 0.038672756403684616, 0.02789486199617386, -0.01973714865744114, -0.018366491422057152, -0.015314817428588867, -0.006424115039408207, 0.014944862574338913,
    0.0006601508939638734, 0.017146674916148186, 0.03247503191232681, 0.03962797671556473, -0.004274528473615646, -0.023883210495114326, 0.05311049148440361, 0.04699631407856941,
    0.007291555404663086, 0.01741909049451351, -0.04352240264415741, -0.00898687168955803, 0.0007664421573281288, 0.03654856979846954, 0.019665461033582687, -0.019242363050580025,
    -0.0075381165370345116, -0.011037345975637436, 0.018389225006103516, 0.02972503937780857, 0.046500902622938156, 0.006277585867792368, -0.032167430967092514, -0.009379194118082523,
    -0.024283021688461304, -0.04124845936894417, 0.04168713837862015, -0.011701012961566448, -0.00023811055871192366, -0.012170090340077877, -0.04250030964612961, -0.06197280436754227,
    1.2838847396778874e-05, -0.03405694290995598, 0.028871770948171616, 0.002781177405267954, 0.027482012286782265, 0.017231570556759834, 0.018963642418384552, -0.0009042765595950186,
    0.007929355837404728, -0.02751384861767292, 0.0014781681820750237, -0.01600525714457035, 0.003587656421586871, -0.02433590404689312, 0.018113523721694946, -0.019178401678800583,
    0.03714504837989807, 0.032994650304317474, 0.011378681287169456, -0.0015387850580736995, 0.01978621445596218, 0.03648260980844498, -0.0046621509827673435, -0.021594630554318428,
    -0.011882024817168713, -0.0421447679400444, -0.0351996049284935, 0.022261429578065872, -0.006294981576502323, -0.005535867530852556, 0.006436564959585667, 0.01632220298051834,
    0.037755273282527924, 0.051538996398448944, -0.0020420143846422434, -0.011946108192205429, -0.028628753498196602, -0.026504846289753914, 0.010951240547001362, -0.010397900827229023,
    -0.06247072294354439, 0.02020031400024891, 0.018741732463240623, -0.005733242258429527, 0.005769222043454647, 0.009487902745604515, 0.03219601511955261, 0.027514301240444183,
    -0.03009781427681446, 0.0037021790631115437, 0.000776515924371779, -0.009206942282617092, 0.00204650335945189, -0.0030827743466943502, 0.006280452478677034, -0.004686279688030481,
    0.062945656478405, -0.020386721938848495, -0.05088195204734802, 0.03482085466384888, -0.04533495381474495, -0.03619018569588661, -0.04093606024980545, 0.01758001744747162,
    -0.024494614452123642, 0.04736781865358353, 0.0024864859879016876, 0.025401771068572998, 0.02120998501777649, -0.017095431685447693, -0.022746574133634567, -0.009625790640711784,
    -0.002766059013083577, 0.012358616106212139, 0.0002854551712516695, 0.02154187671840191, 0.02806861698627472, 0.013384081423282623, -0.03312419727444649, -0.0023490258026868105,
    -0.004733359906822443, -0.023458393290638924, 0.01082785427570343, -0.02390013076364994, -0.021764392033219337, 0.04788358509540558, 0.004034452140331268, 0.02250969223678112,
    0.010125216096639633, -0.05102401226758957, -0.011460735462605953, 8.833538595354185e-05, 0.04641342908143997, 0.02203170582652092, -0.017851294949650764, -0.029829230159521103,
    0.005874321796000004, 0.005324990022927523, -0.012167579494416714, -0.05810682103037834, -0.006207688711583614, -0.07864075154066086, -0.04740189388394356, -0.011376479640603065,
    -0.012844830751419067, -0.04190085083246231, 0.032408203929662704, -0.023842133581638336, -0.01396972592920065, -0.058674998581409454, -0.005276243202388287, 0.0013529491843655705,
    0.05312943086028099, 0.06879258900880814, -0.012009551748633385, -0.03210803493857384, -0.024182427674531937, 0.0023156574461609125, -0.030426185578107834, -0.028364554047584534,
    0.025944245979189873, 0.030299605801701546, -0.0021515819244086742, -0.04349076375365257, -0.046130791306495667, -0.07814402878284454, -0.04643293842673302, 0.031121980398893356,
    0.008319707587361336, 0.03183886781334877, 0.08058750629425049, 0.03967507556080818, -0.0028740232810378075, -0.024249108508229256, -0.009290428832173347, 0.018496334552764893,
    0.016402898356318474, 0.03794850781559944, -0.04001452028751373, -0.02100694179534912, -0.03881675377488136, 0.00917772389948368, -0.010604006238281727, -0.009208664298057556,
    0.0010950317373499274, -0.0464899055659771, -0.006674083881080151, -0.015389136970043182, 0.00035944924456998706, 0.05923886224627495, 0.02319232001900673, 0.004205519799143076,
    -0.03243642672896385, -0.006424012593924999, 0.056444648653268814, -0.012229880318045616, -0.0016425690846517682, -0.02551988512277603, 0.01280505582690239, -0.04254841059446335,
    -0.018107065930962563, -0.042544085532426834, 0.004789512604475021, 0.035293638706207275, -0.019336126744747162, 0.004982310347259045, 0.06879717111587524, 0.0010167190339416265,
    -0.0003016815462615341, -0.05487754940986633, -0.023462705314159393, 0.010394884273409843, 0.008619417436420918, 0.046261437237262726, -0.014357931911945343, 0.017537349835038185,
    -0.030490625649690628, 0.02404717355966568, -0.004031924065202475, -0.019520848989486694, 0.02154024876654148, -0.060462914407253265, -0.0356675460934639, 0.01515944954007864,
    -0.005524199455976486, -0.01773158647119999, -0.011975853703916073, 0.008511246182024479, 0.007272160146385431, 0.0444599948823452, 0.04545833542943001, 0.004211520776152611,
    -0.0030564365442842245, 0.03605908900499344, -0.020154092460870743, 0.005374246742576361, 0.051255002617836, 0.017570417374372482, 0.008660630322992802, -0.058670591562986374,
    -0.00281021511182189, -0.006930331699550152, 0.008327853865921497, -0.016372356563806534, -0.003557855961844325, -0.0007659390685148537, 0.030262038111686707, 0.021067384630441666,
    0.013429403305053711, -0.0231538824737072, 0.00796001311391592, 0.01905934140086174, -0.021052733063697815, 0.021245921030640602, -0.008979756385087967, -0.028350377455353737,
    -0.0034368729684501886, 0.02924240566790104, -0.028356332331895828, -0.00347687560133636, -0.02652585320174694, -0.027726879343390465, -0.021237993612885475, 0.025958659127354622,
    -0.006937751546502113, -0.0030797359067946672, 0.006522934418171644, 0.029904458671808243, -0.015175885520875454, 0.020331935957074165, -0.02573525346815586, -0.01194344088435173,
    0.013535037636756897, -0.007978951558470726, -0.007437948137521744, -0.004093284718692303, -0.021813100203871727, 0.026208331808447838, 0.05531368404626846, 0.03881256282329559,
    0.02011294849216938, -0.005771396216005087, 0.039516787976026535, -0.017341582104563713, 0.03328897804021835, -0.011549369432032108, 0.0853540375828743, 0.006174973677843809,
    -0.06141037866473198, -0.019570518285036087, 0.02437925711274147, -0.002684621140360832, -0.01984480954706669, -0.0038351514376699924, -0.036602187901735306, -0.03694005310535431,
    -0.0018103085458278656, 0.019420474767684937, -0.011199588887393475, -0.0250783022493124, -0.013540257699787617, 0.019317759200930595, 0.025787249207496643, -0.022448798641562462,
    0.07101277261972427, -0.05176951736211777, 0.00023295784194488078, -0.014247908256947994, 0.006192510481923819, -0.010262942872941494, 0.030466554686427116, 0.010120400227606297,
    0.004027658142149448, 0.0011096958769485354, 0.005135402083396912, 0.0007131453021429479, 0.02274545468389988, -0.04377986490726471, -0.01674070954322815, 0.022878099232912064,
    -0.02455538511276245, 0.03870056942105293, 0.007521572057157755, 0.03582336753606796, 0.004387967754155397, -0.0006944718770682812, 0.016507191583514214, -0.006026572082191706,
    0.01304971519857645, -0.024055158719420433, 0.004312651231884956, 0.01822024956345558, -0.0024616532027721405, -0.008350281976163387, 0.023318622261285782, -0.005291461944580078,
    -0.01540994830429554, -0.07440038025379181, -0.0002155886759283021, -0.020188845694065094, -0.03856205940246582, 0.015620280988514423, -0.002904387190937996, 0.004286379553377628,
    -0.015061774291098118, -0.020063506439328194, -0.0038089898880571127, -0.013548587448894978, 0.014852994121611118, -0.07595235109329224, 0.0025586350820958614, -0.005251412745565176,
    0.0251981932669878, 0.020971054211258888, 0.043548453599214554, 0.0027327497955411673, 0.003043356817215681, -0.019352104514837265, 0.02995176427066326, 0.0008176480769179761,
    0.040770627558231354, -0.008047026582062244, 0.035221632570028305, -0.013984229415655136, 0.01833568885922432, -0.01841767132282257, 0.01696738600730896, -0.006907997652888298,
    0.02843690663576126, 0.023243438452482224, 0.02625107392668724, 0.011862458661198616, -0.012544668279588223, -0.00751618854701519, -0.01757686585187912, 0.01711622066795826,
    0.006845987401902676, -0.03686577081680298, -0.0037468248046934605, -0.01933397352695465, -0.02935217134654522, 0.0082833431661129, -0.01079273410141468, -0.002431182423606515,
    -0.0016313958913087845, 0.026050250977277756, 0.020312998443841934, -0.002043120563030243, -0.03901504725217819, 0.006204914301633835, 0.04084615036845207, 0.016815470531582832,
    0.011088848114013672, 0.01946147345006466, -0.007560946512967348, 0.01247461698949337, -0.015869932249188423, -0.037748806178569794, -0.009009994566440582, -0.004721589386463165,
    -0.027988621965050697, -0.009191948920488358, 0.0085414694622159, 0.008721867576241493, -0.042630404233932495, 0.030094940215349197, -0.01091771014034748, -0.02236620895564556,
    0.03281024843454361, 0.05203293636441231, 0.0018270116997882724, 0.017357762902975082, 0.022229494526982307, -0.003739230800420046, -0.02653760276734829, 0.0008000082452781498,
    -0.014601246453821659, -0.014413020573556423, 0.013463437557220459, 0.04278343915939331, -0.0273874644190073, 0.04022625833749771, -0.007148342207074165, -0.058802101761102676,
    0.01189777348190546, -0.03702324628829956, 0.06363429129123688, -0.04641195759177208, -0.0030281732324510813, -0.02327992394566536, 0.0172561164945364, -0.004074402153491974,
    -0.009295436553657055, 0.014697734266519547, 0.01292889378964901, -0.018679294735193253, -0.05563155189156532, 0.06161044165492058, 0.013766796328127384, 0.01485924981534481,
    -0.018084781244397163, 0.020417174324393272, 0.021089741960167885, 0.02793034352362156, 0.007090127095580101, 0.020223446190357208, 0.00880514457821846, 0.002792470855638385,
    -0.02950526773929596, -0.005760616157203913, 0.0031593232415616512, 0.024232476949691772, -0.005039519164711237, 0.015126913785934448, 0.021813921630382538, -0.0409531444311142,
    0.06597234308719635, -0.01901031658053398, 0.03008907288312912, 0.02865637093782425, -0.024754831567406654, -0.013700347393751144, 0.013600085861980915, -0.010458369739353657,
    0.03003213182091713, -0.030606133863329887, -0.0005827033310197294, 0.03662766143679619, 0.0650365948677063, 0.006898222491145134, -0.01575819030404091, 0.004147442057728767,
    -0.03168243542313576, 0.004736439324915409, 0.012049184180796146, 0.03905189409852028, 0.017668036743998528, 0.0745314359664917, 0.028616255149245262, 0.003211099887266755,
    0.0023019297514110804, -0.0035565549042075872, -0.005831197369843721, 0.0051401215605437756, 0.020061420276761055, -0.010181347839534283, -0.013955201022326946, 0.0010176930809393525,
    0.0015143266646191478, 0.0067948936484754086, -0.0006028215284459293, -0.007924238219857216, -0.01106275338679552, 0.017904235050082207, -0.014678758569061756, -0.008368547074496746,
    0.0017376001924276352, -0.00715476693585515, -0.009094164706766605, 0.008836000226438046, -0.009612568654119968, 0.008702557533979416, 0.0038547993171960115, 0.005645756609737873,
    -0.002771587111055851, 0.011077391915023327, 0.0002566082985140383, -0.005431588739156723, -0.021680153906345367, -0.02198396436870098, -0.003938969690352678, -0.03615767881274223,
    0.006161366123706102, -0.006768709979951382, 0.011675232090055943, -0.0009943600744009018, 0.011460602283477783, -0.0059853969141840935, -0.015679754316806793, -0.002363052684813738,
    -0.0019806427881121635, 0.002536090789362788, -0.00661013089120388, 0.0021363042760640383, 0.001209115143865347, 0.004405769519507885, -0.008038869127631187, 0.007061402779072523,
    -0.008199133910238743, -0.0006985410582274199, -0.033359356224536896, -0.004755539819598198, 0.006269522476941347, 0.029317308217287064, -0.010198105126619339, 0.008362929336726665,
    0.004004323855042458, -0.004468442406505346, -0.0050315577536821365, -0.004039252642542124, -0.0029991164337843657, 0.020949114114046097, -0.018610311672091484, -0.00523003563284874,
    -0.005950992926955223, 0.0020201357547193766, -0.0011422780808061361, -2.652593502716627e-05, -0.00792997982352972, -0.001371566322632134, -0.02330455556511879, -0.002573425183072686,
    -0.006423383951187134, -0.008234762586653233, 0.01796327717602253, 0.032260261476039886, -0.0056946794502437115, -0.004946270491927862, 0.0069703515619039536, -0.006534004118293524,
    -0.015625717118382454, 0.003295327303931117, 0.018050191923975945, 0.00782362837344408, 0.004306005779653788, -0.011536921374499798, 0.008132747374475002, 0.005078310612589121,
    -0.008618087507784367, 0.011813328601419926, 0.00047112483298406005, 0.004425086546689272, 0.005095210857689381, 0.012923494912683964, -0.00020908725855406374, 0.005633203778415918,
    0.006450795102864504, 0.002514950931072235, -0.006167096551507711, -0.0036713802255690098, -6.525671324197901e-06, -0.03630923479795456, 0.006545374169945717, -0.0069899181835353374,
    0.02120135724544525, 0.01876746118068695, 0.0022895096335560083, -0.02598002180457115, -0.018436061218380928, -0.026502065360546112, -0.04332443326711655, -0.010473734699189663,
    0.049413152039051056, 0.009246899746358395, 0.004075315315276384, 0.03764619678258896, 0.005971016362309456, -0.0023301912005990744, 0.00013221491826698184, -0.0029500548262149096,
    -0.016615968197584152, 0.0021828454919159412, 0.013194166123867035, 0.0015940623125061393, 0.006902622990310192, 0.0028681778348982334, 0.017139703035354614, -0.00790323968976736,
    -0.04933691769838333, 0.007213607896119356, 0.041494619101285934, 0.09609193354845047, -0.050626855343580246, -0.0647248849272728, -0.017479488626122475, -0.08883537352085114,
    0.1064286157488823, -0.03387106582522392, -0.0597413033246994, -0.07953144609928131, 0.0607832595705986, 0.0457800030708313, 0.0569603368639946, -0.019584644585847855,
    0.07033880054950714, 0.04210731387138367, -0.07567927986383438, 0.01705997809767723, -0.03133842721581459, -0.011694112792611122, -0.12544728815555573, 0.2109997719526291,
    -0.03235483914613724, 0.006891136988997459, -0.019794467836618423, 0.07808630168437958, 0.006810301449149847, 0.0996532067656517, 0.09938349574804306, 0.002567363204434514,
    0.02430223673582077, 0.05255132541060448, -0.05127975344657898, 0.026442088186740875, 0.04992758110165596, -0.20138610899448395, -0.10246234387159348, 0.005350410472601652,
    0.028849869966506958, 0.05003742501139641, 0.027184367179870605, -0.027662117034196854, -0.02204103022813797, -0.0534566305577755, 0.07794290035963058, 0.0224774032831192,
    0.17048095166683197, 0.06991983950138092, -0.02001396380364895, -0.012590248137712479, -0.15631604194641113, -0.1392725110054016, 0.003672127379104495, -0.010434133000671864,
    0.037346694618463516, 0.02896695025265217, -0.039761126041412354, -0.04275626316666603, -0.03752829134464264, -0.0448920764029026, -0.10855145752429962, 0.12831297516822815,
    0.004247138276696205, -0.07043211907148361, -0.03587723523378372, -0.08493747562170029, 0.043434422463178635, 0.09271314740180969, 0.11585471034049988, 0.05835408717393875,
    -0.01761689782142639, -0.11215056478977203, -0.1221136823296547, -0.0470895990729332, 0.1512710452079773, 0.13978733122348785, -0.03692438825964928, 0.12320214509963989,
    -0.057293277233839035, 0.03772202879190445, 0.020282818004488945, -0.1047803983092308, -0.037909723818302155, -0.05457662045955658, -0.08976613730192184, 0.0780029147863388,
    -0.014658240601420403, -0.03072732873260975, -0.03533271700143814, 0.015424958430230618, -0.0760057345032692, -0.0041864532977342606, 0.0013682179851457477, 0.11317561566829681,
    0.06621496379375458, 0.059342529624700546, 0.06334515661001205, 0.07545933127403259, -0.040165893733501434, -0.002895571291446686, 0.02342895045876503, -0.018463458865880966,
    0.06696721166372299, -0.01182724442332983, 0.09119127690792084, 0.012605739757418633, -0.002078797435387969, -0.10391823202371597, 0.11062457412481308, 0.09530426561832428,
    0.004279928747564554, 0.004666013177484274, -0.03601919859647751, 0.05196714401245117, -0.060217227786779404, -0.05234293267130852, 0.02481367625296116, 0.015291359275579453,
    0.03327879682183266, -0.03049568459391594, -0.03149210289120674, -0.039899252355098724, -0.003347469959408045, -0.05722352862358093, -0.07347948849201202, 0.054327353835105896,
    -0.015209229663014412, 0.14392048120498657, 0.03374201059341431, 0.0066005089320242405, -0.08182090520858765, -0.015453946776688099, -0.003228150773793459, -0.06769295781850815,
    -0.02086818218231201, 0.04123064875602722, -0.07290619611740112, 0.08000931888818741, 0.08165131509304047, 0.01746000163257122, 0.15052178502082825, 0.08814685046672821,
    0.023815900087356567, 0.09170964360237122, -0.08618675917387009, -0.1068667620420456, -0.07732299715280533, -0.0013430507387965918, -0.12502333521842957, 0.17191922664642334,
    0.10633436590433121, 0.02445419691503048, -0.1446862816810608, -0.16155937314033508, 0.022685041651129723, -0.028467969968914986, 0.134414404630661, -0.07974829524755478,
    0.03315389156341553, 0.07973366975784302, 0.07681187242269516, 0.018090495839715004, 0.12705707550048828, -0.04260004684329033, -0.018233079463243484, -0.0529017373919487,
    0.03943188861012459, -0.12237581610679626, -0.01337849535048008, 0.021202336996793747, -0.08294831961393356, -0.09270234405994415, 0.14368437230587006, 0.05140053853392601,
    -0.061511650681495667, 0.018209300935268402, -0.06549070030450821, -0.036588992923498154, 0.09330274164676666, 0.17137083411216736, 0.0874117985367775, -0.0011077929520979524,
    -0.07643479853868484, -0.09678483754396439, 0.025057274848222733, -0.14261026680469513, 0.0790296271443367, -0.059038031846284866, -0.08426889032125473, -0.024800771847367287,
    0.013814556412398815, 0.17042502760887146, -0.05402318388223648, -0.06587755680084229, 0.021794842556118965, 0.07269733399152756, 0.02142171934247017, -0.05222354084253311,
    -0.03671472519636154, -0.09390350431203842, -0.054093826562166214, 0.007533572148531675, 0.009164947085082531, -0.0013520512729883194, -0.08642987906932831, -0.05031786113977432,
    -0.04019433632493019, -0.09499137848615646, 0.06607106328010559, -0.0628083273768425, 0.007421363145112991, 0.1067933589220047, 0.11060043424367905, 0.09646891802549362,
    -0.0806306004524231, -0.03469395264983177, -0.07306810468435287, 0.02437336929142475, -0.04492105916142464, -0.013104264624416828, -0.10258310288190842, 0.08514932543039322,
    0.008938540704548359, 0.036487724632024765, 0.11492012441158295, 0.07831811904907227, 0.04193468391895294, -0.016728932037949562, -0.06639531999826431, -0.12385249137878418,
    -0.01479516550898552, -0.08236954361200333, -0.15323494374752045, 0.04386462643742561, -0.08102269470691681, 0.06763911992311478, 0.13493028283119202, -0.04333914443850517,
    0.013772056438028812, -0.014420612715184689, 0.05663954094052315, -0.17572127282619476, 0.09962735325098038, -0.002468222053721547, -0.11685147136449814, 0.090873122215271,
    0.05149225518107414, 0.14814098179340363, -0.02418542467057705, -0.03033450059592724, -0.08979368954896927, -0.00606384314596653, 0.046425774693489075, -0.04809659346938133,
    0.010118206962943077, -0.0715726986527443, 0.02975415624678135, -0.10465382784605026, 0.05133174732327461, -0.05337701737880707, 0.1140788123011589, -0.10411673039197922,
    -0.05105787515640259, 0.12064743787050247, -0.02257731929421425, -0.002039405982941389, 0.08015239983797073, 0.0586327463388443, -0.02262246236205101, 0.03864746540784836,
    0.07505124062299728, 0.07843375205993652, -0.06825800240039825, -0.13560213148593903, 0.018282534554600716, 0.15607818961143494, 0.13709627091884613, -0.04346903786063194,
    -0.04195874184370041, 0.06695544719696045, -0.026125475764274597, 0.05425122752785683, 0.06712186336517334, 0.04044053331017494, 0.083548903465271, -0.005384272895753384,
    -0.11251924932003021, -0.025721348822116852, 0.023699937388300896, -0.06377192586660385, 0.08920419961214066, 0.14337855577468872, -0.04479420557618141, 0.11258579045534134,
    0.10443494468927383, -0.0411679781973362, -0.0027373959310352802, -0.043878648430109024, 0.09992233663797379, -0.11788329482078552, 0.018459832295775414, 0.04325248673558235,
    -0.02595544047653675, -0.05024419724941254, 0.01046445220708847, -0.03032948449254036, 0.20245856046676636, 0.06677322834730148, -0.11002415418624878, -0.10303997248411179,
    -0.050556838512420654, -0.15853916108608246, 0.06557629257440567, 0.007902947254478931, -0.10836908221244812, 0.052145395427942276, -0.11298517882823944, -0.001595477107912302,
    0.013253199867904186, -0.18380822241306305, -0.09379509836435318, 0.13772769272327423, -0.008143350481987, 0.0852828249335289, -0.11941264569759369, -0.10050295293331146,
    0.07322049140930176, -0.06372412294149399, 0.07517541199922562, -0.14006665349006653, -0.16704286634922028, 0.13448412716388702, -0.0640450119972229, -0.18946318328380585,
    -0.07383643090724945, 0.15051370859146118, 0.11949383467435837, 0.02109364978969097, 0.019448379054665565, -0.10298926383256912, -0.05978488177061081, -0.04009455814957619,
    0.029034873470664024, 0.09914100915193558, -0.2012667953968048, 0.018183518201112747, -0.07116685062646866, -0.109173484146595, 0.0078096878714859486, 0.05087384209036827,
    -0.03770407289266586, 0.002284622984007001, -0.024499820545315742, 0.08920599520206451, 0.11317887902259827, 0.044796694070100784, 0.06088775396347046, 0.15845780074596405,
    0.029748862609267235, -0.08357279747724533, 0.09453821182250977, 0.052179500460624695, 0.00039559919969178736, 0.1140681803226471, 0.1492045372724533, 0.006818045862019062,
    0.06366705149412155, -0.13402844965457916, -0.07706591486930847, -0.06503118574619293, 0.08817623555660248, 0.11727946996688843, -0.16380532085895538, -0.13656535744667053,
    -0.025916559621691704, -0.04709208011627197, 0.1598718762397766, 0.001770378090441227, -0.06641504168510437, -0.09408929944038391, -0.08049001544713974, -0.021205689758062363,
    -0.1883353590965271, -0.24994100630283356, -0.008025268092751503, 0.05350339040160179, -0.024365466088056564, -0.14122441411018372, 0.019269077107310295, -0.08807921409606934,
    -0.05786074697971344, -0.06536657363176346, -0.03333388268947601, 0.12599609792232513, -0.025655068457126617, -0.10502706468105316, 0.01597272790968418, -0.00023662000603508204,
    0.04274584352970123, 0.05212001875042915, -0.011502576991915703, -0.07802551239728928, 0.16215798258781433, 0.04640786349773407, 0.082194484770298, -0.1662774682044983,
    0.01260867714881897, 0.051849812269210815, -0.02288755401968956, 0.07949147373437881, 0.1744285672903061, -0.04017231985926628, -0.04293300211429596, 0.009984121657907963,
    -0.05786514654755592, 0.010659543797373772, -0.2193097472190857, 0.0478694774210453, -0.010715032927691936, -0.05107048526406288, -0.1003556102514267, -0.08554607629776001,
    0.000183719617780298, 0.20131123065948486, 0.06817898154258728, -0.08928663283586502, 0.07861194014549255, -0.046330664306879044, -0.20697905123233795, -0.11687929183244705,
    0.0694308802485466, 0.0030886344611644745, 0.05121751129627228, 0.047322846949100494, -0.09199583530426025, -0.04242480918765068, 0.013956425711512566, -0.17936363816261292,
    0.010787295177578926, -0.07315386086702347, -0.053943563252687454, 0.008755076676607132, -0.0613047257065773, 0.014948034659028053, -0.03384653478860855, 0.06810416281223297,
    0.030497947707772255, 0.06726859509944916, 0.020271869376301765, 0.1108475923538208, -0.03972456231713295, -0.06311368197202682, -0.006971078459173441, -0.07923778891563416,
    -0.1949637234210968, 0.0028840184677392244, -0.0010061454959213734, -0.10825064033269882, 0.11702575534582138, -0.13172858953475952, -0.05035274475812912, 0.09464643895626068,
    -0.09544802457094193, -0.17121514678001404, 0.014017065986990929, 0.08522997051477432, -0.019206583499908447, 0.029925057664513588, -0.1910228282213211, 0.06840524822473526,
    -0.039676763117313385, 0.07551541924476624, -0.15791656076908112, -0.002604449400678277, -0.1833273321390152, -0.14347632229328156, 0.06370382010936737, -0.08136436343193054,
    0.026100946590304375, -0.10450033098459244, 0.06680788844823837, 0.0731377825140953, 0.04239565134048462, 0.03274249657988548, -0.17483004927635193, 0.1821720451116562,
    0.024534747004508972, 0.04715505242347717, 0.02503330260515213, 0.20416203141212463, 0.03965366259217262, -0.08501608669757843, 0.05217535421252251, -0.07249665260314941,
    0.08391331136226654, 0.0464126318693161, 0.19637873768806458, 0.19907714426517487, 0.06881365180015564, 0.0204771738499403, 0.06475888192653656, 0.3357832431793213,
    -0.018504882231354713, -0.16703079640865326, 0.2120635062456131, -0.01986715756356716, 0.05884002894163132, -0.019831212237477303, -0.13724713027477264, -0.06789552420377731,
    -0.030100438743829727, 0.0042367614805698395, -0.08772169053554535, -0.05109167471528053, -0.014918018132448196, -0.0645868256688118, -0.20735101401805878, -0.08146347850561142,
    0.11698508262634277, -0.3000486493110657, -0.10527610033750534, 0.05772142484784126, -0.031911611557006836, 0.08142627775669098, 0.03317243978381157, 0.0565345324575901,
    0.010554554872214794, 0.024648485705256462, -0.06657066196203232, -0.11386767029762268, -0.08831928670406342, -0.13792362809181213, 0.09847062826156616, 0.009032892063260078,
    0.06030108034610748, -0.012861966155469418, 0.04636296629905701, -0.2317722886800766, 0.14530140161514282, -0.10227451473474503, -0.039740562438964844, 0.03536157310009003,
    -0.07450319826602936, 0.03717440739274025, 0.0007466149982064962, 0.049382779747247696, 0.010916280560195446, 0.006909959949553013, -0.05085067078471184, -0.1618231236934662,
    -0.20783087611198425, 0.05821714177727699, 0.1349184811115265, -0.12858489155769348, 0.07778695225715637, -0.19161063432693481, -0.14504684507846832, -0.23208242654800415,
    -0.016805514693260193, 0.17065158486366272, -0.07734290510416031, 0.007974021136760712, -0.06316298991441727, 0.1760004311800003, -0.042210012674331665, 0.19408872723579407,
    0.0820346251130104, 0.05703640729188919, 0.1041538193821907, -0.09566918760538101, 0.1792568564414978, -0.13776829838752747, 0.057243552058935165, 0.1587768793106079,
    0.08860351890325546, 0.188501238822937, 0.0488349124789238, -0.02872747927904129, -0.06411340087652206, -0.1213407963514328, 0.014148136600852013, 0.09428327530622482,
    -0.0879867896437645, 0.04725564271211624, -0.13649478554725647, -0.10679686814546585, 0.07721234112977982, -0.1306518018245697, -0.002339991508051753, 0.18843498826026917,
    0.056752320379018784, 0.14393670856952667, -0.02408038079738617, -0.04798608273267746, 0.049851853400468826, -0.05161247029900551, 0.1785975843667984, 0.09137250483036041,
    -0.1418197602033615, 0.21322132647037506, -0.08512958884239197, 0.10405336320400238, -0.09878921508789062, -0.09425222873687744, -0.16066977381706238, 0.11715452373027802,
    0.08189432322978973, -0.14242732524871826, 0.18927493691444397, -0.05586839094758034, -0.02056734822690487, 0.0067110504023730755, 0.05065631493926048, -0.08450813591480255,
    -0.05310588330030441, -0.01228976808488369, -0.08570031076669693, 0.0347619354724884, -0.018801067024469376, 0.0323801152408123, -0.011526249349117279, 0.2045888453722,
    0.06089453026652336, 0.1393163949251175, -0.2480410635471344, 0.0315462090075016, 0.01886274479329586, -0.11096499860286713, 0.05618378892540932, -0.3244551718235016,
    -0.04545639827847481, 0.2571214437484741, -0.03979162126779556, -0.028196018189191818, 0.2378597855567932, 0.02853786200284958, -0.03642873838543892, -0.048212576657533646,
    0.014700600877404213, 0.05622909590601921, -0.00614459253847599, 0.032536353915929794, -0.09012039750814438, 0.0073674204759299755, -0.21759527921676636, -0.08012828975915909,
    -0.1654605120420456, -0.02096514403820038, -0.3267805278301239, -0.04084516689181328, -0.0031647991854697466, 0.13834884762763977, 0.022348327562212944, -0.046292055398225784,
    -0.14031492173671722, -0.023063981905579567, -0.04449018836021423, -0.11262580752372742, -0.038459811359643936, -0.050722572952508926, 0.050366077572107315, -0.049501076340675354,
    0.12526661157608032, 0.015270102769136429, -0.027214042842388153, 0.1685294508934021, 0.11219234019517899, 0.005733516067266464, 0.07982685416936874, 0.0718369409441948,
    -0.02507343702018261, 0.012423447333276272, 0.24368590116500854, -0.01677904650568962, 0.06557291746139526, 0.09774879366159439, -0.02636599913239479, 0.27888205647468567,
    -0.12798872590065002, -0.29106155037879944, -0.028103860095143318, 0.036990270018577576, -0.018985355272889137, 0.07713576406240463, -0.015295881778001785, -0.06623858213424683,
    -0.04982183501124382, 0.10163300484418869, -0.04113620147109032, 0.04708421230316162, -0.014154499396681786, 0.10198292881250381, -0.1341467648744583, 0.2925622761249542,
    -0.029042501002550125, 0.11224652081727982, 0.06569003313779831, 0.0561082698404789, -0.09642533957958221, 0.14778640866279602, -0.04167114943265915, 0.16989125311374664,
    0.041830990463495255, -0.28641948103904724, 0.12083818018436432, 0.07874682545661926, 0.04837120696902275, 0.04903767630457878, 0.07463623583316803, -0.08515700697898865,
    0.28327038884162903, 0.086007259786129, -0.014638657681643963, -0.0844167098402977, 0.0133605245500803, 0.14952608942985535, -0.19397786259651184, -0.014339467510581017,
    0.04563002288341522, 0.048568639904260635, 0.18738429248332977, 0.027242762967944145, 0.0396411307156086, -0.012621907517313957, 0.07983002066612244, -0.05567966774106026,
    0.03554685041308403, 0.020282471552491188, -0.12687426805496216, 0.03001933917403221, 0.01460700947791338, 0.09904740750789642, 0.12625332176685333, -0.01605028472840786,
    0.0159233957529068, -0.09754697978496552, -0.16879047453403473, -0.07840193063020706, -0.018294641748070717, -0.018283739686012268, 0.218709334731102, -0.061365749686956406,
    0.025416703894734383, 0.006864518392831087, 0.04020869731903076, -0.08674068748950958, 0.0038298519793897867, 0.1361796110868454, -0.003911816515028477, 0.1998666524887085,
    0.06497497856616974, -0.03530316799879074, 0.24259895086288452, 0.03885216638445854, -0.08115553110837936, 0.03557348623871803, -0.04891229048371315, 0.3538971543312073,
    -0.020419083535671234, -0.03723564371466637, 0.012731975875794888, 0.000745345139876008, 0.14685069024562836, 0.06477238237857819, 0.1235823780298233, 0.005853577516973019,
    -0.0949208214879036, -0.08023139089345932, -0.05095073580741882, 0.054123200476169586, 0.12187343835830688, 0.10514473915100098, 0.06887875497341156, -0.03978593274950981,
    -0.10127260535955429, 0.02958795614540577, 0.02693837694823742, -0.2518773674964905, -0.014854359440505505, -0.045410096645355225, 0.02346877194941044, 0.022595718502998352,
    -0.2265356481075287, 0.12677209079265594, -0.00185568374581635, -0.05728025361895561, 0.16957007348537445, -0.15941216051578522, -0.10267449170351028, -0.059926632791757584,
    0.10159210115671158, 0.0549088716506958, -0.1646111011505127, 0.004954105708748102, 0.13686184585094452, 0.013642226345837116, 0.031184211373329163, 0.06855518370866776,
    -0.03981756791472435, 0.016487356275320053, -0.21186837553977966, 0.0022428829688578844, -0.03323790431022644, 0.01604028046131134, 0.038073718547821045, -0.3318886160850525,
    0.025755520910024643, 0.05226714909076691, -0.2212308645248413, 0.08086611330509186, -0.060459449887275696, -0.013597127981483936, 0.0780237540602684, 0.26709824800491333,
    -0.06627113372087479, -0.11277253180742264, -0.0977814793586731, -0.04602761194109917, 0.0844702199101448, -0.06017930805683136, 0.19027705490589142, 0.12428271025419235,
    -0.02297302894294262, 0.11070813983678818, -0.19009624421596527, 0.056258171796798706, 0.03659830614924431, 0.01725512370467186, 0.08625681698322296, -0.025346439331769943,
    0.022030547261238098, 0.25633883476257324, -0.14409556984901428, -0.1702863574028015, 0.010858154855668545, 0.06203170865774155, 0.10075730830430984, -0.09813592582941055,
    0.027812492102384567, -0.010870669968426228, 0.03193312883377075, -0.1355193555355072, 0.10956116020679474, -0.11466548591852188, -0.26507335901260376, -0.12896457314491272,
    0.06141253560781479, -0.2725869119167328, -0.023433400318026543, -0.0038422471843659878, 0.16012370586395264, 0.014850247651338577, -0.23139110207557678, -0.013524936512112617,
    0.1461128443479538, -0.015681354328989983, -0.03395574912428856, -0.1684999018907547, -0.1828993409872055, 0.06966562569141388, 0.14023457467556, -0.1880912482738495,
    -0.2564564645290375, -0.04947420954704285, 0.1473086029291153, -0.02912619337439537, 0.13648229837417603, 0.052632734179496765, 0.2171614170074463, 0.06637825071811676,
    -0.022662967443466187, 0.029379190877079964, 0.16586537659168243, 0.06872756034135818, -0.00012603543291334063, -0.17573755979537964, -0.03534785658121109, 0.1072087436914444,
    0.0671992227435112, 0.029558813199400902, -0.25972551107406616, 0.05910780280828476, 0.07075408846139908, 0.025913454592227936, 0.19871889054775238, -0.23972733318805695,
    -0.008123815059661865, -0.17614097893238068, 0.03500298783183098, -0.058146361261606216, -0.0014536908129230142, 0.02615274302661419, 0.06126408278942108, 0.019164353609085083,
    -0.02261492982506752, -0.11522319912910461, -0.0011001700768247247, 0.0016292550135403872, 0.18928523361682892, 0.09537703543901443, 0.3308377265930176, -0.09338188916444778,
    0.029985174536705017, 0.07602883130311966, -0.020967161282896996, -0.01003915537148714, -0.05187144875526428, 0.12125693261623383, -0.06673748046159744, -0.043933361768722534,
    -0.10071247071027756, 0.0669143795967102, 0.02735442854464054, -0.1095728650689125, -0.019771574065089226, 0.03634922206401825, -0.0722326710820198, -0.03805863857269287,
    0.15026859939098358, -0.01563066989183426, -0.12272190302610397, -0.1778722107410431, 0.12062792479991913, -0.14726746082305908, -0.03420896455645561, 0.10175365209579468,
    -0.016761673614382744, 0.01830083690583706, -0.14501254260540009, -0.033877186477184296, 0.04822705313563347, 0.038732435554265976, -0.039840217679739, 0.11747089773416519,
    0.12998345494270325, 0.15905718505382538, -0.26147931814193726, 0.06875188648700714, 0.1162380576133728, 0.003717191517353058, 0.1074431911110878, 0.24163997173309326,
    0.0031089254189282656, 0.059571269899606705, -0.025855708867311478, -0.1851576566696167, -0.013806648552417755, -0.057849980890750885, -0.0691336840391159, -0.09023220837116241,
    -0.004635189194232225, 0.17887412011623383, -0.12959454953670502, 0.01701280102133751, 0.28656020760536194, 0.04314781725406647, 0.02191220223903656, 0.10850727558135986,
    0.024780865758657455, -0.06939999759197235, -0.14083735644817352, -0.028779586777091026, 0.011434661224484444, 0.06916537880897522, -0.06893130391836166, 0.22956007719039917,
    0.017401017248630524, -0.06165440380573273, 0.08900634199380875, -0.026091627776622772, 0.073726586997509, 0.04986855387687683, 0.11694709956645966, 0.008353201672434807,
    0.09878333657979965, 0.37565967440605164, 0.10948990285396576, 0.03442980349063873, -0.16271333396434784, 0.011639376170933247, 0.07931704074144363, 0.03589528426527977,
    0.06948363780975342, -0.0589444637298584, 0.12050913274288177, 0.003999882377684116, -0.0869031623005867, 0.0440022237598896, -0.310190349817276, 0.07190670818090439,
    -0.0031397738493978977, -0.028525864705443382, -0.024022188037633896, -0.018599435687065125, 0.29496076703071594, -8.138488192344084e-05, -0.05626806616783142, 0.13220877945423126,
    0.002703245496377349, -0.04073216766119003, -0.19080786406993866, 0.0990786999464035, 0.031120264902710915, 0.005994537845253944, 0.047108788043260574, -0.047606632113456726,
    0.09058297425508499, -0.014829544350504875, 0.12860500812530518, -0.03717382997274399, 0.09283003956079483, 0.0466143935918808, 0.12199852615594864, 0.1960664689540863,
    -0.020123274996876717, 0.1692105382680893, -0.14673621952533722, -0.06371290981769562, 0.08829141408205032, 0.05242941901087761, 0.16058357059955597, 0.02213786356151104,
    -0.01947195641696453, 0.013461528345942497, 0.06127682700753212, 0.107269786298275, -0.011042877100408077, 0.12336161732673645, 0.27369996905326843, -0.0651518851518631,
    -0.05243927240371704, -0.030447477474808693, 0.16229566931724548, -0.05910953879356384, -0.060543231666088104, 0.10153340548276901, -0.04817238822579384, -0.05876624211668968,
    0.1746833473443985, 0.008955378085374832, -0.06324885785579681, -0.23132365942001343, -0.18297691643238068, 0.022151386365294456, 0.051794134080410004, 0.008538642898201942,
    0.08831768482923508, -0.05379193276166916, -0.0403449684381485, 0.2822074890136719, 0.1121286079287529, 0.030372027307748795, -0.023568198084831238, 0.029129158705472946,
    -0.0003947093791794032, -0.003674354637041688, 0.2087741494178772, -0.06125646457076073, 0.0913596972823143, -0.07361799478530884, 0.01761346496641636, 0.06506466120481491,
    -0.0438518151640892, -0.11146816611289978, 0.15624772012233734, 0.10157898813486099, 0.12069018185138702, -0.03454567492008209, 0.033628180623054504, -0.12227624654769897,
    0.016597509384155273, 0.07013458013534546, 0.07142016291618347, -0.21261747181415558, -0.03609789162874222, 0.03567244112491608, 0.09913110733032227, -0.275125116109848,
    0.013717151246964931, 0.14982393383979797, 0.06613165885210037, 0.09863413870334625, -0.123940609395504, 0.14413832128047943, -0.015027997083961964, 0.08433029800653458,
    0.04172889515757561, -0.15163186192512512, -0.11505461484193802, 0.08949140459299088, 0.07207587361335754, -0.0634302869439125, -0.09963186085224152, 0.19698238372802734,
    -0.004518479108810425, 0.11083987355232239, 0.04187031835317612, -0.03156629577279091, 0.0033917154651135206, -0.007980672642588615, 0.0515860952436924, 0.035139117389917374,
    0.03327891230583191, -0.38825732469558716, -0.0041753691621124744, -0.026540108025074005, -0.1848459541797638, 0.025131555274128914, 0.27434444427490234, 0.1543186604976654,
    -0.05753204599022865, -0.032353468239307404, 0.0542401522397995, 0.2138415277004242, -0.0511167086660862, -0.04927179962396622, 0.12321385741233826, 0.08964439481496811,
    0.12493183463811874, -0.029512953013181686, 0.16967664659023285, -0.09284141659736633, 0.07394730299711227, 0.02017887867987156, -0.24886220693588257, 0.08982690423727036,
    -0.06691645830869675, 0.10796494036912918, 0.13521595299243927, -0.09787695854902267, 0.07880979776382446, 0.04850894957780838, -0.030588727444410324, 0.011567738838493824,
    0.12291653454303741, 0.09819941222667694, -0.04465396702289581, -0.01324576698243618, 0.04841381683945656, -0.011982872150838375, 0.09679396450519562, -0.000507621094584465,
    -0.022825928404927254, 0.015430139377713203, -0.06666427105665207, -0.036823127418756485, 0.010873958468437195, 0.033768076449632645, 0.1286693960428238, 0.04706764966249466,
    -0.1900908499956131, 0.03310566022992134, -0.004147446248680353, 0.05294590815901756, 0.006009043660014868, 0.16873733699321747, -0.125522181391716, -0.01893976517021656,
    -0.0006650922587141395, 0.035149361938238144, 0.16686490178108215, -0.010899538174271584, -0.08287440985441208, -0.1435890942811966, -0.06426504254341125, -0.021973248571157455,
    0.2480204999446869, 0.02937505580484867, -0.04071628674864769, -0.1497926265001297, -0.2505464255809784, -0.09519065171480179, 0.026820555329322815, -0.06338184326887131,
    -0.055786941200494766, -0.09314585477113724, 0.03550242632627487, -0.20091715455055237, 0.22325968742370605, 0.16465921700000763, -0.02764808014035225, 0.0038144404534250498,
    0.007302443962544203, -0.030100610107183456, 0.04509291425347328, 0.004434146918356419, -0.02423400804400444, 0.04478945583105087, -0.1012117937207222, -0.17624711990356445,
    -0.14660853147506714, -0.22567230463027954, 0.38300615549087524, 0.056068532168865204, 0.10719212889671326, -0.12200997024774551, -0.024781279265880585, -0.35210120677948,
    0.07679787278175354, -0.09576380997896194, 0.038413628935813904, -0.2833597660064697, 0.11743080615997314, -0.016315462067723274, 0.21275116503238678, -0.20238928496837616,
    -0.14657311141490936, -0.036566268652677536, -0.015111160464584827, 0.14348900318145752, 0.03504554554820061, -0.1535201072692871, -0.01144072413444519, -0.022865982726216316,
    0.010569806210696697, 0.2559245526790619, -0.01536827813833952, 0.06117677316069603, 0.12008219212293625, 0.012715360149741173, 0.10819611698389053, -0.13166789710521698,
    0.13364222645759583, 0.02474522776901722, -0.005188692826777697, -0.12079521268606186, -0.027263855561614037, 0.000568743038456887, -0.016384681686758995, -0.09986855089664459,
    0.050830766558647156, 0.2527889609336853, 0.011865583248436451, -0.001865660771727562, -0.08583688735961914, -0.020131390541791916, -0.26855507493019104, 0.18658027052879333,
    0.08953729271888733, -0.022595364600419998, 0.07665208727121353, 0.16211503744125366, -0.033247169107198715, 0.1426939070224762, 0.22682301700115204, -0.12848694622516632,
    0.026442132890224457, 0.039803095161914825, 0.07628237456083298, -0.026487858965992928, -0.21860654652118683, 0.032756756991147995, 0.07773175835609436, -0.07436459511518478,
    0.009008471854031086, 0.039374783635139465, 0.07066212594509125, -0.08865553885698318, -0.013603156432509422, -0.03363381698727608, -0.03686494752764702, 0.06992793828248978,
    0.0790594294667244, -0.0008466997533105314, -0.06760682165622711, -0.10718842595815659, 0.08871865272521973, 0.08491522073745728, 0.1384987235069275, -0.08498362451791763,
    -0.07473251223564148, -0.1338789165019989, 0.07489040493965149, 0.03454974666237831, 0.011042420752346516, -0.014938677661120892, -0.04257332161068916, -0.05629860237240791,
    -0.06912935525178909, 0.07481910288333893, -0.011913297697901726, -0.023112520575523376, 0.0010888187680393457, 0.13912849128246307, -0.27859869599342346, -0.08036322891712189,
    0.1273854821920395, 0.013296450488269329, 0.08373761922121048, 0.20875506103038788, -0.06661480665206909, 0.130519837141037, -0.11811014264822006, -0.11905215680599213,
    0.06518770754337311, 0.008098085410892963, 0.023707550019025803, -0.14759786427021027, -0.09529412537813187, -0.01844567060470581, -0.06693980097770691, -0.05310044437646866,
    -0.08514975011348724, -0.06982646137475967, 0.01138431578874588, -0.04896422103047371, 0.12351629883050919, -0.040462758392095566, 0.010497093200683594, -0.1860877126455307,
    -0.00032304110936820507, -0.07449952512979507, -0.26303422451019287, 0.01204629521816969, 0.09561663866043091, 0.012267405167222023, 0.0260170828551054, 0.21389137208461761,
    0.09988969564437866, 0.06339789927005768, 0.18757763504981995, -0.0030753077007830143, -0.1029064953327179, -0.10203813761472702, -0.028656551614403725, 0.06652632355690002,
    0.018751995638012886, -0.13166393339633942, 0.06240328028798103, -0.13212347030639648, -0.06147363409399986, 0.07016552984714508, -0.15998438000679016, -0.017166826874017715,
    -0.19048544764518738, -0.03225337341427803, -0.032753851264715195, 0.1265837401151657, 0.09091220796108246, -0.06411110609769821, -0.11790889501571655, 0.037184782326221466,
    0.05601825192570686, -0.2577090561389923, -0.08693712949752808, 0.026379786431789398, 0.06233471259474754, 0.07374937832355499, -0.037866730242967606, 0.15620674192905426,
    0.274029403924942, -0.007554094772785902, 0.13353611528873444, 0.00785006582736969, 0.10633359104394913, 0.15325269103050232, -0.07522223889827728, 0.07984587550163269,
    0.06151456758379936, -0.06286264955997467, -0.06360295414924622, 0.03874076530337334, 0.18970133364200592, -0.0009185981471091509, -0.06145051121711731, 0.10570186376571655,
    0.25539955496788025, -0.05220773071050644, -0.057480622082948685, -0.2954798936843872, -0.0352226197719574, 0.23341667652130127, -0.3544943034648895, -0.012548419646918774,
    -0.16879954934120178, -0.012953920289874077, -0.2437206208705902, -0.09061417728662491, -0.21039249002933502, 0.01673346385359764, -0.04847022518515587, -0.14538316428661346,
    0.011056862771511078, -0.09965331852436066, -0.09594983607530594, -0.02746768109500408, 0.06216609105467796, -0.09541504830121994, -0.15178316831588745, -0.07804860919713974,
    0.09595838189125061, 0.014439099468290806, 0.23101888597011566, -0.0919007733464241, -0.04865322262048721, 0.051578544080257416, 0.01599886082112789, 0.18346337974071503,
    -0.04744359105825424, 0.14236412942409515, 0.048385556787252426, 0.001857765601016581, 0.1362248808145523, -0.00826087687164545, -0.15688389539718628, 0.04219605028629303,
    -0.13629136979579926, 0.06507761776447296, 0.05114370211958885, 0.0930788591504097, 0.123306043446064, 0.2009350210428238, -0.12575340270996094, -0.126947283744812,
    -0.0713590532541275, 0.06910964101552963, -0.030559543520212173, 0.10331282019615173, -0.08959726989269257, -0.1859414130449295, -0.06718076765537262, -0.0855112224817276,
    -0.0990656390786171, -0.05102952569723129, 0.03574429824948311, -0.11404472589492798, -0.043984174728393555, 0.13011595606803894, -0.12217150628566742, -0.018333327025175095,
    -0.04545271769165993, -0.11173797398805618, 0.12929444015026093, 0.24264012277126312, 0.21716444194316864, -0.15849578380584717, -0.05207435041666031, -0.10865559428930283,
    0.006586157251149416, -0.03788655251264572, 0.1461459994316101, -0.05406779795885086, -0.018967382609844208, 0.058281976729631424, -0.0505557656288147, -0.10001843422651291,
    0.20628100633621216, 0.18211060762405396, -0.3224923610687256, -0.1245003342628479, -0.1560596525669098, -0.14712731540203094, -0.02948479726910591, 0.3912849724292755,
    -0.021078025922179222, 0.12992903590202332, 0.014923286624252796, -0.1170235127210617, -0.08681810647249222, 0.006059387233108282, -0.17500601708889008, -0.02632635459303856,
    -0.20774653553962708, -0.16990092396736145, -0.11615010350942612, 0.20728649199008942, -0.16567212343215942, -0.008761852979660034, 0.057149652391672134, 0.04028977081179619,
    -0.04748796299099922, 0.17015127837657928, -0.12464626133441925, -0.08083415776491165, -0.08434499800205231, 0.0459265373647213, -0.015778157860040665, 0.18528570234775543,
    -0.060238875448703766, -0.06860091537237167, -0.027204927057027817, 0.06765495240688324, 0.13050824403762817, 0.0437394455075264, 0.10354816168546677, -0.03421368822455406,
    0.06419256329536438, -0.12010891735553741, -0.2550319731235504, 0.018631409853696823, 0.10237158089876175, -0.07275030761957169, 0.32322582602500916, 0.06442533433437347,
    0.15491266548633575, -0.006879415828734636, -0.21887840330600739, -0.02376125194132328, -0.11864452064037323, -0.09229971468448639, 0.1137315034866333, 0.1082865297794342,
    -0.19044852256774902, 0.05445609986782074, -0.17813333868980408, -0.008710675872862339, -0.12565851211547852, 0.06911975145339966, 0.11437153071165085, -0.010067961178719997,
    -0.03406120464205742, 0.0032473381143063307, 0.047367557883262634, -0.03255971521139145, -0.03985356166958809, 0.05787814036011696, -0.08798283338546753, 0.03512808308005333,
    0.08603093773126602, 0.1737043559551239, -0.36658695340156555, 0.02295524999499321, -0.022033656015992165, -0.03683200478553772, 0.11556588113307953, -0.2504882514476776,
    -0.08839183300733566, -0.023351440206170082, -0.03509156405925751, -0.06079632043838501, -0.06279653310775757, -0.04474721848964691, 0.1606942117214203, -0.08999991416931152,
    -0.0627647191286087, 0.13413076102733612, 0.03945477679371834, 0.07552247494459152, -0.004119498655200005, 0.11233624815940857, 0.063866525888443, -0.012668456882238388,
    -0.011618338525295258, 0.03695780411362648, -0.11556902527809143, -0.08019018173217773, -0.11790543794631958, -0.12038659304380417, -0.09267416596412659, -0.01728593185544014,
    -0.21356433629989624, -0.14602875709533691, 0.04323099926114082, 0.004223332740366459, -0.05392392724752426, 0.20330539345741272, -0.047614842653274536, -0.0324726365506649,
    0.012855369597673416, -0.03005114756524563, 0.10645110160112381, -0.24659021198749542, 0.08890258520841599, 0.07985880225896835, -0.039412446320056915, -0.2794903516769409,
    -0.07203918695449829, 0.06771642714738846, 0.12489207088947296, 0.006102076265960932, 0.029774708673357964, -0.004579624161124229, 0.06609437614679337, -0.09252411872148514,
    -0.03817136585712433, -0.12716172635555267, -0.48877155780792236, 0.0003138095489703119, -0.12043670564889908, -0.10978372395038605, -0.03272917494177818, -0.03912229463458061,
    0.08757036924362183, 0.27462121844291687, -0.07557353377342224, 0.03350083902478218, 0.11101385205984116, 0.11835403740406036, -0.053904175758361816, 0.17249950766563416,
    -0.2150115817785263, 0.0434194877743721, 0.068398118019104, 0.07203025370836258, -0.04570458456873894, -0.04001036658883095, -0.027844928205013275, -0.02732870914041996,
    -0.053330838680267334, 0.0065653687343001366, -0.2266266793012619, -0.031537964940071106, 0.0881567895412445, 0.046421680599451065, 0.014867721125483513, -0.09306667745113373,
    -0.1257028877735138, 0.12803655862808228, -0.02175285667181015, -0.027013741433620453, 0.07949388027191162, -0.08251230418682098, 0.02866886556148529, -0.1782476007938385,
    -0.0041255890391767025, 0.2741125226020813, -0.262085497379303, -0.0027711563743650913, -0.2933981716632843, 0.0031268757302314043, -0.28036510944366455, 0.04888257756829262,
    0.09996746480464935, -0.165674090385437, -0.09110483527183533, 0.27977997064590454, -0.032677166163921356, -0.3335988223552704, 0.24360673129558563, -0.06491324305534363,
    0.05610562860965729, 0.14885590970516205, 0.018045879900455475, -0.13634270429611206, 0.0996081754565239, 0.05256463587284088, -0.01653534732758999, 0.05304810032248497,
    0.007583921775221825, -0.027914216741919518, 0.026091447100043297, 0.18462005257606506, -0.04991786181926727, 0.04678799584507942, -0.0962013527750969, 0.18928128480911255,
    0.19497820734977722, 0.1285105049610138, 0.3655479848384857, 0.06467963010072708, -0.005520631559193134, -0.01940901204943657, -0.040907252579927444, 0.2289130538702011,
    -0.038784027099609375, -0.09692250192165375, -0.0673961490392685, 0.06126416102051735, -0.15632231533527374, -0.0319133959710598, 0.12125853449106216, 0.006621662061661482,
    0.060216426849365234, 0.054167404770851135, 0.1477135717868805, 0.00636510131880641, -0.07885032147169113, 0.0031106595415621996, 0.19023410975933075, -0.0734962597489357,
    0.061076343059539795, 0.08578634262084961, -0.15002915263175964, -0.16428467631340027, -0.038868650794029236, 0.14313627779483795, -0.1699410229921341, -0.12269316613674164,
    -0.11634673923254013, -0.06548696011304855, 0.044884659349918365, -0.06516153365373611, 0.008252248167991638, 0.02916695922613144, 0.05788074806332588, 0.0025991417933255434,
    -0.23092159628868103, -0.06972131133079529, 0.012702357955276966, 0.09743869304656982, 0.033644065260887146, 0.06673207134008408, -0.027112526819109917, -0.24479280412197113,
    -0.02156841568648815, 0.0036116810515522957, -0.16194993257522583, -0.051316384226083755, 0.007882417179644108, -0.008775079622864723, 0.0056397137232124805, 0.27204445004463196,
    -0.2562066316604614, -0.06148515269160271, 0.03398706763982773, -0.01067185215651989, 0.050512250512838364, -0.08379147201776505, -0.02650471404194832, -0.42383724451065063,
    0.07687214016914368, 0.050073109567165375, 0.03886865824460983, 0.16041533648967743, 0.1380426585674286, 0.04886860027909279, -0.19989275932312012, 0.2473163902759552,
    -0.22298122942447662, 0.037181396037340164, 0.06287869065999985, 0.05719463527202606, 0.18058674037456512, -0.1465209722518921, 0.033771343529224396, -0.04678727313876152,
    -0.10376168042421341, -0.17429938912391663, -0.04083331674337387, 0.045053545385599136, 0.2945271134376526, -0.03893965110182762, -0.028444597497582436, -0.10425917059183121,
    0.10535652190446854, -0.08928559720516205, -0.0138754453510046, 0.03449980542063713, -0.06067242845892906, 0.0006852234364487231, -0.01891246624290943, 0.051569946110248566,
    0.018890995532274246, -0.2434241771697998, -0.1130325049161911, 0.040603820234537125, -0.2167631834745407, 0.009364360012114048, -0.04055602103471756, -0.09902530163526535,
    -0.14032863080501556, -0.1900745928287506, 0.18239687383174896, 0.1018577367067337, -0.14307481050491333, -0.28123989701271057, -0.3041093051433563, -0.19630156457424164,
    -0.11314791440963745, 0.023030325770378113, 0.17673847079277039, -0.028695525601506233, -0.0478401705622673, 0.08711302280426025, -0.13990531861782074, 0.12784092128276825,
    -0.05796489492058754, -0.011342192068696022, -0.13128003478050232, 0.17561063170433044, -0.051085975021123886, 0.05944209545850754, -0.06880798190832138, 0.09075760096311569,
    0.15248063206672668, 0.14142592251300812, -0.4156583845615387, 0.09418344497680664, 0.09016313403844833, 0.045957110822200775, 0.052637021988630295, -0.1472661793231964,
    -0.08730146288871765, 0.08177977800369263, -0.10679196566343307, -0.009091373533010483, 0.11818237602710724, 0.02245338447391987, -0.15873412787914276, 0.04437952861189842,
    0.05938936769962311, 0.008478201925754547, 0.09770019352436066, 0.22600986063480377, 0.0940055251121521, -0.007267698645591736, 0.15548492968082428, -0.15811264514923096,
    -0.030990364030003548, 0.11829058825969696, -0.007128536235541105, -0.12831397354602814, -0.08095550537109375, -0.2975356876850128, 0.01981779932975769, -0.016605237498879433,
    0.17834597826004028, 0.07678496837615967, 0.11740250140428543, -0.24955928325653076, -0.061989039182662964, 0.08143895864486694, 0.03706813603639603, -0.009960055351257324,
    -0.14893977344036102, -0.13454359769821167, -0.1739025115966797, 0.18243932723999023, 0.1273549646139145, -0.10385078936815262, 0.006987829227000475, -0.11323051899671555,
    -0.011091379448771477, 0.057900570333004, -0.03697694465517998, -0.034788794815540314, 0.007385308388620615, 0.016600951552391052, 0.007970673032104969, -0.2703896164894104,
    -0.2718673646450043, 0.179294154047966, 0.3917832374572754, -0.11562463641166687, 0.26387539505958557, 0.054994743317365646, 0.06737393140792847, -0.14056357741355896,
    -0.004860813729465008, 0.02083837240934372, -0.01194422971457243, 0.3030426800251007, -0.03819430619478226, 0.04192884638905525, 0.08529971539974213, -0.015656158328056335,
    -0.12461145967245102, 0.0060334112495183945, -0.2808507978916168, 0.08991485089063644, -0.19825313985347748, -0.1263335943222046, -0.07586999237537384, -0.21505026519298553,
    -0.03877311199903488, 0.23331385850906372, 0.17201581597328186, 0.12317221611738205, -0.03467371687293053, 0.10440254211425781, 0.060055047273635864, -0.04866410419344902,
    0.10932003706693649, 0.0011576510732993484, 0.01982787251472473, 0.049605630338191986, -0.06269362568855286, 0.11516678333282471, -0.035630181431770325, 0.04641134291887283,
    0.0060861194506287575, 0.13459131121635437, -0.1570996195077896, 0.0026086692232638597, 0.05381655693054199, -0.013247168622910976, 0.3111296594142914, 0.04624316468834877,
    0.14670082926750183, -0.1296035647392273, -0.09124846011400223, -0.2799934446811676, -0.0730460062623024, 0.028934296220541, -0.007824582979083061, 0.16319112479686737,
    0.11999090760946274, -0.12896862626075745, 0.10028906911611557, -0.0156759824603796, -0.011188337579369545, 0.15337669849395752, -0.07500627636909485, -0.033699728548526764,
    -0.016290804371237755, -0.040129438042640686, 0.020773867145180702, 0.08428564667701721, -0.026112880557775497, -0.10123488306999207, -0.025751858949661255, -0.11268778145313263,
    0.15649102628231049, -0.032044559717178345, 0.3655830919742584, -0.016739491373300552, -0.08078302443027496, 0.03722044453024864, -0.002015970414504409, 0.0043522366322577,
    -0.10466388612985611, -0.0697319507598877, -0.26718175411224365, -0.031001189723610878, 0.09084608405828476, 0.1396760195493698, -0.2072802037000656, -0.018628232181072235,
    -0.0008346998947672546, -0.11629107594490051, 0.06512297689914703, 0.029778964817523956, 0.09112627059221268, -0.02752029336988926, -0.2108573317527771, -0.14059016108512878,
    0.019723637029528618, -0.0008260757313109934, 0.1960921734571457, -0.25161421298980713, -0.10550469160079956, 0.0034361183643341064, -0.1213405504822731, -0.13096962869167328,
    0.25079473853111267, 0.08474168926477432, 0.043742526322603226, -0.11973880231380463, -0.05551762133836746, 0.07214642316102982, -0.004366426263004541, -0.0046853250823915005,
    0.13980603218078613, -0.12872329354286194, -0.05779452621936798, -0.41615381836891174, 0.12729834020137787, -0.07044791430234909, -0.0007810259703546762, -0.08352886885404587,
    -0.017567593604326248, 0.022951064631342888, 0.1853654831647873, -0.005050932057201862, -0.014224877581000328, 0.011680598370730877, -0.07059790194034576, 0.12424802780151367,
    -0.18353863060474396, -0.0008206139318645, 0.3859555721282959, -0.2410356104373932, 0.026319317519664764, 0.08794700354337692, -0.021989447996020317, 0.33719512820243835,
    0.03051213175058365, 0.20939341187477112, -0.04925381392240524, 0.1991298943758011, 0.026561442762613297, 0.07425916194915771, -0.13586170971393585, -0.3686090111732483,
    -0.05411386489868164, 0.1344175934791565, 0.035719119012355804, -0.07197459042072296, -0.01798846758902073, 0.047660019248723984, -0.03394489735364914, -0.1995927095413208,
    -0.04472687095403671, -0.1312352418899536, 0.10467370599508286, 0.006581156514585018, -0.10575626790523529, 0.08087678253650665, 0.0032678102143108845, -0.009234867990016937,
    0.026423638686537743, 0.03681545704603195, -0.08613178133964539, 0.029581356793642044, 0.07330240309238434, 0.008285491727292538, 0.010711371898651123, 0.10934066772460938,
    0.18388809263706207, -0.006503721699118614, -0.17889617383480072, -0.018612004816532135, 0.19547595083713531, 0.03679230809211731, -0.1654781699180603, 0.15895822644233704,
    -0.022886477410793304, -0.061768099665641785, -0.07831797748804092, -0.11051799356937408, 0.010673370212316513, 0.1894831657409668, 0.31784123182296753, 0.021159056574106216,
    0.03890237584710121, -0.06530708819627762, -0.26451006531715393, -0.012141654267907143, 0.1452685445547104, 0.1072184294462204, 0.034020133316516876, -0.07779712975025177,
    -0.002855624072253704, -0.00734320655465126, 0.0748135894536972, -0.041133586317300797, -0.05831463634967804, 0.031542520970106125, 0.06579460948705673, 0.05683533102273941,
    0.0756765604019165, -0.18290077149868011, -0.31586936116218567, -0.04819031432271004, -0.07329833507537842, -0.03342565521597862, -0.12627013027668, -0.005642404779791832,
    -0.0929543599486351, -0.0238417349755764, -0.08983984589576721, -0.014582926407456398, -0.08495093882083893, 0.2423817664384842, -0.19849713146686554, 0.03567704185843468,
    -0.09979940205812454, -0.05742630362510681, 0.03747249394655228, -0.03008829429745674, -0.01857719197869301, 0.008453317917883396, -0.2842057943344116, -0.04595884680747986,
    0.1801881641149521, 0.08018577843904495, 0.12889748811721802, 0.024272171780467033, 0.0012308468576520681, 0.05450678989291191, -0.006458306685090065, -0.07644136250019073,
    0.05475917086005211, 0.005327555816620588, -0.0014469627058133483, 0.16344688832759857, 0.16897976398468018, -0.01094682514667511, 0.08537904918193817, -0.03945933282375336,
    0.11555033177137375, -0.08497906476259232, -0.20239855349063873, 0.3460623621940613, -0.025727298110723495, 0.04520460218191147, -0.00674785953015089, -0.13973739743232727,
    -0.029811255633831024, 0.13182394206523895, -0.09038221836090088, -0.04329626262187958, 0.10349967330694199, -0.035851139575242996, -0.016743700951337814, 0.1266775280237198,
    -0.003670591628178954, -0.15214543044567108, -0.07342170178890228, 0.02613472379744053, 0.003580693621188402, -0.03971417248249054, 0.0823042169213295, 0.25140756368637085,
    -0.07119397073984146, 0.15180081129074097, 0.06247879937291145, 0.021728578954935074, 0.013120707124471664, 0.00704974727705121, -0.473984032869339, -0.16482244431972504,
    -0.035752277821302414, 0.2630888521671295, 0.13222827017307281, -0.1307457834482193, 0.04311083257198334, -0.03284245729446411, -0.006850640755146742, -0.1522759050130844,
    0.003042703028768301, 0.032040610909461975, -0.046618759632110596, -0.01723378337919712, 0.2582460641860962, -0.043919164687395096, 0.0009198692860081792, -0.11271728575229645,
    -0.32410526275634766, 0.1119605079293251, -0.08483444154262543, 0.10080733895301819, -0.04944208636879921, 0.08295497298240662, -0.11481420695781708, -0.029217710718512535,
    0.11342456936836243, -0.14948268234729767, -0.04296986758708954, 0.0511016771197319, 0.09105662256479263, -0.07748711854219437, -0.11605680733919144, 0.29740798473358154,
    -0.06142334267497063, 0.12336552888154984, -0.08554305881261826, 0.3105196952819824, 0.13558776676654816, 0.031019479036331177, -0.24182166159152985, -0.20386019349098206,
    -0.2851860821247101, 0.15215426683425903, -0.1458255797624588, 0.022527644410729408, 0.05466681346297264, 0.1281662881374359, -0.050682615488767624, -0.07814019918441772,
    -0.0454176627099514, -0.09117133170366287, -0.10785442590713501, -0.04685336351394653, 0.0196510162204504, 0.028019897639751434, 0.019161714240908623, 0.08517738431692123,
    0.14399288594722748, -0.04275446757674217, 0.19001828134059906, 0.027653345838189125, 0.010207654908299446, -0.0010615524370223284, 0.1250152885913849, 0.06864923983812332,
    -0.06546415388584137, 0.12755811214447021, 0.07689886540174484, -0.022935612127184868, -0.08469115942716599, 0.3008030652999878, -0.05398359149694443, 0.014767439104616642,
    -0.020519260317087173, -0.024712229147553444, 0.07687632739543915, 0.08277051150798798, -0.23029771447181702, -0.16405196487903595, 0.0796404778957367, -0.13330745697021484,
    0.09087759256362915, 0.2254667729139328, 0.00015917685232125223, -0.01815236359834671, 0.02565756067633629, -0.2576088309288025, -0.04856673255562782, -0.15526160597801208,
    -0.22661787271499634, -0.016225473955273628, 0.0038038829807192087, 0.054488033056259155, 0.255501389503479, 0.019492901861667633, -0.011245135217905045, -0.04115092009305954,
    0.15552526712417603, -0.09006516635417938, 0.18048569560050964, -0.16099397838115692, 0.07982470840215683, 0.06441942602396011, 0.02536802366375923, -0.04240156337618828,
    0.035158004611730576, -0.017686540260910988, -0.1701786369085312, -0.06773235648870468, 0.0035793527495115995, 0.027144959196448326, 0.054903510957956314, -0.32623541355133057,
    -0.0671166256070137, 0.064895398914814, -0.3502633273601532, 0.4870402216911316, 0.026791458949446678, -0.08402174711227417, 0.13659732043743134, -0.08748245239257812,
    -0.1517568826675415, -0.12198448181152344, 0.09019411355257034, -0.06250292807817459, -0.09973642230033875, 0.00267134141176939, -0.08859114348888397, 0.09599988907575607,
    0.1267094612121582, 0.071971595287323, -0.17700745165348053, 0.044960394501686096, -0.2944376468658447, 0.06361443549394608, 0.04049820452928543, -0.12089968472719193,
    -0.02707473374903202, 0.03361472114920616, 0.028339188545942307, -0.11286035925149918, 0.12201527506113052, -0.1021336019039154, 0.03850993514060974, -0.055601488798856735,
    0.022447142750024796, 0.0998750627040863, -0.23421697318553925, -0.07147647440433502, -0.07572927325963974, 0.08576354384422302, 0.12941502034664154, -0.05412329360842705,
    0.032908011227846146, 0.2876855134963989, 0.2050730139017105, -0.02309371903538704, -0.06225709617137909, 0.007029718719422817, 0.20430459082126617, 0.22220732271671295,
    -0.1760137677192688, 0.1381942480802536, -0.01929018460214138, 0.21406590938568115, 0.1232113167643547, -0.15359674394130707, 0.01716737635433674, 0.08891389518976212,
    -0.402759313583374, -0.20855093002319336, 0.08874448388814926, -0.003781090257689357, -0.024255940690636635, 0.057547636330127716, 0.10676337033510208, -0.0067079453729093075,
    0.029851121827960014, 0.0034908296074718237, -0.03777012974023819, -0.10689909756183624, 0.050525274127721786, -0.09845571964979172, -0.13713742792606354, 0.06641147285699844,
    0.11442088335752487, 0.12991560995578766, -0.08193330466747284, 0.04946930706501007, 0.09200393408536911, 0.02303595095872879, -0.024953991174697876, -0.1649361103773117,
    -0.13385987281799316, -0.07457801699638367, -0.10268249362707138, -0.026941867545247078, -0.09726425260305405, 0.07851379364728928, -0.18531149625778198, -0.03924601525068283,
    0.015252826735377312, 0.1256246268749237, 0.0036234157159924507, 0.23867616057395935, -0.09237180650234222, -0.166759192943573, 0.3127148151397705, -0.176561638712883,
    0.19222252070903778, 0.13376082479953766, 0.0059630065225064754, -0.17863225936889648, -0.0514376275241375, 0.09658022224903107, -0.034133072942495346, -0.08886881172657013,
    -0.21345020830631256, 0.004701555240899324, -0.00011584805906750262, -0.26723501086235046, 0.020580334588885307, 0.09909628331661224, 0.0065212976187467575, -0.07683812081813812,
    0.08230423927307129, -0.11286155879497528, 0.1569511443376541, -0.14809879660606384, 0.004218669608235359, -0.07810968905687332, 0.06037702411413193, 0.0794537216424942,
    -0.027262939140200615, -0.028123702853918076, 0.14481154084205627, 0.030004149302840233, -0.044281214475631714, 0.005258645862340927, -0.05994823947548866, 0.3871293365955353,
    -0.18908075988292694, 0.0033977485727518797, -0.22801849246025085, 0.047500696033239365, 0.017255540937185287, -0.06502750515937805, -0.057050399482250214, -0.25316616892814636,
    -0.016874104738235474, -0.12457406520843506, 0.05697045847773552, -0.11311241239309311, -0.07288423180580139, 0.09840800613164902, 0.06973817944526672, 0.2043633908033371,
    0.364793986082077, 0.09158636629581451, -0.23996368050575256, -0.046639151871204376, 0.2282429188489914, -0.19934645295143127, 0.040028370916843414, 0.034537240862846375,
    -0.04207581654191017, -0.08554878830909729, -0.03132612258195877, -0.11605995148420334, -0.12650740146636963, -0.1256580948829651, 0.08914123475551605, 0.1285875141620636,
    0.05566759780049324, 0.04934459179639816, -0.20563098788261414, 0.14255891740322113, 0.02721095085144043, 0.015253069810569286, 0.02835184335708618, 0.030628569424152374,
    -0.018609652295708656, -0.22045142948627472, 0.07297652959823608, -0.006893152836710215, -0.01513693854212761, 0.04024481028318405, -0.11809341609477997, -0.14041757583618164,
    -0.19403013586997986, -0.08405707776546478, -0.17528080940246582, -0.27562782168388367, 0.2634328603744507, -0.021308107301592827, 0.1858913004398346, 0.08809027075767517,
    0.22587095201015472, -0.35500529408454895, -0.1486511081457138, -0.005909791216254234, -0.05592026934027672, 0.05160072073340416, -0.18850460648536682, 0.059600863605737686,
    -0.03971792384982109, -0.09250020980834961, 0.05686003342270851, 0.005203861277550459, -0.0662323385477066, -0.11694066226482391, 0.008132520131766796, -0.2343253642320633,
    0.14527390897274017, -0.06698166579008102, -0.05893600732088089, 0.09146606177091599, 0.2079252153635025, 0.016127318143844604, 0.0657840222120285, 0.2114097774028778,
    -0.12033119797706604, 0.06261268258094788, -0.05345630645751953, -0.1235443726181984, -0.23803472518920898, 0.030244167894124985, -0.1256362497806549, 0.026284443214535713,
    -0.004998466931283474, 0.17047826945781708, 0.08764182776212692, 0.032750315964221954, -0.0008086601737886667, -0.12917299568653107, 0.10129614919424057, -0.03241709992289543,
    0.07222262024879456, 0.0313275009393692, 0.2803272008895874, -0.12750490009784698, 0.0006510534440167248, 0.133764386177063, 0.06524517387151718, -0.22593307495117188,
    -0.03620506450533867, 0.028040435165166855, 0.06843753159046173, -0.10756029188632965, -0.06074154004454613, 0.06576093286275864, -0.04393715411424637, 0.0164012610912323,
    0.22124873101711273, -0.06836403906345367, -0.10860175639390945, 0.2659800350666046, 0.0017645575571805239, 0.07138029485940933, 0.03029348887503147, -0.04051933437585831,
    -0.015045411884784698, 0.002581597538664937, 0.07522442936897278, -0.054050177335739136, -0.00524390023201704, 0.04268810153007507, -0.04016377404332161, -0.2469218224287033,
    -0.015905672684311867, -0.10118819773197174, 0.14185506105422974, -0.49175208806991577, 0.2911258339881897, -0.05680717155337334, -0.12976492941379547, -0.12411082535982132,
    -0.16129717230796814, 0.1264009177684784, 0.014315275475382805, -0.13482128083705902, 0.022538326680660248, -0.11864419281482697, -0.04052502661943436, 0.04374271258711815,
    0.3435385227203369, 0.059165582060813904, 0.18246757984161377, -0.1437654197216034, -0.08901561051607132, 0.13964036107063293, 0.006192438770085573, 0.049954578280448914,
    -0.042786192148923874, 0.12976177036762238, -0.32973533868789673, -0.09403642266988754, -0.14214988052845, 0.11878412216901779, 0.12766875326633453, -0.2335749715566635,
    -0.010384961031377316, -0.001291888882406056, 0.0008263880736194551, -0.019160879775881767, 0.07567891478538513, -0.042650606483221054, 0.15895536541938782, 0.003382225753739476,
    -0.03370266035199165, 0.029715776443481445, -0.09729722887277603, -0.016254236921668053, 0.18706461787223816, -0.045061271637678146, -0.12419746071100235, -0.4303702712059021,
    -0.14555193483829498, 0.043271176517009735, -0.01831628940999508, -0.19572611153125763, 0.17676809430122375, 0.30540940165519714, -0.18067507445812225, -0.13591572642326355,
    0.14224329590797424, 0.2942443788051605, -0.0771048441529274, 0.052599404007196426, -0.24739813804626465, 0.08758166432380676, -0.012417678721249104, 0.06459111720323563,
    -0.012068013660609722, 0.0663493350148201, -0.13600552082061768, 0.07312850654125214, 0.03540283814072609, -0.05307020992040634, 0.00658700056374073, 0.04204809293150902,
    0.1450069546699524, -0.1145818904042244, 0.12049014121294022, -0.09944968670606613, 0.020027590915560722, -0.0009596173767931759, 0.026476696133613586, -0.2346847653388977,
    -0.11516812443733215, 0.08657214045524597, -0.23753459751605988, -0.06369121372699738, 0.026941487565636635, 0.06264030188322067, -0.10149799287319183, -0.03597255051136017,
    -0.10741918534040451, 0.07671012729406357, 0.11725148558616638, -0.004434450063854456, -0.20287224650382996, -0.07877826690673828, -0.11278747022151947, 0.04212883114814758,
    -0.023930968716740608, -0.046652358025312424, 0.1146780326962471, -0.08666139841079712, -0.039361827075481415, -0.19132490456104279, 0.0336761511862278, -0.02593945525586605,
    0.14104197919368744, 0.005371279548853636, 0.02450689673423767, 0.09496892988681793, 0.2817073464393616, 0.09264208376407623, -0.05199912562966347, 0.004604818299412727,
    0.20213396847248077, -0.0960148349404335, -0.2248394936323166, -0.14809314906597137, -0.11023092269897461, 0.13311220705509186, -0.009844408370554447, 0.03826696053147316,
    -0.041400134563446045, -0.1278558075428009, -0.15349629521369934, -0.040032707154750824, 0.006565259303897619, -0.05709265172481537, 0.004353181459009647, -0.1569468379020691,
    0.1401798576116562, -0.0995127335190773, 0.36005899310112, -0.06987737119197845, 0.17584587633609772, -0.10363715142011642, -0.0672350823879242, 0.23978765308856964,
    0.01945943385362625, 0.23908743262290955, 0.009888002648949623, -0.053420357406139374, 0.05139632523059845, 0.12957875430583954, -0.07858872413635254, 0.11808967590332031,
    0.36452338099479675, -0.1929326355457306, -0.044211532920598984, -0.007305046543478966, -0.07631559669971466, 0.19830574095249176, -0.028134064748883247, 0.038949400186538696,
    -0.005381481721997261, -0.17954280972480774, -0.1629525125026703, 0.3594348430633545, 0.24554532766342163, 0.29248470067977905, 0.05605556070804596, -0.08639536052942276,
    0.03563596308231354, 0.0145313935354352, 0.3013473153114319, 0.01236498262733221, -0.0413934625685215, -0.017639284953475, 0.10412326455116272, -0.06577951461076736,
    -0.07389988005161285, 0.03785601258277893, -0.06531302630901337, -0.02293662168085575, 0.1731688380241394, -0.0868593156337738, 0.17734123766422272, 0.03693779930472374,
    -0.19361817836761475, 0.13472503423690796, -0.06518886983394623, 0.19560304284095764, 0.26348525285720825, 0.15793240070343018, -0.014443372376263142, -0.061819687485694885,
    -0.038479652255773544, 0.1707964539527893, -0.0499563030898571, -0.014564882963895798, -0.12341748178005219, 0.05229917913675308, 0.0481535904109478, -0.17580261826515198,
    0.06353043764829636, 0.12739971280097961, 0.051489099860191345, 0.15624316036701202, 0.07959789037704468, 0.05022506043314934, 0.18649305403232574, -0.12314240634441376,
    0.04979521036148071, 0.013065341860055923, -0.35491517186164856, 0.0895509123802185, -0.18302369117736816, 0.004875666927546263, 0.14731527864933014, 0.2733689546585083,
    -0.020526235923171043, -0.0654313787817955, -0.38600853085517883, 0.03248805180191994, 0.15331360697746277, 0.005440284498035908, 0.1046953871846199, 0.021493231877684593,
    -0.22486789524555206, -0.025125062093138695, 0.03704629838466644, -0.014089768752455711, -0.12681765854358673, 0.03262035548686981, -0.08288626372814178, 0.16148540377616882,
    0.10193408280611038, 0.26223471760749817, 0.14983956515789032, -0.4229657053947449, -0.06877598911523819, 0.18424303829669952, 0.11303044110536575, -0.076934315264225,
    0.1853012889623642, -0.035250939428806305, 0.13304515182971954, 0.20194275677204132, 0.13113851845264435, 0.19713672995567322, 0.015543319284915924, -0.08317521214485168,
    -0.023182662203907967, -0.08621853590011597, -0.09660489857196808, -0.08717319369316101, -0.10249456763267517, -0.07304657995700836, -0.0570499561727047, -0.030231835320591927,
    -0.031230909749865532, -0.08121789991855621, -0.060545261949300766, 0.009465055540204048, -0.07458414882421494, -0.03468320146203041, 0.0334380641579628, 0.483900249004364,
    0.012745773419737816, 0.06667260080575943, 0.027057716622948647, 0.48140206933021545, -0.20271152257919312, -0.21700027585029602, 0.05545908585190773, 0.271379679441452,
    0.037523381412029266, 0.07215246558189392, 0.04393496736884117, -0.0994098111987114, 0.09127622842788696, 0.05969836190342903, -0.03447098284959793, 0.14336469769477844,
    0.47704577445983887, -0.2292337566614151, -0.16844171285629272, -0.09097909927368164, 0.07575229555368423, -0.28318777680397034, -0.02358967810869217, 0.08107034116983414,
    0.012101411819458008, 0.11379878968000412, 0.12231434136629105, 0.18257774412631989, 0.1911708563566208, 0.19760870933532715, 0.05339112877845764, 0.2265847772359848,
    0.05463496223092079, 0.022351190447807312, 0.010758315213024616, -0.025938432663679123, -0.005475861486047506, -0.2010989785194397, -0.1239725798368454, 0.043722476810216904,
    -0.0929306223988533, -0.1447330266237259, 0.1138656735420227, 0.03727428987622261, -0.03780180215835571, 0.03838921710848808, -0.10101111233234406, 0.16099238395690918,
    -0.17694027721881866, -0.09542583674192429, -0.04950319975614548, 0.1519172340631485, 0.29583513736724854, -0.37341389060020447, 0.28075361251831055, 0.11832671612501144,
    -0.14945253729820251, -0.3040233552455902, -0.12056435644626617, 0.062408871948719025, 0.06656559556722641, -0.07634490728378296, 0.08827211707830429, -0.0417952761054039,
    -0.024151764810085297, 0.1717817187309265, -0.08462800085544586, 0.01754806749522686, -0.009382580406963825, 0.006910446099936962, 0.1016835942864418, -0.010482181794941425,
    0.06454678624868393, 0.1090373620390892, 0.402512788772583, -0.09106657654047012, 0.11409028619527817, -0.017958424985408783, -0.18947835266590118, -0.26353031396865845,
    0.0015409942716360092, -0.011486043222248554, 0.1888047456741333, 0.011188489384949207, 0.2149537354707718, -0.16465890407562256, 0.047050636261701584, -0.03953291475772858,
    -0.01106016244739294, -0.04800381511449814, -0.04891885817050934, 0.06449519842863083, -0.03346782550215721, -0.047475822269916534, -0.15701837837696075, 0.07582443207502365,
    0.12751741707324982, 0.19530221819877625, 0.04301917180418968, -0.18669883906841278, 0.03616802766919136, -0.2792561948299408, 0.04089176654815674, -0.3053957521915436,
    -0.1215519830584526, 0.10800876468420029, 0.022446773946285248, -0.15019738674163818, -0.2835991382598877, 0.028314368799328804, 0.0024291498120874166, -0.009909030981361866,
    0.10326708853244781, -0.14331082999706268, -0.039831504225730896, 0.27082812786102295, -0.09629801660776138, 0.0008054224890656769, -0.042025577276945114, 0.11270115524530411,
    0.08494345843791962, -0.3350541889667511, 0.17790599167346954, -0.044299494475126266, 0.05716167017817497, 0.04995384439826012, 0.03710895776748657, -0.5396785736083984,
    0.016619455069303513, 0.10612194985151291, -0.25701454281806946, -0.06733828037977219, -0.15464797616004944, -0.2206827700138092, 0.1541893035173416, -0.2522534132003784,
    -0.14859521389007568, -0.16726095974445343, 0.11931867152452469, 0.28806358575820923, -0.09534813463687897, 0.10296978056430817, 0.027298877015709877, -0.04498958960175514,
    0.491218239068985, -0.27965494990348816, 0.06227009743452072, -0.12841804325580597, 0.007879947312176228, -0.07845848798751831, 0.03362039476633072, 0.110007144510746,
    0.0014932084595784545, -0.051764436066150665, 0.23408617079257965, 0.17730437219142914, 0.0459115169942379, -0.14523161947727203, -0.04253373667597771, 0.2192489504814148,
    -0.08731191605329514, 0.1136767566204071, -0.24181818962097168, -0.16035734117031097, -0.03961336612701416, 0.09044181555509567, -0.05493903532624245, 0.028770819306373596,
    -0.064638651907444, 0.18312402069568634, -0.011739660985767841, -0.03992477059364319, 0.047370366752147675, -0.03680719435214996, -0.04004601016640663, -0.018240777775645256,
    0.2895059585571289, 0.036086928099393845, -0.05121005326509476, -0.16388127207756042, 0.2857549488544464, -0.09695161134004593, -0.2322368025779724, -0.16180792450904846,
    -0.0653529092669487, 0.07299511879682541, 0.10331108421087265, 0.04138542711734772, -0.07308273017406464, -0.06354647874832153, -0.016011299565434456, 0.15627102553844452,
    -0.023358022794127464, -0.03026438131928444, -0.059332095086574554, -0.1289227157831192, -0.05151473730802536, 0.0033609967213124037, -0.08445004373788834, -0.13779044151306152,
    0.10091402381658554, 0.05180465430021286, -0.4296877980232239, 0.057649340480566025, -0.18627974390983582, 0.03916650637984276, 0.08316103368997574, 0.2146766185760498,
    -0.08001790940761566, 0.017971288412809372, -0.09353924542665482, 0.019754832610487938, 0.0057179564610123634, -0.061733707785606384, 0.09481782466173172, -0.0391714870929718,
    -0.10780306160449982, -0.16735012829303741, 0.010149329900741577, 0.012889465317130089, -0.045503269881010056, -0.1333729475736618, -0.021406956017017365, 0.13769842684268951,
    0.164301335811615, -0.060040365904569626, 0.275020956993103, 0.0026523214764893055, -0.06194202974438667, 0.2110225260257721, 0.08624713122844696, -0.1999891847372055,
    -0.062433090060949326, 0.20193633437156677, 0.04968864843249321, -0.17012286186218262, -0.3085678517818451, -0.073748379945755, 0.06642746925354004, 0.010722462087869644,
    -0.07423556596040726, 0.06492310762405396, -0.06036077439785004, -0.25103265047073364, -0.12106337398290634, 0.03677133470773697, 0.0006315622013062239, -0.05155663192272186,
    -0.05805366113781929, -0.14056870341300964, -0.1263730674982071, 0.0025367483031004667, -0.018411697819828987, -0.010861344635486603, -0.02823527716100216, 0.20278562605381012,
    0.12423089891672134, -0.140421524643898, -0.16037538647651672, -0.5525285005569458, 0.256113201379776, -0.2008056491613388, -0.07413332164287567, -0.2098446637392044,
    0.014352128840982914, 0.18103618919849396, -0.02345617488026619, 0.28242358565330505, 0.07477834075689316, -0.0599101260304451, 0.04922483488917351, -0.221173956990242,
    0.4027727544307709, -0.027994973585009575, -0.06002223491668701, -0.11747179180383682, -0.07334574311971664, 0.036239296197891235, -0.00800338201224804, 0.17909879982471466,
    0.07213125377893448, -0.023105736821889877, 0.15516775846481323, -0.17219609022140503, 0.18111971020698547, -0.22747334837913513, 0.04062280431389809, -0.11695627123117447,
    -0.09788933396339417, 0.017333319410681725, -0.19712324440479279, 0.07533470541238785, 0.025767367333173752, -0.10826446861028671, -0.03290742263197899, 0.11867541819810867,
    0.07116369158029556, -0.11281593143939972, 0.024432197213172913, -0.0008815757464617491, -0.2234511375427246, 0.011005577631294727, 0.04464230313897133, -0.2937411665916443,
    0.35510703921318054, -0.01500900462269783, -0.12607359886169434, -0.1531299352645874, 0.2361002117395401, 0.3289102017879486, 0.05452651530504227, -0.07735908776521683,
    -0.11428104341030121, 0.35742104053497314, 0.13065452873706818, 0.04198157414793968, -0.06226912513375282, 0.030271783471107483, -0.018752459436655045, -0.04237138479948044,
    -0.033467475324869156, -0.03708948194980621, -0.058718886226415634, 0.22325550019741058, -0.056407731026411057, -0.09574730694293976, -0.1699604094028473, 0.1455501765012741,
    0.05669990926980972, 0.038383062928915024, 0.34590378403663635, 0.029575131833553314, -0.11839410662651062, -0.02377476543188095, -0.23216459155082703, -0.15542998909950256,
    -0.049136001616716385, 0.056116990745067596, -0.06920953094959259, 0.03544379770755768, -0.1362438201904297, -0.06276823580265045, 0.15340471267700195, -0.03542374074459076,
    -0.0021173881832510233, -0.10896219313144684, 0.03345927223563194, 0.03670181334018707, -0.06428262591362, 0.06220177933573723, 0.05746961385011673, 0.15761332213878632,
    -0.0013701970456168056, -0.03750265762209892, 0.1734786182641983, 0.161333367228508, -0.07017489522695541, 0.28239327669143677, -0.01543385162949562, -0.14118851721286774,
    0.0036623901687562466, -0.22106021642684937, 0.025063632056117058, -0.06615833938121796, 0.046108487993478775, -0.08025830239057541, -0.06061827391386032, 0.002883319742977619,
    0.004199950955808163, -0.1037498340010643, -0.0666678249835968, 0.14123080670833588, -0.13241718709468842, -0.033869560807943344, -0.006556784734129906, 0.011384052224457264,
    -0.029693786054849625, -0.26954343914985657, -0.04943488910794258, -0.038368839770555496, -0.04795392230153084, -0.04405844211578369, -0.09803928434848785, 0.163667693734169,
    0.14819367229938507, -0.0645425096154213, 0.050761282444000244, 0.42883217334747314, 0.16919049620628357, -0.001449184725061059, -0.036896001547575, 0.23494543135166168,
    -0.05410567671060562, 0.153023824095726, -0.05720492824912071, 0.21037302911281586, 0.17714908719062805, 0.02575945481657982, -0.21043099462985992, 0.15503424406051636,
    0.33635208010673523, -0.07942374795675278, 0.017252231016755104, -0.0753423348069191, 0.2525407373905182, 0.03687873110175133, -0.00485837459564209, 0.109200619161129,
    -0.07619164139032364, -0.018632113933563232, 0.4246625602245331, -0.27439460158348083, 0.21417072415351868, 0.09917430579662323, 0.014785613864660263, -0.24719837307929993,
    -0.15016989409923553, 0.029714401811361313, 0.16579590737819672, -0.1618310511112213, 0.02678230218589306, -0.051783911883831024, -0.16963797807693481, -0.16629819571971893,
    0.17316952347755432, -0.020261654630303383, -0.050983041524887085, -0.005559043493121862, -0.11327459663152695, 0.06254305690526962, -0.05898303911089897, -0.2055666297674179,
    0.22981518507003784, -0.10931980609893799, -0.07135873287916183, 0.05669334903359413, 0.22123433649539948, -0.051186107099056244, 0.05472404509782791, 0.16325639188289642,
    0.10878382623195648, 0.07670632749795914, 0.0990295559167862, 0.0717548057436943, -0.04533619433641434, -0.1484403759241104, -0.011792238801717758, -0.08802571892738342,
    -0.0017514951759949327, -0.1717473417520523, 0.06054060906171799, 0.24846358597278595, 0.009809445589780807, -0.051982369273900986, 0.08218327164649963, -0.08862677961587906,
    0.03626590222120285, 0.08489472419023514, -0.2918988764286041, -0.013833127915859222, -0.14371773600578308, 0.04427885636687279, 0.07142497599124908, 0.1478189378976822,
    -0.04545941203832626, -0.06276147812604904, -0.12043102830648422, 0.028765734285116196, -0.031307704746723175, 0.146935373544693, -0.11914560198783875, 0.023447131738066673,
    -0.03356178477406502, 0.07283775508403778, -0.019413156434893608, 0.039095375686883926, 0.11587776988744736, -0.005569517612457275, 0.07209646701812744, 0.26784080266952515,
    0.10060317069292068, 0.11194151639938354, 0.020835919305682182, -0.036419253796339035, -0.10334253311157227, -0.1784166842699051, -0.06535744667053223, -0.17856189608573914,
    0.14480072259902954, -0.254703551530838, 0.09523535519838333, -0.13914267718791962, 0.20713044703006744, -0.28793174028396606, 0.007102055475115776, 0.003527028253301978,
    -0.11294066160917282, -0.032616667449474335, -0.007443620357662439, 0.007119929883629084, -0.11035951972007751, 0.028272300958633423, -0.05543427914381027, 0.049703363329172134,
    0.015719255432486534, -0.16169926524162292, 0.08170514553785324, -0.0021013205405324697, -0.1182456836104393, -0.02012028358876705, -0.08330897986888885, -0.39753222465515137,
    0.09071650356054306, 0.21807928383350372, 0.2645871937274933, 0.2739766240119934, 0.15228328108787537, 0.07430218905210495, 0.12996333837509155, 0.2360665202140808,
    -0.10864562541246414, 0.0011188265634700656, -0.024519821628928185, 0.06584632396697998, -0.10891558229923248, 0.004939697217196226, -0.30377519130706787, 0.23749154806137085,
    0.23745249211788177, -0.035941846668720245, 0.04979025945067406, 0.14448045194149017, -0.21694248914718628, 0.18219365179538727, -0.11229055374860764, 0.14174379408359528,
    -0.08619026839733124, 0.030401302501559258, 0.17833109200000763, 0.023757660761475563, 0.07549256086349487, 0.175278902053833, 0.02533792145550251, 0.12677264213562012,
    0.061216242611408234, -0.07810957729816437, -0.12686318159103394, -0.08304086327552795, -0.02722930908203125, -0.14832329750061035, -0.14067809283733368, -0.060625698417425156,
    0.12495236843824387, 0.11324280500411987, 0.020428355783224106, -0.04971008375287056, 0.1851835697889328, -0.02939566783607006, -0.024090053513646126, -0.06399231404066086,
    0.05747763067483902, -0.10592886060476303, -0.11739924550056458, 0.23055437207221985, 0.16810084879398346, -0.43760111927986145, -0.0403376929461956, 0.07189071178436279,
    -0.020284058526158333, -0.02046908251941204, 0.18639416992664337, 0.050502803176641464, 0.10698222368955612, -0.051426466554403305, -0.06395624577999115, -0.05149010941386223,
    0.025258760899305344, -0.09631232172250748, -0.08003915101289749, 0.24192161858081818, -0.06377724558115005, -0.0943043902516365, 0.2442937046289444, -0.13828381896018982,
    -0.0616622231900692, 0.29682743549346924, 0.20758767426013947, -0.15081161260604858, -0.031210416927933693, 0.1349238157272339, -0.07187934964895248, -0.09551689773797989,
    0.004211214371025562, 0.03906286507844925, 0.05743670091032982, -0.04672713950276375, -0.06304698437452316, 0.09766241908073425, 0.2594035565853119, -0.04496319591999054,
    0.13430893421173096, -0.11792867630720139, -0.01751069538295269, 0.17404033243656158, 0.07594183832406998, -0.0813639834523201, -0.027437841519713402, 0.12430799752473831,
    0.10908803343772888, -0.027515817433595657, 0.15704886615276337, -0.12769368290901184, -0.08634019643068314, 0.3198806345462799, -0.1193937137722969, -0.14597287774085999,
    0.044082798063755035, -0.1213097870349884, 0.05237724259495735, -0.06154152378439903, -0.2844850420951843, -0.25537002086639404, 0.031187616288661957, -0.005310658365488052,
    -0.06603755801916122, -0.042402684688568115, -0.10467948764562607, -0.11878612637519836, -0.11770591139793396, 0.1609950214624405, -0.07732696831226349, 0.12469010055065155,
    0.008435700088739395, -0.28580132126808167, 0.03125381097197533, -0.006470200605690479, 0.045530691742897034, -0.04281342774629593, 0.0017760315677151084, 0.4313937723636627,
    0.008789126761257648, 0.02485559694468975, -0.20173096656799316, -0.4626028835773468, -0.02997860684990883, 0.3333231806755066, 0.1650947481393814, 0.02749335579574108,
    0.029963567852973938, -0.021508878096938133, 0.07941722869873047, -0.01361828949302435, -0.020599711686372757, 0.18402855098247528, -0.10147125273942947, -0.09843417257070541,
    0.05159599706530571, -0.2239423394203186, -0.04911090061068535, 0.08755790442228317, -0.0029716510325670242, -0.1253165453672409, -0.030808741226792336, -0.045020539313554764,
    0.045189760625362396, -0.009787466377019882, -0.13687925040721893, 0.24642199277877808, -0.30743202567100525, 0.11495290696620941, -0.025847427546977997, -0.1229943335056305,
    -0.0434400700032711, -0.004048456437885761, -0.3897921144962311, -0.12378425896167755, 0.012794946320354939, -0.11660365760326385, 0.08280616253614426, -0.02103864774107933,
    -0.1535080075263977, -0.21481572091579437, -0.12432932108640671, -0.05111270770430565, 0.010482524521648884, 0.041165951639413834, 0.0087802829220891, -0.042823780328035355,
    -0.20382319390773773, -0.08020704984664917, -0.03571281582117081, -0.027084819972515106, 0.15821664035320282, 0.17089740931987762, 0.06579358130693436, -0.08602724969387054,
    -0.028183361515402794, -0.22020521759986877, 0.049505844712257385, 0.045183777809143066, 0.07512857764959335, -0.0013815723359584808, 0.03570110350847244, 0.03432507812976837,
    -0.00819117110222578, -0.12047245353460312, 0.05536962300539017, 0.10945767909288406, -0.09139703214168549, 0.015135252848267555, 0.14012345671653748, -0.0996197983622551,
    0.03251076489686966, 0.2459726631641388, -0.19173410534858704, -0.04607833921909332, -0.04892551526427269, 0.031025636941194534, 0.0014942673733457923, 0.0957159772515297,
    0.07394302636384964, 0.07287748903036118, 0.09701871126890182, -0.016265099868178368, -0.07970745116472244, 0.17401476204395294, 0.035198695957660675, -0.07025976479053497,
    0.05003342777490616, -0.1371089071035385, 0.015104507096111774, 0.047946494072675705, -0.028607327491044998, -0.05022710934281349, -0.08453623950481415, -0.1453237235546112,
    0.17959026992321014, -0.08525313436985016, 0.19168098270893097, -0.028879087418317795, -0.1193346232175827, -0.1888979971408844, -0.21965469419956207, -0.12963098287582397,
    0.030689677223563194, -0.05366886034607887, 0.042458295822143555, -0.07210046797990799, -0.24299032986164093, -0.23480208218097687, 0.058370985090732574, -0.06226683780550957,
    0.0812382772564888, 0.13704748451709747, -0.2711898386478424, 0.09088544547557831, -0.2206653654575348, 0.15423952043056488, 0.01683245413005352, 0.09664768725633621,
    -0.02841598354279995, -0.06770406663417816, -0.17509953677654266, 0.06178080290555954, 0.030699776485562325, -0.05979511886835098, 0.024242015555500984, -0.29572197794914246,
    0.08714129775762558, -0.08420468121767044, -0.08692188560962677, 0.06367003172636032, 0.050176847726106644, 0.294737309217453, 0.2995325028896332, -0.11519920825958252,
    0.05257529392838478, 0.13835321366786957, 0.00436827540397644, -0.023393835872411728, -4.7088869905564934e-05, 0.006659206002950668, -0.11071619391441345, -0.24112868309020996,
    -0.05572674423456192, -0.030814344063401222, 0.23404058814048767, 0.026567481458187103, 0.062391605228185654, -0.190348282456398, 0.036105263978242874, 0.11391158401966095,
    0.05581650137901306, 0.008179675787687302, -0.26898548007011414, 0.2711706757545471, -0.20203223824501038, -0.1708926409482956, 0.0203759353607893, -0.19355520606040955,
    -0.03419286012649536, 0.15084393322467804, -0.10509193688631058, -0.061621133238077164, -0.009229928255081177, 0.07191493362188339, -0.056720130145549774, 0.1724182516336441,
    -0.09083323180675507, 0.1551031619310379, -0.11069625616073608, 0.06695827096700668, -0.16003473103046417, 0.03864176571369171, -0.016361946240067482, -0.04973643273115158,
    -0.11808246374130249, -0.18545940518379211, -0.12373746186494827, -0.15512825548648834, 0.19960138201713562, 0.2002757489681244, -0.04151676222681999, 0.10322389751672745,
    -0.11573704332113266, 0.10233230143785477, -0.008658016100525856, 0.04826653376221657, 0.0338754840195179, -0.044472143054008484, 0.2091689109802246, 0.007829626090824604,
    0.08787164837121964, -0.027823522686958313, -0.0015994179993867874, 0.006024060770869255, 0.06196456775069237, 0.005802260711789131, 0.00961662083864212, -0.03228684142231941,
    0.009533400647342205, 0.17094923555850983, 0.07372786104679108, -0.014688367955386639, 0.11674414575099945, 0.024902135133743286, -0.24586132168769836, -0.036975689232349396,
    0.023776832967996597, -0.009698251262307167, 0.012105755507946014, -0.05229600518941879, 0.011157899163663387, 0.24721023440361023, 0.1238548532128334, 0.04023047536611557,
    0.05152186006307602, -0.03347279503941536, -0.04935353249311447, -0.0284256748855114, -0.03683137148618698, 0.025810953229665756, 0.03843163326382637, -0.2963511347770691,
    0.0830245092511177, -0.11795064806938171, -0.077255479991436, 0.20259027183055878, -0.09539289027452469, -0.32877659797668457, -0.24183818697929382, -0.1579289734363556,
    0.07637384533882141, -0.014920496381819248, -0.021183187142014503, 0.03931101784110069, -0.15672828257083893, -0.10077425837516785, 0.06461554765701294, 0.008125139400362968,
    0.22545675933361053, 0.04182782024145126, -0.17892783880233765, 0.021306820213794708, -0.06828492134809494, 0.05696890875697136, 0.08912698924541473, 0.055566105991601944,
    0.012063675560057163, -0.10197419673204422, 0.10192210972309113, -0.032506491988897324, -0.15699279308319092, -0.03232441842556, -0.02491454780101776, -0.058202579617500305,
    0.253827303647995, -0.02220185473561287, 0.2591663599014282, 0.33123114705085754, 0.10927256941795349, 0.19118475914001465, 0.055332593619823456, -0.10140326619148254,
    0.005065784323960543, 0.038095276802778244, 0.10078782588243484, 0.07536234706640244, -0.07157163321971893, 0.14507055282592773, -0.1001804769039154, 0.025073103606700897,
    -0.011061284691095352, 0.08115885406732559, -0.1851547807455063, -0.0065086474642157555, -0.10034918785095215, -0.19925107061862946, 0.12156341969966888, 0.04207617789506912,
    -0.014007962308824062, -0.013250304386019707, -0.024543892592191696, 0.15302927792072296, -0.19383306801319122, -0.31293413043022156, -0.0006300290115177631, 0.21163949370384216,
    0.048060718923807144, -0.01728721335530281, 0.1625613421201706, -0.018772810697555542, 0.03136545792222023, -0.03890351578593254, -0.2817913293838501, -0.09071085602045059,
    -0.07707220315933228, 0.01795380190014839, -0.043802134692668915, -0.006957387086004019, -0.010102160274982452, -0.04167601093649864, 0.04353446140885353, -0.10131007432937622,
    -0.31680575013160706, -0.06373442709445953, -0.03710491582751274, 0.13960163295269012, 0.2400393784046173, -0.1731584370136261, 0.040426645427942276, -0.009936731308698654,
    -0.02077481709420681, 0.10577764362096786, -0.10107807070016861, 0.06856819987297058, -0.015118081122636795, -0.09694519639015198, 0.15653416514396667, -0.04300113767385483,
    0.0386245995759964, 0.032566290348768234, -0.02156158909201622, 0.23222579061985016, -0.07775375247001648, 0.0426214300096035, 0.014805847778916359, -0.13878875970840454,
    -0.036362603306770325, 0.3006047308444977, 0.01645638793706894, 0.12531471252441406, -0.03343188762664795, -0.010521783493459225, -0.059401966631412506, 0.09043950587511063,
    0.06946676969528198, 0.07388950139284134, -0.17119750380516052, -0.03838272765278816, -0.10936528444290161, 0.08784333616495132, -0.1029411256313324, -0.031081613153219223,
    0.21777667105197906, -0.12879081070423126, 0.08056044578552246, -0.10429331660270691, -0.021954480558633804, -0.06048320233821869, 0.08734824508428574, -0.19082877039909363,
    0.062046829611063004, 0.1306409239768982, -0.12165500223636627, 0.08592355996370316, -0.15191209316253662, 0.3173708915710449, -0.33029040694236755, 0.005144741851836443,
    -0.011416877619922161, 0.03160163387656212, 0.011093756183981895, 0.19479350745677948, -0.18926191329956055, 0.013933058828115463, 0.02104264684021473, -0.0004495886678341776,
    0.1340978890657425, 0.16583681106567383, 0.012009003199636936, -0.09580905735492706, -0.18194591999053955, 0.08978509902954102, 0.016589317470788956, -0.06718757003545761,
    -0.02513565495610237, 0.12916064262390137, -0.010590647347271442, 0.03205868974328041, -0.10426851361989975, -0.021748343482613564, 0.13539494574069977, 0.216901034116745,
    -0.0529240258038044, 0.012607947923243046, 0.13831807672977448, -0.3153763711452484, 0.0838489681482315, 0.12150968611240387, 0.16852566599845886, 0.09398972988128662,
    0.03027467243373394, 0.015021536499261856, 0.02777680568397045, -0.14745132625102997, 0.13778337836265564, -0.015040787868201733, 0.13789653778076172, 0.13519270718097687,
    0.11610391736030579, 0.20915068686008453, -0.23279203474521637, -0.06248505413532257, -0.12003111094236374, -0.1919393390417099, -0.051253773272037506, 0.0002777135232463479,
    -7.29630482965149e-06, 0.04340068995952606, -0.06370075792074203, -0.0947142094373703, -0.15165643393993378, -0.07678501307964325, 0.011606969870626926, 0.0708119124174118,
    0.04310731589794159, 0.018219629302620888, 0.010917949490249157, -0.024636734277009964, 0.10847745835781097, -0.08547497540712357, -0.1824760138988495, -0.07418103516101837,
    -0.013831828720867634, -0.16284112632274628, 0.08100927621126175, -0.035989079624414444, -0.030931668356060982, -0.009345920756459236, -0.00975049939006567, 0.02166600525379181,
    0.08460881561040878, -0.09318603575229645, -0.3395254909992218, 0.015836264938116074, 0.11832786351442337, 0.09404759109020233, 0.0010858351597562432, -0.0528806671500206,
    0.16197919845581055, -0.10467209666967392, -0.0538800023496151, -0.025706447660923004, -0.07546647638082504, -0.1119237169623375, 0.05297888070344925, -0.15386416018009186,
    -0.004216165281832218, 0.22729958593845367, 0.051712311804294586, 0.2672461271286011, 0.04793206602334976, -0.007980444468557835, 0.08029959350824356, -0.04233216866850853,
    -0.006274576298892498, 0.36891281604766846, -0.049467310309410095, -0.14155922830104828, -0.06383101642131805, 0.13699248433113098, -0.15380029380321503, -0.042406536638736725,
    0.052865564823150635, 0.00732077332213521, 0.08944138884544373, -0.03727090731263161, 0.053247712552547455, -0.05679672956466675, -0.07609959691762924, -0.059674765914678574,
    0.18466469645500183, -0.021110542118549347, 0.05453523248434067, -0.14743657410144806, 0.09347272664308548, -0.13345490396022797, 0.20959140360355377, -0.16312512755393982,
    0.005740873049944639, 0.1925947517156601, -0.17880967259407043, 0.19539380073547363, -0.08858990669250488, -0.4913133382797241, -0.4126998782157898, -0.08934038132429123,
    -0.09385034441947937, 0.10112594813108444, -0.012732259929180145, 0.10410866886377335, -0.29164278507232666, -0.05373453348875046, -0.04263697564601898, 0.006475480739027262,
    0.10841451585292816, -0.025989675894379616, 0.1448226422071457, 0.09427537769079208, -0.0805782750248909, 0.08652996271848679, 0.029232818633317947, 0.11567164957523346,
    -0.011588206514716148, 0.199907124042511, -0.04373978078365326, -0.008622345514595509, -0.02745882235467434, -0.013812701217830181, 0.05487281084060669, -0.2887324094772339,
    -0.11611251533031464, -0.04785595461726189, -0.11609982699155807, -0.22480326890945435, 0.08753958344459534, 0.005299210548400879, 0.07733345031738281, 0.09262813627719879,
    0.017504258081316948, 0.07102038711309433, 0.07374947518110275, 0.08959616720676422, 0.09209352731704712, -0.04106784611940384, 0.0599336102604866, 0.03953298553824425,
    0.11145015805959702, 0.050898488610982895, 0.0008413721807301044, 0.021316025406122208, 0.17517726123332977, 0.1289301961660385, 0.012204570695757866, 0.13760514557361603,
    -0.051698219031095505, -0.13210810720920563, 0.08222013711929321, 0.03265449404716492, -0.24774394929409027, 0.33640769124031067, -0.03240460157394409, -0.11749707907438278,
    -0.15998786687850952, -0.07424108684062958, -0.05953864008188248, 0.046254709362983704, -0.0827789306640625, -0.06440476328134537, -0.18970027565956116, -0.0838371217250824,
    0.29082468152046204, 0.14094191789627075, -0.09956230968236923, -0.01956254430115223, 0.02696278691291809, -0.07588207721710205, 0.04312463477253914, 0.06794960051774979,
    -0.015744486823678017, 0.08626951277256012, 0.026431336998939514, -0.005110645201057196, 0.044172994792461395, 0.27357912063598633, 0.024543818086385727, -0.032500363886356354,
    0.010799632407724857, 0.10461664944887161, -0.010557008907198906, 0.013126217760145664, -0.00041594746289774776, -0.14265930652618408, -0.14713320136070251, 0.01662815362215042,
    -0.015161551535129547, 0.18921782076358795, -0.010257241316139698, -0.10459308326244354, 0.003720424370840192, 0.05696359649300575, 0.21192218363285065, -0.04511434957385063,
    -0.04033515974879265, 0.30724266171455383, 0.0014909778255969286, 0.04489346593618393, -0.2320041060447693, 0.10613521933555603, 0.10237999260425568, 0.07160253822803497,
    0.014068580232560635, -0.03287379816174507, -0.05039001628756523, -0.059885889291763306, 0.14774969220161438, -0.2815859615802765, -0.04174446687102318, -0.017843592911958694,
    -0.07408566772937775, -0.15738694369792938, -0.01956183649599552, -0.027318011969327927, -0.0005345458048395813, 0.12248141318559647, 0.168777197599411, 0.0764414593577385,
    -0.04063645377755165, 0.04035124555230141, 0.05092853680253029, 0.2001427263021469, -0.09808110445737839, 0.27634069323539734, -0.0025120109785348177, 0.018978958949446678,
    -0.030407598242163658, -0.01207141112536192, -0.10266009718179703, 0.17792683839797974, 0.005726776085793972, -0.15250292420387268, 0.0049098157323896885, 0.04959782958030701,
    -0.1091708093881607, 0.16712118685245514, 0.21266494691371918, -0.06779718399047852, -0.05889755114912987, -0.010180635377764702, -0.013331822119653225, -0.11366812139749527,
    -0.07044177502393723, 0.18809011578559875, -0.0867522731423378, -0.01118423230946064, -0.12040897458791733, -0.08147527277469635, -0.013992343097925186, 0.1904774308204651,
    -0.12616486847400665, -0.12698259949684143, 0.033268265426158905, 0.38255956768989563, -0.06635162234306335, -0.14528101682662964, 0.08797620236873627, -0.019452234730124474,
    -0.0314040407538414, 0.031682658940553665, -0.00624777702614665, -0.1522335410118103, 0.04815896227955818, -0.030610840767621994, -0.022940555587410927, -0.06763681769371033,
    -0.004737140145152807, 0.10095228999853134, -0.2942908704280853, -0.047430213540792465, -0.13564306497573853, -0.13653035461902618, -0.008377298712730408, -0.03709268942475319,
    0.02332218922674656, 0.045765407383441925, -0.11541908234357834, 0.055547356605529785, -0.1522548943758011, 0.4300985336303711, 0.05720902979373932, -0.20548059046268463,
    0.11073730885982513, -0.06016882508993149, 0.03836521878838539, -0.0181917455047369, -0.05061177909374237, -0.018588028848171234, 0.05712500587105751, 0.014593919739127159,
    0.334723562002182, -0.046021852642297745, -0.25677376985549927, 0.002918220590800047, 0.05395262688398361, 0.06287189573049545, 0.027857644483447075, -0.0624583400785923,
    0.024426663294434547, -0.024657202884554863, -0.2863527238368988, -0.12285506725311279, 0.08732303977012634, -0.24396975338459015, -0.001192962983623147, -0.0160832516849041,
    0.09591910988092422, -0.01857924275100231, 0.13989989459514618, -0.04813797399401665, 0.16348639130592346, -0.044530633836984634, -0.022847231477499008, -0.037249211221933365,
    -0.040441010147333145, 0.23107364773750305, -0.0118331890553236, -0.06956107169389725, 0.06462226063013077, -0.04306759685277939, 0.1285933256149292, -0.016320032998919487,
    0.040802039206027985, 0.17840562760829926, -0.007912923581898212, 0.00432922225445509, -0.11691401153802872, 0.009390515275299549, -0.1610357165336609, -0.024917632341384888,
    0.05993618443608284, 0.00767914904281497, -0.10805228352546692, -0.01943139173090458, -0.130239799618721, -0.15430113673210144, 0.049063146114349365, -0.06457965821027756,
    -0.16253197193145752, 0.14699247479438782, 0.02245018072426319, 0.06282428652048111, -0.17981749773025513, 0.05372488871216774, 0.13348498940467834, -0.11608126014471054,
    -0.09227201342582703, 0.03793230652809143, 0.06469399482011795, -0.06430285423994064, 0.033491019159555435, -0.07139439135789871, 0.12484517693519592, 0.01879802718758583,
    0.08005107194185257, 0.21346400678157806, -0.09041228145360947, 0.016063576564192772, -0.018990274518728256, -0.015362773090600967, 0.010293537750840187, -0.008758585900068283,
    -0.05484479293227196, 0.10826707631349564, 0.00531882094219327, 0.07697005569934845, -0.10140249133110046, -0.06699691712856293, -0.007482824381440878, -0.11626939475536346,
    -0.07299576699733734, 0.07611596584320068, -0.15398520231246948, -0.0024517523124814034, -0.08145107328891754, 0.04521375149488449, -0.03800155222415924, 0.008078886196017265,
    -0.18835245072841644, -0.03839113935828209, 0.027637680992484093, -0.2960430681705475, -0.022420991212129593, 0.08214682340621948, 0.05328701436519623, -0.00062153534963727,
    0.011484111659228802, -0.052623502910137177, 0.12740863859653473, 0.0014725072542205453, -0.05448732152581215, 0.031749557703733444, 0.009253008291125298, 0.011758442036807537,
    -0.035741932690143585, 0.007423600181937218, -0.012972944416105747, 0.06077143922448158, -0.0012862493749707937, 0.030937479808926582, -0.043077316135168076, 0.0014085830189287663,
    -0.07655330002307892, -0.033250171691179276, 0.11165039986371994, -0.10586196184158325, -0.10933900624513626, 0.09762922674417496, -0.14139507710933685, 0.06211807578802109,
    -0.09597639739513397, 0.17657122015953064, -0.03112034685909748, -0.01856321655213833, -0.0032182445283979177, 0.08291107416152954, 0.03450004756450653, -0.15112502872943878,
    -0.045892249792814255, 0.01955721154808998, 0.04903288930654526, 0.04952821508049965, -0.07559175044298172, -0.1894710808992386, -0.09953119605779648, -0.19166018068790436,
    0.10711165517568588, 0.04158364236354828, 0.0553085021674633, 0.058723412454128265, 0.00804642029106617, 0.025820797309279442, 0.005340540781617165, 0.053236156702041626,
    -0.009443001821637154, 0.08720975369215012, -0.21607361733913422, -0.04403378814458847, 0.06093819811940193, -0.06577782332897186, 0.13220059871673584, -0.04020616039633751,
    -0.006345455534756184, -0.10719791799783707, -0.05790182948112488, 0.061221182346343994, -0.03764483705163002, 0.20208154618740082, 0.07728664577007294, -0.042673271149396896,
    -0.051028527319431305, 0.15484334528446198, 0.003132404061034322, 0.005011354573071003, 0.12054534256458282, 0.017508843913674355, 0.1025482714176178, -0.057015325874090195,
    0.10412490367889404, -0.0066909571178257465, 0.03696781024336815, 0.06439011543989182, 0.12991398572921753, -0.07572592049837112, -0.021919669583439827, -0.06703423708677292,
    -0.14790035784244537, 0.10980958491563797, -0.009744503535330296, 0.17257753014564514, 0.18629108369350433, -0.041186507791280746, 0.14614565670490265, -0.07377965748310089,
    0.15072569251060486, 0.022539522498846054, -0.022627370432019234, -0.0735730528831482, 0.012314366176724434, 0.14946165680885315, 0.021165048703551292, 0.1388123631477356,
    -0.003518472658470273, 0.06569204479455948, -0.03112388215959072, 0.12582342326641083, -0.043117400258779526, -0.11624979227781296, 0.09786935150623322, 0.026151612401008606,
    0.15948094427585602, 0.07309615612030029, -0.15832780301570892, -0.0690750777721405, 0.003551185131072998, -0.19024182856082916, -0.000829365337267518, -0.04948742315173149,
    -0.028156843036413193, 0.18434728682041168, -0.004097627475857735, 0.010931456461548805, -0.0561169870197773, -0.018727270886301994, -0.015019809827208519, -0.04360359162092209,
    -0.11945266276597977, -0.005507707595825195, -0.028564518317580223, -0.15704064071178436, -0.0618385449051857, -0.03432789817452431, -0.05908197909593582, 0.008176862262189388,
    -0.08611215651035309, -0.09220529347658157, 0.28747332096099854, -0.02917328104376793, 0.05758216604590416, -0.03130573406815529, -0.06451088935136795, -0.049106016755104065,
    -0.14598995447158813, 0.039540600031614304, -0.02853795699775219, 0.04893297702074051, 0.011038975790143013, 0.11669894307851791, 0.01259432453662157, -0.012543836608529091,
    -0.09212954342365265, -0.05329842492938042, 0.15989038348197937, -0.09234865754842758, -0.03526158258318901, 0.06935703009366989, -0.08108995109796524, -0.008254588581621647,
    0.14040863513946533, 0.11652117967605591, 0.10212632268667221, 0.015063592232763767, 0.009269457310438156, 0.05296832323074341, 0.12047702074050903, -0.05738791078329086,
    -0.11355049163103104, -0.058741651475429535, -0.04680253192782402, 0.033872999250888824, -0.014068705029785633, -0.06623765081167221, -0.02672606147825718, -0.06719780713319778,
    0.01782328449189663, 0.008168484084308147, -0.039915282279253006, 0.09842494130134583, 0.010439037345349789, 0.09633127599954605, 0.0066343857906758785, 0.032432787120342255,
    0.005690548103302717, 0.09859795868396759, 0.028666628524661064, -0.03524653613567352, -0.025599215179681778, 0.0267025176435709, 0.029500164091587067, 0.04120568931102753,
    -0.011263488791882992, -0.05297643691301346, 0.04706553369760513, 0.019479772076010704, -0.0039040478877723217, -0.013791412115097046, 0.042751017957925797, -0.09386873245239258,
    -0.06614790111780167, 0.1788773536682129, -0.024757150560617447, 0.057341571897268295, -0.04888078570365906, -0.06425101310014725, -0.020323341712355614, 0.05234817788004875,
    0.17586272954940796, -0.019376497715711594, 0.041251860558986664, 0.022378332912921906, -0.013797804713249207, -0.11325166374444962, -0.004069546237587929, -0.08740542083978653,
    -0.0035802077036350965, 0.02110605686903, -0.03454938530921936, 0.14830666780471802, 0.22465120255947113, -0.020594604313373566, 0.013631108216941357, 0.01513544749468565,
    0.20981328189373016, 0.0018119949381798506, -0.007857398129999638, -0.08571483939886093, 0.16674304008483887, -0.058225277811288834, -0.03779245913028717, 0.02979162149131298,
    -0.030107568949460983, -0.03932517394423485, 0.03672735020518303, 0.1399766206741333, 0.03227817639708519, -0.18263956904411316, 0.11748724430799484, 0.016211731359362602,
    0.2922504246234894, 0.10556318610906601, -0.01522583607584238, -0.01812008209526539, 0.14927168190479279, -0.00699985446408391, 0.010844838805496693, -0.05926930904388428,
    0.009112011641263962, 0.08287094533443451, 0.10235853493213654, 0.058040179312229156, -0.03577554225921631, -0.07734045386314392, -0.02794603258371353, 0.06159657984972,
    0.025286395102739334, 0.053574591875076294, -0.06831749528646469, 0.28548890352249146, 0.1863580346107483, -0.06430497020483017, -0.10133661329746246, 0.04694049060344696,
    0.05291839689016342, 0.12138490378856659, 0.3849670886993408, -0.010615156032145023, 0.16524723172187805, -0.06686972826719284, 0.041364338248968124, 0.04204649478197098,
    -0.12081671506166458, 0.018559530377388, 0.0658140704035759, -0.09634983539581299, 0.02728564292192459, -0.09089036285877228, 0.04614459350705147, 0.046417318284511566,
    -0.10176536440849304, 0.05778875946998596, 0.04187389463186264, 0.022690119221806526, 0.05701514706015587, -0.02206168882548809, 0.012893239967525005, -0.08526088297367096,
    0.058857664465904236, -0.08064164221286774, 0.12631525099277496, -0.037969350814819336, 0.07497916370630264, -0.006459293887019157, 0.0907849445939064, 0.08652817457914352,
    -0.03437933325767517, 0.010831639170646667, 0.02130724862217903, -0.025026505813002586, 0.07585521042346954, 0.202018141746521, 0.12537990510463715, 0.06426657736301422,
    -0.014547626487910748, -0.12104419618844986, -0.05087932571768761, -0.10259539633989334, -0.03777074068784714, -0.18524625897407532, -0.029696516692638397, -0.014593023806810379,
    -0.0463072843849659, -0.020873889327049255, -0.007131572347134352, -0.0010237196693196893, -0.08400604873895645, 0.029407551512122154, -0.07143615186214447, 0.1731465607881546,
    -0.07349767535924911, -0.009099001064896584, -0.021138563752174377, -0.1426188200712204, -0.019530458375811577, -0.0004992050235159695, -0.1098538488149643, 0.015415205620229244,
    -0.004664413630962372, -0.012965011410415173, 0.009234437718987465, -0.056178949773311615, -0.20525245368480682, -0.011867715045809746, -0.0463121272623539, -0.06630083918571472,
    0.08731085807085037, -0.0008822581730782986, 0.03439699113368988, -0.044299397617578506, -0.047571465373039246, -0.05907605588436127, 0.14515085518360138, 0.06027037277817726,
    0.049014948308467865, 0.12995517253875732, -0.04175013303756714, 0.054809655994176865, -0.02024364098906517, -0.013216115534305573, -0.10325867682695389, -0.01698964647948742,
    -0.04231499880552292, -0.04291553422808647, 0.12151528894901276, -0.08053302764892578, 0.23260921239852905, -0.10628646612167358, 0.0861465334892273, -0.038347985595464706,
    -0.022640962153673172, 0.06507833302021027, -0.018606392666697502, -0.08350040763616562, 0.129901722073555, 0.0908064916729927, 0.0636730045080185, 0.06563884019851685,
    -0.10867869108915329, 0.1883343756198883, 0.20013825595378876, 0.04598138481378555, -0.09713926166296005, -0.0036273906007409096, -0.02975301258265972, -0.05618968605995178,
    0.03643927723169327, 0.07702942937612534, -0.11161871999502182, -0.028509633615612984, -0.02493770234286785, 0.011689959093928337, 0.01248207874596119, 0.02285129763185978,
    0.02112233079969883, -0.13698820769786835, 0.017444539815187454, -0.07254581898450851, 0.160580575466156, 0.22338823974132538, -0.04621322825551033, -0.014195396564900875,
    0.021421082317829132, 0.07474607229232788, 0.1516023427248001, -0.013696647249162197, -0.04710083827376366, 0.16692300140857697, 0.19684453308582306, 0.001946349861100316,
    -0.03341744467616081, -0.03473201021552086, -0.0039103408344089985, -0.09527596831321716, 0.0015122772892937064, -0.12415707856416702, -0.0906398668885231, 0.04117453843355179,
    -0.021039903163909912, -0.0587659515440464, -0.08109323680400848, 0.021282587200403214, 0.03520131856203079, -0.04882146790623665, -0.0776372030377388, 0.05244811251759529,
    -0.1708332747220993, -0.016086814925074577, 0.02991381660103798, -0.10210824757814407, 0.12230447679758072, 0.06643559038639069, -0.13602735102176666, -0.09893512725830078,
    0.09818380326032639, 0.0310224462300539, 0.02013157308101654, 0.012802950106561184, -0.06312545388936996, -0.12500229477882385, -0.0754287838935852, -0.027363184839487076,
    0.038982946425676346, -0.11634963750839233, 0.022753234952688217, 0.022420424968004227, 0.06649695336818695, -0.27046075463294983, 0.034533314406871796, 0.006784011144191027,
    -0.05687878653407097, -0.0878882110118866, -0.12056595832109451, 0.004940202459692955, 0.020785735920071602, -0.030815089121460915, -0.016017165035009384, 0.08647225797176361,
    0.019869251176714897, 0.0028852212708443403, -0.13537126779556274, -0.19043458998203278, -0.03952334448695183, 0.12978601455688477, 0.03303917497396469, 0.05254454165697098,
    0.08889202773571014, 0.08037462830543518, -0.041879188269376755, -0.031733136624097824, -0.17326360940933228, -0.001402227790094912, 0.04731552675366402, 0.0007558479555882514,
    0.0846773013472557, -0.0403461791574955, 0.019951079040765762, -0.0599585585296154, 0.035631660372018814, 0.060416027903556824, -0.004427740816026926, 0.042779065668582916,
    -0.013358276337385178, 0.17196479439735413, 0.002024472923949361, -0.12390459328889847, -0.03902329504489899, -0.007071580737829208, -0.20372864603996277, 0.01069809403270483,
    -0.08387552201747894, 0.03675268590450287, 0.005756876897066832, -0.020816581323742867, 0.2341185212135315, 0.14645114541053772, 0.028744082897901535, -0.021967288106679916,
    0.05893745273351669, 0.075251005589962, -0.03520984575152397, -0.08437718451023102, 0.02093924768269062, 0.1103953942656517, 0.0807773545384407, 0.014733805321156979,
    -0.07941637188196182, 0.170477956533432, 0.10896801203489304, -0.07212424278259277, -0.010917131789028645, -0.018939781934022903, -0.011775289662182331, 0.013118244707584381,
    -0.017765672877430916, -0.08574269711971283, -0.0380573645234108, 0.011588071472942829, -0.0628288984298706, 0.023233111947774887, 0.011144367046654224, -0.09018860012292862,
    0.03723214566707611, 0.08596333116292953, 0.015971507877111435, -0.01322698313742876, 0.06538145989179611, 0.14267823100090027, -0.13470110297203064, -0.07915505766868591,
    -0.0972222313284874, -0.1514563411474228, 0.036738310009241104, 0.005580339580774307, 0.08697615563869476, -0.062109123915433884, -0.07205283641815186, -0.07400453090667725,
    -0.0775754526257515, -0.012612925842404366, 0.031335920095443726, -0.03037240356206894, -0.022084379568696022, 0.042392000555992126, -0.054638613015413284, -0.019588099792599678,
    -0.06756360828876495, -0.00884256511926651, -0.08417021483182907, 0.07166844606399536, -0.02593257464468479, -0.01145564578473568, 0.0048593394458293915, 0.07944083213806152,
    0.01158008724451065, 0.024065222591161728, -0.11034251004457474, -0.018117785453796387, 0.16019323468208313, 0.047343336045742035, -0.10776405781507492, -0.00903322920203209,
    -0.03146271035075188, -0.05274636670947075, -0.0288349948823452, -0.018993522971868515, -0.13396406173706055, 0.00022473813442047685, -0.03510940447449684, -8.93295873538591e-05,
    -0.05677969008684158, -0.0539143867790699, -0.08485881984233856, 0.0849086195230484, 0.027610648423433304, -0.25692540407180786, 0.016454286873340607, -0.06742499023675919,
    -0.24244597554206848, 0.0009932704269886017, 0.12149569392204285, -0.03626522049307823, 0.08215305209159851, -0.035810913890600204, -0.04322459176182747, -0.09063377976417542,
    -0.09030905365943909, 0.045028410851955414, 0.1351253241300583, -0.08171968162059784, -0.019136883318424225, -0.06501184403896332, 0.09026769548654556, -0.17244282364845276,
    0.034849267452955246, 0.00012079580483259633, 0.02117743343114853, -0.0783340260386467, -0.1943315714597702, -0.030785489827394485, -0.021128298714756966, -0.006512340623885393,
    0.07294240593910217, -0.003083860268816352, -0.19065365195274353, 0.02664671465754509, 0.04664919897913933, 0.030420608818531036, -0.1323883980512619, 0.0324484221637249,
    0.09157198667526245, -0.04071913659572601, 0.030188677832484245, 0.00929553434252739, -0.0300811268389225, 0.01847441866993904, -0.1005588248372078, 0.022780898958444595,
    -0.021264929324388504, -0.0035147531889379025, 0.04599188640713692, -0.07351189106702805, 0.19601434469223022, -0.13979707658290863, -0.023835614323616028, -0.015027081593871117,
    -0.005910769104957581, 0.09269782900810242, 0.008575303480029106, 0.15932053327560425, -0.0063157109543681145, -0.11550670117139816, 0.04657755047082901, 0.013778077438473701,
    0.1468086987733841, 0.1436723917722702, -0.04376700147986412, -0.015710238367319107, 0.014242817647755146, -0.07626347988843918, 0.009493304416537285, -0.11141043901443481,
    -0.011093655601143837, -0.05247515067458153, 0.09016413241624832, 0.006225452292710543, -0.0757732018828392, -0.008770732209086418, -0.026565654203295708, 0.13424602150917053,
    0.034258220344781876, 0.06593014299869537, -0.016340989619493484, 0.06266262382268906, -0.011990986764431, -0.06194588914513588, -0.15063585340976715, 0.0014140116982161999,
    -0.00422276183962822, -0.22759810090065002, -0.04276421293616295, 0.0030649222899228334, 0.0499022975564003, -0.09416268020868301, -0.12500981986522675, -0.06949175894260406,
    -0.051250752061605453, -0.055489033460617065, 0.02209632284939289, -0.019916296005249023, 0.022282499819993973, -0.058448705822229385, -0.0788210853934288, 0.04416751489043236,
    -0.08304615318775177, 0.013680336065590382, -0.08372918516397476, 0.0018858531257137656, 0.001664420822635293, 0.00838308036327362, -0.05090434104204178, -0.11791742593050003,
    0.08479709178209305, -0.08313068747520447, -0.07912588119506836, -0.0649392232298851, -0.003464451292529702, 0.08278662711381912, -0.04795071482658386, 0.014047200791537762,
    -0.009837137535214424, 0.012126026675105095, -0.09583104401826859, 0.019403547048568726, -0.12333609163761139, 0.08786686509847641, 0.06465527415275574, 0.014029192738234997,
    -0.05933285504579544, -0.15197181701660156, -0.09881661087274551, 0.06482098996639252, -0.052797287702560425, -0.022648876532912254, -0.025715796276926994, -0.0016610621241852641,
    0.08964139968156815, -0.10623369365930557, 0.05571209639310837, -0.0056474655866622925, 0.028096506372094154, 0.05038837715983391, -0.0006402264116331935, -0.21026410162448883,
    0.01971459947526455, 0.12958885729312897, -0.05864540860056877, 0.034022800624370575, -0.004013082478195429, -0.06884269416332245, -0.06066661700606346, -0.10636456310749054,
    0.08676422387361526, -0.053647808730602264, -0.007981098257005215, 0.1029907688498497, 0.04034143686294556, -0.035656433552503586, 0.12475652992725372, -0.017088565975427628,
    -0.004954487085342407, -0.029898062348365784, 0.014333021827042103, 0.017218224704265594, -0.0011045474093407393, 0.03242168948054314, 0.07415485382080078, -0.0377349928021431,
    0.11932684481143951, -0.11791708320379257, -0.01344725675880909, -0.04179674759507179, 0.07252246141433716, -0.023044805973768234, 0.1041148379445076, 0.035204485058784485,
    -0.10288738459348679, 0.07830122858285904, 0.08099937438964844, -0.0350613072514534, 0.36477285623550415, -0.1156809851527214, 0.00404004892334342, -0.1520000398159027,
    -0.08980836719274521, 0.0566762313246727, 0.001814835355617106, 0.11419007927179337, -0.017290407791733742, -0.1463041603565216, 0.014125674031674862, 0.027245085686445236,
    -0.07666841894388199, 0.134498730301857, 0.0501900278031826, 0.045751672238111496, 0.11122410744428635, 0.0002846439019776881, 0.04752344638109207, 0.08681168407201767,
    0.03619067743420601, -0.22070050239562988, -0.06745526194572449, 0.03441153094172478, 0.047990038990974426, -0.036334749311208725, 0.021756773814558983, -0.03193628042936325,
    -0.017651677131652832, -0.07490239292383194, 0.02586010843515396, 0.09276411682367325, 0.007427204865962267, -0.12169315665960312, -0.052020348608493805, 0.1331159621477127,
    0.10026619583368301, -0.024482060223817825, 0.026393206790089607, -0.03126667067408562, -0.04676523059606552, 0.13828466832637787, 0.0901854857802391, 0.04360312968492508,
    0.035958606749773026, 0.011557774618268013, 0.17877033352851868, 0.06320006400346756, -0.041648559272289276, 0.011788487434387207, -0.07010480016469955, 0.029809294268488884,
    0.03139235079288483, -0.013136817142367363, 0.02316550724208355, 0.022848663851618767, 0.12082546204328537, 0.06171833351254463, -0.04122950881719589, -0.07463916391134262,
    -0.1570393294095993, 0.034012529999017715, 0.010679366067051888, -0.022129390388727188, 0.1212613433599472, 0.015565098263323307, 0.024010559543967247, -0.008645942434668541,
    0.05645105987787247, 0.010006959550082684, 0.07106135785579681, 0.02375752106308937, 0.03522292524576187, -0.0944918543100357, -0.018523763865232468, -0.0045037101954221725,
    -0.01999901421368122, -0.15654517710208893, -0.025834228843450546, -0.11299274116754532, -0.024380531162023544, 0.06063985824584961, -0.020985949784517288, 0.12812267243862152,
    0.08381742238998413, -0.13584159314632416, -0.11002986878156662, 0.0006996364099904895, -0.0922165960073471, 0.11598743498325348, 0.0749654620885849, -0.0874214842915535,
    -0.04722234234213829, 0.11108960211277008, -0.055870626121759415, 0.07041390985250473, 0.009593972004950047, 0.0633617416024208, -0.062324002385139465, 0.03030949831008911,
    0.14826951920986176, 0.030666235834360123, -0.02962515875697136, -0.09687510132789612, 0.1270357072353363, -0.026663044467568398, -0.06670744717121124, 0.012617210857570171,
    -0.06643752008676529, -0.04420710727572441, -0.11880858242511749, 0.015727872028946877, -0.0902678444981575, 0.055021725594997406, 0.010324236005544662, 0.0066255610436201096,
    0.015301463194191456, 0.021059997379779816, 0.008811012841761112, -0.06446515023708344, -0.06821482628583908, 0.02246532030403614, 0.08865199983119965, 0.026042891666293144,
    0.006699232384562492, 0.002480926923453808, -0.021103885024785995, 0.01578575000166893, 0.2697424590587616, 0.019754301756620407, 0.034595564007759094, 0.00730318296700716,
    -0.010269733145833015, 0.019475441426038742, 0.005642640870064497, 0.015591196715831757, -0.04936215654015541, -0.0013849529204890132, 0.03985615074634552, -0.010638248175382614,
    -0.12008212506771088, 0.08994907140731812, -0.007573346607387066, -0.045940425246953964, 0.11017797887325287, 0.04650229960680008, 0.013935497961938381, 0.018881073221564293,
    -0.01134822703897953, -0.23065991699695587, -0.05335826799273491, 0.014977691695094109, -0.05298605188727379, 0.022342007607221603, -0.033279284834861755, 0.044829003512859344,
    -0.02224361151456833, 0.01670694164931774, -0.0011445126729086041, -0.06081271171569824, -0.08687739074230194, -0.09843505173921585, 0.03260713443160057, 0.06458131223917007,
    -0.052700698375701904, -0.07006829977035522, -0.05433890223503113, -0.018855294212698936, 0.10023356229066849, 0.05128292366862297, -0.08476205915212631, -0.008785412646830082,
    -0.019025769084692, 0.057969797402620316, 0.05505606159567833, -0.0051549687050282955, -0.01767571270465851, -0.014796067960560322, -0.08685491979122162, -0.037157442420721054,
    0.010442769154906273, -0.0020263593178242445, 0.03423381224274635, -0.06309207528829575, -0.17034386098384857, 0.04394453763961792, -0.04297337308526039, 0.020090484991669655,
    0.049168385565280914, 0.10078263282775879, 0.07017672061920166, 0.034690991044044495, 0.07058209925889969, 0.017321301624178886, 0.05273944512009621, 0.08755870163440704,
    -0.0658123642206192, -0.001865571248345077, 0.1995553821325302, 0.013366011902689934, 0.06470736861228943, 0.06242972984910011, -0.0332217775285244, 0.09366456419229507,
    -0.039462000131607056, -0.06410308182239532, 0.027448680251836777, 0.037704575806856155, 0.015901725739240646, 0.017953669652342796, 0.028158992528915405, -0.03566073626279831,
    -0.02613489143550396, 0.02010657638311386, 0.02497633919119835, -0.016107117757201195, -0.0310553889721632, 0.11404092609882355, -0.008700544014573097, 0.14220842719078064,
    -0.018112219870090485, 0.036947619169950485, 0.12913037836551666, 0.13438905775547028, -0.006636943202465773, -0.017355909571051598, -0.01943165995180607, -0.004224653821438551,
    0.16077426075935364, 0.027455734089016914, 0.056523486971855164, -0.01381013449281454, -0.2013545036315918, -0.0670572966337204, -0.06763073801994324, -0.05836642161011696,
    -0.035746507346630096, 0.042617443948984146, -0.10925916582345963, -0.026053104549646378, -0.07253760099411011, 0.0987432450056076, 0.044666044414043427, 0.02577936090528965,
    0.014026240445673466, 0.08944137394428253, 0.05301142856478691, -0.0023568058386445045, -0.017270738258957863, 0.010501530021429062, 0.04472619295120239, -0.012050723657011986,
    -0.13724663853645325, 0.009250933304429054, 0.041406307369470596, 0.018565889447927475, 0.1643509417772293, -0.07933057844638824, 0.05198579281568527, -0.07599151879549026,
    0.007854191586375237, 0.05270453169941902, -0.033263955265283585, 0.08888398855924606, 0.007202107924968004, 0.033121515065431595, -0.029083963483572006, -0.004150461405515671,
    0.041389498859643936, 0.04840382933616638, -0.006422705017030239, 0.004311081953346729, 0.07248169928789139, 0.00842648558318615, 0.010320054367184639, -0.009072532877326012,
    0.042078979313373566, -0.20989783108234406, 0.0651983842253685, 0.027446091175079346, -0.09610611200332642, 0.008523023687303066, -0.00040492668631486595, -0.005383014678955078,
    -0.09166088700294495, 0.10840491950511932, -0.05129328742623329, -0.01642843894660473, 0.06800944358110428, 0.09548582881689072, 0.09195414930582047, -0.03336409851908684,
    0.043906766921281815, -0.009854329749941826, -0.1204080581665039, -0.020676210522651672, 0.03519995138049126, -0.010319084860384464, -0.16119536757469177, -0.06505543738603592,
    0.024099349975585938, -0.07044246792793274, -0.014671683311462402, 0.01747835986316204, -0.004865647293627262, -0.005576945375651121, -0.058059774339199066, 0.032514043152332306,
    0.055275943130254745, -0.003559294156730175, -0.015128822065889835, -0.08317406475543976, -0.041311562061309814, 0.04468802735209465, -0.07253661006689072, -0.0569726787507534,
    -0.0005392918246798217, -0.058054517954587936, 0.04195162653923035, -0.005946088116616011, -0.02871718443930149, -0.07145681977272034, -0.06851571798324585, 0.06442970782518387,
    -0.06661394983530045, 0.015897398814558983, 0.16945025324821472, -0.006750394124537706, -0.014542942866683006, -0.027427058666944504, 0.006998456548899412, 0.037572793662548065,
    -0.024283049628138542, -0.12191183120012283, -0.10805592685937881, 0.040624119341373444, 0.025914266705513, 0.04459018260240555, -0.0457492396235466, -0.030005700886249542,
    0.04949522018432617, 0.11575990170240402, 0.02097858302295208, -0.07461880892515182, -0.04766332730650902, 0.08576282113790512, -0.06820475310087204, 0.10677681863307953,
    -0.019635029137134552, -0.023714197799563408, -0.10549213737249374, -0.06566448509693146, -0.023839697241783142, -0.06950113922357559, -0.08914750814437866, 0.07123240828514099,
    0.10893625020980835, -0.05580512806773186, -0.03294945880770683, 0.042553238570690155, -0.01631990075111389, -0.027154864743351936, -0.018177086487412453, 0.04093140736222267,
    -0.046517129987478256, -0.01832343451678753, 0.019066419452428818, 0.03417431190609932, -0.0035879393108189106, 0.008759472519159317, 0.010381616652011871, -0.022584104910492897,
    0.006772125139832497, -0.0395098440349102, -0.01994062215089798, 0.07808533310890198, 0.08721897751092911, -0.0282199215143919, 0.03994624316692352, 0.018662795424461365,
    -0.0441088043153286, -0.03276771679520607, -0.01464899629354477, -0.011950595304369926, 0.26987430453300476, -0.01986449956893921, -0.03644484281539917, -0.08866456151008606,
    0.008294417522847652, -0.0397239550948143, -0.011481384746730328, -0.030250338837504387, 0.09838256984949112, -0.010448397137224674, 0.0166473388671875, 0.04360415041446686,
    0.11819075047969818, 0.032527193427085876, 0.018193349242210388, 0.006933744065463543, 0.14114263653755188, 0.07141505181789398, -0.02942759543657303, -0.0002269943943247199,
    0.016513820737600327, -0.22432328760623932, -0.028341129422187805, 0.02764001488685608, -0.05426381155848503, 0.01234434638172388, 0.014579765498638153, -0.020049378275871277,
    -0.05369069054722786, -0.08387533575296402, -0.06671786308288574, 0.039493534713983536, -0.028490712866187096, 0.025526557117700577, 0.03147423639893532, -0.13223080337047577,
    0.08250461518764496, -0.06788825988769531, -0.06405873596668243, -0.019451173022389412, -0.009688708931207657, 0.012566809542477131, -0.08699861168861389, -0.010570629499852657,
    0.057093966752290726, -0.043264470994472504, -0.004638563841581345, 0.12170100212097168, 0.03877631947398186, -0.058356404304504395, -0.014528266154229641, -0.026058748364448547,
    0.00998716615140438, -0.025096826255321503, -0.02542758919298649, 0.030635621398687363, -0.00817811954766512, 0.028905095532536507, 0.003981324844062328, 0.003307265928015113,
    -0.06646315008401871, -0.0841192677617073, 0.05075731873512268, -0.019455133005976677, -0.0051252651028335094, -0.10082589089870453, 0.07781171053647995, -0.014176412485539913,
    0.01782020553946495, -0.016595633700489998, 0.03249647840857506, -0.015608010813593864, 0.047300808131694794, 0.05919862166047096, -0.01897280290722847, -0.004736608359962702,
    0.0583471842110157, -0.03213882818818092, 0.023036114871501923, 0.0071941944770514965, -0.03640175610780716, 0.05826584994792938, 0.018232937902212143, 0.04350995644927025,
    0.05351487174630165, 0.0044372668489813805, 0.040211714804172516, -0.01335048209875822, -0.012232945300638676, 0.1398313194513321, -0.08523929119110107, -0.1407172530889511,
    -0.02754659205675125, -0.032862626016139984, 0.015627583488821983, -0.04844242334365845, -0.09438643604516983, 0.05469090864062309, -0.0021931210067123175, 0.01603454351425171,
    0.1672794073820114, 0.0344574972987175, 0.042660124599933624, -0.032878387719392776, 0.0200558640062809, -0.013589163310825825, -0.0935090035200119, -0.0184028223156929,
    -0.0627000629901886, 0.015957916155457497, 0.0058733136393129826, -0.0034551024436950684, 0.00855226255953312, 0.10464321821928024, -0.05735935643315315, 0.0009732549078762531,
    -0.07668725401163101, -0.07102707028388977, 0.04937486723065376, -0.024775288999080658, -0.05356887727975845, 0.07601592689752579, -0.00909875612705946, 0.024141380563378334,
    0.007411719765514135, 0.058362703770399094, -0.07848189026117325, 0.029742317274212837, 0.18989816308021545, 0.06524600088596344, -0.015628861263394356, -0.0347960963845253,
    0.023194018751382828, -0.030510416254401207, 0.03785450756549835, -0.031333550810813904, -0.012362671084702015, 0.0011402360396459699, 0.03489743545651436, 0.007329641841351986,
    0.024168711155653, -0.003349789185449481, 0.02082899957895279, -0.014752097427845001, 0.17832982540130615, 0.10382390022277832, -0.000466933473944664, -0.04843028634786606,
    0.010843529365956783, -0.08868705481290817, -0.056704066693782806, 0.002064646454527974, -0.07341858744621277, 0.007763145957142115, -0.021420009434223175, 0.03913097083568573,
    -0.009492462500929832, -0.004985002335160971, -0.027748236432671547, -0.03556077182292938, -0.05575014650821686, -0.042429737746715546, -0.041924286633729935, -0.017115864902734756,
    -0.00857220496982336, -0.047934163361787796, -0.17092064023017883, 0.04801451042294502, 0.06324956566095352, -0.02662407048046589, -0.051041483879089355, 0.0105210542678833,
    -0.020066237077116966, 0.023731214925646782, -0.020637400448322296, 0.036084383726119995, -0.00625538919121027, -0.07073937356472015, -0.04450450465083122, -0.033229656517505646,
    -0.012050503864884377, 0.009398634545505047, 0.02685234695672989, 0.024669883772730827, -0.11724593490362167, -0.00814762245863676, 0.029613669961690903, 0.07550602406263351,
    0.011747561395168304, 0.08150806277990341, -0.01394737046211958, -0.015805309638381004, 0.04550551623106003, 0.014035232365131378, 0.04980010166764259, -0.11922132223844528,
    0.04995425418019295, 0.006461120676249266, 0.1279323846101761, 0.017728561535477638, 0.026584018021821976, -0.0479203462600708, -0.005450062919408083, -0.03839116916060448,
    0.008076352998614311, 0.02064383588731289, 0.06419875472784042, 0.01121856365352869, -0.028510764241218567, 0.05278245732188225, 0.01778140477836132, 0.015469495207071304,
    -0.017878353595733643, 0.07700173556804657, 0.005848788656294346, 0.007343715522438288, -0.039246074855327606, 0.14274537563323975, -0.015411254949867725, -0.09250572323799133,
    -0.06201756000518799, -0.028320295736193657, 0.037656933069229126, -0.03458748385310173, 0.009369824081659317, 0.03541644662618637, 0.036582667380571365, -0.09251824766397476,
    0.1585460752248764, 0.04618868976831436, 6.545551514136605e-06, 0.02557615004479885, 0.04436812922358513, -0.04033171385526657, -0.05146528780460358, 0.014393739402294159,
    -0.08062059432268143, -0.036815304309129715, -0.0691981092095375, 0.0019332796800881624, -0.018238788470625877, 0.029755594208836555, -0.015360919758677483, 0.005013454705476761,
    -0.007346686441451311, -0.07972101122140884, 0.021120497956871986, 0.028581419959664345, -0.007081692572683096, 0.06764902919530869, 0.0625101774930954, 0.02008487470448017,
    0.013121157884597778, 0.020166927948594093, -0.012629379518330097, 0.026732411235570908, 0.2039365917444229, 0.01457709539681673, 0.0008498767274431884, -0.10706101357936859,
    -0.05562591925263405, -0.007110150530934334, -0.01938789151608944, 0.026700546965003014, -0.001119240652769804, 0.08705322444438934, 0.004440987948328257, -0.014648037031292915,
    0.042978741228580475, -0.013721128925681114, -0.04924560710787773, 0.036578450351953506, 0.07458093017339706, 0.11152081191539764, 0.025477701798081398, -0.06159614399075508,
    -0.03479430079460144, -0.016842372715473175, 0.07721070945262909, 0.002148781204596162, -0.027473298832774162, -0.03889979049563408, 0.008847768418490887, -0.04249002784490585,
    0.018277674913406372, 0.08573903888463974, 0.020084897056221962, -0.03885774686932564, -0.02588757686316967, 0.029501792043447495, -0.07240217924118042, 0.047867510467767715,
    0.03968523070216179, 0.14317354559898376, -0.1209539920091629, 0.020549524575471878, 0.017877928912639618, 0.02231440134346485, 0.022512171417474747, 0.002044451190158725,
    0.02515384368598461, -0.036922309547662735, -0.08153869956731796, 0.03886845335364342, 0.06634029000997543, 0.0022371874656528234, -0.10521896183490753, 0.023335382342338562,
    -0.009240790270268917, -0.003392979269847274, 0.05523458123207092, -0.06953492760658264, -0.04661521688103676, -0.08086858689785004, -0.05451101437211037, -0.06102384626865387,
    0.030486227944493294, 0.03697230666875839, 0.031533826142549515, -0.04058657959103584, -0.0434369333088398, 0.048790156841278076, -0.022112729027867317, 0.02458261139690876,
    0.03270280361175537, 0.0004767907375935465, 0.03527071326971054, 0.005424888804554939, 0.06727251410484314, -0.012727095745503902, 0.026305798441171646, 0.013326418586075306,
    -0.07380040735006332, -0.007210648152977228, 0.03877994045615196, -0.014973451383411884, -0.04858127981424332, -0.00602780282497406, -0.021248551085591316, -0.06933075189590454,
    -0.0037164101377129555, 0.014311620034277439, -0.008876007981598377, 0.024177435785531998, -0.01069975458085537, 0.07751592993736267, -0.036004215478897095, -0.0968794971704483,
    -0.01417293306440115, -0.010110759176313877, 0.01705276221036911, -0.06581786274909973, 0.0143765052780509, -0.05812336131930351, -0.06660677492618561, -0.0032651571091264486,
    0.17126791179180145, 0.06170250475406647, 6.38006895314902e-05, 0.015430504456162453, 0.155204176902771, 0.0037099774926900864, -0.030218904837965965, -0.020579874515533447,
    -0.05234907194972038, 0.009265029802918434, -0.03473205491900444, 0.04050428047776222, 0.018605176359415054, -0.051812831312417984, 0.06817597895860672, 0.0050970809534192085,
    0.021103261038661003, -0.026330744847655296, 0.028916794806718826, 0.055431582033634186, -0.11712003499269485, -0.009232226759195328, -0.0840080976486206, -0.03609221801161766,
    -0.01122280489653349, 0.04054172709584236, -0.021387090906500816, -0.012755999341607094, 0.21173490583896637, -0.012337320484220982, -0.08089056611061096, -0.13584797084331512,
    0.006370648741722107, -0.028469284996390343, -0.025120260193943977, -0.00376743427477777, -0.026969723403453827, 0.02051876112818718, -0.05644417554140091, 0.0029895296320319176,
    -0.012781924568116665, -0.1271354854106903, -0.0715990886092186, -0.012862836010754108, 0.05803497135639191, -0.03998749703168869, 0.05199510604143143, 0.024360090494155884,
    -0.015625540167093277, 0.0528072752058506, 0.02031860128045082, -0.006266651675105095, -0.058077458292245865, 0.0221362616866827, -0.020409340038895607, 0.02145523391664028,
    0.044094596058130264, 0.014050452969968319, 0.0332648903131485, 0.02081918716430664, -0.03538626804947853, -0.006956575904041529, -0.0360076017677784, 0.025358660146594048,
    -0.00363384117372334, 0.03196010738611221, -0.1954755187034607, 0.05110401660203934, 0.007574087008833885, -0.024750173091888428, 0.04762785881757736, 0.003047897946089506,
    -0.02894592098891735, 0.047603461891412735, 0.06230905279517174, 0.13766928017139435, -0.04592491313815117, -0.03374570608139038, -0.06262315809726715, -0.022129610180854797,
    -0.005108613520860672, 0.0124457823112607, -0.02509106881916523, -0.03194444254040718, 0.034140653908252716, 0.02464866451919079, -0.05768178030848503, -0.00872823502868414,
    -0.025806909427046776, 0.040161795914173126, -0.04463069885969162, 0.03483745828270912, -0.043495338410139084, -0.06169502064585686, 0.02371656335890293, -0.009427639655768871,
    -0.0018871491774916649, -0.002283066511154175, -0.013846373185515404, 0.0001839943724917248, 0.09126558154821396, 0.020239638164639473, -0.08428224176168442, -0.027371620759367943,
    -0.008077439852058887, 0.08293182402849197, 0.0706624761223793, 0.06082824990153313, -0.043351419270038605, -0.02454780973494053, -0.019258027896285057, 0.07207304239273071,
    0.02646057866513729, -0.022366812452673912, 0.01879085972905159, -0.05761578679084778, 0.0032994928769767284, 0.06670426577329636, 0.07234331965446472, 0.1102537289261818,
    0.01979949325323105, -0.023309046402573586, -0.020762715488672256, -0.002194112166762352, 0.022450974211096764, 0.0011453970801085234, -0.05868058651685715, -0.05765758454799652,
    0.19000834226608276, 0.045091353356838226, 0.004138306248933077, -0.004402872174978256, -0.0545453205704689, 0.06080508232116699, -0.00839956197887659, 0.028705619275569916,
    -0.07358652353286743, 0.0383494570851326, 0.01082644797861576, -0.009649362415075302, 0.053088754415512085, -0.14828646183013916, -0.006819623522460461, -0.017415523529052734,
    0.07041233777999878, 0.06541673094034195, 0.02484056167304516, -0.09094711393117905, 0.002621998777613044, -0.0044537256471812725, -0.030352238565683365, 0.0019754923414438963,
    0.05356891453266144, -0.04955220967531204, -0.00445633614435792, 0.007611425127834082, 0.24369201064109802, 0.04332810267806053, 0.0023303155321627855, -0.15472744405269623,
    -0.031263317912817, -0.0749456137418747, -0.027021946385502815, -0.014672250486910343, -0.08693363517522812, 0.025568697601556778, -0.11412132531404495, -0.07192521542310715,
    -0.06402671337127686, -0.14817777276039124, -0.06488154083490372, -0.006192720960825682, 0.058111537247896194, 0.01257278211414814, 0.01879459246993065, -0.0727342963218689,
    0.015559591352939606, 0.10792629420757294, -0.050626397132873535, -0.022099940106272697, -0.060783304274082184, 0.017999406903982162, -0.001252262620255351, -0.04921162873506546,
    -0.02091672457754612, -0.029360834509134293, -0.017137838527560234, -0.029702406376600266, -0.02967320941388607, 0.02122088521718979, 0.08191994577646255, -0.010517081245779991,
    -0.06766383349895477, -0.0027007178869098425, -0.11828502267599106, -0.0189810860902071, -0.0019829128868877888, -0.06836430728435516, -0.07529957592487335, -0.07370783388614655,
    -0.02181108295917511, 0.029744992032647133, 0.07955296337604523, 0.05800704285502434, -0.005227414891123772, -0.07300053536891937, -0.01763787679374218, 0.018077760934829712,
    -0.020108498632907867, -0.004702977370470762, 0.02593427337706089, 0.03962583467364311, -0.02475637011229992, 0.048557087779045105, 0.07634204626083374, -0.011868840083479881,
    -0.03917175531387329, -0.009248984977602959, -0.013327295891940594, 0.010879231616854668, 0.03417176380753517, -0.06252127140760422, 0.06641609221696854, -0.042096082121133804,
    -0.027830520644783974, 0.008701017126441002, -0.0020675731357187033, -0.004648879170417786, 0.08294659852981567, -0.06870889663696289, 0.03798892721533775, 0.06301853805780411,
    -0.02711733989417553, 0.059147000312805176, -0.03185872733592987, -0.0053179883398115635, 0.02599250338971615, -0.096791110932827, 0.02742612734436989, -0.004080162849277258,
    0.01663086749613285, -0.040627703070640564, 0.11000388860702515, -0.010238355956971645, 0.008225872181355953, 0.09118437767028809, 0.01786152273416519, 0.13945752382278442,
    -0.08071895688772202, 0.028046803548932076, 0.04012753441929817, 0.025696327909827232, -0.027401981875300407, -0.0052593667060136795, -0.02093718945980072, -0.02755543775856495,
    0.13244786858558655, -0.06651246547698975, -0.02296089194715023, 0.0019926251843571663, -0.008687886409461498, 0.01249666791409254, -0.02713177166879177, -0.010285666212439537,
    -0.047154687345027924, -0.053297676146030426, 0.013833463191986084, -0.04983733221888542, 0.007256460376083851, -0.03096182644367218, 0.039942920207977295, 0.019749516621232033,
    0.06297144293785095, 0.01765712909400463, 0.07324648648500443, -0.03270597383379936, -0.03783310577273369, -0.028017627075314522, 0.003193334210664034, -0.041077300906181335,
    0.01134002860635519, -0.04291263222694397, 0.05096050724387169, 0.016964517533779144, 0.20390579104423523, -0.046826645731925964, 0.02756592258810997, -0.08783494681119919,
    -0.020471731200814247, -0.11843740195035934, -0.019791366532444954, -0.023758644238114357, -0.03161657601594925, 0.08794527500867844, -0.05441286414861679, -0.0671628937125206,
    0.05764109641313553, -0.1969546526670456, -0.0013991674641147256, 0.026380961760878563, -0.034115005284547806, -0.010991610586643219, -0.024118416011333466, -0.05152376741170883,
    0.014403284527361393, 0.14571894705295563, 0.008469372987747192, 0.006570116151124239, -0.05528857558965683, 0.006191898602992296, -0.019434411078691483, 0.029173534363508224,
    0.01985606737434864, -0.01962772011756897, -0.0570712685585022, 0.06200917437672615, 0.07078094780445099, 0.03653113543987274, 0.08035994321107864, 0.03268369287252426,
    0.023314569145441055, 0.009251851588487625, -0.126700758934021, -0.03337470814585686, -0.09132836759090424, 0.03008595108985901, 0.0009724746341817081, 0.04538862779736519,
    -0.05011013150215149, -0.07394295930862427, -0.09332989156246185, 0.015591718256473541, 0.046509452164173126, -0.019598985090851784, -0.0405597947537899, -0.0034991831053048372,
    0.010659098625183105, -0.015147804282605648, 0.04546458646655083, 0.07941757142543793, -0.0662781223654747, 0.0700983852148056, -0.1043483167886734, -0.018968744203448296,
    0.03765847161412239, -0.013012463226914406, -0.04814424365758896, 0.0009371523046866059, 0.0039141615852713585, 0.056565847247838974, -0.06235881894826889, 0.02073439210653305,
    -0.015591763891279697, 0.006105450447648764, -0.018290812149643898, 0.020081568509340286, 0.030419014394283295, 0.09888405352830887, 0.027189424261450768, 0.05062638595700264,
    0.0866100862622261, 0.05412520468235016, 0.11409207433462143, -0.06377866119146347, -0.0076102204620838165, -0.09384417533874512, -0.038609009236097336, -0.05664407089352608,
    0.046319615095853806, -0.007318982854485512, 0.10641133785247803, -0.05816184729337692, -0.0003997691674157977, 0.03848930820822716, 0.008815049193799496, -0.07037986814975739,
    -0.044341664761304855, 0.04257947579026222, 0.011160686612129211, 0.0391065739095211, -0.007513092365115881, 0.053171250969171524, 0.03153318539261818, 0.06016312167048454,
    0.10890407115221024, -0.05189914256334305, 0.029572106897830963, 0.054918039590120316, 0.03807063028216362, -0.029715480282902718, 0.0218899417668581, 0.026103151962161064,
    -0.04614695906639099, 0.0027129470836371183, 0.05859755352139473, -0.033136118203401566, 0.008329623378813267, 0.059264007955789566, 0.0017998391995206475, 0.04158457741141319,
    -0.03318469971418381, -0.06346168369054794, 0.025083476677536964, -0.10391722619533539, -0.10129581391811371, -0.03846348822116852, 0.016125302761793137, 0.005249691661447287,
    -0.01836523786187172, 0.01275702379643917, -0.005645862314850092, -0.016167225316166878, 0.17356610298156738, 0.01737232506275177, 0.10329854488372803, -0.12826743721961975,
    0.004973005037754774, -0.08090347796678543, -0.006659465841948986, 0.022123323753476143, -0.031025301665067673, 0.007937910966575146, -0.010949656367301941, -0.012018916197121143,
    0.03964431956410408, -0.2024240493774414, -0.004873363766819239, -0.02931865118443966, 0.037557005882263184, -0.006746684666723013, 0.0027735522016882896, 0.020605504512786865,
    0.0020685801282525063, 0.1923961639404297, 0.039584461599588394, -0.01269462238997221, -0.05861060321331024, -0.0011968036415055394, 0.02416413091123104, -0.02660507522523403,
    0.02580857276916504, 0.03329367935657501, -0.027946829795837402, 0.003975680097937584, 0.07757400721311569, -0.018415628001093864, 0.04684137552976608, -0.018748287111520767,
    0.004506219644099474, 0.09694257378578186, -0.11727595329284668, -0.022672176361083984, 0.003584509016945958, -0.04037577286362648, 0.007903870195150375, -0.011369841173291206,
    -0.03886353597044945, 0.030103474855422974, 0.023948868736624718, 0.024380482733249664, -0.020092027261853218, -0.003417949192225933, 0.10912233591079712, -0.01867799647152424,
    -0.0042340452782809734, -0.004455961752682924, 0.014024457894265652, 0.08575962483882904, -0.033802445977926254, 0.04353460296988487, -0.016636956483125687, 0.08645565807819366,
    0.03656027466058731, -0.07193177938461304, -0.004817538894712925, -0.037686362862586975, 0.04765545576810837, -0.020826969295740128, 0.04827427491545677, -0.05809027701616287,
    -0.0158122219145298, 0.002967085922136903, -0.04957849159836769, 0.002902991371229291, 0.0641697347164154, -0.012385131791234016, -0.036313146352767944, -0.04430205374956131,
    -0.002688800683245063, -0.03044438734650612, -0.019682614132761955, 0.006990240421146154, -0.004184463061392307, 0.05107215791940689, 0.04041879624128342, 0.00795443169772625,
    0.003055891254916787, 0.030497103929519653, 0.04361649975180626, -0.004656331613659859, -0.006007747258991003, 0.06593525409698486, -0.008124690502882004, -0.07346626371145248,
    -0.04891056939959526, 0.04498780146241188, -0.015294968150556087, 0.01928345113992691, -0.04126017913222313, -0.014885077252984047, -0.09801393747329712, 0.0651160329580307,
    0.08231548964977264, 0.013628515414893627, -0.03982401639223099, -0.0530473068356514, 0.10557592660188675, 0.009789548814296722, -0.03631008788943291, -0.0728973001241684,
    -0.08094075322151184, 0.02127760648727417, 0.06226120889186859, -0.014381933957338333, -0.022189157083630562, 0.18630212545394897, -0.09361456334590912, 0.023120705038309097,
    -0.017806626856327057, -0.02195512130856514, 0.03708157688379288, -0.07074104249477386, -0.14072030782699585, 8.135968528222293e-05, -0.011282239109277725, -0.07447013258934021,
    0.013639039359986782, 0.012563989497721195, -0.058546025305986404, 0.008686884306371212, 0.24908305704593658, 0.015810053795576096, 0.05988672003149986, -0.1630738377571106,
    0.020859967917203903, -0.06394066661596298, -0.05061708018183708, -0.1019202396273613, -0.0377015694975853, 0.043473515659570694, -0.035099830478429794, -0.014672559686005116,
    0.0008055291837081313, -0.15326423943042755, 0.04525349661707878, 0.08885154873132706, -0.07198143005371094, -0.01876993663609028, -0.04863973706960678, 0.01633521169424057,
    -0.002091603586450219, 0.18571490049362183, -0.020140191540122032, -0.011724703013896942, -0.03116823360323906, 0.032391104847192764, -0.0076423510909080505, 0.05651894956827164,
    0.04796091094613075, -0.02342972531914711, 0.003986815921962261, 0.024408547207713127, -0.02071426250040531, 0.01655471697449684, -0.005496948026120663, 0.00023491492902394384,
    -0.08395131677389145, 0.08391331881284714, -0.07753563672304153, 0.04135360196232796, -0.0018151606200262904, -0.009132185950875282, -0.008557312190532684, -0.014785020612180233,
    0.029186245054006577, 0.011488297022879124, 0.0604923740029335, 0.021377896890044212, 0.08365438878536224, -0.006846616975963116, 0.09853911399841309, -0.03425857797265053,
    -0.002244034316390753, 0.0004385968204587698, -0.054322000592947006, -0.02807489037513733, -0.010128198191523552, -0.11260628700256348, 0.04024932533502579, 0.0038960964884608984,
    0.015417973510921001, -0.020781584084033966, 0.08124712854623795, 0.0794944241642952, 0.0010477392934262753, -0.01463623158633709, 0.11067492514848709, -0.028597678989171982,
    0.018956920132040977, 0.034965284168720245, -0.01692015491425991, -0.0362236350774765, 0.0074600582011044025, 0.03722557798027992, 0.00976706761866808, 0.04256528243422508,
    0.020570486783981323, -0.012633517384529114, 0.04173200950026512, 0.021781794726848602, 0.018156809732317924, -0.0040934220887720585, -0.06156916916370392, 0.004335185047239065,
    -0.0005226345965638757, 0.011740043759346008, 0.062116824090480804, -0.01707363687455654, 0.04200970381498337, 0.01203718688338995, 0.09919294714927673, -0.035817790776491165,
    -0.017717523500323296, -0.05151714012026787, 0.027425935491919518, 0.01564166508615017, 0.005498029291629791, -0.05626062676310539, 0.06480751186609268, -0.10675109922885895,
    0.10411858558654785, -0.011524204164743423, 0.02299249731004238, 0.06178435683250427, 0.021481243893504143, 0.007905733771622181, 0.015549306757748127, 0.084547258913517,
    -0.056511055678129196, -0.033043935894966125, 0.06960127502679825, -0.002478266367688775, 0.04576808214187622, 0.13694483041763306, -0.0632561445236206, 0.025509634986519814,
    -0.013546552509069443, -0.0346641018986702, 0.07839379459619522, -0.08286067843437195, -0.11803121119737625, -0.012724614702165127, 0.04016691446304321, -0.01328632514923811,
    0.026187600567936897, 0.09426365792751312, 0.04997949302196503, 0.028236420825123787, 0.18471719324588776, -0.026982702314853668, 0.11759304255247116, -0.12963911890983582,
    0.02456766925752163, -0.02560105361044407, 0.039210449904203415, -0.020829686895012856, -0.08421910554170609, 0.061968471854925156, -0.024009058251976967, -0.022583095356822014,
    -0.014863689430058002, -0.13710549473762512, 0.016629550606012344, -0.05100531131029129, 0.04941058158874512, -0.016253773123025894, -0.016791798174381256, -0.09359368681907654,
    0.028028899803757668, 0.17509135603904724, 0.0016422884073108435, 0.0016790051013231277, 0.033038388937711716, 0.01088206097483635, 0.034679073840379715, -0.07068523019552231,
    0.036777563393116, -0.00011237289436394349, -0.008448258973658085, -0.02145836502313614, 0.005028631072491407, 0.025510059669613838, 0.08417943120002747, 0.02704906091094017,
    0.011163609102368355, 0.10568530112504959, -0.021248964592814445, -0.05714552477002144, -0.045602764934301376, -0.04115598648786545, 0.010140771977603436, -0.03233880177140236,
    0.03616069629788399, 0.006380863953381777, -0.05142691731452942, 0.013018754310905933, -0.017359524965286255, 0.057208351790905, 0.09371650218963623, 0.00864739716053009,
    0.03058384545147419, 0.0020381228532642126, -0.02602517604827881, -0.07482773065567017, 0.05082240328192711, -0.15617576241493225, 0.02281811833381653, -0.012971768155694008,
    0.014614825136959553, -0.000579334853682667, -0.010282848961651325, 0.023433364927768707, -0.014052771031856537, -0.0007498680497519672, 0.05111878365278244, -0.01327288243919611,
    -0.005842700134962797, 0.003130381228402257, -0.06836268305778503, 0.022518066689372063, 0.1585584580898285, -0.03587007150053978, 0.046849437057971954, -0.00724097341299057,
    -0.03571685403585434, -0.09711184352636337, -0.02724330499768257, 0.05642589181661606, -0.052598632872104645, 0.022493558004498482, -0.03325371816754341, -0.006163845304399729,
    0.0366290919482708, -0.029355265200138092, 0.05818793922662735, 0.008145615458488464, 0.014272993430495262, -0.022161321714520454, 0.0604725256562233, 0.01822437159717083,
    -0.00997889507561922, -0.0018428890034556389, -0.015073939226567745, -0.012305404990911484, 0.016686884686350822, -0.008809269405901432, 0.01379580982029438, 0.06994669139385223,
    0.12327659130096436, -0.03429671749472618, -0.05183026194572449, 0.0885489284992218, 0.025918761268258095, 0.04762287065386772, -0.011473125778138638, -0.08687949180603027,
    -0.06597254425287247, -0.09713505208492279, 0.038465023040771484, -0.023669103160500526, 0.045185260474681854, 0.01635635830461979, 0.023538723587989807, 0.02659507654607296,
    0.031422536820173264, -0.007551288232207298, 0.014852959662675858, -0.12367081642150879, -0.12538358569145203, -0.021890955045819283, -0.012731165625154972, -0.07940255850553513,
    -0.009130696766078472, -0.0035875483881682158, -0.019659459590911865, -0.007656035479158163, 0.15698926150798798, 6.341114931274205e-05, 0.04432883858680725, -0.0997353345155716,
    0.0021491253282874823, -0.11150116473436356, -0.0195370614528656, -0.10647627711296082, -0.05688222870230675, 0.11714661121368408, -0.07923346757888794, -0.014394096098840237,
    0.03403088450431824, -0.15906922519207, 0.02575518563389778, -0.01512613333761692, 0.022873131558299065, 0.10251887887716293, -0.004596798215061426, -0.034287601709365845,
    0.0022704978473484516, 0.0444747619330883, 0.023483863100409508, -0.024207955226302147, 0.0011694254353642464, 0.05277019739151001, 0.0018734741024672985, 0.051410429179668427,
    0.08223387598991394, -0.029353270307183266, 0.04214249551296234, -0.015067348256707191, 0.0062602199614048, -0.03784367814660072, 0.08376094698905945, 0.06822824478149414,
    -0.026125222444534302, -0.05236221104860306, 0.042763594537973404, -0.03207703307271004, 0.02587968483567238, -0.012166081927716732, -0.003749396186321974, 0.013843955472111702,
    0.08389594405889511, -0.015903040766716003, -0.014483890496194363, -0.013418125919997692, -0.0014644571347162127, 0.019959790632128716, 0.07087227702140808, -0.08787225931882858,
    0.011795634403824806, -0.02293997071683407, 0.012035394087433815, -0.08997443318367004, -0.03138924762606621, -0.10161899030208588, 0.018002651631832123, 0.07190212607383728,
    0.0010640912223607302, 0.027928626164793968, -0.025965312495827675, -0.028505101799964905, 0.008707785978913307, 0.004302289802581072, 0.006953717675060034, 0.05534879490733147,
    -0.02159314602613449, -0.027989912778139114, -0.12144005298614502, 0.025550073012709618, 0.0968892052769661, 0.032547298818826675, -0.06890179961919785, -0.018012773245573044,
    -0.01156334113329649, -0.011198609136044979, 0.12177006155252457, -0.008782492019236088, -0.0051577030681073666, -0.036801572889089584, -0.016180571168661118, 0.04093499481678009,
    0.05354570224881172, -0.08254548907279968, -0.02030697651207447, -0.009740258567035198, 0.05399266257882118, 0.07015252858400345, -0.009467086754739285, 0.030043674632906914,
    -0.007869399152696133, -0.011476123705506325, 0.006855555810034275, 0.05277058482170105, -0.013865903951227665, -0.0236668661236763, 0.11100172996520996, 0.01683344505727291,
    0.11153461039066315, 0.03284921869635582, 0.016600048169493675, 0.058623168617486954, -0.11557584255933762, -0.012770803645253181, -0.011581686325371265, 0.07652083039283752,
    -0.08093280345201492, 0.022745873779058456, 0.1225653737783432, -0.006005368661135435, 0.07361859083175659, 0.05154965817928314, 0.0010196571238338947, 0.02019047737121582,
    -0.08964953571557999, -0.07696834206581116, 0.015673533082008362, -0.10419537127017975, -0.08690868318080902, -0.022539526224136353, 0.001946672098711133, -0.02799287997186184,
    -0.05033046752214432, 0.004667791537940502, -0.05779793858528137, -0.03918867185711861, 0.1491793841123581, -0.0033087576739490032, 0.13204383850097656, -0.10904798656702042,
    -0.0001381209585815668, -0.08527819812297821, 0.014603892341256142, -0.05596373975276947, -0.08509130030870438, 0.12235724180936813, -0.01334728766232729, -0.0027441063430160284,
    0.01626427285373211, -0.12243519723415375, -0.06356791406869888, 0.035903073847293854, 0.03498110920190811, 0.006434361916035414, 0.031775977462530136, -0.03704821690917015,
    -0.013586362823843956, -0.013277490623295307, -0.008358203805983067, 0.019179513677954674, -0.00798159558326006, -0.031036242842674255, -0.008212833665311337, -0.0537441112101078,
    -0.007106452248990536, 0.017288312315940857, -0.031050963327288628, -0.03148346021771431, 0.09251953661441803, -0.02353847213089466, 0.06932522356510162, -0.007914761081337929,
    -0.04385416954755783, 0.0723111554980278, 0.03212710842490196, -0.05063485726714134, -0.025232966989278793, -0.08325234800577164, 0.019271552562713623, -0.028676938265562057,
    0.03518099710345268, 0.05549289658665657, -0.01864125393331051, -0.015797892585396767, 0.032319288700819016, 0.02777639962732792, 0.1537981629371643, -0.021213920786976814,
    0.06218938156962395, 0.03204236552119255, -0.001662581809796393, 0.0220993310213089, 0.012199630960822105, 0.04841654375195503, -0.011309555731713772, 0.02303951419889927,
    0.014571022242307663, -0.03508273512125015, -0.009310094639658928, 0.0322677344083786, -0.050114840269088745, -0.05075397714972496, 0.040456876158714294, -0.01784500852227211,
    -0.03082219511270523, 0.03302978351712227, -0.09286800771951675, 0.0158246923238039, 0.038946766406297684, -0.049400363117456436, 0.016173919662833214, -0.028935857117176056,
    -0.026203682646155357, -0.0077148545533418655, -0.007598483469337225, -0.036464400589466095, 0.012148804031312466, 0.020205283537507057, -0.010641999542713165, -0.03402183577418327,
    0.057846151292324066, -0.020195115357637405, 0.0015810882905498147, -0.04209785535931587, -0.037015996873378754, 0.05660014972090721, 0.017332663759589195, -0.06977105885744095,
    -0.009041146375238895, 0.0088656609877944, -0.01679299771785736, 0.017896141856908798, 0.042227089405059814, -0.006798306945711374, -0.07402878254652023, 0.0495988205075264,
    0.0627194419503212, 0.014095582067966461, -0.015776973217725754, -0.010129600763320923, 0.0192314051091671, 0.005787699017673731, -0.057501353323459625, -0.03581986203789711,
    -0.08923771977424622, -0.005806365981698036, 0.11455030739307404, 0.028612950816750526, -0.0163069199770689, 0.033389464020729065, -0.021979931741952896, 0.03521318361163139,
    -0.050993312150239944, -0.07157900184392929, -0.007750239688903093, -0.03978397697210312, -0.05779843404889107, 0.0005248935194686055, -0.001244518905878067, 0.05503762513399124,
    -0.0040366314351558685, -0.00984027050435543, 0.005052746739238501, 0.007725950796157122, 0.1976795345544815, -0.05457497388124466, 0.11068335175514221, -0.06973828375339508,
    0.045081015676259995, -0.02773994207382202, -0.033967696130275726, -0.05611946061253548, -0.019298670813441277, 0.09995531290769577, -0.0510399155318737, 0.01761232130229473,
    -0.010862351395189762, -0.04992368817329407, -0.009610878303647041, -0.003434313926845789, -0.022045347839593887, 0.046218954026699066, 0.012294544838368893, 0.007940027862787247,
    0.012874855659902096, -0.07660439610481262, -0.010568932630121708, -0.011426150798797607, -0.001961024245247245, 0.026201996952295303, -0.022063465788960457, 0.09103407710790634,
    0.02694329433143139, 0.017682552337646484, -0.06141762062907219, -0.06369766592979431, -0.025539491325616837, -0.011196920648217201, 0.07165957242250443, 0.035667452961206436,
    -0.006557589862495661, 0.06402883678674698, -0.008468936197459698, 0.008544264361262321, -0.0004952294402755797, 0.03582866117358208, -0.018738387152552605, -0.022464219480752945,
    0.1174246296286583, 0.0326615646481514, -0.08309238404035568, -0.0018069171346724033, 0.013567586429417133, -0.03353811427950859, 0.16570225358009338, -0.07949342578649521,
    0.027875613421201706, -0.026891089975833893, -0.057897914201021194, 0.05141368508338928, -0.048449691385030746, 0.16221576929092407, -0.0037478094454854727, 0.0035267379134893417,
    -0.0035533232148736715, -0.008701547048985958, -0.016109546646475792, -0.011714841239154339, -0.07292447239160538, -0.010067181661725044, -0.05703875049948692, 0.013976163230836391,
    0.020520193502306938, -0.018790505826473236, -0.023519789800047874, -0.0030664990190416574, -0.02497497759759426, 0.07865431904792786, 0.017241764813661575, -0.045659467577934265,
    0.018818801268935204, 0.06834592670202255, 0.05895658954977989, 0.03952503949403763, 0.002599736675620079, 0.049306243658065796, -0.020934347063302994, 0.0017532106721773744,
    0.05975654721260071, -0.015425092540681362, 0.0075296969152987, 0.004813272971659899, -0.014445486478507519, 0.061563655734062195, -0.022322800010442734, -0.02791338786482811,
    0.011394664645195007, 0.044402919709682465, -0.003990494180470705, 0.04778216406702995, -0.03764093667268753, 0.00852220505475998, -0.060763321816921234, -0.048752956092357635,
    0.013096454553306103, 0.01856437511742115, 0.011125052347779274, 0.09876248985528946, -0.038252510130405426, -0.005957665387541056, 0.03963784500956535, 0.006062312982976437,
    -0.028033478185534477, -0.0026380340568721294, 0.10671114176511765, 0.0375862792134285, 0.02707795426249504, -0.04339729622006416, -0.039409246295690536, 0.02291799522936344,
    0.021653316915035248, -0.01499085407704115, 0.010805786587297916, -0.0372307263314724, -0.035580262541770935, 0.00010818836744874716, -0.012454245239496231, 0.09660632163286209,
    0.009602148085832596, 0.05509772524237633, 0.010617390275001526, 0.011316602118313313, 0.1510050892829895, -0.012589129619300365, 0.04083982855081558, -0.12426505982875824,
    0.02685541845858097, -0.06478805094957352, 0.06531029939651489, -0.02724427729845047, -0.03055877424776554, 0.053587786853313446, -0.03988879546523094, 0.013049475848674774,
    0.036750514060258865, -0.07613156735897064, -0.02998225763440132, -0.0035976998042315245, 0.06897607445716858, -0.0174291729927063, -0.04776052385568619, -0.0159202478826046,
    0.05034743621945381, -0.04234955087304115, 0.01530459150671959, -0.0031763219740241766, 0.07918966561555862, 0.005277690477669239, -0.0023822039365768433, -0.09869365394115448,
    0.056624360382556915, -0.006702929735183716, 0.034578125923871994, 0.014877521432936192, -0.046081285923719406, -0.0041451966390013695, 0.049917154014110565, -0.007688642013818026,
    0.03415840491652489, 0.09957156330347061, 0.05844968557357788, 0.04970017820596695, -0.005088793113827705, -0.03323358669877052, -0.004237680230289698, 0.05483565479516983,
    0.12749750912189484, 0.007367054466158152, -0.02550077624619007, 0.040423691272735596, 0.0004047187394462526, 0.006463200785219669, 0.17106233537197113, 0.01071083452552557,
    0.09109604358673096, 0.03166598454117775, 0.026625484228134155, 0.10400178283452988, -0.08388572931289673, 0.12400009483098984, 0.0102929025888443, 0.02509799599647522,
    0.04637695476412773, -0.022141452878713608, 0.008764955215156078, 0.012349635362625122, -0.03259403631091118, 0.015287945978343487, -0.0010019461624324322, -0.0013165987329557538,
    0.056350674480199814, 0.036984700709581375, -0.03561725839972496, -0.009847559966146946, 0.09148503094911575, -0.02619238570332527, -0.04252041503787041, -0.02688032016158104,
    0.03403667360544205, 0.07480282336473465, 0.09856503456830978, 0.023566681891679764, 0.005223928019404411, -0.036736104637384415, 0.04168786108493805, -0.05147717148065567,
    -0.0075127431191504, -0.037452004849910736, 0.1006213054060936, 0.018452007323503494, 0.017860179767012596, 0.07052043080329895, -0.005593918729573488, -0.052697617560625076,
    0.040219951421022415, 0.009488490410149097, -0.01075178012251854, 0.05584936589002609, -0.02330644428730011, 0.02828768827021122, -0.0301953312009573, 0.050838664174079895,
    0.00036246018134988844, -0.06964326649904251, -0.0007288501947186887, 0.06377716362476349, -4.7823283239267766e-05, -0.03263062983751297, -0.07455883920192719, -0.009086855687201023,
    -0.03464860841631889, 0.042565278708934784, 0.10311346501111984, 0.06630738824605942, -0.01923994906246662, -0.1033318042755127, -0.028324656188488007, 0.0004460118943825364,
    -0.09407155215740204, -0.008558669127523899, -0.033849719911813736, -0.03847470507025719, -0.003170380834490061, -0.09858114272356033, -0.01689780503511429, -0.010503756813704967,
    -0.02889821119606495, 0.06709035485982895, 0.020922239869832993, 0.041409093886613846, 0.1605454385280609, 0.04284575954079628, 0.06812028586864471, -0.19904185831546783,
    0.04926073178648949, -0.008749205619096756, 0.0021222017239779234, -0.0795007199048996, 0.012257229536771774, 0.09006433933973312, -0.04987763240933418, -0.008498947136104107,
    -0.05496068298816681, -0.05123182013630867, -0.07805690169334412, 0.010461774654686451, -0.02786722034215927, -0.033293355256319046, 0.001073906198143959, 0.017891516909003258,
    -0.003415408544242382, -0.10455984622240067, 0.015406795777380466, 0.016210677102208138, 0.01370739471167326, -0.004282857291400433, -0.014275108464062214, 0.026929175481200218,
    0.028262436389923096, -0.013778695836663246, 0.02549971640110016, -0.10148937255144119, -0.12686817348003387, 0.02081436663866043, 0.02734721079468727, 0.04251119866967201,
    0.01650799810886383, 0.07116644829511642, 0.019721146672964096, 0.025265062227845192, -0.013139897957444191, -0.046083446592092514, -0.022539876401424408, 0.023047763854265213,
    0.1671176254749298, -0.013046658597886562, 0.030931614339351654, 0.06482004374265671, -0.030392786487936974, -0.1274118572473526, 0.0681479200720787, -0.005359352566301823,
    0.05857059359550476, -0.028478870168328285, -0.022136550396680832, -0.010724437423050404, -0.07012686878442764, -0.08202861994504929, -0.015849648043513298, -0.040449801832437515,
    0.0037974293809384108, 0.029362594708800316, -0.0441843718290329, -0.000561398162972182, -0.07917240262031555, -0.014216517098248005, -0.046558938920497894, -0.02460768073797226,
    -0.054048504680395126, -0.03127630054950714, -0.021981757134199142, 0.022026553750038147, 0.0498158261179924, -0.006365336012095213, 0.025178221985697746, 0.05134548991918564,
    0.09528129547834396, 0.023174161091446877, 0.11928383260965347, 0.011009229347109795, -0.0025836778804659843, -0.010767842642962933, -0.04941956326365471, -0.0017248125514015555,
    0.0674661174416542, -0.006046734284609556, 0.09838050603866577, 0.010345561429858208, -0.03046855889260769, 0.05329233780503273, 0.019604593515396118, -0.005211837589740753,
    0.002360778860747814, 0.05029033496975899, -0.009015236049890518, 0.05210288614034653, 0.010481077246367931, 0.04200469329953194, 0.006913121324032545, 0.009169554337859154,
    0.020238440483808517, -0.044011909514665604, -0.014815709553658962, 0.07030010223388672, -0.01852063462138176, -0.006221619434654713, 0.043248217552900314, -0.033878717571496964,
    -0.06059316173195839, -0.06823410093784332, 0.013403991237282753, 0.02940589003264904, -0.006383521482348442, -0.038138508796691895, 0.010661565698683262, 0.002221878618001938,
    -0.09513047337532043, -0.02688157558441162, 0.03221401199698448, -0.04843718931078911, 0.017059102654457092, 0.0183554794639349, -0.02811216004192829, -0.03334946930408478,
    0.028292765840888023, 0.0005732106510549784, -0.0783630833029747, -0.03654388710856438, 0.10278057307004929, 0.024029456079006195, -0.011474422179162502, -0.0708765983581543,
    -0.01198661420494318, -0.062255315482616425, 0.056486353278160095, -0.05972206965088844, -0.05377986282110214, 0.0821426585316658, -0.022236060351133347, 0.00258019776083529,
    0.01851021870970726, -0.011681490577757359, -0.034563928842544556, -0.0021967063657939434, -0.048814285546541214, 0.03677857294678688, 0.033756379038095474, 0.016275465488433838,
    0.005599107127636671, -0.13611717522144318, -0.0626022145152092, -0.03108377382159233, -0.045525386929512024, 0.05986499786376953, -0.021786106750369072, -0.052580326795578,
    0.0129114193841815, -0.07256633788347244, -0.019804663956165314, 0.042468562722206116, -0.009910300374031067, 0.006889767944812775, -0.015685392543673515, -0.01895897462964058,
    -0.029508478939533234, 0.09345277398824692, 0.0039041428826749325, -0.01862243562936783, -0.1027912050485611, -0.018261844292283058, 0.007330236490815878, -0.00533802667632699,
    0.10650184750556946, -0.0008851393940858543, -0.09339689463376999, -0.01899944618344307, -0.050537992268800735, -0.013222914189100266, 0.056618716567754745, 0.04453142732381821,
    0.007122548762708902, 0.0056665376760065556, -0.027163434773683548, -0.09565556794404984, -0.10925069451332092, -0.1396009922027588, 0.03695361688733101, -0.0868082270026207,
    0.05263352394104004, 0.018258290365338326, 0.033221468329429626, 0.02147781103849411, -0.08504647761583328, 0.0006977125303819776, 0.05041416734457016, 0.014963885769248009,
    0.02398105338215828, 0.0013888473622500896, -0.057058628648519516, -0.016276270151138306, 0.07017215341329575, 0.07799306511878967, 0.013090526685118675, 0.09166201949119568,
    0.029219841584563255, -0.020875688642263412, 0.09052225947380066, 0.00885671004652977, 0.020322808995842934, -0.08390069752931595, 0.0288743544369936, -0.002336760750040412,
    0.013656075112521648, 0.00385113968513906, 0.10929611325263977, 0.02143344283103943, 0.015084453858435154, 0.06631913036108017, -0.018754949793219566, -0.0277548935264349,
    -0.02133275754749775, -0.06958059221506119, -0.02323697693645954, 0.06826668977737427, -0.0101073132827878, 0.07466194033622742, 0.0340239591896534, -0.03408403322100639,
    -0.0016987415729090571, -0.08398478478193283, 0.029676660895347595, -0.030047142878174782, -0.10949178040027618, 0.02045246958732605, 0.025317801162600517, 0.03314738720655441,
    -0.016041412949562073, 0.05160566419363022, 0.07060416042804718, 0.011247298680245876, 0.006520301103591919, -0.09209396690130234, -0.03148629516363144, 0.012268022634088993,
    -0.06703739613294601, -0.024503957480192184, -0.008963880129158497, -0.026012590155005455, 0.02884392812848091, -0.05140302702784538, -0.0033950121141970158, 0.008111929520964622,
    -0.026082688942551613, -0.017508354038000107, -0.03544210270047188, 0.009737873449921608, 0.1257382333278656, 0.06556469947099686, -0.03912564367055893, -0.08076372742652893,
    0.02945515140891075, -0.02026323601603508, -0.02897966466844082, -0.03288700431585312, -0.016756383702158928, 0.043176013976335526, -0.02635846845805645, -0.008139079436659813,
    -0.04887889325618744, 0.04377554729580879, -0.0036565151531249285, -0.006122225895524025, -0.022412076592445374, 0.00689696054905653, 0.0008591195801272988, -0.032175857573747635,
    0.020972661674022675, -0.11386751383543015, 0.026046553626656532, 0.027054712176322937, -0.03757133707404137, -0.026651082560420036, -0.006171537097543478, 0.04818704351782799,
    0.06892085075378418, 0.01796862855553627, 0.04598304256796837, -0.0029816876631230116, -0.027357272803783417, -0.008259679190814495, 0.006979243829846382, 0.04112781584262848,
    0.006235953886061907, 0.06070174276828766, -0.12501773238182068, 0.048509616404771805, -0.0782468244433403, 0.04402000457048416, -0.014753593131899834, 0.016779271885752678,
    0.018702732399106026, -0.04095727205276489, -0.05517847090959549, -0.03450002893805504, -0.026320869103074074, -0.018108772113919258, 0.06756825000047684, 0.03682737052440643,
    0.04366780072450638, 0.00656594755128026, -0.02534235641360283, -0.08780694752931595, -0.11391998827457428, 0.03494690731167793, -0.01752825640141964, -0.03616948053240776,
    0.01513341162353754, -0.0023494416382163763, 0.06373615562915802, 0.02571503259241581, -0.12355989962816238, -0.016936227679252625, -0.021274032071232796, -0.07884352654218674,
    0.08926506340503693, -0.004068988375365734, -0.0006436614785343409, 0.00033930919016711414, -0.012388627976179123, -0.03670736029744148, -0.04313364624977112, 0.025018218904733658,
    -0.06273450702428818, 0.013327467255294323, 0.08352557569742203, 0.04457808658480644, 0.08573327958583832, -0.042371902614831924, -0.034287188202142715, 0.04265696927905083,
    0.02871122397482395, -0.04265950620174408, 0.09475568681955338, 0.01866903528571129, -0.0003069818776566535, 0.008914945647120476, 0.05141225829720497, -0.01228332333266735,
    0.0223068967461586, -0.06989526003599167, 0.025502793490886688, -0.021623773500323296, -0.010464978404343128, 0.004863151349127293, -0.08291376382112503, -0.03448180854320526,
    -0.040048860013484955, -0.03298766165971756, -0.06663871556520462, 0.060831815004348755, 0.05419600382447243, 0.060500118881464005, 0.06180702522397041, -0.053680818527936935,
    0.004096657037734985, -0.00753889512270689, 0.018365994095802307, -0.013589771464467049, 0.012948542833328247, 0.022891076281666756, -0.023746980354189873, 0.0184034276753664,
    -0.04878174886107445, -0.06746703386306763, -0.007909443229436874, 0.04766516387462616, 0.030485741794109344, -0.006983689032495022, 0.03940674290060997, 0.03622328117489815,
    -0.02214699611067772, 0.0053661782294511795, -0.05333971977233887, 0.008710122667253017, 0.12306668609380722, 0.0036970244254916906, -0.01805337518453598, -0.07766808569431305,
    0.020380554720759392, -0.05683382228016853, 0.014466330409049988, -0.04937371239066124, -0.039041317999362946, 0.0014234012924134731, -0.027693793177604675, 0.01640986278653145,
    0.013188663870096207, -0.01138557679951191, 0.06219710782170296, 0.03349931165575981, -0.11509960889816284, 0.07630708813667297, 0.001766933361068368, 0.04366102069616318,
    -0.005912721157073975, -0.03036537952721119, 0.03120652586221695, -0.03612677380442619, 0.03876279294490814, 0.02647983655333519, 0.021683063358068466, 0.04233061894774437,
    0.024123216047883034, 0.04790357127785683, -0.014263048768043518, -0.013789097778499126, 0.023141834884881973, -0.0032381664495915174, -0.03835553675889969, 0.009344227612018585,
    0.025269359350204468, 0.05087631568312645, -0.023333292454481125, 0.03944762796163559, -0.07435041666030884, 0.04843434318900108, 0.021808937191963196, 0.07833988964557648,
    0.010202017612755299, -0.022682366892695427, -0.05607298016548157, 0.008278260007500648, -0.038686603307724, -0.019216109067201614, 0.012607204727828503, -0.0014645191840827465,
    0.057635728269815445, 0.034636955708265305, -0.02851344458758831, -0.026559973135590553, -0.1369367241859436, 0.0762026458978653, -0.01973397471010685, -0.11356846243143082,
    0.04031486064195633, 0.0010072907898575068, 0.02230321802198887, 0.0741327553987503, -0.0993097648024559, -0.029486678540706635, -0.03508378937840462, -0.004030520562082529,
    0.0867985263466835, 0.018900230526924133, 0.03683936968445778, -0.029662679880857468, -0.022841179743409157, 0.08369564265012741, -0.018918633460998535, 0.10471104085445404,
    0.01727011241018772, 0.020341331139206886, 0.082291379570961, -0.0018237901385873556, 0.03761175647377968, 0.047581616789102554, -0.013145891949534416, 0.01150928158313036,
    -0.005723151843994856, 0.02041667327284813, 0.05929968133568764, 0.05244666337966919, -0.02756146341562271, 0.053132131695747375, 0.03756649047136307, -0.03552437573671341,
    -0.011627993546426296, -0.050934597849845886, -0.027535181492567062, 0.04976038634777069, -0.027395080775022507, -0.019525699317455292, 0.024066301062703133, -0.033344268798828125,
    -0.02443491294980049, -0.07734913378953934, 0.014399893581867218, 0.026150746271014214, 0.04415978491306305, -0.04242337867617607, 0.01657855696976185, 0.0519021600484848,
    0.014617559500038624, 0.05914843827486038, 0.08727893978357315, 0.029018910601735115, -0.001930678030475974, 0.06275136768817902, 0.08748956024646759, -0.016473323106765747,
    -0.10332217067480087, -0.0019978948403149843, 0.044501084834337234, -0.10629057139158249, 0.055658623576164246, -0.07515620440244675, 0.01838078908622265, 0.04047666862607002,
    0.06033513322472572, -0.005268642213195562, 0.010601797141134739, 0.02297574281692505, 0.08252466470003128, 0.039283107966184616, -0.07918574661016464, -0.08946646749973297,
    -0.028100747615098953, -0.07370558381080627, 0.02639254927635193, -0.04235134646296501, -0.05212379992008209, -0.00040677504148334265, 0.018074730411171913, 0.022317053750157356,
    -0.07423405349254608, 0.006896772421896458, 0.01150349248200655, -0.045493558049201965, -0.03448266535997391, 0.035847995430231094, 0.028482938185334206, 0.10515919327735901,
    -0.010546280071139336, 0.015282446518540382, -0.013618790544569492, -0.028263933956623077, 0.0018273346358910203, 0.023188738152384758, 0.02822110429406166, -0.02218000777065754,
    -0.0035766868386417627, -0.014402788132429123, 0.03293310105800629, 0.005233978386968374, -0.0507621206343174, -0.029258480295538902, 0.007714990060776472, -0.04909028857946396,
    -0.041484285145998, 0.05460910499095917, -0.04233148321509361, -0.013564977794885635, -0.04634019732475281, 0.004074946045875549, 0.0008341054199263453, 0.03168400004506111,
    -0.050496116280555725, -0.014490730129182339, -0.07893859595060349, -0.023765752092003822, 0.0005100502748973668, 0.09616108983755112, 0.05941352993249893, -0.010654108598828316,
    0.06347516924142838, -0.06192250922322273, 0.010929686948657036, 0.09449886530637741, -0.09099544584751129, 0.030908990651369095, -0.09043555706739426, -0.02356724999845028,
    0.029819579795002937, -0.06012047827243805, -0.09502800554037094, 0.029761016368865967, 0.023381156846880913, -0.03620139881968498, -0.01012117974460125, -0.008591512218117714,
    0.014098290354013443, 0.00571309681981802, 0.004838688764721155, 0.009228349663317204, 0.029543591663241386, -0.016055861487984657, 0.011861222796142101, 0.06888993829488754,
    -0.02587629295885563, -0.02133360505104065, 0.11813652515411377, -0.056833550333976746, 0.0568840354681015, 0.032448578625917435, 0.04624499753117561, 0.023735949769616127,
    0.02082727663218975, 0.033039119094610214, 0.03343545272946358, 0.03422859311103821, -0.04039192199707031, 0.021172666922211647, 0.019478552043437958, -0.038868870586156845,
    -0.05647902190685272, -0.024205127730965614, -0.008135104551911354, 0.07739341259002686, 0.03809988498687744, -0.03326127678155899, 0.048852644860744476, 0.06355497241020203,
    -0.038198769092559814, -0.020474780350923538, -0.007610260974615812, 0.008471705950796604, 0.01819484680891037, -0.019788824021816254, 0.05127227306365967, -0.06645624339580536,
    -0.03973452001810074, -0.005256307777017355, 0.05298515036702156, -0.044398583471775055, -0.0436166413128376, 0.036232225596904755, 0.03164638951420784, 0.009266369044780731,
    -0.04227175936102867, -0.009925316087901592, -0.07342909276485443, 0.007452003657817841, -0.00938205886632204, -0.04635757580399513, 0.0020789108239114285, 0.06274479627609253,
    -0.02051633410155773, 0.02392665669322014, -0.04146643355488777, 0.0047400034964084625, 0.07116235792636871, -0.023381007835268974, 0.007324586622416973, -0.15563909709453583,
    0.027153952047228813, -0.11309175938367844, -0.037460554391145706, -0.04516265168786049, 0.029898501932621002, 0.06026475504040718, -0.05438290163874626, -0.0037167370319366455,
    0.004432781133800745, 0.0556957870721817, 0.0013303386513143778, 0.055836185812950134, -0.08773470669984818, -0.03683881834149361, -0.045652836561203, 0.06300389021635056,
    0.00648861238732934, -0.00018626016390044242, -0.025961672887206078, 0.03927701711654663, 0.029609069228172302, -0.017644165083765984, 0.015125798061490059, -0.006788316648453474,
    -0.04056856036186218, 0.015521494671702385, 0.0018610382685437799, -0.024725666269659996, -0.0360327772796154, -0.009332961402833462, -0.013154137879610062, 0.04827051982283592,
    -0.06184418126940727, 0.018165552988648415, -0.056351255625486374, 0.021705104038119316, -0.07545330375432968, -0.020955683663487434, 0.007163007743656635, 0.011687340214848518,
    0.062054622918367386, 0.01615099422633648, 0.006186261307448149, 0.018675610423088074, -0.07135337591171265, -0.06362113356590271, -0.060102108865976334, -0.015408860519528389,
    0.03604769706726074, 0.023269938305020332, 0.004787492100149393, 0.057158615440130234, -0.016820525750517845, 0.006092546042054892, -0.07084590941667557, -0.08116954565048218,
    0.08362264186143875, -0.014688126742839813, 0.06595815718173981, 0.09768593311309814, -0.038718268275260925, -0.002394643146544695, -0.07444018125534058, -0.007599391043186188,
    -0.035048168152570724, 0.02076024003326893, -0.053310804069042206, -0.014092477038502693, -0.11672041565179825, 0.06546130776405334, -0.03875717148184776, 0.011087278835475445,
    0.04817177355289459, 0.006675083655864, 0.03018048219382763, -0.052194200456142426, 0.00302924239076674, 0.06876707822084427, -0.04809543490409851, 0.053170252591371536,
    0.015270490199327469, 0.009050208143889904, -0.004917852580547333, -0.02386670932173729, 0.011648370884358883, -0.006395616568624973, 2.6423262170283124e-05, -0.046686287969350815,
    -0.03322478011250496, -0.016731861978769302, -0.014221077784895897, 0.01998438499867916, -0.0723416730761528, 0.02246483787894249, 0.094854436814785, 0.00232749804854393,
    -0.06816520541906357, 0.031331002712249756, 0.009285005740821362, -0.04350532591342926, 0.005535056348890066, 0.019059665501117706, 0.018482189625501633, 0.032019805163145065,
    -0.029796091839671135, 0.032711051404476166, 0.07165145874023438, 0.02333642542362213, -0.025781473144888878, 0.12653644382953644, 0.02211896702647209, 0.024147706106305122,
    -0.041215959936380386, 0.013864397071301937, 0.02966052107512951, -0.025569569319486618, 0.06915125250816345, -0.015979817137122154, 0.045391637831926346, -0.07414066046476364,
    0.04581817612051964, -0.07454272359609604, -0.0016456483863294125, -0.008756247349083424, 0.1107884868979454, 0.06282196938991547, -0.023639922961592674, -0.13741692900657654,
    0.002391131827607751, -0.08876264840364456, 0.0036605787463486195, -0.043071094900369644, -0.060280557721853256, -0.017341936007142067, 0.01781783252954483, -0.019500302150845528,
    -0.001998055260628462, 0.05366634577512741, 0.009138072840869427, -0.015282331965863705, -0.03778259828686714, 0.05339657515287399, -0.04361429810523987, 0.05328759923577309,
    0.00040572130819782615, -0.027623280882835388, 0.06311044096946716, 0.024077333509922028, -0.02390742488205433, 0.010942205786705017, 0.02537556365132332, 0.004927377216517925,
    0.01592482253909111, 0.014047748409211636, 0.0075927297584712505, -0.06215132400393486, -0.05134187266230583, -0.018644556403160095, -0.009137815795838833, 0.011234283447265625,
    -0.05191373452544212, 0.07631734758615494, -0.08704734593629837, 0.0005421037785708904, -0.05435315892100334, -0.049982018768787384, 0.04199589788913727, 0.06117721647024155,
    -0.04809309169650078, -0.03307017311453819, -0.06211753562092781, -0.035188861191272736, 0.01781153492629528, 0.07135066390037537, 0.025043996050953865, -0.0035403200890868902,
    0.03034411557018757, -0.02163899876177311, 0.06619647890329361, -0.02265641652047634, 0.015344524756073952, -0.05358993634581566, -0.06650437414646149, -0.043576017022132874,
    0.018311694264411926, -0.10882031172513962, 0.004954507574439049, 0.010531747713685036, 0.01481203269213438, -0.04633922502398491, -0.006308909971266985, 0.013509034179151058,
    -0.03285953775048256, -0.03346465900540352, -0.04948945716023445, 0.0030324566178023815, -0.026588065549731255, -0.01971612498164177, 0.03944317623972893, 0.022116737440228462,
    -0.04654209315776825, -0.016157636418938637, 0.0263176541775465, 0.00402233237400651, 0.06268526613712311, 0.05035734921693802, 0.014181036502122879, -0.05821899324655533,
    -0.049061473459005356, -0.02919873036444187, -0.03199620544910431, 0.014197316952049732, 0.006957430858165026, 0.017653515562415123, 0.04755072668194771, 0.012941365130245686,
    -0.014350635930895805, 0.034963157027959824, -0.020569147542119026, 0.03236374631524086, 0.02419193647801876, -0.0051794229075312614, 0.07182111591100693, 0.058585815131664276,
    -0.03002084046602249, 0.02032705768942833, -0.033859241753816605, -0.04605042189359665, 0.07556313276290894, -0.020835282281041145, 0.032481849193573, -0.02220604382455349,
    -0.08765868842601776, -0.03711753711104393, 0.008942998014390469, 0.012248853221535683, -0.010023726150393486, 0.03955035284161568, -0.044234052300453186, 0.0064323400147259235,
    0.12574487924575806, -0.003685753094032407, -0.075190469622612, 0.05457640066742897, -0.0326538160443306, -0.045592550188302994, -0.013749295845627785, 0.03661166876554489,
    0.007017119787633419, 0.011920385994017124, -0.0033129453659057617, 0.007794061675667763, 0.07757042348384857, -0.03122016042470932, -0.002097415504977107, -0.07101733982563019,
    0.03333544731140137, 0.0196958277374506, -0.025229517370462418, -0.063713438808918, -0.11528477072715759, 0.020677778869867325, -0.02296225167810917, -0.0057028657756745815,
    0.02613314427435398, 0.07401806861162186, 0.0113760931417346, 0.002605411922559142, -0.12737570703029633, 0.019949065521359444, -0.05463863164186478, -0.0038967381697148085,
    0.016880087554454803, 0.034613121300935745, -0.017976876348257065, 0.03532004356384277, 0.03314819931983948, -0.025686591863632202, 0.00811516959220171, -0.020404912531375885,
    0.053691886365413666, 0.024011798202991486, -0.02983883023262024, -0.05241505056619644, -0.157636359333992, -0.039137110114097595, -0.07119596749544144, 0.02636641636490822,
    -0.012257009744644165, -0.09327319264411926, -0.05997557193040848, 0.03623170033097267, -0.027854949235916138, -0.020084969699382782, -0.026232043281197548, 0.022808421403169632,
    0.0602196604013443, 0.06250829249620438, 0.015214773826301098, 0.11549204587936401, -0.016237100586295128, 0.03396976739168167, -0.02549424022436142, -0.029067056253552437,
    0.07443690299987793, 0.0345785915851593, 0.011008667759597301, -0.07423557341098785, -0.011004419066011906, -0.09025008231401443, -0.04486432671546936, -0.1202009916305542,
    0.03795543685555458, -0.03721742331981659, 0.08435779809951782, 0.07817219197750092, -0.051768939942121506, -0.03311270847916603, -0.04965854808688164, 0.0556236132979393,
    0.03130346164107323, 0.037362582981586456, -0.006367233116179705, 0.009632440283894539, -0.06018376722931862, 0.037963688373565674, 0.025243716314435005, 0.10089343041181564,
    -0.014700549654662609, 0.038259174674749374, -0.0004396526201162487, 0.023125624284148216, -0.01354197971522808, 0.05579186975955963, 0.012650718912482262, 0.028566574677824974,
    -0.02921113558113575, -0.02842237800359726, 0.044524721801280975, -0.01398126408457756, -0.023390982300043106, -0.017494698986411095, -0.024101154878735542, 0.013115476816892624,
    0.07579683512449265, -0.00609612325206399, -0.03484698012471199, 0.08032797276973724, 0.027590926736593246, 0.007359662558883429, 0.16914153099060059, -0.05618434399366379,
    -0.045783787965774536, -0.052305806428194046, -0.029377425089478493, 0.0029006500262767076, -0.005633866414427757, 0.027737075462937355, -0.0019198368536308408, 0.022715939208865166,
    -0.04213448613882065, 0.0034341486170887947, 0.009758830070495605, -0.006248775403946638, 0.02038365602493286, 0.0220639631152153, 0.046186380088329315, -0.0006883595488034189,
    0.03223336115479469, 0.01325967162847519, 0.06701261550188065, -0.00442079920321703, 0.0026499165687710047, 0.0018973901169374585, 0.07050234824419022, -0.01761741377413273,
    0.001407108036801219, -0.027231302112340927, 0.03036959283053875, 0.00877137016505003, 0.04964698851108551, 0.041576217859983444, -0.024807028472423553, -0.10634191334247589,
    0.050669290125370026, -0.02239805832505226, 0.011568442918360233, 0.003635304281488061, -0.01583992876112461, -0.02075403928756714, -0.007816246710717678, 0.0030788849107921124,
    0.003858707146719098, 0.028284208849072456, -0.004339465871453285, -0.0013060264755040407, -0.011013460345566273, 0.021772285923361778, -0.04688412696123123, 0.013092835433781147,
    0.0015804875874891877, -0.003353229258209467, 0.05700013414025307, -0.003552660346031189, -0.050837136805057526, 0.00862882286310196, 0.021526256576180458, 0.02686634100973606,
    0.010873869061470032, -0.005904432851821184, 0.031579501926898956, 0.05896952748298645, -0.021373329684138298, 0.03716186434030533, -0.02019941806793213, 0.026769820600748062,
    -0.03038281947374344, 0.0754896029829979, -0.09260957688093185, 0.02323942817747593, -0.021744277328252792, 0.0073072356171905994, 0.05244279280304909, 0.08950252085924149,
    0.006858532782644033, -0.0491979755461216, 0.0017904271371662617, 0.0074434042908251286, 0.0007244017324410379, -0.0010869040852412581, -0.03910382464528084, 0.04843752831220627,
    -0.004410772584378719, -0.00901282299309969, -0.007721604313701391, -0.013343531638383865, -0.016073524951934814, 0.005586307495832443, -0.06427247822284698, -0.0463106632232666,
    -0.03013882040977478, -0.06086420640349388, -0.03719523176550865, -0.016787175089120865, -0.012306474149227142, -0.011693494394421577, 0.016467338427901268, 0.02537629008293152,
    0.1403857171535492, -0.03202896937727928, -0.004960585851222277, -4.566480583889643e-06, -0.01377284899353981, -0.06703744828701019, -0.013346757739782333, 0.010131819173693657,
    -0.026462048292160034, -0.027679044753313065, 0.044722214341163635, -0.039996709674596786, 0.010256706736981869, 0.006901554763317108, -0.021079089492559433, 0.0036060635466128588,
    -0.08376273512840271, -0.03216315433382988, -0.06426677107810974, 0.006365991663187742, -0.0010257292306050658, 0.018920982256531715, 0.03834234178066254, 0.03554059565067291,
    -0.1429259330034256, -0.10304737836122513, 0.016828421503305435, -0.026844600215554237, -0.01331679243594408, -0.038274288177490234, 0.06389439105987549, 0.036851514130830765,
    0.03200364112854004, -0.0009661578806117177, -0.00464203953742981, 0.027175849303603172, 0.05801320821046829, 0.006023786496371031, 0.005670332349836826, -0.013433551415801048,
    -0.07765522599220276, -0.038640644401311874, 0.044152695685625076, -0.044416289776563644, 0.057088278234004974, -0.12446006387472153, 0.016335956752300262, 0.012904509902000427,
    -0.035900067538022995, -0.019079992547631264, 0.008489709347486496, 0.013865246437489986, 0.04150346666574478, -0.03443115949630737, -0.011779814027249813, 0.07094713300466537,
    0.020179467275738716, 0.0057060327380895615, -0.016452739015221596, 0.016923217102885246, 0.0032504438422620296, 0.007700239773839712, -0.020290851593017578, -0.012728364206850529,
    0.0026580854319036007, -0.002580969827249646, -0.04385741800069809, -0.020481761544942856, -0.0270734541118145, -0.000863153487443924, 0.02911616489291191, 0.004571402445435524,
    0.002834534738212824, 0.10927882790565491, -0.03601433336734772, 0.020662251859903336, -0.022287292405962944, 0.022439314052462578, -0.032892391085624695, -0.0401846282184124,
    -0.024057190865278244, 0.011420955881476402, 0.03502922132611275, -0.012604438699781895, 0.0004745153128169477, 0.02908010222017765, 0.024129409343004227, -0.039835888892412186,
    0.013670322485268116, 0.019962480291724205, -0.025926224887371063, -0.0201864093542099, -0.03237519785761833, -0.038671474903821945, -0.016037555411458015, 0.006190316751599312,
    -0.04142365604639053, -0.01945680007338524, -0.029793737456202507, -0.002671550028026104, 0.00963886734098196, -0.016090720891952515, -0.002071189461275935, 0.044398825615644455,
    0.06751634925603867, 0.009383074007928371, -0.04439069703221321, 0.04159281775355339, 0.029492070898413658, 0.02516694739460945, -0.03275340050458908, -0.047720808535814285,
    -0.045068223029375076, 0.024724876508116722, -0.001026116544380784, 0.03914285823702812, -0.010457275435328484, 0.012635347433388233, 0.016862420365214348, -0.0718596875667572,
    -0.008075196295976639, -0.012638292275369167, 0.01541946455836296, 0.0011691962135955691, -0.01900019869208336, 0.010245454497635365, -0.019439637660980225, 0.03608948364853859,
    0.04702099785208702, 0.021663988009095192, -0.02700948901474476, -0.0004131612367928028, -0.0546441525220871, 0.0573803186416626, 0.025288010016083717, 0.03471425920724869,
    -0.07975468784570694, 0.02585110068321228, 0.04448709264397621, -0.013408118858933449, 0.000582305365242064, -0.06586837768554688, 0.0403168760240078, 0.01668318547308445,
    -0.017671512439846992, -0.024124007672071457, -0.019310705363750458, -0.017878646031022072, -0.04342426732182503, 0.053021568804979324, -0.02528860978782177, -0.015048212371766567,
    0.009731079451739788, -0.06673180311918259, 0.007847193628549576, 0.013154854997992516, -0.03298027440905571, -0.0623990073800087, 0.0778864324092865, 0.013475919142365456,
    0.008613429963588715, 0.0253201425075531, 4.1191997297573835e-05, 0.015488831326365471, -0.024467965587973595, -0.046908482909202576, 0.022659672424197197, 0.038447897881269455,
    -0.046283889561891556, 0.021147115156054497, -0.009503579698503017, -0.013150621205568314, -0.018701745197176933, -0.09259749948978424, 0.06549840420484543, -0.012231940403580666,
    0.02364661730825901, -0.041894715279340744, 0.018923694267868996, -0.007938985712826252, -0.0001928365381900221, 0.03885985165834427, -0.025882510468363762, 0.12129715830087662,
    -0.005264783278107643, 0.004817559849470854, 0.0018340221140533686, 0.06823567301034927, 0.007688246201723814, 0.02055211178958416, -0.03332722187042236, -0.03306294605135918,
    -0.02662292867898941, -0.020019805058836937, 0.008500966243445873, -0.03568309172987938, 0.012229576706886292, -0.019085759297013283, -0.014314902015030384, 0.005774967838078737,
    0.0582851842045784, -0.017650702968239784, 0.018753593787550926, 0.0008415506454184651, -0.09434568136930466, 0.017204469069838524, 0.023305362090468407, 0.0336998887360096,
    -0.007394376210868359, 0.014084974303841591, 0.011051948182284832, 0.009012590162456036, -0.004435822367668152, -0.006837797816842794, 0.01807214878499508, 0.003494411474093795,
    1.5981651813490316e-05, 0.00195754854939878, 0.005363183561712503, 0.014266072772443295, -0.020766111090779305, -0.017474278807640076, 0.030089259147644043, 0.008907758630812168,
    0.022485094144940376, -0.05127587541937828, -0.14695070683956146, 0.0008549478370696306, 0.015830162912607193, -0.010531006380915642, 0.05680324509739876, 0.005983223207294941,
    0.004897138103842735, -0.02933957241475582, 0.005165413022041321, 0.08169814199209213, 0.0317838154733181, 0.006740184500813484, -0.02407580427825451, 0.037354230880737305,
    0.04018062725663185, 0.005431323777884245, 0.0012214904418215156, 0.01515072863548994, 0.01988622173666954, -0.030781952664256096, 0.054716113954782486, 0.024535229429602623,
    -0.054498519748449326, 0.0018389656906947494, 0.01345359068363905, 0.03418715298175812, -0.031139230355620384, 0.04560002312064171, -0.008081812411546707, 0.0287286676466465,
    -0.0019045642111450434, 0.0062809474766254425, -0.02134041115641594, -0.0003692596510518342, -0.004893312696367502, -0.026285648345947266, 0.009780186228454113, 0.02577095292508602,
    -0.050163548439741135, 0.009889662265777588, -0.04232169687747955, 0.0016654814826324582, -0.01955210231244564, -0.05946027860045433, -0.004181118682026863, -0.0019192093750461936,
    0.014755254611372948, -0.029509786516427994, -0.01312294416129589, -0.008646729402244091, 0.010623360984027386, 0.729901134967804, 0.0015293479664251208, 0.012922038324177265,
    -0.017680754885077477, 0.0018928061472252011, 0.009176506660878658, 0.027111630886793137, 0.023480378091335297, -0.018834702670574188, 0.04512079432606697, 0.06378892809152603,
    -0.927484929561615, -0.049246467649936676, -0.0016026354860514402, -0.039233725517988205, -0.030412662774324417, 0.007352323271334171, 0.029490375891327858, -0.0021507169585675,
    1.5850787162780762, -0.003273381618782878, -0.018192101269960403, -0.011578674428164959, -0.008581523783504963, 0.04678976163268089, -0.04462001472711563, -0.008107825182378292
};


#endif /* USE_WEIGHTS_FILE */

#ifndef USE_WEIGHTS_FILE

#define WEIGHTS_conv1_bias_DEFINED
#define WEIGHTS_conv1_bias_TYPE WEIGHT_TYPE_float
static const float conv1_bias[128] = {
    0.3753451108932495, -0.31263622641563416, 0.1924740970134735, -0.37317919731140137, -0.13099564611911774, 0.3319762051105499, 0.43507567048072815, -0.029343826696276665,
    -0.22431740164756775, 0.1976400464773178, 0.13212032616138458, -0.09688625484704971, -0.4686017632484436, 0.014419090934097767, -0.16912999749183655, -0.18686920404434204,
    -0.3986794054508209, -0.4786561131477356, 0.5187416672706604, -0.024580780416727066, -0.03012051247060299, -0.1702262908220291, -0.22491595149040222, -0.14124749600887299,
    -0.0813673660159111, -0.23379066586494446, -0.0359601192176342, -0.35408470034599304, 0.3087765872478485, 0.28016114234924316, 0.059025634080171585, 0.14468581974506378,
    -0.8071728348731995, 0.022358417510986328, 0.3021509051322937, 0.3746678829193115, 0.3178957998752594, -0.10307133197784424, 0.3276095688343048, 0.03084367886185646,
    0.3119138181209564, -0.07370207458734512, 0.6843315362930298, -0.6697177886962891, -0.1744915246963501, 0.29088208079338074, -0.22335173189640045, -0.5845288634300232,
    0.029046891257166862, 0.21471790969371796, -0.4948368966579437, -0.13153494894504547, -0.1479397714138031, -0.004794825334101915, -0.1928389072418213, -0.23072637617588043,
    0.3955727219581604, 0.17044533789157867, -0.16662828624248505, -0.15869435667991638, 0.10097646713256836, -0.13020986318588257, 0.32582807540893555, -0.4249304533004761,
    -0.4208472669124603, 0.1347932666540146, 0.04249047860503197, 0.03178796172142029, 0.23510892689228058, 0.09670674055814743, 0.3334648013114929, 0.07869245111942291,
    0.09139156341552734, -0.2330510914325714, 0.12179593741893768, 0.20958466827869415, -0.15298162400722504, -0.12814350426197052, -0.08299394696950912, 0.1858099102973938,
    0.1748916357755661, -0.36431562900543213, 0.17586688697338104, -0.20066531002521515, 0.008044804446399212, -0.6389476656913757, 0.2840230464935303, 0.1153317540884018,
    0.24163909256458282, -0.10723503679037094, 0.29339298605918884, -0.15585865080356598, 0.5061817765235901, -0.7141739130020142, -0.271774023771286, 0.20448875427246094,
    -0.24598902463912964, -0.2906428873538971, 0.09868737310171127, -0.549403190612793, -0.18524813652038574, -0.1657918393611908, -0.03430243954062462, -0.20135363936424255,
    -0.4854106307029724, 0.10389760136604309, -0.1761404573917389, -0.24890942871570587, 0.29066774249076843, -0.09632062166929245, -0.2667017877101898, -0.11757036298513412,
    0.5467973351478577, -0.1853608787059784, -0.4111495316028595, -0.23748596012592316, -0.2544082999229431, -0.22717365622520447, 0.10672933608293533, 0.5879379510879517,
    0.07828577607870102, 0.17375074326992035, 0.07005846500396729, -0.23562844097614288, -0.33717864751815796, 0.21945884823799133, 0.048800595104694366, -0.5538548231124878
};


#endif /* USE_WEIGHTS_FILE */

#ifndef USE_WEIGHTS_FILE

#define WEIGHTS_conv2_weights_int8_DEFINED
#define WEIGHTS_conv2_weights_int8_TYPE WEIGHT_TYPE_int8
static const opus_int8 conv2_weights_int8[147456] = {
    -28, 1, -2, 47, 2, -1, -1, -10,
    2, -13, 7, -3, -8, 2, -8, -22,
    -8, 32, -17, -22, 22, -12, -13, 1,
    -20, 10, -11, 15, 7, -13, 24, -2,
    3, -8, 11, 12, 3, -10, 1, -1,
    -7, 5, -6, 5, -21, 25, -60, -30,
    5, 16, 26, 9, -26, 19, 25, 34,
    -23, 18, 15, -6, -30, -55, -1, -5,
    1, -35, 18, 34, -2, 1, -8, 5,
    -10, -3, 3, 6, -3, 17, -20, -25,
    45, 14, -11, 12, 8, 15, -13, -18,
    -4, -27, -2, 10, 8, 21, -24, 24,
    12, -22, -7, 15, -18, -17, 4, 0,
    1, -20, -6, -3, 36, 41, 36, -28,
    30, 1, 27, 25, -4, -45, -1, 22,
    -15, 6, -7, -23, -31, 1, -2, -25,
    14, 15, -24, 12, 5, -1, 3, -7,
    -5, -2, 4, -1, 0, 84, -16, 12,
    20, -4, 19, 24, -10, 7, 24, -8,
    17, 5, -11, 2, -29, 4, 15, 11,
    -15, 26, -13, 19, -5, 7, 1, 28,
    4, -7, 17, 3, -9, 19, -19, -70,
    -2, 6, -23, 4, -31, 8, -20, 1,
    5, 0, -15, -8, 7, 15, -5, -25,
    9, 41, 53, -36, -10, -5, -1, -35,
    -14, 8, 11, -13, 16, 19, -13, -113,
    -22, 6, -3, 49, 7, 25, -14, 51,
    9, -7, -10, -8, -2, 16, 64, -51,
    -2, -57, -26, 7, -5, -10, 15, -22,
    4, 7, 12, -3, -47, 21, -14, -5,
    28, 13, -22, -25, -11, 9, 4, -9,
    -9, -2, -4, 5, 25, 27, 16, -43,
    10, -9, 14, 25, -2, 1, -12, 5,
    -8, 4, -13, -1, -12, -27, 47, -64,
    -7, 12, 49, 20, 18, 15, -21, -10,
    0, 0, -6, -6, 13, -33, 5, 15,
    -1, 14, -17, -13, -17, 14, 20, -15,
    8, -9, 1, -2, -13, -9, 21, -21,
    -5, -3, -12, 40, -4, 20, -10, 17,
    -1, 28, -6, 1, -1, -23, -2, -10,
    -20, -13, 34, -11, -11, -3, 3, -2,
    20, 14, 3, -17, 34, -31, -30, 11,
    -11, 4, 25, -14, -1, 19, 13, 10,
    -6, 1, 14, 4, 31, -5, -36, 9,
    12, 13, 13, 22, 11, -8, -11, 6,
    5, -4, 13, 2, -9, -43, 34, 49,
    52, -15, 2, 39, 1, -1, 7, -9,
    -8, 0, -32, -5, 0, 6, -21, 22,
    -15, 17, 21, 9, 16, 25, -12, 4,
    -3, -6, -8, -9, -41, 22, 32, -50,
    32, -27, 6, 30, 37, 13, -4, -5,
    1, 0, -7, 16, -2, 29, 11, -10,
    30, -16, 12, 8, 8, 15, -29, 8,
    -11, 0, -27, 1, 2, 47, 30, 56,
    30, -28, 40, 37, 1, -57, -30, -38,
    -22, 0, -5, -19, -27, -24, -5, 2,
    22, 41, -2, -2, 3, -18, 15, 3,
    7, 9, -5, 0, -3, 48, -28, 95,
    2, 5, 6, 4, -4, 7, -18, -25,
    3, 0, -28, -8, 21, 2, 7, -26,
    13, 20, 0, 28, 24, -23, 6, -2,
    26, 14, 3, -9, 36, -11, -5, -12,
    -17, 56, -6, -11, -16, -26, 8, 0,
    6, -4, -5, 9, 0, -6, 12, -54,
    17, -9, 34, 1, -5, 65, 6, 17,
    0, 20, -3, 18, -11, 64, 16, 3,
    -3, 22, 2, -33, 18, -21, 17, 7,
    7, 0, -4, 4, 15, 18, 25, -10,
    -31, 2, -30, -7, -3, -32, 15, 4,
    3, -12, -6, 16, 18, -7, 2, -14,
    -1, 27, -37, -10, -6, -4, 6, -3,
    9, 9, -9, 4, 5, 19, 15, 2,
    5, 37, 1, -36, 7, -18, 11, 9,
    9, -6, 11, 2, 7, -16, -8, -8,
    -4, 15, 16, 0, 23, 2, 7, 28,
    -11, -4, 13, 2, 43, -21, -15, 3,
    30, -12, 32, -2, 11, 25, 13, 9,
    10, 14, -3, 15, 0, -20, -22, -3,
    57, -3, -40, 46, 10, -8, -2, 3,
    -5, -7, 19, -3, 8, -1, 23, -38,
    30, -14, -58, 6, 3, -83, 11, -7,
    -1, -8, 15, -10, 9, -40, -31, 44,
    22, 17, -50, -25, 10, 27, 39, -7,
    -3, 1, 5, -10, 21, -38, -3, 0,
    29, -11, 15, 13, 16, 12, -3, 1,
    16, 7, -11, -8, 9, 5, 36, 25,
    -5, 14, 46, 5, 9, 24, -23, -18,
    2, 2, -25, -16, -31, 21, -5, -16,
    -16, -15, 42, -25, -5, 17, -8, -7,
    9, 8, 2, 8, 39, 25, -10, -36,
    6, 6, -37, -13, -4, 23, -4, -21,
    2, -8, 13, 4, -18, 24, -8, -8,
    -21, -5, 4, 11, 9, 10, -5, -12,
    8, -11, 10, 3, -11, 43, -49, 30,
    -5, 3, 35, -3, -2, 18, 1, -4,
    -2, -22, -12, -8, -27, -4, 3, 57,
    22, -3, -20, 3, -2, 8, -5, -10,
    -14, 10, -5, 15, 4, 37, 5, -21,
    -15, 8, 40, -2, -26, -8, -25, 18,
    -21, -10, -16, 5, -9, 5, -18, -17,
    23, -7, 21, -6, 2, 3, 25, -7,
    7, 1, 1, 17, -19, -26, 16, 57,
    -21, -13, 1, -27, -3, 24, 22, -7,
    -14, -7, -12, -5, 12, 27, -17, -4,
    -5, -16, 15, 2, -9, 25, -13, 3,
    4, 3, -10, 9, -29, 1, -57, -25,
    0, 5, 26, -30, 25, 8, 27, 6,
    10, 8, 1, -17, 2, 36, -33, 52,
    8, 6, -36, -27, 0, 16, -6, 1,
    -1, 1, 2, -4, -17, -24, 9, -7,
    5, 12, -6, -8, -7, -10, -13, -3,
    -5, -6, 1, 6, -4, 0, -2, -11,
    -4, 2, -7, -27, 4, -18, 71, -16,
    0, -5, -7, -6, -20, 14, 36, 32,
    6, -23, 8, -24, -13, -15, -20, -25,
    7, 3, -6, 1, -22, -12, -7, -15,
    16, 9, 1, -19, 11, 15, -2, 1,
    1, 1, 4, 6, 5, 15, 1, 6,
    4, 11, -9, -3, 0, 23, 7, 18,
    -7, -7, 4, -8, -20, 18, 42, 2,
    4, 26, 19, -4, -3, -24, -6, 1,
    0, -8, 0, -1, 29, 30, -2, 4,
    4, 22, -4, -7, 5, -2, 6, -12,
    10, -5, 22, 0, -19, 1, -16, -9,
    48, 9, 27, -10, 16, -11, 15, -3,
    9, -10, -4, -8, 8, 6, -9, 29,
    -21, 8, 12, 11, 14, -1, 29, 24,
    8, 1, 23, 9, 12, -15, 31, -8,
    6, -6, 14, 32, 2, -23, 6, 2,
    -2, 1, 12, -11, -17, -86, 15, -14,
    24, 55, -12, 32, -12, -4, -42, 17,
    -15, 10, -22, 6, 12, 5, -8, -20,
    -24, -7, 19, 5, 12, -19, 8, 2,
    -3, 5, -11, -4, 29, 3, -10, -49,
    -32, 6, 14, -4, -57, 11, 8, 13,
    0, 5, -14, 5, 24, 3, -11, -11,
    29, 1, 28, -15, 18, -2, -11, -22,
    -5, -2, 4, 27, 17, 11, 26, -1,
    39, -12, -34, -35, -23, 8, -3, -46,
    7, -8, 3, 52, 10, 8, 38, -11,
    15, -11, 9, -7, 8, 7, -22, -14,
    -2, -2, 6, -8, 10, -15, 11, -13,
    20, -23, 1, 6, -15, -42, 33, 21,
    -3, -8, -9, -9, -12, -11, -25, 14,
    7, 39, -25, -9, -2, -14, 18, 22,
    -5, 17, 11, 3, 6, 46, 17, 72,
    -2, 12, 11, -3, -3, 11, -5, -13,
    -19, -5, -10, 8, 14, -34, 3, -27,
    -30, -7, -26, 20, -2, 22, 10, 8,
    13, -18, 9, 21, -10, -31, 23, -63,
    -6, 73, 3, 7, 1, 6, -8, -5,
    13, 3, -7, -6, -70, -23, -7, -69,
    3, 0, -27, -19, -34, -6, 28, -39,
    -8, 2, -6, 28, 2, 14, -8, -16,
    17, 8, -8, -8, 21, 25, 2, 35,
    4, 2, 20, 3, 13, 30, -52, -38,
    -3, 17, 17, -19, -15, 13, 16, 24,
    -2, -7, 5, -4, -36, 44, -29, 27,
    0, -5, -20, -44, 5, 0, 10, -1,
    -13, -1, 3, 2, -1, 29, -1, 26,
    11, 6, -71, 17, 0, -11, -4, -3,
    -7, 0, -24, 0, -31, 3, -13, -38,
    17, -4, 22, 28, 10, 6, 7, -3,
    -1, 0, 5, -6, -23, -10, 53, -6,
    17, 0, -8, -8, -12, 1, -9, -7,
    15, -11, 6, 5, 1, -66, 15, -22,
    39, -30, -16, 18, -22, 25, -27, 1,
    2, 1, 2, -1, 15, 30, 5, 1,
    -42, 14, 20, -7, 7, 11, 1, 6,
    18, 10, 1, -18, 70, 3, 26, 22,
    44, 9, -7, -15, 18, -6, -12, 5,
    15, -15, 15, -5, -11, -38, -17, -1,
    -32, -3, 29, 13, 40, 10, -26, 11,
    2, -3, -1, 1, -16, -16, 79, -18,
    -16, 36, 54, 13, -3, 12, 15, 8,
    -28, -2, -5, -10, 6, 21, 68, -16,
    7, -24, 28, 7, 44, 12, 8, 6,
    -7, -16, 4, -6, 38, 36, 31, 3,
    14, 14, -35, 11, 22, 21, -9, -9,
    5, 1, -1, -18, 48, 5, 22, -24,
    52, -19, 15, -2, -12, -33, -48, -14,
    -18, -4, -12, 9, -29, 13, -65, 0,
    -17, -15, -37, -7, 35, -43, 13, -5,
    -27, 10, -24, -24, -9, 16, 34, -18,
    -2, -8, -6, -16, -6, 12, 3, 10,
    3, 11, -11, 3, 20, 64, -23, 40,
    -11, -32, 29, -1, -11, -7, -10, -9,
    -7, 3, -11, -4, -10, 33, 18, 46,
    32, -20, 5, -8, 11, -7, -6, 28,
    5, 3, 3, -22, -46, -47, -16, -6,
    1, -4, -12, -37, 5, -23, 7, -32,
    -6, -9, -17, -6, -7, -12, 20, -24,
    -18, -40, -4, -21, -6, 20, -10, 32,
    -10, 1, -19, -4, 2, -8, -3, 35,
    19, -4, -45, 46, 24, -4, 2, 15,
    7, 2, 10, -12, -8, 7, -73, 38,
    -43, 29, -4, -27, -4, 1, 6, 22,
    6, -8, -16, 4, 72, -3, 21, -17,
    -60, -21, -53, 46, -22, -34, 23, -36,
    6, -12, 11, 7, -15, -3, 12, 42,
    4, -7, -1, -51, 26, -13, 2, -22,
    6, -8, 7, 9, 23, -29, -52, -11,
    -51, 29, -56, -8, -15, 13, 2, 25,
    -1, 5, -18, 11, 115, 5, 40, 21,
    31, 13, -56, -49, 7, 47, 26, -10,
    11, -3, -4, 25, 17, -25, -23, 64,
    48, 13, 39, 2, 6, 15, 14, -30,
    8, 20, 3, 19, -1, 26, -4, 47,
    10, 17, -11, -24, 6, -4, 14, -4,
    -1, -8, 5, -1, -12, -38, -25, 40,
    -27, 35, -62, 6, -2, 15, 27, 3,
    4, -7, 14, 16, -9, 14, 19, -8,
    32, -26, -4, 2, -12, -10, 8, -32,
    26, 6, 10, -2, 3, -5, -16, 102,
    23, -9, -20, 55, 5, 36, 3, -23,
    -3, 11, -21, 14, 21, 11, 44, 17,
    -1, -19, 29, 4, 16, 15, -5, -7,
    6, 20, 12, -8, -6, -19, -49, -21,
    -57, -32, -17, 0, 11, -18, 12, -4,
    2, 19, -30, 3, -2, -16, 15, -11,
    -19, 3, -33, 1, -20, 9, -17, 7,
    1, -7, -56, 5, -36, -10, -14, 5,
    -58, 7, 44, -6, -31, 13, 31, -9,
    9, -22, 1, 4, 42, 4, -22, 18,
    -9, 42, -12, 5, 10, -14, -50, 2,
    -33, -5, 8, 0, -60, -26, 48, -1,
    -30, 41, -81, 15, -21, 1, 17, 29,
    -31, -1, -28, -8, 9, -13, -24, -27,
    13, 9, 31, -2, -1, 4, 48, 24,
    -6, 1, -9, -5, -9, -11, -8, 30,
    1, -16, 30, -8, 2, 15, 5, -10,
    -44, -7, 25, -43, -2, 27, 25, 0,
    -9, -15, -2, 7, 2, -1, 10, 8,
    -2, -9, -35, 9, 0, 1, -14, 0,
    15, -6, -6, 37, 7, -4, 35, 29,
    5, 0, 6, -14, 5, -6, 18, -72,
    6, 2, 5, -39, -3, 8, 11, 53,
    -1, -2, -5, -5, 6, -40, 22, -7,
    -6, 33, -22, -43, -5, 4, 34, -13,
    -9, -4, -9, -7, -9, -19, -55, -25,
    -22, 32, -26, -42, -1, -23, 19, 17,
    -6, 12, -8, -15, 6, 21, 26, 103,
    -8, 20, -6, -12, -3, -30, -24, -10,
    0, 2, -9, -4, -13, 2, 19, -43,
    10, 2, -15, -4, -2, 17, -16, -5,
    1, 10, 8, -3, -27, -3, 25, -21,
    28, -36, -33, 16, 21, 13, 1, 19,
    2, 7, 16, -5, 32, 11, -9, -25,
    -6, 17, 2, -2, -3, 13, -10, 11,
    -2, 4, -19, -4, 53, -36, -13, -29,
    -9, 10, 36, -19, -1, -23, 15, 4,
    -3, 2, 46, 20, -12, 1, -35, 21,
    16, -18, -31, -12, 27, -16, -13, 6,
    15, -7, 7, -7, 5, 0, -12, 54,
    -13, 2, 9, 3, -31, -20, 62, 31,
    -13, -17, -6, -8, 22, 9, 31, 31,
    78, -81, 1, -35, 9, -27, 12, 11,
    13, -15, 17, -22, 42, -73, -3, 16,
    -20, 5, -1, -24, 1, 16, -62, 7,
    -28, 30, -31, 10, -17, -5, -3, -68,
    23, 15, 40, 69, 37, -21, 14, -13,
    6, -23, 4, -18, 14, -27, 66, -38,
    -2, 15, 12, 60, -81, 19, 10, -29,
    2, -24, -44, -11, -24, -13, -16, 0,
    17, 52, -38, 9, 25, 29, -8, -49,
    12, -12, -6, 43, -8, -15, -7, 38,
    -46, -1, 57, -35, -19, 0, -33, -42,
    32, -10, -4, 122, -3, -15, -49, 66,
    21, -12, -69, -30, -12, 9, -40, -24,
    -3, 43, -2, -16, -18, -13, 24, -14,
    -8, -17, -4, -22, 6, -71, 35, 28,
    -2, -20, 6, -9, 57, 7, 63, 50,
    -58, -71, 83, -61, 5, -26, -6, 18,
    -19, 11, 4, 15, -45, 14, 32, 69,
    -1, -22, 59, -19, 22, -6, -8, -7,
    -58, -44, 0, -13, -25, -4, -62, 21,
    32, 21, -40, -54, -43, 33, 6, 65,
    20, -10, 25, 18, 7, -3, 18, -12,
    -8, 17, -56, 0, -3, 3, 13, -25,
    19, 6, 10, -19, 10, 29, 11, -8,
    23, -12, 52, -25, -34, 0, 18, 3,
    5, 6, -19, 52, -17, -2, -54, 114,
    -39, -14, 19, -60, -21, 22, 38, 61,
    42, 9, 105, 14, -56, 87, 10, 2,
    -34, 35, -25, 17, -24, 74, 0, 40,
    -3, -22, -7, -13, -4, -19, 19, 56,
    -48, -53, 2, -29, 11, 15, 2, -14,
    -3, 10, 0, 1, 27, -1, 0, 36,
    -2, -21, 29, 7, -17, -17, 23, -9,
    -9, -6, -45, -5, -23, -4, -29, -15,
    2, -12, -7, 18, 28, -21, 9, -35,
    -2, 12, 9, 4, -7, 51, -9, 22,
    -34, 69, 64, -19, -7, -3, 0, 22,
    28, 12, 15, 28, 12, -111, 12, 5,
    2, -25, 13, -60, -60, -1, -43, 56,
    31, 1, 3, -13, -41, 15, -8, 27,
    -37, -55, -28, 41, 0, 3, -9, -6,
    36, 28, 4, -18, 0, 37, 69, -26,
    -37, 40, 16, 34, -23, -17, -4, -2,
    54, -18, 33, -30, 45, 12, 8, -1,
    -15, 25, -1, 14, 29, -6, -11, 21,
    11, 0, 13, -12, -34, -19, 26, -92,
    24, 8, 0, 24, 4, 1, 0, -3,
    -43, -13, -16, -24, -67, 40, 70, -18,
    45, -42, -21, 15, 74, 26, 6, -13,
    -2, -29, 10, 7, 31, -17, 22, -6,
    -30, -50, -41, 26, 61, -11, 8, 2,
    -8, -34, -19, -42, 50, -78, -14, -6,
    25, 19, 43, -24, -7, -67, -41, -16,
    -32, -23, -52, 26, -40, -39, 9, -5,
    43, 38, 32, 15, -21, -94, 9, -9,
    -19, -3, -45, -49, -93, 31, 2, 43,
    -9, -8, 10, 24, 0, 29, -1, 35,
    -12, 2, -22, 15, 15, 26, -14, -40,
    26, 45, -26, -19, -30, 23, 26, 22,
    30, -20, 28, 5, 24, 20, 12, 10,
    28, 27, -1, 4, -14, -13, -25, 90,
    0, -25, 9, -2, -68, -51, 37, 8,
    28, 7, -11, -53, 8, 43, -2, -16,
    -17, -31, -9, 9, -33, 51, -15, -9,
    -14, -12, -3, 5, -18, -67, -13, 29,
    -4, -32, -23, 13, 32, -90, 0, 4,
    -9, 45, 20, 14, 2, -50, 29, 59,
    9, -31, 41, -34, -34, -12, -10, -4,
    52, -11, 31, -12, -1, 18, 22, 38,
    18, 8, -33, 31, 64, 22, 59, 11,
    -97, -32, 10, 37, -17, -52, 26, -68,
    8, -39, 23, 30, -25, 4, -24, -53,
    -9, 7, 63, -18, 64, -24, -40, -50,
    37, -10, 28, 3, -64, -49, -53, -14,
    -67, 7, -68, -5, 19, 2, -10, 26,
    -37, 34, -85, 8, 10, -32, 33, -11,
    6, 39, -44, 29, 8, 114, 25, 28,
    -12, 15, 15, 41, 46, -44, 25, 100,
    16, 0, 20, 82, -8, 21, 5, -29,
    5, 21, -45, 17, -24, -33, 1, -3,
    -10, 43, -14, 41, 3, 126, 24, -31,
    4, 28, -9, 16, -18, -10, 38, -37,
    -19, 44, 7, -24, 11, 6, 25, 36,
    23, 1, 33, 3, -60, 50, 30, -17,
    4, -4, 29, -39, -20, -20, 0, -5,
    23, 7, 38, -19, -24, 3, -119, 4,
    15, -22, 27, -49, 32, 56, -20, -6,
    14, 10, -13, 40, 23, 8, -55, 71,
    54, -79, 30, -39, 25, -18, -33, 31,
    1, 9, 21, -15, 16, -11, 53, 47,
    8, -12, -30, 0, 16, -2, -12, -25,
    0, 62, -81, -5, 18, -52, 1, -30,
    41, 17, -13, -51, -10, -26, -25, 46,
    -9, -9, -127, 29, -40, -58, -12, -36,
    34, 8, -9, -9, -23, 17, 100, -64,
    46, -39, -14, 5, -57, -24, 22, 45,
    7, -23, -10, -56, 32, 8, -42, 5,
    -27, -3, 5, 9, -74, 5, 38, -6,
    8, 10, 11, -62, -46, 18, 0, 14,
    -76, -13, -42, -35, -8, -22, -25, 32,
    26, 28, 21, 54, -38, 3, 62, 38,
    -2, -2, -15, 2, 24, 29, 0, 40,
    34, -15, -2, -47, -19, 4, 19, 24,
    -113, -16, 9, -61, 25, 17, -1, 13,
    -12, 6, 4, -72, 14, -6, 54, -36,
    -4, -12, -60, 11, 24, -7, 57, -37,
    8, -11, -36, -16, 1, 26, 77, 52,
    10, -24, -11, -50, 23, -29, 32, 15,
    13, -18, -20, 23, 13, -8, 53, 56,
    3, -15, -19, 7, 11, -61, -9, 28,
    11, 35, 2, 21, 0, 3, 1, 3,
    -5, -16, -56, -2, -5, -16, -1, -82,
    -74, -9, 1, -55, 13, -46, -83, 45,
    -6, 14, 14, -13, 72, -20, 1, 60,
    -25, 27, -74, -49, -19, 0, -14, 21,
    14, -6, 3, -26, -29, 62, 58, 21,
    -6, 46, -8, 9, -26, 18, -18, -6,
    -21, 13, 0, 15, 0, -23, 3, -38,
    53, -24, 44, -21, -40, 54, 31, 43,
    -7, 17, 26, 13, 67, 4, -99, -30,
    -88, 4, -35, 0, -25, 5, -6, 7,
    4, 16, -37, -1, 81, -84, 2, -52,
    -44, 44, -69, -14, 7, -41, 24, 27,
    9, 1, 95, 26, 16, -12, 75, 29,
    -41, 7, -37, -17, 32, -5, -33, 33,
    44, -15, -8, -15, 12, -24, 14, 20,
    69, 0, 4, -8, -13, -24, 19, 24,
    -4, -15, -30, -1, -31, -39, -65, 33,
    34, -11, -20, 5, -7, 11, 12, -10,
    4, -1, 7, 28, 1, -1, 15, -6,
    4, -11, 16, 3, 20, 1, 11, 2,
    -2, 21, -8, 18, -13, 18, -15, 4,
    -42, -12, -23, -19, 10, 12, 28, 5,
    -53, 5, 4, 5, 16, -21, -25, 16,
    7, -14, 6, 1, -2, -11, 3, 5,
    9, 8, -15, 2, -27, -7, -8, -18,
    -1, -11, 13, 33, 10, -15, 1, -10,
    -13, -14, 14, -27, -22, -16, -6, -2,
    -4, 0, -3, -7, 7, -9, 13, -19,
    -1, -32, 3, -12, -16, -14, -26, 0,
    10, 32, -2, 3, -4, 2, 0, -2,
    -7, 15, 11, 11, 12, 7, -12, -4,
    -8, -1, -1, -5, -2, 2, -15, -4,
    20, 5, -2, -3, -8, -9, 8, 20,
    -4, -33, -10, -68, 4, 15, 7, -9,
    -27, -16, 9, -11, -21, -10, 13, -18,
    9, -7, -11, 8, -12, -34, -3, 11,
    2, 9, 15, 24, 18, 5, -1, -11,
    13, -3, -13, -29, 2, 10, 15, 0,
    5, -55, 26, 18, -7, 2, 11, 5,
    -15, 4, 1, -19, 3, -7, -4, 4,
    12, -2, 26, -37, -15, -11, 15, 3,
    -1, 26, -5, 14, -14, -13, -21, -5,
    -46, -49, 7, 55, -8, -22, 30, -39,
    -2, 3, 12, 16, 3, 5, -5, -7,
    -25, 11, -12, 44, -24, 3, 7, 4,
    -11, 20, 7, -2, -1, -6, -2, 10,
    32, 6, 19, 10, -6, 23, -2, -32,
    -8, 9, 21, -6, -9, 16, 21, -14,
    2, 0, 0, 0, 18, 1, -5, 4,
    18, -13, 28, -26, 1, -3, 25, -7,
    21, -5, -41, 0, 9, 21, 1, 10,
    -44, 2, 5, 52, -2, 7, -23, -2,
    -8, -11, -44, -7, -13, 7, -12, 5,
    5, -25, 49, 39, -8, -10, -12, -5,
    -6, -20, 2, 0, 17, -27, 24, -28,
    32, -11, -6, -8, 3, -19, -7, 21,
    -21, 36, -16, 7, -2, 17, -3, 6,
    -8, -5, -12, -32, 2, -3, -1, 2,
    -4, 13, 12, 23, -15, 9, -1, -14,
    -5, 6, 6, -15, 2, -5, -8, -11,
    -17, 22, 2, -4, -7, 13, -3, 9,
    -8, 2, 12, -29, -14, 4, -11, 9,
    -22, 29, -7, 16, -6, 1, -1, 5,
    -3, -2, -1, -8, -16, 13, -14, -20,
    -3, -15, 11, -4, -10, -15, -12, -5,
    -13, -4, 15, -22, 20, 21, 1, 19,
    20, 47, -24, 2, -17, 5, 5, 12,
    -16, 0, -2, 1, -21, 15, -20, 0,
    -7, 23, 19, 1, 15, 14, 2, -10,
    -8, -11, -4, 36, -13, 6, 4, -19,
    -38, -41, -15, -2, 3, 5, 19, -1,
    -1, 7, 8, -1, 5, -8, -14, -22,
    22, -18, 22, 4, -7, -1, -21, 18,
    1, 6, 44, -12, -14, -13, -5, 16,
    3, 23, -22, 1, -8, -8, -10, 12,
    6, 7, 4, 8, -5, -3, 5, -1,
    8, 10, -30, 7, 17, 6, -24, 1,
    16, 14, -4, -1, -3, -7, -9, 12,
    -41, 8, -4, 35, -2, -36, 9, -18,
    5, -1, 5, 19, -1, -6, 39, -2,
    -21, -8, 10, -8, 12, 10, -23, -10,
    22, -18, 64, -31, -4, 6, -3, 8,
    10, -74, 24, 26, 5, 3, -27, 28,
    -26, -31, -8, 1, 9, 3, -6, -5,
    -11, -47, -10, -5, -8, 0, 19, 17,
    49, 9, -1, 14, 4, -25, 6, -11,
    -20, -7, 37, -10, 4, 8, 12, -13,
    15, 14, 13, 2, 20, 5, -11, 11,
    -2, 6, 2, -4, 3, 2, 13, -7,
    -2, 16, 18, 9, 2, -13, -2, -9,
    8, -21, -13, -24, -1, 6, -17, -22,
    -15, -9, 10, 5, -26, -15, 1, 0,
    8, -4, -7, -2, -12, -20, 12, -6,
    -13, -21, 14, 57, -6, -3, 8, 2,
    28, 29, 11, 33, 7, -13, -8, 8,
    -19, -2, -6, 12, -4, 20, 10, -5,
    9, -24, 27, 14, 8, -19, -7, 15,
    2, -4, 30, 13, -4, -22, 7, -2,
    -12, 29, -9, -12, 5, -5, 26, -18,
    0, 6, 7, -38, 5, -3, 28, 0,
    -8, 28, -22, -17, 4, -2, 7, -16,
    4, -7, 18, -8, -5, -10, -13, 5,
    -37, 19, -49, 47, 1, -15, 18, 2,
    3, 4, -10, 5, 32, -5, -2, -1,
    2, -1, -25, -7, -24, -11, 3, -9,
    16, -17, -3, 9, 1, -4, -16, -19,
    8, 10, 14, -4, -4, -18, 4, 5,
    11, -11, -5, 0, 15, 9, -13, 17,
    -1, 17, 16, 10, -2, 22, 19, -2,
    -12, -13, -12, 18, -10, 25, 6, 7,
    10, -7, 24, -47, 8, 1, -31, 37,
    -11, -2, 21, 0, -6, -14, -3, 17,
    22, 31, 23, -19, 32, 16, -5, -23,
    -8, 48, 26, -15, -5, 4, 21, 0,
    -30, 4, -26, 1, 25, 25, -30, 0,
    7, -5, -4, -6, -21, -9, -18, 3,
    -1, -8, -29, -14, 3, 8, -8, 10,
    23, -3, 3, -8, -23, 9, 3, -4,
    17, -3, 25, -12, -2, -5, 12, -21,
    -11, 2, 1, 2, -22, -19, 7, 1,
    -25, -2, 22, -34, 7, -1, 0, 3,
    -4, 6, -19, 9, -10, 22, -1, -15,
    20, -2, 29, -13, -2, 0, -7, 15,
    -35, -4, -2, 1, -2, 6, 30, -2,
    -8, -2, 13, -36, -4, -3, -3, -9,
    -27, 36, -23, -41, -7, 16, 16, 4,
    7, 22, 0, -19, -7, 0, -10, 15,
    28, 4, -13, -4, 12, 3, 16, 13,
    -14, -1, 6, 4, -5, -1, -11, -2,
    6, -6, 0, 57, -27, 1, 6, -9,
    -4, 60, -15, 30, -10, -23, 3, -9,
    9, -4, 1, -12, -15, -6, -8, -8,
    -18, -12, 0, 7, -17, 11, 10, 1,
    -18, -18, 24, -11, -7, 6, -12, 6,
    -9, -45, 26, 26, 6, 8, -2, 9,
    -8, -18, -10, 4, -21, -4, -7, 24,
    22, -8, 14, 7, 15, -2, 0, 11,
    -3, -38, -45, 6, -22, -3, 0, 7,
    16, -42, 26, -9, 4, 21, -8, -2,
    0, 5, 3, -27, 0, -12, 7, 1,
    18, -18, 11, 2, 22, -3, 0, -7,
    -19, -10, 3, 22, 3, 8, -16, 1,
    14, 2, 7, -3, 36, -9, 3, -5,
    -8, -1, -4, -91, 9, 2, -2, -6,
    15, 6, 15, -19, 2, 10, 2, 4,
    37, -11, -17, 22, 15, 28, 16, 6,
    -10, 28, -2, -43, 5, 2, 12, 7,
    10, -7, 17, -1, -12, 9, 2, -16,
    8, -23, -28, -5, -11, -1, -9, -23,
    -2, 2, 20, -9, -28, -14, 31, -8,
    -9, -15, -26, 12, 3, -4, -16, 23,
    -9, -4, 1, 2, 17, -7, 8, 6,
    7, 22, -1, -5, 4, -6, 13, 10,
    -15, -2, 2, -28, 19, -2, -16, 18,
    -6, -1, -16, 62, -29, -2, -1, -29,
    -10, 13, 6, -4, 6, 34, -18, 14,
    -11, 4, -5, 29, -11, 5, 27, 6,
    19, -6, 17, -9, -1, -5, -7, -2,
    -5, -16, 30, 1, -7, 21, 6, 3,
    -3, 8, 4, -8, -20, -36, 5, -1,
    5, 1, 0, -4, -10, -5, -22, -13,
    13, 2, -18, 6, -5, 35, 9, -39,
    9, -6, 29, -34, -13, 0, 3, -19,
    -8, -5, -9, 15, -26, -42, 9, 3,
    -26, -21, 11, 0, -3, -10, 5, 0,
    -33, 56, 8, 7, -34, 0, 21, 8,
    21, -7, 24, -15, -1, 44, -8, -10,
    -7, 1, -9, -9, 12, -5, -23, -13,
    20, -46, 0, -40, -9, 19, -13, 25,
    22, 27, -14, -25, 10, 2, 17, -15,
    -40, -51, -15, 0, 9, -15, 13, -70,
    -2, 5, -5, 1, -12, 5, -12, -29,
    -2, 7, -35, 16, -25, -13, 10, -1,
    -18, 33, 24, 3, -11, 10, 9, 13,
    36, 6, 17, -30, 5, -15, 0, -13,
    -6, 6, 25, -4, 3, -21, 10, 10,
    8, -5, -12, -20, -5, -12, 0, -12,
    5, 25, 78, -35, -8, -8, 17, -2,
    -2, 0, -50, -7, -3, 3, 2, 10,
    -36, -6, 8, 50, 6, -4, 31, 3,
    3, -6, -27, -4, -7, -19, 17, -15,
    -5, -36, 26, 9, -8, 6, -2, 0,
    15, 27, -9, -22, 13, -20, 15, -8,
    40, -17, -8, -3, -13, 38, 46, -9,
    16, 30, 19, 13, -12, -7, 3, 7,
    6, 29, 24, -46, -24, -21, -25, 11,
    -40, -23, 28, 3, 1, 5, -5, -32,
    13, 7, 8, -12, 6, -25, -9, -5,
    9, 11, -18, -6, 11, -29, 13, 1,
    5, 6, 12, -15, 20, -5, -29, -11,
    -28, -9, -75, -6, -34, -1, -24, 4,
    3, 13, -1, -3, 2, -8, -2, -7,
    -11, 18, 30, -16, 2, -2, -21, -6,
    4, 2, -15, -24, -3, -26, 13, 21,
    25, 1, -8, -28, 6, 4, 1, 8,
    -21, 18, -6, 5, -30, -5, -22, 23,
    -14, 0, -8, 12, -4, -25, 10, 26,
    -13, 12, 54, -20, 11, -7, 45, -14,
    47, 34, -40, 1, 18, 26, -6, -26,
    -6, 6, -17, 4, 12, 37, -18, 8,
    29, 13, 17, 26, -33, -7, -40, -2,
    -1, -21, 30, 8, -4, -10, -1, 4,
    -28, 7, 19, -8, -11, -36, -13, -18,
    -10, 4, -1, 2, 1, -29, 0, 12,
    8, 37, -26, -4, 11, -8, 18, 17,
    -5, 21, 6, -30, -1, 5, 18, 13,
    14, -5, -10, 8, -6, -27, 1, -30,
    -2, -20, -4, 10, -2, -8, 20, -39,
    14, 1, -7, -25, -2, 26, -11, -49,
    0, 2, 8, 3, 3, 0, 6, 10,
    2, -15, 9, 34, 5, 14, 0, -10,
    -21, -11, -16, 13, 3, 52, -8, 20,
    7, -15, -18, 0, 0, 0, 15, -6,
    4, 31, 5, 23, -13, -35, 3, -22,
    -14, 21, -22, -11, 6, 22, -9, -20,
    17, 8, 26, -2, -26, -25, -17, -4,
    -3, -36, -7, -2, -7, -3, 4, -7,
    -33, 24, -1, 9, 38, 5, -11, -8,
    3, 4, 35, 13, 28, -17, 5, -5,
    10, -15, 16, 6, 12, -5, 23, 21,
    15, -9, 15, -14, 23, 5, 9, 7,
    7, -9, 33, 15, -7, -2, 9, 0,
    -20, 26, 21, 25, 36, -11, 17, -11,
    -11, -2, -9, 6, 1, 16, -19, 16,
    -7, -30, -29, 3, -7, 18, 19, 16,
    4, 12, -15, -24, -3, 3, -4, -6,
    -8, 7, -37, -14, -11, 12, -27, 5,
    7, 9, -6, -38, -4, -21, 16, -5,
    10, 7, -3, 18, 22, -14, -20, -4,
    -17, -12, -6, 15, -24, 0, -9, -63,
    -15, -6, 30, -32, 5, 0, -5, -24,
    -2, -8, -2, 10, 15, -11, 47, -9,
    -6, 9, 22, 3, -22, -10, 0, -20,
    -8, -9, 2, 27, -8, -3, 14, -11,
    -4, 27, 16, -3, 13, -8, -5, 5,
    -5, 7, 14, 0, 18, -8, -35, -16,
    -6, -3, 15, 5, 35, 44, 5, -24,
    -40, -19, 37, 27, -4, 31, -12, -18,
    11, -5, -45, -39, -9, -9, 35, 31,
    -9, -13, -2, 17, 33, 3, 4, -24,
    24, 8, 0, -33, 36, 7, 4, -10,
    45, 29, 6, -14, 8, -11, 40, -3,
    -13, -5, 33, 3, -6, -18, -25, -17,
    -2, 9, -27, -8, -22, -41, -2, -17,
    -32, -13, 32, -10, -4, -12, -17, 1,
    10, 16, -5, -4, -31, 5, -53, 35,
    -20, -17, 7, 14, 17, 0, -6, 7,
    -13, 5, -5, -11, -33, 7, 10, 28,
    7, -3, 3, -5, 6, 6, -9, 6,
    9, 11, 36, -27, -13, -2, 3, -10,
    11, 4, -20, 12, -9, -9, 23, 29,
    -32, 2, -6, -19, -3, -14, -16, -44,
    5, -3, -23, -20, -4, 5, -4, -22,
    -16, 47, 32, -49, 3, -8, -32, 5,
    19, 29, 4, 26, -12, 9, -14, 17,
    43, -3, -3, 5, 7, 15, -17, 7,
    -19, 0, -10, -20, 12, 10, -11, 4,
    30, 0, -18, -20, -12, 1, 12, 13,
    -22, -10, -20, 37, -3, -28, 29, 13,
    4, -15, -2, -8, -24, -20, 22, 1,
    -16, 28, -7, -15, -2, -1, 19, -17,
    14, -6, 9, 0, 42, 15, -4, 0,
    30, -49, 16, -7, 20, -16, -23, 8,
    -5, -37, -3, 5, 17, -1, -2, -16,
    15, -8, 20, 17, 6, -7, -15, -13,
    0, -28, 12, 3, -14, 18, -16, 7,
    32, 40, 20, 17, 10, -19, 3, 15,
    0, 10, -2, -37, -29, 13, 9, -10,
    3, 5, -9, -4, 25, 12, -5, 10,
    -38, 2, -28, 13, 1, 9, -22, 10,
    79, 4, -4, 11, 2, 4, -2, -1,
    2, 2, 7, -95, 13, -4, -19, -7,
    -6, 1, 51, -21, -1, 15, 5, 5,
    29, 2, -11, -38, 22, 7, 21, 21,
    29, 15, 14, -3, -13, 8, -9, 38,
    22, 5, 18, 12, -42, 83, 9, 42,
    18, -40, 2, 1, 63, 11, -22, -7,
    -25, 18, 30, 1, -27, -30, 23, -26,
    9, 9, 2, -34, 1, 35, 26, 9,
    -24, -12, 14, -3, -19, 21, -19, -16,
    7, 14, 8, 9, 12, 13, 14, -25,
    -15, -51, -2, 2, 27, -1, -1, 2,
    28, 26, 35, -48, -6, -16, 1, -8,
    -7, -1, -1, -12, -14, -27, -16, -5,
    4, -3, 9, -9, 37, -22, 13, 1,
    -17, 38, 5, -51, 5, -3, 0, -19,
    16, 2, 19, 17, -21, 29, -10, 17,
    9, 9, 5, -4, 15, 47, 43, 46,
    9, -42, 15, 11, -11, 17, 22, -25,
    -55, -70, -37, 17, 13, 95, 4, -94,
    -39, 29, -44, -48, -50, -21, 14, -11,
    -5, -13, 1, -3, 18, 56, -54, -1,
    17, 18, -17, -73, -36, -41, -15, -19,
    16, 27, 7, -32, -79, -36, 34, 17,
    55, 9, 52, -48, 5, -22, 9, -23,
    0, -13, -15, 8, -34, -17, -23, 37,
    1, 34, 37, -10, -5, -11, 13, 22,
    26, 7, -35, -94, -21, 8, 22, 3,
    6, -56, -39, -39, 55, -26, -10, -71,
    -15, 16, -5, 1, 9, 21, 9, 9,
    -17, 31, 44, -34, 35, -22, 23, 5,
    -14, -21, -24, 9, -17, 64, 31, 0,
    3, 40, 20, -34, 24, -21, -8, 24,
    2, 14, 18, 10, 21, 25, 6, -11,
    -5, 24, 10, -19, 13, 26, -3, -1,
    7, -22, 80, -59, -4, -6, 18, 3,
    -16, 14, 20, -29, 5, -6, -29, 3,
    -32, 6, -1, 62, 14, -23, -51, 8,
    -1, 29, 6, -16, -7, 40, 7, 4,
    34, -39, 56, 28, 4, -5, 0, 12,
    1, 96, -27, -9, -45, -28, 17, 51,
    28, -55, -5, -11, 7, -29, -27, 9,
    35, 23, -1, -13, 32, -23, 17, -7,
    -53, -39, 40, -22, -63, -26, -67, 34,
    -19, -110, 39, 10, 38, 21, 26, -51,
    -10, 18, 2, -8, -14, 34, 32, 10,
    2, 7, -3, -10, 41, 11, 5, -26,
    -4, -11, -62, -14, 55, 16, -31, -29,
    16, -30, 50, 20, -21, 34, -29, -33,
    -10, 16, -19, -14, -16, 14, 101, 28,
    3, 0, 20, 11, 12, 18, -35, -10,
    -13, 71, -19, -39, -8, -42, 8, 51,
    -96, -23, -11, -18, -37, -37, 19, -48,
    2, 24, -1, 0, 4, -16, -7, -2,
    7, 1, -25, 8, -10, 17, -25, -4,
    30, 74, 30, -29, -23, -31, 74, -21,
    46, 3, -14, -2, 32, -10, 12, -48,
    -42, -7, 6, -2, -28, -45, 15, -7,
    35, 88, 6, 17, 9, -27, 14, 8,
    -15, 52, 61, 2, 9, 13, 8, 11,
    -23, 18, -7, 4, 35, -1, -95, -4,
    7, 26, -28, -11, 7, 27, -30, 6,
    -25, -54, 6, 0, 26, -29, 44, -61,
    52, 15, 12, 53, -4, 0, 11, 26,
    43, 46, 8, -48, -17, 18, 30, 4,
    4, -22, 6, 16, -12, 15, -10, 35,
    15, -32, -39, -3, 10, -35, 12, 51,
    15, 43, -12, -31, 5, -1, -15, 31,
    14, 38, -31, 36, -3, -8, 21, -22,
    -28, -6, 9, -3, 14, 30, 30, -10,
    7, 43, -28, 50, 7, 8, -54, 6,
    -9, 56, 37, 69, -9, -38, 6, -33,
    -13, 12, -124, 8, -37, 27, 9, 37,
    21, 4, 35, 41, -33, 21, -30, 38,
    -11, -16, -31, 11, 32, 8, 30, 21,
    7, 11, -39, 32, 49, -8, -38, -7,
    18, 3, 20, -36, 98, -8, 4, 5,
    -11, -19, -5, 8, 4, -28, -21, -8,
    -5, -13, 11, -17, -53, -76, -18, -16,
    18, -34, 10, 78, -16, 34, 13, 13,
    -88, 59, 55, -111, 36, -49, -14, 25,
    27, 18, -6, 40, 0, -8, 17, -29,
    -39, -39, -36, -38, 48, 15, -28, 43,
    11, -35, -21, 19, -13, 12, -11, -9,
    -16, -20, -11, 35, -20, 37, 3, -10,
    -11, -6, -13, -54, 9, -19, 4, -36,
    -7, -26, 37, 42, 36, -2, -13, -23,
    4, 4, 83, 31, -53, -10, -19, -110,
    -65, -19, 72, -17, -29, 9, -38, 13,
    13, -1, 14, 5, -42, -16, -31, -13,
    5, 9, 52, 77, -9, -7, 6, 59,
    48, 34, -5, 67, -19, -2, 41, -40,
    -20, 39, -30, -35, 25, -44, -33, -2,
    -11, -18, 17, -8, -25, 6, 28, 33,
    -10, 12, -30, -31, -15, -27, 4, 1,
    -15, -6, 42, 76, 0, 48, -21, -21,
    -18, 22, -35, -46, 48, -34, 101, 28,
    -7, -8, 9, 10, -16, 43, 6, 21,
    -46, -28, 17, 12, 29, -41, -4, 32,
    -21, -4, 6, -33, 37, 3, 45, 0,
    -36, 13, 44, 18, -27, -61, 7, -38,
    2, 0, 22, -12, 57, 53, 0, -7,
    27, -12, 8, 8, -31, -8, 30, 3,
    5, -8, 23, -75, -20, 12, -25, 34,
    65, -7, -18, 6, 61, -8, -11, -8,
    -9, 7, 9, -13, 40, -12, 37, 37,
    20, 6, 2, 47, 13, -1, -25, -17,
    6, -7, -61, -37, -3, -9, -7, -18,
    -10, 25, -41, 35, -25, 29, 81, 22,
    -25, -3, 11, -18, 5, 2, 34, 11,
    0, 1, -34, 44, -10, 14, 15, -43,
    -16, 115, -8, 64, 0, -25, -83, 0,
    -3, 52, 14, -45, 11, -48, 8, -21,
    44, 0, -3, 11, 12, 7, 51, 29,
    -9, 28, 20, 20, 5, -21, -17, 34,
    -12, 6, 37, -14, 0, -11, -10, 11,
    -42, -6, 2, -12, -8, 1, 27, 61,
    0, -3, -10, -15, 3, 10, 14, 36,
    -25, 16, 19, -26, -37, 2, 3, -53,
    -43, -40, 12, -23, 49, 14, 20, -13,
    70, 16, -5, 12, -8, 7, -16, 17,
    -28, -47, 8, -7, 42, -25, 23, -26,
    -35, 22, -66, 20, -63, -20, -36, -20,
    -2, 50, 23, 9, 1, 29, -27, -11,
    43, 57, -23, 2, 34, -49, 3, 0,
    -2, 16, -11, -47, -6, -20, -2, 7,
    -64, 0, 25, 7, 11, 6, 8, -26,
    4, 6, -7, -7, 14, 1, -9, 16,
    -34, -15, 24, 16, -6, 8, 29, -14,
    -2, -1, 1, -127, 40, -14, -2, 21,
    -15, 8, -31, -9, -23, 2, 1, 31,
    -9, 25, -1, -17, -11, 27, 11, 0,
    -50, 70, 7, 6, 0, 16, -2, 0,
    13, 16, -9, -17, -11, 5, 24, -3,
    2, -4, -6, -9, -17, -15, -14, 12,
    -1, -27, -30, -20, -13, -19, 0, -7,
    12, -3, -15, 5, -14, 20, 0, 8,
    7, -1, 14, 0, -3, 7, 3, 36,
    -10, -23, -16, 9, 16, -16, -31, -15,
    38, -25, 9, 19, -30, 4, -10, -43,
    21, 10, -4, 15, 3, -9, 18, -11,
    17, 12, -19, 38, -6, 8, -4, -4,
    5, 27, -15, -11, -22, -3, 40, 51,
    34, -4, 33, 16, -20, 18, 27, 5,
    3, -10, -1, 10, -9, -3, 7, 1,
    36, 0, -15, -32, 0, -1, 4, -2,
    7, 4, 1, 6, 20, -36, 14, 7,
    11, 47, 17, -15, -2, -5, -45, -30,
    37, 14, 39, 12, -11, -16, 18, 26,
    -25, -23, -2, 21, -23, 9, -31, 23,
    24, -11, 1, 8, -39, -35, 0, -36,
    -14, 38, -14, -8, -1, -3, -2, 22,
    -40, 13, 20, -2, 31, -5, 2, 11,
    -26, 12, 27, 20, -9, 2, 29, 2,
    -10, 12, 36, -9, -23, -7, 0, -5,
    23, 15, -10, -13, 25, -1, 17, 23,
    -5, 21, 1, 15, 20, 2, 3, -14,
    6, 18, -18, -19, -1, 1, 44, 10,
    3, 14, 11, 18, -10, 25, -21, -2,
    16, 18, 17, 21, 2, 30, 15, -20,
    18, -12, -14, 14, -19, -14, -4, -15,
    -10, -28, 22, -20, 0, -8, 1, 34,
    12, -10, 2, 2, -20, -7, 41, -35,
    3, -9, 7, -37, -4, -2, -25, 18,
    -6, 4, -10, 13, -2, 7, 15, 7,
    10, -14, -7, -12, 6, 6, 3, -9,
    -9, 1, -1, 3, 11, 30, -29, -15,
    -14, 15, -16, -40, 39, -2, 2, -5,
    0, 40, -10, -20, -11, -18, 7, -4,
    -23, 27, 4, 13, 13, 4, -21, -1,
    2, 8, 2, -18, -10, -27, -40, -33,
    -3, -25, -3, -23, -34, -3, -10, -5,
    28, 6, -4, 13, 14, -30, -1, 7,
    7, 47, 22, -3, 26, -16, -4, -21,
    8, 11, 4, -27, -13, 8, -3, -18,
    -5, 27, 4, -3, -29, -10, -11, 44,
    9, -11, 30, 19, -6, -20, -7, 4,
    1, 0, 5, -9, 16, 7, 1, -21,
    3, -14, -1, -17, 2, 7, 12, -33,
    30, -11, 18, -12, -16, -35, -34, 3,
    54, -13, -11, 7, 5, 3, 13, 17,
    -8, 22, 19, 13, 16, -19, -23, 24,
    5, -5, -4, 9, 3, 6, -10, -6,
    10, 13, -22, 16, 14, -16, 6, 0,
    -10, -28, 6, 2, -5, -3, -22, -18,
    -16, 4, 17, -3, -14, -9, 23, 29,
    3, -14, -30, 11, -8, -8, -26, -9,
    2, 2, -13, -11, -2, 0, 32, -7,
    9, 15, -24, 7, 7, -4, -14, 13,
    -4, 20, -36, -19, -13, -7, 11, -24,
    -5, 10, -12, -19, 5, -13, -6, -3,
    -29, -2, -37, -5, -15, 19, -7, 24,
    -23, -4, 11, 1, -2, -18, -5, -3,
    9, -22, -1, 13, 11, -7, 11, 18,
    1, 28, -3, -1, 39, 53, 1, -54,
    0, 20, 14, 13, 3, -6, 0, 21,
    -1, -12, -7, 25, 3, -13, -22, -4,
    -25, 41, 14, -22, -7, 3, 6, -20,
    10, -2, 24, 8, 2, 25, -8, 20,
    -2, 22, -4, -17, -6, -8, 7, -19,
    -12, -3, -21, -8, -5, -6, 5, -23,
    9, -12, -5, -14, 17, -11, -1, 19,
    9, 1, 7, -34, 19, 4, 28, 17,
    39, 48, -7, -9, 16, 3, 8, -9,
    -18, 26, -23, -13, -10, -8, 15, -3,
    41, -50, -18, -6, 15, -11, 1, -17,
    -3, -2, -9, 7, 17, 0, -5, 30,
    8, 41, -24, 32, -22, 3, -4, 4,
    -34, 1, 8, 10, -14, -5, 0, -8,
    -18, -9, 19, -1, -6, -13, -3, 0,
    -39, 12, 23, 3, -2, -9, -3, -12,
    -16, -27, -2, -14, 2, -21, 6, 33,
    -7, -18, 19, 3, 4, -6, 6, 4,
    7, 0, -25, -23, 4, 12, -2, -16,
    11, 7, 12, -2, 6, -20, 50, 2,
    -12, -37, -29, -18, -11, -40, -1, 31,
    -12, 1, -43, 12, -4, -6, 0, 5,
    -33, -4, 8, -23, 6, 12, -27, -3,
    4, 5, -15, -12, -20, 14, -16, -46,
    -9, -21, -10, 12, 10, -11, 13, -17,
    -3, 16, -20, 5, -13, 1, -23, 12,
    28, -35, 25, -12, 6, -18, 57, -2,
    13, -20, -24, -6, -25, 23, 20, 20,
    1, -20, -1, 54, -20, -2, 9, -20,
    21, -6, 21, -21, -4, 21, 3, 2,
    17, -1, 2, -8, -22, 9, -8, -16,
    16, -9, 0, 13, 6, -18, -11, 14,
    -38, -22, -2, -14, 26, 18, 2, -6,
    33, -19, 29, -17, 4, 7, -16, -4,
    29, 37, -9, -1, 9, -6, 6, 12,
    -15, -17, 8, 0, -15, -21, -6, -20,
    -5, -1, 30, -23, 6, -20, -28, -9,
    12, 18, 5, 14, 0, -6, -5, -3,
    -33, -21, 12, -11, 26, -17, 6, 17,
    -6, 1, 2, -13, -11, 14, -32, 0,
    -3, -18, -29, 1, -16, -12, 27, 26,
    1, 0, 17, 17, -1, 5, 15, 16,
    -17, 1, -30, 40, 5, -11, 2, 0,
    0, 2, -3, -19, 2, -5, -43, 31,
    -8, -11, 30, -2, 16, 2, 0, -36,
    24, -10, -5, 26, 5, 0, -14, 16,
    24, -15, 12, -52, -9, 12, -2, -4,
    -15, 16, 6, -2, -5, 20, -9, 11,
    -19, -46, -15, 16, -7, -1, 10, 13,
    7, -16, 21, 32, -4, 4, 20, 3,
    -20, 2, 6, -19, 16, 14, -13, -5,
    -1, -5, 14, 1, 17, -43, -36, -11,
    29, 40, 48, -40, 4, 14, 10, -21,
    33, 8, 12, 1, -2, 0, -7, -11,
    -13, -4, -4, 25, -22, -2, -20, -3,
    -4, 13, 19, 0, -57, 19, 6, -12,
    -2, 15, -4, 23, -11, 9, 11, 0,
    -3, -13, -34, -1, -6, 3, -8, -9,
    -25, 23, -31, -28, 5, -13, 0, 21,
    15, 0, 6, 17, 14, 25, -21, 19,
    21, 0, -27, 4, -5, -18, -28, -2,
    27, 2, 14, -4, 25, -12, -7, 6,
    -36, 1, -4, 3, -12, 6, 14, 2,
    14, -14, -18, 11, -15, -6, 11, 4,
    -51, -18, -1, 15, -17, -3, -37, -8,
    5, -14, -10, -35, -24, 5, 0, -1,
    11, 15, -9, -19, 4, -3, 20, 11,
    26, -30, 0, 1, -2, 19, -7, 15,
    31, 26, -1, -13, 19, -24, -3, 18,
    -9, -1, 11, 7, -16, -5, 10, 3,
    -27, 0, 16, 15, 18, 25, -23, 4,
    -17, -60, 6, -31, -14, 20, -29, 9,
    -12, -13, 26, -41, -23, 12, 0, 28,
    0, -2, 0, 31, -16, -36, 9, 21,
    -2, 18, -35, 41, -20, -1, 2, 1,
    -11, 4, 16, -3, 30, 23, -43, 5,
    1, 32, 37, -6, -5, -27, -27, -4,
    18, -2, -41, 35, 8, -8, 6, 7,
    -32, -37, -62, -23, 13, 18, 18, 23,
    12, 4, -1, 8, -25, -46, 13, 21,
    -29, 25, -25, -44, -9, -76, 2, 49,
    -13, 21, 18, -13, -5, -13, -8, 24,
    8, -46, -10, 63, 108, 7, 10, 8,
    -12, -6, -4, 32, -12, -21, -41, -34,
    33, 2, -1, -21, 7, -11, -5, -39,
    5, -4, 1, 0, 31, -1, 2, 17,
    -50, -5, 18, 1, -22, -37, 53, -11,
    2, -6, 56, -13, -41, 4, -19, 3,
    -5, -23, -59, -15, -59, -15, 3, -10,
    5, 9, 19, -19, 5, 8, -1, -15,
    -30, 7, -5, -31, -47, -21, -43, -13,
    37, 22, -13, 1, 20, -3, 1, 43,
    30, -8, 10, -18, 0, -51, -19, 14,
    -2, 6, -6, -5, -4, 9, 12, -13,
    -29, 18, 8, 2, 27, 4, -17, -13,
    -4, 16, 0, 7, 2, 26, 10, -13,
    -4, 6, 2, -25, 3, -17, 58, 18,
    -18, -2, 5, -1, 5, 7, 15, 10,
    2, -1, 22, 20, 5, 16, 4, 1,
    -7, 13, 21, 11, 17, 7, -19, -21,
    31, 55, -21, 1, -21, 62, 19, -33,
    -18, 4, -2, -22, -10, -9, -12, -6,
    6, -14, 17, 13, 45, -25, -10, -14,
    3, -5, 11, -13, 44, -29, -19, -16,
    29, -27, 18, -12, -1, 11, 18, 9,
    -19, -57, -8, 8, 17, -54, 11, 6,
    -3, -8, 33, 0, -7, -37, 20, -12,
    -28, -3, 26, -22, 3, 11, 9, -1,
    5, -40, -11, -5, -6, -6, -50, 17,
    23, 13, -19, -2, 12, -13, -10, 6,
    -56, 14, 7, -14, 4, 2, 4, -4,
    20, 40, 25, 7, -37, -35, 7, -16,
    -30, 14, 34, -10, 40, -21, 25, 13,
    11, -34, -15, 1, 16, 22, 2, 16,
    23, -13, 2, -37, -14, 26, -26, 10,
    -29, -8, -13, -10, -40, 24, -9, 6,
    28, -41, 10, -3, 7, 57, -16, 7,
    0, 13, -21, -2, 6, 4, -41, -23,
    -50, 44, 19, -30, 27, 19, -17, 30,
    -42, -15, -19, 9, -50, -14, -26, -5,
    -4, -2, -33, 19, -8, -6, 5, 18,
    21, 7, -1, 12, -5, -6, 5, -4,
    -12, 9, -1, -10, -23, -28, 26, 6,
    20, 39, -9, -39, 13, -41, 4, 8,
    29, 10, -37, 87, 22, 31, -41, -17,
    17, 7, -5, -5, 1, -10, 5, 14,
    -40, -34, -13, -10, -26, 4, -53, -27,
    -2, 28, 29, -15, -21, -28, 17, 6,
    3, -20, 8, -21, -25, 11, 4, 37,
    17, 0, 7, 4, 7, -18, -19, 6,
    0, 40, -22, 4, -7, 1, -24, 70,
    -4, -3, -9, -3, 11, -23, 10, 4,
    7, 79, 16, 20, -47, -6, -13, 23,
    -30, -16, -13, -32, 7, -13, -8, -26,
    22, 31, 1, 20, -31, -3, 32, -67,
    -25, -10, 12, -12, 8, 30, 29, 30,
    7, 21, -2, -39, -4, 11, 6, 31,
    -4, 8, 5, -6, -13, 7, 25, 8,
    3, -26, -6, 19, 56, 18, 43, -6,
    -15, 17, -27, 12, 7, 0, -7, 9,
    65, 28, -44, 3, 37, -21, -22, -12,
    -32, 9, 11, -4, -8, 0, 4, -14,
    18, -18, -17, 13, 9, 2, -38, 40,
    -16, -5, -9, -3, 19, 29, -7, -7,
    7, -3, 52, -25, 2, -22, -78, -5,
    9, 14, -12, -4, -2, -12, -13, 13,
    -6, -15, -27, -32, 15, 11, -12, 12,
    6, -9, 16, 14, -6, -26, 57, 6,
    -7, -3, -62, 15, 22, -57, 50, 2,
    4, -10, 24, -28, -7, -7, -18, 2,
    4, -9, -20, 73, 37, -17, -28, 23,
    3, 2, 12, -6, -18, 0, -9, 28,
    38, 20, -44, 37, 28, -1, 0, 20,
    -20, 57, -20, 5, -13, 7, -20, 26,
    6, -2, -5, 38, -18, 18, 10, 37,
    -77, -2, 3, -12, 3, 17, -36, 52,
    -26, -40, 28, 13, 29, -17, -2, 10,
    29, -12, -3, -10, 2, 21, 11, 3,
    23, -4, 46, -70, 0, 24, 3, -5,
    37, 7, 0, -7, 7, -8, 45, 25,
    -56, -25, 14, -7, -6, -36, -27, -13,
    -7, -11, 9, -13, -14, 43, -1, 1,
    23, 5, -20, -5, 60, 1, -19, 3,
    5, -28, -21, -15, 8, -22, 8, -16,
    50, -33, 54, -55, -5, -10, 1, 23,
    0, -3, 12, -9, 33, 1, 3, 13,
    -57, -26, 22, -43, 24, 12, 41, -30,
    26, 13, 2, -4, 3, 21, -39, 12,
    -14, -38, -33, 79, -23, -17, -2, -55,
    1, 31, -12, 18, 6, 4, 3, 14,
    7, 40, -5, 11, -5, 8, 14, -21,
    1, 18, -20, -23, 5, 11, -9, 14,
    -23, -11, 34, 12, 18, -15, -13, -15,
    8, -3, 21, 22, 3, 9, -2, 6,
    -3, 17, 51, -13, -4, 27, 43, 10,
    -6, 4, 13, 3, -1, 20, 11, 4,
    -34, 21, -12, 9, -7, 0, -9, 43,
    -4, 7, -30, 10, -2, -1, 5, 19,
    -9, 69, 11, -3, -2, -44, 13, -41,
    5, 4, -5, 19, 13, 15, 2, -37,
    18, 14, 69, 21, -11, -11, 35, 37,
    38, -11, 10, -3, -10, -11, -15, 9,
    -49, -20, 2, 17, -40, 4, -18, 15,
    15, -12, 6, 3, -25, 3, -5, 26,
    -2, 0, -7, -1, -5, 49, 17, 14,
    5, 42, -3, -2, -2, -1, -17, 2,
    -10, 9, 2, -5, -19, -31, 36, 48,
    0, 14, -1, 7, -9, -35, -8, -11,
    25, 24, 43, -8, 96, 6, 19, -12,
    7, 6, 0, -22, 19, -1, 6, 8,
    23, 18, -10, -17, 79, 13, 3, -1,
    9, 28, -3, 8, -16, 10, 23, 7,
    48, -2, 35, -34, 25, 32, -1, 43,
    113, 3, -9, -41, -37, 14, -1, -7,
    13, -21, -18, -2, 34, -9, -7, 32,
    46, -51, 16, 10, -21, 0, -25, -20,
    9, -8, -51, 40, 10, 24, -57, -19,
    27, 4, 19, -9, -50, 7, 29, 30,
    8, -6, 23, 49, 33, 12, 49, 21,
    -19, -110, 55, -76, 51, 78, 2, 76,
    32, 50, 39, 57, 23, 43, 6, -16,
    1, -14, 11, -2, -54, -50, 23, 35,
    17, -50, -19, 2, 49, -50, 7, -24,
    -18, 29, -48, 2, 16, 4, 78, 42,
    43, -11, -2, 51, 25, -3, -58, -19,
    45, -21, 23, 25, 0, 4, -19, 8,
    -2, 50, -67, -30, 11, 27, -29, 15,
    4, -21, -4, -4, 3, 61, -8, 4,
    -8, 9, 21, 108, 18, -13, -39, -50,
    -19, -27, 1, -38, 21, -32, -27, 71,
    9, 17, 2, -11, 47, 1, 17, -24,
    -48, -3, 13, 55, 14, -57, 20, 4,
    -17, 28, -5, -27, -25, 19, 1, 67,
    4, 1, 5, 26, 58, 2, -8, 2,
    -26, 9, -13, -26, -25, 9, 15, -57,
    3, -19, 79, 15, -29, -19, -64, -4,
    -46, -20, 116, 2, -6, -8, -20, -33,
    -45, 40, 56, -8, 0, 13, 0, -12,
    -33, 14, -7, 16, -24, -31, 6, -11,
    29, 35, 2, 12, 34, 4, 17, 73,
    -82, -20, -46, 0, -34, -14, 36, -66,
    -12, 54, 6, 21, -16, 18, 14, -1,
    -38, -45, 9, 13, -35, -55, -42, -26,
    18, 32, 3, 36, 0, 10, -18, 27,
    -1, -16, 39, -4, 7, 22, -17, -22,
    -13, 57, -1, 1, 17, 1, 27, 3,
    13, -41, -9, 30, 3, 14, -25, -12,
    3, 37, 27, 7, 21, -18, -22, -21,
    -10, -1, 37, 23, 7, -14, 5, -3,
    34, -8, 49, 7, 13, -48, -12, -9,
    -8, -21, -39, 53, 8, -17, 24, -14,
    -18, -20, 7, 11, 21, -34, -14, 34,
    66, 39, -8, 11, 66, 20, -46, -16,
    37, 0, -20, -22, 10, -98, -6, 34,
    -21, 7, 11, 2, -58, 7, 36, -19,
    -52, 6, 29, -51, 109, -20, 26, -9,
    12, 13, -65, 4, 23, -52, -29, -12,
    -17, 50, -25, 19, 32, -23, -36, 40,
    47, -36, -1, 8, 62, -32, -43, 15,
    3, 40, 10, 5, -35, 51, 46, -13,
    10, 3, 74, 8, 14, 31, 0, 27,
    -26, -51, -36, 33, 21, 64, -3, -12,
    26, -42, 14, 18, -7, 3, -47, -11,
    -31, -16, -47, -11, -8, -48, 6, -94,
    -1, -60, -26, 33, 21, -62, 5, 80,
    8, 12, 47, -5, 29, -9, -83, -46,
    -14, 0, 42, -48, -22, -24, 37, -15,
    -19, -15, -10, 9, -3, -25, 51, -48,
    -48, -13, 28, -6, -29, 9, -44, -4,
    12, -31, 27, -77, -21, 25, 49, 3,
    -62, -30, 16, -25, 10, 29, -17, 19,
    34, 63, -4, -75, -13, 12, -4, 83,
    -20, -36, -37, 0, 28, -30, -26, -22,
    -7, -54, 0, 33, 8, 10, 6, -5,
    -16, 21, 33, 3, -16, -3, 13, 2,
    -10, 40, 32, -21, 7, 0, 8, 63,
    13, -67, -5, 51, -21, 31, -49, 15,
    3, -13, -48, 1, 5, -24, -34, 5,
    -21, -8, 37, 6, 1, 0, -7, 21,
    -4, -17, -33, 6, 5, -75, -14, 0,
    26, 7, -37, 53, 44, 29, 36, -11,
    15, 26, 67, -5, 24, -20, -15, -27,
    -17, 8, 32, -63, -16, -27, 12, -33,
    -35, -5, 45, 2, 15, 22, -18, 94,
    -56, 10, 2, 49, -52, -59, -5, 2,
    -36, -76, -15, 17, -43, 25, 7, 15,
    -36, -34, -31, 25, -12, 46, 13, 14,
    -9, -5, -37, 23, 92, -17, 92, 25,
    -45, -14, 71, 11, -4, 25, 19, -73,
    18, 41, -93, 45, -6, -10, 1, -44,
    -27, -15, -22, -53, -26, -9, 72, 57,
    -35, 31, -25, 15, -30, -28, 30, -30,
    22, 8, -77, 12, -23, 15, 12, 3,
    -28, 50, -34, -44, 26, -12, -58, -4,
    5, -26, -21, -18, -6, 12, 13, 18,
    10, 5, 38, -7, 0, -38, 34, 27,
    -50, 0, 18, 6, 1, -33, 20, 13,
    24, 13, 42, 29, -56, -2, -19, 14,
    21, 7, -65, -9, 39, -11, 18, -22,
    15, 4, 0, 16, -36, 14, 9, 24,
    -28, 11, 16, -45, 19, -24, 11, -39,
    -18, -71, 24, -9, -38, 29, 5, 95,
    26, -35, -11, 2, 21, -30, -11, -3,
    -123, 7, -11, -29, 71, -42, 67, -5,
    46, -19, 53, -10, -48, -8, -14, -24,
    -7, -52, 1, -6, 23, 35, 12, -19,
    14, 15, 17, -19, -8, 38, -37, -5,
    -8, -12, -10, -5, 5, 7, 8, 18,
    34, -4, -14, 55, -4, 65, -2, 64,
    -51, -32, 76, 20, -1, 91, 16, -19,
    -22, 1, 3, 3, 12, -11, -6, -24,
    -15, -84, -7, -3, -16, 15, -9, -19,
    27, -37, -88, 42, 14, -4, -89, 10,
    -8, -20, 44, -46, 60, -4, 3, 8,
    27, -34, 7, 32, -17, -7, -82, -20,
    41, 7, 36, 0, 17, 18, -57, 8,
    27, -23, 11, 53, 4, -28, -2, -17,
    -2, -16, 43, -67, 12, 13, 9, 41,
    5, 30, 49, 80, -1, 32, -22, 6,
    -15, 38, -8, -1, -8, -1, -17, -8,
    -42, -4, 45, -18, 1, -5, 3, -38,
    -18, -1, -29, -6, 2, 10, 13, 30,
    -4, 14, 33, -42, -1, -17, -17, 30,
    -1, 13, 34, -10, -10, 14, -31, -30,
    -105, 2, 71, 20, 4, -15, 38, -22,
    40, -82, -87, -42, 2, -4, -2, 29,
    -29, 85, 5, 17, -5, 7, 11, 33,
    12, -36, -3, -5, 26, 9, 71, -2,
    -18, 12, -43, 74, -2, 12, 0, 89,
    -102, -2, 7, -8, -22, -35, 7, 23,
    -65, -31, -8, 20, -19, -24, 12, 40,
    -28, 13, -3, -6, -5, 22, 5, 55,
    -56, -13, 1, 9, 5, 4, -1, -34,
    21, 33, -13, -4, 2, 20, 2, 19,
    0, 19, 50, -38, -5, -4, -15, 22,
    -2, -8, 16, 9, -15, -24, 55, -10,
    -33, -16, 15, -14, -102, -27, -67, 13,
    -73, -22, -32, 44, 22, 2, 37, 17,
    12, -10, -22, -19, 11, 12, -1, 2,
    -22, 56, -9, 10, -14, -13, 45, -7,
    -10, -16, -25, 10, -26, 11, 49, -36,
    -7, 6, -19, 14, 38, -9, 12, 6,
    10, -30, 24, 34, 4, -26, -17, 18,
    42, 36, -2, -21, -10, 5, 19, -18,
    21, -2, 7, 22, 7, 30, 11, -5,
    -3, -19, 6, 2, 3, -3, 37, -15,
    12, -47, -9, -11, 7, 16, 21, 35,
    0, 39, 35, -27, 12, 4, -11, -27,
    10, -11, 28, 39, -42, -6, -17, -1,
    2, -1, 6, -2, 10, -22, 7, 17,
    10, 30, -5, 10, 13, -2, 3, -8,
    53, -10, -66, -20, 12, 24, -1, 9,
    1, -6, -6, 23, 21, -19, 8, -29,
    0, 1, 3, 0, -4, -4, 8, 7,
    -14, 4, 37, -18, -10, -5, -17, -3,
    -19, 26, 19, -26, -35, 16, 25, 15,
    3, 11, 20, 37, -2, 21, 31, 43,
    -14, 1, 11, 5, -34, 4, -24, 2,
    25, -45, -16, -32, -16, -18, 43, 15,
    22, -22, 22, -29, -29, 1, 7, -39,
    51, -14, -18, 8, 27, 27, 14, -28,
    1, -2, -1, 2, -14, 12, -18, -24,
    18, 53, 16, -60, 17, -2, -11, 13,
    -19, 7, -26, 31, -14, 35, 38, -4,
    -14, -20, 1, 4, -33, -4, 5, -38,
    0, 5, -9, -11, 18, -10, -6, -8,
    3, 5, -19, 22, 17, 27, -8, 8,
    -24, 3, -23, 5, 30, 29, 36, 4,
    -36, 6, 0, -16, -22, -36, -1, -20,
    -2, -1, 2, 0, 23, 3, -3, 6,
    1, 32, 28, -46, -19, 1, 2, -6,
    26, 8, 18, -35, -10, 24, 12, -15,
    -4, -11, 20, -9, -48, -2, -5, 42,
    -2, -4, 8, 11, -9, -26, 33, -10,
    8, 6, -11, -11, 1, 6, 9, -21,
    1, -4, -7, 22, 8, -6, 22, 0,
    4, -21, 14, -23, 39, 0, -3, -28,
    7, 12, 12, 5, 2, 20, -15, 10,
    43, -47, -21, -18, 13, 6, 22, 5,
    18, -5, 22, 4, 30, -14, 9, 17,
    3, -49, 23, -10, -11, -13, 7, -22,
    0, 1, 1, 11, 18, -54, 18, 1,
    -29, 20, 50, -60, -1, 12, 19, -2,
    -5, -31, -14, -37, -9, -35, 2, -22,
    14, -30, -35, -17, 7, 0, 8, -5,
    10, -3, -5, -8, 6, -4, 12, -1,
    -46, -24, -3, -40, 17, -4, 6, 4,
    41, 21, -40, 4, -9, 22, -27, 28,
    -45, -5, -1, -3, 35, -42, 6, -12,
    10, -4, 15, -9, -28, 12, -34, 0,
    -15, 4, 11, 66, 11, 21, 0, -21,
    -22, 43, -1, -14, -5, 12, -42, -47,
    14, 2, 29, 36, 33, 24, 20, 6,
    5, -3, 13, -14, 5, 39, 50, -26,
    -21, -40, -23, -6, 14, -26, -14, 19,
    10, 12, 5, -27, 17, -10, -4, -26,
    -2, 42, -28, 32, -3, -2, -18, 25,
    13, -13, 12, -5, 20, 13, 3, -9,
    28, -19, 8, -24, -12, -10, -27, 10,
    13, -18, 9, -46, -4, -17, 56, 38,
    -7, -17, 32, -13, -5, 21, 1, -20,
    -5, 16, -4, -8, 3, 70, -2, 22,
    17, 11, 43, 9, 11, -16, 19, -37,
    16, 1, 44, -28, 2, 18, -45, -35,
    -20, 9, -3, -15, 5, 9, 10, -8,
    8, -17, 2, -8, -19, 20, -22, -4,
    6, -13, -34, -14, -1, -22, -4, -5,
    17, 21, -30, -21, 17, -18, 12, 60,
    2, -10, 4, 15, -4, 24, -36, 4,
    -8, -1, 8, -9, -6, -25, -13, -6,
    28, 25, 29, -2, 3, 1, 9, 14,
    32, 1, 1, -37, -8, -22, -18, -43,
    -64, -17, -44, 14, 35, -8, 18, -41,
    -9, 15, -11, 0, -6, -32, 10, 0,
    -6, 7, -57, -34, -41, 39, -12, 16,
    19, -18, 73, -1, 20, -10, 38, -12,
    -5, -6, -17, -39, 13, 11, 14, 5,
    14, -11, 10, -10, 4, 4, -45, -19,
    38, 2, -14, -21, 8, 6, -27, -11,
    31, -26, -9, 18, -46, -1, -13, 24,
    18, -32, 27, -9, 6, -3, -12, -28,
    8, 1, 11, 4, 5, -8, 4, -17,
    4, 9, 61, 5, 6, 15, 3, 22,
    -46, 17, -56, 12, 11, -7, -6, 11,
    17, -10, -25, -18, 0, -73, -2, -26,
    0, 3, -1, 9, -1, 8, -12, -9,
    38, -10, -18, 7, 31, -3, 10, 34,
    -32, -2, -20, 30, 17, -12, 2, -19,
    16, -16, 22, -12, -7, -11, 16, 19,
    6, 3, -6, 7, 1, -2, 11, -19,
    -37, -11, -13, -47, 16, -14, 1, 21,
    25, 22, 23, -44, -30, 33, -24, -53,
    -6, -6, -38, -18, 0, -36, -35, 20,
    -20, 8, 15, -14, 1, -14, -16, 4,
    -34, -36, 15, 16, -18, -15, 14, -21,
    -1, -5, -20, -26, 9, -16, -1, 19,
    21, -22, 8, 11, -9, -6, -19, -27,
    -10, 3, 17, -2, -16, 12, 38, -8,
    -12, -21, -21, 21, -19, -22, 23, -21,
    0, 0, -8, -38, -69, 8, -11, -27,
    -20, 33, -57, 65, 7, -8, -1, 19,
    3, 12, 11, -10, 6, 32, 47, -11,
    -14, -30, 7, -2, -4, 16, -5, -22,
    4, -4, 42, 33, -15, -13, 10, -25,
    5, 19, 26, -17, -15, -8, -14, -5,
    -7, -1, 10, 6, 11, -14, -10, -10,
    -1, -33, 5, 44, 15, 46, 16, -15,
    -5, 17, 12, -43, -24, -15, -24, 51,
    27, -35, -18, 3, 30, 10, 13, -28,
    3, 6, 1, -3, -10, 13, 14, -1,
    -31, 38, 22, -31, -1, -24, -2, -30,
    -5, 56, -15, -27, 7, -6, -21, -17,
    10, -27, 3, -20, -12, -35, -9, 0,
    6, 15, -6, 1, 1, 17, -23, 12,
    -23, 11, 0, -51, -2, -13, -24, -36,
    -72, 0, 31, -28, 14, -25, 5, -22,
    12, 21, 19, 23, 30, -10, -4, -47,
    1, 5, 3, 9, -29, 1, 27, -59,
    -44, -7, -63, 5, -10, 16, 32, 42,
    -9, -37, 37, -14, -19, 14, -13, -11,
    -42, -11, 1, -25, -4, 68, -11, -28,
    1, 14, 11, 5, 5, 8, -11, 16,
    -37, 13, 25, -8, -29, -7, -1, -34,
    -13, -11, -24, -32, -18, 42, 46, 5,
    -1, 8, 11, -13, 25, 12, 9, -77,
    6, -4, -4, 9, -34, -24, -24, -4,
    -2, -36, 15, -7, 13, 8, 19, 4,
    5, -47, -18, -44, -23, -1, 3, -12,
    -1, -20, 3, 5, 20, 42, 25, -37,
    0, -22, -8, -1, 26, 41, 16, -36,
    -16, 0, -3, 4, 5, -24, -32, 24,
    -8, 72, 11, 19, -22, -7, 18, 13,
    25, -4, 34, 23, -3, 33, 5, 0,
    -12, -13, -5, 3, 10, 5, 28, -49,
    12, 11, -8, 5, 32, -1, 46, 29,
    -32, 78, 18, -45, 11, 26, -23, -49,
    20, -10, 63, -39, -10, 11, 30, 9,
    22, 5, 6, 0, 1, -29, -18, -38,
    -23, 60, 48, 9, 32, 32, 43, -26,
    27, 29, -11, -53, 34, 22, -19, -13,
    -7, 5, 7, -8, 2, -14, -28, -5,
    1, 26, 8, -8, -20, 39, 13, 10,
    -3, 1, -8, -12, -11, -11, -18, -6,
    4, -44, 45, -27, 12, 18, 40, 3,
    38, -13, 1, 47, -10, 44, 13, -44,
    -12, 7, 9, 22, -18, 3, -24, -17,
    38, -11, -2, 24, -12, -37, 54, 35,
    -2, -38, 20, -2, -1, 34, -46, 0,
    24, -17, -24, 26, -10, -3, 62, -46,
    11, -22, -10, 7, -20, 8, 10, 9,
    2, 31, -6, -75, 30, 8, -35, 42,
    -27, 8, -32, 9, -34, 10, 31, -37,
    27, 3, -39, 3, 22, -27, -3, -30,
    -7, 7, -17, -14, 36, 6, -30, 26,
    17, 17, -26, -15, 28, 27, 2, -15,
    -51, 9, 12, 29, 20, -1, 30, 45,
    -18, 54, 7, -1, -20, -32, 12, -14,
    2, 18, 7, -15, 34, 24, 19, -3,
    -41, 6, -7, -10, -27, 28, -8, 0,
    56, 7, -2, -56, 11, 38, 7, -3,
    8, -7, -6, 3, -44, -20, -23, 38,
    0, 0, -31, 11, -7, -17, 3, -1,
    -1, -19, 23, -39, 6, -19, -1, -8,
    -3, 13, 19, -25, 9, 2, -4, 8,
    -6, -14, 19, -54, 32, -5, 5, -37,
    2, 5, 9, 11, 10, 1, -4, 20,
    -11, -43, 26, -15, 19, -22, 22, -11,
    29, -10, 5, -21, 52, 32, -21, -2,
    34, -38, 26, -21, -33, -35, 9, -25,
    -6, 3, -4, 8, -7, -55, 35, -10,
    -17, -38, 17, -28, 34, 3, 11, -36,
    14, -29, -22, -38, 13, -2, -4, -24,
    31, 42, -20, -7, -18, 0, 8, -5,
    15, 4, 10, -4, 0, -14, -5, -26,
    -13, -1, 48, -29, 27, -25, -11, -25,
    -26, -13, -5, 7, -39, -15, 21, 28,
    2, 2, -33, -41, 35, -44, -21, 41,
    7, -4, 14, -2, -4, 8, -19, -4,
    11, -7, 46, -29, 17, 40, 7, -28,
    32, 9, 28, -10, -22, 17, -20, -31,
    -18, -8, 22, -18, -1, 13, -41, 6,
    14, -22, -2, 3, 2, -46, 18, 4,
    13, 14, -16, 27, 16, 19, -25, 5,
    -13, -27, 18, -11, 15, -52, 36, 5,
    10, -11, 16, 9, 13, 1, 10, -19,
    -7, -1, 16, -9, 16, -1, 24, -36,
    -26, 2, -9, 53, -4, -1, 1, -11,
    -24, 12, -11, -28, 31, -16, -3, -10,
    -2, 1, 21, 2, 12, 27, 7, 24,
    6, 6, -5, -1, 13, 26, 7, 35,
    1, 12, 0, -38, 20, -17, 25, -29,
    -15, -8, -17, -54, -29, -15, -2, 57,
    1, 39, -27, -9, -3, -23, 17, 42,
    11, -6, -12, -4, 0, 1, -5, -3,
    6, -9, -38, 12, 10, 7, -21, 0,
    -3, 0, -39, -18, 13, -47, -43, -3,
    3, 27, 10, 20, -17, -6, -31, -4,
    14, 0, -4, -30, 20, 8, 3, -38,
    -13, -9, -43, -22, 21, -6, -25, 9,
    11, 41, -41, -30, 2, 55, 9, 2,
    -67, 10, -13, -16, 15, -8, 0, -37,
    -16, -16, -8, 0, 50, -15, -10, -23,
    53, 76, 63, 11, -27, 19, 38, 11,
    23, 16, 50, -4, 33, -35, 23, -35,
    2, 23, -1, -17, -6, -30, 16, -4,
    -1, 0, -5, -19, -7, -34, -59, -21,
    25, 9, 48, -12, -9, -5, 10, -24,
    54, -7, 8, -4, -18, 27, -28, -8,
    6, -28, 0, 0, 21, 3, -23, -27,
    0, 12, 12, 1, -3, 25, 32, -31,
    21, -11, -29, 2, 7, 9, 10, 20,
    -36, 9, -55, -9, 9, 15, 10, 11,
    8, 6, -104, -13, 7, -43, 4, -22,
    3, 8, -23, -4, 27, 7, -17, -24,
    10, -14, 39, 7, 10, -4, 15, 43,
    -23, -21, -19, -7, 33, -15, -31, 10,
    30, 12, 23, 15, -51, 70, 29, -5,
    1, 9, 16, -5, -6, 24, -13, -19,
    -1, -39, 27, 52, -23, -12, 27, -3,
    81, -47, -7, -3, 16, -6, -3, 10,
    1, 34, -11, -69, 7, -17, -21, -5,
    -7, 9, -27, -39, 20, -11, -3, 4,
    9, 7, 3, -13, -26, -34, 14, -2,
    45, -30, 4, -1, 8, -25, 30, 29,
    12, 26, -4, 1, -16, 4, -6, -28,
    -26, 18, 10, 3, -24, 25, 20, 6,
    25, -7, -29, -14, -6, -34, 12, -4,
    -14, 11, -39, -46, -20, 39, -50, 33,
    4, 17, 3, 44, 15, -6, 34, 27,
    4, 8, 3, 7, 23, 13, 43, 0,
    -6, -18, -21, -1, 13, 17, -30, -4,
    -71, 7, 13, 6, -24, -5, 8, -46,
    18, 6, 44, 8, -34, 0, -12, -22,
    1, -3, -7, 10, -9, -22, 2, 35,
    5, 17, 7, -39, 4, 30, 9, 5,
    8, -24, -17, -27, -2, 14, 18, -18,
    11, -27, 29, -20, 35, -6, -2, -35,
    4, -19, -1, 0, 3, 27, 9, 26,
    -19, 21, 21, -52, -4, -21, 20, -18,
    -11, 46, -52, -3, 19, -28, -8, 6,
    7, -31, 4, -22, -18, 35, -49, 16,
    -1, 6, 10, -9, 10, 20, 21, 4,
    -42, 24, 15, -15, -5, 23, -2, -41,
    -98, 26, 30, -9, -1, -1, -41, -1,
    2, 7, 20, -16, 21, 7, -3, 19,
    7, 12, 6, -8, -11, 16, 14, -26,
    17, 19, 3, -3, 4, 19, -4, 6,
    -46, -39, 35, -3, -13, 1, 17, 39,
    -32, -44, 9, -7, 2, 34, 10, -3,
    -2, 14, 23, 7, 13, 5, -3, 4,
    -28, 7, -51, 17, -28, -11, -9, -22,
    -21, 3, -32, -11, 8, -9, 0, -13,
    -19, 20, 1, 1, -5, 17, 2, -66,
    6, 0, -19, 8, -23, 5, -21, -13,
    13, -2, 51, -14, -37, -8, 17, 13,
    -18, -53, -29, -34, -21, -25, -8, 19,
    31, -1, -3, 17, -75, 72, 48, 8,
    6, -27, -8, -40, 2, 11, -2, -31,
    -16, 25, -15, 52, -1, -127, -24, 20,
    -10, 111, 23, -36, -22, -100, 2, -27,
    -9, -17, 64, 27, -46, 33, 10, -5,
    -24, 2, -20, 6, 8, 37, 55, -46,
    -55, 123, -21, -28, 42, -27, 57, 26,
    -15, 112, 5, -44, 41, -11, 21, 17,
    15, -6, 10, -15, -52, 64, 0, 14,
    31, 1, 11, -16, -23, -39, 18, -12,
    -13, -2, 15, 12, 89, 40, -15, -10,
    -56, 47, -19, -36, 1, 26, -35, -30,
    28, 0, 54, 16, 29, -30, 25, 7,
    -1, 24, -2, 1, -9, 7, 25, 10,
    -12, 83, 3, -54, 26, -26, 3, 20,
    18, -66, 44, 16, -27, -25, -29, 61,
    31, 49, -10, 19, 1, 47, 6, -54,
    6, 28, 14, 21, -37, 28, -16, -64,
    -7, 42, -37, -90, -53, -53, 23, 20,
    40, -40, 54, -80, -30, -36, 58, 8,
    11, -9, -1, 7, 21, 63, -17, -17,
    5, -14, -19, -6, -50, 55, 22, 29,
    -16, 21, 12, -70, 1, -36, 16, 89,
    -5, 13, 15, 11, 34, -29, 99, -96,
    45, -19, -79, -50, -18, 1, 20, 18,
    -13, -1, -8, -18, 54, 2, -18, -5,
    -7, 8, 38, -18, 96, 13, -22, -19,
    -113, -8, 64, -18, 19, 0, -13, -23,
    -8, 6, 5, 26, -39, 3, 33, -3,
    -9, 45, 16, -37, 71, -13, -6, 13,
    16, -1, -91, 12, 38, 17, 22, 34,
    51, -2, -6, -79, 10, -109, -32, 38,
    -13, -22, -18, -4, -33, 1, -20, 39,
    -2, 0, -63, 20, -25, -39, -50, 1,
    16, -54, -54, -31, 1, 15, 6, -1,
    1, 31, 18, -9, -15, -22, 39, 27,
    20, 38, -8, -60, 47, -33, -12, -35,
    -8, 15, 6, -13, 8, -8, 4, -25,
    -22, 44, 23, -50, 57, -14, 0, -1,
    37, 20, 34, -6, -52, 42, -2, -35,
    8, -36, 79, -48, 8, -68, -7, -15,
    -12, 4, 1, 16, -27, -18, 25, -22,
    4, 71, -28, 1, 59, 27, 28, -50,
    4, -60, -29, -26, -87, 47, 52, -30,
    13, 18, -28, -66, -31, 29, 36, 8,
    15, -10, 6, -9, 29, 17, -50, -51,
    14, -41, 24, -36, 26, -98, -44, -59,
    -63, -37, 45, -25, 31, 58, -85, -44,
    -63, -27, -29, -43, 30, -77, -45, 20,
    -4, -11, 28, -16, 6, 11, -5, -57,
    17, 18, -17, -93, -3, 77, 47, -4,
    37, -6, 23, -47, -33, 29, -11, 53,
    22, -12, 7, -10, -2, -18, -28, -35,
    16, -6, -9, 11, 48, -2, 37, -7,
    -37, -57, 60, 44, 46, 32, 38, 36,
    35, 40, 29, -45, 38, 58, -86, 14,
    42, 5, 36, -5, 2, -36, -19, 6,
    -20, -7, 27, -7, -64, -40, -14, -30,
    18, 39, -4, 97, -31, -20, 22, -65,
    -68, -61, 13, 25, 10, 70, -22, 2,
    48, -14, -7, 4, -43, 47, -43, -6,
    21, -16, -16, 0, 32, 4, 1, 0,
    50, -16, -3, 66, 19, -4, 3, 3,
    11, -15, -42, -79, -22, 24, 31, -80,
    -1, 32, -9, 10, -30, -53, -2, -1,
    15, 14, -26, -9, -12, 34, -41, 15,
    16, -7, -59, -43, -1, 25, 9, -6,
    1, 19, -7, -40, -1, 9, 87, 9,
    4, 62, 9, -5, -5, 26, -8, -18,
    18, -2, -22, -57, -9, 43, -43, -38,
    -9, 3, -44, 42, 40, -1, 20, -21,
    51, 43, -82, -21, -42, -32, -37, -11,
    17, 25, 39, -15, -3, 40, 30, -30,
    -20, -1, 11, -4, 38, -24, 10, -23,
    60, 49, -12, -38, -8, -44, 59, -12,
    42, -71, 33, 22, -54, 105, 34, -3,
    5, 16, 3, 42, 2, 42, -25, -47,
    8, -11, -36, -27, 16, -94, -50, -53,
    73, -67, 52, -73, -23, 7, 47, 11,
    44, 28, 57, 20, -57, -30, 42, 73,
    2, 50, 4, -29, -24, 11, 48, -27,
    -2, 3, 18, 10, 5, 58, 2, -22,
    49, 2, -6, 41, -9, 4, -22, -3,
    -47, 21, -50, -4, -24, -10, -41, 20,
    29, 1, -83, -3, -20, -61, -15, -38,
    9, -5, -54, -13, -44, -10, -17, -52,
    -8, 6, -4, 21, 43, 10, -7, 42,
    -49, -32, 46, 48, -42, -9, 45, -20,
    32, 21, 63, -19, 5, 12, -10, -45,
    0, -8, 49, -9, 11, 7, 5, -22,
    52, 19, 46, 62, -1, -20, 14, -49,
    68, -100, 4, 16, -1, 45, -11, 46,
    31, 25, -24, -62, -27, -17, 3, -6,
    -12, 8, -47, -82, -8, -26, 21, 19,
    -45, 28, 0, 8, -49, -52, 13, 23,
    31, -42, -11, 29, 13, -47, 41, 21,
    41, -24, 2, -11, 19, 16, -13, -16,
    -34, 33, 1, 3, -31, 21, 67, -16,
    63, 7, 57, -6, 24, -51, 1, 20,
    -62, 42, 15, -74, 3, -76, 63, -30,
    -29, 39, 37, 37, 41, -14, 35, 35,
    -14, 9, 8, 7, 6, 18, 72, 57,
    38, 4, -42, 47, -30, 35, 0, 14,
    -60, -8, -26, -35, 84, 4, -22, 42,
    9, -7, 7, -6, -44, -40, 42, -8,
    15, -2, -6, 13, -10, -40, -32, 105,
    -4, 16, 20, 45, 9, 29, 4, -22,
    -2, -103, -38, -50, -12, -11, -8, 2,
    11, -6, 39, 0, 44, -40, 73, -59,
    1, -34, 7, 11, 23, 51, -17, 0,
    1, -39, -47, -49, -3, -4, 7, 22,
    -2, 47, -80, -36, 10, 13, -31, 41,
    8, -56, 10, -11, 8, -3, 2, -3,
    -2, -3, 7, -18, 8, 46, 46, 6,
    -47, 74, -14, 43, 5, -20, -23, -2,
    -123, 6, -15, -20, 16, 4, -22, 44,
    13, 15, 37, -34, 23, 12, 2, 127,
    18, 4, 10, -25, 20, 25, 1, -43,
    2, -15, 68, 18, -8, 26, -46, -17,
    7, -68, 23, 4, 7, -43, 9, 17,
    -20, -20, 15, -2, -25, -17, 10, -16,
    -2, -6, 39, 1, 36, -8, -6, -11,
    -20, -45, -19, 6, 0, -15, 26, -15,
    -56, 46, -43, -9, 25, 25, -35, 19,
    60, 2, -34, -12, -16, 0, -25, -51,
    20, 1, -22, 3, 15, 21, 50, -9,
    68, -27, 19, 24, -73, -18, 34, 6,
    14, -61, -56, -12, 38, 27, 38, -14,
    -2, 12, -9, -7, 9, -47, 10, -59,
    -38, 0, 17, -53, 18, -12, -1, 3,
    15, 9, -11, 16, 10, 20, -65, -6,
    20, 4, 4, -35, -24, 16, -36, 34,
    16, -15, -5, 1, -3, -21, 15, 24,
    13, -40, -39, -24, 4, 4, -2, -1,
    -9, 3, -5, 32, -41, -8, -10, 4,
    17, 13, 42, -8, -12, 16, 17, -15,
    -21, 0, 2, 15, -22, 40, 14, -20,
    39, 0, -8, -13, 8, -13, 4, 15,
    -12, 31, -17, -1, -27, -34, -19, 69,
    -5, 40, 22, 15, -3, 20, 24, 2,
    -24, -12, 9, 5, 1, -5, -13, -8,
    2, -10, 16, -11, -4, -3, 11, -6,
    -42, -5, 20, 3, 56, -23, 9, 57,
    -5, 4, 35, 16, -16, -14, 7, 2,
    -12, -1, 2, -25, -29, -6, 8, -2,
    32, 16, -15, -40, -11, -8, -4, -21,
    1, 8, 4, -38, 16, -26, -12, 8,
    -11, 6, -22, 23, 12, -30, 4, 7,
    -4, 7, -19, 5, 42, -49, 75, -127,
    -7, 2, 24, -36, -11, 19, 3, 2,
    -23, 8, 48, 0, -28, -40, 12, 55,
    -27, 18, -1, 45, 27, -28, 4, 2,
    21, 16, -3, -19, -24, -3, -17, 1,
    -23, 3, 18, 44, 13, 21, 8, -6,
    -2, 2, -4, -20, 6, 25, -22, -2,
    -15, 9, 11, 0, -23, 30, -9, -42,
    17, -3, 9, -12, 10, 27, -15, 8,
    -16, 7, -17, -26, -2, 1, -2, 11,
    -5, -8, -16, 46, -11, -7, 43, 17,
    26, -12, -13, 18, 26, 4, -27, 45,
    19, -16, 51, -7, 15, 4, -4, 32,
    -1, -2, 21, -14, 14, -5, 6, -38,
    8, 3, -26, 2, 5, 32, 28, -15,
    0, 29, 12, -21, 23, 14, 44, -92,
    5, 12, 5, -3, -26, 36, -5, -7,
    -16, 4, -7, -17, -10, -12, -4, -1,
    2, 3, 29, 20, -7, 9, 6, 1,
    -10, -6, 2, 12, -13, 27, -40, -4,
    8, -40, -12, 16, -16, 14, -17, 16,
    -13, -6, 26, 8, -2, 7, 6, 2,
    1, 27, 20, -23, 47, -22, 5, 36,
    21, 12, -16, 17, 21, 18, -11, 8,
    -4, 17, 1, 7, 6, 45, -83, -9,
    -35, -38, 50, 52, -5, 12, 17, -11,
    -23, 7, -8, 23, 3, 3, 11, 17,
    -2, 23, 27, 21, -3, -37, 26, -15,
    -24, -10, -7, 26, -37, -2, 32, -2,
    9, -56, 21, 20, -5, 15, -3, 3,
    -26, 24, -9, 10, 53, 42, 23, -16,
    23, -24, 8, -5, -4, 19, 20, -18,
    -13, 32, -16, -15, 3, 53, 9, -12,
    -1, -21, -1, 4, -15, -10, -5, 5,
    31, 3, -30, -4, 2, 8, -30, 19,
    4, -20, -7, 11, -13, 4, 16, -12,
    0, -14, 13, 6, -3, 19, 10, 19,
    17, -11, 23, -13, -1, -4, 12, 4,
    0, 0, -34, -8, -1, 19, -43, -13,
    -29, 46, 14, 10, -4, 27, -5, 33,
    24, 13, 10, 21, -9, -27, 14, -39,
    27, 4, -3, 13, -2, -17, -5, 24,
    6, -17, 48, 24, 0, 22, 24, -28,
    -18, 6, -10, -12, 7, -19, -19, -11,
    16, 40, 13, 12, 21, -25, -16, -12,
    3, 16, -13, -40, 19, 3, 1, 13,
    -1, 15, -2, 5, -65, -10, 4, -30,
    8, 11, 6, 9, -11, -10, -40, -8,
    -12, -14, -33, -5, -11, 3, -13, -15,
    -13, 4, 15, 22, 7, 10, 2, -19,
    5, -26, -16, 4, -7, 0, 11, 2,
    3, -4, -18, -1, 31, -17, 15, -12,
    49, -7, -6, 0, -1, -27, 36, -1,
    41, 43, -4, -15, 15, 22, 10, 13,
    -6, -15, 14, 10, -5, -63, 6, 17,
    -9, -23, -4, 3, 9, -42, -62, -13,
    -35, 11, -12, -29, -32, -16, -28, 9,
    44, -17, -19, 5, 1, 4, 6, -8,
    -26, 43, 28, -37, 67, 17, -6, -14,
    -9, -7, -11, -18, -1, 25, -26, 14,
    8, -12, 1, 29, -40, 6, -37, -4,
    18, 6, -62, -15, 5, 17, -6, 17,
    1, -2, -22, -8, -22, 27, 29, -3,
    0, -9, 4, -2, -12, -37, 14, 42,
    -10, 3, 44, 14, -15, -10, 14, -45,
    -12, 11, -27, -5, 7, -3, -2, -11,
    -27, 8, -46, 13, -1, 29, -7, 14,
    13, -17, -20, 16, -40, -47, 30, 9,
    -10, 5, -8, -16, 36, 37, -13, 41,
    15, -9, 7, -34, -7, -6, 1, -4,
    -41, -8, 8, -12, -3, 11, 3, 30,
    20, 6, 6, -7, 7, 45, -14, 16,
    -9, 13, 11, 9, -9, -7, 14, -3,
    -2, 17, 26, -4, -5, -1, 16, -1,
    -26, 0, 12, -10, 39, 18, -11, -14,
    12, 12, 22, -3, 40, 30, -67, 13,
    -34, 0, -2, -13, -15, -18, 8, 46,
    9, 38, 8, 37, -4, 5, 1, -6,
    -27, -19, -14, 24, 52, 48, 0, 18,
    24, 10, 20, 20, 10, -20, 33, -26,
    18, 13, 35, 6, -27, 14, 20, 6,
    -14, 24, 6, -21, 19, -3, 11, 2,
    -18, -28, 34, -14, -14, -34, 25, -21,
    18, -11, -8, 12, -26, 13, 9, 27,
    1, -6, -43, 8, 9, -35, 53, -57,
    -23, -46, -19, -10, 15, -8, 15, -10,
    16, -12, -4, 27, 3, -28, 5, -39,
    7, 7, 7, 11, -27, -11, -17, -4,
    8, 26, -3, -27, -10, 27, -16, -3,
    3, 9, -49, 12, -10, 10, -5, -10,
    -34, 31, -19, -10, -13, -4, 15, -32,
    -16, -2, 33, -14, 53, -22, 32, 40,
    7, -10, -10, -24, 18, 7, -6, 7,
    -16, 22, -10, 3, 4, -9, -29, 14,
    7, -8, 13, -18, -3, -30, -25, -35,
    -12, 19, 17, -4, -2, -9, 44, 45,
    4, 41, -18, -27, 7, -67, 13, 15,
    44, 7, -13, -10, -9, 8, 15, 4,
    -21, -11, 4, -9, 0, 5, 8, -9,
    7, 1, -23, -11, 7, 46, -11, -3,
    -16, 30, -3, 21, 9, 18, 29, -27,
    -57, -15, -57, 12, -3, 4, -8, 3,
    2, -23, 30, 19, 8, -8, -1, -5,
    24, -3, -23, 21, 7, 22, -66, 24,
    -24, -6, -7, 2, 12, -5, -30, -23,
    31, -31, 1, 11, -14, 4, -9, 31,
    -31, -12, 2, -11, -31, -12, -13, 39,
    -5, -15, -39, 11, -11, 8, -11, 16,
    -34, 1, -3, 16, 23, -15, -4, -18,
    24, -2, 15, -42, 12, 18, -1, 15,
    11, -3, -9, 26, -13, -30, -40, -10,
    28, -3, 16, -18, 2, -34, -8, -52,
    -7, -19, 20, 2, -4, 20, 8, -6,
    -40, -21, -2, 8, 5, 8, -3, 9,
    -6, -33, -13, 10, -16, -26, 9, 11,
    -14, 18, 34, -6, -29, -21, 0, 10,
    26, 3, 5, -16, 2, 0, -11, 4,
    8, 4, -31, -10, -21, -6, -4, -31,
    3, 10, -7, 27, -47, 2, 45, 5,
    -19, 31, 37, -15, -31, 2, 14, -29,
    10, -37, 1, 0, -25, 7, 17, -7,
    -16, 17, 12, -37, 6, -22, 10, 12,
    -34, 6, 1, 14, 32, -18, 23, 23,
    -1, 11, 45, 5, -4, -5, 43, 33,
    -22, -10, 10, 12, -5, 3, -30, -15,
    31, -13, 1, -25, 9, 3, -14, -15,
    -13, -29, -14, 8, -23, -68, -5, 16,
    7, 20, -7, 15, -19, 22, -36, 35,
    -7, 12, 1, 18, 15, 18, 85, -92,
    -13, 10, 63, -56, -23, 26, 10, 14,
    -16, -24, 1, 31, -3, -21, 3, 24,
    4, 34, 6, 14, 37, 25, -30, -1,
    10, -6, 4, 26, -10, 16, 8, -5,
    49, 7, 21, 11, 10, 0, 3, 13,
    -5, 4, -15, 13, 44, 40, -6, 6,
    6, -8, -2, -6, -24, 19, -12, -4,
    4, -19, -3, -4, 23, -12, -66, -48,
    -4, 30, -23, -18, -2, 18, -3, 10,
    -9, -22, 11, 4, -13, -7, 62, 11,
    28, 13, 8, 13, 4, 21, 59, 25,
    13, -19, 12, -3, -1, 15, 17, 8,
    -16, 15, 10, -2, 16, -9, 63, -34,
    11, 6, -20, -12, 8, 31, 31, -11,
    3, 18, 21, -34, 29, 3, 53, -97,
    -29, -35, -10, -3, -2, 109, 3, -15,
    -1, -37, -18, -10, -19, -2, 2, 8,
    20, -30, 17, 23, -26, 27, -1, -13,
    4, 6, -1, -1, -39, 7, 10, -30,
    1, 10, 4, 10, -23, 17, -10, 4,
    -33, -27, 18, 8, -14, 8, 9, 2,
    -18, 9, 12, -10, 9, -16, -1, 26,
    1, -6, 1, 28, 35, -14, -10, 4,
    -29, 25, 21, -22, 15, 12, -46, 31,
    -14, -1, 11, 51, -23, -4, 28, 0,
    -7, 15, 4, 23, 13, 5, -47, 7,
    3, 22, 7, 27, -52, 42, 30, 46,
    -7, -23, 2, 24, -32, 33, 6, -13,
    -42, -3, -10, 36, -19, 19, 2, -12,
    -18, 19, 11, 35, -6, 23, 31, 14,
    -2, -25, 22, -24, -16, 1, -18, -14,
    -34, 2, 15, -11, 30, 9, -20, 7,
    7, -1, -29, 25, 9, 0, 43, 3,
    -31, 19, 7, -15, -36, 4, -11, 19,
    -12, -21, 8, -4, 5, -20, 36, 37,
    7, -26, 2, 0, 10, -26, 11, 19,
    45, -8, 31, -15, 5, -6, 19, 8,
    -2, -24, -18, -17, -13, 19, -10, -14,
    -13, -4, 24, -8, 5, -50, -21, 10,
    -3, -12, 2, -12, -21, -3, 47, 10,
    26, -11, 45, 50, -29, 13, 16, 15,
    -20, 8, 21, 9, 22, 22, 33, -37,
    -5, -7, -13, -47, -17, -29, 12, -8,
    0, -4, -1, 11, 6, -8, 14, 26,
    13, -12, 64, -11, 19, -6, 3, 1,
    -12, -8, 22, 6, -33, -13, 19, -22,
    1, 12, -45, 11, 13, 45, 15, -14,
    8, 6, -9, 6, -9, 2, -16, -8,
    10, 35, 15, 30, -8, 17, 6, 9,
    -26, -11, 2, -33, -27, -5, -3, -21,
    11, -11, -13, 4, 9, -19, 71, -58,
    16, 1, -18, 7, -14, -27, 28, 9,
    -41, 3, -16, -21, 12, 16, -9, 1,
    -13, -13, -4, 32, -27, -14, 9, 11,
    -3, -17, 27, 6, -7, -27, -7, 47,
    22, -6, -4, 3, -59, -3, 7, -23,
    9, -40, -32, 21, -17, 2, -10, -12,
    -47, 68, -22, -36, 11, 10, 69, -50,
    -12, -3, -2, 11, -1, -11, -58, -39,
    -3, -16, -4, 5, 6, 7, 5, 52,
    14, 22, 7, -1, 6, -7, -3, 2,
    5, -3, -42, 5, -35, 15, -15, 14,
    -11, -3, -17, -8, -7, -55, -4, 54,
    13, 4, 28, 9, 15, 9, 9, 28,
    25, 0, 21, 58, 4, 12, 29, 10,
    -14, 13, 0, 5, 8, 13, -3, -38,
    -9, -6, 2, -1, 29, -47, -14, -17,
    -2, 4, -14, -24, 10, 21, -14, 16,
    13, -8, -17, 25, 3, -18, -23, 11,
    -29, 38, -14, 4, -14, 30, 10, -3,
    8, 16, 31, -18, 44, 20, -6, -35,
    -8, 13, 18, 20, -23, -6, -3, 10,
    -14, 18, 1, 17, -5, -8, 23, 49,
    3, -7, 0, -11, 40, 25, -22, -27,
    10, 24, 5, -18, -4, 8, -8, -52,
    -19, -11, -16, -1, 6, 26, -54, 16,
    -22, 7, -18, 7, 34, 20, -14, 7,
    -41, 8, -10, 9, 29, 19, -20, 26,
    -13, 13, -27, 23, -33, 32, 19, 3,
    -11, 16, 2, 2, 1, 8, 6, -48,
    10, 15, -38, -12, 21, 1, 11, 1,
    -36, -49, 22, -1, -35, -40, 22, 3,
    17, -16, -14, 4, 26, -13, 9, 18,
    7, -3, -6, 0, 2, 8, 15, 14,
    -13, 4, 0, -37, 24, 12, 45, -15,
    7, -27, -16, 35, 9, -19, -1, 16,
    6, -6, -1, 23, -28, 11, 5, 26,
    20, -6, -9, -14, -8, 14, 18, -37,
    2, -32, -23, -31, -7, 9, 11, 0,
    -34, 44, 20, 30, -19, -5, -1, -24,
    -22, 2, -8, -19, 57, -41, 21, 29,
    -2, 4, 2, 24, 11, 21, -19, -1,
    -14, 37, -48, -37, 6, -11, -5, 1,
    0, 46, 6, 6, 8, -9, 4, -14,
    -16, -7, 13, -5, -17, -25, 71, -13,
    -7, 17, -16, 13, -8, -16, -3, -2,
    -4, -8, 6, 20, 9, -4, -10, -16,
    -33, 8, -1, 2, -7, 3, -12, 3,
    44, 3, -19, 5, -35, 24, -5, -28,
    -9, -10, 2, 16, 0, 11, 43, -5,
    -35, -11, 3, -2, -9, -8, -10, 1,
    33, -8, 33, 14, 4, 9, -43, 12,
    13, 0, -7, 10, 18, -25, 28, 37,
    -10, -3, 3, -9, -16, -15, -30, -21,
    26, -19, 0, -24, -46, 10, 22, 29,
    3, -17, -4, -13, -30, -9, -32, 44,
    6, -17, -11, 10, 12, -9, -34, 15,
    -6, -1, -9, 41, 12, -61, -15, -35,
    14, -2, 13, -26, 10, 10, -1, 12,
    27, -41, -4, -12, -1, -19, -32, 15,
    65, -6, 7, -20, -6, 18, -58, 44,
    35, -7, -4, 12, 36, -7, 9, 25,
    11, 30, 58, 25, -1, 6, -4, 15,
    -16, -31, -11, 39, -29, -21, 9, -48,
    5, 31, 38, -43, -29, 0, 3, -6,
    30, -25, -21, -24, -15, -11, 39, 2,
    19, -33, 50, -22, -18, -32, 17, 16,
    45, 43, 112, -12, -65, -62, -75, 27,
    -4, 20, 42, -25, 22, 11, 27, 21,
    10, 5, 3, -2, -14, -40, -13, -14,
    -3, -27, -13, -37, -10, -7, 12, -8,
    -85, 11, -43, -5, 42, 5, 70, 46,
    18, 10, 70, 0, -36, 21, 1, 0,
    18, -21, 21, 9, -33, -6, 34, -3,
    -52, 36, 69, -5, 0, -15, -16, -7,
    -5, -83, 33, 33, 5, 6, -83, -43,
    44, 85, -29, 0, -5, -58, -15, 19,
    -39, -17, -30, 60, 37, 4, 88, -105,
    -45, 6, -11, -90, 1, 3, 19, -6,
    13, -6, 8, -28, 45, -43, -4, 49,
    -1, 31, -11, 16, -23, 14, -38, -10,
    6, -6, -14, 60, -8, 2, 48, -3,
    41, -35, -6, 45, -1, -11, 0, -34,
    -17, -27, -8, -4, 25, 55, -9, -11,
    83, -19, 3, -16, 70, 45, -19, 29,
    13, -5, 12, -7, -1, -24, -82, 16,
    -14, -6, -39, -2, -9, -16, -9, 0,
    -65, 41, -15, 7, 14, -4, 55, 27,
    39, 40, 16, 15, 49, -28, -55, 27,
    41, 4, -14, 14, -18, -8, 14, 13,
    -12, -2, -33, -10, 8, 6, 88, -37,
    -4, 6, -29, -12, -24, 27, 30, -8,
    11, 29, 29, -24, -2, 1, 59, -127,
    -6, -118, -32, 11, 4, 109, 20, -22,
    -8, -48, 11, -9, -27, -19, 17, 3,
    -6, -4, 61, 14, -11, 39, -36, -29,
    19, 17, -2, -16, -27, 7, -22, 39,
    6, 42, 6, 11, -12, 0, 20, 1,
    -29, 3, 73, 0, -29, 34, 10, -14,
    -28, -7, 16, 14, 7, -23, 0, 43,
    -22, -36, -2, 47, -24, -9, -3, -47,
    -4, 14, 12, -10, 67, 15, -40, 29,
    8, 32, 23, -30, -18, 22, -10, 7,
    -6, 13, 54, 2, -17, -45, -32, -23,
    36, 50, 42, 35, 42, -18, 12, -11,
    77, 45, 13, -5, 9, 6, 10, -5,
    10, -6, -7, -22, -36, 50, 0, -1,
    -36, 27, 15, 48, -51, 2, 28, -41,
    -17, -44, 39, -66, 9, -48, 15, -42,
    -65, -64, 27, 21, 23, 6, -32, -7,
    32, -3, 35, -73, 5, 40, 20, 13,
    -19, -30, 48, -21, 0, -20, 7, 2,
    4, -30, 71, -27, -29, -5, -28, 4,
    -11, 32, -7, 5, 13, 26, 13, 35,
    17, 14, -20, 34, 20, 6, 24, -7,
    19, -52, -16, 0, -47, 30, 14, -52,
    -13, 19, 14, -17, 32, -9, 28, 21,
    -18, -23, 3, 16, -11, 22, 57, -33,
    16, -17, 32, -43, 18, 5, 14, 20,
    -2, -1, 59, -59, 28, 46, -10, 16,
    1, 10, -2, -62, -53, -18, -2, 37,
    3, -72, -1, -24, 0, 4, 14, 46,
    -9, -34, 24, 3, 18, 26, 9, -37,
    -15, 18, 1, -36, -21, 1, -28, -54,
    3, 29, -62, -13, 5, 11, -27, 29,
    20, 19, 56, 6, -21, -43, -38, 0,
    20, -6, 70, 59, -3, 9, 7, 34,
    -30, -10, -10, -7, 6, 7, 33, 31,
    4, 9, 1, 53, -22, -13, -7, -28,
    17, -60, -23, 7, -21, 18, -2, 9,
    6, 6, 40, -3, 27, -1, -14, 21,
    -36, 28, 5, 65, -20, -39, 43, -25,
    0, -40, 57, 21, 12, 5, -6, 30,
    74, 17, 24, 88, -17, -45, -8, 5,
    37, -13, -28, 55, -1, -13, -29, 21,
    -120, -4, 9, -47, 65, 64, -2, -14,
    23, 4, 31, 40, -1, -11, 59, -1,
    -18, 18, 16, -45, 17, -3, 5, 77,
    15, 46, -16, 31, 5, -33, -9, 14,
    -3, -7, -57, 28, -45, 2, 31, -14,
    -42, -12, 33, -14, 10, -53, -6, 59,
    -32, 13, -47, 23, 14, 11, 24, 36,
    69, 3, -13, 16, 9, 36, 94, 35,
    -34, 13, -6, -34, 17, 4, -5, 14,
    22, -16, 21, 19, -29, -65, 1, 9,
    16, -40, 23, 56, 8, 24, -15, -35,
    29, -37, 11, 44, 8, -18, -44, 19,
    -47, 29, 41, -35, 8, 37, -43, 24,
    -1, 33, 34, 2, -30, -26, 14, -37,
    -2, 9, 2, 22, -29, -5, -6, -42,
    -12, -8, -23, -42, 2, -7, 10, 96,
    127, -4, 4, 1, -36, 3, -36, 6,
    9, 58, 9, -18, 23, -19, 23, 20,
    38, 3, -14, -1, -7, -9, -18, -39,
    -33, -25, -2, -74, 31, -9, -29, 0,
    -23, 7, -32, -3, -12, 42, 17, 24,
    7, 5, -94, 17, -38, -33, -5, -51,
    -33, 25, -15, -30, 16, 15, -44, 36,
    15, 59, 9, 25, 3, 11, -8, -26,
    -31, -61, -14, -43, 6, -57, 74, 14,
    -18, -18, -27, -5, -30, -15, -52, -27,
    21, 4, 42, -45, 0, 13, 10, 19,
    -19, 46, 20, -60, 15, 8, 7, -30,
    -15, -19, -31, 36, 13, -16, 20, -10,
    -10, 17, -12, -47, -14, 46, 17, 19,
    14, -30, 3, 44, 32, 12, -31, -26,
    13, -25, -40, 47, -21, 15, -5, -1,
    -29, 22, 37, -18, -27, 14, 4, 30,
    -11, -19, -20, -39, 51, -39, 17, -2,
    -5, -30, 8, 2, 7, 6, -30, 24,
    -66, -22, -35, -54, 6, -8, 16, 13,
    -39, 32, 8, -17, 13, -40, 52, -7,
    -34, -32, -4, -14, 2, 46, 82, -21,
    -13, -26, 19, 65, 11, 28, 24, -26,
    -42, -4, 58, -7, -3, -26, -13, -14,
    -27, 14, -9, -6, 12, 3, -21, 21,
    51, -9, -18, 0, -41, 34, -1, -75,
    -15, -23, -6, -13, 22, 15, 30, 25,
    -3, -20, 31, -24, -12, 50, -16, 15,
    -2, -13, -6, 14, 7, 9, 22, -2,
    -2, 25, -50, -12, 29, -25, -13, 84,
    21, 1, 13, 14, 26, 13, -11, -34,
    47, 19, -19, -18, 0, 17, 19, 34,
    -31, 5, -28, -2, -41, -42, -23, 20,
    -3, -14, -46, 14, 12, -12, -42, 70,
    9, -32, 0, 18, -16, -4, 20, 7,
    -52, -1, -9, 11, -9, 36, 15, 22,
    -6, -4, -5, -11, 45, -15, -10, 30,
    -4, -68, 0, 0, -16, -13, -32, -20,
    5, -10, 6, -12, 12, -15, -19, -18,
    1, -23, -13, 34, -33, 2, 8, 2,
    3, 44, -14, 3, -7, -5, -26, -32,
    -13, -12, 30, 9, -10, -16, -35, -13,
    19, -16, -13, -10, 13, 10, -17, 46,
    15, 16, 1, -9, 26, -2, -8, 9,
    16, 2, -23, -33, 0, -5, -25, 3,
    -32, 29, -25, 15, -14, -8, -45, 15,
    6, -3, -6, 11, -8, -21, -14, 12,
    15, -20, -29, 2, -17, 37, 15, 4,
    -11, 12, 15, 11, 18, 27, -17, -12,
    -24, -17, -2, 9, 20, -26, -14, -5,
    13, 0, -12, -6, -18, -38, 6, 13,
    9, 2, 10, 17, 26, 34, 4, 5,
    -32, 11, -11, -19, 29, 37, -10, -21,
    -55, 51, -7, 12, 31, 48, -6, -14,
    -6, 5, 21, 3, 2, 24, 9, -46,
    17, 14, 24, -28, 27, 23, -20, -29,
    -13, -16, 19, -12, -8, -15, -12, -69,
    9, -22, -20, -9, 21, 6, -7, -33,
    -7, -17, 20, 7, -19, -4, 10, -28,
    -15, 1, -17, -3, -39, 10, 8, 39,
    7, 5, 4, -3, 40, -41, 14, -11,
    -14, -3, -18, 20, 3, -19, 37, -15,
    16, 13, -12, -4, -21, 15, -24, 18,
    -47, 4, -8, -37, 3, -9, -15, 19,
    29, -12, 34, 15, 3, -19, -4, -6,
    -2, 10, 20, -1, -8, -19, 19, -6,
    -5, 9, 19, 7, 4, 15, 13, -12,
    -21, -4, -25, 3, 31, 15, 7, 14,
    -1, -1, -17, 5, -17, -15, -43, -14,
    -3, -19, 20, -1, -32, -17, -14, -3,
    -5, -15, -6, 5, -9, -36, 6, -36,
    -39, -9, -12, -15, 8, 7, -6, 28,
    29, 13, 18, 9, 10, 13, -40, 35,
    6, 1, -7, -3, -41, -26, 27, -11,
    -43, -11, 7, 6, 24, -38, -5, -27,
    32, -8, -2, 20, 45, -38, 34, -10,
    -6, -19, -4, -9, 0, -34, -11, 36,
    -37, 0, 11, -15, -5, 0, -18, 17,
    0, -4, -23, 4, 2, -26, 33, 7,
    -18, 15, 0, -22, -31, -15, -33, 14,
    2, 10, 15, -23, -30, 17, 7, 10,
    9, 17, -26, -3, 21, -15, 18, 19,
    -40, 1, -19, 11, 0, -22, 0, 16,
    -9, 14, 14, -3, 14, 9, -34, 19,
    -30, 8, -22, 13, -34, 4, -30, -10,
    -33, -9, 4, -14, -15, 4, -7, -10,
    35, 8, -9, 18, -6, -37, -1, 18,
    35, -8, -18, 26, -11, -23, -8, -25,
    1, 7, -1, 2, 61, -14, -16, -39,
    0, -15, -24, -7, -34, -10, 6, 11,
    5, -31, -8, 10, 3, 4, 3, -19,
    21, 32, -36, 14, 19, -28, 6, -35,
    -15, -11, 10, 9, -5, -29, -64, 10,
    5, -42, 21, 23, 14, -18, 9, -5,
    13, -8, 31, 38, 31, -15, 3, 17,
    -6, -9, -3, 42, -21, -19, 26, 7,
    -12, -10, 20, 5, -21, -50, -52, 13,
    -8, -3, 0, -44, 16, 32, 18, 20,
    -7, -6, -27, -10, 0, 50, -24, 2,
    -33, 2, 30, -21, -10, -44, -20, 16,
    10, -15, 9, 35, -9, -30, -25, -31,
    12, -1, 36, 14, -7, 31, -5, -17,
    -6, -13, 16, -24, -13, 8, 4, 19,
    -80, 11, -4, -31, 23, 7, 17, -40,
    3, -6, -1, 5, -14, 10, -45, -37,
    5, 11, 40, 9, -5, 1, 2, -12,
    -9, 2, -3, 6, -1, 62, 19, -11,
    3, 11, -41, -1, -16, 9, -21, -6,
    -25, 5, -15, 24, 16, -5, 9, -35,
    -9, -54, 14, 20, -20, 7, 6, -21,
    18, 16, -18, -2, 9, 2, -27, -8,
    7, -21, -8, 14, -43, -30, -26, 1,
    18, 45, 29, -30, -5, -2, -11, -1,
    6, 3, -24, 0, -4, 11, 9, 14,
    5, -12, 7, 4, 2, -39, -1, -8,
    22, 28, 14, 14, -18, 19, -3, -4,
    -28, 4, -5, 1, -19, 35, -8, -9,
    5, -32, 40, 10, 16, 6, -29, 2,
    -17, 21, 5, 31, -5, -11, 4, -1,
    12, -16, 8, -3, -17, -13, 3, 16,
    25, 16, -16, 12, -20, 16, -24, 3,
    -26, 15, -40, 5, -17, -25, 2, -32,
    1, -2, 24, -3, -41, 5, -9, -27,
    1, 4, -16, 13, -27, 18, -64, -5,
    17, 23, 5, 6, -4, 8, -54, 33,
    53, 27, -7, 8, 1, 7, -18, -2,
    10, -2, -9, -12, 11, -15, -28, 5,
    -6, 1, 57, 18, -13, -27, 4, -3,
    -34, -11, 16, -6, 26, -7, -30, -51,
    9, -22, 8, 18, 16, -17, -8, -8,
    -25, 30, 3, 26, 25, -14, -16, 20,
    50, -34, -12, -3, -19, -29, -35, -35,
    33, -28, 1, -63, 1, -29, 29, 14,
    -5, 16, 16, -4, 23, 12, 4, -7,
    -13, 3, 56, -3, -12, -27, 41, -1,
    -12, 16, 17, 5, -34, 8, -21, -21,
    -17, 0, -38, -25, -29, 16, 25, -10,
    7, 11, 30, 33, 18, -26, -39, 3,
    -29, 11, 11, -5, 14, -30, -6, 20,
    -1, 12, 19, -9, -18, -22, 2, 18,
    6, -11, -3, 15, 3, -2, 2, -37,
    4, 15, 11, 13, -31, 3, -7, 26,
    -5, 10, -10, 25, 30, 1, 24, -21,
    1, 5, 61, -4, 5, -20, -31, 41,
    18, 1, -36, 37, 3, -9, -30, 38,
    -19, -22, 13, -25, 3, 20, 60, -15,
    -6, 20, 8, -23, -4, -7, -14, -17,
    -9, 56, 15, 34, 1, 4, -15, -14,
    53, -16, -7, 7, -28, 38, -45, -56,
    -7, 7, -24, 0, 13, -19, 5, -77,
    -17, 12, -40, 10, -8, 1, 11, 40,
    13, 3, -16, 5, 15, -17, -19, 21,
    0, -5, 39, 16, 7, -10, -19, 17,
    -27, -17, 9, 3, 14, -36, 24, 1,
    -3, -7, 5, 28, -5, 30, -2, 20,
    1, -20, -3, -9, 2, -13, -21, -22,
    44, -23, -11, -19, -26, -26, 26, -15,
    -1, -16, 22, -34, 18, -51, -4, 15,
    12, -11, 4, -6, 14, 10, 18, 4,
    25, 1, 3, 30, 6, 9, -40, -2,
    30, -5, 11, -8, 24, 11, -9, 8,
    17, 23, 19, 0, 37, 18, 1, 0,
    -15, 23, 19, -2, 1, -52, 32, 13,
    0, 11, 0, -25, -48, 43, -7, -9,
    -14, 20, 5, -9, -24, -36, 18, -1,
    27, -1, 0, -15, 28, 13, -27, -4,
    25, -19, 31, -9, 13, 19, -16, 30,
    42, 20, 6, 5, 18, 65, 14, -5,
    11, 21, -2, -14, 20, -2, 20, -26,
    -1, 21, 17, -17, -16, -46, 10, -10,
    12, 15, 13, -12, -10, -10, 72, -66,
    -90, -39, -22, 20, -43, -7, 0, 84,
    -13, 12, -13, -39, -3, -1, 86, 8,
    -39, 3, -7, 39, -11, -4, -59, -22,
    -10, 16, -12, 32, 16, 31, 6, 2,
    18, -1, -14, 27, 9, -22, -4, 19,
    22, -1, 13, 12, -18, -13, -46, -11,
    3, -29, 32, 30, -32, 26, 8, 2,
    14, 14, 37, 27, 19, -3, 12, -38,
    -12, -7, -4, 18, -31, 12, -1, -48,
    -10, -2, 22, -25, 15, 11, 41, -37,
    8, 1, -11, -12, -10, -27, -38, 54,
    44, 83, -28, 37, 5, 55, 13, -7,
    -64, -13, 8, -12, -33, -9, -28, -10,
    19, 17, -9, -34, -81, -33, -8, -12,
    -29, -14, 3, -9, 40, 5, 21, -35,
    -16, 2, 9, -5, -4, -33, -25, -5,
    -6, 16, 36, 54, -23, 8, 31, 24,
    -22, 18, 8, -4, 23, -16, -31, -45,
    -47, 5, -29, -1, -36, -4, 61, 38,
    -11, -20, -66, -10, -26, -19, -14, -7,
    39, -32, -16, 5, 60, -14, -8, 11,
    94, -7, 18, 1, -46, 3, 43, -30,
    0, -25, 10, 0, 49, 17, 33, 76,
    -28, -4, -26, 20, 15, -32, 22, -26,
    19, 5, -13, -12, 21, 10, 18, 22,
    -11, 29, -4, -6, -42, -20, 22, 1,
    12, 1, 45, 14, 9, -2, 25, 18,
    1, -21, 16, -24, 13, -34, -26, 1,
    3, 36, 39, 12, 0, 30, 34, 13,
    41, 26, 18, -3, 17, -56, -32, 13,
    -1, 29, -3, -1, -51, 5, 47, 18,
    64, 65, -3, 10, 54, -2, -13, -36,
    52, 14, -17, 13, 28, -45, 27, -12,
    -18, -17, -8, -24, 68, -78, 30, 7,
    8, -2, 54, -31, -18, 11, 11, -13,
    9, -46, -32, 20, 31, 19, 28, -13,
    -38, 33, 8, -12, -44, -54, -28, 14,
    25, -11, -21, 11, 20, -10, 41, 55,
    -41, 28, -39, -28, -18, 9, -29, -20,
    28, 3, -20, -12, -29, -21, 11, 36,
    66, -7, -3, -37, -12, -26, -1, -17,
    -2, -10, -26, -26, -1, 21, 12, -10,
    -17, -4, -11, 9, 0, -40, 16, 22,
    -17, 20, 38, 3, -8, -29, -33, -13,
    20, -18, -1, -23, 8, -35, 26, -45,
    9, -3, 9, -25, 16, -7, -62, -60,
    3, 0, 11, -20, -47, -15, 34, -11,
    15, -117, -33, 1, -18, -28, 24, 5,
    -11, 50, 22, 79, -28, -54, -4, 10,
    -32, 25, 1, -4, 19, -1, -48, 39,
    0, -51, 43, 1, -27, -10, 37, -15,
    -12, -25, 1, 24, 11, 14, -35, -9,
    -21, 29, 25, 50, 19, -35, 4, 23,
    0, 7, -17, -32, -27, -41, -58, 30,
    -30, -7, -19, -35, -17, 82, 12, 54,
    -16, -10, -63, 24, -6, 39, 37, 23,
    -12, -21, -6, -4, 0, 42, 51, -10,
    5, -10, -12, -11, 9, 14, 16, 24,
    6, -40, 15, 3, -18, 4, 9, 9,
    -20, 43, -22, 24, 29, -29, -48, -4,
    -16, -25, -64, 33, 27, -9, 9, 32,
    38, 15, 13, 7, -36, 4, -23, -6,
    18, 17, 4, -58, -32, -11, 17, 14,
    -30, -45, 41, 4, -6, 40, 21, -15,
    33, -25, -3, 5, -7, 4, 21, 23,
    18, -15, 16, 6, -12, 31, -7, -1,
    9, -18, -18, 19, -10, 12, 3, -4,
    9, -40, 64, 3, -3, -7, 32, 11,
    -26, -17, 33, -12, -18, -19, -25, -14,
    26, 42, 18, 2, -22, 35, -25, 8,
    -55, 10, -24, 7, -4, -15, 23, 15,
    -20, 20, -17, 0, 2, 2, 4, 12,
    49, -11, -39, 1, 8, -37, -56, -15,
    -14, -3, -10, 0, -27, -3, -27, -20,
    4, -39, -20, -14, -27, 14, 34, -6,
    10, 28, 9, -29, -9, 4, -5, -5,
    -41, 12, 89, -18, 20, -4, -11, 27,
    17, 0, 3, 18, -44, 22, 19, -2,
    -2, 15, -35, 39, 6, -30, 6, -14,
    -8, 2, -41, -29, -11, 6, 58, -13,
    64, -69, 56, -20, 44, 8, -51, -14,
    18, 1, 5, -1, 19, -7, -106, -12,
    32, -56, 10, -26, -32, 44, 51, -6,
    -24, -22, -6, -11, 0, -16, 23, 2,
    -61, 32, 15, 14, -27, -8, -6, -7,
    -74, 2, -10, 11, 31, -4, 5, -35,
    9, -19, 11, 24, -3, -23, 18, -36,
    47, 6, 28, 22, 36, 22, 57, 36,
    13, 17, -2, -12, -27, 14, 23, -34,
    -8, -10, 10, -50, -83, 9, -6, -5,
    23, 33, -1, 5, 83, -45, 5, -21,
    -31, 16, -38, 37, 39, -20, -28, 26,
    10, 32, -51, 22, -44, 0, 30, -39,
    -18, 5, -33, -14, -7, 10, 13, -39,
    -14, -7, -11, -33, -18, -9, 42, 21,
    -25, 32, -11, 72, 15, -28, 27, 24,
    1, 14, 22, -14, 15, -16, -3, -39,
    -8, -33, -6, -24, -11, -8, 20, 44,
    23, -25, 19, 17, 5, 19, 13, -68,
    -7, 18, 11, -44, 19, 2, -2, -38,
    8, -8, 3, 18, 2, -21, -47, 16,
    19, -2, -31, 41, 21, -8, 1, 2,
    -16, -6, 2, -11, 10, -20, 13, -28,
    -19, 14, -19, -30, -16, -24, -16, -29,
    -6, 12, 5, 13, -10, -5, 1, -16,
    54, -41, -17, 0, 10, 87, -29, -3,
    30, -66, 28, 15, 14, -43, 14, 19,
    3, 12, 1, 4, 12, 2, -13, 1,
    -15, 4, 18, 21, -24, -22, 59, 18,
    27, -10, 42, 3, 8, 37, -44, -78,
    -15, -15, -23, 37, -18, -50, -13, -19,
    -19, -40, -45, 26, 6, 8, -13, 25,
    3, -31, 26, 12, -5, -15, 56, 14,
    70, 17, -22, -32, 4, -2, 25, -20,
    16, 0, -6, -15, 36, -34, 31, 48,
    65, -8, 0, -26, -20, 27, 47, -8,
    15, -19, 88, 35, 43, -26, 49, 7,
    19, -12, -12, -5, -16, 13, 1, -15,
    -58, 20, -16, 9, 76, -12, 11, -3,
    81, 48, -17, -12, 7, 60, -13, 41,
    25, 67, 2, -40, 14, -15, 1, -57,
    -26, 35, 5, -27, -2, 34, -16, 7,
    28, -40, -28, -41, 6, -28, 32, 13,
    -1, -6, 0, 5, 15, 58, -17, 30,
    -29, -91, -16, -24, -29, -12, 15, 19,
    16, 43, 10, -54, -79, 4, 127, -68,
    16, -20, 9, -38, 60, -45, 25, -1,
    32, -13, -33, -18, 14, -20, -21, 27,
    -21, 18, -29, -53, -29, 42, 28, 35,
    -36, -20, -24, -49, -49, -17, 9, 35,
    -37, 0, -6, 26, 5, 26, 26, -27,
    -23, 33, 21, -14, 37, 53, 34, 2,
    4, -65, 15, 45, 58, -59, 26, 36,
    37, -36, 44, 27, -31, -77, 23, -24,
    28, -25, 24, 7, 14, -5, 1, -16,
    -10, -8, 8, -44, -22, 4, -39, 23,
    4, 25, -18, -21, -14, -3, -12, 15,
    -19, -5, 8, -3, -89, -11, -9, 9,
    21, 34, 15, 48, -28, 2, -28, -82,
    33, -48, 8, 0, 0, -29, 12, 39,
    61, 51, -18, 38, 7, -5, 15, 9,
    0, 42, -3, -5, 31, 14, 8, 48,
    -13, 12, 10, -63, 45, -37, -29, 17,
    -35, -4, 3, -5, 30, -36, -33, 11,
    70, 12, -54, 43, 39, -4, -36, 34,
    -22, 43, 20, -4, 56, 3, 27, 31,
    -7, -10, 28, 39, -5, -10, -85, -23,
    -7, 61, 3, -41, 27, -41, 35, -25,
    46, -21, 42, 16, 9, 1, 1, 75,
    127, -35, 3, -22, 101, -20, -3, 44,
    -36, -89, 21, 36, -22, 12, 23, 28,
    -33, -26, -29, 21, 16, -18, -59, -2,
    34, 7, -36, -2, 16, 18, 0, -25,
    -4, 67, -3, 0, -29, -5, 8, -4,
    44, -1, 30, 28, 2, -16, -23, -16,
    17, 21, -2, 3, -25, 10, -35, 79,
    68, -2, 6, 1, -10, -28, 31, -21,
    48, 38, -7, 7, 74, -46, -82, -17,
    -35, -11, 9, -37, -1, -5, 60, -31,
    -2, -13, 6, 15, 9, 39, 5, -21,
    36, -9, -20, 20, 42, 1, 10, 4,
    -44, -13, -2, -20, 50, -107, 74, -50,
    68, 14, -44, -15, 55, -32, 3, 2,
    39, 2, 23, 8, -42, 50, -47, -82,
    7, -26, -56, 21, 30, 49, 12, -8,
    -10, -21, -88, -12, 10, 57, 31, -43,
    18, 67, 12, 16, -35, -16, 25, 9,
    -53, 33, -20, 16, -32, -58, 95, -26,
    -54, -31, 10, 1, -30, -50, 24, -7,
    12, -20, -11, -37, 27, -5, 11, -42,
    -26, -26, 32, -24, 21, 49, 38, -5,
    26, 36, 54, 11, 75, -34, -25, 36,
    -1, 4, -6, 16, 7, -55, 4, 8,
    3, 20, -15, -9, -11, 27, -12, -78,
    -39, -20, -23, 7, 29, 33, -75, -27,
    -39, 26, 5, 11, -61, 70, -58, -1,
    -1, 62, 42, -59, -42, 19, -2, -12,
    -37, 3, 29, 16, -7, -5, 26, 1,
    -15, 40, -36, 18, -29, 80, -38, -10,
    -30, -23, 38, 12, -13, -22, -42, 23,
    -24, 35, 37, -16, 33, 39, -22, 4,
    18, 0, -23, -60, -38, 6, 34, -10,
    -13, -4, 8, 85, 28, -12, -39, -8,
    18, -24, 5, 10, 7, -32, -14, 2,
    5, 45, 22, 46, 22, 107, 41, 29,
    -7, 4, 5, -31, -19, 4, -35, 24,
    8, -39, -21, -34, 14, 20, -17, -36,
    6, -16, 33, -68, -19, -10, -6, -51,
    15, -15, 41, -62, -12, -27, -40, -53,
    29, 5, -11, 22, 20, -6, -3, -21,
    -56, -4, 1, 20, 14, 54, -39, 36,
    23, 35, -21, -10, 101, 15, 57, -24,
    -38, -51, 1, 23, -45, 4, 71, 25,
    17, -4, 15, 1, -51, 4, -44, 33,
    21, -48, -7, 33, -37, -6, 56, -4,
    5, 6, -18, -10, 40, 14, 49, 9,
    5, 19, 56, 41, 5, 9, 67, -21,
    46, 42, 28, 1, -23, -4, 8, -9,
    19, 25, 12, 50, 28, -2, 14, -47,
    19, 74, -22, -22, -7, 81, 2, -21,
    -19, -53, -14, 20, -35, -90, -5, 15,
    8, -4, 41, 6, 19, -44, -9, 17,
    -16, -15, 43, 2, -40, -51, 18, -22,
    -35, 40, -9, 36, -5, 21, -56, 27,
    60, 10, 79, 49, -17, -11, 58, -46,
    6, 4, -4, 51, -41, 36, 13, 69,
    0, -5, 17, -41, 17, -46, 54, 75,
    13, -4, 15, -26, 32, -23, 14, 59,
    -36, 82, -4, 32, -52, 32, 35, -16,
    22, -18, 19, 34, -24, 28, -15, 33,
    10, -34, -2, -21, 27, -111, -33, -34,
    12, 3, 28, -9, -4, -37, 46, 21,
    -41, 18, -18, -28, -12, 19, -69, -21,
    -105, -19, 4, 12, 39, -41, 51, -1,
    22, -9, 28, 21, -61, -19, -83, 3,
    37, 28, -10, -15, -52, -18, 8, 7,
    -82, -25, -48, 42, -34, 39, 46, 35,
    16, -33, -11, -43, -78, -27, 22, -13,
    25, -71, -80, 9, -81, 30, 4, 1,
    -20, -2, 9, 10, -1, -1, -34, -41,
    41, 60, -89, 37, 64, 42, 14, 48,
    1, 27, -25, -26, -10, -7, 14, -11,
    32, -23, 18, -24, 41, 52, -27, 29,
    -17, 73, 1, -37, -2, 45, 27, -59,
    11, -7, -9, -28, 12, 19, 0, -2,
    -9, -40, -8, -26, -14, -34, 36, 52,
    31, -32, -34, 7, 5, -4, -45, 28,
    -2, 27, -24, 68, 10, 9, 5, -12,
    -1, -27, 20, -5, -3, 0, 8, -76,
    2, 4, -64, 10, -5, -22, -34, -13,
    7, 12, -5, -8, 5, -17, -42, -43,
    -17, 10, -66, 22, -28, -13, -13, 14,
    44, -78, -10, 23, 3, 28, 12, 0,
    14, -49, -17, 8, 8, 101, -25, 25,
    24, -58, 62, 67, 13, -18, 19, -4,
    32, 44, -28, -20, -27, -22, -14, -17,
    8, -26, 34, 40, -23, 2, 42, -16,
    55, -17, 39, -15, 28, 4, 6, -63,
    -18, -37, -25, 67, 8, -24, -67, -5,
    -25, -1, 4, 9, 69, -52, -7, 10,
    -42, 1, 0, -45, -42, 3, -43, -16,
    91, 2, 2, -16, 23, -37, 10, 41,
    25, 35, -17, -51, -11, 37, -8, -7,
    26, 14, -24, -19, -29, 17, 13, 0,
    -46, 16, -116, 8, 2, -18, -17, 2,
    18, -5, -19, -12, -21, -15, 2, 10,
    38, 11, 78, -44, -58, -20, -13, -5,
    1, 1, 2, 6, 7, 2, 9, 30,
    21, 33, -10, 7, 42, -13, 21, -39,
    0, -1, 7, 22, -2, 12, 8, 5,
    19, 13, 39, -24, -25, 20, -26, 41,
    -6, -5, 16, 26, 8, 12, 5, 16,
    -30, -6, 31, -1, 26, 19, -16, 25,
    -9, -23, -2, 3, 2, 6, 2, 4,
    -12, 14, -32, 13, -1, -21, 8, 12,
    10, -31, -5, -16, -7, 12, -1, -21,
    -31, 18, -29, 4, 41, 39, -6, -52,
    11, -44, -3, 26, 14, 11, 15, -22,
    -4, 15, -37, 11, -26, -20, 29, 11,
    -3, 24, -26, -9, -15, 24, -11, -20,
    6, -15, 15, 15, 30, 23, -11, -1,
    -4, 27, 0, -21, 9, 7, -3, -8,
    -28, 34, 8, 13, 19, -16, -4, -3,
    -2, -23, -22, -6, -16, -17, 38, 6,
    11, -11, -18, 25, 38, 30, -19, -32,
    6, -8, -1, -7, -6, 4, 1, -11,
    7, 32, -10, 13, -36, -14, -3, 33,
    -10, -8, 8, 23, -10, -35, -11, 16,
    28, -37, 16, 20, -44, 10, -4, 8,
    -2, 27, 7, 8, 8, -4, -10, -1,
    -25, -13, 6, -3, -15, -12, 15, 3,
    -16, -9, 4, -8, -13, -24, -48, 9,
    -3, 34, -6, 44, 28, -2, 64, 25,
    -31, -12, -17, -1, -1, -12, -4, -1,
    14, -8, 25, 18, 13, 3, 5, -28,
    -22, 1, 5, -8, -9, 10, -7, -22,
    78, 10, -17, 27, -7, 75, -5, 0,
    -13, -8, -30, -5, -4, -1, -17, 2,
    18, 7, 9, -5, -9, -38, -1, 18,
    -21, 5, 30, -7, -3, 2, 19, -17,
    9, 8, -14, 15, -21, -3, 78, -12,
    1, 2, -5, -4, -7, 0, -2, 6,
    21, 17, -3, -8, 5, -13, 5, 29,
    38, -2, 9, 13, 11, -3, 20, -6,
    10, 1, -12, -32, 27, 17, 9, 4,
    20, 30, -1, -13, 10, 0, 7, 0,
    -3, 28, 12, 22, -16, -10, -26, 17,
    -9, 17, 4, 9, -48, -30, -2, 4,
    -1, 28, 2, -31, -22, -18, -1, 6,
    9, 11, -20, 5, -6, 5, 6, -6,
    35, -2, -8, 11, -23, 22, 6, 2,
    35, 36, 1, 5, 1, 31, -28, -12,
    -18, -13, 17, -13, 8, -15, 7, -18,
    -22, 19, -33, -10, 16, 21, -16, 1,
    -1, -22, 26, 12, 10, 1, -47, -2,
    1, -19, -14, -16, -15, 7, 9, -23,
    62, 10, 10, -8, -3, -47, -2, -23,
    17, -5, 22, 53, 5, 2, 12, -2,
    -19, -6, -19, 9, 21, -4, 10, -10,
    -4, -2, 6, -17, -8, 23, 3, 19,
    9, -22, 29, 16, 64, -11, 34, -3,
    20, 0, 3, -31, -9, 1, -6, 4,
    -2, -11, 24, 7, -23, 27, -21, 1,
    7, 17, 35, -9, 15, 15, -16, 47,
    -42, 12, 24, -29, 13, 47, 25, 24,
    -2, -14, -1, -24, -3, 14, -4, 10,
    54, 0, 31, 2, -11, -16, 13, -52,
    11, -6, 1, -4, 1, -8, 18, -37,
    -3, 23, -28, 1, 26, -7, -1, -13,
    -11, 6, -16, 1, -6, 4, 10, -16,
    -11, -27, -12, 7, 38, 21, 8, 19,
    8, 23, 3, 11, -1, -6, 12, -1,
    6, -14, 21, -11, -21, -13, -20, 5,
    0, -7, -17, 19, 3, 2, -6, -2,
    -2, -16, -12, 6, 9, -15, 46, -2,
    -4, -16, 3, 18, 36, -10, 56, 20,
    -8, 20, 33, -9, -26, -8, -14, -19,
    1, 2, -29, -8, 0, 10, -12, -6,
    -1, -13, -12, -33, 3, -21, 45, 3,
    0, 26, -3, -24, 25, 0, 30, 11,
    31, -30, -29, -3, -13, -1, -19, 12,
    -1, 11, -18, -26, 7, -16, 12, 3,
    23, 14, 20, -13, -5, 8, 39, -4,
    -15, -4, -17, -7, 7, 6, -19, 32,
    -11, 28, -13, 48, -6, -18, 14, 17,
    5, -1, 24, 19, 0, 5, 3, 7,
    9, -22, 18, 40, 31, 0, 44, -29,
    -1, 8, -6, 14, 37, -2, -15, -7,
    -10, 27, -84, -25, -6, -19, 51, 13,
    25, 8, 30, 26, -3, -1, -4, -10,
    -23, 11, -15, 21, -7, 24, 1, -4,
    24, 0, 15, 3, 2, 5, 8, 2,
    -9, 22, -12, 24, 31, -8, 16, 45,
    4, 0, -5, 12, -3, 2, 1, 4,
    24, 15, 5, -15, 8, -7, -12, -12,
    -8, 7, 8, -23, -1, -26, -2, -19,
    53, -10, 38, -1, 45, -35, 16, 49,
    27, -18, -2, 37, 3, -6, -4, 5,
    6, -2, -39, 13, -26, -35, 9, -3,
    9, 4, -5, -5, -15, 7, -1, -3,
    -36, -42, 18, -21, 5, 9, 21, 3,
    3, 15, -13, -26, 16, -10, 6, 2,
    5, -9, -1, 13, -29, 6, 33, -2,
    -14, 19, -35, 4, -24, -19, -9, -30,
    16, 21, 6, 36, 20, 47, -8, -8,
    -5, -18, -30, -10, -15, 0, -2, 1,
    6, -4, -18, 15, -13, -24, 13, -2,
    19, 3, 0, 8, -12, -8, 1, -28,
    27, 9, 33, -4, -37, -86, -2, -40,
    -2, 13, -29, -5, 8, 6, -2, -2,
    -18, 14, 8, -15, 29, -19, -15, -16,
    -8, -15, 8, -13, 0, 41, 12, -59,
    4, 3, 11, -30, -8, -24, 16, -14,
    12, 22, 4, 5, 2, 1, -8, -5,
    -9, 1, -14, 22, 13, 8, 17, 0,
    3, 5, -15, -3, -2, 8, -45, 4,
    -22, 22, -14, -20, -8, -14, -16, 9,
    22, -3, -24, 43, 1, 10, -4, -9,
    -5, 11, -7, 40, 28, -7, -5, 33,
    23, 13, -8, 13, -20, -25, -33, -10,
    20, -45, -17, 48, -18, 34, 23, -16,
    -2, 16, -29, 18, 10, -1, 1, 7,
    -19, 23, -5, -2, 8, 18, -15, -59,
    33, -14, 4, 22, -43, -15, 31, 3,
    21, -16, 2, -19, -10, -24, 66, 32,
    -13, -25, -46, -6, -6, -3, -2, -2,
    -3, 36, 13, 13, -15, -7, -18, 0,
    10, 8, -29, -1, -36, -2, 8, 4,
    7, -2, -36, -8, 5, 9, 34, -18,
    -2, 10, -10, 31, 14, -1, -9, -7,
    -31, 14, 4, 7, 6, 27, 11, 3,
    17, 10, -35, -39, -17, 32, 36, -28,
    -30, -37, -23, -14, 33, -33, -5, -20,
    35, -5, 10, 25, -8, 4, 3, 5,
    -40, -2, -1, 10, -8, 17, -2, 2,
    7, -32, 39, 12, 18, -25, -2, 11,
    31, -13, -17, -38, 0, -1, -1, -17,
    28, -5, 18, 5, -5, 3, 6, 5,
    -7, -13, 14, -37, -20, 1, -29, -14,
    -3, 6, 22, 35, 14, 15, -7, -18,
    16, -13, 14, 19, 28, 23, -22, 13,
    5, -25, -7, -4, -15, -3, 2, 0,
    14, 23, -37, -6, 7, -26, -5, 20,
    -11, 20, 8, -31, -13, -5, -1, 19,
    -21, 7, 31, 3, 16, 22, -25, -30,
    -18, -13, -47, 2, 17, 4, 5, -14,
    -30, 8, 7, 8, -60, -26, -12, 54,
    -7, 12, -27, -1, 25, 19, -13, 11,
    -10, -23, -7, 39, -1, -30, -9, -9,
    2, -34, 6, -19, -9, 9, -6, -13,
    -43, -22, 22, -8, 42, 15, 30, 4,
    -36, -4, -3, 17, -5, -10, 21, 17,
    35, 0, -2, 5, 4, 39, -32, -25,
    -33, -31, 2, 19, -4, -7, 3, -18,
    28, -2, 0, 12, 1, -3, -19, 4,
    22, 21, 0, 5, -5, -19, -15, 22,
    32, 0, 26, -1, -71, -15, 13, 21,
    29, 21, 14, 14, -1, 7, -4, 0,
    -38, -5, 5, -12, -11, -3, 28, -34,
    -9, -13, 29, -16, 16, 4, -7, -9,
    -10, 18, -31, 37, -29, -6, 40, 11,
    -31, -7, -5, 12, 7, -10, -13, 3,
    5, -15, 4, 7, -26, 25, -7, -60,
    -20, -21, -11, 1, 1, 21, 18, -13,
    46, -1, -31, 3, -23, 49, -6, 1,
    6, 10, -46, 3, -2, 1, -14, -1,
    32, -14, -2, 14, 14, -1, 24, 34,
    -13, -12, -11, -3, -5, 40, 17, -12,
    14, -12, 34, 12, -18, 5, 75, 2,
    1, 27, 5, 5, -12, 3, 10, 0,
    24, 16, -33, -10, -4, -9, 10, 5,
    7, -25, 20, 3, 25, -30, 36, -8,
    -28, 52, 12, -17, 26, 15, 0, -30,
    24, 2, -5, -13, 16, 2, 7, 9,
    19, 40, 40, 33, -9, 11, -37, 19,
    -40, 29, -4, 13, 4, -6, -5, -10,
    27, -35, -6, -16, -48, -31, -1, -11,
    15, 6, -31, 5, -2, -1, 3, -10,
    13, 23, -22, 5, -13, -14, -7, 22,
    46, 15, -10, 9, -4, 14, -10, 12,
    -8, -19, -26, -3, -16, -33, 2, 8,
    3, -2, -46, -26, 6, 8, 1, -10,
    17, 7, 51, -10, -17, -25, -23, 16,
    7, -35, -22, 15, 13, 17, -2, 5,
    -40, -32, -10, -1, -3, -49, -4, -30,
    -18, 54, 15, 56, 7, 13, -10, 7,
    -16, -15, -6, -19, 12, -7, -10, -29,
    -14, -33, 8, 9, 18, 10, 34, 18,
    51, -3, 40, -1, 46, 10, 23, 5,
    29, 20, -13, 29, -11, -8, -13, 10,
    -23, -2, 40, 19, -11, 2, 10, 1,
    -3, 45, -25, -13, 26, 10, -11, 6,
    3, -12, 51, -31, -19, -3, 41, 18,
    -16, -31, 0, -19, -6, -14, -1, 6,
    41, 19, -13, 9, -28, -6, -24, 1,
    -15, 26, 1, -18, 1, 4, -31, -46,
    7, 30, 29, 3, 10, 17, 9, 10,
    -19, 6, 17, -5, -1, 2, 8, -17,
    -4, -12, -6, -65, 18, -17, -29, 46,
    -2, 17, 26, 5, -5, -5, -14, -14,
    -15, -24, -10, -8, -32, -1, 12, -10,
    4, 0, 18, 14, -3, -4, 5, -8,
    18, 16, -9, -1, -13, 13, 8, -19,
    5, 20, -43, 14, 6, -11, 11, 13,
    -4, 0, 35, -37, 8, 11, 17, 18,
    20, 16, 18, -34, -1, 5, 8, -6,
    21, -9, -11, 13, -8, 10, 29, -8,
    26, -5, 5, -19, -4, -56, 1, -4,
    -34, -2, -13, 33, -9, -3, -46, -24,
    -32, -19, 3, -12, 6, -1, -4, 6,
    12, -6, 12, -17, 7, 7, 30, -9,
    -4, -3, -2, 0, 39, 13, -52, -7,
    -2, 9, -22, -27, -2, -1, -11, -2,
    5, -9, 19, -17, -6, 3, -1, 9,
    21, -41, -23, -1, 21, -12, -23, -9,
    13, 5, -12, 12, 12, 53, 6, 9,
    7, -15, -62, -9, 20, -25, 5, 5,
    0, 20, -1, 10, -4, -5, -2, -4,
    -4, 14, 2, -10, -35, 23, 35, -23,
    3, -15, 36, 10, -17, 1, 5, 17,
    -37, -13, 20, -3, 45, -29, 20, 55,
    -26, 9, 29, -12, 4, 0, -8, 3,
    -4, 21, -9, 48, -20, 23, 31, -35,
    26, -29, 26, -32, 4, -45, 1, -29,
    4, -22, -5, 4, 37, -26, -1, 48,
    17, -46, -29, 49, -10, 9, -13, 3,
    0, 23, -4, 42, 16, -24, 17, 46,
    18, -18, -19, -3, -44, 0, -17, -5,
    16, -16, -17, -20, 4, 9, 6, 3,
    -23, 11, -30, -22, 20, -8, 3, 0,
    5, -4, 34, -17, -56, 34, 23, -7,
    16, -21, -2, 5, -4, -17, 25, -9,
    -36, 18, 5, 29, -23, 35, 5, 1,
    19, 8, -34, 16, -6, 2, 8, 4,
    -14, -7, 20, 9, 1, -26, 17, 23,
    5, 8, -22, 30, -6, 0, 16, -3,
    3, 5, -24, -38, 2, -63, 14, 0,
    -10, 10, -21, -8, -5, 12, 2, -17,
    19, 4, 20, -20, 13, -8, -2, -4,
    -26, -6, -10, 4, -8, 3, -5, -13,
    29, -11, 31, -51, -26, 14, 18, -33,
    13, 32, -11, 20, -5, 5, -3, -1,
    -12, -10, -29, 5, -3, 13, 22, 1,
    -6, -3, -13, -18, -14, 16, 4, -18,
    -21, -5, -20, -59, -9, 5, 1, 29,
    10, 0, 5, 24, 4, 7, 10, 1,
    2, -1, -13, 25, 6, -9, -6, 17,
    0, -12, 14, 33, -5, -14, -23, -28,
    -5, -22, 26, -4, -17, 2, -9, 13,
    6, -3, -5, 15, 15, 2, -9, 3,
    -11, -13, -7, 5, 4, 4, -9, -41,
    -18, -13, -6, -16, -34, 8, 14, 4,
    3, -16, 14, -18, -2, 0, 51, 16,
    -27, -25, -74, 16, -9, 1, 0, 4,
    6, 3, -8, 13, 26, 0, -8, -2,
    19, 14, -44, 22, 21, -1, 41, 24,
    49, 10, -18, -28, 10, 8, 14, 1,
    0, 11, -22, 32, 16, -4, 14, -3,
    -43, 13, -25, 10, -17, 53, 28, -13,
    29, 13, -53, -28, -26, 6, 13, -36,
    -35, -9, -7, -5, -22, -29, 18, -4,
    24, -1, 9, 6, -14, -4, 0, 3,
    0, -13, -6, 12, 28, -19, -1, -3,
    -11, -17, 71, 0, -42, -75, 39, -42,
    62, 12, -16, 1, -20, -22, 20, -31,
    17, 3, 26, 21, -3, -62, 20, -64,
    -25, 16, -17, -4, -14, 8, -43, -61,
    -12, -17, 13, 9, -38, -39, 27, -40,
    14, -4, -50, 9, -12, 2, -1, -1,
    13, -25, 13, -11, -48, -4, -2, 0,
    -11, -27, -56, -57, 5, 25, -24, -1,
    25, 0, 1, -46, 0, 28, -23, 29,
    -55, 24, -23, -29, -9, -1, -14, -4,
    -42, -16, -29, 16, 3, 16, -23, 17,
    -7, 34, -6, 22, -72, -57, -9, 55,
    2, 11, 12, 1, -1, -25, -9, 46,
    3, -11, -12, 39, -9, -11, 17, 3,
    9, -69, 12, -24, -39, 2, 3, -47,
    31, -14, 24, 11, 59, 58, 58, 18,
    -22, 4, -41, -15, 9, -8, -27, 36,
    22, 32, 39, 86, 0, 21, -69, 7,
    -36, -47, 34, -12, 3, -85, 28, -57,
    39, 2, -66, 27, 51, -9, -61, -59,
    -22, 7, 38, -2, 11, 31, 19, -23,
    49, -15, 43, -26, -80, 54, 4, -3,
    95, 32, -21, 57, -19, 79, -50, -35,
    35, 37, 65, 32, 26, 38, -26, -28,
    -12, 4, -35, -41, -17, 32, 16, -43,
    -15, -46, 32, 5, 21, 3, 56, -25,
    -32, -8, -22, 51, -11, -18, -17, 3,
    -66, -6, 11, 2, -71, 75, 68, -19,
    3, 35, 33, -6, 58, -33, 10, -22,
    -6, -75, -54, -32, 12, 59, -14, 26,
    -16, 26, -25, -46, -6, 32, -13, 3,
    35, -53, -2, -17, 48, -20, -1, 52,
    -32, 14, 16, 20, -29, 82, -31, 9,
    10, -3, 3, 4, -22, 0, 71, -7,
    13, 2, -9, 6, -2, 9, 13, -9,
    6, -2, -17, 11, 4, -11, -31, 32,
    48, -42, -13, -14, 17, -33, -29, -9,
    -67, 50, 59, -22, 67, 33, -45, -53,
    1, 5, -16, -25, 30, 14, 27, -3,
    -8, 12, -35, 28, 0, 29, -47, 29,
    14, -31, 19, -11, -32, 15, 35, -9,
    -73, 47, -29, -1, -28, -28, 12, -21,
    -14, 7, -76, 17, 35, -7, 9, -10,
    -90, 56, -18, 14, -66, -9, -11, 84,
    16, -12, 20, -23, 56, -36, -35, -13,
    -36, 40, -76, 39, -16, -83, -9, -48,
    7, -28, -96, -5, -13, -6, 63, -14,
    44, 20, 12, -31, -34, 41, -4, 5,
    -44, -44, -8, 22, 50, -67, 4, 21,
    -27, -42, -21, 18, 0, 22, -18, -29,
    14, 61, -4, 127, 11, 70, -77, 13,
    2, -28, 101, 20, 32, -21, -39, -41,
    -25, -12, 19, 8, -19, 23, 28, -23,
    -59, -14, -37, 3, 54, 14, 18, 12,
    -3, 44, -19, 63, -58, -31, -3, 8,
    -33, 42, -29, 58, -41, 51, 82, -28,
    4, -25, 38, -28, 18, -23, 8, -20,
    43, 53, 1, -22, 2, -6, 58, 9,
    -28, -6, -27, 1, 30, 23, -35, 7,
    -26, -4, -30, -51, -74, 21, 11, 34,
    -17, 24, -4, 3, 4, 24, -28, -34,
    15, 0, 115, 8, 53, 9, -54, 53,
    -32, 19, 30, -5, -3, -19, 58, -55,
    -10, 10, -7, -35, 3, 13, -46, 25,
    -13, -1, -34, -13, -15, 22, -14, 22,
    -7, 11, 31, -31, -18, -10, -10, -40,
    2, 21, 11, -19, 6, -2, -2, -3,
    4, 24, 46, -33, -9, 28, 18, -38,
    20, 57, -10, -41, -22, -34, -42, -59,
    -27, -8, -10, 21, 12, 4, -4, 33,
    26, 25, 36, -22, 5, -3, 25, 5,
    -49, 28, -46, 4, -32, -6, -21, 11,
    29, -6, 12, -37, -38, -2, -30, -28,
    -55, 52, -127, 56, -5, 20, -78, -51,
    -21, -27, -1, 0, 20, -20, -8, 24,
    33, 17, -37, 8, -3, 41, 23, -13,
    8, 24, -17, -7, 48, -8, -11, -12,
    13, -17, 11, -25, -12, 11, 12, -32,
    14, -1, -12, -34, -87, -42, 5, 1,
    4, -2, -2, -52, 9, -14, -46, 37,
    -34, 6, 20, -37, -27, 37, -20, 17,
    26, -41, -57, 44, 36, 22, 93, -10,
    -6, 19, -18, 15, 7, 4, -38, -9,
    -37, 19, 73, -7, -4, 30, -13, 9,
    -5, -15, -36, -6, -88, -3, -71, 20,
    -83, 2, 34, -21, 12, -41, -24, 66,
    14, 15, 54, -63, 61, -2, 7, 26,
    -16, 6, 11, -6, 31, 15, 7, -14,
    -5, 16, 11, 4, -20, -32, -6, 20,
    -28, 56, 43, -22, 32, 14, 24, 57,
    11, -25, -16, 25, 0, 52, 62, -21,
    -4, -18, 43, 33, 3, 8, 20, 15,
    27, -16, -16, 3, -76, -19, -10, 2,
    46, -14, -34, 18, 6, -15, 6, 18,
    -34, 18, 24, -31, 39, -17, -2, -13,
    34, 29, 78, 51, -101, 52, 35, 4,
    -34, -1, -4, 36, -3, -45, 66, 12,
    73, -24, -1, -20, 23, 25, 1, -5,
    7, 18, -16, 10, 28, -2, 32, -7,
    -16, -12, 6, 25, 5, -63, -21, 9,
    -2, 27, 7, 19, 34, 3, -6, 50,
    27, -22, 44, -84, -8, -52, 34, 12,
    -18, 2, 10, -28, -5, -7, -4, -8,
    55, -52, 35, -5, 39, 10, 32, 23,
    -11, -24, -3, 7, -18, -5, -36, 118,
    11, 39, 1, 23, -18, -20, 7, -22,
    17, 33, 13, 88, -12, -8, 3, 18,
    12, -28, -35, -23, -5, 8, 15, -32,
    -5, 19, 3, 17, 0, 25, -17, -41,
    -13, -5, -14, -103, 3, 22, 6, 47,
    -8, 26, 5, 55, 3, -10, 1, 29,
    -15, 12, -2, -61, 9, 10, -15, 51,
    -1, -26, 44, -1, 37, 28, 62, 27,
    43, 36, 10, 7, 7, -1, -35, 38,
    1, 23, 12, 53, -5, -15, 2, 19,
    75, 16, 12, 23, 31, -34, 12, -19,
    63, -41, -23, 12, 45, 18, -17, -14,
    -71, -31, 73, -40, 11, -10, 8, 21,
    -31, -25, -39, 17, 39, 13, -8, 11,
    -27, 1, -54, 3, 15, -27, 25, -15,
    1, 4, -24, -4, 47, -18, 21, 41,
    8, 10, -44, 19, 5, 6, 8, -10,
    -19, -32, -57, 20, -7, 7, 67, -2,
    46, 27, 3, 37, -29, 46, 33, -1,
    -45, -8, -39, -90, -37, -31, -65, -64,
    63, 7, 45, 31, -21, -48, 20, -28,
    38, -14, -5, 13, 7, 0, -11, 2,
    -32, -39, -17, 19, 85, -38, -76, 19,
    -17, 6, -8, -18, 22, 22, -9, 16,
    14, 30, 1, 36, 11, 35, 13, 10,
    -4, 2, -9, -22, 0, 27, 3, 25,
    -33, -16, 24, 20, 7, 5, -9, -4,
    -13, 21, 7, -20, 24, -25, 5, -21,
    -20, 9, 2, 17, 11, -20, -2, 12,
    -8, -2, 17, 24, -5, -11, 3, 20,
    9, -26, -6, -13, 5, 9, 7, 14,
    7, -13, 9, 3, 4, -17, 17, 31,
    26, 25, -22, 2, 19, 25, 9, 12,
    50, 15, -8, -3, 3, -24, 4, -3,
    0, -7, 30, 32, 7, 6, -9, -13,
    -28, -4, -39, -18, -23, 0, -6, -11,
    12, 3, -50, -15, -6, 1, 12, -2,
    8, -53, -37, 36, 2, -5, -8, -31,
    -4, -22, 16, -15, 9, 0, 5, 14,
    -10, 11, 5, 37, -8, -48, -11, 11,
    -46, -17, 12, -37, 17, 35, 5, 6,
    22, -4, -1, 18, 17, -15, 29, 1,
    15, -40, 18, -2, -2, -12, -9, 7,
    7, -12, -18, 7, -12, -14, 27, -2,
    -18, -6, 49, 13, -31, 25, 3, 10,
    -18, 3, -33, 7, 37, 17, 37, 9,
    -14, 24, -31, 27, 3, -5, 0, 1,
    10, 1, -2, 23, -15, 2, 23, -7,
    38, -50, 7, -7, -3, 8, 1, 7,
    -1, 14, -5, -25, -32, 9, 12, -23,
    18, 9, 19, 21, -8, 2, -1, 9,
    -11, -23, -21, -24, 1, 12, -5, -8,
    -16, -38, 5, 11, 26, -19, 13, -2,
    -23, 22, -14, -39, -7, 24, -26, -22,
    32, -9, 29, 5, -4, 19, 2, 1,
    -2, 5, 10, -1, 8, 8, -15, 1,
    33, -18, -8, 2, 1, 8, 0, -21,
    -3, 5, 20, -33, -16, -8, 9, 9,
    1, 9, -5, 22, 19, 1, 11, -8,
    10, 21, -9, -3, 0, 6, -10, -6,
    -50, 39, 4, 26, -9, -9, -22, 23,
    -32, -15, 19, 11, -8, 13, 2, -8,
    31, -35, 11, 3, -10, 14, 1, -10,
    16, 17, 15, -16, -2, 10, 24, -3,
    11, 40, 8, -6, 22, 5, -9, -26,
    32, 18, 2, 12, -17, -11, 4, 9,
    21, -4, 8, -18, 13, 2, 12, -4,
    18, 19, -35, -27, 3, 25, 8, 9,
    -30, -26, -45, -9, -23, -36, -6, 6,
    13, 47, 15, -9, 3, 27, -5, 33,
    3, 14, -29, -34, 2, 3, -1, -7,
    -10, -9, -1, -24, -23, 2, 14, -21,
    -1, 7, -8, 16, 22, 4, 9, -3,
    5, -1, 21, -4, -12, -3, -23, 2,
    21, -30, -22, 25, -3, -5, -3, 2,
    16, 3, 15, 4, -29, -20, 13, 2,
    24, -12, 39, -1, -17, 22, 5, -6,
    -32, -24, 55, -19, -35, -8, -27, 11,
    -10, 16, 35, 21, 0, 0, 7, 10,
    22, -19, 37, 15, 4, -24, -12, 22,
    10, 27, 26, -20, -13, 25, 3, -34,
    9, -36, 4, 28, -1, 9, 2, 10,
    10, -47, 22, -14, -8, 4, 16, 3,
    -28, -2, 22, -12, 9, 10, 2, -21,
    -9, -2, -26, 20, 6, 4, 9, -2,
    17, 13, -23, -5, 3, 2, -2, 1,
    13, 8, -15, -13, -10, -9, -6, 2,
    17, -32, -12, 3, 3, 5, 3, 4,
    6, -7, 0, 29, -9, 14, 11, -13,
    -15, -10, -17, -17, -14, -22, -13, -13,
    -4, 18, 26, -12, 6, 4, -14, 3,
    -8, 12, -8, 14, -2, 8, 13, -9,
    -16, 1, 16, -24, -1, 0, 30, 28,
    15, 27, 13, 3, 7, 2, 6, -17,
    8, 13, 8, -13, -2, -1, -5, -11,
    6, 3, 16, -15, -2, -14, 9, -14,
    -6, -7, -4, 12, -24, -12, -35, 14,
    18, -20, 12, 41, 39, 26, -5, -8,
    2, 25, 10, -25, 3, -2, -4, 12,
    2, -17, 1, 1, 11, 29, -4, -16,
    58, -15, 27, -25, 13, 2, -26, -5,
    19, 84, 4, -1, 40, 13, -3, -18,
    20, 21, 31, 1, 1, 3, -11, 10,
    2, 23, -6, 27, -9, -7, -14, -12,
    -24, -10, 11, -21, -8, 0, -8, 4,
    -21, -30, 12, -2, 24, 13, -20, -6,
    8, -20, 24, -5, 2, -7, -4, 6,
    9, -8, -14, 0, -19, 0, -28, 1,
    -17, -29, 20, 22, 4, 2, 7, 14,
    -30, 40, -8, -24, -20, -2, -15, 23,
    9, -6, 35, -19, -6, 9, -14, -14,
    -7, 1, 1, -4, 9, 2, 15, 5,
    13, -24, 7, -19, 2, 7, -1, 9,
    -16, -33, -7, 10, -15, 13, 38, -33,
    7, -3, -8, -4, -3, 13, -13, -16,
    -10, 6, -4, 22, 5, 6, 1, -11,
    -1, -1, -4, -25, 14, 13, 4, 12,
    42, 18, 17, 3, -6, 8, 6, -18,
    -7, -2, -14, 20, 7, 1, 6, 7,
    -9, 1, -4, -2, -16, -3, 9, 11,
    40, 1, -3, -22, -14, -5, 13, -14,
    9, -16, -20, 17, -16, -1, -32, -19,
    10, 28, 8, -28, 15, 8, -7, 5,
    11, 4, -39, -10, -32, 6, 5, -9,
    11, -6, -13, 16, -37, 36, 29, 12,
    -8, 8, 14, 18, 13, 2, 1, 13,
    -8, 4, 5, 3, -8, 0, -2, -14,
    26, 21, -17, -4, -9, 2, -4, -13,
    -34, -6, 20, -36, 5, 6, 0, -29,
    31, -20, 0, -22, 5, -6, -15, 0,
    18, -1, -19, -14, -2, 3, -4, 3,
    -12, 18, 18, 0, -2, -18, -39, -7,
    15, 3, 7, 21, 14, 27, -5, -19,
    -18, -7, 44, 22, -5, 18, -41, 0,
    -3, 1, 5, 19, 9, 3, -12, 6,
    8, 11, -14, 0, 8, -2, 8, -10,
    -7, 52, 7, 9, 0, -2, 39, 3,
    -16, -5, 15, -46, 20, -1, 9, 10,
    -2, -10, 2, -10, 12, -13, 1, 2,
    -11, -5, 34, -4, -4, -4, -10, -14,
    -14, -31, 3, 9, 17, -5, 5, 12,
    57, 34, 18, 9, -10, 22, 23, 28,
    27, -7, 2, 33, 0, -5, -3, 7,
    17, -29, 22, 2, 20, -8, -6, -14,
    -1, 3, 29, 5, -7, 1, 13, -12,
    -13, -15, -17, -13, 23, 7, -44, 0,
    0, 15, -16, -1, 6, 5, 0, -2,
    -12, 20, 3, -9, -9, 9, 3, -6,
    -27, 16, -25, -8, 32, -15, -44, 5,
    -2, -5, -5, 15, 12, -10, -8, -25,
    11, 6, 9, -28, -5, -2, -10, 12,
    -52, 11, -7, -36, 18, 29, -10, 20,
    4, 14, 15, 45, -4, 36, -9, -32,
    -4, -21, -19, -27, 6, 10, 8, -26,
    37, -3, 23, -32, -20, -38, 14, 16,
    -31, -4, -17, 31, 11, -20, 5, -22,
    11, 13, 24, 11, 15, -33, -7, 6,
    -16, 8, 16, 0, -21, 11, -13, 35,
    -13, 7, 10, -39, -23, 5, -10, 10,
    4, -8, -18, -49, 9, -5, 10, 6,
    -18, 10, 29, 4, -13, 2, -37, 57,
    59, -23, 70, 46, 2, -23, 3, 11,
    -45, 12, -23, -27, 17, -4, 75, 54,
    22, -4, 41, 2, 4, -17, 19, -6,
    -21, -5, -67, -34, -11, -17, -36, -23,
    -10, -20, -20, -5, 8, 0, -3, -16,
    -20, -19, -40, -23, -2, 0, 1, -9,
    -23, -2, 6, 40, -29, -4, 1, -27,
    -50, -20, 21, 20, 4, 65, -13, 19,
    12, -12, -24, 31, 23, -9, 6, 10,
    6, 15, 16, -47, 31, 2, -45, -29,
    2, 52, -28, 3, -7, -16, 20, -23,
    14, -45, -26, 24, -58, -18, -2, 13,
    13, -17, 2, -54, 16, 44, 37, -14,
    -7, 19, -7, -30, -34, -13, 7, -10,
    21, 10, 8, -28, -24, 0, 11, 16,
    33, -75, 2, 2, 4, 11, 26, -24,
    66, 22, 44, -35, -9, 25, 13, 3,
    12, 14, 24, -5, 6, 4, -4, -12,
    -21, -11, -8, -4, 8, 11, -9, -26,
    -48, -24, -2, 3, 3, -12, 11, 4,
    -23, 13, -33, 2, -1, 17, -29, 16,
    26, -7, 35, 6, -6, 3, 1, 21,
    -1, -5, 24, -10, 4, -1, -27, -5,
    36, 10, -28, 25, 12, -21, -26, -4,
    -5, 19, -37, -30, -33, -5, 45, 9,
    -2, -16, -13, -4, 22, -9, -3, -7,
    23, 22, 3, -21, -6, 16, -5, 13,
    -46, -28, 42, 9, -15, 20, -28, -6,
    -18, -10, -12, 31, 7, 15, 16, -7,
    35, 18, 46, 22, 13, -21, -30, 3,
    11, 1, -24, 9, -16, 15, 2, -12,
    23, 49, 14, 21, -2, -5, -20, -24,
    2, 35, -1, 7, 57, 19, -4, 10,
    27, 12, -7, -4, 6, -4, 9, -1,
    -17, -73, -24, -10, -49, 7, 6, 21,
    -15, 54, 23, -6, -22, -40, 45, 10,
    12, -3, -57, 2, -25, 5, -6, 31,
    6, 16, -7, 0, 8, 3, -8, -14,
    11, 12, -5, 5, -43, 27, -10, 4,
    -16, -30, -14, -7, -7, -14, 30, -3,
    29, 11, -16, -41, -6, 19, -19, -2,
    3, -11, -60, 10, 3, -16, 5, -44,
    -4, 38, 27, 7, -13, -16, -14, 0,
    -34, -41, 52, -21, 28, 7, -1, 18,
    -49, -41, -20, -17, 17, -10, -17, -8,
    14, 1, -18, 0, -13, -27, -6, -16,
    5, -27, 29, -32, 24, -22, 7, 6,
    22, 95, 37, 19, -20, 28, 0, -6,
    24, 8, -24, 2, 1, -23, 26, 30,
    -8, -40, 4, -1, -4, -3, 17, 0,
    -17, -4, 14, 31, 7, -17, 9, 4,
    -8, 7, 0, -18, 7, -22, 21, 24,
    20, -2, -13, 2, 11, 5, -20, -23,
    7, -9, -13, -7, -3, -1, 0, 7,
    -1, -14, 10, -48, -7, 21, 13, -11,
    41, 16, -7, -8, -6, 41, 9, -4,
    19, -21, -12, -2, -15, -36, -22, -11,
    -12, 16, -35, 31, -5, -12, 21, 9,
    37, -3, -8, 15, -9, 11, 21, -19,
    -44, -15, 38, 21, -39, -20, 36, 34,
    -8, -3, 6, 19, 10, 43, -38, -10,
    28, 22, 16, 11, 6, 8, -12, 34,
    -59, 30, 1, -14, -30, -13, -59, -9,
    -27, -4, -17, 7, -3, -13, -26, 4,
    4, -20, 9, 16, -9, -30, -36, -24,
    7, -22, -35, -23, -30, 22, -3, -11,
    14, -46, -31, 23, -18, 5, -23, -2,
    56, -34, -15, 18, -5, -28, -19, -16,
    11, 42, 36, 0, 14, -45, -12, -49,
    12, 13, -24, -19, -10, 13, 32, 2,
    -28, 16, 6, 3, -14, -17, -5, -6,
    -4, -37, -25, -9, 41, 26, -29, -6,
    4, 27, 0, 12, 30, 14, 8, 0,
    29, 11, -21, 2, 13, 0, 15, -12,
    -32, -4, -16, 32, -5, -3, -16, -25,
    13, -14, 20, 36, 20, -9, -5, 31,
    -9, 36, -15, 55, 29, 0, 9, 24,
    -22, -20, 35, 21, 7, -3, 9, 70,
    32, 38, -3, -2, 12, 1, -30, -44,
    14, -29, 29, -28, 6, -3, 18, 28,
    -14, 39, 2, 17, -28, 22, 1, -2,
    -1, -16, -14, -3, -3, 36, -6, 23,
    20, 17, -19, -18, -18, 0, 9, 6,
    -20, 0, -4, -46, 8, 24, -24, -8,
    39, 14, 12, 8, 10, 6, 1, 13,
    -27, -4, 13, 20, 11, 4, -7, 22,
    -11, 29, -25, -12, -11, -6, 5, 18,
    -1, -19, -38, -10, -11, 23, -4, -3,
    9, -22, -67, 14, -22, 13, 15, -4,
    -23, -7, 21, -29, 1, 0, -2, 4,
    -22, 17, -13, 6, -25, 2, 4, -25,
    22, -9, -13, -13, -7, 25, 24, -47,
    -67, 5, 3, -25, 38, 26, -25, -34,
    68, 3, 0, -8, -15, -4, -36, -14,
    27, 1, -36, -4, -12, -29, -10, 18,
    -20, 47, 16, -65, -14, 55, -27, -19,
    22, 1, -31, 23, -1, 9, -23, -29,
    15, 26, -13, 46, 3, 9, 7, -35,
    -7, 7, -11, 56, -1, -4, 0, -9,
    21, -18, -7, 7, 4, 24, -19, 0,
    -15, -34, -3, -5, -4, 7, 12, -15,
    5, 1, 5, -16, 14, -13, 5, -20,
    27, -24, -11, 39, 20, 10, -5, -20,
    23, 85, 3, 21, 15, 26, -20, -6,
    13, 6, 6, -11, 20, 6, 0, -53,
    -22, -1, -11, -14, 1, 6, -1, -32,
    6, -14, 20, 3, -24, -21, -7, -13,
    -19, -47, 25, -3, -28, -13, -10, 9,
    2, 44, 31, -17, -44, 16, 8, 28,
    18, 18, 7, 20, 2, 10, -1, 15,
    14, 11, -11, 6, 5, -14, -3, -33,
    -12, 12, 8, 2, -9, -2, 19, 0,
    -9, 14, 1, 2, 26, 9, -14, 18,
    -8, -6, -28, -8, -10, 2, 33, -3,
    19, 5, 11, -14, -10, 3, -12, -3,
    15, 30, -16, -24, 23, -11, 20, -7,
    -22, -20, -70, 7, -1, -34, 7, -23,
    -6, 12, -23, -27, -20, 7, -8, 9,
    14, -1, -10, 20, -6, 19, -12, 36,
    -1, 4, 52, 9, 45, 13, 3, -79,
    -42, -21, 14, 33, 2, 40, 21, -5,
    34, 6, 1, -71, -7, 16, 20, -9,
    32, 5, -31, 13, 55, 8, 35, -29,
    -48, -15, 9, -12, 7, -18, 19, 18,
    20, 7, 21, -37, -14, 14, 5, 13,
    -39, 5, 20, -16, 7, 4, 12, 7,
    -18, 0, 15, 57, 20, -9, 15, -24,
    -44, 51, -37, -39, -21, 23, -84, 32,
    -4, -39, -43, -72, -7, 29, -52, -41,
    8, 1, 72, -33, -8, -19, -35, -25,
    13, 3, 42, 3, 0, -5, -23, -21,
    -31, -9, -34, -45, 18, -9, -85, -34,
    -20, 47, -4, 16, -11, -42, -12, 4,
    -11, 7, -23, -30, 9, -5, -10, -2,
    -1, 1, -4, -60, -71, -18, 20, -28,
    -4, 12, -13, -1, 0, 41, 11, 34,
    6, 10, -7, 0, 17, -20, -9, 3,
    -6, 6, 30, 49, -30, 32, 14, 55,
    7, 6, -32, -13, -39, -36, 2, -78,
    9, 79, -5, 30, -39, 1, 23, 1,
    -15, -18, 51, -9, 18, 19, 49, -54,
    18, 20, -20, -54, 11, 5, 26, -17,
    -8, 11, 4, -73, -24, -13, -27, 36,
    22, -31, 18, -3, 42, -13, 86, 14,
    65, 40, -8, -20, -36, 35, -2, 34,
    -22, 22, 41, -17, -5, 0, 2, 0,
    -24, 20, 7, 18, 17, 7, -5, -31,
    -10, -59, 10, -18, 29, 1, 1, 31,
    62, 0, -26, 35, 13, -12, -9, 4,
    -30, 20, -1, 67, -3, -20, -5, 9,
    6, 21, 2, -25, -7, -19, -3, -9,
    47, -7, 11, 9, 11, -72, -17, 0,
    0, 3, -39, -26, -16, -5, 58, 9,
    -3, -29, -17, 0, 16, -7, -6, -3,
    -25, -5, -20, -26, -17, 51, 12, 37,
    34, -22, 30, 24, 1, -17, -3, -5,
    -2, -12, -31, 48, -14, 57, 22, -17,
    25, 37, 41, 20, -17, -20, 13, -6,
    -6, 16, 7, 3, -29, -52, 28, -4,
    5, 58, 1, 27, 12, 30, -30, 23,
    20, 29, 35, -2, -3, 36, 15, 43,
    48, 0, 8, 7, 11, 12, -6, -7,
    46, 83, 28, 24, -33, 16, -25, 12,
    17, -28, -8, 0, 18, -3, 4, 28,
    -4, 24, 34, -16, -11, -17, 6, -25,
    37, 92, -68, -6, -22, 18, 29, -38,
    51, -8, -1, 21, -19, 10, 10, -7,
    3, 37, -3, 17, 20, -49, 24, -16,
    47, 75, -51, 9, -8, -57, -9, -13,
    13, -80, -69, 10, -9, -8, 1, 8,
    -8, 27, 27, -19, 9, 7, -19, -20,
    -15, -5, -12, -3, 46, -2, 2, -13,
    14, 3, -22, -3, 23, -8, -40, 28,
    -9, -52, -10, -20, 14, -7, -3, -8,
    -12, -14, 2, -10, -9, 13, 37, 45,
    32, -24, 43, -38, -40, 6, 13, 23,
    23, -33, -16, 43, 19, -28, -23, 53,
    49, -13, 34, -25, 9, -9, -13, 19,
    -6, 17, 9, -21, 6, -2, 3, -24,
    -24, 23, -32, -14, -6, 4, 9, 39,
    35, -25, -39, 32, -22, -17, 7, 10,
    4, 21, 21, 19, 11, -6, 1, -13,
    -5, 9, -24, -13, -3, 18, -8, 1,
    42, 20, 6, 13, 5, 5, -28, 48,
    27, -51, 7, 37, -16, 5, -24, -13,
    -10, 21, -47, 34, -9, -19, 0, -23,
    -52, -12, -41, -13, -8, 8, 1, -32,
    -7, 26, 36, 71, -31, -16, 34, 37,
    -13, 16, 15, -2, -21, 86, -17, -33,
    22, -1, 62, 21, 10, 19, 20, -13,
    -14, 0, -4, -16, 43, 29, -4, 0,
    -75, -14, -40, 0, 19, -40, -30, -26,
    118, -38, -4, -7, 64, -31, -64, -12,
    -40, -18, -76, -9, 25, 15, -1, 6,
    -3, -15, 14, -27, -20, -2, -4, 9,
    16, 38, 44, 25, 51, 25, -4, 41,
    49, 43, -65, -64, 5, -76, -22, -59,
    -2, 19, -40, -7, 22, 8, -7, -1,
    1, 24, -9, 30, 12, -31, -24, 25,
    -8, -29, -13, -47, 68, 18, 42, -5,
    46, 40, 27, 11, -9, 8, -26, -3,
    19, 28, -67, 5, 18, 17, -51, 3,
    -6, 5, 19, -60, 55, -4, -22, -79,
    -5, -35, 92, 37, -7, -17, -25, 56,
    -44, 24, -23, 35, 25, -1, 15, 37,
    -44, -6, -15, -26, -12, 6, -3, -34,
    7, -18, 34, -21, 47, -6, -33, -96,
    -16, 22, -64, 17, -20, -58, -25, 45,
    18, 1, -32, -6, -8, -31, -26, 16,
    -23, 19, 20, -23, 11, 34, -3, -11,
    -3, 13, 3, 12, -13, 7, -19, -33,
    -39, 10, -39, 51, -11, 41, -7, -38,
    -40, -10, 5, 11, -16, 6, 28, 55,
    28, -2, 5, 19, -8, -3, -1, 6,
    -4, 22, -94, 22, -29, -11, -35, -10,
    29, -2, -81, 15, -41, -21, 41, -16,
    44, -3, -32, 19, 37, -36, 127, -24,
    -44, -19, 10, -26, -4, -16, 4, -18,
    0, 5, 32, 17, -24, 15, 37, -30,
    30, -17, -41, 19, 53, 55, -14, 16,
    24, 73, 57, 39, 40, 8, 2, -32,
    58, -28, 58, -42, 32, -12, 14, 0,
    22, 12, -18, -36, -14, -5, -10, -18,
    -18, -32, -18, -52, -7, 104, 19, -99,
    25, -36, -20, 51, 1, 6, -26, 5,
    8, 58, 0, -18, -8, -15, 3, 39,
    -8, 26, 22, -5, 12, 4, -39, -7,
    16, 23, 17, 59, 7, -11, -20, 16,
    6, -3, 31, 25, -6, -7, -5, -55,
    21, -42, -6, -36, 4, 25, -4, 7,
    -20, 16, 35, -13, 21, -16, -6, 8,
    12, 13, 41, -38, 28, -14, -78, -35,
    44, -55, -19, 13, 24, 76, 21, 34,
    -14, -62, -16, -17, 4, -19, 4, -14,
    11, 44, -7, -9, 2, 15, 5, -30,
    45, -55, -11, 11, -107, -22, -3, 6,
    6, 31, -23, -23, 35, 11, -12, 51,
    -27, 3, 71, -15, -9, -21, -18, -7,
    -26, 26, 22, 3, 8, -6, -16, -8,
    -32, 39, -4, -12, 1, -14, 37, -23,
    18, -20, -13, 3, 73, -12, 5, 5,
    -45, -4, -77, 9, 8, -7, -3, -12,
    -20, -21, -25, -5, 29, 21, 24, -2,
    -15, 24, -80, -43, -11, 4, 29, -2,
    38, 2, -6, 25, -33, -42, -14, -3,
    -16, 26, -51, -24, 12, 1, 19, -16,
    33, 5, -6, 16, -20, -8, 4, -3,
    -3, -7, 14, 11, -24, -5, 44, -53,
    28, 15, -31, 21, 5, 14, -9, 6,
    15, 22, 9, -5, 2, 20, 7, -2,
    14, 21, 28, -4, -8, 28, -5, 17,
    -17, -4, 1, -18, 7, 18, -42, 11,
    -15, -35, -20, 5, 1, 25, -10, -17,
    -3, 14, -21, 14, -2, 4, 19, 1,
    -59, -27, 57, 3, 8, -33, 37, 20,
    -27, -30, -45, 36, 11, 32, -6, -40,
    -12, 7, 57, 20, 7, -21, -19, 23,
    -5, -1, 27, 4, -5, -10, -29, -21,
    -28, 24, -11, -29, -2, 17, -11, 4,
    4, -38, 0, 1, 10, 13, 16, 8,
    20, -7, 23, 6, 31, -34, -12, -5,
    -18, -9, -21, 3, -18, 6, 6, -22,
    -14, -43, -10, 0, -40, -19, 7, -12,
    47, -14, 34, 16, 15, -21, -14, -38,
    8, -18, -13, -20, 25, 16, 22, 1,
    2, -43, -8, -24, 6, -3, -5, -19,
    -36, 26, -14, -34, 6, -8, 7, 24,
    29, -12, -6, -45, 40, 17, 19, -3,
    8, -13, 24, 0, -23, 11, -10, -46,
    -7, -17, -9, 18, 2, 4, -9, 13,
    27, -8, -2, -11, -39, -11, 6, -43,
    1, 3, -35, 9, 7, 4, 24, -27,
    -35, 56, -1, 2, -4, 15, 8, 1,
    -6, -7, 8, -5, -12, 2, 17, -13,
    -13, 4, -10, 31, -23, -4, -13, 15,
    32, -28, -2, -35, 12, 30, 14, -9,
    1, 7, -11, -12, 18, -29, -13, 30,
    13, -5, 29, 9, 13, -12, 14, -10,
    0, -13, -7, 0, 2, 4, -26, -5,
    26, 24, -61, 22, 7, 4, -7, -11,
    9, 26, 1, -5, 22, -12, -8, -22,
    -6, 0, 13, -3, 6, -8, 12, 34,
    21, -1, -2, 12, -19, 10, 3, 10,
    19, -2, -6, -16, -2, -6, 18, 24,
    -14, -3, 1, -4, 17, -19, 3, -39,
    -8, 3, -20, 5, 9, 9, 17, 1,
    40, 4, 16, -21, -10, 30, 13, -7,
    38, -14, 19, -17, 25, -1, -20, 34,
    23, -13, -65, 11, -14, 8, -18, 6,
    -7, 2, -22, 24, 4, 4, 14, 6,
    -15, 47, -18, 7, 1, -21, -30, -21,
    -11, -6, -2, 3, 20, -53, -11, 6,
    -40, 20, 7, 10, -2, 15, 19, 12,
    12, -35, -9, 11, 13, -21, -23, -5,
    -9, 3, 2, -32, 12, -34, 19, 9,
    -22, 25, 20, -14, -53, -49, 16, -35,
    23, -30, 23, 5, 15, 28, 11, 2,
    -20, 6, 7, 4, 21, 9, -2, 0,
    8, -15, 2, -5, -19, -16, 0, -53,
    -10, -2, -17, 33, 24, -16, 29, -2,
    0, 15, 15, -19, 1, -5, 43, 3,
    -5, -13, 46, 16, -21, -11, -5, 17,
    -7, 55, 3, 16, -18, -21, 22, -5,
    -1, 27, -20, -23, -19, -26, -6, 45,
    14, -1, -30, -1, -37, 20, -2, 10,
    -31, 12, -11, 21, 1, -31, 30, -15,
    -3, -13, -7, -5, 16, 5, 7, 30,
    -27, -35, 19, -55, 4, -13, 13, -2,
    9, -24, -16, 9, 17, 15, -16, -12,
    -2, 1, -33, 13, -14, 39, 11, -16,
    4, -8, 8, -25, 31, -8, 12, -24,
    -11, -19, 35, -62, 0, -9, 20, 14,
    15, 1, -10, -29, 4, -26, 47, -6,
    18, 12, -3, 18, 8, -12, 11, 12,
    10, 8, 7, -39, 1, 19, -8, 38,
    8, 16, 31, -22, 5, 7, -25, -27,
    -23, 13, 16, -36, 20, 5, 3, 3,
    -3, -19, -12, 4, -13, 0, 3, 16,
    15, -11, 27, 10, -26, 32, -21, -14,
    18, -13, 15, 11, 28, -19, 29, -7,
    27, -16, -36, -14, -11, -11, -34, -16,
    25, -25, 1, -6, -21, 4, 8, -24,
    -38, -36, -27, -6, -7, 6, 14, 19,
    56, -39, -16, 35, 6, -18, 16, -39,
    -1, -57, 24, 47, 15, -29, 21, 35,
    14, 1, 2, 1, 5, 38, -4, 2,
    25, -9, 21, 17, 20, 16, -22, 13,
    12, -14, 44, -6, 24, -16, -32, -15,
    -41, 6, -31, -14, 7, 17, 10, 0,
    4, 1, 15, 2, 6, -10, 2, -7,
    -11, -2, -17, -37, 35, -4, 24, -37,
    8, 12, -13, -17, 38, -17, 5, -10,
    39, 4, 31, 16, -32, -13, -13, -26,
    5, -6, -16, 6, 14, -62, 52, 7,
    24, -23, 31, -26, 0, -8, 0, 28,
    7, -11, 55, -19, 9, -28, -54, 9,
    -4, -14, 11, 1, 39, -7, 1, 29,
    -7, -13, 3, 18, 4, 12, -11, -15,
    -10, -21, 5, -28, -31, 6, 9, 30,
    40, 1, -26, -25, -17, 15, -25, 6,
    23, -2, 19, 8, 14, 3, 4, 29,
    -16, 32, -7, -15, -22, 2, 1, 4,
    -31, -14, -5, 14, -8, 4, -6, -21,
    14, 8, -33, -16, -23, -14, -17, -10,
    32, 55, 8, -1, 14, 5, 8, -10,
    15, 16, -4, 0, -22, 15, 5, -7,
    2, 11, 23, -33, 19, -4, 2, 5,
    -35, -18, -35, 32, -22, -24, 6, 3,
    -26, -15, 9, -6, -1, 31, -14, -23,
    11, 2, -64, 1, 2, 12, 34, 14,
    10, 11, 4, -13, 16, -12, 2, 18,
    15, -3, 5, 25, -13, -10, -24, 44,
    -34, -49, -24, 17, 11, 2, -44, -1,
    -7, 27, -11, 24, -17, 0, 38, -10,
    1, -28, 5, 6, -20, 14, -26, 5,
    12, -5, 32, 14, 3, 1, -11, -18,
    -23, 11, -4, -35, 6, 8, -10, -8,
    0, -14, -35, -17, -5, 8, -21, -26,
    14, -19, 29, -16, 11, -20, -17, 24,
    -20, -5, 9, -20, 4, 28, 4, 53,
    -7, 4, -29, -19, -7, 2, -23, 40,
    21, -33, 13, 39, 1, 15, 15, -3,
    -49, -15, 13, -14, -4, 12, 4, 8,
    26, -42, -12, -12, 41, 6, -11, 10,
    25, -7, 13, 25, 19, -5, 20, -13,
    -10, -7, 22, -8, -1, -2, 3, -5,
    -5, -3, -8, -30, -8, 13, 5, 33,
    39, -23, -46, -36, 19, 66, -3, -8,
    31, 9, -24, 12, -3, -27, -3, -6,
    -3, 10, -30, 7, -14, -18, 3, -10,
    -24, -5, 6, -29, -1, 41, -41, 45,
    80, -17, -8, -48, 34, -11, 11, 2,
    6, -58, -24, 29, -1, -4, 8, 10,
    27, -8, -3, 18, 17, 18, -4, -4,
    28, -5, 7, 16, -2, -11, 2, 31,
    -2, 8, 14, -7, 0, 30, 31, -25,
    24, 2, -16, -20, 8, 14, 17, 49,
    -16, 4, -11, -29, 8, -6, 4, 25,
    -31, -9, -2, 18, -1, 4, 19, -13,
    -29, 8, 12, -10, -4, 24, -57, -2,
    11, -20, 1, 11, -17, -9, 19, -9,
    17, 17, -30, 2, -5, 7, 16, -6,
    -16, 29, 43, 22, -6, -6, 41, 54,
    -24, -10, -28, 13, 30, 45, 5, -40,
    -33, -17, 0, 12, 49, 14, -18, -49,
    -18, 5, -30, 39, 1, -2, -9, 11,
    -31, -51, -3, -14, -13, 0, -13, 0,
    8, -30, -13, -2, -11, -9, -25, 2,
    14, -12, 21, 28, 14, 3, -1, 0,
    -19, 11, -17, 20, 2, 31, -25, -16,
    -5, -28, -4, 57, 14, 13, -8, -31,
    30, -35, 33, 16, 24, -12, -24, 9,
    9, -11, -14, -12, 4, 0, -4, -48,
    11, -22, -11, -20, 8, -20, 1, -7,
    -16, 19, -15, 4, -15, -5, 27, -12,
    13, -39, -3, -24, -4, 11, -7, 13,
    32, 22, 5, -14, -12, 38, -3, -14,
    -20, -8, -15, 28, 10, 14, -6, -4,
    -36, -12, -16, 1, -47, -4, 12, -49,
    47, 19, 7, 47, -21, -8, -5, -17,
    -8, 17, 21, -28, -16, -6, -15, 18,
    17, -2, 24, 15, -15, 17, 13, -4,
    -42, -9, 4, -23, 5, -27, -18, -16,
    26, 6, 15, -29, -17, 68, -5, 5,
    -17, 9, 21, 9, -4, 0, 14, 17,
    39, 10, 14, 3, 1, -6, 3, 13,
    17, -53, 18, -21, -5, 29, -4, -5,
    17, 22, -80, 20, 0, -2, 17, -9,
    25, 34, 16, -41, 1, -19, 7, -19,
    -2, 12, 14, -7, 0, -9, 43, 16,
    0, -16, 18, 1, -5, -20, 15, 30,
    -12, 0, 4, 5, 15, -36, 16, -7,
    -7, 5, 20, 7, 13, -2, -17, 15,
    12, 42, 3, -2, 0, 11, 6, 1,
    32, 3, -6, 15, -16, 4, 15, -11,
    49, -1, 13, -1, 24, -53, 3, 17,
    10, -15, -57, 24, 26, -15, 9, 10,
    1, -44, -19, 22, -3, -2, -7, 16,
    -27, 0, 2, -7, -4, -6, 24, -10,
    -3, 36, -13, -21, 8, -47, 30, -1,
    11, 28, -37, 6, 11, -19, 49, -5,
    0, -25, 1, 29, 18, -7, 17, 1,
    -12, -6, 19, 43, 29, 7, 25, -12,
    -24, 55, 29, -5, 12, -17, 26, -88,
    -12, -14, 8, -13, -2, 14, 20, -20,
    -20, 8, -14, -31, 35, -1, 22, 10,
    -4, 26, 2, 2, 3, 28, -13, -76,
    -31, -12, -44, -1, 39, -28, 7, -3,
    9, 22, -4, 27, -18, 10, 16, -6,
    16, 3, 38, 26, -2, -18, 22, 13,
    -4, -33, -5, 21, 0, -58, 25, 11,
    17, 27, -12, -9, 14, -1, 26, 29,
    22, 17, -22, -5, 12, -17, -20, -23,
    -27, 18, 35, 32, -2, -9, 10, 15,
    -22, -43, -2, -7, -1, -11, -35, -27,
    -16, -9, 3, -12, 35, 3, -17, 10,
    -30, 22, 3, 1, 15, -1, -6, 6,
    -7, 23, -20, 13, -11, 79, -12, -8,
    -1, 25, 1, 30, 33, -5, -3, -5,
    -31, -9, 43, -28, -10, -4, -11, -8,
    -9, 9, -31, 12, -4, -34, -2, 8,
    20, 5, -15, -1, -1, 22, 4, -5,
    20, -23, 10, -15, -41, 49, -22, -14,
    17, 33, -22, -26, 47, 17, 45, 24,
    8, 10, -3, -49, 23, 5, 3, 35,
    -7, 11, 10, 13, 3, -11, -17, 19,
    3, -12, -20, 28, -26, -3, 20, 7,
    39, -24, 18, -11, 36, -35, 35, 36,
    37, -4, 17, 22, 18, -23, -18, 2,
    45, -32, 27, -20, 6, 17, -6, -10,
    -23, -27, 14, 13, -25, 16, 47, 0,
    47, -9, 1, -20, -2, -17, 13, -40,
    -30, -39, 6, -12, -16, -12, 38, 23,
    31, -4, -42, 16, 7, 13, 1, -1,
    -38, -51, -18, 9, 7, 8, -31, 19,
    10, -32, 35, -2, 26, -26, 0, -39,
    -27, 12, -11, 31, -28, -22, 41, 15,
    19, 2, -2, 0, 3, 1, -15, 8,
    7, 12, -12, -34, 4, 2, 36, 6,
    4, 20, -22, -55, -1, -13, 24, 72,
    19, 33, 26, -5, 1, -4, -3, -9,
    9, 4, -1, 32, -7, -43, 62, -15,
    0, -25, -28, -23, -2, 21, -21, 64,
    -24, 33, -7, -8, 2, -72, 51, 8,
    10, 0, 26, -15, -11, -11, -44, 25,
    7, 23, 5, 16, -1, 24, 4, 6,
    27, -5, 5, -11, 9, 13, -3, 19,
    40, 0, -26, -9, 9, 4, -43, -8,
    33, -4, 38, -13, 12, -1, 0, 24,
    -63, 11, -1, -19, 16, 13, 4, 5,
    -12, -12, 22, 15, -2, 9, 1, 10,
    14, 10, 1, -19, -27, 45, -11, -16,
    13, 0, -30, 26, -25, -28, 4, 24,
    6, 23, 1, -8, 3, -4, 2, -1,
    -20, 28, -14, 23, 36, -5, -19, -16,
    -14, -27, 4, 25, -43, -20, -26, -44,
    -7, 10, -25, -2, 0, -5, -24, -21,
    7, 22, -20, -8, 3, 13, 31, 16,
    -11, 0, 2, -28, 27, -30, -2, 3,
    14, 9, -13, 21, -2, 2, -8, -42,
    14, 5, -17, -34, 18, -17, -13, -13,
    -10, -9, 8, 7, -7, -3, 31, -31,
    20, -12, 15, -18, -47, 14, 15, -31,
    23, 12, 30, -13, 1, -14, -4, 16,
    -4, 5, 12, -32, -10, -4, 16, -39,
    1, 2, -4, 47, 2, 20, -13, 0,
    41, -7, 29, -14, 2, 12, -26, -5,
    -24, 23, 41, -21, -13, 26, -32, 7,
    1, -36, 3, -7, -22, 20, 32, -2,
    29, -50, 17, -1, 5, 20, 9, 21,
    11, -9, -10, 1, 12, 40, -23, 3,
    -3, -15, -9, -1, 23, -1, -1, 12,
    -19, 11, 1, 15, 54, 18, 8, 16,
    29, 7, 6, -4, 7, 4, 1, -37,
    -19, 13, 9, -8, 2, 19, 73, 21,
    22, -31, 33, -14, 14, 44, -50, -3,
    17, -1, -40, 13, -20, -24, -8, -18,
    -10, 1, 15, -6, -10, 2, -10, -9,
    -27, 7, 12, -34, -29, 22, -3, 26,
    36, -14, -1, -31, -7, -1, 0, 2,
    -31, -18, -6, 38, -35, -3, -8, 0,
    38, -17, -12, 10, -2, 12, 2, 20,
    -5, -9, 8, 12, -26, 15, -30, 66,
    -9, 84, 3, -88, 37, -22, -13, 23,
    -42, -44, 14, -10, 38, -40, -15, -39,
    -4, 1, -10, -24, 5, -22, 12, 16,
    -19, 36, -63, 85, 25, 27, 27, 2,
    -41, 44, 21, 18, 22, -52, -21, 5,
    3, -39, -8, -42, 15, -15, 37, 59,
    79, 45, -41, 2, -20, -1, -14, -2,
    11, 15, 23, 63, 31, -6, 76, 53,
    -57, 0, 60, 28, 60, 11, -127, 48,
    1, -31, 30, 8, -1, -4, 12, 2,
    -28, -21, -39, -9, -29, 9, -17, -11,
    5, 17, -12, -20, 24, 6, 3, -1,
    31, -78, -2, -10, -21, -37, -64, 6,
    -31, -2, 29, 8, -60, 10, 19, -14,
    -47, -12, -49, 5, 14, 22, -2, -5,
    42, -13, -23, -7, -66, -12, 7, -10,
    32, -21, 3, 84, -55, -70, 35, 34,
    59, 61, -70, 17, 7, 2, 33, -18,
    -3, -30, -3, -78, 29, 3, -38, -19,
    -45, 7, -11, 37, 6, 11, 22, -46,
    -46, 13, 17, -47, 69, -23, 51, -32,
    -76, -48, 20, 17, 44, 37, 2, -21,
    -47, 9, -17, 17, 31, 27, 24, 16,
    -22, -17, 5, 19, 55, -8, 75, 2,
    58, 22, 47, 29, 65, -10, 1, 79,
    -1, -2, -53, -30, 25, 20, 29, 22,
    -2, -1, 48, 2, -24, 21, 7, 47,
    -96, 29, 29, -77, -16, -10, -44, 13,
    21, -47, -20, -64, 19, 16, -34, 47,
    -17, 10, 5, 46, -22, -1, -3, 3,
    38, 4, 3, -16, -10, 6, 10, 1,
    -2, -78, -10, -5, -25, 5, -25, -17,
    10, 11, -21, 22, -6, -13, -3, 0,
    50, 31, -60, -25, 4, -22, 8, -6,
    -12, 2, 20, -10, 4, -16, 52, 33,
    -5, -28, 8, 20, -34, -15, 16, 38,
    -49, 37, -6, -16, -37, -12, 5, 17,
    9, -27, -27, 13, -2, 2, 17, 9,
    15, 37, 12, 14, -20, 21, 21, 4,
    27, 2, -26, 30, -35, 20, 42, -23,
    45, -33, 19, -27, 46, 16, 49, -15,
    -22, 95, -4, -1, 17, 10, -5, -9,
    -11, 5, -45, 11, -14, -8, -35, 34,
    -19, -68, 40, 47, 11, -44, 44, -26,
    16, 30, -10, -1, -6, -15, -40, -78,
    -10, -43, 57, -27, 14, 29, -32, 5,
    6, -53, -80, 38, 46, -19, 37, 29,
    20, -21, 37, 59, 72, -9, 36, -45,
    -46, -20, 49, -32, 10, 43, 34, -56,
    33, 8, -50, -42, -15, 17, -14, 1,
    0, -27, -65, -37, 55, -6, 10, 21,
    -25, 11, -10, -41, -6, -20, 65, -96,
    66, 11, -3, -34, -35, 0, -32, 25,
    -35, 45, 0, 8, 8, 4, -50, -17,
    44, -11, 13, -12, -19, -45, 41, 19,
    -73, -44, 16, 41, 17, -17, -17, 27,
    -39, 5, -21, 20, 50, -11, 22, 24,
    48, 19, -47, 7, -13, 7, -13, -34,
    -59, 56, 17, 110, 6, -53, 9, 51,
    1, 6, -2, 63, -14, 4, 7, 15,
    1, -25, -5, -48, -3, 30, 19, 53,
    -33, -3, -58, 40, 70, -45, 13, 6,
    9, -1, -65, -14, -58, 127, -5, 5,
    -25, 14, -15, 7, 39, 9, -18, 20,
    -37, 9, 20, -49, 5, -29, 62, 24,
    21, -16, 8, 1, 17, 12, -43, 40,
    15, 36, -46, 14, -15, 9, 5, 37,
    -9, -62, -17, -7, 9, 42, 24, -13,
    -61, 9, -56, -73, 65, -8, 68, -60,
    -27, 37, -27, 38, 19, -27, -26, -11,
    25, -23, -17, 15, -24, -7, -5, -12,
    -35, -35, -38, 39, 20, -16, -24, 11,
    42, 36, 3, 15, -28, 16, 38, -3,
    15, 19, -48, -16, -9, -28, -21, 29,
    52, -41, 5, -25, 15, 21, -4, -32,
    -49, 42, 70, -47, 15, -4, -12, 45,
    15, -30, -18, -109, 44, -43, -10, 38,
    27, -8, -54, 40, -44, -85, -19, 29,
    36, 7, 7, 43, -8, 37, -39, -28,
    -63, -66, -45, 17, 18, 9, -1, 55,
    23, -36, -26, 13, 13, -12, 31, -9,
    -24, 29, -28, -8, -17, -70, 11, 57,
    31, 1, -20, -1, 6, 13, -9, -2,
    -21, -2, -47, -33, 29, 30, 7, 57,
    20, 11, -25, -77, 32, -11, -24, 22,
    -2, 26, -25, 55, 44, -1, -2, 35,
    -35, 2, 6, 97, 4, -40, 58, 22,
    -22, 26, -15, 8, 13, 0, -41, 0,
    -22, -29, -20, 53, 1, 2, -25, 14,
    5, -6, -30, -13, -35, 76, -19, -52,
    19, 34, -13, -9, -20, -19, -59, -9,
    24, 61, -9, 3, 2, -13, 16, 24,
    101, 13, -14, -9, 2, -19, 21, -55,
    -37, -17, 40, 22, 12, -24, -15, -20,
    -127, 2, 33, -26, -22, 20, 12, 23,
    60, 49, 19, 24, 17, -17, -16, -24,
    -22, 72, -45, -33, -23, -50, -5, -40,
    50, -7, 1, 31, -5, -28, 40, 15,
    -66, 34, 5, -8, 7, 33, 4, -14,
    -63, 26, -11, 38, -27, 5, -66, -20,
    -21, -40, 38, -28, -67, -23, 25, 54,
    65, 53, -20, -13, 9, -26, -41, 0,
    -20, 50, -53, 56, -3, -5, 50, 38,
    -15, -28, 16, 33, 20, -26, 16, -71,
    7, -26, -25, 28, 10, 5, 20, -47,
    2, -11, 30, 99, 19, -27, -40, 6,
    -31, -1, -11, -6, -9, 5, 71, -44,
    28, -4, 27, 30, -37, -12, -28, -37,
    2, 59, -1, -36, 8, 5, -40, -16,
    6, -21, 41, -28, -17, -12, -12, -30,
    -2, -15, -31, 64, 0, 28, -7, -15,
    14, 53, 13, -7, -22, -19, 2, -11,
    -44, 35, 88, -58, 14, 69, -23, 45,
    -6, 21, 16, -9, -76, -2, 72, -5,
    12, -63, -7, -22, -4, 38, 8, 41,
    29, -23, 10, 24, -37, 58, -20, -23,
    -38, -4, -37, 1, -48, -15, 23, 19,
    66, 15, -4, 12, -26, 23, 0, 22,
    55, 19, 40, -24, 31, 2, -35, -47,
    -51, -3, -59, 13, 21, -23, 24, 44,
    20, -11, 28, -2, 64, -33, 83, -14,
    39, -8, 29, 20, -97, -5, 7, 28,
    -25, -2, -19, -23, -15, 1, -15, 1,
    -14, -26, -3, -9, 17, 20, -32, 58,
    4, -11, -29, -48, 32, -4, 26, 8,
    25, 11, 4, 12, 49, 17, -17, 11,
    5, 9, 5, 17, 6, -4, -42, 15,
    -18, 8, -56, -13, 41, -21, 5, -30,
    -16, -11, 27, -17, 1, 1, -8, 1,
    -4, -5, -8, 9, -22, 16, 6, 18,
    13, -8, -2, -12, -1, 3, -11, 0,
    57, -18, 6, 25, -36, 20, 3, -17,
    35, 30, -2, 5, -14, -13, 15, 8,
    9, 8, -5, 11, 7, -1, 27, -30,
    -4, -8, 9, -21, 35, -33, -12, 13,
    3, 27, 6, -27, 24, 34, -35, -56,
    -4, 65, 37, -16, -7, -4, 11, 34,
    -10, -1, -2, -11, -57, 0, 47, -48,
    1, -13, -10, -34, -19, 38, 18, -16,
    13, -20, 0, 18, 10, 27, 12, 0,
    6, -2, -3, -1, -11, -5, -10, -14,
    22, -5, 5, 5, -77, 21, 11, -26,
    -6, -13, -2, -6, 28, 6, 14, 23,
    14, -5, -24, -5, -51, -18, -2, 14,
    -17, 11, 14, 15, -15, -11, -12, 1,
    6, 1, 6, -7, -4, -33, 0, -18,
    2, 11, 13, 3, -6, 4, -4, -6,
    -32, -19, -2, 2, -4, -9, -10, 61,
    -32, 7, -19, 36, -19, -17, 14, -25,
    5, -11, 9, -12, 27, -7, -19, 2,
    -3, 2, 8, 3, -14, 17, 20, 11,
    -3, -20, -35, 52, 9, 10, -32, 13,
    -22, -11, 19, 33, 37, 21, -1, 0,
    10, 8, -8, 8, 54, 12, 26, -5,
    -11, 14, 31, 31, 9, 15, -31, 4,
    -22, -5, -36, -25, 33, 48, 20, 17,
    -35, -1, 17, -7, 18, -18, 6, 13,
    -8, -4, -1, -13, 6, -2, -10, -24,
    5, -13, 9, 3, -15, -19, -9, 31,
    7, 13, -20, -3, 8, 1, 36, -28,
    -6, -1, 29, -7, 1, -2, -17, -6,
    -6, -11, -8, -6, 44, 5, -26, -1,
    -11, 12, -20, 4, 6, 5, -8, -8,
    -41, -3, -29, 33, 20, -1, -12, -25,
    21, -36, -22, 11, 7, 18, -13, 4,
    4, 6, -10, 3, 2, -28, 14, 21,
    11, 1, -16, 24, -24, 7, 29, 16,
    2, 18, 14, 44, 38, 21, -7, -2,
    33, -14, -25, -25, -5, 17, 11, -10,
    7, 8, 5, 7, 7, 66, -32, -10,
    11, 14, 10, -12, 15, 0, -12, 21,
    -2, -24, -8, 4, -6, 17, -58, -7,
    -5, -7, -11, 1, -6, 2, 7, -9,
    -3, -3, 7, -5, -33, 3, 5, 13,
    -3, 18, 8, -5, -9, -13, 6, -26,
    -16, -7, -2, -32, 35, 23, -36, -24,
    22, 19, -21, 5, 13, 2, -10, -8,
    5, 17, 7, 0, -27, -3, 31, -27,
    12, -8, -15, -9, -5, 2, 1, -7,
    34, -38, 9, 3, -43, -22, -36, -44,
    -17, 4, 2, -3, -25, -10, 21, -9,
    7, -3, 11, 7, 5, 7, -36, 23,
    1, 5, -10, -8, -11, 20, 2, 13,
    15, -33, -24, 4, -8, -8, 5, -53,
    -13, 3, 19, 20, 5, 15, -13, 6,
    -7, 0, -5, 13, -41, 6, 20, 0,
    13, -9, -14, 21, 23, 21, -3, -3,
    -14, -17, 15, -24, -29, -36, 23, 19,
    -21, -39, 12, 4, 16, 3, -15, 14,
    -11, 18, 8, 2, -16, -4, 26, -38,
    -1, -22, -11, 6, 12, 20, -7, -11,
    7, -67, -41, -33, -7, -26, -13, 12,
    5, -10, -32, 16, 2, -19, -6, 18,
    -9, -4, -16, -3, 36, -3, 33, 22,
    -2, -45, 11, -7, 7, 2, 7, -1,
    -34, -28, -12, 1, 3, 21, 56, 22,
    -11, -16, 3, -28, -23, -19, 7, 10,
    -6, -8, -3, -1, -34, -28, 9, 17,
    8, 1, 10, 14, -28, -28, 1, -12,
    -48, -14, -21, 47, 31, -22, 2, 14,
    18, 20, -20, 30, 19, 9, 1, 1,
    0, 0, -3, 6, 23, 1, -62, -3,
    -22, -15, -8, 11, -24, 34, -4, 6,
    -5, -9, -66, 6, -6, -10, 2, -13,
    17, -20, -9, 52, -23, 2, -29, 0,
    -2, -11, -12, 1, -29, 25, 28, -12,
    -25, 1, 9, 26, 17, -3, 9, 19,
    -16, 31, 14, -7, 11, -5, -31, 10,
    2, -8, 31, 9, -7, 10, 16, -7,
    10, 5, -6, 0, 7, -16, 20, 14,
    5, -86, -6, -16, -9, -11, -21, 7,
    -18, 55, 9, -17, 27, 2, -42, 3,
    8, 12, -7, -7, -25, 6, 2, 20,
    -15, 9, 6, 27, -7, 1, 14, 30,
    3, 32, 12, -8, -11, 17, 23, 20,
    0, 27, 32, 2, -24, -9, 40, -31,
    29, -26, 22, -21, -24, -11, -10, 26,
    -6, 13, 5, 10, -11, 24, -60, 0,
    28, -7, 0, -8, -14, 3, 5, 28,
    -12, 13, 10, -15, -47, -2, 22, 4,
    13, -21, -24, -39, 2, -5, -11, -12,
    13, 0, 5, -4, -39, -2, 74, -22,
    -9, -14, 19, -19, 11, -4, -16, -6,
    14, 12, -2, 25, 14, 9, 11, 14,
    -21, -4, 41, -19, -6, 8, 9, 7,
    12, 5, 8, 8, -6, 16, 11, 21,
    -13, -9, 9, 10, 29, -22, 4, -3,
    -65, 10, 28, -13, -11, -4, 36, -8,
    -28, 22, 18, -12, 15, -9, 6, -4,
    -1, -4, 7, -5, -16, 44, -33, -15,
    -4, 5, -4, -8, -15, 6, 10, -11,
    33, -9, 39, -8, 10, 10, 38, -12,
    23, 36, 0, -17, 11, 15, 4, -2,
    -4, 0, 5, 6, -14, -10, 25, 70,
    -22, 7, 0, 5, 9, 9, -19, -7,
    -13, 5, -7, 60, -37, -34, -41, 34,
    -20, -10, 25, -3, -5, 16, -11, 10,
    1, 0, -5, 16, 11, -24, 7, 5,
    19, -25, -25, 34, -10, -2, -4, 10,
    -10, 34, 48, -21, 45, 15, 16, -3,
    -4, 19, 19, -31, 30, 35, 12, -20,
    22, -3, 4, 2, 33, 7, 2, 22,
    3, -15, 77, -30, 0, -13, -5, 19,
    35, 3, -43, 7, -50, 32, 24, 10,
    -27, -2, -14, 13, 3, -2, 3, 8,
    18, -4, 0, -8, -43, 11, 4, 23,
    -4, -14, 11, 26, -19, 18, -2, 8,
    1, -20, 15, -3, 17, 18, -18, -12,
    6, 7, -11, -29, 16, 0, -17, -1,
    13, 0, -13, -10, -7, 4, 23, 23,
    -5, -8, -4, -20, -6, -5, 28, 27,
    2, -2, 19, 11, 12, -13, -32, -39,
    -20, -2, 28, -19, 28, 20, -1, 5,
    3, 1, 7, -4, 19, -22, 12, -4,
    1, -7, 10, -35, 34, 11, -13, 17,
    2, 29, -61, -15, -32, 10, -22, -31,
    10, -6, 12, -44, -6, -5, -11, -11,
    -10, 22, 1, 10, 10, -25, 20, -7,
    -3, -15, 2, 5, -3, 4, 1, -10,
    6, 26, -21, 19, -39, 32, -16, -12,
    3, 45, -4, -13, 2, 11, -4, 19,
    2, -9, -15, 3, -11, -19, 0, 16,
    -18, 0, 1, -8, 23, -15, -6, -3,
    -26, 0, -14, 9, 4, 62, -27, -56,
    -12, 35, -4, 61, -13, -17, 23, 34,
    4, 0, -3, -13, -25, -30, 29, 10,
    -21, -7, 7, -44, 3, 30, 1, -35,
    -12, -35, -3, 45, -7, -19, 22, -7,
    -12, -24, -35, -13, -15, 13, -13, -6,
    25, 3, -1, -30, -48, -10, -3, -12,
    5, 38, 0, -5, 25, 27, 17, 2,
    -9, 0, 15, -13, -20, -9, -25, 35,
    -6, 18, 12, 16, -3, -30, -10, -25,
    -1, 23, -1, -22, 26, 6, -5, 18,
    17, 9, 4, -12, -37, 8, -22, 22,
    -11, -6, -17, 65, -15, 11, 21, 12,
    -42, 18, 8, -22, -49, -32, 0, -33,
    -7, 19, -2, -15, 3, 2, 14, -8,
    -6, -4, -2, 8, 12, 12, -26, 30,
    8, -6, 8, -12, -12, 28, -44, -45,
    -20, -17, 33, 26, 8, 24, 2, 2,
    8, -1, -5, 9, -43, -22, -28, -6,
    -14, 11, -2, 41, 34, 12, -3, 1,
    11, -30, -12, -15, -24, 30, 0, 0,
    -33, 10, -14, 23, 11, 7, -6, 20,
    -8, -1, -2, -18, 5, -25, -18, 10,
    5, 1, 15, -8, -11, -9, 8, 29,
    16, -14, 5, -19, -31, -8, 50, 5,
    -11, -3, 48, 5, 9, -37, -3, 7,
    -1, -12, 2, -1, 44, -11, -16, 3,
    -11, 6, -20, 11, 2, 4, -23, -6,
    -53, -5, 1, 45, 6, 41, -8, -6,
    3, -15, 4, 1, -8, 2, -5, 0,
    1, 4, -5, -4, -65, 24, -24, 29,
    5, -3, -30, 52, -27, -23, 14, 31,
    -13, 16, -14, 24, 18, -51, -49, 0,
    42, -41, -10, -5, 25, -8, 22, -19,
    -8, 3, 4, 5, -28, 81, 10, -1,
    -2, 16, 1, -9, 2, 29, -17, 22,
    -11, -12, 13, 6, -2, -12, 28, 3,
    -2, -23, -7, -15, 19, 26, 30, 5,
    8, 3, 4, -2, 33, 48, 17, -55,
    2, 24, 17, -12, -21, 26, 11, -16,
    -22, -33, -10, -25, -52, -29, -29, -46,
    -5, -26, -24, -28, 14, -11, -14, 8,
    1, 20, -4, 11, -13, -21, 48, 37,
    28, 12, -8, -5, -5, -27, -12, -5,
    10, 5, -23, 22, 25, 27, -38, -19,
    22, 11, 21, 10, -24, -5, 30, 2,
    4, 0, -12, 16, -4, 42, 10, 9,
    -3, -4, -17, -8, -22, -8, 3, 27,
    -34, -20, -18, 5, 16, 58, 6, -4,
    -1, -35, 25, 32, 20, 10, 6, 26,
    0, 1, -8, 15, -27, 58, -18, -27,
    7, 14, -8, 10, 22, 1, -7, 22,
    33, -25, 37, -5, 36, -43, 15, -24,
    -14, -30, 6, 22, 9, -13, -39, 66,
    -4, 3, 8, 4, -8, -21, 5, -31,
    1, -2, -2, 3, 25, 11, -4, 6,
    7, 17, -2, -50, -13, 11, -19, -1,
    15, -2, -33, 38, 0, -5, 48, 25,
    1, -2, 0, 0, 0, 32, 85, -42,
    -2, -57, 1, -4, -2, -22, -6, -23,
    -11, -17, -9, -17, -13, -8, 58, 28,
    -19, 0, 12, -28, -25, -34, 0, -8,
    -8, 4, -6, 3, -6, -11, -34, -48,
    9, 18, 2, -8, -38, -24, -10, 5,
    -11, -24, -10, 50, 4, 33, -51, -13,
    51, 21, 27, 5, 22, 14, 16, 2,
    4, 5, 0, 3, -26, 11, -80, -17,
    -30, -14, -2, 17, -16, 18, 7, -10,
    5, -6, -37, -17, -48, -42, -18, -53,
    12, -26, -27, 43, -16, -34, -40, 3,
    12, 4, -11, -9, -33, 9, -35, 17,
    -6, 0, 9, 11, 29, 34, 12, 0,
    45, 39, 0, -4, -15, -44, 48, -1,
    44, -43, -22, 32, -2, -19, 6, 10,
    8, 1, -13, 7, 36, -24, -45, -24,
    0, -100, 5, -24, -9, -5, 19, 7,
    41, 62, 32, 3, 18, -33, -23, -10,
    -9, -5, 4, 13, -1, 9, 2, -8,
    -11, 1, 7, 27, -6, 32, -23, -22,
    30, 32, 15, -14, -3, 24, -14, 4,
    -26, 1, 50, 9, -17, -17, 24, 9,
    15, -32, -7, 20, 4, -33, 2, 18,
    2, -14, -16, -4, 46, 35, 0, -13,
    15, -2, -3, -2, -22, -6, 23, 31,
    -13, 11, 7, 0, -39, 28, 1, -26,
    12, 0, -19, -43, 5, 0, -7, 3,
    -13, -1, 6, 1, -4, -17, 16, -30,
    -19, -7, 17, -10, 12, -5, 1, -10,
    -43, -14, -6, -11, -25, 33, 49, -6,
    -17, 29, 28, -29, 9, 4, 43, -2,
    4, 3, 0, 2, 30, 10, 38, 41,
    -10, 2, -3, 3, -1, -23, -37, -2,
    -27, 11, 43, -38, 61, -16, 16, -21,
    4, 13, -7, -3, 15, -20, 35, 13,
    7, 1, 6, -16, -22, 15, -25, 20,
    8, -3, 9, 0, -9, 20, 25, -25,
    16, -27, -8, -17, 32, 18, -9, -24,
    -1, 41, -12, 15, -2, -2, 4, 14,
    -4, 6, -3, 0, -9, 24, -15, 39,
    -16, 25, 6, 14, 9, 22, -19, -3,
    -11, 8, -5, 37, -5, -23, -7, 32,
    -3, -11, 25, -9, 5, -2, -4, -9,
    1, 2, -4, -4, -15, 2, 20, 8,
    21, -4, 26, 19, -8, 8, 15, -1,
    18, 3, -3, -14, 41, 0, 12, 55,
    20, 21, 4, -39, 18, 60, 7, -16,
    39, 24, 2, -4, 22, 15, -28, 41,
    3, -4, 65, -20, 35, 13, -10, -13,
    38, -3, -13, -68, 25, 36, 34, 9,
    -3, 9, -29, 8, -11, 25, 7, 5,
    -9, 1, 1, 0, -50, -14, 17, 15,
    -5, -20, 15, 7, -29, 2, 19, 2,
    16, 10, -4, -6, 20, 33, -21, -16,
    7, -4, -37, -7, 14, -4, 8, -5,
    20, 1, -2, -12, 0, -15, -5, 39,
    13, -23, 3, -18, 12, -2, 25, 23,
    38, -2, 30, 1, 13, -7, 19, -20,
    -3, -18, 48, 6, 28, 29, 5, 13,
    3, -4, -5, 2, -14, 15, -7, -4,
    13, -12, 9, -19, 41, -6, 8, 6,
    -2, 8, -83, 21, -29, -49, -28, -21,
    16, 4, 26, -66, 15, 0, -27, -18,
    -19, 6, 6, 6, 21, -19, -1, -3,
    2, 10, -7, -6, 22, 9, 2, -13,
    -30, 30, -30, -21, -19, -12, -25, -46,
    -42, 79, 37, -36, 21, -6, -14, 58,
    -17, -14, -7, -4, -12, -17, 3, 25,
    -35, 3, 14, -1, -2, -32, -19, -4,
    -33, -41, 22, 22, -18, -35, -5, 109,
    -10, 62, 0, 69, 3, -36, -16, 61,
    38, 6, 29, -25, -43, -14, -25, 24,
    -40, 3, 14, 3, 0, 56, 3, -39,
    52, -22, -2, 33, 25, -51, 77, 29,
    -34, -15, -45, -38, -41, 28, -18, 8,
    51, -10, -12, -55, -3, 40, 16, -33,
    13, 28, 11, 1, 90, 11, 15, -6,
    25, 36, 4, 63, -13, -1, -34, 60,
    -15, 39, 17, -24, -2, -32, 3, -22,
    -7, 20, 0, 0, 8, 45, -51, 27,
    6, 5, -3, -9, 18, -14, -14, 30,
    -5, -28, 18, 87, -14, 49, 115, -86,
    -80, -26, -17, -31, -54, -72, 21, 22,
    -35, 0, -1, -31, 6, 37, -28, 2,
    -15, -4, -5, -8, -19, 2, 1, 4,
    -25, 8, 14, -28, -81, 40, 122, 7,
    -44, 3, 54, 10, 10, 40, 7, 3,
    25, 8, -17, 2, 33, 16, -91, 67,
    -4, 21, -5, 34, 11, 0, -13, 2,
    5, -41, -35, 5, 21, -24, -36, -17,
    9, 75, -1, 30, 0, -1, 12, 73,
    -9, -5, -6, -2, -16, -1, -18, 64,
    -1, -12, 5, -8, -5, 33, 24, 24,
    2, -8, 30, -37, -30, 24, 33, 21,
    10, -14, 21, -11, 13, -47, 2, -3,
    2, -28, 7, -9, 59, -44, -9, 26,
    -15, 0, -23, 25, 6, 29, -7, -6,
    -94, -18, -9, 63, -25, 66, -31, 16,
    45, 5, 30, 7, -12, -31, 9, 0,
    -23, 18, -15, -10, -42, 1, 3, 45,
    -10, 2, -6, 64, -42, -10, 4, 19,
    -12, 18, -14, -1, -79, 61, 27, -48,
    94, -6, 19, -26, 85, 0, 18, -30,
    3, 0, -7, 6, 46, 38, 2, 21,
    -14, 6, 2, -22, -34, 27, -15, 32,
    -16, 60, 7, 9, 7, -77, -29, -42,
    1, -62, 43, -43, 26, 77, 41, 13,
    31, 20, -10, 9, 14, 52, 64, -16,
    -16, 21, 7, -19, -9, -6, -1, -6,
    30, -51, 18, 4, -14, -11, -51, 37,
    44, -32, -57, -67, 1, -22, -24, -17,
    -19, 17, 4, 16, -1, 27, 37, -8,
    16, 27, 3, -15, 4, -38, 12, -17,
    -19, -59, 66, 3, -18, 35, -100, -14,
    -40, -2, -5, 3, -35, -3, 19, -1,
    7, 23, -37, -12, -43, 25, 44, 1,
    4, 10, -5, -11, 36, -1, 26, 55,
    -17, -39, -28, -16, 9, 8, 35, -12,
    64, 15, 2, 51, 27, -8, -12, 22,
    1, 13, 13, 27, 10, -29, -8, -15,
    -8, -25, -9, 1, 14, -31, -9, 12,
    -1, 16, 37, -20, 3, 21, -14, -12,
    -22, -46, -30, 17, 2, -22, -42, 127,
    2, -8, -11, 13, -9, 7, 19, 81,
    17, -8, 4, -16, 20, -21, -14, -11,
    -17, 51, 53, -17, 4, 38, 26, 41,
    22, -3, -72, 30, -16, -16, 39, 40,
    3, -2, -8, -9, 33, -14, -33, -52,
    -16, -51, -3, -22, 15, -39, 22, -20,
    -55, -21, 1, 22, -53, -37, -36, 22,
    -24, -9, -4, -70, -63, -36, 2, -31,
    -10, 14, -31, 0, -15, 10, 10, 12,
    -16, 22, -14, -12, -7, 5, -26, -36,
    -87, -26, -11, 50, 18, 41, -54, -10,
    2, 9, -44, 21, 47, 1, -18, 14,
    -13, 19, -13, -12, -17, -31, -31, -52,
    -37, -3, 4, 19, -11, 22, 5, -1,
    1, 11, 51, -20, -68, -29, 52, -77,
    -66, -45, 9, 17, -23, -29, -48, -25,
    38, -6, -11, -14, 18, 10, 2, 6,
    -2, -26, 16, -24, 3, 26, -7, 28,
    0, 38, 21, 3, 13, -61, 50, 56,
    69, 0, 2, 20, -1, -14, 3, -16,
    4, -4, -18, 8, -15, -19, 63, -21,
    -4, -125, 21, -19, -10, -4, 40, 2,
    16, 69, 57, -71, 88, -42, -40, 20,
    -51, -6, -12, 68, -22, 5, -9, -46,
    -11, -5, 23, 11, 13, 48, -40, -68,
    3, 36, 32, -3, -2, 21, -20, 21,
    -34, 0, 92, 34, -43, 54, 27, -67,
    16, -20, 22, 15, 6, -70, -27, 1,
    13, -58, -21, 4, -1, 13, 38, -11,
    -4, 22, 29, 4, -38, -91, 62, 40,
    -18, 13, -9, 26, -77, 28, 44, 12,
    35, -3, -8, -14, 49, 7, 1, 17,
    12, 3, -11, 1, 38, 4, -27, -49,
    1, -19, 23, 1, 15, 3, -15, -7,
    14, 30, -34, 1, 35, -13, 37, 14,
    22, 55, 127, -29, 14, 25, 68, 0,
    -8, -3, 26, 6, 1, -16, -39, 71,
    -27, -5, 10, -7, 39, -20, 42, 4,
    45, 14, -31, -6, -13, 25, -10, 46,
    -40, 46, -45, 29, 20, -47, 45, 9,
    19, 24, 10, -23, -13, 6, 37, -48,
    28, -24, 6, -30, -26, 39, -7, -39,
    11, 27, 19, -16, 0, 1, -3, 39,
    -13, 3, -3, 66, 1, -8, 5, 12,
    5, 5, -24, 24, 39, 33, -8, -36,
    -20, 12, 3, 8, 7, 5, -10, -41,
    6, 37, -20, 2, 14, 7, -26, 2,
    -3, -63, 6, -43, 9, -6, 43, -3,
    -3, 0, 17, 3, -31, -23, 16, -7,
    17, 13, 18, 15, -26, 4, 23, -5,
    5, -19, -53, -32, 34, -23, 19, 66,
    36, 60, 2, -52, -8, 79, -12, -28,
    67, 62, -1, 0, 4, 42, -29, -45,
    -14, 22, 71, -26, 51, 5, -13, -27,
    20, -9, 33, -127, 8, 11, 2, -14,
    89, -3, -9, 27, -19, 16, 8, 17,
    -13, 5, 5, -3, -21, -9, 13, 39,
    -29, -13, 18, 14, -30, -4, -3, -2,
    45, -8, 14, 15, 46, 10, 43, 46,
    12, 14, -72, -17, -14, 7, 44, 0,
    57, 2, -3, -15, 9, 14, 9, -37,
    16, -16, 22, -13, 32, 0, 75, 18,
    -14, 14, 38, 25, 23, 6, -65, -38,
    -65, -30, 21, -14, -6, 40, 42, -1,
    2, 17, 32, -10, -8, -11, 127, -21,
    37, -8, 21, -38, 28, -1, -47, 21,
    18, -23, 11, 32, 1, -17, 1, 4,
    -15, 9, -12, -2, -8, 8, -2, 2,
    -9, 7, 12, -29, 12, -13, -5, -4,
    5, -9, -4, -11, -21, -44, 11, -40,
    -1, -19, 1, -8, 5, 12, 20, -14,
    -9, 9, 7, -7, 8, 19, -14, 3,
    23, 36, 9, -7, -16, 11, 32, -1,
    -17, -5, 5, 27, -8, 8, -20, 3,
    1, 40, 3, -10, 1, 41, 13, -38,
    -6, -6, 5, -9, 0, -15, -8, -17,
    -2, -14, -7, -23, -2, -4, -3, -9,
    -32, -3, -38, 34, -32, 25, -40, 38,
    -7, 4, 15, -17, 18, -4, 27, -17,
    2, -4, 10, 1, 21, 23, -6, 13,
    -27, -13, -4, -31, 3, 37, -14, 9,
    -4, -4, -23, 8, 28, 23, -39, 11,
    7, -49, 2, -8, 30, -12, -11, -27,
    -3, 27, 1, 6, 13, 27, 6, 1,
    19, -10, 48, 15, 6, 7, -31, 3,
    1, -16, -7, -12, -12, -12, 39, 31,
    3, 26, 22, -14, -25, 3, 38, -25,
    16, -21, 2, 17, -4, 7, -33, 35,
    -11, -36, -5, 1, -20, -28, -13, -23,
    10, -21, 15, -25, -33, -31, 35, -22,
    2, -12, -1, -14, -32, 21, 11, -23,
    12, 0, -5, -18, 12, 9, 8, -37,
    -6, -17, 16, -18, 11, -6, 3, -15,
    40, 17, -34, 9, 11, -2, -6, 7,
    -5, 18, -45, 36, 14, -33, -12, 9,
    12, 4, -25, -2, 0, -27, -13, 11,
    -4, -30, -3, -12, -15, 6, -7, -8,
    -6, -5, -13, -2, 3, -29, 40, -10,
    11, -5, -7, -3, -16, 29, 25, 24,
    42, 5, -4, -69, 22, -5, 3, -35,
    9, -30, -17, 16, -1, -9, 13, -3,
    -7, -1, 17, -19, -40, -5, 20, 6,
    -9, 34, 2, -11, -6, 44, -11, 0,
    -23, 0, 0, -13, 26, 22, 14, -20,
    32, -24, -11, -3, 18, 16, -10, -11,
    -16, 11, 4, -20, 9, 23, 38, 6,
    17, 5, 1, 17, 0, -25, -37, -2,
    -7, -9, 4, 6, 38, -14, 0, 22,
    27, -6, -15, 13, 9, -25, -10, -2,
    67, -5, 0, -2, 33, -42, 6, 7,
    -24, 8, -21, -8, 20, -6, 31, -2,
    -12, 4, 6, 7, -6, 14, -9, 5,
    -14, -5, 10, -21, 2, -5, -16, -7,
    -15, -6, -10, -39, -2, -8, -1, -10,
    1, -17, 30, 15, 17, -10, 7, 12,
    2, 4, 8, -12, 26, 37, 3, -2,
    13, -10, 17, 7, 12, 4, 9, 10,
    -42, 10, 6, -3, 26, 30, 10, -7,
    -9, -20, -5, 0, -9, 9, -27, 29,
    -12, -7, -1, 11, -11, 1, 14, 19,
    3, 23, -23, -17, 11, 16, -1, 6,
    -2, 18, -9, -2, 0, -33, -15, -13,
    8, -5, -6, -20, -29, -39, -9, 17,
    -11, -1, 5, -5, -53, -2, 6, -11,
    -1, -5, -22, 2, 8, -13, 10, -9,
    -2, 9, -16, 39, -22, 29, -45, 10,
    1, -7, -17, 14, -4, 23, -6, 11,
    4, -5, -7, 5, 27, -29, -25, 12,
    25, 6, 0, -19, 1, -19, 20, -13,
    26, -31, 29, 23, -15, -15, -1, 30,
    58, -8, -7, 23, 16, -31, -9, 69,
    22, 18, 4, -8, 14, 27, -25, 10,
    12, -9, 15, 19, -7, 22, -40, 1,
    -13, 13, 25, 28, -38, -6, 10, -36,
    -26, 0, -6, 9, -26, -37, 5, -25,
    9, 8, -18, 7, -7, -6, -22, -30,
    -22, -3, -27, -20, 7, 19, 8, -36,
    -27, -7, 12, -22, 17, -5, 11, -35,
    5, 39, -2, -25, 20, 15, 7, -30,
    -2, 5, -1, -8, 20, 13, -16, 18,
    14, -1, 12, -46, -16, -13, 0, -13,
    28, -5, -7, 17, 9, -27, 4, 3,
    15, -36, -2, -24, -15, -6, 7, 1,
    5, 3, -18, -2, -1, -23, 9, 7,
    -3, 8, 13, -6, -12, -10, -17, -14,
    -18, 26, -15, -31, 47, -4, -12, -1,
    -2, 7, -25, -9, 30, -19, 20, -44,
    0, -4, 3, 46, -3, -40, 10, 12,
    -6, 22, 28, 19, -1, -27, -5, 6,
    -21, -8, -1, 1, -5, 21, -8, 21,
    -11, 9, -13, -7, -1, -21, 69, -5,
    7, -36, 10, 1, 9, -9, -27, -37,
    2, -49, -20, -5, -1, -15, -35, 4,
    -2, -10, -7, 11, -39, -18, -27, -3,
    9, -25, 7, 10, -50, 13, -11, -1,
    -5, 6, 13, -7, 16, 20, 12, -8,
    -9, 21, -37, 2, 4, 27, 19, 2,
    17, -3, -33, 26, -5, -16, 30, 13,
    -16, 0, -9, -29, 7, -12, -6, -18,
    0, 7, -3, 11, -22, 9, -30, 12,
    -10, 5, -19, -26, -4, -8, 9, -47,
    15, -8, -4, -36, 45, -18, -17, 16,
    -16, 0, -30, -4, 4, -23, -7, 12,
    -9, 4, 10, 0, -1, -11, -24, -25,
    -4, -30, -20, -15, 14, 1, 4, -13,
    -16, 22, 7, 10, 5, 0, -10, -43,
    -19, -19, 7, -26, 18, -19, 2, 8,
    10, 14, -11, -2, -20, 15, -7, -20,
    -5, -13, -36, 15, -3, -5, 42, -9,
    -38, -4, 5, -11, -9, -13, 4, 1,
    8, -8, -13, -12, 29, -25, -12, 1,
    30, 1, -13, 18, -2, 14, -29, 4,
    17, 19, -10, -14, 6, -9, 33, -7,
    -22, -18, 6, -8, -11, -8, -6, 24,
    -37, 17, -44, -4, -7, 33, -31, 9,
    -31, 18, 4, -8, -13, -5, 11, 43,
    17, -22, 6, -4, -7, -16, 1, 13,
    2, 14, 22, 20, 6, -6, 31, -5,
    -26, -19, 9, 18, -34, -29, -7, 7,
    5, 6, 3, 8, 5, -12, 35, -15,
    -17, 2, -28, -38, 3, -1, -8, 0,
    -15, 23, -11, 6, -36, -2, 27, -1,
    -5, 9, -5, 2, 25, -27, -35, 18,
    3, 33, 18, -2, -20, 15, -2, 3,
    -36, 27, 23, -27, -20, 7, 4, 15,
    -30, -1, 40, 22, -25, -12, -19, -52,
    -3, -2, -16, 1, -12, 9, -61, -4,
    2, -2, 10, 25, 2, 38, 1, 37,
    -12, -54, -13, 7, 5, 25, 4, -6,
    -46, -17, -3, 4, -59, -28, 16, 29,
    4, -9, -8, -5, 16, -6, 20, -49,
    1, 2, -2, 91, -27, -3, -6, 25,
    -17, -15, -22, -11, -25, 21, -24, -19,
    -24, -40, 18, -10, -43, -10, -40, -8,
    30, -44, -11, 18, -11, 2, -23, -6,
    0, 28, -7, -27, 25, 1, 10, 34,
    -23, 4, 0, 26, 18, -13, -18, 17,
    26, -50, -1, -43, -73, -39, 11, -12,
    19, 6, 11, -11, -70, 17, -14, -17,
    -8, -3, -3, 8, -3, 8, -9, -5,
    -19, 27, 8, 8, 12, 7, 20, -15,
    29, -4, -21, 23, 4, -22, -60, -24,
    -13, 4, 10, -13, -11, 31, -25, -45,
    -20, 16, 2, 1, 16, -37, -22, -4,
    23, 21, -2, -16, 4, -12, -1, -6,
    -19, 0, 9, 66, -59, 38, -70, -3,
    3, 36, 23, -32, -6, -24, 34, 25,
    -4, 1, -5, 10, 25, 4, 9, 27,
    -4, -17, 13, 14, 6, 7, -7, 7,
    8, -1, -21, 26, 18, -37, 28, -10,
    -19, -22, 8, -36, 50, 31, -4, 1,
    4, 14, 4, -25, -25, 5, -14, 0,
    2, 8, 29, 20, 9, -11, -15, 16,
    24, 10, 1, -35, 3, 49, -1, -1,
    -5, 6, 35, -4, -11, -29, -7, 23,
    -20, 13, 4, -16, -8, 1, -16, 42,
    -18, 12, -19, -6, -10, -7, -6, -7,
    -6, 13, 16, -10, 5, 65, -6, -10,
    4, 8, -15, -20, -15, 40, -17, 32,
    -1, 7, -8, -6, -15, 10, -2, 53,
    -6, -22, 5, 24, 32, -3, 5, -28,
    40, -5, 20, -4, 15, -8, -10, -11,
    20, -3, -57, 14, 22, 25, 22, -10,
    -16, -10, -11, -9, 2, -31, -17, -5,
    9, -15, -6, 3, -2, 36, -8, -20,
    6, -2, 11, 2, 26, -91, 33, -20,
    4, 8, 1, 0, -29, 23, -23, 8,
    35, -6, 43, -75, -6, 10, -35, -5,
    0, -23, -24, 12, -5, 2, -11, 4,
    3, -4, 24, -24, -16, -14, 46, 1,
    -15, 49, -4, 0, 2, -6, -5, 23,
    -22, 34, 1, 2, 8, -6, 26, 14,
    -8, -6, -6, 4, 8, 3, 0, -26,
    -7, 43, -25, -9, 31, -4, 36, -28,
    23, 3, -1, 23, -48, 9, 18, 17,
    -4, -42, 2, 9, 15, 53, -15, 6,
    36, 11, -40, -3, 5, -13, -10, -4,
    62, 4, 9, -8, -41, -51, -36, 45,
    12, 28, -11, -10, -36, -25, -13, -2,
    2, -5, 22, -5, -42, 9, 33, -6,
    -15, 17, 15, -21, -10, 6, -4, -14,
    26, 0, -59, -30, -15, -70, -40, -18,
    -19, 0, -15, 36, 58, -21, 7, 54,
    -8, 6, -11, -4, 18, 20, -17, 64,
    54, -15, 15, 13, 21, 0, 14, 1,
    -8, -2, -25, -36, 40, -10, 32, 19,
    3, -5, -25, 6, -25, 24, -7, 31,
    27, 43, 12, -2, -49, -35, -7, -8,
    -28, -21, 4, -2, 8, -28, -1, 6,
    -12, 21, -1, -9, -8, -30, 19, 2,
    1, -12, 6, -16, 1, -69, -14, -22,
    -1, -25, 13, 5, 3, 0, -37, -23,
    -27, -9, -61, -1, 4, -6, 0, -14,
    -24, 30, -39, 27, -18, 34, -4, 3,
    8, 22, 15, 14, -14, -33, -33, -19,
    -3, 17, -12, -11, -8, -26, 3, 7,
    -12, -25, -10, -27, -9, -12, -4, -3,
    -9, 18, 37, 9, -3, 12, -21, 23,
    34, 3, 3, 0, -4, -15, 40, 33,
    30, 23, 15, 3, 12, -18, 48, -61,
    21, -17, 22, 39, -12, 38, -31, 11,
    -25, 7, -17, 4, -35, 9, 5, 0,
    9, 0, 12, -5, 14, 5, 31, -50,
    -6, 1, -31, -20, 31, -8, -20, 39,
    5, 3, 19, -43, 25, 2, 24, -45,
    11, -4, 1, -5, -18, 9, -12, -39,
    14, 18, -2, -25, 53, 40, -30, -40,
    25, 17, 12, -5, -24, -15, -72, -9,
    45, -19, 31, -35, -13, 4, 17, -20,
    -9, -21, -21, 15, -53, 26, -15, 3,
    -3, -22, -27, -14, 21, 4, -33, 24,
    -18, 18, -10, -16, 4, -8, 12, -25,
    -10, 19, 31, 1, 4, 1, -14, -21,
    31, 30, 11, 54, 60, -6, 34, -2,
    33, 20, 9, 36, 23, 8, 66, -30,
    5, -11, -12, 45, 8, 14, -38, -9,
    -8, 4, -4, -10, -9, -10, -6, 19,
    4, 3, -56, 1, -5, 4, -47, -29,
    28, 6, 10, 2, 75, -22, 20, -18,
    17, -13, 16, -29, 11, 8, -50, 11,
    6, -20, -30, 39, 12, -20, -71, 15,
    6, -4, -18, 20, -45, -9, -7, 29,
    17, 28, 11, 7, -12, 32, 7, 13,
    3, 2, 6, 1, 50, -29, -35, 16,
    -21, 18, 5, 23, 7, 1, 15, 11,
    -10, 12, -18, -4, -12, -13, -35, -13,
    -5, -11, -5, 11, 38, -14, -8, -4,
    10, 3, -2, -22, -63, -12, 62, 39,
    4, 14, -2, -3, 8, -13, 19, -69,
    4, -8, 19, -20, 10, 11, -17, -14,
    -27, -16, -15, -11, -28, -49, 48, 13,
    -19, 0, -19, 10, -39, 12, 36, 2,
    -9, -15, -47, -17, -7, 19, -5, -22,
    23, -4, -18, 18, 4, -21, -2, -19,
    5, 16, 18, -17, -32, -18, 65, -50,
    11, 6, 5, -19, 38, 30, 14, -44,
    6, -29, -15, 17, 23, 4, 48, 4,
    -12, 17, -26, -10, 13, -7, -57, 43,
    8, 0, -4, 3, 6, -15, 15, 13,
    23, -6, -8, -2, -10, -8, 41, 0,
    11, 10, 8, -5, 1, -3, 11, -6,
    3, -21, 4, -9, -27, 17, -51, 10,
    -27, 4, -61, -19, 20, 16, -13, -4,
    -34, 13, 2, 2, -20, 2, -26, 43,
    25, -25, -5, -10, -5, -21, -13, 15,
    20, 2, 15, 3, 6, 14, 6, -5,
    0, -9, -2, -8, -32, 26, -5, 9,
    1, -5, 6, 6, -6, 11, -12, 16,
    -2, -15, 26, -11, 5, -17, 14, 11,
    -27, -57, -11, -11, -44, -40, 10, 46,
    -20, 19, 0, -6, -18, -8, 12, 13,
    19, 38, -11, 0, -32, -19, -31, 10,
    -4, 4, -2, 18, -11, 9, 2, -12,
    -26, -25, 54, 19, 24, -38, -10, 26,
    4, 16, 14, -19, -9, -14, 31, 0,
    2, 13, -17, 24, -5, -48, 20, 29,
    13, -87, -8, -4, 6, 8, 3, -2,
    -31, -9, -34, 13, -73, 15, -27, 11,
    -30, -3, -9, -8, 63, -16, -29, -4,
    11, 4, 2, 90, -50, -7, 22, 37,
    1, 28, -13, -10, -17, 4, -13, -14,
    -7, -17, -12, -4, 20, 13, -49, -37,
    19, 16, 22, 1, -10, 20, -40, -32,
    -9, 13, -14, 29, 6, 7, 13, 25,
    -28, 56, -32, 18, 6, -25, -13, 14,
    -28, -24, 29, -66, -8, 9, 28, 21,
    -8, 54, 11, 14, -35, 2, -22, 32,
    -5, 2, 1, -10, 27, -13, 17, 8,
    -33, 52, -18, 31, -7, 14, 30, 5,
    27, -27, -17, -19, 47, -12, -24, -64,
    -18, 29, 9, -4, 0, -60, -14, 19,
    23, -8, -6, 9, -43, 11, 17, -5,
    30, -14, 21, 43, 11, -31, 23, -13,
    -23, -4, -46, 77, -17, -7, -83, 48,
    -5, -26, 1, -17, -34, 54, -4, 20,
    -6, 19, -1, -1, 10, -16, -8, 3,
    -24, -39, 21, 21, -2, -13, 4, 14,
    48, 22, 11, 75, 6, 49, 40, -17,
    -9, -9, 87, 42, 59, 40, -6, -1,
    1, 39, 3, 0, -12, -14, -17, 1,
    17, 47, 36, -13, -20, 19, -25, 20,
    59, 17, -81, 14, 1, -29, -48, -38,
    -18, 40, -22, -31, -25, 24, 4, -67,
    12, 8, 7, 2, -15, 3, 26, -63,
    -5, -40, -27, -7, -25, -28, -30, 16,
    -43, 19, 52, 24, 13, 34, 5, 31,
    2, 7, -16, -15, 24, 4, -37, -36,
    -19, -5, 1, 27, -46, 7, -59, 7,
    0, -34, -42, -10, 42, 0, 11, -53,
    -2, -2, 12, 2, -8, 36, -19, 43,
    3, 11, -59, 5, -3, 9, 3, -12,
    -9, 4, -14, -14, -23, -17, 13, -12,
    30, -35, -19, -59, -1, 59, -18, -4,
    16, 22, 33, 7, 17, 23, 57, 37,
    -13, -13, -1, -23, -38, -23, 57, -1,
    34, -3, 6, -86, -5, 35, 40, -13,
    10, -33, -65, -13, -8, 10, -3, -8,
    21, 17, -8, 1, -10, 70, -15, 34,
    -32, 48, 28, 14, 27, 39, -13, 26,
    -13, 16, 7, -3, -18, 55, 33, 20,
    -32, -10, -11, -45, 6, 26, 5, -24,
    -6, 33, -58, -2, 29, -47, -2, -27,
    17, -8, -6, 10, -48, -67, 9, 61,
    4, -18, -12, 17, -34, -14, -9, -12,
    20, 62, -27, -14, -22, -38, 18, -31,
    40, 18, 42, -28, -42, -87, -49, 38,
    0, 59, -21, -29, 4, -6, -51, 39,
    7, 9, -16, -2, -13, 29, -60, -33,
    14, -40, -35, -40, -2, -1, -7, -35,
    1, -43, -25, -54, 13, -2, 8, 30,
    2, 17, 0, -6, 18, 64, 9, 16,
    5, -24, -3, 7, -38, -60, 6, 4,
    39, -19, 9, -20, 31, -9, 11, -8,
    -18, -38, -12, -23, 14, -7, -47, 15,
    2, -11, -18, -15, 6, 36, 9, 10,
    -7, -27, -1, -11, 66, 63, 2, 20,
    -33, 12, 14, 16, 29, -31, 27, -9,
    -23, -27, 71, -10, -28, -12, 18, 18,
    12, 3, -11, 18, -14, -18, -10, 18,
    -2, -23, -6, -11, 59, 1, -44, -17,
    21, 4, -109, -15, 17, 6, 23, -16,
    -39, -64, -7, 40, 29, 39, 14, -1,
    -24, -16, 18, -50, 19, -4, -2, 46,
    -3, 7, -12, 13, 14, 11, 5, 23,
    -4, -63, -6, -12, -10, 7, 10, -10,
    -3, 4, 31, 27, -8, 29, 14, 19,
    19, -10, 8, 9, -1, 0, 33, 59,
    28, -3, -30, -15, 15, -19, 29, -24,
    10, 40, -17, 8, 3, 37, -35, 18,
    -4, 10, 4, -27, -23, 1, -70, -21,
    -9, -16, 16, 24, -64, 15, -11, -29,
    -6, 16, -39, 3, 10, 18, 10, -15,
    -58, -70, -35, -65, 43, 9, 38, -127,
    -72, -4, -18, -22, -34, 57, 28, 12,
    25, 48, -1, 23, -15, 127, 3, -30,
    -9, 5, -22, 3, 59, 8, 6, -24,
    -53, 26, -3, -14, -4, 10, 14, -22,
    -9, -11, 8, 13, -24, -13, 21, -5,
    -14, -41, 1, 24, 1, -28, 16, -9,
    11, 13, -19, 3, -15, -55, 19, 21,
    42, -74, -10, -3, 2, -2, -24, -40,
    -37, 32, -2, -23, 26, 18, -38, -53,
    44, 28, -14, 35, 6, 33, 25, -14,
    -2, -2, -2, 59, 4, 5, 39, 16,
    30, -86, -21, 25, -10, 22, -5, 4,
    -50, -17, -34, -6, 6, -8, 19, -37,
    8, 23, -14, -18, 37, -14, 85, -15,
    18, -2, 4, -3, -30, -18, 48, -34,
    54, -13, -32, 11, -8, -30, -126, 13,
    -59, -31, -28, -73, -42, 0, -2, 55,
    11, 13, 46, 30, 6, 65, 30, 21,
    -19, 3, -13, -14, 16, 21, -40, 17,
    -47, 33, -24, 6, 34, -4, 26, 12,
    -30, 93, 22, -2, -42, -14, -4, 6,
    45, 8, -4, -10, 39, 40, -82, 4,
    -10, 13, 5, 12, -27, -13, 28, 17,
    26, 7, -8, 10, 31, -11, 36, -109,
    -61, 17, 41, -17, -9, 6, 9, 0,
    -10, 1, 6, -74, -58, -19, 7, -41,
    -10, 9, 12, 2, -29, -62, 18, -12,
    10, -11, 37, -47, -23, 49, 46, -35,
    23, 21, -32, 61, -71, -6, -7, 10,
    -39, -8, -2, -38, -60, -42, 64, -43,
    1, 1, 16, -9, 48, 42, 20, -36,
    2, -34, -96, 7, -21, 10, 48, -16,
    -12, 51, -11, 34, 17, 24, -56, -47,
    21, 26, -5, -13, 22, -3, -30, -22,
    32, -3, 12, 37, 2, 7, -5, -52,
    4, 20, 1, 7, 8, 11, 16, 2,
    9, -55, 31, 98, -21, 29, -14, -42,
    5, -29, -79, 1, 34, 3, 12, 33,
    -36, -15, 11, -15, -17, -13, 6, 15,
    -3, -42, 21, -46, -2, -31, -28, 32,
    4, 40, 39, 1, -10, -11, -59, 2,
    -10, 13, 7, 9, -17, 79, 22, 9,
    -14, 31, 4, 26, -1, -17, -17, 21,
    -35, 43, 109, 20, 10, -34, 31, 26,
    -39, -27, 1, -11, -18, -39, 43, -8,
    -2, 19, 25, -26, -8, 30, 13, 15,
    -18, 31, 5, 2, 49, 39, -20, 4,
    67, 2, 11, 32, -21, 17, 0, -15,
    36, -32, 4, -27, -26, -21, -19, 63,
    4, 14, -41, 0, 11, 90, 46, -10,
    0, -4, 1, 53, -28, -20, 38, 4,
    -2, -78, 10, -24, 11, -17, 8, 29,
    0, -6, -20, 4, -57, -5, 36, 3,
    -11, -5, -11, -6, 88, 8, 43, 4,
    -3, -4, -31, 127, 31, -9, 23, 0,
    27, 46, 23, -22, -42, 3, -24, -6,
    24, -58, -33, -35, 0, -1, -52, -16,
    -4, 5, 3, 9, -16, 31, 4, 30,
    -8, 1, 19, 4, -14, 23, 22, 1,
    7, 4, -3, -14, 1, 9, -1, -10,
    -23, -5, -5, 7, 2, 1, -3, 24,
    6, 7, -7, 7, 10, 7, -16, -20,
    -12, 2, -17, -14, -3, 1, -36, -29,
    14, -22, -6, -11, 6, 11, 25, 6,
    -2, 16, -2, 11, -8, -18, -15, -10,
    8, 0, 3, -13, -9, -27, -10, 5,
    27, -7, 0, 7, 9, -9, -10, -12,
    10, 11, 4, 14, 32, 30, -18, -8,
    23, 1, 3, -3, 31, 17, 0, -13,
    9, 1, 7, -5, 8, 27, -11, 6,
    -20, -2, 34, -11, 0, -7, 21, -15,
    5, 14, -4, 0, 1, -13, -4, 3,
    40, 10, -7, -11, -11, -5, -22, -41,
    2, 13, -14, 10, 0, 35, -8, 20,
    -4, 36, -21, 12, -17, 7, -9, -9,
    2, 21, -5, -8, 0, 29, -9, 3,
    -6, 37, -16, -26, -35, 50, -11, -12,
    -8, 3, -3, -7, 16, 10, -7, 13,
    22, 31, 16, -10, 13, -73, 32, -35,
    -7, -24, 39, -9, 13, -6, -12, 14,
    2, 9, -2, -4, -9, 14, -26, -19,
    1, -19, -16, 1, 14, 17, 4, -18,
    12, 5, 11, -12, -12, 11, 63, 18,
    27, -23, -39, 2, 48, -24, 6, 14,
    21, 8, 1, 16, -5, -24, 50, -31,
    4, 6, -8, 0, 14, 3, -2, -15,
    16, 14, -17, 27, 22, -30, -11, -28,
    -1, 9, -23, -9, 21, -5, -11, 28,
    -9, 10, -7, -21, -9, -7, 13, -46,
    -1, -10, 16, 0, -1, 21, -3, -3,
    9, 36, 15, 7, 12, 6, 7, 13,
    6, -10, -3, 0, -7, -3, 34, -13,
    -3, -22, -4, 1, 13, 19, -14, -7,
    3, 12, -4, -2, -6, 10, -7, -6,
    0, -3, -45, 5, 31, -2, -2, 4,
    -15, 1, -9, -3, 1, 14, -9, -6,
    -9, 5, -21, -4, 8, -27, -4, 15,
    -8, 5, -4, -2, 15, 20, 1, 10,
    -24, -8, -22, 10, -14, 3, -3, -43,
    -11, -1, 14, 13, 7, -13, 3, 11,
    -11, -6, 3, 12, -8, 19, 5, 1,
    15, 4, 17, -5, -13, -14, 12, -5,
    5, -31, 31, 8, 40, -19, -38, -7,
    17, -6, -4, -7, 19, -3, 7, 10,
    33, -11, 0, 4, -11, -6, 12, -8,
    -12, -9, 4, 1, 19, 13, 25, -11,
    8, 4, 23, 14, -34, 2, 3, 12,
    -4, 13, 24, -28, 8, -3, -2, -25,
    6, 14, -11, -10, -10, -24, 10, -5,
    7, 0, 5, 7, 11, 16, -6, 22,
    -3, -24, 21, 18, -13, -15, 13, -18,
    11, 4, 0, 22, -12, -5, 2, -9,
    3, 5, -14, 6, 20, 7, 9, -33,
    -6, -13, 9, -2, -2, -39, 18, 19,
    14, -31, 10, -33, 46, -27, 17, -12,
    41, 16, 0, -9, -9, -19, 24, -2,
    -7, -25, 18, 10, 25, -22, 5, -28,
    -5, 0, -4, -1, -5, 2, -13, 17,
    -2, 14, -2, 3, 27, 20, 32, -19,
    26, 18, -6, 0, 2, 25, 1, 22,
    5, 10, 6, 11, 13, -10, 28, -14,
    1, -6, -8, 6, 11, -6, -6, -1,
    -3, 6, -8, 24, 20, -10, 15, -4,
    4, 16, 21, -9, -4, 36, -7, -1,
    4, 1, -18, 22, -8, -10, -19, -17,
    -2, -6, -5, 1, 29, -9, -13, -17,
    -2, 4, -14, -5, 11, 21, -18, 18,
    1, 18, -9, 4, 17, 17, 3, -4,
    5, -22, 11, 10, 8, 13, -20, 25,
    -16, 0, 1, 1, 13, 19, -15, -8,
    11, 32, 8, -15, 35, 6, -9, -18,
    -7, 20, 13, -10, 6, 16, 13, 18,
    23, 26, -11, -15, 22, 10, 3, -7,
    9, -5, 7, -14, 42, 23, 33, 3,
    25, 8, 28, -5, -11, -13, 6, -2,
    11, 12, -20, 29, -17, -27, -12, 14,
    7, 5, -8, 2, -49, 36, -13, -1,
    2, 3, -38, 11, 9, -4, 2, -1,
    -21, 10, -30, -7, -25, 8, 9, -19,
    -11, -14, -23, -20, -17, 4, 7, 4,
    0, 15, -40, 15, -16, 5, 31, 6,
    3, 12, 8, 8, 1, -2, -1, -2,
    11, -9, 7, 16, 42, -53, -3, -25,
    -15, 8, -16, -7, 7, -18, 27, 45,
    -12, 15, 17, 11, 15, 23, 18, 28,
    1, 9, 6, 3, -6, 15, -17, -18,
    -25, 4, -4, -7, -23, -24, -1, 21,
    4, -4, 2, 31, 32, -21, -20, -22,
    5, 19, -15, -3, -25, 1, -14, -39,
    -9, 6, 11, -6, -28, 8, -2, -14,
    2, -11, 31, 13, -17, 4, -3, 21,
    3, -4, 16, 0, -6, -34, -5, 14,
    5, 7, 9, 3, 0, -1, 10, 20,
    1, 7, -8, 6, 15, -5, -28, 10,
    -11, -11, -18, 10, 13, -18, 0, 7,
    14, 0, -6, -13, -26, -18, 7, 5,
    0, -16, 8, -7, 4, -7, -17, 2,
    6, 22, -9, 3, 5, 6, -29, 10,
    10, -25, 3, 8, -12, 14, -27, 42,
    -22, -11, -3, 19, 15, 0, 0, -22,
    33, 22, -14, 3, -15, -20, 29, 11,
    8, -8, -2, 19, -13, 12, -6, 13,
    0, -3, -14, 3, 15, -18, -8, 5,
    -3, -4, -10, -16, -18, -16, -6, -5,
    1, 4, -15, 6, -2, 2, 5, 20,
    -2, -4, 3, -4, -2, -16, -6, 19,
    5, 33, -19, 25, -20, 18, -3, -14,
    6, 19, 10, -34, -7, 10, -12, -13,
    -7, 2, 7, 18, -7, -6, 26, 19,
    -2, -6, 5, 9, 4, -6, -5, 14,
    -10, -33, 8, 23, 13, 35, -2, -21,
    14, -2, -4, -1, -7, 4, 21, 6,
    73, -2, 6, -23, 0, 12, 22, -12,
    -2, 6, -8, 2, 17, 10, 17, 1,
    -7, 7, -19, -5, -3, -17, -10, -17,
    -48, 4, 9, -20, -12, -3, 7, 9,
    33, 15, -6, -16, -26, 14, -39, 4,
    6, -4, -3, -5, -14, 3, -2, 0,
    15, 4, -16, 24, 17, 28, -10, -13,
    -12, 6, -10, 6, -3, 17, -39, -3,
    57, -16, 4, -18, -6, -1, -16, -15,
    -6, -2, -6, -6, 14, 19, 0, 5,
    6, -6, 9, -4, 9, 2, 29, 8,
    -22, -1, -17, -2, -28, 16, 4, 1,
    9, 6, -9, 10, 10, -2, 37, -16,
    -12, -1, 3, 0, -5, 36, 13, 36,
    -10, 1, 25, 13, -16, -12, -6, -6,
    4, 52, -4, -5, -6, -1, 9, -19,
    -26, -9, 16, 30, -11, -3, 28, 8,
    -2, 10, -14, 1, -3, 33, -32, 2,
    -27, -39, -4, -9, -8, 17, -64, -16,
    6, 23, -1, -10, 34, 5, -12, -7,
    -18, -14, -8, 11, -23, -10, -5, 15,
    8, 19, 15, -31, 1, 5, -10, -23,
    22, 17, 2, -4, 24, -23, 35, 11,
    -13, 17, -12, -5, 11, -28, -9, -11,
    39, 13, -11, 1, 57, 32, -5, 1,
    1, -3, -2, -17, 1, 4, -21, 13,
    -2, 1, 44, -1, 10, 4, 7, 17,
    11, 2, -2, -30, 7, 13, -14, 20,
    2, -1, -19, -47, -7, -19, -58, -14,
    -1, 14, -12, 6, -3, 23, 20, 24,
    3, 20, -20, 9, -30, -14, 16, 37,
    -1, 21, -19, -13, 4, 22, -20, 20,
    2, 34, -13, -55, -13, 15, -5, 41,
    7, 10, 10, 6, 21, 28, 5, -9,
    18, 27, 26, -30, 25, -90, -6, -7,
    -14, -8, -2, -24, 15, -24, -6, 32,
    -18, 31, -4, -7, -33, 10, -4, -28,
    -1, -29, -4, 1, -4, 19, 6, -1,
    46, -8, 2, -18, -45, 17, 22, -20,
    31, 4, 18, 21, 31, -5, -16, -22,
    20, -1, -10, 4, 6, -28, 40, -2,
    -4, 16, 6, -11, -3, 27, -10, -17,
    3, -11, 1, 6, 2, 1, -28, 6,
    46, -9, -18, -21, 4, -4, 8, 18,
    -17, -1, 5, -36, -9, 9, -2, -25,
    -6, -5, 12, -3, 8, -13, 6, -11,
    -3, 25, 2, 0, 4, 7, -38, 37,
    -2, 27, -37, -11, 3, 5, 2, -18,
    1, -11, -1, -7, 18, 5, -9, -21,
    0, -7, -9, -1, -16, 20, -13, -8,
    0, -6, -27, 7, -3, -8, -25, -26,
    34, 13, 10, 13, -12, 12, -16, -13,
    -2, 7, -22, -8, -18, -13, 6, 4,
    6, 4, -6, 0, -10, 9, 7, 11,
    -38, 13, -9, 10, 46, 25, -44, -42,
    -20, 5, -1, 0, 26, -13, 36, -3,
    -9, -26, 2, 29, 1, 30, -1, -6,
    8, -17, 15, -13, 4, -25, 18, 2,
    7, -26, 21, 17, 4, 48, 46, 30,
    -7, -25, 7, 2, 29, 32, -7, 13,
    30, -49, 16, -4, 10, -4, 53, -24,
    0, 15, 8, 2, -1, -5, 14, -14,
    -7, 2, 38, 26, 4, -50, 1, -39,
    -12, 2, -46, -45, -5, 4, -10, -16,
    -20, 16, -2, 13, -16, -10, 17, -14,
    15, 11, -9, 12, 22, 5, -7, 2,
    0, 0, 3, 14, -43, -23, -8, -5,
    10, 7, 49, 23, 24, -1, -2, -6,
    6, -1, -6, -10, 13, -40, 28, -11,
    1, -15, 3, 8, 19, 3, 13, 31,
    10, -9, 10, -38, -6, 44, 2, 18,
    24, 45, -5, 24, -6, -2, 31, -13,
    -16, -15, 0, 7, 31, -12, 2, -5,
    -8, -3, -3, 0, -17, -6, -7, -4,
    5, 4, 26, -15, 46, -10, 16, -14,
    9, 11, 25, -4, 24, 17, -2, 2,
    17, -8, 13, 16, -5, -32, 48, 6,
    3, -1, -25, 9, 6, 1, -14, -3,
    1, 3, -15, 9, -2, -3, -45, -15,
    10, 14, -12, -22, -1, 4, -8, -14,
    0, -5, -6, -3, -9, 6, -32, -4,
    -3, 3, 1, -1, 39, -7, 12, -1,
    4, 11, -9, -13, -11, -6, -20, -29,
    38, -3, -11, 46, -7, 12, -28, -19,
    -6, 11, 16, 8, -30, -6, 8, 12,
    -6, -5, -7, -2, -3, 22, -38, -3,
    -3, 35, -1, -15, 48, 26, -32, 8,
    -6, -19, 17, -14, -4, -4, 34, 5,
    -1, 13, -7, -12, -13, 22, 1, 11,
    4, 4, 15, -9, 13, -7, 22, 1,
    14, 10, 32, 16, 44, 22, 15, -35,
    -15, 17, -11, -8, -29, -2, 10, 8,
    25, -8, -19, 8, -10, 36, 2, 21,
    3, 6, -14, 6, 13, 12, 6, -12,
    -23, 8, -1, -1, -34, 1, -31, -39,
    13, 2, -33, 6, 1, -11, -12, -5,
    21, 6, -6, 2, -30, 16, 22, 15,
    9, 3, -1, 11, -6, 2, -6, -22,
    19, -13, 16, -7, -11, -37, 10, 6,
    -16, 7, -8, 69, 36, -12, 16, -10,
    -7, 4, 6, 11, 9, 4, -3, 24,
    0, -6, 4, 6, 11, 8, -29, -31,
    -60, 32, -7, 5, -43, -29, 57, -13,
    0, -24, 31, 16, -23, 20, -6, -13,
    13, -7, -52, -10, -55, -20, -29, 7,
    -12, 2, 9, 7, -4, 13, 9, -24,
    9, -7, 18, 6, 3, 20, -43, 12,
    -31, -2, 20, 0, -14, -17, -31, -1,
    -4, 14, 3, 2, 18, 9, 6, 6,
    3, -6, -14, 6, 13, -7, -27, 7,
    -1, -36, -33, 10, -63, -8, -9, 5,
    -2, -1, -10, -4, -2, 17, -10, 27,
    4, -15, 12, -4, 16, -34, -49, 9,
    -6, 23, -16, -2, -5, -5, -39, -23,
    4, -16, -1, 2, -12, 1, -19, 15,
    -16, -1, 3, 2, 37, 17, 12, 21,
    27, 49, 2, 12, 1, -15, 29, 14,
    1, 1, 0, 11, -3, 4, -3, -8,
    -4, -4, -12, 33, 22, -52, -42, -38,
    -6, -11, 0, -28, -6, -1, -10, 7,
    4, 14, -18, 25, -3, 11, 10, -19,
    4, -7, 3, 2, 0, -20, -23, -14,
    6, 21, 0, 0, -19, 21, -31, -12,
    4, 3, -42, -6, -3, 4, 14, -1,
    -15, -3, 25, 22, -1, 1, 30, -6,
    4, 8, 1, -1, -6, -2, -16, 36,
    -17, -25, 9, 19, -26, 20, 15, 8,
    27, 0, -2, -27, 4, -24, -5, -1,
    100, 8, 14, -7, -24, 13, -4, -12,
    -5, 4, -8, 2, 17, 33, 8, -11,
    -12, 8, -25, -13, 65, -35, -11, -19,
    15, -17, 41, 3, 1, 11, -13, -12,
    4, 22, -18, 4, -2, 22, -12, -6,
    18, -4, -18, -8, -21, -5, -37, 4,
    13, 14, -7, 1, 5, 1, -4, 0,
    -25, -32, 18, 2, -13, 13, -11, -15,
    103, -11, -2, -29, -12, -9, -27, -28,
    -3, 3, 0, -2, 13, 14, -4, 0,
    12, 3, -34, 3, -15, 1, 9, 24,
    -7, -12, 3, 21, -13, 10, 10, 5,
    4, 24, -31, 16, 9, 6, -11, -13,
    -11, 6, 8, -3, -52, 50, 11, 76,
    -12, -14, 18, 22, 23, -50, 2, -68,
    10, -99, 5, -38, -18, 11, 25, 41,
    -29, 4, 20, 22, -4, -9, 7, -10,
    -18, 7, -37, 7, 19, 42, 1, -56,
    -49, -80, -3, -14, -39, 27, -80, 26,
    24, 32, -5, 3, -33, -28, -31, -33,
    -46, 16, -48, 41, -66, -7, -19, 44,
    -8, 44, 35, -29, 9, -22, -66, -63,
    21, 43, 13, -49, -114, 7, 29, -23,
    -64, 30, 15, 58, 17, 2, -41, 7,
    49, 30, 23, -37, 39, 49, 24, -4,
    29, -30, 0, -30, 9, 31, -8, 19,
    1, -17, 56, 4, -39, 35, -11, 29,
    -26, -9, -41, -39, 1, -25, -14, 8,
    7, -27, -25, -104, -1, -16, -70, -59,
    -9, 4, 4, -7, -5, 61, -39, -12,
    -23, 22, -16, 30, 4, 35, -7, 25,
    1, -30, 43, 7, 14, 3, -23, -3,
    -13, 35, 10, -50, -43, -3, 21, -40,
    11, 29, -7, 14, 59, 33, 20, -28,
    56, 33, 50, -19, -42, -57, -47, 7,
    -16, -29, -15, -43, -16, 60, -54, 44,
    -8, 42, -13, -45, -46, 35, -27, -25,
    2, -39, 11, -2, 40, 26, 3, 13,
    41, -26, 2, -16, 14, 19, 36, -25,
    -3, 14, -3, -17, -28, -1, -18, 19,
    59, -34, -5, 5, 31, -23, 47, 12,
    -8, -1, 9, -45, 24, -25, 3, -23,
    16, -11, 13, -3, 22, 59, 11, 0,
    40, 26, 12, 10, -56, 15, 23, -5,
    -53, -19, -11, -52, -71, -9, -6, -49,
    -10, 10, 12, -3, 9, 4, -1, -21,
    -7, 14, 11, -8, 10, 25, -18, 22,
    -11, -22, 2, -8, 9, -9, -22, -4,
    2, -27, 10, -13, 16, -26, -11, -29,
    -27, 7, -13, -5, 40, 14, -41, -6,
    -8, -29, -41, 7, -6, 34, 3, -3,
    21, 13, 3, 21, -25, -54, 1, -6,
    -30, 4, -35, -8, -28, 10, 3, 6,
    -13, -9, -17, 5, -36, 1, 30, 24,
    -50, 18, -13, 3, 35, -12, -37, -18,
    15, 15, 17, -22, -38, 19, 5, -5,
    -41, -35, -25, 40, 13, 49, -4, 6,
    9, -7, 19, -27, 45, -49, -20, -14,
    21, -27, 12, -3, 22, 40, 60, 52,
    -4, -19, 28, -8, -34, 30, 33, -10,
    56, -38, 28, 25, 10, -21, 63, -24,
    6, 16, 11, 12, -21, 21, 34, -66,
    -52, 1, 46, 43, 4, 29, -59, -70,
    6, 1, -79, 5, 14, 42, -21, 39,
    4, 29, 4, 24, -53, 26, -7, 5,
    31, 0, -17, 4, 42, 9, -22, -34,
    -21, 8, -20, 9, 26, -7, 31, 13,
    -70, 0, -57, 42, -71, -58, -9, 0,
    33, 1, -46, -4, 6, 7, 19, 34,
    4, -11, 20, 29, -32, 38, 38, 13,
    41, -21, 7, -81, 4, 32, 12, 13,
    57, 72, -12, 34, -6, 50, -45, 4,
    1, 2, 4, 66, 4, 1, -34, 25,
    -6, -20, -1, -28, 10, 27, -17, 5,
    -5, 11, 28, -19, 5, -37, 6, 6,
    -9, 16, 17, -22, -19, -14, -12, 3,
    36, -24, 17, -8, 10, -39, 60, 0,
    8, 8, -13, -13, 19, 10, -38, -32,
    2, 2, -33, -7, 12, -22, 23, 53,
    12, 14, -9, 10, -12, -40, 0, -44,
    8, -14, -12, 7, -22, -3, -31, -14,
    -10, -5, -1, -1, 84, 10, 15, 38,
    -16, 22, 16, -5, 10, 36, -4, -53,
    -31, -44, 11, -21, -34, -16, 22, 39,
    36, -10, 3, 2, -11, -32, 33, 37,
    -37, 26, -15, 2, 2, 40, -35, -49,
    -5, 80, -24, -23, 42, -24, 15, 1,
    20, -61, 12, 30, -39, 13, -43, 22,
    11, 52, -7, -5, -6, 38, -3, 22,
    -7, 48, 29, -22, 47, 39, 43, -40,
    8, 13, 30, 1, 18, 12, -51, 17,
    -49, -9, 33, 69, 38, 18, 20, 39,
    15, 1, -10, -16, 10, 32, 1, -10,
    4, 2, -19, 17, 7, 9, 27, -1,
    -17, -9, 12, -7, 13, -19, 8, -23,
    27, 30, 37, -4, -37, -26, -34, -45,
    38, 9, -14, 30, -12, 14, -19, 41,
    6, 3, 7, 3, 12, 4, -16, 33,
    23, -11, 21, -30, -25, -14, 44, -5,
    3, -1, 17, 35, -33, -25, -34, 3,
    21, 11, 11, 15, 82, 21, 9, 30,
    -1, -20, 2, 20, 4, 58, -71, -5,
    -73, 18, -27, -5, 4, -17, 1, -9,
    -22, 23, 24, -29, -52, 10, 29, 3,
    -3, -9, -54, -6, -71, -23, -26, -16,
    -4, 4, 14, -2, -116, 36, -11, -11,
    18, 2, 16, 13, 12, 21, 41, 7,
    -2, -20, -6, -4, 15, -12, -14, -12,
    -9, 32, -1, -20, 9, 22, -19, 16,
    21, -26, -28, -8, -11, 18, -13, -2,
    -11, -63, -42, 23, 20, -1, 78, -7,
    57, -37, -54, 9, -16, 18, -9, 5,
    9, -17, 19, 1, 19, -56, -30, -15,
    7, 113, -15, 1, 22, -36, -38, 13,
    3, -19, 5, -15, 7, -16, -25, 6,
    20, 12, -8, 1, 19, -8, 22, -29,
    8, 71, -23, 5, 16, -20, 39, -11,
    2, 12, 3, 4, 3, -10, -13, 13,
    13, 1, 6, 33, -12, -31, 20, -10,
    -6, 9, 13, 31, -9, -23, 36, -25,
    12, 26, -36, 25, 4, 21, 20, -14,
    -1, 8, 1, -4, 4, -23, -53, 38,
    14, 10, 3, -21, -14, 19, -21, -13,
    19, -50, -38, 32, -3, -23, 35, 6,
    -2, -25, 26, 35, -1, -31, 19, -5,
    -76, -4, -9, 4, 62, 4, -5, 17,
    -36, -33, 0, 20, -49, 29, 17, -17,
    67, -60, 7, 6, -16, -3, -18, 31,
    95, 15, -6, 3, -4, 29, -33, 30,
    -26, 2, -8, -1, 49, 27, 1, -9,
    -10, 6, -45, -11, 5, -29, -36, -18,
    85, 1, -1, 4, 21, -6, 24, -12,
    -29, 23, 0, 14, -22, 5, 4, -3,
    127, 1, -12, 3, -55, 11, -4, 5,
    10, 22, -40, 2, -25, -27, -35, 14,
    -105, -6, 10, -12, -41, -8, -51, -12,
    94, -7, -49, -12, -47, -13, -13, -19,
    -12, 13, -32, -9, 9, 22, 20, 20,
    -5, -6, -35, -2, -40, 13, -42, 25,
    36, 71, -10, 0, 15, 15, -21, 2,
    40, 61, -18, 14, 18, 36, 8, -4,
    -37, 13, 41, -17, -26, 0, -25, -66,
    -6, 2, 14, 25, -1, 21, -21, 17,
    14, 9, -19, 13, -23, 31, -27, -31,
    19, -42, 14, -11, -1, 1, 1, 4,
    -10, 15, -36, -2, -53, 39, 36, -9,
    10, -15, 14, -25, -17, 0, -21, 19,
    12, -35, -28, 1, -35, -18, -36, 17,
    8, -24, -10, -4, -5, -6, 1, 0,
    -4, 18, 19, -12, -31, -33, 1, -60,
    9, 5, -28, 42, 30, -2, 10, -17,
    17, -9, -16, 7, -22, 8, 2, -5,
    1, -11, 8, -5, 8, 0, 0, -4,
    -8, 27, 76, -18, -47, 1, 15, -17,
    -12, 10, -21, -8, 1, -19, 3, 33,
    -17, -50, -36, 13, -23, 20, -35, -44,
    17, -9, 11, -15, 0, -5, -9, 1,
    40, 15, -49, -24, -30, 51, -29, -19,
    7, 19, 14, 39, -5, 6, -14, -14,
    6, -12, 17, 19, -16, 14, 69, 42,
    5, -45, -2, 10, 1, 4, 17, -6,
    30, -1, -37, 11, 45, -16, -28, 56,
    -4, -9, 16, 1, -7, 6, -14, -23,
    -17, -4, -38, -9, -1, -21, -25, 6,
    28, 4, 1, -49, 3, 2, -5, -1,
    26, -16, 13, -25, 72, 8, 4, -10,
    -25, -10, -3, -18, -3, 7, 6, 45,
    -26, -11, 7, 8, -6, -14, 17, -77,
    -13, 13, 14, -11, -1, 4, -4, 2,
    34, -4, -15, -1, 24, -1, 32, -14,
    -3, -27, -12, 6, 11, 19, -9, -11,
    -18, 8, -17, -22, -13, -31, -22, -6,
    32, 9, 27, -26, 1, 4, -8, 4,
    17, -3, 17, -13, 28, 58, -48, 15,
    16, -24, 9, -16, 15, -10, -15, 0,
    2, 10, 13, 8, -20, -10, 36, -29,
    -7, -5, -45, 7, -10, -7, -8, 0,
    32, -52, -7, 28, 13, -46, -2, 41,
    20, 12, -12, -28, 12, -2, 4, -14,
    -10, 1, 4, 39, -19, -7, 43, 16,
    -21, 6, 14, 6, 8, 5, -8, -1,
    -5, -17, 1, -17, 24, -12, -18, -7,
    12, -5, 26, -13, -1, -20, -12, 10,
    -1, 5, 32, 13, 19, -17, -33, 32,
    2, 1, -8, -17, 1, 4, 4, -12,
    -3, -21, -62, 2, -29, 19, -36, 14,
    27, 19, 18, -6, -9, 14, 6, -13,
    -8, 5, 19, 1, -19, 14, -46, 54,
    6, 7, -35, 22, 9, 3, -6, -4,
    13, -28, -4, 3, 10, -2, -32, 2,
    -30, 5, 0, 2, 1, 32, 11, -8,
    -36, -12, 25, 13, 29, 49, 10, -9,
    -40, 17, 8, -14, 2, 7, -6, -1,
    -9, 28, 13, -20, -102, 8, -5, 10,
    17, -13, 3, 18, -23, -9, -8, -14,
    29, 10, 9, -5, -61, -7, 21, 20,
    19, 31, 5, 6, -5, -3, -5, 3,
    19, -47, 50, -9, -7, 30, 65, 2,
    -7, 17, -9, 30, 0, 10, 9, -12,
    -9, 1, 10, 10, -22, 67, 5, 18,
    -2, 13, -1, -11, -11, 12, -7, 4,
    0, -21, 9, -9, 13, 10, -11, -36,
    -5, -6, -7, 9, 8, -8, -10, 9,
    -27, 23, 4, 8, -11, -57, -19, 0,
    2, 12, -20, -4, -3, 0, -6, 4,
    1, 34, -4, -16, 41, 34, -17, -3,
    2, -3, 20, 3, -7, -5, 23, -6,
    25, -10, 43, -8, -32, 18, 33, -7,
    -8, 5, 11, 16, -1, -1, 4, -2,
    -11, 11, -7, -50, 16, 10, -15, 32,
    -5, 25, 7, 4, -14, 0, 7, 23,
    -4, 1, -1, -12, -29, 1, 30, -23,
    2, -16, 11, -3, -9, 3, 0, -5,
    -20, 16, 27, -10, -16, 4, -5, -7,
    22, -14, 12, -18, 24, 15, -11, 34,
    -22, 5, -41, -8, -28, -25, 8, 20,
    9, -22, 27, 7, 11, 7, -6, 2,
    23, -15, -78, 44, -59, 2, 11, -18,
    5, -18, 24, -29, -17, -4, -11, 12,
    26, 15, 44, -10, 30, 31, -4, 69,
    -25, -7, 21, -28, -2, -13, 2, -1,
    -4, -4, 14, 11, -6, -41, 45, 34,
    -10, 8, -40, -18, -2, 15, 38, 9,
    -25, 16, -38, -9, -3, 5, 35, -14,
    7, -5, 40, 6, 0, -2, 7, -2,
    0, -28, 39, 17, 32, 16, 1, 58,
    -14, 2, 15, -14, 3, 16, 35, 5,
    0, -32, -38, 22, -3, -5, 40, -33,
    -6, 11, -27, -22, -12, -1, -11, -3,
    -14, 0, 12, 1, -11, 25, -7, -7,
    -33, -5, 34, 25, 14, 7, -2, 9,
    -42, -14, 13, 16, 0, -11, 14, -6,
    12, -12, -15, 8, -4, 0, 6, -2,
    -2, 2, -21, 4, 0, -62, 68, -44,
    -2, 3, -52, 12, -13, 9, 14, 19,
    -2, -19, 37, -32, 47, 32, -19, 22,
    6, -7, 0, 3, 16, -8, -1, 1,
    -9, -33, -7, -25, -34, -18, 7, 7,
    11, 4, -27, -7, -2, 2, 18, -3,
    29, 31, 30, 9, -15, 29, 23, -39,
    7, -8, 4, -19, -8, 1, 12, 3,
    -41, -8, -9, 9, 48, -1, 9, -13,
    15, 2, -11, -1, -6, 13, -11, -14,
    5, -3, -21, -44, -4, -17, -5, -40,
    -23, 13, 15, -2, 8, 5, 4, 4,
    6, -37, -18, 22, 30, 12, 21, 65,
    5, 0, -40, 7, 9, 30, -8, 11,
    -14, -55, 20, -10, -1, 18, -22, 10,
    -8, 19, -2, 30, 3, -3, -6, 0,
    -13, -5, 42, -21, -52, -29, 4, 12,
    6, 11, 29, 26, -8, -4, 14, -25,
    5, 8, 35, 2, 20, -21, -4, 5,
    -2, 35, -19, 28, -2, -3, 16, 3,
    6, 51, 20, -13, -22, 27, 18, 15,
    -12, 16, -41, -16, -11, 8, -5, -13,
    -8, 1, -54, 5, -59, 46, 11, -20,
    0, 16, 10, -28, 8, 19, -4, -4,
    3, -21, -3, 31, -39, -10, 13, -18,
    -11, 22, 9, -10, -26, -6, 9, 13,
    34, -17, -7, -40, -16, -10, 34, 46,
    -2, -15, 11, 11, -2, 1, 8, 3,
    30, 56, 32, 4, -29, -19, 24, 18,
    -11, 18, -5, -14, -17, 1, 5, -14,
    6, -18, -30, 26, -55, 14, 23, -3,
    -12, -10, -3, -19, 4, -4, -2, 1,
    -16, -33, -57, -14, -12, -14, 18, -10,
    12, 19, 20, 23, 10, -9, 30, 3,
    21, -13, 36, 34, 0, 2, -5, -23,
    34, -10, 26, 13, -5, 0, 11, -1,
    44, -6, -20, -41, -31, -10, -4, -21,
    -14, 29, -34, 29, -3, -3, -12, -26,
    62, -16, 22, 24, 11, -3, 4, 14,
    44, 5, -39, 5, -1, 2, 2, 9,
    22, -7, -29, -3, 25, 14, 2, 10,
    -16, -34, -35, 19, -34, -11, 0, -15,
    -9, -23, 32, -7, -28, -16, -20, -12,
    -28, -3, -18, 4, 4, 5, 2, 3,
    15, -12, -7, 4, 17, 19, 14, 59,
    25, -31, -22, 49, 7, 0, 3, 20,
    -35, 35, -14, -9, 25, 62, -18, -54,
    30, -8, -9, -32, 12, -3, 6, -3,
    9, -10, 30, -1, -9, -35, -27, -8,
    12, 4, 34, 12, -9, -17, 20, 21,
    -8, 38, -17, -6, 22, 11, 1, -29,
    -18, -17, -12, -9, -2, -3, -14, -6,
    3, -21, 13, -27, 41, 29, 48, -41,
    -44, -19, 8, 27, 1, 0, -16, 10,
    -24, 51, 1, 11, -11, 51, 46, -44,
    -4, 10, 12, -2, 2, -2, 12, -6,
    32, -29, 34, -27, -52, 7, 12, 42,
    15, 18, 3, -49, 17, 3, -2, 5,
    32, 66, 17, -6, 28, -5, -11, -36,
    -13, -17, -2, 3, -5, -6, -6, -4,
    -15, 3, -37, -28, -16, -30, -46, -18,
    7, -21, 23, -49, -6, 10, -11, 58,
    -33, 4, -12, 42, -23, -9, 12, -44,
    -4, 15, -9, 31, 5, 4, -10, 0,
    8, -36, 4, 7, 26, -39, -35, 38,
    -4, -12, 12, -25, -11, 25, 6, 3,
    -20, 5, 10, 13, -14, 0, 38, 10,
    1, 25, 0, -32, 2, -3, -6, 0,
    -5, -27, 47, -15, 2, -6, 56, 8,
    14, -3, 35, -19, 16, 11, -21, 1,
    14, -1, 27, -35, -34, 13, 32, -14,
    -27, 0, -13, -5, -4, -4, -6, 2,
    -6, -14, -17, -25, -3, -14, 1, 14,
    13, 31, -6, -20, -19, 2, -6, -10,
    11, -31, 13, 28, 6, 29, -8, 36,
    0, -31, 42, 12, 11, 9, 1, -3,
    -6, -22, -15, 12, 14, 11, -28, 7,
    -18, -19, -23, -15, 1, 7, -1, 19,
    -30, 7, 3, 23, 8, -8, -14, 2,
    -9, 21, -17, -22, 3, 5, 5, -16,
    26, 23, 32, -4, 30, 32, -3, 13,
    -54, 1, -49, -13, 20, 11, -2, -12,
    -12, 27, 26, 5, -16, -16, 27, 47,
    -28, -22, 7, -8, 5, 2, -8, -4,
    -2, -34, 7, 30, -34, 13, 19, 12,
    17, -10, -12, 35, -9, 8, 7, 19,
    -49, -14, 22, 31, -5, 4, 8, 30,
    -29, 17, 14, 25, 1, 8, -4, 8,
    -9, -12, -29, 28, 13, 51, 37, 30,
    -28, 11, -10, 0, 6, 3, -11, -3,
    10, -47, 27, -35, -26, -9, 26, 25,
    -39, 2, -1, -9, -3, 9, -3, 3,
    -15, 43, 33, -4, 2, 78, 31, 1,
    -25, 41, 1, -1, 3, 3, -16, 6,
    -2, -8, -44, 1, -2, 14, -31, 0,
    -17, 21, -10, -22, 6, 5, 1, 4,
    23, 16, 7, -26, -17, -23, -58, 10,
    1, -43, -1, -18, -13, 15, -12, 6,
    -33, 25, -5, -13, -27, -36, -1, -18,
    8, -24, 12, 3, 3, 2, -7, -3,
    -11, 41, -22, -13, 20, 47, 46, -2,
    17, 26, 8, -39, -8, -42, 15, -6,
    25, -52, 40, 43, -18, -12, -5, -6,
    1, -9, 42, -12, 1, -2, -1, 4,
    -40, -36, -18, -38, -4, -12, -61, 58,
    5, -9, 61, -19, -20, 6, 0, -6,
    -12, 38, -15, 22, 30, -25, 18, -6,
    -4, 12, 33, 8, 0, 2, -7, 2,
    28, 41, -22, 24, -15, -2, -7, -42,
    19, 57, -71, 12, 31, 17, 20, 29,
    -16, -16, 30, 31, 44, -22, -34, -23,
    9, 13, -5, -4, 7, 5, 0, 0,
    -5, 8, -2, 65, 1, -16, 8, 16,
    56, 6, -15, 0, 1, 4, 1, 21,
    12, 39, 30, 29, 11, 57, -51, 7,
    -3, 14, -19, 25, -1, -6, 1, 3,
    -19, 2, 10, 3, 23, -25, -34, -55,
    -22, -24, -31, -1, -3, 24, 30, 15,
    16, -54, 20, 30, -35, 15, 50, -5,
    -11, 38, 2, 57, 4, -2, 1, 1,
    -18, -22, 37, -19, -2, 11, 86, -35,
    24, 3, -25, 0, 2, 27, 55, -17,
    -48, -15, 103, 1, -63, 26, 37, 5,
    23, 29, -30, -29, -7, 0, 3, 4,
    -21, -21, 72, 24, 15, -29, 22, -26,
    9, 14, -23, -22, 20, 35, -10, -10,
    -25, -17, 79, -17, -24, -19, 6, -12,
    6, 1, -7, 9, -3, -3, 2, -1,
    32, 27, -41, 42, 33, -3, -46, 35,
    3, 17, 0, -5, -13, 23, -18, 14,
    -79, -32, 3, 9, 14, 29, -15, 1,
    40, -6, 41, -4, 11, -9, 4, 4,
    -31, -38, 15, -30, -10, 24, -32, 13,
    -29, -2, -53, -18, -12, 16, 28, 1,
    44, 3, -3, 10, -53, -30, -16, 21,
    6, -17, 19, 7, -6, -2, -2, -9,
    36, 18, 11, 57, 33, -20, -30, 7,
    -65, 8, 20, -1, -23, 13, 2, -8,
    60, 3, -3, 0, 5, -19, 6, -3,
    2, -1, -12, -32, 2, 16, 0, 1,
    3, -66, -41, -3, 1, -19, -54, 6,
    24, -44, -13, -40, 12, 20, -9, 17,
    0, 20, 28, -15, 14, -13, 2, -24,
    -52, -8, 31, 6, 0, -6, -7, 2,
    -15, 5, 10, 8, -65, 33, 19, 20,
    -23, -6, -55, 43, -9, 5, 20, -32,
    -7, 1, 11, -38, -12, -38, -25, 30,
    24, -16, -20, -13, 1, 2, 10, 1,
    11, -13, -19, 7, -37, -6, -7, 22,
    -11, -68, 11, 8, -12, 4, -9, 31,
    23, -33, 6, 28, -30, 7, -8, -23,
    -22, 14, -3, -14, 20, 18, -4, -8,
    53, -11, -10, 37, -24, -23, -36, -44,
    2, -33, -3, 11, -15, 10, -10, 15,
    -7, -1, 16, -9, 29, 1, 8, 5,
    -3, -6, -16, 9, 1, 2, 9, 2,
    43, 64, -38, -3, 4, 8, -54, 9,
    -10, 30, 23, -2, -6, -14, -44, 8,
    12, 3, -31, -5, -58, 37, 43, -35,
    -16, 0, 0, -12, 11, -4, -4, -9,
    5, 4, 1, 1, 18, 18, 21, -7,
    -13, -5, -19, 8, 24, -6, 18, 1,
    22, -9, -33, 31, -17, -18, -8, -21,
    -32, 2, -6, 3, -9, 0, 8, -5,
    31, 8, -11, 8, -72, -16, -12, -7,
    -12, -26, 9, 25, 9, -6, -15, -49,
    -26, 66, -25, 9, -66, -27, 6, 12,
    -36, -8, -67, -10, 7, -41, 12, -22,
    53, 4, -32, -20, -31, 3, 8, 2,
    49, 19, 6, -6, -34, 1, 1, -17,
    -15, 33, -15, -23, 36, -52, 21, -54,
    -19, 15, 0, -13, 6, 15, 0, 2,
    -13, -52, 32, 56, 35, 13, -8, -68,
    -37, 7, -5, 33, -16, 1, 11, 30,
    24, 2, 7, 110, 41, -11, -7, 30,
    5, 23, 3, 16, -3, 6, 15, 22,
    -16, -94, -2, -17, 32, -41, -19, 0,
    -1, -2, 37, 24, -1, -57, 31, 32,
    -33, 37, -22, 24, 2, -32, 30, 11,
    43, 43, -9, 33, -3, -4, -13, -15,
    -21, -49, 32, 6, 67, 18, -17, -18,
    -63, -15, 34, -7, 9, 33, -26, -28,
    -22, -51, 12, -57, 36, 3, 14, 4,
    0, 41, 32, -31, -2, -21, 18, -17,
    -52, -23, 29, 13, 22, -15, 32, -8,
    22, 13, -4, -21, 13, 15, -17, 16,
    -37, -21, -39, -3, -4, 25, 9, 2,
    30, 31, 30, -44, -16, 1, -11, -11,
    -9, 7, 18, 74, 30, -32, -6, -9,
    1, 2, 13, 35, -19, 12, 10, 67,
    -73, 30, -45, -45, 64, 23, -8, 77,
    4, 1, -16, -22, 8, 7, 16, -3,
    40, 4, -26, 14, 9, 41, 19, -2,
    -18, 23, -25, -26, -15, 35, -14, -1,
    32, 10, -22, -21, 91, -24, -8, 1,
    13, -2, -33, 41, -3, 25, -6, 3,
    0, -18, -24, 21, 58, 8, -20, 39,
    -9, 13, -49, -43, 16, 2, -1, -5,
    10, 6, -97, -8, -30, 29, -23, 19,
    -61, -16, 38, -96, -8, -5, 11, 5,
    -17, 39, -11, -19, -14, -44, -17, 52,
    -32, -31, -1, 34, -29, 26, -15, -28,
    -9, 56, -4, -38, -11, 23, -81, 41,
    -3, 34, -7, -10, 4, 5, 2, 3,
    7, 16, 2, 1, 24, 25, -30, 0,
    -5, 15, 36, -28, 2, 6, -27, 34,
    -20, 108, -13, -22, 7, 62, 33, -44,
    29, -8, 12, -11, 16, -4, 7, -16,
    -17, -9, -9, -16, 49, 39, 34, -56,
    -28, -20, -36, -40, 49, -4, 32, 19,
    -38, -6, -66, -52, 38, -82, -104, 1,
    45, -30, -22, 27, -10, 8, 10, -8,
    -36, 25, 46, -9, -52, -72, 15, -14,
    48, -11, 2, -16, -46, -42, -5, 4,
    66, -1, -27, -43, 12, -15, 3, 17,
    -2, -4, 2, -39, 7, -6, -57, 18,
    -21, -72, 44, -19, 5, -42, 54, 23,
    33, 5, -11, -33, -17, -42, -27, -15,
    23, 106, 93, -27, -10, -85, 23, -50,
    -19, 30, -47, -12, 13, 9, -3, 3,
    -32, -13, 20, 19, 30, 99, -32, -11,
    -11, -1, 0, 6, -14, -34, 7, 20,
    28, -69, -69, 26, 23, 6, 38, 21,
    6, 19, -16, -10, 30, -12, 16, 28,
    -91, 69, -13, 32, -72, -37, -63, 31,
    -36, -48, -7, -31, -29, 14, -10, -3,
    41, -64, 18, -3, -42, 79, -15, 1,
    44, 47, -19, 42, 2, -7, -7, -4,
    -18, -6, -24, 29, 16, -29, 0, -61,
    5, -72, -23, 17, 4, -28, -6, -15,
    19, 75, -94, -32, -10, -47, -50, 27,
    -61, -15, -28, 1, 6, 1, -13, 3,
    -14, 2, 31, 28, 14, 50, 36, 29,
    -16, -1, -16, -1, -19, -16, -4, -41,
    8, 34, -24, -1, -9, -29, -55, -40,
    -36, 45, -26, -1, 5, -8, 16, -1,
    31, -33, -8, -36, 56, 20, 46, -25,
    26, -15, 29, -8, 39, 15, 11, 6,
    -99, -1, 1, 38, -7, -22, 14, -41,
    -50, 0, 17, 24, -16, -3, 7, 3,
    53, -56, 15, 61, 15, -7, -80, 46,
    10, -59, 5, 2, -4, 49, 12, -15,
    67, -62, -48, -21, 67, 15, -45, -12,
    31, 0, -10, 1, -2, 14, -9, 34,
    16, 113, -35, -1, -29, -23, 27, -79,
    -4, 10, 66, 20, -18, 49, 52, 24,
    -10, -118, -62, 12, -14, 28, -14, -44,
    -8, 29, -18, 91, 8, -5, 9, 2,
    -10, 11, -114, 5, 43, 10, -2, 52,
    6, 49, -90, -39, -24, 34, 112, 17,
    34, -6, 18, 20, -14, 50, -21, 12,
    -11, 21, 5, -16, -1, -4, 11, 6,
    -27, 68, 15, 26, -6, 42, 65, 2,
    3, 1, -37, 8, 21, 25, 8, 4,
    14, 24, -17, 25, -33, 21, -60, 16,
    -22, 42, -18, -10, 10, -25, 0, -1,
    13, 0, 76, -32, 65, 11, 3, -50,
    -28, 0, 31, -52, -30, 28, -35, 33,
    -9, -36, -58, 4, -108, -21, 2, 14,
    3, 20, -10, 15, 3, -22, 1, 6,
    3, 19, 97, -50, -70, 6, 5, -6,
    -7, -8, 31, -15, -36, 28, 45, 16,
    -72, -20, -46, -28, 1, -20, 67, 37,
    -15, -1, 13, -24, 7, -21, 3, -7,
    -44, 19, -24, 2, -24, -25, 3, -33,
    -8, 1, -27, -17, -29, 0, -16, -4,
    -28, -16, 21, -86, -18, 59, -73, 74,
    65, -12, -29, 43, -16, 68, -5, -4,
    19, -3, 70, 4, 48, -18, 5, -60,
    9, -11, 29, 16, 5, -9, -15, 16,
    -1, 18, -1, -11, 26, -26, 45, 74,
    -59, 5, -49, 18, 0, -9, -2, 14,
    -18, -21, -10, -1, -79, -12, -38, 38,
    -7, 13, -13, -46, -3, -4, 4, -17,
    -15, -22, -23, 25, -7, -35, -40, -16,
    66, 35, 0, 18, 4, -4, 3, 22,
    64, -29, -72, -8, -22, 19, -74, -45,
    -27, -15, 70, 5, -22, -30, 3, 48,
    75, 9, 40, 1, -10, -24, -27, 28,
    -29, -20, -31, 33, -27, -7, 3, -10,
    -62, -26, 32, 18, -5, -32, 9, -84,
    -14, 22, 6, 11, -19, 7, 3, 40,
    -3, 29, 63, 7, 76, -13, 15, -39,
    42, 87, -5, -6, 1, 4, 7, 3,
    51, -77, -33, 32, -10, 8, 5, -66,
    7, -30, 12, 4, 10, 1, -49, 37,
    61, 9, -27, -3, 20, -23, -18, -23,
    -2, 45, 33, 61, 127, 1, -5, -9,
    -9, -4, 40, 25, -14, -28, -83, -4,
    25, -22, 13, 4, -13, 3, 37, -13,
    4, -2, 52, 26, 27, -36, -15, 1,
    34, -12, -12, 42, -12, 5, -7, -3,
    4, 13, 13, 13, -7, -19, 5, 28,
    -10, -3, 3, 11, 6, -18, 1, -4,
    3, -12, 30, -7, -51, 52, -11, -11,
    53, -51, 43, -19, 8, -11, -41, -3,
    -14, -6, -3, 5, 26, 24, -15, 17,
    31, 20, 21, 14, 2, -6, 17, 7,
    1, 10, -2, -17, -9, 34, -15, 4,
    12, -15, 62, 7, -23, 71, -20, -26,
    -20, -26, -30, 17, -8, 4, 42, 42,
    -9, -15, 31, -53, 4, 13, 14, -15,
    -14, 2, -9, 5, -1, -15, -29, 2,
    4, 2, 69, 4, 8, 2, 7, -16,
    -10, -15, -17, -13, 6, 22, 34, 24,
    -12, 24, -1, 10, -13, 21, 10, -10,
    -8, 3, -12, -10, 5, 6, 7, -11,
    -21, -29, -24, -14, 14, -3, 2, 19,
    22, -33, 10, 25, -18, -57, -7, 2,
    -7, 17, -2, -6, 1, 1, 4, -12,
    -12, -5, 22, 5, 36, 8, 69, 38,
    26, 7, 15, 22, -1, 35, 59, 9,
    -15, -14, -20, -2, -16, -3, 19, 10,
    -2, 20, -12, -2, -9, 22, 10, -16,
    12, 7, 13, -19, -9, 29, -52, 26,
    39, -13, 43, -8, 13, -51, -25, -11,
    -3, -9, 15, 58, -20, 28, -9, -19,
    16, 15, 4, 14, -5, -4, 3, 9,
    20, -8, 7, -12, -51, -24, 11, -20,
    -56, 15, -61, 33, -15, -19, -29, -1,
    -7, -51, 12, -16, -15, -9, 21, 31,
    -9, -11, -43, 5, 16, -8, -11, 8,
    -4, 3, -4, 14, 37, -53, 4, -40,
    22, -10, -18, -2, 0, -12, 4, 14,
    22, -17, -50, 44, 12, -19, -17, -9,
    -12, -9, -56, 21, 3, -15, 12, 22,
    1, -12, 2, -19, 0, -66, -3, -45,
    5, 30, 33, 31, -35, 7, 8, -23,
    21, 57, -25, 7, 15, 28, -4, 28,
    20, -18, -6, 22, -6, -13, 7, 9,
    1, -4, -5, -22, 30, -1, 6, -15,
    -19, -34, -46, 16, -38, -20, -9, 28,
    17, 52, 10, -6, 5, 51, 18, -38,
    -2, 31, 65, -64, 16, 8, 7, -3,
    23, -15, 15, -19, 34, 8, 12, 10,
    -63, 38, -4, -14, -48, 21, 21, 26,
    5, -18, 23, -21, -8, 36, -16, -28,
    -8, -48, -7, -28, 15, 7, 8, 26,
    -10, 11, 8, -14, -33, 8, 11, 10,
    5, 54, -8, 6, 21, 3, -33, -38,
    8, 38, 5, -15, -24, -9, -31, 11,
    9, 15, -26, -5, 12, -8, 7, 17,
    16, -9, 18, 6, 28, 24, 44, -21,
    -27, -16, 22, 50, -15, -23, 48, -13,
    12, -23, -5, 18, 10, 38, 2, 4,
    42, 54, 9, 40, 4, -5, 8, -4,
    1, -23, -15, -1, 48, 13, -28, 26,
    16, -4, -74, 7, -18, 15, 26, 26,
    -16, 8, -11, -5, 34, 16, -45, -46,
    -1, 47, 33, 3, -6, 3, 8, 13,
    -10, 1, -15, 14, -14, -44, -26, 38,
    36, -18, -50, -42, -41, 19, -14, 33,
    -40, -6, 10, -16, -35, -30, 23, -3,
    3, -16, -24, -41, 0, -23, 5, -6,
    5, 20, -28, 5, 10, -5, -4, -12,
    14, -36, 25, 41, -8, -43, 1, -16,
    9, -34, 34, 21, 24, -54, -11, -1,
    -20, -10, -6, 40, -10, -1, -12, -8,
    -10, 0, 19, 4, -8, -16, 3, 2,
    -14, 25, 34, -43, -4, 9, -1, -26,
    -41, -16, -11, -42, 23, -13, 46, 12,
    -23, -12, 20, 28, 0, -14, 10, -6,
    -6, 5, -3, -6, 25, 14, -17, -28,
    24, 27, 9, 83, -17, 10, 2, 0,
    -19, 14, 25, 1, -34, 3, -20, 23,
    -24, 14, -23, -15, -2, 13, 0, -12,
    22, 12, 7, -17, -34, 1, 28, -3,
    0, 39, 36, 7, -12, -8, -12, 10,
    -39, 20, 37, -32, -15, 5, -15, -53,
    15, -14, 5, 1, -12, -11, 5, 16,
    9, 11, 4, 2, 2, -5, -6, 20,
    -9, -35, 14, 24, -11, 2, -2, 19,
    8, 7, -7, -22, -4, 54, -13, 26,
    8, 7, -59, -1, -12, -13, 7, 25,
    -1, -34, 4, -2, 12, -15, 59, 24,
    -31, -15, -17, -26, 7, -19, 18, 1,
    -26, -26, -87, 46, 22, 19, 23, 11,
    -4, 2, -36, 10, -7, 5, 10, 22,
    -12, -1, -1, 0, -36, -9, 2, -2,
    30, -3, 4, 17, 0, -23, -8, -49,
    -7, 6, 12, 31, 2, -45, -15, -3,
    41, -7, -5, -8, 2, 14, 6, 23,
    4, -10, 11, -4, -20, 17, -13, -14,
    -57, -30, 38, 40, 38, -6, -13, 45,
    12, -7, 26, -15, -31, -24, -2, 21,
    -11, -28, 1, -31, 7, -13, 14, 0,
    1, -21, -21, 21, 23, 25, -42, 25,
    11, -42, -11, 51, 16, 19, 8, 18,
    38, -2, -24, 3, 2, -62, 1, -5,
    27, 14, 10, 13, -16, -2, 8, -19,
    -5, -6, -19, -24, 7, -5, 2, -70,
    -10, -18, -58, 27, 0, 23, 48, -22,
    -21, 27, -50, 3, -21, 31, -15, -3,
    9, 0, 11, 5, -15, 2, -9, 20,
    4, -1, 1, 7, -12, -20, 34, -36,
    26, -35, 17, -4, 17, -6, -23, -13,
    16, 7, 44, -14, 31, 20, 31, -20,
    1, 30, -24, 12, -1, -1, -9, 16,
    -10, -2, -27, -3, 13, 11, -8, 18,
    -18, 8, 8, -42, -2, 18, -9, -2,
    -2, 25, -4, 11, 18, -21, -28, 24,
    -22, 12, 26, -8, 4, -2, 1, -1,
    -15, 0, 10, 2, -7, -29, 26, 8,
    4, 75, -27, -42, 14, 6, 39, 15,
    15, -15, -27, -33, 10, -26, -22, -19,
    -23, -7, -46, 28, -2, -9, 20, -17,
    -1, -18, -41, 24, -47, 33, -12, -60,
    -1, 7, -6, -20, -31, 40, -5, 17,
    -6, -35, -11, 10, -21, -30, -22, 10,
    30, -10, 16, 24, 5, 0, -24, 5,
    -19, 12, -1, -6, 16, 16, 30, 34,
    10, -4, -8, -7, -18, 20, 23, 16,
    3, -62, -12, -29, -30, 7, 27, -35,
    -21, -63, 22, 8, 1, 11, 4, -15,
    -1, 18, 21, 24, 11, -13, 41, -4,
    -53, 27, -25, 12, -12, -2, -22, 23,
    20, 7, 26, -17, -14, -4, -22, -26,
    -1, 12, -24, 15, -7, 25, -17, -13,
    10, -1, -10, 1, 14, 23, 39, -4,
    -52, -10, 18, -16, -1, -27, 20, 20,
    31, 20, 10, -34, 35, 17, 18, 31,
    23, 13, 10, 14, 9, -1, 14, -6,
    7, 1, 28, 0, -24, 38, 6, -32,
    86, -25, 19, -10, -27, -39, -13, -24,
    -1, 15, 9, -7, -13, 4, 31, -11,
    -1, -17, -6, -5, 20, -10, 32, -5,
    1, -3, 9, -9, 18, 20, 49, -10,
    -2, -42, 33, 0, 7, 26, -27, -2,
    -20, 7, -8, 26, 7, -3, -26, 13,
    3, 28, -1, 32, -8, 9, 5, -8,
    -2, 4, -10, 17, -29, 6, 0, -36,
    4, 24, -32, -40, -5, -1, 58, 1,
    1, 0, -16, 10, 3, -17, 23, -3,
    9, -15, -12, 18, -11, -7, -4, 8,
    -3, 1, 4, 0, 6, -1, -39, 29,
    8, 33, -16, -15, 0, -6, -23, -1,
    -9, -1, -10, -36, 29, -15, -23, 74,
    13, 53, 18, -67, -3, 1, 16, -35,
    -11, 1, 9, -12, -15, 22, 30, 13,
    19, -39, 0, 18, -32, -18, 20, 17,
    -22, -14, 23, -31, 5, -41, 3, 98,
    -41, 45, -23, 36, 5, 16, 7, 19,
    9, -4, 14, -27, -42, 4, -67, 36,
    37, 3, 55, -59, -20, -16, -88, -41,
    54, 8, 13, 1, -18, 20, -8, 21,
    -27, 4, -12, -42, -19, -24, -19, -5,
    17, -26, -19, 11, -27, -11, 23, -36,
    -3, 34, 22, 37, 57, -1, 12, 9,
    -1, -59, 21, -7, -25, 38, 8, -14,
    7, -54, -1, 0, 2, -5, -10, -5,
    -8, 16, -6, 0, 14, 28, 45, -13,
    28, 1, -17, 38, -20, 5, 4, 30,
    1, -5, 18, 25, 6, 22, -22, -16,
    -12, 12, -16, 16, 4, 9, 18, 12,
    -4, 3, -16, -23, 10, 8, 55, -40,
    4, 14, 22, 12, -14, 1, 10, -36,
    0, 71, 11, -3, 16, -63, -18, 18,
    -36, -23, 0, 26, -23, -11, 9, -4,
    35, -2, 8, -16, 26, -16, 33, 30,
    7, -21, -1, -10, -27, -18, 40, -6,
    -6, 33, -6, -9, 40, 12, 27, -12,
    -39, 24, 18, -48, -5, 6, 29, -12,
    18, -11, 25, -21, 33, -53, 22, -4,
    -110, 26, -16, -6, -3, 18, 20, 14,
    -10, 2, -18, -35, -13, 26, -27, 1,
    50, -60, 40, -20, 22, 5, -7, -4,
    -23, 4, -11, -19, -3, 13, 19, -8,
    39, -32, -42, -14, 39, 9, -28, -21,
    -47, -10, 8, 12, 21, 26, -25, -38,
    8, -13, -35, 37, 15, 11, -2, 16,
    14, -19, -3, 5, 31, 46, 32, -70,
    -27, 27, -8, 59, 36, 8, 24, -2,
    41, 34, -46, 17, 15, -127, 34, -15,
    19, 56, 42, 78, 10, 3, 22, 0,
    22, 5, -13, -6, 28, 42, -14, -21,
    17, -3, -16, 28, -41, 35, -17, -9,
    0, -51, 27, -19, 9, 5, -6, -57,
    11, -8, -17, -12, -7, -18, 12, 8,
    -3, -15, -14, -9, -22, 114, 3, 6,
    54, 30, -17, -13, -12, 66, 11, 5,
    -3, 7, 9, -16, -10, -16, 9, -24,
    28, -18, -40, 10, -6, -4, -20, 6,
    -14, 18, -25, -2, -6, 33, -29, -27,
    -1, 12, 11, 21, -48, -16, 0, 8,
    13, -4, 15, 4, -22, -32, -18, -20,
    6, 22, 29, 34, -7, -7, -33, 4,
    -4, -46, -4, 10, -2, 6, -102, 20,
    8, -21, 59, -28, 1, 20, -16, 29,
    -5, -24, -87, 1, -17, 64, 60, -15,
    -43, -17, 4, 16, 2, -1, 1, -25,
    2, 13, -16, 6, 21, 1, -10, -8,
    20, -58, -17, -2, -12, -40, -10, 18,
    24, 22, 33, 1, -31, -62, 15, 26,
    75, -33, 12, -8, 32, -20, 16, 0,
    30, 17, 4, -29, 35, 10, -4, 10,
    -8, 38, -23, -3, 6, 45, -4, 21,
    -69, 19, 50, -7, -25, 13, -22, -66,
    20, 18, 3, 23, 6, -14, 7, 7,
    -3, 5, -17, -5, 4, 12, -2, -46,
    -33, -9, 52, 0, -13, 9, 16, -6,
    38, -8, 14, 33, 34, -9, -51, -19,
    23, -33, -26, 15, 4, 9, 14, 2,
    -4, -35, 8, -13, 1, -4, 13, -1,
    -21, 46, 47, 9, -10, -16, -50, 32,
    14, -23, 3, 30, -2, 34, -51, -23,
    -16, -12, 76, -2, 6, 7, -7, -7,
    -4, 8, -24, 12, -64, 18, 2, -15,
    1, -11, 55, 5, -43, -29, -11, -13,
    -11, 44, -11, 30, -5, -37, 38, 51,
    -19, -19, -68, -14, -4, -22, 1, 15,
    -1, -2, -6, -12, 0, -27, 20, -8,
    -86, -19, 92, 31, 25, 48, 0, -31,
    14, -11, 8, 0, -46, 1, 7, 16,
    -8, -3, -7, 10, 14, -18, 29, -13,
    3, -20, -9, 13, -23, 2, -22, -4,
    20, -24, -7, 42, 1, -2, 15, -27,
    -13, -9, -14, -16, 54, 43, -7, 42,
    50, 5, 19, 60, 23, 1, 21, -12,
    9, -25, -2, -17, 25, 1, 23, -27,
    57, -61, 25, -2, -18, 12, -41, -14,
    40, -17, 0, -20, 30, 34, -77, -27,
    22, -5, -19, 36, -31, 3, -27, 10,
    -14, -4, 6, -8, -12, 0, 23, 62,
    26, -29, 40, 32, -43, 26, 12, 16,
    -9, -16, -22, -7, 24, 9, 21, 31,
    9, 22, -16, 36, 1, 6, 4, -7,
    -1, -18, 0, -3, 18, -23, -1, -10,
    -19, -32, 27, 2, 14, 55, -14, 6,
    -12, 50, -15, -12, 11, -22, 33, 2,
    -2, 30, 34, -44, -4, -9, 13, 1,
    -8, 4, 3, -7, -9, 11, 27, 53,
    12, -7, -35, 55, -17, 5, -37, 26,
    9, -5, -20, -25, -4, -11, -2, -23,
    3, -2, -18, -38, -8, -22, 2, -6,
    1, -6, -14, 18, -35, 8, -1, 7,
    0, 16, -5, -2, -21, 21, 18, 54,
    -15, -9, -38, 11, -2, -5, -15, 2,
    13, 17, -7, 16, -2, 3, -4, 5,
    -17, 5, -25, 48, 68, 15, 25, -15,
    -17, 17, 6, -21, -28, 25, 11, -6,
    9, 2, 9, 3, -29, -20, -17, -21,
    -25, 2, -53, -41, 12, 4, 1, -20,
    -3, 8, 32, 24, 26, 5, -39, 9,
    -47, -23, 13, 26, -18, -12, -20, 25,
    -24, 27, 49, -10, -62, -48, -5, 15,
    14, -6, -23, 20, -6, 11, -17, 5,
    -14, 4, -11, -2, -9, -2, 66, 21,
    -11, -25, 23, 0, 42, 5, 13, 1,
    35, 66, -2, -6, -48, -19, -25, 5,
    22, -12, 6, 30, 63, 50, 5, 21,
    6, -22, 27, 9, 7, -42, -12, 26,
    -46, -64, -11, 29, 6, -6, -9, -16,
    20, 8, -29, 1, 2, 9, -1, -10,
    -14, -23, -33, 34, 26, -38, 115, -8,
    -2, -8, 29, -1, -23, -39, 41, -13,
    27, -59, 4, -23, -38, -81, -27, -22,
    -19, 14, 12, -6, -17, -11, -16, -51,
    22, -22, 19, -2, -7, -9, 16, -26,
    0, -5, -17, 3, 3, 27, -56, -27,
    1, -34, 21, 40, 10, 28, -54, -10,
    -3, 14, -15, 6, 34, -18, -30, 37,
    -11, 6, -8, 14, -28, -8, 5, 17,
    -9, -11, 1, -4, -20, -39, 41, 11,
    30, -74, 2, 15, 48, 35, 62, -20,
    -16, 44, -62, 12, 12, -18, 26, -6,
    17, 21, 21, 9, -30, -22, 0, -111,
    -33, -12, -4, -3, -52, -24, 10, 9,
    0, 26, 4, 52, -34, 40, -71, -14,
    27, 32, 9, -5, 55, -17, 116, -72,
    55, -1, -27, 8, 18, -9, 13, 41,
    14, -14, 1, -28, 78, -1, -24, 127,
    58, -7, 57, -39, 34, -6, -67, 63,
    1, -6, 23, -40, 6, -20, -2, -34,
    -4, 14, -9, 46, -56, -10, -17, -15,
    45, -20, -4, 17, -54, 0, -13, -8,
    64, 10, -69, 19, 26, 34, -29, -30,
    -14, 54, 42, 19, 7, -45, -26, -52,
    1, -49, -60, -23, 14, 16, -13, 19,
    -6, 18, 2, -8, 43, 55, 15, 7,
    78, -43, -54, 32, 29, 10, 94, 24,
    9, 8, 117, -19, -19, -36, 11, -2,
    -28, -2, -96, 44, 0, 16, 16, -11,
    -1, 13, -18, -30, -1, 43, 11, -17,
    -8, 7, -90, 31, -25, 35, -45, 5,
    -9, 86, 8, -11, -30, 86, 29, -12,
    -33, -41, -27, -4, -30, 17, -16, 3,
    40, 6, 7, -38, 54, -73, 8, 43,
    -16, -57, -7, -54, 70, -97, -22, -41,
    -8, -77, -4, 37, -62, -41, 45, 24,
    -79, 103, -5, 5, -22, 17, 103, -48,
    44, 3, 22, -29, -19, 10, 24, -9,
    -127, 45, 25, -6, 18, 4, 4, 14,
    -7, 19, 50, -15, 25, -56, -67, 47,
    50, -48, 1, 82, 84, 45, -44, -17,
    -33, 4, -20, -28, 40, -28, -4, -10,
    -39, 31, -2, -47, 59, -93, 34, -18,
    -41, -47, -27, 15, -27, 24, 20, -44,
    50, -55, -63, 82, -3, 31, -17, -4,
    -14, -35, -6, 8, 32, 55, 31, 42,
    -44, 23, 75, 28, 19, 11, 7, 15,
    54, 75, -10, 11, 61, 15, -60, -48,
    -56, 20, -11, 42, 30, -9, 56, 17,
    29, 26, -24, -16, -13, 57, 2, 25,
    -25, 23, 30, 17, -12, 22, 83, 25,
    15, 28, 70, 20, 6, -27, -14, 56,
    51, 6, 0, 0, 18, -8, 2, -15,
    -5, -6, -10, -23, -3, -63, 42, -78,
    -6, -33, 19, -43, 10, -62, 56, -89,
    34, 40, 34, 29, 24, -4, 17, -25,
    -15, -16, 34, 26, -1, -19, -12, 16,
    -12, 20, -30, 2, -30, -12, -45, 26,
    -21, 7, 18, -7, 1, -36, -7, 47,
    1, 56, -16, -14, -31, 76, 34, 28,
    -10, -42, 38, 91, -7, -14, -37, 27,
    -5, -79, -4, -5, -1, -4, -66, 5,
    11, 15, 39, 32, 22, 46, -12, 62,
    53, 8, -80, 14, -38, -7, 0, -74,
    23, -89, -24, 54, 9, 23, 7, -33,
    7, 16, -24, 12, 11, -19, 38, -43,
    -57, -45, -9, -13, -2, 8, 49, -17,
    44, -17, 40, 3, 60, 25, -48, 4,
    6, 52, -45, -20, 21, -45, 47, -3,
    32, 5, 14, -17, 14, -75, -3, -10,
    -75, 44, -22, -49, -13, -69, -2, -24,
    -115, 37, -19, -37, -98, -28, -22, -78,
    18, -41, 4, 26, -9, -15, 24, -1,
    4, 10, 2, -6, 16, 2, -60, -55,
    33, -53, 16, -30, 35, 46, -49, -14,
    16, -93, -5, 54, 2, -43, -35, 24,
    45, -14, -16, 49, -2, 2, 3, 3,
    -8, -31, 1, -2, 4, 27, 57, 7,
    -88, 26, 47, 38, -23, -13, 10, -60,
    -3, -3, 53, 13, -15, 17, -15, -51,
    -13, 35, 15, 23, -26, 10, 11, -48,
    -6, 8, -40, 15, 16, 41, -22, 45,
    14, 7, -53, 26, -2, -5, -7, 74,
    1, -7, 14, -47, 11, 52, -40, 14,
    -48, 22, 6, 7, -32, -45, 41, -2,
    16, 6, 7, -19, -18, 3, -24, -8,
    -118, 49, 41, 28, -76, 47, -10, -34,
    10, 10, -29, 57, -10, 51, 24, -4,
    -12, 0, 9, -14, -22, -50, 25, -26,
    -8, -25, 12, 8, -41, -26, -7, -25,
    31, -35, 6, 9, -90, -18, -43, 7,
    4, 29, -5, 10, 6, 4, 59, -19,
    115, -34, 19, 13, 80, -7, 62, 5,
    7, -40, -10, -3, -2, -32, 4, 41,
    -9, -46, -18, -13, 32, -22, 16, 80,
    30, -8, 36, 32, -25, 74, -15, 11,
    40, -4, -87, 52, -6, 31, -109, 71,
    -5, -2, -7, -10, 19, 34, -37, 80,
    -47, -24, -43, 7, 20, -20, 45, 55,
    -21, 21, -48, -13, 9, -38, -65, -37,
    8, 56, -8, 78, -5, 3, 4, 15,
    2, -15, -7, -4, 26, -45, 22, -3,
    -24, -10, 8, 47, -12, 45, 1, 60,
    -9, 38, -33, 21, 19, 45, 6, -37,
    -21, -25, -41, -19, -2, -21, 3, 0,
    -5, 2, 5, -15, -33, 21, 20, 1,
    22, 35, 22, -23, -17, 3, 47, 36,
    2, 4, -20, -23, 38, 14, 11, 0,
    -10, 27, -32, 17, 18, -32, -26, 11,
    1, -18, 13, 39, -12, 16, 22, 1,
    3, 8, 27, 62, 0, -48, 40, -20,
    -26, 47, -22, 18, 111, 12, -5, -29,
    -2, 17, 42, 37, -23, 9, -4, 12,
    -33, 3, -9, 127, -36, 9, -53, -10,
    -52, 14, -2, 9, 21, 20, -59, -13,
    -18, 44, -11, 51, 27, 11, 52, 31,
    -44, -58, -122, 26, 6, 16, -41, -17,
    4, 0, 3, 35, 19, -32, 46, -1,
    -18, -61, 64, 42, -37, -15, 70, -13,
    -48, 26, 2, -8, 14, 0, 50, -8,
    67, 1, 27, 42, 6, 19, -25, 14,
    -19, 10, -6, 7, -38, -47, -4, -5,
    25, -26, 5, -31, -1, 5, -4, 6,
    17, -32, -32, 52, -38, 59, -42, 1,
    0, 2, 7, -16, 9, 18, 24, 2,
    15, -10, 9, -25, -11, -3, 15, -16,
    -17, -2, 3, 44, -34, -43, -33, -16,
    -48, -20, 41, -8, 15, 31, 18, 36,
    8, -9, -40, 3, 14, -14, -2, 4,
    32, -5, 7, -17, 12, 3, 25, 7,
    13, -15, -13, 9, 7, -3, -12, -3,
    -61, 20, -9, 10, -17, 11, -41, -33,
    -25, -31, 1, -7, 6, -9, 20, -8,
    -5, -2, -23, 6, 17, 10, 36, 34,
    21, 9, 2, -41, 59, -49, -42, 31,
    -22, 44, -61, -51, 16, -1, -37, -10,
    -11, 26, 5, 5, -14, -3, -9, -22,
    -8, -19, 5, -1, 0, -13, 1, -5,
    -13, 14, -17, -50, 21, 32, 51, 36,
    -18, 33, 39, -20, -4, 35, -2, 25,
    19, -4, -1, 51, -7, 16, -32, -10,
    7, -8, -7, 9, -39, -6, -5, -8,
    5, 47, 25, -15, 47, -11, -22, 6,
    46, -10, -40, -16, 42, -12, 9, -31,
    4, 10, -15, 10, 13, -5, 5, 10,
    -18, 4, 9, 15, -7, -8, 27, 6,
    -9, 12, 0, 5, 18, 17, 33, 44,
    -6, -5, -32, -7, -38, -20, -36, -26,
    40, -20, 20, -23, 20, -17, -3, -10,
    15, 1, 7, 4, 22, -3, 4, -2,
    3, -14, 18, 6, -90, 71, 4, 10,
    0, 18, 23, -34, 18, -91, 4, -20,
    18, 2, -23, 21, -3, -12, -1, -6,
    2, 13, -21, -7, -1, -16, 24, -12,
    36, 3, -6, 13, 34, 41, -8, 50,
    -12, -23, -32, -2, -65, 19, -27, -30,
    -24, 9, 3, -2, 39, 1, 10, -6,
    -12, -18, -4, -26, -5, -15, 9, -2,
    9, 10, -38, -6, 12, -7, 61, -43,
    -23, -14, 3, -9, -33, 45, 26, -50,
    -17, 5, 5, 8, 7, 13, 12, 3,
    0, 17, -49, 9, 29, -19, -2, -4,
    -5, -32, -8, 19, 5, -53, 4, -40,
    -30, -12, -6, 15, -10, 39, -9, 23,
    -47, -13, 21, -25, -6, -18, 7, 5,
    20, -4, -1, -2, -12, 10, 11, 9,
    -7, 4, -11, -14, 17, -29, -10, -6,
    -17, 29, 36, 0, -32, -38, 11, 19,
    -28, 19, 5, -2, -12, -1, -12, -4,
    8, -2, 4, -7, -23, 9, 20, -25,
    8, 13, -42, -18, 80, 23, 25, -8,
    -18, 50, 15, -10, 7, -10, 14, 15,
    16, -5, -47, 5, -29, -5, -1, 7,
    14, -19, -9, -5, 14, 5, -12, 28,
    7, -1, -11, -3, 85, -54, 27, 6,
    -47, 2, 9, -49, -31, 19, 18, 12,
    -26, 11, -1, -8, 12, 5, 19, -5,
    -4, 15, 11, -5, -19, 0, 5, 11,
    5, -11, -20, 26, 7, -43, 19, 14,
    25, -49, 13, -3, 12, -9, -5, -1,
    7, -11, 25, -17, 2, -39, 6, -3,
    8, -12, -8, -2, -5, 44, 13, 3,
    -8, -14, 14, -2, 5, -18, 12, -11,
    -34, 12, 0, 13, 2, 16, -5, -4,
    2, -1, -7, -8, -13, 29, 15, -14,
    34, 21, 12, -5, -20, -21, 9, -14,
    -7, -3, 22, 10, 27, -28, -57, 101,
    -24, 11, 0, -2, 24, 5, -3, -52,
    18, 22, -4, 1, 26, 16, -7, 0,
    5, 1, 2, 9, -14, 16, -9, -24,
    22, -20, -17, 14, 17, -33, -7, -4,
    36, -9, 66, 22, -8, -20, 7, 35,
    -16, 14, 31, -9, -12, 0, -9, 10,
    12, 8, -21, 4, 12, -28, -3, 48,
    14, -6, 18, -5, -12, 35, -51, 22,
    16, 1, 11, -1, -34, 4, -9, -17,
    6, 8, 22, -15, 6, 0, -2, -38,
    0, -21, -6, -3, 23, 0, 5, -9,
    -29, 26, 16, -7, 101, 1, -2, -18,
    20, 49, 44, 7, 22, -23, -1, -1,
    -1, 9, -4, -8, -9, -9, 15, -6,
    -10, 20, 5, 3, 13, -23, -2, -6,
    41, -2, 27, -2, -4, -19, 37, 9,
    -14, -48, -6, 11, 10, -2, 43, -3,
    12, -10, 16, 2, 2, -13, -6, -20,
    6, -15, -13, -1, -11, -1, -7, 3,
    5, 32, 5, 23, -25, 45, -53, -8,
    -40, -19, -32, 12, 3, -63, -31, 8,
    -8, 21, -14, 21, 13, -3, -3, 9,
    29, 27, 5, -6, -2, -10, 13, 24,
    -9, 14, -7, 35, 14, 10, 16, -10,
    -50, -20, 40, -28, -52, -4, -24, 22,
    -37, 19, 9, -7, -25, -14, 18, 1,
    12, 2, -3, 16, 25, 16, 13, -21,
    0, -15, -10, 0, 15, 67, 58, 1,
    17, -40, -34, -21, 60, 12, 8, -2,
    -13, -12, -1, 19, 0, 15, -1, -9,
    -5, -9, 2, 9, -11, 5, 18, 0,
    4, -20, 4, 25, 3, 19, -27, -4,
    -1, 48, -7, -5, 44, 4, 18, 2,
    -3, -5, 12, -6, -11, 6, 22, 12,
    -27, 1, 12, 9, 17, -20, -17, -3,
    -9, 2, 19, 16, 29, 43, -46, 31,
    -15, 9, -10, 9, 21, 13, -31, -6,
    -4, -25, 25, -38, 3, 2, 13, 10,
    -25, 0, 10, 2, 7, 10, 10, 28,
    -16, 34, 44, -28, -69, -29, 10, 59,
    18, 34, 43, -15, -3, 7, 41, 15,
    28, 37, 19, -24, -8, 4, 15, 15,
    -6, -1, 7, -10, -4, -12, -6, 8,
    -5, 21, -16, 17, 11, -39, -4, 13,
    -13, -25, 19, 6, 16, -16, -33, 12,
    5, -6, 6, 21, -2, 0, 8, 13,
    -3, 5, 10, 4, 7, -5, 5, 6,
    -11, -14, 14, 64, -13, 26, -13, -44,
    -7, 16, 32, 3, -7, -17, 4, 63,
    -14, 27, -9, 34, 0, 10, 19, -7,
    3, -3, -37, -8, 0, -10, -5, -14,
    17, -3, -28, -30, -32, -11, 7, 16,
    -19, -24, 0, -16, -27, 14, 13, -11,
    10, -15, 7, -17, 11, -12, -12, 25,
    -29, -7, 4, 18, 3, 8, -19, 16,
    -11, 30, 6, 19, 22, 24, 3, 8,
    -39, -50, 57, 8, 13, -5, 1, 16,
    -4, -21, 21, 27, -9, 0, 1, 5,
    -12, -13, -15, 40, -11, 4, -26, -6,
    -3, 5, 46, 10, -34, 12, 25, 11,
    0, 27, -15, -13, 44, 21, 1, 5,
    15, 12, -11, -2, -1, -5, -19, 4,
    -7, 12, -13, -2, -10, 32, -19, 2,
    8, -10, 37, -8, 31, -43, -37, 19,
    -18, -37, -21, -18, -58, 59, 4, 46,
    -18, -43, 0, 31, -13, -2, 34, -7,
    8, -3, 1, 1, 11, 5, 7, -29,
    -30, -23, -1, -7, 20, -62, -11, -26,
    1, -3, 42, 31, 48, -24, 34, 14,
    3, -15, -48, -14, 15, 8, -1, 1,
    17, 3, 7, -23, 9, 12, 46, 5,
    41, -18, -12, 11, -7, 17, -7, -63,
    -6, 23, -1, 13, 9, 58, -38, -11,
    -23, -27, -25, 48, 17, 3, 3, 1,
    -7, -14, -4, -13, -4, -20, -7, -5,
    38, 52, -21, 4, 27, -1, -17, -23,
    -3, -25, -18, -25, 0, -57, -38, -1,
    -28, -3, 6, 18, -2, -8, -20, -5,
    -18, -14, 5, -9, -7, -8, -2, -12,
    -12, -13, -42, -44, 24, 23, 18, 31,
    -13, -116, 65, 16, -9, 13, 28, -31,
    18, -49, 31, 15, 10, 14, -15, 4,
    2, 6, -3, -1, -40, -1, -7, -14,
    -32, 0, 44, 8, 8, 36, -10, 24,
    40, -42, -40, -65, -11, 60, 18, 6,
    11, -24, -14, 3, 13, -5, 3, 23,
    -13, -15, 8, 13, 1, 1, -9, 21,
    16, 25, -13, -19, -31, 18, 40, 37,
    -59, 9, -58, 3, 22, -25, -6, 7,
    14, -4, -4, -5, -9, -15, -5, 1,
    -3, -5, -3, 16, 26, -8, -17, -4,
    23, -18, -18, 2, -18, 45, 23, 1,
    -29, 7, -23, 22, -14, 11, 42, -22,
    4, 5, -18, 33, 9, -4, -14, 5,
    10, -10, -15, -2, 15, 32, 9, -8,
    11, 7, -3, 18, 64, -22, 39, -21,
    5, -9, -55, -19, -80, -10, 67, -85,
    -24, 26, -1, -9, 31, -6, -11, -3,
    -19, -8, -11, -20, -1, -24, 16, -4,
    -8, 8, -24, -24, 7, 49, -27, -34,
    -19, 74, 26, -5, -15, -5, 41, -39,
    0, 18, 22, -4, -11, 8, 14, 0,
    -9, 11, -50, -1, -24, 12, -13, -11,
    -42, 16, 25, 18, 25, 7, 24, -17,
    9, 19, 10, 14, -17, -46, -38, 28,
    -13, 11, -4, -12, -9, 16, 7, 3,
    21, 14, 6, -13, -17, -3, 41, -5,
    7, 6, -27, -14, -35, -4, -40, 5,
    -10, -6, -32, 0, -10, 27, -25, -21,
    -7, 1, -12, 1, -2, -18, -4, 0,
    -10, -26, -9, -2, 44, 4, 3, -42,
    28, 6, 17, -16, 41, -8, 54, 7,
    23, -3, -4, -8, 8, -11, 36, 27,
    23, 25, -33, 5, -8, -17, 16, -3,
    11, -8, -10, -18, -1, 3, -16, 9,
    6, -7, 18, 27, -15, 8, 4, 43,
    30, 57, -26, 11, 0, 88, 8, -18,
    2, -26, -20, 6, 13, 16, 14, 7,
    14, 14, 20, 2, 18, -22, 19, 35,
    10, 37, -43, 25, 54, 24, -32, -29,
    2, 64, -35, 9, -26, -35, 15, 31,
    7, 12, -60, -15, -7, -16, -17, 10,
    15, -22, -16, -3, -20, 44, 16, 6,
    5, -46, -12, 29, -13, 31, -9, -29,
    21, -36, -16, -51, -11, 40, 8, 28,
    -6, -15, 17, 1, -23, 10, -3, -2,
    40, -14, 23, -20, 6, 16, 3, 1,
    2, -22, 5, -13, 40, -23, -29, 10,
    -33, -13, -3, -17, 22, 43, -41, 53,
    -5, -23, 44, -45, 10, 47, 6, -3,
    0, 11, -4, -6, -15, 26, -31, -11,
    4, -14, -43, 26, 9, -44, -6, 12,
    45, 18, 18, -25, 1, -53, 13, 68,
    -18, 14, 52, 13, 21, 8, 2, 8,
    13, -7, -26, 21, 24, -25, 21, 8,
    11, 7, 3, -18, -32, 4, -62, -13,
    12, -5, 20, -6, 47, 63, 17, -14,
    -60, -5, -44, -16, -2, -31, -7, -44,
    -12, -30, -26, -4, 7, -1, 38, -1,
    7, 27, -12, 2, 82, 1, 42, 44,
    -21, -49, -19, 17, 29, 2, -13, -4,
    28, 14, -39, 19, 13, -10, -24, 10,
    -2, -10, -4, 3, 25, 1, -1, -46,
    29, 15, -12, 5, -89, 25, 16, -60,
    -31, -22, -28, 21, -10, -37, -1, 28,
    -5, 46, 17, -15, 10, -29, -9, -40,
    3, -35, -13, -12, 0, 1, -14, 17,
    -9, 16, 15, 34, 11, 4, -24, 22,
    -9, -1, -11, -2, -14, -48, 31, 19,
    10, 11, -25, -9, -3, -6, -14, 9,
    27, 25, 17, -11, -1, 2, 9, -42,
    -17, 30, 27, -6, 19, -11, -8, 17,
    13, -29, 28, 34, -12, -53, -32, 14,
    22, -18, -57, 29, -3, 3, 14, 12,
    -20, 16, -3, 11, 12, -40, 50, 3,
    -11, -15, -75, -12, 78, 11, 1, -12,
    22, -47, -50, -48, 25, 18, -24, -48,
    12, -8, 17, 29, 0, 8, -22, -2,
    -8, -15, 9, 26, -12, -2, 14, -19,
    14, -32, 4, 1, -22, 14, -7, -4,
    -85, 7, 41, -29, 8, -50, -12, 4,
    -26, -19, 54, -4, 5, 5, 7, 10,
    -22, -1, 24, 29, 34, -10, -1, 11,
    -48, -40, -37, -7, -5, 51, -53, -1,
    -15, 40, -5, -8, -9, -24, 22, 15,
    -10, -3, 29, -10, 8, 15, 9, 9,
    -24, 6, 18, 8, 17, 11, -10, 67,
    -6, 58, 36, 7, -11, -43, 52, 42,
    9, -29, -9, -12, 33, 19, -7, -10,
    14, -23, 28, -12, -6, -7, -4, 1,
    -8, 3, 20, 6, 8, 24, 14, 51,
    13, 11, -39, 14, 29, -4, 10, 8,
    -17, -37, 40, 38, 45, -7, 21, 7,
    4, -5, 11, 41, -2, -9, 11, 3,
    -6, 2, -1, 10, 7, -6, -2, 9,
    -8, 20, 6, 68, -7, -37, -37, -53,
    -10, -5, 5, 10, -41, 51, 31, 52,
    0, 23, -12, 5, 0, 1, -6, 8,
    5, 2, -71, -3, -2, 2, -4, 22,
    45, -6, -13, -14, -2, 15, -1, 32,
    17, -6, 40, 1, 43, 62, -7, -52,
    -11, -16, 16, 12, 11, -17, 16, -11,
    -8, -21, 17, -17, 16, 8, -12, -21,
    9, 52, 18, 8, -3, 45, -39, 50,
    -11, -37, 1, -23, 29, 36, -25, 15,
    -9, -22, 21, 16, -7, 2, 3, -6,
    1, -4, 2, 29, 1, 12, -79, -30,
    17, -4, 3, -1, -14, 31, 11, -3,
    19, 4, -20, -14, 68, 1, 49, -24,
    -13, 13, -30, -24, 16, 2, -26, 11,
    -3, 7, -10, -5, -3, 32, -5, -4,
    4, 15, 37, -34, 39, -49, -28, 35,
    -35, 23, -33, -44, -2, -35, -81, 6,
    -41, -30, -1, -22, 10, 6, 1, -14,
    19, 5, 9, -16, 65, 35, 3, -17,
    -28, 13, 7, 59, -12, -117, -4, 44,
    19, -20, 7, -68, 68, 19, 66, 38,
    -3, -4, -65, 16, 8, -13, 0, -9,
    12, -6, 29, -20, -9, -7, 97, 11,
    1, -39, -40, -32, 15, -17, 8, -34,
    12, -25, -25, -29, 61, -59, 38, -12,
    -14, -31, -10, 61, 18, -22, 21, 11,
    -4, -3, 5, 0, 13, -10, -26, -3,
    73, 56, 0, -72, 54, 39, -5, 64,
    47, -12, 41, -3, -57, 27, -25, -22,
    -2, 9, -19, 12, -13, -20, -20, 14,
    -27, 13, -10, -7, 25, -15, 30, -6,
    25, 14, -10, -56, 26, -27, -39, 26,
    38, 22, -42, -79, -25, 63, 88, -26,
    -17, 30, 14, 39, -20, -11, -8, 28,
    -2, -21, -13, 16, -109, -20, 1, -29,
    -42, 60, 18, -34, -30, -10, 39, -64,
    -46, 71, -6, -16, 2, -72, -38, 105,
    10, 6, -6, -79, 3, -4, 10, 7,
    -21, 2, 21, 21, 41, 4, -8, 49,
    -61, -18, -4, -17, 12, 55, 51, 41,
    -25, 1, 124, -25, 28, 21, -44, -64,
    1, -6, 30, -26, 8, -13, 3, -31,
    0, 4, -7, 26, 10, 6, -22, 20,
    55, -22, 7, 11, -31, 11, 60, -44,
    38, -41, 14, 4, 11, 64, -28, 8,
    -15, 5, -2, -6, 17, -20, -7, 22,
    15, -17, -4, 12, 11, 25, -4, 9,
    25, 55, -7, -20, 30, -28, -17, 4,
    -9, -15, 25, 8, -55, -36, 22, -118,
    -36, -14, 13, 29, 28, -9, -2, 5,
    -10, -4, -11, -6, -11, 6, 19, -15,
    2, 47, -32, -2, 3, 4, -30, -39,
    15, 81, -88, 39, 64, -19, 88, -17,
    -32, 61, 24, 10, -6, 10, 27, -1,
    10, 15, -45, -19, -42, 26, -21, 7,
    -46, -34, -33, 28, -4, 59, -14, -39,
    16, -56, -36, 65, 9, -88, 33, -21,
    -16, -44, -13, 10, 12, 12, -13, 1,
    18, -4, 6, -4, 41, -1, 74, -55,
    -48, -6, -28, -38, -28, 19, -56, 5,
    23, -25, 22, 16, 19, 35, -21, -15,
    -17, 24, -50, 58, -14, 3, -4, 4,
    -1, -20, -6, -11, 58, 0, -37, -77,
    54, 26, 52, -30, 16, -71, -45, -4,
    -56, 21, 39, -4, 0, -32, -15, 41,
    -16, 7, -10, -27, -30, 8, 2, -3,
    -3, 7, 3, -15, -28, 35, -13, 34,
    20, -32, -1, 36, 43, 6, -23, 100,
    27, -9, 12, -2, -4, 27, -3, -63,
    70, 2, -24, -56, 21, 11, 27, 6,
    42, 6, -3, -4, 39, -39, 48, 48,
    8, 13, 39, 17, 11, 37, 1, 1,
    -5, -76, 42, -2, -9, 47, 62, -11,
    -38, -16, -20, 31, 6, 2, -6, -8,
    -10, -28, -3, 5, 4, 16, 2, -12,
    42, -65, 9, 10, -15, -12, 9, -5,
    39, -23, -13, 8, 53, -20, 10, 0,
    31, -12, 24, 12, -7, -16, 12, -18,
    27, -8, 16, -8, -6, 20, -5, 41,
    1, -25, 22, 6, 68, -37, 8, 17,
    14, 8, 2, -15, -30, 105, 8, -43,
    19, 27, 1, -18, 18, 111, 4, -26,
    -8, 28, 2, -30, -26, 25, -61, -2,
    1, -19, 17, -7, 36, -13, -32, -24,
    -23, 57, -41, -31, -38, -10, 25, 30,
    -2, -3, 56, -100, -1, 18, 15, 0,
    1, 17, -20, 19, 53, -30, 32, -13,
    6, 34, -18, -23, -6, -13, -12, 11,
    26, -30, 9, -20, 28, -37, -30, -19,
    11, -1, 25, -26, -14, 7, 9, -32,
    -3, -33, -14, 6, 15, -39, 53, -13,
    7, -37, -12, 16, 10, -4, 37, 50,
    14, -21, 4, -120, 16, 42, -54, 82,
    22, -4, -69, -40, 0, -18, 14, -5,
    -9, 19, -6, 6, 67, -23, -17, -60,
    44, -6, -17, -2, -35, -50, 7, 11,
    7, -22, 12, 20, -2, -28, -30, 12,
    17, 62, 4, 27, 9, -34, -27, -50,
    3, -68, -7, -16, -4, 1, -44, 9,
    -12, -4, -17, 2, 0, 16, 41, 66,
    29, -30, 58, -20, 49, -30, 41, -25,
    45, 22, 28, -35, -1, -20, 19, -31,
    30, 26, 19, -29, -14, 1, -15, -66,
    17, 42, -5, -2, 8, 8, 6, 26,
    27, -41, -2, -76, 45, -68, 18, 4,
    53, 54, -70, -59, 10, 21, 10, 15,
    -19, 0, 4, 19, 10, -52, 20, 8,
    10, -104, -38, -66, 35, -10, -52, -65,
    -31, 76, 12, -14, 52, -6, -108, 41,
    16, 45, -13, -5, -3, -11, -25, -1,
    -12, -14, 16, 21, -12, -42, -1, -25,
    3, -26, 11, 32, -25, 7, -17, 12,
    6, 31, -64, 23, 5, 28, 28, -72,
    -63, 23, 8, -6, 7, 15, -2, 14,
    -22, -7, 25, 29, 55, 9, 68, 20,
    -13, -27, 21, 10, 43, -51, -34, 5,
    -8, -2, 38, -51, -58, -36, 50, -32,
    -78, -35, 83, -20, -1, 3, 15, -18,
    -10, 5, 30, 9, 13, 25, -36, 86,
    -71, 63, 53, -50, 83, 21, 0, 22,
    32, -42, -61, 12, 36, 21, -17, 47,
    25, -31, -45, -10, -31, -7, -11, -7,
    -8, 3, 28, -8, -5, 26, 11, 55,
    11, 10, -33, 23, 20, 16, 36, -4,
    -29, 10, 54, -28, 39, -26, -1, 58,
    -5, -7, 24, -2, 1, -14, -10, 11,
    -6, 26, 2, 19, -8, -20, -52, -17,
    -20, -27, -3, 43, -16, -77, -22, -4,
    5, 23, 31, -15, -3, 27, 68, 20,
    -32, 19, 43, -28, -6, -10, -25, -12,
    -2, -5, -111, -18, 19, -34, 4, 7,
    71, 48, 29, -7, -24, -59, 26, 20,
    -8, 8, -44, -1, -11, 67, 16, -42,
    18, 18, 25, -2, -15, -30, 7, -44,
    -7, -20, 6, -29, -4, 6, -14, -4,
    -47, 35, 10, 6, 24, 48, -24, 63,
    85, 26, 20, -5, -13, 97, 64, 49,
    -14, 16, 98, 14, -4, 25, 2, -18,
    -10, -13, -17, 13, 28, -14, -115, -11,
    101, -32, 10, -1, 14, -2, -59, 11,
    -61, -56, -30, -22, 46, 59, -83, 127,
    47, -10, -52, -46, -18, 14, 4, -1,
    2, 4, -3, -6, -52, 1, 23, -2,
    8, -1, -34, -13, -25, -10, -51, 46,
    -29, -23, 22, -39, 13, 2, 4, -5,
    -10, -23, -4, -21, 21, -9, 17, 11,
    8, -21, -16, -2, -20, 31, 3, -3,
    -12, -28, -9, -8, 2, -21, 5, -5,
    -5, -22, -12, 0, -13, 2, 6, 8,
    10, 15, -9, -23, -9, 3, 30, 9,
    -1, 6, 33, -23, -6, -19, -24, 2,
    -33, -25, 32, -10, 22, 11, 10, -1,
    11, 10, 20, -3, 0, -17, 0, -5,
    22, 5, -4, -2, -51, -17, 23, 0,
    18, -1, -17, -16, -28, 9, -35, 10,
    -51, -25, -23, 9, -32, 10, 17, -13,
    3, -23, 30, -21, -3, -5, -6, -12,
    -11, -8, 4, 8, 5, 23, -23, -51,
    12, -21, -38, 0, 32, -5, 17, -6,
    13, 35, 10, -11, 18, 17, 10, -14,
    9, 63, -22, -22, -7, 3, 5, 5,
    12, 6, 29, 3, -12, -23, -22, 37,
    -10, -40, -21, 26, 54, -59, 0, -1,
    -14, 40, -8, -3, 11, 4, 4, 5,
    7, -31, -12, 3, 15, -10, -3, -3,
    5, 14, 6, -3, 16, -20, -13, 43,
    -24, -10, 39, 27, -16, -26, -17, -16,
    -6, -33, 18, -58, 4, -25, 0, 12,
    -30, -26, 12, -30, -13, -3, -2, -13,
    0, -3, 1, -9, -12, 5, 20, 25,
    16, 5, 9, 0, 6, 5, -26, 5,
    1, -7, 12, 32, 9, -17, 3, -17,
    -32, 41, 62, -57, -3, -7, -8, -13,
    15, 4, -17, 5, 17, 22, -15, 5,
    -22, 3, 15, 23, -9, 53, -15, 8,
    -35, 13, 22, -1, -12, -6, -23, 10,
    -12, -6, -12, 20, -2, 1, -10, -4,
    -22, -2, 3, -5, 1, -9, -12, 23,
    -4, 16, 9, 7, -11, 3, -20, -1,
    35, -5, 29, 4, 4, 19, 31, -36,
    -9, 27, 5, 12, -2, 0, 13, -4,
    -4, 0, 4, -8, 4, 19, 7, -2,
    -13, 14, -2, 6, -36, -7, 7, -17,
    14, -27, 12, -1, -12, -15, -2, 57,
    -46, 4, 44, -46, -11, 8, 6, -8,
    3, 4, 5, 1, 35, 8, -32, -7,
    -9, -9, 16, 3, 43, 33, 7, -3,
    -25, -24, 7, 5, -47, 21, 12, 22,
    -2, 32, -62, -20, 1, -10, -9, 12,
    10, 0, -3, 1, -8, 13, 14, 18,
    1, -1, 9, 3, -11, 33, -7, -9,
    29, 6, -22, 25, -4, 26, -26, -5,
    -36, 44, -53, -29, 15, -6, 3, 5,
    -12, -13, -13, 9, -9, 7, -22, 27,
    27, 18, 9, -20, 32, -5, 21, -28,
    -62, -3, 0, 13, 26, -25, -12, 27,
    12, 32, 40, -46, -13, 2, -6, -13,
    -1, -6, 20, -7, -8, 8, -7, -18,
    29, 6, 3, -8, -14, 28, 14, 7,
    -45, 6, -11, -30, 34, -4, 5, -3,
    -41, -42, 40, -1, 10, 9, -20, -9,
    2, 2, 4, 2, -5, -5, 16, -20,
    2, 10, 10, -7, 10, 9, -36, -20,
    4, -21, 33, -15, -11, 18, -15, 12,
    -20, 18, 32, -55, 3, 3, 17, 3,
    -5, -22, 23, -7, -6, -4, 19, 29,
    28, 9, -28, -4, 16, -9, 22, 13,
    8, -4, -4, 18, -20, 7, -12, -23,
    -1, 5, -31, -43, -2, -6, 6, -15,
    1, -5, -3, 1, -32, -11, 25, -14,
    7, 25, 4, 35, -18, 18, 29, -37,
    30, -15, -8, -14, 21, -8, -29, -5,
    -15, 2, 7, -34, -4, -2, 8, -5,
    25, 12, -7, -7, -4, 6, -1, 27,
    -20, -8, -24, -3, 38, 9, 6, 15,
    16, 5, 25, -15, -18, -1, 3, -16,
    -26, -22, -36, -12, 1, -4, -6, 5,
    -5, 9, -1, 18, 27, 8, -23, -5,
    -5, -73, -5, -11, -37, -5, 32, -4,
    42, 20, 33, 10, -10, 21, 0, 0,
    -21, 13, -26, 65, -1, -2, 7, -11,
    -24, 25, -9, 11, 1, 36, 23, -44,
    1, -5, -9, -2, 17, -1, -19, 35,
    -19, -30, 3, 23, 2, 4, -27, -16,
    -35, -26, 22, 12, -1, -1, 2, 4,
    -5, 6, 8, -9, -15, -16, -30, 20,
    -26, -4, -6, 0, -11, 18, 17, 37,
    -9, 1, 8, -2, -9, 15, 3, 27,
    32, -18, -11, -6, 5, -8, -6, -3,
    -5, -4, -2, -7, 16, 2, 10, 25,
    11, 8, -18, 3, -49, 18, 17, -29,
    18, -8, -6, -2, 15, 10, 48, -21,
    26, 27, -22, 12, -8, 5, -2, -8,
    14, 3, -28, 8, 6, -5, 8, 10,
    -11, 1, 2, -12, 1, -6, 14, 40,
    28, 2, 23, -15, 6, 9, -18, 27,
    -63, -11, 41, 16, 15, -2, -4, 10,
    -12, 1, 0, 10, -32, -25, -12, 2,
    -17, 3, -5, 35, 14, -29, 25, -6,
    -39, 26, 72, -23, 40, -14, -5, 5,
    -27, 32, -24, 5, -8, 10, 11, -4,
    2, 0, 1, -26, -15, -2, 5, 15,
    11, -12, 1, 15, 34, -8, 23, -28,
    -30, 14, 3, 26, -1, 3, 15, 11,
    1, 3, 16, -18, -3, -25, 15, 4,
    -9, 0, 6, 15, -16, -12, 23, 0,
    47, -2, 4, -18, -51, 13, 17, -1,
    26, 35, 6, 6, -20, -15, 24, -12,
    -18, 22, 25, 1, -5, -1, -8, -6,
    0, -15, -7, 22, 4, 5, 10, 2,
    5, 14, -2, -16, 5, 5, 24, -31,
    -27, -2, 24, 18, 0, 3, 4, -39,
    13, -24, 2, -39, 3, 2, 8, -11,
    11, -8, -1, -1, 3, -12, -11, 0,
    -19, 29, 1, 25, -16, 10, -7, -25,
    -13, -30, -23, -20, -45, 15, -25, 42,
    10, 22, 27, -37, -31, 7, 11, 13,
    31, 0, -31, 16, -25, 52, 6, -38,
    -1, -25, 11, 19, 6, 6, 1, -22,
    23, 7, 1, -3, -13, 8, 10, -4,
    -43, -40, -36, 17, -3, -2, -7, 3,
    4, 2, 4, -10, -23, -6, -4, -32,
    33, -15, -14, 6, 18, -22, 12, 62,
    -14, -22, -9, 23, -16, 10, 17, 4,
    -25, 30, -25, -34, -29, 7, -9, 2,
    29, 5, -5, 2, -22, 1, 6, -16,
    -7, -9, -3, 22, -17, -6, -31, -7,
    -28, -1, -11, -28, -6, 29, -9, 9,
    -25, -28, -53, 3, -6, -8, -2, 4,
    -17, 11, 10, -3, -17, -19, 2, -25,
    9, 1, -27, 4, 19, 0, -34, 12,
    18, -9, -3, -27, -13, -8, 8, 38,
    -14, -41, 36, -40, -10, -3, 0, -10,
    14, -10, -16, -12, -40, 9, -19, 21,
    61, -16, 5, -13, 2, 15, -33, -39,
    2, -6, -37, -1, -3, 39, -12, -6,
    -57, 6, -19, 61, -15, 0, 5, -3,
    5, 2, 16, -35, 3, -15, 3, -4,
    -31, -24, 21, -52, 4, 8, 5, -20,
    -15, -15, -4, 8, 22, 13, -22, 20,
    -3, 28, 13, -57, 4, -19, 16, 1,
    3, -3, 1, 20, -39, -17, 20, -19,
    16, 12, -17, -16, -33, -12, -20, 4,
    -1, -15, -21, -4, 6, -11, 16, -43,
    -5, -10, 26, -34, -2, 1, -9, 2,
    -27, -3, -2, 10, -6, -34, -25, -5,
    -4, -15, -65, -15, 11, -29, -6, -57,
    13, -9, 20, -5, 23, 1, 13, 10,
    -18, 6, 5, -22, -4, -6, 12, 10,
    7, 16, -3, -28, 27, 12, 12, -3,
    1, -45, -17, 33, -9, 24, 0, -27,
    7, -28, 19, -6, 17, -16, -19, 16,
    32, -17, 44, -23, 8, -18, 10, -5,
    -8, -4, -15, 13, -27, -39, -29, 25,
    16, -34, 62, -27, -71, -14, -4, -28,
    24, -25, 29, 0, -27, -48, -14, 37,
    14, -29, -1, -30, -4, 7, -5, 3,
    -3, 1, 11, 6, 26, -21, -31, -39,
    34, 20, 4, -9, -5, 25, 43, -31,
    -32, -21, -3, -21, 7, 4, -16, -60,
    -37, 72, 7, -2, 12, -4, 11, -4,
    31, -13, -6, 30, 12, 27, 21, -18,
    -38, 36, 9, 6, -8, -7, 11, 17,
    -7, 50, -11, -24, -23, 30, 3, -23,
    -4, -31, 26, 13, 3, 5, 1, 0,
    -18, 2, -9, 7, -3, 3, 25, 12,
    -16, 17, -19, 2, -12, 6, 40, -10,
    11, -2, -18, 1, -12, 3, 92, -48,
    -40, 14, -1, 13, 1, -11, 10, -1,
    13, 2, 11, -3, -14, 43, -20, -18,
    -12, -2, 16, -3, -28, 53, 36, 6,
    -5, -14, 6, -2, -10, -26, 10, 14,
    -87, -40, 36, -13, -8, -2, 0, -15,
    9, 8, 11, 2, 2, -40, -35, 12,
    -27, -33, 16, 16, 14, -29, 0, 17,
    -2, -20, -4, -7, -53, -76, -7, 16,
    14, 16, -50, -15, 3, 2, -13, 12,
    -10, -3, -3, -13, -38, -19, -32, -14,
    40, 57, 41, 50, -36, -24, 21, -34,
    24, -4, -14, 14, -17, -1, 42, 9,
    -42, 6, -39, 17, 6, 0, -1, 7,
    -6, 5, -16, 1, -23, -38, 20, 51,
    -31, 6, 10, -44, -1, -41, 9, -24,
    -72, -42, -3, 21, 24, 0, -22, -9,
    -6, 61, 1, 4, -6, 8, -2, -15,
    9, -4, 16, -2, -5, 18, 45, -16,
    44, 19, -40, -1, -5, 19, 33, -37,
    10, 12, -2, 16, 18, 24, 24, 21,
    -51, -8, 39, -31, -4, 1, -3, -4,
    -2, -24, -10, 1, -2, -38, -20, -18,
    1, 109, -20, -12, -24, -26, -1, 24,
    20, -26, 1, -6, 5, 48, 76, 0,
    -2, 17, 46, -51, -3, 7, -4, -10,
    3, -10, 15, 26, 43, -15, -16, -52,
    19, 10, 3, -60, 33, -1, 6, 15,
    28, -37, 9, -15, 15, 25, -15, -17,
    15, 19, 41, -12, -5, 4, 6, 6,
    1, -19, -2, 9, -39, 28, -7, 16,
    6, -4, -35, 8, -5, 44, 16, -7,
    5, 9, 22, -13, 9, 57, -7, -21,
    -1, 0, -1, -30, -5, -2, 7, 16,
    17, 10, 16, -11, -21, 4, 19, -15,
    -16, 5, 0, -28, -11, -57, 13, 11,
    18, 34, 25, -33, 23, -7, -4, -23,
    -7, 47, -37, -6, 0, -10, -6, 8,
    8, -28, 3, 13, 46, 10, 23, 8,
    -6, 4, -12, -20, 24, -20, -1, -3,
    59, 20, 4, 23, -16, 66, -28, -5,
    -45, 17, 50, 63, -13, 1, 5, -2,
    -5, 31, -10, 3, -9, 26, -35, 6,
    -21, -5, -33, -22, 3, 6, -21, 12,
    -15, -55, -58, -5, -13, 2, -33, -18,
    -42, -19, 60, 1, -13, 2, 3, 1,
    -11, 0, 7, 3, 6, -4, -33, -14,
    22, -1, 8, 12, 1, 30, -22, 71,
    -10, -38, 50, 0, 6, 13, -46, 5,
    24, -32, 23, -9, -23, 1, -5, -3,
    11, 3, 13, 2, 33, 4, -13, -24,
    -25, -11, -22, 12, -38, 11, -7, -25,
    49, 12, 8, 1, -29, -3, -34, -4,
    -56, 19, 22, 42, -3, 4, 3, -1,
    3, -8, -28, -18, 37, -22, -37, -6,
    -39, -15, 15, 1, 61, -27, 10, 12,
    -27, -6, -8, -8, 28, -14, 18, 55,
    9, -15, 16, 46, 13, 1, -1, 10,
    -9, 0, 11, 4, 10, 26, 9, 5,
    3, 16, -23, -6, 17, -28, 24, -40,
    -6, 9, 8, 10, 18, 9, 35, 17,
    -33, -38, -51, 7, 1, -5, 0, -15,
    2, -16, 16, -18, 0, -6, -33, -7,
    -13, -5, -2, 7, -11, 45, -2, -4,
    -46, -18, 7, -1, -7, 56, 19, -15,
    5, 24, 35, -11, -3, -22, -3, 3,
    9, 5, 0, 4, -25, 6, 27, -33,
    71, -1, 16, 5, -28, 34, 33, 6,
    -1, 36, 6, -6, -15, -23, 28, -35,
    -29, 17, 14, 3, -4, -10, -6, -11,
    -10, 0, 15, 28, 10, -31, -22, -8,
    -13, 32, -16, -7, 7, 9, 17, -14,
    -12, -3, 16, -11, 13, -23, 3, -17,
    -3, 33, 30, -9, -1, 6, 11, 0,
    2, -2, 10, 9, 0, 20, -9, -11,
    5, 5, 16, -10, -36, 1, -35, 24,
    17, -38, -2, 2, -38, 5, 8, 57,
    -3, 4, 23, 5, -28, -1, 4, -11,
    23, 11, -8, -23, -7, -3, -3, -37,
    -7, 7, -6, -13, 6, -14, 17, 4,
    20, 26, 3, 8, -9, -13, -17, -2,
    22, -30, -58, -29, -3, -6, -11, -1,
    7, -29, -14, 8, 24, 4, -6, 24,
    8, -6, -4, 12, 10, -2, 11, -1,
    11, -14, 21, 12, 5, 13, -4, -4,
    -62, 16, 3, 1, -13, -1, 6, -3,
    32, 10, -2, -4, -8, 21, 11, 0,
    7, -15, -29, -12, -22, 7, 21, 21,
    -19, -4, -10, -26, -11, 31, -11, 44,
    29, 30, 1, -14, 9, -2, 21, 1,
    -31, -3, -10, -12, 3, -22, 18, -31,
    -1, 7, -38, 24, 7, -3, 41, 7,
    21, -3, -74, -34, -57, -13, 25, 43,
    33, -58, 18, -16, -1, -34, 7, -32,
    45, 24, -25, -51, -28, 57, 35, 52,
    53, -31, -19, 32, -20, 22, -26, 30,
    -10, -47, -29, 49, -25, -31, -10, 37,
    -2, 3, -12, 36, -19, 1, 21, -15,
    3, -15, -17, 38, -25, 15, -92, 6,
    -42, -22, 20, -55, 10, -40, 55, -8,
    81, 27, 4, 10, 9, -4, -39, -15,
    26, -23, -3, 31, 2, 2, -12, 31,
    -36, -28, -3, 44, 42, 16, -34, 20,
    2, -17, 42, 47, 51, -21, -39, 28,
    44, -80, -3, -15, -28, 1, 2, -49,
    34, -8, -2, -43, -42, 13, -13, 5,
    21, 8, 4, 61, 56, 25, 29, -10,
    -16, -14, -17, -14, 17, 46, -17, -38,
    -55, -3, 15, 27, -5, -1, 17, -15,
    -26, -9, -11, 28, -13, -42, -5, -27,
    20, -20, 11, 118, 45, 42, -10, 64,
    -42, -11, 14, 72, -59, 46, -45, -28,
    -38, -65, 71, 58, 5, 35, -12, -7,
    1, -20, 36, -40, -2, -7, -13, -12,
    29, -14, -3, 37, -33, -27, -26, 23,
    1, -35, 5, -54, -30, 41, 29, 29,
    -47, -20, 33, 29, -25, 17, -11, -29,
    76, -29, -28, -16, 12, 15, 11, 14,
    -52, -20, 55, 20, 14, -15, -23, 8,
    10, -1, 26, -8, 20, 9, 25, -26,
    71, -30, 69, 20, -1, 18, 40, -14,
    -52, 81, -14, -6, 3, 22, 15, 15,
    -24, -19, -24, 37, -30, 42, 37, -39,
    -31, 29, -51, 17, -6, -54, -38, 38,
    41, -13, -65, -3, 8, 59, -1, 28,
    -40, -9, 63, -15, 8, 13, 26, 4,
    -10, 5, 3, 27, 8, -23, -15, -1,
    -2, 46, -27, -6, -31, -51, -15, -6,
    24, 7, 5, -1, -6, 6, 88, -63,
    -60, -40, 2, 1, 25, -17, 11, 2,
    -42, -40, 25, -13, -21, 24, -40, 27,
    -16, 16, 35, -14, 7, 21, -36, 15,
    -26, -34, 6, 19, 24, -26, 24, 6,
    -52, -23, 2, -42, 7, -27, 11, -17,
    22, 15, -16, 16, -66, -53, -124, 73,
    -50, 12, -6, 10, 28, 21, 58, -19,
    13, 17, 6, -22, -54, -66, -14, -8,
    4, 3, -12, 23, -5, -4, 15, -8,
    -45, 77, -26, 10, -9, -28, 13, 69,
    11, 48, 26, 49, 14, -38, -38, -6,
    -8, -23, -86, -1, 11, 48, 34, 3,
    -9, 67, -57, 43, -3, -10, -66, 5,
    -23, -88, 32, 1, 0, -20, 14, 76,
    -17, -18, -3, -37, 27, -17, 42, -10,
    -25, 14, 46, -32, 47, 15, -28, -20,
    41, -46, 15, 41, -9, -43, 38, 6,
    -11, -60, 80, 24, -26, -68, -22, 17,
    -45, 4, -48, -23, -34, -34, 0, -26,
    28, -44, -38, -36, -4, 1, 35, 34,
    5, -27, 14, -28, 13, -15, 2, 7,
    -34, 16, 29, 0, -61, -31, -22, 45,
    23, 106, -11, 15, 3, -29, 24, -70,
    -2, -29, 16, 39, 15, 8, 78, 16,
    -11, 17, 60, -11, 0, 6, 1, 0,
    2, 25, 44, -13, 4, 2, 15, -1,
    25, 19, 33, -72, -3, -1, 1, 77,
    31, -29, 30, 27, -10, 19, -31, -9,
    -13, 45, -20, -2, 15, -10, 1, 14,
    -14, -18, 56, -7, -38, -9, 11, -9,
    -7, -17, -65, -29, 9, 14, -21, 31,
    -3, 7, 61, 44, 16, 44, -34, 30,
    18, -20, -19, -74, 19, -15, 39, 13,
    -30, -23, 2, 2, 37, 34, 42, -26,
    -26, -8, 20, 68, -57, -36, -28, -14,
    22, 5, 35, 13, 7, -26, -29, -35,
    -21, 27, -67, -23, -12, -10, 26, 17,
    -33, -17, 46, 55, 100, 16, 15, 9,
    -53, 37, -25, 21, -91, -38, -117, -5,
    120, 6, 52, 19, 54, 17, -22, -5,
    7, 13, 34, -29, -45, 21, 0, 38,
    -49, 37, 54, 7, -13, 85, -46, -38,
    43, 13, -31, -42, 22, -47, 37, 59,
    2, -66, 24, 68, -26, -5, -3, -47,
    -20, -19, -15, -16, -3, -2, -20, -4,
    -30, -2, 8, -17, 25, 30, -50, 4,
    3, 36, 48, 21, -22, 65, -65, 19,
    23, -29, 7, 3, 22, -13, -12, 45,
    47, -40, 9, -24, -2, -6, 3, 5,
    -26, 5, 0, -64, 14, -2, -42, -76,
    3, -15, -10, 14, -10, 11, -35, 14,
    36, 26, -38, 17, -20, 7, -56, 4,
    -63, 45, -49, 54, -11, 17, -6, -18,
    -23, 18, 82, 6, 20, 24, -22, -63,
    -62, 2, 1, -21, -13, -24, 12, 27,
    -35, -26, -1, -19, 1, 12, -16, -7,
    4, -33, 23, 83, -5, -19, -6, -9,
    6, 34, 2, 7, -31, 94, 11, 17,
    47, 28, -44, 2, -12, -65, -42, -5,
    -34, -3, 43, 0, -32, 6, 106, -2,
    -10, 48, 42, -12, -2, -17, -19, -6,
    15, 3, -23, -20, 30, 4, -63, 12,
    15, -21, -56, -40, 18, 50, 33, 44,
    -44, -37, 51, -25, 0, 6, -8, 6,
    -51, -22, 52, 18, 7, 31, 10, 17,
    23, -23, -4, 23, -103, -9, 104, -127,
    27, 14, 23, -22, 19, 36, -34, 61,
    -79, 36, -39, -42, 14, -10, 42, -9,
    -19, 26, -16, -31, -2, -7, -6, 2,
    5, 15, 30, -43, 22, -13, -11, -18,
    9, 33, 5, -24, 7, 15, 0, 8,
    -11, -3, 39, -32, 22, 12, 2, -1,
    28, 31, 4, 45, 7, -9, 13, 27,
    6, 19, 12, -40, 34, -41, -6, -26,
    -1, -12, -28, -58, -37, -20, 3, 55,
    8, -72, -52, -1, -49, 9, -21, 37,
    3, 36, -25, 28, -93, -36, 5, -15,
    -1, -27, -2, 14, -25, 9, 39, 28,
    9, -6, 14, -64, 14, -1, -23, 32,
    1, 30, -9, 12, 5, 15, -24, -8,
    30, -2, -47, -38, -5, 0, 20, 6,
    -17, -40, 9, 12, 16, -1, -14, 30,
    -15, -48, 41, -1, 69, 14, -38, -65,
    -34, 21, 27, -47, -1, 23, -13, -52,
    -100, -29, -9, 3, 104, -1, 12, -12,
    15, 9, 42, 22, -5, 1, -57, 16,
    -34, -20, -65, -13, -5, 23, 32, 7,
    11, -16, -35, 6, 6, -2, 21, 27,
    -19, -14, 93, -1, 10, -14, -21, -19,
    -24, -8, 23, -3, 41, -26, -10, 9,
    -26, 40, -21, 20, 58, 5, -39, 52,
    34, -10, 27, -29, -23, -13, -34, 81,
    -1, 24, 17, -4, 14, -22, -1, 7,
    13, -56, 2, 8, -36, 25, -7, 31,
    19, 26, 20, 18, -21, 33, 13, 17,
    7, 27, 9, 22, 23, 12, -24, -3,
    -12, -9, 19, 0, 5, 15, -1, 6,
    32, -24, 31, -8, -17, -18, -10, -1,
    -14, -4, 0, 6, 16, -42, -24, 5,
    2, -9, -12, -2, -12, -6, 2, 9,
    29, 35, -18, 13, -28, 3, 25, -3,
    -15, 29, 2, 34, -16, -28, 1, 55,
    5, -9, 14, 14, -11, -51, 11, 36,
    4, -6, 28, -27, 8, 23, 13, 19,
    0, -18, 49, -7, 4, -19, -13, 8,
    -5, 5, -20, 4, -7, -6, 12, 5,
    10, 13, 11, -10, -2, 22, 17, -10,
    -1, 6, -5, -7, 18, 6, 10, 49,
    14, -28, -16, 25, 3, 3, 20, 11,
    -8, -18, 4, -3, 4, 29, -25, -14,
    38, 13, -22, 4, 22, 7, 24, 39,
    -13, 18, -8, -9, 11, 21, -42, -14,
    -12, 8, 13, -1, -17, -10, -9, 1,
    16, 5, -13, -52, -16, 43, 1, -1,
    10, -42, -5, 14, -1, 34, -20, -21,
    -9, 11, -17, -47, -23, -13, 16, -21,
    -2, 13, -10, 18, -23, 2, -39, -15,
    3, -5, -7, -12, -18, 5, 9, -19,
    -1, -14, -3, 31, -15, 8, -11, 3,
    -18, 0, -31, -5, 15, -2, 24, 22,
    20, 35, 13, 10, -15, -7, 10, -25,
    -22, 11, 6, -22, 47, -20, 28, 63,
    -3, -10, 1, 4, 16, -24, 9, 23,
    11, 15, 11, -10, -57, -20, 21, 2,
    15, 33, -4, 15, -9, 11, 7, -11,
    23, 11, -10, 0, 1, -9, 26, -2,
    -10, -9, -2, 2, -16, -7, 8, -5,
    8, -32, 16, 0, 2, 12, 6, 7,
    22, 0, 11, 9, -20, -6, -10, -15,
    -9, 1, -13, -13, 17, 5, -15, -11,
    17, -12, 4, 44, 27, -4, 17, 13,
    -14, 42, -17, -10, -37, 31, -14, -1,
    41, -10, -5, -18, 11, -20, 6, 7,
    -35, -23, 21, -2, 27, -10, -29, 8,
    -8, 5, 4, 6, 11, -14, 28, -14,
    -37, -6, -8, 14, -23, -8, -13, 6,
    -8, 0, 27, 14, 8, 19, -40, -9,
    1, 19, -9, -14, 10, -6, -8, -10,
    16, -1, -10, -4, -2, 21, 8, -21,
    -9, 13, 10, 4, 26, 13, -4, 26,
    -8, -7, -12, 15, 3, 12, 9, -6,
    18, -34, -5, 0, -35, -47, -1, 13,
    -18, -9, 11, 2, 4, -13, -15, -14,
    24, 3, 49, -16, -12, 51, -24, 11,
    -3, -10, 6, -18, 28, 32, -12, 20,
    16, -33, 18, -23, 22, 9, -39, 7,
    31, 14, 30, -20, 36, -10, -4, 20,
    -15, 37, 13, -15, -19, 1, -34, 54,
    9, 0, 21, -30, 6, 5, -21, 0,
    13, -39, 6, 0, -4, -28, 36, -11,
    9, -15, -1, 0, 18, -5, -38, -8,
    -25, 22, 10, 0, -5, -4, 4, -36,
    6, 11, -6, 10, 13, -23, 16, -6,
    32, 33, 20, 16, 17, 33, -16, 22,
    -18, 12, 27, 8, 25, -23, 11, 13,
    -10, -12, -10, -25, -19, 9, -21, -9,
    13, -7, -10, -27, 7, 12, -7, -16,
    10, -8, -36, 19, -5, 13, 6, 26,
    -1, -48, 6, -12, -2, 1, 41, -17,
    0, -6, -37, -11, -17, 7, -3, 19,
    -14, 18, -20, 4, -13, -7, -22, -19,
    0, -16, 2, 27, -3, -20, 3, 20,
    -16, -18, -2, -3, -5, 12, 11, 2,
    -4, 15, -19, 3, 62, -23, 6, -19,
    6, -3, 10, 2, -29, -19, -3, 4,
    9, 6, 4, 14, 2, 39, 1, -23,
    1, 27, -18, -14, -12, 14, -11, 3,
    -30, -4, 23, 5, -8, -42, 42, -6,
    -38, -5, -16, 22, 19, 35, 19, 12,
    5, 26, -40, -3, -22, 20, 25, -38,
    -13, 1, -4, -9, 7, 11, 25, -5,
    -17, -18, 14, -16, 8, 16, 5, -50,
    -9, 9, -20, 5, -4, 4, 21, 8,
    -2, 6, -5, 24, 28, -17, 21, 6,
    -5, 25, -20, 6, 8, -9, -18, 1,
    1, 11, -33, 25, 7, 10, 27, -9,
    -23, -20, -12, 14, 21, 0, 13, -28,
    3, -7, -12, -19, -14, -15, 1, -28,
    15, 12, 28, 12, -1, 10, 18, 9,
    13, 10, 16, -31, 1, 28, -7, 0,
    -11, -5, -6, -26, 25, -7, 26, 20,
    10, -37, -1, -2, 9, 24, -22, 17,
    -15, 8, 1, 16, -1, -25, -1, 9,
    -14, 4, -17, 39, -26, -19, 22, 11,
    -12, -17, 38, -8, 33, -9, -18, 15,
    -13, -7, 5, 5, -1, 6, -19, 0,
    -12, 7, 13, 14, -4, -5, -8, 34,
    6, 20, -9, 37, 0, -8, -8, 17,
    11, -17, 11, -4, -16, -9, 11, -9,
    -30, -35, -31, -5, 0, -7, -19, -17,
    29, -2, -1, 29, 16, -35, -10, -23,
    -9, 21, 12, -2, -20, -11, 21, 28,
    -24, -19, 10, -20, -12, -16, -14, 10,
    -17, -29, -2, 33, 0, 20, -7, 27,
    4, -2, -24, 33, 21, -13, -2, 10,
    2, 21, 37, -14, 24, 18, -26, -25,
    6, -41, -3, -19, 8, 4, 1, -19,
    8, 21, -16, -10, 3, 15, -14, 21,
    -8, -1, 25, 12, -8, 13, -17, -4,
    14, -1, -2, -20, -2, -12, -8, 19,
    0, 28, -10, -25, -10, 8, 18, -4,
    -10, 14, -12, 12, -1, 17, -8, -14,
    -5, 7, 2, 14, -12, -1, -1, 0,
    -9, 8, 18, -16, -8, -11, -6, 21,
    -15, -2, -5, 24, -19, -8, 6, 8,
    22, -7, -1, -5, 15, -18, -11, 20,
    0, 13, 8, 2, 10, 8, -1, -10,
    -4, -9, 18, 8, -1, -4, -22, -4,
    21, 7, -14, 0, -9, -3, 24, -27,
    8, 25, -43, -17, 35, 21, 26, -25,
    40, -16, -11, 8, 24, 14, 25, 3,
    -18, -17, 15, -8, 3, 10, -35, -10,
    -6, 13, -44, -6, 2, 10, 37, 11,
    16, -13, 18, 4, -14, 13, 17, -13,
    -5, 11, -2, 10, 8, 28, 13, 2,
    22, 8, 19, 25, 5, -3, -27, 12,
    -31, -37, -13, -6, 24, 9, 2, 10,
    14, 10, 32, 3, -18, 10, 6, -23,
    18, -8, -3, 1, 22, 15, 11, -4,
    -3, 36, -7, 22, -40, 15, -16, 38,
    21, -11, -3, -1, 4, 25, -14, 26,
    33, -5, 1, -36, 5, 51, -2, 28,
    -12, -12, 15, 26, 14, 12, 20, 12,
    2, -16, 2, -11, 10, -5, -11, -23,
    -31, -9, 12, -4, 2, 12, -12, 6,
    37, 4, 17, 13, -34, 9, 7, 0,
    -2, -37, -14, 11, -19, -32, -9, -10,
    -25, 2, -11, 24, -17, -3, 3, -3,
    -12, 13, -3, -34, -1, -25, -17, -1,
    -63, -9, 5, -6, -12, -53, 5, -10,
    3, -8, 2, 23, 0, -14, 23, 35,
    -26, -12, -42, 16, 3, 35, -14, -1,
    -15, -36, 32, 10, -27, 12, -16, -7,
    -5, 7, 21, -9, 9, 19, 18, 21,
    25, 14, -9, -10, 0, 11, 8, -12,
    -14, 3, -9, -29, 25, -17, 32, 50,
    45, -11, -9, -1, 18, -28, -1, -16,
    -14, 9, -8, -10, 42, 24, -36, 57,
    40, -17, -15, -13, 8, -21, 29, 24,
    28, 20, -18, -29, 14, 25, -24, -14,
    34, 12, 65, -22, -12, -22, -3, -19,
    -9, -13, 4, -18, -10, 2, 7, -10,
    5, 12, -4, -2, -18, 10, 0, -15,
    25, 18, -15, -28, -28, 13, -18, 15,
    -6, -4, 8, 1, 9, -2, 22, -16,
    -16, 7, 7, 19, -36, 1, -7, -42,
    -29, -12, -7, 7, -10, 10, -6, -9,
    -26, 10, -39, -19, -27, 28, -51, 24,
    7, -9, -2, -5, 15, 22, 19, -20,
    27, 0, -20, -2, -27, 22, 10, -18,
    -4, -12, 2, 28, 14, 4, 11, -4,
    13, 12, 14, -6, -27, -17, 51, 16,
    9, 30, -30, 4, -12, 11, 32, 7,
    14, 14, -22, 9, -11, 13, -34, 3,
    -16, -8, 27, 7, -27, 15, -15, 0,
    -20, 0, -22, -20, -8, 8, 34, 17,
    12, -21, 10, 8, 0, -37, 3, -14,
    -8, 14, 23, -12, 28, -38, -14, -2,
    19, -6, -13, 16, 28, 9, 7, -6,
    16, -12, -20, 3, 0, -6, -23, -16,
    -8, 22, -17, -18, -27, -22, -5, 13,
    -17, -27, 27, 5, -27, -12, -12, -2,
    -12, -18, 9, 5, -26, 6, 25, -15,
    1, -30, -12, 30, -27, -34, -2, -7,
    -19, 12, -12, 18, -27, 26, 3, 5,
    -10, -21, -33, -24, -16, -8, 19, 0,
    29, -10, -13, -20, -1, 1, -7, -11,
    -27, -17, 10, -12, 0, -54, -10, 13,
    -18, 20, -27, -3, -11, 8, -19, -8,
    -31, -40, -44, 7, -4, 21, 29, 13,
    5, -3, 42, -3, 6, -11, -18, -1,
    5, 56, -42, -21, -11, 10, -13, 37,
    -16, -31, -32, 3, -20, 26, -7, 18,
    34, -14, 35, 5, 19, 4, -13, 12,
    18, 9, -1, -10, 38, 6, 22, 23,
    9, 18, 4, 21, -14, -23, 39, 26,
    -23, 1, 18, -2, 23, 43, 12, 32,
    45, -30, 51, 3, 13, -3, 13, 15,
    -8, -14, 4, 2, 19, 3, -18, 14,
    2, -10, -38, 13, -11, -42, 44, -28,
    4, -25, 24, 11, -10, 0, 19, 31,
    36, 8, 13, 17, 46, -21, 7, 43,
    -28, 19, -4, 0, 17, -18, -10, -1,
    3, -60, 21, 40, 2, 15, -31, 6,
    -11, -12, -37, 7, 15, -3, 36, -16,
    4, -10, -7, 4, -11, -1, 31, 10,
    6, 3, 20, 25, -13, 9, 7, 0,
    -1, -5, -29, -6, -29, -23, 21, 20,
    23, 20, 32, 13, -18, -20, 2, 14,
    -10, -26, 0, -3, -2, 38, 71, -3,
    -35, 9, -25, -3, 9, -4, -3, 29,
    13, 34, 39, 27, 22, -10, 33, -46,
    -25, -10, -14, 5, 4, -4, -21, 5,
    18, -17, 39, 16, -24, -19, 3, -10,
    -12, 26, -3, -4, -9, -23, -3, 0,
    -23, -3, -11, 1, -6, 0, 17, 16,
    -10, 6, 8, 16, 8, 37, -10, 5,
    13, -12, -47, 11, 11, 11, -19, -10,
    16, 2, 5, 3, -15, -12, 2, 3,
    6, -4, -6, -4, 23, 54, -33, 13,
    -13, 0, -6, 5, 20, -4, 22, -17,
    32, -1, 9, 20, 11, -19, -44, -20,
    -10, 3, -5, 5, -4, 20, -1, -4,
    4, 28, 19, -20, -38, 19, 29, -9,
    -9, -17, 6, 31, 5, -4, 44, -6,
    -16, 9, -4, 2, 38, -15, -21, 11,
    -28, -11, 29, 3, -6, 12, -1, -9,
    -29, 7, 35, 18, 21, 33, 21, -58,
    -34, -23, 17, 28, -22, -16, 7, 1,
    45, -51, -24, 3, -7, -10, -5, -11,
    -14, 19, -22, 17, 15, -22, 16, 13,
    -21, -12, -21, 43, 10, 12, 5, 23,
    -6, -4, -10, 14, 25, 13, 3, 27,
    -4, -11, 18, 0, -21, 11, -43, -17,
    -14, 13, -6, 15, -9, -13, -19, 10,
    0, 16, -26, 23, -11, -1, -15, 17,
    -2, 3, -29, 11, 11, 10, -21, -28,
    -10, -8, 9, -9, 28, 62, -42, 0,
    33, -11, -4, 18, 42, 4, -10, 3,
    26, 31, 10, -5, -16, -26, 32, 31,
    -8, -23, 0, 11, -4, -1, 9, -28,
    6, 6, -2, -16, -21, 44, 19, -21,
    17, 9, -14, 24, -34, -9, -4, 21,
    25, 25, 25, -13, -2, 12, 21, -41,
    -6, 2, 14, 12, 1, 27, 5, 0,
    11, 9, 14, -5, 4, 25, 9, 16,
    -12, -1, 5, 6, -2, 0, -11, -3,
    12, 5, 4, 45, 14, -38, 14, 33,
    4, 4, -5, -15, 12, -17, -15, 10,
    -7, -11, 2, -21, 13, -39, 19, -36,
    5, 13, 12, 10, 1, -15, -20, -22,
    -9, 5, 39, 14, -18, 13, -22, 5,
    -6, -2, 3, 12, -16, 47, -9, -1,
    20, -1, -9, -10, 4, 48, 2, -11,
    -6, 11, 16, 17, 14, 6, -18, -8,
    19, 51, 26, -42, -12, -45, 21, -2,
    -4, -18, -17, 30, -31, 3, 19, -17,
    -34, 13, 2, 7, -19, 1, 15, -13,
    15, -11, -35, 3, -25, -12, 13, 25,
    17, -3, 14, 36, -15, 32, -21, -17,
    0, 11, -8, -24, -8, 7, 52, -1,
    24, -12, 35, 8, -10, 15, 6, -11,
    -12, 25, 7, -1, 19, 17, 29, 11,
    -30, 1, 3, -17, 9, 16, -17, 11,
    3, -13, -19, -8, 4, 8, 23, 21,
    15, -5, 35, 7, 31, 0, 7, -9,
    31, 5, -29, 8, 2, 10, 7, -1,
    20, 35, -1, 18, -23, -24, -15, 22,
    -10, -31, -21, -2, -72, -36, 26, -6,
    -2, -43, 17, -32, 54, -47, 2, -2,
    0, 33, -17, 17, 6, -46, 29, 1,
    -9, -73, 4, -77, -13, -92, -2, -9,
    -5, 35, 23, 34, -13, -8, -8, -21,
    49, 30, 80, 49, -6, -39, 83, 16,
    50, 26, -47, -9, 40, 20, 27, 0,
    35, 21, 42, 6, 53, 61, -10, 26,
    -47, 6, 23, -47, -31, 30, 7, -34,
    -56, -24, -30, 97, 23, 5, 42, 23,
    -14, -19, -32, -68, 1, 86, 49, -52,
    -46, -2, 8, 35, 17, 31, 88, 11,
    3, -15, -55, -14, -33, 7, 0, 31,
    -41, 32, -36, 20, 41, -45, -33, 5,
    8, -34, 3, 0, -1, -56, -41, -16,
    -78, 4, -37, -64, -36, 19, -13, 3,
    -2, -29, 39, -8, 27, 68, -4, -22,
    -46, -6, -2, -28, -6, -36, 33, -5,
    -50, 12, 0, 21, -22, -3, 45, 30,
    -3, -2, 46, -44, -13, -16, -19, -13,
    35, -5, 101, -127, 38, 33, -15, -31,
    -78, -45, 18, -37, 68, 61, 29, -24,
    53, -24, -57, 2, 54, 64, -27, 6,
    5, 10, -24, -102, -33, -44, -3, -61,
    13, -20, 11, -12, 4, 2, -5, 23,
    24, 9, 33, 20, -45, -24, -41, 27,
    30, -2, -2, -43, -11, 17, -13, 55,
    63, 66, -19, -17, 31, 25, -45, 26,
    -30, -23, -41, -10, 32, -8, 50, -31,
    29, 18, -24, 21, -24, -29, -41, 11,
    -12, 4, 8, 28, -20, 35, 18, -28,
    89, 3, 2, 46, -44, 42, 14, 1,
    -10, -8, 16, 12, 4, -1, -24, -7,
    10, 1, -27, 2, -4, 3, -33, 5,
    12, 12, -42, -5, -21, 16, 0, -11,
    -10, -15, 0, -14, -29, 22, 49, 15,
    -26, 69, 8, -38, 41, -28, 13, -4,
    8, 51, 25, -23, -31, 29, 39, 22,
    -4, 42, 24, -56, 25, -9, 37, -3,
    6, 31, 28, -20, -21, 1, 1, 5,
    -54, -41, -18, 7, 58, -7, -7, 22,
    30, -38, 56, -22, 51, -4, 43, -15,
    2, 25, -70, 26, 64, -19, -16, 0,
    4, 19, -17, 31, 25, -12, -13, 17,
    14, 11, -72, -6, -21, -5, 33, 11,
    -48, 8, -37, -36, -3, 49, -71, -57,
    -35, 8, 72, 14, -42, -5, 32, 12,
    6, 13, -18, -45, -44, -72, -13, 22,
    -68, -24, -6, -3, 10, -19, -5, 7,
    29, -38, -46, -49, -8, -50, 72, -38,
    -20, -14, -32, 12, -9, -21, 12, -1,
    -10, -12, -74, -8, 23, -29, -38, -28,
    37, 37, 10, 28, -4, 2, 19, -8,
    13, -35, 26, -25, 46, 8, 14, -45,
    59, 4, 37, 45, 51, -41, 4, -54,
    -10, 37, -27, -43, -6, -49, 6, -66,
    11, 31, -27, 43, 0, -59, 13, 6,
    19, -13, 49, 59, -15, -27, -15, -38,
    -11, 26, -30, -1, -22, -53, -17, 33,
    47, 33, -26, 44, -19, -10, 45, 81,
    35, 13, 73, -68, -20, 2, -12, -30,
    35, -6, -36, 101, 0, -27, 16, -72,
    22, -17, 37, -55, -45, 40, -16, -90,
    -35, 53, 25, -27, 41, 45, -49, 81,
    -14, 28, -12, 15, -8, -38, -20, 17,
    4, -20, -1, 59, -23, -10, -26, -4,
    0, 112, -41, -72, -31, 9, -85, -44,
    8, -17, -3, 7, -24, -38, 30, 19,
    -9, -59, -10, -36, 20, 27, -35, -17,
    -9, 3, -20, 1, -30, 31, -48, 10,
    -8, 30, 37, -26, 16, 16, -5, -32,
    19, 11, 28, -7, 54, 0, -11, 14,
    9, 67, 56, 12, 4, -35, 46, -13,
    34, 11, 37, -20, -71, -2, 36, 12,
    -2, -15, -9, -10, -18, -33, 3, 19,
    42, 46, 33, -1, 44, 85, 73, 7,
    15, -41, -26, -8, -37, 55, -19, -72,
    55, -22, -33, 17, -5, -7, -22, -45,
    29, -25, -56, -73, -14, 26, 3, -96,
    -46, -54, -46, 27, 18, -16, -8, 15,
    9, -41, 35, 31, -19, -28, 13, 0,
    17, 25, -15, 47, -25, -36, 3, 12,
    21, -3, -8, 6, -29, 0, -12, 10,
    31, 1, 55, 34, -9, 35, -30, 8,
    -11, -19, 26, -12, -8, 3, -25, -19,
    -84, 4, -7, 20, -52, 9, -27, -58,
    38, -29, -52, -3, -4, 0, -68, -28,
    35, 27, 37, -12, 15, 14, 19, 3,
    12, 16, 3, 4, -33, 38, -9, -71,
    40, -47, -47, 11, 52, -48, 34, -16,
    51, -2, -7, -31, 27, -36, 9, -13,
    -27, 54, -41, -43, 42, 6, 29, 25,
    30, 42, -15, -69, -50, 6, 4, -8,
    -13, -4, -11, -28, 33, 1, -5, -79,
    -1, 34, -7, -32, -7, -7, 31, -27,
    -30, 15, 19, -30, -44, 10, -11, 12,
    -22, -30, -25, -26, -28, 16, 11, 17,
    1, -47, 28, -5, -19, -22, 25, -5,
    -83, 44, 7, -12, -84, 47, -3, 17,
    -6, -67, 11, -16, -33, 14, -27, 7,
    20, -12, 6, 26, 55, -10, -23, 76,
    -14, -20, 53, -22, 5, 48, -37, 30,
    27, 5, 91, -19, 13, 2, -23, 61,
    33, 66, 55, 3, -47, 58, 50, -9,
    -2, 14, -17, -23, 14, -40, 38, 91,
    0, 23, -16, -15, 1, 12, 10, -30,
    9, -8, 4, 45, 20, -22, 18, 11,
    26, 43, 8, 24, -7, -14, 20, 61,
    -3, 22, -68, -18, 13, 0, 55, -31,
    2, -21, -23, 13, -9, 2, 20, -75,
    -2, -28, 3, 51, -13, -16, 6, -1,
    7, -54, -42, 10, -5, -1, -48, -3,
    -2, -10, 7, 1, 20, -16, -6, 17,
    11, 59, 15, 17, 1, -7, 65, -10,
    -3, -3, -38, -5, -13, -17, -20, -24,
    44, -28, 1, 22, -37, 56, 17, 1,
    15, -2, 37, 20, 42, 14, -3, 18,
    -77, 39, 51, 32, -52, 24, 15, -26,
    -35, -5, 16, -12, 52, 11, 16, -5,
    30, 36, 43, -4, -12, 34, 34, 2,
    -18, 20, -3, -13, 21, -48, 31, -27,
    17, -12, 39, 4, -30, -9, 34, -43,
    6, 11, -28, 3, -12, -44, 22, -15,
    -15, -19, 14, -8, 19, 12, -23, 15,
    61, 7, 20, -11, -50, 0, -29, 2,
    58, -8, 44, -8, -50, -20, -7, -15,
    -15, 7, 23, 20, -110, -15, 14, -8,
    30, 43, -5, 6, 22, -57, 24, 29,
    13, -23, 5, -26, -2, -75, -88, 48,
    5, 39, -12, 20, 16, -21, -9, -8,
    -27, -8, -12, 11, -13, -23, 2, 38,
    19, 36, -3, -3, 31, -39, -50, -19,
    11, -11, -14, 8, 30, -55, 16, -22,
    -33, -3, -4, 50, -13, 16, 11, 29,
    30, 15, -50, -5, -9, -27, -27, 10,
    15, -2, 13, 2, 10, -41, -4, 19,
    -12, 14, -26, 3, 42, -32, -16, 11,
    39, -21, -7, 0, -6, -18, -10, 5,
    30, 44, -35, -2, -46, 2, 14, 19,
    -25, -4, 13, -21, -6, -2, 60, 34,
    -14, 27, 6, 21, 23, -17, -71, -40,
    -63, -32, -33, -11, -7, -29, -27, -3,
    45, -4, -7, 33, 7, 12, 5, 20,
    -43, -4, 2, -22, 48, 13, 4, 35,
    19, 20, -3, -7, 46, 29, 20, 46,
    5, -23, 14, -34, -54, 1, 6, -24,
    69, -22, -22, 13, 21, 5, -20, -20,
    -17, -4, 12, -11, 28, -95, 31, 1,
    27, -3, 4, -21, 3, -3, 18, -54,
    5, 35, -13, 24, 10, -29, -2, -6,
    -13, -32, 10, 9, -14, -19, 20, -23,
    -24, 20, 23, -24, -31, -60, 27, 23,
    -1, 14, 29, -42, -63, -27, 8, -27,
    17, 26, 28, 14, 2, 11, 2, -13,
    2, 18, -16, -10, 14, -27, -26, 30,
    34, -28, -7, 10, -84, 15, -60, 0,
    -1, -2, 10, -15, -12, 47, -8, -12,
    24, 7, -15, 23, -7, 40, 12, -24,
    -36, -14, -18, 31, -17, 37, 18, 18,
    -1, 23, 18, -56, -47, -2, -25, 62,
    -7, 0, 64, -17, 13, -30, -2, -11,
    -1, -26, -38, 2, 14, 2, 23, 14,
    -18, 21, 21, 3, -31, -1, -11, -34,
    -15, -1, -10, -17, -47, 42, 10, -5,
    -1, -12, 25, 9, -67, 24, 19, -57,
    -2, 29, 31, 10, -24, 5, 2, 6,
    -11, 12, 0, -18, -4, -32, -11, 11,
    5, -44, -2, 10, -62, -13, -21, 7,
    -4, -22, -37, 10, 16, 0, 44, 12,
    43, 3, 45, -21, -24, -25, -8, -4,
    -18, 14, -4, 45, 8, 9, -23, -5,
    -9, 17, -37, -5, 23, 11, -5, 16,
    10, 13, -5, 37, 8, 25, -8, -1,
    31, -4, 19, -15, 2, -12, -8, -12,
    14, -29, 32, 30, 6, 1, 12, 8,
    -70, 31, -60, -18, 3, 24, 32, 21,
    -16, 8, 14, -8, 27, -17, 57, 15,
    22, 26, -39, -29, -35, -13, -7, 24,
    17, 3, 33, -7, -21, -9, 5, 12,
    -30, 45, -24, 0, 41, 45, 56, 10,
    -2, 18, 7, -13, 26, -16, -21, 21,
    -50, -42, -27, 4, -10, -2, -12, -2,
    27, 5, 31, -11, 18, -7, 9, -3,
    -10, 4, -61, 29, 2, 49, 0, -4,
    -6, 18, 29, 29, 31, -1, -68, 39,
    -10, 11, 38, 7, 28, -8, 22, 2,
    8, 11, -3, 23, -30, -6, -3, -22,
    -2, 17, 27, 11, -47, 43, -17, -4,
    20, 21, -3, 28, -10, -49, 48, 5,
    -26, 22, -26, -15, -24, 16, 16, -27,
    11, 40, 1, 28, 12, 1, -26, 15,
    17, -39, 57, -28, -5, -43, -38, -4,
    -24, 29, -29, -7, -32, -3, -20, 16,
    16, 8, 36, 42, 20, 7, 15, -24,
    -34, 2, -41, -43, -12, 6, -14, -8,
    19, -10, 19, -50, -45, 2, -16, -80,
    -4, -19, 1, -14, 20, 16, -22, 81,
    -20, -11, 31, -18, -10, 33, -9, -3,
    -39, -8, -45, 5, 3, 23, -3, 21,
    67, 52, 33, 4, 5, 41, -1, 24,
    22, 14, 14, -21, -32, 7, -17, -35,
    0, -30, 55, 4, 13, -10, -4, 19,
    -10, -12, -32, 5, 29, -8, 10, 29,
    -68, -16, 30, 33, -18, 4, -34, 11,
    -32, -9, -9, -6, -14, 38, 5, 1,
    -38, 64, -8, 40, 33, -9, -20, -31,
    22, 1, -24, 27, 11, 13, -4, -18,
    -51, 10, -19, 29, 9, -36, -1, 50,
    -1, 9, -6, -5, -23, -35, -22, -46,
    17, -40, 22, -14, 17, -7, -21, 7,
    0, 31, -23, -25, -28, 8, 14, -7,
    11, -63, 68, 27, -59, 31, -4, -42,
    21, 4, 22, -12, -14, -1, -32, 36,
    -11, 7, -21, -4, 6, -13, -20, 32,
    0, 14, 25, 32, -20, 10, -1, -15,
    32, 41, -28, -41, -15, 5, -13, -38,
    8, 42, -16, -1, -11, 11, -54, 4,
    38, -2, -57, 3, 17, -27, -12, 7,
    37, 21, 4, 32, 15, -7, -8, 4,
    9, 0, -30, -26, 43, -46, 31, 56,
    4, -2, -12, 10, -35, -9, -10, -29,
    -5, -19, 37, -20, 37, -27, 31, -1,
    47, 34, -40, 4, -7, 14, -11, 33,
    -35, -18, 21, 26, 36, -2, 19, -5,
    -12, -8, -12, 8, -3, 33, -33, 44,
    -23, 33, -47, 17, -22, 5, -5, -11,
    29, 6, -3, 55, 3, -20, 25, 13,
    0, -21, 7, -26, 22, 13, -7, -8,
    9, 0, 21, 17, 7, 4, 77, 32,
    -10, 20, 27, 8, 21, 17, 19, -35,
    -12, 16, -3, 25, -4, 7, -19, -3,
    -35, -14, 50, -98, -20, -33, 25, -18,
    -40, 4, 0, 10, -33, 22, 39, 19,
    -23, 45, 11, -10, -7, -16, 10, -9,
    -5, -30, -13, -22, -9, -18, 21, 19,
    -14, 46, 36, -4, -12, -66, 3, -82,
    14, 14, 7, 12, 40, -46, -10, 47,
    14, 16, -53, 10, -9, 4, -11, 47,
    18, 19, 3, 6, 16, 26, 10, 9,
    -23, 5, 31, 3, 8, 46, 58, -1,
    8, 13, 20, 1, 2, -93, 33, 2,
    46, -6, -8, 34, 26, 26, 13, -22,
    -25, -24, 20, 38, 3, -23, -7, 5,
    26, 25, -3, -55, -18, -67, 30, -4,
    9, 11, -25, 8, -35, -23, 49, 45,
    -8, 4, 38, -31, 16, 4, -17, 30,
    69, -20, -15, 34, -22, -28, -2, 6,
    -76, -33, 46, 9, 21, 4, 27, 0,
    -4, 24, -20, 8, 8, -25, 38, 1,
    6, -70, -15, 19, -1, -8, -11, 10,
    -28, 24, -33, 17, 8, 0, 29, 5,
    -17, -9, 45, -14, -8, -10, -36, 14,
    -6, -15, -12, -15, 37, 35, 12, 18,
    11, 17, -3, -13, 11, 23, 6, 22,
    -16, -12, -31, 21, -12, 6, 19, -28,
    -23, 1, -13, 3, -28, -32, 22, 28,
    2, -12, 8, 7, 31, -2, -69, 6,
    48, 58, -4, 18, 42, -14, -9, -22,
    28, -6, 23, -16, 8, 18, 3, 0,
    -9, -20, 3, -21, 41, -36, -42, -30,
    0, -15, -13, 11, 50, -52, 49, -8,
    -44, 9, 17, 21, -7, 25, 2, 0,
    -19, 1, -48, -9, -9, 4, -14, -19,
    32, -23, 31, 18, -58, -17, -24, 2,
    2, -10, 38, -42, 39, -27, -38, -2,
    46, 7, -13, -6, 0, -42, 7, 31,
    2, 3, -36, -11, -37, -21, -23, 33,
    5, 23, 40, 24, -47, -13, 44, 59,
    -6, -1, 2, -11, 44, 16, -20, 7,
    -48, -11, 6, 4, 2, -32, -40, 19,
    8, 3, 5, 5, 17, -6, 20, 36,
    -15, -16, -49, -1, 27, 19, 35, 47,
    7, 16, 5, 10, 21, 6, 8, 9,
    -35, -43, 19, 24, -27, -8, 12, -49,
    7, -34, -22, 44, -1, 42, -16, 20,
    -2, -58, 29, 31, -10, 14, -36, -5,
    19, -3, -21, 29, 27, 44, -18, -24,
    61, -16, -65, 53, -35, -29, 3, 17,
    41, -6, 18, 9, -30, -1, -6, 29,
    51, -9, 11, -82, 18, -18, 60, 10,
    -28, -15, -10, -16, -44, -3, 48, -56,
    4, 16, -7, -12, 26, 19, -46, 29,
    -38, 27, 15, 23, 38, -18, -17, 16,
    -28, 8, 5, 10, -37, 3, 23, -4,
    -6, -2, 2, -13, -5, 12, 31, -10,
    -2, -9, -15, 25, 7, -27, 24, -9,
    6, 38, 15, -2, 16, 21, 18, -15,
    -50, 2, -7, 8, -12, -47, 38, -28,
    -4, -7, 18, 20, 15, 12, 18, 8,
    -12, 8, -46, 31, 7, -14, 16, 5,
    -7, 21, -34, 0, -21, 13, -18, -10,
    -1, -25, -3, -37, -42, 4, -51, 4,
    5, -52, 6, 14, -29, 70, 17, -23,
    8, -1, 24, 17, 10, -30, 14, 0,
    -41, 20, -34, -17, -3, -24, 36, -8,
    9, 9, 20, -4, 0, 5, -27, 18,
    -5, -8, -2, -7, 37, -10, 10, 24,
    9, 7, 27, -12, 8, 19, 18, -23,
    -15, 14, 3, 31, 15, -2, -5, -4,
    80, 21, 5, -7, -44, 2, 10, -3,
    -10, 24, 28, 12, -9, 70, -71, 7,
    -81, -5, 24, -3, -11, 14, 13, -24,
    10, -6, -7, -5, -18, -3, 28, -29,
    -10, 17, 21, -9, -5, 7, -17, 32,
    -10, -11, 2, 6, 31, -24, 2, 29,
    -6, -56, -39, 13, -13, 23, 3, 1,
    -8, 17, 9, -6, -63, -6, -16, -11,
    -46, -5, 32, -5, -17, -10, 1, 37,
    -42, 0, -4, 9, 15, 37, -14, -3,
    -108, 20, -8, -24, -61, 10, -8, -9,
    49, 18, -19, 61, 41, 17, 67, -5,
    1, 13, -38, 13, 16, 19, -39, 3,
    5, -14, 28, 13, 36, 91, -9, 40,
    -43, 44, 12, -50, -13, -30, 34, -2,
    12, -41, 7, 49, 1, 33, -37, -30,
    -27, 26, 2, 48, -26, -6, 4, -22,
    20, -18, -9, 10, 10, -67, -1, -24,
    14, 10, 1, -2, -22, -38, -31, 20,
    9, -6, 5, 48, 43, -28, 31, 10,
    -6, 1, -19, -7, -23, -26, -27, 5,
    -1, 3, -39, 1, -2, 5, -56, -34,
    8, -66, 13, 3, 29, -13, -14, -17,
    0, -13, -55, -21, -2, -2, -28, 0,
    -4, -28, -71, -8, -31, 12, 46, -40,
    -12, -23, 41, 13, -9, -10, 18, 23,
    -32, -23, 1, 48, -29, 9, -22, 18,
    -17, 36, -1, -36, -13, 6, 16, -9,
    -8, -8, -24, 48, 13, 12, -6, -30,
    35, -6, -2, -7, -68, -38, -19, 9,
    -27, -22, -44, -1, -4, -8, -14, -5,
    -10, -33, 3, 6, 34, -24, -17, 38,
    0, -24, 2, 23, -14, -95, 13, 23,
    28, -1, -33, 75, -43, 44, 8, -32,
    -19, 45, 18, 93, 30, 27, -30, 38,
    9, -35, -8, -77, -9, -45, -28, -18,
    -3, 16, 34, 1, -44, 18, 42, -32,
    -13, -6, -9, -26, -41, 5, -14, -29,
    4, 26, -38, -26, -17, -12, -10, 4,
    -23, 12, -29, -16, 25, -42, 15, -30,
    -25, -13, 9, 27, 8, -15, 42, -4,
    27, 7, -26, 10, -9, 19, -11, 26,
    6, 22, 37, 5, 20, -11, 27, 1,
    16, -2, -20, -6, 27, 28, -21, 20,
    -25, 20, -36, -47, 37, 22, 11, 70,
    -18, 4, 24, -34, 36, -11, 67, -31,
    -7, -27, 48, -28, -13, -5, -72, -4,
    -35, 26, -29, 23, -4, -28, 15, -39,
    10, -10, -21, 25, 36, 26, 49, -45,
    -25, -11, -3, 14, -43, -38, -66, -10,
    -1, -27, -55, 12, 5, -2, -11, 39,
    -19, 28, 31, -4, -32, 20, 18, 15,
    -15, -23, -14, -20, -9, -4, 21, 25,
    -8, -7, 13, 4, 2, 29, 29, 30,
    -76, -30, -8, -1, -26, -43, 7, -21,
    17, 5, 12, 9, -11, 6, -23, 14,
    -57, -47, -21, 20, -7, 7, -37, 9,
    -7, 4, 24, -27, 71, -32, -38, 9,
    17, 18, 30, 5, 11, 21, 42, -44,
    -14, 7, -6, 41, -5, 2, -2, -16,
    3, 16, 17, 13, 0, -56, -28, -14,
    -16, 4, -14, 9, -29, -40, 50, 14,
    -1, -31, -32, -40, 9, -16, -11, -14,
    10, 1, 12, 46, -18, 25, 4, 25,
    -9, -3, 2, -37, 14, 4, -32, -6,
    21, -9, -13, -8, 20, -51, 21, 5,
    14, 17, -2, 36, -1, 22, -11, 45,
    18, -9, 12, 0, 5, -9, 2, -37,
    -6, 24, -21, -4, -2, 4, 24, -52,
    -1, -8, -8, 4, 0, -70, 1, -22,
    30, -32, -19, -8, 42, 42, -11, 0,
    4, 60, -15, 49, 3, 14, 4, -6,
    3, -35, -20, 14, -62, 12, 24, -57,
    -4, -6, 16, -10, 9, -21, 30, 18,
    33, -36, 20, 9, -11, 1, -9, 8,
    20, -3, 2, -8, 20, -20, 9, 10,
    25, 26, 29, 2, -9, 4, 5, 3,
    6, 3, -6, 5, -13, 71, 0, -16,
    -24, 9, 5, 33, -5, -7, 4, -8,
    -12, -27, 22, -17, 7, -31, -8, 1,
    -10, -16, 22, -4, -28, 18, 60, 11,
    30, 1, -15, -16, 43, -17, -40, 41,
    45, 3, 29, -9, 3, 37, -19, 21,
    19, -2, -2, -8, 38, 5, 33, -50,
    -18, 11, 12, 1, -49, -68, -12, 18,
    -4, -17, 7, 9, -57, 41, 2, 101,
    39, -9, -2, -40, 2, 10, 13, -22,
    32, 20, 16, -1, 13, -39, 52, -16,
    -14, -19, 38, 43, -76, -53, 22, -8,
    28, -30, 15, 16, 20, -39, 56, -50,
    -23, 5, -10, 15, -24, -19, -37, 35,
    10, 26, 9, -9, -46, -22, 1, -23,
    15, -39, 58, -17, -45, -41, -5, -21,
    15, -8, 7, -54, 43, 33, -60, -47,
    22, 21, 57, 1, -27, -36, 3, 3,
    -63, 40, 2, -82, 7, -37, 16, 28,
    10, 5, 36, 57, -13, 13, -38, -2,
    -8, -24, 2, 21, -3, -10, -37, -24,
    -11, 21, -65, -33, 114, -17, -7, 23,
    -15, 28, 1, -34, -71, -58, 12, 31,
    -16, 27, -13, 35, 29, -82, 29, 44,
    -18, 2, 20, 35, 32, 14, -127, 32,
    -26, -2, -12, -84, -52, -9, -14, 68,
    -104, -25, 23, 6, 12, 38, -20, -4,
    13, 32, -71, -18, 2, -29, -24, -98,
    5, 1, -41, 65, -62, 11, 20, 47,
    18, -2, 15, -8, -22, -22, 7, 13,
    53, -9, -99, 80, -19, 2, 17, -12,
    -19, 38, 109, -21, -18, 14, 54, 7,
    -26, -13, -10, 15, -70, -13, 22, 20,
    -52, -7, 11, 20, 41, 50, -8, 1,
    34, 30, -20, 10, 0, -6, -7, -54,
    55, 4, 36, 4, 43, -15, -35, 20,
    -9, -17, 24, -21, 21, 14, 31, -76,
    -77, -2, -30, -4, -33, -35, 35, -3,
    23, 21, 24, -8, 60, 64, 7, 14,
    -21, -26, -32, 21, 26, -1, 17, -28,
    -8, 4, -10, 37, 44, -24, 74, 49,
    -7, -10, -20, 47, -8, -14, -12, 8,
    0, 13, 30, 3, -5, 13, -10, 21,
    -21, 11, -30, 2, -36, -2, -10, -18,
    8, -105, -15, 38, -21, 16, -12, -6,
    -9, 54, -30, -16, -45, -36, 5, -5,
    33, -23, 23, -1, 34, -38, -31, -52,
    27, 32, -6, -6, -9, -49, -82, -11,
    1, 45, 13, -32, -39, -51, 37, 26,
    -11, -50, -21, 49, -26, 53, -44, 20,
    27, -2, -14, 17, 61, 36, 10, -15,
    43, 14, 76, -15, -100, 23, 34, 22,
    -27, 5, -21, -12, -25, 8, -80, 39,
    15, -15, 0, 68, -8, 58, 58, 2,
    -26, -5, 23, -92, -8, 6, -12, -27,
    42, -67, 49, -13, 65, -53, 8, -22,
    18, 26, 21, -1, 40, -72, 116, -7,
    -32, -18, 29, 30, 31, -33, 52, 14,
    -15, 76, -37, -30, -8, 6, -20, -9,
    -55, -24, -6, 17, 48, 63, -51, 20,
    -53, -38, 7, 17, -30, -41, -81, -13,
    -53, -50, -44, -53, -9, -28, 17, 56,
    4, 0, 22, 90, -6, 2, -44, -45,
    46, -38, 50, -30, -63, 36, -22, 13,
    -12, 9, -45, -16, 15, -54, 29, 40,
    -27, 14, 10, -36, -85, 27, -24, 22,
    10, 61, 4, 29, 19, -32, -9, -37,
    34, -21, 31, -23, -66, -18, -15, 31,
    -17, -40, -10, 20, -19, -55, -54, 91,
    36, -40, 7, 85, 9, -31, -13, 35,
    17, 11, 18, 15, 77, -85, -8, -5,
    7, 29, -10, 80, -30, -3, -57, 43,
    -22, -35, 13, -14, -17, -93, -43, -36,
    15, -92, -28, 50, 22, -18, 1, 35,
    10, -8, -25, -48, 6, 34, -9, -16,
    -3, -59, -25, 63, -11, -25, -16, 9,
    -3, 5, 62, 14, -9, 56, -1, 1,
    -43, -24, -36, -21, -116, -13, -10, -22,
    21, 56, -24, -17, -13, 6, -9, 6,
    15, -42, -96, 15, 22, 53, 28, -11,
    -20, -32, -14, 3, 41, -10, -57, -53,
    -75, -15, 28, -20, -11, 4, 5, -33,
    32, 11, 2, 24, 32, -67, 9, 8,
    -66, -5, -43, -1, -47, 17, -46, 20,
    71, 16, 18, 85, -11, 77, -36, -38,
    -66, 34, 29, -9, -12, -5, -2, -52,
    -6, 19, -1, -2, 19, -42, 0, 23,
    -44, -52, 71, -10, 21, 10, -39, 30,
    -2, 26, -38, -91, -84, 20, -28, -6,
    -3, 39, -16, 12, -23, -6, -68, -4,
    9, 10, -48, -43, 9, -23, 17, -52,
    -4, 3, -10, 4, -31, -37, 11, -14,
    7, 10, -52, -5, 20, -15, -49, 10,
    10, 25, -8, -64, 21, -6, 13, -27,
    -72, 27, 38, -64, -18, 10, -56, -28,
    -44, -14, -68, 107, 7, 22, -13, 61,
    18, -51, -4, 2, 94, -24, -1, -8,
    2, 39, 99, -45, -72, -54, 34, 12,
    -29, -43, 43, -65, 35, -16, 10, -26,
    -72, 71, 48, 11, 20, 55, -46, 61,
    -41, -25, 41, 11, -53, -10, 5, 12,
    54, 21, -93, -36, -64, 17, -32, 24,
    -26, 31, 28, 4, -26, -21, 20, 27,
    -15, -44, -33, -15, -61, -15, 30, -22,
    -31, -12, 27, 1, 64, 23, -9, 58,
    -21, 12, -68, 11, 124, -21, 23, -13,
    23, -19, 85, -14, -19, -40, -31, 63,
    92, 23, 16, 32, -56, -47, 39, 18,
    -8, 2, 6, -28, -8, -65, 24, -30,
    43, -43, 49, 56, 78, 0, 50, -26,
    95, 16, 37, 26, -14, 17, 18, 3,
    14, -13, -79, 127, 11, 3, -39, 82,
    -26, -1, 42, -31, 0, -72, 31, -28,
    1, -12, -72, -8, -7, 5, -13, 75,
    5, -20, 10, 49, -38, -13, -63, 36,
    -1, -25, -5, 50, -5, -25, 47, 40,
    15, -31, -13, 38, 18, -47, 28, -42,
    -18, 76, 46, 56, 2, 24, -3, -3,
    19, 15, -39, 21, -7, -16, -17, -30,
    22, 8, -28, -29, 28, 17, 53, 66,
    -9, -27, -15, 22, -87, 76, -86, 80,
    -38, -5, -26, -6, 45, 36, 16, 54,
    -12, -3, -50, 65, -8, -38, 48, -29,
    -17, 13, -61, 65, -56, 34, -12, 21,
    10, -38, 4, 1, -69, -2, 46, -4,
    4, 31, 30, 13, 47, -14, -22, -18,
    0, -14, 29, -25, -33, -30, 34, 6,
    27, 18, -42, 30, 29, 6, 7, 3,
    14, -36, -11, -28, 24, 64, 58, -29,
    -42, 24, 36, 3, 6, 22, -27, 11,
    -28, -33, -69, -2, -12, 2, -1, -42,
    -5, -65, -35, 28, -9, -7, -17, -22,
    -16, -13, -6, -36, 89, -124, -50, 18,
    10, -14, 41, -22, 25, -2, 12, 20,
    -55, -6, 80, -7, 5, 18, -8, -76,
    11, -18, -42, 1, 49, -35, 10, -1,
    -21, -27, -16, 6, -9, 11, 4, -12,
    24, 3, -33, 0, -20, 37, 3, 6,
    -30, -8, 30, 5, 23, -11, 22, -21,
    -36, 27, 27, 10, 8, -4, -12, 2,
    -24, -8, -4, 9, 36, -37, 10, 7,
    -2, -9, 21, -1, -5, -13, -14, -3,
    38, -5, 33, -6, 18, -24, -3, 37,
    51, 0, -13, 18, 7, -8, 17, -5,
    -2, -11, 35, 5, 14, -12, 17, -15,
    7, -3, 12, 2, 32, 2, 18, 4,
    -7, 45, -5, 10, -27, 15, -34, -13,
    7, 4, -23, -21, 24, 10, -28, -7,
    36, -21, 1, -9, 38, 0, 3, 18,
    6, -2, -33, -27, 13, 10, -2, 1,
    3, 5, 19, -33, -45, -9, -12, -14,
    55, 12, 25, 14, 6, -21, 4, -18,
    7, 16, -9, -22, 2, -1, -25, 14,
    6, 0, 2, 6, 6, -6, -44, 24,
    15, -18, -5, 51, -21, 0, -10, 12,
    -4, -3, 2, -13, -16, 15, -1, 17,
    16, 15, 10, -2, 15, -2, 16, -7,
    4, 11, -7, -26, -16, 28, 25, 3,
    33, 24, -31, -18, -57, 10, 37, -4,
    -29, 7, -16, 4, -16, 4, 3, 5,
    -27, 23, 19, 40, 0, 12, 36, -2,
    3, 15, 22, 3, -13, 8, 20, 16,
    -25, -9, -9, -31, 9, -21, 6, 30,
    13, 19, -12, 30, 13, 1, 1, 4,
    -19, -6, -1, 2, -43, 22, 13, 33,
    4, 13, -6, -19, -24, 2, 41, -9,
    -9, -18, 3, -70, -16, 14, 14, -7,
    -32, 18, 2, 1, 7, 13, -14, 6,
    1, 7, 13, 19, 25, 12, 1, 13,
    -6, -21, 3, -11, 70, -1, 0, -36,
    3, 12, 15, -1, -17, -12, -26, 0,
    0, -11, -13, 6, 4, -5, 15, -27,
    8, -54, -6, 15, -10, -11, -36, -10,
    38, -14, 8, 13, 8, 22, -40, 2,
    -3, -15, -21, 2, 2, 22, 6, -2,
    5, 41, 31, 14, -7, 18, 2, -40,
    30, 1, -11, 27, -6, -41, 22, -10,
    -5, 15, 5, -36, 7, 30, -16, 35,
    -17, -22, 0, 22, -1, -15, -8, -12,
    38, 28, 5, 11, -18, 7, -2, 6,
    22, 18, -15, 33, -31, -9, -12, -14,
    10, -23, -24, -21, 3, 0, -9, -2,
    -46, 28, 5, -6, 0, 7, -39, -29,
    -14, -10, 15, 16, 11, -14, 6, -2,
    18, -34, -29, 24, 3, -21, 11, -12,
    34, 28, -25, 1, 0, -14, 21, -21,
    12, 10, 18, 10, 14, 29, -3, -26,
    -16, -1, -39, -25, -7, -13, 7, -2,
    21, -4, -21, 8, -12, -5, 1, -45,
    21, 5, 30, -4, 11, 10, -22, 5,
    -9, -7, 48, -5, 7, 4, -27, -8,
    41, -20, 0, -1, 16, -8, 6, -6,
    17, 13, -35, -12, -18, 23, 6, 7,
    34, 12, 30, -5, -6, 27, -12, 4,
    -47, 18, 5, 8, 21, 20, -19, -23,
    -2, 48, -26, 16, -1, -4, 24, 6,
    -10, -5, 1, 15, 21, 1, -32, 14,
    -3, -18, -15, 14, 24, 1, -27, 3,
    24, -28, -3, -50, 20, -18, -12, 35,
    -14, -17, 26, 5, -25, 31, 0, -4,
    28, -30, 10, 18, 20, 6, -21, -5,
    5, -19, -4, 2, 37, 1, 30, 2,
    14, 8, -14, -5, 11, 26, -13, 29,
    20, -15, 18, -20, 6, 27, -8, -11,
    -7, -18, -44, -31, 2, -19, -7, -11,
    -22, -16, 0, 13, -21, -1, -33, 15,
    -20, 16, -20, -13, 32, -4, -2, -5,
    28, 0, 3, -7, 2, 10, -9, 21,
    -10, 36, -26, -5, 16, -10, -12, -18,
    32, -4, -37, -3, 5, 20, 14, -32,
    11, 24, 3, 18, 30, -47, 38, 11,
    9, 13, -21, 27, 6, 22, -8, 3,
    16, -14, 14, 7, -21, 39, -11, -3,
    -17, -22, 7, 28, 10, 2, 4, 6,
    24, 0, 16, -6, -24, -19, 36, 25,
    -10, -22, -38, -2, 5, 6, -10, 6,
    0, 15, 5, -21, -14, 13, -5, -4,
    23, -37, 7, 0, -2, 1, 18, -11,
    -13, 1, -11, -15, 21, -33, 31, 14,
    -13, -7, 14, 7, 2, 18, -9, -3,
    20, 32, 0, -32, 1, 21, -4, -53,
    -21, -7, -12, 25, -15, -10, -40, -59,
    1, -24, -12, 17, 4, 24, -25, -31,
    -47, 34, -9, -43, 18, 23, -4, 8,
    6, 12, -27, 34, -16, -11, 1, 35,
    -16, 13, -6, 23, 16, -5, -13, -20,
    -5, -8, -4, 15, -5, 9, -15, -13,
    -2, -5, 4, 4, -2, 6, 17, 3,
    -27, 27, 8, -11, -8, -10, -1, -11,
    4, -13, 6, 1, -35, 11, -14, 10,
    -8, 1, -13, -7, -2, -21, 7, -12,
    -52, 1, 13, 14, -3, 1, 5, 1,
    -18, -6, 32, 0, 11, -1, 3, 38,
    9, 21, -15, -15, 9, 19, -1, 97,
    0, 6, -25, -4, 25, 4, 22, 7,
    6, -13, 4, -12, -11, 15, 1, -1,
    9, -15, 13, 32, -54, 45, 17, 11,
    -21, -17, -11, 31, 15, -17, -3, -1,
    -7, -4, -20, -10, -15, -6, 12, 3,
    -22, -15, 36, -22, -9, 17, 25, -9,
    30, -28, -20, 26, 12, -21, -15, -7,
    -12, -9, 5, 16, -1, 13, -21, -1,
    9, -19, -39, 45, 0, 32, 23, 4,
    4, 37, 5, -25, 31, -9, 8, -18,
    26, -29, 13, 9, -10, -2, -3, 6,
    -3, -7, 6, -12, 45, 5, -2, -14,
    -5, -12, -2, -31, 0, -7, 15, -21,
    -25, -22, -8, -9, -5, 7, 12, 4,
    6, -16, -31, -16, 13, -21, 10, 4,
    4, -24, 17, -16, 4, -23, 4, -14,
    1, -21, 5, 7, -12, 9, 21, -12,
    15, -9, 6, -6, 5, 0, 2, 11,
    -9, 20, 4, 7, 2, 8, -27, -4,
    12, -1, 12, 13, -11, -3, 11, -23,
    -6, 23, -10, -29, -1, -11, -2, -10,
    -13, 18, 20, 24, -23, 7, 11, 2,
    32, -1, -8, -24, -27, 12, -3, 28,
    9, -6, 41, -2, 9, 11, -17, -52,
    16, 19, -30, 2, -18, -5, 27, -2,
    -9, -3, 0, -49, -10, -15, -1, 19,
    0, 4, 17, 16, -6, -15, 15, 39,
    1, -4, -6, -5, 39, -14, -17, 79,
    -22, -12, 23, 16, 3, -11, 18, 30,
    -33, 35, -17, -17, 2, 13, -8, 2,
    5, 15, -8, 5, -32, 5, 28, 34,
    33, -37, -24, 0, -11, 0, 18, 12,
    11, 22, 9, -4, -12, 50, -16, 21,
    0, -7, 37, -1, 1, -5, -22, -24,
    2, 27, 12, -13, 16, -24, -2, 19,
    14, 3, 18, 11, -3, -1, -1, 14,
    16, -7, 26, 3, -1, -49, -18, -10,
    14, -2, -14, 20, 28, -6, 6, 6,
    -16, -21, -54, 42, 17, -31, -40, -21,
    13, -5, 39, -8, 18, -7, 9, 25,
    28, 23, 21, -12, -9, -8, -32, 5,
    -6, 4, 8, -41, 7, 1, -22, -5,
    4, -43, -3, -4, -12, -23, 14, 12,
    -11, 5, -33, -22, -8, 11, -2, -8,
    16, 30, -10, -18, 16, -29, 30, 2,
    6, -4, -2, -9, -9, -74, 7, -6,
    -5, 51, -4, -14, 31, -11, -23, 33,
    11, -20, 13, -1, -4, -33, -61, 6,
    7, -2, 3, -6, 3, 14, -11, 31,
    -3, -22, 32, -31, -4, -7, 9, 10,
    -47, 24, -1, -21, 13, -9, 20, -5,
    5, -15, 0, -9, -3, -1, 4, -21,
    -20, 33, -27, 14, 57, 13, 7, 26,
    -11, 27, 2, 4, 14, 8, 6, 5,
    44, 15, 11, 35, 25, -21, 6, 21,
    3, 16, 17, 16, 11, -10, 10, 9,
    7, -29, 10, -18, 14, -22, -9, 78,
    -15, 16, -37, 23, 13, -10, 3, -21,
    28, -10, 21, 10, -8, -4, -6, -12,
    23, 2, -3, 12, -4, -1, 28, -8,
    -32, -3, -6, -48, -3, 18, 12, -25,
    -48, 24, 8, -33, 7, 3, -15, 13,
    20, 18, 28, -6, 17, 6, 2, 7,
    6, -31, -42, -19, 59, 13, 0, -14,
    3, 5, 39, -4, -24, -10, -20, 7,
    -11, 26, 2, -8, 7, -9, 3, -24,
    17, 20, -7, 5, 5, 19, -43, -3,
    33, 27, 10, 7, 11, -3, -24, -2,
    -28, -26, -3, 6, 7, -3, -17, 1,
    -21, -10, 19, 16, -12, 22, -3, -66,
    15, 4, -13, 9, -5, 6, -19, 9,
    55, 54, -9, -47, -3, 20, -17, 36,
    -23, -22, 14, 17, 7, 22, -10, 14,
    -44, 20, 15, 5, 14, 32, 1, 3,
    16, 74, 11, 47, -58, 26, 34, 33,
    33, -10, -22, 14, 1, 18, -5, -1,
    8, 49, 11, -13, -50, -10, 5, 1,
    39, -28, -33, 6, 31, -17, -4, -11,
    -16, 6, -29, -57, 14, 21, -20, -16,
    -17, -10, -30, -13, -20, -9, -23, -10,
    -14, 27, 5, 8, 16, 37, 18, -10,
    22, 36, -60, 0, -7, -6, -6, 1,
    -9, 17, 5, -20, -7, -24, -55, -36,
    5, -5, 18, 0, 7, 2, -24, -13,
    -11, -6, -1, 25, -7, -24, -10, -7,
    52, -1, -6, -4, -8, 3, 11, 9,
    -4, 41, -37, 32, -35, 25, -2, 18,
    40, 5, 14, 15, 2, 25, 0, 1,
    -16, 31, 27, 17, -14, 4, -12, -23,
    -12, 22, 26, 9, 1, -16, 13, 10,
    -14, 5, 8, 20, -12, -47, -1, 33,
    -25, -36, 11, 4, 35, -17, -23, 0,
    -1, -14, 29, -10, -23, -14, -20, 7,
    2, 13, 3, -2, -23, 42, 13, -10,
    13, -34, -33, 33, 15, -35, 24, -19,
    -2, 21, -53, 31, 18, -11, 14, -32,
    5, -27, -55, -11, -6, -5, -43, -31,
    24, 9, 13, 4, 2, 40, 16, 18,
    -64, -28, 4, 0, -13, 17, 2, 55,
    9, -47, 4, 37, -19, -7, 23, -22,
    22, 16, 24, -24, 1, 24, 32, -11,
    69, -15, -30, 31, 11, 1, -3, 26,
    8, 31, 16, 18, -27, -26, -16, -29,
    30, 3, -40, -8, -17, -29, -12, -5,
    -5, -6, 10, 41, -25, -25, -45, -5,
    15, 24, 26, 28, -7, 13, -8, -13,
    27, 27, 8, -17, 7, 3, 16, -35,
    -15, -5, 4, 44, 29, -11, 14, -28,
    37, 14, 19, -9, -12, 6, -29, -33,
    -6, -28, 16, 25, -21, 10, 12, 0,
    32, 28, 4, 3, -9, 52, -8, -16,
    13, -30, -6, -14, 16, 18, 8, -21,
    16, -11, -24, -4, -41, 0, -9, -9,
    4, 0, -14, 13, -1, 47, -6, 0,
    44, 38, 44, 1, 6, 5, 36, 78,
    -3, -7, 10, 27, -20, 1, -51, -6,
    -9, 5, -23, -6, -10, 9, -41, 18,
    -9, 16, -3, -35, 16, 25, 3, 27,
    31, 3, -18, -22, -16, -45, -8, 44,
    -18, 14, 10, 7, -8, 2, 16, -22,
    -7, -26, 29, -9, -13, 5, -30, 28,
    14, -6, 4, -6, 8, 15, -10, 25,
    -40, 27, 15, 9, -23, -31, 6, 23,
    11, -31, -22, -13, -5, -9, 7, 2,
    -6, 20, 11, -9, -8, -13, 59, 10,
    -38, -20, -1, -3, 3, -1, 2, 10,
    37, -5, -85, 8, 1, 35, -39, 44,
    11, -22, 41, -5, 33, 24, -2, 85,
    8, 28, -67, -4, -35, 13, 23, 8,
    20, -16, 39, -16, -19, 3, 33, -8,
    -2, -12, 7, -24, -4, 31, 32, -44,
    -35, 15, -41, 46, 5, -13, -2, -26,
    -7, -17, -43, 9, -21, 28, 37, -16,
    -8, -1, -24, 16, -22, 10, 24, 6,
    3, 6, 4, 1, 9, -5, 7, 37,
    -13, 1, 6, -28, -4, 10, -2, 13,
    4, 11, 5, 40, -16, 6, 16, -26,
    18, 19, 1, 28, 34, -5, 1, -17,
    46, -8, 11, -33, 5, 4, 10, 5,
    8, -39, -31, -32, 48, 6, 13, -23,
    -3, -22, 10, -48, -3, 10, 15, 8,
    -15, -1, -5, 27, -5, 2, -9, 11,
    -15, 15, -10, 1, 2, 20, -21, -14,
    24, -21, -3, -22, 15, 18, 4, -15,
    -7, 15, 19, -19, 13, -34, -23, 4,
    11, 5, 4, -5, 7, 2, -16, 3,
    -28, 32, 27, 37, -28, -24, -19, 25,
    16, 15, 31, 1, 17, 6, -3, -4,
    -14, 5, -8, 12, 19, -20, -4, 21,
    -1, -1, 30, 1, -10, 5, -2, 2,
    27, 12, -2, -45, -18, -36, 3, 17,
    -3, -20, 23, -19, -2, -7, 11, -35,
    9, 0, -20, -15, -16, -48, 35, -15,
    7, 16, -22, -5, -10, -11, -11, 12,
    6, 0, 47, 11, 19, 10, 31, 27,
    -18, 18, -11, 5, 17, 20, 15, 87,
    16, -28, -12, 14, -43, -5, 30, 5,
    2, 32, -1, -11, 0, 13, 14, -3,
    -32, 64, 21, 28, -16, -49, 13, -69,
    33, -39, 7, -15, -8, -27, 27, 21,
    19, 26, 30, -56, -32, -7, -34, -8,
    28, -32, 26, 1, 12, 29, -9, 3,
    -12, -21, 24, -25, -1, -1, 16, 44,
    -23, -20, 53, 14, -16, -43, -10, 12,
    2, 11, -29, 32, 71, 17, -23, -28,
    2, 56, -28, 33, 19, -3, 7, -8,
    38, 20, -22, -25, -123, -6, 46, 48,
    -18, 8, 62, 21, 22, 20, -34, -11,
    -21, 47, 3, 1, -19, -33, 91, 2,
    16, 18, -54, -20, 14, 2, -38, 11,
    -22, 25, 36, -25, -5, -14, -25, -35,
    -8, -37, 20, -32, 3, 28, -3, 3,
    4, -38, -44, -29, 8, -11, -16, -20,
    15, -4, -38, 7, -35, -94, -1, -22,
    -42, -7, -22, 0, -18, -31, -9, -11,
    31, 20, -46, -2, 5, -12, -86, 6,
    14, -9, 25, 16, 38, 89, 21, -57,
    -47, -50, 51, 16, 10, -18, 3, -3,
    14, 10, -14, -9, 7, 9, 12, -26,
    -34, -21, -27, 57, 6, 13, -3, 25,
    18, 41, -61, 13, -33, -26, 15, 2,
    -66, 101, -41, 39, 27, -2, -15, 21,
    67, 6, 13, 23, 24, -3, -16, 14,
    -35, 26, 6, -21, -23, 9, -21, -5,
    -59, -70, 29, 39, -36, -63, -29, 17,
    -3, 4, -20, -14, 20, -11, -18, -19,
    64, -2, 5, 13, -42, -13, 15, -17,
    52, 4, 22, 7, -12, 20, 102, -28,
    -18, 18, 33, -77, -33, -44, -30, -29,
    -87, -42, -20, -70, 8, 20, -3, 10,
    12, 38, 36, -11, 12, -39, 31, -3,
    -16, -19, -32, 8, 78, -12, 24, -31,
    8, -12, 32, 23, 2, -23, 38, -18,
    -33, 36, 18, -18, 19, -5, -4, -24,
    42, -13, -18, 10, -7, 60, 22, 1,
    62, 2, -1, -14, 47, -30, -32, 8,
    -48, -14, 35, 14, -32, 44, 2, -8,
    -20, -21, 28, 50, -7, 11, 1, -83,
    61, 24, -30, 22, 20, -70, -2, -11,
    71, 58, 23, -87, 6, -28, 6, 50,
    47, 6, -46, 47, -69, -5, -8, 31,
    -18, -5, 24, -33, 29, 48, -18, 7,
    35, -25, -66, 29, 20, 37, -40, 0,
    62, -5, -13, 25, -4, -46, -3, 14,
    -9, 5, 34, 6, 36, 39, 28, -35,
    19, -35, 66, 17, 8, -13, 20, -2,
    -12, -15, -51, -78, -10, -52, -51, -23,
    -14, -21, -34, -17, -4, 0, -4, 30,
    16, 1, -2, -29, 2, -28, 31, -44,
    42, 65, -9, 61, -26, -2, 6, -1,
    20, -23, 75, 25, 24, 32, -10, -33,
    22, 10, 20, 4, 17, -14, -5, -8,
    -29, -20, 13, 56, 47, 66, -49, -27,
    0, -57, -15, -12, -19, -10, -4, 25,
    61, -13, 10, -27, 26, 24, 11, 12,
    1, -12, 12, -8, -9, -11, 40, -34,
    -48, 35, 9, 35, 2, 48, -3, 23,
    -44, -5, 4, 32, -4, 10, 16, 0,
    34, -23, -3, 12, -21, 51, 16, -37,
    -46, -30, -34, -9, 66, -52, -23, 15,
    -45, -13, 59, -59, 56, -5, -17, -6,
    3, 37, 35, -83, -23, 57, 12, 0,
    35, -10, 11, 48, 16, -11, -23, -1,
    -17, 14, -20, 80, 54, -29, 20, -11,
    -18, -15, -90, -23, 3, -45, -3, -40,
    1, -9, 37, -17, -4, 26, 24, 23,
    21, -1, 42, 50, -23, -17, -42, -85,
    -35, -35, -2, 10, 49, 7, 51, -14,
    2, -11, 35, 5, -24, 24, -71, 20,
    9, -6, -1, 28, 21, 5, 31, 38,
    -4, -14, 55, 0, -28, 24, 59, 0,
    8, -17, -48, -6, -3, -69, -12, 7,
    23, -39, 16, 46, 55, 15, 11, -5,
    -17, 16, -11, 56, 15, -9, -2, 2,
    -13, 11, 17, 21, -67, -37, 10, -71,
    -32, 27, -1, -44, -10, 59, -7, 12,
    24, 63, -14, -3, 21, 47, -28, 4,
    -27, 5, 92, -50, -20, 24, 21, 5,
    -4, 25, 42, -6, 1, 37, 8, 63,
    20, -31, -17, -3, -17, 15, 37, -2,
    -12, -38, -88, -9, 7, 27, 11, -5,
    17, 10, -47, 26, 1, 52, 32, -11,
    29, 40, 69, -2, 2, 24, 58, -36,
    -54, -43, 29, 18, 12, -1, -43, 13,
    -33, 32, -18, 16, -55, -21, 86, -1,
    -2, 40, -29, -16, 9, 23, 12, 33,
    41, 16, 16, -33, -15, -2, -48, -27,
    -22, 32, -3, 34, -29, 14, -14, 6,
    11, -95, 8, -22, 22, -45, 22, 7,
    20, -43, 22, -6, 5, 5, 1, 25,
    -83, 18, 10, -5, 34, -26, -2, -59,
    -28, -42, -25, 42, -52, 5, 2, -4,
    -26, 50, 36, -42, 10, 10, 15, 14,
    -26, -11, -4, 41, -5, 1, 2, 10,
    6, -48, -36, 21, -33, -30, 40, -13,
    81, -28, 48, 7, 17, 5, -5, 127,
    3, 52, 23, 22, -41, -27, 1, -54,
    18, 38, -53, -46, -33, 27, 49, -9,
    -28, -7, -48, 39, 59, 19, -19, 16,
    -11, 11, -12, 13, 11, 11, -34, 9,
    -35, 21, -53, -10, 43, 16, -25, -34,
    15, -1, -57, -5, -13, 15, -11, 13,
    7, 6, -17, -23, -16, 17, -10, 29,
    0, 0, -17, 27, -2, -18, 2, 1,
    -3, 19, 49, -27, -5, -12, -81, -48,
    4, 25, -13, 30, 24, 3, 12, 0,
    46, -2, -27, -47, 14, 21, 13, 25,
    13, 16, 14, -79, 36, 16, 18, 24,
    -4, -34, -59, -17, -4, 33, -6, -42,
    -20, 34, -67, 7, -7, -14, 11, 0,
    16, -55, -11, -54, -8, -29, -10, -15,
    46, 5, 9, -54, 15, -45, 22, -14,
    -11, 6, -2, 7, -1, -23, -36, 8,
    -35, 27, -40, 35, 20, 40, -43, -6,
    1, 33, 21, 63, 60, 22, 4, 20,
    79, 29, 8, 18, 1, 2, -46, -2,
    20, -19, -6, 11, -13, 16, 26, 31,
    -12, 23, -3, -11, -19, 6, 1, -8,
    35, -17, 20, -31, -64, -21, 39, 5,
    -21, 5, -8, 2, -12, -8, 63, -40,
    40, -6, 8, -14, 11, 22, -46, -24,
    16, 6, -50, 19, 0, -18, -27, 12,
    -26, -14, 25, 35, 21, 57, -4, -18,
    -14, 1, -19, -13, -30, -1, -33, 83,
    -28, 8, -1, 19, 42, 38, 0, 0,
    -75, -5, 19, 9, -3, 8, 23, 1,
    2, 56, 19, 9, 16, -6, -1, 12,
    -3, 7, 8, 10, 7, -14, -26, 35,
    30, 8, 12, 12, 1, -21, -4, -17,
    14, 6, -51, 2, 19, 14, -2, -27,
    -4, -29, 16, -22, 29, 2, 7, -2,
    4, -26, -6, 13, 38, -7, -32, 2,
    -28, -24, 36, 32, -38, 12, -19, 5,
    17, 8, -11, -18, -2, 6, -4, 7,
    -15, -8, 11, 48, -18, 2, 2, 27,
    38, 11, -25, -8, -75, 6, 21, 28,
    4, 17, -38, -6, 5, 42, -5, -17,
    -8, -37, 28, -14, 13, 1, 4, 20,
    -26, 17, 28, 10, 3, 11, -16, -2,
    -26, -41, -12, -16, 14, -18, 13, 38,
    6, -11, -17, -16, -1, -16, -13, -12,
    -4, -26, -9, -22, -14, 3, -2, 1,
    -10, -13, -31, -28, -4, 11, -5, 3,
    -8, -10, -26, -21, -33, -17, -18, -50,
    -35, -7, 11, 0, -14, -11, 18, 5,
    -1, 9, 45, -22, 2, -25, 6, -15,
    7, -48, -33, 48, 17, 4, -6, -2,
    21, 18, 0, 9, -40, 11, -8, 46,
    -28, 2, 13, 28, 36, 9, 27, -52,
    10, -5, 21, 9, -5, -14, -14, 0,
    8, 21, -20, 11, -2, -1, -9, -11,
    -9, 16, 54, -12, 21, 24, -5, 1,
    -4, -30, 16, -9, -10, -1, -17, 9,
    0, 3, 35, 6, 14, 12, -11, 44,
    34, -22, 1, 2, -14, 5, -16, 3,
    4, 54, 15, -5, -8, -23, 17, 45,
    18, -25, -15, 42, -7, -6, -7, 4,
    -13, -78, 5, 2, -10, -28, 8, -21,
    11, 13, -34, 29, 25, -1, 12, -65,
    9, 17, -20, 12, 12, 2, -8, -24,
    -15, 2, -25, -15, -7, 15, -5, -18,
    -37, -22, -26, -15, 11, 9, -23, -5,
    36, 1, 29, -16, -14, -43, 13, 21,
    28, -35, 31, -21, 8, 25, -21, 10,
    3, 69, 2, -24, -41, 8, 11, -3,
    -1, 1, -3, 7, 11, 7, 11, 38,
    14, -8, 5, -3, 6, -4, 2, 1,
    6, 2, 11, 13, -3, 38, 16, 1,
    37, 41, 25, -18, -7, 6, -8, -15,
    -4, 20, -5, -16, 3, -3, -5, -7,
    20, 19, -6, -24, -7, 13, 4, -7,
    -27, 21, 22, 18, -38, 20, -28, -10,
    -9, -23, 30, -25, 0, -3, -3, 1,
    11, -48, -5, 6, -10, -3, 12, -1,
    -22, -8, -29, -23, -42, -18, 1, 7,
    -20, -5, -3, -3, 15, 32, -2, 45,
    29, 11, 3, -40, 18, -7, -2, 14,
    3, 4, -4, 9, -46, -5, -14, -12,
    4, 17, -17, 16, -5, 16, -12, -8,
    -22, 21, -12, 0, -3, 14, 2, 18,
    -1, -21, 34, -29, -19, -12, 20, 28,
    15, -9, 1, -7, 21, 59, 4, 3,
    26, -11, 54, -19, 4, 18, 12, 14,
    4, -28, 50, 9, 11, -29, -26, -40,
    -2, -5, 13, -15, -8, -32, 33, 3,
    7, 8, -10, 46, 1, -14, 12, -11,
    -5, 60, -22, 1, 4, -15, 18, -2,
    9, -10, -15, 31, 15, -15, -6, 11,
    -7, -13, -27, 21, 12, 29, 2, 12,
    10, 19, 11, -22, -9, -13, 6, -21,
    21, -26, 43, 10, 15, 17, 12, -15,
    20, 17, 12, 25, 42, 27, 18, -26,
    9, 41, 1, 17, -27, 31, -28, -21,
    -20, -11, -10, 31, 14, -41, 2, -13,
    -9, -5, -4, 6, 2, -1, -5, 16,
    -23, -21, 3, 6, -46, -6, 9, -14,
    -23, -13, 10, -18, 7, 36, -41, 4,
    -40, -26, 11, -21, 3, -2, -24, 16,
    -36, 28, -16, -27, 2, 11, -9, 4,
    11, 3, 11, 27, 54, 46, 25, -10,
    -9, 11, -6, 9, 39, 21, 12, 0,
    -24, 7, -14, -9, -4, 15, 3, -2,
    -12, 30, 13, -36, 8, 32, -8, 4,
    -28, -16, -24, 29, 21, -15, -20, -17,
    19, 16, 18, -14, -31, -5, 0, 24,
    16, -8, 32, -18, -16, -29, 8, 8,
    13, 37, -2, 5, -4, 22, -6, 26,
    -7, 32, 7, 22, -19, -12, 2, 14,
    19, -61, -11, 3, -19, 48, -30, -21,
    18, -16, 7, -11, 13, 41, -10, -4,
    25, 22, 24, -6, 12, 29, -3, 3,
    -2, -3, -17, 11, 86, -10, -15, -11,
    -10, 27, -39, 26, -6, -6, -30, -9,
    12, -12, -35, 13, 4, 16, -26, 0,
    -29, -10, -31, -7, 15, 7, -5, 23,
    5, -5, -40, -26, 6, 1, 6, -23,
    0, -20, -19, -17, 19, -13, 6, -14,
    4, 35, -50, 15, -1, -9, 17, -19,
    -36, -28, -13, -32, 19, -5, -5, 10,
    -17, 12, 35, -15, -32, 4, 27, -12,
    -12, -8, -18, -5, 16, -4, -1, 2,
    10, -12, 18, 17, -2, 4, 38, -29,
    -24, -19, 25, 18, -6, 11, -1, -1,
    41, -23, 2, 23, 3, -38, -45, 10,
    32, 13, -15, 15, -26, 6, 46, 33,
    12, -6, 0, -28, -20, -9, 33, -1,
    42, -39, -13, 12, -9, 6, 6, 0,
    -6, 4, 5, 5, 8, 32, 2, 16,
    -11, -10, -22, -15, -4, -39, 23, -14,
    4, 3, -15, 17, 9, 4, 4, -23,
    -8, 11, -7, 0, 31, 6, -20, 10,
    -46, 14, -8, 25, 21, -11, 12, 7,
    -11, 31, 17, 15, 7, -7, -29, 11,
    -20, 9, 7, -5, 11, -19, -6, 10,
    -12, 3, 5, 18, -30, 21, 3, -11,
    -44, 31, -19, -12, -7, -15, -13, 17,
    7, 21, -18, 1, -12, 39, 14, 46,
    61, -13, 24, 12, -15, 22, -6, -18,
    1, 44, -4, -11, 5, -5, -25, 14,
    5, 14, -3, 16, 2, -21, -14, 11,
    17, 18, 48, 18, -5, 13, 21, 16,
    -12, 17, 6, 3, 10, -3, -23, -43,
    -9, 13, 3, -12, 2, 18, 5, 2,
    13, -1, -3, -3, -30, 51, 28, -6,
    -1, 1, -4, 23, -47, -12, -4, -15,
    21, 26, 10, -24, 38, -15, -12, 20,
    21, -11, 9, 1, -8, -7, 4, 15,
    -14, 0, 4, -17, -37, -27, -4, 6,
    3, -3, -21, 8, 10, -10, -18, 24,
    -10, -3, -2, 10, 7, -34, -37, -9,
    12, 1, 3, -35, -8, 17, 7, 59,
    31, -2, 6, -17, 10, -13, -33, 42,
    35, 3, -15, -1, -22, -3, -5, 7,
    21, -1, 2, -11, 16, 0, 17, -21,
    -72, -57, 9, -1, 8, 7, -8, -15,
    -13, 3, 34, 41, 10, 3, -40, 33,
    -21, -20, -24, -33, 27, 16, 17, -4,
    -24, 6, -2, 9, 31, -2, -7, -20,
    -22, -23, 18, 0, 31, -14, 8, 13,
    12, 5, 31, -10, 51, -6, -15, 3,
    23, 2, 22, 8, -39, 7, -18, -10,
    10, 1, -3, -1, 6, 7, 10, -11,
    29, -3, -4, 34, 19, -18, -5, 18,
    36, -13, 29, 28, 10, 52, 25, -4,
    -42, -6, -12, -29, 9, 59, 4, -18,
    20, -3, 25, 22, 10, -3, -11, 21,
    8, -27, -26, -18, 10, 23, 4, -3,
    12, 9, -27, -31, 54, -16, 18, 11,
    -5, -9, -16, -18, 2, 10, 13, 11,
    18, 8, 10, -25, -5, 30, 8, -5,
    40, -10, -31, 13, -5, 31, -6, 23,
    -16, -6, -23, -76, -23, -2, 10, -30,
    -10, -1, 38, -38, 8, 14, -29, -55,
    1, 18, 16, 15, -6, -1, -2, -2,
    -14, 2, 16, -17, 4, 3, 14, 16,
    -2, 4, -15, -8, -39, 31, 11, 9,
    18, -16, 13, 56, -19, -10, 52, -13,
    7, 3, -30, 51, -10, 17, -8, -1,
    -75, -15, -73, -28, 9, -10, -9, -27,
    26, 6, -23, 58, 40, 0, -13, 15,
    2, -8, -12, -35, -30, 37, -42, -4,
    -3, -5, 9, 6, 24, 4, -10, 19,
    13, 15, 2, -18, -9, -12, -6, -10,
    22, 29, -6, -7, 1, -28, 36, 36,
    16, -43, 0, 19, -22, -13, 15, -44,
    -19, -6, 34, -10, 0, -27, -6, -13,
    -14, -6, -4, 18, 22, 7, -43, -54,
    -2, -12, -28, -42, 23, -11, -4, -26,
    -18, 5, -4, -13, -20, 28, -29, 1,
    -28, -14, -11, 0, -1, 13, -24, -12,
    -5, 18, -18, 2, -15, -39, 5, 1,
    56, -3, 7, -25, -7, 20, -15, 18,
    31, 62, 11, 0, -11, -16, -9, 24,
    31, -41, -16, 4, 21, 32, 19, 32,
    24, -55, -6, 24, 2, 26, 10, -3,
    25, 6, 2, -21, 22, 39, 25, 2,
    37, -14, 21, 21, -15, -9, -15, -9,
    20, -25, 1, -6, 7, -2, -2, 2,
    29, -10, 7, -14, -1, -7, 6, -11,
    45, -35, 13, 14, -21, -3, -6, 13,
    -14, -4, -13, -13, -22, -39, 37, 42,
    -10, -11, 48, 14, -10, 17, 11, -9,
    15, -79, 53, 19, -40, -27, -7, -11,
    -12, 47, 27, -8, 37, -9, -18, 25,
    13, -19, -3, -24, 1, -8, -8, 36,
    15, 7, -4, -24, -58, 0, -9, -5,
    53, -22, 7, -6, 0, 31, -19, 2,
    -9, 4, -61, 11, 4, 7, 52, 27,
    4, 26, -16, -24, -14, -21, -20, 0,
    13, 3, -20, -14, 18, 17, -39, -9,
    -23, -48, 24, 6, 0, 22, 19, 7,
    31, 26, 3, -24, 4, -75, -28, -18,
    -54, 34, 8, 14, -4, -32, 19, -42,
    12, 5, -32, 4, 4, -5, 13, -19,
    22, -1, -34, -39, 37, -34, 8, 30,
    -7, 4, 10, 61, 11, -9, 9, 27,
    27, -12, -15, 8, 15, -14, -29, -11,
    -10, 32, -5, -14, 18, -4, 15, 12,
    14, 13, 14, 27, 23, 25, -20, -16,
    -8, -25, -38, 6, 28, 45, 34, 11,
    2, 36, -27, 1, -11, -2, 28, -28,
    -1, -7, -14, 9, 21, -44, -12, -9,
    27, -26, -11, -34, 32, -1, -20, 18,
    -9, -9, 18, -40, -39, -19, -24, 6,
    8, 18, -16, 37, -22, 32, -13, 12,
    1, 3, 11, -12, 22, 11, 0, 8,
    -29, 8, 4, -23, -14, -3, -24, 14,
    19, -6, -8, 17, 41, 1, 16, -12,
    39, 12, 36, -8, -8, -2, 1, -8,
    20, -14, -13, 1, -7, -2, -2, -10,
    7, -3, -52, -18, -17, -1, -5, 14,
    14, 37, -37, 9, -17, 7, -32, -14,
    29, 4, -27, 8, 12, -10, -9, -17,
    25, 20, 11, -15, -14, -6, 15, -5,
    -12, 19, -11, -10, 2, 11, -28, 11,
    34, -23, -28, 37, -5, -27, 38, 38,
    18, -3, 23, 13, -22, 15, -22, -45,
    18, -19, -4, -46, 18, 37, 20, 17,
    -33, 2, -35, 42, 22, 31, -14, 0,
    10, -16, -13, -3, 34, -5, -21, -6,
    34, 11, 52, 8, 26, 1, -31, -29,
    -13, 1, -17, -5, 5, 31, -37, -18,
    9, -11, -50, 9, 11, 8, 24, 2,
    31, -4, -82, 28, 26, -16, 0, -84,
    -26, -1, 0, 6, 12, 3, -28, 7,
    -6, 2, -3, 2, 1, 15, 9, 16,
    -26, 5, -23, -44, 10, 2, -24, 6,
    -7, 9, -12, -12, -39, 12, 27, 8,
    7, -12, -21, -14, 20, 5, -31, 50,
    -6, 6, -7, 3, -2, 1, 1, -13,
    -64, 29, 5, 28, -8, 21, -7, 1,
    -12, 49, -45, 3, 37, -42, -69, 29,
    -37, -41, -4, -5, -8, 16, 20, 39,
    3, -2, 5, -19, -4, -3, -15, -5,
    0, -16, 25, 30, -32, -2, -12, -11,
    -17, -6, -4, 35, 8, 46, 0, 28,
    43, -2, 25, -1, -7, -36, -17, -13,
    9, 4, -1, 9, -18, 0, 5, -35,
    5, -15, -12, 18, 32, 1, -42, 10,
    -18, 9, -13, 52, 23, -2, -4, -9,
    -6, 5, -28, -5, 9, -61, -22, 63,
    -24, -16, -21, 4, -9, -4, -26, 5,
    8, -12, -8, -29, -34, 16, -2, 4,
    -22, 25, -13, -2, -11, -20, -27, -10,
    6, 27, -46, 40, -19, 24, 19, -35,
    44, 16, 2, 1, -2, 20, -2, -3,
    15, 13, 12, 4, 12, -5, -20, 3,
    6, -6, 22, 8, -6, -42, -2, -42,
    -1, -42, -23, -10, 5, 36, 0, -7,
    -6, 9, 10, -19, 4, -3, -10, -26,
    17, 16, -32, -27, 4, 10, 4, 7,
    -14, 17, 10, 27, 10, 76, 9, -9,
    -23, 11, 31, 9, -10, 5, -29, 16,
    29, 3, 4, -22, -12, -12, 9, 12,
    36, -9, 66, 32, -6, 33, -7, 28,
    12, -30, -67, -27, -23, -8, 11, 4,
    5, 50, -7, 6, 18, 18, -3, -8,
    4, 9, -12, -18, -7, -19, -19, 5,
    -30, -3, -43, -38, 18, 8, -11, 64,
    -45, 45, -35, -26, -34, 3, -21, 36,
    39, 7, 19, -25, -58, -34, -12, -3,
    -10, -7, 12, -7, -19, 0, 5, -21,
    6, 37, -17, -28, 15, 1, -1, -33,
    -19, -7, -13, 27, -6, 18, -29, 16,
    -39, 77, 21, 72, -45, 13, 18, 21,
    8, 41, 9, 34, 13, 23, -7, -34,
    -16, 68, 8, 48, 42, 3, 10, 2,
    2, -25, 3, -13, 81, -9, -21, 7,
    -69, -7, -24, -14, 15, -4, -15, -8,
    -11, -12, 22, -1, 41, 5, -1, -7,
    -1, -23, -14, -16, 39, -15, 3, 44,
    29, -11, 6, -29, 39, 55, 36, -65,
    74, -17, 5, -63, 64, 48, 25, 11,
    -11, 15, -36, 28, -2, -7, -10, 56,
    25, 74, -1, -6, -15, 63, -10, 2,
    43, 23, 29, 5, 6, 17, 20, 10,
    -29, 0, 31, -19, 22, -14, -46, 33,
    3, 19, 26, -5, 3, 23, -4, 9,
    -6, -29, -6, 24, -12, 4, -13, 10,
    -12, 30, 30, 54, -29, 13, 15, -40,
    4, 39, -18, 31, 25, -34, -35, 33,
    -8, -26, 3, -30, -6, 1, 4, 3,
    4, 16, -39, 26, -23, -21, 2, 40,
    37, -13, 7, -13, -44, 8, -24, 20,
    -17, 22, -22, 34, 16, 4, 29, -36,
    -9, -16, -77, 127, -32, -20, 8, 8,
    -4, -4, -3, -7, 17, -5, -26, -81,
    -64, 3, -14, 10, 71, 13, -54, 33,
    40, 16, -46, 70, 15, 0, 21, 17,
    21, 16, -11, -3, 27, -19, -31, -98,
    -20, -6, -10, 6, 3, -17, -3, -18,
    22, 26, -19, 35, -23, -49, 4, 16,
    -26, 27, 3, -39, -36, -93, -49, -59,
    9, 76, 93, 31, 3, -54, -4, -12,
    9, -6, -3, 3, 26, 13, -33, -63,
    6, -35, -1, -21, 8, -29, 12, -32,
    -11, -11, -34, 1, -3, -5, -5, 10,
    -4, 21, 25, 5, -3, 0, -20, -14,
    -15, 21, 50, 31, 2, -6, 13, -14,
    -6, 6, 12, -30, 27, 3, -23, 20,
    -17, -3, -20, 53, -28, -38, -26, 24,
    70, -105, -15, 11, 19, 30, 28, -11,
    -7, -42, -14, 37, -4, 39, 16, 0,
    17, 30, 19, 6, 47, 53, 10, 19,
    -54, -32, -9, 49, -3, -7, -23, 9,
    -12, -12, 13, -44, -18, 29, 20, -1,
    -29, 5, 30, 19, -2, -32, 15, -20,
    24, 68, 40, 14, 16, 3, -30, 11,
    -33, 27, 38, 27, 6, -55, 11, 29,
    -37, 10, 42, -4, -14, -3, -21, -21,
    -16, -72, -2, -46, -103, -26, 6, -7,
    0, 11, 23, 23, 18, 68, -2, 56,
    -40, -22, 27, 66, -15, -33, 42, 35,
    9, -1, -11, -7, -82, -31, 4, 9,
    -30, -5, -32, -8, 29, 63, -33, 31,
    0, 43, 44, 9, -41, -16, 105, 4,
    -7, 9, -30, -20, -17, -33, -50, -30,
    -13, 13, 14, -24, 37, 92, -27, 4,
    -22, 55, 73, 13, 1, 32, 44, -20,
    -18, -41, 9, 17, -10, -1, -16, -7,
    11, 6, -5, -23, -80, -26, -16, 24,
    -5, -4, -25, -22, -9, 13, 25, -22,
    49, 65, 11, 39, 83, -80, 8, 31,
    47, -23, 15, -19, -16, 23, 9, 30,
    -63, 38, 35, 7, 16, 2, -21, -6,
    2, -6, -36, 21, 86, -30, 16, -10,
    -2, -31, -54, -4, 38, 62, -43, -23,
    -8, 86, 17, -12, 32, 54, 20, 13,
    -22, -107, 45, -56, -19, 9, 50, -34,
    13, 4, -3, -24, 17, 75, 4, 7,
    30, 13, 3, 21, 9, -10, -32, 38,
    -20, -5, -67, 14, -75, -20, -12, -6,
    20, 30, 8, -15, -42, -53, -93, -8,
    36, 10, 62, 6, 6, -16, -34, 38,
    30, 10, -41, 50, 14, -11, -10, 32,
    12, 17, -1, 42, 43, 19, 3, -16,
    34, 47, -17, -22, 8, 19, -15, -5,
    42, -50, 3, 0, 8, -5, -10, 24,
    58, 13, 34, -46, -12, -7, 10, 40,
    -13, -14, -48, -37, 63, -14, -50, 37,
    -54, 41, 67, -15, 19, -64, -23, -47,
    48, 64, -36, -1, -11, -22, 15, 14,
    11, 47, 59, 26, 15, -26, -30, 12,
    16, -83, 14, 30, 3, -24, -35, 47,
    -30, 117, -36, -36, -42, -7, -68, 2,
    8, 24, 36, -85, 23, -43, -19, 17,
    17, 8, 22, 49, 28, 42, 19, 2,
    -82, -47, 62, -48, 85, 9, -12, -45,
    -15, 3, -21, -73, 4, -8, 14, -19,
    6, -2, 44, 16, 11, 30, 21, 4,
    24, -33, 26, 36, -28, -6, 47, 27,
    -10, 23, 55, -20, 69, -20, -30, -99,
    -36, -15, 5, -5, -3, 65, 18, 19,
    -8, -34, 30, 16, -15, 8, 50, 14,
    39, -6, -57, -26, -6, -2, -48, -7,
    30, -4, 4, 2, -69, 29, 25, 24,
    43, 38, 57, 11, 5, 55, -1, 37,
    -4, -13, -22, 12, 7, -6, -42, -3,
    -31, 49, -42, -33, -7, -1, 33, 1,
    5, -8, 17, 16, 48, -50, -120, 22,
    -12, 16, 3, -3, 33, 38, 37, 27,
    -5, 5, 32, 5, 29, -13, 16, -19,
    4, -25, 6, -40, -46, 15, -20, -14,
    52, -36, 62, 32, -23, 43, 15, 25,
    -54, 19, 41, -46, 32, -43, 2, 66,
    -44, 8, 9, -49, -4, 4, -39, -26,
    8, -27, -36, -13, 27, 8, -60, -12,
    -49, 0, -62, -31, 14, 18, -3, 33,
    -2, -6, -6, 11, 31, -88, -5, 76,
    -10, -13, -10, -53, -6, -12, -98, 4,
    -13, -40, -25, -38, -43, 30, -6, 3,
    -13, 52, 11, 19, -24, -25, -59, 9,
    -21, -16, 15, 24, -22, 26, 19, -48,
    6, 20, 17, -9, -4, 32, 5, -23,
    -1, 39, 12, 11, 17, 5, -25, -13,
    -17, -52, 97, 9, -34, -73, 12, -3,
    -30, 29, -87, -12, 2, 82, 14, 81,
    24, -15, -5, -29, -1, 9, -1, -31,
    -41, -29, 0, -18, -4, 7, -10, -4,
    -52, 1, -4, 14, 33, 66, 12, -30,
    1, -35, -14, 6, 23, 10, 7, 8,
    -23, -36, -3, 26, 11, 11, -18, -4,
    -2, 37, -56, 77, 4, 65, -31, 13,
    37, -11, -3, 25, -63, -21, -3, 10,
    24, -7, -41, 25, 39, 21, 20, 32,
    -7, 30, -14, -37, -4, 43, -42, 15,
    -7, -5, 5, 27, 18, 15, 4, 63,
    27, 19, 2, -21, -58, 9, -19, 49,
    -64, -17, -19, -16, -21, -58, -18, 1,
    -34, -22, -27, -20, 6, 6, 14, -21,
    -3, -12, -20, 3, -13, -8, -17, -44,
    -2, 27, 2, 40, 23, 3, 20, -6,
    21, 55, -14, 17, -23, -19, -4, -9,
    8, -1, -8, -3, 6, 10, -6, 7,
    29, 8, 13, -7, -12, 9, -30, -11,
    36, 9, -31, -21, 4, 24, -2, -22,
    -16, -3, -5, -9, -4, -26, -11, -5,
    42, -9, -4, 6, 7, 21, 19, -29,
    -1, -4, 6, -4, -11, -38, 8, -11,
    14, -8, -20, -42, -42, -37, 51, -13,
    3, -22, 7, -9, 29, -13, -15, -7,
    10, -1, 3, 11, -4, 10, -4, -5,
    -15, -10, 9, 11, 3, -25, -14, -12,
    8, 14, -17, -16, 18, 24, -26, -11,
    7, -12, 10, -9, -6, -30, -12, -7,
    -9, 18, -14, -14, 15, 17, 49, 2,
    4, 11, -4, -8, 7, -51, 1, -10,
    -30, 18, -7, 25, -32, 19, 7, -13,
    5, -18, -2, -14, 19, 8, -30, -13,
    -4, -18, -14, 12, -34, 14, 1, 18,
    21, -9, 2, 30, 2, 19, -7, -12,
    6, 19, -19, -2, -37, -19, 29, 23,
    -3, 6, 8, -2, 20, 20, 14, -28,
    4, 10, -13, 4, 11, 3, 23, -31,
    32, -21, 1, -10, 48, 12, 20, 2,
    -13, 2, 35, 3, -2, -6, -17, -57,
    -1, 2, -14, 25, 7, -11, 15, -30,
    -12, -3, 21, 15, 18, 11, 23, -10,
    -6, 21, 11, 13, 5, -9, -10, 51,
    34, 18, 2, -9, -29, -14, -32, 7,
    0, -4, 8, -25, -4, 1, 8, -13,
    -12, 0, -11, -9, -1, 8, 6, -3,
    -4, -12, 11, 12, 7, 2, -2, -1,
    36, -4, 26, -3, 16, -16, 4, -12,
    -15, 2, 3, 16, 20, -11, 6, 4,
    4, -4, 5, 2, -11, 18, 24, 1,
    2, -3, 9, 22, -33, -8, -18, -4,
    -3, -13, 13, -5, -10, -6, -33, -16,
    -6, 44, -15, 8, -15, -40, -2, 9,
    -14, 34, 9, -37, 37, -21, 7, -3,
    -8, -14, -1, -2, 17, -17, -13, 7,
    -48, -23, -7, 1, -51, 17, -54, -11,
    -17, 11, 7, 4, 2, -8, -17, 24,
    -12, -9, -4, 29, 5, -10, 32, -31,
    5, 33, -28, 9, -6, 18, 4, 8,
    -17, 5, -15, 5, 8, 10, -26, -3,
    7, -18, 14, -10, 3, 30, -1, -2,
    4, -6, 8, -5, -26, 3, -10, -33,
    -49, 3, -1, -11, -5, -6, 17, -10,
    1, 7, -16, -10, 11, 20, 3, 18,
    18, 5, 8, 9, -3, 8, 13, 23,
    28, -6, 5, -7, 5, -1, 1, -3,
    11, 1, 9, 1, 0, 0, -13, 16,
    -2, 17, 7, 55, -19, -7, -30, -23,
    -3, -31, -10, 21, 5, -38, 19, 10,
    -21, -7, -1, 5, 20, -10, -33, -16,
    -9, 8, 30, 17, -36, 55, -4, 34,
    -25, 25, 55, -6, 10, 3, -47, -27,
    18, 25, -6, -14, -7, 7, 18, 23,
    1, 22, 3, 11, -16, -13, -12, 4,
    17, 12, 19, -9, 19, -5, 1, 38,
    -8, 37, -5, 6, 20, -42, -29, -5,
    -23, 43, 0, -10, 16, -6, 1, 21,
    -31, 32, 8, 9, 22, -20, 27, -19,
    6, 6, 10, 11, 8, 4, -2, 25,
    14, -12, 0, 6, 2, 47, 26, 7,
    -10, -33, 8, 10, 7, 16, 26, 5,
    -5, 25, -16, -8, 13, 21, -16, -6,
    -15, 8, -4, 16, -13, 6, -9, 1,
    14, 15, -29, 24, 12, 2, 0, -22,
    -21, -18, -2, 13, 8, 9, -26, -33,
    -3, 1, -12, 9, 25, 39, 16, 0,
    -4, 4, 18, -8, 0, 0, -4, 18,
    -2, -24, -29, -3, 13, -8, 21, -14,
    -18, -11, -14, 21, 16, 14, -9, -32,
    -1, -12, 1, -12, -20, 18, -7, 12,
    1, 37, 10, -39, 25, -22, 7, -5,
    -1, -16, 23, 8, 23, 38, 51, -48,
    -8, -12, 15, -13, 16, 25, 17, -24,
    -10, 28, -3, 23, 10, 10, -11, 25,
    -3, -6, -4, -2, -1, -12, 0, -9,
    23, 4, -11, 25, -3, -35, -12, -4,
    11, -1, -9, -26, 1, -8, 11, -15,
    19, -34, 4, -9, 14, -6, -21, -11,
    8, 4, -6, 4, -8, -5, 25, -5,
    23, 10, 20, 59, -65, -52, 21, -11,
    -7, 2, -21, 15, -13, 7, -23, -28,
    1, -46, 43, -14, 3, 0, 15, 42,
    -19, -10, 27, -13, 25, -8, -1, -19,
    10, 3, 66, 34, -18, 50, 50, 8,
    -3, -22, 7, -17, -9, 23, 3, -18,
    -3, -11, 2, 1, 0, 15, 1, -3,
    -17, -2, 4, -3, -4, 18, -8, 5,
    -6, 16, 7, -8, 36, 15, -67, -18,
    16, 21, 24, -29, -18, 23, 6, 4,
    2, 6, 3, -11, -6, -32, -20, 9,
    -20, 2, 11, 1, -38, 7, -4, 8,
    -40, 39, -17, -19, 12, -6, -59, 6,
    -18, 12, 26, -23, -4, 9, 5, 22,
    -1, 7, -13, -12, 8, 18, -29, -32,
    13, -41, -13, -12, 12, 0, 22, -23,
    65, 19, 16, -59, 36, -12, -23, 51,
    -6, 4, 12, 5, 6, -14, 11, 13,
    14, 0, 21, 0, -19, -3, -7, -20,
    -8, -15, 4, 24, 2, -26, 4, 17,
    19, 31, -9, -15, 5, -26, -14, 34,
    0, 9, 15, -19, -20, -8, -40, 6,
    13, 0, 22, -14, 4, 7, -14, -6,
    -9, 2, -16, 5, 8, 0, -21, 1,
    11, -23, 5, -16, 10, 5, -18, 19,
    12, 3, 3, 16, -24, 4, 5, -18,
    9, 9, 1, -3, -10, 12, -15, -12,
    24, 26, -8, -19, 14, -7, -7, -2,
    -17, 1, -8, 1, -24, -16, 8, -1,
    -20, 11, 17, 22, 4, -30, 5, -17,
    12, -6, 18, 4, -3, -36, 0, -23,
    14, 29, 9, -6, -5, -7, 1, 0,
    -7, -11, -25, 13, -54, 17, 23, 0,
    3, 5, -8, 4, -5, -2, -9, -2,
    11, -4, -14, 5, -16, -14, 17, 14,
    16, -33, -2, -15, 6, 3, 2, 20,
    14, -10, 41, -3, -5, 40, -4, -2,
    -10, -39, -29, -1, 9, -11, -19, 12,
    1, 4, 15, 3, -16, 23, -29, 8,
    14, -26, 14, -5, -7, -9, -7, -5,
    -32, 22, 38, -20, -10, 13, 25, -19,
    2, 15, 37, 4, 28, 10, -9, -9,
    -7, 17, -12, 6, 19, -29, -2, -5,
    9, -28, -27, 58, 18, 5, 6, -5,
    -41, -9, -6, -15, -7, 50, 36, 24,
    -11, 8, 3, -12, -38, -35, 9, -21,
    16, -9, 0, 15, -5, 37, -17, -2,
    -16, 9, -23, -26, -10, 28, 19, 3,
    25, -3, -33, -3, -31, 11, 10, -24,
    4, 17, -16, -18, 22, -7, -13, -6,
    28, -8, -4, -8, 12, 21, 18, -12,
    5, -15, 25, -10, -13, 7, 23, -7,
    18, -15, 1, 8, -8, 26, 7, -6,
    13, -2, 14, 51, -14, 32, 10, -38,
    12, -8, 13, 5, -4, 23, 19, -31,
    13, -2, -1, -22, -9, -5, 4, -16,
    5, -23, -12, -41, 0, 14, -3, -16,
    -6, -29, -22, -2, -11, -2, -5, -28,
    7, -2, -15, -21, 24, -12, 32, 5,
    -28, -37, 25, 34, -20, 24, 17, -3,
    4, -2, 17, 41, -20, 8, -2, 14,
    15, 28, -19, 26, 7, -11, -7, 3,
    -8, 9, -30, 4, -28, 6, 2, 13,
    12, -64, -10, 11, -9, -19, -46, 22,
    24, -11, -49, -10, -59, -44, -53, 9,
    -24, -8, -31, 18, 28, 5, -21, -22,
    15, -1, 15, 15, 35, 33, 1, -21,
    10, -14, 21, 37, 30, 11, 34, 23,
    -13, -10, 59, -10, -1, -11, 27, -42,
    -3, 14, 5, -2, 7, -7, -30, -30,
    -3, 1, 9, 29, 23, -1, 30, 14,
    -1, 26, 0, 34, 2, 15, -31, 39,
    48, -27, -51, 36, -44, -4, -30, -13,
    40, -8, -3, 1, 1, -9, 16, -3,
    6, 11, -3, -12, -24, -21, 5, -5,
    8, -5, 10, 2, 19, -4, -27, -7,
    24, -8, 10, 15, 22, 12, 35, -5,
    -1, -7, -24, 15, 2, 12, 32, 2,
    -1, -9, -4, -3, -12, 5, 7, -3,
    1, -10, 37, 10, -27, 5, 8, -7,
    -12, 28, -11, -39, 10, 1, -38, -7,
    -8, 1, 2, -5, -5, 5, 11, 29,
    2, 28, 5, -40, 16, -19, 0, 5,
    7, -1, -9, 4, -4, -11, 24, 23,
    22, 65, -2, -19, 0, 14, -33, 5,
    13, -8, 7, 28, 16, -33, -23, 28,
    3, 0, 8, 11, -44, -10, 14, -14,
    -29, 59, -50, -6, 5, -5, -4, 0,
    -38, 19, -52, -4, -8, -32, 12, 15,
    9, 5, 31, 0, -18, 7, 23, 32,
    12, -17, 11, -5, -1, -46, -55, -21,
    9, 9, -18, 13, 13, -10, -3, -50,
    6, -8, 0, -21, 19, 29, 10, -2,
    22, 4, 10, -16, 5, -34, -12, 2,
    6, -27, 13, 8, 25, -18, 31, 1,
    -37, 26, -36, -9, -5, 7, 11, -33,
    -23, 14, -2, -2, -23, 19, -40, 7,
    -33, -4, 6, 8, 13, 10, 11, 0,
    -26, -16, -4, 6, 18, 4, -12, -5,
    0, 74, 7, 29, 16, 42, 0, 16,
    28, 23, 35, -23, 11, 38, -41, -20,
    15, -21, 3, 8, -6, -8, 14, 32,
    5, 13, 0, 6, -8, 22, -15, -2,
    16, -10, 14, 56, 11, 14, 11, 38,
    -7, 7, -18, -22, -11, -12, -6, 6,
    -10, -14, 3, -35, 18, 17, -13, -17,
    -48, 46, 14, 4, -14, 25, 15, -50,
    -10, 24, 12, -26, 0, -11, -20, 1,
    30, 23, -33, -5, -12, 18, -20, 6,
    -28, 1, -13, 18, -7, 8, -14, 1,
    -5, 1, -16, 16, 9, 5, -21, -10,
    23, -19, -7, 46, 3, 15, -18, 21,
    -8, 1, -24, 10, -9, 32, -12, 14,
    -23, -24, -27, 16, 12, 25, -5, -5,
    15, 8, -35, -3, 16, 11, 31, 38,
    -20, 0, -63, 17, -23, -14, -2, 11,
    -85, -36, -29, -23, 22, 11, -33, -31,
    -28, 10, 8, -19, 19, 13, 27, -11,
    -15, 2, 16, -32, 7, 6, 26, 37,
    -15, 15, 16, 6, 1, -16, 34, 29,
    -12, -20, 10, 27, 25, 8, 33, -3,
    11, 0, 19, -18, 31, 26, -22, -23,
    -18, 32, 1, -2, -9, 33, 75, 26,
    -6, -15, -16, 10, -8, -3, -13, -8,
    31, 21, -48, 1, 14, -26, 1, -10,
    3, -2, -10, -19, 10, -9, 25, -6,
    4, -7, -4, -1, -1, -5, -57, -4,
    20, 7, -17, -26, -12, 11, -3, -24,
    43, 11, 43, 32, -5, -19, -10, -3,
    -20, 1, -19, 37, 21, 18, 7, -1,
    21, -36, 66, 7, 8, -16, 4, 6,
    -19, -9, 21, -7, 18, -14, 27, -7,
    23, -8, 12, -4, 17, 0, -11, 22,
    -17, 46, 0, -18, 6, -21, -25, -2,
    -3, 26, 21, 4, 13, 49, 21, 8,
    3, 0, -8, 0, 8, 3, 8, -2,
    -27, -10, -22, 6, 23, -3, -8, -1,
    -11, 2, 0, -1, -11, 15, -10, -17,
    -4, 0, -18, -25, -8, -9, 2, -6,
    -38, -46, -4, -10, 17, 3, 36, 1,
    30, 7, 7, -8, 12, 23, -11, -8,
    11, -33, 6, -7, -58, 2, -11, 27,
    -5, 10, -4, 6, -24, -27, -28, -22,
    -23, -1, 66, -47, -24, 19, 19, 12,
    10, 32, 4, 10, 29, 1, -44, -10,
    12, 24, -20, -5, 31, -10, 11, -6,
    -19, 7, 19, 15, -14, -2, -3, 5,
    -12, 9, 14, -26, -4, 15, 13, -11,
    34, -12, -16, -9, -8, 13, 36, 13,
    -7, -4, 10, -24, -13, 1, -24, -15,
    9, -11, 13, -11, 3, 7, 11, -25,
    -13, -29, -20, -10, 4, -27, -8, 16,
    9, 1, 15, 28, 1, -27, -7, 17,
    12, 17, 9, -10, -15, 5, 14, -14,
    6, 0, -16, 6, -10, 12, -20, 14,
    18, 23, -37, 28, 22, 6, -12, -7,
    4, -16, -32, -1, -27, 60, 2, -27,
    18, 8, 17, 15, 20, -16, -12, -39,
    7, 22, -22, 19, -28, -67, -17, 23,
    -28, 4, 58, -12, -3, -13, 50, 8,
    0, -19, -25, -25, -18, 11, 14, 24,
    55, 14, -15, -22, 15, 8, -8, -6,
    -6, -1, 9, 9, -3, -1, 25, 3,
    26, -47, -4, 3, 8, -11, 0, 11,
    23, -7, 1, 4, -7, 37, -58, -20,
    10, -13, 17, -3, 14, 5, 7, 4,
    6, -2, -5, 7, -36, 3, -24, 1,
    0, -16, 36, 14, -2, -23, 21, 13,
    48, 23, 4, -27, -15, -33, 23, -9,
    13, 5, -6, -17, -6, -1, 7, 5,
    2, 2, -31, 7, 9, -16, -30, 1,
    5, -46, 6, 4, -3, 52, 5, 3,
    -35, -6, -23, -63, -31, 20, 26, -28,
    49, 36, -1, -35, 9, -35, -9, 6,
    11, 9, 12, -15, 1, 58, 0, -17,
    -11, 19, 2, -9, 15, 69, -17, 21,
    24, 44, 4, -50, 26, -12, -7, 3,
    -6, 28, 1, -23, 56, -4, -19, 29,
    37, -8, 10, -20, -43, 7, -1, -82,
    -48, 32, 45, 52, 19, 31, 36, 34,
    -24, -25, -36, -30, 11, -9, 20, 33,
    24, 12, -42, -12, 13, 6, 38, -5,
    -5, 35, -76, 51, -19, 41, -41, -5,
    -1, -40, -14, 9, -11, 35, 1, -10,
    -1, -25, -35, -48, -19, -26, -3, 4,
    0, 23, 0, 5, -44, 38, -51, -50,
    23, -65, -8, -29, 57, -40, 65, 17,
    -23, 14, 24, 42, -9, 69, 9, 18,
    -43, -19, 19, 62, 35, 42, 19, -24,
    12, -27, -7, 20, -21, -53, -3, 40,
    1, -3, -25, -23, -19, 33, -2, 30,
    43, -16, -23, -6, 7, -18, -121, -8,
    53, -3, -59, 15, -31, -26, -23, -52,
    0, -16, -53, 33, -4, -15, 21, -54,
    7, -4, 6, 32, 50, 79, -7, -15,
    31, 7, 4, 18, 16, -23, 11, 28,
    30, -11, 49, 20, -63, 13, 40, 19,
    32, 29, 12, -34, 2, -37, 66, 12,
    -5, -19, -20, 103, 22, 30, 25, -3,
    -34, 17, 17, 31, -19, 42, 0, 20,
    37, -44, -45, -18, -12, 37, -23, -22,
    48, 23, 58, 4, -22, -19, -56, 13,
    -8, 19, 18, 14, -9, -36, 1, -22,
    12, 41, -6, 9, 25, -51, -42, 4,
    0, 12, -20, 13, 16, -28, 68, 0,
    2, 27, 15, -1, 8, -4, -12, -10,
    8, -33, 41, -5, -9, 84, 6, -1,
    24, 35, 37, -5, -4, 16, 27, -12,
    -26, 27, 2, -6, 43, 8, -3, 57,
    58, -26, 14, -4, -44, 37, 5, 77,
    8, 26, -11, -65, 16, 25, 2, -9,
    94, 4, 13, 4, 54, -15, -54, 77,
    89, 40, 21, -37, -37, -28, 24, -12,
    75, -9, -28, 26, -11, 12, 1, 23,
    13, -24, 7, 25, -65, -33, 17, -10,
    -44, 27, -87, 1, -22, -36, 8, 31,
    -47, 46, 1, -50, 5, -32, -33, -8,
    -5, -30, 69, 21, 45, 34, -54, -7,
    45, -8, 30, -23, -22, -75, -26, 10,
    -40, -12, -1, -55, 27, 11, 16, -89,
    -40, 18, -1, -63, -35, -9, 11, -15,
    -1, 68, -57, -9, 29, 22, 3, -8,
    -34, -59, 26, 37, 7, -6, 20, -23,
    69, -13, 0, -30, 29, 17, 13, -37,
    -46, -13, -46, 11, 42, 1, 28, -37,
    66, 38, -9, 71, -72, -57, -22, -34,
    -43, -7, -21, 19, -19, -62, 13, -8,
    64, 14, -2, -10, -8, -41, -22, 40,
    57, 26, -37, 13, -85, -44, 47, 36,
    22, -25, 23, -31, -9, 44, 20, 61,
    -1, -21, 30, 29, -3, 29, -13, -23,
    6, -5, 11, -12, 13, -16, -8, 48,
    -28, 21, 61, 5, -96, 29, -1, -81,
    30, -59, 2, 11, -14, 47, 28, 38,
    -55, 95, 4, 15, -9, 44, 31, -113,
    -17, 37, -55, -50, 18, -18, -12, -11,
    13, -10, 25, -31, 4, -27, -1, 54,
    -10, 1, -26, 7, -8, -26, 19, 6,
    -15, -38, 16, 38, 10, 19, -20, -6,
    34, 17, 39, 9, 2, 41, 1, 68,
    -1, -13, 6, 16, -9, 6, 18, -65,
    41, -6, 36, 18, 27, -26, -24, 72,
    24, 15, -24, 5, 19, 17, 10, 34,
    -61, 13, 7, 16, 5, 1, 49, 9,
    -37, 32, 3, -22, 62, 40, 13, -42,
    -10, -102, -9, -9, -13, 45, 0, -20,
    -31, -19, 18, -43, -19, 5, 18, 21,
    -35, 40, 38, -8, 28, 16, 42, 30,
    -19, -3, -58, -6, -92, 43, -57, 71,
    -49, -10, -18, -28, 59, -5, 65, 34,
    -18, 67, -7, 8, 21, 35, 45, 22,
    11, -10, 35, -12, -20, -3, 5, -2,
    66, 7, 5, -1, 18, 20, -14, 22,
    15, -6, 25, -41, 52, 44, 30, 35,
    1, 15, -7, -21, -21, -9, -32, 3,
    -1, -7, -30, -2, 4, 17, -5, -35,
    32, -1, 16, 47, -5, -12, -30, 17,
    26, 13, 47, 82, -22, 19, -17, 28,
    17, -45, 127, -15, 16, -27, -11, -13,
    -12, 14, -16, 21, 71, -24, -3, 2,
    32, 5, -56, -6, 32, -28, -65, 4,
    -44, 13, 8, -8, -30, 13, 70, -15,
    16, 14, 21, 13, -23, 71, -11, -23,
    17, -26, -40, -54, 26, 51, 1, 4,
    -1, -52, -7, -7, 16, 34, 88, -1,
    -2, -31, -72, 15, -16, 23, 9, 5,
    -1, 2, -72, -21, -33, -25, 11, -19,
    -83, -46, -50, 19, 42, 37, -17, 5,
    -37, -14, -108, -7, -8, 11, 2, 9,
    -16, -25, 34, -6, 40, -25, -5, 3,
    -20, 43, 21, 7, 20, -7, -39, -38,
    -63, -20, 14, -120, -61, 2, 10, 20,
    66, 12, 22, 10, -69, 19, 7, -50,
    5, 14, 9, 7, -5, -25, 11, 24,
    -15, -1, 30, 43, -17, 22, -28, -35,
    -7, 0, 9, -41, 6, 13, 15, -83,
    4, 38, 31, -60, -4, -24, 76, -13,
    -18, -18, -21, -25, -15, 27, 12, -9,
    7, -27, 6, -44, 1, -14, 3, -26,
    8, -52, -10, -11, -9, -20, -10, -8,
    4, -9, 21, 30, 27, -3, 17, 4,
    10, 15, -7, -10, -6, -18, -57, 13,
    17, -6, -4, 4, -9, 1, -35, -8,
    2, -16, -74, -32, 22, 27, -19, -30,
    -1, 17, -9, 40, -17, -12, 26, -13,
    71, -39, -23, -86, -8, 24, -17, 59,
    9, 29, -63, 27, 25, -116, 7, 45,
    63, -14, 86, -3, 47, -14, 54, -13,
    -2, 26, 20, -50, -36, 15, -31, 17,
    5, 4, -36, -10, -22, -7, 32, -17,
    -25, -6, 11, 28, -2, 8, -8, 3,
    -46, -65, 3, -29, 4, -24, 28, -21,
    35, -43, 51, 21, 13, 15, 99, -3,
    22, 34, -7, -24, -33, -16, -32, 7,
    -4, 15, -57, 0, -29, -13, -6, 1,
    -69, 1, 3, 15, 7, -51, 67, -3,
    26, 21, -3, -28, 50, -43, -62, -10,
    -42, 27, 10, 4, 39, 23, -33, 32,
    36, 17, -28, 3, 17, -21, -20, -10,
    13, -19, -1, -2, -19, -3, -4, -45,
    -4, -34, 0, -12, -16, 2, 5, -6,
    -15, -7, 1, 8, -19, -9, -10, -28,
    -24, -12, 12, -16, -48, -22, 10, 1,
    -28, 1, 0, 21, 2, 1, 19, 16,
    26, -10, -6, 11, -9, 6, -12, 5,
    -10, -10, 32, 8, -7, -3, 42, -12,
    4, 12, -11, -15, 41, -11, -1, 14,
    -39, -35, 12, -59, 26, 24, -13, 45,
    9, -21, 11, -17, -12, -9, 15, 3,
    7, -5, -8, -8, 28, 11, -7, -4,
    17, 26, -59, -23, 19, 32, -6, 45,
    -45, 0, -12, -39, 11, -31, -6, 15,
    -19, 4, -19, 10, 0, -3, -27, 0,
    -9, 3, -13, 16, -7, -16, 18, -13,
    -9, 41, -6, -24, 34, -19, 0, 6,
    -24, 0, 23, -29, -34, -17, 17, -37,
    16, 1, -5, -17, -3, 16, 13, -9,
    15, 34, -9, 9, -14, -9, 29, -14,
    -39, 36, 41, -1, 16, 14, 4, -2,
    18, -6, -33, 16, -5, -7, 3, 34,
    -14, -15, -10, -3, -12, -6, -8, 2,
    -19, 11, -5, 16, 63, 0, 13, 0,
    1, -16, -30, 10, -31, -25, 39, 8,
    21, -22, 30, -14, -8, -30, 12, 7,
    4, -19, -1, 4, 2, 15, 3, 1,
    -12, 27, -31, 6, 34, -25, 46, 21,
    52, -24, -18, -19, -20, -11, -36, 21,
    18, 15, 23, 6, -26, -16, 11, -7,
    4, -8, -1, -5, 21, -30, -6, -14,
    19, 19, 3, 4, -13, 21, 2, -30,
    -8, 9, -19, -13, 28, 26, 4, -56,
    7, 7, 41, 2, 29, 15, -17, 8,
    -2, -8, -17, 14, 5, 19, 1, 7,
    13, -4, -14, -6, -15, -9, -14, -4,
    6, 6, -43, -8, 11, -1, 15, 35,
    -1, -14, 14, -2, -15, 2, 11, 22,
    22, 3, -6, 10, 14, -3, -8, -18,
    -27, 4, -11, -2, -8, -17, -1, -3,
    6, 18, 54, -4, -41, -5, -11, -26,
    11, 9, 27, -56, 34, 14, -19, 12,
    -47, 28, 24, -14, 3, 1, -6, 8,
    -2, -9, 5, 9, 6, -32, 1, -18,
    -5, -2, -30, 8, -12, -24, -25, 40,
    18, 56, -53, -8, -5, -1, -7, -19,
    10, -4, -27, -15, -17, 4, 5, 3,
    30, 40, -11, 15, -18, -24, -43, -18,
    -19, 10, 3, 31, 32, 23, 40, 17,
    -1, -36, -12, 53, 28, 29, 7, 29,
    12, 21, 13, -17, 13, -16, -22, 3,
    35, 16, -29, 16, -15, 31, -4, -30,
    29, 15, 3, -18, 16, 29, 32, -8,
    23, -5, 26, 2, -14, 25, -17, 12,
    5, -18, 0, -11, -9, -20, -7, -12,
    -14, 10, 5, 8, -1, -10, 16, -7,
    3, -10, -30, -16, 46, -8, 6, 4,
    6, -14, 28, -39, 14, -19, 7, 0,
    -33, 2, 28, 7, 11, 20, -5, 4,
    -32, -6, 4, -20, -2, 15, 2, -9,
    -1, -27, -15, -13, -4, 22, -67, 37,
    -13, -31, 10, 18, -1, 30, -13, -1,
    -7, 5, 10, -12, -10, 4, 7, -15,
    8, -7, 24, 45, 7, -15, 29, 20,
    -41, 47, 18, -37, 7, -3, -5, -11,
    3, -30, -2, -19, -13, -2, 17, -8,
    -12, -6, -17, 14, 0, -4, 0, 6,
    3, -18, 19, -32, -21, 29, -59, -23,
    13, 64, -26, 34, -31, 57, 50, -38,
    -7, 8, -34, 0, 5, 9, -30, -2,
    -33, 2, 4, 28, -10, 0, -9, -4,
    15, 14, -7, 35, 4, 0, 33, 10,
    22, 13, -1, 14, 39, 14, 17, -15,
    9, -2, -17, 10, -23, -1, 46, 2,
    -31, -12, 6, 9, 5, 13, 2, 2,
    17, -29, 12, 5, 30, 10, 11, 28,
    -16, -26, 37, -31, -8, -18, -24, 21,
    2, -14, 17, -11, 5, 7, 21, 21,
    -17, 17, 13, 7, -17, -21, -3, -21,
    -6, -9, -34, 8, 16, -38, -8, 2,
    13, -1, -24, -10, 24, 23, -36, 22,
    5, -8, -24, 6, -13, 24, 39, -7,
    20, -8, 16, 1, 7, -17, 26, -8,
    -20, -14, 24, 4, -3, -13, -43, 17,
    24, -37, 10, 5, -8, 1, 2, -64,
    20, 12, 61, 20, -5, -6, -21, -12,
    7, 11, 13, -10, -24, 3, 2, 3,
    -4, 10, -15, 8, 6, 25, -19, 33,
    -9, -83, -26, 32, -38, -14, 17, 0,
    -30, -15, 43, 12, 29, 21, -30, 13,
    -8, 6, 0, 17, 4, -24, 18, -14,
    15, -5, -2, -11, 6, 0, -38, -19,
    -43, -6, 15, 5, 8, 19, -31, -8,
    11, -29, -37, 9, -16, -4, 23, -19,
    -18, -7, 23, -12, -1, 2, -2, 6,
    -45, 0, 29, 10, -11, -36, -8, 28,
    8, 19, 35, 10, -42, 17, -10, 77,
    -6, 56, 8, 4, 18, -1, -32, 11,
    2, -21, -3, 6, -2, 2, 14, -4,
    4, 2, 39, 26, 38, 15, -13, 18,
    -23, -10, -4, -36, 22, -12, 37, -32,
    1, 4, 15, 2, 8, -22, 0, 31,
    1, 28, -12, -38, 28, 6, 0, 7,
    10, 23, 49, -24, -6, -14, -12, -51,
    32, 0, -21, -29, 15, 23, 14, -24,
    -2, -2, -21, 29, -13, -6, -18, -37,
    10, 6, 21, -13, -9, 10, 5, -13,
    2, -5, -6, -11, -7, -25, 1, 9,
    -12, 8, 20, 31, -8, -41, -25, 9,
    -15, 30, 20, 18, 0, 41, 55, -10,
    17, -1, 9, 27, 1, -4, 6, 11,
    2, 20, -10, -22, -9, 34, 11, 6,
    40, -12, -5, -23, 33, 42, 29, 38,
    5, 14, 5, -12, -9, -34, -10, -17,
    8, 24, -8, 17, 1, 24, -6, -12,
    -24, 20, -12, 7, 10, 8, 9, 39,
    26, 47, 30, -30, 19, -13, -4, -29,
    -49, -19, -4, -26, -12, -9, 0, 16,
    -12, -20, -14, -9, -5, -3, 13, 0,
    -16, 7, 6, -7, -29, 2, -20, -27,
    -8, 18, -35, -81, 15, 13, 15, -20,
    -17, 49, 6, 28, -12, -42, -27, 3,
    -10, -8, 27, -5, 10, 4, 10, -1,
    5, 3, 38, 4, 6, -25, -7, 11,
    -24, -13, -18, -40, -11, -25, -30, -7,
    28, -34, 30, 7, -5, -10, -20, -10,
    7, 8, 21, -19, -15, 6, 2, 5,
    -55, 0, 2, 15, 4, -33, 23, -2,
    -23, 1, -31, 29, -25, -17, -10, 15,
    -9, -35, 22, 8, -10, 21, -22, -26,
    -2, -8, -7, -18, -17, -4, 10, 8,
    13, -12, 6, -29, 3, 0, 9, -21,
    5, 42, -6, -8, -33, -51, 7, -45,
    -50, -1, 5, 15, -26, 2, -15, -2,
    -13, -18, -14, 11, -10, 17, 2, -5,
    14, 4, -4, 14, -32, -5, 48, 14,
    -24, -13, -15, -1, 3, 15, -4, -21,
    -15, 7, 49, -43, 3, -18, 55, 42,
    24, 13, -5, 5, 16, -15, -11, -6,
    7, 33, 31, 9, 36, 44, 14, -21,
    -25, -34, 19, -23, 61, 17, -63, 41,
    -46, -19, -43, -45, -8, -28, -27, 3,
    -8, -8, 10, -5, -19, -12, -17, -2,
    -11, -12, -31, 31, -15, -23, -3, 0,
    13, 14, 8, -6, 10, -48, -53, -15,
    17, 26, 9, -42, -4, -54, 1, -31,
    -32, -13, -1, 9, 5, -8, 14, -16,
    42, -7, -26, -33, 20, -37, 32, 16,
    8, -11, 10, -47, 10, 33, -21, 47,
    5, 12, 28, -57, -33, -53, 7, 36,
    33, 27, -24, -12, 13, 12, 2, 11,
    -54, 37, 71, 30, 53, -24, 20, -29,
    12, -60, -42, -22, -27, 4, 11, 8,
    -17, -42, 21, 4, 38, -10, -22, 5,
    -7, -1, 33, 7, -4, 18, 25, 24,
    -25, 16, -46, -5, 19, -21, 3, 26,
    14, -24, -24, -11, 38, 14, 1, 9,
    4, -31, -14, -12, -3, -19, 9, -21,
    0, -7, 13, -6, 39, 3, -17, 8,
    -9, -20, -18, -19, -39, 27, -15, -36,
    9, -20, -25, -9, 49, 51, 16, -19,
    8, 12, 42, -32, 27, -5, -93, -8,
    -1, -17, 1, 6, -3, 12, -1, 8,
    -8, -15, 13, -3, -15, 10, -20, 2,
    -31, 35, -18, -57, -20, 39, -38, 49,
    -2, -12, -12, -11, 0, -19, -6, 38,
    13, 23, 11, 9, 21, 1, -8, 9,
    -21, 24, 1, -17, -16, -25, 23, 14,
    46, -8, 37, 11, 13, -61, -12, -4,
    25, 27, 50, -56, 12, 31, -6, 1,
    -29, -7, 2, -5, 0, 5, 13, 5,
    24, -31, 19, 7, 11, 10, 34, -23,
    -20, 25, 25, -1, 27, 10, -26, 15,
    35, 17, -26, -11, -13, 53, -7, -31,
    -33, -49, 2, -13, -18, -16, -1, -5,
    31, 18, 32, -31, -12, -21, -32, -36,
    -6, -24, -15, -7, -9, -24, 44, 36,
    38, 13, 41, -14, 9, 60, -36, 17,
    5, -13, 3, -10, -2, 8, -10, 4,
    -31, 5, 10, 51, -17, 6, 1, 6,
    28, 31, -8, 33, 25, -4, 15, 1,
    48, 0, -27, -35, -10, 57, -7, 25,
    -14, -2, -12, -31, -9, -8, -37, -22,
    58, 15, 23, 10, -6, -15, -13, -11,
    11, -13, 22, 32, 5, 8, 13, -21,
    34, -21, -21, 11, 11, -8, 16, 6,
    -20, -13, 1, -25, 30, 16, -8, -10,
    -74, -55, 9, -3, 5, -2, -10, -26,
    -37, -21, -10, -59, 0, 41, 7, -2,
    -22, -4, -11, 41, 11, -23, -14, 7,
    1, 16, 17, -26, -7, -13, 11, 19,
    5, -22, 21, -11, -11, -10, 9, -7,
    13, 25, 1, -31, 23, -54, -5, -15,
    3, -40, -51, 13, -7, 17, -43, -21,
    -5, 0, -6, -36, -5, -16, 8, 13,
    4, -22, 4, 28, -11, -5, -24, 0,
    10, 52, 25, -12, 1, 5, -30, 14,
    48, 57, -29, -6, -9, 27, -30, -43,
    16, 5, 16, 13, 13, 21, 3, 6,
    -49, 9, -30, -46, 0, -7, 0, -5,
    42, 3, 0, -27, 24, 1, 28, -6,
    -35, 7, 15, -19, -26, -22, 43, -9,
    -9, 0, -21, 10, -22, -17, 2, -8,
    -7, -18, 24, -1, -5, 54, -26, 18,
    3, 7, 4, -33, -29, 2, -1, 18,
    -12, -6, 3, -30, 49, -35, 17, 20,
    -14, 32, 18, 21, 9, -19, 1, -18,
    -7, 29, -8, -9, -21, -4, -25, -29,
    31, -12, 15, 70, 38, 16, -31, -28,
    14, -1, 28, 20, -4, -40, 3, 18,
    6, 2, 38, -5, 0, 0, -2, -21,
    -25, -13, -15, -4, 6, 10, 17, -4,
    18, 2, 37, 20, 32, -8, -6, -25,
    12, 23, 13, 20, 3, 13, 24, -16,
    -25, 16, -2, 14, -10, 6, -1, 10,
    -15, -20, 31, -11, 7, 4, -17, -13,
    41, -69, 9, -38, -14, -22, -9, 58,
    -5, -43, -60, 40, -36, -37, 14, 40,
    24, 21, 1, 0, 14, -10, 0, -9,
    7, -14, -36, -1, -33, -2, -44, 30,
    0, -38, 73, -4, -7, -17, -36, 14,
    32, -26, 4, 30, -21, -19, -9, -21,
    19, -1, -3, -13, -15, -9, 8, 11,
    -37, -11, -5, 29, 47, -18, -6, -8,
    5, 33, -14, -4, -12, -3, -38, 5,
    -8, 57, 2, -10, -12, -11, -18, 22,
    -58, -24, -33, 2, -5, 9, 5, -9,
    -1, -2, -7, 21, -26, 12, -24, 9,
    29, -7, 35, -48, -30, 31, -11, -8,
    14, -14, 10, -8, 3, -24, -14, -4,
    8, 12, 1, -31, 37, 4, 3, 19,
    57, 5, 1, 9, -18, -20, 1, -24,
    -13, 12, 5, -17, 33, 20, 22, -21,
    26, -17, 13, 52, -10, 19, -42, 69,
    -6, -7, 5, -27, 2, 5, 9, 18,
    -6, -30, -24, 35, -7, 1, -12, 2,
    -26, -35, -36, 12, 0, 23, -26, -13,
    -4, -9, -4, -3, -6, -2, 16, -21,
    0, -7, -17, 39, 11, 15, 28, 3,
    -10, 60, -4, -20, -3, 21, 17, -10,
    43, 10, -8, 8, 45, 15, 40, 19,
    8, 52, -22, -27, 3, 56, 26, -59,
    3, -59, -20, 4, 20, 41, -7, 5,
    -7, -9, 9, -24, 27, 31, -11, -1,
    8, -28, -3, 16, 18, 41, 17, -8,
    23, 30, 35, -4, 1, -1, -9, 4,
    -2, -8, 6, -8, 0, 2, -9, -9,
    -1, 7, -44, 20, -41, -4, -15, 9,
    3, 6, -19, -30, -24, -22, -10, -42,
    -26, 6, -3, 11, 20, -17, -21, 5,
    -15, 2, 57, 5, 14, -2, -16, -13,
    -10, 10, 27, 0, 25, -40, -39, 16,
    -4, 55, -8, 31, 16, -38, 15, -53,
    -35, -17, 30, -12, 7, 20, -29, -5,
    -40, -11, -17, -7, -29, -7, 2, 5,
    -1, -5, -17, 6, 4, -7, 40, -3,
    23, 4, 10, 43, 51, -39, 35, -20,
    -59, 11, 9, 56, 3, 64, -32, -29,
    -37, 5, -25, -11, 33, -24, -9, -64,
    1, 21, -7, -2, 15, 69, 21, 41,
    51, 7, -5, -11, 51, -25, 40, -25,
    39, -1, -43, 23, 52, 25, -38, -8,
    7, -27, -19, 11, -2, 21, 27, 2,
    -7, 26, -13, 11, -14, -6, -1, -6,
    -1, 28, -4, 1, -20, 15, 61, 20,
    27, 49, 14, -39, 27, -30, 14, -46,
    10, -12, 2, 42, -9, -25, -16, 13,
    -16, -2, -13, -56, 56, 73, -26, 5,
    2, 18, -19, 27, -12, -23, -65, 37,
    -3, -22, -41, -15, -34, 13, -52, 16,
    32, 16, 41, 10, -21, -22, -13, 20,
    -23, -9, -30, -6, 27, -36, -2, -5,
    14, -26, -27, -22, -43, -9, -24, -43,
    -4, 43, 51, 46, -5, -53, 19, 9,
    -91, -34, -8, 12, -8, -47, 34, 29,
    17, -96, 5, -21, 19, -30, 13, 16,
    -26, -36, 76, -11, -34, -95, -7, -26,
    56, 4, -14, -37, -65, -26, 34, 30,
    27, 2, -19, -14, 23, -17, -33, -25,
    24, 44, 43, 53, 63, 51, 36, -53,
    63, 35, -65, 14, 26, 38, 6, -11,
    71, -69, 40, 25, 2, -31, 32, 10,
    66, 16, 38, -39, -28, 9, 29, 17,
    -83, 4, -3, 24, 38, -17, 13, -5,
    -5, -11, 66, -19, -21, 72, 40, 7,
    9, -64, 13, 32, 0, -127, 4, 14,
    21, -12, 11, 22, 23, 8, -19, 26,
    -81, -10, -39, -41, -15, -9, -15, -33,
    -11, -1, -38, 1, 41, 76, 4, -8,
    -17, 3, 54, -19, 23, -14, -40, -15,
    -8, -9, 1, 16, 4, -4, 33, 5,
    -9, 24, 0, -3, -18, 31, -28, 11,
    -50, 12, 62, -127, 15, 41, 16, 87,
    -87, -28, 0, -1, -19, 50, -1, 34,
    18, 31, -8, 21, 8, 10, 40, 17,
    -36, -3, 29, -12, -26, -45, -5, -9,
    -64, -6, 68, 7, 29, 1, -27, 29,
    -7, 39, -33, -15, 48, 15, -23, -4,
    21, -7, -19, -13, 35, -2, 17, 21,
    6, 54, -9, -13, -41, 15, 7, -17,
    30, 8, -5, 0, -27, -8, -8, 17,
    57, 9, -5, -26, -3, 18, 1, -66,
    -35, -26, -10, 24, -15, 44, -26, -8,
    -36, -6, -50, -37, -24, -38, -52, -43,
    16, 24, 69, -25, -28, 49, -36, 13,
    16, 21, 97, -16, -78, -4, 18, -28,
    16, 29, 1, -27, -9, -12, -6, -2,
    58, 14, -20, 83, -9, 15, 29, -5,
    58, 12, 15, 29, 90, -24, -48, 16,
    23, -42, 50, 63, -31, -4, 19, 57,
    -35, 20, -27, -62, -13, 3, -11, -56,
    -2, -9, -15, 58, 9, -17, 57, 40,
    12, -55, -22, 11, -26, 14, 66, 18,
    -24, -79, -71, 63, -40, -7, -1, 42,
    2, -44, 33, -11, -5, 18, 19, -18,
    -63, -12, 12, 5, 23, -28, -15, -32,
    -10, -33, 4, 23, 29, 29, 33, -14,
    -37, 13, 12, -35, 8, 11, 49, -5,
    10, 1, 39, 14, 2, 19, 19, -41,
    1, -21, 13, 45, 9, -12, 12, 24,
    -26, 39, -13, -3, 17, -14, 15, -9,
    -11, -71, 35, -17, -24, 20, 16, 20,
    -7, 19, -7, -11, -3, -9, -5, -7,
    8, -44, -1, -21, -25, -16, -7, -7,
    -30, 17, -29, 13, 28, -29, -31, 50,
    -47, 62, 9, -54, -54, 23, -47, 22,
    5, -14, -21, 8, 27, -19, 6, -7,
    -2, -6, 6, -17, -5, 21, 40, 17,
    -51, 23, -49, -10, -24, -23, 38, -51,
    114, -29, 22, 6, 71, -6, 13, 2,
    -26, -21, -17, -12, 12, -35, 14, 1,
    -32, -33, 11, 18, -21, 9, -27, 21,
    7, 11, 19, -33, -43, 4, -67, 9,
    -26, 46, -10, -28, 9, -5, 58, 13,
    8, 15, 10, -3, 12, -47, -30, -4,
    21, 19, 34, 10, 44, -16, 40, -63,
    61, -17, 4, 17, 53, -12, -47, 18,
    -12, 11, 97, 14, -20, -37, 2, 7,
    7, 33, -6, 9, 10, 30, 4, 0,
    -9, -10, -48, 24, -44, 29, 5, 1,
    21, 30, -42, 67, 19, 21, -26, -57,
    4, 8, 23, -36, -24, 14, -27, -25,
    17, 6, 18, 20, 23, 12, 32, 13,
    11, -25, 21, 10, 9, 6, 4, 4,
    -20, -72, 56, -7, 27, 2, 29, -20,
    40, 0, -53, -55, -26, 17, 16, 54,
    -8, 37, -49, -17, 30, -18, 4, -40,
    20, -26, 4, -32, -52, -10, 3, 18,
    -12, -16, 32, 27, -8, -70, 37, 51,
    62, -20, 74, 55, 34, -21, 12, -1,
    26, -17, -18, -7, 34, 10, -16, 11,
    -49, -35, 14, 25, 44, 1, -22, 24,
    89, 5, 27, 16, -50, -77, 1, 2,
    80, -66, -36, -30, -41, -27, -16, -1,
    -35, -18, -16, -12, -11, 44, 21, -21,
    37, 7, 19, 17, 24, 36, -37, 13,
    -17, 43, -28, -99, -9, 25, -14, 11,
    12, 76, 23, 40, -11, -27, 62, 17,
    2, -6, 54, -31, -8, -121, 25, -11,
    -2, 0, -1, -9, -29, -8, -10, 12,
    30, -36, -31, 22, 38, 33, -26, -39,
    11, -46, 37, -66, -24, 16, 5, -6,
    8, -11, -11, -14, 2, 2, -3, -28,
    11, -29, -21, 66, 11, -18, 1, -11,
    -42, -45, -7, 56, 22, 29, 30, -43,
    3, -5, 49, -42, -16, -16, 10, 11,
    3, 14, -26, 24, 5, 8, -15, -17,
    -8, 16, -20, 38, -7, -6, 25, -64,
    68, 16, -14, -20, 16, 3, -15, -2,
    -81, 29, -42, -11, 7, 25, 28, -2,
    -4, -63, -3, -11, 108, 9, 3, -17,
    -18, 9, -10, 16, 38, 42, -9, -3,
    -19, 43, 34, 30, -5, -3, 34, -60,
    58, 23, 20, -1, 20, 12, -5, -19,
    -16, -9, 2, -11, 31, 10, -12, -3,
    -51, -27, 0, 17, -21, -23, -12, 31,
    -22, 64, 9, -5, -55, -72, -18, -2,
    10, 15, 39, -25, 4, -25, -20, -8,
    3, 15, 112, 17, -109, 8, 12, 2,
    -22, -10, -52, 37, 40, -40, -64, -9,
    12, 41, -26, 72, 7, -26, 23, -35,
    -38, -13, 21, 5, -9, 21, 37, 12,
    -44, -2, 22, -10, -8, -16, 18, 8,
    46, -38, 18, 22, 15, -37, 16, 5,
    -91, -11, -17, 45, -7, -18, 12, 2,
    9, -7, 60, 0, 7, 2, 1, -8,
    0, -14, 22, -10, 10, -1, 11, -6,
    -13, 6, 12, -9, -7, -2, 19, -7,
    -20, 25, 18, 12, 5, 11, -3, 1,
    2, -3, 1, -1, 6, 4, -1, 11,
    21, -8, -8, -17, -29, 6, -5, 29,
    -2, 13, -5, -9, 4, 2, 1, -5,
    -19, -7, 1, 11, 5, -6, 30, 15,
    -3, -8, 13, 36, -16, 1, -13, -14,
    -21, -20, 12, 35, 11, 1, -6, -13,
    -7, -1, -17, 3, -3, 2, 7, -19,
    -25, -26, -22, 15, 12, -2, -30, -19,
    -11, 23, -6, -44, -8, -26, -6, 7,
    -4, -4, 7, 1, -6, -13, 12, -5,
    -5, 7, 8, 9, -7, 17, -3, -20,
    4, 24, 3, -1, -9, -18, 15, 8,
    -22, 25, 0, -15, -6, 12, 4, -14,
    5, -28, 34, -7, -14, -17, -10, 6,
    -5, -12, 3, -10, 20, 1, 1, 27,
    11, 18, 18, 30, 11, 3, 10, -8,
    2, 12, -18, -16, -5, -2, 0, -11,
    -8, -2, -8, -23, -7, -5, 15, 13,
    -4, -2, -3, 17, -10, 11, -23, -16,
    -5, -16, 11, 17, -1, 19, -16, 3,
    26, 5, 11, -9, -6, -3, 7, -51,
    -19, -1, 10, -9, 5, -1, 6, 9,
    5, 20, 2, -4, -10, 0, 2, -1,
    -12, 5, -10, -5, 1, -7, -2, 5,
    4, -19, 18, -21, -4, 13, 0, 9,
    36, 8, 9, 11, -19, -2, -2, 0,
    13, -2, 9, 19, -7, 3, 2, 8,
    13, 7, -4, 11, -5, 14, -24, -25,
    -12, -5, 29, 48, -11, -2, 47, -20,
    12, 5, -4, 17, -17, -19, 3, 25,
    3, 17, -1, -11, 20, 1, 2, 5,
    1, -18, 5, 10, 9, -18, -15, -22,
    26, 40, 29, 10, 12, -14, 8, -14,
    -12, -22, -9, -7, -15, -15, -6, 12,
    28, 24, -5, 0, 18, -7, -11, -1,
    -4, 36, 7, -25, -18, 12, 11, 25,
    2, 6, -4, -12, 1, -50, 0, 3,
    12, 14, -15, -8, 22, -12, 0, -16,
    -1, 8, 6, -17, 34, -19, 18, 0,
    18, -10, -7, -4, 24, 30, 37, -23,
    8, -14, -10, 8, 12, -3, -28, -3,
    -37, -7, 3, 8, 2, 10, 5, -4,
    -6, 2, 13, 3, 6, 22, 12, 13,
    -1, 16, 19, 8, 7, -1, 1, -13,
    -34, -1, -7, 13, 22, 0, -14, 2,
    -13, -12, 3, 12, 9, 15, 20, 17,
    7, 3, -28, -21, 0, -20, -35, -23,
    -6, 5, 1, -29, 1, 14, -16, -14,
    23, -17, 9, 3, 6, 7, -24, -5,
    37, 5, -3, 12, 8, -12, -14, 4,
    -7, 6, 21, 0, 14, 13, 10, 10,
    50, 17, -6, 22, -24, -28, -3, -14,
    5, -23, 27, -18, -4, -6, 24, -9,
    10, 16, -36, -16, 1, 38, -2, 6,
    3, 10, 5, 14, 14, 9, 1, 4,
    18, 41, -17, 7, -11, -25, -24, 10,
    -8, 88, 3, -15, 28, 22, 4, -30,
    7, -18, -1, -18, 3, -4, -24, 36,
    2, 6, -9, -2, -11, -36, 17, -14,
    13, -10, -37, 22, -4, 0, 3, -5,
    16, -16, 5, 31, -6, 47, 8, 15,
    -3, -37, 39, -8, 0, -10, 9, 18,
    4, 6, 10, 14, 9, -9, -6, 3,
    2, 4, 63, 12, -9, 11, 21, 6,
    10, 0, -19, -32, 2, -9, -7, 8,
    -14, 14, 16, -12, -1, 12, 3, -28,
    8, 8, -13, 3, -14, 13, -11, -6,
    10, 16, -19, 2, 11, 12, -3, -13,
    19, 8, 12, -54, -8, -8, 6, -6,
    17, -22, -7, -4, 19, 13, 1, 6,
    10, 6, 12, 2, -1, 8, 36, -2,
    -4, -24, 9, -10, 15, -15, 33, 10,
    11, -1, 16, -1, -6, 18, -9, -11,
    -9, 33, 5, 7, 1, -22, 28, 0,
    -12, -11, 8, 6, 11, 17, -4, -25,
    -16, -29, 10, 8, 25, -11, 1, -9,
    23, 15, 4, -52, 0, -42, 33, 15,
    -11, -3, 26, -32, -27, 7, -38, 6,
    12, -13, -8, -3, 17, -1, 2, 8,
    -4, -26, -39, -20, -16, 0, -6, 4,
    12, -53, 23, 31, 12, -18, 41, -20,
    -3, 13, 9, -47, 24, 19, 0, 7,
    -4, 4, -1, -2, -24, 20, 13, 8,
    15, -23, 20, -18, 1, -8, -6, -21,
    -48, 22, 13, 6, 8, -2, -14, 10,
    -13, -40, 1, 20, 32, 0, -24, -11,
    8, -5, 26, -2, 11, -12, 30, -15,
    -10, -15, 11, 6, -10, 13, -13, 11,
    -9, -17, -41, -6, 2, 1, -11, 20,
    5, -1, -29, 32, 6, -8, -10, 12,
    -13, -11, 4, -2, -7, -19, -7, -12,
    -2, 3, -26, 18, 11, 9, -14, 14,
    -33, 28, -14, -36, -8, -5, 28, -13,
    7, -20, 3, 2, 10, -4, 16, -7,
    -4, 8, -5, -14, -28, -8, -21, 1,
    -9, -8, 24, -18, -10, -5, 37, 15,
    27, -11, 27, -16, 30, 0, 13, 12,
    -2, -16, -24, -2, 6, -9, 12, -8,
    9, 2, -10, -14, 4, -1, -20, 6,
    13, -17, 34, -8, -7, 2, 7, -8,
    -4, 18, -28, -1, 11, 4, -22, 2,
    6, -11, -1, -41, 2, -7, -12, -25,
    9, 4, -4, 3, 3, 29, 16, 5,
    -8, 23, -22, -11, -3, -1, -13, 1,
    18, -17, 4, -23, -5, 7, 0, -25,
    18, 14, 10, 16, -7, -6, 17, -4,
    3, -3, -14, -16, 30, -12, -1, 32,
    6, -7, 20, -18, -26, -16, -20, -13,
    -3, 23, -1, -22, -11, 0, 26, 2,
    -17, -18, 0, -17, -24, 60, -17, 30,
    14, -40, 16, 6, 20, -31, 19, -29,
    -5, 7, 12, 11, 7, 9, 12, 0,
    -11, -32, -18, -42, -5, 15, -6, -3,
    4, -8, 18, 20, 10, -2, 10, -22,
    11, 11, 28, -6, 21, -10, -6, 3,
    -1, 9, 29, 6, -11, 14, 15, -4,
    -9, -7, 14, -8, 1, 28, 17, 15,
    18, -7, -9, 2, -4, -4, -5, 14,
    5, -5, 14, -2, 10, 18, 11, -13,
    7, 25, 35, -14, -8, -13, 5, -2,
    -58, 2, -14, -34, -33, -10, 11, 20,
    15, -6, 18, 10, 2, 9, -23, -17,
    -4, -4, -12, -2, 3, 28, -2, -9,
    -26, 10, -29, 0, -22, 16, -6, -2,
    -10, -17, 45, 84, -15, -3, 0, -2,
    -25, -8, 16, 23, 3, -8, 13, 6,
    -22, -18, -1, -5, 25, -7, -1, 0,
    -39, 52, 2, 7, 21, 15, -8, 20,
    -17, -3, -16, 3, -14, -8, -8, 1,
    -54, 2, -35, -2, -10, 13, -8, -2,
    3, 19, 2, -29, 30, 18, 30, -10,
    -8, -2, -19, 18, -5, -2, 18, 37,
    -1, -17, 10, -6, 27, 3, -22, -14,
    -4, -1, 12, -28, -4, 4, 14, 5,
    -25, -15, -32, 25, -19, -2, -5, 21,
    -13, -20, -9, -7, -4, 15, -11, -24,
    -14, -11, 5, -38, 1, -2, -7, 1,
    -6, 0, -9, -12, -6, 3, 41, -7,
    2, 15, 8, 9, -30, -12, -27, -19,
    3, 12, 14, 3, -5, 6, 5, -27,
    -23, -15, 6, -76, -4, 13, 2, 16,
    43, -17, -5, 7, -29, -12, 1, -4,
    -11, 14, 0, -20, -51, -9, 9, -6,
    13, 16, 13, 2, -23, 4, -11, -3,
    38, -3, -43, -24, 13, 4, -7, -9,
    -19, -34, 24, -13, 11, -19, -12, 16,
    -7, 13, 3, 22, -17, 8, 1, -22,
    -1, 10, 8, 25, -43, 7, -7, 33,
    -51, -21, -14, -1, -9, -2, 6, 11,
    11, -5, -10, -30, 15, -12, -17, 6,
    6, 7, 16, -7, 15, -18, 19, 19,
    2, -14, 9, -14, -12, -7, -7, 4,
    -3, 14, -7, 17, -5, 15, -2, -10,
    20, 56, 20, 1, 12, -2, 1, -32,
    50, -9, 10, 15, 5, 10, -11, 7,
    -8, -6, -11, -21, -28, 7, -25, -1,
    -18, -18, 37, 82, -3, 2, -4, -8,
    5, 2, 35, 20, -19, 22, -11, 15,
    -5, 9, -5, 8, 12, -8, -19, -14,
    -6, 3, -2, 18, 16, -6, 12, -18,
    3, -9, 2, -4, -10, -30, -5, -15,
    7, -18, -15, -11, 13, 4, 6, 6,
    24, 5, -17, 0, 17, 26, 3, 6,
    -14, -4, -4, -18, 12, 12, -9, 29,
    -52, -4, -1, 4, 14, -15, -7, 17,
    -47, -41, -8, 9, -10, 9, 16, -14,
    3, -4, 5, -13, 3, 7, 33, -21,
    -27, 7, -25, 1, -5, 24, 16, -6,
    44, 39, -47, -17, -1, -27, -11, 1,
    9, -9, 8, 21, -3, 1, 30, -18,
    -6, -9, 9, -2, -4, 6, -1, -23,
    -6, 0, -20, 27, -16, 1, 7, 20,
    18, -44, 28, 36, 15, -1, -11, 7,
    -16, 32, 5, -9, -13, -8, -5, 15,
    9, 4, -16, -21, 27, 36, -10, -22,
    23, 4, 7, 4, -6, 1, -5, 13,
    10, -52, 28, -23, -17, -38, -8, -10,
    31, -15, -2, 1, 28, 9, 2, 4,
    9, -8, 17, -10, 15, -37, 9, -7,
    5, -11, 5, 27, 6, -16, 2, -14,
    -9, 4, -36, 32, -8, -1, -8, -7,
    -13, 20, 25, -14, 8, 27, -3, 1,
    -19, 6, 9, 11, 4, 53, -15, 2,
    -8, 0, 5, 2, -10, 4, 9, -2,
    -28, 77, -7, -23, -2, 4, -6, 5,
    -3, -19, 1, 8, 8, -15, 11, 3,
    9, 6, -25, 5, -14, -15, 22, 7,
    12, -14, -12, 9, 9, 3, 6, 28,
    14, -7, 33, -14, -4, -13, 6, 12,
    -1, 5, 55, 17, 22, -12, -9, -3,
    -2, -4, -2, 7, 2, 1, -15, -21,
    11, -6, 41, -7, 1, -12, -26, 8,
    -12, -1, 17, -51, -5, -3, 14, 8,
    31, -17, -3, -4, -17, 2, -2, -11,
    5, 11, -6, 14, 43, 19, -18, 10,
    -15, -7, 5, 12, -14, 2, -3, 11,
    31, 10, 2, -34, 2, -11, 9, 1,
    -40, 26, -43, -23, 5, -5, -7, -4,
    11, -22, 15, -15, -18, -34, 7, -1,
    8, -31, 1, -9, -35, 6, -30, 11,
    50, -45, -11, 29, 26, 7, -19, 28,
    -34, 3, -21, 9, -11, -18, 0, -16,
    6, 1, -11, -8, -5, -17, -9, 0,
    -27, -22, 6, 16, 1, 0, 36, -7,
    -1, 28, -21, -72, -12, -29, 5, 12,
    -16, 30, 29, -4, -5, -18, -4, 5,
    11, 10, -6, -11, 21, 13, -4, 16,
    -14, 6, -7, -9, -12, 3, 2, 4,
    -23, -40, -57, -52, 9, -25, 11, -7,
    -16, 18, -15, 7, 14, 12, -10, 35,
    -2, 7, 0, 25, -32, 17, 0, 25,
    4, -12, -3, -4, -49, 9, -4, -13,
    12, -41, 72, -6, -5, -8, -13, -34,
    -31, -3, 18, 72, 19, -7, -14, -17,
    -4, 18, -2, 1, 18, 4, 19, 11,
    -11, -2, 18, -9, 7, -26, 4, 15,
    -17, -17, -1, -20, 2, 11, -13, 20,
    33, 5, 15, 27, -13, -21, 6, -11,
    -39, -16, -5, 12, -18, -49, -18, -18,
    27, 11, -12, 8, -12, 16, -2, 3,
    11, -2, 15, -11, -8, -2, 21, -8,
    45, 27, 34, -6, 9, -4, 8, -5,
    1, 0, 6, 0, -50, -4, 29, -11,
    5, 28, 3, -2, 7, 34, 7, 19,
    23, 20, -21, 41, -19, -1, -2, -2,
    -4, -7, 11, 11, -5, -1, -10, 5,
    23, 5, -2, 17, 12, -21, 12, 20,
    -11, -11, 11, -2, 31, 3, -50, 42,
    -7, -17, 33, -4, 8, -2, -3, 2,
    -1, -8, -6, -7, -14, 3, -17, -12,
    4, 1, -1, 5, -1, 30, 17, 9,
    -7, 1, -10, 1, -4, -7, -19, 8,
    19, -31, -19, -5, -6, -21, -5, -10,
    17, 10, 10, 6, 4, -3, 6, 3,
    -2, 8, -7, 11, 17, -28, 8, 46,
    2, -6, 4, -13, -20, 7, 2, -12,
    -8, 17, 17, 53, -14, -11, 17, 21,
    -7, 2, -10, -26, -9, 39, 0, 18,
    30, -23, -1, 11, -17, 2, -10, 11,
    -8, 13, -12, -9, 12, -17, 1, -3,
    23, -44, 33, -48, -7, -7, -7, -11,
    -13, -42, 1, 5, -7, -9, -7, -1,
    15, -2, 26, 2, -17, -9, 31, 2,
    9, -8, 15, -4, -4, 15, -12, 9,
    -26, -46, -18, -27, 3, 25, 0, 8,
    19, -9, -1, 21, 5, 1, 0, -11,
    11, -8, 42, -6, -11, -11, -25, -11,
    12, 21, 44, 14, -7, -18, -11, -4,
    -50, 10, -37, -38, 9, -12, -22, 2,
    9, 11, 12, -2, 3, 2, -6, -13,
    7, -4, -8, -6, -8, 32, 6, -5,
    5, -19, 3, -13, -11, 1, 49, -2,
    3, 19, 3, -3, -20, -33, 4, 12,
    -17, -37, 8, -65, 19, 4, 33, 15,
    21, -5, 14, 6, 33, 10, -14, 8,
    -20, 15, 45, -16, -6, -21, -6, 39,
    5, 23, -4, 8, -5, -5, 1, 8,
    -24, 58, -13, -17, 9, 31, -4, -18,
    -19, -15, -5, 16, 20, -40, -9, 0,
    -20, -47, -20, -31, 15, -2, -28, 72,
    9, -38, -28, 30, 41, 8, -17, -23,
    -37, 46, 16, 24, -5, 33, -34, -38,
    24, 35, 88, -40, -46, -6, 0, 5,
    24, 38, -26, 3, -5, 39, -6, -37,
    -14, -9, -1, -5, -6, 17, -17, 1,
    -27, 4, -12, -25, -33, -30, 20, -5,
    -9, -11, -34, -35, -21, -47, -19, 38,
    18, -45, -9, 0, -1, 5, -16, -23,
    -23, 26, 32, -16, 19, 2, 13, -16,
    23, 28, 13, -17, -14, -37, 76, 23,
    -11, -57, 53, 33, -48, 12, 1, 50,
    23, 15, -9, 53, -14, 51, -1, -62,
    -2, -34, -51, 42, 32, -8, -1, -14,
    45, 23, -23, -48, 28, 30, -34, -1,
    -11, -3, 1, -6, 0, -3, 65, -12,
    42, 87, 18, 4, -47, 43, -13, 17,
    39, -45, -9, -12, -33, 4, -2, 60,
    -32, 7, -12, 17, -11, -48, 15, 8,
    4, -34, 3, 3, -34, -39, -39, 9,
    6, -7, 3, 27, -39, -13, 13, 43,
    6, -78, -22, -2, 8, 9, 0, -2,
    38, 8, 18, 18, 40, -16, 4, -67,
    -82, 12, -5, -15, -21, -38, -18, -10,
    -17, 7, 13, -57, -48, -23, -23, 13,
    -11, 1, -56, 96, -5, -9, -58, 5,
    -6, 11, 15, 12, -12, 32, 10, -1,
    -3, -21, 3, -6, -8, -25, 19, 7,
    -2, 23, 13, 14, 16, -32, 35, -19,
    9, -3, 52, 31, -12, -42, -23, 9,
    -33, 26, 7, 11, 33, 13, 13, 29,
    -29, -19, 0, 1, -7, 30, -11, 5,
    -18, 2, -1, 3, 15, 19, 19, -8,
    10, 25, -9, 15, 28, 32, -5, 13,
    47, -7, -17, 17, -51, 11, 20, -37,
    -9, 2, -2, -8, -70, -31, 31, -30,
    -43, 0, -10, 13, -32, 50, 14, 13,
    -37, -1, -7, -21, 11, -18, 4, 0,
    19, 6, -5, 36, -12, -10, -8, -2,
    20, 13, 1, 7, -12, -17, -18, -46,
    4, -19, 13, 47, -15, -7, 35, 65,
    -54, 5, 26, -11, 32, -5, 8, 5,
    -15, -114, -12, -1, 21, 40, -26, 22,
    -27, 0, 7, 44, 8, 2, 69, 60,
    22, -12, 39, 53, 8, -15, 25, -4,
    45, 44, 7, 37, -40, -89, -18, -16,
    14, -34, -4, 29, -7, -21, -50, 3,
    -2, 14, -31, 4, -3, 3, -7, 57,
    6, -1, -54, -1, -6, -7, 2, -9,
    4, -33, -10, -21, -19, 13, -51, -7,
    2, -11, -13, 0, -24, 57, 13, 24,
    62, -15, -17, -7, -41, -36, 20, -7,
    -30, -77, 15, -10, -43, -7, 49, -13,
    -11, 34, -10, -89, -31, 14, -10, -4,
    0, 24, -7, -18, -12, -7, 22, -112,
    -16, -9, 1, -49, -18, 21, 26, -26,
    -28, 25, -11, -63, 15, 0, -2, 11,
    1, -15, -6, 18, -10, -83, 15, 11,
    0, -11, -64, 32, -6, -13, -16, -14,
    -20, -14, 35, -1, -10, 26, 15, -8,
    -10, -38, 23, 8, -5, 3, -72, 38,
    -5, 17, 6, 1, -21, 0, 11, -3,
    35, -16, 5, -17, 41, 10, 31, -2,
    4, -4, 28, -21, -22, 29, -6, -50,
    -10, 22, -18, -56, -65, -58, -59, 54,
    -7, 5, 47, -2, -5, 9, 25, -18,
    26, -13, 30, 6, -8, -2, 36, 75,
    -27, 38, -30, 19, 0, -22, -3, 9,
    -34, -22, -10, 17, -49, 17, -85, 7,
    11, -42, -25, 57, 67, 9, 9, 33,
    -48, 69, -15, -87, -56, 59, 83, 22,
    -24, -37, 34, -4, -29, -17, 37, -7,
    -40, 46, 25, 0, -27, -14, 68, -28,
    15, 23, -2, -81, -16, 22, 17, -10,
    -9, 51, -2, 21, 12, -41, -35, -2,
    -2, 18, -18, -11, -8, 1, -4, -2,
    -46, 16, -7, 17, -32, -9, -34, 41,
    51, -65, -14, 28, -38, -23, -31, 5,
    -16, 20, -12, -17, 13, -4, -11, 59,
    22, 5, 2, -45, 6, 7, -6, -54,
    25, -3, -15, -15, -51, 26, -19, 5,
    -15, 69, -4, 19, -23, -2, 8, -7,
    31, -1, -14, -58, 3, 16, 17, -12,
    -12, -28, 4, -1, 6, -23, -42, 5,
    -20, 16, -59, -22, -30, -8, 12, -31,
    29, -16, -24, -69, 1, 10, -3, -10,
    26, 8, 30, 16, 20, -12, -5, -21,
    127, -7, 8, 0, -4, -33, 5, -1,
    2, 0, 27, -30, 10, 34, -16, -12,
    -48, -5, -6, -45, -13, -12, 10, 17,
    -63, 5, -12, 10, -11, 6, -89, -40,
    -28, 9, -21, -13, 2, 0, 6, -18,
    8, 16, -55, 60, 42, 20, 34, 16,
    7, 7, -47, -70, 4, -9, -14, 49,
    20, -25, -46, 81, -28, 38, -48, -10,
    -35, -17, -20, -28, 37, -26, 27, -7,
    -49, 24, -42, 34, 42, -2, -123, 127,
    -10, -21, -2, -12, 10, 16, 57, 10,
    -6, 1, 26, 67, -4, 0, 2, -22,
    2, -5, -22, 8, -4, 1, -7, -4,
    -13, -22, 5, -2, -2, -4, -33, -35,
    34, 8, -30, -31, 13, -42, 16, -4,
    18, 11, -16, -33, 17, -29, -49, 74,
    0, -5, -30, -39, 3, 29, 0, 26,
    -6, 38, 23, -35, -25, 33, -6, 14,
    6, 34, -8, -25, -12, -9, -1, 28,
    20, 6, -11, -36, 0, -67, 17, 4,
    -18, 29, -9, -8, -49, -19, -3, -5,
    -27, -31, -5, 18, 16, -13, -5, 18,
    -17, -70, -20, -22, -11, -13, 17, 16,
    56, -9, -32, -36, 1, -12, 26, 13,
    -22, -1, -17, 11, -10, -25, -32, -33,
    42, 7, -39, -10, 26, 24, -19, -1,
    -10, -20, -36, -60, -1, -18, 1, -18,
    19, -34, -28, -6, -18, -10, -46, -9,
    7, 4, -54, 1, 1, -5, 19, -2,
    -8, 0, -1, 15, -21, 5, 44, -17,
    -44, 9, 30, -60, 29, -11, -29, 6,
    -58, -16, -10, -12, -37, 31, -43, -18,
    -13, -6, 11, -18, 12, 0, 14, -1,
    -19, -19, -69, -4, -14, -1, 53, -2,
    24, -10, -20, -20, 33, 14, -23, -19,
    -12, -53, 3, -21, -31, -75, -27, -5,
    1, 38, 3, 15, 6, -3, -7, 26,
    -42, 2, -5, 2, -9, -47, -32, 25,
    -43, 29, -12, 8, 24, -24, -1, 3,
    -14, -61, -9, -1, -8, -13, -3, 8,
    -26, 13, 15, -30, -5, -22, -6, -9,
    22, -5, 14, 9, 6, 1, 9, -4,
    -35, -13, 31, -44, -30, 36, -24, 11,
    5, -3, 7, 34, 12, 19, -18, 2,
    36, -31, -24, 0, 22, -3, 0, -7,
    -1, -23, 18, 20, -10, 5, -21, 22,
    -46, 50, 1, -2, 12, -41, -24, 10,
    30, -82, -2, 25, 2, -16, -6, -12,
    14, -26, -17, -3, -12, 18, -11, -16,
    17, -15, 6, 5, -24, -10, 25, -5,
    -19, 51, -19, -28, 12, -16, -38, -4,
    84, -44, 35, 1, 36, 0, 3, -19,
    14, -3, 18, 5, -19, -23, -2, -14,
    -24, -10, -14, -33, -2, 6, 16, 19,
    55, 2, 36, -25, 11, -35, -26, -6,
    43, 41, -33, -18, -6, -7, -35, 29,
    -6, -26, -8, -26, 29, 33, -33, 18,
    -25, 16, 0, -7, -31, 6, 8, -15,
    45, -1, 66, 30, -2, -11, 4, -19,
    -4, 5, -47, -57, -14, -30, -14, -14,
    -4, 3, 10, 60, -6, 3, 34, -35,
    -4, -18, 34, -7, 11, -28, 24, 3,
    7, 4, 8, -39, -41, 0, 27, -37,
    21, -30, -24, -29, 17, 29, 25, 17,
    37, 2, -10, 4, -13, 7, -11, 1,
    -2, -15, 9, -14, 0, 4, 7, -2,
    -1, -21, 8, 24, 28, -17, -13, -13,
    0, 69, 32, 4, -3, 19, 9, 21,
    14, 1, -14, 14, 30, 1, 66, -30,
    -4, 2, -34, -7, -8, -22, 27, 13,
    12, 31, 12, 33, -25, 1, 0, 3,
    -36, 12, -45, -55, -30, -27, 6, 4,
    16, 34, -1, -25, 1, -52, 10, 24,
    25, -6, -25, 1, 12, -7, -4, -5,
    -29, -15, 7, -8, -1, -19, 21, -1,
    -16, 11, 17, -15, -31, -16, -22, 14,
    -15, 24, 33, -11, -4, 5, -21, 30,
    0, 28, 31, 16, 20, 27, -3, -5,
    -23, 7, -42, 4, -24, 1, -40, -3,
    8, -60, -21, -31, -20, 3, 29, 11,
    4, -8, 15, -8, -25, -15, 1, 1,
    -28, 25, -4, -51, -4, 33, -14, -9,
    -98, 14, -34, 3, 25, 27, 12, -9,
    17, -1, 53, 54, 46, -31, 31, 18,
    22, -5, 19, -15, -17, 3, 16, 13,
    15, 16, -8, -28, 2, 11, 22, -15,
    -3, -12, -20, -20, -1, 22, 2, -20,
    9, 0, 35, 42, 15, 11, 5, 40,
    -8, -17, -26, 35, -7, -26, 26, 18,
    -12, 0, 19, 65, 9, -22, -18, -3,
    -18, -42, 57, -15, -15, 8, -32, 14,
    4, -21, -22, -15, -9, -18, -48, -12,
    -16, -21, 6, -1, -23, -7, 30, 7,
    -8, -35, -4, -12, 4, -7, 0, 3,
    -9, -13, 50, -8, -12, 7, -17, -12,
    6, -10, -25, 18, 27, -10, -17, -2,
    -39, 23, -24, -47, 38, 0, 19, 8,
    -3, -10, -16, 28, -8, 4, 12, -11,
    20, -22, 13, 5, -3, 5, -10, 23,
    3, -3, -75, -54, -25, -7, -9, -37,
    0, -29, 33, 25, -3, 23, -30, -26,
    13, -33, 15, 7, -17, -28, 6, 33,
    -1, -44, 7, -57, -35, -17, -26, 8,
    8, 17, -21, 19, -21, 19, 14, 1,
    11, -7, -1, -15, 8, 12, 31, -4,
    19, 9, -22, 2, -1, 0, 9, -5,
    15, -7, 44, 7, -12, -12, 0, -2,
    -64, -41, -76, -51, -13, -7, -50, 20,
    8, 12, 8, -4, 13, 3, -2, -13,
    34, -8, -7, -21, 11, 20, 22, 3,
    4, -34, -3, -54, -1, -3, 20, -7,
    21, -27, -20, 10, 16, 45, -45, 13,
    -12, 3, 11, -5, 17, -31, -50, 5,
    -10, 8, 2, -37, -2, -22, -1, 14,
    27, -3, 57, 72, -18, -28, 9, -8,
    -63, 18, 29, -55, -38, 20, 33, -31,
    -2, -10, 13, -27, 0, -16, 14, 28,
    28, -5, 4, -10, -10, 4, 4, 16,
    39, 36, -33, -3, 10, -15, 4, 7,
    -11, 11, -33, 32, 4, -32, 14, 21,
    -29, 5, -38, 4, 32, -31, 27, -19,
    -13, 12, 12, -12, 9, -5, 27, 17,
    -20, -2, 25, -5, 0, 44, 10, 32,
    -25, -9, -56, 69, 45, -11, 14, 37,
    20, -37, 10, -8, 19, 15, -12, 12,
    6, -31, -14, 5, -31, 16, -47, 17,
    8, 13, 29, -8, 23, -5, 14, -1,
    -14, -21, -26, 54, 8, 14, -8, 28,
    11, 6, 46, -18, -9, 19, 30, 41,
    -47, 12, 15, 17, 4, -32, 8, -19,
    -14, 6, -5, -7, -9, 11, -21, 15,
    -27, -46, -17, 9, -12, -37, 12, -3,
    7, 11, 36, 7, -14, 16, -9, -8,
    -35, -3, 3, 3, -24, -12, 6, -14,
    0, -6, 10, -5, 3, 26, 11, -4,
    -38, -65, 6, -19, 0, -11, 32, 40,
    46, 30, 13, -1, 16, 9, -12, -12,
    29, -9, 5, 12, 5, 0, -38, 8,
    -1, 23, -1, 48, -6, -3, 10, 8,
    15, -40, 14, -18, -2, -43, 17, -52,
    17, -21, 21, 9, -19, -2, -36, 17,
    -14, -5, -29, 3, 1, 2, 0, -8,
    -22, -4, -26, -54, -17, 4, -27, -2,
    -15, 30, 12, 34, 10, 41, 30, 20,
    -4, 4, -3, -12, -14, -8, -13, -13,
    20, -14, -10, 13, -21, -23, 6, 5,
    -18, 76, 22, -61, -18, 16, 21, 5,
    2, -18, -38, 16, 13, -34, 38, 3,
    38, -2, -24, -31, -12, 4, -6, 9,
    7, -37, 9, -27, -3, -2, 16, -21,
    11, 5, 14, -6, -26, 5, 5, -6,
    21, -53, -69, 1, 4, -49, -5, 27,
    1, -1, 38, 10, -33, -1, 8, -3,
    -5, 6, -3, -3, 14, -8, -22, -4,
    -53, 15, 69, 4, -29, -16, 14, 20,
    36, 3, -26, -5, -12, 58, 0, -18,
    27, -43, -47, -1, -3, 77, -10, -16,
    8, -28, -3, -12, 19, 10, -10, -27,
    -1, -12, -16, -14, 3, -16, 5, 25,
    -4, 10, -12, 14, -9, -16, -37, -5,
    -8, -1, 31, -16, -11, 0, 10, -1,
    1, 16, 2, -10, -23, 8, 37, -3,
    -45, -18, -11, 33, 37, 35, -8, -29,
    76, 34, 18, 2, 11, -19, -32, 11,
    34, -15, -7, 0, -5, 6, 19, 33,
    -25, 2, 7, 7, 5, 39, -7, -24,
    15, -10, -11, -15, 13, -6, -19, 21,
    -20, 26, 9, -4, -19, 16, -5, 10,
    -10, 5, -2, -7, -7, -29, 0, 9,
    4, -25, -2, -7, 13, 13, 8, 7,
    36, 14, 2, 24, -14, 40, 33, -57,
    -19, 18, 41, 19, -49, -50, 53, -26,
    32, -5, 8, -6, 7, 34, 12, 5,
    -18, -9, -65, -15, -34, 2, 12, -17,
    -1, 7, -5, 7, -2, -28, -11, -1,
    8, 15, 24, -10, -5, 24, 24, -23,
    -15, -15, -16, -23, 17, -26, -7, -34,
    16, 5, -6, 8, 8, -30, 34, 22,
    26, -13, 0, 17, 11, -6, -11, 0,
    -2, 15, 11, 0, 16, 3, -3, -57,
    -10, -20, 29, -2, -10, 5, -8, -35,
    3, 45, -48, -8, -1, 34, -8, 26,
    -12, -8, -54, 18, 20, 10, 1, 4,
    -16, 34, -14, 5, -5, -35, 5, 19,
    23, -16, 3, 24, 11, 11, -22, -22,
    31, 26, 16, 18, 20, -30, 3, -15,
    0, 30, -37, -16, -15, -33, 32, 10,
    12, -8, 44, 8, 19, -21, 39, 8,
    -13, 21, 39, 13, -42, -13, -16, 5,
    -31, -1, 24, -25, -24, -7, -9, 8,
    16, -11, 2, 20, -42, 6, 16, -32,
    12, -40, 28, -81, 39, 10, -2, -33,
    44, 1, -22, 25, -51, 26, -4, 24,
    19, -9, -8, -2, -9, 10, 32, 11,
    7, -8, 50, -9, 8, -20, 3, -12,
    20, 11, 20, -6, -2, -1, -9, 5,
    -9, 10, 6, 19, -4, -13, 20, -43,
    -6, 13, -9, -1, -26, -3, 16, 4,
    -7, -5, -51, 14, -18, 11, 8, 19,
    4, -6, 40, 25, 4, -6, -3, -3,
    -11, 12, 13, -18, -2, -27, -10, -5,
    34, 8, -40, -20, 8, 13, 4, -9,
    42, -21, -11, 4, -14, -19, 18, 5,
    48, -26, 8, -20, -27, 3, -22, 18,
    -10, 25, 3, -3, 24, -17, 29, 15,
    -1, 14, -1, 12, -13, 12, -1, -1,
    12, -30, 51, 8, -16, -4, -12, 1,
    -36, -33, 99, -22, 7, 14, -17, 28,
    7, 24, 9, -4, 16, -21, 23, -29,
    -11, -4, -12, -1, -2, 4, -21, -12,
    -13, 12, 14, -10, 9, 7, 23, 18,
    -15, -5, 32, 13, 1, -2, 13, -2,
    22, -25, -14, 4, -5, -79, 6, 26,
    -17, 28, -19, -37, 23, -22, -10, -18,
    -51, -43, 28, 1, 5, -9, 7, -7,
    3, -15, -21, -5, 8, -36, -20, 14,
    -6, -27, -18, -4, -45, -35, 76, 41,
    -14, 7, 18, 29, 9, 4, -11, 20,
    -45, 31, -26, 20, 21, 10, -27, 1,
    -6, -38, 3, -29, -11, -40, -15, -15,
    3, -5, 1, -15, 49, -54, -25, -16,
    -10, -31, -14, -33, 11, 27, -10, -9,
    -15, 3, -31, 12, -29, -3, -11, -43,
    7, -23, -19, 13, 10, 73, 15, -2,
    -17, 7, -22, -44, 43, -37, 7, 75,
    2, -23, -31, 11, -6, 28, -9, 14,
    -5, -1, -35, -21, 6, -1, -12, -9,
    10, -23, -19, -60, -17, 21, -5, -35,
    2, -16, 39, -7, -10, 25, -27, 9,
    11, 10, -15, 19, -9, -46, -16, 9,
    -32, 29, 20, 48, 13, -17, 7, -32,
    21, -27, -51, 20, 16, 3, 13, -16,
    -2, -25, 12, -3, -43, 1, 23, 35,
    7, 23, 13, -10, 57, -7, 16, -12,
    9, -31, -13, 14, -27, -31, 15, 5,
    -52, -68, -23, -20, 0, -14, -7, -6,
    -44, -2, -9, 8, 23, -39, 18, -9,
    -11, -38, -29, -12, 45, 2, 12, 9,
    53, 49, 10, 35, -2, 40, 31, 25,
    8, 16, 64, -26, 17, 9, 62, -32,
    -20, -11, 15, -4, 26, -4, -42, 18,
    -29, 4, -14, -24, -26, -34, -25, 5,
    -10, 43, 5, -32, 7, -18, 3, -3,
    -6, 26, -2, 34, 16, 3, -6, -6,
    8, 6, 11, -16, -30, -13, 22, -12,
    19, -19, 22, 4, -4, -3, 6, -6,
    -36, 29, -10, -34, -12, 1, 17, 15,
    14, 19, -6, -11, 19, -25, -1, 9,
    -54, -7, 5, 5, 21, -20, -20, -53,
    -20, 1, 24, 36, 17, -6, 9, 15,
    -17, 13, -4, 5, 2, -41, 41, 17,
    -20, -71, -21, 30, 11, 13, 28, 14,
    18, 7, 32, -7, -21, -41, 25, -49,
    -9, 42, -27, 33, -9, 7, 2, -20,
    28, 35, -33, 64, 48, -16, 25, 19,
    -26, -40, 12, 32, -29, 8, 6, -4,
    42, 3, 25, -16, 5, -4, -27, 18,
    -102, 13, 7, 30, -13, -9, 0, -4,
    17, -1, -36, 1, -28, 16, -22, 30,
    24, 26, -44, 12, -2, 0, 12, -24,
    -1, -2, -7, 5, 2, -21, -47, 43,
    -5, -3, 5, 35, -17, -1, 8, -12,
    24, 16, 14, 23, -27, 41, -9, -18,
    -31, -19, -6, -61, 16, 0, 27, -21,
    54, 20, -7, 19, -19, 15, 1, 5,
    50, -15, 0, 30, -13, -11, -6, 5,
    -4, -25, -33, 0, -9, 2, -3, 6,
    9, 3, -1, 38, 0, 5, 14, -3,
    3, -11, 12, 13, 20, -23, -29, 24,
    -25, -28, -14, -16, 14, 13, 6, -5,
    -6, 22, 25, 15, -6, -4, -29, 10,
    9, 13, -60, -44, 1, -11, 21, 25,
    2, 4, -17, 10, -29, -39, 1, -52,
    25, -11, 72, 4, 5, -4, -12, 0,
    12, -24, -8, -17, 20, -1, 11, -1,
    -16, 18, 1, -47, -1, -17, 15, -10,
    23, 3, -2, -20, -9, -38, -16, 28,
    8, -24, 5, -20, -24, -41, -8, -3,
    32, 7, -10, 9, -53, -15, 9, -21,
    -16, -55, -77, -26, -9, -23, 42, -4,
    2, -16, -3, -7, 62, 42, 31, 14,
    16, 16, -5, -9, 3, 13, 14, 20,
    -52, 41, -73, -6, -27, -7, -46, 22,
    53, -6, 35, 17, 7, 1, -18, -22,
    26, -8, -49, -13, 12, 38, -10, -20,
    19, -27, 41, -28, 11, -4, -9, -2,
    1, 5, -26, 15, -7, 15, -17, 40,
    -30, -33, 38, 13, -28, 6, -4, -15,
    -32, -19, -15, -5, 21, 7, -67, 19,
    -3, 13, -2, -3, -17, -2, 15, 8,
    -28, -33, -35, -19, 48, 44, 12, -24,
    -27, 15, 62, -69, -10, -33, -21, 25,
    73, -16, -17, -110, 67, -86, 14, -35,
    16, 8, 25, -4, -9, 14, -26, -36,
    11, -1, -28, 4, -5, -10, -46, -4,
    31, 52, 50, 26, 30, 6, 14, 7,
    5, 21, -13, 21, 55, 4, 58, -11,
    12, 30, 31, 28, -30, -9, -1, 18,
    -47, -20, 5, 13, -6, 43, -24, -16,
    -67, 38, 71, -2, -23, -50, 30, 14,
    -22, 2, -3, 60, -16, -12, 10, -5,
    5, 1, 87, 29, -24, 47, 43, -22,
    -39, -27, -13, -11, -20, -13, -19, -21,
    -13, 9, 6, -36, -60, -14, -24, -32,
    -17, 69, -10, -19, 26, -31, 4, -18,
    -38, -17, -22, -75, 27, -6, 51, 29,
    5, -40, 22, -19, 18, -10, -22, 53,
    -62, -29, 41, 26, -10, -36, 17, 12,
    -32, -97, 26, 15, -22, 37, 32, 19,
    -30, -99, 43, 30, -11, 87, -7, 9,
    1, -26, 9, -76, 12, 4, -53, 51,
    83, 27, 38, -100, -82, -47, 0, 13,
    -45, 25, -36, 4, -3, -68, 32, 18,
    -15, 10, 0, -102, 42, 34, -13, -7,
    -20, -2, -33, -15, -49, -37, 24, 17,
    4, -4, 21, 38, 22, -39, -2, -4,
    -33, 19, 42, -74, 53, -8, -12, 59,
    -58, -7, 42, 23, -53, 19, 2, -17,
    33, -4, -13, -3, -87, 17, 30, -65,
    14, -36, 11, -12, 18, -31, -27, 12,
    0, 50, -15, 12, 23, -65, -28, 34,
    -46, -3, -54, -43, 0, 32, 43, 1,
    23, -49, 22, -9, 15, -14, 17, -6,
    -5, -12, 10, -7, -14, -20, -9, 19,
    -8, 7, 53, 0, -14, -19, -35, -22,
    -24, -5, 15, -18, -14, 27, 32, -11,
    -85, 85, 17, 13, -13, -11, 20, 14,
    18, 43, 59, 6, 41, -34, 32, -36,
    17, 62, 32, -7, -18, -47, 10, 9,
    -28, 9, 17, 22, 6, 32, -4, -5,
    -24, -2, -35, -15, 4, -14, -44, 44,
    9, -54, 38, -16, -6, -31, 2, 15,
    42, -20, -19, -12, 22, 37, 94, -49,
    -58, 12, 3, -9, -9, -28, -27, 0,
    55, 30, -37, 5, -38, -5, 16, 41,
    -2, 10, -46, -49, 58, 5, -25, -35,
    -14, 9, 20, 33, -27, 22, 7, -41,
    0, 34, -26, -13, -5, 2, 50, 16,
    -25, 19, 53, 16, 46, -8, 27, 3,
    5, -80, 30, -8, 10, 69, 54, -42,
    -17, 1, -73, 21, 6, -14, -7, -8,
    -21, -27, -29, 10, -17, -30, -39, -27,
    5, -6, 19, 3, -20, -21, 6, 7,
    5, -4, -39, -7, 30, -5, 59, 16,
    21, 9, -33, -14, -73, 43, -10, -23,
    -40, -20, -48, 29, 1, 58, -29, -4,
    -50, 77, -9, 27, -17, -59, -32, -6,
    -17, 5, 52, 11, -12, -25, -18, -3,
    38, -25, 51, -7, 13, 65, 10, -14,
    11, 61, -17, 75, 61, -4, 20, -10,
    -25, 25, 44, -24, -24, -33, 0, -28,
    5, 11, 8, -4, 24, -1, 33, -35,
    60, -1, 48, 17, 2, 31, 11, 6,
    -21, -10, 31, -37, -6, 4, -26, 20,
    1, 22, -9, -9, -5, 8, -49, -29,
    4, -31, -7, 56, -9, 57, 22, 31,
    18, -11, -4, 39, 0, -12, 46, 9,
    5, -32, 11, 13, -1, -12, -38, -29,
    -13, -37, -7, 12, -5, 21, 49, -25,
    -28, -23, -64, -51, 2, -34, 0, 12,
    -25, -14, 49, 13, -10, -8, -49, 25,
    23, -49, 16, 15, 27, 24, -29, 31,
    13, 16, 86, 6, -63, -66, 3, 15,
    -59, 15, 75, -14, -18, 23, 37, -19,
    35, -44, 25, 36, -100, 23, -1, -30,
    36, 52, -21, 9, -66, 45, 2, 20,
    0, -18, -5, 12, 24, 52, -9, 17,
    -3, -46, 30, -8, 55, -54, 50, 20,
    -71, 46, 9, 13, 47, -18, 0, 2,
    -10, -24, 45, 27, -9, -46, -62, -67,
    1, 23, -6, 25, 2, -39, -16, -9,
    -48, 29, -47, 68, 36, -35, -49, -3,
    50, 38, 24, 4, 20, -2, -33, 3,
    87, -16, -110, 19, -23, -35, 12, 9,
    -17, 51, 0, -11, -66, -20, 30, -6,
    76, 18, -34, 2, -19, -46, 37, 1,
    37, -2, 92, -43, -39, -5, -127, 28,
    23, -9, 8, -2, -8, -11, 49, -28,
    -26, 15, 26, -45, 0, -72, -20, 9,
    33, 41, -26, -1, 4, 7, 3, 20,
    12, 58, 36, -50, -11, -10, 95, -44,
    45, -42, 60, -8, 9, 13, -27, -26,
    -2, 55, 16, -34, 47, 3, -3, 37,
    -1, -26, -2, -10, 8, -14, -19, -45,
    54, -4, -72, 15, 4, -22, 81, -55,
    -9, -2, -20, -11, -3, 16, 6, 2,
    7, 14, 18, -11, -28, 15, 14, 43,
    38, 28, -63, -40, 4, -32, -17, -26,
    58, 7, -52, -26, 26, -7, 24, 3,
    -11, -3, -34, -66, -45, -32, -8, -10,
    -34, 17, 15, 40, -13, 25, -22, 3,
    -15, -48, -20, 59, 12, 8, -10, 2,
    -3, -26, 22, -5, 66, -34, 31, 1,
    -52, -53, -29, -16, 45, -2, 14, 10,
    5, 35, -20, -8, -6, -17, -34, -1,
    5, 23, -27, 23, -24, 28, -20, -9,
    -1, -13, -6, 60, 3, -5, 10, -17,
    -22, 9, 7, -23, 25, 8, -42, 7,
    10, 28, -72, 34, -28, -16, 0, 13,
    -1, 49, -114, -15, 0, 12, -7, 38,
    -9, 5, -13, 48, -4, 23, -14, -21,
    24, -57, -51, -2, 8, 22, -5, -15,
    -6, -36, -13, 40, -6, 33, 15, -28,
    -34, -21, 16, 66, 8, 32, -18, -12,
    -18, -3, 27, -18, 53, 25, 5, 46,
    -1, 14, 22, 25, 18, -16, 16, -17,
    -19, 38, -11, -17, -21, -16, -48, -30,
    76, 4, 31, -36, 20, -35, 6, -19,
    27, 38, -48, -5, 76, 0, 80, 14,
    -4, -12, 29, -11, -21, 33, 21, 45,
    25, 31, 20, 13, -20, 14, -90, -10,
    6, -4, 60, 25, -11, 4, 32, -44,
    9, 71, 3, 9, -6, -54, -4, 6,
    -66, -38, -67, 7, 33, 29, 0, 18,
    20, 60, -26, 13, -42, 15, 2, 30,
    51, -27, 32, 20, 4, 30, 39, -28,
    10, -14, -2, -1, 1, 27, 56, -22,
    12, 19, 19, 16, -80, -16, 27, -12,
    -14, 23, 14, 39, 14, 6, 7, 16,
    -29, -1, -11, 30, 2, -7, 23, -6,
    0, -12, 58, -33, -29, -37, 30, -10,
    -14, -20, 14, -16, 5, 21, -3, 1,
    -12, -16, -23, -15, -1, -4, 10, 4,
    -17, 1, -5, -2, 11, 1, -1, 5,
    0, -31, -6, -10, -19, 1, -1, -41,
    -12, -1, -16, 16, 31, -63, -43, 14,
    7, -57, 58, 1, 15, 6, -34, -9,
    24, -1, 34, 14, -1, 14, 21, 3,
    -23, -9, -34, -8, -14, -9, -21, 7,
    3, 17, -45, 12, -36, 12, -6, 5,
    27, 5, 5, 1, -14, -3, 16, 12,
    -15, 26, -23, 3, -5, -26, 14, 24,
    -21, 4, -26, -5, -36, -15, -1, -28,
    6, -18, 5, 18, -1, -13, -13, 4,
    9, 23, 1, -4, -12, 11, -13, 11,
    15, 37, -13, -6, 15, -15, -7, -6,
    -24, 37, -14, -23, 10, 44, -24, 65,
    20, 8, 8, -25, 34, -12, 1, 27,
    -21, -17, -27, -30, -12, 14, -12, 11,
    11, 7, 3, 5, 25, 8, 13, -31,
    -16, -19, -2, -39, -9, -6, 21, -10,
    -3, -5, -23, -17, -21, -6, 29, -7,
    -39, 13, -24, 13, 18, 13, 0, 17,
    -24, -22, -10, 53, -18, 3, 8, -18,
    37, -16, 16, -27, -19, 20, 20, -54,
    -1, 12, -16, 1, 24, -27, 5, 7,
    -32, 19, 9, 3, -4, 10, -9, 11,
    -19, -7, -33, 10, -19, 15, 19, 17,
    22, 11, 33, -44, 19, -12, 7, 2,
    9, -18, 19, 10, -39, -90, -1, 7,
    19, -2, 0, 1, 13, -8, -32, 1,
    -14, 0, 4, 4, -34, 14, 9, 67,
    -13, -17, -5, 49, 29, 39, 13, 20,
    3, -6, 22, 27, -6, -2, -27, 2,
    -4, -38, -23, -2, -1, 4, -9, 21,
    -24, 11, -15, 6, 11, -29, -10, 5,
    10, -67, 7, -25, 28, -22, 20, 8,
    3, -11, 0, -55, -20, 11, 5, 19,
    -14, -16, 3, 20, -7, 3, 26, -3,
    -4, -21, 13, 12, 10, 22, 1, 17,
    -34, -43, -9, 26, -5, 17, -18, -56,
    23, -18, -1, -21, 21, 37, 19, 17,
    -42, -11, 10, -3, -2, 11, 13, -11,
    5, -11, 37, 36, -8, 0, -9, -2,
    28, 58, -20, -31, -18, -10, 3, 13,
    21, 1, 37, 3, -7, -16, 22, -2,
    22, 8, 11, 11, 1, -15, 9, 8,
    47, -2, 39, 30, -14, -3, -20, -5,
    -49, -27, -23, 7, -18, 15, -55, 3,
    25, -6, -3, -6, -44, 10, -7, 2,
    44, -34, 8, 17, -7, 1, 23, -13,
    -53, -40, -16, -35, 12, 14, -11, -2,
    -27, -14, 27, 10, 23, 4, 23, -14,
    -2, -33, -8, 15, -8, -34, -41, -8,
    -11, 32, -35, -9, -20, -3, 10, -5,
    -3, -5, -41, -2, 7, -4, 11, -6,
    -5, 7, 21, -20, -1, -40, 24, 36,
    15, -14, -5, 16, -23, 47, -37, -2,
    25, -3, -8, 9, 1, -21, 10, -1,
    -28, 41, 20, 35, 25, -7, -20, -3,
    -2, 19, -10, 15, 15, -24, -8, -30,
    8, 53, -17, 10, 13, -56, -2, 27,
    8, 1, 14, -35, -6, -5, 6, 4,
    -28, -33, -18, 3, 34, -15, 2, -4,
    30, 45, 50, 1, -14, -7, -7, 30,
    0, 6, 18, 25, 5, -17, -4, 20,
    -7, 16, -13, 25, -13, -5, -8, 13,
    -17, -1, 8, 10, -3, 2, 12, -6,
    14, -16, -5, 12, -9, -10, 18, 30,
    -3, -9, -16, -24, -51, -15, 22, -16,
    -26, -31, -43, -18, -22, 26, -10, -5,
    -18, -7, -43, -21, 19, 16, -15, 7,
    -53, 13, 23, -19, -37, -27, -21, 8,
    -7, 2, 20, 5, 23, 30, -11, 0,
    19, 27, 22, 5, 18, 4, -7, -13,
    15, 33, 28, -74, 4, -5, 0, 3,
    4, -3, 26, 14, 2, -41, -3, -14,
    23, -16, 6, 6, -48, 22, 31, -42,
    -5, -14, 1, -17, -11, 9, -4, 9,
    -2, 28, -11, -29, -11, -2, -3, -39,
    38, -10, 52, -22, -22, -14, -73, -17,
    4, 8, 23, 0, 14, -28, 11, 8,
    8, 9, -28, -17, 11, 7, -15, 19,
    -32, -1, -14, -12, 8, 7, -8, -15,
    -11, -53, -4, -5, 26, -15, -15, 72,
    2, -7, -25, 3, -4, 44, -38, -43,
    1, -24, 25, 21, 0, 2, -1, -15,
    -30, 7, -34, -51, -11, -27, 6, 1,
    8, -13, 47, -30, -9, 34, 7, -2,
    14, -15, -4, -5, -8, -15, 0, 23,
    -8, -4, -5, 46, -7, -6, -2, -8,
    4, 1, 0, -9, -9, -12, 18, 22,
    -39, 11, -41, 14, 1, 29, -37, -20,
    -3, -10, -7, -10, 12, 3, 8, 6,
    -1, 27, 15, 12, -4, -3, 11, 3,
    38, -7, 8, 4, -13, 4, -5, 7,
    -5, 12, 23, -18, 25, 10, 23, -6,
    0, -11, 16, -2, 15, 3, -55, 32,
    -24, -20, 85, -45, 7, 13, 16, -2,
    14, 7, 2, -16, 11, 2, 11, 17,
    9, 10, 41, 20, 31, 4, 6, -28,
    -1, -15, -10, 26, -44, -8, -7, -3,
    11, 4, -22, -38, 7, 0, 0, 6,
    6, -22, -5, 38, 10, 20, -29, 13,
    -42, 3, -8, 24, -7, 7, -2, 3,
    -5, -12, -5, 8, -18, 29, 18, -15,
    -8, 31, 5, -8, -3, 5, 2, -17,
    14, 0, 27, 32, -24, 5, -5, 18,
    2, 19, 18, -19, 5, 35, -14, 50,
    -2, 9, 18, 2, -35, 0, 40, -7,
    -12, -13, -19, 10, 9, 6, -9, 4,
    -22, 61, 2, 38, 5, 12, 2, 4,
    -1, 5, 12, 18, -33, 49, 43, -24,
    2, 4, -38, 22, -9, 2, -17, -39,
    -28, -15, 45, 27, 0, -5, 13, 1,
    16, 32, -30, 14, 4, -11, -8, 14,
    -53, -29, 12, 23, 44, -30, -22, 31,
    19, 14, 38, -29, 11, 3, -19, 43,
    9, -1, 23, 14, 6, -14, 35, 10,
    -10, -36, -24, 29, 22, 12, 15, -29,
    -2, 57, 37, -25, -14, 8, 52, -19,
    12, -18, 6, 6, -5, -30, 13, -14,
    10, 1, 36, -21, 9, 18, 2, 29,
    17, -10, 4, 14, 2, 13, 19, -4,
    -8, 8, 13, -44, -9, -27, 12, 23,
    28, 0, 16, -5, 67, -36, 4, -32,
    -35, 6, -17, -16, 22, 2, -7, -7,
    -33, -25, -27, -51, 9, 13, 10, 1,
    5, 12, 59, 22, -28, 14, 18, -32,
    5, -9, 0, 8, -15, -23, 0, 65,
    7, 13, 3, 24, -9, -4, 15, 14,
    -3, -1, -18, 39, 18, 16, -2, 11,
    21, -25, 18, 16, 1, 13, -31, -27,
    3, 16, 6, 1, -13, -55, 5, 7,
    -15, 3, -30, -11, 23, 28, -22, -6,
    20, 1, 3, 22, 6, -27, -19, 6,
    28, 51, 0, -22, 29, 12, 84, -33,
    5, 4, -21, 15, 34, 13, -10, -30,
    -15, 6, 7, -2, 5, -9, 5, 7,
    -17, -9, -21, -3, 3, 28, 18, 11,
    -10, -29, -2, -6, -27, -25, 6, -26,
    6, 21, -7, -9, 10, -30, -5, -3,
    -20, -30, 31, 27, -10, -4, 8, 13,
    -24, -20, 0, 31, 0, 32, -15, -31,
    20, -36, -16, 40, -12, -57, 22, 52,
    -29, -4, 20, 4, -11, 16, 25, 50,
    22, -18, -8, -51, 25, 12, -11, -4,
    8, 10, -16, 35, -22, 25, -1, 13,
    6, -46, 17, -33, -19, -43, 17, -40,
    37, 2, -23, -20, -28, -9, 15, -51,
    -13, -1, -17, -9, 5, -4, 9, 3,
    -44, 5, -8, 16, 24, -3, -29, 20,
    -16, -26, 9, -20, -25, 17, 14, -6,
    -2, 0, -3, 26, 1, -39, 22, 51,
    -21, 3, 1, 17, 1, 6, -9, 7,
    8, 7, -1, 15, 22, 3, 39, -11,
    14, 30, -26, 16, -35, 28, -4, -12,
    -2, 1, 17, 30, -35, -12, -13, 11,
    4, 4, 15, -15, 19, -6, -27, 3,
    15, 3, -8, -2, -56, -30, -30, 76,
    -11, -8, -9, 92, 46, 25, -8, 15,
    10, -28, 14, 11, 9, 2, -49, -25,
    -14, 8, 0, -13, -4, 0, -2, 5,
    1, 17, 18, -17, 18, -23, -6, 12,
    38, -20, 21, -21, -25, 11, 16, -20,
    5, 20, -14, -8, 20, 68, 0, 35,
    -24, -45, -1, 40, -5, 3, 2, 1,
    0, -33, 13, 21, -17, 20, -6, -13,
    17, 15, 17, 38, 2, 24, 12, -43,
    5, -1, 2, -14, -2, 90, 1, 37,
    -13, -4, 10, 22, 2, 8, 22, -4,
    -27, 3, -4, 0, 1, 9, 28, 5,
    -24, 11, 58, -25, 21, 51, -44, -11,
    18, 53, 20, -14, -7, -36, 50, -7,
    3, 21, 25, -34, -13, -24, 15, 10,
    41, -38, 36, -8, -19, 24, -28, -1,
    -29, -43, -1, -15, 9, 13, -4, 70,
    -3, 10, 21, -4, 19, -36, 19, 21,
    18, 27, 18, -20, 5, 13, 21, 11,
    -8, 24, -7, -13, -1, 17, -4, -3,
    -27, 32, 34, 37, -34, -11, -62, -8,
    -4, -28, -27, 11, -30, -62, -25, -20,
    -27, 37, -38, 24, 0, 2, -6, 14,
    -16, -28, 5, 16, -4, 6, 21, 0,
    19, -40, -25, 2, 27, -15, 38, -7,
    -10, 27, -17, 31, 3, 19, -63, -17,
    23, 23, 8, 10, 9, -5, -2, 7,
    12, -12, -1, 1, 10, -12, 14, 27,
    -35, -6, -19, -30, -36, 25, 9, -16,
    -2, 15, 2, 3, -12, -50, -7, 34,
    10, 19, -12, 17, -13, 7, 10, -4,
    -4, -9, -20, -3, 20, -32, -24, -20,
    32, 44, -1, 13, -10, -6, 14, -10,
    10, -31, -15, 8, 10, -9, -7, -8,
    -48, 10, -23, 13, -3, 4, 1, 0,
    -4, -18, 33, 0, -19, -5, 16, -23,
    -7, 0, -5, 10, -4, -44, 7, -27,
    -13, -24, -12, 2, 13, -10, 19, 53,
    -4, -14, -7, -10, 7, -8, 2, 4,
    32, -26, 9, 2, 28, -13, -9, -10,
    -9, 22, -44, -21, -39, 1, -64, -40,
    18, -11, 21, 0, 21, -5, -26, -25,
    10, 4, 15, -14, 2, -2, -16, -24,
    9, 13, -51, -4, -21, 21, -11, -28,
    4, 12, -16, -29, 3, -57, -46, 10,
    27, 16, -9, -4, 10, 6, 44, -29,
    0, 18, -25, -8, 0, 7, 5, 0,
    11, -1, -13, -41, 25, 56, 9, -52,
    6, -24, -16, -56, -14, 8, -32, 9,
    20, 18, 20, 2, 17, 9, 35, 28,
    20, 8, 21, 9, 23, 3, 16, 6,
    -23, -7, -13, -5, 24, 35, -16, -4,
    19, -44, 55, 66, -3, -30, -43, -81,
    10, 9, 18, -10, -21, 39, -31, 27,
    -9, 22, -2, 7, 16, -16, 26, -14,
    29, 22, -11, -29, 2, 14, -26, 16,
    -17, -10, -16, 23, 10, -3, -11, -5,
    12, -7, 2, -38, 10, -23, -13, 12,
    2, 2, -2, 15, -6, 6, -12, -2,
    -7, -2, -35, -32, 9, 32, 16, 39,
    7, 5, -2, 19, 24, -2, -8, -56,
    3, -2, 11, 3, -15, -30, 75, 22,
    23, 0, -3, 13, -4, -25, 13, 10,
    -23, -7, -13, -3, 1, 17, -34, -4,
    -29, -25, 7, 11, 13, 31, -35, 16,
    -7, -28, -10, -2, 34, -25, -4, 18,
    -20, 8, 55, -22, 20, 5, 8, 4,
    -13, -8, 14, -11, 6, -3, 18, 8,
    -40, 1, 12, -28, -17, 22, 57, 23,
    7, -15, 28, 26, -46, 1, -27, -2,
    -7, 29, -7, -68, 17, -5, -13, 12,
    1, -20, -25, -17, 8, 3, -34, 9,
    -6, -12, 20, -83, 35, -60, -8, 36,
    -8, -3, -5, 14, -8, 9, 24, 9,
    -20, -13, -4, 3, -6, -9, 17, -2,
    11, 10, -23, 9, -18, 14, 3, 2,
    43, -20, -22, -30, 6, 41, 2, 47,
    4, 23, -27, -4, -17, -51, -17, -19,
    -8, -11, -7, 4, 6, -10, -19, -10,
    -2, -8, 25, -16, 6, 2, -17, -1,
    -17, -13, -6, 2, -51, 35, 5, 34,
    3, 11, -7, -9, -16, -6, -14, 36,
    -1, -3, 30, 11, 3, 26, -12, 15,
    -11, 22, -16, 4, -38, 7, 23, -9,
    -10, -58, -41, 11, 47, 5, 4, -66,
    -14, 25, 8, 9, -13, 40, 3, 66,
    8, 24, -8, 9, -8, -21, 20, 2,
    -1, -20, 24, 29, -16, -15, -22, -41,
    -43, 46, 38, -34, -35, -48, 19, -8,
    20, -13, 10, -8, 4, -38, 5, -13,
    37, 9, 41, -16, 15, 0, 7, 19,
    25, 13, -12, -7, 14, 15, 8, -4,
    7, 11, 19, -21, 27, -5, -28, 12,
    2, 13, 15, 12, 13, -19, 4, -5,
    -51, -64, 12, -14, 40, -2, -12, 5,
    -21, 35, -22, 44, 16, 11, 39, -10,
    21, -6, 68, -32, 18, 26, 15, 3,
    4, 52, 15, -29, 37, -53, 9, -64,
    5, 10, 81, 4, 37, -12, 7, 3,
    17, -4, 11, -15, 21, -10, 7, 31,
    57, 1, 34, 17, -39, -12, -43, -20,
    13, -12, -12, -5, 51, -14, 58, 64,
    28, 48, 40, -3, 58, 71, -21, -47,
    18, -26, -63, -44, 39, -27, 14, 6,
    -17, 26, -6, 27, -61, -3, -15, -43,
    31, 19, 24, -27, 20, 50, -30, -65,
    9, 1, -1, -40, -14, -28, 9, 20,
    -26, -25, 22, 41, -13, -3, 8, 12,
    -78, 39, -34, -17, 51, 3, 10, -2,
    30, 99, -23, 6, 17, -24, -42, -20,
    -37, 52, -19, -48, -8, 27, 7, -6,
    -27, -3, -6, -23, -21, -11, -4, 8,
    -9, 20, 32, -28, 28, 19, -40, -30,
    -8, 29, 2, 28, -67, 34, 52, 12,
    33, 46, 27, -26, 14, -21, -4, 2,
    -8, -37, -22, 61, -35, -6, -6, -27,
    29, -11, -36, -17, 15, 22, 16, -3,
    0, 46, -18, 0, 46, -21, 49, -73,
    16, 6, 38, 3, -15, -24, 36, -8,
    87, -12, -19, -44, 10, 35, -10, 75,
    10, 2, -28, 11, -34, 14, 80, -70,
    4, -23, 4, 5, 6, -57, -16, -18,
    -36, 0, -73, -9, 18, 33, 10, -27,
    66, 63, 51, 12, -1, 17, 29, -23,
    39, -16, 8, 18, -7, -12, 12, -72,
    -45, 23, 12, -35, -37, 45, -23, 25,
    7, 3, -25, -28, 16, -5, -20, -11,
    19, 49, 22, -23, -45, 2, -22, 121,
    -1, -24, -8, 94, 30, 0, 35, 24,
    -1, -11, 35, 6, -39, -28, 106, -30,
    -12, 54, -22, 21, -8, 18, 16, 5,
    77, 7, -15, -11, 45, -11, -26, 38,
    36, -7, 63, 33, 45, 61, -17, -1,
    1, 16, -13, 21, 32, 97, 34, 77,
    47, -12, 73, 26, -9, -2, -3, 3,
    -30, -16, -6, -22, -12, 11, 18, -43,
    41, -18, 19, 7, -18, -51, -16, -10,
    9, -28, -8, -7, -9, -112, 24, 7,
    76, -44, -10, 16, -3, 0, 53, -37,
    -47, -33, -20, 19, 1, 2, -1, -11,
    -10, 1, -41, -58, 32, 40, -44, 25,
    15, 37, -11, -14, 2, 40, 8, -57,
    7, -14, 4, -3, -18, -86, 32, 2,
    -9, 55, -19, -19, 1, -9, -22, -32,
    -9, 2, -22, -6, 15, 23, 33, 43,
    28, 23, 43, -22, -59, -44, 34, -17,
    17, -50, -11, -74, -7, 3, 50, 56,
    -2, -18, 20, -29, -5, -6, 9, -29,
    -23, -3, 19, -23, 37, 13, 64, -8,
    37, 5, -56, 1, 88, 39, 9, 13,
    17, -82, -3, -3, 24, -53, -10, 48,
    -4, 13, 40, -5, -6, 9, 31, 7,
    25, 65, -42, -27, -4, -14, 35, -50,
    -31, -4, -2, -7, -31, -21, 57, 0,
    -10, 40, -13, -32, 4, -10, -18, -3,
    52, -27, -7, 20, -34, -15, 15, -17,
    -48, 32, 12, 0, 17, 10, -61, 46,
    5, -10, -29, 1, -45, 48, -15, -44,
    16, -9, -44, 36, 0, 32, 20, 28,
    8, 15, -4, -12, 25, -54, 8, -5,
    53, -15, -1, 22, 10, 22, 2, 11,
    8, -78, -13, 0, 35, 37, -18, 17,
    -21, 16, -84, 10, 20, -4, -19, -7,
    58, 37, 64, 5, 8, -26, 16, 3,
    -18, -26, 11, 34, 96, 6, 19, -7,
    14, 27, -44, 11, 67, 15, 8, -14,
    -67, -5, 19, -31, 77, -15, -28, -9,
    -10, -66, -1, 28, -5, 36, 21, -4,
    4, 30, 30, -22, -58, 17, 1, -53,
    43, -30, 40, -12, 71, -16, 66, -11,
    -33, 11, -15, -75, -21, 21, -36, -38,
    -30, 32, 14, 39, -37, -47, 5, -11,
    11, 20, -10, 31, 26, 1, -40, -33,
    3, 13, -14, 32, -46, -12, 7, -48,
    46, 83, -5, 50, -12, 7, 44, 10,
    31, -26, 24, -55, 9, 87, -43, -86,
    18, -25, -92, -18, 27, -1, -5, -21,
    12, 66, 39, -13, -21, 7, -28, 62,
    -1, -10, -17, 35, 62, 9, 48, 5,
    39, 14, 24, 14, 21, 24, -41, -26,
    -64, -65, 22, 33, -62, -44, 64, -7,
    9, 22, 12, -26, 17, 47, 38, 7,
    -40, 65, -6, -43, 24, -31, -28, -53,
    -16, 2, -4, 26, 19, 17, -7, 32,
    54, 21, -8, -8, 14, -100, 19, -23,
    12, 13, -6, 10, 68, -2, 16, -48,
    -11, -11, -16, 21, -31, 4, 25, 11,
    -95, -5, -55, -21, 4, -14, 12, 28,
    -30, -9, 23, -26, -52, 32, -30, 11,
    22, 26, -23, 13, -29, -36, 58, -12,
    -22, 18, -25, 30, 7, -68, 14, 30,
    7, 34, 22, 1, -23, 10, 56, 11,
    -25, -61, 45, 3, 24, 30, -57, 68,
    -1, -8, -46, 13, -66, -19, -14, 14,
    56, -1, -67, 112, -1, 7, 20, 11,
    -83, 22, 17, -90, -28, 0, -1, -19,
    21, -5, -4, -25, 6, 27, 43, 53,
    -13, -32, 26, 3, 34, 11, -11, 15,
    -15, 12, 4, -3, 15, 7, -8, 0,
    9, 17, -14, -56, 34, 16, 1, -5,
    -8, 0, 36, -8, 19, -99, -69, -27,
    -12, -22, -13, -1, -2, 24, -15, -31,
    -11, -1, 39, -42, -20, -4, 11, -25,
    -16, -17, -26, 37, -3, 8, -29, 7,
    29, -14, -40, -15, -11, 127, 8, 50,
    10, 25, 1, 3, -5, -8, -6, -9,
    -25, -15, 5, -32, 21, 2, -37, -9,
    21, -34, 35, -27, -7, 3, -38, -6,
    -29, -35, 10, 8, -17, 20, 64, -23,
    18, -15, 57, -37, 7, -76, 9, 2,
    29, 48, -7, -18, 11, 52, -19, 0,
    -22, 1, 42, -1, -23, -25, 7, -62,
    -34, -64, 8, 53, 85, 42, -48, -80,
    -35, 18, -46, 31, -2, 100, -28, 61,
    -9, -14, 83, 9, 8, -5, 31, 4,
    58, 29, -14, -10, -18, -32, 13, -89,
    -97, 35, -39, -58, 26, 6, -11, 41,
    42, 21, 7, -7, -6, 29, 24, 7,
    -23, 13, -59, -20, -7, 1, -21, 27,
    -21, -7, -21, 11, -4, 5, 4, -62,
    -22, 33, 17, -72, -38, -70, 2, -23,
    4, 12, -17, 1, -33, 1, 12, -24,
    -30, 22, 23, 1, -3, 1, 2, 28,
    -10, -11, -11, 23, 13, 48, 7, -4,
    21, -4, 8, -37, -20, 24, 0, -14,
    11, 0, 0, -12, -4, -28, -14, -21,
    -46, -2, 15, 21, 34, -13, -1, -2,
    -15, 5, -9, -25, -43, 14, 44, -31,
    -2, 12, 17, 0, 18, 11, 9, -27,
    12, 15, 1, 2, 22, -19, 14, -13,
    -4, -17, -27, -15, 22, -3, 19, 26,
    -8, 7, 2, 5, -6, -35, 11, 4,
    -19, 8, 6, 3, -5, 9, 37, -30,
    22, -2, -7, 11, 42, 17, 13, 2,
    1, -3, -10, 3, -10, 29, 38, 9,
    -5, 16, -24, -7, -16, -1, -24, -16,
    -11, 13, 7, -12, 1, 19, 6, -11,
    -22, -4, -17, -5, 21, -6, 14, 9,
    22, 32, 13, 37, 45, -8, -18, 0,
    -29, -7, 8, -16, -41, -1, 18, 2,
    12, -20, -18, 8, -23, 37, -43, -6,
    12, 5, -15, 21, -10, 13, -20, -21,
    4, 25, -4, -6, -22, 6, -53, 23,
    -16, 5, 32, 20, 32, -25, 28, -57,
    -11, 10, 14, -7, -32, -8, 55, -20,
    17, 10, -13, -17, 22, 4, -12, -14,
    -33, 12, -5, -3, -20, 11, 9, -35,
    -7, 6, -21, 6, -18, 13, 25, -18,
    21, 13, 11, -4, 24, -32, -54, -2,
    -28, -25, 1, 20, 7, 19, 4, -27,
    16, -5, -11, 0, 17, 16, -18, 2,
    -5, -6, 7, -20, -25, 22, 6, 17,
    41, 13, -20, 28, -15, 7, -24, 35,
    -14, 9, -11, -2, -11, 47, 1, -31,
    -2, -21, 2, 3, -9, 30, -2, -23,
    6, -4, 13, -7, -5, 52, -30, -16,
    0, 34, 7, 15, 13, -25, -44, -15,
    18, 17, 12, 1, -1, 9, 32, -18,
    16, 4, -5, -16, 3, -51, 6, 5,
    15, -1, 3, 10, 5, 15, -6, -4,
    15, 5, 2, -6, -40, 3, -21, -16,
    -28, 15, 11, 5, -7, -49, -20, -15,
    -12, -15, 0, 7, 29, 21, -1, -1,
    -1, 10, 11, -24, -38, 28, 15, -5,
    -2, -35, -19, 0, -30, 19, -22, 13,
    12, -12, -3, 16, 5, -47, 9, 11,
    6, 28, -9, -6, -19, 5, 44, -9,
    3, -19, 4, -25, -40, 13, -10, 25,
    -20, 15, 4, 17, 3, -22, -8, -9,
    3, 3, 14, 6, -9, -10, -3, -9,
    -15, -18, -7, 10, 24, -48, -32, 45,
    -15, 12, -14, 9, 17, -12, 4, -29,
    11, -27, -24, -13, 20, -21, 32, 3,
    -8, 9, 3, -17, 5, -16, -19, 3,
    17, 8, 30, 12, 2, 9, 5, -16,
    16, 9, 6, 16, -48, 19, -63, -44,
    21, 5, -23, -3, -66, 3, -23, 45,
    4, 4, -2, 4, -48, -7, 24, -44,
    4, 28, -1, 32, 7, -14, 25, 4,
    7, -17, -2, -22, 37, -15, -17, 17,
    6, -23, -3, -3, -18, 27, 0, -9,
    10, 4, 11, 8, 30, -14, 13, 19,
    -2, -23, -9, 35, 20, 9, -9, 12,
    -4, 4, -21, 11, -12, -29, -15, -5,
    6, -9, -5, 13, 7, -9, -25, 28,
    -12, -10, -4, -14, 13, 33, 2, -4,
    5, -3, 21, 7, -37, 21, -34, 1,
    1, 16, -17, 3, 5, 0, -48, -22,
    14, -9, 13, 11, 19, 18, 10, -20,
    -11, 5, -14, -12, -5, 1, -36, -14,
    -2, -11, 9, -1, 0, -1, -9, -25,
    6, -1, -8, 14, -11, 13, 7, -1,
    9, 5, -22, -10, 44, 13, -56, -32,
    8, -1, -3, -7, 21, 13, -3, -21,
    -11, 6, -17, 12, 11, -1, -19, -4,
    20, 16, -2, -9, 44, 1, -36, -2,
    -4, -24, 48, 12, 26, 30, 27, -36,
    15, -5, 26, 12, -9, -9, -4, 2,
    -20, -3, 10, 10, 40, -22, -43, -1,
    32, -15, 7, 30, -32, -3, -30, 3,
    17, -5, -1, 4, -20, -23, 6, -13,
    2, 23, -21, 8, -2, 22, -17, 48,
    10, 0, 24, -5, -2, 11, -13, -1,
    3, -2, -16, 9, -22, 0, 25, -6,
    7, -12, 10, 4, -2, -14, -18, -10,
    13, -6, 3, 1, -5, 10, -11, -19,
    -18, 11, -14, -35, -13, 9, 19, 20,
    31, -2, 4, 6, 22, -7, 25, 59,
    -14, -6, 10, 8, -20, 0, -20, 11,
    -12, 21, -9, 8, -22, -9, 11, 5,
    19, 10, 16, -2, -12, -26, 3, -39,
    -15, -13, -7, 1, -21, 56, 2, 4,
    8, -13, -5, -30, 40, -1, 12, -54,
    -4, -4, -11, -2, -2, 11, -8, -39,
    -12, 19, 9, 3, -18, -5, 21, 10,
    9, -20, 11, 12, 22, 6, -1, -5,
    -17, 13, -4, 13, -27, -9, 18, -46,
    -4, 15, 16, -17, 24, -4, -19, -4,
    26, -1, -4, -19, 7, 1, 37, 0,
    8, 19, -17, -3, -3, -4, -19, -6,
    -8, -18, -37, -1, -31, 5, 33, 17,
    2, -3, 11, 17, 40, -14, -1, 9,
    17, 14, 8, 28, -1, -14, 33, 4,
    -11, -5, -5, -4, 22, -30, 59, -8,
    17, 18, 25, -8, 44, -16, 70, -9,
    24, 14, 3, -2, -28, 10, -2, 20,
    3, 21, 13, 0, -3, -4, -8, 12,
    0, -4, -15, -8, 5, -8, 18, -36,
    17, 1, 9, 39, 14, 18, 13, 9,
    14, 1, 20, -7, -12, -19, -4, 3,
    6, -11, 24, 8, 0, -1, 3, -4,
    -6, -6, -8, 40, 6, 14, -31, -41,
    -5, 13, -31, -21, -10, 2, -2, -23,
    -5, -8, -9, -7, 3, 14, -23, -24,
    8, 16, -24, 6, -4, 12, -28, 19,
    1, 31, 5, -9, -60, -29, -4, 8,
    40, -26, -2, 15, 5, -15, -32, 62,
    -8, 8, -11, 5, -1, 8, 1, 34,
    11, -18, 16, 9, -19, 30, -37, -15,
    -13, 4, -7, 14, 37, -9, -16, 14,
    -7, 9, -5, 4, -24, 37, 34, 37,
    24, 1, 16, -1, 1, 14, 10, 1,
    -7, 10, -8, 9, 14, 43, -24, 13,
    16, -12, -3, 18, -10, -44, 12, 15,
    36, 13, 0, -24, 14, -14, 10, 12,
    4, -8, -12, -7, -11, 35, -23, 11,
    25, 33, 6, -6, -2, -2, -54, 34,
    3, 24, -3, 6, 11, -9, 44, -10,
    16, -8, -11, -24, -43, 1, -19, 16,
    -5, 16, -6, -7, 4, 11, -40, -1,
    4, 36, 7, 20, -25, 27, 25, 11,
    -9, -21, -6, 2, 8, 7, 26, -64,
    45, -19, -22, -40, 7, 76, 1, -3,
    7, 23, -1, -18, -8, -28, -16, 31,
    -18, 17, 6, 9, 36, -11, 10, -3,
    -23, -28, -18, -11, -13, 3, 8, -1,
    15, 14, -1, -29, -3, 36, -37, 20,
    -10, 8, -11, 14, -7, 7, -3, 9,
    -19, -56, -25, 20, -9, 22, 5, 24,
    -26, 23, -34, 31, 5, -1, 4, 6,
    -21, -42, -21, 8, -45, -33, 10, 78,
    7, -14, 1, 29, 30, 2, -39, -36,
    11, 6, -2, -4, -8, -15, 11, 20,
    -6, -10, -5, -10, 7, -11, -19, -21,
    -10, -8, 19, 13, 15, 14, 20, -27,
    -20, -25, -8, 17, 4, -1, 16, 15,
    15, 27, 0, 11, 25, 11, -32, 16,
    4, 3, 36, 15, -51, -23, 48, 13,
    -2, -25, -6, 32, 43, -3, -12, 34,
    0, 12, -12, -11, -37, -35, -19, 11,
    -6, -10, -15, 8, -13, 22, -65, 29,
    7, -5, 9, 2, 23, -2, -2, -54,
    23, -15, 14, 38, 2, 43, 29, -12,
    8, 14, -1, -6, 30, -17, -11, 6,
    -19, 20, 9, -3, 19, -10, -2, -19,
    5, 6, 11, -18, -33, 58, 0, -31,
    -7, 15, 24, 7, -2, -33, 58, -27,
    -13, -16, 29, 7, 10, 14, -26, -23,
    8, 18, 12, -15, 33, 18, 13, 6,
    28, -15, 15, -10, -37, 78, 3, 5,
    51, -7, -21, 22, 8, -36, -65, -2,
    -2, 3, -3, -7, -26, 36, 0, -8,
    8, 13, -17, 13, 18, 17, -5, -16,
    6, -13, 38, 2, 10, 15, 12, -6,
    1, 52, -12, -1, -2, -6, 53, 2,
    -3, 10, 2, -9, -9, -17, -7, -5,
    -15, 12, 19, -5, 3, -42, 0, 13,
    -5, -2, 3, 19, 1, 27, 13, -3,
    -3, -27, 21, -11, -19, -15, -38, -3,
    -1, 5, 12, 5, 10, -50, 0, 1,
    -27, -24, -8, 18, 16, -4, -5, 1,
    -1, 8, 9, -14, 39, 11, 16, -9,
    8, 1, -8, 10, -16, -24, -15, -9,
    7, 1, 4, 15, -2, -43, 3, 14,
    -15, 45, 3, 15, -12, -24, 71, -26,
    2, 19, -5, -11, -65, 24, 35, -8,
    -33, 26, -5, 10, 5, 27, -17, -5,
    -1, -27, 10, -3, -27, 14, 60, 8,
    -10, -11, -32, 0, 7, -29, -11, -12,
    -9, -6, -7, 37, 15, -40, 13, -33,
    -5, -39, -30, -9, 23, -52, 9, -25,
    4, 10, 20, 2, -17, 32, -16, 3,
    -7, 13, 9, 42, 11, -32, 11, 19,
    14, 4, 16, -1, -42, 49, -50, -41,
    -7, -44, -10, -2, -71, 42, 12, 19,
    -3, -18, 5, -11, 6, -40, -26, 5,
    -17, 30, -20, 34, -2, -26, 2, 3,
    -4, 4, -7, 7, 23, -27, 14, 30,
    35, 13, 28, -11, -35, -39, 47, 39,
    6, 0, 18, 1, 0, -26, 10, 23,
    -3, -29, -3, 22, 7, 9, 3, -6,
    -13, 26, -31, -26, -35, -29, -14, -24,
    -11, -8, 5, -27, -51, 64, -33, 22,
    -3, -16, 15, -17, -19, 7, 30, -7,
    0, -8, 27, 2, -31, -7, -30, 13,
    -7, 9, 7, 26, 12, -3, -127, 19,
    15, -21, 9, -4, 15, 29, 14, 21,
    -11, 6, -9, -4, -8, -3, 25, 13,
    23, 9, 27, -9, 9, 2, -1, 21,
    -1, -7, -8, -29, -55, -5, 4, -3,
    0, -16, -14, -6, -5, -15, -28, 29,
    11, -2, -11, 13, 51, 10, 27, -35,
    33, -11, 7, 6, 35, -20, 28, 16,
    -8, 7, -24, -12, 51, 68, 14, -21,
    -14, -20, 0, 14, 5, 17, 7, 5,
    -3, -8, -7, 2, -52, 16, 9, 2,
    -36, 12, -20, -10, -20, 8, -3, -10,
    -11, -14, -10, 6, -51, -25, -13, 67,
    2, 11, -6, 22, -38, 11, 62, 4,
    -11, -8, 9, 33, -7, 8, -52, -35,
    9, -1, 24, 20, 2, -10, 52, -21,
    6, 28, -19, -6, -58, -8, 48, 11,
    6, 14, 4, -10, -34, 37, -28, -24,
    4, 11, -1, -23, 19, 6, 21, -16,
    3, 18, -23, -1, 3, 19, 0, 31,
    -3, 6, 5, -4, 30, 20, 31, 5,
    9, 6, -5, 15, 20, 11, 23, 76,
    5, 18, -13, -1, -17, -6, -17, 45,
    19, -34, 32, -25, -22, -6, 35, 15,
    12, -5, -34, 6, -42, 23, 1, -25,
    -4, 8, 3, 1, -23, 43, 0, 39,
    -12, 23, 7, -2, 8, 5, -10, 2,
    -16, 31, -6, -6, -25, 4, 49, -15,
    0, -25, 25, 21, 33, -23, -66, -34,
    -49, 5, -23, 11, 2, -27, -8, 34,
    -9, 15, -4, -7, 0, -9, -6, -24,
    4, 4, -5, -13, -16, 5, 31, 16,
    -10, -8, -2, 1, -66, -22, -14, 0,
    -14, -14, 0, 10, 13, 6, -50, -3,
    5, -6, 21, 6, -36, 21, 16, -10,
    -7, 18, 24, -4, -3, -15, 6, 17,
    -20, 10, -20, 10, -42, -15, 10, -19,
    19, 5, -6, -12, -63, 10, 12, -45,
    3, 5, 7, -11, 48, 22, 16, -16,
    9, 32, 6, 6, 9, 38, 3, -17,
    -6, 0, -12, 7, 28, -17, 11, -46,
    6, -1, 10, 15, -9, 22, 11, -83,
    0, -1, 6, -3, -16, 1, 29, 10,
    6, -6, 1, 11, -3, 1, -6, -2,
    7, 6, 21, 12, 0, 17, -31, -16,
    11, -11, -4, 4, -3, -5, -26, -25,
    -7, 5, 14, 11, 7, 14, 2, -7,
    1, 2, -11, -13, 4, 7, 2, -9,
    1, -4, -6, -13, -18, -47, 2, 42,
    45, -10, -4, -5, 12, -2, -10, 19,
    19, -12, 3, -13, 9, -5, -18, 13,
    -15, -8, 9, 24, 44, 29, -23, -2,
    5, 0, -15, 19, 89, 9, -8, 9,
    6, 11, 12, -3, -26, -3, 26, -16,
    -2, -7, 0, 5, -14, 5, -29, 9,
    -9, -18, 10, -7, -2, 9, -23, -10,
    28, -3, -9, -1, 0, 17, -16, 25,
    32, 6, 23, 8, 10, 33, 62, 34,
    18, -1, -3, 14, -1, -2, 4, 8,
    23, 11, 12, 13, -2, 6, -11, 17,
    -11, 24, 3, -14, 26, -1, 12, -26,
    1, -13, -3, -7, 1, 26, 13, -5,
    9, -1, -12, -2, -32, 15, 17, -9,
    25, 5, 2, -16, -28, 31, 33, 82,
    51, -42, -14, -46, -18, 57, 22, 40,
    45, -1, -23, -30, 8, -34, 18, -24,
    -59, 47, -11, 23, -13, -29, -19, 45,
    6, 26, 8, 29, 31, 24, -15, -24,
    -14, -6, -29, -10, 8, -9, -17, -97,
    11, 15, 14, -60, 23, -2, 15, 26,
    8, -24, -32, -23, -1, 5, -17, 0,
    -46, -83, -8, 21, 14, 6, 27, -8,
    -26, 4, 2, 17, 56, -35, -44, -62,
    -43, -86, -3, 15, -21, 33, 23, -56,
    59, -4, -2, -30, 4, -60, -24, 63,
    -6, 37, -39, 9, -22, 34, -6, -15,
    -21, -13, -10, -68, 9, 4, -10, 20,
    15, -28, -11, 15, -61, 0, -52, -77,
    18, 13, 22, 38, 7, 17, -21, 29,
    23, 10, 31, -1, 45, 62, -6, 51,
    -20, -64, 54, -78, -64, 39, -22, 109,
    -16, -39, -10, 35, 15, -28, 22, 18,
    0, 18, -33, -9, -21, -37, -11, -2,
    -12, -69, -17, -13, -31, -98, -88, 31,
    -19, 41, -23, -2, 57, -34, 46, -44,
    -20, -21, 37, 8, -1, -34, 6, 37,
    -1, 11, 28, 0, -19, -30, -39, -38,
    -22, -6, -12, 18, 57, -14, -86, 14,
    -2, -6, 92, -20, 20, 81, 35, 1,
    -10, 31, 18, 35, 2, -15, 38, 23,
    24, -24, -28, -6, -11, -4, -3, -7,
    -11, -10, 8, -14, 21, -17, 27, -18,
    -14, 13, -7, -26, -23, 57, -16, -4,
    69, -24, -36, 11, -57, 67, -11, -45,
    7, -41, 8, -22, -13, -27, -4, 29,
    18, 13, -19, 0, 28, -1, -11, -16,
    -9, 17, -15, -1, 10, 56, 6, 0,
    6, 71, 14, -10, -12, 30, 39, 26,
    -10, 20, -19, -2, 8, -17, -28, 21,
    -27, 5, 43, 15, 9, -101, -31, 5,
    -3, 0, 11, 3, 38, -12, -11, 13,
    -38, 12, 22, -30, 13, -67, 55, 15,
    -4, -13, -10, 3, -20, -77, -4, -8,
    -29, -1, -7, 30, -40, 32, -46, 15,
    9, 11, -13, -5, 19, -7, 6, -8,
    -3, -31, 13, 2, 12, 27, 11, -77,
    -23, -33, -23, 27, -43, 20, 17, 17,
    0, 43, -6, 23, -7, -34, 11, 0,
    35, 85, -89, 4, -36, 32, 29, -11,
    -13, 28, -20, -32, -12, -54, 23, -56,
    22, -28, 3, 14, -15, 40, -61, -11,
    -23, -28, -33, -7, 35, 74, 11, -10,
    -10, -21, -45, 75, 9, 28, 55, -95,
    -9, -45, -7, -39, 5, 11, -57, -8,
    -50, 58, 112, 17, 71, 15, 35, 8,
    -31, 30, -14, 40, -69, -36, 28, 37,
    6, -4, 21, 17, -80, -22, -61, -30,
    4, 6, 16, -20, -37, -49, 28, -54,
    -9, -17, 3, 4, -79, -50, -13, 11,
    -14, 37, -3, 35, -19, 93, -41, 25,
    40, 1, -10, -48, -11, 36, 28, 12,
    19, 29, 46, 24, 52, -32, -26, -3,
    -28, -8, -18, -19, -34, 47, -15, -4,
    -15, -13, 11, -33, 4, 11, 0, -21,
    -4, -24, -5, 14, -27, 25, 9, 2,
    5, 19, -3, 32, -44, -6, 8, -5,
    15, -1, 37, 27, 5, 0, 22, 40,
    -3, -19, 49, 14, -17, -43, 55, -31,
    -8, -17, -40, 57, 1, -38, -72, 42,
    5, -20, 18, 9, 0, 13, -60, 5,
    -37, 7, 31, -28, -3, -21, 20, 6,
    23, -18, -40, -10, -24, -11, 1, 3,
    11, -41, 45, -20, -51, 87, -41, -42,
    -55, -21, -36, -23, 34, -65, 43, -22,
    -25, 27, -9, -43, -9, -8, 18, 35,
    0, -1, 6, 29, 60, -1, 3, 18,
    -40, -39, -68, -16, 15, 57, -57, -16,
    18, -4, -2, -12, -13, -3, -71, 10,
    52, -2, -6, -7, -24, 11, 33, 32,
    -46, 21, -11, -7, 14, -14, 45, 22,
    55, 8, -80, 3, -53, -9, 27, 3,
    52, -15, -19, 4, -32, -17, -32, 64,
    -3, 2, 29, -68, 54, 3, 2, 17,
    28, 21, 3, 28, -11, 5, -14, -30,
    34, 58, -29, 1, -39, 32, 29, -4,
    -8, 0, 48, 12, 4, 73, 11, -13,
    -18, 11, -20, -9, 7, -16, -10, -20,
    -47, 26, 7, -37, -15, 15, -12, -64,
    -33, 20, 13, -3, -42, 3, -10, 39,
    21, -3, -17, -12, -88, 43, 3, 38,
    25, 10, -15, -49, -1, -20, 3, 22,
    6, -22, 10, -14, 13, 44, 40, 80,
    -28, -43, -2, 7, -46, 14, 17, 38,
    12, -36, 18, 0, -35, 40, -67, 52,
    1, 88, 10, 3, 6, -10, 21, -44,
    -5, 33, -18, -17, -4, 57, 51, 10,
    29, -51, 0, -27, 18, -29, -35, -5,
    -22, 21, 4, -18, 20, -50, 11, -23,
    12, 42, -17, 2, -17, 13, -24, -23,
    -38, 4, 15, -22, 72, 33, 7, -18,
    -66, -63, 45, -7, -70, 27, -92, 16,
    -26, -2, 22, -18, 67, 10, 76, -15,
    -23, 30, 26, 33, 7, -29, 23, -10,
    46, 15, -2, 1, -21, 11, 12, -1,
    43, -15, -30, -51, -27, -28, 97, -5,
    8, 6, -7, 7, -60, -13, -57, 20,
    21, -101, 28, 22, -7, -7, 14, -28,
    0, 5, 7, -27, 17, 13, 13, -15,
    2, 32, 0, -34, 33, -47, -11, 7,
    6, -13, -24, 0, -7, -35, 24, 69,
    1, -30, -10, -12, 5, 43, 30, 22,
    1, -11, -9, 43, -9, -7, -24, 41,
    -6, -33, 5, -3, -5, 44, -36, 24,
    1, 30, -9, -33, 7, -12, -1, 18,
    -10, 12, 26, -15, 16, -2, -14, 12,
    10, -10, 7, -36, 7, 41, -13, 28,
    9, -42, -22, -25, -25, 41, -3, 42,
    47, 65, -11, -6, -14, 60, 18, 12,
    78, 18, -1, 40, 48, 35, -4, 10,
    14, -19, 25, -1, 25, -37, -3, 24,
    -77, 5, -6, 37, 48, -20, 34, -1,
    3, 29, 21, -32, 45, -25, -14, -26,
    -5, 10, -28, -2, -9, -21, 6, -11,
    -42, -20, -3, -19, -14, -22, -34, -21,
    15, -14, -16, -23, 72, 14, 3, 35,
    104, -11, -20, 0, -65, -9, -41, -11,
    5, 10, 45, 1, -24, 13, 17, -6,
    -4, 37, 35, -4, 14, 18, 53, 10,
    5, 17, -14, 1, 53, -25, 62, -29,
    0, -35, 16, -15, 14, -7, -20, 2,
    18, -40, 22, -3, 15, 11, -7, -18,
    18, 5, 27, -21, -37, -12, -17, 3,
    -4, 8, 0, -8, 3, 14, 12, -39,
    7, -21, 1, 5, 4, 14, -2, -14,
    13, 9, -19, -34, 18, 53, 7, -65,
    19, 4, -9, 3, -12, 32, 11, -29,
    12, 1, 2, 0, 44, 21, -1, -1,
    24, -5, -8, 3, -18, 11, 34, -35,
    3, 2, 27, 3, -18, 41, 23, 46,
    61, 3, -8, 18, 23, 17, 22, 16,
    24, 6, 24, 23, 64, -12, 42, -45,
    16, 5, 18, -4, 3, -26, 7, -31,
    -8, 19, 14, -14, -59, -5, -20, 8,
    -15, 5, 10, -12, 34, -2, -10, 7,
    -2, -11, 16, 6, 21, 47, 27, -12,
    13, -8, -3, 6, 1, 19, -1, -8,
    -20, -24, 20, 18, -9, 13, 27, -9,
    -31, -34, 45, 8, 8, 23, -28, -14,
    2, -28, 13, -17, -17, -3, -4, 9,
    12, -4, -7, -17, -18, 46, 29, 29,
    -17, -28, 28, -17, -19, 24, 16, -31,
    -9, -25, 2, 37, -37, -22, -11, 76,
    13, -13, -10, 2, 2, -12, -2, 47,
    29, 9, -6, -6, 3, -28, -7, -17,
    11, 25, -5, 29, -23, -25, -16, -4,
    58, -18, 23, 3, -17, 4, 6, -12,
    21, -23, -22, -6, -30, -31, 10, 3,
    -21, 2, -14, -10, 29, -25, 11, 8,
    26, 34, 44, -7, -2, -6, 11, 41,
    21, 17, 12, 15, -8, 12, 34, 5,
    -25, 5, -3, 3, 4, 24, -28, 2,
    1, 12, 4, 14, -2, -12, 8, 13,
    18, -13, -8, 19, 51, -24, 46, -41,
    -66, -27, 16, -3, -3, -3, 25, -21,
    -14, -6, -9, -2, -13, -47, 15, -16,
    -1, -10, 16, -8, -47, 35, -54, -9,
    -71, 5, -3, 18, 3, -36, -4, 5,
    35, -10, -5, 28, 16, -71, -13, 11,
    21, -9, -22, 20, -28, 42, 46, 27,
    4, 3, -6, -5, 19, -20, -16, 33,
    40, -46, 12, -15, 55, 18, 19, 13,
    11, 11, 11, -32, -4, -11, -5, 6,
    2, 9, -3, -26, -35, 4, -10, 31,
    3, -11, -15, 19, 24, -22, 28, -13,
    4, 0, 3, -5, 20, 15, 18, -25,
    -11, 25, -8, -16, 10, -47, 13, 4,
    25, 4, -29, -21, -14, -51, 10, 6,
    21, -22, -7, 14, 23, 51, 1, 1,
    11, 22, -5, -24, -70, -1, -47, 9,
    18, 11, -11, 8, 37, 2, -20, -17,
    20, 24, 1, 20, 1, -37, 6, 9,
    -16, 2, -2, -3, 6, 0, -26, -19,
    6, -13, -29, 13, -32, 25, -38, -68,
    25, -14, 24, 10, -29, -24, 13, 1,
    26, 0, 12, -1, 69, -14, 23, 4,
    11, -3, 17, -5, -10, 3, -31, -45,
    -45, -19, -23, -16, 29, 53, -19, -12,
    -17, 27, 16, -12, -18, 4, 17, -4,
    3, -9, 5, -7, -12, 0, 51, -38,
    -9, -3, 16, 11, -16, 9, 3, -15,
    -17, 61, 26, -6, -4, 9, 29, 15,
    5, -6, 11, 6, 8, -28, -16, 54,
    -10, 12, 25, 31, 31, -14, 17, 9,
    -3, 12, 11, 20, -3, -5, -21, -5,
    45, 2, -24, -25, -32, -49, 14, -11,
    10, -8, 17, 2, 6, 19, -19, 5,
    -1, 1, 23, -26, 16, 46, -32, -26,
    0, 12, -19, 7, -13, -15, -22, 18,
    -26, -37, 55, 22, 30, -19, 57, -8,
    7, -15, -23, -23, 44, -10, 34, 11,
    2, 6, 4, 16, -8, -5, -33, 16,
    3, 9, 2, 6, 5, 2, 17, -12,
    21, -1, 33, 19, -18, -43, 42, -45,
    36, 0, 47, -36, 28, -44, -20, 13,
    -27, 29, 20, -14, -34, 10, -39, -48,
    9, -4, -19, -6, 10, -10, -9, -3,
    33, -3, 9, 43, 13, -3, 19, 29,
    -21, -14, 16, 6, 27, 21, -35, 70,
    18, -27, -9, 26, -18, -16, -25, 21,
    -26, -3, -11, -2, 4, -2, 10, 3,
    -42, 52, 3, 18, -41, -21, 28, -2,
    -3, -25, 31, 9, -12, 4, -6, -26,
    -11, -30, -5, -13, 10, 37, -80, -36,
    -14, -14, -10, -13, 3, -6, 42, 1,
    11, 108, 21, 15, 71, -19, 35, 21,
    26, 6, 25, 57, 3, 24, -4, 28,
    -21, 8, 3, -25, -10, 14, -58, 16,
    13, 2, -2, -5, -23, 7, 11, -15,
    36, 24, -15, -7, -1, 22, -65, -8,
    28, 17, 43, -66, 5, -35, 0, 0,
    -14, 8, 6, -25, 16, -15, 14, -5,
    1, -10, -4, 6, 14, -4, -1, -12,
    8, 29, -15, -13, 58, 22, -25, -13,
    -15, -7, -6, 20, -30, 6, 16, 36,
    -21, 6, 44, -15, 6, 20, -18, -21,
    -23, 18, 3, 4, -7, -23, -8, 12,
    10, -15, 39, -2, -23, 10, 42, -15,
    -36, 6, 15, -21, 1, 28, 18, 19,
    17, -3, -5, 0, -8, 13, 23, -6,
    22, 6, 19, 6, 0, 18, -34, -32,
    -23, -2, 55, -70, 26, 29, 20, -11,
    -20, 11, 9, -12, -11, -1, 0, -23,
    -17, 3, 20, -33, 48, 19, 69, 6,
    16, -4, 5, 18, -1, -14, 1, -10,
    15, -2, -5, -8, -40, 38, -26, -33,
    15, 3, 1, 28, -10, -10, -7, -5,
    6, -8, 0, -30, 26, -14, 12, -51,
    1, -4, -6, -10, -18, 14, -33, 41,
    25, -4, -1, 41, -2, 56, 60, -12,
    27, 5, 3, -20, 47, 9, -19, -1,
    -1, 18, 19, -5, -7, 21, -45, 25,
    -2, 11, 6, 5, -11, -14, 25, 48,
    -46, 14, 5, -8, 4, -37, 14, 44,
    22, 24, -16, -39, -9, -4, -5, 42,
    13, -2, -12, 1, -13, 11, 23, 2,
    25, -16, 12, 6, 18, -3, 26, -65,
    -1, -21, -83, -30, 8, 39, 41, -70,
    16, 2, 5, -17, 4, 8, -20, -32,
    -4, -15, 11, 15, 3, -13, -5, 34,
    22, 0, -15, -8, 25, 19, -33, -36,
    25, 17, 4, -65, 30, -25, 30, -8,
    -5, -14, -1, -40, 10, 11, -30, 50,
    -15, -5, -13, 1, -35, 0, 0, 7,
    13, 14, 1, -13, 24, -40, -28, -8,
    -2, 9, 13, 18, -15, -66, 51, -52,
    2, -26, -27, -14, -5, -7, -51, 41,
    1, 3, -6, 2, -3, 5, -56, 23,
    -16, -7, -2, 15, -11, 23, 28, -3,
    -29, -4, 25, -63, 35, -13, 57, -6,
    -7, 7, -15, -38, -20, 13, -10, -25,
    2, -18, 6, -7, 18, 28, 5, -32,
    -6, 0, -6, -15, 15, 19, -17, -1,
    16, -33, -35, -28, -16, 42, -18, -39,
    16, 25, -7, -20, -23, -3, 12, -25,
    13, 17, -12, -22, 17, 11, 22, -4,
    28, 4, -13, 27, 14, 7, 7, -46,
    4, 9, 16, 0, 23, 17, 31, -7,
    23, 4, 16, -12, -12, 22, -11, -8,
    -7, 10, 19, -1, 76, 0, -6, -48,
    -6, -5, 6, -19, -4, -44, -20, 23,
    -38, -1, -6, 17, 8, 19, -10, 30,
    -7, -16, 8, -5, 16, -16, -4, 8,
    0, 4, -1, -12, 0, -12, 32, -3,
    -11, -8, 21, 16, 12, -2, -23, -2,
    -5, 30, -10, 8, 13, -19, 12, -8,
    16, -12, 19, -4, -7, -2, -6, 7,
    -14, -31, 10, -4, -3, 13, 10, 7,
    6, 2, -4, -15, -35, 12, 30, 31,
    1, -30, 25, 14, -44, 16, 21, 19,
    -58, -20, 10, 10, 25, -8, -25, 53,
    38, 18, -20, 7, 0, -12, -9, 37,
    14, 2, 2, 2, -33, -45, 2, -31,
    30, 20, 40, -34, 4, -32, 2, -7,
    -15, -11, 8, -11, 15, -9, 9, 13,
    10, -12, -55, -26, 7, -28, 27, -43,
    -17, -4, 3, -3, 23, -28, 0, -8,
    -20, 24, 22, 25, 22, -15, -36, -12,
    22, 24, -33, 18, -22, -11, 43, 10,
    -18, -12, 1, -10, 5, 27, -40, -11,
    -4, 10, 9, -2, 21, -8, 5, 12,
    -11, -19, 1, -10, -20, -41, 30, 15,
    -74, -5, 46, -18, 20, -2, 10, -15,
    -15, -19, -19, 5, -18, -16, -15, -14,
    2, -25, 6, -2, -46, 51, 23, -13,
    -68, -10, 14, 21, 7, -14, -9, 3,
    8, -7, 12, 26, -10, -80, 4, 26,
    5, 11, -15, -2, -25, 22, 45, -24,
    -12, 1, 13, 2, -7, -18, -7, 14,
    25, -3, 17, 14, 5, 29, 24, -30,
    20, 31, -10, -13, 12, -46, -11, 8,
    41, 13, -32, -15, -35, 34, 7, 25,
    0, -19, -13, 11, 18, -28, 19, -33,
    9, -1, -3, 11, 24, 2, 18, -13,
    -13, 26, -18, 9, 16, -26, 6, -20,
    13, 2, 4, -15, -5, -85, 47, 16,
    24, 7, -9, 17, 21, 59, -23, -12,
    -21, 29, -15, 9, -45, 12, 11, -3,
    35, 0, 11, 19, -23, 14, 12, 0,
    -8, 31, -12, -10, -11, -10, -21, -27,
    -13, 21, -22, 16, 15, -8, -36, -3,
    -11, 1, -4, -1, -8, -39, 15, -21,
    7, -5, 9, 11, -28, 18, 0, 43,
    24, 18, -15, -9, 25, -10, 23, 16,
    28, 6, 5, -1, -13, -3, 6, -27,
    10, 18, -3, -19, 39, 90, -15, 21,
    -23, -24, 15, -9, 4, 19, 8, 13,
    -14, 1, -24, -5, -13, -5, 11, -45,
    -15, -20, 34, 8, -15, 24, -1, 24,
    -10, 39, 42, 1, 3, -45, 0, 6,
    31, -23, -19, -38, -4, -4, -8, 5,
    19, 2, 24, 30, 38, -65, 36, -3,
    -1, -1, 13, 23, 19, -10, -16, 8,
    49, -36, -25, -1, 20, -51, -20, -12,
    -23, 6, -40, -10, 9, -28, -6, -1,
    -8, 18, -14, -43, 4, 61, -34, -38,
    -10, 13, 20, 34, -14, 12, -9, 8,
    -20, -61, 13, 3, 9, 13, 58, 19,
    -5, -16, -20, 2, 3, -5, 33, -16,
    -10, 32, 0, -4, -28, 21, -20, 29,
    1, -12, 9, 3, 36, -10, 27, 15,
    23, -21, -18, 28, -9, -18, -29, -15,
    20, 14, 17, -3, 53, 3, 16, 20,
    13, 4, 39, -3, -26, -33, -57, -39,
    15, 0, 15, 5, 40, 2, -7, 4,
    -32, 22, 36, 31, -7, -27, 5, -27,
    -20, -21, -1, 5, -9, 25, -27, 22,
    30, -15, -5, 7, -30, -9, -5, -11,
    -27, -5, -16, -22, 24, 2, -26, 18,
    -9, -9, -17, 12, -48, -23, -14, -40,
    -4, -5, -13, -8, -4, -4, -15, -24,
    0, -5, -16, -2, 22, 102, -28, -31,
    -2, -13, -1, -3, 2, -6, 15, -10,
    -13, -2, 18, 11, 19, -12, 70, 44,
    -16, -5, -8, 4, 0, 33, -5, -27,
    -14, 1, 8, -27, -14, -11, -76, 23,
    21, 3, 1, -6, -25, 6, 25, 6,
    14, 50, -32, -21, -26, 10, -4, -30,
    -22, -10, 29, -27, 19, -10, -4, -6,
    34, -1, -33, -26, -3, -13, 12, 35,
    -3, -1, 5, -12, 26, -27, 21, -4,
    8, 0, -2, -24, 16, 54, -49, -1,
    -32, 16, 52, 5, 14, 25, 19, -6,
    -14, 19, 24, -3, 9, 5, -47, 9,
    -18, 25, 10, 1, -24, -26, -10, -7,
    29, -14, 9, -38, -1, -13, -19, -19,
    -30, 30, 26, -2, 1, 2, 4, 8,
    -1, 20, -34, -3, 15, 44, 31, -4,
    2, 26, 28, 9, -15, 13, 22, -43,
    3, -29, 6, -46, -49, -7, 0, 2,
    31, 40, -31, 7, -4, 8, 12, -4,
    3, 8, 76, -64, 44, 30, 63, -13,
    13, -2, 3, 19, 2, -19, -10, -23,
    31, -23, -33, -35, -9, 27, -7, 14,
    8, -34, 9, -32, -12, -3, 16, -25,
    14, -16, -6, 33, 28, -15, -7, -50,
    0, -14, 4, -5, -16, 11, -16, -8,
    0, -12, 8, 43, -13, -10, -35, 20,
    13, 16, -17, -9, 10, -1, 12, 23,
    6, 20, 0, -10, -7, -6, -20, 10,
    4, 8, -2, -7, -7, -36, -1, 31,
    -63, 46, -11, -33, 1, 18, 21, -43,
    34, -33, -15, 9, -6, 4, 6, 18,
    24, -36, -31, -23, -10, 7, 7, -37,
    17, -12, 12, 14, 0, -19, 15, -12,
    7, -9, 4, 17, -26, 10, 12, -19,
    29, -4, -3, 2, 11, 8, 4, -2,
    -35, -14, 8, 13, 41, -21, 5, -25,
    18, -5, -11, -24, -2, 1, 25, -30,
    -24, 22, 15, -22, 67, 28, -9, -28,
    2, -49, -14, 12, 9, 6, -17, -9,
    1, 3, -32, 6, -32, 22, -40, -5,
    1, 10, 3, 5, 52, -12, -50, -25,
    1, -8, 32, 37, -25, -41, -5, -39,
    -12, -24, 9, -18, 35, -3, -1, 34,
    -8, 0, 1, 7, -6, 3, -39, 23,
    -4, -4, 12, -8, 11, -14, 19, -9,
    -33, 2, 62, -55, 6, -2, 28, 12,
    -4, -2, -63, -49, -7, -14, 11, 42,
    15, 3, -5, 31, 41, 2, -5, -17,
    -8, 3, -6, 10, 30, -6, -25, 32,
    29, -1, -32, 15, 17, 61, 17, -49,
    -19, -3, -21, 7, -9, -24, 30, -12,
    57, 4, -31, -28, 16, 0, 50, 16,
    -11, 6, -9, 39, -10, -39, 13, -51,
    -25, 21, -13, 23, 0, 46, 37, -97,
    11, -15, -19, -28, 25, 14, 21, -11,
    9, 6, 28, 9, 68, -15, -11, -12,
    37, -28, 35, -10, 9, -22, -3, 26,
    41, 41, -5, -80, 29, 14, 31, 27,
    46, 39, 33, 26, 7, -50, 23, -23,
    -22, 24, 22, 36, -65, -64, 8, 5,
    -23, 0, 13, -18, -1, -18, -14, -6,
    30, 42, 28, 8, 47, -13, 24, 31,
    -16, 28, -10, 7, 0, -18, 11, -45,
    -18, -38, 40, -25, -3, 8, 50, 18,
    12, -32, 6, 5, -25, -3, 43, 42,
    11, 7, 48, 12, 10, -10, -15, 26,
    -24, 18, 54, -24, 22, -20, 8, 20,
    14, -13, -13, 23, 12, -16, -39, 30,
    15, -10, -40, 6, 8, -70, 8, 21,
    4, 32, 54, -24, -14, 23, -25, 21,
    -14, 19, 23, -41, -18, -13, -5, 35,
    40, -22, -71, -22, 38, -33, 2, -70,
    -11, -7, 12, 18, 36, 1, -9, 13,
    -12, 2, 10, 22, 31, 0, 9, 23,
    -58, 24, -26, -43, 7, -2, 1, -43,
    -6, -10, -17, -3, 19, -17, -31, -15,
    -23, 6, -10, -2, 67, 19, 12, 25,
    -26, 38, -12, -55, -8, -6, 27, -11,
    -111, 17, 34, -34, 11, 2, -44, 23,
    -11, -12, -68, -7, 7, -27, -42, 1,
    -1, -36, -43, 18, -25, 38, 10, 10,
    -95, 8, 42, -4, -15, 46, 0, -10,
    -24, 30, 7, 46, -21, -108, -5, 28,
    -7, 28, -7, 11, -21, 3, 54, -86,
    -35, -38, -3, 16, 27, -105, 16, 7,
    -1, 15, 1, -7, 17, 42, 41, -22,
    -49, -37, -6, -2, 2, 8, 7, -17,
    40, 45, -24, -24, 0, 37, 29, 46,
    0, 57, 11, 2, 59, 43, -8, -33,
    -13, -19, -5, -18, 1, -25, 42, -13,
    34, -16, -22, 46, -6, 7, -54, -27,
    31, 11, -35, -30, -23, -56, -33, 1,
    16, 18, -6, -13, 3, 49, -53, -9,
    3, 19, 8, 16, 0, 11, 73, -29,
    46, 17, -37, 73, 33, 73, 20, 38,
    5, 67, -20, -31, -57, -3, 42, -27,
    22, 4, -42, 27, 25, -3, -20, -25,
    29, 4, 15, 6, 11, -4, -21, -29,
    -13, 30, -10, 47, -39, -21, -19, -7,
    17, 17, -5, -19, 14, 37, -5, -8,
    -81, -48, -7, -24, -66, -63, 21, 2,
    35, -46, -19, 5, 49, 44, -24, 23,
    10, 47, 49, -29, -6, -25, 2, -19,
    -19, 19, -24, 16, -7, -45, -4, -69,
    5, -7, -1, -4, 28, 28, -40, -34,
    11, 68, -9, 4, 52, -37, 32, -21,
    40, -11, -10, 42, 1, -43, 13, 23,
    18, 11, 3, -14, 42, -42, 33, -1,
    -6, -38, 18, 80, -6, -18, -5, 17,
    68, -42, 2, -22, -7, -14, -30, -32,
    -36, 10, -4, 9, 3, -31, -5, -34,
    -7, 12, 0, -56, -11, 89, -8, -38,
    -9, 9, 24, -29, 19, 10, 19, -17,
    -45, -84, 41, -12, -3, 31, 33, 3,
    -8, -15, 16, -18, 1, 45, 13, -2,
    -1, 79, -25, -19, -39, 42, 21, 7,
    -13, -24, 31, 42, 28, 8, 68, 45,
    -4, 0, -11, -37, 56, 33, -74, 53,
    -58, -10, -34, 32, -53, -27, 1, 15,
    18, -7, 111, 16, -61, -21, -59, -25,
    -27, -6, -33, 18, 12, -73, -62, 20,
    -2, 9, -32, 62, -34, -47, 20, -5,
    14, -8, -34, -51, 35, -40, 15, 80,
    27, -22, 7, 33, 9, -16, -7, 20,
    46, -33, 0, 52, 44, -50, -22, 66,
    -8, -8, -17, 12, -38, 35, 59, -13,
    -22, 4, 64, 65, -26, 6, -37, -26,
    11, 46, -26, 4, 2, 118, -38, -30,
    -8, 4, -11, -11, -21, -52, 21, -37,
    -28, -38, -6, 16, 37, -11, 12, 7,
    -14, -10, 19, -3, 20, 33, -52, -35,
    45, 5, 18, -56, -8, -20, -89, -20,
    15, 5, -36, -7, 16, 22, 11, 33,
    49, 61, -91, 12, 0, -12, 2, 50,
    -65, 32, 7, -53, 15, -44, -23, 15,
    57, 16, -57, -72, 2, 35, 8, 19,
    -10, -23, 22, -11, 2, -40, 7, -11,
    2, -67, 43, -12, -1, -18, 11, 6,
    14, 32, 44, 4, -8, 3, 34, 39,
    -16, 42, 21, 7, 36, 4, -62, -23,
    -6, 4, 5, 12, -34, -26, -5, 17,
    51, -26, -5, 1, -11, -19, -17, 7,
    27, 42, -22, -34, 31, -23, 8, 35,
    28, 13, -28, -19, 2, 7, 108, -2,
    24, 32, 42, 7, 16, -16, 34, 2,
    48, 15, -62, -49, 20, 31, -67, -1,
    46, 11, 16, 47, -36, 37, 4, -23,
    -32, 23, 83, -69, 40, 24, -39, 10,
    -22, -2, 4, 2, -10, -35, -43, -11,
    -18, -28, -19, -20, -57, 33, -13, -46,
    -35, 10, -29, 4, -16, -18, 22, 10,
    8, -24, 4, 15, 17, -18, -56, -50,
    1, -8, 22, 6, 5, 22, 8, -20,
    -7, -26, -3, -6, -15, -5, -63, -6,
    29, 17, 27, 6, 1, -23, 4, -9,
    16, -19, 2, -10, -29, -4, 37, -33,
    4, -27, -28, 3, 19, -54, 4, 36,
    -46, 12, -7, -50, 23, 41, 32, -12,
    -4, -6, 25, 57, -19, 23, 14, -15,
    27, -47, -19, 1, -20, 16, -55, -41,
    14, 34, 0, 48, 9, -3, 18, -1,
    -29, 5, 57, 44, -12, -5, -34, -50,
    28, 48, -35, 32, -54, -16, 16, 27,
    -57, -23, 0, 24, 19, -48, 8, -64,
    -6, -6, 26, -40, -7, -26, 53, -39,
    -12, -5, 34, 6, 27, 22, -17, -28,
    10, 17, -27, 60, 20, 0, -32, -8,
    -6, -12, -53, -9, -32, 9, -43, -23,
    10, -4, -8, -1, 36, -7, -7, -36,
    15, -1, 12, 57, 9, -50, -40, -20,
    -6, -18, -47, 25, 5, -31, -15, 18,
    -16, 20, -43, 10, 33, -8, -19, 36,
    11, 7, -49, 4, -23, -16, -13, -9,
    -19, -5, -21, -53, -6, -16, -67, 10,
    22, -26, -26, 28, -15, 31, -2, -8,
    -3, -16, 20, -14, 5, -19, -19, 46,
    7, 14, 23, -31, -21, 2, 6, -35,
    6, 4, 5, 11, -1, -15, -11, 3,
    29, -28, -6, -30, 32, 39, -14, 34,
    -28, -2, 19, 18, -17, 9, 12, 16,
    48, -19, 48, 30, -38, 20, 2, -10,
    15, 5, 1, -6, 8, -16, 7, 7,
    33, -5, 22, 4, 7, 11, -86, -21,
    13, -13, -8, -22, 31, -37, 0, 0,
    15, 33, -52, -27, -38, 20, 9, 14,
    0, -28, 15, -1, 14, 8, 9, -4,
    0, 5, 7, 9, 27, 9, 59, -11,
    -18, -14, -7, -21, -8, -4, 11, -11,
    11, 31, 29, 5, -43, 12, -4, -21,
    -9, 11, 1, -2, -17, 6, 8, -4,
    8, 8, -12, 23, 21, 33, -14, -8,
    -3, -4, 7, 0, -4, 35, 35, 10,
    -2, -8, -14, -3, 28, 35, 37, -28,
    13, -19, 7, 3, -9, 0, -20, -17,
    15, 18, -14, 60, 4, -33, -1, -7,
    15, 12, 2, 0, 3, 1, 25, 1,
    -15, 9, 35, 38, 4, 13, 1, -24,
    -4, -24, -12, 4, -19, 23, 36, -6,
    12, 2, 26, -21, -20, -18, 9, 2,
    4, -13, 26, -23, -26, -23, -11, 8,
    -4, 38, 18, 9, 6, -11, -4, -19,
    7, 0, 24, -2, 15, 10, 1, -6,
    -10, 39, -42, 12, 5, 7, 12, 6,
    -17, 4, 11, -16, 30, 5, 17, 0,
    -36, 26, 5, 21, -15, 2, -10, -24,
    13, 10, 12, -14, 4, 12, -13, 27,
    -8, 6, 12, -10, 12, -6, 1, -2,
    3, -1, -8, 7, -4, -6, 5, 15,
    10, 13, -10, 16, -23, -13, 26, -12,
    -5, 8, -15, -13, -11, -12, 29, -2,
    -7, -51, -11, 11, -32, -18, -7, -15,
    10, 11, 16, -9, -2, 4, -1, 6,
    8, 19, 8, -19, -2, 6, 23, 6,
    18, -8, -4, -7, 11, 5, 2, 31,
    -6, -24, 10, 4, -27, -8, -6, 27,
    13, 10, 12, -10, -9, -29, 27, 5,
    19, -1, 13, 13, -11, 11, -8, 5,
    0, 14, -9, -23, 16, -5, -7, -11,
    26, -22, 13, -4, -10, 5, 30, 10,
    26, -9, 36, -5, -3, 17, 40, -17,
    -15, 36, 27, 30, -14, -21, -23, 17,
    9, 12, 9, 1, 2, 10, -13, -9,
    10, -2, -26, 9, -10, 25, 14, 9,
    14, 0, 7, 2, 30, -13, -14, -38,
    8, -10, -25, -25, 0, -12, -5, -17,
    3, -5, -24, -3, -24, -39, -9, -11,
    -36, -32, 25, 3, 15, -5, -16, 5,
    7, 7, -9, 17, 0, -7, -32, 34,
    -7, 7, 19, -15, -20, -6, -43, 20,
    -2, -6, 23, -14, 33, 17, 4, 30,
    6, 13, 50, -21, 14, -51, -23, -22,
    -22, -14, 34, 8, -7, -14, 40, -16,
    -64, -19, 11, -21, 0, -10, -10, 14,
    11, 7, -15, -2, 12, 1, 36, -14,
    9, 2, 2, 12, 6, 39, 11, -31,
    32, 9, 4, 18, -3, 12, 16, 22,
    5, -18, -21, -3, 7, -7, 15, -8,
    -5, 10, 16, -17, 6, -5, -4, -5,
    -19, 28, -27, -17, -13, 14, 18, -1,
    25, 29, -6, 21, 3, -11, 15, 3,
    19, -7, -57, 3, 9, -40, -17, -5,
    5, 2, 13, 19, 7, 10, -5, -2,
    -24, 0, -4, 7, 56, 6, -21, -8,
    14, -20, -29, 19, 5, -19, 11, 17,
    8, 12, 14, -36, 5, 4, 6, 10,
    -10, 3, 8, 2, 0, -4, -4, 11,
    30, 45, -8, 7, -13, -17, 23, 15,
    19, -10, 20, 6, 5, 1, -20, -3,
    21, 8, -3, 24, -7, 9, -1, -5,
    2, -18, 18, -3, -3, 8, 25, -8,
    30, -7, 13, 42, 42, 37, 16, 5,
    -3, 20, 13, -6, 21, -8, -1, 22,
    -50, 20, -25, -5, -12, -30, -18, 15,
    10, 5, 3, -11, -2, -13, -6, 12,
    12, 7, -7, 9, -10, -7, -37, -13,
    11, -72, 14, 19, 23, -5, 24, 9,
    -14, 15, -45, -5, -4, 56, 9, 2,
    19, -2, -9, 4, -18, 3, -12, 3,
    9, 21, -1, 21, -55, 8, -6, 12,
    14, 22, -9, 34, 27, 1, 4, -30,
    -33, 27, -15, -6, -15, 4, 22, 7,
    -20, -2, 4, -21, 29, 7, 9, 9,
    -16, -22, 4, -11, -2, 48, -14, -10,
    13, -14, 14, 5, 16, -55, 7, -4,
    -23, 13, -4, 5, 4, 15, 19, 26,
    -9, -5, 23, 10, -10, -16, 5, -33,
    -33, 3, 13, 6, -4, 15, -2, -12,
    -19, -23, 24, -5, 2, 2, 7, -14,
    6, -24, 13, 3, 69, 24, -26, 15,
    -7, -14, 15, -2, -41, -5, 27, -3,
    -19, -2, -20, -16, 4, -6, -20, -2,
    1, 15, 7, 1, -53, 7, 43, -12,
    -12, -29, -6, 17, 39, -3, 13, -32,
    -12, 13, -15, 0, 8, 17, 25, 17,
    30, -4, 16, 31, -32, -2, -13, 8,
    16, -37, -20, 11, 4, 0, 23, 7,
    1, 27, -16, -3, 13, -12, -6, 47,
    8, 4, -1, 16, 6, -6, 6, -17,
    4, 14, 0, 37, -2, 18, -14, 28,
    -3, 6, 21, 23, 3, 5, -4, -22,
    18, -3, 41, 23, 2, 19, -3, -16,
    8, -3, 2, -7, 0, 14, -27, -9,
    18, -11, -29, -5, 25, 13, -3, 5,
    -6, -1, -43, -27, 6, 25, 6, -34,
    7, 14, -4, 15, 5, 12, 29, 6,
    3, -5, -15, -3, 6, -7, -6, -27,
    3, 6, -15, 4, 6, -33, -16, 33,
    -23, 2, 6, -1, -13, -1, 34, -31,
    43, -32, -15, 2, -13, 9, 12, 9,
    15, -8, 8, -11, -9, -10, -12, -6,
    0, 61, -20, -25, 29, 60, 42, -4,
    21, 13, -8, 3, 20, 1, 20, 35,
    -40, -6, 7, 33, 2, -19, 0, 1,
    18, 4, 7, -4, -12, 12, -3, 3,
    6, 5, -5, 35, 5, 8, -16, 5,
    12, 1, -1, 3, -9, 13, 26, -10,
    -23, -3, 17, 4, -10, 42, -8, 2,
    -7, -6, -15, 6, -2, 7, 20, 6,
    -19, 3, -9, 13, 3, -5, 13, 23,
    20, 2, 13, -1, 18, -25, 18, -18,
    -16, -10, -27, 17, -23, 40, 16, -23,
    2, -10, -9, -11, -37, -11, -8, -2,
    -12, -6, -16, 4, -18, 26, -2, 9,
    9, 15, 17, -7, -4, -25, 6, 7,
    25, 92, 16, -3, 10, -20, -14, -29,
    9, -22, 11, 1, -6, -22, 1, 14,
    7, -7, -11, 0, 19, 22, -13, 22,
    -7, -13, -9, -4, 12, 23, 14, 24,
    6, -3, 18, -7, 6, 23, -30, 16,
    0, 17, -1, -3, 15, -11, 0, -13,
    9, -8, 21, 9, -1, 5, -12, -16,
    32, -12, 6, 35, -1, 7, -19, -9,
    38, -26, -18, 3, -63, -40, 31, 2,
    -13, 3, 0, 16, 20, 15, -28, -1,
    21, -3, 8, 14, 18, 15, 21, -14,
    -8, -16, -29, -11, -45, 10, -8, 5,
    16, -38, 16, -5, -20, 11, 16, 17,
    11, 8, -19, -14, -9, -5, -11, -3,
    23, 7, -6, 17, 11, -1, -17, -11,
    -4, -4, 5, 34, -4, 20, 34, 37,
    -22, 10, -30, -28, 27, 28, 8, -24,
    -1, -10, 7, -3, -18, -15, -11, -2,
    3, -24, -33, 59, 9, -31, 13, -25,
    -17, -20, -7, -35, 9, -23, 6, 34,
    -78, -8, 52, 9, -4, -15, 10, 10,
    -23, -1, -15, -16, 23, 14, 23, 24,
    13, -4, -5, -23, -4, -19, 12, -6,
    18, -2, 24, -15, -23, -46, -24, -65,
    -3, 22, -41, 23, 24, 6, -29, 10,
    -13, 12, -1, -9, 18, -3, -6, -4,
    -9, 38, -2, 18, 2, 14, 2, 1,
    -25, 20, 11, 7, 36, 17, 20, -12,
    -38, 25, 11, 0, -23, 1, 7, -6,
    13, 7, -1, -15, 9, -3, -3, 8,
    17, 11, 10, 4, 22, -10, -6, -10,
    3, 13, 9, 21, 9, 1, 9, 16,
    17, 18, -78, 11, -24, -10, 0, -6,
    -7, 2, -6, -4, -14, 7, 5, 5,
    0, -60, -22, -10, -19, -4, 0, 1,
    -20, 17, 9, -5, -16, 48, 20, 10,
    -1, 2, 27, 7, -6, 20, -1, -2,
    15, -6, -4, -5, -5, 3, -9, 19,
    17, -9, 3, 5, -23, -1, 6, 27,
    15, 16, 1, -2, -21, -22, 16, 12,
    -12, 17, -6, 3, 4, 43, -18, -14,
    7, 10, -1, -15, -3, 26, -5, -9,
    6, -39, 19, 14, 8, -9, 2, 1,
    -15, 5, -1, -24, -34, 32, 10, 6,
    -62, 27, 79, -8, 5, 21, 19, 14,
    9, -1, 14, -12, 3, 6, -5, -18,
    6, 0, -13, 14, 10, -7, 4, -6,
    20, 19, 11, 19, -12, -31, -6, -46,
    -28, -53, -25, 11, -19, 15, -14, 28,
    15, -10, -19, 10, -3, -14, 3, 0,
    -6, -15, 14, 22, 17, 29, 12, 10,
    7, -20, 24, 12, 49, 5, -29, -4,
    -13, -18, -5, 23, -43, -14, -11, 22,
    -11, 5, 0, -7, 6, -14, 4, 23,
    -5, 3, 37, -14, 11, -30, -3, -8,
    3, 0, 4, -17, 11, 29, 19, -1,
    -45, -60, -11, -51, 10, -12, 31, -6,
    25, 10, -11, 4, -12, 2, -1, -16,
    14, 1, -11, -19, 6, 30, 1, 8,
    -11, -25, 7, -10, 8, 27, 6, -34,
    30, -55, 26, 4, -5, 30, 22, -2,
    -6, -11, -18, -18, 3, -13, 18, -8,
    1, -11, -4, 5, 3, 4, 24, -3,
    15, -1, -1, -40, -19, -22, 12, -11,
    2, -6, -10, -67, 4, -3, -14, -12,
    -3, 7, -7, 3, -3, 5, -4, -6,
    13, 13, 17, -3, 22, -27, -14, 23,
    -26, -1, 17, -39, 37, -2, 0, -11,
    -15, 17, 6, 12, -30, 6, 9, -12,
    -5, -7, -2, -4, 18, 15, 14, -47,
    26, 11, 13, 10, 7, 14, 35, 8,
    -1, -7, 3, 3, 9, 17, -19, 13,
    31, -23, -49, 0, -11, -13, -13, -1,
    -14, 2, 8, -2, 0, -37, 21, -10,
    15, -9, -6, 29, 11, -8, 34, 12,
    11, -1, -10, 11, -11, 11, -17, 3,
    -20, 9, -13, -12, 21, -20, -21, 25,
    16, -31, -14, 7, 14, 2, -34, -1,
    5, -15, -33, -43, 21, 10, -19, -10,
    17, 21, -33, 10, 35, 22, 63, 17,
    -4, 10, 12, -42, 2, 14, -19, -9,
    11, -6, 21, 6, -20, 15, -3, 7,
    5, 18, -32, 29, -17, 11, 6, -9,
    25, 5, -39, -4, -46, 27, -5, -16,
    -15, 20, -63, 10, 44, 0, -1, 11,
    -9, -9, 18, 6, 7, 14, 7, 1,
    6, -24, -24, 1, -10, 24, 3, -22,
    10, 11, -18, -33, -11, 1, 10, -3,
    -2, -12, -31, -33, -5, 19, -19, -14,
    -3, -19, 9, 2, -10, -43, -4, -6,
    -14, 11, 8, 5, -4, 21, 9, -15,
    0, -9, 48, 5, -1, 2, -26, -22,
    11, -31, 8, 14, 9, 37, -5, 17,
    8, -16, 2, 7, -22, -20, 9, -1,
    2, 16, 36, -12, 4, 0, 5, 24,
    26, 29, 6, 8, -69, -17, 13, -1,
    -49, 12, 18, 26, 31, 41, -12, -20,
    -23, -5, 0, -4, 13, -8, 17, 26,
    8, 13, -15, 11, -24, -12, 4, -14,
    -57, -25, 4, -32, 38, -15, -7, -19,
    16, -23, 16, -5, 32, -18, -13, 13,
    16, -1, 9, -2, 34, 3, -7, 27,
    18, 7, 24, 7, 5, 14, 2, -2,
    -1, 6, 35, 3, 17, 6, -15, -8,
    1, -23, 26, 68, -5, 9, -6, -18,
    -4, -10, -13, -7, 1, 10, -5, 17,
    7, -22, 3, -10, 0, -7, -19, 0,
    6, -11, -12, 8, -11, 0, 8, -14,
    24, 15, -12, -28, -2, -29, 22, -9,
    4, 9, -3, -2, 0, -16, 1, -5,
    15, -25, -12, 0, -4, 2, -7, 17,
    -29, 0, -19, -12, -13, -19, 3, 3,
    25, 55, -42, -1, -14, 1, 0, 0,
    23, 25, 1, 2, -17, 8, -25, 6,
    11, -5, -12, 11, 6, 24, 36, -11,
    -30, 11, -22, -5, 18, 21, 28, 29,
    -25, -28, -39, 21, 9, -30, -16, -13,
    21, 4, -4, 3, -2, 6, -31, 11,
    10, -7, -14, 1, 7, -3, -5, -2,
    -5, -23, 2, -3, -23, 19, 4, -14,
    -12, -32, 44, -12, -13, 29, 63, 13,
    8, 11, -7, -2, -33, 7, 18, -1,
    -19, 0, 5, 18, 6, -11, 16, 17,
    -31, -5, -44, -1, -49, 1, 40, -16,
    -11, -21, -47, 42, 10, 18, 3, -3,
    -23, -6, 9, -12, -37, 8, 0, -1,
    21, 23, -10, 4, 91, -58, 15, -9,
    -13, 41, 14, -7, -34, 25, 5, 62,
    55, -35, -13, -61, -9, 0, 12, 23,
    31, -103, 32, -13, -34, 3, -11, 19,
    -16, 7, -10, 23, 28, -32, 8, -37,
    22, 10, -17, -51, -32, 26, -15, -17,
    29, -47, 45, 51, 21, 1, -13, -43,
    5, 32, -10, -16, -26, 17, -34, 9,
    -23, -22, -9, -10, 17, 3, -82, 118,
    -32, 23, 24, 18, 0, -31, -40, 14,
    -9, -72, 56, 60, -20, 30, -15, -29,
    -5, 56, -21, 42, -54, 1, 28, 58,
    11, 24, -3, 3, -27, -31, -39, 0,
    -18, 35, -6, -9, -14, 52, -34, -1,
    -32, -32, -50, 14, -22, -50, 21, 22,
    22, -32, 2, -21, -51, 0, -43, 8,
    40, -16, 25, -14, 5, -24, -44, 39,
    0, 12, -16, -18, 33, 92, -21, -10,
    4, -65, 36, -56, -5, -7, -13, -3,
    -32, -9, 19, 78, 20, 39, -19, -64,
    -40, -57, -90, 65, -57, -48, 30, 40,
    18, 20, -5, -14, -32, -29, -2, -15,
    -63, 0, 79, -80, 15, 35, 65, 11,
    -21, 8, -11, -23, 31, 17, -33, 20,
    -5, -8, 6, -20, -20, 21, -19, 4,
    -6, 10, -28, 8, -11, -58, -15, -18,
    9, 39, -53, 16, -7, -13, -14, 26,
    -20, 24, -36, 9, -14, -35, 18, -10,
    -17, -35, 17, 1, -8, 34, 28, -41,
    20, -48, -5, 21, -3, 16, 11, 37,
    -63, 10, -5, 24, 61, -38, 12, 22,
    69, 60, 26, -3, -54, -24, -40, -5,
    30, -8, -40, 3, 22, 42, -10, 0,
    9, 27, -6, 1, 22, -17, -27, 10,
    -8, -14, 46, 24, -20, 41, 49, 8,
    3, 10, 19, -10, -14, -2, -34, 13,
    1, -127, 19, -24, -7, -33, 13, 18,
    17, 46, -5, 7, -3, 17, -21, -18,
    -45, 63, 55, 30, 6, 30, -14, -36,
    13, -40, -1, 14, -26, 19, -32, 3,
    -4, 71, -47, -4, -15, 25, -14, 24,
    -16, 11, -16, 13, -96, 43, 1, 65,
    -33, -11, 35, -27, 12, 40, -10, -20,
    -1, 17, -24, -25, -61, 23, -6, -12,
    -37, 30, 7, 7, -13, 95, 45, 3,
    1, 7, 15, -6, -4, -3, 0, 42,
    -46, 83, -57, -18, 44, -37, -38, -30,
    -52, -62, 40, -11, 2, 26, 17, -10,
    10, -3, -20, 28, 24, 47, -7, 42,
    -6, 18, 14, -20, 11, -29, -35, -24,
    -34, -45, -18, 32, -35, -18, 55, 6,
    65, 9, -52, 20, 38, -8, -8, -13,
    -87, -30, 30, 29, -8, 43, -59, -4,
    -5, 30, -1, 10, -42, -37, -24, -12,
    45, 77, -24, 12, 9, 25, 2, 22,
    23, 28, -53, -2, -62, 3, 8, 5,
    -6, 33, -29, -6, -41, 31, -7, -25,
    22, 18, 29, 17, 69, 60, -9, 8,
    -9, 36, 45, 12, 10, -28, 19, -42,
    53, 17, 25, 12, -13, 1, -9, 29,
    -6, -34, 7, -13, -44, -68, -26, -20,
    26, 4, -5, 12, -5, 2, 5, 3,
    20, 43, 26, 3, 4, 24, -28, 28,
    -4, 1, -40, -19, 2, -2, 16, -8,
    -6, -48, 14, -29, -3, -18, -26, 12,
    6, -61, -1, -24, -1, -62, -21, -5,
    4, -55, 35, 22, -5, 18, -61, 16,
    4, -2, -12, -13, -8, -11, -12, -26,
    -28, 8, 37, 25, -103, -26, -8, -52,
    3, 32, -34, 36, -5, -1, -6, 37,
    -33, 4, -70, -59, -15, 36, -31, -3,
    -13, -1, -15, -29, -32, -6, 9, 55,
    14, -38, -27, 21, -44, -29, -27, 5,
    7, 48, -8, -15, -14, 17, -13, 13,
    10, 14, 2, 30, 14, -48, 8, -48,
    8, -17, 43, 26, -85, 40, 6, -12,
    61, 33, 1, 90, 4, -2, -67, -6,
    -13, 30, -19, 22, -5, 5, -27, 6,
    -43, -55, -15, 37, 28, -4, 12, 13,
    -10, -51, 38, 57, 20, 14, 15, 5,
    -3, 21, -12, -54, 12, 13, -69, 0,
    16, 113, 38, -20, 12, 56, 10, 5,
    -45, 7, -75, 21, -34, -95, -21, 3,
    13, 9, 107, 19, 3, 17, -15, -2,
    -50, 10, -31, -22, -3, 19, -5, 36,
    -46, 7, 21, -11, -34, -3, 9, -10,
    25, 28, -9, -73, -66, -12, -5, 16,
    59, -5, 11, 57, -21, 14, 3, -11,
    37, -15, -9, 73, -34, -41, -79, 15,
    30, 14, 39, -14, -63, 40, 19, -52,
    3, -39, -69, -30, 24, -53, -44, 9,
    -12, -56, 21, -33, -12, 47, 6, 14,
    27, 20, -11, 14, -66, 4, 1, -12,
    -16, -13, -15, 26, -16, 53, -48, 3,
    75, -23, 23, -25, -48, 8, 30, -37,
    -23, -18, -1, 6, 3, -28, -5, -8,
    18, -25, 22, -13, 7, 11, -24, 56,
    -15, 16, -40, 4, 6, -2, 6, -13,
    -16, -35, 6, -13, -53, -15, 48, 20,
    60, 5, -17, -1, 22, 11, -60, -4,
    -2, -15, -20, -46, 20, -13, 1, 0,
    43, -21, 15, -6, 24, -25, -65, 46,
    17, -40, -2, -14, 59, 16, -43, 79,
    -16, 16, 6, -4, 23, 12, -10, -14,
    14, 0, 44, -23, 18, 3, -3, 59,
    -1, -26, -27, -22, 9, 25, 11, 17,
    -3, -4, 27, 44, 19, 29, -21, -18,
    -8, 4, -8, 24, 1, -3, -4, -23,
    -16, -40, 14, 22, -10, 29, 54, -7,
    11, 27, -24, -15, -6, -54, 27, -23,
    33, 29, 42, -8, 20, 14, -10, 14,
    19, 1, -54, 2, 7, -11, 25, 14,
    17, -9, -8, -36, 1, 85, 13, -23,
    64, -24, -39, -15, 33, 14, -19, 29,
    18, 40, -53, 0, 85, -5, 21, 18,
    34, 24, 13, 17, -127, 1, -5, -3,
    -10, -62, 26, 48, -22, 31, -81, 0,
    2, 18, -7, 9, -22, -32, 29, 16,
    -88, -10, 11, 31, 56, -6, -41, -36,
    47, -17, -42, -2, 26, -7, 28, -3,
    -14, -7, -34, -2, 10, -1, 40, -39,
    73, 5, -24, 3, 26, 5, -84, -36,
    -46, -22, 56, 0, 71, 7, 35, -28,
    17, 12, -22, 3, -36, -8, -19, 11,
    16, 4, 13, 4, -49, 4, -35, 21,
    42, 2, 12, -9, 14, 27, -25, 0,
    56, -12, -4, -11, -38, -5, 11, -30,
    -56, -19, 51, -14, 60, 3, -25, -17,
    29, 8, 14, -12, -16, -5, -7, 10,
    8, 21, 5, -33, 2, 9, 28, -13,
    72, -19, 13, -17, 16, -50, 13, 30,
    -2, -10, -15, -5, -16, 10, 15, 25,
    -58, 19, 9, 13, 33, -12, -10, 27,
    -30, 33, -27, -2, 23, -11, 3, -3,
    -28, 16, 31, -21, 6, 15, 46, 13,
    11, 2, -2, 21, -5, 3, 12, -9,
    -60, -65, 9, 32, 1, 17, -1, 1,
    -4, -46, 57, 13, -4, 8, -13, -2,
    -32, -24, 21, 2, 18, -4, -35, 18,
    8, 7, -17, -9, -15, -41, 20, -9,
    -13, 36, -38, -46, 1, -3, 23, 12,
    3, -43, -20, -16, 7, -12, 1, -10,
    -9, 17, -17, 1, -14, -12, 2, -28,
    38, 34, 8, -3, 7, 9, 11, -17,
    -12, 7, 10, -38, 9, -38, -14, 13,
    -37, -13, 40, -8, -3, -9, -2, -11,
    -48, -20, -58, -24, -30, 2, 34, 40,
    13, -2, 16, 13, -24, -13, 24, -15,
    0, -42, -63, -31, 7, 13, -4, 15,
    -38, 47, 15, 34, -12, 16, -3, -10,
    -6, 15, 28, -30, -8, -1, -24, -6,
    40, 5, -13, 13, -9, -22, 30, 17,
    53, 14, -6, -30, 22, 7, -17, 22,
    -14, 5, -50, 0, 4, -4, 12, -75,
    33, 6, 42, -34, -7, 12, -3, 20,
    -27, -1, -37, 33, -1, -22, 8, -13,
    8, -42, -17, -2, 32, 22, 1, 8,
    8, -37, 59, -45, -17, -12, 2, 24,
    -15, 38, 3, 3, -26, -6, -3, 32,
    -1, -20, 6, 59, 4, -51, -13, -1,
    27, -38, -6, -9, 4, -2, -13, 10,
    -5, 4, -1, 9, -4, -1, 7, -23,
    22, -3, 15, -34, -36, -10, 22, -20,
    -7, 4, 22, -45, -1, -51, -15, -8,
    15, 33, 32, -17, 30, 17, -14, 37,
    -51, -19, -26, 24, -21, -5, 2, -11,
    -29, -1, 12, 1, 46, 42, 31, 21,
    10, -2, -16, 2, 40, 8, -23, 24,
    -11, -4, 7, 14, 15, -14, -9, -19,
    -16, -8, -19, 11, 28, -2, -5, -13,
    -5, -44, 5, -10, 53, 22, 31, -31,
    41, 40, -4, -5, -10, 30, 12, -17,
    32, 12, -45, -3, 0, -7, 15, -28,
    10, -27, -42, 22, -1, -1, -10, -1,
    20, 53, 13, -6, 35, 23, 5, -35,
    15, -45, 18, -25, -44, -25, -61, -12,
    -14, -29, 9, 14, -12, 2, -14, -30,
    -39, 20, 4, 21, -27, -18, 3, 9,
    -13, 15, -39, 4, -13, 1, -2, -28,
    32, -4, 17, -24, -27, 45, 19, -8,
    20, 84, -14, 12, 35, -29, 33, -4,
    -23, 60, 19, 48, 11, -3, 19, 1,
    17, 0, 23, -10, 45, -20, 2, -20,
    45, 84, -26, 37, 20, 37, 34, 4,
    -2, 13, -9, 4, -4, 1, 10, -11,
    -63, 21, -19, -6, -12, 3, -14, 5,
    38, -14, 35, -33, -1, -1, 37, -41,
    -40, 44, -15, -37, -39, 41, -9, 3,
    -14, 67, -29, -1, 34, 20, -25, -3,
    -31, 20, 36, 4, 27, 13, -1, 8,
    -7, 23, 14, -11, -25, 27, -14, 11,
    -15, -49, -26, 3, 1, -24, -8, 6,
    29, 5, 6, -4, 11, -2, -1, -20,
    -64, 12, -46, -7, -4, 21, 14, 8,
    26, 36, 4, 41, 1, -23, -11, 22,
    -11, -49, -7, -26, 10, -23, 26, 21,
    19, -72, 6, -10, -14, 26, -28, -19,
    36, -5, -22, 43, 2, 6, 4, -12,
    -41, -8, 29, -59, 4, -13, 37, 7,
    -20, 12, 11, 25, -10, -25, 17, -7,
    -34, -23, -11, 11, 44, 30, 33, -11,
    -34, -3, -22, 15, -6, -18, -2, -29,
    -7, 24, 18, 32, 6, 13, -32, 8,
    -4, -15, -29, 21, -3, 2, 4, -1,
    28, 38, 57, -13, 2, -14, 1, 3,
    29, 12, 60, -8, -12, 15, 16, 2,
    -24, -32, -7, -17, -41, -2, 3, 0,
    -5, -25, 19, 44, -19, -6, 58, -24,
    19, 2, -45, -19, 11, 19, -28, -21,
    -1, 12, 46, 4, -9, -30, -10, 11,
    7, -21, -20, 47, 29, 20, 11, 40,
    -18, 40, -37, -23, 16, 5, 2, 12,
    1, -23, 10, 60, 20, -26, 10, 29,
    -37, -26, -2, -28, 6, -9, -20, -9,
    -12, -23, 18, 19, -7, 4, 9, 32,
    -4, 6, -14, 9, 7, 3, -8, -5,
    -31, -18, 14, 17, -19, -41, 19, -7,
    25, -11, 22, -26, -11, -6, 12, -2,
    -31, -11, -15, 9, 2, -16, -4, -9,
    -7, -5, -17, 63, -10, 31, -13, 24,
    13, 16, 2, -40, -34, -28, 22, -31,
    42, -36, 2, -19, 12, 7, -20, 14,
    -25, 0, 39, -13, 32, -34, 3, -10,
    13, -1, -36, 24, -8, -6, 16, 2,
    -2, -3, 80, -33, -41, -63, 10, -15,
    11, -20, 31, -26, 37, 14, 9, 11,
    11, 25, 26, -4, 6, 4, -3, -15,
    -4, 11, -27, 15, 20, -2, -24, 0,
    16, -18, -48, 33, 15, 5, 16, 30,
    -20, 29, -42, 13, -12, 4, 1, 12,
    21, -56, 14, -2, -6, 9, -69, 31,
    9, 28, -10, 12, 20, -2, -7, -10,
    0, -21, -20, 10, 3, -15, 20, 3,
    -13, 6, 9, -34, 8, 1, -27, -18,
    5, 42, 20, 11, 17, 7, 3, -29,
    13, -33, -2, -43, 12, -3, -1, 11,
    9, -42, -4, -3, -28, 21, 7, -48,
    23, -35, -5, 34, -14, -2, -15, -10,
    -12, 16, -22, -26, -21, -19, 14, -19,
    -9, 25, 15, 6, 14, -24, -4, 0,
    -21, 21, -6, -38, 2, 21, 13, 10,
    -26, 21, 10, -32, 2, 14, -23, -2,
    -9, 18, 2, 33, -19, 1, -5, -22,
    -8, -66, 13, 44, -49, -6, -12, 18,
    20, -36, -26, -65, 35, 29, -21, 13,
    28, 3, -9, 0, -11, -12, -16, -10,
    7, -14, 16, 22, -10, -15, 6, 8,
    35, -21, -8, 44, 10, -13, -17, -16,
    -9, 11, 30, 2, 17, 7, -18, -20,
    15, -30, -51, -3, -5, 41, -13, 16,
    -2, -21, -7, 24, -23, -27, 6, -5,
    -13, 7, 17, -5, -23, 15, 15, -14,
    16, 11, 55, -13, 13, 4, -33, -6,
    2, -23, -3, -8, -19, -3, -18, -11,
    -12, 35, 10, -3, -21, 17, 1, -1,
    20, -23, 35, 8, 16, 20, 27, -9,
    25, 28, 20, -16, 2, -30, -21, 4,
    17, 13, -8, 13, 1, 3, 27, -20,
    39, -2, 11, 54, 2, -73, 0, 10,
    10, 25, -28, 54, -31, 18, -3, -8,
    -50, 11, -27, -15, 47, 8, 9, 43,
    6, 24, 15, -57, 29, 6, -12, -1,
    -45, -29, 38, -17, 26, -8, 29, -5,
    -11, 17, 7, -26, -1, -25, -10, 6,
    24, 8, 14, 39, 26, -12, 54, 0,
    36, 26, 57, -28, -2, -1, -24, -8,
    -21, 4, 27, 74, 25, -4, 0, 20,
    -16, -5, 19, 4, 35, 25, -9, 31,
    -19, 87, 34, -19, -11, -5, 23, -12,
    17, -6, -31, 25, 7, 13, -12, 9,
    27, 19, 19, 7, -24, -6, -6, 3,
    -16, -5, -21, -20, 20, -9, -2, -19,
    0, 11, 23, 51, -2, -65, 1, 3,
    9, -47, 29, -88, 5, 6, 3, -5,
    -26, -40, -19, -16, 0, -14, 23, 23,
    25, 54, -6, -59, 1, -39, 17, 36,
    -12, -4, -74, -18, -10, 9, 32, 22,
    -3, -8, 15, 33, -29, -1, 6, 33,
    36, 7, 23, -44, 20, -1, -19, -28,
    -21, -10, -6, 23, 28, -10, -17, -10,
    27, 0, -55, -21, 4, -15, -1, -1,
    6, -31, -19, -29, -3, -8, -24, -57,
    -37, -21, -6, -21, 32, 10, -34, -2,
    5, -15, 30, 24, 20, -27, -23, -13,
    -9, -6, -27, -17, 18, 3, -44, 13,
    6, 53, 35, 25, -9, -29, 7, 22,
    -13, -7, 5, -23, -8, 6, -4, 32,
    3, -2, 50, 20, -58, -7, -8, -10,
    7, 57, 0, 17, 7, -18, 38, -16,
    -6, 9, 11, 9, -4, -2, -9, -15,
    35, -6, -13, -35, -20, -8, -7, -12,
    -21, -20, -14, -23, -1, -8, -3, -1,
    31, 7, 21, 7, 16, 2, 2, -2,
    7, -28, -35, 11, -24, -7, -5, 29,
    -16, 19, -1, -4, 20, 22, 17, 2,
    -18, -28, -27, -21, 18, 5, 13, -4,
    65, -17, 4, -5, 37, -6, -7, -7,
    24, 7, 7, 2, 16, -4, 0, -14,
    -4, 13, 35, -42, 42, 14, 47, -42,
    -13, 64, 38, 1, 27, -21, 11, -20,
    -28, -101, 7, 12, 30, -17, -37, -34,
    27, 28, -30, 13, -16, -18, -9, -12,
    5, 8, -15, -6, -9, 13, -17, -38,
    9, 45, -27, -41, -27, -4, -6, 5,
    -31, -13, -17, -6, 7, 29, -11, 10,
    -31, -54, 32, -45, -25, -11, 1, -23,
    -34, -23, 20, 24, -6, 18, -25, -28,
    10, 18, -25, 8, 2, -14, 19, 34,
    9, 16, 30, 17, -15, -18, -24, 21,
    30, -27, 110, -16, 26, 0, -11, 14,
    17, 34, -23, -7, 9, 10, 9, -7,
    -19, -33, 26, -12, -5, 1, 1, 16,
    10, 23, 29, -61, -9, -53, 30, -6,
    -10, -29, -13, 5, -5, -1, -22, -4,
    -6, 20, -23, 12, -1, 29, -6, -37,
    -22, -2, -11, -1, 19, 20, 5, -28,
    49, -11, -2, 13, 15, 35, 9, 30,
    -33, 5, 39, -97, 37, -19, 8, 1,
    -34, 40, -68, -16, 5, -3, 1, 23,
    -17, -4, 3, 1, 9, 3, 32, 3,
    34, -35, -19, -39, -5, 9, 30, 26,
    -40, 37, -39, 43, -3, -1, -7, -22,
    -18, 13, 8, -4, 8, 10, -51, 19,
    3, 3, 4, -50, 12, 24, 15, 2,
    61, 2, 1, 38, 24, 4, -21, 5,
    -3, 12, -9, -37, 13, 7, 16, 9,
    -16, 13, 13, -21, -8, -11, 28, 37,
    -7, 10, 47, 15, 16, -16, 14, 22,
    -3, -20, -29, 16, -37, 18, 16, -22,
    50, -75, 36, 29, 15, -19, 1, -7,
    -8, 13, -21, 12, -16, -5, -38, -13,
    6, -38, 2, 14, -19, 45, -20, -2,
    42, 8, -27, 52, 9, -26, 32, 36,
    -6, 45, 11, 7, 23, -1, -5, -5,
    43, 8, -40, 1, 24, -61, -28, 21,
    0, -27, 8, -4, 25, -8, 16, 7,
    23, -6, -30, -44, 9, 15, 12, 7,
    -30, -30, 60, 15, 8, -14, 8, 11,
    -34, -49, 2, 26, 12, -15, -4, 23,
    0, 17, -26, -4, -15, -34, -56, -1,
    -77, -18, -7, 81, 39, -15, 29, 60,
    -12, -6, -18, 2, -3, 0, -58, -12,
    22, -36, 65, 12, 18, 16, 11, 42,
    62, 18, -71, -17, 12, -11, 9, -22,
    -16, -78, -6, -12, -36, 29, -12, 19,
    3, -29, 24, -34, -4, 2, -7, 20,
    7, -18, -65, -22, 3, -1, -19, -8,
    32, 29, -29, -36, -8, -21, -15, 7,
    17, -24, -65, -7, 11, -17, 10, -15,
    -2, -34, -12, 0, 20, 3, 5, 12,
    -19, -13, 0, 15, 12, -5, -16, -18,
    -30, 8, 54, 22, 25, 5, -28, -12,
    55, -3, 11, -16, -55, -7, -1, -26,
    55, 13, 40, 12, -8, -18, -17, 18,
    -16, -49, 5, 0, 3, -9, 23, -16,
    64, 20, -25, 18, 15, 40, 10, 18,
    1, -11, -75, -27, -38, 4, 39, 22,
    -80, 38, -38, -5, -12, 14, -2, 4,
    -2, -60, 6, 1, 1, -4, -21, 36,
    -42, -11, 58, -45, -11, -21, -29, -22,
    -5, -8, -4, -19, 6, -16, -19, -2,
    6, -53, 54, 24, 6, -3, -14, -5,
    7, -12, -7, -6, 5, 12, -4, -22,
    17, 2, 30, 43, -5, 26, -19, -10,
    -1, -37, 5, 16, -30, 1, -3, -20,
    16, -31, -11, -24, -3, 7, 0, -11,
    -1, -30, -29, -22, -12, -30, 14, -10,
    -6, -38, -24, -67, 4, -29, 31, -18,
    -27, -61, 34, -18, 5, 5, -19, 4,
    -21, -35, 8, -82, -2, 1, -10, 17,
    -29, 8, 8, 18, 0, 11, -7, -21,
    9, -33, -22, -23, -21, -8, -15, 7,
    -1, -69, -14, 1, -10, -4, 15, -13,
    73, 16, -13, 3, -8, -16, -20, -14,
    -40, -2, 25, -1, -10, 4, 14, 1,
    -31, 19, 40, 6, 1, 10, -12, 20,
    -28, 19, -18, 4, 3, -1, 14, 18,
    -1, -27, 13, -45, -14, 22, -14, -6,
    13, 14, -35, 1, 8, 3, 9, -15,
    -19, -51, 15, 8, -2, 38, -28, -10,
    -15, 10, -49, 20, 9, 15, 29, -11,
    -55, 8, -8, -1, -23, -2, -4, -11,
    50, 37, -23, -3, -2, 4, 14, -8,
    -27, -22, -24, 13, -12, 11, -21, 0,
    39, -12, -9, -82, 24, 61, 3, -7,
    -31, -11, -14, -46, 10, -1, 12, -38,
    49, 54, -7, 96, -31, 3, 15, 8,
    -41, -6, -41, -49, -21, -97, 9, -19,
    8, 38, 20, -31, -71, 19, -19, 28,
    -31, 24, -12, -117, 28, -3, -37, 16,
    21, -2, -15, 16, -8, 3, 19, -22,
    -5, -33, -18, -12, -72, -28, 13, -15,
    -12, 0, 24, -9, -80, -15, 5, 6,
    41, 16, 6, -48, 50, -7, 3, -17,
    -9, -3, 23, 26, -15, 10, -49, -6,
    -5, 52, -4, 10, -29, 90, -12, -42,
    -89, 18, 49, 7, 11, -66, 3, -26,
    82, 10, -43, 14, -26, 115, -10, 17,
    11, -33, 2, 48, 25, -20, 30, 28,
    25, -40, 7, 0, -13, -3, 6, -79,
    6, 47, 80, -33, 42, -4, 12, -10,
    43, 17, -44, 11, 13, -21, 14, 34,
    -21, -43, 31, -5, -53, 18, 12, 11,
    26, 80, -11, -40, 13, -16, 39, -99,
    31, -12, -11, -32, 25, 36, -18, 28,
    5, 4, -9, -36, -54, 4, -18, 18,
    -4, -71, 8, -2, 55, 52, 40, -27,
    -34, -5, -45, 21, 1, 50, -6, -84,
    -28, 25, 5, -46, -81, -48, -33, -2,
    25, -37, 32, -7, 6, -6, -7, -117,
    -38, -91, -10, -30, -25, 7, -5, -19,
    14, -37, -26, -56, -15, 17, -22, 37,
    58, -23, 0, 23, -63, -39, -22, -47,
    -49, 16, 22, -41, 8, -47, -16, 0,
    22, 9, -34, -62, 43, -41, 10, -30,
    -50, -27, 42, 13, 7, 67, 9, 59,
    -2, 36, -36, 21, 1, -23, -9, -17,
    -3, 4, -11, 5, -15, 6, -27, -16,
    4, 41, -87, -28, -56, -37, 6, -3,
    -15, -36, 37, -45, 21, -39, 29, -26,
    -54, 84, 60, -16, 15, -38, 10, -38,
    14, -7, -14, -56, -12, -11, -9, 99,
    -30, -57, 34, 25, -29, 59, -42, -8,
    -4, -3, -24, -59, 12, 50, 25, 7,
    -11, -4, -4, -18, -25, -2, -40, 11,
    5, 13, -29, 48, 1, 3, 5, -15,
    -34, 47, 3, -62, -14, 30, 10, -28,
    -5, -48, 45, 1, 28, -30, 30, -36,
    -69, -36, -78, -28, -24, 50, -27, 34,
    -12, 38, 42, 52, -62, -37, -37, 3,
    -41, 48, -45, -47, -42, -21, -75, -35,
    -35, -1, 51, -70, 8, 7, 47, -3,
    -12, -105, -27, -42, -19, -13, -17, 51,
    -45, 83, 53, -85, 18, -3, -17, -17,
    28, 28, 38, 8, -28, -5, -27, 86,
    -61, -32, 16, 17, -48, 6, -67, 32,
    52, 23, -9, -57, -32, 33, 0, 19,
    -70, 21, -77, -20, 63, -25, -33, 0,
    41, -14, 27, -16, 34, 50, -127, 12,
    3, 22, -11, -37, -23, -22, -65, -43,
    55, -58, 15, -62, -35, 7, 11, -35,
    -23, 97, -18, 56, -23, 24, -35, -29,
    -76, 23, -12, -9, -70, -51, 3, -33,
    -27, -22, 16, 8, 119, 10, -28, -3,
    64, -16, 25, -53, 36, -47, 24, -51,
    -42, -44, -4, -44, 93, -69, 34, -19,
    -31, -28, -8, -65, -1, -12, -19, -28,
    18, 15, -28, -50, -19, 25, 44, -40,
    38, 9, -43, -24, -12, -12, 6, -28,
    -27, 64, -25, -45, 4, -17, -8, -25,
    -6, 20, -37, -30, -7, 29, 40, 7,
    -6, 22, 26, -101, 8, 61, -49, 1,
    -45, -8, -26, -62, -7, 0, 3, -9,
    14, 49, -67, 32, 10, 3, 16, 27,
    21, 13, 46, 22, -42, 7, -6, -53,
    18, 29, -7, -8, 57, 7, 15, -14,
    -37, -2, -9, -14, -40, 40, -23, 24,
    3, 27, -29, 46, 60, -28, -5, 16,
    -37, 6, 11, 39, -1, 17, -17, -16,
    25, 14, 56, 41, 17, 57, -1, 3,
    51, -19, -39, 33, 29, 15, -45, 11,
    54, 69, -73, -48, 48, -27, 26, 52,
    5, -17, 2, 36, -25, -9, 12, -64,
    -36, 60, -56, -17, -48, -27, -36, -14,
    42, -50, -111, 1, 27, -61, -26, 28,
    -42, -37, -57, -12, 9, -36, 6, 8,
    16, -41, -10, 2, 11, -19, -50, 13,
    -33, -17, 40, -46, 20, -27, 11, 22,
    -68, -24, -83, -18, -40, -10, 33, 18,
    -17, -26, 18, 17, 5, -5, -127, 3,
    -25, -17, -3, -6, 43, -14, -62, -59,
    21, -13, 29, -89, 34, -10, -5, -10,
    27, -50, -78, -28, -37, -21, 77, 4,
    22, 37, -47, 7, -53, -17, -16, 30,
    -14, -3, -7, 21, -12, 42, -64, -19,
    8, 31, -68, -54, 5, 10, -3, -55,
    -23, -56, 61, -91, 71, -5, -30, 2,
    0, 30, -59, 53, 29, 0, 41, 27,
    -36, -23, -32, 25, -53, -11, -3, -13,
    21, 45, -10, 16, 64, 4, 26, -50,
    33, -101, 34, -7, -47, 30, -16, -32,
    -30, 37, -100, -7, 14, -42, -20, 5,
    32, -12, -28, -12, -40, 5, -65, -35,
    -29, -15, -25, 16, 30, 1, 71, 14,
    40, -36, 50, -20, -12, -28, -55, 10,
    -32, -8, 115, -47, 20, 23, -21, 8,
    -86, -28, -20, -66, -6, 22, 92, 29,
    14, 5, 47, -40, -35, -40, 29, -55,
    -12, 60, 35, 59, 11, -48, -10, -3,
    8, -127, -20, 20, -1, -3, 6, 18,
    35, -5, 40, -35, 14, 8, -10, 55,
    18, -33, -41, -13, 11, 7, 38, 28,
    -2, -53, 9, -11, -22, -15, 3, -13,
    -9, 14, 20, -7, -6, -12, -7, -14,
    0, -9, -8, 58, -29, 52, 17, 14,
    -2, 5, 14, -2, 12, -56, 7, -18,
    -19, -92, 38, -38, -14, 41, -2, 23,
    3, 50, 25, 56, 2, -43, 58, -1,
    -11, 3, 1, -26, 11, -20, 12, 9,
    -6, -53, 9, 14, 16, -23, -11, 24,
    -9, -42, 82, -11, -1, -30, 23, -23,
    -9, -69, 1, -4, -3, -5, -62, -21,
    -35, -28, 27, 13, -14, -14, -19, -12,
    37, 49, -25, 11, -20, 20, 20, 46,
    -29, -20, -24, -32, 8, 19, -16, 2,
    19, 47, -17, -38, -19, 35, 28, 21,
    -89, -18, -48, 1, -1, 8, 73, 20,
    -17, 12, -4, 6, 8, -4, 33, 3,
    25, 9, -35, -20, 25, 26, -37, 10,
    46, 6, -13, -6, -37, 5, -16, -17,
    -17, 20, -37, -19, 5, 4, -54, -30,
    10, 17, -36, 13, -15, 21, -13, 3,
    -22, 6, 3, -2, -28, 6, 10, 9,
    20, 51, -8, -25, -13, -9, 15, -8,
    -4, 44, 2, 8, -37, 30, 15, 5,
    15, -13, 25, 12, 17, 0, 6, 18,
    5, 28, -9, -14, 4, 6, -11, 40,
    -17, 15, 11, 5, -17, 29, -8, 16,
    36, -1, 28, -7, 17, -28, 14, 0,
    -11, 40, 29, 1, 37, 4, 2, 13,
    -23, -12, 4, -7, -34, 24, 31, -6,
    7, -45, -14, 37, -10, 6, -53, 32,
    16, -26, 29, -8, 1, 5, -17, 10,
    -41, 42, 15, -19, 31, 2, 4, -30,
    12, 9, 13, 16, -14, -13, -13, 32,
    14, 11, -3, -17, 3, -17, 14, 7,
    2, 8, -1, 12, -22, 14, -13, -13,
    -38, 79, -27, -13, -7, 15, 9, -6,
    16, 7, -9, 2, -15, 22, -11, -26,
    27, -16, 16, -25, -13, 39, 7, -7,
    27, -16, 8, -11, -27, -3, 0, -12,
    -41, 28, -41, 6, 21, -18, 1, -15,
    -7, -6, 10, -21, -28, 14, 10, 10,
    2, -5, -18, -23, 13, -4, 35, -96,
    -9, -14, -26, -8, -12, 48, -29, 10,
    29, -23, -34, 67, -13, -14, -18, -7,
    -7, 23, 7, 2, 48, -5, -29, 20,
    -7, -7, 9, 7, -11, 2, -10, 7,
    -22, 4, 4, 30, 33, 2, 38, -8,
    -19, -5, -15, 35, -3, -5, -18, 79,
    4, 9, 3, -8, -8, -15, -8, 25,
    10, -38, 35, 9, -26, -29, 33, -42,
    34, -17, 25, -22, 28, 8, 13, -16,
    3, -18, -22, 9, -9, 27, -19, -27,
    15, 9, 1, -6, 3, -7, -25, -19,
    16, -1, -7, -6, -13, 1, -11, -4,
    7, -2, -17, 14, 23, -9, -1, -6,
    3, 3, 7, 6, -1, -4, 26, 8,
    8, -11, -10, -15, -3, 37, -21, -29,
    15, 1, 21, 2, 9, 51, 7, 1,
    16, -19, 2, 31, 11, 1, 28, 12,
    7, 18, 12, 31, 28, 12, 22, 45,
    -10, -7, -9, -21, 24, 10, 0, -15,
    4, -20, 17, -22, 54, 3, -14, -21,
    6, -2, 8, -12, 6, -20, 9, 8,
    -26, -1, 12, -17, -1, 0, 0, 17,
    5, -2, -13, -1, -20, 2, 34, -6,
    32, -51, 13, 3, -12, 35, -21, -3,
    -32, 1, 2, 9, -17, 20, -52, -28,
    -17, 1, -1, -5, -17, 7, -3, -5,
    1, -25, -37, -10, 20, 40, -27, 15,
    23, -36, -24, -33, -17, -7, -25, 39,
    29, 5, 0, 17, -30, 16, -11, 12,
    -20, -36, -15, 17, -14, -13, -4, -9,
    -17, 9, 2, 11, 7, -26, -13, -25,
    64, -37, 27, 9, 39, 19, 10, -10,
    31, -41, 13, 13, -3, 28, -24, 2,
    -26, 16, 8, -27, 4, 2, 12, 22,
    8, 13, 31, 15, -7, 44, 9, -32,
    17, -11, 7, 8, 29, -64, -27, -47,
    0, -13, -26, -37, 2, -13, -7, 22,
    12, -12, 2, -17, -7, -4, 38, -14,
    15, -1, -2, -13, 31, 14, -15, 27,
    13, 18, -47, -17, -31, 8, 57, -68,
    -10, 3, 21, -53, -35, -11, 1, 1,
    -20, -25, 7, 4, -36, 25, 3, -20,
    10, -1, 23, -3, 6, 1, -27, -2,
    18, -25, 15, -4, -34, -50, -54, -39,
    -7, -20, 13, -14, 14, -14, 26, 0,
    15, -45, -31, 4, -2, -63, -1, -7,
    31, 4, -5, 37, 2, -2, -5, 24,
    -52, 14, -14, -34, 40, 2, 16, -1,
    13, 12, -3, -29, 14, -4, -9, 0,
    6, -4, 0, -8, 51, 3, 0, 9,
    -6, -12, 8, 30, 56, 8, -3, 29,
    9, 15, 37, -13, -11, 11, 10, 1,
    -43, 6, 2, -10, 12, 13, -3, 16,
    22, -9, -2, -33, -14, 0, 18, -5,
    -17, 2, 15, 14, -14, 16, -17, -48,
    -24, -45, 17, -44, -11, 5, 36, -15,
    -27, 3, -40, -5, -1, 25, -37, -2,
    0, 4, 33, -39, -13, -28, -24, 24,
    -4, 7, 5, 7, -17, -23, 25, 1,
    10, 5, -26, 5, -4, 13, 11, -4,
    -28, 39, -4, -22, -15, 11, -25, 13,
    -13, 76, -11, -7, 13, 45, 26, 20,
    10, 7, -13, 8, 16, 7, -14, 27,
    -31, -32, 5, -36, -1, 2, -11, 27,
    -12, 23, 6, -18, 25, -6, 14, 8,
    17, 1, 14, 31, -12, 0, 2, 2,
    19, 0, 4, 13, -49, 6, -6, -24,
    -30, -3, -7, 1, -7, -19, -15, -20,
    -21, 4, 4, 4, -11, 7, 15, -23,
    -6, 4, 10, -11, 19, -10, -7, 11,
    -7, -38, -12, -7, -15, -16, -17, 19,
    30, -12, 14, -18, 29, -10, 24, -4,
    22, 7, -3, 12, -23, 15, 16, -6,
    -10, -30, 4, -6, -22, 15, 48, -19,
    -25, -1, -1, 8, -2, -38, 14, -13,
    4, -9, 27, -5, 2, -6, 24, -42,
    -11, -43, 58, -24, -20, -27, -15, 4,
    0, -14, 7, 10, -2, -9, 63, -26,
    27, 14, 2, -12, 26, -43, 54, -10,
    41, -5, 1, -20, -44, -31, -33, -20,
    -23, 3, 18, -19, 11, 6, -10, -29,
    25, 13, -26, 24, 0, 0, 44, -14,
    3, 3, 1, 2, 10, 7, -14, 2,
    -24, 5, 3, -4, 3, -13, 2, -4,
    -7, -5, 7, -17, -24, 16, -15, 8,
    -1, 5, -4, 40, 7, 18, 21, -35,
    4, 6, -6, -17, -28, 23, -11, 35,
    4, 20, -19, 11, 6, 14, 11, 55,
    11, 9, 2, -12, 1, -9, -17, -30,
    15, 15, -30, 42, 8, -12, -4, -39,
    25, -23, 0, 2, 35, 13, 3, -20,
    -7, -42, 21, 0, -31, 30, 30, -52,
    22, -10, 1, -44, -11, -4, -20, -9,
    15, 21, 23, 40, -11, 6, 14, -9,
    13, -2, 15, -1, -64, -5, -19, -21,
    14, 38, -4, 3, 5, -39, -28, 4,
    -1, -7, -16, 30, 14, 10, -31, -12,
    -10, -8, -32, 10, -11, -20, 9, 54,
    5, 0, 7, -2, 38, -17, 0, -9,
    2, -18, 0, 3, 5, -18, -3, 3,
    17, -4, 9, -15, 8, 2, 17, 2,
    6, -29, -11, 8, -23, -28, -6, -22,
    -3, 7, -6, -21, 15, 8, 16, 18,
    11, -8, 24, -34, 1, 9, 13, -8,
    -18, -19, -1, 8, 4, 28, -30, -18,
    -11, -10, -16, -14, -41, 6, -29, -12,
    -3, 24, 12, -10, 1, 36, 22, 1,
    -14, -40, 20, 11, 12, -24, 15, -4,
    10, -9, -10, 2, -25, -2, 0, -14,
    2, 21, -4, -23, -14, 3, -13, -31,
    -7, 10, 8, -33, 21, 24, 13, 9,
    11, 22, -10, -30, -49, 3, -9, -4,
    48, 31, 48, -3, 25, 10, 16, -1,
    10, 3, 6, -8, 34, 2, 1, -1,
    -14, 12, -26, 16, -1, -2, 49, 6,
    50, 34, 3, -33, -2, 0, -13, 5,
    17, 33, 2, -44, 6, 10, -30, 21,
    -46, 29, 1, -14, 21, -12, 6, 24,
    -2, -11, 9, 5, 2, -7, 23, 37,
    1, -41, -37, -18, -3, -9, 13, 29,
    6, 9, 24, -1, -6, -17, -34, 11,
    -2, -1, 10, 25, 9, 7, 0, 8,
    22, 25, -12, -34, 32, 9, -7, -29,
    -48, 21, -3, 7, 26, -10, -32, 11,
    -4, -19, 6, -43, -51, 10, 5, 12,
    -16, 16, -8, 35, 5, -11, -3, 5,
    -21, 43, 9, 12, -53, 27, -20, 10,
    -14, 6, 16, -24, -28, -37, 12, -66,
    -3, 25, 8, -5, -9, 37, -17, 30,
    6, -3, -24, 14, 15, -48, -36, 3,
    -2, 29, 19, 16, 15, -23, 20, 37,
    20, -9, 19, 10, 18, 1, -18, 19,
    -28, 2, -12, 24, 21, 5, -19, 2,
    21, -12, 4, -9, -20, -7, 1, 0,
    21, -10, 12, -26, 2, -9, -1, -29,
    -7, -31, 6, -17, -12, -17, 32, -28,
    21, -4, 4, -12, 5, 15, 2, -2,
    -6, -24, 14, 6, -6, 13, -1, -19,
    6, -3, -11, -3, -4, 17, -41, -27,
    -5, -27, -50, -30, -40, -15, -6, 14,
    -5, -8, 4, 8, -1, -37, 8, -15,
    8, 12, 51, 0, 1, -3, 1, 20,
    18, -7, -9, -12, 30, 26, -18, 5,
    7, 15, 33, -7, 33, 7, 1, 23,
    19, -23, 3, 11, -2, 2, 36, 3,
    -25, 16, 3, 0, -1, 21, 2, 28,
    -40, -14, 7, -24, -15, 6, 29, -26,
    -7, -1, 10, -22, 33, -25, 5, -2,
    17, 4, 21, -9, 51, -2, 30, 0,
    -12, -25, -10, -3, -4, 15, -16, -2,
    10, -15, -15, -20, -8, -21, 24, 11,
    -3, -41, -7, -39, -51, 19, 7, -6,
    -7, -22, 2, 32, -17, 25, -29, -9,
    -14, 21, 6, 26, -2, 2, -2, -8,
    9, 3, 4, -19, 17, 0, -8, 18,
    49, -12, 32, -10, -14, 21, 30, 18,
    17, 25, -21, -4, -14, 4, 9, -4,
    -23, -32, -6, 0, -11, -4, -17, -10,
    36, 6, 4, 0, 38, 7, -24, -28,
    15, -1, -28, -5, 15, 20, -21, -10,
    41, -50, 8, 1, 11, 6, 34, -2,
    15, 38, 40, -16, -11, 23, 10, 16,
    -29, 7, 9, 24, -22, -15, 2, 31,
    4, 8, -13, -9, 10, -40, -19, 6,
    11, -31, 3, 4, -31, -20, -26, 15,
    37, -23, -20, -1, 6, 15, -5, -19,
    9, 2, -17, -17, -12, -9, -6, 7,
    3, -35, -6, -28, -34, -20, 40, -3,
    0, 20, 3, 37, -27, -19, -2, -4,
    0, -23, -13, -13, 3, -18, 7, 2,
    4, -16, -16, 5, 0, -41, -9, -22,
    32, -28, 41, 22, -41, -6, 18, -23,
    -1, -22, -18, 20, 16, -10, -26, 2,
    -2, 42, -14, 23, -3, 12, -6, -20,
    6, 14, -6, 38, 39, 21, -27, 35,
    18, -5, -64, -25, 16, 17, 18, -7,
    -12, 24, -52, 6, -19, -1, 2, 8,
    -50, -13, 2, -45, 17, 4, 40, 10,
    15, -5, 18, 13, 73, -5, 41, 7,
    34, 13, 19, -20, -22, -4, -18, -14,
    -24, -37, 8, 7, 44, 2, 26, -27,
    25, -21, 4, -12, 23, -33, 1, 11,
    -11, 8, -14, 17, -5, 36, 35, -36,
    -27, 16, -16, -10, -19, -1, 24, -8,
    -15, -3, -3, -37, 28, 17, -72, 18,
    11, -35, -7, -28, 10, -20, -50, 33,
    15, 7, -7, 19, 6, -11, 8, 36,
    13, -1, -28, 4, -14, -4, 7, 17,
    -27, 35, -16, -36, 7, -10, -6, -7,
    -7, 27, -12, -20, 7, 12, 0, -3,
    -14, 6, -20, 19, -10, -20, -11, 75,
    -23, -14, 13, 0, 5, 5, 18, 48,
    -44, -5, 16, -32, 48, 4, -15, 16,
    35, 0, 12, 11, 38, -8, 3, 12,
    18, -7, -23, -7, 5, -8, 23, -1,
    8, 17, -23, -21, -4, -12, -15, -11,
    25, 8, 2, 10, -15, -9, 10, 9,
    -9, 5, 3, -38, 23, 1, -17, -42,
    -9, -30, -7, 8, -44, -23, 46, 17,
    9, -25, -5, -55, 18, -32, 21, 32,
    4, -19, -26, 33, -16, 22, 13, -24,
    14, 15, -15, 9, -24, 19, 5, -5,
    0, -19, 21, 13, 8, 2, -35, 5,
    -3, -26, -3, -3, 20, -20, 20, 0,
    25, 16, 22, -24, -31, -13, 2, 24,
    27, 20, -29, -3, -5, -19, 9, -17,
    19, 34, -4, 14, -17, -5, -8, -26,
    -20, 27, 15, 79, -47, -9, -2, -4,
    21, -10, -8, 17, -2, 6, 1, -45,
    6, 16, 7, -5, -38, 11, 31, -31,
    -10, -4, -1, 2, -3, 14, 0, -1,
    -18, -8, -33, 24, 1, 0, -24, 11,
    5, -29, 7, 24, -19, 19, 10, -31,
    6, -11, -10, -7, 15, 16, -11, -50,
    0, 19, -16, 7, -11, 1, -29, 35,
    0, 17, -70, 21, -17, 7, 24, 2,
    13, 8, -15, -31, 15, 7, 33, -17,
    -1, 29, -15, 1, 21, -3, -14, -28,
    12, -6, -16, 0, 44, -23, 4, -1,
    2, 13, 3, 41, -41, 40, 25, -33,
    7, -6, 4, -9, 6, -1, -10, -7,
    -2, -13, 8, 10, 5, -13, 3, -5,
    17, 12, -5, 4, -20, 10, 22, 6,
    -2, 40, -7, -31, -17, -17, -40, -5,
    -11, 0, -14, 2, 2, -11, -9, 1,
    13, 12, -10, -1, -17, -29, -1, 0,
    -8, -7, 20, 8, 31, -26, -11, -3,
    4, -17, 49, 1, -9, -2, 2, 12,
    1, -10, -19, 7, 32, -5, 3, -5,
    -2, -6, 16, 13, 0, 12, -12, -29,
    21, 25, -20, -24, 18, -28, -5, 27,
    3, -11, -45, -15, -11, 7, -1, -20,
    -6, -18, 18, 15, 27, -4, 7, -11,
    33, -3, 22, -10, 22, 7, -67, -23,
    29, -36, -16, 20, -24, 24, 7, -36,
    13, -17, 28, -12, -16, 17, -9, 9,
    -38, 11, 1, -8, -30, 61, -14, 8,
    16, -4, 5, 2, -24, -10, -30, -24,
    25, -35, 6, 42, -30, 50, -3, -24,
    -17, -44, -1, -20, -29, 23, -3, -79,
    12, 42, 51, 34, -28, -2, -18, 42,
    -45, -30, -42, -39, 18, 2, 40, -27,
    112, -16, 54, 1, -33, -40, -24, -9,
    18, 17, 8, 23, -77, -52, -58, -2,
    32, 73, 74, -71, -7, -43, -35, 7,
    -1, -7, -1, 25, 16, -43, 82, 34,
    9, 25, -3, 4, 7, 29, 27, 27,
    35, -32, -8, 7, -18, 7, 21, 44,
    4, -72, 12, 42, -4, -24, -16, 46,
    17, -68, 8, -3, -5, -34, 3, 15,
    -4, -33, 36, 93, 50, 0, -51, 24,
    -23, 2, -35, 25, -25, 55, -58, -37,
    -4, 25, -16, -46, -34, 32, 12, -2,
    34, 27, -5, 1, 15, 23, 9, -8,
    -10, -41, 38, -3, 3, 88, -15, 12,
    16, -30, -37, 99, 0, -40, 36, -85,
    -40, 5, -15, 2, 31, 64, 41, 56,
    19, -33, -68, -43, -12, -37, -38, 71,
    46, -12, -13, 7, -18, -44, 40, 1,
    46, -14, 19, -37, 45, -30, 6, -8,
    0, -6, -13, -41, 38, -25, -9, 14,
    5, 5, 41, -20, 8, -20, 21, -94,
    -97, 37, -28, 20, 35, -54, -23, -12,
    -10, -20, 30, 11, 28, -49, -9, 9,
    -14, 18, 13, -13, -4, -17, -20, -45,
    -1, 34, 8, -32, 10, -41, -70, -24,
    -11, -36, -6, 4, 1, 18, 27, -23,
    21, -23, 10, 31, -34, -3, 11, 16,
    -2, -28, 33, 4, -1, -47, 17, -4,
    16, 22, -8, -8, -12, -14, -44, 16,
    -33, -3, -3, -11, 52, 40, 11, 15,
    32, -44, -19, -35, -7, 71, 21, -3,
    -9, 6, 33, -20, -1, -2, 8, -1,
    -35, -38, 0, -24, -6, -39, 9, -72,
    22, 28, 8, -13, 49, -41, -28, 12,
    26, -6, 3, -38, -56, -46, 9, 20,
    31, -20, 55, -4, 48, 9, 60, 6,
    -59, -70, -12, -2, -9, 36, 41, -54,
    -19, 26, 12, 32, 12, -13, -69, 18,
    2, 6, 73, 14, 9, -7, -56, -22,
    -20, -24, 27, 38, 12, 23, -107, -4,
    -3, 13, 8, 91, 22, -34, -7, -24,
    -31, -11, 39, 44, 11, 30, 23, -30,
    26, 19, 51, -2, -16, -36, 48, -49,
    13, -59, 27, -37, 40, 62, 60, 2,
    11, -10, -20, 30, -11, 20, -5, -17,
    18, -21, 3, 5, 43, 0, -23, 2,
    -15, 8, 25, -24, 92, 19, 36, 4,
    74, -41, 27, -75, 24, 25, 2, -16,
    -1, -10, 54, -71, 2, 27, 36, -8,
    12, -32, 8, -10, -23, -30, 50, 79,
    19, -53, 26, -41, -39, 101, -6, 15,
    -55, -18, -6, 22, -51, -31, -51, -22,
    42, -49, -12, 9, 34, -29, 9, -47,
    4, 0, 32, 0, 43, -4, 15, -1,
    -13, 51, 12, -13, 34, 47, 21, -12,
    12, 13, -35, -29, -10, -36, 22, -12,
    2, -5, -30, -2, 41, -38, 22, -9,
    -26, -1, 7, 4, 6, -78, -52, -7,
    31, 29, 22, -13, -25, 56, -15, -11,
    21, 64, -90, -39, 7, -26, 4, 51,
    11, 65, 24, -8, 11, 118, -13, -19,
    -41, -2, 26, -29, 6, -14, -4, 34,
    -36, 56, -16, -58, 23, -9, -20, -49,
    -41, 42, -39, 58, -27, -36, -16, -1,
    32, -14, 0, -79, -28, -36, -16, -15,
    12, -9, -36, 28, 12, -30, 80, 2,
    -58, -71, 31, -22, 15, -13, 9, -40,
    -30, -1, 29, 21, -15, 24, -9, -31,
    8, 7, 30, -11, -125, 31, -24, -8,
    -35, -56, 23, 21, 46, 24, 34, -29,
    16, 12, 19, 15, 10, -4, -40, -58,
    -50, -10, 14, -39, 28, 13, -27, -19,
    23, -30, -29, 12, 40, -85, 36, 33,
    -44, 15, -25, 4, 0, -57, 21, 54,
    -41, -16, -24, -55, 13, -43, 26, 50,
    -54, -19, -87, -33, -2, -47, -98, -1,
    -31, -32, 50, 12, 37, -71, -14, -17,
    26, 2, -39, -51, 12, -14, 37, -16,
    -2, -28, 56, 16, -15, -22, 15, 18,
    -65, -25, 33, 22, -14, 0, -2, 3,
    42, -7, -33, -10, -35, -23, 23, 12,
    -35, -9, -14, -26, 36, -17, 12, 19,
    -33, -31, -12, -35, 4, -16, -28, -23,
    19, -7, 54, 17, -27, 17, 19, 95,
    -4, -15, 34, -27, -33, 35, 19, -8,
    85, -29, -20, 26, -82, -4, 20, 5,
    16, -29, -26, 25, -67, -7, -2, -27,
    12, 25, -54, -2, 4, 15, 45, -2,
    -15, 52, -9, -59, -2, -16, -3, -10,
    44, 5, 20, 16, 25, 23, -62, 4,
    -19, -30, -15, 68, -51, -8, 14, -37,
    -58, 79, 79, -17, -22, 24, -28, 27,
    -32, 32, 69, -15, -8, 21, 74, -38,
    -32, 16, -7, -44, 33, 13, -83, -17,
    49, 12, 17, -16, -1, -3, 48, 72,
    65, 12, -50, 25, -34, -40, -51, -78,
    -93, 5, 71, -42, 15, 1, -38, 10,
    -2, -11, 1, 15, -27, 21, -35, 8,
    -3, -34, -29, -19, -19, -4, -75, 31,
    12, 10, -30, -57, -12, 15, -18, -73,
    0, -12, -12, 3, 7, 23, -17, 29,
    -7, -19, -8, -72, -29, 7, -56, 19,
    -33, 32, 22, -22, -4, 45, -4, 60,
    11, 45, 5, -40, 8, 11, 10, -66,
    -4, 10, -45, 20, 0, -7, -1, 12,
    -43, 20, -17, 4, 54, -72, -7, 24,
    2, -17, -39, -38, -44, 22, 12, 35,
    1, 17, -44, 32, -20, 32, 0, -27,
    -27, 10, -21, -6, 3, 23, -16, -10,
    -77, 2, -49, -3, 7, -7, 27, 18,
    -15, -13, -26, -11, 18, -3, 21, -16,
    94, -28, -7, -58, -15, -26, -21, 1,
    -45, 5, 43, -15, 55, -21, 36, -67,
    -53, -35, -42, 44, 66, 10, -10, -2,
    1, -11, -27, 10, -29, -5, 28, 20,
    -4, -4, 4, -19, 59, -7, -10, 30,
    -39, -46, 20, 25, 29, 25, -26, -16,
    -28, 8, 5, 12, 11, -13, 24, -1,
    -16, -12, 3, 11, 21, 17, -5, -23,
    -36, -34, 21, 6, 63, 4, -18, -32,
    58, 0, -11, 10, -23, 5, 44, -47,
    9, -3, 7, -17, -9, 10, -7, -5,
    3, -38, -11, -9, -12, 0, 5, -3,
    -10, 4, -11, 3, 9, -1, 32, -2,
    -29, -7, -36, 30, 9, -23, -20, -23,
    -6, -11, 6, 9, -6, -10, 7, 1,
    -15, -35, -11, -61, 4, -7, -1, -13,
    -11, -2, 14, -5, 12, -11, 2, -6,
    6, -10, -11, 2, -18, 39, 12, 14,
    -24, -12, -5, -14, -22, -50, 50, -37,
    17, -9, 50, 1, 3, 12, -3, -10,
    -4, -6, 2, 0, -10, 13, 6, 34,
    -24, -20, -18, 12, 22, -2, -30, -4,
    -9, -5, -4, -10, -32, 45, -12, -15,
    33, -13, -8, -7, -6, -6, -5, -17,
    -5, -22, 10, -2, 4, -15, 13, 25,
    18, -8, 27, -6, 10, 4, -18, 10,
    2, 0, 1, -3, -7, -17, 13, -1,
    7, 42, 6, -27, -9, 11, 9, 2,
    -1, 16, 4, -16, 9, -6, -16, 5,
    -2, -12, 1, 15, -14, 17, 23, -14,
    -1, -5, -5, 12, 6, 14, -35, -3,
    25, -20, 20, -35, 9, 11, 6, 2,
    -18, 5, 1, 3, -17, 6, -5, 8,
    -3, 25, -16, 20, -26, 7, -10, 41,
    14, -8, 7, -2, 25, 3, 1, -19,
    -32, -17, -15, -34, 1, -12, 13, 2,
    3, 8, -1, -3, -7, 14, 12, 15,
    -38, 22, -22, 4, 10, -23, 16, -13,
    -5, 9, 1, -16, -1, -26, 23, -41,
    16, 55, -17, 15, -1, -5, 4, -10,
    1, -4, 10, -6, 0, -4, 17, -7,
    -8, -23, -2, 18, 22, -8, -18, -9,
    -6, 7, 3, 7, -8, -11, -26, -7,
    2, 13, 34, -1, 1, -13, -8, 3,
    0, 3, 3, -16, -45, 1, -5, 84,
    -13, 8, 2, -13, 54, -14, -12, -35,
    6, -5, -2, -8, 0, -27, -5, 3,
    -3, 2, -24, -4, 5, -8, -7, 18,
    -3, -15, 8, -16, 19, 15, -7, 8,
    -5, -43, 12, 4, -46, 56, 6, -36,
    -17, -5, 13, -3, -62, 5, 8, -7,
    -5, -41, -4, 30, -2, 10, 3, -10,
    -10, 7, -2, 2, 6, -15, 15, -23,
    -5, 3, -8, 10, -8, 9, 25, 21,
    7, -17, -4, -15, 5, 8, -28, -52,
    -2, -35, -54, 10, -2, 3, -7, 0,
    0, 11, 10, -6, -6, 16, -5, -19,
    11, -30, 21, -19, 37, 10, -8, -12,
    -9, 4, -6, -3, -23, 3, 15, -8,
    1, -45, 28, -14, 4, -3, -6, -1,
    -24, 9, -14, 7, -13, 0, -16, -4,
    -1, -7, -25, 31, 43, -13, 20, -25,
    -8, 16, -2, -18, 26, 29, -56, 0,
    -27, -67, 58, 19, -4, 6, -1, -1,
    9, 12, 9, -13, 3, -21, 3, -16,
    24, -7, -14, 12, 20, -21, 3, -28,
    0, 26, 7, -2, 22, -18, 16, 40,
    -22, 0, -5, -9, -1, 3, -1, -5,
    -5, 2, -9, -8, 4, -9, -6, -11,
    -7, -21, -17, -10, -9, -18, 35, 34,
    11, -2, 18, 20, 21, -30, -5, 16,
    -8, 13, -36, -10, 0, -4, -4, -1,
    -2, -11, -3, -2, -4, 5, 4, -14,
    -12, -17, -9, -9, -31, -7, 9, -41,
    11, 5, -8, 3, 12, -2, 29, -26,
    20, 15, -9, -4, 1, -1, 1, 3,
    14, -12, 13, 3, -12, -12, 14, 9,
    -37, -4, -7, -21, 27, 14, 25, 26,
    7, -4, 6, 6, 5, -13, 16, 3,
    -53, 27, -31, -31, -8, 4, -2, -1,
    1, 8, 17, 1, -7, -2, 12, 14,
    0, 0, -9, 0, 13, -9, -12, -2,
    6, -16, -7, 4, 3, 32, -3, 3,
    6, -10, -57, -2, 7, 10, -7, 1,
    18, 8, 1, 18, 5, -8, 5, -2,
    -26, 25, -2, -13, -58, -58, -9, 23,
    -13, -14, 24, -18, 36, 4, 4, -19,
    19, -11, -39, 34, 6, 0, 3, -1,
    -1, -10, 15, -3, -26, -9, 11, 21,
    47, -22, 26, -5, -22, 2, 19, 19,
    -2, -13, -5, 4, 33, -19, 41, -6,
    -28, -5, -19, -19, -7, 3, 12, 9,
    -5, 30, 6, -3, 2, 4, 16, -53,
    13, 18, 1, -21, -3, -46, 27, 27,
    10, 5, -17, 8, 16, 16, 8, 19,
    16, -24, -12, -21, -11, 6, -12, -11,
    -6, 42, 22, -16, 22, 3, 27, 10,
    -17, 19, 3, 5, -21, 26, -36, 6,
    -23, -7, -6, -9, -5, -19, -19, 50,
    11, 23, -3, 40, -3, -5, -1, -6,
    4, 2, -10, -12, 4, -15, 3, -18,
    -24, -1, -9, 4, -20, 7, -39, -3,
    -9, -4, 19, -15, -10, 16, 1, -1,
    -16, -4, -34, -17, 4, 3, 6, 8,
    -19, 5, 28, 4, -3, -4, 13, -13,
    9, -10, -27, 16, 25, 14, 30, -2,
    -8, 1, -2, -13, -27, 23, 10, -21,
    -2, 42, -6, 23, -6, -9, 16, 1,
    -6, -9, -5, 12, 6, -6, 7, 12,
    18, -11, 18, -35, 27, 17, 3, -18,
    2, -2, 14, 10, -3, -18, -34, 18,
    -16, -16, 2, -3, 7, 3, 13, 13,
    10, -3, 0, -21, 4, -2, -13, -11,
    -7, 3, -1, -25, 20, 22, 10, -21,
    13, 17, 20, 4, 16, -1, 26, 64,
    -9, -29, -14, 9, 1, -2, -1, -4,
    7, 16, 7, 5, -20, 13, -5, -2,
    -5, 14, 13, -10, 27, 16, -17, -18,
    -5, 1, 2, 8, -17, 23, 33, 60,
    15, 11, -1, -16, -1, 1, -4, 4,
    -2, -1, -3, 6, -12, -10, -10, -10,
    11, -18, 10, 40, -31, -7, 3, -20,
    13, 5, -2, -10, -24, 40, 10, -17,
    -21, -33, 57, 28, -4, 21, 3, 0,
    -3, 5, -21, -10, -10, 20, -3, -15,
    -17, 12, -9, -19, 6, -9, -6, 2,
    -10, -1, 4, -13, 23, -14, 21, 28,
    37, -29, -11, 30, -4, 1, -5, -8,
    -16, 4, -4, 18, 4, -39, -8, 13,
    -10, 31, 8, 8, 20, -16, 29, -19,
    -6, -2, 2, -9, -28, 20, 23, -6,
    23, 18, 2, 29, 1, -9, -12, 5,
    -6, -18, -4, 0, -5, -10, 9, -33,
    5, -14, -10, 26, 4, -4, -14, -14,
    12, -4, 7, -10, 61, 13, 4, -16,
    40, -26, -7, -8, 6, 4, 24, -17,
    -28, -2, 17, -2, -3, -14, 7, -38,
    41, 24, -5, 33, -39, -1, -2, 22,
    3, -5, -7, -17, 42, 23, 10, -14,
    37, 92, -10, -3, -6, 16, 14, 8,
    -20, -3, -12, 0, 6, -14, 31, -5,
    32, 35, -8, -13, 46, 32, -2, 43,
    7, -16, -5, 12, 6, 14, 20, 17,
    -47, 7, -23, -33, -5, -5, -9, -12,
    -12, -8, 7, 2, 4, 6, -14, -14,
    0, -22, 16, 14, -23, 18, -17, 64,
    -19, -8, -32, 11, -33, -18, 20, 18,
    38, -6, 57, -4, 19, 6, 3, -9,
    -20, -8, 0, -23, -23, 2, 3, -14,
    -22, -47, 12, 50, -45, -27, -46, 20,
    -10, -1, 2, 3, -27, -18, -31, -22,
    34, -18, 3, -19, -7, -4, -9, -27,
    -4, -59, 5, 14, 6, -22, 24, -1,
    -17, 17, 11, -11, -14, 18, 20, -1,
    -16, -19, 13, 17, -4, -19, 29, -1,
    30, 25, 32, 29, 3, 7, 13, 7,
    4, 5, 5, 17, 7, -21, -15, -3,
    -52, -50, 23, -23, -26, -89, 41, -37,
    3, -11, -23, -12, -23, 30, 7, -57,
    -7, -6, 5, 6, 2, 0, 16, -6,
    6, 2, -11, -5, 3, 9, -16, 13,
    20, -3, -37, 22, -5, -9, -44, -8,
    7, -5, 11, -5, -28, 10, 40, 14,
    -65, -31, 23, -8, 5, -16, 1, 3,
    10, 9, -6, -20, 9, -12, -4, 8,
    4, 3, 22, 31, -52, 13, 22, -18,
    -11, -7, -8, -7, -21, -13, -20, -24,
    -10, 8, 8, -67, -20, 5, 0, -21,
    7, 16, 7, -2, -14, 2, 7, 12,
    -7, 16, 43, 1, 15, -3, -36, -13,
    -1, 28, 18, 7, -21, -12, -12, 2,
    5, 1, -7, 15, -2, -1, -11, -1,
    2, 6, -21, -10, -56, -14, -6, 97,
    3, 5, -5, -19, 29, -19, -26, -33,
    -17, 11, 4, -13, -39, 52, 11, 10,
    -27, -76, 15, 12, -3, 0, -10, 5,
    -23, -15, 10, -34, 37, -2, -24, 18,
    -25, -40, 37, 9, -43, 3, 10, -42,
    10, -1, 15, -13, -68, 57, 14, -9,
    -1, -19, -40, 31, -10, 12, 11, -5,
    27, 27, 3, -9, 13, -22, -11, 3,
    30, -28, -13, -4, -18, 52, -15, 7,
    -4, -15, -28, -24, 22, 36, -23, -38,
    -16, -13, 1, 37, 2, -12, -7, 1,
    1, 12, 9, -6, -7, 8, -26, -13,
    -1, 20, -25, -2, -24, -33, -14, -22,
    -7, 2, -4, 6, -2, -11, -7, 43,
    17, 18, 27, -3, 4, 3, -10, -9,
    -9, 11, -7, -16, -2, 6, 6, -13,
    -10, 5, -12, 18, 10, 88, 4, -5,
    8, -1, -10, 3, 57, -51, -15, 0,
    -70, 21, 42, 29, 17, 6, -3, -8,
    -2, -9, 26, -8, 10, -21, 11, -3,
    -17, -5, -57, 6, -32, 18, 0, 0,
    -5, 11, 0, -3, 45, 40, -27, 61,
    19, -14, -42, -37, -1, -3, 1, -8,
    4, 12, -15, 11, -6, 42, 7, 5,
    26, 49, 16, -17, -7, -68, 39, 24,
    2, -6, 20, 14, -12, -13, 1, -25,
    -5, -44, -32, -14, 1, -10, 2, 6,
    1, 0, -6, -1, 2, 5, 24, -18,
    -29, -