/**************************************************************************\
 * Copyright (c) Kongsberg Oil & Gas Technologies AS
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * 
 * Neither the name of the copyright holder nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
\**************************************************************************/

#include <VolumeViz/misc/CvrCentralDifferenceGradient.h>
#include <Inventor/SbVec3f.h>
#include <Inventor/SbVec3s.h>

// *************************************************************************

SbVec3f
CvrCentralDifferenceGradient::getGradient(unsigned int vx, unsigned int vy, unsigned int vz)
{
  //return SbVec3f(0,0,0);
  int x = (int) vx;
  int y = (int) vy;
  int z = (int) vz;
  
  // Calculate gradient using the central difference algorithm
  SbVec3f g;
  g[0] = static_cast<float>(getVoxel(x-1, y, z) - getVoxel(x+1, y, z));
  g[1] = static_cast<float>(getVoxel(x, y-1, z) - getVoxel(x, y+1, z));
  g[2] = static_cast<float>(getVoxel(x, y, z-1) - getVoxel(x, y, z+1));
  if (g.length() > 0) {
    g.normalize();
  }
  return g;
}
