/*
 * Copyright 2019 Google LLC
 *
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

#ifndef GrClientMappedBufferManager_DEFINED
#define GrClientMappedBufferManager_DEFINED

#include "include/gpu/GrDirectContext.h"
#include "src/gpu/ClientMappedBufferManager.h"
#include "src/gpu/ganesh/GrGpuBuffer.h"

// This is declared as a class rather than an alias to allow for forward declarations
class GrClientMappedBufferManager :
        public skgpu::ClientMappedBufferManager<GrGpuBuffer, GrDirectContext::DirectContextID> {
public:
    GrClientMappedBufferManager(GrDirectContext::DirectContextID ownerID)
            : ClientMappedBufferManager(ownerID) {}
};

bool SkShouldPostMessageToBus(const GrClientMappedBufferManager::BufferFinishedMessage&,
                              GrDirectContext::DirectContextID potentialRecipient);

#endif
