/////////////////////////////////////////////////////////////////////////////
// Name:        wx/msw/wrapwin.h
// Purpose:     Wrapper around <windows.h>, to be included instead of it
// Author:      Vaclav Slavik
// Created:     2003/07/22
// Copyright:   (c) 2003 Vaclav Slavik
// Licence:     wxWindows licence
/////////////////////////////////////////////////////////////////////////////

#ifndef _WX_WRAPWIN_H_
#define _WX_WRAPWIN_H_

#include "wx/platform.h"

// before including windows.h, define version macros at (currently) maximal
// values because we do all our checks at run-time anyhow
#include "wx/msw/winver.h"

// strict type checking to detect conversion from HFOO to HBAR at compile-time
#ifndef STRICT
    #define STRICT 1
#endif

// this macro tells windows.h to not define min() and max() as macros: we need
// this as otherwise they conflict with standard C++ functions
#ifndef NOMINMAX
    #define NOMINMAX
#endif // NOMINMAX


// For IPv6 support, we must include winsock2.h before winsock.h, and
// windows.h include winsock.h so do it before including it
#if wxUSE_IPV6
    #include <winsock2.h>
#endif

#include <windows.h>

// #undef the macros defined in winsows.h which conflict with code elsewhere
#include "wx/msw/winundef.h"

#endif // _WX_WRAPWIN_H_
