# Asterix parser generator

*Asterix* is a set of standards, where each standard is defined
as so called *asterix category*.
In addition, each *asterix category* is potentially released
in number of editions. There is no guarantie about backward
compatibility between the editions.

The structured version of asterix specifications is maintained
in a separate project:
<https://zoranbosnjak.github.io/asterix-specs/specs.html>

The purpose of this directory is to convert from structured
specifications (json format) to the `epan/dissectors/packet-asterix.c` file,
which is the actual asterix parser for this project.

It is important **NOT** to edit `epan/dissectors/packet-asterix.c` file
manually, since this file is automatically generated.

## Manual update procedure

To sync with the upstream asterix specifications, run:

```bash
# show current upstream git revision (for reference)
export ASTERIX_SPECS_REV=$(./tools/asterix/update-specs.py --reference)
echo $ASTERIX_SPECS_REV

# update asterix decoder
./tools/asterix/update-specs.py > epan/dissectors/packet-asterix.c
git add epan/dissectors/packet-asterix.c

# inspect change, rebuild project, test...

# commit change, with reference to upstream version
git commit -m "asterix: Sync with asterix-specs #$ASTERIX_SPECS_REV"
```

## Automatic update procedure

To integrate asterix updates to a periodic (GitLab CI) job, use `--update` option.
For example:

```
...
# Asterix categories.
- ./tools/asterix/update-specs.py --update || echo "asterix failed." >> commit-message.txt
- COMMIT_FILES+=("epan/dissectors/packet-asterix.c")
...
```

