/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.8.5
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"
        #include <wx/affinematrix2dbase.h>
        #include <wx/geometry.h>
        #include <wx/affinematrix2dbase.h>


PyDoc_STRVAR(doc_wxAffineMatrix2DBase_IsEqual, "IsEqual(t) -> bool\n"
"\n"
"Check that this matrix is identical with t.");

extern "C" {static PyObject *meth_wxAffineMatrix2DBase_IsEqual(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAffineMatrix2DBase_IsEqual(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        const ::wxAffineMatrix2DBase* t;
        const ::wxAffineMatrix2DBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_t,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxAffineMatrix2DBase, &sipCpp, sipType_wxAffineMatrix2DBase, &t))
        {
            bool sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_AffineMatrix2DBase, sipName_IsEqual);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsEqual(*t);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_AffineMatrix2DBase, sipName_IsEqual, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAffineMatrix2DBase_Set, "Set(mat2D, tr)\n"
"\n"
"Set all elements of this matrix.");

extern "C" {static PyObject *meth_wxAffineMatrix2DBase_Set(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAffineMatrix2DBase_Set(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        const ::wxMatrix2D* mat2D;
        const ::wxPoint2DDouble* tr;
        int trState = 0;
        ::wxAffineMatrix2DBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_mat2D,
            sipName_tr,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9J1", &sipSelf, sipType_wxAffineMatrix2DBase, &sipCpp, sipType_wxMatrix2D, &mat2D, sipType_wxPoint2DDouble, &tr, &trState))
        {
            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_AffineMatrix2DBase, sipName_Set);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Set(*mat2D, *tr);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPoint2DDouble *>(tr), sipType_wxPoint2DDouble, trState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_AffineMatrix2DBase, sipName_Set, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAffineMatrix2DBase_Get, "Get() -> (mat2D, tr)\n"
"\n"
"Get the component values of the matrix.");

extern "C" {static PyObject *meth_wxAffineMatrix2DBase_Get(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAffineMatrix2DBase_Get(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        ::wxMatrix2D* mat2D;
        ::wxPoint2DDouble* tr;
        const ::wxAffineMatrix2DBase *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, SIP_NULLPTR, "B", &sipSelf, sipType_wxAffineMatrix2DBase, &sipCpp))
        {
            mat2D = new ::wxMatrix2D();
            tr = new ::wxPoint2DDouble();

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_AffineMatrix2DBase, sipName_Get);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Get(mat2D, tr);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipBuildResult(0, "(NN)", mat2D, sipType_wxMatrix2D, SIP_NULLPTR, tr, sipType_wxPoint2DDouble, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_AffineMatrix2DBase, sipName_Get, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAffineMatrix2DBase_Concat, "Concat(t)\n"
"\n"
"Concatenate this matrix with another one.");

extern "C" {static PyObject *meth_wxAffineMatrix2DBase_Concat(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAffineMatrix2DBase_Concat(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        const ::wxAffineMatrix2DBase* t;
        ::wxAffineMatrix2DBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_t,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxAffineMatrix2DBase, &sipCpp, sipType_wxAffineMatrix2DBase, &t))
        {
            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_AffineMatrix2DBase, sipName_Concat);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Concat(*t);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_AffineMatrix2DBase, sipName_Concat, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAffineMatrix2DBase_Invert, "Invert() -> bool\n"
"\n"
"Invert this matrix.");

extern "C" {static PyObject *meth_wxAffineMatrix2DBase_Invert(PyObject *, PyObject *);}
static PyObject *meth_wxAffineMatrix2DBase_Invert(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        ::wxAffineMatrix2DBase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAffineMatrix2DBase, &sipCpp))
        {
            bool sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_AffineMatrix2DBase, sipName_Invert);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Invert();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_AffineMatrix2DBase, sipName_Invert, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAffineMatrix2DBase_IsIdentity, "IsIdentity() -> bool\n"
"\n"
"Check if this is the identity matrix.");

extern "C" {static PyObject *meth_wxAffineMatrix2DBase_IsIdentity(PyObject *, PyObject *);}
static PyObject *meth_wxAffineMatrix2DBase_IsIdentity(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        const ::wxAffineMatrix2DBase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxAffineMatrix2DBase, &sipCpp))
        {
            bool sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_AffineMatrix2DBase, sipName_IsIdentity);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsIdentity();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_AffineMatrix2DBase, sipName_IsIdentity, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAffineMatrix2DBase_Translate, "Translate(dx, dy)\n"
"\n"
"Add the translation to this matrix.");

extern "C" {static PyObject *meth_wxAffineMatrix2DBase_Translate(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAffineMatrix2DBase_Translate(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        ::wxDouble dx;
        ::wxDouble dy;
        ::wxAffineMatrix2DBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_dx,
            sipName_dy,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bdd", &sipSelf, sipType_wxAffineMatrix2DBase, &sipCpp, &dx, &dy))
        {
            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_AffineMatrix2DBase, sipName_Translate);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Translate(dx, dy);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_AffineMatrix2DBase, sipName_Translate, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAffineMatrix2DBase_Scale, "Scale(xScale, yScale)\n"
"\n"
"Add scaling to this matrix.");

extern "C" {static PyObject *meth_wxAffineMatrix2DBase_Scale(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAffineMatrix2DBase_Scale(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        ::wxDouble xScale;
        ::wxDouble yScale;
        ::wxAffineMatrix2DBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_xScale,
            sipName_yScale,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bdd", &sipSelf, sipType_wxAffineMatrix2DBase, &sipCpp, &xScale, &yScale))
        {
            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_AffineMatrix2DBase, sipName_Scale);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Scale(xScale, yScale);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_AffineMatrix2DBase, sipName_Scale, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAffineMatrix2DBase_Rotate, "Rotate(cRadians)\n"
"\n"
"Add clockwise rotation to this matrix.");

extern "C" {static PyObject *meth_wxAffineMatrix2DBase_Rotate(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAffineMatrix2DBase_Rotate(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        ::wxDouble cRadians;
        ::wxAffineMatrix2DBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_cRadians,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bd", &sipSelf, sipType_wxAffineMatrix2DBase, &sipCpp, &cRadians))
        {
            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_AffineMatrix2DBase, sipName_Rotate);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Rotate(cRadians);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_AffineMatrix2DBase, sipName_Rotate, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAffineMatrix2DBase_Mirror, "Mirror(direction=HORIZONTAL)\n"
"\n"
"Add mirroring to this matrix.");

extern "C" {static PyObject *meth_wxAffineMatrix2DBase_Mirror(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAffineMatrix2DBase_Mirror(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int direction = wxHORIZONTAL;
        ::wxAffineMatrix2DBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_direction,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|i", &sipSelf, sipType_wxAffineMatrix2DBase, &sipCpp, &direction))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Mirror(direction);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_AffineMatrix2DBase, sipName_Mirror, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAffineMatrix2DBase_TransformPoint, "TransformPoint(p) -> Point2DDouble\n"
"TransformPoint(x, y) -> (x, y)\n"
"\n"
"Applies this matrix to the point.\n"
"");

extern "C" {static PyObject *meth_wxAffineMatrix2DBase_TransformPoint(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAffineMatrix2DBase_TransformPoint(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPoint2DDouble* p;
        int pState = 0;
        const ::wxAffineMatrix2DBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_p,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxAffineMatrix2DBase, &sipCpp, sipType_wxPoint2DDouble, &p, &pState))
        {
            ::wxPoint2DDouble*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxPoint2DDouble(sipCpp->TransformPoint(*p));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPoint2DDouble *>(p), sipType_wxPoint2DDouble, pState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxPoint2DDouble, SIP_NULLPTR);
        }
    }

    {
        ::wxDouble x;
        ::wxDouble y;
        const ::wxAffineMatrix2DBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bdd", &sipSelf, sipType_wxAffineMatrix2DBase, &sipCpp, &x, &y))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->TransformPoint(&x, &y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipBuildResult(0, "(dd)", x, y);
        }
    }

    sipNoMethod(sipParseErr, sipName_AffineMatrix2DBase, sipName_TransformPoint, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxAffineMatrix2DBase_TransformDistance, "TransformDistance(p) -> Point2DDouble\n"
"TransformDistance(dx, dy) -> (dx, dy)\n"
"\n"
"Applies the linear part of this matrix, i.e. without translation.\n"
"");

extern "C" {static PyObject *meth_wxAffineMatrix2DBase_TransformDistance(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxAffineMatrix2DBase_TransformDistance(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPoint2DDouble* p;
        int pState = 0;
        const ::wxAffineMatrix2DBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_p,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxAffineMatrix2DBase, &sipCpp, sipType_wxPoint2DDouble, &p, &pState))
        {
            ::wxPoint2DDouble*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxPoint2DDouble(sipCpp->TransformDistance(*p));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPoint2DDouble *>(p), sipType_wxPoint2DDouble, pState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxPoint2DDouble, SIP_NULLPTR);
        }
    }

    {
        ::wxDouble dx;
        ::wxDouble dy;
        const ::wxAffineMatrix2DBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_dx,
            sipName_dy,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bdd", &sipSelf, sipType_wxAffineMatrix2DBase, &sipCpp, &dx, &dy))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->TransformDistance(&dx, &dy);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipBuildResult(0, "(dd)", dx, dy);
        }
    }

    sipNoMethod(sipParseErr, sipName_AffineMatrix2DBase, sipName_TransformDistance, SIP_NULLPTR);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_wxAffineMatrix2DBase___ne__(PyObject *, PyObject *);}
static PyObject *slot_wxAffineMatrix2DBase___ne__(PyObject *sipSelf, PyObject *sipArg)
{
    ::wxAffineMatrix2DBase *sipCpp = reinterpret_cast<::wxAffineMatrix2DBase *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_wxAffineMatrix2DBase));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxAffineMatrix2DBase* t;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxAffineMatrix2DBase, &t))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->::wxAffineMatrix2DBase::operator!=(*t);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI__core, ne_slot, sipType_wxAffineMatrix2DBase, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_wxAffineMatrix2DBase___eq__(PyObject *, PyObject *);}
static PyObject *slot_wxAffineMatrix2DBase___eq__(PyObject *sipSelf, PyObject *sipArg)
{
    ::wxAffineMatrix2DBase *sipCpp = reinterpret_cast<::wxAffineMatrix2DBase *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_wxAffineMatrix2DBase));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxAffineMatrix2DBase* t;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxAffineMatrix2DBase, &t))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->::wxAffineMatrix2DBase::operator==(*t);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI__core, eq_slot, sipType_wxAffineMatrix2DBase, sipSelf, sipArg);
}


/* Call the instance's destructor. */
extern "C" {static void release_wxAffineMatrix2DBase(void *, int);}
static void release_wxAffineMatrix2DBase(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast<::wxAffineMatrix2DBase *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxAffineMatrix2DBase(sipSimpleWrapper *);}
static void dealloc_wxAffineMatrix2DBase(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxAffineMatrix2DBase(sipGetAddress(sipSelf), 0);
    }
}


/* Define this type's Python slots. */
static sipPySlotDef slots_wxAffineMatrix2DBase[] = {
    {(void *)slot_wxAffineMatrix2DBase___ne__, ne_slot},
    {(void *)slot_wxAffineMatrix2DBase___eq__, eq_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_wxAffineMatrix2DBase[] = {
    {sipName_Concat, SIP_MLMETH_CAST(meth_wxAffineMatrix2DBase_Concat), METH_VARARGS|METH_KEYWORDS, doc_wxAffineMatrix2DBase_Concat},
    {sipName_Get, SIP_MLMETH_CAST(meth_wxAffineMatrix2DBase_Get), METH_VARARGS|METH_KEYWORDS, doc_wxAffineMatrix2DBase_Get},
    {sipName_Invert, meth_wxAffineMatrix2DBase_Invert, METH_VARARGS, doc_wxAffineMatrix2DBase_Invert},
    {sipName_IsEqual, SIP_MLMETH_CAST(meth_wxAffineMatrix2DBase_IsEqual), METH_VARARGS|METH_KEYWORDS, doc_wxAffineMatrix2DBase_IsEqual},
    {sipName_IsIdentity, meth_wxAffineMatrix2DBase_IsIdentity, METH_VARARGS, doc_wxAffineMatrix2DBase_IsIdentity},
    {sipName_Mirror, SIP_MLMETH_CAST(meth_wxAffineMatrix2DBase_Mirror), METH_VARARGS|METH_KEYWORDS, doc_wxAffineMatrix2DBase_Mirror},
    {sipName_Rotate, SIP_MLMETH_CAST(meth_wxAffineMatrix2DBase_Rotate), METH_VARARGS|METH_KEYWORDS, doc_wxAffineMatrix2DBase_Rotate},
    {sipName_Scale, SIP_MLMETH_CAST(meth_wxAffineMatrix2DBase_Scale), METH_VARARGS|METH_KEYWORDS, doc_wxAffineMatrix2DBase_Scale},
    {sipName_Set, SIP_MLMETH_CAST(meth_wxAffineMatrix2DBase_Set), METH_VARARGS|METH_KEYWORDS, doc_wxAffineMatrix2DBase_Set},
    {sipName_TransformDistance, SIP_MLMETH_CAST(meth_wxAffineMatrix2DBase_TransformDistance), METH_VARARGS|METH_KEYWORDS, doc_wxAffineMatrix2DBase_TransformDistance},
    {sipName_TransformPoint, SIP_MLMETH_CAST(meth_wxAffineMatrix2DBase_TransformPoint), METH_VARARGS|METH_KEYWORDS, doc_wxAffineMatrix2DBase_TransformPoint},
    {sipName_Translate, SIP_MLMETH_CAST(meth_wxAffineMatrix2DBase_Translate), METH_VARARGS|METH_KEYWORDS, doc_wxAffineMatrix2DBase_Translate}
};

PyDoc_STRVAR(doc_wxAffineMatrix2DBase, "AffineMatrix2DBase()\n"
"\n"
"A 2x3 matrix representing an affine 2D transformation.");


sipClassTypeDef sipTypeDef__core_wxAffineMatrix2DBase = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_ABSTRACT|SIP_TYPE_CLASS,
        sipNameNr_wxAffineMatrix2DBase,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_AffineMatrix2DBase,
        {0, 0, 1},
        12, methods_wxAffineMatrix2DBase,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxAffineMatrix2DBase,
    -1,
    -1,
    SIP_NULLPTR,
    slots_wxAffineMatrix2DBase,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxAffineMatrix2DBase,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_wxAffineMatrix2DBase,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
};
