/////////////////////////////////////////////////////////////////////////////
// Name:        wx/private/lang_info.h
// Purpose:     Language database data
// Author:      misc/languages/genlang.py
// Created:     2024-10-04
// Copyright:   (c) 2024 wxWidgets development team <vadim@wxwidgets.org>
// Licence:     wxWindows licence
/////////////////////////////////////////////////////////////////////////////

// WARNING: Parts of this file are generated. See misc/languages/README for
// details.

#ifndef _WX_PRIVATE_LANG_INFO_H_
#define _WX_PRIVATE_LANG_INFO_H_

// ----------------------------------------------------------------------------
// Table of all supported languages
// ----------------------------------------------------------------------------

// --- --- --- generated code begins here --- --- ---

// The following data tables are generated by misc/languages/genlang.py
// When making changes, please put them into misc/languages/langtabl.txt

// Data table for known languages
static const struct langData_t
{
    int   wxlang;
    const char* bcp47tag;
    const char* canonical;
    const char* canonicalref;
    wxUint32 winlang;
    wxUint32 winsublang;
    wxLayoutDirection layout;
    const char* desc;
    const char* descnative;
}
tabLangData[] =
{
    { wxLANGUAGE_ABKHAZIAN,                                        "ab"             , "ab"                        , ""             , 0   , 0   , wxLayout_LeftToRight, "Abkhazian","\320\260\322\247\321\201\321\203\320\260 \320\261\321\213\320\267\321\210\323\231\320\260" },
    { wxLANGUAGE_AFAR,                                             "aa"             , "aa"                        , "aa_ET"        , 0x00, 0x04, wxLayout_LeftToRight, "Afar","Qafar" },
    { wxLANGUAGE_AFAR_DJIBOUTI,                                    "aa-DJ"          , "aa_DJ"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Afar (Djibouti)","Qafar (Yabuuti)" },
    { wxLANGUAGE_AFAR_ERITREA,                                     "aa-ER"          , "aa_ER"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Afar (Eritrea)","Qafar (Eretria)" },
    { wxLANGUAGE_AFAR_ETHIOPIA,                                    "aa-ET"          , "aa_ET"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Afar (Ethiopia)","Qafar (Otobbia)" },
    { wxLANGUAGE_AFRIKAANS,                                        "af"             , "af"                        , "af_ZA"        , 0x36, 0x01, wxLayout_LeftToRight, "Afrikaans","Afrikaans" },
    { wxLANGUAGE_AFRIKAANS_NAMIBIA,                                "af-NA"          , "af_NA"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Afrikaans (Namibia)","Afrikaans (Namibi\303\253)" },
    { wxLANGUAGE_AFRIKAANS_SOUTH_AFRICA,                           "af-ZA"          , "af_ZA"                     , ""             , 0x36, 0x01, wxLayout_LeftToRight, "Afrikaans (South Africa)","Afrikaans (Suid-Afrika)" },
    { wxLANGUAGE_AGHEM,                                            "agq"            , "agq"                       , "agq_CM"       , 0x00, 0x04, wxLayout_LeftToRight, "Aghem","Aghem" },
    { wxLANGUAGE_AGHEM_CAMEROON,                                   "agq-CM"         , "agq_CM"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Aghem (Cameroon)","Aghem (K\303\240m\303\240l\303\273\305\213)" },
    { wxLANGUAGE_AKAN,                                             "ak"             , "ak"                        , "ak_GH"        , 0x00, 0x04, wxLayout_LeftToRight, "Akan","Akan" },
    { wxLANGUAGE_AKAN_GHANA,                                       "ak-GH"          , "ak_GH"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Akan (Ghana)","Akan (Gaana)" },
    { wxLANGUAGE_ALBANIAN,                                         "sq"             , "sq"                        , "sq_AL"        , 0x1c, 0x01, wxLayout_LeftToRight, "Albanian","shqip" },
    { wxLANGUAGE_ALBANIAN_ALBANIA,                                 "sq-AL"          , "sq_AL"                     , ""             , 0x1c, 0x01, wxLayout_LeftToRight, "Albanian (Albania)","shqip (Shqip\303\253ri)" },
    { wxLANGUAGE_ALBANIAN_KOSOVO,                                  "sq-XK"          , "sq_XK"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Albanian (Kosovo)","shqip (Kosov\303\253)" },
    { wxLANGUAGE_ALBANIAN_NORTH_MACEDONIA,                         "sq-MK"          , "sq_MK"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Albanian (North Macedonia)","shqip (Maqedonia e Veriut)" },
    { wxLANGUAGE_ALSATIAN_FRANCE,                                  "gsw-FR"         , "gsw_FR"                    , ""             , 0x84, 0x01, wxLayout_LeftToRight, "Alsatian (France)","Els\303\244ssisch (Fr\303\240nkrisch)" },
    { wxLANGUAGE_AMHARIC,                                          "am"             , "am"                        , "am_ET"        , 0x5e, 0x01, wxLayout_LeftToRight, "Amharic","\341\212\240\341\210\233\341\210\255\341\212\233" },
    { wxLANGUAGE_AMHARIC_ETHIOPIA,                                 "am-ET"          , "am_ET"                     , ""             , 0x5e, 0x01, wxLayout_LeftToRight, "Amharic (Ethiopia)","\341\212\240\341\210\233\341\210\255\341\212\233 (\341\212\242\341\211\265\341\213\256\341\214\265\341\213\253)" },
    { wxLANGUAGE_ARABIC,                                           "ar"             , "ar"                        , "ar_SA"        , 0x01, 0x01, wxLayout_RightToLeft, "Arabic","\330\247\331\204\330\271\330\261\330\250\331\212\330\251" },
    { wxLANGUAGE_ARABIC_ALGERIA,                                   "ar-DZ"          , "ar_DZ"                     , ""             , 0x01, 0x05, wxLayout_RightToLeft, "Arabic (Algeria)","\330\247\331\204\330\271\330\261\330\250\331\212\330\251 (\330\247\331\204\330\254\330\262\330\247\330\246\330\261)" },
    { wxLANGUAGE_ARABIC_BAHRAIN,                                   "ar-BH"          , "ar_BH"                     , ""             , 0x01, 0x0f, wxLayout_RightToLeft, "Arabic (Bahrain)","\330\247\331\204\330\271\330\261\330\250\331\212\330\251 (\330\247\331\204\330\250\330\255\330\261\331\212\331\206)" },
    { wxLANGUAGE_ARABIC_CHAD,                                      "ar-TD"          , "ar_TD"                     , ""             , 0x00, 0x04, wxLayout_RightToLeft, "Arabic (Chad)","\330\247\331\204\330\271\330\261\330\250\331\212\330\251 (\330\252\330\264\330\247\330\257)" },
    { wxLANGUAGE_ARABIC_COMOROS,                                   "ar-KM"          , "ar_KM"                     , ""             , 0x00, 0x04, wxLayout_RightToLeft, "Arabic (Comoros)","\330\247\331\204\330\271\330\261\330\250\331\212\330\251 (\330\254\330\262\330\261 \330\247\331\204\331\202\331\205\330\261)" },
    { wxLANGUAGE_ARABIC_DJIBOUTI,                                  "ar-DJ"          , "ar_DJ"                     , ""             , 0x00, 0x04, wxLayout_RightToLeft, "Arabic (Djibouti)","\330\247\331\204\330\271\330\261\330\250\331\212\330\251 (\330\254\331\212\330\250\331\210\330\252\331\212)" },
    { wxLANGUAGE_ARABIC_EGYPT,                                     "ar-EG"          , "ar_EG"                     , ""             , 0x01, 0x03, wxLayout_RightToLeft, "Arabic (Egypt)","\330\247\331\204\330\271\330\261\330\250\331\212\330\251 (\331\205\330\265\330\261)" },
    { wxLANGUAGE_ARABIC_ERITREA,                                   "ar-ER"          , "ar_ER"                     , ""             , 0x00, 0x04, wxLayout_RightToLeft, "Arabic (Eritrea)","\330\247\331\204\330\271\330\261\330\250\331\212\330\251 (\330\245\330\261\331\212\330\252\330\261\331\212\330\247)" },
    { wxLANGUAGE_ARABIC_IRAQ,                                      "ar-IQ"          , "ar_IQ"                     , ""             , 0x01, 0x02, wxLayout_RightToLeft, "Arabic (Iraq)","\330\247\331\204\330\271\330\261\330\250\331\212\330\251 (\330\247\331\204\330\271\330\261\330\247\331\202)" },
    { wxLANGUAGE_ARABIC_ISRAEL,                                    "ar-IL"          , "ar_IL"                     , ""             , 0x00, 0x04, wxLayout_RightToLeft, "Arabic (Israel)","\330\247\331\204\330\271\330\261\330\250\331\212\330\251 (\330\245\330\263\330\261\330\247\330\246\331\212\331\204)" },
    { wxLANGUAGE_ARABIC_JORDAN,                                    "ar-JO"          , "ar_JO"                     , ""             , 0x01, 0x0b, wxLayout_RightToLeft, "Arabic (Jordan)","\330\247\331\204\330\271\330\261\330\250\331\212\330\251 (\330\247\331\204\330\243\330\261\330\257\331\206)" },
    { wxLANGUAGE_ARABIC_KUWAIT,                                    "ar-KW"          , "ar_KW"                     , ""             , 0x01, 0x0d, wxLayout_RightToLeft, "Arabic (Kuwait)","\330\247\331\204\330\271\330\261\330\250\331\212\330\251 (\330\247\331\204\331\203\331\210\331\212\330\252)" },
    { wxLANGUAGE_ARABIC_LEBANON,                                   "ar-LB"          , "ar_LB"                     , ""             , 0x01, 0x0c, wxLayout_RightToLeft, "Arabic (Lebanon)","\330\247\331\204\330\271\330\261\330\250\331\212\330\251 (\331\204\330\250\331\206\330\247\331\206)" },
    { wxLANGUAGE_ARABIC_LIBYA,                                     "ar-LY"          , "ar_LY"                     , ""             , 0x01, 0x04, wxLayout_RightToLeft, "Arabic (Libya)","\330\247\331\204\330\271\330\261\330\250\331\212\330\251 (\331\204\331\212\330\250\331\212\330\247)" },
    { wxLANGUAGE_ARABIC_MAURITANIA,                                "ar-MR"          , "ar_MR"                     , ""             , 0x00, 0x04, wxLayout_RightToLeft, "Arabic (Mauritania)","\330\247\331\204\330\271\330\261\330\250\331\212\330\251 (\331\205\331\210\330\261\331\212\330\252\330\247\331\206\331\212\330\247)" },
    { wxLANGUAGE_ARABIC_MOROCCO,                                   "ar-MA"          , "ar_MA"                     , ""             , 0x01, 0x06, wxLayout_RightToLeft, "Arabic (Morocco)","\330\247\331\204\330\271\330\261\330\250\331\212\330\251 (\330\247\331\204\331\205\331\205\331\204\331\203\330\251 \330\247\331\204\331\205\330\272\330\261\330\250\331\212\330\251)" },
    { wxLANGUAGE_ARABIC_OMAN,                                      "ar-OM"          , "ar_OM"                     , ""             , 0x01, 0x08, wxLayout_RightToLeft, "Arabic (Oman)","\330\247\331\204\330\271\330\261\330\250\331\212\330\251 (\330\271\331\205\330\247\331\206)" },
    { wxLANGUAGE_ARABIC_PALESTINIAN_AUTHORITY,                     "ar-PS"          , "ar_PS"                     , ""             , 0x00, 0x04, wxLayout_RightToLeft, "Arabic (Palestinian Authority)","\330\247\331\204\330\271\330\261\330\250\331\212\330\251 (\330\247\331\204\330\263\331\204\330\267\330\251 \330\247\331\204\331\201\331\204\330\263\330\267\331\212\331\206\331\212\330\251)" },
    { wxLANGUAGE_ARABIC_QATAR,                                     "ar-QA"          , "ar_QA"                     , ""             , 0x01, 0x10, wxLayout_RightToLeft, "Arabic (Qatar)","\330\247\331\204\330\271\330\261\330\250\331\212\330\251 (\331\202\330\267\330\261)" },
    { wxLANGUAGE_ARABIC_SAUDI_ARABIA,                              "ar-SA"          , "ar_SA"                     , ""             , 0x01, 0x01, wxLayout_RightToLeft, "Arabic (Saudi Arabia)","\330\247\331\204\330\271\330\261\330\250\331\212\330\251 (\330\247\331\204\331\205\331\205\331\204\331\203\330\251 \330\247\331\204\330\271\330\261\330\250\331\212\330\251 \330\247\331\204\330\263\330\271\331\210\330\257\331\212\330\251)" },
    { wxLANGUAGE_ARABIC_SOMALIA,                                   "ar-SO"          , "ar_SO"                     , ""             , 0x00, 0x04, wxLayout_RightToLeft, "Arabic (Somalia)","\330\247\331\204\330\271\330\261\330\250\331\212\330\251 (\330\247\331\204\330\265\331\210\331\205\330\247\331\204)" },
    { wxLANGUAGE_ARABIC_SOUTH_SUDAN,                               "ar-SS"          , "ar_SS"                     , ""             , 0x00, 0x04, wxLayout_RightToLeft, "Arabic (South Sudan)","\330\247\331\204\330\271\330\261\330\250\331\212\330\251 (\330\254\331\206\331\210\330\250 \330\247\331\204\330\263\331\210\330\257\330\247\331\206)" },
    { wxLANGUAGE_ARABIC_SUDAN,                                     "ar-SD"          , "ar_SD"                     , ""             , 0x00, 0x04, wxLayout_RightToLeft, "Arabic (Sudan)","\330\247\331\204\330\271\330\261\330\250\331\212\330\251 (\330\247\331\204\330\263\331\210\330\257\330\247\331\206)" },
    { wxLANGUAGE_ARABIC_SYRIA,                                     "ar-SY"          , "ar_SY"                     , ""             , 0x01, 0x0a, wxLayout_RightToLeft, "Arabic (Syria)","\330\247\331\204\330\271\330\261\330\250\331\212\330\251 (\330\263\331\210\330\261\331\212\330\247)" },
    { wxLANGUAGE_ARABIC_TUNISIA,                                   "ar-TN"          , "ar_TN"                     , ""             , 0x01, 0x07, wxLayout_RightToLeft, "Arabic (Tunisia)","\330\247\331\204\330\271\330\261\330\250\331\212\330\251 (\330\252\331\210\331\206\330\263)" },
    { wxLANGUAGE_ARABIC_UAE,                                       "ar-AE"          , "ar_AE"                     , ""             , 0x01, 0x0e, wxLayout_RightToLeft, "Arabic (United Arab Emirates)","\330\247\331\204\330\271\330\261\330\250\331\212\330\251 (\330\247\331\204\330\245\331\205\330\247\330\261\330\247\330\252 \330\247\331\204\330\271\330\261\330\250\331\212\330\251 \330\247\331\204\331\205\330\252\330\255\330\257\330\251)" },
    { wxLANGUAGE_ARABIC_WORLD,                                     "ar-001"         , "ar_001"                    , ""             , 0x00, 0x04, wxLayout_RightToLeft, "Arabic (World)","\330\247\331\204\330\271\330\261\330\250\331\212\330\251 (\330\247\331\204\330\271\330\247\331\204\331\205)" },
    { wxLANGUAGE_ARABIC_YEMEN,                                     "ar-YE"          , "ar_YE"                     , ""             , 0x01, 0x09, wxLayout_RightToLeft, "Arabic (Yemen)","\330\247\331\204\330\271\330\261\330\250\331\212\330\251 (\330\247\331\204\331\212\331\205\331\206)" },
    { wxLANGUAGE_ARMENIAN,                                         "hy"             , "hy"                        , "hy_AM"        , 0x2b, 0x01, wxLayout_LeftToRight, "Armenian","\325\260\325\241\325\265\325\245\326\200\325\245\325\266" },
    { wxLANGUAGE_ARMENIAN_ARMENIA,                                 "hy-AM"          , "hy_AM"                     , ""             , 0x2b, 0x01, wxLayout_LeftToRight, "Armenian (Armenia)","\325\260\325\241\325\265\325\245\326\200\325\245\325\266 (\325\200\325\241\325\265\325\241\325\275\325\277\325\241\325\266)" },
    { wxLANGUAGE_ASSAMESE,                                         "as"             , "as"                        , "as_IN"        , 0x4d, 0x01, wxLayout_LeftToRight, "Assamese","\340\246\205\340\246\270\340\246\256\340\247\200\340\246\257\340\246\274\340\246\276" },
    { wxLANGUAGE_ASSAMESE_INDIA,                                   "as-IN"          , "as_IN"                     , ""             , 0x4d, 0x01, wxLayout_LeftToRight, "Assamese (India)","\340\246\205\340\246\270\340\246\256\340\247\200\340\246\257\340\246\274\340\246\276 (\340\246\255\340\246\276\340\247\260\340\246\244)" },
    { wxLANGUAGE_ASTURIAN,                                         "ast"            , "ast"                       , "ast_ES"       , 0x00, 0x04, wxLayout_LeftToRight, "Asturian","asturianu" },
    { wxLANGUAGE_ASTURIAN_SPAIN,                                   "ast-ES"         , "ast_ES"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Asturian (Spain)","asturianu (Espa\303\261a)" },
    { wxLANGUAGE_ASU,                                              "asa"            , "asa"                       , "asa_TZ"       , 0x00, 0x04, wxLayout_LeftToRight, "Asu","Kipare" },
    { wxLANGUAGE_ASU_TANZANIA,                                     "asa-TZ"         , "asa_TZ"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Asu (Tanzania)","Kipare (Tadhania)" },
    { wxLANGUAGE_AYMARA,                                           "ay"             , "ay"                        , ""             , 0   , 0   , wxLayout_LeftToRight, "Aymara","Aymara" },
    { wxLANGUAGE_AZERBAIJANI,                                      "az"             , "az"                        , ""             , 0x2c, 0x01, wxLayout_LeftToRight, "Azerbaijani","az\311\231rbaycan" },
    { wxLANGUAGE_AZERBAIJANI_CYRILLIC,                             "az-Cyrl"        , "az@cyrillic"               , ""             , 0x2c, 0x02, wxLayout_LeftToRight, "Azerbaijani (Cyrillic)","\320\220\320\267\323\231\321\200\320\261\320\260\321\230\322\271\320\260\320\275\302\240\320\264\320\270\320\273\320\270 (\320\232\320\270\321\200\320\270\320\273)" },
    { wxLANGUAGE_AZERBAIJANI_CYRILLIC_AZERBAIJAN,                  "az-Cyrl-AZ"     , "az_AZ@cyrillic"            , ""             , 0x2c, 0x02, wxLayout_LeftToRight, "Azerbaijani (Cyrillic, Azerbaijan)","\320\260\320\267\323\231\321\200\320\261\320\260\321\230\322\271\320\260\320\275 (\320\220\320\267\323\231\321\200\320\261\320\260\321\230\322\271\320\260\320\275)" },
    { wxLANGUAGE_AZERBAIJANI_LATIN,                                "az-Latn"        , "az@latin"                  , ""             , 0x2c, 0x01, wxLayout_LeftToRight, "Azerbaijani (Latin)","Az\311\231rbaycan\302\255\304\261l\304\261 (Lat\304\261n)" },
    { wxLANGUAGE_AZERBAIJANI_LATIN_AZERBAIJAN,                     "az-Latn-AZ"     , "az_AZ@latin"               , ""             , 0x2c, 0x01, wxLayout_LeftToRight, "Azerbaijani (Latin, Azerbaijan)","az\311\231rbaycan (Az\311\231rbaycan)" },
    { wxLANGUAGE_BAFIA,                                            "ksf"            , "ksf"                       , "ksf_CM"       , 0x00, 0x04, wxLayout_LeftToRight, "Bafia","rikpa" },
    { wxLANGUAGE_BAFIA_CAMEROON,                                   "ksf-CM"         , "ksf_CM"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Bafia (Cameroon)","rikpa (kam\311\233r\303\272n)" },
    { wxLANGUAGE_BAMANANKAN,                                       "bm"             , "bm"                        , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Bamanankan","bamanakan" },
    { wxLANGUAGE_BAMANANKAN_LATIN,                                 "bm-Latn"        , "bm@latin"                  , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Bamanankan (Latin)","bamanakan (Latin)" },
    { wxLANGUAGE_BAMANANKAN_LATIN_MALI,                            "bm-Latn-ML"     , "bm_ML@latin"               , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Bamanankan (Latin, Mali)","bamanakan (Mali)" },
    { wxLANGUAGE_BANGLA,                                           "bn"             , "bn"                        , "bn_BD"        , 0x45, 0x02, wxLayout_LeftToRight, "Bangla","\340\246\254\340\246\276\340\246\202\340\246\262\340\246\276" },
    { wxLANGUAGE_BANGLA_BANGLADESH,                                "bn-BD"          , "bn_BD"                     , ""             , 0x45, 0x02, wxLayout_LeftToRight, "Bangla (Bangladesh)","\340\246\254\340\246\276\340\246\202\340\246\262\340\246\276 (\340\246\254\340\246\276\340\246\202\340\246\262\340\246\276\340\246\246\340\247\207\340\246\266)" },
    { wxLANGUAGE_BANGLA_INDIA,                                     "bn-IN"          , "bn_IN"                     , ""             , 0x45, 0x01, wxLayout_LeftToRight, "Bengali (India)","\340\246\254\340\246\276\340\246\202\340\246\262\340\246\276 (\340\246\255\340\246\276\340\246\260\340\246\244)" },
    { wxLANGUAGE_BASAA,                                            "bas"            , "bas"                       , "bas_CM"       , 0x00, 0x04, wxLayout_LeftToRight, "Basaa","\306\201\303\240s\303\240a" },
    { wxLANGUAGE_BASAA_CAMEROON,                                   "bas-CM"         , "bas_CM"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Basaa (Cameroon)","\306\201\303\240s\303\240a (K\303\240m\311\233\314\200r\303\273n)" },
    { wxLANGUAGE_BASHKIR,                                          "ba"             , "ba"                        , "ba_RU"        , 0x6d, 0x01, wxLayout_LeftToRight, "Bashkir","\320\221\320\260\321\210\322\241\320\276\321\200\321\202" },
    { wxLANGUAGE_BASHKIR_RUSSIA,                                   "ba-RU"          , "ba_RU"                     , ""             , 0x6d, 0x01, wxLayout_LeftToRight, "Bashkir (Russia)","\320\221\320\260\321\210\322\241\320\276\321\200\321\202 (\320\240\323\231\321\201\323\231\320\271)" },
    { wxLANGUAGE_BASQUE,                                           "eu"             , "eu"                        , "eu_ES"        , 0x2d, 0x01, wxLayout_LeftToRight, "Basque","euskara" },
    { wxLANGUAGE_BASQUE_SPAIN,                                     "eu-ES"          , "eu_ES"                     , ""             , 0x2d, 0x01, wxLayout_LeftToRight, "Basque (Basque)","euskara (euskara)" },
    { wxLANGUAGE_BELARUSIAN,                                       "be"             , "be"                        , "be_BY"        , 0x23, 0x01, wxLayout_LeftToRight, "Belarusian","\320\261\320\265\320\273\320\260\321\200\321\203\321\201\320\272\320\260\321\217" },
    { wxLANGUAGE_BELARUSIAN_BELARUS,                               "be-BY"          , "be_BY"                     , ""             , 0x23, 0x01, wxLayout_LeftToRight, "Belarusian (Belarus)","\320\261\320\265\320\273\320\260\321\200\321\203\321\201\320\272\320\260\321\217 (\320\221\320\265\320\273\320\260\321\200\321\203\321\201\321\214)" },
    { wxLANGUAGE_BEMBA,                                            "bem"            , "bem"                       , "bem_ZM"       , 0x00, 0x04, wxLayout_LeftToRight, "Bemba","Ichibemba" },
    { wxLANGUAGE_BEMBA_ZAMBIA,                                     "bem-ZM"         , "bem_ZM"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Bemba (Zambia)","Ichibemba (Zambia)" },
    { wxLANGUAGE_BENA,                                             "bez"            , "bez"                       , "bez_TZ"       , 0x00, 0x04, wxLayout_LeftToRight, "Bena","Hibena" },
    { wxLANGUAGE_BENA_TANZANIA,                                    "bez-TZ"         , "bez_TZ"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Bena (Tanzania)","Hibena (Hutanzania)" },
    { wxLANGUAGE_BIHARI,                                           "bh"             , "bh"                        , ""             , 0   , 0   , wxLayout_LeftToRight, "Bihari","Bihari" },
    { wxLANGUAGE_BISLAMA,                                          "bi"             , "bi"                        , ""             , 0   , 0   , wxLayout_LeftToRight, "Bislama","Bislama" },
    { wxLANGUAGE_BLIN,                                             "byn"            , "byn"                       , "byn_ER"       , 0x00, 0x04, wxLayout_LeftToRight, "Blin","\341\211\245\341\210\212\341\212\225" },
    { wxLANGUAGE_BLIN_ERITREA,                                     "byn-ER"         , "byn_ER"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Blin (Eritrea)","\341\211\245\341\210\212\341\212\225 (\341\212\244\341\210\255\341\211\265\341\210\253)" },
    { wxLANGUAGE_BODO,                                             "brx"            , "brx"                       , "brx_IN"       , 0x00, 0x04, wxLayout_LeftToRight, "Bodo","\340\244\254\340\244\241\340\244\274\340\245\213" },
    { wxLANGUAGE_BODO_INDIA,                                       "brx-IN"         , "brx_IN"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Bodo (India)","\340\244\254\340\244\241\340\244\274\340\245\213 (\340\244\255\340\244\276\340\244\260\340\244\244)" },
    { wxLANGUAGE_BOSNIAN,                                          "bs"             , "bs"                        , ""             , 0x1a, 0x05, wxLayout_LeftToRight, "Bosnian","bosanski" },
    { wxLANGUAGE_BOSNIAN_CYRILLIC,                                 "bs-Cyrl"        , "bs@cyrillic"               , ""             , 0x1a, 0x08, wxLayout_LeftToRight, "Bosnian (Cyrillic)","\320\261\320\276\321\201\320\260\320\275\321\201\320\272\320\270 (\320\213\320\270\321\200\320\270\320\273\320\270\321\206\320\260)" },
    { wxLANGUAGE_BOSNIAN_CYRILLIC_BOSNIA_AND_HERZEGOVINA,          "bs-Cyrl-BA"     , "bs_BA@cyrillic"            , ""             , 0x1a, 0x08, wxLayout_LeftToRight, "Bosnian (Cyrillic, Bosnia and Herzegovina)","\320\261\320\276\321\201\320\260\320\275\321\201\320\272\320\270 (\320\221\320\276\321\201\320\275\320\260 \320\270 \320\245\320\265\321\200\321\206\320\265\320\263\320\276\320\262\320\270\320\275\320\260)" },
    { wxLANGUAGE_BOSNIAN_LATIN,                                    "bs-Latn"        , "bs@latin"                  , ""             , 0x1a, 0x05, wxLayout_LeftToRight, "Bosnian (Latin)","bosanski (Latinica)" },
    { wxLANGUAGE_BOSNIAN_LATIN_BOSNIA_AND_HERZEGOVINA,             "bs-Latn-BA"     , "bs_BA@latin"               , ""             , 0x1a, 0x05, wxLayout_LeftToRight, "Bosnian (Latin, Bosnia and Herzegovina)","bosanski (Bosna i Hercegovina)" },
    { wxLANGUAGE_BRETON,                                           "br"             , "br"                        , "br_FR"        , 0x7e, 0x01, wxLayout_LeftToRight, "Breton","brezhoneg" },
    { wxLANGUAGE_BRETON_FRANCE,                                    "br-FR"          , "br_FR"                     , ""             , 0x7e, 0x01, wxLayout_LeftToRight, "Breton (France)","brezhoneg (Fra\303\261s)" },
    { wxLANGUAGE_BULGARIAN,                                        "bg"             , "bg"                        , "bg_BG"        , 0x02, 0x01, wxLayout_LeftToRight, "Bulgarian","\320\261\321\212\320\273\320\263\320\260\321\200\321\201\320\272\320\270" },
    { wxLANGUAGE_BULGARIAN_BULGARIA,                               "bg-BG"          , "bg_BG"                     , ""             , 0x02, 0x01, wxLayout_LeftToRight, "Bulgarian (Bulgaria)","\320\261\321\212\320\273\320\263\320\260\321\200\321\201\320\272\320\270 (\320\221\321\212\320\273\320\263\320\260\321\200\320\270\321\217)" },
    { wxLANGUAGE_BURMESE,                                          "my"             , "my"                        , "my_MM"        , 0x55, 0x01, wxLayout_LeftToRight, "Burmese","\341\200\227\341\200\231\341\200\254" },
    { wxLANGUAGE_BURMESE_MYANMAR,                                  "my-MM"          , "my_MM"                     , ""             , 0x55, 0x01, wxLayout_LeftToRight, "Burmese (Myanmar)","\341\200\231\341\200\274\341\200\224\341\200\272\341\200\231\341\200\254 (\341\200\231\341\200\274\341\200\224\341\200\272\341\200\231\341\200\254)" },
    { wxLANGUAGE_CATALAN,                                          "ca"             , "ca"                        , "ca_ES"        , 0x03, 0x01, wxLayout_LeftToRight, "Catalan","catal\303\240" },
    { wxLANGUAGE_CATALAN_ANDORRA,                                  "ca-AD"          , "ca_AD"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Catalan (Andorra)","catal\303\240 (Andorra)" },
    { wxLANGUAGE_CATALAN_FRANCE,                                   "ca-FR"          , "ca_FR"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Catalan (France)","catal\303\240 (Fran\303\247a)" },
    { wxLANGUAGE_CATALAN_ITALY,                                    "ca-IT"          , "ca_IT"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Catalan (Italy)","catal\303\240 (It\303\240lia)" },
    { wxLANGUAGE_CATALAN_SPAIN,                                    "ca-ES"          , "ca_ES"                     , ""             , 0x03, 0x01, wxLayout_LeftToRight, "Catalan (Catalan)","catal\303\240 (catal\303\240)" },
    { wxLANGUAGE_CEBUANO,                                          "ceb"            , "ceb"                       , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Cebuano","Binisaya" },
    { wxLANGUAGE_CEBUANO_LATIN,                                    "ceb-Latn"       , "ceb@latin"                 , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Cebuano (Latin)","Binisaya (Latin)" },
    { wxLANGUAGE_CEBUANO_LATIN_PHILIPPINES,                        "ceb-Latn-PH"    , "ceb_PH@latin"              , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Cebuano (Latin, Philippines)","Binisaya (Pilipinas)" },
    { wxLANGUAGE_CENTRAL_ATLAS_TAMAZIGHT,                          "tzm"            , "tzm"                       , ""             , 0x5f, 0x02, wxLayout_LeftToRight, "Central Atlas Tamazight","Tamazi\311\243t n la\341\271\255la\341\271\243" },
    { wxLANGUAGE_CENTRAL_ATLAS_TAMAZIGHT_ARABIC,                   "tzm-Arab"       , "tzm@arabic"                , ""             , 0x5f, 0x01, wxLayout_RightToLeft, "Central Atlas Tamazight (Arabic)","\330\247\331\204\330\243\331\205\330\247\330\262\331\212\330\272\331\212\330\251 \331\210\330\263\330\267 \330\247\331\204\330\243\330\267\331\204\330\263" },
    { wxLANGUAGE_CENTRAL_ATLAS_TAMAZIGHT_ARABIC_MOROCCO,           "tzm-Arab-MA"    , "tzm_MA@arabic"             , ""             , 0x5f, 0x01, wxLayout_RightToLeft, "Central Atlas Tamazight (Arabic, Morocco)","\330\247\331\204\330\243\331\205\330\247\330\262\331\212\330\272\331\212\330\251 \331\210\330\263\330\267 \330\247\331\204\330\243\330\267\331\204\330\263 (\330\247\331\204\331\205\330\272\330\261\330\250)" },
    { wxLANGUAGE_CENTRAL_ATLAS_TAMAZIGHT_LATIN,                    "tzm-Latn"       , "tzm@latin"                 , ""             , 0x5f, 0x02, wxLayout_LeftToRight, "Central Atlas Tamazight (Latin)","Tamazi\311\243t n la\341\271\255la\341\271\243 (Latin)" },
    { wxLANGUAGE_CENTRAL_ATLAS_TAMAZIGHT_LATIN_ALGERIA,            "tzm-Latn-DZ"    , "tzm_DZ@latin"              , ""             , 0x5f, 0x02, wxLayout_LeftToRight, "Central Atlas Tamazight (Latin, Algeria)","Tamazi\311\243t n la\341\271\255la\341\271\243 (Djaza\303\257r)" },
    { wxLANGUAGE_CENTRAL_ATLAS_TAMAZIGHT_LATIN_MOROCCO,            "tzm-Latn-MA"    , "tzm_MA@latin"              , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Central Atlas Tamazight (Latin, Morocco)","Tamazi\311\243t n la\341\271\255la\341\271\243 (Me\341\271\233\341\271\233uk)" },
    { wxLANGUAGE_CENTRAL_ATLAS_TAMAZIGHT_TIFINAGH,                 "tzm-Tfng"       , "tzm@tifinagh"              , ""             , 0x5f, 0x04, wxLayout_LeftToRight, "Central Atlas Tamazight (Tifinagh)","Tamazight (Tifinagh)" },
    { wxLANGUAGE_CENTRAL_ATLAS_TAMAZIGHT_TIFINAGH_MOROCCO,         "tzm-Tfng-MA"    , "tzm_MA@tifinagh"           , ""             , 0x5f, 0x04, wxLayout_LeftToRight, "Central Atlas Tamazight (Tifinagh, Morocco)","\342\265\234\342\264\260\342\265\216\342\264\260\342\265\243\342\265\211\342\265\226\342\265\234 (\342\265\215\342\265\216\342\265\226\342\265\224\342\265\211\342\264\261)" },
    { wxLANGUAGE_CENTRAL_KURDISH,                                  "ku"             , "ku"                        , ""             , 0x92, 0x01, wxLayout_RightToLeft, "Central Kurdish","\332\251\331\210\330\261\330\257\333\214\333\214 \331\206\330\247\331\210\333\225\332\225\330\247\330\263\330\252" },
    { wxLANGUAGE_CENTRAL_KURDISH_ARABIC,                           "ku-Arab"        , "ku@arabic"                 , ""             , 0x92, 0x01, wxLayout_RightToLeft, "Central Kurdish","\332\251\331\210\330\261\330\257\333\214\333\214 \331\206\330\247\331\210\333\225\332\225\330\247\330\263\330\252" },
    { wxLANGUAGE_CENTRAL_KURDISH_ARABIC_IRAQ,                      "ku-Arab-IQ"     , "ku_IQ@arabic"              , ""             , 0x92, 0x01, wxLayout_RightToLeft, "Central Kurdish (Iraq)","\332\251\331\210\330\261\330\257\333\214\333\214 \331\206\330\247\331\210\333\225\332\225\330\247\330\263\330\252 (\330\271\333\216\330\261\330\247\331\202)" },
    { wxLANGUAGE_CHAKMA,                                           "ccp"            , "ccp"                       , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Chakma","\360\221\204\214\360\221\204\213\360\221\204\264\360\221\204\237\360\221\204\263\360\221\204\246" },
    { wxLANGUAGE_CHAKMA_CHAKMA,                                    "ccp-Cakm"       , "ccp@chakma"                , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Chakma (Chakma)","\360\221\204\214\360\221\204\213\360\221\204\264\360\221\204\237\360\221\204\263\360\221\204\246 (\360\221\204\214\360\221\204\207\360\221\204\264\360\221\204\237)" },
    { wxLANGUAGE_CHAKMA_CHAKMA_BANGLADESH,                         "ccp-Cakm-BD"    , "ccp_BD@chakma"             , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Chakma (Chakma, Bangladesh)","\360\221\204\214\360\221\204\213\360\221\204\264\360\221\204\237\360\221\204\263\360\221\204\246 (\360\221\204\235\360\221\204\201\360\221\204\243\360\221\204\230\360\221\204\254\360\221\204\214\360\221\204\264)" },
    { wxLANGUAGE_CHAKMA_CHAKMA_INDIA,                              "ccp-Cakm-IN"    , "ccp_IN@chakma"             , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Chakma (Chakma, India)","\360\221\204\214\360\221\204\213\360\221\204\264\360\221\204\237\360\221\204\263\360\221\204\246 (\360\221\204\236\360\221\204\242\360\221\204\247\360\221\204\226\360\221\204\264)" },
    { wxLANGUAGE_CHECHEN,                                          "ce"             , "ce"                        , "ce_RU"        , 0x00, 0x04, wxLayout_LeftToRight, "Chechen","\320\275\320\276\321\205\321\207\320\270\320\271\320\275" },
    { wxLANGUAGE_CHECHEN_RUSSIA,                                   "ce-RU"          , "ce_RU"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Chechen (Russia)","\320\275\320\276\321\205\321\207\320\270\320\271\320\275 (\320\240\320\276\321\201\321\201\320\270)" },
    { wxLANGUAGE_CHEROKEE,                                         "chr"            , "chr"                       , ""             , 0x5c, 0x01, wxLayout_LeftToRight, "Cherokee","\341\217\243\341\216\263\341\216\251" },
    { wxLANGUAGE_CHEROKEE_CHEROKEE,                                "chr-Cher"       , "chr@cherokee"              , ""             , 0x5c, 0x01, wxLayout_LeftToRight, "Cherokee","\341\217\243\341\216\263\341\216\251" },
    { wxLANGUAGE_CHEROKEE_US,                                      "chr-Cher-US"    , "chr_US@cherokee"           , ""             , 0x5c, 0x01, wxLayout_LeftToRight, "Cherokee (Cherokee, United States)","\341\217\243\341\216\263\341\216\251 (\341\217\214\341\217\212 \341\216\242\341\217\263\341\216\276\341\216\265\341\217\215\341\217\224\341\217\205 \341\217\215\341\216\246\341\217\232\341\216\251)" },
    { wxLANGUAGE_CHIGA,                                            "cgg"            , "cgg"                       , "cgg_UG"       , 0x00, 0x04, wxLayout_LeftToRight, "Chiga","Rukiga" },
    { wxLANGUAGE_CHIGA_UGANDA,                                     "cgg-UG"         , "cgg_UG"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Chiga (Uganda)","Rukiga (Uganda)" },
    { wxLANGUAGE_CHINESE,                                          "zh"             , "zh"                        , "zh_TW"        , 0x04, 0x01, wxLayout_LeftToRight, "Chinese","\344\270\255\346\226\207" },
    { wxLANGUAGE_CHINESE_CHINA,                                    "zh-CN"          , "zh_CN"                     , ""             , 0x04, 0x02, wxLayout_LeftToRight, "Chinese (Simplified, China)","\344\270\255\346\226\207(\344\270\255\345\233\275)" },
    { wxLANGUAGE_CHINESE_HONGKONG,                                 "zh-HK"          , "zh_HK"                     , ""             , 0x04, 0x03, wxLayout_LeftToRight, "Chinese (Traditional, Hong Kong SAR)","\344\270\255\346\226\207(\351\246\231\346\270\257\347\211\271\345\210\245\350\241\214\346\224\277\345\215\200)" },
    { wxLANGUAGE_CHINESE_MACAO,                                    "zh-MO"          , "zh_MO"                     , ""             , 0x04, 0x05, wxLayout_LeftToRight, "Chinese (Traditional, Macao SAR)","\344\270\255\346\226\207(\346\276\263\351\226\200\347\211\271\345\210\245\350\241\214\346\224\277\345\215\200)" },
    { wxLANGUAGE_CHINESE_SIMPLIFIED_EXPLICIT,                      "zh-Hans"        , "zh@Hans"                   , "zh_CN"        , 0x04, 0x02, wxLayout_LeftToRight, "Chinese (Simplified)","\344\270\255\346\226\207(\347\256\200\344\275\223)" },
    { wxLANGUAGE_CHINESE_SIMPLIFIED_HONGKONG,                      "zh-Hans-HK"     , "zh_HK@Hans"                , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Chinese (Simplified, Hong Kong SAR)","\344\270\255\346\226\207 (\351\246\231\346\270\257\347\211\271\345\210\253\350\241\214\346\224\277\345\214\272)" },
    { wxLANGUAGE_CHINESE_SIMPLIFIED_MACAO,                         "zh-Hans-MO"     , "zh_MO@Hans"                , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Chinese (Simplified, Macao SAR)","\344\270\255\346\226\207 (\346\276\263\351\227\250\347\211\271\345\210\253\350\241\214\346\224\277\345\214\272)" },
    { wxLANGUAGE_CHINESE_SINGAPORE,                                "zh-SG"          , "zh_SG"                     , ""             , 0x04, 0x04, wxLayout_LeftToRight, "Chinese (Simplified, Singapore)","\344\270\255\346\226\207(\346\226\260\345\212\240\345\235\241)" },
    { wxLANGUAGE_CHINESE_TAIWAN,                                   "zh-TW"          , "zh_TW"                     , ""             , 0x04, 0x01, wxLayout_LeftToRight, "Chinese (Traditional, Taiwan)","\344\270\255\346\226\207(\345\217\260\347\201\243)" },
    { wxLANGUAGE_CHINESE_TRADITIONAL_EXPLICIT,                     "zh-Hant"        , "zh@Hant"                   , "zh_TW"        , 0x04, 0x01, wxLayout_LeftToRight, "Chinese (Traditional)","\344\270\255\346\226\207(\347\271\201\351\253\224)" },
    { wxLANGUAGE_CHURCH_SLAVIC,                                    "cu"             , "cu"                        , "cu_RU"        , 0x00, 0x04, wxLayout_LeftToRight, "Church Slavic","\321\206\320\265\321\200\320\272\320\276\320\262\320\275\320\276\321\201\320\273\320\276\320\262\320\265\314\201\320\275\321\201\320\272\321\227\320\271" },
    { wxLANGUAGE_CHURCH_SLAVIC_RUSSIA,                             "cu-RU"          , "cu_RU"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Church Slavic (Russia)","\321\206\320\265\321\200\320\272\320\276\320\262\320\275\320\276\321\201\320\273\320\276\320\262\320\265\314\201\320\275\321\201\320\272\321\227\320\271 (\321\200\321\241\321\201\321\201\321\226\314\201\320\260)" },
    { wxLANGUAGE_COLOGNIAN,                                        "ksh"            , "ksh"                       , "ksh_DE"       , 0x00, 0x04, wxLayout_LeftToRight, "Colognian","K\303\266lsch" },
    { wxLANGUAGE_COLOGNIAN_GERMANY,                                "ksh-DE"         , "ksh_DE"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Colognian (Germany)","K\303\266lsch (Do\303\274tschland)" },
    { wxLANGUAGE_CORNISH,                                          "kw"             , "kw"                        , "kw_GB"        , 0x00, 0x04, wxLayout_LeftToRight, "Cornish","kernewek" },
    { wxLANGUAGE_CORNISH_UK,                                       "kw-GB"          , "kw_GB"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Cornish (United Kingdom)","kernewek (Rywvaneth Unys)" },
    { wxLANGUAGE_CORSICAN,                                         "co"             , "co"                        , "co_FR"        , 0x83, 0x01, wxLayout_LeftToRight, "Corsican","corsu" },
    { wxLANGUAGE_CORSICAN_FRANCE,                                  "co-FR"          , "co_FR"                     , ""             , 0x83, 0x01, wxLayout_LeftToRight, "Corsican (France)","Corsu (Francia)" },
    { wxLANGUAGE_CROATIAN,                                         "hr"             , "hr"                        , "hr_HR"        , 0x1a, 0x01, wxLayout_LeftToRight, "Croatian","hrvatski" },
    { wxLANGUAGE_CROATIAN_BOSNIA_AND_HERZEGOVINA,                  "hr-BA"          , "hr_BA"                     , ""             , 0x1a, 0x04, wxLayout_LeftToRight, "Croatian (Bosnia and Herzegovina)","hrvatski (Bosna i Hercegovina)" },
    { wxLANGUAGE_CROATIAN_CROATIA,                                 "hr-HR"          , "hr_HR"                     , ""             , 0x1a, 0x01, wxLayout_LeftToRight, "Croatian (Croatia)","hrvatski (Hrvatska)" },
    { wxLANGUAGE_CZECH,                                            "cs"             , "cs"                        , "cs_CZ"        , 0x05, 0x01, wxLayout_LeftToRight, "Czech","\304\215e\305\241tina" },
    { wxLANGUAGE_CZECH_CZECHIA,                                    "cs-CZ"          , "cs_CZ"                     , ""             , 0x05, 0x01, wxLayout_LeftToRight, "Czech (Czechia)","\304\215e\305\241tina (\304\214esko)" },
    { wxLANGUAGE_DANISH,                                           "da"             , "da"                        , "da_DK"        , 0x06, 0x01, wxLayout_LeftToRight, "Danish","dansk" },
    { wxLANGUAGE_DANISH_DENMARK,                                   "da-DK"          , "da_DK"                     , ""             , 0x06, 0x01, wxLayout_LeftToRight, "Danish (Denmark)","dansk (Danmark)" },
    { wxLANGUAGE_DANISH_GREENLAND,                                 "da-GL"          , "da_GL"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Danish (Greenland)","dansk (Gr\303\270nland)" },
    { wxLANGUAGE_DIVEHI,                                           "dv"             , "dv"                        , "dv_MV"        , 0x65, 0x01, wxLayout_RightToLeft, "Divehi","\336\213\336\250\336\210\336\254\336\200\336\250\336\204\336\246\336\220\336\260" },
    { wxLANGUAGE_DIVEHI_MALDIVES,                                  "dv-MV"          , "dv_MV"                     , ""             , 0x65, 0x01, wxLayout_RightToLeft, "Divehi (Maldives)","\336\213\336\250\336\210\336\254\336\200\336\250\336\204\336\246\336\220\336\260 (\336\213\336\250\336\210\336\254\336\200\336\250 \336\203\336\247\336\207\336\260\336\226\336\254)" },
    { wxLANGUAGE_DOGRI,                                            "doi"            , "doi"                       , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Dogri","\340\244\241\340\245\213\340\244\227\340\244\260\340\245\200" },
    { wxLANGUAGE_DOGRI_DEVANAGARI,                                 "doi-Deva"       , "doi@devanagari"            , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Dogri (Devanagari)","\340\244\241\340\245\213\340\244\227\340\244\260\340\245\200 (\340\244\246\340\245\207\340\244\265\340\244\250\340\244\276\340\244\227\340\244\260\340\245\200)" },
    { wxLANGUAGE_DOGRI_DEVANAGARI_INDIA,                           "doi-Deva-IN"    , "doi_IN@devanagari"         , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Dogri (Devanagari, India)","\340\244\241\340\245\213\340\244\227\340\244\260\340\245\200 (\340\244\255\340\244\276\340\244\260\340\244\244)" },
    { wxLANGUAGE_DUALA,                                            "dua"            , "dua"                       , "dua_CM"       , 0x00, 0x04, wxLayout_LeftToRight, "Duala","du\303\241l\303\241" },
    { wxLANGUAGE_DUALA_CAMEROON,                                   "dua-CM"         , "dua_CM"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Duala (Cameroon)","du\303\241l\303\241 (Cameroun)" },
    { wxLANGUAGE_DUTCH,                                            "nl"             , "nl"                        , "nl_NL"        , 0x13, 0x01, wxLayout_LeftToRight, "Dutch","Nederlands" },
    { wxLANGUAGE_DUTCH_ARUBA,                                      "nl-AW"          , "nl_AW"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Dutch (Aruba)","Nederlands (Aruba)" },
    { wxLANGUAGE_DUTCH_BELGIAN,                                    "nl-BE"          , "nl_BE"                     , ""             , 0x13, 0x02, wxLayout_LeftToRight, "Dutch (Belgium)","Nederlands (Belgi\303\253)" },
    { wxLANGUAGE_DUTCH_BONAIRE_SINT_EUSTATIUS_AND_SABA,            "nl-BQ"          , "nl_BQ"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Dutch (Bonaire, Sint Eustatius and Saba)","Nederlands (Bonaire, Sint Eustatius en Saba)" },
    { wxLANGUAGE_DUTCH_CURACAO,                                    "nl-CW"          , "nl_CW"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Dutch (Cura\303\247ao)","Nederlands (Cura\303\247ao)" },
    { wxLANGUAGE_DUTCH_NETHERLANDS,                                "nl-NL"          , "nl_NL"                     , ""             , 0x13, 0x01, wxLayout_LeftToRight, "Dutch (Netherlands)","Nederlands (Nederland)" },
    { wxLANGUAGE_DUTCH_SINT_MAARTEN,                               "nl-SX"          , "nl_SX"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Dutch (Sint Maarten)","Nederlands (Sint-Maarten)" },
    { wxLANGUAGE_DUTCH_SURINAME,                                   "nl-SR"          , "nl_SR"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Dutch (Suriname)","Nederlands (Suriname)" },
    { wxLANGUAGE_DZONGKHA,                                         "dz"             , "dz"                        , "dz_BT"        , 0x51, 0x03, wxLayout_LeftToRight, "Dzongkha","\340\275\242\340\276\253\340\275\274\340\275\204\340\274\213\340\275\201" },
    { wxLANGUAGE_DZONGKHA_BHUTAN,                                  "dz-BT"          , "dz_BT"                     , ""             , 0x51, 0x03, wxLayout_LeftToRight, "Dzongkha (Bhutan)","\340\275\242\340\276\253\340\275\274\340\275\204\340\274\213\340\275\201 (\340\275\240\340\275\226\340\276\262\340\275\264\340\275\202)" },
    { wxLANGUAGE_EDO,                                              "bin"            , "bin"                       , "bin_NG"       , 0x66, 0x01, wxLayout_LeftToRight, "Edo","\341\272\270\314\200d\303\263" },
    { wxLANGUAGE_EDO_NIGERIA,                                      "bin-NG"         , "bin_NG"                    , ""             , 0x66, 0x01, wxLayout_LeftToRight, "Edo (Nigeria)","\341\272\270\314\200d\303\263 (Nigeria)" },
    { wxLANGUAGE_EMBU,                                             "ebu"            , "ebu"                       , "ebu_KE"       , 0x00, 0x04, wxLayout_LeftToRight, "Embu","K\304\251embu" },
    { wxLANGUAGE_EMBU_KENYA,                                       "ebu-KE"         , "ebu_KE"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Embu (Kenya)","K\304\251embu (Kenya)" },
    { wxLANGUAGE_ENGLISH,                                          "en"             , "en"                        , "en_GB"        , 0x09, 0x02, wxLayout_LeftToRight, "English","English" },
    { wxLANGUAGE_ENGLISH_AMERICAN_SAMOA,                           "en-AS"          , "en_AS"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (American Samoa)","English (American Samoa)" },
    { wxLANGUAGE_ENGLISH_ANGUILLA,                                 "en-AI"          , "en_AI"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Anguilla)","English (Anguilla)" },
    { wxLANGUAGE_ENGLISH_ANTIGUA_AND_BARBUDA,                      "en-AG"          , "en_AG"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Antigua and Barbuda)","English (Antigua & Barbuda)" },
    { wxLANGUAGE_ENGLISH_AUSTRALIA,                                "en-AU"          , "en_AU"                     , ""             , 0x09, 0x03, wxLayout_LeftToRight, "English (Australia)","English (Australia)" },
    { wxLANGUAGE_ENGLISH_AUSTRIA,                                  "en-AT"          , "en_AT"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Austria)","English (Austria)" },
    { wxLANGUAGE_ENGLISH_BAHAMAS,                                  "en-BS"          , "en_BS"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Bahamas)","English (Bahamas)" },
    { wxLANGUAGE_ENGLISH_BARBADOS,                                 "en-BB"          , "en_BB"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Barbados)","English (Barbados)" },
    { wxLANGUAGE_ENGLISH_BELGIUM,                                  "en-BE"          , "en_BE"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Belgium)","English (Belgium)" },
    { wxLANGUAGE_ENGLISH_BELIZE,                                   "en-BZ"          , "en_BZ"                     , ""             , 0x09, 0x0a, wxLayout_LeftToRight, "English (Belize)","English (Belize)" },
    { wxLANGUAGE_ENGLISH_BERMUDA,                                  "en-BM"          , "en_BM"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Bermuda)","English (Bermuda)" },
    { wxLANGUAGE_ENGLISH_BOTSWANA,                                 "en-BW"          , "en_BW"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Botswana)","English (Botswana)" },
    { wxLANGUAGE_ENGLISH_BRITISH_INDIAN_OCEAN_TERRITORY,           "en-IO"          , "en_IO"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (British Indian Ocean Territory)","English (British Indian Ocean Territory)" },
    { wxLANGUAGE_ENGLISH_BRITISH_VIRGIN_ISLANDS,                   "en-VG"          , "en_VG"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (British Virgin Islands)","English (British Virgin Islands)" },
    { wxLANGUAGE_ENGLISH_BURUNDI,                                  "en-BI"          , "en_BI"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Burundi)","English (Burundi)" },
    { wxLANGUAGE_ENGLISH_CAMEROON,                                 "en-CM"          , "en_CM"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Cameroon)","English (Cameroon)" },
    { wxLANGUAGE_ENGLISH_CANADA,                                   "en-CA"          , "en_CA"                     , ""             , 0x09, 0x04, wxLayout_LeftToRight, "English (Canada)","English (Canada)" },
    { wxLANGUAGE_ENGLISH_CARIBBEAN,                                "en-029"         , "en_029"                    , "en_CB"        , 0x09, 0x09, wxLayout_LeftToRight, "English (Caribbean)","English (Caribbean)" },
    { wxLANGUAGE_ENGLISH_CARIBBEAN_CB,                             "en-CB"          , "en_CB"                     , ""             , 0x09, 0x09, wxLayout_LeftToRight, "English (Caribbean)","English (Caribbean)" },
    { wxLANGUAGE_ENGLISH_CAYMAN_ISLANDS,                           "en-KY"          , "en_KY"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Cayman Islands)","English (Cayman Islands)" },
    { wxLANGUAGE_ENGLISH_CHRISTMAS_ISLAND,                         "en-CX"          , "en_CX"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Christmas Island)","English (Christmas Island)" },
    { wxLANGUAGE_ENGLISH_COCOS_KEELING_ISLANDS,                    "en-CC"          , "en_CC"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Cocos (Keeling) Islands)","English (Cocos (Keeling) Islands)" },
    { wxLANGUAGE_ENGLISH_COOK_ISLANDS,                             "en-CK"          , "en_CK"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Cook Islands)","English (Cook Islands)" },
    { wxLANGUAGE_ENGLISH_CYPRUS,                                   "en-CY"          , "en_CY"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Cyprus)","English (Cyprus)" },
    { wxLANGUAGE_ENGLISH_DENMARK,                                  "en-DK"          , "en_DK"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Denmark)","English (Denmark)" },
    { wxLANGUAGE_ENGLISH_DOMINICA,                                 "en-DM"          , "en_DM"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Dominica)","English (Dominica)" },
    { wxLANGUAGE_ENGLISH_EIRE,                                     "en-IE"          , "en_IE"                     , ""             , 0x09, 0x06, wxLayout_LeftToRight, "English (Ireland)","English (Ireland)" },
    { wxLANGUAGE_ENGLISH_ERITREA,                                  "en-ER"          , "en_ER"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Eritrea)","English (Eritrea)" },
    { wxLANGUAGE_ENGLISH_ESWATINI,                                 "en-SZ"          , "en_SZ"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Eswatini)","English (Eswatini)" },
    { wxLANGUAGE_ENGLISH_EUROPE,                                   "en-150"         , "en_150"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Europe)","English (Europe)" },
    { wxLANGUAGE_ENGLISH_FALKLAND_ISLANDS,                         "en-FK"          , "en_FK"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Falkland Islands)","English (Falkland Islands)" },
    { wxLANGUAGE_ENGLISH_FIJI,                                     "en-FJ"          , "en_FJ"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Fiji)","English (Fiji)" },
    { wxLANGUAGE_ENGLISH_FINLAND,                                  "en-FI"          , "en_FI"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Finland)","English (Finland)" },
    { wxLANGUAGE_ENGLISH_GAMBIA,                                   "en-GM"          , "en_GM"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Gambia)","English (Gambia)" },
    { wxLANGUAGE_ENGLISH_GERMANY,                                  "en-DE"          , "en_DE"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Germany)","English (Germany)" },
    { wxLANGUAGE_ENGLISH_GHANA,                                    "en-GH"          , "en_GH"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Ghana)","English (Ghana)" },
    { wxLANGUAGE_ENGLISH_GIBRALTAR,                                "en-GI"          , "en_GI"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Gibraltar)","English (Gibraltar)" },
    { wxLANGUAGE_ENGLISH_GRENADA,                                  "en-GD"          , "en_GD"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Grenada)","English (Grenada)" },
    { wxLANGUAGE_ENGLISH_GUAM,                                     "en-GU"          , "en_GU"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Guam)","English (Guam)" },
    { wxLANGUAGE_ENGLISH_GUERNSEY,                                 "en-GG"          , "en_GG"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Guernsey)","English (Guernsey)" },
    { wxLANGUAGE_ENGLISH_GUYANA,                                   "en-GY"          , "en_GY"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Guyana)","English (Guyana)" },
    { wxLANGUAGE_ENGLISH_HONG_KONG_SAR,                            "en-HK"          , "en_HK"                     , ""             , 0x09, 0x0f, wxLayout_LeftToRight, "English (Hong Kong SAR)","English (Hong Kong SAR)" },
    { wxLANGUAGE_ENGLISH_INDIA,                                    "en-IN"          , "en_IN"                     , ""             , 0x09, 0x10, wxLayout_LeftToRight, "English (India)","English (India)" },
    { wxLANGUAGE_ENGLISH_INDONESIA,                                "en-ID"          , "en_ID"                     , ""             , 0x09, 0x0e, wxLayout_LeftToRight, "English (Indonesia)","English (Indonesia)" },
    { wxLANGUAGE_ENGLISH_ISLE_OF_MAN,                              "en-IM"          , "en_IM"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Isle of Man)","English (Isle of Man)" },
    { wxLANGUAGE_ENGLISH_ISRAEL,                                   "en-IL"          , "en_IL"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Israel)","English (Israel)" },
    { wxLANGUAGE_ENGLISH_JAMAICA,                                  "en-JM"          , "en_JM"                     , ""             , 0x09, 0x08, wxLayout_LeftToRight, "English (Jamaica)","English (Jamaica)" },
    { wxLANGUAGE_ENGLISH_JERSEY,                                   "en-JE"          , "en_JE"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Jersey)","English (Jersey)" },
    { wxLANGUAGE_ENGLISH_KENYA,                                    "en-KE"          , "en_KE"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Kenya)","English (Kenya)" },
    { wxLANGUAGE_ENGLISH_KIRIBATI,                                 "en-KI"          , "en_KI"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Kiribati)","English (Kiribati)" },
    { wxLANGUAGE_ENGLISH_LESOTHO,                                  "en-LS"          , "en_LS"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Lesotho)","English (Lesotho)" },
    { wxLANGUAGE_ENGLISH_LIBERIA,                                  "en-LR"          , "en_LR"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Liberia)","English (Liberia)" },
    { wxLANGUAGE_ENGLISH_MACAO_SAR,                                "en-MO"          , "en_MO"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Macao SAR)","English (Macao SAR)" },
    { wxLANGUAGE_ENGLISH_MADAGASCAR,                               "en-MG"          , "en_MG"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Madagascar)","English (Madagascar)" },
    { wxLANGUAGE_ENGLISH_MALAWI,                                   "en-MW"          , "en_MW"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Malawi)","English (Malawi)" },
    { wxLANGUAGE_ENGLISH_MALAYSIA,                                 "en-MY"          , "en_MY"                     , ""             , 0x09, 0x11, wxLayout_LeftToRight, "English (Malaysia)","English (Malaysia)" },
    { wxLANGUAGE_ENGLISH_MALTA,                                    "en-MT"          , "en_MT"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Malta)","English (Malta)" },
    { wxLANGUAGE_ENGLISH_MARSHALL_ISLANDS,                         "en-MH"          , "en_MH"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Marshall Islands)","English (Marshall Islands)" },
    { wxLANGUAGE_ENGLISH_MAURITIUS,                                "en-MU"          , "en_MU"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Mauritius)","English (Mauritius)" },
    { wxLANGUAGE_ENGLISH_MICRONESIA,                               "en-FM"          , "en_FM"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Micronesia)","English (Micronesia)" },
    { wxLANGUAGE_ENGLISH_MONTSERRAT,                               "en-MS"          , "en_MS"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Montserrat)","English (Montserrat)" },
    { wxLANGUAGE_ENGLISH_NAMIBIA,                                  "en-NA"          , "en_NA"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Namibia)","English (Namibia)" },
    { wxLANGUAGE_ENGLISH_NAURU,                                    "en-NR"          , "en_NR"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Nauru)","English (Nauru)" },
    { wxLANGUAGE_ENGLISH_NETHERLANDS,                              "en-NL"          , "en_NL"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Netherlands)","English (Netherlands)" },
    { wxLANGUAGE_ENGLISH_NEW_ZEALAND,                              "en-NZ"          , "en_NZ"                     , ""             , 0x09, 0x05, wxLayout_LeftToRight, "English (New Zealand)","English (New Zealand)" },
    { wxLANGUAGE_ENGLISH_NIGERIA,                                  "en-NG"          , "en_NG"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Nigeria)","English (Nigeria)" },
    { wxLANGUAGE_ENGLISH_NIUE,                                     "en-NU"          , "en_NU"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Niue)","English (Niue)" },
    { wxLANGUAGE_ENGLISH_NORFOLK_ISLAND,                           "en-NF"          , "en_NF"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Norfolk Island)","English (Norfolk Island)" },
    { wxLANGUAGE_ENGLISH_NORTHERN_MARIANA_ISLANDS,                 "en-MP"          , "en_MP"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Northern Mariana Islands)","English (Northern Mariana Islands)" },
    { wxLANGUAGE_ENGLISH_PAKISTAN,                                 "en-PK"          , "en_PK"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Pakistan)","English (Pakistan)" },
    { wxLANGUAGE_ENGLISH_PALAU,                                    "en-PW"          , "en_PW"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Palau)","English (Palau)" },
    { wxLANGUAGE_ENGLISH_PAPUA_NEW_GUINEA,                         "en-PG"          , "en_PG"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Papua New Guinea)","English (Papua New Guinea)" },
    { wxLANGUAGE_ENGLISH_PHILIPPINES,                              "en-PH"          , "en_PH"                     , ""             , 0x09, 0x0d, wxLayout_LeftToRight, "English (Philippines)","English (Philippines)" },
    { wxLANGUAGE_ENGLISH_PITCAIRN_ISLANDS,                         "en-PN"          , "en_PN"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Pitcairn Islands)","English (Pitcairn Islands)" },
    { wxLANGUAGE_ENGLISH_PUERTO_RICO,                              "en-PR"          , "en_PR"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Puerto Rico)","English (Puerto Rico)" },
    { wxLANGUAGE_ENGLISH_RWANDA,                                   "en-RW"          , "en_RW"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Rwanda)","English (Rwanda)" },
    { wxLANGUAGE_ENGLISH_SAMOA,                                    "en-WS"          , "en_WS"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Samoa)","English (Samoa)" },
    { wxLANGUAGE_ENGLISH_SEYCHELLES,                               "en-SC"          , "en_SC"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Seychelles)","English (Seychelles)" },
    { wxLANGUAGE_ENGLISH_SIERRA_LEONE,                             "en-SL"          , "en_SL"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Sierra Leone)","English (Sierra Leone)" },
    { wxLANGUAGE_ENGLISH_SINGAPORE,                                "en-SG"          , "en_SG"                     , ""             , 0x09, 0x12, wxLayout_LeftToRight, "English (Singapore)","English (Singapore)" },
    { wxLANGUAGE_ENGLISH_SINT_MAARTEN,                             "en-SX"          , "en_SX"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Sint Maarten)","English (Sint Maarten)" },
    { wxLANGUAGE_ENGLISH_SLOVENIA,                                 "en-SI"          , "en_SI"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Slovenia)","English (Slovenia)" },
    { wxLANGUAGE_ENGLISH_SOLOMON_ISLANDS,                          "en-SB"          , "en_SB"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Solomon Islands)","English (Solomon Islands)" },
    { wxLANGUAGE_ENGLISH_SOUTH_AFRICA,                             "en-ZA"          , "en_ZA"                     , ""             , 0x09, 0x07, wxLayout_LeftToRight, "English (South Africa)","English (South Africa)" },
    { wxLANGUAGE_ENGLISH_SOUTH_SUDAN,                              "en-SS"          , "en_SS"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (South Sudan)","English (South Sudan)" },
    { wxLANGUAGE_ENGLISH_ST_HELENA_ASCENSION_TRISTAN_DA_CUNHA,     "en-SH"          , "en_SH"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (St Helena, Ascension, Tristan da Cunha)","English (St Helena, Ascension, Tristan da Cunha)" },
    { wxLANGUAGE_ENGLISH_ST_KITTS_AND_NEVIS,                       "en-KN"          , "en_KN"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (St. Kitts and Nevis)","English (St. Kitts & Nevis)" },
    { wxLANGUAGE_ENGLISH_ST_LUCIA,                                 "en-LC"          , "en_LC"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (St. Lucia)","English (St. Lucia)" },
    { wxLANGUAGE_ENGLISH_ST_VINCENT_AND_GRENADINES,                "en-VC"          , "en_VC"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (St. Vincent and Grenadines)","English (St. Vincent & Grenadines)" },
    { wxLANGUAGE_ENGLISH_SUDAN,                                    "en-SD"          , "en_SD"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Sudan)","English (Sudan)" },
    { wxLANGUAGE_ENGLISH_SWEDEN,                                   "en-SE"          , "en_SE"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Sweden)","English (Sweden)" },
    { wxLANGUAGE_ENGLISH_SWITZERLAND,                              "en-CH"          , "en_CH"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Switzerland)","English (Switzerland)" },
    { wxLANGUAGE_ENGLISH_TANZANIA,                                 "en-TZ"          , "en_TZ"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Tanzania)","English (Tanzania)" },
    { wxLANGUAGE_ENGLISH_TOKELAU,                                  "en-TK"          , "en_TK"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Tokelau)","English (Tokelau)" },
    { wxLANGUAGE_ENGLISH_TONGA,                                    "en-TO"          , "en_TO"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Tonga)","English (Tonga)" },
    { wxLANGUAGE_ENGLISH_TRINIDAD,                                 "en-TT"          , "en_TT"                     , ""             , 0x09, 0x0b, wxLayout_LeftToRight, "English (Trinidad and Tobago)","English (Trinidad & Tobago)" },
    { wxLANGUAGE_ENGLISH_TURKS_AND_CAICOS_ISLANDS,                 "en-TC"          , "en_TC"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Turks and Caicos Islands)","English (Turks & Caicos Islands)" },
    { wxLANGUAGE_ENGLISH_TUVALU,                                   "en-TV"          , "en_TV"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Tuvalu)","English (Tuvalu)" },
    { wxLANGUAGE_ENGLISH_UGANDA,                                   "en-UG"          , "en_UG"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Uganda)","English (Uganda)" },
    { wxLANGUAGE_ENGLISH_UK,                                       "en-GB"          , "en_GB"                     , ""             , 0x09, 0x02, wxLayout_LeftToRight, "English (United Kingdom)","English (United Kingdom)" },
    { wxLANGUAGE_ENGLISH_UNITED_ARAB_EMIRATES,                     "en-AE"          , "en_AE"                     , ""             , 0x09, 0x13, wxLayout_LeftToRight, "English (United Arab Emirates)","English (United Arab Emirates)" },
    { wxLANGUAGE_ENGLISH_US,                                       "en-US"          , "en_US"                     , ""             , 0x09, 0x01, wxLayout_LeftToRight, "English (United States)","English (United States)" },
    { wxLANGUAGE_ENGLISH_US_OUTLYING_ISLANDS,                      "en-UM"          , "en_UM"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (U.S. Outlying Islands)","English (U.S. Outlying Islands)" },
    { wxLANGUAGE_ENGLISH_US_VIRGIN_ISLANDS,                        "en-VI"          , "en_VI"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (U.S. Virgin Islands)","English (U.S. Virgin Islands)" },
    { wxLANGUAGE_ENGLISH_VANUATU,                                  "en-VU"          , "en_VU"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Vanuatu)","English (Vanuatu)" },
    { wxLANGUAGE_ENGLISH_WORLD,                                    "en-001"         , "en_001"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (World)","English (World)" },
    { wxLANGUAGE_ENGLISH_ZAMBIA,                                   "en-ZM"          , "en_ZM"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "English (Zambia)","English (Zambia)" },
    { wxLANGUAGE_ENGLISH_ZIMBABWE,                                 "en-ZW"          , "en_ZW"                     , ""             , 0x09, 0x0c, wxLayout_LeftToRight, "English (Zimbabwe)","English (Zimbabwe)" },
    { wxLANGUAGE_ESPERANTO,                                        "eo"             , "eo"                        , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Esperanto","esperanto" },
    { wxLANGUAGE_ESPERANTO_WORLD,                                  "eo-001"         , "eo_001"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Esperanto (World)","esperanto (Mondo)" },
    { wxLANGUAGE_ESTONIAN,                                         "et"             , "et"                        , "et_EE"        , 0x25, 0x01, wxLayout_LeftToRight, "Estonian","eesti" },
    { wxLANGUAGE_ESTONIAN_ESTONIA,                                 "et-EE"          , "et_EE"                     , ""             , 0x25, 0x01, wxLayout_LeftToRight, "Estonian (Estonia)","eesti (Eesti)" },
    { wxLANGUAGE_EWE,                                              "ee"             , "ee"                        , "ee_GH"        , 0x00, 0x04, wxLayout_LeftToRight, "Ewe","E\312\213egbe" },
    { wxLANGUAGE_EWE_GHANA,                                        "ee-GH"          , "ee_GH"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Ewe (Ghana)","E\312\213egbe (Ghana nutome)" },
    { wxLANGUAGE_EWE_TOGO,                                         "ee-TG"          , "ee_TG"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Ewe (Togo)","E\312\213egbe (Togo nutome)" },
    { wxLANGUAGE_EWONDO,                                           "ewo"            , "ewo"                       , "ewo_CM"       , 0x00, 0x04, wxLayout_LeftToRight, "Ewondo","ewondo" },
    { wxLANGUAGE_EWONDO_CAMEROON,                                  "ewo-CM"         , "ewo_CM"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Ewondo (Cameroon)","ewondo (Kam\311\231r\303\272n)" },
    { wxLANGUAGE_FAEROESE,                                         "fo"             , "fo"                        , "fo_FO"        , 0x38, 0x01, wxLayout_LeftToRight, "Faroese","f\303\270royskt" },
    { wxLANGUAGE_FAEROESE_DENMARK,                                 "fo-DK"          , "fo_DK"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Faroese (Denmark)","f\303\270royskt (Danmark)" },
    { wxLANGUAGE_FAEROESE_FAROE_ISLANDS,                           "fo-FO"          , "fo_FO"                     , ""             , 0x38, 0x01, wxLayout_LeftToRight, "Faroese (Faroe Islands)","f\303\270royskt (F\303\270royar)" },
    { wxLANGUAGE_FIJI,                                             "fj"             , "fj"                        , ""             , 0   , 0   , wxLayout_LeftToRight, "Fiji","Na Vosa Vakaviti" },
    { wxLANGUAGE_FILIPINO,                                         "fil"            , "fil"                       , "fil_PH"       , 0x64, 0x01, wxLayout_LeftToRight, "Filipino","Filipino" },
    { wxLANGUAGE_FILIPINO_PHILIPPINES,                             "fil-PH"         , "fil_PH"                    , ""             , 0x64, 0x01, wxLayout_LeftToRight, "Filipino (Philippines)","Filipino (Pilipinas)" },
    { wxLANGUAGE_FINNISH,                                          "fi"             , "fi"                        , "fi_FI"        , 0x0b, 0x01, wxLayout_LeftToRight, "Finnish","suomi" },
    { wxLANGUAGE_FINNISH_FINLAND,                                  "fi-FI"          , "fi_FI"                     , ""             , 0x0b, 0x01, wxLayout_LeftToRight, "Finnish (Finland)","suomi (Suomi)" },
    { wxLANGUAGE_FRENCH,                                           "fr"             , "fr"                        , "fr_FR"        , 0x0c, 0x01, wxLayout_LeftToRight, "French","fran\303\247ais" },
    { wxLANGUAGE_FRENCH_ALGERIA,                                   "fr-DZ"          , "fr_DZ"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "French (Algeria)","fran\303\247ais (Alg\303\251rie)" },
    { wxLANGUAGE_FRENCH_BELGIAN,                                   "fr-BE"          , "fr_BE"                     , ""             , 0x0c, 0x02, wxLayout_LeftToRight, "French (Belgium)","fran\303\247ais (Belgique)" },
    { wxLANGUAGE_FRENCH_BENIN,                                     "fr-BJ"          , "fr_BJ"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "French (Benin)","fran\303\247ais (B\303\251nin)" },
    { wxLANGUAGE_FRENCH_BURKINA_FASO,                              "fr-BF"          , "fr_BF"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "French (Burkina Faso)","fran\303\247ais (Burkina Faso)" },
    { wxLANGUAGE_FRENCH_BURUNDI,                                   "fr-BI"          , "fr_BI"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "French (Burundi)","fran\303\247ais (Burundi)" },
    { wxLANGUAGE_FRENCH_CAMEROON,                                  "fr-CM"          , "fr_CM"                     , ""             , 0x0c, 0x0b, wxLayout_LeftToRight, "French (Cameroon)","fran\303\247ais (Cameroun)" },
    { wxLANGUAGE_FRENCH_CANADIAN,                                  "fr-CA"          , "fr_CA"                     , ""             , 0x0c, 0x03, wxLayout_LeftToRight, "French (Canada)","fran\303\247ais (Canada)" },
    { wxLANGUAGE_FRENCH_CARIBBEAN,                                 "fr-029"         , "fr_029"                    , ""             , 0x0c, 0x07, wxLayout_LeftToRight, "French (Caribbean)","fran\303\247ais (Cara\303\257bes)" },
    { wxLANGUAGE_FRENCH_CENTRAL_AFRICAN_REPUBLIC,                  "fr-CF"          , "fr_CF"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "French (Central African Republic)","fran\303\247ais (R\303\251publique centrafricaine)" },
    { wxLANGUAGE_FRENCH_CHAD,                                      "fr-TD"          , "fr_TD"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "French (Chad)","fran\303\247ais (Tchad)" },
    { wxLANGUAGE_FRENCH_COMOROS,                                   "fr-KM"          , "fr_KM"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "French (Comoros)","fran\303\247ais (Comores)" },
    { wxLANGUAGE_FRENCH_CONGO,                                     "fr-CG"          , "fr_CG"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "French (Congo)","fran\303\247ais (Congo)" },
    { wxLANGUAGE_FRENCH_CONGO_DRC,                                 "fr-CD"          , "fr_CD"                     , ""             , 0x0c, 0x09, wxLayout_LeftToRight, "French Congo (DRC)","fran\303\247ais (Congo, R\303\251publique d\303\251mocratique du)" },
    { wxLANGUAGE_FRENCH_COTE_DIVOIRE,                              "fr-CI"          , "fr_CI"                     , ""             , 0x0c, 0x0c, wxLayout_LeftToRight, "French (C\303\264te d\342\200\231Ivoire)","fran\303\247ais (C\303\264te d\342\200\231Ivoire)" },
    { wxLANGUAGE_FRENCH_DJIBOUTI,                                  "fr-DJ"          , "fr_DJ"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "French (Djibouti)","fran\303\247ais (Djibouti)" },
    { wxLANGUAGE_FRENCH_EQUATORIAL_GUINEA,                         "fr-GQ"          , "fr_GQ"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "French (Equatorial Guinea)","fran\303\247ais (Guin\303\251e \303\251quatoriale)" },
    { wxLANGUAGE_FRENCH_FRANCE,                                    "fr-FR"          , "fr_FR"                     , ""             , 0x0c, 0x01, wxLayout_LeftToRight, "French (France)","fran\303\247ais (France)" },
    { wxLANGUAGE_FRENCH_FRENCH_GUIANA,                             "fr-GF"          , "fr_GF"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "French (French Guiana)","fran\303\247ais (Guyane fran\303\247aise)" },
    { wxLANGUAGE_FRENCH_FRENCH_POLYNESIA,                          "fr-PF"          , "fr_PF"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "French (French Polynesia)","fran\303\247ais (Polyn\303\251sie fran\303\247aise)" },
    { wxLANGUAGE_FRENCH_GABON,                                     "fr-GA"          , "fr_GA"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "French (Gabon)","fran\303\247ais (Gabon)" },
    { wxLANGUAGE_FRENCH_GUADELOUPE,                                "fr-GP"          , "fr_GP"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "French (Guadeloupe)","fran\303\247ais (Guadeloupe)" },
    { wxLANGUAGE_FRENCH_GUINEA,                                    "fr-GN"          , "fr_GN"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "French (Guinea)","fran\303\247ais (Guin\303\251e)" },
    { wxLANGUAGE_FRENCH_HAITI,                                     "fr-HT"          , "fr_HT"                     , ""             , 0x0c, 0x0f, wxLayout_LeftToRight, "French (Haiti)","fran\303\247ais (Ha\303\257ti)" },
    { wxLANGUAGE_FRENCH_LUXEMBOURG,                                "fr-LU"          , "fr_LU"                     , ""             , 0x0c, 0x05, wxLayout_LeftToRight, "French (Luxembourg)","fran\303\247ais (Luxembourg)" },
    { wxLANGUAGE_FRENCH_MADAGASCAR,                                "fr-MG"          , "fr_MG"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "French (Madagascar)","fran\303\247ais (Madagascar)" },
    { wxLANGUAGE_FRENCH_MALI,                                      "fr-ML"          , "fr_ML"                     , ""             , 0x0c, 0x0d, wxLayout_LeftToRight, "French (Mali)","fran\303\247ais (Mali)" },
    { wxLANGUAGE_FRENCH_MARTINIQUE,                                "fr-MQ"          , "fr_MQ"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "French (Martinique)","fran\303\247ais (Martinique)" },
    { wxLANGUAGE_FRENCH_MAURITANIA,                                "fr-MR"          , "fr_MR"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "French (Mauritania)","fran\303\247ais (Mauritanie)" },
    { wxLANGUAGE_FRENCH_MAURITIUS,                                 "fr-MU"          , "fr_MU"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "French (Mauritius)","fran\303\247ais (Maurice)" },
    { wxLANGUAGE_FRENCH_MAYOTTE,                                   "fr-YT"          , "fr_YT"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "French (Mayotte)","fran\303\247ais (Mayotte)" },
    { wxLANGUAGE_FRENCH_MONACO,                                    "fr-MC"          , "fr_MC"                     , ""             , 0x0c, 0x06, wxLayout_LeftToRight, "French (Monaco)","fran\303\247ais (Monaco)" },
    { wxLANGUAGE_FRENCH_MOROCCO,                                   "fr-MA"          , "fr_MA"                     , ""             , 0x0c, 0x0e, wxLayout_LeftToRight, "French (Morocco)","fran\303\247ais (Maroc)" },
    { wxLANGUAGE_FRENCH_NEW_CALEDONIA,                             "fr-NC"          , "fr_NC"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "French (New Caledonia)","fran\303\247ais (Nouvelle-Cal\303\251donie)" },
    { wxLANGUAGE_FRENCH_NIGER,                                     "fr-NE"          , "fr_NE"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "French (Niger)","fran\303\247ais (Niger)" },
    { wxLANGUAGE_FRENCH_REUNION,                                   "fr-RE"          , "fr_RE"                     , ""             , 0x0c, 0x08, wxLayout_LeftToRight, "French (R\303\251union)","fran\303\247ais (La R\303\251union)" },
    { wxLANGUAGE_FRENCH_RWANDA,                                    "fr-RW"          , "fr_RW"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "French (Rwanda)","fran\303\247ais (Rwanda)" },
    { wxLANGUAGE_FRENCH_SENEGAL,                                   "fr-SN"          , "fr_SN"                     , ""             , 0x0c, 0x0a, wxLayout_LeftToRight, "French (Senegal)","fran\303\247ais (S\303\251n\303\251gal)" },
    { wxLANGUAGE_FRENCH_SEYCHELLES,                                "fr-SC"          , "fr_SC"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "French (Seychelles)","fran\303\247ais (Seychelles)" },
    { wxLANGUAGE_FRENCH_ST_BARTHELEMY,                             "fr-BL"          , "fr_BL"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "French (St. Barth\303\251lemy)","fran\303\247ais (Saint-Barth\303\251lemy)" },
    { wxLANGUAGE_FRENCH_ST_MARTIN,                                 "fr-MF"          , "fr_MF"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "French (St. Martin)","fran\303\247ais (Saint-Martin)" },
    { wxLANGUAGE_FRENCH_ST_PIERRE_AND_MIQUELON,                    "fr-PM"          , "fr_PM"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "French (St. Pierre and Miquelon)","fran\303\247ais (Saint-Pierre-et-Miquelon)" },
    { wxLANGUAGE_FRENCH_SWISS,                                     "fr-CH"          , "fr_CH"                     , ""             , 0x0c, 0x04, wxLayout_LeftToRight, "French (Switzerland)","fran\303\247ais (Suisse)" },
    { wxLANGUAGE_FRENCH_SYRIA,                                     "fr-SY"          , "fr_SY"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "French (Syria)","fran\303\247ais (Syrie)" },
    { wxLANGUAGE_FRENCH_TOGO,                                      "fr-TG"          , "fr_TG"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "French (Togo)","fran\303\247ais (Togo)" },
    { wxLANGUAGE_FRENCH_TUNISIA,                                   "fr-TN"          , "fr_TN"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "French (Tunisia)","fran\303\247ais (Tunisie)" },
    { wxLANGUAGE_FRENCH_VANUATU,                                   "fr-VU"          , "fr_VU"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "French (Vanuatu)","fran\303\247ais (Vanuatu)" },
    { wxLANGUAGE_FRENCH_WALLIS_AND_FUTUNA,                         "fr-WF"          , "fr_WF"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "French (Wallis and Futuna)","fran\303\247ais (Wallis-et-Futuna)" },
    { wxLANGUAGE_FRISIAN,                                          "fy"             , "fy"                        , "fy_NL"        , 0x62, 0x01, wxLayout_LeftToRight, "Western Frisian","Frysk" },
    { wxLANGUAGE_FRISIAN_NETHERLANDS,                              "fy-NL"          , "fy_NL"                     , ""             , 0x62, 0x01, wxLayout_LeftToRight, "Western Frisian (Netherlands)","Frysk (Nederl\303\242n)" },
    { wxLANGUAGE_FRIULIAN,                                         "fur"            , "fur"                       , "fur_IT"       , 0x00, 0x04, wxLayout_LeftToRight, "Friulian","furlan" },
    { wxLANGUAGE_FRIULIAN_ITALY,                                   "fur-IT"         , "fur_IT"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Friulian (Italy)","furlan (Italie)" },
    { wxLANGUAGE_FULAH,                                            "ff"             , "ff"                        , ""             , 0x67, 0x02, wxLayout_LeftToRight, "Fulah","Pulaar" },
    { wxLANGUAGE_FULAH_ADLAM,                                      "ff-Adlm"        , "ff@adlam"                  , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Fulah (Adlam)","\360\236\244\206\360\236\244\265\360\236\244\244\360\236\244\242\360\236\244\252 (\360\236\244\200\360\236\244\201\360\236\244\202\360\236\244\242\360\236\244\203)" },
    { wxLANGUAGE_FULAH_ADLAM_BURKINA_FASO,                         "ff-Adlm-BF"     , "ff_BF@adlam"               , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Fulah (Adlam, Burkina Faso)","\360\236\244\206\360\236\244\265\360\236\244\244\360\236\244\242\360\236\244\252 (\360\236\244\204\360\236\244\265\360\236\244\252\360\236\244\263\360\236\244\255\360\236\244\262\360\236\244\242 \360\236\244\212\360\236\244\242\360\236\244\247\360\236\244\256\360\236\245\205)" },
    { wxLANGUAGE_FULAH_ADLAM_CAMEROON,                             "ff-Adlm-CM"     , "ff_CM@adlam"               , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Fulah (Adlam, Cameroon)","\360\236\244\206\360\236\244\265\360\236\244\244\360\236\244\242\360\236\244\252 (\360\236\244\221\360\236\244\242\360\236\244\245\360\236\244\242\360\236\244\252\360\236\244\265\360\236\245\205\360\236\244\262)" },
    { wxLANGUAGE_FULAH_ADLAM_GAMBIA,                               "ff-Adlm-GM"     , "ff_GM@adlam"               , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Fulah (Adlam, Gambia)","\360\236\244\206\360\236\244\265\360\236\244\244\360\236\244\242\360\236\244\252 (\360\236\244\230\360\236\244\242\360\236\244\245\360\236\244\246\360\236\244\255\360\236\244\264\360\236\244\242)" },
    { wxLANGUAGE_FULAH_ADLAM_GHANA,                                "ff-Adlm-GH"     , "ff_GH@adlam"               , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Fulah (Adlam, Ghana)","\360\236\244\206\360\236\244\265\360\236\244\244\360\236\244\242\360\236\244\252 (\360\236\244\230\360\236\244\242\360\236\244\262\360\236\244\242)" },
    { wxLANGUAGE_FULAH_ADLAM_GUINEA,                               "ff-Adlm-GN"     , "ff_GN@adlam"               , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Fulah (Adlam, Guinea)","\360\236\244\206\360\236\244\265\360\236\244\244\360\236\244\242\360\236\244\252 (\360\236\244\230\360\236\244\255\360\236\244\262\360\236\244\253)" },
    { wxLANGUAGE_FULAH_ADLAM_GUINEA_BISSAU,                        "ff-Adlm-GW"     , "ff_GW@adlam"               , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Fulah (Adlam, Guinea-Bissau)","\360\236\244\206\360\236\244\265\360\236\244\244\360\236\244\242\360\236\244\252 (\360\236\244\230\360\236\244\255\360\236\244\262\360\236\244\253-\360\236\244\204\360\236\244\255\360\236\244\247\360\236\244\242\360\236\244\261\360\236\244\256\360\236\245\205)" },
    { wxLANGUAGE_FULAH_ADLAM_LIBERIA,                              "ff-Adlm-LR"     , "ff_LR@adlam"               , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Fulah (Adlam, Liberia)","\360\236\244\206\360\236\244\265\360\236\244\244\360\236\244\242\360\236\244\252 (\360\236\244\202\360\236\244\242\360\236\244\246\360\236\244\255\360\236\244\252\360\236\244\255\360\236\244\264\360\236\244\242\360\236\245\204)" },
    { wxLANGUAGE_FULAH_ADLAM_MAURITANIA,                           "ff-Adlm-MR"     , "ff_MR@adlam"               , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Fulah (Adlam, Mauritania)","\360\236\244\206\360\236\244\265\360\236\244\244\360\236\244\242\360\236\244\252 (\360\236\244\203\360\236\244\256\360\236\244\252\360\236\244\274\360\236\244\242\360\236\244\262\360\236\244\255\360\236\245\205)" },
    { wxLANGUAGE_FULAH_ADLAM_NIGER,                                "ff-Adlm-NE"     , "ff_NE@adlam"               , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Fulah (Adlam, Niger)","\360\236\244\206\360\236\244\265\360\236\244\244\360\236\244\242\360\236\244\252 (\360\236\244\220\360\236\244\255\360\236\245\205\360\236\244\266\360\236\244\253\360\236\244\252)" },
    { wxLANGUAGE_FULAH_ADLAM_NIGERIA,                              "ff-Adlm-NG"     , "ff_NG@adlam"               , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Fulah (Adlam, Nigeria)","\360\236\244\206\360\236\244\265\360\236\244\244\360\236\244\242\360\236\244\252 (\360\236\244\220\360\236\244\242\360\236\244\266\360\236\244\253\360\236\244\252\360\236\244\255\360\236\244\264\360\236\244\242\360\236\245\204)" },
    { wxLANGUAGE_FULAH_ADLAM_SENEGAL,                              "ff-Adlm-SN"     , "ff_SN@adlam"               , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Fulah (Adlam, Senegal)","\360\236\244\206\360\236\244\265\360\236\244\244\360\236\244\242\360\236\244\252 (\360\236\244\205\360\236\244\253\360\236\244\262\360\236\244\253\360\236\244\272\360\236\244\242\360\236\245\204\360\236\244\244)" },
    { wxLANGUAGE_FULAH_ADLAM_SIERRA_LEONE,                         "ff-Adlm-SL"     , "ff_SL@adlam"               , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Fulah (Adlam, Sierra Leone)","\360\236\244\206\360\236\244\265\360\236\244\244\360\236\244\242\360\236\244\252 (\360\236\244\205\360\236\244\242\360\236\244\252\360\236\244\242\360\236\244\244\360\236\244\256\360\236\244\262)" },
    { wxLANGUAGE_FULAH_LATIN,                                      "ff-Latn"        , "ff@latin"                  , ""             , 0x67, 0x02, wxLayout_LeftToRight, "Fulah (Latin)","Pulaar" },
    { wxLANGUAGE_FULAH_LATIN_BURKINA_FASO,                         "ff-Latn-BF"     , "ff_BF@latin"               , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Fulah (Latin, Burkina Faso)","Pulaar (Burkibaa Faaso)" },
    { wxLANGUAGE_FULAH_LATIN_CAMEROON,                             "ff-Latn-CM"     , "ff_CM@latin"               , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Fulah (Latin, Cameroon)","Pulaar (Kameruun)" },
    { wxLANGUAGE_FULAH_LATIN_GAMBIA,                               "ff-Latn-GM"     , "ff_GM@latin"               , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Fulah (Latin, Gambia)","Pulaar (Gammbi)" },
    { wxLANGUAGE_FULAH_LATIN_GHANA,                                "ff-Latn-GH"     , "ff_GH@latin"               , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Fulah (Latin, Ghana)","Pulaar (Ganaa)" },
    { wxLANGUAGE_FULAH_LATIN_GUINEA,                               "ff-Latn-GN"     , "ff_GN@latin"               , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Fulah (Latin, Guinea)","Pulaar (Gine)" },
    { wxLANGUAGE_FULAH_LATIN_GUINEA_BISSAU,                        "ff-Latn-GW"     , "ff_GW@latin"               , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Fulah (Latin, Guinea-Bissau)","Pulaar (Gine-Bisaawo)" },
    { wxLANGUAGE_FULAH_LATIN_LIBERIA,                              "ff-Latn-LR"     , "ff_LR@latin"               , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Fulah (Latin, Liberia)","Pulaar (Liberiyaa)" },
    { wxLANGUAGE_FULAH_LATIN_MAURITANIA,                           "ff-Latn-MR"     , "ff_MR@latin"               , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Fulah (Latin, Mauritania)","Pulaar (Muritani)" },
    { wxLANGUAGE_FULAH_LATIN_NIGER,                                "ff-Latn-NE"     , "ff_NE@latin"               , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Fulah (Latin, Niger)","Pulaar (Nijeer)" },
    { wxLANGUAGE_FULAH_LATIN_NIGERIA,                              "ff-Latn-NG"     , "ff_NG@latin"               , ""             , 0x67, 0x01, wxLayout_LeftToRight, "Fulah (Latin, Nigeria)","Pulaar (Nijeriyaa)" },
    { wxLANGUAGE_FULAH_LATIN_SENEGAL,                              "ff-Latn-SN"     , "ff_SN@latin"               , ""             , 0x67, 0x02, wxLayout_LeftToRight, "Fulah (Latin, Senegal)","Pulaar (Senegaal)" },
    { wxLANGUAGE_FULAH_LATIN_SIERRA_LEONE,                         "ff-Latn-SL"     , "ff_SL@latin"               , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Fulah (Latin, Sierra Leone)","Pulaar (Seraa liyon)" },
    { wxLANGUAGE_GALICIAN,                                         "gl"             , "gl"                        , "gl_ES"        , 0x56, 0x01, wxLayout_LeftToRight, "Galician","galego" },
    { wxLANGUAGE_GALICIAN_SPAIN,                                   "gl-ES"          , "gl_ES"                     , ""             , 0x56, 0x01, wxLayout_LeftToRight, "Galician (Galician)","galego (galego)" },
    { wxLANGUAGE_GANDA,                                            "lg"             , "lg"                        , "lg_UG"        , 0x00, 0x04, wxLayout_LeftToRight, "Ganda","Luganda" },
    { wxLANGUAGE_GANDA_UGANDA,                                     "lg-UG"          , "lg_UG"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Ganda (Uganda)","Luganda (Yuganda)" },
    { wxLANGUAGE_GEORGIAN,                                         "ka"             , "ka"                        , "ka_GE"        , 0x37, 0x01, wxLayout_LeftToRight, "Georgian","\341\203\245\341\203\220\341\203\240\341\203\227\341\203\243\341\203\232\341\203\230" },
    { wxLANGUAGE_GEORGIAN_GEORGIA,                                 "ka-GE"          , "ka_GE"                     , ""             , 0x37, 0x01, wxLayout_LeftToRight, "Georgian (Georgia)","\341\203\245\341\203\220\341\203\240\341\203\227\341\203\243\341\203\232\341\203\230 (\341\203\241\341\203\220\341\203\245\341\203\220\341\203\240\341\203\227\341\203\225\341\203\224\341\203\232\341\203\235)" },
    { wxLANGUAGE_GERMAN,                                           "de"             , "de"                        , "de_DE"        , 0x07, 0x01, wxLayout_LeftToRight, "German","Deutsch" },
    { wxLANGUAGE_GERMAN_AUSTRIAN,                                  "de-AT"          , "de_AT"                     , ""             , 0x07, 0x03, wxLayout_LeftToRight, "German (Austria)","Deutsch (\303\226sterreich)" },
    { wxLANGUAGE_GERMAN_BELGIUM,                                   "de-BE"          , "de_BE"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "German (Belgium)","Deutsch (Belgien)" },
    { wxLANGUAGE_GERMAN_GERMANY,                                   "de-DE"          , "de_DE"                     , ""             , 0x07, 0x01, wxLayout_LeftToRight, "German (Germany)","Deutsch (Deutschland)" },
    { wxLANGUAGE_GERMAN_ITALY,                                     "de-IT"          , "de_IT"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "German (Italy)","Deutsch (Italien)" },
    { wxLANGUAGE_GERMAN_LIECHTENSTEIN,                             "de-LI"          , "de_LI"                     , ""             , 0x07, 0x05, wxLayout_LeftToRight, "German (Liechtenstein)","Deutsch (Liechtenstein)" },
    { wxLANGUAGE_GERMAN_LUXEMBOURG,                                "de-LU"          , "de_LU"                     , ""             , 0x07, 0x04, wxLayout_LeftToRight, "German (Luxembourg)","Deutsch (Luxemburg)" },
    { wxLANGUAGE_GERMAN_SWISS,                                     "de-CH"          , "de_CH"                     , ""             , 0x07, 0x02, wxLayout_LeftToRight, "German (Switzerland)","Deutsch (Schweiz)" },
    { wxLANGUAGE_GREEK,                                            "el"             , "el"                        , "el_GR"        , 0x08, 0x01, wxLayout_LeftToRight, "Greek","\316\225\316\273\316\273\316\267\316\275\316\271\316\272\316\254" },
    { wxLANGUAGE_GREEK_CYPRUS,                                     "el-CY"          , "el_CY"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Greek (Cyprus)","\316\225\316\273\316\273\316\267\316\275\316\271\316\272\316\254 (\316\232\317\215\317\200\317\201\316\277\317\202)" },
    { wxLANGUAGE_GREEK_GREECE,                                     "el-GR"          , "el_GR"                     , ""             , 0x08, 0x01, wxLayout_LeftToRight, "Greek (Greece)","\316\225\316\273\316\273\316\267\316\275\316\271\316\272\316\254 (\316\225\316\273\316\273\316\254\316\264\316\261)" },
    { wxLANGUAGE_GUARANI,                                          "gn"             , "gn"                        , "gn_PY"        , 0x74, 0x01, wxLayout_LeftToRight, "Guarani","Ava\303\261e\342\200\231\341\272\275" },
    { wxLANGUAGE_GUARANI_PARAGUAY,                                 "gn-PY"          , "gn_PY"                     , ""             , 0x74, 0x01, wxLayout_LeftToRight, "Guarani (Paraguay)","Ava\303\261e\342\200\231\341\272\275 (Paragu\303\241i)" },
    { wxLANGUAGE_GUJARATI,                                         "gu"             , "gu"                        , "gu_IN"        , 0x47, 0x01, wxLayout_LeftToRight, "Gujarati","\340\252\227\340\253\201\340\252\234\340\252\260\340\252\276\340\252\244\340\253\200" },
    { wxLANGUAGE_GUJARATI_INDIA,                                   "gu-IN"          , "gu_IN"                     , ""             , 0x47, 0x01, wxLayout_LeftToRight, "Gujarati (India)","\340\252\227\340\253\201\340\252\234\340\252\260\340\252\276\340\252\244\340\253\200 (\340\252\255\340\252\276\340\252\260\340\252\244)" },
    { wxLANGUAGE_GUSII,                                            "guz"            , "guz"                       , "guz_KE"       , 0x00, 0x04, wxLayout_LeftToRight, "Gusii","Ekegusii" },
    { wxLANGUAGE_GUSII_KENYA,                                      "guz-KE"         , "guz_KE"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Gusii (Kenya)","Ekegusii (Kenya)" },
    { wxLANGUAGE_HAUSA,                                            "ha"             , "ha"                        , ""             , 0x68, 0x01, wxLayout_LeftToRight, "Hausa","Hausa" },
    { wxLANGUAGE_HAUSA_LATIN,                                      "ha-Latn"        , "ha@latin"                  , ""             , 0x68, 0x01, wxLayout_LeftToRight, "Hausa (Latin)","Hausa (Latin)" },
    { wxLANGUAGE_HAUSA_LATIN_GHANA,                                "ha-Latn-GH"     , "ha_GH@latin"               , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Hausa (Latin, Ghana)","Hausa (Gana)" },
    { wxLANGUAGE_HAUSA_LATIN_NIGER,                                "ha-Latn-NE"     , "ha_NE@latin"               , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Hausa (Latin, Niger)","Hausa (Nijar)" },
    { wxLANGUAGE_HAUSA_LATIN_NIGERIA,                              "ha-Latn-NG"     , "ha_NG@latin"               , ""             , 0x68, 0x01, wxLayout_LeftToRight, "Hausa (Latin, Nigeria)","Hausa (Najeriya)" },
    { wxLANGUAGE_HAWAIIAN,                                         "haw"            , "haw"                       , "haw_US"       , 0x75, 0x01, wxLayout_LeftToRight, "Hawaiian","\312\273\305\214lelo Hawai\312\273i" },
    { wxLANGUAGE_HAWAIIAN_US,                                      "haw-US"         , "haw_US"                    , ""             , 0x75, 0x01, wxLayout_LeftToRight, "Hawaiian (United States)","\312\273\305\214lelo Hawai\312\273i (\312\273Amelika Hui P\305\253 \312\273Ia)" },
    { wxLANGUAGE_HEBREW,                                           "he"             , "he"                        , "he_IL"        , 0x0d, 0x01, wxLayout_RightToLeft, "Hebrew","\327\242\327\221\327\250\327\231\327\252" },
    { wxLANGUAGE_HEBREW_ISRAEL,                                    "he-IL"          , "he_IL"                     , ""             , 0x0d, 0x01, wxLayout_RightToLeft, "Hebrew (Israel)","\327\242\327\221\327\250\327\231\327\252 (\327\231\327\251\327\250\327\220\327\234)" },
    { wxLANGUAGE_HINDI,                                            "hi"             , "hi"                        , "hi_IN"        , 0x39, 0x01, wxLayout_LeftToRight, "Hindi","\340\244\271\340\244\277\340\244\250\340\245\215\340\244\246\340\245\200" },
    { wxLANGUAGE_HINDI_INDIA,                                      "hi-IN"          , "hi_IN"                     , ""             , 0x39, 0x01, wxLayout_LeftToRight, "Hindi (India)","\340\244\271\340\244\277\340\244\250\340\245\215\340\244\246\340\245\200 (\340\244\255\340\244\276\340\244\260\340\244\244)" },
    { wxLANGUAGE_HUNGARIAN,                                        "hu"             , "hu"                        , "hu_HU"        , 0x0e, 0x01, wxLayout_LeftToRight, "Hungarian","magyar" },
    { wxLANGUAGE_HUNGARIAN_HUNGARY,                                "hu-HU"          , "hu_HU"                     , ""             , 0x0e, 0x01, wxLayout_LeftToRight, "Hungarian (Hungary)","magyar (Magyarorsz\303\241g)" },
    { wxLANGUAGE_IBIBIO,                                           "ibb"            , "ibb"                       , "ibb_NG"       , 0x69, 0x01, wxLayout_LeftToRight, "Ibibio","Ibibio-Efik" },
    { wxLANGUAGE_IBIBIO_NIGERIA,                                   "ibb-NG"         , "ibb_NG"                    , ""             , 0x69, 0x01, wxLayout_LeftToRight, "Ibibio (Nigeria)","Ibibio-Efik (Nigeria)" },
    { wxLANGUAGE_ICELANDIC,                                        "is"             , "is"                        , "is_IS"        , 0x0f, 0x01, wxLayout_LeftToRight, "Icelandic","\303\255slenska" },
    { wxLANGUAGE_ICELANDIC_ICELAND,                                "is-IS"          , "is_IS"                     , ""             , 0x0f, 0x01, wxLayout_LeftToRight, "Icelandic (Iceland)","\303\255slenska (\303\215sland)" },
    { wxLANGUAGE_IGBO,                                             "ig"             , "ig"                        , "ig_NG"        , 0x70, 0x01, wxLayout_LeftToRight, "Igbo","Igbo" },
    { wxLANGUAGE_IGBO_NIGERIA,                                     "ig-NG"          , "ig_NG"                     , ""             , 0x70, 0x01, wxLayout_LeftToRight, "Igbo (Nigeria)","Igbo (Na\341\273\213j\341\273\213r\341\273\213a)" },
    { wxLANGUAGE_INDONESIAN,                                       "id"             , "id"                        , "id_ID"        , 0x21, 0x01, wxLayout_LeftToRight, "Indonesian","Indonesia" },
    { wxLANGUAGE_INDONESIAN_INDONESIA,                             "id-ID"          , "id_ID"                     , ""             , 0x21, 0x01, wxLayout_LeftToRight, "Indonesian (Indonesia)","Indonesia (Indonesia)" },
    { wxLANGUAGE_INTERLINGUA,                                      "ia"             , "ia"                        , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Interlingua","interlingua" },
    { wxLANGUAGE_INTERLINGUA_WORLD,                                "ia-001"         , "ia_001"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Interlingua (World)","interlingua (Mundo)" },
    { wxLANGUAGE_INTERLINGUE,                                      "ie"             , "ie"                        , ""             , 0   , 0   , wxLayout_LeftToRight, "Interlingue","Interlingue" },
    { wxLANGUAGE_INUKTITUT,                                        "iu"             , "iu"                        , ""             , 0x5d, 0x02, wxLayout_LeftToRight, "Inuktitut","Inuktitut" },
    { wxLANGUAGE_INUKTITUT_LATIN,                                  "iu-Latn"        , "iu@latin"                  , ""             , 0x5d, 0x02, wxLayout_LeftToRight, "Inuktitut (Latin)","Inuktitut (Qaliujaaqpait)" },
    { wxLANGUAGE_INUKTITUT_LATIN_CANADA,                           "iu-Latn-CA"     , "iu_CA@latin"               , ""             , 0x5d, 0x02, wxLayout_LeftToRight, "Inuktitut (Latin, Canada)","Inuktitut (Kanatami)" },
    { wxLANGUAGE_INUKTITUT_SYLLABICS,                              "iu-Cans"        , "iu@canadian_aboriginal"    , ""             , 0x5d, 0x01, wxLayout_LeftToRight, "Inuktitut (Syllabics)","\341\220\203\341\223\204\341\222\203\341\221\216\341\221\220\341\221\246 (\341\226\203\341\223\202\341\220\205\341\224\256\341\226\205\341\220\270\341\220\203\341\221\246)" },
    { wxLANGUAGE_INUKTITUT_SYLLABICS_CANADA,                       "iu-Cans-CA"     , "iu_CA@canadian_aboriginal" , ""             , 0x5d, 0x01, wxLayout_LeftToRight, "Inuktitut (Syllabics, Canada)","\341\220\203\341\223\204\341\222\203\341\221\216\341\221\220\341\221\246 (\341\221\262\341\223\207\341\221\225\341\222\245)" },
    { wxLANGUAGE_INUPIAK,                                          "ik"             , "ik"                        , ""             , 0   , 0   , wxLayout_LeftToRight, "Inupiak","Inupiaq" },
    { wxLANGUAGE_IRISH,                                            "ga"             , "ga"                        , "ga_IE"        , 0x3c, 0x02, wxLayout_LeftToRight, "Irish","Gaeilge" },
    { wxLANGUAGE_IRISH_IRELAND,                                    "ga-IE"          , "ga_IE"                     , ""             , 0x3c, 0x02, wxLayout_LeftToRight, "Irish (Ireland)","Gaeilge (\303\211ire)" },
    { wxLANGUAGE_IRISH_UNITED_KINGDOM,                             "ga-GB"          , "ga_GB"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Irish (United Kingdom)","Gaeilge (an R\303\255ocht Aontaithe)" },
    { wxLANGUAGE_ITALIAN,                                          "it"             , "it"                        , "it_IT"        , 0x10, 0x01, wxLayout_LeftToRight, "Italian","italiano" },
    { wxLANGUAGE_ITALIAN_ITALY,                                    "it-IT"          , "it_IT"                     , ""             , 0x10, 0x01, wxLayout_LeftToRight, "Italian (Italy)","italiano (Italia)" },
    { wxLANGUAGE_ITALIAN_SAN_MARINO,                               "it-SM"          , "it_SM"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Italian (San Marino)","italiano (San Marino)" },
    { wxLANGUAGE_ITALIAN_SWISS,                                    "it-CH"          , "it_CH"                     , ""             , 0x10, 0x02, wxLayout_LeftToRight, "Italian (Switzerland)","italiano (Svizzera)" },
    { wxLANGUAGE_ITALIAN_VATICAN_CITY,                             "it-VA"          , "it_VA"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Italian (Vatican City)","italiano (Citt\303\240 del Vaticano)" },
    { wxLANGUAGE_JAPANESE,                                         "ja"             , "ja"                        , "ja_JP"        , 0x11, 0x01, wxLayout_LeftToRight, "Japanese","\346\227\245\346\234\254\350\252\236" },
    { wxLANGUAGE_JAPANESE_JAPAN,                                   "ja-JP"          , "ja_JP"                     , ""             , 0x11, 0x01, wxLayout_LeftToRight, "Japanese (Japan)","\346\227\245\346\234\254\350\252\236 (\346\227\245\346\234\254)" },
    { wxLANGUAGE_JAVANESE,                                         "jv"             , "jv"                        , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Javanese","Basa Jawa" },
    { wxLANGUAGE_JAVANESE_JAVANESE,                                "jv-Java"        , "jv@javanese"               , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Javanese (Javanese)","\352\246\247\352\246\261\352\246\227\352\246\256" },
    { wxLANGUAGE_JAVANESE_JAVANESE_INDONESIA,                      "jv-Java-ID"     , "jv_ID@javanese"            , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Javanese (Javanese, Indonesia)","\352\246\247\352\246\261\352\246\227\352\246\256 (Indon\303\251sia)" },
    { wxLANGUAGE_JAVANESE_LATIN,                                   "jv-Latn"        , "jv@latin"                  , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Javanese","Basa Jawa" },
    { wxLANGUAGE_JAVANESE_LATIN_INDONESIA,                         "jv-Latn-ID"     , "jv_ID@latin"               , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Javanese (Indonesia)","Basa Jawa (Indonesia)" },
    { wxLANGUAGE_JOLA_FONYI,                                       "dyo"            , "dyo"                       , "dyo_SN"       , 0x00, 0x04, wxLayout_LeftToRight, "Jola-Fonyi","joola" },
    { wxLANGUAGE_JOLA_FONYI_SENEGAL,                               "dyo-SN"         , "dyo_SN"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Jola-Fonyi (Senegal)","joola (Senegal)" },
    { wxLANGUAGE_KABUVERDIANU,                                     "kea"            , "kea"                       , "kea_CV"       , 0x00, 0x04, wxLayout_LeftToRight, "Kabuverdianu","kabuverdianu" },
    { wxLANGUAGE_KABUVERDIANU_CABO_VERDE,                          "kea-CV"         , "kea_CV"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Kabuverdianu (Cabo Verde)","kabuverdianu (Kabu Verdi)" },
    { wxLANGUAGE_KABYLE,                                           "kab"            , "kab"                       , "kab_DZ"       , 0x00, 0x04, wxLayout_LeftToRight, "Kabyle","Taqbaylit" },
    { wxLANGUAGE_KABYLE_ALGERIA,                                   "kab-DZ"         , "kab_DZ"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Kabyle (Algeria)","Taqbaylit (Lezzayer)" },
    { wxLANGUAGE_KAKO,                                             "kkj"            , "kkj"                       , "kkj_CM"       , 0x00, 0x04, wxLayout_LeftToRight, "Kako","kak\311\224" },
    { wxLANGUAGE_KAKO_CAMEROON,                                    "kkj-CM"         , "kkj_CM"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Kako (Cameroon)","kak\311\224 (Kam\311\233run)" },
    { wxLANGUAGE_KALAALLISUT,                                      "kl"             , "kl"                        , "kl_GL"        , 0x6f, 0x01, wxLayout_LeftToRight, "Kalaallisut","kalaallisut" },
    { wxLANGUAGE_KALAALLISUT_GREENLAND,                            "kl-GL"          , "kl_GL"                     , ""             , 0x6f, 0x01, wxLayout_LeftToRight, "Kalaallisut (Greenland)","kalaallisut (Kalaallit Nunaat)" },
    { wxLANGUAGE_KALENJIN,                                         "kln"            , "kln"                       , "kln_KE"       , 0x00, 0x04, wxLayout_LeftToRight, "Kalenjin","Kalenjin" },
    { wxLANGUAGE_KALENJIN_KENYA,                                   "kln-KE"         , "kln_KE"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Kalenjin (Kenya)","Kalenjin (Emetab Kenya)" },
    { wxLANGUAGE_KAMBA,                                            "kam"            , "kam"                       , "kam_KE"       , 0x00, 0x04, wxLayout_LeftToRight, "Kamba","Kikamba" },
    { wxLANGUAGE_KAMBA_KENYA,                                      "kam-KE"         , "kam_KE"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Kamba (Kenya)","Kikamba (Kenya)" },
    { wxLANGUAGE_KANNADA,                                          "kn"             , "kn"                        , "kn_IN"        , 0x4b, 0x01, wxLayout_LeftToRight, "Kannada","\340\262\225\340\262\250\340\263\215\340\262\250\340\262\241" },
    { wxLANGUAGE_KANNADA_INDIA,                                    "kn-IN"          , "kn_IN"                     , ""             , 0x4b, 0x01, wxLayout_LeftToRight, "Kannada (India)","\340\262\225\340\262\250\340\263\215\340\262\250\340\262\241 (\340\262\255\340\262\276\340\262\260\340\262\244)" },
    { wxLANGUAGE_KANURI,                                           "kr"             , "kr"                        , ""             , 0x71, 0x01, wxLayout_LeftToRight, "Kanuri","Kanuri" },
    { wxLANGUAGE_KANURI_LATIN,                                     "kr-Latn"        , "kr@latin"                  , ""             , 0x71, 0x01, wxLayout_LeftToRight, "Kanuri (Latin)","Kanuri" },
    { wxLANGUAGE_KANURI_LATIN_NIGERIA,                             "kr-Latn-NG"     , "kr_NG@latin"               , ""             , 0x71, 0x01, wxLayout_LeftToRight, "Kanuri (Latin, Nigeria)","Kanuri (Nigeria)" },
    { wxLANGUAGE_KASHMIRI,                                         "ks"             , "ks"                        , "ks_IN"        , 0x00, 0x04, wxLayout_RightToLeft, "Kashmiri","\332\251\331\262\330\264\331\217\330\261" },
    { wxLANGUAGE_KASHMIRI_ARABIC,                                  "ks-Arab"        , "ks@arabic"                 , ""             , 0x00, 0x04, wxLayout_RightToLeft, "Kashmiri (Arabic)","\332\251\331\262\330\264\331\217\330\261 (\330\247\331\216\330\261\330\250\333\214)" },
    { wxLANGUAGE_KASHMIRI_ARABIC_INDIA,                            "ks-Arab-IN"     , "ks_IN@arabic"              , ""             , 0x00, 0x04, wxLayout_RightToLeft, "Kashmiri (Arabic)","\332\251\331\262\330\264\331\217\330\261 (\330\247\331\216\330\261\330\250\333\214)" },
    { wxLANGUAGE_KASHMIRI_DEVANAGARI,                              "ks-Deva"        , "ks@devanagari"             , ""             , 0x60, 0x02, wxLayout_LeftToRight, "Kashmiri (Devanagari)","\340\244\225\340\245\211\340\244\266\340\245\201\340\244\260" },
    { wxLANGUAGE_KASHMIRI_DEVANAGARI_INDIA,                        "ks-Deva-IN"     , "ks_IN@devanagari"          , ""             , 0x60, 0x02, wxLayout_LeftToRight, "Kashmiri (Devanagari)","\340\244\225\340\245\211\340\244\266\340\245\201\340\244\260 (India)" },
    { wxLANGUAGE_KASHMIRI_INDIA,                                   "ks-IN"          , "ks_IN"                     , ""             , 0x00, 0x04, wxLayout_RightToLeft, "Kashmiri (India)","\332\251\330\264\331\210\330\261 (\330\250\332\276\330\247\330\261\330\252)" },
    { wxLANGUAGE_KAZAKH,                                           "kk"             , "kk"                        , "kk_KZ"        , 0x3f, 0x01, wxLayout_LeftToRight, "Kazakh","\322\233\320\260\320\267\320\260\322\233 \321\202\321\226\320\273\321\226" },
    { wxLANGUAGE_KAZAKH_KAZAKHSTAN,                                "kk-KZ"          , "kk_KZ"                     , ""             , 0x3f, 0x01, wxLayout_LeftToRight, "Kazakh (Kazakhstan)","\322\233\320\260\320\267\320\260\322\233 \321\202\321\226\320\273\321\226 (\322\232\320\260\320\267\320\260\322\233\321\201\321\202\320\260\320\275)" },
    { wxLANGUAGE_KHMER,                                            "km"             , "km"                        , "km_KH"        , 0x53, 0x01, wxLayout_LeftToRight, "Khmer","\341\236\201\341\237\222\341\236\230\341\237\202\341\236\232" },
    { wxLANGUAGE_KHMER_CAMBODIA,                                   "km-KH"          , "km_KH"                     , ""             , 0x53, 0x01, wxLayout_LeftToRight, "Khmer (Cambodia)","\341\236\201\341\237\222\341\236\230\341\237\202\341\236\232 (\341\236\200\341\236\230\341\237\222\341\236\226\341\236\273\341\236\207\341\236\266)" },
    { wxLANGUAGE_KICHE,                                            "quc"            , "quc"                       , ""             , 0x86, 0x01, wxLayout_LeftToRight, "K\312\274iche\312\274","K\312\274iche\312\274" },
    { wxLANGUAGE_KICHE_LATIN,                                      "quc-Latn"       , "quc@latin"                 , ""             , 0x86, 0x01, wxLayout_LeftToRight, "K\312\274iche\312\274 (Latin)","K\312\274iche\312\274" },
    { wxLANGUAGE_KICHE_LATIN_GUATEMALA,                            "quc-Latn-GT"    , "quc_GT@latin"              , ""             , 0x86, 0x01, wxLayout_LeftToRight, "K\312\274iche\312\274 (Latin, Guatemala)","K\312\274iche\312\274 (Guatemala)" },
    { wxLANGUAGE_KIKUYU,                                           "ki"             , "ki"                        , "ki_KE"        , 0x00, 0x04, wxLayout_LeftToRight, "Kikuyu","Gikuyu" },
    { wxLANGUAGE_KIKUYU_KENYA,                                     "ki-KE"          , "ki_KE"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Kikuyu (Kenya)","Gikuyu (Kenya)" },
    { wxLANGUAGE_KINYARWANDA,                                      "rw"             , "rw"                        , "rw_RW"        , 0x87, 0x01, wxLayout_LeftToRight, "Kinyarwanda","Kinyarwanda" },
    { wxLANGUAGE_KINYARWANDA_RWANDA,                               "rw-RW"          , "rw_RW"                     , ""             , 0x87, 0x01, wxLayout_LeftToRight, "Kinyarwanda (Rwanda)","Kinyarwanda (U Rwanda)" },
    { wxLANGUAGE_KIRGHIZ,                                          "ky"             , "ky"                        , "ky_KG"        , 0x40, 0x01, wxLayout_LeftToRight, "Kyrgyz","\320\272\321\213\321\200\320\263\321\213\320\267\321\207\320\260" },
    { wxLANGUAGE_KIRGHIZ_KYRGYZSTAN,                               "ky-KG"          , "ky_KG"                     , ""             , 0x40, 0x01, wxLayout_LeftToRight, "Kyrgyz (Kyrgyzstan)","\320\272\321\213\321\200\320\263\321\213\320\267\321\207\320\260 (\320\232\321\213\321\200\320\263\321\213\320\267\321\201\321\202\320\260\320\275)" },
    { wxLANGUAGE_KIRUNDI,                                          "rn"             , "rn"                        , "rn_BI"        , 0x00, 0x04, wxLayout_LeftToRight, "Rundi","Ikirundi" },
    { wxLANGUAGE_KIRUNDI_BURUNDI,                                  "rn-BI"          , "rn_BI"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Rundi (Burundi)","Ikirundi (Uburundi)" },
    { wxLANGUAGE_KONKANI,                                          "kok"            , "kok"                       , "kok_IN"       , 0x57, 0x01, wxLayout_LeftToRight, "Konkani","\340\244\225\340\245\213\340\244\202\340\244\225\340\244\243\340\245\200" },
    { wxLANGUAGE_KONKANI_INDIA,                                    "kok-IN"         , "kok_IN"                    , ""             , 0x57, 0x01, wxLayout_LeftToRight, "Konkani (India)","\340\244\225\340\245\213\340\244\202\340\244\225\340\244\243\340\245\200 (\340\244\255\340\244\276\340\244\260\340\244\244)" },
    { wxLANGUAGE_KOREAN,                                           "ko"             , "ko"                        , "ko_KR"        , 0x12, 0x01, wxLayout_LeftToRight, "Korean","\355\225\234\352\265\255\354\226\264" },
    { wxLANGUAGE_KOREAN_KOREA,                                     "ko-KR"          , "ko_KR"                     , ""             , 0x12, 0x01, wxLayout_LeftToRight, "Korean (Korea)","\355\225\234\352\265\255\354\226\264(\353\214\200\355\225\234\353\257\274\352\265\255)" },
    { wxLANGUAGE_KOREAN_NORTH_KOREA,                               "ko-KP"          , "ko_KP"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Korean (North Korea)","\355\225\234\352\265\255\354\226\264 (\354\241\260\354\204\240\353\257\274\354\243\274\354\243\274\354\235\230\354\235\270\353\257\274\352\263\265\355\231\224\352\265\255)" },
    { wxLANGUAGE_KOYRABORO_SENNI,                                  "ses"            , "ses"                       , "ses_ML"       , 0x00, 0x04, wxLayout_LeftToRight, "Koyraboro Senni","Koyraboro senni" },
    { wxLANGUAGE_KOYRABORO_SENNI_MALI,                             "ses-ML"         , "ses_ML"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Koyraboro Senni (Mali)","Koyraboro senni (Maali)" },
    { wxLANGUAGE_KOYRA_CHIINI,                                     "khq"            , "khq"                       , "khq_ML"       , 0x00, 0x04, wxLayout_LeftToRight, "Koyra Chiini","Koyra ciini" },
    { wxLANGUAGE_KOYRA_CHIINI_MALI,                                "khq-ML"         , "khq_ML"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Koyra Chiini (Mali)","Koyra ciini (Maali)" },
    { wxLANGUAGE_KURDISH,                                          "ku-TR"          , "ku_TR"                     , ""             , 0   , 0   , wxLayout_LeftToRight, "Kurdish","Kurd\303\256" },
    { wxLANGUAGE_KURDISH_ARABIC_IRAN,                              "ku-Arab-IR"     , "ku_IR@arabic"              , ""             , 0x00, 0x04, wxLayout_RightToLeft, "Kurdish (Arabic, Iran)","\332\251\331\210\330\261\330\257\333\214 (\330\246\333\216\330\261\330\247\331\206)" },
    { wxLANGUAGE_KWASIO,                                           "nmg"            , "nmg"                       , "nmg_CM"       , 0x00, 0x04, wxLayout_LeftToRight, "Kwasio","Kwasio" },
    { wxLANGUAGE_KWASIO_CAMEROON,                                  "nmg-CM"         , "nmg_CM"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Kwasio (Cameroon)","Kwasio (Kamerun)" },
    { wxLANGUAGE_LAKOTA,                                           "lkt"            , "lkt"                       , "lkt_US"       , 0x00, 0x04, wxLayout_LeftToRight, "Lakota","Lak\310\237\303\263l\312\274iyapi" },
    { wxLANGUAGE_LAKOTA_US,                                        "lkt-US"         , "lkt_US"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Lakota (United States)","Lak\310\237\303\263l\312\274iyapi (M\303\255laha\305\213ska T\310\237am\303\241k\310\237o\304\215he)" },
    { wxLANGUAGE_LANGI,                                            "lag"            , "lag"                       , "lag_TZ"       , 0x00, 0x04, wxLayout_LeftToRight, "Langi","K\311\250laangi" },
    { wxLANGUAGE_LANGI_TANZANIA,                                   "lag-TZ"         , "lag_TZ"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Langi (Tanzania)","K\311\250laangi (Taansan\303\255a)" },
    { wxLANGUAGE_LAOTHIAN,                                         "lo"             , "lo"                        , "lo_LA"        , 0x54, 0x01, wxLayout_LeftToRight, "Lao","\340\272\245\340\272\262\340\272\247" },
    { wxLANGUAGE_LAOTHIAN_LAOS,                                    "lo-LA"          , "lo_LA"                     , ""             , 0x54, 0x01, wxLayout_LeftToRight, "Lao (Laos)","\340\272\245\340\272\262\340\272\247 (\340\272\245\340\272\262\340\272\247)" },
    { wxLANGUAGE_LATIN,                                            "la"             , "la"                        , "la_VA"        , 0x76, 0x01, wxLayout_LeftToRight, "Latin","Latina" },
    { wxLANGUAGE_LATIN_VATICAN_CITY,                               "la-VA"          , "la_VA"                     , ""             , 0x76, 0x01, wxLayout_LeftToRight, "Latin (Vatican City)","Latina (Civitas Vaticana)" },
    { wxLANGUAGE_LATIN_WORLD,                                      "la-001"         , "la_001"                    , ""             , 0x76, 0x01, wxLayout_LeftToRight, "Latin (World)","Latina (Mundus)" },
    { wxLANGUAGE_LATVIAN,                                          "lv"             , "lv"                        , "lv_LV"        , 0x26, 0x01, wxLayout_LeftToRight, "Latvian","latvie\305\241u" },
    { wxLANGUAGE_LATVIAN_LATVIA,                                   "lv-LV"          , "lv_LV"                     , ""             , 0x26, 0x01, wxLayout_LeftToRight, "Latvian (Latvia)","latvie\305\241u (Latvija)" },
    { wxLANGUAGE_LINGALA,                                          "ln"             , "ln"                        , "ln_CD"        , 0x00, 0x04, wxLayout_LeftToRight, "Lingala","ling\303\241la" },
    { wxLANGUAGE_LINGALA_ANGOLA,                                   "ln-AO"          , "ln_AO"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Lingala (Angola)","ling\303\241la (Ang\303\263la)" },
    { wxLANGUAGE_LINGALA_CENTRAL_AFRICAN_REPUBLIC,                 "ln-CF"          , "ln_CF"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Lingala (Central African Republic)","ling\303\241la (Repibiki ya Afr\303\255ka ya K\303\241ti)" },
    { wxLANGUAGE_LINGALA_CONGO,                                    "ln-CG"          , "ln_CG"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Lingala (Congo)","ling\303\241la (Kongo)" },
    { wxLANGUAGE_LINGALA_CONGO_DRC,                                "ln-CD"          , "ln_CD"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Lingala (Congo DRC)","ling\303\241la (Republ\303\255ki ya Kong\303\263 Demokrat\303\255ki)" },
    { wxLANGUAGE_LITHUANIAN,                                       "lt"             , "lt"                        , "lt_LT"        , 0x27, 0x01, wxLayout_LeftToRight, "Lithuanian","lietuvi\305\263" },
    { wxLANGUAGE_LITHUANIAN_LITHUANIA,                             "lt-LT"          , "lt_LT"                     , ""             , 0x27, 0x01, wxLayout_LeftToRight, "Lithuanian (Lithuania)","lietuvi\305\263 (Lietuva)" },
    { wxLANGUAGE_LOWER_SORBIAN,                                    "dsb"            , "dsb"                       , "dsb_DE"       , 0x2e, 0x02, wxLayout_LeftToRight, "Lower Sorbian","dolnoserb\305\241\304\207ina" },
    { wxLANGUAGE_LOWER_SORBIAN_GERMANY,                            "dsb-DE"         , "dsb_DE"                    , ""             , 0x2e, 0x02, wxLayout_LeftToRight, "Lower Sorbian (Germany)","dolnoserb\305\241\304\207ina (Nimska)" },
    { wxLANGUAGE_LOW_GERMAN,                                       "nds"            , "nds"                       , "nds_DE"       , 0x00, 0x04, wxLayout_LeftToRight, "Low German","Neddersass\342\200\231sch" },
    { wxLANGUAGE_LOW_GERMAN_GERMANY,                               "nds-DE"         , "nds_DE"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Low German (Germany)","Neddersass\342\200\231sch (D\303\274\303\274tschland)" },
    { wxLANGUAGE_LOW_GERMAN_NETHERLANDS,                           "nds-NL"         , "nds_NL"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Low German (Netherlands)","Neddersass\342\200\231sch (Nedderlannen)" },
    { wxLANGUAGE_LUBA_KATANGA,                                     "lu"             , "lu"                        , "lu_CD"        , 0x00, 0x04, wxLayout_LeftToRight, "Luba-Katanga","Tshiluba" },
    { wxLANGUAGE_LUBA_KATANGA_CONGO_DRC,                           "lu-CD"          , "lu_CD"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Luba-Katanga (Congo DRC)","Tshiluba (Ditunga wa Kongu)" },
    { wxLANGUAGE_LUO,                                              "luo"            , "luo"                       , "luo_KE"       , 0x00, 0x04, wxLayout_LeftToRight, "Luo","Dholuo" },
    { wxLANGUAGE_LUO_KENYA,                                        "luo-KE"         , "luo_KE"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Luo (Kenya)","Dholuo (Kenya)" },
    { wxLANGUAGE_LUXEMBOURGISH,                                    "lb"             , "lb"                        , "lb_LU"        , 0x6e, 0x01, wxLayout_LeftToRight, "Luxembourgish","L\303\253tzebuergesch" },
    { wxLANGUAGE_LUXEMBOURGISH_LUXEMBOURG,                         "lb-LU"          , "lb_LU"                     , ""             , 0x6e, 0x01, wxLayout_LeftToRight, "Luxembourgish (Luxembourg)","L\303\253tzebuergesch (L\303\253tzebuerg)" },
    { wxLANGUAGE_LUYIA,                                            "luy"            , "luy"                       , "luy_KE"       , 0x00, 0x04, wxLayout_LeftToRight, "Luyia","Luluhia" },
    { wxLANGUAGE_LUYIA_KENYA,                                      "luy-KE"         , "luy_KE"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Luyia (Kenya)","Luluhia (Kenya)" },
    { wxLANGUAGE_MACEDONIAN,                                       "mk"             , "mk"                        , "mk_MK"        , 0x2f, 0x01, wxLayout_LeftToRight, "Macedonian","\320\274\320\260\320\272\320\265\320\264\320\276\320\275\321\201\320\272\320\270" },
    { wxLANGUAGE_MACEDONIAN_NORTH_MACEDONIA,                       "mk-MK"          , "mk_MK"                     , ""             , 0x2f, 0x01, wxLayout_LeftToRight, "Macedonian (North Macedonia)","\320\274\320\260\320\272\320\265\320\264\320\276\320\275\321\201\320\272\320\270 (\320\241\320\265\320\262\320\265\321\200\320\275\320\260 \320\234\320\260\320\272\320\265\320\264\320\276\320\275\320\270\321\230\320\260)" },
    { wxLANGUAGE_MACHAME,                                          "jmc"            , "jmc"                       , "jmc_TZ"       , 0x00, 0x04, wxLayout_LeftToRight, "Machame","Kimachame" },
    { wxLANGUAGE_MACHAME_TANZANIA,                                 "jmc-TZ"         , "jmc_TZ"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Machame (Tanzania)","Kimachame (Tanzania)" },
    { wxLANGUAGE_MAITHILI,                                         "mai"            , "mai"                       , "mai_IN"       , 0x00, 0x04, wxLayout_LeftToRight, "Maithili","\340\244\256\340\245\210\340\244\245\340\244\277\340\244\262\340\245\200" },
    { wxLANGUAGE_MAITHILI_INDIA,                                   "mai-IN"         , "mai_IN"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Maithili (India)","\340\244\256\340\245\210\340\244\245\340\244\277\340\244\262\340\245\200 (\340\244\255\340\244\276\340\244\260\340\244\244)" },
    { wxLANGUAGE_MAKHUWA_MEETTO,                                   "mgh"            , "mgh"                       , "mgh_MZ"       , 0x00, 0x04, wxLayout_LeftToRight, "Makhuwa-Meetto","Makua" },
    { wxLANGUAGE_MAKHUWA_MEETTO_MOZAMBIQUE,                        "mgh-MZ"         , "mgh_MZ"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Makhuwa-Meetto (Mozambique)","Makua (Umozambiki)" },
    { wxLANGUAGE_MAKONDE,                                          "kde"            , "kde"                       , "kde_TZ"       , 0x00, 0x04, wxLayout_LeftToRight, "Makonde","Chimakonde" },
    { wxLANGUAGE_MAKONDE_TANZANIA,                                 "kde-TZ"         , "kde_TZ"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Makonde (Tanzania)","Chimakonde (Tanzania)" },
    { wxLANGUAGE_MALAGASY,                                         "mg"             , "mg"                        , "mg_MG"        , 0x00, 0x04, wxLayout_LeftToRight, "Malagasy","Malagasy" },
    { wxLANGUAGE_MALAGASY_MADAGASCAR,                              "mg-MG"          , "mg_MG"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Malagasy (Madagascar)","Malagasy (Madagasikara)" },
    { wxLANGUAGE_MALAY,                                            "ms"             , "ms"                        , "ms_MY"        , 0x3e, 0x01, wxLayout_LeftToRight, "Malay","Melayu" },
    { wxLANGUAGE_MALAYALAM,                                        "ml"             , "ml"                        , "ml_IN"        , 0x4c, 0x01, wxLayout_LeftToRight, "Malayalam","\340\264\256\340\264\262\340\264\257\340\264\276\340\264\263\340\264\202" },
    { wxLANGUAGE_MALAYALAM_INDIA,                                  "ml-IN"          , "ml_IN"                     , ""             , 0x4c, 0x01, wxLayout_LeftToRight, "Malayalam (India)","\340\264\256\340\264\262\340\264\257\340\264\276\340\264\263\340\264\202 (\340\264\207\340\264\250\340\265\215\340\264\244\340\265\215\340\264\257)" },
    { wxLANGUAGE_MALAY_BRUNEI,                                     "ms-BN"          , "ms_BN"                     , ""             , 0x3e, 0x02, wxLayout_LeftToRight, "Malay (Brunei)","Melayu (Brunei)" },
    { wxLANGUAGE_MALAY_INDONESIA,                                  "ms-ID"          , "ms_ID"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Malay (Indonesia)","Melayu (Indonesia)" },
    { wxLANGUAGE_MALAY_MALAYSIA,                                   "ms-MY"          , "ms_MY"                     , ""             , 0x3e, 0x01, wxLayout_LeftToRight, "Malay (Malaysia)","Melayu (Malaysia)" },
    { wxLANGUAGE_MALAY_SINGAPORE,                                  "ms-SG"          , "ms_SG"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Malay (Singapore)","Melayu (Singapura)" },
    { wxLANGUAGE_MALTESE,                                          "mt"             , "mt"                        , "mt_MT"        , 0x3a, 0x01, wxLayout_LeftToRight, "Maltese","Malti" },
    { wxLANGUAGE_MALTESE_MALTA,                                    "mt-MT"          , "mt_MT"                     , ""             , 0x3a, 0x01, wxLayout_LeftToRight, "Maltese (Malta)","Malti (Malta)" },
    { wxLANGUAGE_MANIPURI,                                         "mni"            , "mni"                       , "mni_IN"       , 0x58, 0x01, wxLayout_LeftToRight, "Manipuri","\340\246\256\340\247\210\340\246\244\340\247\210\340\246\262\340\247\213\340\246\250\340\247\215" },
    { wxLANGUAGE_MANIPURI_BENGALI,                                 "mni-Beng"       , "mni@bengali"               , ""             , 0x58, 0x01, wxLayout_LeftToRight, "Manipuri (Bangla)","\340\246\256\340\247\210\340\246\244\340\247\210\340\246\262\340\247\213\340\246\250\340\247\215" },
    { wxLANGUAGE_MANIPURI_INDIA,                                   "mni-IN"         , "mni_IN"                    , ""             , 0x58, 0x01, wxLayout_LeftToRight, "Manipuri (Bangla, India)","\340\246\256\340\247\210\340\246\244\340\247\210\340\246\262\340\247\213\340\246\250\340\247\215 (\340\246\207\340\246\250\340\247\215\340\246\246\340\246\277\340\246\257\340\246\274\340\246\276)" },
    { wxLANGUAGE_MANX,                                             "gv"             , "gv"                        , "gv_IM"        , 0x00, 0x04, wxLayout_LeftToRight, "Manx","Gaelg" },
    { wxLANGUAGE_MANX_ISLE_OF_MAN,                                 "gv-IM"          , "gv_IM"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Manx (Isle of Man)","Gaelg (Ellan Vannin)" },
    { wxLANGUAGE_MAORI,                                            "mi"             , "mi"                        , "mi_NZ"        , 0x81, 0x01, wxLayout_LeftToRight, "Maori","te reo M\304\201ori" },
    { wxLANGUAGE_MAORI_NEW_ZEALAND,                                "mi-NZ"          , "mi_NZ"                     , ""             , 0x81, 0x01, wxLayout_LeftToRight, "Maori (New Zealand)","te reo M\304\201ori (Aotearoa)" },
    { wxLANGUAGE_MAPUCHE,                                          "arn"            , "arn"                       , "arn_CL"       , 0x7a, 0x01, wxLayout_LeftToRight, "Mapuche","Mapudungun" },
    { wxLANGUAGE_MAPUCHE_CHILE,                                    "arn-CL"         , "arn_CL"                    , ""             , 0x7a, 0x01, wxLayout_LeftToRight, "Mapuche (Chile)","Mapudungun (Chile)" },
    { wxLANGUAGE_MARATHI,                                          "mr"             , "mr"                        , "mr_IN"        , 0x4e, 0x01, wxLayout_LeftToRight, "Marathi","\340\244\256\340\244\260\340\244\276\340\244\240\340\245\200" },
    { wxLANGUAGE_MARATHI_INDIA,                                    "mr-IN"          , "mr_IN"                     , ""             , 0x4e, 0x01, wxLayout_LeftToRight, "Marathi (India)","\340\244\256\340\244\260\340\244\276\340\244\240\340\245\200 (\340\244\255\340\244\276\340\244\260\340\244\244)" },
    { wxLANGUAGE_MASAI,                                            "mas"            , "mas"                       , "mas_KE"       , 0x00, 0x04, wxLayout_LeftToRight, "Masai","Maa" },
    { wxLANGUAGE_MASAI_KENYA,                                      "mas-KE"         , "mas_KE"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Masai (Kenya)","Maa (Kenya)" },
    { wxLANGUAGE_MASAI_TANZANIA,                                   "mas-TZ"         , "mas_TZ"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Masai (Tanzania)","Maa (Tansania)" },
    { wxLANGUAGE_MAZANDERANI,                                      "mzn"            , "mzn"                       , "mzn_IR"       , 0x00, 0x04, wxLayout_RightToLeft, "Mazanderani","\331\205\330\247\330\262\330\261\331\210\331\206\333\214" },
    { wxLANGUAGE_MAZANDERANI_IRAN,                                 "mzn-IR"         , "mzn_IR"                    , ""             , 0x00, 0x04, wxLayout_RightToLeft, "Mazanderani (Iran)","\331\205\330\247\330\262\330\261\331\210\331\206\333\214 (\330\247\333\214\330\261\330\247\331\206)" },
    { wxLANGUAGE_MERU,                                             "mer"            , "mer"                       , "mer_KE"       , 0x00, 0x04, wxLayout_LeftToRight, "Meru","K\304\251m\304\251r\305\251" },
    { wxLANGUAGE_MERU_KENYA,                                       "mer-KE"         , "mer_KE"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Meru (Kenya)","K\304\251m\304\251r\305\251 (Kenya)" },
    { wxLANGUAGE_META,                                             "mgo"            , "mgo"                       , "mgo_CM"       , 0x00, 0x04, wxLayout_LeftToRight, "Meta\312\274","meta\312\274" },
    { wxLANGUAGE_META_CAMEROON,                                    "mgo-CM"         , "mgo_CM"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Meta\312\274 (Cameroon)","meta\312\274 (Kamalun)" },
    { wxLANGUAGE_MOHAWK,                                           "moh"            , "moh"                       , "moh_CA"       , 0x7c, 0x01, wxLayout_LeftToRight, "Mohawk","Kanien\312\274k\303\251ha" },
    { wxLANGUAGE_MOHAWK_CANADA,                                    "moh-CA"         , "moh_CA"                    , ""             , 0x7c, 0x01, wxLayout_LeftToRight, "Mohawk (Canada)","Kanien\312\274k\303\251ha (Canada)" },
    { wxLANGUAGE_MOLDAVIAN,                                        "mo"             , "mo"                        , ""             , 0   , 0   , wxLayout_LeftToRight, "Moldavian","\320\273\320\270\320\274\320\261\320\260 \320\274\320\276\320\273\320\264\320\276\320\262\320\265\320\275\321\217\321\201\320\272\321\215" },
    { wxLANGUAGE_MONGOLIAN,                                        "mn"             , "mn"                        , "mn_MN"        , 0x50, 0x01, wxLayout_LeftToRight, "Mongolian","\320\234\320\276\320\275\320\263\320\276\320\273\302\240\321\205\321\215\320\273" },
    { wxLANGUAGE_MONGOLIAN_CYRILLIC,                               "mn-Cyrl"        , "mn@cyrillic"               , ""             , 0x50, 0x01, wxLayout_LeftToRight, "Mongolian","\320\234\320\276\320\275\320\263\320\276\320\273\302\240\321\205\321\215\320\273 (\320\232\320\270\321\200\320\270\320\273\320\273 \322\257\321\201\321\215\320\263)" },
    { wxLANGUAGE_MONGOLIAN_MONGOLIA,                               "mn-MN"          , "mn_MN"                     , ""             , 0x50, 0x01, wxLayout_LeftToRight, "Mongolian (Mongolia)","\320\274\320\276\320\275\320\263\320\276\320\273 (\320\234\320\276\320\275\320\263\320\276\320\273)" },
    { wxLANGUAGE_MONGOLIAN_TRADITIONAL,                            "mn-Mong"        , "mn@mongolian"              , ""             , 0x50, 0x02, wxLayout_LeftToRight, "Mongolian (Traditional Mongolian)","\341\240\256\341\240\243\341\240\251\341\240\255\341\240\243\341\240\244\341\240\257 \341\240\254\341\240\241\341\240\257\341\240\241 (\341\240\256\341\240\243\341\240\251\341\240\255\341\240\243\341\240\244\341\240\257 \341\240\254\341\240\241\341\240\257\341\240\241)" },
    { wxLANGUAGE_MONGOLIAN_TRADITIONAL_CHINA,                      "mn-Mong-CN"     , "mn_CN@mongolian"           , ""             , 0x50, 0x02, wxLayout_LeftToRight, "Mongolian (Traditional Mongolian, China)","\341\240\256\341\240\243\341\240\251\341\240\255\341\240\243\341\240\244\341\240\257 \341\240\254\341\240\241\341\240\257\341\240\241 (\341\240\252\341\240\246\341\240\255\341\240\246\341\240\263\341\240\241 \341\240\250\341\240\240\341\240\242\341\240\267\341\240\240\341\240\256\341\240\263\341\240\240\341\240\254\341\240\244 \341\240\263\341\240\244\341\240\256\341\240\263\341\240\240\341\240\263\341\240\244 \341\240\240\341\240\267\341\240\240\341\240\263 \341\240\243\341\240\257\341\240\243\341\240\260)" },
    { wxLANGUAGE_MONGOLIAN_TRADITIONAL_MONGOLIA,                   "mn-Mong-MN"     , "mn_MN@mongolian"           , ""             , 0x50, 0x03, wxLayout_LeftToRight, "Mongolian (Traditional Mongolian, Mongolia)","\341\240\256\341\240\243\341\240\251\341\240\255\341\240\243\341\240\257 \341\240\254\341\240\241\341\240\257\341\240\241 (\341\240\256\341\240\243\341\240\251\341\240\255\341\240\243\341\240\257 \341\240\243\341\240\257\341\240\243\341\240\260)" },
    { wxLANGUAGE_MORISYEN,                                         "mfe"            , "mfe"                       , "mfe_MU"       , 0x00, 0x04, wxLayout_LeftToRight, "Morisyen","kreol morisien" },
    { wxLANGUAGE_MORISYEN_MAURITIUS,                               "mfe-MU"         , "mfe_MU"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Morisyen (Mauritius)","kreol morisien (Moris)" },
    { wxLANGUAGE_MUNDANG,                                          "mua"            , "mua"                       , "mua_CM"       , 0x00, 0x04, wxLayout_LeftToRight, "Mundang","MUNDA\305\212" },
    { wxLANGUAGE_MUNDANG_CAMEROON,                                 "mua-CM"         , "mua_CM"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Mundang (Cameroon)","MUNDA\305\212 (kameru\305\213)" },
    { wxLANGUAGE_NAMA,                                             "naq"            , "naq"                       , "naq_NA"       , 0x00, 0x04, wxLayout_LeftToRight, "Nama","Khoekhoegowab" },
    { wxLANGUAGE_NAMA_NAMIBIA,                                     "naq-NA"         , "naq_NA"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Nama (Namibia)","Khoekhoegowab (Namibiab)" },
    { wxLANGUAGE_NAURU,                                            "na"             , "na"                        , ""             , 0   , 0   , wxLayout_LeftToRight, "Nauru","Nauru" },
    { wxLANGUAGE_NEPALI,                                           "ne"             , "ne"                        , "ne_NP"        , 0x61, 0x01, wxLayout_LeftToRight, "Nepali","\340\244\250\340\245\207\340\244\252\340\244\276\340\244\262\340\245\200" },
    { wxLANGUAGE_NEPALI_INDIA,                                     "ne-IN"          , "ne_IN"                     , ""             , 0x61, 0x02, wxLayout_LeftToRight, "Nepali (India)","\340\244\250\340\245\207\340\244\252\340\244\276\340\244\262\340\245\200 (\340\244\255\340\244\276\340\244\260\340\244\244)" },
    { wxLANGUAGE_NEPALI_NEPAL,                                     "ne-NP"          , "ne_NP"                     , ""             , 0x61, 0x01, wxLayout_LeftToRight, "Nepali (Nepal)","\340\244\250\340\245\207\340\244\252\340\244\276\340\244\262\340\245\200 (\340\244\250\340\245\207\340\244\252\340\244\276\340\244\262)" },
    { wxLANGUAGE_NGIEMBOON,                                        "nnh"            , "nnh"                       , "nnh_CM"       , 0x00, 0x04, wxLayout_LeftToRight, "Ngiemboon","Shw\303\263\305\213\303\262 ngiemb\311\224\311\224n" },
    { wxLANGUAGE_NGIEMBOON_CAMEROON,                               "nnh-CM"         , "nnh_CM"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Ngiemboon (Cameroon)","Shw\303\263\305\213\303\262 ngiemb\311\224\311\224n (K\303\240mal\303\273m)" },
    { wxLANGUAGE_NGOMBA,                                           "jgo"            , "jgo"                       , "jgo_CM"       , 0x00, 0x04, wxLayout_LeftToRight, "Ngomba","Nda\352\236\214a" },
    { wxLANGUAGE_NGOMBA_CAMEROON,                                  "jgo-CM"         , "jgo_CM"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Ngomba (Cameroon)","Nda\352\236\214a (Kam\311\233l\303\273n)" },
    { wxLANGUAGE_NIGERIAN_PIDGIN,                                  "pcm"            , "pcm"                       , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Nigerian Pidgin","Naij\303\255ri\303\241 P\303\255jin" },
    { wxLANGUAGE_NIGERIAN_PIDGIN_LATIN,                            "pcm-Latn"       , "pcm@latin"                 , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Nigerian Pidgin (Latin)","Naij\303\255ri\303\241 P\303\255jin (L\303\241tin)" },
    { wxLANGUAGE_NIGERIAN_PIDGIN_LATIN_NIGERIA,                    "pcm-Latn-NG"    , "pcm_NG@latin"              , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Nigerian Pidgin (Latin, Nigeria)","Naij\303\255ri\303\241 P\303\255jin (Naij\303\255ria)" },
    { wxLANGUAGE_NKO,                                              "nqo"            , "nqo"                       , "nqo_GN"       , 0x00, 0x04, wxLayout_RightToLeft, "N'ko","\337\222\337\236\337\217" },
    { wxLANGUAGE_NKO_GUINEA,                                       "nqo-GN"         , "nqo_GN"                    , ""             , 0x00, 0x04, wxLayout_RightToLeft, "N'ko (Guinea)","\337\222\337\236\337\217 (\337\226\337\214\337\254\337\243\337\215\337\254 \337\236\337\212\337\262\337\223\337\215\337\262)" },
    { wxLANGUAGE_NORTHERN_LURI,                                    "lrc"            , "lrc"                       , "lrc_IR"       , 0x00, 0x04, wxLayout_RightToLeft, "Northern Luri","\331\204\333\212\330\261\333\214 \330\264\331\210\331\205\330\247\331\204\333\214" },
    { wxLANGUAGE_NORTHERN_LURI_IRAN,                               "lrc-IR"         , "lrc_IR"                    , ""             , 0x00, 0x04, wxLayout_RightToLeft, "Northern Luri (Iran)","\331\204\333\212\330\261\333\214 \330\264\331\210\331\205\330\247\331\204\333\214 (Iran)" },
    { wxLANGUAGE_NORTHERN_LURI_IRAQ,                               "lrc-IQ"         , "lrc_IQ"                    , ""             , 0x00, 0x04, wxLayout_RightToLeft, "Northern Luri (Iraq)","\331\204\333\212\330\261\333\214 \330\264\331\210\331\205\330\247\331\204\333\214 (Iraq)" },
    { wxLANGUAGE_NORTH_NDEBELE,                                    "nd"             , "nd"                        , "nd_ZW"        , 0x00, 0x04, wxLayout_LeftToRight, "North Ndebele","isiNdebele" },
    { wxLANGUAGE_NORTH_NDEBELE_ZIMBABWE,                           "nd-ZW"          , "nd_ZW"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "North Ndebele (Zimbabwe)","isiNdebele (Zimbabwe)" },
    { wxLANGUAGE_NORWEGIAN,                                        "no"             , "no"                        , ""             , 0x14, 0x01, wxLayout_LeftToRight, "Norwegian","norsk" },
    { wxLANGUAGE_NORWEGIAN_BOKMAL,                                 "nb"             , "nb"                        , "nb_NO"        , 0x14, 0x01, wxLayout_LeftToRight, "Norwegian Bokm\303\245l","norsk bokm\303\245l" },
    { wxLANGUAGE_NORWEGIAN_BOKMAL_NORWAY,                          "nb-NO"          , "nb_NO"                     , ""             , 0x14, 0x01, wxLayout_LeftToRight, "Norwegian Bokm\303\245l (Norway)","norsk bokm\303\245l (Norge)" },
    { wxLANGUAGE_NORWEGIAN_BOKMAL_SVALBARD_AND_JAN_MAYEN,          "nb-SJ"          , "nb_SJ"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Norwegian Bokm\303\245l (Svalbard and Jan Mayen)","norsk bokm\303\245l (Svalbard og Jan Mayen)" },
    { wxLANGUAGE_NORWEGIAN_NYNORSK,                                "nn"             , "nn"                        , "nn_NO"        , 0x14, 0x02, wxLayout_LeftToRight, "Norwegian Nynorsk","norsk nynorsk" },
    { wxLANGUAGE_NORWEGIAN_NYNORSK_NORWAY,                         "nn-NO"          , "nn_NO"                     , ""             , 0x14, 0x02, wxLayout_LeftToRight, "Norwegian Nynorsk (Norway)","norsk nynorsk (Noreg)" },
    { wxLANGUAGE_NUER,                                             "nus"            , "nus"                       , "nus_SS"       , 0x00, 0x04, wxLayout_LeftToRight, "Nuer","Thok Nath" },
    { wxLANGUAGE_NUER_SOUTH_SUDAN,                                 "nus-SS"         , "nus_SS"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Nuer (South Sudan)","Thok Nath (South Sudan)" },
    { wxLANGUAGE_NYANKOLE,                                         "nyn"            , "nyn"                       , "nyn_UG"       , 0x00, 0x04, wxLayout_LeftToRight, "Nyankole","Runyankore" },
    { wxLANGUAGE_NYANKOLE_UGANDA,                                  "nyn-UG"         , "nyn_UG"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Nyankole (Uganda)","Runyankore (Uganda)" },
    { wxLANGUAGE_OCCITAN,                                          "oc"             , "oc"                        , "oc_FR"        , 0x82, 0x01, wxLayout_LeftToRight, "Occitan","occitan" },
    { wxLANGUAGE_OCCITAN_FRANCE,                                   "oc-FR"          , "oc_FR"                     , ""             , 0x82, 0x01, wxLayout_LeftToRight, "Occitan (France)","occitan (Fran\303\247a)" },
    { wxLANGUAGE_ODIA,                                             "or"             , "or"                        , "or_IN"        , 0x48, 0x01, wxLayout_LeftToRight, "Odia","\340\254\223\340\254\241\340\254\274\340\254\277\340\254\206" },
    { wxLANGUAGE_ODIA_INDIA,                                       "or-IN"          , "or_IN"                     , ""             , 0x48, 0x01, wxLayout_LeftToRight, "Odia (India)","\340\254\223\340\254\241\340\254\274\340\254\277\340\254\206 (\340\254\255\340\254\276\340\254\260\340\254\244)" },
    { wxLANGUAGE_OROMO,                                            "om"             , "om"                        , "om_ET"        , 0x72, 0x01, wxLayout_LeftToRight, "Oromo","Oromoo" },
    { wxLANGUAGE_OROMO_ETHIOPIA,                                   "om-ET"          , "om_ET"                     , ""             , 0x72, 0x01, wxLayout_LeftToRight, "Oromo (Ethiopia)","Oromoo (Itoophiyaa)" },
    { wxLANGUAGE_OROMO_KENYA,                                      "om-KE"          , "om_KE"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Oromo (Kenya)","Oromoo (Keeniyaa)" },
    { wxLANGUAGE_OSSETIC,                                          "os"             , "os"                        , "os_GE"        , 0x00, 0x04, wxLayout_LeftToRight, "Ossetic","\320\270\321\200\320\276\320\275" },
    { wxLANGUAGE_OSSETIC_GEORGIA,                                  "os-GE"          , "os_GE"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Ossetic (Georgia)","\320\270\321\200\320\276\320\275 (\320\223\321\203\321\213\321\200\320\264\320\267\321\213\321\201\321\202\320\276\320\275)" },
    { wxLANGUAGE_OSSETIC_RUSSIA,                                   "os-RU"          , "os_RU"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Ossetic (Russia)","\320\270\321\200\320\276\320\275 (\320\243\323\225\321\200\323\225\321\201\320\265)" },
    { wxLANGUAGE_PAPIAMENTO,                                       "pap"            , "pap"                       , ""             , 0x79, 0x01, wxLayout_LeftToRight, "Papiamento","Papiamentu" },
    { wxLANGUAGE_PAPIAMENTO_CARIBBEAN,                             "pap-029"        , "pap_029"                   , ""             , 0x79, 0x01, wxLayout_LeftToRight, "Papiamento (Caribbean)","Papiamentu (Caribbean)" },
    { wxLANGUAGE_PASHTO,                                           "ps"             , "ps"                        , "ps_AF"        , 0x63, 0x01, wxLayout_RightToLeft, "Pashto","\331\276\332\232\330\252\331\210" },
    { wxLANGUAGE_PASHTO_AFGHANISTAN,                               "ps-AF"          , "ps_AF"                     , ""             , 0x63, 0x01, wxLayout_RightToLeft, "Pashto (Afghanistan)","\331\276\332\232\330\252\331\210 (\330\247\331\201\330\272\330\247\331\206\330\263\330\252\330\247\331\206)" },
    { wxLANGUAGE_PASHTO_PAKISTAN,                                  "ps-PK"          , "ps_PK"                     , ""             , 0x00, 0x04, wxLayout_RightToLeft, "Pashto (Pakistan)","\331\276\332\232\330\252\331\210 (\331\276\330\247\332\251\330\263\330\252\330\247\331\206)" },
    { wxLANGUAGE_PERSIAN,                                          "fa"             , "fa"                        , "fa_IR"        , 0x29, 0x01, wxLayout_RightToLeft, "Persian","\331\201\330\247\330\261\330\263\333\214" },
    { wxLANGUAGE_PERSIAN_AFGHANISTAN,                              "fa-AF"          , "fa_AF"                     , ""             , 0x8c, 0x01, wxLayout_RightToLeft, "Persian (Afghanistan)","\331\201\330\247\330\261\330\263\333\214 (\330\247\331\201\330\272\330\247\331\206\330\263\330\252\330\247\331\206)" },
    { wxLANGUAGE_PERSIAN_IRAN,                                     "fa-IR"          , "fa_IR"                     , ""             , 0x29, 0x01, wxLayout_RightToLeft, "Persian (Iran)","\331\201\330\247\330\261\330\263\333\214 (\330\247\333\214\330\261\330\247\331\206)" },
    { wxLANGUAGE_POLISH,                                           "pl"             , "pl"                        , "pl_PL"        , 0x15, 0x01, wxLayout_LeftToRight, "Polish","polski" },
    { wxLANGUAGE_POLISH_POLAND,                                    "pl-PL"          , "pl_PL"                     , ""             , 0x15, 0x01, wxLayout_LeftToRight, "Polish (Poland)","polski (Polska)" },
    { wxLANGUAGE_PORTUGUESE,                                       "pt"             , "pt"                        , "pt_PT"        , 0x16, 0x02, wxLayout_LeftToRight, "Portuguese","portugu\303\252s" },
    { wxLANGUAGE_PORTUGUESE_ANGOLA,                                "pt-AO"          , "pt_AO"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Portuguese (Angola)","portugu\303\252s (Angola)" },
    { wxLANGUAGE_PORTUGUESE_BRAZILIAN,                             "pt-BR"          , "pt_BR"                     , ""             , 0x16, 0x01, wxLayout_LeftToRight, "Portuguese (Brazil)","portugu\303\252s (Brasil)" },
    { wxLANGUAGE_PORTUGUESE_CABO_VERDE,                            "pt-CV"          , "pt_CV"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Portuguese (Cabo Verde)","portugu\303\252s (Cabo Verde)" },
    { wxLANGUAGE_PORTUGUESE_EQUATORIAL_GUINEA,                     "pt-GQ"          , "pt_GQ"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Portuguese (Equatorial Guinea)","portugu\303\252s (Guin\303\251 Equatorial)" },
    { wxLANGUAGE_PORTUGUESE_GUINEA_BISSAU,                         "pt-GW"          , "pt_GW"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Portuguese (Guinea-Bissau)","portugu\303\252s (Guin\303\251-Bissau)" },
    { wxLANGUAGE_PORTUGUESE_LUXEMBOURG,                            "pt-LU"          , "pt_LU"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Portuguese (Luxembourg)","portugu\303\252s (Luxemburgo)" },
    { wxLANGUAGE_PORTUGUESE_MACAO_SAR,                             "pt-MO"          , "pt_MO"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Portuguese (Macao SAR)","portugu\303\252s (RAE de Macau)" },
    { wxLANGUAGE_PORTUGUESE_MOZAMBIQUE,                            "pt-MZ"          , "pt_MZ"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Portuguese (Mozambique)","portugu\303\252s (Mo\303\247ambique)" },
    { wxLANGUAGE_PORTUGUESE_PORTUGAL,                              "pt-PT"          , "pt_PT"                     , ""             , 0x16, 0x02, wxLayout_LeftToRight, "Portuguese (Portugal)","portugu\303\252s (Portugal)" },
    { wxLANGUAGE_PORTUGUESE_SAO_TOME_AND_PRINCIPE,                 "pt-ST"          , "pt_ST"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Portuguese (S\303\243o Tom\303\251 and Pr\303\255ncipe)","portugu\303\252s (S\303\243o Tom\303\251 e Pr\303\255ncipe)" },
    { wxLANGUAGE_PORTUGUESE_SWITZERLAND,                           "pt-CH"          , "pt_CH"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Portuguese (Switzerland)","portugu\303\252s (Su\303\255\303\247a)" },
    { wxLANGUAGE_PORTUGUESE_TIMOR_LESTE,                           "pt-TL"          , "pt_TL"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Portuguese (Timor-Leste)","portugu\303\252s (Timor-Leste)" },
    { wxLANGUAGE_PRUSSIAN,                                         "prg"            , "prg"                       , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Prussian","pr\305\253siskan" },
    { wxLANGUAGE_PRUSSIAN_WORLD,                                   "prg-001"        , "prg_001"                   , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Prussian (World)","pr\305\253siskan (sw\304\253tai)" },
    { wxLANGUAGE_PUNJABI,                                          "pa"             , "pa"                        , "pa_IN"        , 0x46, 0x01, wxLayout_LeftToRight, "Punjabi","\340\250\252\340\251\260\340\250\234\340\250\276\340\250\254\340\251\200" },
    { wxLANGUAGE_PUNJABI_ARABIC,                                   "pa-Arab"        , "pa@arabic"                 , ""             , 0x46, 0x02, wxLayout_RightToLeft, "Punjabi","\331\276\331\206\330\254\330\247\330\250\333\214" },
    { wxLANGUAGE_PUNJABI_GURMUKHI,                                 "pa-Guru"        , "pa@gurmukhi"               , ""             , 0x46, 0x01, wxLayout_LeftToRight, "Punjabi","\340\250\252\340\251\260\340\250\234\340\250\276\340\250\254\340\251\200" },
    { wxLANGUAGE_PUNJABI_INDIA,                                    "pa-IN"          , "pa_IN"                     , ""             , 0x46, 0x01, wxLayout_LeftToRight, "Punjabi (India)","\340\250\252\340\251\260\340\250\234\340\250\276\340\250\254\340\251\200 (\340\250\255\340\250\276\340\250\260\340\250\244)" },
    { wxLANGUAGE_PUNJABI_PAKISTAN,                                 "pa-Arab-PK"     , "pa_PK@arabic"              , ""             , 0x46, 0x02, wxLayout_RightToLeft, "Punjabi (Pakistan)","\331\276\331\206\330\254\330\247\330\250\333\214 (\331\276\330\247\332\251\330\263\330\252\330\247\331\206)" },
    { wxLANGUAGE_QUECHUA,                                          "quz"            , "quz"                       , "quz_BO"       , 0x6b, 0x01, wxLayout_LeftToRight, "Quechua","Runasimi" },
    { wxLANGUAGE_QUECHUA_BOLIVIA,                                  "quz-BO"         , "quz_BO"                    , ""             , 0x6b, 0x01, wxLayout_LeftToRight, "Quechua (Bolivia)","Runasimi (Bolivia)" },
    { wxLANGUAGE_QUECHUA_ECUADOR,                                  "quz-EC"         , "quz_EC"                    , ""             , 0x6b, 0x02, wxLayout_LeftToRight, "Quechua (Ecuador)","Runasimi (Ecuador)" },
    { wxLANGUAGE_QUECHUA_MACRO,                                    "qu"             , "qu"                        , ""             , 0   , 0   , wxLayout_LeftToRight, "Quechua","Qhichwa" },
    { wxLANGUAGE_QUECHUA_PERU,                                     "quz-PE"         , "quz_PE"                    , ""             , 0x6b, 0x03, wxLayout_LeftToRight, "Quechua (Peru)","Runasimi (Per\303\272)" },
    { wxLANGUAGE_RHAETO_ROMANCE,                                   "rm"             , "rm"                        , "rm_CH"        , 0x17, 0x01, wxLayout_LeftToRight, "Romansh","rumantsch" },
    { wxLANGUAGE_RHAETO_ROMANCE_SWITZERLAND,                       "rm-CH"          , "rm_CH"                     , ""             , 0x17, 0x01, wxLayout_LeftToRight, "Romansh (Switzerland)","rumantsch (Svizra)" },
    { wxLANGUAGE_ROMANIAN,                                         "ro"             , "ro"                        , "ro_RO"        , 0x18, 0x01, wxLayout_LeftToRight, "Romanian","rom\303\242n\304\203" },
    { wxLANGUAGE_ROMANIAN_MOLDOVA,                                 "ro-MD"          , "ro_MD"                     , ""             , 0x18, 0x02, wxLayout_LeftToRight, "Romanian (Moldova)","rom\303\242n\304\203 (Republica Moldova)" },
    { wxLANGUAGE_ROMANIAN_ROMANIA,                                 "ro-RO"          , "ro_RO"                     , ""             , 0x18, 0x01, wxLayout_LeftToRight, "Romanian (Romania)","rom\303\242n\304\203 (Rom\303\242nia)" },
    { wxLANGUAGE_ROMBO,                                            "rof"            , "rof"                       , "rof_TZ"       , 0x00, 0x04, wxLayout_LeftToRight, "Rombo","Kihorombo" },
    { wxLANGUAGE_ROMBO_TANZANIA,                                   "rof-TZ"         , "rof_TZ"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Rombo (Tanzania)","Kihorombo (Tanzania)" },
    { wxLANGUAGE_RUSSIAN,                                          "ru"             , "ru"                        , "ru_RU"        , 0x19, 0x01, wxLayout_LeftToRight, "Russian","\321\200\321\203\321\201\321\201\320\272\320\270\320\271" },
    { wxLANGUAGE_RUSSIAN_BELARUS,                                  "ru-BY"          , "ru_BY"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Russian (Belarus)","\321\200\321\203\321\201\321\201\320\272\320\270\320\271 (\320\221\320\265\320\273\320\260\321\200\321\203\321\201\321\214)" },
    { wxLANGUAGE_RUSSIAN_KAZAKHSTAN,                               "ru-KZ"          , "ru_KZ"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Russian (Kazakhstan)","\321\200\321\203\321\201\321\201\320\272\320\270\320\271 (\320\232\320\260\320\267\320\260\321\205\321\201\321\202\320\260\320\275)" },
    { wxLANGUAGE_RUSSIAN_KYRGYZSTAN,                               "ru-KG"          , "ru_KG"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Russian (Kyrgyzstan)","\321\200\321\203\321\201\321\201\320\272\320\270\320\271 (\320\232\320\270\321\200\320\263\320\270\320\267\320\270\321\217)" },
    { wxLANGUAGE_RUSSIAN_MOLDOVA,                                  "ru-MD"          , "ru_MD"                     , ""             , 0x19, 0x02, wxLayout_LeftToRight, "Russian (Moldova)","\321\200\321\203\321\201\321\201\320\272\320\270\320\271 (\320\234\320\276\320\273\320\264\320\276\320\262\320\260)" },
    { wxLANGUAGE_RUSSIAN_RUSSIA,                                   "ru-RU"          , "ru_RU"                     , ""             , 0x19, 0x01, wxLayout_LeftToRight, "Russian (Russia)","\321\200\321\203\321\201\321\201\320\272\320\270\320\271 (\320\240\320\276\321\201\321\201\320\270\321\217)" },
    { wxLANGUAGE_RUSSIAN_UKRAINE,                                  "ru-UA"          , "ru_UA"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Russian (Ukraine)","\321\200\321\203\321\201\321\201\320\272\320\270\320\271 (\320\243\320\272\321\200\320\260\320\270\320\275\320\260)" },
    { wxLANGUAGE_RWA,                                              "rwk"            , "rwk"                       , "rwk_TZ"       , 0x00, 0x04, wxLayout_LeftToRight, "Rwa","Kiruwa" },
    { wxLANGUAGE_RWA_TANZANIA,                                     "rwk-TZ"         , "rwk_TZ"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Rwa (Tanzania)","Kiruwa (Tanzania)" },
    { wxLANGUAGE_SAHO,                                             "ssy"            , "ssy"                       , "ssy_ER"       , 0x00, 0x04, wxLayout_LeftToRight, "Saho","Saho" },
    { wxLANGUAGE_SAHO_ERITREA,                                     "ssy-ER"         , "ssy_ER"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Saho (Eritrea)","Saho (Eretria)" },
    { wxLANGUAGE_SAKHA,                                            "sah"            , "sah"                       , "sah_RU"       , 0x85, 0x01, wxLayout_LeftToRight, "Sakha","\321\201\320\260\321\205\320\260 \321\202\321\213\320\273\320\260" },
    { wxLANGUAGE_SAKHA_RUSSIA,                                     "sah-RU"         , "sah_RU"                    , ""             , 0x85, 0x01, wxLayout_LeftToRight, "Sakha (Russia)","\321\201\320\260\321\205\320\260 \321\202\321\213\320\273\320\260 (\320\220\321\200\320\260\321\201\321\201\321\213\321\213\320\271\320\260)" },
    { wxLANGUAGE_SAMBURU,                                          "saq"            , "saq"                       , "saq_KE"       , 0x00, 0x04, wxLayout_LeftToRight, "Samburu","Kisampur" },
    { wxLANGUAGE_SAMBURU_KENYA,                                    "saq-KE"         , "saq_KE"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Samburu (Kenya)","Kisampur (Kenya)" },
    { wxLANGUAGE_SAMI,                                             "se"             , "se"                        , "se_NO"        , 0x3b, 0x01, wxLayout_LeftToRight, "Northern Sami","davvis\303\241megiella" },
    { wxLANGUAGE_SAMI_FINLAND,                                     "se-FI"          , "se_FI"                     , ""             , 0x3b, 0x03, wxLayout_LeftToRight, "Sami, Northern (Finland)","davvis\303\241megiella (Suopma)" },
    { wxLANGUAGE_SAMI_INARI,                                       "smn"            , "smn"                       , "smn_FI"       , 0x3b, 0x09, wxLayout_LeftToRight, "Sami (Inari)","anar\303\242\305\241kiel\303\242" },
    { wxLANGUAGE_SAMI_INARI_FINLAND,                               "smn-FI"         , "smn_FI"                    , ""             , 0x3b, 0x09, wxLayout_LeftToRight, "Sami, Inari (Finland)","anar\303\242\305\241kiel\303\242 (Suom\303\242)" },
    { wxLANGUAGE_SAMI_LULE,                                        "smj"            , "smj"                       , "smj_SE"       , 0x3b, 0x05, wxLayout_LeftToRight, "Sami (Lule)","julevus\303\241megiella" },
    { wxLANGUAGE_SAMI_LULE_NORWAY,                                 "smj-NO"         , "smj_NO"                    , ""             , 0x3b, 0x04, wxLayout_LeftToRight, "Sami, Lule (Norway)","julevus\303\241megiella (Vuodna)" },
    { wxLANGUAGE_SAMI_LULE_SWEDEN,                                 "smj-SE"         , "smj_SE"                    , ""             , 0x3b, 0x05, wxLayout_LeftToRight, "Sami, Lule (Sweden)","julevus\303\241megiella (Svierik)" },
    { wxLANGUAGE_SAMI_NORWAY,                                      "se-NO"          , "se_NO"                     , ""             , 0x3b, 0x01, wxLayout_LeftToRight, "Sami, Northern (Norway)","davvis\303\241megiella (Norga)" },
    { wxLANGUAGE_SAMI_SKOLT,                                       "sms"            , "sms"                       , "sms_FI"       , 0x3b, 0x08, wxLayout_LeftToRight, "Sami (Skolt)","s\303\244\303\244\302\264m\307\251i\303\265ll" },
    { wxLANGUAGE_SAMI_SKOLT_FINLAND,                               "sms-FI"         , "sms_FI"                    , ""             , 0x3b, 0x08, wxLayout_LeftToRight, "Sami, Skolt (Finland)","s\303\244\303\244\302\264m\307\251i\303\265ll (L\303\244\303\244\302\264ddj\303\242nnam)" },
    { wxLANGUAGE_SAMI_SOUTHERN,                                    "sma"            , "sma"                       , "sma_SE"       , 0x3b, 0x07, wxLayout_LeftToRight, "Sami (Southern)","\303\245arjelsaemieng\303\257ele" },
    { wxLANGUAGE_SAMI_SOUTHERN_NORWAY,                             "sma-NO"         , "sma_NO"                    , ""             , 0x3b, 0x06, wxLayout_LeftToRight, "Sami, Southern (Norway)","\303\245arjelsaemieng\303\257ele (N\303\266\303\266rje)" },
    { wxLANGUAGE_SAMI_SOUTHERN_SWEDEN,                             "sma-SE"         , "sma_SE"                    , ""             , 0x3b, 0x07, wxLayout_LeftToRight, "Sami, Southern (Sweden)","\303\245arjelsaemieng\303\257ele (Sveerje)" },
    { wxLANGUAGE_SAMI_SWEDEN,                                      "se-SE"          , "se_SE"                     , ""             , 0x3b, 0x02, wxLayout_LeftToRight, "Sami, Northern (Sweden)","davvis\303\241megiella (Ruo\305\247\305\247a)" },
    { wxLANGUAGE_SAMOAN,                                           "sm"             , "sm"                        , ""             , 0   , 0   , wxLayout_LeftToRight, "Samoan","Samoa" },
    { wxLANGUAGE_SANGHO,                                           "sg"             , "sg"                        , "sg_CF"        , 0x00, 0x04, wxLayout_LeftToRight, "Sango","S\303\244ng\303\266" },
    { wxLANGUAGE_SANGHO_CENTRAL_AFRICAN_REPUBLIC,                  "sg-CF"          , "sg_CF"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Sango (Central African Republic)","S\303\244ng\303\266 (K\303\266d\303\266r\303\266s\303\252se t\303\256 B\303\252afr\303\256ka)" },
    { wxLANGUAGE_SANGU,                                            "sbp"            , "sbp"                       , "sbp_TZ"       , 0x00, 0x04, wxLayout_LeftToRight, "Sangu","Ishisangu" },
    { wxLANGUAGE_SANGU_TANZANIA,                                   "sbp-TZ"         , "sbp_TZ"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Sangu (Tanzania)","Ishisangu (Tansaniya)" },
    { wxLANGUAGE_SANSKRIT,                                         "sa"             , "sa"                        , "sa_IN"        , 0x4f, 0x01, wxLayout_LeftToRight, "Sanskrit","\340\244\270\340\244\202\340\244\270\340\245\215\340\244\225\340\245\203\340\244\244 \340\244\255\340\244\276\340\244\267\340\244\276" },
    { wxLANGUAGE_SANSKRIT_INDIA,                                   "sa-IN"          , "sa_IN"                     , ""             , 0x4f, 0x01, wxLayout_LeftToRight, "Sanskrit (India)","\340\244\270\340\244\202\340\244\270\340\245\215\340\244\225\340\245\203\340\244\244 \340\244\255\340\244\276\340\244\267\340\244\276 (\340\244\255\340\244\276\340\244\260\340\244\244\340\244\203)" },
    { wxLANGUAGE_SANTALI,                                          "sat"            , "sat"                       , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Santali","\341\261\245\341\261\237\341\261\261\341\261\233\341\261\237\341\261\262\341\261\244" },
    { wxLANGUAGE_SANTALI_OL_CHIKI,                                 "sat-Olck"       , "sat@ol_chiki"              , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Santali (Ol Chiki)","\341\261\245\341\261\237\341\261\261\341\261\233\341\261\237\341\261\262\341\261\244 (\341\261\232\341\261\236 \341\261\252\341\261\244\341\261\240\341\261\244)" },
    { wxLANGUAGE_SANTALI_OL_CHIKI_INDIA,                           "sat-Olck-IN"    , "sat_IN@ol_chiki"           , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Santali (Ol Chiki, India)","\341\261\245\341\261\237\341\261\261\341\261\233\341\261\237\341\261\262\341\261\244 (\341\261\244\341\261\261\341\261\260\341\261\244\341\261\255\341\261\237)" },
    { wxLANGUAGE_SCOTS_GAELIC,                                     "gd"             , "gd"                        , "gd_GB"        , 0x91, 0x01, wxLayout_LeftToRight, "Scottish Gaelic","G\303\240idhlig" },
    { wxLANGUAGE_SCOTS_GAELIC_UK,                                  "gd-GB"          , "gd_GB"                     , ""             , 0x91, 0x01, wxLayout_LeftToRight, "Scottish Gaelic (United Kingdom)","G\303\240idhlig (An R\303\254oghachd Aonaichte)" },
    { wxLANGUAGE_SENA,                                             "seh"            , "seh"                       , "seh_MZ"       , 0x00, 0x04, wxLayout_LeftToRight, "Sena","sena" },
    { wxLANGUAGE_SENA_MOZAMBIQUE,                                  "seh-MZ"         , "seh_MZ"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Sena (Mozambique)","sena (Mo\303\247ambique)" },
    { wxLANGUAGE_SERBIAN,                                          "sr"             , "sr"                        , "sr_RS"        , 0x1a, 0x01, wxLayout_LeftToRight, "Serbian","srpski" },
    { wxLANGUAGE_SERBIAN_CYRILLIC,                                 "sr-Cyrl"        , "sr@cyrillic"               , ""             , 0x1a, 0x0a, wxLayout_LeftToRight, "Serbian (Cyrillic)","\321\201\321\200\320\277\321\201\320\272\320\270 (\320\213\320\270\321\200\320\270\320\273\320\270\321\206\320\260)" },
    { wxLANGUAGE_SERBIAN_CYRILLIC_BOSNIA_AND_HERZEGOVINA,          "sr-Cyrl-BA"     , "sr_BA@cyrillic"            , ""             , 0x1a, 0x07, wxLayout_LeftToRight, "Serbian (Cyrillic, Bosnia and Herzegovina)","\321\201\321\200\320\277\321\201\320\272\320\270 (\320\221\320\276\321\201\320\275\320\260 \320\270 \320\245\320\265\321\200\321\206\320\265\320\263\320\276\320\262\320\270\320\275\320\260)" },
    { wxLANGUAGE_SERBIAN_CYRILLIC_KOSOVO,                          "sr-Cyrl-XK"     , "sr_XK@cyrillic"            , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Serbian (Cyrillic, Kosovo)","\321\201\321\200\320\277\321\201\320\272\320\270 (\320\232\320\276\321\201\320\276\320\262\320\276)" },
    { wxLANGUAGE_SERBIAN_CYRILLIC_MONTENEGRO,                      "sr-Cyrl-ME"     , "sr_ME@cyrillic"            , ""             , 0x1a, 0x0c, wxLayout_LeftToRight, "Serbian (Cyrillic, Montenegro)","\321\201\321\200\320\277\321\201\320\272\320\270 (\320\246\321\200\320\275\320\260 \320\223\320\276\321\200\320\260)" },
    { wxLANGUAGE_SERBIAN_CYRILLIC_SERBIA,                          "sr-Cyrl-RS"     , "sr_RS@cyrillic"            , ""             , 0x1a, 0x0a, wxLayout_LeftToRight, "Serbian (Cyrillic, Serbia)","\321\201\321\200\320\277\321\201\320\272\320\270 (\320\241\321\200\320\261\320\270\321\230\320\260)" },
    { wxLANGUAGE_SERBIAN_CYRILLIC_YU,                              "sr-Cyrl-YU"     , "sr_YU@cyrillic"            , ""             , 0x1a, 0x03, wxLayout_LeftToRight, "Serbian (Cyrillic)","\321\201\321\200\320\277\321\201\320\272\320\270 (\320\241\321\200\320\261\320\270\321\230\320\260)" },
    { wxLANGUAGE_SERBIAN_LATIN,                                    "sr-Latn"        , "sr@latin"                  , ""             , 0x1a, 0x09, wxLayout_LeftToRight, "Serbian (Latin)","srpski (latinica)" },
    { wxLANGUAGE_SERBIAN_LATIN_BOSNIA_AND_HERZEGOVINA,             "sr-Latn-BA"     , "sr_BA@latin"               , ""             , 0x1a, 0x06, wxLayout_LeftToRight, "Serbian (Latin, Bosnia and Herzegovina)","srpski (Bosna i Hercegovina)" },
    { wxLANGUAGE_SERBIAN_LATIN_KOSOVO,                             "sr-Latn-XK"     , "sr_XK@latin"               , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Serbian (Latin, Kosovo)","srpski (Kosovo)" },
    { wxLANGUAGE_SERBIAN_LATIN_MONTENEGRO,                         "sr-Latn-ME"     , "sr_ME@latin"               , ""             , 0x1a, 0x0b, wxLayout_LeftToRight, "Serbian (Latin, Montenegro)","srpski (Crna Gora)" },
    { wxLANGUAGE_SERBIAN_LATIN_SERBIA,                             "sr-Latn-RS"     , "sr_RS@latin"               , ""             , 0x1a, 0x09, wxLayout_LeftToRight, "Serbian (Latin, Serbia)","srpski (Srbija)" },
    { wxLANGUAGE_SERBIAN_LATIN_YU,                                 "sr-Latn-YU"     , "sr_YU@latin"               , ""             , 0x1a, 0x02, wxLayout_LeftToRight, "Serbian (Latin)","srpski (latinica)" },
    { wxLANGUAGE_SERBIAN_SERBIA,                                   "sr-RS"          , "sr_RS"                     , ""             , 0x1a, 0x01, wxLayout_LeftToRight, "Serbian (Serbia)","srpski (Srbija)" },
    { wxLANGUAGE_SERBIAN_YU,                                       "sr-YU"          , "sr_YU"                     , ""             , 0x1a, 0x01, wxLayout_LeftToRight, "Serbian","srpski" },
    { wxLANGUAGE_SERBO_CROATIAN,                                   "sh"             , "sh"                        , ""             , 0   , 0   , wxLayout_LeftToRight, "Serbo-Croatian","srpskohrvatski" },
    { wxLANGUAGE_SESOTHO,                                          "st"             , "st"                        , "st_ZA"        , 0x30, 0x01, wxLayout_LeftToRight, "Sesotho","Sesotho" },
    { wxLANGUAGE_SESOTHO_LESOTHO,                                  "st-LS"          , "st_LS"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Sesotho (Lesotho)","Sesotho (Lesotho)" },
    { wxLANGUAGE_SESOTHO_SA_LEBOA,                                 "nso"            , "nso"                       , "nso_ZA"       , 0x6c, 0x01, wxLayout_LeftToRight, "Sesotho sa Leboa","Sesotho sa Leboa" },
    { wxLANGUAGE_SESOTHO_SA_LEBOA_SOUTH_AFRICA,                    "nso-ZA"         , "nso_ZA"                    , ""             , 0x6c, 0x01, wxLayout_LeftToRight, "Sesotho sa Leboa (South Africa)","Sesotho sa Leboa (Afrika Borwa)" },
    { wxLANGUAGE_SESOTHO_SOUTH_AFRICA,                             "st-ZA"          , "st_ZA"                     , ""             , 0x30, 0x01, wxLayout_LeftToRight, "Sesotho (South Africa)","Sesotho (South Africa)" },
    { wxLANGUAGE_SETSWANA,                                         "tn"             , "tn"                        , "tn_ZA"        , 0x32, 0x01, wxLayout_LeftToRight, "Setswana","Setswana" },
    { wxLANGUAGE_SETSWANA_BOTSWANA,                                "tn-BW"          , "tn_BW"                     , ""             , 0x32, 0x02, wxLayout_LeftToRight, "Setswana (Botswana)","Setswana (Botswana)" },
    { wxLANGUAGE_SETSWANA_SOUTH_AFRICA,                            "tn-ZA"          , "tn_ZA"                     , ""             , 0x32, 0x01, wxLayout_LeftToRight, "Setswana (South Africa)","Setswana (Aforika Borwa)" },
    { wxLANGUAGE_SHAMBALA,                                         "ksb"            , "ksb"                       , "ksb_TZ"       , 0x00, 0x04, wxLayout_LeftToRight, "Shambala","Kishambaa" },
    { wxLANGUAGE_SHAMBALA_TANZANIA,                                "ksb-TZ"         , "ksb_TZ"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Shambala (Tanzania)","Kishambaa (Tanzania)" },
    { wxLANGUAGE_SHONA,                                            "sn"             , "sn"                        , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Shona","chiShona" },
    { wxLANGUAGE_SHONA_LATIN,                                      "sn-Latn"        , "sn@latin"                  , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Shona (Latin)","chiShona (Latin)" },
    { wxLANGUAGE_SHONA_LATIN_ZIMBABWE,                             "sn-Latn-ZW"     , "sn_ZW@latin"               , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Shona (Latin, Zimbabwe)","chiShona (Zimbabwe)" },
    { wxLANGUAGE_SINDHI,                                           "sd"             , "sd"                        , ""             , 0x59, 0x02, wxLayout_RightToLeft, "Sindhi","\330\263\331\206\332\214\331\212" },
    { wxLANGUAGE_SINDHI_ARABIC,                                    "sd-Arab"        , "sd@arabic"                 , ""             , 0x59, 0x02, wxLayout_RightToLeft, "Sindhi","\330\263\331\206\332\214\331\212" },
    { wxLANGUAGE_SINDHI_DEVANAGARI,                                "sd-Deva"        , "sd@devanagari"             , ""             , 0x59, 0x01, wxLayout_LeftToRight, "Sindhi (Devanagari)","\340\244\270\340\244\277\340\244\250\340\245\215\340\244\247\340\245\200" },
    { wxLANGUAGE_SINDHI_DEVANAGARI_INDIA,                          "sd-Deva-IN"     , "sd_IN@devanagari"          , ""             , 0x59, 0x01, wxLayout_LeftToRight, "Sindhi (Devanagari, India)","\340\244\270\340\244\277\340\244\250\340\245\215\340\244\247\340\245\200 (\340\244\255\340\244\276\340\244\260\340\244\244)" },
    { wxLANGUAGE_SINDHI_PAKISTAN,                                  "sd-Arab-PK"     , "sd_PK@arabic"              , ""             , 0x59, 0x02, wxLayout_RightToLeft, "Sindhi (Pakistan)","\330\263\331\206\332\214\331\212 (\331\276\330\247\332\251\330\263\330\252\330\247\331\206)" },
    { wxLANGUAGE_SINHALESE,                                        "si"             , "si"                        , "si_LK"        , 0x5b, 0x01, wxLayout_LeftToRight, "Sinhala","\340\267\203\340\267\222\340\266\202\340\267\204\340\266\275" },
    { wxLANGUAGE_SINHALESE_SRI_LANKA,                              "si-LK"          , "si_LK"                     , ""             , 0x5b, 0x01, wxLayout_LeftToRight, "Sinhala (Sri Lanka)","\340\267\203\340\267\222\340\266\202\340\267\204\340\266\275 (\340\267\201\340\267\212\342\200\215\340\266\273\340\267\223 \340\266\275\340\266\202\340\266\232\340\267\217\340\267\200)" },
    { wxLANGUAGE_SISWATI,                                          "ss"             , "ss"                        , "ss_ZA"        , 0x00, 0x04, wxLayout_LeftToRight, "siSwati","Siswati" },
    { wxLANGUAGE_SISWATI_ESWATINI,                                 "ss-SZ"          , "ss_SZ"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "siSwati (Eswatini)","siSwati (eSwatini)" },
    { wxLANGUAGE_SISWATI_SOUTH_AFRICA,                             "ss-ZA"          , "ss_ZA"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "siSwati (South Africa)","siSwati (South Africa)" },
    { wxLANGUAGE_SLOVAK,                                           "sk"             , "sk"                        , "sk_SK"        , 0x1b, 0x01, wxLayout_LeftToRight, "Slovak","sloven\304\215ina" },
    { wxLANGUAGE_SLOVAK_SLOVAKIA,                                  "sk-SK"          , "sk_SK"                     , ""             , 0x1b, 0x01, wxLayout_LeftToRight, "Slovak (Slovakia)","sloven\304\215ina (Slovensko)" },
    { wxLANGUAGE_SLOVENIAN,                                        "sl"             , "sl"                        , "sl_SI"        , 0x24, 0x01, wxLayout_LeftToRight, "Slovenian","sloven\305\241\304\215ina" },
    { wxLANGUAGE_SLOVENIAN_SLOVENIA,                               "sl-SI"          , "sl_SI"                     , ""             , 0x24, 0x01, wxLayout_LeftToRight, "Slovenian (Slovenia)","sloven\305\241\304\215ina (Slovenija)" },
    { wxLANGUAGE_SOGA,                                             "xog"            , "xog"                       , "xog_UG"       , 0x00, 0x04, wxLayout_LeftToRight, "Soga","Olusoga" },
    { wxLANGUAGE_SOGA_UGANDA,                                      "xog-UG"         , "xog_UG"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Soga (Uganda)","Olusoga (Yuganda)" },
    { wxLANGUAGE_SOMALI,                                           "so"             , "so"                        , "so_SO"        , 0x77, 0x01, wxLayout_LeftToRight, "Somali","Soomaali" },
    { wxLANGUAGE_SOMALI_DJIBOUTI,                                  "so-DJ"          , "so_DJ"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Somali (Djibouti)","Soomaali (Jabuuti)" },
    { wxLANGUAGE_SOMALI_ETHIOPIA,                                  "so-ET"          , "so_ET"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Somali (Ethiopia)","Soomaali (Itoobiya)" },
    { wxLANGUAGE_SOMALI_KENYA,                                     "so-KE"          , "so_KE"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Somali (Kenya)","Soomaali (Kenya)" },
    { wxLANGUAGE_SOMALI_SOMALIA,                                   "so-SO"          , "so_SO"                     , ""             , 0x77, 0x01, wxLayout_LeftToRight, "Somali (Somalia)","Soomaali (Soomaaliya)" },
    { wxLANGUAGE_SOUTH_NDEBELE,                                    "nr"             , "nr"                        , "nr_ZA"        , 0x00, 0x04, wxLayout_LeftToRight, "South Ndebele","isiNdebele" },
    { wxLANGUAGE_SOUTH_NDEBELE_SOUTH_AFRICA,                       "nr-ZA"          , "nr_ZA"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "South Ndebele (South Africa)","isiNdebele (South Africa)" },
    { wxLANGUAGE_SPANISH,                                          "es"             , "es"                        , "es_ES"        , 0x0a, 0x03, wxLayout_LeftToRight, "Spanish","espa\303\261ol" },
    { wxLANGUAGE_SPANISH_ARGENTINA,                                "es-AR"          , "es_AR"                     , ""             , 0x0a, 0x0b, wxLayout_LeftToRight, "Spanish (Argentina)","espa\303\261ol (Argentina)" },
    { wxLANGUAGE_SPANISH_BELIZE,                                   "es-BZ"          , "es_BZ"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Spanish (Belize)","espa\303\261ol (Belice)" },
    { wxLANGUAGE_SPANISH_BOLIVIA,                                  "es-BO"          , "es_BO"                     , ""             , 0x0a, 0x10, wxLayout_LeftToRight, "Spanish (Bolivia)","espa\303\261ol (Bolivia)" },
    { wxLANGUAGE_SPANISH_BRAZIL,                                   "es-BR"          , "es_BR"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Spanish (Brazil)","espa\303\261ol (Brasil)" },
    { wxLANGUAGE_SPANISH_CHILE,                                    "es-CL"          , "es_CL"                     , ""             , 0x0a, 0x0d, wxLayout_LeftToRight, "Spanish (Chile)","espa\303\261ol (Chile)" },
    { wxLANGUAGE_SPANISH_COLOMBIA,                                 "es-CO"          , "es_CO"                     , ""             , 0x0a, 0x09, wxLayout_LeftToRight, "Spanish (Colombia)","espa\303\261ol (Colombia)" },
    { wxLANGUAGE_SPANISH_COSTA_RICA,                               "es-CR"          , "es_CR"                     , ""             , 0x0a, 0x05, wxLayout_LeftToRight, "Spanish (Costa Rica)","espa\303\261ol (Costa Rica)" },
    { wxLANGUAGE_SPANISH_CUBA,                                     "es-CU"          , "es_CU"                     , ""             , 0x0a, 0x17, wxLayout_LeftToRight, "Spanish (Cuba)","espa\303\261ol (Cuba)" },
    { wxLANGUAGE_SPANISH_DOMINICAN_REPUBLIC,                       "es-DO"          , "es_DO"                     , ""             , 0x0a, 0x07, wxLayout_LeftToRight, "Spanish (Dominican Republic)","espa\303\261ol (Rep\303\272blica Dominicana)" },
    { wxLANGUAGE_SPANISH_ECUADOR,                                  "es-EC"          , "es_EC"                     , ""             , 0x0a, 0x0c, wxLayout_LeftToRight, "Spanish (Ecuador)","espa\303\261ol (Ecuador)" },
    { wxLANGUAGE_SPANISH_EL_SALVADOR,                              "es-SV"          , "es_SV"                     , ""             , 0x0a, 0x11, wxLayout_LeftToRight, "Spanish (El Salvador)","espa\303\261ol (El Salvador)" },
    { wxLANGUAGE_SPANISH_EQUATORIAL_GUINEA,                        "es-GQ"          , "es_GQ"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Spanish (Equatorial Guinea)","espa\303\261ol (Guinea Ecuatorial)" },
    { wxLANGUAGE_SPANISH_GUATEMALA,                                "es-GT"          , "es_GT"                     , ""             , 0x0a, 0x04, wxLayout_LeftToRight, "Spanish (Guatemala)","espa\303\261ol (Guatemala)" },
    { wxLANGUAGE_SPANISH_HONDURAS,                                 "es-HN"          , "es_HN"                     , ""             , 0x0a, 0x12, wxLayout_LeftToRight, "Spanish (Honduras)","espa\303\261ol (Honduras)" },
    { wxLANGUAGE_SPANISH_LATIN_AMERICA,                            "es-419"         , "es_419"                    , ""             , 0x0a, 0x16, wxLayout_LeftToRight, "Spanish (Latin America)","espa\303\261ol (Latinoam\303\251rica)" },
    { wxLANGUAGE_SPANISH_MEXICAN,                                  "es-MX"          , "es_MX"                     , ""             , 0x0a, 0x02, wxLayout_LeftToRight, "Spanish (Mexico)","espa\303\261ol (M\303\251xico)" },
    { wxLANGUAGE_SPANISH_NICARAGUA,                                "es-NI"          , "es_NI"                     , ""             , 0x0a, 0x13, wxLayout_LeftToRight, "Spanish (Nicaragua)","espa\303\261ol (Nicaragua)" },
    { wxLANGUAGE_SPANISH_PANAMA,                                   "es-PA"          , "es_PA"                     , ""             , 0x0a, 0x06, wxLayout_LeftToRight, "Spanish (Panama)","espa\303\261ol (Panam\303\241)" },
    { wxLANGUAGE_SPANISH_PARAGUAY,                                 "es-PY"          , "es_PY"                     , ""             , 0x0a, 0x0f, wxLayout_LeftToRight, "Spanish (Paraguay)","espa\303\261ol (Paraguay)" },
    { wxLANGUAGE_SPANISH_PERU,                                     "es-PE"          , "es_PE"                     , ""             , 0x0a, 0x0a, wxLayout_LeftToRight, "Spanish (Peru)","espa\303\261ol (Per\303\272)" },
    { wxLANGUAGE_SPANISH_PHILIPPINES,                              "es-PH"          , "es_PH"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Spanish (Philippines)","espa\303\261ol (Filipinas)" },
    { wxLANGUAGE_SPANISH_PUERTO_RICO,                              "es-PR"          , "es_PR"                     , ""             , 0x0a, 0x14, wxLayout_LeftToRight, "Spanish (Puerto Rico)","espa\303\261ol (Puerto Rico)" },
    { wxLANGUAGE_SPANISH_SPAIN,                                    "es-ES"          , "es_ES"                     , ""             , 0x0a, 0x03, wxLayout_LeftToRight, "Spanish (Spain, International Sort)","espa\303\261ol (Espa\303\261a, alfabetizaci\303\263n internacional)" },
    { wxLANGUAGE_SPANISH_URUGUAY,                                  "es-UY"          , "es_UY"                     , ""             , 0x0a, 0x0e, wxLayout_LeftToRight, "Spanish (Uruguay)","espa\303\261ol (Uruguay)" },
    { wxLANGUAGE_SPANISH_US,                                       "es-US"          , "es_US"                     , ""             , 0x0a, 0x15, wxLayout_LeftToRight, "Spanish (United States)","espa\303\261ol (Estados Unidos)" },
    { wxLANGUAGE_SPANISH_VENEZUELA,                                "es-VE"          , "es_VE"                     , ""             , 0x0a, 0x08, wxLayout_LeftToRight, "Spanish (Venezuela)","espa\303\261ol (Venezuela)" },
    { wxLANGUAGE_STANDARD_MOROCCAN_TAMAZIGHT,                      "zgh"            , "zgh"                       , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Standard Moroccan Tamazight","\342\265\234\342\264\260\342\265\216\342\264\260\342\265\243\342\265\211\342\265\226\342\265\234" },
    { wxLANGUAGE_STANDARD_MOROCCAN_TAMAZIGHT_TIFINAGH,             "zgh-Tfng"       , "zgh@tifinagh"              , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Standard Moroccan Tamazight (Tifinagh)","\342\265\234\342\264\260\342\265\216\342\264\260\342\265\243\342\265\211\342\265\226\342\265\234 (Tifinagh)" },
    { wxLANGUAGE_STANDARD_MOROCCAN_TAMAZIGHT_TIFINAGH_MOROCCO,     "zgh-Tfng-MA"    , "zgh_MA@tifinagh"           , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Standard Moroccan Tamazight (Tifinagh, Morocco)","\342\265\234\342\264\260\342\265\216\342\264\260\342\265\243\342\265\211\342\265\226\342\265\234 (\342\265\215\342\265\216\342\265\226\342\265\224\342\265\211\342\264\261)" },
    { wxLANGUAGE_SUNDANESE,                                        "su"             , "su"                        , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Sundanese","Basa Sunda" },
    { wxLANGUAGE_SUNDANESE_LATIN,                                  "su-Latn"        , "su@latin"                  , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Sundanese (Latin)","Basa Sunda (Latin)" },
    { wxLANGUAGE_SUNDANESE_LATIN_INDONESIA,                        "su-Latn-ID"     , "su_ID@latin"               , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Sundanese (Latin, Indonesia)","Basa Sunda (Indonesia)" },
    { wxLANGUAGE_SWAHILI,                                          "sw"             , "sw"                        , "sw_KE"        , 0x41, 0x01, wxLayout_LeftToRight, "Kiswahili","Kiswahili" },
    { wxLANGUAGE_SWAHILI_CONGO_DRC,                                "sw-CD"          , "sw_CD"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Kiswahili (Congo DRC)","Kiswahili (Jamhuri ya Kidemokrasia ya Kongo)" },
    { wxLANGUAGE_SWAHILI_KENYA,                                    "sw-KE"          , "sw_KE"                     , ""             , 0x41, 0x01, wxLayout_LeftToRight, "Kiswahili (Kenya)","Kiswahili (Kenya)" },
    { wxLANGUAGE_SWAHILI_TANZANIA,                                 "sw-TZ"          , "sw_TZ"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Kiswahili (Tanzania)","Kiswahili (Tanzania)" },
    { wxLANGUAGE_SWAHILI_UGANDA,                                   "sw-UG"          , "sw_UG"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Kiswahili (Uganda)","Kiswahili (Uganda)" },
    { wxLANGUAGE_SWEDISH,                                          "sv"             , "sv"                        , "sv_SE"        , 0x1d, 0x01, wxLayout_LeftToRight, "Swedish","svenska" },
    { wxLANGUAGE_SWEDISH_ALAND_ISLANDS,                            "sv-AX"          , "sv_AX"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Swedish (\303\205land Islands)","svenska (\303\205land)" },
    { wxLANGUAGE_SWEDISH_FINLAND,                                  "sv-FI"          , "sv_FI"                     , ""             , 0x1d, 0x02, wxLayout_LeftToRight, "Swedish (Finland)","svenska (Finland)" },
    { wxLANGUAGE_SWEDISH_SWEDEN,                                   "sv-SE"          , "sv_SE"                     , ""             , 0x1d, 0x01, wxLayout_LeftToRight, "Swedish (Sweden)","svenska (Sverige)" },
    { wxLANGUAGE_SWISS_GERMAN,                                     "gsw"            , "gsw"                       , "gsw_CH"       , 0x00, 0x04, wxLayout_LeftToRight, "Swiss German","Schwiizert\303\274\303\274tsch" },
    { wxLANGUAGE_SWISS_GERMAN_LIECHTENSTEIN,                       "gsw-LI"         , "gsw_LI"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Swiss German (Liechtenstein)","Schwiizert\303\274\303\274tsch (Li\303\244chtescht\303\244i)" },
    { wxLANGUAGE_SWISS_GERMAN_SWITZERLAND,                         "gsw-CH"         , "gsw_CH"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Swiss German (Switzerland)","Schwiizert\303\274\303\274tsch (Schwiiz)" },
    { wxLANGUAGE_SYRIAC,                                           "syr"            , "syr"                       , "syr_SY"       , 0x5a, 0x01, wxLayout_RightToLeft, "Syriac","\334\243\334\230\334\252\334\235\334\235\334\220" },
    { wxLANGUAGE_SYRIAC_SYRIA,                                     "syr-SY"         , "syr_SY"                    , ""             , 0x5a, 0x01, wxLayout_RightToLeft, "Syriac (Syria)","\334\243\334\230\334\252\334\235\334\235\334\220 (\334\243\334\230\334\252\334\235\334\220)" },
    { wxLANGUAGE_TACHELHIT,                                        "shi"            , "shi"                       , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Tachelhit","\342\265\234\342\264\260\342\265\233\342\265\215\342\265\203\342\265\211\342\265\234" },
    { wxLANGUAGE_TACHELHIT_LATIN,                                  "shi-Latn"       , "shi@latin"                 , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Tachelhit (Latin)","Tashel\341\270\245iyt (Latin)" },
    { wxLANGUAGE_TACHELHIT_LATIN_MOROCCO,                          "shi-Latn-MA"    , "shi_MA@latin"              , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Tachelhit (Latin, Morocco)","Tashel\341\270\245iyt (lm\311\243rib)" },
    { wxLANGUAGE_TACHELHIT_TIFINAGH,                               "shi-Tfng"       , "shi@tifinagh"              , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Tachelhit (Tifinagh)","\342\265\234\342\264\260\342\265\233\342\265\215\342\265\203\342\265\211\342\265\234 (Tifinagh)" },
    { wxLANGUAGE_TACHELHIT_TIFINAGH_MOROCCO,                       "shi-Tfng-MA"    , "shi_MA@tifinagh"           , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Tachelhit (Tifinagh, Morocco)","\342\265\234\342\264\260\342\265\233\342\265\215\342\265\203\342\265\211\342\265\234 (\342\265\215\342\265\216\342\265\226\342\265\224\342\265\211\342\264\261)" },
    { wxLANGUAGE_TAGALOG,                                          "tl"             , "tl"                        , "tl_PH"        , 0   , 0   , wxLayout_LeftToRight, "Tagalog","Tagalog" },
    { wxLANGUAGE_TAGALOG_PHILIPPINES,                              "tl-PH"          , "tl_PH"                     , ""             , 0   , 0   , wxLayout_LeftToRight, "Tagalog (Philippines)","Tagalog (Pilipinas)" },
    { wxLANGUAGE_TAITA,                                            "dav"            , "dav"                       , "dav_KE"       , 0x00, 0x04, wxLayout_LeftToRight, "Taita","Kitaita" },
    { wxLANGUAGE_TAITA_KENYA,                                      "dav-KE"         , "dav_KE"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Taita (Kenya)","Kitaita (Kenya)" },
    { wxLANGUAGE_TAJIK,                                            "tg"             , "tg"                        , ""             , 0x28, 0x01, wxLayout_LeftToRight, "Tajik","\320\242\320\276\322\267\320\270\320\272\323\243" },
    { wxLANGUAGE_TAJIK_CYRILLIC,                                   "tg-Cyrl"        , "tg@cyrillic"               , ""             , 0x28, 0x01, wxLayout_LeftToRight, "Tajik (Cyrillic)","\320\242\320\276\322\267\320\270\320\272\323\243 (\320\232\320\270\321\200\320\270\320\273\320\273\320\270\320\272\323\243)" },
    { wxLANGUAGE_TAJIK_CYRILLIC_TAJIKISTAN,                        "tg-Cyrl-TJ"     , "tg_TJ@cyrillic"            , ""             , 0x28, 0x01, wxLayout_LeftToRight, "Tajik (Cyrillic, Tajikistan)","\321\202\320\276\322\267\320\270\320\272\323\243 (\320\242\320\276\322\267\320\270\320\272\320\270\321\201\321\202\320\276\320\275)" },
    { wxLANGUAGE_TAMIL,                                            "ta"             , "ta"                        , "ta_IN"        , 0x49, 0x01, wxLayout_LeftToRight, "Tamil","\340\256\244\340\256\256\340\256\277\340\256\264\340\257\215" },
    { wxLANGUAGE_TAMIL_INDIA,                                      "ta-IN"          , "ta_IN"                     , ""             , 0x49, 0x01, wxLayout_LeftToRight, "Tamil (India)","\340\256\244\340\256\256\340\256\277\340\256\264\340\257\215 (\340\256\207\340\256\250\340\257\215\340\256\244\340\256\277\340\256\257\340\256\276)" },
    { wxLANGUAGE_TAMIL_MALAYSIA,                                   "ta-MY"          , "ta_MY"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Tamil (Malaysia)","\340\256\244\340\256\256\340\256\277\340\256\264\340\257\215 (\340\256\256\340\256\262\340\257\207\340\256\232\340\256\277\340\256\257\340\256\276)" },
    { wxLANGUAGE_TAMIL_SINGAPORE,                                  "ta-SG"          , "ta_SG"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Tamil (Singapore)","\340\256\244\340\256\256\340\256\277\340\256\264\340\257\215 (\340\256\232\340\256\277\340\256\231\340\257\215\340\256\225\340\256\252\340\257\215\340\256\252\340\257\202\340\256\260\340\257\215)" },
    { wxLANGUAGE_TAMIL_SRI_LANKA,                                  "ta-LK"          , "ta_LK"                     , ""             , 0x49, 0x02, wxLayout_LeftToRight, "Tamil (Sri Lanka)","\340\256\244\340\256\256\340\256\277\340\256\264\340\257\215 (\340\256\207\340\256\262\340\256\231\340\257\215\340\256\225\340\257\210)" },
    { wxLANGUAGE_TASAWAQ,                                          "twq"            , "twq"                       , "twq_NE"       , 0x00, 0x04, wxLayout_LeftToRight, "Tasawaq","Tasawaq senni" },
    { wxLANGUAGE_TASAWAQ_NIGER,                                    "twq-NE"         , "twq_NE"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Tasawaq (Niger)","Tasawaq senni (Ni\305\276er)" },
    { wxLANGUAGE_TATAR,                                            "tt"             , "tt"                        , "tt_RU"        , 0x44, 0x01, wxLayout_LeftToRight, "Tatar","\321\202\320\260\321\202\320\260\321\200" },
    { wxLANGUAGE_TATAR_RUSSIA,                                     "tt-RU"          , "tt_RU"                     , ""             , 0x44, 0x01, wxLayout_LeftToRight, "Tatar (Russia)","\321\202\320\260\321\202\320\260\321\200 (\320\240\320\276\321\201\321\201\320\270\321\217)" },
    { wxLANGUAGE_TELUGU,                                           "te"             , "te"                        , "te_IN"        , 0x4a, 0x01, wxLayout_LeftToRight, "Telugu","\340\260\244\340\261\206\340\260\262\340\261\201\340\260\227\340\261\201" },
    { wxLANGUAGE_TELUGU_INDIA,                                     "te-IN"          , "te_IN"                     , ""             , 0x4a, 0x01, wxLayout_LeftToRight, "Telugu (India)","\340\260\244\340\261\206\340\260\262\340\261\201\340\260\227\340\261\201 (\340\260\255\340\260\276\340\260\260\340\260\244\340\260\246\340\261\207\340\260\266\340\260\202)" },
    { wxLANGUAGE_TESO,                                             "teo"            , "teo"                       , "teo_UG"       , 0x00, 0x04, wxLayout_LeftToRight, "Teso","Kiteso" },
    { wxLANGUAGE_TESO_KENYA,                                       "teo-KE"         , "teo_KE"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Teso (Kenya)","Kiteso (Kenia)" },
    { wxLANGUAGE_TESO_UGANDA,                                      "teo-UG"         , "teo_UG"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Teso (Uganda)","Kiteso (Uganda)" },
    { wxLANGUAGE_THAI,                                             "th"             , "th"                        , "th_TH"        , 0x1e, 0x01, wxLayout_LeftToRight, "Thai","\340\271\204\340\270\227\340\270\242" },
    { wxLANGUAGE_THAI_THAILAND,                                    "th-TH"          , "th_TH"                     , ""             , 0x1e, 0x01, wxLayout_LeftToRight, "Thai (Thailand)","\340\271\204\340\270\227\340\270\242 (\340\271\204\340\270\227\340\270\242)" },
    { wxLANGUAGE_TIBETAN,                                          "bo"             , "bo"                        , "bo_CN"        , 0x51, 0x01, wxLayout_LeftToRight, "Tibetan","\340\275\226\340\275\274\340\275\221\340\274\213\340\275\246\340\276\220\340\275\221\340\274\213" },
    { wxLANGUAGE_TIBETAN_CHINA,                                    "bo-CN"          , "bo_CN"                     , ""             , 0x51, 0x01, wxLayout_LeftToRight, "Tibetan (China)","\340\275\226\340\275\274\340\275\221\340\274\213\340\275\246\340\276\220\340\275\221\340\274\213 (\340\275\242\340\276\222\340\276\261\340\274\213\340\275\223\340\275\202)" },
    { wxLANGUAGE_TIBETAN_INDIA,                                    "bo-IN"          , "bo_IN"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Tibetan (India)","\340\275\226\340\275\274\340\275\221\340\274\213\340\275\246\340\276\220\340\275\221\340\274\213 (\340\275\242\340\276\222\340\276\261\340\274\213\340\275\202\340\275\242\340\274\213)" },
    { wxLANGUAGE_TIGRE,                                            "tig"            , "tig"                       , "tig_ER"       , 0x00, 0x04, wxLayout_LeftToRight, "Tigre","\341\211\265\341\214\215\341\210\250" },
    { wxLANGUAGE_TIGRE_ERITREA,                                    "tig-ER"         , "tig_ER"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Tigre (Eritrea)","\341\211\265\341\214\215\341\210\250 (\341\212\244\341\210\255\341\211\265\341\210\253)" },
    { wxLANGUAGE_TIGRINYA,                                         "ti"             , "ti"                        , "ti_ER"        , 0x73, 0x02, wxLayout_LeftToRight, "Tigrinya","\341\211\265\341\214\215\341\210\255" },
    { wxLANGUAGE_TIGRINYA_ERITREA,                                 "ti-ER"          , "ti_ER"                     , ""             , 0x73, 0x02, wxLayout_LeftToRight, "Tigrinya (Eritrea)","\341\211\265\341\214\215\341\210\255 (\341\212\244\341\210\255\341\211\265\341\210\253)" },
    { wxLANGUAGE_TIGRINYA_ETHIOPIA,                                "ti-ET"          , "ti_ET"                     , ""             , 0x73, 0x01, wxLayout_LeftToRight, "Tigrinya (Ethiopia)","\341\211\265\341\214\215\341\210\255 (\341\212\242\341\211\265\341\213\256\341\214\265\341\213\253)" },
    { wxLANGUAGE_TONGA,                                            "to"             , "to"                        , "to_TO"        , 0x00, 0x04, wxLayout_LeftToRight, "Tongan","lea fakatonga" },
    { wxLANGUAGE_TONGA_TONGA,                                      "to-TO"          , "to_TO"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Tongan (Tonga)","lea fakatonga (Tonga)" },
    { wxLANGUAGE_TSONGA,                                           "ts"             , "ts"                        , "ts_ZA"        , 0x31, 0x01, wxLayout_LeftToRight, "Xitsonga","Xitsonga" },
    { wxLANGUAGE_TSONGA_SOUTH_AFRICA,                              "ts-ZA"          , "ts_ZA"                     , ""             , 0x31, 0x01, wxLayout_LeftToRight, "Xitsonga (South Africa)","Xitsonga (South Africa)" },
    { wxLANGUAGE_TURKISH,                                          "tr"             , "tr"                        , "tr_TR"        , 0x1f, 0x01, wxLayout_LeftToRight, "Turkish","T\303\274rk\303\247e" },
    { wxLANGUAGE_TURKISH_CYPRUS,                                   "tr-CY"          , "tr_CY"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Turkish (Cyprus)","T\303\274rk\303\247e (K\304\261br\304\261s)" },
    { wxLANGUAGE_TURKISH_TURKIYE,                                  "tr-TR"          , "tr_TR"                     , ""             , 0x1f, 0x01, wxLayout_LeftToRight, "Turkish (T\303\274rkiye)","T\303\274rk\303\247e (T\303\274rkiye)" },
    { wxLANGUAGE_TURKMEN,                                          "tk"             , "tk"                        , "tk_TM"        , 0x42, 0x01, wxLayout_LeftToRight, "Turkmen","t\303\274rkmen dili" },
    { wxLANGUAGE_TURKMEN_TURKMENISTAN,                             "tk-TM"          , "tk_TM"                     , ""             , 0x42, 0x01, wxLayout_LeftToRight, "Turkmen (Turkmenistan)","t\303\274rkmen dili (T\303\274rkmenistan)" },
    { wxLANGUAGE_TWI,                                              "tw"             , "tw"                        , ""             , 0   , 0   , wxLayout_LeftToRight, "Twi","Twi" },
    { wxLANGUAGE_UIGHUR,                                           "ug"             , "ug"                        , "ug_CN"        , 0x80, 0x01, wxLayout_RightToLeft, "Uyghur","\330\246\333\207\331\212\330\272\333\207\330\261\332\206\333\225" },
    { wxLANGUAGE_UIGHUR_CHINA,                                     "ug-CN"          , "ug_CN"                     , ""             , 0x80, 0x01, wxLayout_RightToLeft, "Uyghur (China)","\330\246\333\207\331\212\330\272\333\207\330\261\332\206\333\225 (\330\254\333\207\332\255\330\256\333\207\330\247 \330\256\333\225\331\204\331\202 \330\254\333\207\331\205\332\276\333\207\330\261\331\211\331\212\331\211\330\252\331\211)" },
    { wxLANGUAGE_UKRAINIAN,                                        "uk"             , "uk"                        , "uk_UA"        , 0x22, 0x01, wxLayout_LeftToRight, "Ukrainian","\321\203\320\272\321\200\320\260\321\227\320\275\321\201\321\214\320\272\320\260" },
    { wxLANGUAGE_UKRAINIAN_UKRAINE,                                "uk-UA"          , "uk_UA"                     , ""             , 0x22, 0x01, wxLayout_LeftToRight, "Ukrainian (Ukraine)","\321\203\320\272\321\200\320\260\321\227\320\275\321\201\321\214\320\272\320\260 (\320\243\320\272\321\200\320\260\321\227\320\275\320\260)" },
    { wxLANGUAGE_UPPER_SORBIAN,                                    "hsb"            , "hsb"                       , "hsb_DE"       , 0x2e, 0x01, wxLayout_LeftToRight, "Upper Sorbian","hornjoserb\305\241\304\207ina" },
    { wxLANGUAGE_UPPER_SORBIAN_GERMANY,                            "hsb-DE"         , "hsb_DE"                    , ""             , 0x2e, 0x01, wxLayout_LeftToRight, "Upper Sorbian (Germany)","hornjoserb\305\241\304\207ina (N\304\233mska)" },
    { wxLANGUAGE_URDU,                                             "ur"             , "ur"                        , "ur_PK"        , 0x20, 0x01, wxLayout_RightToLeft, "Urdu","\330\247\330\261\330\257\331\210" },
    { wxLANGUAGE_URDU_INDIA,                                       "ur-IN"          , "ur_IN"                     , ""             , 0x20, 0x02, wxLayout_RightToLeft, "Urdu (India)","\330\247\330\261\330\257\331\210 (\330\250\332\276\330\247\330\261\330\252)" },
    { wxLANGUAGE_URDU_PAKISTAN,                                    "ur-PK"          , "ur_PK"                     , ""             , 0x20, 0x01, wxLayout_RightToLeft, "Urdu (Pakistan)","\330\247\330\261\330\257\331\210 (\331\276\330\247\332\251\330\263\330\252\330\247\331\206)" },
    { wxLANGUAGE_UZBEK,                                            "uz"             , "uz"                        , ""             , 0x43, 0x01, wxLayout_LeftToRight, "Uzbek","o\342\200\230zbek" },
    { wxLANGUAGE_UZBEK_ARABIC,                                     "uz-Arab"        , "uz@arabic"                 , ""             , 0x00, 0x04, wxLayout_RightToLeft, "Uzbek (Arabic)","\330\247\331\210\330\262\330\250\333\214\332\251 (\330\271\330\261\330\250\333\214)" },
    { wxLANGUAGE_UZBEK_ARABIC_AFGHANISTAN,                         "uz-Arab-AF"     , "uz_AF@arabic"              , ""             , 0x00, 0x04, wxLayout_RightToLeft, "Uzbek (Arabic, Afghanistan)","\330\247\331\210\330\262\330\250\333\214\332\251 (\330\247\331\201\330\272\330\247\331\206\330\263\330\252\330\247\331\206)" },
    { wxLANGUAGE_UZBEK_CYRILLIC,                                   "uz-Cyrl"        , "uz@cyrillic"               , ""             , 0x43, 0x02, wxLayout_LeftToRight, "Uzbek (Cyrillic)","\320\216\320\267\320\261\320\265\320\272 (\320\232\320\270\321\200\320\270\320\273)" },
    { wxLANGUAGE_UZBEK_CYRILLIC_UZBEKISTAN,                        "uz-Cyrl-UZ"     , "uz_UZ@cyrillic"            , ""             , 0x43, 0x02, wxLayout_LeftToRight, "Uzbek (Cyrillic, Uzbekistan)","\321\236\320\267\320\261\320\265\320\272\321\207\320\260 (\320\216\320\267\320\261\320\265\320\272\320\270\321\201\321\202\320\276\320\275)" },
    { wxLANGUAGE_UZBEK_LATIN,                                      "uz-Latn"        , "uz@latin"                  , ""             , 0x43, 0x01, wxLayout_LeftToRight, "Uzbek (Latin)","o\342\200\230zbek" },
    { wxLANGUAGE_UZBEK_LATIN_UZBEKISTAN,                           "uz-Latn-UZ"     , "uz_UZ@latin"               , ""             , 0x43, 0x01, wxLayout_LeftToRight, "Uzbek (Latin, Uzbekistan)","o\342\200\230zbek (O\312\273zbekiston)" },
    { wxLANGUAGE_VAI,                                              "vai"            , "vai"                       , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Vai","\352\225\231\352\224\244" },
    { wxLANGUAGE_VAI_LATIN,                                        "vai-Latn"       , "vai@latin"                 , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Vai (Latin)","Vai (Latin)" },
    { wxLANGUAGE_VAI_LATIN_LIBERIA,                                "vai-Latn-LR"    , "vai_LR@latin"              , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Vai (Latin, Liberia)","Vai (Laibhiya)" },
    { wxLANGUAGE_VAI_VAI,                                          "vai-Vaii"       , "vai@vai"                   , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Vai (Vai)","\352\225\231\352\224\244 (Vai)" },
    { wxLANGUAGE_VAI_VAI_LIBERIA,                                  "vai-Vaii-LR"    , "vai_LR@vai"                , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Vai (Vai, Liberia)","\352\225\231\352\224\244 (\352\225\236\352\224\244\352\224\253\352\225\251)" },
    { wxLANGUAGE_VALENCIAN,                                        "ca-ES-valencia" , "ca_ES@valencia"            , ""             , 0x03, 0x02, wxLayout_LeftToRight, "Valencian (Spain)","valenci\303\240 (Espanya)" },
    { wxLANGUAGE_VENDA,                                            "ve"             , "ve"                        , "ve_ZA"        , 0x33, 0x01, wxLayout_LeftToRight, "Venda","Tshiven\341\270\223a" },
    { wxLANGUAGE_VENDA_SOUTH_AFRICA,                               "ve-ZA"          , "ve_ZA"                     , ""             , 0x33, 0x01, wxLayout_LeftToRight, "Venda (South Africa)","Tshiven\341\270\223a (South Africa)" },
    { wxLANGUAGE_VIETNAMESE,                                       "vi"             , "vi"                        , "vi_VN"        , 0x2a, 0x01, wxLayout_LeftToRight, "Vietnamese","Ti\341\272\277ng Vi\341\273\207t" },
    { wxLANGUAGE_VIETNAMESE_VIETNAM,                               "vi-VN"          , "vi_VN"                     , ""             , 0x2a, 0x01, wxLayout_LeftToRight, "Vietnamese (Vietnam)","Ti\341\272\277ng Vi\341\273\207t (Vi\341\273\207t Nam)" },
    { wxLANGUAGE_VOLAPUK,                                          "vo"             , "vo"                        , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Volap\303\274k","Volap\303\274k" },
    { wxLANGUAGE_VOLAPUK_WORLD,                                    "vo-001"         , "vo_001"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Volap\303\274k (World)","Volap\303\274k (World)" },
    { wxLANGUAGE_VUNJO,                                            "vun"            , "vun"                       , "vun_TZ"       , 0x00, 0x04, wxLayout_LeftToRight, "Vunjo","Kyivunjo" },
    { wxLANGUAGE_VUNJO_TANZANIA,                                   "vun-TZ"         , "vun_TZ"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Vunjo (Tanzania)","Kyivunjo (Tanzania)" },
    { wxLANGUAGE_WALSER,                                           "wae"            , "wae"                       , "wae_CH"       , 0x00, 0x04, wxLayout_LeftToRight, "Walser","Walser" },
    { wxLANGUAGE_WALSER_SWITZERLAND,                               "wae-CH"         , "wae_CH"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Walser (Switzerland)","Walser (Schwiz)" },
    { wxLANGUAGE_WELSH,                                            "cy"             , "cy"                        , "cy_GB"        , 0x52, 0x01, wxLayout_LeftToRight, "Welsh","Cymraeg" },
    { wxLANGUAGE_WELSH_UK,                                         "cy-GB"          , "cy_GB"                     , ""             , 0x52, 0x01, wxLayout_LeftToRight, "Welsh (United Kingdom)","Cymraeg (Y Deyrnas Unedig)" },
    { wxLANGUAGE_WOLAYTTA,                                         "wal"            , "wal"                       , "wal_ET"       , 0x00, 0x04, wxLayout_LeftToRight, "Wolaytta","\341\213\210\341\210\213\341\213\255\341\211\263\341\211\261" },
    { wxLANGUAGE_WOLAYTTA_ETHIOPIA,                                "wal-ET"         , "wal_ET"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Wolaytta (Ethiopia)","\341\213\210\341\210\213\341\213\255\341\211\263\341\211\261 (\341\212\242\341\211\265\341\213\256\341\214\265\341\213\253)" },
    { wxLANGUAGE_WOLOF,                                            "wo"             , "wo"                        , "wo_SN"        , 0x88, 0x01, wxLayout_LeftToRight, "Wolof","Wolof" },
    { wxLANGUAGE_WOLOF_SENEGAL,                                    "wo-SN"          , "wo_SN"                     , ""             , 0x88, 0x01, wxLayout_LeftToRight, "Wolof (Senegal)","Wolof (Senegaal)" },
    { wxLANGUAGE_XHOSA,                                            "xh"             , "xh"                        , "xh_ZA"        , 0x34, 0x01, wxLayout_LeftToRight, "isiXhosa","isiXhosa" },
    { wxLANGUAGE_XHOSA_SOUTH_AFRICA,                               "xh-ZA"          , "xh_ZA"                     , ""             , 0x34, 0x01, wxLayout_LeftToRight, "isiXhosa (South Africa)","isiXhosa (eMzantsi Afrika)" },
    { wxLANGUAGE_YANGBEN,                                          "yav"            , "yav"                       , "yav_CM"       , 0x00, 0x04, wxLayout_LeftToRight, "Yangben","nuasue" },
    { wxLANGUAGE_YANGBEN_CAMEROON,                                 "yav-CM"         , "yav_CM"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Yangben (Cameroon)","nuasue (Kemel\303\272n)" },
    { wxLANGUAGE_YI,                                               "ii"             , "ii"                        , "ii_CN"        , 0x78, 0x01, wxLayout_LeftToRight, "Yi","\352\206\210\352\214\240\352\211\231" },
    { wxLANGUAGE_YIDDISH,                                          "yi"             , "yi"                        , ""             , 0x3d, 0x01, wxLayout_RightToLeft, "Yiddish","\327\231\327\231\326\264\327\223\327\231\327\251" },
    { wxLANGUAGE_YIDDISH_WORLD,                                    "yi-001"         , "yi_001"                    , ""             , 0x3d, 0x01, wxLayout_RightToLeft, "Yiddish (World)","\327\231\327\231\326\264\327\223\327\231\327\251 (\327\225\327\225\327\242\327\234\327\230)" },
    { wxLANGUAGE_YI_CHINA,                                         "ii-CN"          , "ii_CN"                     , ""             , 0x78, 0x01, wxLayout_LeftToRight, "Yi (China)","\352\206\210\352\214\240\352\211\231 (\352\215\217\352\207\251)" },
    { wxLANGUAGE_YORUBA,                                           "yo"             , "yo"                        , "yo_NG"        , 0x6a, 0x01, wxLayout_LeftToRight, "Yoruba","\303\210d\303\250 Yor\303\271b\303\241" },
    { wxLANGUAGE_YORUBA_BENIN,                                     "yo-BJ"          , "yo_BJ"                     , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Yoruba (Benin)","\303\210d\303\250 Yor\303\271b\303\241 (B\311\233\314\200n\311\233\314\200)" },
    { wxLANGUAGE_YORUBA_NIGERIA,                                   "yo-NG"          , "yo_NG"                     , ""             , 0x6a, 0x01, wxLayout_LeftToRight, "Yoruba (Nigeria)","\303\210d\303\250 Yor\303\271b\303\241 (N\303\240\303\254j\303\255r\303\255\303\240)" },
    { wxLANGUAGE_ZARMA,                                            "dje"            , "dje"                       , "dje_NE"       , 0x00, 0x04, wxLayout_LeftToRight, "Zarma","Zarmaciine" },
    { wxLANGUAGE_ZARMA_NIGER,                                      "dje-NE"         , "dje_NE"                    , ""             , 0x00, 0x04, wxLayout_LeftToRight, "Zarma (Niger)","Zarmaciine (Ni\305\276er)" },
    { wxLANGUAGE_ZHUANG,                                           "za"             , "za"                        , ""             , 0   , 0   , wxLayout_LeftToRight, "Zhuang","Zhuang" },
    { wxLANGUAGE_ZULU,                                             "zu"             , "zu"                        , "zu_ZA"        , 0x35, 0x01, wxLayout_LeftToRight, "isiZulu","isiZulu" },
    { wxLANGUAGE_ZULU_SOUTH_AFRICA,                                "zu-ZA"          , "zu_ZA"                     , ""             , 0x35, 0x01, wxLayout_LeftToRight, "isiZulu (South Africa)","isiZulu (iNingizimu Afrika)" },

    { 0, nullptr, nullptr, nullptr, 0, 0, wxLayout_Default, nullptr, nullptr }
};
// --- --- --- generated code ends here --- --- ---

#endif // _WX_PRIVATE_LANG_INFO_H_
