pragma Ada_2012;

pragma Style_Checks (Off);
pragma Warnings (Off, "-gnatwu");

with Interfaces.C; use Interfaces.C;
with Interfaces.C.Strings;
with corecrt_h;
limited with sys_timeb_h;

package time_h is

   --  unsupported macro: NULL ((void *)0)
   CLOCKS_PER_SEC : constant := 1000;  --  D:/a/msys64/ucrt64/include/time.h:113

   TIME_UTC : constant := 1;  --  D:/a/msys64/ucrt64/include/time.h:116
   --  unsupported macro: CLK_TCK CLOCKS_PER_SEC

  --*
  -- * This file has no copyright assigned and is placed in the Public Domain.
  -- * This file is part of the mingw-w64 runtime package.
  -- * No warranty is given; refer to the file DISCLAIMER.PD within this package.
  --  

  -- When building mingw-w64, this should be blank.   
  -- Adding timespec definition.   
   subtype clock_t is long;  -- D:/a/msys64/ucrt64/include/time.h:63

   type tm is record
      tm_sec : aliased int;  -- D:/a/msys64/ucrt64/include/time.h:101
      tm_min : aliased int;  -- D:/a/msys64/ucrt64/include/time.h:102
      tm_hour : aliased int;  -- D:/a/msys64/ucrt64/include/time.h:103
      tm_mday : aliased int;  -- D:/a/msys64/ucrt64/include/time.h:104
      tm_mon : aliased int;  -- D:/a/msys64/ucrt64/include/time.h:105
      tm_year : aliased int;  -- D:/a/msys64/ucrt64/include/time.h:106
      tm_wday : aliased int;  -- D:/a/msys64/ucrt64/include/time.h:107
      tm_yday : aliased int;  -- D:/a/msys64/ucrt64/include/time.h:108
      tm_isdst : aliased int;  -- D:/a/msys64/ucrt64/include/time.h:109
   end record
   with Convention => C_Pass_By_Copy;  -- D:/a/msys64/ucrt64/include/time.h:100

   --  skipped func __daylight

   --  skipped func __dstbias

   --  skipped func __timezone

   --  skipped func __tzname

   --  skipped func _get_daylight

   --  skipped func _get_dstbias

   --  skipped func _get_timezone

   --  skipped func _get_tzname

   function asctime (u_Tm : access constant tm) return Interfaces.C.Strings.chars_ptr  -- D:/a/msys64/ucrt64/include/time.h:142
   with Import => True, 
        Convention => C, 
        External_Name => "asctime";

   function asctime_s
     (u_Buf : Interfaces.C.Strings.chars_ptr;
      u_SizeInWords : corecrt_h.size_t;
      u_Tm : access constant tm) return corecrt_h.errno_t  -- D:/a/msys64/ucrt64/include/time.h:143
   with Import => True, 
        Convention => C, 
        External_Name => "asctime_s";

   --  skipped func _ctime32

   --  skipped func _ctime32_s

   function clock return clock_t  -- D:/a/msys64/ucrt64/include/time.h:146
   with Import => True, 
        Convention => C, 
        External_Name => "clock";

   --  skipped func _difftime32

   --  skipped func _gmtime32

   --  skipped func _gmtime32_s

   --  skipped func _localtime32

   --  skipped func _localtime32_s

   function strftime
     (u_Buf : Interfaces.C.Strings.chars_ptr;
      u_SizeInBytes : corecrt_h.size_t;
      u_Format : Interfaces.C.Strings.chars_ptr;
      u_Tm : access constant tm) return corecrt_h.size_t  -- D:/a/msys64/ucrt64/include/time.h:152
   with Import => True, 
        Convention => C, 
        External_Name => "strftime";

   --  skipped func _strftime_l

   --  skipped func _strdate

   --  skipped func _strdate_s

   --  skipped func _strtime

   --  skipped func _strtime_s

   --  skipped func _time32

   --  skipped func _timespec32_get

   --  skipped func _mktime32

   --  skipped func _mkgmtime32

   --  skipped func _tzset

   --  skipped func _difftime64

   --  skipped func _ctime64

   --  skipped func _ctime64_s

   --  skipped func _gmtime64

   --  skipped func _gmtime64_s

   --  skipped func _localtime64

   --  skipped func _localtime64_s

   --  skipped func _mktime64

   --  skipped func _mkgmtime64

   --  skipped func _time64

   --  skipped func _timespec64_get

   --  skipped func _getsystime

   --  skipped func _setsystime

   --  skipped func _wasctime

   --  skipped func _wasctime_s

   --  skipped func _wctime32

   --  skipped func _wctime32_s

   function wcsftime
     (u_Buf : access corecrt_h.wchar_t;
      u_SizeInWords : corecrt_h.size_t;
      u_Format : access corecrt_h.wchar_t;
      u_Tm : access constant tm) return corecrt_h.size_t  -- D:/a/msys64/ucrt64/include/time.h:198
   with Import => True, 
        Convention => C, 
        External_Name => "wcsftime";

   --  skipped func _wcsftime_l

   --  skipped func _wstrdate

   --  skipped func _wstrdate_s

   --  skipped func _wstrtime

   --  skipped func _wstrtime_s

   --  skipped func _wctime64

   --  skipped func _wctime64_s

   --  skipped func _wctime

   --  skipped func _wctime_s

   function time (u_Time : access corecrt_h.time_t) return corecrt_h.time_t  -- D:/a/msys64/ucrt64/include/time.h:245
   with Import => True, 
        Convention => C, 
        External_Name => "_time64";

   function timespec_get (u_Ts : access sys_timeb_h.timespec; u_Base : int) return int  -- D:/a/msys64/ucrt64/include/time.h:247
   with Import => True, 
        Convention => C, 
        External_Name => "_timespec64_get";

   function difftime (u_Time1 : corecrt_h.time_t; u_Time2 : corecrt_h.time_t) return double  -- D:/a/msys64/ucrt64/include/time.h:249
   with Import => True, 
        Convention => C, 
        External_Name => "_difftime64";

   function localtime (u_Time : access corecrt_h.time_t) return access tm  -- D:/a/msys64/ucrt64/include/time.h:250
   with Import => True, 
        Convention => C, 
        External_Name => "_localtime64";

   function localtime_s (u_Tm : access tm; u_Time : access corecrt_h.time_t) return corecrt_h.errno_t  -- D:/a/msys64/ucrt64/include/time.h:251
   with Import => True, 
        Convention => C, 
        External_Name => "_localtime64_s";

   function gmtime (u_Time : access corecrt_h.time_t) return access tm  -- D:/a/msys64/ucrt64/include/time.h:252
   with Import => True, 
        Convention => C, 
        External_Name => "_gmtime64";

   function gmtime_s (u_Tm : access tm; u_Time : access corecrt_h.time_t) return corecrt_h.errno_t  -- D:/a/msys64/ucrt64/include/time.h:253
   with Import => True, 
        Convention => C, 
        External_Name => "_gmtime64_s";

   function ctime (u_Time : access corecrt_h.time_t) return Interfaces.C.Strings.chars_ptr  -- D:/a/msys64/ucrt64/include/time.h:254
   with Import => True, 
        Convention => C, 
        External_Name => "_ctime64";

   function ctime_s
     (u_Buf : Interfaces.C.Strings.chars_ptr;
      u_SizeInBytes : corecrt_h.size_t;
      u_Time : access corecrt_h.time_t) return corecrt_h.errno_t  -- D:/a/msys64/ucrt64/include/time.h:255
   with Import => True, 
        Convention => C, 
        External_Name => "_ctime64_s";

   function mktime (u_Tm : access tm) return corecrt_h.time_t  -- D:/a/msys64/ucrt64/include/time.h:256
   with Import => True, 
        Convention => C, 
        External_Name => "_mktime64";

   --  skipped func _mkgmtime

   daylight : aliased int  -- D:/a/msys64/ucrt64/include/time.h:274
   with Import => True, 
        Convention => C, 
        External_Name => "daylight";

   timezone : aliased long  -- D:/a/msys64/ucrt64/include/time.h:275
   with Import => True, 
        Convention => C, 
        External_Name => "timezone";

   tzname : array (0 .. 1) of Interfaces.C.Strings.chars_ptr  -- D:/a/msys64/ucrt64/include/time.h:276
   with Import => True, 
        Convention => C, 
        External_Name => "tzname";

   procedure tzset  -- D:/a/msys64/ucrt64/include/time.h:277
   with Import => True, 
        Convention => C, 
        External_Name => "tzset";

  -- POSIX 2008 says clock_gettime and timespec are defined in time.h header,
  --   but other systems - like Linux, Solaris, etc - tend to declare such
  --   recent extensions only if the following guards are met.   

end time_h;

pragma Style_Checks (On);
pragma Warnings (On, "-gnatwu");
