pragma Ada_2012;

pragma Style_Checks (Off);
pragma Warnings (Off, "-gnatwu");

with Interfaces.C; use Interfaces.C;

package umingw_h is

   USE_u_u_UUIDOF : constant := 0;  --  D:/a/msys64/ucrt64/include/_mingw.h:70

   MINGW_HAS_SECURE_API : constant := 1;  --  D:/a/msys64/ucrt64/include/_mingw.h:678
   --  unsupported macro: UNALIGNED __unaligned

  --*
  -- * This file has no copyright assigned and is placed in the Public Domain.
  -- * This file is part of the mingw-w64 runtime package.
  -- * No warranty is given; refer to the file DISCLAIMER.PD within this package.
  --  

  -- Include _cygwin.h if we're building a Cygwin application.  
  -- Target specific macro replacement for type "long".  In the Windows API,
  --   the type long is always 32 bit, even if the target is 64 bit (LLP64).
  --   On 64 bit Cygwin, the type long is 64 bit (LP64).  So, to get the right
  --   sized definitions and declarations, all usage of type long in the Windows
  --   headers have to be replaced by the below defined macro __LONG32.  

  -- C/C++ specific language defines.   
  -- Note the extern. This is needed to work around GCC's
  --limitations in handling dllimport attribute.   

  -- Recent MSVC supports C++14 but it doesn't define __cplusplus accordingly.   
  -- Attribute `nonnull' was valid as of gcc 3.3.  We don't use GCC's
  --   variadiac macro facility, because variadic macros cause syntax
  --   errors with  --traditional-cpp.   

  --  High byte is the major version, low byte is the minor.  
  -- Allow both 0x1400 and 0xE00 to identify UCRT  
  -- other headers depend on this include  
  -- We have to define _DLL for gcc based mingw version. This define is set
  --   by VC, when DLL-based runtime is used. So, gcc based runtime just have
  --   DLL-base runtime, therefore this define has to be set.
  --   As our headers are possibly used by windows compiler having a static
  --   C-runtime, we make this definition gnu compiler specific here.   

  -- MSVC defines _NATIVE_NULLPTR_SUPPORTED when nullptr is supported. We emulate it here for GCC.  
  -- We are activating __USE_MINGW_ANSI_STDIO for various define indicators.
  -- * printf ll modifier (unsupported by msvcrt.dll) is required by C99 and C++11 standards.  

  -- Enable __USE_MINGW_ANSI_STDIO if user did _not_ specify it explicitly...  
  -- We are defining __USE_MINGW_ANSI_STDIO as 0 or 1  
  -- _dowildcard is an int that controls the globbing of the command line.
  -- * The MinGW32 (mingw.org) runtime calls it _CRT_glob, so we are adding
  -- * a compatibility definition here:  you can use either of _CRT_glob or
  -- * _dowildcard .
  -- * If _dowildcard is non-zero, the command line will be globbed:  *.*
  -- * will be expanded to be all files in the startup directory.
  -- * In the mingw-w64 library a _dowildcard variable is defined as being
  -- * 0, therefore command line globbing is DISABLED by default. To turn it
  -- * on and to leave wildcard command line processing MS's globbing code,
  -- * include a line in one of your source modules defining _dowildcard and
  -- * setting it to -1, like so:
  -- * int _dowildcard = -1;
  --  

  -- Macros for __uuidof template-based emulation  
   --  skipped func __debugbreak

   --  skipped func __fastfail

  -- mingw-w64 specific functions:  
   --  skipped func __mingw_get_crt_info

  -- for backward compatibility  
end umingw_h;

pragma Style_Checks (On);
pragma Warnings (On, "-gnatwu");
