


# Hints, tricks, bugs, and suggestions

This page is meant to provide a place to project managers using the COIN-OR autotools system to share their experience.  Please write anything down that might be useful to other project managers.  For example, what didn't work the way you expected, what did you misunderstand, what bug did you find in the autotools, how did you get something to work, what is not clear in the documentation, _etc_.  This will also be helpful for the [BuildTools](http://projects.coin-or.org/BuildTools/wiki) maintainers to improve the system and documentation.

-------------------------------

Here are a few comments from a person new to the autotools. Experienced users may not find these useful.

First, some important terminology. This terminology is consistent with that used in this Wiki.

*Project Base Directory:* If, for example, you download the Cbc project via svn using

{{{ 
svn co https://projects.coin-or.org/svn/Cbc/trunk Coin-Cbc
}}}

then `Coin-Cbc` is the Project Base Directory.

*Project Main Subirectory:* If you download the Cbc project via svn with the above command there will be `Cbc` subdirectory under the Project Base Directory `Coin-Cbc`. We call this `Cbc` subdirectory the Project Main Subdirectory.

*Source Subdirectory:* It is common for the Project Main Subdirectory to have a `src` subdirectory. This is the Source Subdirectory. Some projects such as Cgl will have source code in the `src` subdirectory and source code in directories under `src`.  

The following points are all made at [this wiki](./pm-main). I am just summarizing a few key points that are useful to have at your fingertips.

1. If the `configure.ac` file in the Project Main Subdirectory contains (we again illustrate with the Cbc project) the macro
```
AC_COIN_CHECK_PACKAGE(Cbc, cbc)
```
 then the variable `COIN_HAS_CBC` will be defined to 1 and there will be a variable `CBC_CFLAGS` which contains the include paths for building against CBC and a variable `CBC_LIBS` which contain the flags for linking against the CBC library, _e.g._, `-lCbc -lOsi -lClp...`. So, if you have some code and want to build against CBC, you can do this
```
if COIN_HAS_CBC
  AM_CPPFLAGS += $(CBC_CFLAGS)
  myLibrary_LDADD = $(CBC_LIBS)
endif
```

2. The variable `AM_CPPFLAGS` is important. It is used to set the include directories for the header files. It is also used to set additional `-D` preprocessor flags. 

3. There is a very useful header file, `config_`_prj_{{.h}}} (_e.g._, `config_cbc.h`) that is automatically generated by the `configure` script and put into the `inc` subdirectory in the Project Main Subirectory. It has `#defines` such as 
```
/* If defined, debug sanity checks are performed during runtime */
/* #undef COIN_DEBUG */

/* Define to 1 if the ASL package is available */
#define COIN_HAS_ASL 1
```
 These variables can then be used in `#ifdef` statements inside the C++ code. See `CbcConfig.h` for an example of how to use the `config_cbc.h` file. 

4. *Use the Correct Version of Autotools*. Whatever you do take the [advice given at this page](./pm-get-autotools) and put your autotools in `$HOME/bin` and the configuration files in `$HOME/share`.  The BuildTools page says you can alternatively install them in another directory and set the appropriate environment variable (like doing `export AUTOTOOLS_DIR=/somepath/autotools; export PATH=/somepath/autotools/bin`). Don't even think about it! Also make sure you don't have alternative versions of the autotools lurking about in directories such as `/usr/bin` that appear before `$HOME/bin` in `PATH`.

-------------------------------


## Using autoreconf

As distributed, COIN-OR packages do not provide `acinclude.m4` and `aclocal.m4`. Instead, these are generated when the script `BuildTools/run_autotools` is executed. (Have a look at the script to see how it's done; `aclocal` is responsible for `aclocal.m4`.) Documentation to the contrary, `autoreconf` is not capable of correctly (re)generating `acinclude.m4` and `aclocal.m4`. If you're writing configuration macros, you want to be using `run_autotools` to incorporate your changes into `acinclude.m4` and `aclocal.m4`. If you're not writing configuration macros, you need to run `run_autotools` at least once to produce `acinclude.m4` and `aclocal.m4`, after which you can use `autoreconf`.
