/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;

public class ImgdecClient {
    private String hostname;
    private int portNo;

    public ImgdecClient(String string, int n) {
        this.hostname = string;
        this.portNo = n;
    }

    public PnmImage decode_jpipstream(byte[] byArray, String string, String string2, int n, int n2) {
        if (byArray != null) {
            this.send_JPIPstream(byArray);
        }
        return this.get_PNMstream(string2, string, n, n2);
    }

    public PnmImage decode_jpipstream(byte[] byArray, String string, String string2, String string3, int n, int n2) {
        this.send_JPIPstream(byArray, string, string2, string3);
        return this.get_PNMstream(string3, string2, n, n2);
    }

    public void send_JPIPstream(byte[] byArray) {
        try {
            Socket socket = new Socket(this.hostname, this.portNo);
            DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
            DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
            System.err.println("Sending " + byArray.length + "Data Bytes to decodingServer");
            dataOutputStream.writeBytes("JPIP-stream\n");
            dataOutputStream.writeBytes("version 1.2\n");
            dataOutputStream.writeBytes(byArray.length + "\n");
            dataOutputStream.write(byArray, 0, byArray.length);
            byte by = dataInputStream.readByte();
            if (by == 0) {
                System.err.println("    failed");
            }
        }
        catch (UnknownHostException unknownHostException) {
            System.err.println("Trying to connect to unknown host: " + unknownHostException);
        }
        catch (IOException iOException) {
            System.err.println("IOException: " + iOException);
        }
    }

    public void send_JPIPstream(byte[] byArray, String string, String string2, String string3) {
        try {
            Socket socket = new Socket(this.hostname, this.portNo);
            DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
            DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
            int n = 0;
            if (byArray != null) {
                n = byArray.length;
            }
            System.err.println("Sending " + n + "Data Bytes to decodingServer");
            dataOutputStream.writeBytes("JPIP-stream\n");
            dataOutputStream.writeBytes("version 1.2\n");
            dataOutputStream.writeBytes(string + "\n");
            if (string2 == null) {
                dataOutputStream.writeBytes("0\n");
            } else {
                dataOutputStream.writeBytes(string2 + "\n");
            }
            if (string3 == null) {
                dataOutputStream.writeBytes("0\n");
            } else {
                dataOutputStream.writeBytes(string3 + "\n");
            }
            dataOutputStream.writeBytes(n + "\n");
            dataOutputStream.write(byArray, 0, n);
            byte by = dataInputStream.readByte();
            if (by == 0) {
                System.err.println("    failed");
            }
        }
        catch (UnknownHostException unknownHostException) {
            System.err.println("Trying to connect to unknown host: " + unknownHostException);
        }
        catch (IOException iOException) {
            System.err.println("IOException: " + iOException);
        }
    }

    public PnmImage get_PNMstream(String string, String string2, int n, int n2) {
        PnmImage pnmImage = null;
        try {
            Socket socket = new Socket(this.hostname, this.portNo);
            DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
            DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
            byte[] byArray = new byte[7];
            dataOutputStream.writeBytes("PNM request\n");
            if (string != null) {
                dataOutputStream.writeBytes(string + "\n");
            } else if (string2 != null) {
                dataOutputStream.writeBytes(string2 + "\n");
            } else {
                dataOutputStream.writeBytes("0\n");
            }
            dataOutputStream.writeBytes(n + "\n");
            dataOutputStream.writeBytes(n2 + "\n");
            ImgdecClient.read_stream(dataInputStream, byArray, 7);
            if (byArray[0] == 80) {
                byte by = byArray[1];
                if (by == 5 || by == 6) {
                    int n3 = by == 6 ? 3 : 1;
                    int n4 = (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
                    int n5 = (byArray[4] & 0xFF) << 8 | byArray[5] & 0xFF;
                    int n6 = byArray[6] & 0xFF;
                    int n7 = n4 * n5 * n3;
                    if (n6 == 255 && n7 != 0) {
                        pnmImage = new PnmImage(n3, n4, n5);
                        ImgdecClient.read_stream(dataInputStream, pnmImage.get_data(), n7);
                    } else {
                        System.err.println("Error in get_PNMstream(), only 255 is accepted");
                    }
                } else {
                    System.err.println("Error in get_PNMstream(), wrong magick number" + byArray[1]);
                }
            } else {
                System.err.println("Error in get_PNMstream(), Not starting with P");
            }
            dataOutputStream.close();
            dataInputStream.close();
            socket.close();
        }
        catch (UnknownHostException unknownHostException) {
            System.err.println("Trying to connect to unknown host: " + unknownHostException);
        }
        catch (IOException iOException) {
            System.err.println("IOException: " + iOException);
        }
        return pnmImage;
    }

    public byte[] get_XMLstream(String string) {
        byte[] byArray = null;
        try {
            Socket socket = new Socket(this.hostname, this.portNo);
            DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
            DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
            byte[] byArray2 = new byte[5];
            dataOutputStream.writeBytes("XML request\n");
            dataOutputStream.writeBytes(string + "\n");
            ImgdecClient.read_stream(dataInputStream, byArray2, 5);
            if (byArray2[0] == 88 && byArray2[1] == 77 && byArray2[2] == 76) {
                int n = (byArray2[3] & 0xFF) << 8 | byArray2[4] & 0xFF;
                byArray = new byte[n];
                ImgdecClient.read_stream(dataInputStream, byArray, n);
            } else {
                System.err.println("Error in get_XMLstream(), not starting with XML");
            }
        }
        catch (UnknownHostException unknownHostException) {
            System.err.println("Trying to connect to unknown host: " + unknownHostException);
        }
        catch (IOException iOException) {
            System.err.println("IOException: " + iOException);
        }
        return byArray;
    }

    public String query_cid(String string) {
        int[] nArray = new int[]{67, 73, 68};
        return this.query_id("CID request", string, nArray);
    }

    public String query_tid(String string) {
        int[] nArray = new int[]{84, 73, 68};
        return this.query_id("TID request", string, nArray);
    }

    public String query_id(String string, String string2, int[] nArray) {
        String string3 = null;
        try {
            Socket socket = new Socket(this.hostname, this.portNo);
            DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
            DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
            byte[] byArray = new byte[4];
            dataOutputStream.writeBytes(string + "\n");
            dataOutputStream.writeBytes(string2 + "\n");
            ImgdecClient.read_stream(dataInputStream, byArray, 4);
            if (byArray[0] == nArray[0] && byArray[1] == nArray[1] && byArray[2] == nArray[2]) {
                int n = byArray[3] & 0xFF;
                if (n > 0) {
                    byte[] byArray2 = new byte[n];
                    ImgdecClient.read_stream(dataInputStream, byArray2, n);
                    string3 = new String(byArray2);
                }
            } else {
                System.err.println("Error in query_id(" + string + "), wrong to start with " + byArray);
            }
        }
        catch (UnknownHostException unknownHostException) {
            System.err.println("Trying to connect to unknown host: " + unknownHostException);
        }
        catch (IOException iOException) {
            System.err.println("IOException: " + iOException);
        }
        return string3;
    }

    public Dimension query_imagesize(String string, String string2) {
        Dimension dimension = null;
        try {
            Socket socket = new Socket(this.hostname, this.portNo);
            DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
            DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
            byte[] byArray = new byte[3];
            dataOutputStream.writeBytes("SIZ request\n");
            if (string2 == null) {
                dataOutputStream.writeBytes("0\n");
            } else {
                dataOutputStream.writeBytes(string2 + "\n");
            }
            if (string == null) {
                dataOutputStream.writeBytes("0\n");
            } else {
                dataOutputStream.writeBytes(string + "\n");
            }
            ImgdecClient.read_stream(dataInputStream, byArray, 3);
            if (byArray[0] == 83 && byArray[1] == 73 && byArray[2] == 90) {
                byte[] byArray2 = new byte[3];
                ImgdecClient.read_stream(dataInputStream, byArray2, 3);
                int n = (byArray2[0] & 0xFF) << 16 | (byArray2[1] & 0xFF) << 8 | byArray2[2] & 0xFF;
                ImgdecClient.read_stream(dataInputStream, byArray2, 3);
                int n2 = (byArray2[0] & 0xFF) << 16 | (byArray2[1] & 0xFF) << 8 | byArray2[2] & 0xFF;
                dimension = new Dimension(n, n2);
            } else {
                System.err.println("Error in query_imagesize(" + string + ", " + string2 + "), wrong to start with " + byArray);
            }
        }
        catch (UnknownHostException unknownHostException) {
            System.err.println("Trying to connect to unknown host: " + unknownHostException);
        }
        catch (IOException iOException) {
            System.err.println("IOException: " + iOException);
        }
        return dimension;
    }

    private static void read_stream(DataInputStream dataInputStream, byte[] byArray, int n) {
        int n2 = 0;
        try {
            int n3;
            for (int i = n; i > 0; i -= n3) {
                n3 = dataInputStream.read(byArray, n2, i);
                if (n3 == -1) {
                    System.err.println("    failed to read_stream()");
                    break;
                }
                n2 += n3;
            }
        }
        catch (IOException iOException) {
            System.err.println("IOException: " + iOException);
        }
    }

    public void destroy_cid(String string) {
        try {
            Socket socket = new Socket(this.hostname, this.portNo);
            DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
            DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
            dataOutputStream.writeBytes("CID destroy\n");
            dataOutputStream.writeBytes(string + "\n");
            byte by = dataInputStream.readByte();
            if (by == 0) {
                System.err.println("    failed");
            }
        }
        catch (UnknownHostException unknownHostException) {
            System.err.println("Trying to connect to unknown host: " + unknownHostException);
        }
        catch (IOException iOException) {
            System.err.println("IOException: " + iOException);
        }
    }
}

