%define OT_MonteCarloLHS_doc
"Monte Carlo LHS optimization.

Performs the optimization of an LHS using Monte Carlo simulations.

Parameters
----------
lhsDesign : :class:`~openturns.LHSExperiment`
     Factory that generate designs
N : int
    Number of simulations
spaceFilling : :class:`~openturns.SpaceFilling`, optional
    Criterion to be optimized, default is :class:`~openturns.SpaceFillingMinDist`

Notes
-----
MonteCarloLHS generates :math:`N` LHS designs and returns the optimal one with
respect to a space-filling criterion.
Unlike :class:`~openturns.SimulatedAnnealingLHS` it does not apply cell swaps
directly so the design may not change that much if the shuffle property of the
:class:`~openturns.LHSExperiment` is disabled.

Examples
--------
>>> import openturns as ot
>>> dimension = 3
>>> size = 100
>>> # Build standard randomized LHS algorithm
>>> distribution = ot.ComposedDistribution([ot.Uniform(0.0, 1.0)]*dimension)
>>> lhs = ot.LHSExperiment(distribution, size)
>>> lhs.setAlwaysShuffle(True) # randomized
>>> # Defining space fillings
>>> spaceFilling = ot.SpaceFillingC2()
>>> # RandomBruteForce MonteCarlo with N designs (LHS with C2 optimization)
>>> N = 10000
>>> optimalLHSAlgorithm = ot.MonteCarloLHS(lhs, N, spaceFilling)
"
%enddef
%feature("docstring") OT::MonteCarloLHS
OT_MonteCarloLHS_doc

// ---------------------------------------------------------------------
