%feature("docstring") OT::NAISResult
"NAIS result.

See also
--------
NAIS, SimulationResult"

// ---------------------------------------------------------------------------

%feature("docstring") OT::NAISResult::getAuxiliaryDistribution
"Accessor of the auxiliary distribution at the final NAIS step.

Returns
-------
auxiliaryDistribution : :class:`~openturns.Distribution`
    Auxiliary distribution at the final NAIS step."

// ---------------------------------------------------------------------------

%feature("docstring") OT::NAISResult::getAuxiliaryInputSample
"Accessor of the auxiliary distribution input sample at the final NAIS step.

Returns
-------
auxiliaryInputSample : :class:`~openturns.Sample`
    Auxiliary distribution input sample at the final NAIS step."
    
// ---------------------------------------------------------------------------

%feature("docstring") OT::NAISResult::getAuxiliaryOutputSample
"Accessor of the auxiliary distribution output sample at the final NAIS step.

Returns
-------
auxiliaryOutputSample : :class:`~openturns.Sample`
    Auxiliary distribution output sample at the final NAIS step."
    
// ---------------------------------------------------------------------------

%feature("docstring") OT::NAISResult::setAuxiliaryInputSample
"Accessor of the auxiliary distribution input sample at the final NAIS step.

Parameters
----------
auxiliaryInputSample : :class:`~openturns.Sample`
    Auxiliary distribution input sample at the final NAIS step."
    
// ---------------------------------------------------------------------------

%feature("docstring") OT::NAISResult::setAuxiliaryOutputSample
"Accessor of the auxiliary distribution output sample at the final NAIS step.

Parameters
----------
auxiliaryOutputSample : :class:`~openturns.Sample`
    Auxiliary distribution output sample at the final NAIS step."    
    
// ---------------------------------------------------------------------------

%feature("docstring") OT::NAISResult::setAuxiliaryDistribution
"Accessor of the auxiliary distribution at the final NAIS step.

Parameters
----------
auxiliaryDistribution : :class:`~openturns.Distribution`
    Auxiliary distribution at the final NAIS step."    
    
// ---------------------------------------------------------------------------

%feature("docstring") OT::NAISResult::getWeights
"Auxiliary distribution input sample associated weights accessor of the final NAIS step.

Returns
-------
weights : :class:`~openturns.Point`
    Auxiliary distribution input sample associated weights."     

// ---------------------------------------------------------------------------

%feature("docstring") OT::NAISResult::setWeights
"Auxiliary distribution input sample associated weights accessor of the final NAIS step.

Parameters
----------
weights : :class:`~openturns.Point`
    Auxiliary distribution input sample associated weights." 


