#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsegbuffercreate_ PETSCSEGBUFFERCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsegbuffercreate_ petscsegbuffercreate
#endif
PETSC_EXTERN void petscsegbuffercreate_(size_t *a, PetscCount *b, PetscSegBuffer *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(c);
  CHKFORTRANNULLOBJECT(c);
  *ierr = PetscSegBufferCreate(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsegbufferget_ PETSCSEGBUFFERGET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsegbufferget_ petscsegbufferget
#endif
PETSC_EXTERN void petscsegbufferget_(PetscSegBuffer *a, PetscCount *b, void *c, PetscErrorCode *ierr)
{
  *ierr = PetscSegBufferGet(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsegbufferdestroy_ PETSCSEGBUFFERDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsegbufferdestroy_ petscsegbufferdestroy
#endif
PETSC_EXTERN void petscsegbufferdestroy_(PetscSegBuffer *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = PetscSegBufferDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsegbufferextractto_ PETSCSEGBUFFEREXTRACTTO
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsegbufferextractto_ petscsegbufferextractto
#endif
PETSC_EXTERN void petscsegbufferextractto_(PetscSegBuffer *a, void *b, PetscErrorCode *ierr)
{
  *ierr = PetscSegBufferExtractTo(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsegbufferextractalloc_ PETSCSEGBUFFEREXTRACTALLOC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsegbufferextractalloc_ petscsegbufferextractalloc
#endif
PETSC_EXTERN void petscsegbufferextractalloc_(PetscSegBuffer *a, void *b, PetscErrorCode *ierr)
{
  *ierr = PetscSegBufferExtractAlloc(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsegbufferextractinplace_ PETSCSEGBUFFEREXTRACTINPLACE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsegbufferextractinplace_ petscsegbufferextractinplace
#endif
PETSC_EXTERN void petscsegbufferextractinplace_(PetscSegBuffer *a, void *b, PetscErrorCode *ierr)
{
  *ierr = PetscSegBufferExtractInPlace(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsegbuffergetsize_ PETSCSEGBUFFERGETSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsegbuffergetsize_ petscsegbuffergetsize
#endif
PETSC_EXTERN void petscsegbuffergetsize_(PetscSegBuffer *a, PetscCount *b, PetscErrorCode *ierr)
{
  *ierr = PetscSegBufferGetSize(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsegbufferunuse_ PETSCSEGBUFFERUNUSE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsegbufferunuse_ petscsegbufferunuse
#endif
PETSC_EXTERN void petscsegbufferunuse_(PetscSegBuffer *a, PetscCount *b, PetscErrorCode *ierr)
{
  *ierr = PetscSegBufferUnuse(*a, *b);
  if (*ierr) return;
}
