#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscdraw.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdrawopenx_ PETSCDRAWOPENX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdrawopenx_ petscdrawopenx
#endif
PETSC_EXTERN void petscdrawopenx_(MPI_Fint *a, char b[], char c[], int *d, int *e, int *f, int *g, PetscDraw *h, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b, PETSC_FORTRAN_CHARLEN_T l_c)
{
  PetscBool null_h = !*(void**) h ? PETSC_TRUE : PETSC_FALSE;
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  CHKFORTRANNULLOBJECT(h);
  *ierr = PetscDrawOpenX(MPI_Comm_f2c(*(a)), c_b, c_c, *d, *e, *f, *g, h);
  if (*ierr) return;
  FREECHAR(b, c_b);
  FREECHAR(c, c_c);
  if (! null_h && !*(void**) h) *(void **) h = (void *)-2;
}
