#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcreatesubmatrixvirtual_ MATCREATESUBMATRIXVIRTUAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcreatesubmatrixvirtual_ matcreatesubmatrixvirtual
#endif
PETSC_EXTERN void matcreatesubmatrixvirtual_(Mat *a, IS *b, IS *c, Mat *d, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(d);
  *ierr = MatCreateSubMatrixVirtual(*a, *b, *c, d);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matsubmatrixvirtualupdate_ MATSUBMATRIXVIRTUALUPDATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matsubmatrixvirtualupdate_ matsubmatrixvirtualupdate
#endif
PETSC_EXTERN void matsubmatrixvirtualupdate_(Mat *a, Mat *b, IS *c, IS *d, PetscErrorCode *ierr)
{
  *ierr = MatSubMatrixVirtualUpdate(*a, *b, *c, *d);
  if (*ierr) return;
}
