#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscspaceptrimmedsetformdegree_ PETSCSPACEPTRIMMEDSETFORMDEGREE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscspaceptrimmedsetformdegree_ petscspaceptrimmedsetformdegree
#endif
PETSC_EXTERN void petscspaceptrimmedsetformdegree_(PetscSpace *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = PetscSpacePTrimmedSetFormDegree(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscspaceptrimmedgetformdegree_ PETSCSPACEPTRIMMEDGETFORMDEGREE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscspaceptrimmedgetformdegree_ petscspaceptrimmedgetformdegree
#endif
PETSC_EXTERN void petscspaceptrimmedgetformdegree_(PetscSpace *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = PetscSpacePTrimmedGetFormDegree(*a, b);
  if (*ierr) return;
}
