#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petsclandau.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define landaukokkosjacobian_ LANDAUKOKKOSJACOBIAN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define landaukokkosjacobian_ landaukokkosjacobian
#endif
PETSC_EXTERN void landaukokkosjacobian_(DM a[], const PetscInt *b, const PetscInt *c, const PetscInt *d, const PetscInt *e, const PetscInt f[], PetscReal g[], PetscScalar h[], const PetscScalar i[], const LandauStaticData *j, const PetscReal *k, const PetscLogEvent l[], const PetscInt m[], const PetscInt n[], Mat o[], Mat *p, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(f);
  CHKFORTRANNULLREAL(g);
  CHKFORTRANNULLSCALAR(h);
  CHKFORTRANNULLSCALAR(i);
  CHKFORTRANNULLINTEGER(m);
  CHKFORTRANNULLINTEGER(n);
  *ierr = LandauKokkosJacobian(a, *b, *c, *d, *e, f, g, h, i, j, *k, l, m, n, o, *p);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petsclandau.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define landaukokkosdestroymatmaps_ LANDAUKOKKOSDESTROYMATMAPS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define landaukokkosdestroymatmaps_ landaukokkosdestroymatmaps
#endif
PETSC_EXTERN void landaukokkosdestroymatmaps_(P4estVertexMaps *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = LandauKokkosDestroyMatMaps(a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petsclandau.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define landaukokkosstaticdataset_ LANDAUKOKKOSSTATICDATASET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define landaukokkosstaticdataset_ landaukokkosstaticdataset
#endif
PETSC_EXTERN void landaukokkosstaticdataset_(DM *a, const PetscInt *b, const PetscInt *c, const PetscInt *d, const PetscInt *e, PetscInt f[], PetscInt g[], PetscInt h[], PetscReal i[], PetscReal j[], PetscReal k[], PetscReal l[], PetscReal m[], PetscReal n[], PetscReal o[], PetscReal p[], PetscReal q[], LandauStaticData *r, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(f);
  CHKFORTRANNULLINTEGER(g);
  CHKFORTRANNULLINTEGER(h);
  CHKFORTRANNULLREAL(i);
  CHKFORTRANNULLREAL(j);
  CHKFORTRANNULLREAL(k);
  CHKFORTRANNULLREAL(l);
  CHKFORTRANNULLREAL(m);
  CHKFORTRANNULLREAL(n);
  CHKFORTRANNULLREAL(o);
  CHKFORTRANNULLREAL(p);
  CHKFORTRANNULLREAL(q);
  *ierr = LandauKokkosStaticDataSet(*a, *b, *c, *d, *e, f, g, h, i, j, k, l, m, n, o, p, q, r);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petsclandau.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define landaukokkosstaticdataclear_ LANDAUKOKKOSSTATICDATACLEAR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define landaukokkosstaticdataclear_ landaukokkosstaticdataclear
#endif
PETSC_EXTERN void landaukokkosstaticdataclear_(LandauStaticData *a, PetscErrorCode *ierr)
{
  *ierr = LandauKokkosStaticDataClear(a);
  if (*ierr) return;
}
