#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matdensegetlda_ MATDENSEGETLDA
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matdensegetlda_ matdensegetlda
#endif
PETSC_EXTERN void matdensegetlda_(Mat *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = MatDenseGetLDA(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matdensesetlda_ MATDENSESETLDA
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matdensesetlda_ matdensesetlda
#endif
PETSC_EXTERN void matdensesetlda_(Mat *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = MatDenseSetLDA(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcreateseqdense_ MATCREATESEQDENSE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcreateseqdense_ matcreateseqdense
#endif
PETSC_EXTERN void matcreateseqdense_(MPI_Fint *a, PetscInt *b, PetscInt *c, PetscScalar d[], Mat *e, PetscErrorCode *ierr)
{
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLSCALAR(d);
  CHKFORTRANNULLOBJECT(e);
  *ierr = MatCreateSeqDense(MPI_Comm_f2c(*(a)), *b, *c, d, e);
  if (*ierr) return;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matseqdensesetpreallocation_ MATSEQDENSESETPREALLOCATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matseqdensesetpreallocation_ matseqdensesetpreallocation
#endif
PETSC_EXTERN void matseqdensesetpreallocation_(Mat *a, PetscScalar b[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(b);
  *ierr = MatSeqDenseSetPreallocation(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matdensegetcolumnvec_ MATDENSEGETCOLUMNVEC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matdensegetcolumnvec_ matdensegetcolumnvec
#endif
PETSC_EXTERN void matdensegetcolumnvec_(Mat *a, PetscInt *b, Vec *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = MatDenseGetColumnVec(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matdenserestorecolumnvec_ MATDENSERESTORECOLUMNVEC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matdenserestorecolumnvec_ matdenserestorecolumnvec
#endif
PETSC_EXTERN void matdenserestorecolumnvec_(Mat *a, PetscInt *b, Vec *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = MatDenseRestoreColumnVec(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matdensegetcolumnvecread_ MATDENSEGETCOLUMNVECREAD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matdensegetcolumnvecread_ matdensegetcolumnvecread
#endif
PETSC_EXTERN void matdensegetcolumnvecread_(Mat *a, PetscInt *b, Vec *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = MatDenseGetColumnVecRead(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matdenserestorecolumnvecread_ MATDENSERESTORECOLUMNVECREAD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matdenserestorecolumnvecread_ matdenserestorecolumnvecread
#endif
PETSC_EXTERN void matdenserestorecolumnvecread_(Mat *a, PetscInt *b, Vec *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = MatDenseRestoreColumnVecRead(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matdensegetcolumnvecwrite_ MATDENSEGETCOLUMNVECWRITE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matdensegetcolumnvecwrite_ matdensegetcolumnvecwrite
#endif
PETSC_EXTERN void matdensegetcolumnvecwrite_(Mat *a, PetscInt *b, Vec *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = MatDenseGetColumnVecWrite(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matdenserestorecolumnvecwrite_ MATDENSERESTORECOLUMNVECWRITE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matdenserestorecolumnvecwrite_ matdenserestorecolumnvecwrite
#endif
PETSC_EXTERN void matdenserestorecolumnvecwrite_(Mat *a, PetscInt *b, Vec *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = MatDenseRestoreColumnVecWrite(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matdensegetsubmatrix_ MATDENSEGETSUBMATRIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matdensegetsubmatrix_ matdensegetsubmatrix
#endif
PETSC_EXTERN void matdensegetsubmatrix_(Mat *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscInt *e, Mat *f, PetscErrorCode *ierr)
{
  PetscBool null_f = !*(void**) f ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(f);
  *ierr = MatDenseGetSubMatrix(*a, *b, *c, *d, *e, f);
  if (*ierr) return;
  if (! null_f && !*(void**) f) *(void **) f = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matdenserestoresubmatrix_ MATDENSERESTORESUBMATRIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matdenserestoresubmatrix_ matdenserestoresubmatrix
#endif
PETSC_EXTERN void matdenserestoresubmatrix_(Mat *a, Mat *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = MatDenseRestoreSubMatrix(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matseqdenseinvert_ MATSEQDENSEINVERT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matseqdenseinvert_ matseqdenseinvert
#endif
PETSC_EXTERN void matseqdenseinvert_(Mat *a, PetscErrorCode *ierr)
{
  *ierr = MatSeqDenseInvert(*a);
  if (*ierr) return;
}
