#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsgleeregisterall_ TSGLEEREGISTERALL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsgleeregisterall_ tsgleeregisterall
#endif
PETSC_EXTERN void tsgleeregisterall_(PetscErrorCode *ierr)
{
  *ierr = TSGLEERegisterAll();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsgleeregisterdestroy_ TSGLEEREGISTERDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsgleeregisterdestroy_ tsgleeregisterdestroy
#endif
PETSC_EXTERN void tsgleeregisterdestroy_(PetscErrorCode *ierr)
{
  *ierr = TSGLEERegisterDestroy();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsgleeinitializepackage_ TSGLEEINITIALIZEPACKAGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsgleeinitializepackage_ tsgleeinitializepackage
#endif
PETSC_EXTERN void tsgleeinitializepackage_(PetscErrorCode *ierr)
{
  *ierr = TSGLEEInitializePackage();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsgleefinalizepackage_ TSGLEEFINALIZEPACKAGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsgleefinalizepackage_ tsgleefinalizepackage
#endif
PETSC_EXTERN void tsgleefinalizepackage_(PetscErrorCode *ierr)
{
  *ierr = TSGLEEFinalizePackage();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsgleeregister_ TSGLEEREGISTER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsgleeregister_ tsgleeregister
#endif
PETSC_EXTERN void tsgleeregister_(char * a, PetscInt *b, PetscInt *c, PetscInt *d, PetscReal *e, const PetscReal f[], const PetscReal g[], const PetscReal h[], const PetscReal i[], const PetscReal j[], const PetscReal k[], const PetscReal l[], const PetscReal m[], const PetscReal n[], const PetscReal o[], PetscInt *p, const PetscReal q[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a)
{
  char* c_a;
  FIXCHAR(a, l_a, c_a);
  CHKFORTRANNULLREAL(f);
  CHKFORTRANNULLREAL(g);
  CHKFORTRANNULLREAL(h);
  CHKFORTRANNULLREAL(i);
  CHKFORTRANNULLREAL(j);
  CHKFORTRANNULLREAL(k);
  CHKFORTRANNULLREAL(l);
  CHKFORTRANNULLREAL(m);
  CHKFORTRANNULLREAL(n);
  CHKFORTRANNULLREAL(o);
  CHKFORTRANNULLREAL(q);
  *ierr = TSGLEERegister(c_a, *b, *c, *d, *e, f, g, h, i, j, k, l, m, n, o, *p, q);
  if (*ierr) return;
  FREECHAR(a, c_a);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsgleesettype_ TSGLEESETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsgleesettype_ tsgleesettype
#endif
PETSC_EXTERN void tsgleesettype_(TS *a, char * b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = TSGLEESetType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsgleegettype_ TSGLEEGETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsgleegettype_ tsgleegettype
#endif
PETSC_EXTERN void tsgleegettype_(TS *a, char * b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = TSGLEEGetType(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
