#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define veccreatempikokkoswitharray_ VECCREATEMPIKOKKOSWITHARRAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define veccreatempikokkoswitharray_ veccreatempikokkoswitharray
#endif
PETSC_EXTERN void veccreatempikokkoswitharray_(MPI_Fint *a, PetscInt *b, PetscInt *c, PetscInt *d, const PetscScalar e[], Vec *f, PetscErrorCode *ierr)
{
  PetscBool null_f = !*(void**) f ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLSCALAR(e);
  CHKFORTRANNULLOBJECT(f);
  *ierr = VecCreateMPIKokkosWithArray(MPI_Comm_f2c(*(a)), *b, *c, *d, e, f);
  if (*ierr) return;
  if (! null_f && !*(void**) f) *(void **) f = (void *)-2;
}
