/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import { describe, it, expect, vi } from 'vitest';
import * as os from 'node:os';
import * as path from 'node:path';
vi.mock('fs', async (importOriginal) => {
    const actual = await importOriginal();
    return {
        ...actual,
        mkdirSync: vi.fn(),
    };
});
import { Storage } from './storage.js';
describe('Storage – getGlobalSettingsPath', () => {
    it('returns path to ~/.qwen/settings.json', () => {
        const expected = path.join(os.homedir(), '.qwen', 'settings.json');
        expect(Storage.getGlobalSettingsPath()).toBe(expected);
    });
});
describe('Storage – additional helpers', () => {
    const projectRoot = '/tmp/project';
    const storage = new Storage(projectRoot);
    it('getWorkspaceSettingsPath returns project/.qwen/settings.json', () => {
        const expected = path.join(projectRoot, '.qwen', 'settings.json');
        expect(storage.getWorkspaceSettingsPath()).toBe(expected);
    });
    it('getUserCommandsDir returns ~/.qwen/commands', () => {
        const expected = path.join(os.homedir(), '.qwen', 'commands');
        expect(Storage.getUserCommandsDir()).toBe(expected);
    });
    it('getProjectCommandsDir returns project/.qwen/commands', () => {
        const expected = path.join(projectRoot, '.qwen', 'commands');
        expect(storage.getProjectCommandsDir()).toBe(expected);
    });
    it('getMcpOAuthTokensPath returns ~/.qwen/mcp-oauth-tokens.json', () => {
        const expected = path.join(os.homedir(), '.qwen', 'mcp-oauth-tokens.json');
        expect(Storage.getMcpOAuthTokensPath()).toBe(expected);
    });
});
//# sourceMappingURL=storage.test.js.map