/* SPDX-License-Identifier: (LGPL-2.1 OR BSD-2-Clause) */

/* THIS FILE IS AUTOGENERATED BY BPFTOOL! */
#ifndef __SOCKET_BIND_BPF_SKEL_H__
#define __SOCKET_BIND_BPF_SKEL_H__

#include <errno.h>
#include <stdlib.h>
#include <bpf/libbpf.h>

#define BPF_SKEL_SUPPORTS_MAP_AUTO_ATTACH 1

struct socket_bind_bpf {
	struct bpf_object_skeleton *skeleton;
	struct bpf_object *obj;
	struct {
		struct bpf_map *sd_bind_allow;
		struct bpf_map *sd_bind_deny;
	} maps;
	struct {
		struct bpf_program *sd_bind4;
		struct bpf_program *sd_bind6;
	} progs;
	struct {
		struct bpf_link *sd_bind4;
		struct bpf_link *sd_bind6;
	} links;

#ifdef __cplusplus
	static inline struct socket_bind_bpf *open(const struct bpf_object_open_opts *opts = nullptr);
	static inline struct socket_bind_bpf *open_and_load();
	static inline int load(struct socket_bind_bpf *skel);
	static inline int attach(struct socket_bind_bpf *skel);
	static inline void detach(struct socket_bind_bpf *skel);
	static inline void destroy(struct socket_bind_bpf *skel);
	static inline const void *elf_bytes(size_t *sz);
#endif /* __cplusplus */
};

static void
socket_bind_bpf__destroy(struct socket_bind_bpf *obj)
{
	if (!obj)
		return;
	if (obj->skeleton)
		bpf_object__destroy_skeleton(obj->skeleton);
	free(obj);
}

static inline int
socket_bind_bpf__create_skeleton(struct socket_bind_bpf *obj);

static inline struct socket_bind_bpf *
socket_bind_bpf__open_opts(const struct bpf_object_open_opts *opts)
{
	struct socket_bind_bpf *obj;
	int err;

	obj = (struct socket_bind_bpf *)calloc(1, sizeof(*obj));
	if (!obj) {
		errno = ENOMEM;
		return NULL;
	}

	err = socket_bind_bpf__create_skeleton(obj);
	if (err)
		goto err_out;

	err = bpf_object__open_skeleton(obj->skeleton, opts);
	if (err)
		goto err_out;

	return obj;
err_out:
	socket_bind_bpf__destroy(obj);
	errno = -err;
	return NULL;
}

static inline struct socket_bind_bpf *
socket_bind_bpf__open(void)
{
	return socket_bind_bpf__open_opts(NULL);
}

static inline int
socket_bind_bpf__load(struct socket_bind_bpf *obj)
{
	return bpf_object__load_skeleton(obj->skeleton);
}

static inline struct socket_bind_bpf *
socket_bind_bpf__open_and_load(void)
{
	struct socket_bind_bpf *obj;
	int err;

	obj = socket_bind_bpf__open();
	if (!obj)
		return NULL;
	err = socket_bind_bpf__load(obj);
	if (err) {
		socket_bind_bpf__destroy(obj);
		errno = -err;
		return NULL;
	}
	return obj;
}

static inline int
socket_bind_bpf__attach(struct socket_bind_bpf *obj)
{
	return bpf_object__attach_skeleton(obj->skeleton);
}

static inline void
socket_bind_bpf__detach(struct socket_bind_bpf *obj)
{
	bpf_object__detach_skeleton(obj->skeleton);
}

static inline const void *socket_bind_bpf__elf_bytes(size_t *sz);

static inline int
socket_bind_bpf__create_skeleton(struct socket_bind_bpf *obj)
{
	struct bpf_object_skeleton *s;
	struct bpf_map_skeleton *map __attribute__((unused));
	int err;

	s = (struct bpf_object_skeleton *)calloc(1, sizeof(*s));
	if (!s)	{
		err = -ENOMEM;
		goto err;
	}

	s->sz = sizeof(*s);
	s->name = "socket_bind_bpf";
	s->obj = &obj->obj;

	/* maps */
	s->map_cnt = 2;
	s->map_skel_sz = 24;
	s->maps = (struct bpf_map_skeleton *)calloc(s->map_cnt,
			sizeof(*s->maps) > 24 ? sizeof(*s->maps) : 24);
	if (!s->maps) {
		err = -ENOMEM;
		goto err;
	}

	map = (struct bpf_map_skeleton *)((char *)s->maps + 0 * s->map_skel_sz);
	map->name = "sd_bind_allow";
	map->map = &obj->maps.sd_bind_allow;

	map = (struct bpf_map_skeleton *)((char *)s->maps + 1 * s->map_skel_sz);
	map->name = "sd_bind_deny";
	map->map = &obj->maps.sd_bind_deny;

	/* programs */
	s->prog_cnt = 2;
	s->prog_skel_sz = sizeof(*s->progs);
	s->progs = (struct bpf_prog_skeleton *)calloc(s->prog_cnt, s->prog_skel_sz);
	if (!s->progs) {
		err = -ENOMEM;
		goto err;
	}

	s->progs[0].name = "sd_bind4";
	s->progs[0].prog = &obj->progs.sd_bind4;
	s->progs[0].link = &obj->links.sd_bind4;

	s->progs[1].name = "sd_bind6";
	s->progs[1].prog = &obj->progs.sd_bind6;
	s->progs[1].link = &obj->links.sd_bind6;

	s->data = socket_bind_bpf__elf_bytes(&s->data_sz);

	obj->skeleton = s;
	return 0;
err:
	bpf_object__destroy_skeleton(s);
	return err;
}

static inline const void *socket_bind_bpf__elf_bytes(size_t *sz)
{
	static const char data[] __attribute__((__aligned__(8))) = "\
\x7f\x45\x4c\x46\x02\x01\x01\0\0\0\0\0\0\0\0\0\x01\0\xf7\0\x01\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\x68\x12\0\0\0\0\0\0\0\0\0\0\x40\0\0\0\0\0\x40\0\x0b\0\
\x01\0\0\x2e\x73\x74\x72\x74\x61\x62\0\x2e\x73\x79\x6d\x74\x61\x62\0\x63\x67\
\x72\x6f\x75\x70\x2f\x62\x69\x6e\x64\x34\0\x63\x67\x72\x6f\x75\x70\x2f\x62\x69\
\x6e\x64\x36\0\x6c\x69\x63\x65\x6e\x73\x65\0\x2e\x6d\x61\x70\x73\0\x73\x6f\x63\
\x6b\x65\x74\x2d\x62\x69\x6e\x64\x2e\x62\x70\x66\x2e\x63\0\x73\x64\x5f\x62\x69\
\x6e\x64\x34\0\x73\x64\x5f\x62\x69\x6e\x64\x5f\x61\x6c\x6c\x6f\x77\0\x73\x64\
\x5f\x62\x69\x6e\x64\x5f\x64\x65\x6e\x79\0\x73\x64\x5f\x62\x69\x6e\x64\x36\0\
\x5f\x6c\x69\x63\x65\x6e\x73\x65\0\x2e\x72\x65\x6c\x63\x67\x72\x6f\x75\x70\x2f\
\x62\x69\x6e\x64\x34\0\x2e\x72\x65\x6c\x63\x67\x72\x6f\x75\x70\x2f\x62\x69\x6e\
\x64\x36\0\x2e\x42\x54\x46\0\x2e\x42\x54\x46\x2e\x65\x78\x74\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x39\0\0\0\x04\0\xf1\xff\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\x03\0\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x4b\0\0\0\x12\0\x03\0\0\0\0\
\0\0\0\0\0\x90\x02\0\0\0\0\0\0\x54\0\0\0\x11\0\x06\0\0\0\0\0\0\0\0\0\x18\0\0\0\
\0\0\0\0\x62\0\0\0\x11\0\x06\0\x18\0\0\0\0\0\0\0\x18\0\0\0\0\0\0\0\x6f\0\0\0\
\x12\0\x04\0\0\0\0\0\0\0\0\0\x90\x02\0\0\0\0\0\0\x78\0\0\0\x11\0\x05\0\0\0\0\0\
\0\0\0\0\x04\0\0\0\0\0\0\0\xbf\x17\0\0\0\0\0\0\xb7\0\0\0\x01\0\0\0\x61\x71\0\0\
\0\0\0\0\x55\x01\x4b\0\x02\0\0\0\x61\x71\x1c\0\0\0\0\0\x55\x01\x49\0\x02\0\0\0\
\x61\x71\x18\0\0\0\0\0\x63\x1a\xfc\xff\0\0\0\0\xb7\x08\0\0\0\0\0\0\x61\xa9\xfc\
\xff\0\0\0\0\xdc\x09\0\0\x10\0\0\0\x18\x06\0\0\xff\xff\xff\xff\0\0\0\0\0\0\0\0\
\x63\x8a\xf8\xff\0\0\0\0\xbf\xa2\0\0\0\0\0\0\x07\x02\0\0\xf8\xff\xff\xff\x18\
\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x85\0\0\0\x01\0\0\0\x15\0\x16\0\0\0\0\0\x61\
\x02\0\0\0\0\0\0\x1d\x62\x0e\0\0\0\0\0\x61\x71\x24\0\0\0\0\0\x15\x02\x03\0\0\0\
\0\0\x61\x73\0\0\0\0\0\0\x57\x03\0\0\xff\0\0\0\x5d\x32\x09\0\0\0\0\0\x61\x02\
\x04\0\0\0\0\0\x15\x02\x01\0\0\0\0\0\x5d\x12\x06\0\0\0\0\0\x69\x01\x08\0\0\0\0\
\0\x15\x01\x2e\0\0\0\0\0\x69\x02\x0a\0\0\0\0\0\x2d\x92\x02\0\0\0\0\0\x0f\x12\0\
\0\0\0\0\0\x2d\x92\x2a\0\0\0\0\0\x07\x08\0\0\x01\0\0\0\xbf\x81\0\0\0\0\0\0\x67\
\x01\0\0\x20\0\0\0\x77\x01\0\0\x20\0\0\0\x15\x01\x01\0\x80\0\0\0\x05\0\xe3\xff\
\0\0\0\0\x61\x71\x18\0\0\0\0\0\x63\x1a\xfc\xff\0\0\0\0\xb7\x08\0\0\0\0\0\0\x61\
\xa9\xfc\xff\0\0\0\0\xdc\x09\0\0\x10\0\0\0\x18\x06\0\0\xff\xff\xff\xff\0\0\0\0\
\0\0\0\0\x63\x8a\xf8\xff\0\0\0\0\xbf\xa2\0\0\0\0\0\0\x07\x02\0\0\xf8\xff\xff\
\xff\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x85\0\0\0\x01\0\0\0\x15\0\x16\0\0\0\0\
\0\x61\x02\0\0\0\0\0\0\x1d\x62\x0e\0\0\0\0\0\x61\x71\x24\0\0\0\0\0\x15\x02\x03\
\0\0\0\0\0\x61\x73\0\0\0\0\0\0\x57\x03\0\0\xff\0\0\0\x5d\x32\x09\0\0\0\0\0\x61\
\x02\x04\0\0\0\0\0\x15\x02\x01\0\0\0\0\0\x5d\x12\x06\0\0\0\0\0\x69\x01\x08\0\0\
\0\0\0\x15\x01\x0c\0\0\0\0\0\x69\x02\x0a\0\0\0\0\0\x2d\x92\x02\0\0\0\0\0\x0f\
\x12\0\0\0\0\0\0\x2d\x92\x08\0\0\0\0\0\x07\x08\0\0\x01\0\0\0\xbf\x81\0\0\0\0\0\
\0\x67\x01\0\0\x20\0\0\0\x77\x01\0\0\x20\0\0\0\x15\x01\x01\0\x80\0\0\0\x05\0\
\xe3\xff\0\0\0\0\xb7\0\0\0\x01\0\0\0\x95\0\0\0\0\0\0\0\xb7\0\0\0\0\0\0\0\x05\0\
\xfd\xff\0\0\0\0\xbf\x17\0\0\0\0\0\0\xb7\0\0\0\x01\0\0\0\x61\x71\0\0\0\0\0\0\
\x55\x01\x4b\0\x0a\0\0\0\x61\x71\x1c\0\0\0\0\0\x55\x01\x49\0\x0a\0\0\0\x61\x71\
\x18\0\0\0\0\0\x63\x1a\xfc\xff\0\0\0\0\xb7\x08\0\0\0\0\0\0\x61\xa9\xfc\xff\0\0\
\0\0\xdc\x09\0\0\x10\0\0\0\x18\x06\0\0\xff\xff\xff\xff\0\0\0\0\0\0\0\0\x63\x8a\
\xf8\xff\0\0\0\0\xbf\xa2\0\0\0\0\0\0\x07\x02\0\0\xf8\xff\xff\xff\x18\x01\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\x85\0\0\0\x01\0\0\0\x15\0\x16\0\0\0\0\0\x61\x02\0\0\0\0\
\0\0\x1d\x62\x0e\0\0\0\0\0\x61\x71\x24\0\0\0\0\0\x15\x02\x03\0\0\0\0\0\x61\x73\
\0\0\0\0\0\0\x57\x03\0\0\xff\0\0\0\x5d\x32\x09\0\0\0\0\0\x61\x02\x04\0\0\0\0\0\
\x15\x02\x01\0\0\0\0\0\x5d\x12\x06\0\0\0\0\0\x69\x01\x08\0\0\0\0\0\x15\x01\x2e\
\0\0\0\0\0\x69\x02\x0a\0\0\0\0\0\x2d\x92\x02\0\0\0\0\0\x0f\x12\0\0\0\0\0\0\x2d\
\x92\x2a\0\0\0\0\0\x07\x08\0\0\x01\0\0\0\xbf\x81\0\0\0\0\0\0\x67\x01\0\0\x20\0\
\0\0\x77\x01\0\0\x20\0\0\0\x15\x01\x01\0\x80\0\0\0\x05\0\xe3\xff\0\0\0\0\x61\
\x71\x18\0\0\0\0\0\x63\x1a\xfc\xff\0\0\0\0\xb7\x08\0\0\0\0\0\0\x61\xa9\xfc\xff\
\0\0\0\0\xdc\x09\0\0\x10\0\0\0\x18\x06\0\0\xff\xff\xff\xff\0\0\0\0\0\0\0\0\x63\
\x8a\xf8\xff\0\0\0\0\xbf\xa2\0\0\0\0\0\0\x07\x02\0\0\xf8\xff\xff\xff\x18\x01\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\x85\0\0\0\x01\0\0\0\x15\0\x16\0\0\0\0\0\x61\x02\0\0\
\0\0\0\0\x1d\x62\x0e\0\0\0\0\0\x61\x71\x24\0\0\0\0\0\x15\x02\x03\0\0\0\0\0\x61\
\x73\0\0\0\0\0\0\x57\x03\0\0\xff\0\0\0\x5d\x32\x09\0\0\0\0\0\x61\x02\x04\0\0\0\
\0\0\x15\x02\x01\0\0\0\0\0\x5d\x12\x06\0\0\0\0\0\x69\x01\x08\0\0\0\0\0\x15\x01\
\x0c\0\0\0\0\0\x69\x02\x0a\0\0\0\0\0\x2d\x92\x02\0\0\0\0\0\x0f\x12\0\0\0\0\0\0\
\x2d\x92\x08\0\0\0\0\0\x07\x08\0\0\x01\0\0\0\xbf\x81\0\0\0\0\0\0\x67\x01\0\0\
\x20\0\0\0\x77\x01\0\0\x20\0\0\0\x15\x01\x01\0\x80\0\0\0\x05\0\xe3\xff\0\0\0\0\
\xb7\0\0\0\x01\0\0\0\x95\0\0\0\0\0\0\0\xb7\0\0\0\0\0\0\0\x05\0\xfd\xff\0\0\0\0\
\x47\x50\x4c\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x80\0\0\0\0\0\0\0\x01\0\0\0\x05\0\0\0\
\xa0\x01\0\0\0\0\0\0\x01\0\0\0\x06\0\0\0\x80\0\0\0\0\0\0\0\x01\0\0\0\x05\0\0\0\
\xa0\x01\0\0\0\0\0\0\x01\0\0\0\x06\0\0\0\x9f\xeb\x01\0\x18\0\0\0\0\0\0\0\x98\
\x02\0\0\x98\x02\0\0\xb8\x01\0\0\0\0\0\0\0\0\0\x02\x03\0\0\0\x01\0\0\0\0\0\0\
\x01\x04\0\0\0\x20\0\0\x01\0\0\0\0\0\0\0\x03\0\0\0\0\x02\0\0\0\x04\0\0\0\x02\0\
\0\0\x05\0\0\0\0\0\0\x01\x04\0\0\0\x20\0\0\0\0\0\0\0\0\0\0\x02\x06\0\0\0\x19\0\
\0\0\0\0\0\x08\x07\0\0\0\x1f\0\0\0\0\0\0\x01\x04\0\0\0\x20\0\0\0\0\0\0\0\0\0\0\
\x02\x09\0\0\0\x2c\0\0\0\x04\0\0\x04\x0c\0\0\0\x3d\0\0\0\x06\0\0\0\0\0\0\0\x4c\
\0\0\0\x06\0\0\0\x20\0\0\0\x55\0\0\0\x0a\0\0\0\x40\0\0\0\x5e\0\0\0\x0a\0\0\0\
\x50\0\0\0\x67\0\0\0\0\0\0\x08\x0b\0\0\0\x6d\0\0\0\0\0\0\x01\x02\0\0\0\x10\0\0\
\0\x7c\0\0\0\x03\0\0\x04\x18\0\0\0\x8e\0\0\0\x01\0\0\0\0\0\0\0\x93\0\0\0\x05\0\
\0\0\x40\0\0\0\x97\0\0\0\x08\0\0\0\x80\0\0\0\x9d\0\0\0\0\0\0\x0e\x0c\0\0\0\x01\
\0\0\0\xab\0\0\0\0\0\0\x0e\x0c\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\x02\x10\0\0\0\xb8\
\0\0\0\x0a\0\0\x04\x48\0\0\0\xc6\0\0\0\x06\0\0\0\0\0\0\0\xd2\0\0\0\x06\0\0\0\
\x20\0\0\0\xdb\0\0\0\x11\0\0\0\x40\0\0\0\xe4\0\0\0\x06\0\0\0\xc0\0\0\0\xee\0\0\
\0\x06\0\0\0\xe0\0\0\0\x8e\0\0\0\x06\0\0\0\0\x01\0\0\x4c\0\0\0\x06\0\0\0\x20\
\x01\0\0\xf5\0\0\0\x06\0\0\0\x40\x01\0\0\x01\x01\0\0\x11\0\0\0\x60\x01\0\0\0\0\
\0\0\x12\0\0\0\0\x02\0\0\0\0\0\0\0\0\0\x03\0\0\0\0\x06\0\0\0\x04\0\0\0\x04\0\0\
\0\0\0\0\0\x01\0\0\x05\x08\0\0\0\x0d\x01\0\0\x13\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\x02\x1a\0\0\0\0\0\0\0\x01\0\0\x0d\x02\0\0\0\x10\x01\0\0\x0f\0\0\0\x14\x01\0\0\
\x01\0\0\x0c\x14\0\0\0\x1d\x01\0\0\x01\0\0\x0c\x14\0\0\0\x26\x01\0\0\0\0\0\x01\
\x01\0\0\0\x08\0\0\x01\0\0\0\0\0\0\0\x03\0\0\0\0\x17\0\0\0\x04\0\0\0\x04\0\0\0\
\x2b\x01\0\0\0\0\0\x0e\x18\0\0\0\x01\0\0\0\x34\x01\0\0\0\0\0\x07\0\0\0\0\x90\
\x01\0\0\x01\0\0\x0f\x04\0\0\0\x19\0\0\0\0\0\0\0\x04\0\0\0\x98\x01\0\0\x02\0\0\
\x0f\x30\0\0\0\x0d\0\0\0\0\0\0\0\x18\0\0\0\x0e\0\0\0\x18\0\0\0\x18\0\0\0\0\x69\
\x6e\x74\0\x5f\x5f\x41\x52\x52\x41\x59\x5f\x53\x49\x5a\x45\x5f\x54\x59\x50\x45\
\x5f\x5f\0\x5f\x5f\x75\x33\x32\0\x75\x6e\x73\x69\x67\x6e\x65\x64\x20\x69\x6e\
\x74\0\x73\x6f\x63\x6b\x65\x74\x5f\x62\x69\x6e\x64\x5f\x72\x75\x6c\x65\0\x61\
\x64\x64\x72\x65\x73\x73\x5f\x66\x61\x6d\x69\x6c\x79\0\x70\x72\x6f\x74\x6f\x63\
\x6f\x6c\0\x6e\x72\x5f\x70\x6f\x72\x74\x73\0\x70\x6f\x72\x74\x5f\x6d\x69\x6e\0\
\x5f\x5f\x75\x31\x36\0\x75\x6e\x73\x69\x67\x6e\x65\x64\x20\x73\x68\x6f\x72\x74\
\0\x73\x6f\x63\x6b\x65\x74\x5f\x62\x69\x6e\x64\x5f\x6d\x61\x70\x5f\x74\0\x74\
\x79\x70\x65\0\x6b\x65\x79\0\x76\x61\x6c\x75\x65\0\x73\x64\x5f\x62\x69\x6e\x64\
\x5f\x61\x6c\x6c\x6f\x77\0\x73\x64\x5f\x62\x69\x6e\x64\x5f\x64\x65\x6e\x79\0\
\x62\x70\x66\x5f\x73\x6f\x63\x6b\x5f\x61\x64\x64\x72\0\x75\x73\x65\x72\x5f\x66\
\x61\x6d\x69\x6c\x79\0\x75\x73\x65\x72\x5f\x69\x70\x34\0\x75\x73\x65\x72\x5f\
\x69\x70\x36\0\x75\x73\x65\x72\x5f\x70\x6f\x72\x74\0\x66\x61\x6d\x69\x6c\x79\0\
\x6d\x73\x67\x5f\x73\x72\x63\x5f\x69\x70\x34\0\x6d\x73\x67\x5f\x73\x72\x63\x5f\
\x69\x70\x36\0\x73\x6b\0\x63\x74\x78\0\x73\x64\x5f\x62\x69\x6e\x64\x34\0\x73\
\x64\x5f\x62\x69\x6e\x64\x36\0\x63\x68\x61\x72\0\x5f\x6c\x69\x63\x65\x6e\x73\
\x65\0\x62\x70\x66\x5f\x73\x6f\x63\x6b\0\x2f\x75\x73\x72\x2f\x73\x72\x63\x2f\
\x64\x65\x62\x75\x67\x2f\x73\x79\x73\x74\x65\x6d\x64\x2f\x62\x75\x69\x6c\x64\
\x2f\x2e\x2e\x2f\x73\x79\x73\x74\x65\x6d\x64\x2f\x73\x72\x63\x2f\x63\x6f\x72\
\x65\x2f\x62\x70\x66\x2f\x73\x6f\x63\x6b\x65\x74\x5f\x62\x69\x6e\x64\x2f\x73\
\x6f\x63\x6b\x65\x74\x2d\x62\x69\x6e\x64\x2e\x62\x70\x66\x2e\x63\0\x6c\x69\x63\
\x65\x6e\x73\x65\0\x2e\x6d\x61\x70\x73\0\x63\x67\x72\x6f\x75\x70\x2f\x62\x69\
\x6e\x64\x34\0\x63\x67\x72\x6f\x75\x70\x2f\x62\x69\x6e\x64\x36\0\x9f\xeb\x01\0\
\x20\0\0\0\0\0\0\0\x24\0\0\0\x24\0\0\0\x54\x06\0\0\x78\x06\0\0\0\0\0\0\x08\0\0\
\0\x9e\x01\0\0\x01\0\0\0\0\0\0\0\x15\0\0\0\xab\x01\0\0\x01\0\0\0\0\0\0\0\x16\0\
\0\0\x10\0\0\0\x9e\x01\0\0\x32\0\0\0\0\0\0\0\x3d\x01\0\0\0\0\0\0\0\x8c\x01\0\
\x10\0\0\0\x3d\x01\0\0\0\0\0\0\x12\x90\x01\0\x18\0\0\0\x3d\x01\0\0\0\0\0\0\x29\
\x90\x01\0\x20\0\0\0\x3d\x01\0\0\0\0\0\0\x31\x90\x01\0\x28\0\0\0\x3d\x01\0\0\0\
\0\0\0\x0d\x90\x01\0\x30\0\0\0\x3d\x01\0\0\0\0\0\0\x29\x14\x01\0\x38\0\0\0\x3d\
\x01\0\0\0\0\0\0\x18\x14\x01\0\x48\0\0\0\x3d\x01\0\0\0\0\0\0\x1d\x18\x01\0\x68\
\0\0\0\x3d\x01\0\0\0\0\0\0\x1d\x24\x01\0\x80\0\0\0\x3d\x01\0\0\0\0\0\0\x37\x28\
\x01\0\x98\0\0\0\x3d\x01\0\0\0\0\0\0\x15\x38\x01\0\xa0\0\0\0\x3d\x01\0\0\0\0\0\
\0\x10\xe8\0\0\xa8\0\0\0\x3d\x01\0\0\0\0\0\0\x0d\xe8\0\0\xb0\0\0\0\x3d\x01\0\0\
\0\0\0\0\0\x44\x01\0\xb8\0\0\0\x3d\x01\0\0\0\0\0\0\x2c\xf4\0\0\xc0\0\0\0\x3d\
\x01\0\0\0\0\0\0\0\x44\x01\0\xc8\0\0\0\x3d\x01\0\0\0\0\0\0\0\xf4\0\0\xd0\0\0\0\
\x3d\x01\0\0\0\0\0\0\x2c\xf4\0\0\xd8\0\0\0\x3d\x01\0\0\0\0\0\0\x13\xb0\0\0\xe0\
\0\0\0\x3d\x01\0\0\0\0\0\0\x2d\xf8\0\0\xf0\0\0\0\x3d\x01\0\0\0\0\0\0\x13\xc4\0\
\0\xf8\0\0\0\x3d\x01\0\0\0\0\0\0\x21\xc4\0\0\0\x01\0\0\x3d\x01\0\0\0\0\0\0\x1d\
\xc8\0\0\x08\x01\0\0\x3d\x01\0\0\0\0\0\0\x26\xc8\0\0\x10\x01\0\0\x3d\x01\0\0\0\
\0\0\0\x3c\xc8\0\0\x20\x01\0\0\x3d\x01\0\0\0\0\0\0\x36\x20\x01\0\x40\x01\0\0\
\x3d\x01\0\0\0\0\0\0\x09\x20\x01\0\x50\x01\0\0\x3d\x01\0\0\0\0\0\0\x29\x14\x01\
\0\x58\x01\0\0\x3d\x01\0\0\0\0\0\0\x18\x14\x01\0\x68\x01\0\0\x3d\x01\0\0\0\0\0\
\0\x1d\x18\x01\0\x88\x01\0\0\x3d\x01\0\0\0\0\0\0\x1d\x24\x01\0\xa0\x01\0\0\x3d\
\x01\0\0\0\0\0\0\x37\x28\x01\0\xb8\x01\0\0\x3d\x01\0\0\0\0\0\0\x15\x38\x01\0\
\xc0\x01\0\0\x3d\x01\0\0\0\0\0\0\x10\xe8\0\0\xc8\x01\0\0\x3d\x01\0\0\0\0\0\0\
\x0d\xe8\0\0\xd0\x01\0\0\x3d\x01\0\0\0\0\0\0\0\x44\x01\0\xd8\x01\0\0\x3d\x01\0\
\0\0\0\0\0\x2c\xf4\0\0\xe0\x01\0\0\x3d\x01\0\0\0\0\0\0\0\x44\x01\0\xe8\x01\0\0\
\x3d\x01\0\0\0\0\0\0\0\xf4\0\0\xf0\x01\0\0\x3d\x01\0\0\0\0\0\0\x2c\xf4\0\0\xf8\
\x01\0\0\x3d\x01\0\0\0\0\0\0\x13\xb0\0\0\0\x02\0\0\x3d\x01\0\0\0\0\0\0\x2d\xf8\
\0\0\x10\x02\0\0\x3d\x01\0\0\0\0\0\0\x13\xc4\0\0\x18\x02\0\0\x3d\x01\0\0\0\0\0\
\0\x21\xc4\0\0\x20\x02\0\0\x3d\x01\0\0\0\0\0\0\x1d\xc8\0\0\x28\x02\0\0\x3d\x01\
\0\0\0\0\0\0\x26\xc8\0\0\x30\x02\0\0\x3d\x01\0\0\0\0\0\0\x3c\xc8\0\0\x40\x02\0\
\0\x3d\x01\0\0\0\0\0\0\x36\x20\x01\0\x60\x02\0\0\x3d\x01\0\0\0\0\0\0\x09\x20\
\x01\0\x78\x02\0\0\x3d\x01\0\0\0\0\0\0\x01\xa0\x01\0\xab\x01\0\0\x32\0\0\0\0\0\
\0\0\x3d\x01\0\0\0\0\0\0\0\xac\x01\0\x10\0\0\0\x3d\x01\0\0\0\0\0\0\x12\xb0\x01\
\0\x18\0\0\0\x3d\x01\0\0\0\0\0\0\x2a\xb0\x01\0\x20\0\0\0\x3d\x01\0\0\0\0\0\0\
\x32\xb0\x01\0\x28\0\0\0\x3d\x01\0\0\0\0\0\0\x0d\xb0\x01\0\x30\0\0\0\x3d\x01\0\
\0\0\0\0\0\x29\x14\x01\0\x38\0\0\0\x3d\x01\0\0\0\0\0\0\x18\x14\x01\0\x48\0\0\0\
\x3d\x01\0\0\0\0\0\0\x1d\x18\x01\0\x68\0\0\0\x3d\x01\0\0\0\0\0\0\x1d\x24\x01\0\
\x80\0\0\0\x3d\x01\0\0\0\0\0\0\x37\x28\x01\0\x98\0\0\0\x3d\x01\0\0\0\0\0\0\x15\
\x38\x01\0\xa0\0\0\0\x3d\x01\0\0\0\0\0\0\x10\xe8\0\0\xa8\0\0\0\x3d\x01\0\0\0\0\
\0\0\x0d\xe8\0\0\xb0\0\0\0\x3d\x01\0\0\0\0\0\0\0\x44\x01\0\xb8\0\0\0\x3d\x01\0\
\0\0\0\0\0\x2c\xf4\0\0\xc0\0\0\0\x3d\x01\0\0\0\0\0\0\0\x44\x01\0\xc8\0\0\0\x3d\
\x01\0\0\0\0\0\0\0\xf4\0\0\xd0\0\0\0\x3d\x01\0\0\0\0\0\0\x2c\xf4\0\0\xd8\0\0\0\
\x3d\x01\0\0\0\0\0\0\x13\xb0\0\0\xe0\0\0\0\x3d\x01\0\0\0\0\0\0\x2d\xf8\0\0\xf0\
\0\0\0\x3d\x01\0\0\0\0\0\0\x13\xc4\0\0\xf8\0\0\0\x3d\x01\0\0\0\0\0\0\x21\xc4\0\
\0\0\x01\0\0\x3d\x01\0\0\0\0\0\0\x1d\xc8\0\0\x08\x01\0\0\x3d\x01\0\0\0\0\0\0\
\x26\xc8\0\0\x10\x01\0\0\x3d\x01\0\0\0\0\0\0\x3c\xc8\0\0\x20\x01\0\0\x3d\x01\0\
\0\0\0\0\0\x36\x20\x01\0\x40\x01\0\0\x3d\x01\0\0\0\0\0\0\x09\x20\x01\0\x50\x01\
\0\0\x3d\x01\0\0\0\0\0\0\x29\x14\x01\0\x58\x01\0\0\x3d\x01\0\0\0\0\0\0\x18\x14\
\x01\0\x68\x01\0\0\x3d\x01\0\0\0\0\0\0\x1d\x18\x01\0\x88\x01\0\0\x3d\x01\0\0\0\
\0\0\0\x1d\x24\x01\0\xa0\x01\0\0\x3d\x01\0\0\0\0\0\0\x37\x28\x01\0\xb8\x01\0\0\
\x3d\x01\0\0\0\0\0\0\x15\x38\x01\0\xc0\x01\0\0\x3d\x01\0\0\0\0\0\0\x10\xe8\0\0\
\xc8\x01\0\0\x3d\x01\0\0\0\0\0\0\x0d\xe8\0\0\xd0\x01\0\0\x3d\x01\0\0\0\0\0\0\0\
\x44\x01\0\xd8\x01\0\0\x3d\x01\0\0\0\0\0\0\x2c\xf4\0\0\xe0\x01\0\0\x3d\x01\0\0\
\0\0\0\0\0\x44\x01\0\xe8\x01\0\0\x3d\x01\0\0\0\0\0\0\0\xf4\0\0\xf0\x01\0\0\x3d\
\x01\0\0\0\0\0\0\x2c\xf4\0\0\xf8\x01\0\0\x3d\x01\0\0\0\0\0\0\x13\xb0\0\0\0\x02\
\0\0\x3d\x01\0\0\0\0\0\0\x2d\xf8\0\0\x10\x02\0\0\x3d\x01\0\0\0\0\0\0\x13\xc4\0\
\0\x18\x02\0\0\x3d\x01\0\0\0\0\0\0\x21\xc4\0\0\x20\x02\0\0\x3d\x01\0\0\0\0\0\0\
\x1d\xc8\0\0\x28\x02\0\0\x3d\x01\0\0\0\0\0\0\x26\xc8\0\0\x30\x02\0\0\x3d\x01\0\
\0\0\0\0\0\x3c\xc8\0\0\x40\x02\0\0\x3d\x01\0\0\0\0\0\0\x36\x20\x01\0\x60\x02\0\
\0\x3d\x01\0\0\0\0\0\0\x09\x20\x01\0\x78\x02\0\0\x3d\x01\0\0\0\0\0\0\x01\xc0\
\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\x03\0\0\0\
\x20\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x40\0\0\0\0\0\0\0\xb1\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x09\0\0\0\x02\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\xf8\0\0\0\0\0\0\0\xd8\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\x08\0\0\
\0\0\0\0\0\x18\0\0\0\0\0\0\0\x11\0\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\xd0\x01\0\0\0\0\0\0\x90\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\x1e\0\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x60\x04\
\0\0\0\0\0\0\x90\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\x2b\0\0\0\x01\0\0\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xf0\x06\0\0\0\0\0\0\
\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x33\0\0\0\
\x01\0\0\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xf8\x06\0\0\0\0\0\0\x30\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x81\0\0\0\x09\0\0\0\x40\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x28\x07\0\0\0\0\0\0\x20\0\0\0\0\0\0\0\x02\0\0\0\
\x03\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x92\0\0\0\x09\0\0\0\x40\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\x48\x07\0\0\0\0\0\0\x20\0\0\0\0\0\0\0\x02\0\0\0\x04\0\0\
\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\xa3\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\x68\x07\0\0\0\0\0\0\x68\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\xa8\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\xd0\x0b\0\0\0\0\0\0\x98\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0";

	*sz = sizeof(data) - 1;
	return (const void *)data;
}

#ifdef __cplusplus
struct socket_bind_bpf *socket_bind_bpf::open(const struct bpf_object_open_opts *opts) { return socket_bind_bpf__open_opts(opts); }
struct socket_bind_bpf *socket_bind_bpf::open_and_load() { return socket_bind_bpf__open_and_load(); }
int socket_bind_bpf::load(struct socket_bind_bpf *skel) { return socket_bind_bpf__load(skel); }
int socket_bind_bpf::attach(struct socket_bind_bpf *skel) { return socket_bind_bpf__attach(skel); }
void socket_bind_bpf::detach(struct socket_bind_bpf *skel) { socket_bind_bpf__detach(skel); }
void socket_bind_bpf::destroy(struct socket_bind_bpf *skel) { socket_bind_bpf__destroy(skel); }
const void *socket_bind_bpf::elf_bytes(size_t *sz) { return socket_bind_bpf__elf_bytes(sz); }
#endif /* __cplusplus */

__attribute__((unused)) static void
socket_bind_bpf__assert(struct socket_bind_bpf *s __attribute__((unused)))
{
#ifdef __cplusplus
#define _Static_assert static_assert
#endif
#ifdef __cplusplus
#undef _Static_assert
#endif
}

#endif /* __SOCKET_BIND_BPF_SKEL_H__ */
