/*
 * Decompiled with CFR 0.152.
 */
package iaik.tsp;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.BOOLEAN;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.GeneralizedTime;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.ChoiceOfTime;
import iaik.asn1.structures.GeneralName;
import iaik.cms.CMSParsingException;
import iaik.cms.Content;
import iaik.tsp.Accuracy;
import iaik.tsp.MessageImprint;
import iaik.x509.X509ExtensionException;
import iaik.x509.X509Extensions;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Date;

public class TSTInfo
implements Content {
    private boolean g = false;
    private X509Extensions j;
    private GeneralName i;
    private BigInteger e;
    private boolean d = false;
    private Accuracy k;
    private ChoiceOfTime h;
    private BigInteger b;
    private MessageImprint f;
    private ObjectID c;
    private int a = 1;
    private static final boolean v = true;
    private static final int u = 1;
    private static final boolean n = false;
    private static final int m = 0;
    private static final int t = 4;
    private static final int o = 3;
    private static final int s = 2;
    private static final int p = 1;
    private static final int l = 0;
    private static final int r = 10;
    private static final int q = 5;
    public static final ObjectID ID_CT_TSTINFO = new ObjectID("1.2.840.113549.1.9.16.1.4", "id-ct-TSTInfo");

    private void a(ASN1Object aSN1Object) throws CodingException {
        int n;
        if (!aSN1Object.isA(ASN.SEQUENCE)) {
            throw new CodingException("No TSTInfo!");
        }
        SEQUENCE sEQUENCE = (SEQUENCE)aSN1Object;
        if (sEQUENCE.countComponents() < 5) {
            throw new CodingException("Too few elements.");
        }
        if (sEQUENCE.countComponents() > 10) {
            throw new CodingException("Too many elements.");
        }
        if (sEQUENCE.getComponentAt(0).isA(ASN.INTEGER)) {
            n = ((BigInteger)((INTEGER)sEQUENCE.getComponentAt(0)).getValue()).intValue();
            if (this.a != n) {
                throw new CodingException("Version " + String.valueOf(sEQUENCE.getComponentAt(0)) + " not provided");
            }
        } else {
            throw new CodingException("No TSTInfo!");
        }
        try {
            CON_SPEC cON_SPEC;
            this.c = (ObjectID)sEQUENCE.getComponentAt(1);
            this.f = new MessageImprint(sEQUENCE.getComponentAt(2));
            if (!sEQUENCE.getComponentAt(3).isA(ASN.INTEGER)) {
                throw new CodingException("No serialNumber found!");
            }
            this.b = (BigInteger)((INTEGER)sEQUENCE.getComponentAt(3)).getValue();
            if (!sEQUENCE.getComponentAt(4).isA(ASN.GeneralizedTime)) {
                throw new CodingException("No genTime found!");
            }
            this.h = new ChoiceOfTime((ASN1Object)((GeneralizedTime)sEQUENCE.getComponentAt(4)));
            n = 5;
            if (n == sEQUENCE.countComponents()) {
                return;
            }
            if (sEQUENCE.getComponentAt(n).isA(ASN.SEQUENCE)) {
                this.k = new Accuracy(sEQUENCE.getComponentAt(n));
                if (++n == sEQUENCE.countComponents()) {
                    return;
                }
            }
            if (sEQUENCE.getComponentAt(n).isA(ASN.BOOLEAN)) {
                this.d = (Boolean)((BOOLEAN)sEQUENCE.getComponentAt(n)).getValue();
                if (++n == sEQUENCE.countComponents()) {
                    return;
                }
            }
            if (sEQUENCE.getComponentAt(n).isA(ASN.INTEGER)) {
                this.e = (BigInteger)((INTEGER)sEQUENCE.getComponentAt(n)).getValue();
                this.g = true;
                if (++n == sEQUENCE.countComponents()) {
                    return;
                }
            }
            if (sEQUENCE.getComponentAt(n).isA(ASN.CON_SPEC) && (cON_SPEC = (CON_SPEC)sEQUENCE.getComponentAt(n)).getAsnType().getTag() == 0) {
                ASN1Object aSN1Object2 = (ASN1Object)cON_SPEC.getValue();
                this.i = new GeneralName(aSN1Object2);
                if (++n == sEQUENCE.countComponents()) {
                    return;
                }
            }
            if (sEQUENCE.getComponentAt(n).isA(ASN.CON_SPEC)) {
                cON_SPEC = (CON_SPEC)sEQUENCE.getComponentAt(n);
                cON_SPEC.forceImplicitlyTagged(ASN.SEQUENCE);
                if (cON_SPEC.getAsnType().getTag() != 1) {
                    throw new CodingException("Wrong extensions tag " + String.valueOf(cON_SPEC.getAsnType().getTag()));
                }
                this.j = new X509Extensions((ASN1Object)cON_SPEC.getValue());
                ++n;
            }
            if (n != sEQUENCE.countComponents()) {
                new CodingException("No TimeStampReq!");
                return;
            }
        }
        catch (X509ExtensionException x509ExtensionException) {
            throw new CodingException(x509ExtensionException.getMessage());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<TSTInfo>\n");
        stringBuffer.append("<Version>\n");
        stringBuffer.append("\t" + String.valueOf(this.a) + "\n");
        stringBuffer.append("</Version>\n");
        stringBuffer.append("<Policy>\n");
        stringBuffer.append("\t" + this.c.toString() + "\n");
        stringBuffer.append("</Policy>\n");
        stringBuffer.append(String.valueOf(this.f.toString()) + "\n");
        stringBuffer.append("<SerialNumber (low-order 64 bits)>\n");
        stringBuffer.append("\t" + String.valueOf(this.b.longValue()) + "\n");
        stringBuffer.append("</SerialNumber>\n");
        stringBuffer.append("<GenTime>\n");
        stringBuffer.append("\t" + this.h + "\n");
        stringBuffer.append("</GenTime>\n");
        if (this.k instanceof Accuracy) {
            stringBuffer.append(String.valueOf(this.k.toString()) + "\n");
        }
        stringBuffer.append("<Ordering>\n");
        stringBuffer.append("\t" + String.valueOf(this.d) + "\n");
        stringBuffer.append("</Ordering>\n");
        if (this.g) {
            stringBuffer.append("<nonce (low-order 64 bits)>\n");
            stringBuffer.append("\t" + String.valueOf(this.e.longValue()) + "\n");
            stringBuffer.append("</nonce>\n");
        }
        if (this.i != null) {
            stringBuffer.append("<tsa>\n");
            stringBuffer.append("\t" + this.i.toString() + "\n");
            stringBuffer.append("</tsa>\n");
        }
        if (this.j instanceof X509Extensions) {
            stringBuffer.append("<tsa>\n");
            stringBuffer.append("\t" + this.j.toString() + "\n");
            stringBuffer.append("</tsa>\n");
        }
        stringBuffer.append("</TSTInfo>");
        return stringBuffer.toString();
    }

    public String toString(boolean bl) {
        if (bl) {
            return this.toString();
        }
        return "TSTInfo";
    }

    public X509Extensions getExtensions() {
        return this.j;
    }

    public GeneralName getTsa() {
        return this.i;
    }

    public BigInteger getNonce() {
        return this.e;
    }

    public boolean getOrdering() {
        return this.d;
    }

    public Accuracy getAccuracy() {
        return this.k;
    }

    public Date getGenTime() {
        return this.h.getDate();
    }

    public BigInteger getSerialNumber() {
        return this.b;
    }

    public MessageImprint getMessageImprint() {
        return this.f;
    }

    public ObjectID getTSAPolicyID() {
        return this.c;
    }

    public int getVersion() {
        return this.a;
    }

    public ObjectID getContentType() {
        return ID_CT_TSTINFO;
    }

    public void setExtensions(X509Extensions x509Extensions) throws NullPointerException {
        if (x509Extensions != null) {
            this.j = x509Extensions;
            return;
        }
        throw new NullPointerException("Argument \"extensions\" must not be null");
    }

    public void setTsa(GeneralName generalName) throws IllegalArgumentException {
        if (generalName != null) {
            this.i = generalName;
            return;
        }
        throw new NullPointerException("Argument \"genName\" must noat be null");
    }

    public void setNonce(BigInteger bigInteger) throws NullPointerException {
        if (bigInteger != null) {
            this.e = bigInteger;
            this.g = true;
            return;
        }
        throw new NullPointerException("Argument \"nonce\" must not be null");
    }

    public void setOrdering(boolean bl) {
        this.d = bl;
    }

    public void setAccuracy(Accuracy accuracy) throws NullPointerException {
        if (accuracy != null) {
            this.k = accuracy;
            return;
        }
        throw new NullPointerException("Argument \"accuracy\" must not be null");
    }

    public void setGenTime(Date date) throws NullPointerException {
        if (date != null) {
            this.h = new ChoiceOfTime(date);
            return;
        }
        throw new NullPointerException("Argument \"get_time\" must not be null");
    }

    public void setSerialNumber(BigInteger bigInteger) throws NullPointerException {
        if (bigInteger != null) {
            this.b = bigInteger;
            return;
        }
        throw new NullPointerException("Argument \"serial_number\" must not be null");
    }

    public void setMessageImprint(MessageImprint messageImprint) throws NullPointerException {
        if (messageImprint != null) {
            this.f = messageImprint;
            return;
        }
        throw new NullPointerException("Argument \" message_imprint\" must not be null");
    }

    public void setTSAPolicyID(ObjectID objectID) throws NullPointerException {
        if (objectID != null) {
            this.c = objectID;
            return;
        }
        throw new NullPointerException("Argument \"policy\" must not be null");
    }

    public void setBlockSize(int n) {
    }

    public int getBlockSize() {
        return 0;
    }

    public ASN1Object toASN1Object() {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent((ASN1Object)new INTEGER(this.a));
        sEQUENCE.addComponent((ASN1Object)this.c);
        sEQUENCE.addComponent(this.f.toASN1Object());
        sEQUENCE.addComponent((ASN1Object)new INTEGER(this.b));
        this.h.setEncodingType(ASN.GeneralizedTime);
        sEQUENCE.addComponent(this.h.toASN1Object());
        if (this.k != null) {
            sEQUENCE.addComponent(this.k.toASN1Object());
        }
        if (this.d) {
            sEQUENCE.addComponent((ASN1Object)new BOOLEAN(this.d));
        }
        if (this.g) {
            sEQUENCE.addComponent((ASN1Object)new INTEGER(this.e));
        }
        try {
            if (this.i != null) {
                sEQUENCE.addComponent((ASN1Object)new CON_SPEC(0, this.i.toASN1Object(), false));
            }
        }
        catch (CodingException codingException) {
            codingException.printStackTrace();
            throw new InternalError("Exception where no exception can be");
        }
        try {
            if (this.j != null) {
                sEQUENCE.addComponent((ASN1Object)new CON_SPEC(1, this.j.toASN1Object(), true));
            }
        }
        catch (X509ExtensionException x509ExtensionException) {
            x509ExtensionException.printStackTrace();
            throw new InternalError("Exception where no exception can be");
        }
        return sEQUENCE;
    }

    public byte[] getEncoded() {
        return DerCoder.encode((ASN1Object)this.toASN1Object());
    }

    public void decode(byte[] byArray) throws CodingException, CMSParsingException {
        this.decode(DerCoder.decode((byte[])byArray));
    }

    public void decode(ASN1Object aSN1Object) throws CMSParsingException {
        try {
            this.a(aSN1Object);
            return;
        }
        catch (CodingException codingException) {
            throw new CMSParsingException(codingException.getMessage());
        }
    }

    public void decode(InputStream inputStream) throws CMSParsingException, IOException {
        try {
            this.a(DerCoder.decode((InputStream)inputStream));
            return;
        }
        catch (CodingException codingException) {
            throw new CMSParsingException(codingException.getMessage());
        }
    }

    public TSTInfo(ASN1Object aSN1Object) throws CodingException {
        this.a(aSN1Object);
    }

    public TSTInfo(ObjectID objectID, MessageImprint messageImprint, BigInteger bigInteger, Date date) throws NullPointerException {
        if (objectID != null && messageImprint != null && bigInteger != null && date != null) {
            this.c = objectID;
            this.f = messageImprint;
            this.b = bigInteger;
            this.h = new ChoiceOfTime(date);
            return;
        }
        throw new NullPointerException("All parameters must be set!");
    }

    public TSTInfo() {
    }
}

