/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.messaging.saaj.util;

import com.sun.xml.internal.messaging.saaj.util.ByteInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class ByteOutputStream
extends OutputStream {
    protected byte[] buf;
    protected int count = 0;

    public ByteOutputStream() {
        this(1024);
    }

    public ByteOutputStream(int n) {
        this.buf = new byte[n];
    }

    public void write(InputStream inputStream) throws IOException {
        if (inputStream instanceof ByteArrayInputStream) {
            int n = inputStream.available();
            this.ensureCapacity(n);
            this.count += inputStream.read(this.buf, this.count, n);
            return;
        }
        int n;
        int n2;
        while ((n2 = inputStream.read(this.buf, this.count, n = this.buf.length - this.count)) >= 0) {
            this.count += n2;
            if (n != n2) continue;
            this.ensureCapacity(this.count);
        }
        return;
    }

    @Override
    public void write(int n) {
        this.ensureCapacity(1);
        this.buf[this.count] = (byte)n;
        ++this.count;
    }

    private void ensureCapacity(int n) {
        int n2 = n + this.count;
        if (n2 > this.buf.length) {
            byte[] byArray = new byte[Math.max(this.buf.length << 1, n2)];
            System.arraycopy(this.buf, 0, byArray, 0, this.count);
            this.buf = byArray;
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        this.ensureCapacity(n2);
        System.arraycopy(byArray, n, this.buf, this.count, n2);
        this.count += n2;
    }

    @Override
    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    public void writeAsAscii(String string) {
        int n = string.length();
        this.ensureCapacity(n);
        int n2 = this.count;
        for (int i = 0; i < n; ++i) {
            this.buf[n2++] = (byte)string.charAt(i);
        }
        this.count = n2;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.buf, 0, this.count);
    }

    public void reset() {
        this.count = 0;
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.count];
        System.arraycopy(this.buf, 0, byArray, 0, this.count);
        return byArray;
    }

    public int size() {
        return this.count;
    }

    public ByteInputStream newInputStream() {
        return new ByteInputStream(this.buf, this.count);
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    @Override
    public void close() {
    }

    public byte[] getBytes() {
        return this.buf;
    }

    public int getCount() {
        return this.count;
    }
}

