/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.ocsp.extensions;

import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.x509.V3Extension;
import iaik.x509.X509ExtensionException;

public class AcceptableResponses
extends V3Extension {
    private ObjectID[] a;
    public static final ObjectID oid = new ObjectID("1.3.6.1.5.5.7.48.1.4", "AcceptableResponses");

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("acceptable responses: {");
        if (this.a != null) {
            int n2 = 0;
            while (n2 < this.a.length) {
                stringBuffer.append("\n  " + this.a[n2].getName());
                ++n2;
            }
        }
        stringBuffer.append("\n}");
        return stringBuffer.toString();
    }

    public ASN1Object toASN1Object() {
        SEQUENCE sEQUENCE = new SEQUENCE();
        if (this.a != null) {
            int n2 = 0;
            while (n2 < this.a.length) {
                sEQUENCE.addComponent(this.a[n2]);
                ++n2;
            }
        }
        return sEQUENCE;
    }

    public void setAcceptableResponseTypes(ObjectID[] objectIDArray) {
        this.a = objectIDArray;
    }

    public boolean isResponseTypeAcceptable(ObjectID objectID) {
        if (this.a == null) {
            return true;
        }
        int n2 = 0;
        while (n2 < this.a.length) {
            if (this.a.equals(objectID)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void init(ASN1Object aSN1Object) throws X509ExtensionException {
        try {
            int n2 = aSN1Object.countComponents();
            this.a = new ObjectID[n2];
            int n3 = 0;
            while (n3 < n2) {
                this.a[n3] = (ObjectID)aSN1Object.getComponentAt(n3);
                ++n3;
            }
            return;
        }
        catch (CodingException codingException) {
            throw new X509ExtensionException(codingException.getMessage());
        }
    }

    public int hashCode() {
        return oid.hashCode();
    }

    public ObjectID getObjectID() {
        return oid;
    }

    public ObjectID[] getAcceptableResponseTypes() {
        return this.a;
    }

    public AcceptableResponses(ObjectID[] objectIDArray) {
        this.a = objectIDArray;
    }

    public AcceptableResponses() {
    }
}

