/*
 * Decompiled with CFR 0.152.
 */
package finanze.IDTE.generale2003;

import finanze.IDTE.generale2003.BaseTelem;
import finanze.IDTE.generale2003.ComuniProvincia;
import finanze.IDTE.generale2003.DataSogei;
import finanze.IDTE.generale2003.Diagnostici;
import finanze.IDTE.generale2003.Dichiarazione;
import finanze.IDTE.generale2003.MainGen;
import finanze.IDTE.generale2003.Modello;
import finanze.IDTE.generale2003.Util;
import finanze.IDTE.mod770.Modello77003;
import finanze.IDTE.modIVA.ModelloIVA03;
import finanze.IDTE.resources.RecordParser;

public abstract class Liquidatore
extends Modello {
    protected String flagsTelem = "";
    protected boolean banchePoste = false;
    protected int tipoFornitore = 0;
    protected static final int CODGRAV = 16;
    protected static int CODWARNING = 4;
    protected int codGravDatiIncoerenti;
    protected int codGravConferma;
    protected String codFiscDichiarante = "";
    public static final int CTR_B_INDEX = 0;
    public static final int CTR_RECVAR_INDEX = 1;
    public static final int CTR_F_INDEX = 2;
    public static final int CTR_G_INDEX = 3;
    public static final int CTR_H_INDEX = 4;
    public static final int CTR_C_INDEX = 1;
    public static final int CTR_D_INDEX = 2;
    public static final int CTR_E_INDEX = 3;
    public static final int CTR_I_INDEX = 7;
    public static final int CTR_Q_INDEX = 15;
    public static final int CTR_R_INDEX = 16;
    public static final int CTR_S_INDEX = 17;
    public static final int CTR_T_INDEX = 18;
    public static final int CTR_U_INDEX = 19;
    public static final int CTR_X_INDEX = 22;

    protected Liquidatore() {
        this(null, new Dichiarazione());
    }

    protected Liquidatore(RecordParser recordParser, Dichiarazione dichiarazione) {
        this.recordB = recordParser;
        this.dich = dichiarazione;
        String string = this.getClass().getName();
        this.TIPO_MODELLO = string.substring(string.length() - 5, string.length() - 2);
        this.ANNO = string.substring(string.length() - 2);
        System.out.println("La versione della Liquidazione: " + this.getVersione());
    }

    public static String[] controlloProtocolloBanchePoste(String string, String string2, double d, String string3, int n, int n2, int n3, int n4) {
        String[] stringArray = new String[]{"0", "0", "0", "0", "0"};
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        String string9 = "";
        String string10 = "";
        if (string.trim().length() == 25) {
            string4 = string.substring(0, 5);
            string5 = string.substring(5, 10);
            string6 = string.substring(10, 13);
            string7 = string.substring(13, 21);
            string8 = string.substring(21, 25);
            if (n != 8) {
                stringArray[0] = "1070";
            }
            if (!Util.isNumericoAssoluto(string4) || string4.equals("00000")) {
                stringArray[0] = "1070";
            }
            if (!Util.isNumericoAssoluto(string5) || string5.equals("00000")) {
                stringArray[0] = "1070";
            }
            if (!(string6.equals("UNI") || string6.equals("SCE") || string6.equals("SCS") || string6.equals("IVA") || string6.equals("730") || string6.equals("U50") || string6.equals("U60") || string6.equals("U61") || string6.equals("770") || string6.equals("77S"))) {
                stringArray[0] = "1070";
            }
            if (!string6.equals(string3.substring(0, 3))) {
                stringArray[1] = "1071";
            }
            if (!string6.equals(string3.substring(0, 3)) && n2 != 1) {
                stringArray[0] = "1070";
            }
            if (!Util.isNumericoAssoluto(string7) || !Util.controlloData(string7) || string7.equals("00000000")) {
                stringArray[0] = "1070";
            } else if (Util.valoreDouble(string7.substring(4, 8)) != (double)n4 && Util.valoreDouble(string7.substring(4, 8)) != (double)(n4 - 1) && Util.valoreDouble(string7.substring(4, 8)) != (double)(n4 + 1) && Util.valoreDouble(string7.substring(4, 8)) != (double)(n4 + 2) && Util.valoreDouble(string7.substring(4, 8)) != (double)(n4 + 3) && Util.valoreDouble(string7.substring(4, 8)) != (double)(n4 + 4)) {
                stringArray[0] = "1070";
            }
            if (!Util.isNumericoAssoluto(string8)) {
                stringArray[0] = "1070";
            }
        } else if (string.trim().length() == 18) {
            string10 = string.substring(0, 5);
            string8 = string.substring(5, 10);
            string9 = string.substring(10, 18);
            if (n != 7) {
                stringArray[0] = "1070";
            }
            if (!Util.isNumericoAssoluto(string10) || string10.equals("00000")) {
                stringArray[0] = "1070";
            }
            if (!Util.isNumericoAssoluto(string8)) {
                stringArray[0] = "1070";
            }
            if (!Util.isNumericoAssoluto(string9) || !Util.controlloData(string9) || string9.equals("00000000")) {
                stringArray[0] = "1070";
            } else if (Util.valoreDouble(string9.substring(4, 8)) != (double)n4 && Util.valoreDouble(string9.substring(4, 8)) != (double)(n4 - 1) && Util.valoreDouble(string9.substring(4, 8)) != (double)(n4 + 1) && Util.valoreDouble(string9.substring(4, 8)) != (double)(n4 + 2) && Util.valoreDouble(string9.substring(4, 8)) != (double)(n4 + 3) && Util.valoreDouble(string9.substring(4, 8)) != (double)(n4 + 4)) {
                stringArray[0] = "1070";
            }
        } else {
            stringArray[0] = "1070";
        }
        string2 = string2.replace(' ', '0');
        if (string2.equals("0000000")) {
            stringArray[2] = "1072";
        }
        if (n == 7 && (Util.valoreDouble(string2.substring(0, 2)) == 0.0 || Util.valoreDouble(string2.substring(0, 2)) > 12.0)) {
            stringArray[2] = "1072";
        }
        if (d == 0.0 || d > 100.0) {
            stringArray[3] = "1073";
        }
        if (n == 8 && n3 == 0) {
            stringArray[4] = "1095";
        }
        return stringArray;
    }

    public static boolean controlloProtocolloTelematico(String string, String string2, String string3) {
        boolean bl = true;
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        boolean bl2 = false;
        if (string.trim().length() == 17) {
            if (string.equals("00000000000000000")) {
                bl2 = true;
            } else {
                string4 = String.valueOf(string.substring(4, 6)) + string.substring(2, 4) + "20" + string.substring(0, 2);
                string5 = string.substring(6, 8);
                string6 = string.substring(8, 10);
                string7 = string.substring(10, 12);
                string8 = string.substring(12, 17);
                if (!Util.isNumericoAssoluto(string4) || string4.equals("00000000") || string4.equals("0000" + string3) || !Util.controlloData(string4)) {
                    bl = false;
                } else if (!Util.isNumericoAssoluto(string5) || Util.valoreDouble(string5) > 47.0) {
                    bl = false;
                } else if (!Util.isNumericoAssoluto(string6) || Util.valoreDouble(string6) > 59.0) {
                    bl = false;
                } else if (!Util.isNumericoAssoluto(string7) || Util.valoreDouble(string7) > 59.0) {
                    bl = false;
                } else if (!Util.isNumericoAssoluto(string8) || Util.valoreDouble(string8) == 0.0) {
                    bl = false;
                }
            }
        } else if (string.trim().length() == 0) {
            bl2 = true;
        } else {
            bl = false;
        }
        if (string2.trim().length() == 6) {
            if (!Util.isNumericoAssoluto(string2) || string2.equals("000000") && !bl2) {
                bl = false;
            }
        } else if (string2.trim().length() == 0) {
            if (!bl2) {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean getBanchePoste() {
        return this.banchePoste;
    }

    public String getCodFiscDichiarante() {
        return this.codFiscDichiarante;
    }

    public int getCodGravConferma() {
        return this.codGravConferma;
    }

    public int getCodGravDatiIncoerenti() {
        return this.codGravDatiIncoerenti;
    }

    public int getTipoFornitore() {
        return this.tipoFornitore;
    }

    public abstract String getVersione();

    private int liquidaQuadriCompilati(ModelloIVA03 modelloIVA03, Modello77003 modello77003, boolean bl, boolean bl2) {
        int n;
        String[] stringArray;
        boolean bl3;
        int n2 = 0;
        String string = "";
        this.codFiscDichiarante = this.BS(2).trim();
        Dichiarazione dichiarazione = null;
        boolean bl4 = bl3 = modelloIVA03 != null && modello77003 != null;
        if (!this.TIPO_MODELLO.equals("IVA") && !this.TIPO_MODELLO.equals("77S")) {
            stringArray = new String[]{"SF", "SG", "SH", "SI", "SK", "SL", "SM", "SO", "SP", "SQ", "SR", "ST", "SX"};
            string = "";
            if (bl3) {
                dichiarazione = modello77003.getDichiarazione();
            } else if (this.TIPO_MODELLO.equals("770")) {
                dichiarazione = this.getDichiarazione();
            }
            if (this.AI(29) == 0 && this.AI(30) == 0 || this.AI(29) == 1) {
                n = 160;
                while (n <= 172) {
                    string = "XXX" + Util.formNum(2, n - 100);
                    if (this.BI(n) != 1 && dichiarazione.esisteQuadro(stringArray[n - 160])) {
                        n2 = Diagnostici.DIA(n2, CODWARNING, this.codFiscDichiarante, "1322", string, (double)this.BI(n), "1");
                    }
                    if (this.BI(n) == 1 && !dichiarazione.esisteQuadro(stringArray[n - 160])) {
                        n2 = Diagnostici.DIA(n2, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1321", string, (double)this.BI(n), "");
                    }
                    ++n;
                }
            }
        }
        if (bl3) {
            stringArray = new String[]{"RA", "RB", "RC", "RD", "RE", "RF", "RG", "RH", "RI", "RJ", "RK", "RL", "RM", "RN", "RO", "RP", "RQ", "RR", "RS", "RT", "RU", "RV", "RX", "RY", "RZ", "FA", "FC", "CR"};
            string = "";
            if (this.AI(29) == 0 && this.AI(30) == 0 || this.AI(29) == 1) {
                n = 132;
                while (n <= 159) {
                    string = "XXX" + Util.formNum(2, n - 100);
                    if (this.BI(n) != 1 && this.dich.esisteQuadro(stringArray[n - 132])) {
                        n2 = Diagnostici.DIA(n2, CODWARNING, this.codFiscDichiarante, "1322", string, (double)this.BI(n), "1");
                    }
                    if (this.BI(n) == 1 && !this.dich.esisteQuadro(stringArray[n - 132])) {
                        n2 = Diagnostici.DIA(n2, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1321", string, (double)this.BI(n), "");
                    }
                    ++n;
                }
            }
            n = 0;
            int n3 = 0;
            while (n3 < stringArray.length) {
                if (this.dich.esisteQuadro(stringArray[n3])) {
                    n = 1;
                    break;
                }
                ++n3;
            }
            if (this.BI(13) == 1 && n == 0) {
                n2 = Diagnostici.DIA(n2, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1329", "XXB13", (double)this.BI(13), "");
            } else if (n != 0 && !stringArray[n3].equals("RX") && this.BI(13) != 1) {
                n2 = Diagnostici.DIA(n2, CODWARNING, this.codFiscDichiarante, "1019", "XXB13", (double)this.BI(13), 1.0);
            }
            int n4 = n = this.dich.esisteQuadro("IQ") || this.dich.esisteQuadro("IP") || this.dich.esisteQuadro("IC") || this.dich.esisteQuadro("IE") || this.dich.esisteQuadro("IK") ? 1 : 0;
            if (this.AI(29) == 0 && this.AI(30) == 0) {
                if (this.BI(14) == 1 && n == 0) {
                    n2 = Diagnostici.DIA(n2, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1329", "XXB14", (double)this.BI(14), "");
                } else if (n != 0 && this.BI(14) != 1) {
                    n2 = Diagnostici.DIA(n2, CODWARNING, this.codFiscDichiarante, "1019", "XXB14", (double)this.BI(14), 1.0);
                }
            }
            long l = new DataSogei("01012002").getGiulianoAnno() - new DataSogei(this.BS(79)).getGiulianoAnno();
            int n5 = new Long(l).intValue();
            if (this.BI(15) == 1 && this.TIPO_MODELLO.equals("UNI") && !modelloIVA03.getDichiarazione().esisteModulo("00000001")) {
                n2 = Diagnostici.DIA(n2, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1329", "XXB15", (double)this.BI(15), "");
            }
            if (this.BI(15) == 1 && modelloIVA03 != null && !this.TIPO_MODELLO.equals("UNI")) {
                if (!modelloIVA03.getDichiarazione().esisteModulo("00000001")) {
                    n2 = Diagnostici.DIA(n2, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1329", "XXB15", (double)this.BI(15), "");
                } else if (this.BL(79) != 0L && !this.BS(79).equals("31122002") || this.BL(78) != 0L && n5 > 0 || this.BI(101) == 3 || this.BI(101) == 4) {
                    n2 = Diagnostici.DIA(n2, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1343", "XXB15", (double)this.BI(15), "");
                }
            }
            if (this.BI(16) == 1 && modello77003 != null && !modello77003.getDichiarazione().esisteModulo("00000001")) {
                n2 = Diagnostici.DIA(n2, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1329", "XXB16", (double)this.BI(16), "");
            } else if (modello77003 != null && modello77003.getDichiarazione().esisteModulo("00000001") && this.BI(16) != 1) {
                n2 = Diagnostici.DIA(n2, CODWARNING, this.codFiscDichiarante, "1019", "XXB16", (double)this.BI(16), 1.0);
            }
            if (this.TIPO_MODELLO.equals("UNI") || this.TIPO_MODELLO.equals("U50") || this.TIPO_MODELLO.equals("U61")) {
                if (this.BI(17) == 1 && !this.dich.esisteQuadro("RW")) {
                    n2 = Diagnostici.DIA(n2, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1329", "XXB17", (double)this.BI(17), "");
                } else if (this.BI(17) != 1 && this.dich.esisteQuadro("RW")) {
                    n2 = Diagnostici.DIA(n2, CODWARNING, this.codFiscDichiarante, "1019", "XXB17", (double)this.BI(17), 1.0);
                }
            }
            if (this.BI(18) == 1 && !bl) {
                n2 = Diagnostici.DIA(n2, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1329", "XXB18", (double)this.BI(18), "");
            } else if (bl && this.BI(18) == 0) {
                n2 = Diagnostici.DIA(n2, CODWARNING, this.codFiscDichiarante, "1019", "XXB18", (double)this.BI(18), "1");
            }
            if (this.BI(19) == 1 && !bl2) {
                n2 = Diagnostici.DIA(n2, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1329", "XXB19", (double)this.BI(19), "");
            } else if (bl2 && this.BI(19) == 0) {
                n2 = Diagnostici.DIA(n2, CODWARNING, this.codFiscDichiarante, "1019", "XXB19", (double)this.BI(19), "1");
            }
            if (this.BI(20) == 1 && !this.dich.esisteQuadro("AC")) {
                n2 = Diagnostici.DIA(n2, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1329", "XXB20", (double)this.BI(20), "");
            } else if (this.dich.esisteQuadro("AC") && this.BI(20) != 1) {
                n2 = Diagnostici.DIA(n2, CODWARNING, this.codFiscDichiarante, "1019", "XXB20", (double)this.BI(20), 1.0);
            }
            if (this.BI(21) == 1 && !modelloIVA03.getDichiarazione().esisteQuadro("VO")) {
                n2 = Diagnostici.DIA(n2, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1329", "XXB21", (double)this.BI(21), "");
            }
            if (this.BI(15) == 1 && this.BI(21) == 1) {
                n2 = Diagnostici.DIA(n2, CODWARNING, this.codFiscDichiarante, "1501", "XXB21", (double)this.BI(21), "");
            }
        }
        return n2;
    }

    public int liquidaTRecA() {
        int n = 0;
        String string = BaseTelem.currentSystem == 2 ? this.AS(5) : "AAAAAAAAAAAAAAAA";
        String string2 = this.AS(16).trim().length() != 0 ? this.AS(16) : String.valueOf(this.AS(6)) + " " + this.AS(7);
        if (this.AI(29) > this.AI(30) || this.AI(29) == 0 && this.AI(30) > 0 || this.AI(29) == 1 && this.AI(30) == 1) {
            MainGen.fornituraCorretta = false;
            n = Diagnostici.DIA(n, 24, string, "1047", "XXA", "", "");
        }
        return n;
    }

    public int liquidaTRecB() {
        return this.liquidaTRecB(null, null, false, false);
    }

    public int liquidaTRecB(ModelloIVA03 modelloIVA03, Modello77003 modello77003, boolean bl, boolean bl2) {
        boolean bl3;
        int n = 0;
        this.codGravDatiIncoerenti = this.banchePoste && this.BI(192) == 1 ? 4 : 16;
        this.codGravConferma = this.flagConferma ? 8 : 14;
        this.codFiscDichiarante = this.BS(2).trim();
        boolean bl4 = bl3 = modelloIVA03 != null && modello77003 != null;
        if (bl3) {
            modelloIVA03.tipo_ModUnico = this.TIPO_MODELLO;
        }
        if (this.TIPO_MODELLO.equals("UNI")) {
            modelloIVA03.part_Iva = Util.isNumericoAssoluto(this.BS(28).trim()) ? this.BS(28) : "00000000000";
        }
        n = Util.aggRc(n, this.liquidaTRecBProtocollo());
        if ((this.TIPO_MODELLO.equals("770") || this.TIPO_MODELLO.equals("77S")) && (this.AI(4) == 7 || this.AI(4) == 8)) {
            return n;
        }
        if (this.TIPO_MODELLO.equals("77S")) {
            if (this.BL(217) != 0L && this.BL(218) != 0L && !Liquidatore.controlloProtocolloTelematico(this.BS(217), this.BS(218), "2003")) {
                n = Diagnostici.DIA(n, 16, this.codFiscDichiarante, "1068", "XXY17", "", "");
            }
            if (this.BL(217) != 0L && this.BL(218) == 0L) {
                n = Diagnostici.DIA(n, 16, this.codFiscDichiarante, "1016", "XXY18", "", "");
            }
            if (this.BL(217) == 0L && this.BL(218) != 0L) {
                n = Diagnostici.DIA(n, 16, this.codFiscDichiarante, "1016", "XXY19", "", "");
            }
            if (this.BL(217) != 0L && this.BL(218) != 0L && this.BI(9) == 0 && this.BI(10) == 0) {
                n = Diagnostici.DIA(n, 16, this.codFiscDichiarante, "6130", "XXB", "", "");
            }
        }
        if (this.BI(9) != 0 && this.BI(10) != 0) {
            n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1314", "XXB", "", "");
        }
        n = Util.aggRc(n, this.liquidaTRecBTipoFornitore());
        int n2 = n = this.TIPO_MODELLO.equals("UNI") && this.BL(101) == 2L ? Util.aggRc(n, this.liquidaTRecBAnagraficaEreditaGiacente()) : Util.aggRc(n, this.liquidaTRecBCF());
        if ((this.TIPO_MODELLO.equals("770") || this.TIPO_MODELLO.equals("77S")) && Util.esisteAlmenoUnCampo(this.recordB, 38, 50) && (Util.esisteAlmenoUnCampo(this.recordB, 68, 77) || Util.esisteAlmenoUnCampo(this.recordB, 82, 84) || this.BL(93) != 0L)) {
            n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1316", "XXB", "", "");
        }
        if (!this.TIPO_MODELLO.equals("UNI") || this.BL(101) != 2L) {
            n = Util.aggRc(n, this.liquidaTRecBAnagrafica(modelloIVA03, modello77003));
        }
        if (!this.TIPO_MODELLO.equals("UNI") && !this.TIPO_MODELLO.equals("IVA")) {
            n = Util.aggRc(n, this.liquidaTRecBDatiSocieta());
        }
        if ((this.TIPO_MODELLO.equals("770") || this.TIPO_MODELLO.equals("77S")) && Util.esisteAlmenoUnCampo(this.recordB, 68, 77) && !Util.esisteAlmenoUnCampo(this.recordB, 98, 114)) {
            n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1318", "XXB", "", "");
        }
        if ((this.TIPO_MODELLO.equals("UNI") || this.TIPO_MODELLO.equals("770") || this.TIPO_MODELLO.equals("77S") || this.TIPO_MODELLO.equals("IVA")) && Util.esisteAlmenoUnCampo(this.recordB, 98, 114) || this.TIPO_MODELLO.equals("U50") || this.TIPO_MODELLO.equals("U60") || this.TIPO_MODELLO.equals("U61")) {
            n = Util.aggRc(n, this.liquidaTRecBRappresentante());
        }
        if (this.TIPO_MODELLO.equals("UNI") && Util.contaCampiPresenti(this.recordB, 124, 130) > 1) {
            n = Diagnostici.DIA(n, CODWARNING, this.codFiscDichiarante, "1319", "XXX24", "", "");
        }
        if (this.TIPO_MODELLO.equals("IVA") && this.BI(186) == 0) {
            n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXX86", "", "");
        }
        if (this.BI(15) == 1 && this.BI(186) == 0) {
            n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXX86", "", "");
        }
        n = Util.aggRc(n, this.liquidaQuadriCompilati(modelloIVA03, modello77003, bl, bl2));
        if (this.BI(210) == 1 && this.BS(208).trim().length() == 0) {
            n = Diagnostici.DIA(n, CODWARNING, this.codFiscDichiarante, "1014", "XXY08", "", "");
        }
        if (this.BS(208).trim().length() != 0 && !Util.controlloCF(this.BS(208).trim())) {
            n = Diagnostici.DIA(n, 16, this.codFiscDichiarante, "1013", "XXY08", this.BS(208), "");
        }
        if (this.BI(214) == 1 && this.BS(212).trim().length() == 0) {
            n = Diagnostici.DIA(n, CODWARNING, this.codFiscDichiarante, "1014", "XXY12", "", "");
        }
        if (this.BS(212).trim().length() != 0 && !Util.controlloCF(this.BS(212).trim())) {
            n = Diagnostici.DIA(n, 16, this.codFiscDichiarante, "1013", "XXY12", this.BS(212), "");
        }
        if (this.BS(213).trim().length() != 0 && !Util.controlloCF(this.BS(213).trim())) {
            n = Diagnostici.DIA(n, 16, this.codFiscDichiarante, "1013", "XXY13", this.BS(213), "");
        }
        if (this.BS(7).trim().length() != 0 && !Util.controlloCF(this.BS(7).trim())) {
            n = Diagnostici.DIA(n, 16, this.codFiscDichiarante, "1013", "XXB07", this.BS(7), "");
        }
        if ((this.TIPO_MODELLO.equals("IVA") || this.TIPO_MODELLO.equals("UNI") && this.BL(101) != 2L || this.TIPO_MODELLO.equals("770") || this.TIPO_MODELLO.equals("77S")) && this.BS(39).trim().length() > 0 && !this.BS(39).trim().equals("EE") && !Util.esisteProvincia(this.BS(39))) {
            n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1012", "XXB39", this.BS(39), "");
        }
        if ((this.TIPO_MODELLO.equals("UNI") && this.BL(101) != 2L || this.TIPO_MODELLO.equals("770") || this.TIPO_MODELLO.equals("77S")) && this.BS(46).trim().length() > 0 && !this.BS(46).trim().equals("EE") && !Util.esisteProvincia(this.BS(46))) {
            n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1012", "XXB46", this.BS(46), "");
        }
        if (this.TIPO_MODELLO.equals("UNI") && this.BL(101) != 2L && this.BS(55).trim().length() > 0 && !this.BS(55).trim().equals("EE") && !Util.esisteProvincia(this.BS(55))) {
            n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1012", "XXB55", this.BS(55), "");
        }
        if (!this.TIPO_MODELLO.equals("IVA") && !this.TIPO_MODELLO.equals("UNI")) {
            if (this.BS(70).trim().length() > 0 && !this.BS(70).trim().equals("EE") && !Util.esisteProvincia(this.BS(70))) {
                n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1012", "XXB70", this.BS(70), "");
            }
            if (this.BS(75).trim().length() > 0 && !this.BS(75).trim().equals("EE") && !Util.esisteProvincia(this.BS(75))) {
                n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1012", "XXB75", this.BS(75), "");
            }
        }
        if (this.BS(109).trim().length() > 0 && !this.BS(109).trim().equals("EE") && !Util.esisteProvincia(this.BS(109))) {
            n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1012", "XXX09", this.BS(109), "");
        }
        if (this.BS(111).trim().length() > 0 && !this.BS(111).trim().equals("EE") && !Util.esisteProvincia(this.BS(111))) {
            n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1012", "XXX11", this.BS(111), "");
        }
        if (!this.TIPO_MODELLO.equals("77S") && this.BI(120) == 0) {
            n = Diagnostici.DIA(n, CODWARNING, this.codFiscDichiarante, "1016", "XXX20", "", "");
        }
        if (this.BS(201).trim().length() != 0 && this.BI(206) == 0) {
            n = Diagnostici.DIA(n, CODWARNING, this.codFiscDichiarante, "1310", "XXY06", "", "");
        }
        if (this.BS(208).trim().length() != 0 && this.BI(210) == 0) {
            n = Diagnostici.DIA(n, CODWARNING, this.codFiscDichiarante, "1310", "XXY10", "", "");
        }
        if (this.BS(212).trim().length() != 0 && this.BI(215) == 0) {
            n = Diagnostici.DIA(n, CODWARNING, this.codFiscDichiarante, "1310", "XXY15", "", "");
        }
        if (this.BS(201).trim().length() != 0 && !Util.controlloCF(this.BS(201).trim())) {
            n = Diagnostici.DIA(n, 16, this.codFiscDichiarante, "1013", "XXY01", this.BS(201), "");
        }
        return n;
    }

    private int liquidaTRecBAnagrafica(ModelloIVA03 modelloIVA03, Modello77003 modello77003) {
        int n = 0;
        this.codFiscDichiarante = this.BS(2).trim();
        boolean bl = Util.isNumericoAssoluto(this.codFiscDichiarante);
        if (this.TIPO_MODELLO.equals("IVA")) {
            if (this.BL(28) == 0L) {
                n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1096", "XXB28", this.BS(28), "");
            }
            if (this.BL(28) != 0L && !Util.controlloPI(this.BS(28))) {
                n = Diagnostici.DIA(n, 16, this.codFiscDichiarante, "1096", "XXB28", this.BS(28), "");
            }
        }
        if (!(this.TIPO_MODELLO.equals("IVA") || this.TIPO_MODELLO.equals("770") || this.TIPO_MODELLO.equals("77S"))) {
            if (modelloIVA03 != null && modelloIVA03.getDichiarazione().esisteModulo("00000001") && this.BI(15) == 1 && this.BL(28) == 0L) {
                n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1096", "XXB28", this.BS(28), "");
            }
            if (modelloIVA03 != null && modelloIVA03.getDichiarazione().esisteModulo("00000001") && this.BI(15) == 1 && this.BL(28) != 0L && !Util.controlloPI(this.BS(28))) {
                n = Diagnostici.DIA(n, 16, this.codFiscDichiarante, "1096", "XXB28", this.BS(28), "");
            }
        }
        if (this.BS(33).trim().length() > 0 && !Util.isNumericoAssoluto(this.BS(33).trim())) {
            n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1011", "XXB33", "", "");
        }
        if (this.BS(34).trim().length() > 0 && !Util.isNumericoAssoluto(this.BS(34).trim())) {
            n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1011", "XXB34", "", "");
        }
        if (this.TIPO_MODELLO.equals("UNI")) {
            if (this.BS(45).trim().length() == 0) {
                n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXB45", "", "");
            }
            if (this.BS(46).trim().length() == 0) {
                n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXB46", "", "");
            }
            if (!Util.esisteAlmenoUnCampo(this.recordB, 58, 66)) {
                if (this.BS(47).trim().length() == 0) {
                    n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXB47", "", "");
                }
                if (this.BS(45).trim().length() != 0 && this.BS(47).trim().length() != 0 && this.BS(45).trim().equals(this.BS(47).trim())) {
                    n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1012", "XXB44", this.BS(44), "");
                }
                if (this.BS(49).trim().length() == 0) {
                    n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXB49", "", "");
                } else if (!ComuniProvincia.esisteCodCat(this.BS(49).trim())) {
                    n = Diagnostici.DIA(n, CODWARNING, this.codFiscDichiarante, "1012", "XXB49", this.BS(49), "");
                }
            }
            if (this.BS(54).trim().length() == 0) {
                n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXB54", "", "");
            }
            if (this.BS(55).trim().length() == 0) {
                n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXB55", "", "");
            }
            if (this.BS(56).trim().length() == 0) {
                n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXB56", "", "");
            } else if (!ComuniProvincia.esisteCodCat(this.BS(56).trim())) {
                n = Diagnostici.DIA(n, CODWARNING, this.codFiscDichiarante, "1012", "XXB56", this.BS(56), "");
            }
            if (Util.esisteAlmenoUnCampo(this.recordB, 58, 66)) {
                if (this.BS(59).trim().length() == 0) {
                    n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXB59", "", "");
                }
                if (this.BI(60) == 0) {
                    n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXB60", "", "");
                } else if (!Util.esisteCodicePaeseEstero(this.BS(60))) {
                    n = Diagnostici.DIA(n, CODWARNING, this.codFiscDichiarante, "1012", "XXB60", "", "");
                }
                if (this.BS(63).trim().length() == 0) {
                    n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXB63", "", "");
                }
            }
            if (this.BL(50) != 0L && !Util.controlloData(this.BS(50))) {
                n = Diagnostici.DIA(n, 16, this.codFiscDichiarante, "1015", "XXB50", this.BS(50), "");
            }
        }
        if ((this.TIPO_MODELLO.equals("770") || this.TIPO_MODELLO.equals("77S")) && !bl) {
            String string;
            if (this.BS(45).trim().length() == 0) {
                n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXB45", "", "");
            }
            if (this.BS(46).trim().length() == 0) {
                n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXB46", "", "");
            }
            if (!(string = this.BS(46).trim()).equals("EE") && !Util.isNonValorizzato(string)) {
                if (this.BI(48) == 0) {
                    n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXB48", "", "");
                }
                if (this.BS(47).trim().length() == 0) {
                    n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXB47", "", "");
                }
            }
        }
        return n;
    }

    private int liquidaTRecBAnagraficaEreditaGiacente() {
        int n = 0;
        this.codFiscDichiarante = this.BS(2).trim();
        if (Util.isNumericoAssoluto(this.codFiscDichiarante)) {
            if (this.BL(2) == 0L) {
                n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1014", "XXB02", "", "");
            }
        } else if (this.codFiscDichiarante.length() == 0) {
            n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1014", "XXB02", "", "");
        }
        if (!Util.controlloCF(this.codFiscDichiarante)) {
            n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1013", "XXB02", this.codFiscDichiarante, "");
        }
        return n;
    }

    private int liquidaTRecBCF() {
        int n = 0;
        int n2 = 0;
        String string = this.BS(2).trim();
        String string2 = "";
        if (string.length() > 9) {
            string2 = this.BS(2).substring(0, 10);
        }
        boolean bl = string2.equals("PROG REC N");
        boolean bl2 = false;
        boolean bl3 = true;
        if (!bl) {
            bl2 = Util.isNumericoAssoluto(string);
            boolean bl4 = bl3 = !Util.controlloCF(string);
        }
        if ((this.TIPO_MODELLO.equals("U50") || this.TIPO_MODELLO.equals("U60") || this.TIPO_MODELLO.equals("U61")) && !bl2) {
            bl3 = true;
        }
        boolean bl5 = false;
        if (this.TIPO_MODELLO.equals("UNI") || (this.TIPO_MODELLO.equals("770") || this.TIPO_MODELLO.equals("77S") || this.TIPO_MODELLO.equals("IVA")) && !bl2) {
            bl5 = true;
        }
        boolean bl6 = true;
        bl6 = true;
        if (this.banchePoste && (this.BS(25).trim().length() != 0 && this.BS(26).trim().length() != 0 || this.BS(27).trim().length() != 0)) {
            bl6 = false;
        }
        if (bl && bl6) {
            n = Diagnostici.DIA(n, 16, string, "1016", "XXB02", "", "");
        }
        if (!bl && bl3 && bl6) {
            n = Diagnostici.DIA(n, 16, string, "1013", "XXB02", string, "");
        }
        bl6 = true;
        if (this.banchePoste && !bl3) {
            bl6 = false;
        }
        if (!bl5) {
            if (this.BS(27).trim().length() == 0 && bl6) {
                n = Diagnostici.DIA(n, 16, string, "1016", "XXB27", "", "");
            }
        } else {
            if (this.BS(25).trim().length() == 0 && bl6) {
                n = Diagnostici.DIA(n, 16, string, "1016", "XXB25", "", "");
            }
            if (this.BS(26).trim().length() == 0 && bl6) {
                n = Diagnostici.DIA(n, 16, string, "1016", "XXB26", "", "");
            }
        }
        if (this.BS(25).trim().length() != 0 && this.BS(27).trim().length() != 0) {
            n = Diagnostici.DIA(n, 16, string, "1342", "XXB", "", "");
        } else if (this.BS(26).trim().length() != 0 && this.BS(27).trim().length() != 0) {
            n = Diagnostici.DIA(n, 16, string, "1342", "XXB", "", "");
        }
        int n3 = 16;
        if (this.banchePoste) {
            n3 = this.codGravDatiIncoerenti;
        }
        if (bl5) {
            if (this.BS(38).trim().length() == 0 && bl6) {
                n2 = Diagnostici.DIA(n2, n3, this.codFiscDichiarante, "1016", "XXB38", "", "");
            }
            if (this.BL(40) == 0L && bl6) {
                n2 = Diagnostici.DIA(n2, n3, this.codFiscDichiarante, "1016", "XXB40", "", "");
            }
            if (this.BS(41).trim().length() == 0 && bl6) {
                n2 = Diagnostici.DIA(n2, n3, this.codFiscDichiarante, "1016", "XXB41", "", "");
            }
            n = Util.aggRc(n, n2);
        }
        return n;
    }

    private int liquidaTRecBDatiSocieta() {
        String string;
        int n = 0;
        this.codFiscDichiarante = this.BS(2).trim();
        boolean bl = Util.isNumericoAssoluto(this.codFiscDichiarante);
        if (this.TIPO_MODELLO.equals("U50") || this.TIPO_MODELLO.equals("U60") || this.TIPO_MODELLO.equals("U61")) {
            if (this.BL(78) != 0L || this.BL(79) != 0L) {
                if (this.BL(78) == 0L) {
                    n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXB78", "", "");
                } else if (!Util.controlloData(this.BS(78))) {
                    n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1015", "XXB73", this.BS(78), "");
                }
                if (this.BL(79) == 0L) {
                    n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXB79", "", "");
                } else if (!Util.controlloData(this.BS(79))) {
                    n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1015", "XXB74", this.BS(79), "");
                }
            }
            if (!Util.controlloMeseAnno(this.BS(68))) {
                n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1015", "XXB68", this.BS(68), "");
            }
            if (this.BS(69).trim().length() == 0) {
                n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXB69", "", "");
            }
            if (!(string = this.BS(70).trim()).equals("EE") && !Util.isNonValorizzato(string)) {
                if (this.BS(71).trim().length() == 0) {
                    n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXB71", "", "");
                }
                if (this.BI(72) == 0) {
                    n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXB72", "", "");
                }
            }
            if (!Util.controlloMeseAnno(this.BS(73))) {
                n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1015", "XXB73", this.BS(73), "");
            }
            if (Util.esisteAlmenoUnCampo(this.recordB, 74, 77) && this.BS(74).trim().length() == 0) {
                n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXB74", "", "");
            }
            if (Util.esisteAlmenoUnCampo(this.recordB, 74, 77) && this.BS(75).trim().length() == 0) {
                n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXB75", "", "");
            }
            if (Util.esisteAlmenoUnCampo(this.recordB, 74, 77) && this.BS(76).trim().length() == 0) {
                n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXB76", "", "");
            }
            if (Util.esisteAlmenoUnCampo(this.recordB, 74, 77) && this.BS(77).trim().length() == 0) {
                n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXB77", "", "");
            }
            if (this.BI(82) != 0 && (this.BI(82) < 1 || this.BI(82) > 4)) {
                n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1012", "XXB82", (double)this.BI(82), "");
            }
            if (this.BI(87) != 0 && !Util.esisteCodicePaeseEstero(this.BS(87))) {
                n = Diagnostici.DIA(n, CODWARNING, this.codFiscDichiarante, "1012", "XXB87", "", "");
            }
            if (this.TIPO_MODELLO.equals("U50")) {
                if (this.BI(83) != 0 && (this.BI(83) < 23 || this.BI(83) > 29)) {
                    n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1012", "XXB83", (double)this.BI(83), "");
                }
                if (this.BI(84) != 0 && (this.BI(84) < 1 || this.BI(84) > 7) && this.BI(84) != 9) {
                    n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1012", "XXB84", (double)this.BI(84), "");
                }
            }
            if (this.TIPO_MODELLO.equals("U60")) {
                if (!(this.BI(83) == 0 || this.BI(83) >= 1 && this.BI(83) <= 22 || this.BI(83) >= 30 && this.BI(83) <= 33 || this.BI(83) >= 35 && this.BI(83) <= 43 || this.BI(83) == 50)) {
                    n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1012", "XXB83", (double)this.BI(83), "");
                }
                if (this.BI(84) != 0 && (this.BI(84) < 1 || this.BI(84) > 7)) {
                    n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1012", "XXB84", (double)this.BI(84), "");
                }
                if (this.BL(91) == 1L && this.BL(92) == 0L) {
                    n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXB92", "", "");
                }
            }
            if (this.TIPO_MODELLO.equals("U61")) {
                if (!(this.BI(83) >= 0 && this.BI(83) <= 22 || this.BI(83) >= 30 && this.BI(83) <= 33 || this.BI(83) >= 35 && this.BI(83) <= 43 || this.BI(83) == 50 || this.BI(83) == 53)) {
                    n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1012", "XXB83", (double)this.BI(83), "");
                }
                if (this.BI(84) < 1 || this.BI(84) > 7) {
                    n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1012", "XXB84", (double)this.BI(84), "");
                }
                if (this.BL(91) == 1L && this.BL(92) == 0L) {
                    n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXB92", "", "");
                }
            }
            if (this.BS(90).trim().length() != 0 && !Util.isNumericoAssoluto(this.BS(90).trim())) {
                n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1345", "XXB90", this.BS(90).trim(), "");
            }
            if (this.BS(90).trim().length() != 0 && !Util.controlloCF(this.BS(90).trim())) {
                n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1013", "XXB90", this.BS(90).trim(), "");
            }
            if ((this.TIPO_MODELLO.equals("U60") || this.TIPO_MODELLO.equals("U61")) && this.BI(92) != 0 && (this.BI(92) < 1 || this.BI(92) > 11)) {
                n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1012", "XXB92", "", "");
            }
        }
        if ((this.TIPO_MODELLO.equals("770") || this.TIPO_MODELLO.equals("77S")) && bl) {
            if (!Util.controlloMeseAnno(this.BS(68))) {
                n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1015", "XXB68", this.BS(68), "");
            }
            if (this.BS(65).trim().length() == 0) {
                n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXB65", "", "");
            }
            if (!(string = this.BS(70).trim()).equals("EE") && !Util.isNonValorizzato(string)) {
                if (this.BS(71).trim().length() == 0) {
                    n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXB71", "", "");
                }
                if (this.BI(72) == 0) {
                    n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXB72", "", "");
                }
            }
            if (!Util.controlloMeseAnno(this.BS(73))) {
                n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1015", "XXB73", this.BS(73), "");
            }
            if (Util.esisteAlmenoUnCampo(this.recordB, 74, 77) && this.BS(74).trim().length() == 0) {
                n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXB74", "", "");
            }
            if (Util.esisteAlmenoUnCampo(this.recordB, 74, 77) && this.BS(75).trim().length() == 0) {
                n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXB75", "", "");
            }
            if (Util.esisteAlmenoUnCampo(this.recordB, 74, 77) && this.BS(76).trim().length() == 0) {
                n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXB76", "", "");
            }
            if (Util.esisteAlmenoUnCampo(this.recordB, 74, 77) && this.BS(77).trim().length() == 0) {
                n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXB77", "", "");
            }
            if (this.BS(32).trim().length() != 0 && !Util.esisteCodAtt(this.BS(32))) {
                n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1012", "XXB32", this.BS(32), "");
            }
            if (this.BL(93) != 0L && !Util.controlloCF(this.BS(93).trim())) {
                n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1013", "XXB93", (double)this.BL(93), "");
            }
        }
        return n;
    }

    private int liquidaTRecBProtocollo() {
        int n = 0;
        this.codFiscDichiarante = this.BS(2).trim();
        String[] stringArray = new String[5];
        if (this.banchePoste) {
            stringArray = Liquidatore.controlloProtocolloBanchePoste(this.BS(5), this.BS(226), this.BD(227), this.getCodiceFornitura(), this.tipoFornitore, this.BI(233), this.BI(228), 2003);
            if (stringArray[0].equals("1070")) {
                n = Diagnostici.DIA(n, 16, this.codFiscDichiarante, stringArray[0], "XXB05", "", "");
            }
            if (stringArray[1].equals("1071") && !stringArray[0].equals("1070")) {
                n = Diagnostici.DIA(n, CODWARNING, this.codFiscDichiarante, "1070", "XXB05", "", "");
            }
            if (stringArray[2].equals("1072")) {
                n = Diagnostici.DIA(n, 16, this.codFiscDichiarante, stringArray[2], "XXY06", "", "");
            }
            if (stringArray[3].equals("1073")) {
                n = Diagnostici.DIA(n, 16, this.codFiscDichiarante, stringArray[3], "XXY07", "", "");
            }
            if (stringArray[4].equals("1095")) {
                n = Diagnostici.DIA(n, 16, this.codFiscDichiarante, stringArray[4], "XXY08", "", "");
            }
        } else if (this.BS(5).trim().length() != 0) {
            n = Diagnostici.DIA(n, 16, this.codFiscDichiarante, "1300", "XXB05", "", "");
        }
        if (this.tipoFornitore == 7 && this.BS(224).trim().length() != 0) {
            String string = this.BS(224).trim();
            if (string.length() == 25) {
                String string2 = string.substring(0, 5);
                String string3 = string.substring(5, 10);
                String string4 = string.substring(10, 13);
                String string5 = string.substring(13, 21);
                String string6 = string.substring(21, 25);
                double d = 2003.0;
                if (!(Util.isNumericoAssoluto(string2) && !string2.equals("00000") && Util.isNumericoAssoluto(string3) && !string3.equals("00000") && (string4.equals("UNI") || string4.equals("SCE") || string4.equals("SCS") || string4.equals("IVA") || string4.equals("730") || string4.equals("U50") || string4.equals("U60") || string4.equals("U61") || string4.equals("770") || string4.equals("77S")) && Util.isNumericoAssoluto(string5) && Util.controlloData(string5) && !string5.equals("00000000") && Util.isNumericoAssoluto(string6))) {
                    n = Diagnostici.DIA(n, 16, this.codFiscDichiarante, "1070", "XXY24", "", "");
                } else if (Util.valoreDouble(string5.substring(4, 8)) != d && Util.valoreDouble(string5.substring(4, 8)) != d - 1.0 && Util.valoreDouble(string5.substring(4, 8)) != d + 1.0 && Util.valoreDouble(string5.substring(4, 8)) != d + 2.0 && Util.valoreDouble(string5.substring(4, 8)) != d + 3.0 && Util.valoreDouble(string5.substring(4, 8)) != d + 4.0) {
                    n = Diagnostici.DIA(n, 16, this.codFiscDichiarante, "1070", "XXY24", "", "");
                }
            } else {
                n = Diagnostici.DIA(n, 16, this.codFiscDichiarante, "1070", "XXY24", "", "");
            }
        }
        return n;
    }

    private int liquidaTRecBRappresentante() {
        boolean bl;
        int n = 0;
        this.codFiscDichiarante = this.BS(2).trim();
        String string = this.BS(98).trim();
        boolean bl2 = bl = Util.esistenzaTuttiCampi(this.recordB, 98, 99, true) && Util.esistenzaTuttiCampi(this.recordB, 101, 108, true);
        if (!this.banchePoste) {
            if (string.length() == 0) {
                n = Diagnostici.DIA(n, 16, this.codFiscDichiarante, "1014", "XXB98", "", "");
            } else if (!Util.controlloCF(string)) {
                n = Diagnostici.DIA(n, 16, this.codFiscDichiarante, "1013", "XXB98", string, "");
            }
            if (this.BS(104).trim().length() == 0) {
                n = Diagnostici.DIA(n, 16, this.codFiscDichiarante, "1016", "XXX04", "", "");
            }
            if (this.BS(105).trim().length() == 0) {
                n = Diagnostici.DIA(n, 16, this.codFiscDichiarante, "1016", "XXX05", "", "");
            }
            if (this.BS(106).trim().length() == 0) {
                n = Diagnostici.DIA(n, 16, this.codFiscDichiarante, "1016", "XXX06", "", "");
            }
            if (this.BI(107) == 0) {
                n = Diagnostici.DIA(n, 16, this.codFiscDichiarante, "1016", "XXX07", "", "");
            } else if (this.BI(107) != 0 && !Util.controlloData(this.BS(107))) {
                n = Diagnostici.DIA(n, 16, this.codFiscDichiarante, "1015", "XXX07", this.BS(107), "");
            }
            if (this.BS(108).trim().length() == 0) {
                n = Diagnostici.DIA(n, 16, this.codFiscDichiarante, "1016", "XXX08", "", "");
            }
        } else {
            if (!bl) {
                if (string.length() == 0) {
                    n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1014", "XXB98", "", "");
                } else if (!Util.controlloCF(string)) {
                    n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1013", "XXB98", string, "");
                }
            }
            if (string.length() == 0 || !Util.controlloCF(string)) {
                if (this.BS(104).trim().length() == 0) {
                    n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXX04", "", "");
                }
                if (this.BS(105).trim().length() == 0) {
                    n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXX05", "", "");
                }
                if (this.BS(106).trim().length() == 0) {
                    n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXX06", "", "");
                }
                if (this.BI(107) == 0) {
                    n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXX07", "", "");
                } else if (this.BI(107) != 0 && !Util.controlloData(this.BS(107))) {
                    n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1015", "XXX07", this.BS(107), "");
                }
                if (this.BS(108).trim().length() == 0) {
                    n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXX08", "", "");
                }
            }
            if (bl && string.length() != 0 && Util.controlloCF(string)) {
                n = Diagnostici.DIA(n, CODWARNING, this.codFiscDichiarante, "1326", "XXB", "", "");
            }
        }
        if (this.BI(101) == 0) {
            n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXX01", "", "");
        }
        if (this.TIPO_MODELLO.equals("IVA")) {
            if (this.BL(99) != 0L && !Util.controlloCF(this.BS(99))) {
                n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1500", "XXB99", "", "");
            }
            if (this.BI(101) == 9 && this.BL(99) == 0L) {
                n = Diagnostici.DIA(n, this.codGravConferma, this.codFiscDichiarante, "1016", "XXB99", "", "");
            }
        }
        if (this.TIPO_MODELLO.equals("IVA") && this.BI(103) == 0 && (this.BI(101) == 3 || this.BI(101) == 4)) {
            n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1016", "XXX03", "", "");
        }
        if (!(this.TIPO_MODELLO.equals("770") || this.TIPO_MODELLO.equals("77S") || this.BL(103) == 0L || Util.controlloData(this.BS(103)))) {
            n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1015", "XXX03", this.BS(103), "");
        }
        if (this.BS(114).trim().length() > 0 && !Util.isNumericoAssoluto(this.BS(114).trim())) {
            n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1011", "XXX14", "", "");
        }
        if (this.TIPO_MODELLO.equals("UNI") || this.TIPO_MODELLO.equals("IVA")) {
            if (this.BI(116) != 0 && (this.BL(115) == 0L || this.BL(117) != 0L)) {
                n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1019", "XXX16", (double)this.BI(116), "");
            }
            if (this.BL(117) > 0L && this.BI(116) != 0) {
                n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1019", "XXX17", (double)this.BL(117), "");
            }
            if (this.BL(115) != 0L && !Util.controlloData(this.BS(115))) {
                n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1015", "XXX15", this.BS(115), "");
            }
            if (this.BL(117) != 0L && !Util.controlloData(this.BS(117))) {
                n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1015", "XXX17", this.BS(117), "");
            }
        }
        if (this.TIPO_MODELLO.equals("UNI") && this.BI(118) != 0 && this.BI(101) != 7) {
            n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1317", "XXX18", "", "");
        }
        return n;
    }

    private int liquidaTRecBTipoFornitore() {
        boolean bl;
        int n = 0;
        this.codFiscDichiarante = this.BS(2).trim();
        this.BI(101);
        String string = this.AS(5).trim();
        String string2 = this.BS(98).trim();
        String string3 = this.BS(201).trim();
        boolean bl2 = Util.esisteAlmenoUnCampo(this.recordB, 201, 206);
        boolean bl3 = bl = string.equals(this.codFiscDichiarante) || string.equals(string2);
        if (this.tipoFornitore == 10 && !bl && !bl2) {
            n = Diagnostici.DIA(n, 16, this.codFiscDichiarante, "1303", "XXB", "", "");
        }
        if (!(this.tipoFornitore != 3 && this.tipoFornitore != 5 || bl2)) {
            n = Diagnostici.DIA(n, 16, this.codFiscDichiarante, "1303", "XXB", "", "");
        }
        if (this.tipoFornitore == 6 || this.tipoFornitore == 9) {
            if (!Util.isNumericoAssoluto(this.codFiscDichiarante) || this.codFiscDichiarante.length() != 11) {
                n = Diagnostici.DIA(n, 16, this.codFiscDichiarante, "1305", "XXB02", this.codFiscDichiarante, "");
            }
            if (!string.equals(this.codFiscDichiarante) && !string.equals(string3)) {
                n = Diagnostici.DIA(n, 16, this.codFiscDichiarante, "1306", "XXB02", "", "");
            }
        }
        if ((this.tipoFornitore == 7 || this.tipoFornitore == 8) && this.BS(229).trim().length() == 0) {
            n = Diagnostici.DIA(n, 16, this.codFiscDichiarante, "1016", "XXY29", "", "");
        }
        if (bl2) {
            if (Util.isNonValorizzato(string3)) {
                n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1074", "XXY01", "", "");
            }
            if ((this.tipoFornitore == 3 || this.tipoFornitore == 5) && this.BI(202) == 0) {
                n = Diagnostici.DIA(n, 16, this.codFiscDichiarante, "1304", "XXY02", "", "");
            }
            if (this.BI(203) == 1 && this.BI(204) == 1) {
                n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1307", "XXY03", "", "");
            } else if (this.BI(203) == 0 && this.BI(204) == 0) {
                n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1308", "XXY03", "", "");
            }
            if (this.BI(205) == 0) {
                n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, this.codFiscDichiarante, "1309", "XXY05", "", "");
            } else if (!Util.controlloData(this.BS(205))) {
                n = Diagnostici.DIA(n, 16, this.codFiscDichiarante, "1015", "XXY05", this.BS(205), "");
            }
        }
        return n;
    }

    public int liquidaTRecZ(int[] nArray) {
        int n = 0;
        String string = "ZZZZZZZZZZZZZZZZ";
        if (this.ZD(3) != (double)nArray[0]) {
            n = Diagnostici.DIA(n, CODWARNING, string, "1018", "XXZ03", this.ZD(3), (double)nArray[0]);
        }
        if (this.TIPO_MODELLO.equals("UNI") || this.TIPO_MODELLO.equals("U50") || this.TIPO_MODELLO.equals("U60") || this.TIPO_MODELLO.equals("U61")) {
            if (this.ZD(4) != (double)nArray[1]) {
                n = Diagnostici.DIA(n, CODWARNING, string, "1018", "XXZ04", this.ZD(4), (double)nArray[1]);
            }
            if (this.ZD(5) != (double)nArray[2]) {
                n = Diagnostici.DIA(n, CODWARNING, string, "1018", "XXZ05", this.ZD(5), (double)nArray[2]);
            }
            if (this.ZD(6) != (double)nArray[3]) {
                n = Diagnostici.DIA(n, CODWARNING, string, "1018", "XXZ06", this.ZD(6), (double)nArray[3]);
            }
            if (this.ZD(7) != (double)nArray[7]) {
                n = Diagnostici.DIA(n, CODWARNING, string, "1018", "XXZ07", this.ZD(7), (double)nArray[7]);
            }
            if (this.ZD(8) != (double)nArray[15]) {
                n = Diagnostici.DIA(n, CODWARNING, string, "1018", "XXZ08", this.ZD(8), (double)nArray[15]);
            }
            if (this.ZD(9) != (double)nArray[16]) {
                n = Diagnostici.DIA(n, CODWARNING, string, "1018", "XXZ09", this.ZD(9), (double)nArray[16]);
            }
            if (this.ZD(10) != (double)nArray[17]) {
                n = Diagnostici.DIA(n, CODWARNING, string, "1018", "XXZ10", this.ZD(10), (double)nArray[17]);
            }
            if (this.ZD(11) != (double)nArray[18]) {
                n = Diagnostici.DIA(n, CODWARNING, string, "1018", "XXZ11", this.ZD(11), (double)nArray[18]);
            }
            if (this.ZD(12) != (double)nArray[19]) {
                n = Diagnostici.DIA(n, CODWARNING, string, "1018", "XXZ12", this.ZD(12), (double)nArray[19]);
            }
        }
        if ((this.TIPO_MODELLO.equals("IVA") || this.TIPO_MODELLO.equals("770")) && this.ZD(4) != (double)nArray[1]) {
            n = Diagnostici.DIA(n, CODWARNING, string, "1018", "XXZ04", this.ZD(4), (double)nArray[1]);
        }
        if (this.TIPO_MODELLO.equals("77S")) {
            if (this.ZD(4) != (double)nArray[1]) {
                n = Diagnostici.DIA(n, CODWARNING, string, "1018", "XXZ04", this.ZD(4), (double)nArray[1]);
            }
            if (this.ZD(5) != (double)nArray[2]) {
                n = Diagnostici.DIA(n, CODWARNING, string, "1018", "XXZ05", this.ZD(5), (double)nArray[2]);
            }
            if (this.ZD(6) != (double)nArray[3]) {
                n = Diagnostici.DIA(n, CODWARNING, string, "1018", "XXZ06", this.ZD(6), (double)nArray[3]);
            }
            if (this.ZD(7) != (double)nArray[4]) {
                n = Diagnostici.DIA(n, CODWARNING, string, "1018", "XXZ07", this.ZD(7), (double)nArray[4]);
            }
        }
        return n;
    }

    public String mod(int n) {
        String string = Util.formNum(8, n);
        return string;
    }

    public int numeroModuliQuadro(String string) {
        return this.dich.maxModuliDaQuadro(string);
    }

    public void setBanchePoste(boolean bl) {
        this.banchePoste = bl;
    }

    public void setTipoFornitore(int n) {
        this.tipoFornitore = n;
    }

    protected int soloSulPrimoModulo(String[] stringArray, String string) {
        int n = 0;
        if (stringArray == null) {
            return n;
        }
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string2 = stringArray[n3];
            if (string2.length() == 8) {
                String string3 = string2.substring(0, 2);
                String string4 = string2.substring(2, 8);
                int n4 = this.dich.maxModuliDaQuadro(string3);
                int n5 = 2;
                while (n5 <= n4) {
                    String string5 = Util.formNum(8, n5);
                    if (this.dich.esisteCampo(String.valueOf(string2) + string5)) {
                        n = Diagnostici.DIA(n, this.codGravDatiIncoerenti, string, "1052", String.valueOf(string3) + string4 + string5, "", "", "", "");
                    }
                    ++n5;
                }
            } else {
                System.out.println("!!!ERRORE!!! - soloSulPrimoModulo(...): formato del codice campo errato: " + string2);
            }
            ++n3;
        }
        return n;
    }
}

