import QtQuick
import QtQuick.Shapes

Item {
    objectName: "declared root item"
    width: 240
    height: 304
    Rectangle {
        id: shadow
        anchors {
            fill: parent
            margins: 10
            leftMargin: 20
            topMargin: 20
        }
        color: shadowHH.hovered? "indigo" : "grey"
        radius: 3
        opacity: 0.5
        HoverHandler {
            id: shadowHH
            objectName: "shadow"
            cursorShape: Qt.ForbiddenCursor
        }
    }

    Rectangle {
        id: frame
        anchors.fill: parent
        anchors.margins: 20
        border.color: "darkgreen"
        gradient: "MagicLake"
        HoverHandler {
            id: frameHH
            objectName: "frame"
            cursorShape: Qt.UpArrowCursor
        }
        // just barely fits in its frame
        Shape {
            id: goat
            preferredRendererType: Shape.CurveRenderer
            containsMode: Shape.FillContains
            HoverHandler {
                id: goatHH
                objectName: "goat"
                cursorShape: Qt.SizeAllCursor
            }

            ShapePath {
                fillColor: goatHH.hovered ? "sienna" : "black"
                pathHints: ShapePath.PathQuadratic | ShapePath.PathNonIntersecting | ShapePath.PathNonOverlappingControlPointTriangles
                scale: Qt.size(0.26, 0.27)
                PathSvg {
                    // adapted from https://openclipart.org/detail/76129/goat-line-art
                    path: "M 147.216 2.60501 L 137.691 27.167 L 127.105 54.4683 L 127.089 54.4624 Q 110.989 92.7603 103.681 126.032 Q 96.3737 159.305 97.8588 187.551 " +
                        "Q 100.829 244.044 138.97 280.433 Q 116.165 314.286 109.415 394.922 Q 101.66 487.551 68.2749 523.933 Q 44.0039 535.789 28.5851 572.449 " +
                        "Q 11.2689 613.621 35.0112 636.183 Q 40.8154 659.013 52.735 675.577 Q 63.7557 690.891 77.9038 698.134 Q 93.182 711.031 132.513 722.909 " +
                        "Q 156.375 730.116 165.748 735.152 Q 185.394 772.321 182.87 814.696 Q 180.346 857.071 155.652 904.652 Q 165.567 910.775 183.857 905.677 " +
                        "Q 194.279 902.772 213.26 893.712 Q 230.075 885.686 229.332 889.623 Q 227.376 898.234 218.225 920.951 Q 205.416 952.753 206.355 960.824 " +
                        "Q 207.918 974.263 238.472 953.902 Q 258.023 950.973 278.168 929.003 Q 293.019 912.807 301.197 895.742 Q 299.642 936.36 311.363 926.859 " +
                        "Q 318.263 921.265 336.293 888.04 L 347.351 868.324 Q 358.78 836.592 347.752 800.586 Q 341.15 779.032 317.994 737.732 Q 299.229 704.263 292.742 687.363 " +
                        "Q 308.57 669.063 315.192 671.075 Q 319.42 672.359 323.584 687.097 Q 330.779 712.559 343.166 718.359 Q 369.499 732.303 399 734.008 " +
                        "Q 428.501 735.712 461.169 725.177 Q 493.729 714.677 516.797 696.142 Q 539.866 677.606 553.445 651.035 L 559.353 594.633 " +
                        "Q 568.718 511.641 568.525 469.843 Q 621.629 467.242 664.756 453.647 Q 707.884 440.052 741.035 415.464 Q 701.539 366.041 653.45 344.138 " +
                        "Q 624.364 330.891 597.195 330.787 Q 570.026 330.684 544.775 343.724 Q 539.319 329.904 547.766 319.621 Q 552.879 313.397 569.686 303.422 " +
                        "Q 595.635 288.021 600.066 274.955 Q 619.047 251.303 625.6 222.246 Q 632.153 193.189 626.278 158.727 Q 617.397 106.627 580.416 43.9546 " +
                        "L 579.574 55.7282 Q 575.315 116.441 566.684 144.506 Q 552.126 191.844 515.085 215.255 Q 505.739 225.171 494.626 221.013 " +
                        "Q 487.874 218.486 474.001 206.354 Q 453.074 188.052 440.816 187.214 Q 432.573 182.13 421.38 162.181 Q 403.5 130.314 383.105 125.625 " +
                        "Q 359.096 113.289 332.999 112.021 Q 306.902 110.752 278.717 120.551 Q 249.627 130.664 231.317 148.588 Q 213.007 166.512 205.476 192.246 " +
                        "Q 179.467 162.66 166.561 117.17 Q 158.847 89.9789 151.384 32.9629 L 147.216 2.60501 M 140.759 59.7339 L 140.765 59.7378 L 140.763 59.7398 " +
                        "L 140.763 59.7418 L 140.761 59.7418 L 140.761 59.7398 L 140.759 59.7378 L 140.759 59.7358 L 140.759 59.7339 M 140.761 59.7456 " +
                        "Q 142.029 101.321 158.808 141.12 Q 175.587 180.919 207.878 218.943 Q 211.115 216.063 214.445 213.408 Q 216.671 183.956 234.607 163.882 " +
                        "Q 252.544 143.809 286.191 133.115 Q 319.05 122.672 345.997 126.745 Q 372.944 130.818 393.98 149.408 Q 421.683 169.052 411.697 192.236 " +
                        "Q 471.126 208.06 498.041 246.994 Q 539.927 219.716 561.858 189.307 Q 592.554 146.745 589.419 93.4351 Q 608.743 130.997 614.447 163.775 " +
                        "Q 620.15 196.554 612.235 224.548 Q 604.319 252.542 582.784 275.753 Q 561.25 298.964 526.095 317.39 Q 528.328 324.145 529.398 339.766 " +
                        "Q 530.649 358.017 534.023 365.201 Q 558.192 350.21 582.998 346.664 Q 607.804 343.118 633.247 351.016 Q 679.024 365.228 717.043 412.5 " +
                        "Q 689.365 434.025 652.575 443.46 Q 630.502 449.121 585.484 453.453 L 554.132 456.826 Q 555.838 500.823 545.165 585.251 Q 539.292 631.703 538.826 649.437 " +
                        "Q 525.482 674.646 500.572 691.117 Q 475.663 707.588 439.188 715.321 Q 404.697 722.634 381.169 719.358 Q 357.641 716.082 345.076 702.216 " +
                        "Q 334.208 690.224 335.572 654.705 Q 335.971 644.299 335.707 640.068 Q 331.563 642.14 318.291 652.463 Q 292.946 672.177 274.574 682.964 " +
                        "Q 280.477 702.797 303.728 742.67 Q 331.775 790.765 336.842 815.81 Q 345.319 857.714 315.591 893.861 Q 315.591 878.978 306.378 851.078 " +
                        "Q 297.156 823.149 296.634 807.5 Q 296.339 810.746 296.372 820.832 Q 296.542 872.585 278.967 903.217 Q 261.392 933.848 226.072 943.359 " +
                        "Q 239.339 913.288 246.214 885.433 Q 254.507 851.833 254.507 818.029 Q 243.697 847.511 225.545 867.661 Q 202.533 893.204 177.625 889.646 " +
                        "Q 199.934 844.351 198.881 801.171 Q 197.827 757.991 173.412 716.925 L 172.75 715.777 Q 147.703 716.046 123.157 706.398 Q 105.031 699.273 96.7066 691.705 " +
                        "L 98.7066 691.173 Q 121.523 685.12 133.058 680.58 Q 153.742 672.439 155.427 664.287 Q 124.528 678.614 104.741 680.599 Q 71.7222 683.911 57.6363 657.89 " +
                        "Q 54.178 651.502 52.0389 644.578 Q 49.9893 637.944 49.15 630.816 Q 60.4554 636.919 89.1539 632.668 Q 98.6355 631.263 107.946 621.74 " +
                        "Q 117.257 612.218 126.397 594.577 Q 133.239 581.37 135.791 571.154 Q 138.358 560.881 134.441 562.105 Q 113.377 568.687 90.207 558.682 " +
                        "Q 78.6219 553.68 71.2496 547.361 L 70.7631 547.694 L 70.2808 548.031 Q 79.2477 530.959 97.8104 502.573 Q 109.483 484.723 112.244 478.99 " +
                        "Q 117.778 467.493 123.11 407.823 Q 131.963 308.755 147.769 293.3 Q 150.695 289.757 154.045 285.309 L 160.339 276.714 Q 155.601 276.131 152.345 273.527 " +
                        "Q 132.158 257.38 122.121 232.139 Q 112.084 206.899 112.198 172.566 Q 112.398 112.052 140.761 59.7456 M 345.447 374.378 Q 344.129 374.297 342.701 374.41 " +
                        "Q 331.04 375.334 316.392 386.744 Q 313.724 386.488 311.148 386.454 Q 308.441 386.418 305.816 386.626 Q 278.49 390.205 260.926 400.489 " +
                        "Q 243.362 410.774 235.56 427.765 Q 228.461 440.292 225.502 455.392 Q 222.762 469.378 223.697 484.867 Q 227.311 496.286 239.421 500.276 " +
                        "Q 247.995 503.101 262.57 502.392 Q 293.938 501.428 318.455 481.094 Q 331.227 470.5 338.303 457.607 Q 345.379 444.714 346.759 429.521 " +
                        "Q 348.116 421.902 347.071 407.104 L 346.642 400.289 Q 349.628 396.695 357.523 392.852 Q 365.552 388.943 370.373 388.89 Q 368.267 386.976 362.254 388.058 " +
                        "Q 358.705 388.697 350.739 391.223 Q 342.201 393.93 339.734 393.964 Q 339.369 393.773 338.657 393.339 Q 337.747 392.784 337.275 392.56 " +
                        "Q 337.025 388.989 346.603 384.507 Q 353.926 381.08 362.8 378.744 Q 355.564 377.459 347.72 379.644 Q 339.877 381.829 331.426 387.483 " +
                        "Q 329.446 388.808 328.65 389.281 Q 327.879 389.041 326.919 388.787 L 325.175 388.343 Q 325.137 384.837 331.359 381.139 Q 337.608 377.425 348.085 374.761 " +
                        "Q 346.816 374.463 345.447 374.378 M 310.287 392.765 Q 313.074 392.683 315.707 392.851 Q 322.352 393.276 328.216 395.3 Q 334.438 397.447 339.861 401.419 " +
                        "L 339.857 401.419 Q 342.813 429.701 333.896 450.293 Q 324.979 470.885 304.189 483.789 Q 303.627 475.288 293.34 471.331 Q 284.603 467.97 269.249 468.011 " +
                        "Q 261.259 468.03 244.143 469.111 L 229.79 469.923 Q 229.691 469.927 229.4 470.002 L 228.777 470.175 Q 231.673 450.306 240.599 433.126 " +
                        "Q 252.307 410.591 270.302 403.115 Q 294.057 393.245 310.287 392.765 M 61.7847 548.541 Q 64.3595 565.276 93.2975 571.556 Q 111.749 575.561 126.712 574.41 " +
                        "Q 125.078 582.042 115.49 598.694 Q 104.126 618.43 94.7554 624.119 Q 78.9446 630.993 58.9844 627.358 Q 41.2315 624.125 38.4526 618.033 " +
                        "Q 32.174 604.268 40.6079 581.385 Q 48.5238 559.907 61.7847 548.541"
                }
            }

            Rectangle {
                x: 64
                y: 128
                width: 16
                height: 6
                radius: 3
                color: pupilHH.hovered ? "red" : "transparent"
                HoverHandler {
                    id: pupilHH
                    objectName: "pupil"
                    cursorShape: Qt.CrossCursor
                }
            }
        }
    }
}
