#!/usr/bin/env python
# Copyright (C) 2022 The Qt Company Ltd.
# SPDX-License-Identifier: LicenseRef-Qt-Commercial

import os
import sys
import unittest

from pathlib import Path
sys.path.append(os.fspath(Path(__file__).resolve().parents[1]))
from init_paths import init_test_paths
init_test_paths(False)

from PySide6.QtCore import QObject, SIGNAL


class ArgsDontMatch(unittest.TestCase):

    def callback(self, arg1):
        self.ok = True

    def testConnectSignalToSlotWithLessArgs(self):
        self.ok = False
        obj1 = QObject()
        QObject.connect(obj1, SIGNAL('the_signal(int, int, int)'), self.callback)
        obj1.emit(SIGNAL('the_signal(int, int, int)'), 1, 2, 3)

        self.assertTrue(self.ok)


if __name__ == '__main__':
    unittest.main()
