# Copyright (C) 2022 The Qt Company Ltd.
# SPDX-License-Identifier: LicenseRef-Qt-Commercial

from typing import Optional

from checkboxpanel import CheckBoxPanel

from PySide6.QtWidgets import QWidget

_OPTIONS = [
    ('--enable-pyside-extensions', 'Enable PySide extensions', False,
     """Enable PySide extensions, such as support for signal/slots,
use this if you are creating a binding for a Qt-based library."""),
    ('--avoid-protected-hack', 'Avoid protected hack', True,
     "Avoid the use of the '#define protected public' hack."),
    ('--use-global-header', 'Use global headers', True,
     "Use the global headers in generated code."),
    ('--enable-parent-ctor-heuristic',
     'Enable constructor parent relationship heuristics', True,
     'Enable heuristics to detect parent relationship on constructors.'),
    ('--enable-return-value-heuristic',
     'Enable return value parent heuristics', True,
     """Enable heuristics to detect parent relationship on return values
(USE WITH CAUTION!)"""),
    ('--use-isnull-as-nb_nonzero', 'Use isNull() as nb_nonzero', True,
     """If a class have an isNull() const method, it will be used to compute
the value of boolean casts""")
]


class ShibokenOptionsPanel(CheckBoxPanel):
    """A Panel presenting Shiboken Options"""

    def __init__(self, parent: Optional[QWidget] = None):
        t = 'Shiboken Options'
        super(ShibokenOptionsPanel, self).__init__(t, _OPTIONS, 2, parent)
