/* @(#)mem.c	1.2 03/09/13 Copyright 1998-2003 J. Schilling */
#ifndef lint
static	char sccsid[] =
	"@(#)mem.c	1.2 03/09/13 Copyright 1998-2003 J. Schilling";
#endif
/*
 *	Memory handling with error checking
 *
 *	Copyright (c) 1998-2003 J. Schilling
 */
/*
 * Copyright Jrg Schilling. All rights reserved.
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only.
 * See the file CDDL.Schily.txt in this distribution or
 * http://opensource.org/licenses/cddl1.php for details.
 */

#include <mconfig.h>
#include <stdio.h>
#include <stdxlib.h>
#include <unixstd.h>
#include <strdefs.h>
#include <standard.h>
#include <schily.h>
#include "starsubs.h"

EXPORT	void	*__malloc	__PR((size_t size, char *msg));
EXPORT	void	*__realloc	__PR((void *ptr, size_t size, char *msg));
EXPORT	char	*__savestr	__PR((const char *s));

EXPORT void *
__malloc(size, msg)
	size_t	size;
	char	*msg;
{
	void	*ret;

	ret = malloc(size);
	if (ret == NULL) {
		comerr("Cannot allocate memory for %s.\n", msg);
		/* NOTREACHED */
	}
	return (ret);
}

EXPORT void *
__realloc(ptr, size, msg)
	void	*ptr;
	size_t	size;
	char	*msg;
{
	void	*ret;

	if (ptr == NULL)
		ret = malloc(size);
	else
		ret = realloc(ptr, size);
	if (ret == NULL) {
		comerr("Cannot realloc memory for %s.\n", msg);
		/* NOTREACHED */
	}
	return (ret);
}

EXPORT char *
__savestr(s)
	const char	*s;
{
	char	*ret = __malloc(strlen(s)+1, "saved string");

	strcpy(ret, s);
	return (ret);
}
