% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset-format.R
\name{JsonFileFormat}
\alias{JsonFileFormat}
\title{JSON dataset file format}
\value{
A \code{JsonFileFormat} object
}
\description{
A \code{JsonFileFormat} is a \link{FileFormat} subclass which holds information about how to
read and parse the files included in a JSON \code{Dataset}.
}
\section{Factory}{

\code{JsonFileFormat$create()} can take options in the form of lists passed through as \code{parse_options},
or \code{read_options} parameters.

Available \code{read_options} parameters:
\itemize{
\item \code{use_threads}: Whether to use the global CPU thread pool. Default \code{TRUE}. If \code{FALSE}, JSON input must end with an
empty line.
\item \code{block_size}: Block size we request from the IO layer; also determines size of chunks when \code{use_threads}
is \code{TRUE}.
}

Available \code{parse_options} parameters:
\itemize{
\item \code{newlines_in_values}:Logical: are values allowed to contain CR (\code{0x0d} or \verb{\\r}) and LF (\code{0x0a} or \verb{\\n})
characters? (default \code{FALSE})
}
}

\examples{
\dontshow{if (arrow_with_dataset()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontshow{\}) # examplesIf}
}
\seealso{
\link{FileFormat}
}
