;; NOTE: Assertions have been generated by update_lit_checks.py --output=fuzz-exec and should not be edited.

;; RUN: wasm-opt --enable-nontrapping-float-to-int %s --llvm-nontrapping-fptoint-lowering --fuzz-exec -q | filecheck %s

(module

  (func $assert_i32 (param i32 i32)
    (if (i32.ne (local.get 1) (local.get 0))
    (then (unreachable)))
  )
  (func $assert_i64 (param i64 i64)
    (if (i64.ne (local.get 1) (local.get 0))
    (then (unreachable)))
  )

  (func $i32.trunc_sat_f32_s (param $x f32) (result i32) (i32.trunc_sat_f32_s (local.get $x)))
  (func $i32.trunc_sat_f32_u (param $x f32) (result i32) (i32.trunc_sat_f32_u (local.get $x)))
  (func $i32.trunc_sat_f64_s (param $x f64) (result i32) (i32.trunc_sat_f64_s (local.get $x)))
  (func $i32.trunc_sat_f64_u (param $x f64) (result i32) (i32.trunc_sat_f64_u (local.get $x)))
  (func $i64.trunc_sat_f32_s (param $x f32) (result i64) (i64.trunc_sat_f32_s (local.get $x)))
  (func $i64.trunc_sat_f32_u (param $x f32) (result i64) (i64.trunc_sat_f32_u (local.get $x)))
  (func $i64.trunc_sat_f64_s (param $x f64) (result i64) (i64.trunc_sat_f64_s (local.get $x)))
  (func $i64.trunc_sat_f64_u (param $x f64) (result i64) (i64.trunc_sat_f64_u (local.get $x)))

  ;; CHECK:      [fuzz-exec] calling f32_i32
  (func $f32_i32 (export "f32_i32")
    (call $assert_i32 (call $i32.trunc_sat_f32_s (f32.const 0.0)) (i32.const 0))
    (call $assert_i32 (call $i32.trunc_sat_f32_s (f32.const -0.0)) (i32.const 0))
    (call $assert_i32 (call $i32.trunc_sat_f32_s (f32.const 0x1p-149)) (i32.const 0))
    (call $assert_i32 (call $i32.trunc_sat_f32_s (f32.const -0x1p-149)) (i32.const 0))
    (call $assert_i32 (call $i32.trunc_sat_f32_s (f32.const 1.0)) (i32.const 1))
    (call $assert_i32 (call $i32.trunc_sat_f32_s (f32.const 0x1.19999ap+0)) (i32.const 1))
    (call $assert_i32 (call $i32.trunc_sat_f32_s (f32.const 1.5)) (i32.const 1))
    (call $assert_i32 (call $i32.trunc_sat_f32_s (f32.const -1.0)) (i32.const -1))
    (call $assert_i32 (call $i32.trunc_sat_f32_s (f32.const -0x1.19999ap+0)) (i32.const -1))
    (call $assert_i32 (call $i32.trunc_sat_f32_s (f32.const -1.5)) (i32.const -1))
    (call $assert_i32 (call $i32.trunc_sat_f32_s (f32.const -1.9)) (i32.const -1))
    (call $assert_i32 (call $i32.trunc_sat_f32_s (f32.const -2.0)) (i32.const -2))
    (call $assert_i32 (call $i32.trunc_sat_f32_s (f32.const 2147483520.0)) (i32.const 2147483520))
    (call $assert_i32 (call $i32.trunc_sat_f32_s (f32.const -2147483648.0)) (i32.const -2147483648))
    ;; For out-of-range inputs, we ensure there is no trap, but do not check the value
    (drop (call $i32.trunc_sat_f32_s (f32.const 2147483648.0)))
    (call $assert_i32 (call $i32.trunc_sat_f32_s (f32.const -2147483904.0)) (i32.const 0x80000000))
    (drop (call $i32.trunc_sat_f32_s (f32.const inf)))
    (drop (call $i32.trunc_sat_f32_s (f32.const -inf)))
    (drop (call $i32.trunc_sat_f32_s (f32.const nan)))
    (drop (call $i32.trunc_sat_f32_s (f32.const nan:0x200000)))
    (drop (call $i32.trunc_sat_f32_s (f32.const -nan)))
    (drop (call $i32.trunc_sat_f32_s (f32.const -nan:0x200000)))
  )

  ;; CHECK:      [fuzz-exec] calling f32_i32_u
  (func $f32_i32_u (export "f32_i32_u")
    (call $assert_i32 (call $i32.trunc_sat_f32_u (f32.const 0.0)) (i32.const 0))
    (call $assert_i32 (call $i32.trunc_sat_f32_u (f32.const -0.0)) (i32.const 0))
    (call $assert_i32 (call $i32.trunc_sat_f32_u (f32.const 0x1p-149)) (i32.const 0))
    (call $assert_i32 (call $i32.trunc_sat_f32_u (f32.const -0x1p-149)) (i32.const 0))
    (call $assert_i32 (call $i32.trunc_sat_f32_u (f32.const 1.0)) (i32.const 1))
    (call $assert_i32 (call $i32.trunc_sat_f32_u (f32.const 0x1.19999ap+0)) (i32.const 1))
    (call $assert_i32 (call $i32.trunc_sat_f32_u (f32.const 1.5)) (i32.const 1))
    (call $assert_i32 (call $i32.trunc_sat_f32_u (f32.const 1.9)) (i32.const 1))
    (call $assert_i32 (call $i32.trunc_sat_f32_u (f32.const 2.0)) (i32.const 2))
    (call $assert_i32 (call $i32.trunc_sat_f32_u (f32.const 2147483648)) (i32.const -2147483648)) ;; 0x1.00000p+31 -> 8000 0000
    (call $assert_i32 (call $i32.trunc_sat_f32_u (f32.const 4294967040.0)) (i32.const -256))
    (call $assert_i32 (call $i32.trunc_sat_f32_u (f32.const -0x1.ccccccp-1)) (i32.const 0))
    (call $assert_i32 (call $i32.trunc_sat_f32_u (f32.const -0x1.fffffep-1)) (i32.const 0))
    (drop (call $i32.trunc_sat_f32_u (f32.const 4294967296.0)))
    (drop (call $i32.trunc_sat_f32_u (f32.const -1.0)))
    (drop (call $i32.trunc_sat_f32_u (f32.const inf)))
    (drop (call $i32.trunc_sat_f32_u (f32.const -inf)))
    (drop (call $i32.trunc_sat_f32_u (f32.const nan)))
    (drop (call $i32.trunc_sat_f32_u (f32.const nan:0x200000)))
    (drop (call $i32.trunc_sat_f32_u (f32.const -nan)))
    (drop (call $i32.trunc_sat_f32_u (f32.const -nan:0x200000)))
  )

  ;; CHECK:      [fuzz-exec] calling f64_i32
  (func $f64_i32 (export "f64_i32")
    (call $assert_i32 (call $i32.trunc_sat_f64_s (f64.const 0.0)) (i32.const 0))
    (call $assert_i32 (call $i32.trunc_sat_f64_s (f64.const -0.0)) (i32.const 0))
    (call $assert_i32 (call $i32.trunc_sat_f64_s (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
    (call $assert_i32 (call $i32.trunc_sat_f64_s (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
    (call $assert_i32 (call $i32.trunc_sat_f64_s (f64.const 1.0)) (i32.const 1))
    (call $assert_i32 (call $i32.trunc_sat_f64_s (f64.const 0x1.199999999999ap+0)) (i32.const 1))
    (call $assert_i32 (call $i32.trunc_sat_f64_s (f64.const 1.5)) (i32.const 1))
    (call $assert_i32 (call $i32.trunc_sat_f64_s (f64.const -1.0)) (i32.const -1))
    (call $assert_i32 (call $i32.trunc_sat_f64_s (f64.const -0x1.199999999999ap+0)) (i32.const -1))
    (call $assert_i32 (call $i32.trunc_sat_f64_s (f64.const -1.5)) (i32.const -1))
    (call $assert_i32 (call $i32.trunc_sat_f64_s (f64.const -1.9)) (i32.const -1))
    (call $assert_i32 (call $i32.trunc_sat_f64_s (f64.const -2.0)) (i32.const -2))
    (call $assert_i32 (call $i32.trunc_sat_f64_s (f64.const -2147483648.0)) (i32.const -2147483648))
    (drop (call $i32.trunc_sat_f64_s (f64.const 2147483647.0)))
    (drop (call $i32.trunc_sat_f64_s (f64.const 2147483648.0)))
    (drop (call $i32.trunc_sat_f64_s (f64.const -2147483649.0)))
    (drop (call $i32.trunc_sat_f64_s (f64.const inf)))
    (drop (call $i32.trunc_sat_f64_s (f64.const -inf)))
    (drop (call $i32.trunc_sat_f64_s (f64.const nan)))
    (drop (call $i32.trunc_sat_f64_s (f64.const nan:0x4000000000000)))
    (drop (call $i32.trunc_sat_f64_s (f64.const -nan)))
    (drop (call $i32.trunc_sat_f64_s (f64.const -nan:0x4000000000000)))
  )

  ;; CHECK:      [fuzz-exec] calling f64_i32_s
  (func $f64_i32_s (export "f64_i32_s")
    (call $assert_i32 (call $i32.trunc_sat_f64_u (f64.const 0.0)) (i32.const 0))
    (call $assert_i32 (call $i32.trunc_sat_f64_u (f64.const -0.0)) (i32.const 0))
    (call $assert_i32 (call $i32.trunc_sat_f64_u (f64.const 0x0.0000000000001p-1022)) (i32.const 0))
    (call $assert_i32 (call $i32.trunc_sat_f64_u (f64.const -0x0.0000000000001p-1022)) (i32.const 0))
    (call $assert_i32 (call $i32.trunc_sat_f64_u (f64.const 1.0)) (i32.const 1))
    (call $assert_i32 (call $i32.trunc_sat_f64_u (f64.const 0x1.199999999999ap+0)) (i32.const 1))
    (call $assert_i32 (call $i32.trunc_sat_f64_u (f64.const 1.5)) (i32.const 1))
    (call $assert_i32 (call $i32.trunc_sat_f64_u (f64.const 1.9)) (i32.const 1))
    (call $assert_i32 (call $i32.trunc_sat_f64_u (f64.const 2.0)) (i32.const 2))
    (call $assert_i32 (call $i32.trunc_sat_f64_u (f64.const 2147483648)) (i32.const -2147483648)) ;; 0x1.00000p+31 -> 8000 0000

    (drop (call $i32.trunc_sat_f64_u (f64.const 4294967295.0)))
    (call $assert_i32 (call $i32.trunc_sat_f64_u (f64.const -0x1.ccccccccccccdp-1)) (i32.const 0))
    (call $assert_i32 (call $i32.trunc_sat_f64_u (f64.const -0x1.fffffffffffffp-1)) (i32.const 0))
    (call $assert_i32 (call $i32.trunc_sat_f64_u (f64.const 1e8)) (i32.const 100000000))
    (drop (call $i32.trunc_sat_f64_u (f64.const 4294967296.0)))
    (call $assert_i32 (call $i32.trunc_sat_f64_u (f64.const -1.0)) (i32.const 0x00000000))
    (drop (call $i32.trunc_sat_f64_u (f64.const 1e16)))
    (drop (call $i32.trunc_sat_f64_u (f64.const 1e30)))
    (drop (call $i32.trunc_sat_f64_u (f64.const 9223372036854775808)))
    (drop (call $i32.trunc_sat_f64_u (f64.const inf)))
    (drop (call $i32.trunc_sat_f64_u (f64.const -inf)))
    (drop (call $i32.trunc_sat_f64_u (f64.const nan)))
    (drop (call $i32.trunc_sat_f64_u (f64.const nan:0x4000000000000)))
    (drop (call $i32.trunc_sat_f64_u (f64.const -nan)))
    (drop (call $i32.trunc_sat_f64_u (f64.const -nan:0x4000000000000)))
  )

  ;; CHECK:      [fuzz-exec] calling f32_i64
  (func $f32_i64 (export "f32_i64")
    (call $assert_i64 (call $i64.trunc_sat_f32_s (f32.const 0.0)) (i64.const 0))
    (call $assert_i64 (call $i64.trunc_sat_f32_s (f32.const -0.0)) (i64.const 0))
    (call $assert_i64 (call $i64.trunc_sat_f32_s (f32.const 0x1p-149)) (i64.const 0))
    (call $assert_i64 (call $i64.trunc_sat_f32_s (f32.const -0x1p-149)) (i64.const 0))
    (call $assert_i64 (call $i64.trunc_sat_f32_s (f32.const 1.0)) (i64.const 1))
    (call $assert_i64 (call $i64.trunc_sat_f32_s (f32.const 0x1.19999ap+0)) (i64.const 1))
    (call $assert_i64 (call $i64.trunc_sat_f32_s (f32.const 1.5)) (i64.const 1))
    (call $assert_i64 (call $i64.trunc_sat_f32_s (f32.const -1.0)) (i64.const -1))
    (call $assert_i64 (call $i64.trunc_sat_f32_s (f32.const -0x1.19999ap+0)) (i64.const -1))
    (call $assert_i64 (call $i64.trunc_sat_f32_s (f32.const -1.5)) (i64.const -1))
    (call $assert_i64 (call $i64.trunc_sat_f32_s (f32.const -1.9)) (i64.const -1))
    (call $assert_i64 (call $i64.trunc_sat_f32_s (f32.const -2.0)) (i64.const -2))
    (call $assert_i64 (call $i64.trunc_sat_f32_s (f32.const 4294967296)) (i64.const 4294967296)) ;; 0x1.00000p+32 -> 1 0000 0000
    (call $assert_i64 (call $i64.trunc_sat_f32_s (f32.const -4294967296)) (i64.const -4294967296)) ;; -0x1.00000p+32 -> ffff ffff 0000 0000
    (call $assert_i64 (call $i64.trunc_sat_f32_s (f32.const 9223371487098961920.0)) (i64.const 9223371487098961920))
    (call $assert_i64 (call $i64.trunc_sat_f32_s (f32.const -9223372036854775808.0)) (i64.const -9223372036854775808))
    (drop (call $i64.trunc_sat_f32_s (f32.const 9223372036854775808.0)))
    (drop (call $i64.trunc_sat_f32_s (f32.const -9223373136366403584.0)))
    (drop (call $i64.trunc_sat_f32_s (f32.const inf)))
    (drop (call $i64.trunc_sat_f32_s (f32.const -inf)))
    (drop (call $i64.trunc_sat_f32_s (f32.const nan)))
    (drop (call $i64.trunc_sat_f32_s (f32.const nan:0x200000)))
    (drop (call $i64.trunc_sat_f32_s (f32.const -nan)))
    (drop (call $i64.trunc_sat_f32_s (f32.const -nan:0x200000)))
  )

  ;; CHECK:      [fuzz-exec] calling f32_i64_u
  (func $f32_i64_u (export "f32_i64_u")
    (call $assert_i64 (call $i64.trunc_sat_f32_u (f32.const 0.0)) (i64.const 0))
    (call $assert_i64 (call $i64.trunc_sat_f32_u (f32.const -0.0)) (i64.const 0))
    (call $assert_i64 (call $i64.trunc_sat_f32_u (f32.const 0x1p-149)) (i64.const 0))
    (call $assert_i64 (call $i64.trunc_sat_f32_u (f32.const -0x1p-149)) (i64.const 0))
    (call $assert_i64 (call $i64.trunc_sat_f32_u (f32.const 1.0)) (i64.const 1))
    (call $assert_i64 (call $i64.trunc_sat_f32_u (f32.const 0x1.19999ap+0)) (i64.const 1))
    (call $assert_i64 (call $i64.trunc_sat_f32_u (f32.const 1.5)) (i64.const 1))
    (call $assert_i64 (call $i64.trunc_sat_f32_u (f32.const 4294967296)) (i64.const 4294967296))
    (call $assert_i64 (call $i64.trunc_sat_f32_u (f32.const 18446742974197923840.0)) (i64.const -1099511627776))
    (call $assert_i64 (call $i64.trunc_sat_f32_u (f32.const -0x1.ccccccp-1)) (i64.const 0))
    (call $assert_i64 (call $i64.trunc_sat_f32_u (f32.const -0x1.fffffep-1)) (i64.const 0))
    (drop (call $i64.trunc_sat_f32_u (f32.const 18446744073709551616.0)))
    (call $assert_i64 (call $i64.trunc_sat_f32_u (f32.const -1.0)) (i64.const 0x0000000000000000))
    (drop (call $i64.trunc_sat_f32_u (f32.const inf)))
    (drop (call $i64.trunc_sat_f32_u (f32.const -inf)))
    (drop (call $i64.trunc_sat_f32_u (f32.const nan)))
    (drop (call $i64.trunc_sat_f32_u (f32.const nan:0x200000)))
    (drop (call $i64.trunc_sat_f32_u (f32.const -nan)))
    (drop (call $i64.trunc_sat_f32_u (f32.const -nan:0x200000)))
  )

  ;; CHECK:      [fuzz-exec] calling f64_i64
  (func $f64_i64 (export "f64_i64")
    (call $assert_i64 (call $i64.trunc_sat_f64_s (f64.const 0.0)) (i64.const 0))
    (call $assert_i64 (call $i64.trunc_sat_f64_s (f64.const -0.0)) (i64.const 0))
    (call $assert_i64 (call $i64.trunc_sat_f64_s (f64.const 0x0.0000000000001p-1022)) (i64.const 0))
    (call $assert_i64 (call $i64.trunc_sat_f64_s (f64.const -0x0.0000000000001p-1022)) (i64.const 0))
    (call $assert_i64 (call $i64.trunc_sat_f64_s (f64.const 1.0)) (i64.const 1))
    (call $assert_i64 (call $i64.trunc_sat_f64_s (f64.const 0x1.199999999999ap+0)) (i64.const 1))
    (call $assert_i64 (call $i64.trunc_sat_f64_s (f64.const 1.5)) (i64.const 1))
    (call $assert_i64 (call $i64.trunc_sat_f64_s (f64.const -1.0)) (i64.const -1))
    (call $assert_i64 (call $i64.trunc_sat_f64_s (f64.const -0x1.199999999999ap+0)) (i64.const -1))
    (call $assert_i64 (call $i64.trunc_sat_f64_s (f64.const -1.5)) (i64.const -1))
    (call $assert_i64 (call $i64.trunc_sat_f64_s (f64.const -1.9)) (i64.const -1))
    (call $assert_i64 (call $i64.trunc_sat_f64_s (f64.const -2.0)) (i64.const -2))
    (call $assert_i64 (call $i64.trunc_sat_f64_s (f64.const 4294967296)) (i64.const 4294967296)) ;; 0x1.00000p+32 -> 1 0000 0000
    (call $assert_i64 (call $i64.trunc_sat_f64_s (f64.const -4294967296)) (i64.const -4294967296)) ;; -0x1.00000p+32 -> ffff ffff 0000 0000
    (call $assert_i64 (call $i64.trunc_sat_f64_s (f64.const 9223372036854774784.0)) (i64.const 9223372036854774784))
    (call $assert_i64 (call $i64.trunc_sat_f64_s (f64.const -9223372036854775808.0)) (i64.const -9223372036854775808))
    (drop (call $i64.trunc_sat_f64_s (f64.const 9223372036854775808.0)))
    (call $assert_i64 (call $i64.trunc_sat_f64_s (f64.const -9223372036854777856.0)) (i64.const 0x8000000000000000))
    (drop (call $i64.trunc_sat_f64_s (f64.const inf)))
    (drop (call $i64.trunc_sat_f64_s (f64.const -inf)))
    (drop (call $i64.trunc_sat_f64_s (f64.const nan)))
    (drop (call $i64.trunc_sat_f64_s (f64.const nan:0x4000000000000)))
    (drop (call $i64.trunc_sat_f64_s (f64.const -nan)))
    (drop (call $i64.trunc_sat_f64_s (f64.const -nan:0x4000000000000)))
  )

  ;; CHECK:      [fuzz-exec] calling f64_i64_u
  (func $f64_i64_u (export "f64_i64_u")
    (call $assert_i64 (call $i64.trunc_sat_f64_u (f64.const 0.0)) (i64.const 0))
    (call $assert_i64 (call $i64.trunc_sat_f64_u (f64.const -0.0)) (i64.const 0))
    (call $assert_i64 (call $i64.trunc_sat_f64_u (f64.const 0x0.0000000000001p-1022)) (i64.const 0))
    (call $assert_i64 (call $i64.trunc_sat_f64_u (f64.const -0x0.0000000000001p-1022)) (i64.const 0))
    (call $assert_i64 (call $i64.trunc_sat_f64_u (f64.const 1.0)) (i64.const 1))
    (call $assert_i64 (call $i64.trunc_sat_f64_u (f64.const 0x1.199999999999ap+0)) (i64.const 1))
    (call $assert_i64 (call $i64.trunc_sat_f64_u (f64.const 1.5)) (i64.const 1))
    (call $assert_i64 (call $i64.trunc_sat_f64_u (f64.const 4294967295)) (i64.const 0xffffffff))
    (call $assert_i64 (call $i64.trunc_sat_f64_u (f64.const 4294967296)) (i64.const 0x100000000))
    (call $assert_i64 (call $i64.trunc_sat_f64_u (f64.const 18446744073709549568.0)) (i64.const -2048))
    (call $assert_i64 (call $i64.trunc_sat_f64_u (f64.const -0x1.ccccccccccccdp-1)) (i64.const 0))
    (call $assert_i64 (call $i64.trunc_sat_f64_u (f64.const -0x1.fffffffffffffp-1)) (i64.const 0))
    (call $assert_i64 (call $i64.trunc_sat_f64_u (f64.const 1e8)) (i64.const 100000000))
    (call $assert_i64 (call $i64.trunc_sat_f64_u (f64.const 1e16)) (i64.const 10000000000000000))
    (call $assert_i64 (call $i64.trunc_sat_f64_u (f64.const 9223372036854775808)) (i64.const -9223372036854775808))
    (drop (call $i64.trunc_sat_f64_u (f64.const 18446744073709551616.0)))
    (call $assert_i64 (call $i64.trunc_sat_f64_u (f64.const -1.0)) (i64.const 0x0000000000000000))
    (drop (call $i64.trunc_sat_f64_u (f64.const inf)))
    (drop (call $i64.trunc_sat_f64_u (f64.const -inf)))
    (drop (call $i64.trunc_sat_f64_u (f64.const nan)))
    (drop (call $i64.trunc_sat_f64_u (f64.const nan:0x4000000000000)))
    (drop (call $i64.trunc_sat_f64_u (f64.const -nan)))
    (drop (call $i64.trunc_sat_f64_u (f64.const -nan:0x4000000000000)))
  )
)
;; CHECK:      [fuzz-exec] calling f32_i32

;; CHECK:      [fuzz-exec] calling f32_i32_u

;; CHECK:      [fuzz-exec] calling f64_i32

;; CHECK:      [fuzz-exec] calling f64_i32_s

;; CHECK:      [fuzz-exec] calling f32_i64

;; CHECK:      [fuzz-exec] calling f32_i64_u

;; CHECK:      [fuzz-exec] calling f64_i64

;; CHECK:      [fuzz-exec] calling f64_i64_u
;; CHECK-NEXT: [fuzz-exec] comparing f32_i32
;; CHECK-NEXT: [fuzz-exec] comparing f32_i32_u
;; CHECK-NEXT: [fuzz-exec] comparing f32_i64
;; CHECK-NEXT: [fuzz-exec] comparing f32_i64_u
;; CHECK-NEXT: [fuzz-exec] comparing f64_i32
;; CHECK-NEXT: [fuzz-exec] comparing f64_i32_s
;; CHECK-NEXT: [fuzz-exec] comparing f64_i64
;; CHECK-NEXT: [fuzz-exec] comparing f64_i64_u
