
#line 1 "hb-ot-shaper-use-machine.rl"
/*
 * Copyright © 2015  Mozilla Foundation.
 * Copyright © 2015  Google, Inc.
 *
 *  This is part of HarfBuzz, a text shaping library.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE COPYRIGHT HOLDER HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 *
 * THE COPYRIGHT HOLDER SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE COPYRIGHT HOLDER HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 * Mozilla Author(s): Jonathan Kew
 * Google Author(s): Behdad Esfahbod
 */

#ifndef HB_OT_SHAPER_USE_MACHINE_HH
#define HB_OT_SHAPER_USE_MACHINE_HH

#include "hb.hh"

#include "hb-ot-shaper-syllabic.hh"

/* buffer var allocations */
#define use_category() ot_shaper_var_u8_category()

#define USE(Cat) use_syllable_machine_ex_##Cat

enum use_syllable_type_t {
  use_virama_terminated_cluster,
  use_sakot_terminated_cluster,
  use_standard_cluster,
  use_number_joiner_terminated_cluster,
  use_numeral_cluster,
  use_symbol_cluster,
  use_hieroglyph_cluster,
  use_broken_cluster,
  use_non_cluster,
};


#line 54 "hb-ot-shaper-use-machine.hh"
#define use_syllable_machine_ex_B 1u
#define use_syllable_machine_ex_CGJ 6u
#define use_syllable_machine_ex_CMAbv 31u
#define use_syllable_machine_ex_CMBlw 32u
#define use_syllable_machine_ex_CS 43u
#define use_syllable_machine_ex_FAbv 24u
#define use_syllable_machine_ex_FBlw 25u
#define use_syllable_machine_ex_FMAbv 45u
#define use_syllable_machine_ex_FMBlw 46u
#define use_syllable_machine_ex_FMPst 47u
#define use_syllable_machine_ex_FPst 26u
#define use_syllable_machine_ex_G 49u
#define use_syllable_machine_ex_GB 5u
#define use_syllable_machine_ex_H 12u
#define use_syllable_machine_ex_HM 54u
#define use_syllable_machine_ex_HN 13u
#define use_syllable_machine_ex_HR 55u
#define use_syllable_machine_ex_HVM 53u
#define use_syllable_machine_ex_IS 44u
#define use_syllable_machine_ex_J 50u
#define use_syllable_machine_ex_MAbv 27u
#define use_syllable_machine_ex_MBlw 28u
#define use_syllable_machine_ex_MPre 30u
#define use_syllable_machine_ex_MPst 29u
#define use_syllable_machine_ex_N 4u
#define use_syllable_machine_ex_O 0u
#define use_syllable_machine_ex_R 18u
#define use_syllable_machine_ex_RK 56u
#define use_syllable_machine_ex_SB 51u
#define use_syllable_machine_ex_SE 52u
#define use_syllable_machine_ex_SMAbv 41u
#define use_syllable_machine_ex_SMBlw 42u
#define use_syllable_machine_ex_SUB 11u
#define use_syllable_machine_ex_Sk 48u
#define use_syllable_machine_ex_VAbv 33u
#define use_syllable_machine_ex_VBlw 34u
#define use_syllable_machine_ex_VMAbv 37u
#define use_syllable_machine_ex_VMBlw 38u
#define use_syllable_machine_ex_VMPre 23u
#define use_syllable_machine_ex_VMPst 39u
#define use_syllable_machine_ex_VPre 22u
#define use_syllable_machine_ex_VPst 35u
#define use_syllable_machine_ex_WJ 16u
#define use_syllable_machine_ex_ZWNJ 14u


#line 99 "hb-ot-shaper-use-machine.hh"
static const unsigned char _use_syllable_machine_trans_keys[] = {
	49u, 51u, 0u, 56u, 11u, 56u, 11u, 56u, 1u, 53u, 14u, 48u, 14u, 47u, 14u, 47u, 
	14u, 47u, 14u, 46u, 14u, 46u, 14u, 14u, 14u, 48u, 14u, 48u, 14u, 48u, 1u, 14u, 
	14u, 48u, 14u, 53u, 14u, 53u, 14u, 53u, 14u, 53u, 12u, 53u, 14u, 53u, 12u, 53u, 
	12u, 53u, 12u, 53u, 11u, 56u, 1u, 14u, 1u, 48u, 14u, 42u, 14u, 42u, 11u, 56u, 
	1u, 53u, 14u, 48u, 14u, 47u, 14u, 47u, 14u, 47u, 14u, 46u, 14u, 46u, 14u, 14u, 
	14u, 48u, 14u, 48u, 14u, 48u, 1u, 14u, 14u, 48u, 14u, 53u, 14u, 53u, 14u, 53u, 
	14u, 53u, 12u, 53u, 14u, 53u, 12u, 53u, 12u, 53u, 12u, 53u, 11u, 56u, 1u, 14u, 
	1u, 14u, 1u, 48u, 14u, 14u, 13u, 14u, 4u, 14u, 11u, 56u, 11u, 56u, 1u, 53u, 
	14u, 48u, 14u, 47u, 14u, 47u, 14u, 47u, 14u, 46u, 14u, 46u, 14u, 14u, 14u, 48u, 
	14u, 48u, 14u, 48u, 1u, 14u, 14u, 48u, 14u, 53u, 14u, 53u, 14u, 53u, 14u, 53u, 
	12u, 53u, 14u, 53u, 12u, 53u, 12u, 53u, 12u, 53u, 11u, 56u, 1u, 14u, 1u, 14u, 
	1u, 48u, 14u, 14u, 11u, 56u, 1u, 53u, 14u, 48u, 14u, 47u, 14u, 47u, 14u, 47u, 
	14u, 46u, 14u, 46u, 14u, 14u, 14u, 48u, 14u, 48u, 14u, 48u, 1u, 14u, 14u, 48u, 
	14u, 53u, 14u, 53u, 14u, 53u, 14u, 53u, 12u, 53u, 14u, 53u, 12u, 53u, 12u, 53u, 
	12u, 53u, 11u, 56u, 1u, 14u, 1u, 48u, 4u, 14u, 13u, 14u, 1u, 56u, 14u, 42u, 
	14u, 42u, 1u, 5u, 14u, 55u, 14u, 51u, 14u, 52u, 14u, 54u, 11u, 56u, 0
};

static const char _use_syllable_machine_key_spans[] = {
	3, 57, 46, 46, 53, 35, 34, 34, 
	34, 33, 33, 1, 35, 35, 35, 14, 
	35, 40, 40, 40, 40, 42, 40, 42, 
	42, 42, 46, 14, 48, 29, 29, 46, 
	53, 35, 34, 34, 34, 33, 33, 1, 
	35, 35, 35, 14, 35, 40, 40, 40, 
	40, 42, 40, 42, 42, 42, 46, 14, 
	14, 48, 1, 2, 11, 46, 46, 53, 
	35, 34, 34, 34, 33, 33, 1, 35, 
	35, 35, 14, 35, 40, 40, 40, 40, 
	42, 40, 42, 42, 42, 46, 14, 14, 
	48, 1, 46, 53, 35, 34, 34, 34, 
	33, 33, 1, 35, 35, 35, 14, 35, 
	40, 40, 40, 40, 42, 40, 42, 42, 
	42, 46, 14, 48, 11, 2, 56, 29, 
	29, 5, 42, 38, 39, 41, 46
};

static const short _use_syllable_machine_index_offsets[] = {
	0, 4, 62, 109, 156, 210, 246, 281, 
	316, 351, 385, 419, 421, 457, 493, 529, 
	544, 580, 621, 662, 703, 744, 787, 828, 
	871, 914, 957, 1004, 1019, 1068, 1098, 1128, 
	1175, 1229, 1265, 1300, 1335, 1370, 1404, 1438, 
	1440, 1476, 1512, 1548, 1563, 1599, 1640, 1681, 
	1722, 1763, 1806, 1847, 1890, 1933, 1976, 2023, 
	2038, 2053, 2102, 2104, 2107, 2119, 2166, 2213, 
	2267, 2303, 2338, 2373, 2408, 2442, 2476, 2478, 
	2514, 2550, 2586, 2601, 2637, 2678, 2719, 2760, 
	2801, 2844, 2885, 2928, 2971, 3014, 3061, 3076, 
	3091, 3140, 3142, 3189, 3243, 3279, 3314, 3349, 
	3384, 3418, 3452, 3454, 3490, 3526, 3562, 3577, 
	3613, 3654, 3695, 3736, 3777, 3820, 3861, 3904, 
	3947, 3990, 4037, 4052, 4101, 4113, 4116, 4173, 
	4203, 4233, 4239, 4282, 4321, 4361, 4403
};

static const unsigned char _use_syllable_machine_indicies[] = {
	1, 0, 2, 0, 3, 4, 5, 5, 
	6, 7, 5, 5, 5, 5, 5, 8, 
	9, 10, 11, 5, 5, 5, 12, 5, 
	5, 5, 13, 14, 15, 16, 17, 18, 
	19, 20, 21, 8, 22, 23, 24, 25, 
	5, 26, 27, 28, 5, 29, 30, 31, 
	32, 33, 34, 35, 32, 1, 5, 36, 
	5, 37, 5, 5, 38, 5, 40, 41, 
	39, 42, 39, 39, 39, 39, 39, 39, 
	39, 43, 44, 45, 46, 47, 48, 49, 
	50, 51, 40, 52, 53, 54, 55, 39, 
	56, 57, 58, 39, 59, 60, 39, 61, 
	62, 63, 64, 61, 39, 39, 39, 39, 
	65, 39, 39, 64, 39, 40, 41, 39, 
	42, 39, 39, 39, 39, 39, 39, 39, 
	43, 44, 45, 46, 47, 48, 49, 50, 
	51, 40, 52, 53, 54, 55, 39, 56, 
	57, 58, 39, 39, 39, 39, 61, 62, 
	63, 64, 61, 39, 39, 39, 39, 65, 
	39, 39, 64, 39, 40, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 42, 39, 39, 39, 39, 39, 39, 
	39, 39, 44, 45, 46, 47, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	56, 57, 58, 39, 39, 39, 39, 39, 
	62, 63, 64, 66, 39, 39, 39, 39, 
	44, 39, 42, 39, 39, 39, 39, 39, 
	39, 39, 39, 44, 45, 46, 47, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 56, 57, 58, 39, 39, 39, 39, 
	39, 62, 63, 64, 66, 39, 42, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	45, 46, 47, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 62, 63, 64, 
	39, 42, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 46, 47, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	62, 63, 64, 39, 42, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	47, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 62, 63, 64, 39, 42, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 62, 63, 
	39, 42, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 63, 39, 42, 39, 42, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 45, 
	46, 47, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 56, 57, 58, 39, 
	39, 39, 39, 39, 62, 63, 64, 66, 
	39, 42, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 45, 46, 47, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 57, 58, 39, 39, 39, 39, 39, 
	62, 63, 64, 66, 39, 42, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 45, 
	46, 47, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 58, 39, 
	39, 39, 39, 39, 62, 63, 64, 66, 
	39, 67, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 42, 39, 
	42, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 45, 46, 47, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 62, 
	63, 64, 66, 39, 42, 39, 39, 39, 
	39, 39, 39, 39, 43, 44, 45, 46, 
	47, 39, 39, 39, 39, 39, 39, 53, 
	54, 55, 39, 56, 57, 58, 39, 39, 
	39, 39, 39, 62, 63, 64, 66, 39, 
	39, 39, 39, 44, 39, 42, 39, 39, 
	39, 39, 39, 39, 39, 39, 44, 45, 
	46, 47, 39, 39, 39, 39, 39, 39, 
	53, 54, 55, 39, 56, 57, 58, 39, 
	39, 39, 39, 39, 62, 63, 64, 66, 
	39, 39, 39, 39, 44, 39, 42, 39, 
	39, 39, 39, 39, 39, 39, 39, 44, 
	45, 46, 47, 39, 39, 39, 39, 39, 
	39, 39, 54, 55, 39, 56, 57, 58, 
	39, 39, 39, 39, 39, 62, 63, 64, 
	66, 39, 39, 39, 39, 44, 39, 42, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	44, 45, 46, 47, 39, 39, 39, 39, 
	39, 39, 39, 39, 55, 39, 56, 57, 
	58, 39, 39, 39, 39, 39, 62, 63, 
	64, 66, 39, 39, 39, 39, 44, 39, 
	68, 39, 42, 39, 39, 39, 39, 39, 
	39, 39, 43, 44, 45, 46, 47, 39, 
	49, 50, 39, 39, 39, 53, 54, 55, 
	39, 56, 57, 58, 39, 39, 39, 39, 
	39, 62, 63, 64, 66, 39, 39, 39, 
	39, 44, 39, 42, 39, 39, 39, 39, 
	39, 39, 39, 39, 44, 45, 46, 47, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 56, 57, 58, 39, 39, 39, 
	39, 39, 62, 63, 64, 66, 39, 39, 
	39, 39, 44, 39, 68, 39, 42, 39, 
	39, 39, 39, 39, 39, 39, 43, 44, 
	45, 46, 47, 39, 39, 50, 39, 39, 
	39, 53, 54, 55, 39, 56, 57, 58, 
	39, 39, 39, 39, 39, 62, 63, 64, 
	66, 39, 39, 39, 39, 44, 39, 68, 
	39, 42, 39, 39, 39, 39, 39, 39, 
	39, 43, 44, 45, 46, 47, 39, 39, 
	39, 39, 39, 39, 53, 54, 55, 39, 
	56, 57, 58, 39, 39, 39, 39, 39, 
	62, 63, 64, 66, 39, 39, 39, 39, 
	44, 39, 68, 39, 42, 39, 39, 39, 
	39, 39, 39, 39, 43, 44, 45, 46, 
	47, 48, 49, 50, 39, 39, 39, 53, 
	54, 55, 39, 56, 57, 58, 39, 39, 
	39, 39, 39, 62, 63, 64, 66, 39, 
	39, 39, 39, 44, 39, 40, 41, 39, 
	42, 39, 39, 39, 39, 39, 39, 39, 
	43, 44, 45, 46, 47, 48, 49, 50, 
	51, 39, 52, 53, 54, 55, 39, 56, 
	57, 58, 39, 39, 39, 39, 61, 62, 
	63, 64, 61, 39, 39, 39, 39, 65, 
	39, 39, 64, 39, 40, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 42, 39, 40, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	42, 39, 39, 39, 39, 39, 39, 39, 
	39, 44, 45, 46, 47, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 56, 
	57, 58, 39, 39, 39, 39, 39, 62, 
	63, 64, 66, 39, 42, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 59, 
	60, 39, 42, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 60, 39, 
	4, 70, 69, 71, 69, 69, 69, 69, 
	69, 69, 69, 72, 73, 74, 75, 76, 
	77, 78, 79, 80, 4, 81, 82, 83, 
	84, 69, 85, 86, 87, 69, 69, 69, 
	69, 88, 89, 90, 91, 92, 69, 69, 
	69, 69, 93, 69, 69, 94, 69, 4, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 71, 69, 69, 69, 
	69, 69, 69, 69, 69, 73, 74, 75, 
	76, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 85, 86, 87, 69, 69, 
	69, 69, 69, 89, 90, 91, 95, 69, 
	69, 69, 69, 73, 69, 71, 69, 69, 
	69, 69, 69, 69, 69, 69, 73, 74, 
	75, 76, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 85, 86, 87, 69, 
	69, 69, 69, 69, 89, 90, 91, 95, 
	69, 71, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 74, 75, 76, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	89, 90, 91, 69, 71, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 75, 
	76, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 89, 90, 91, 69, 71, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 76, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 89, 90, 
	91, 69, 71, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 89, 90, 69, 71, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 90, 69, 71, 69, 
	71, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 74, 75, 76, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 85, 
	86, 87, 69, 69, 69, 69, 69, 89, 
	90, 91, 95, 69, 71, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 74, 75, 
	76, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 86, 87, 69, 69, 
	69, 69, 69, 89, 90, 91, 95, 69, 
	71, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 74, 75, 76, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 87, 69, 69, 69, 69, 69, 89, 
	90, 91, 95, 69, 97, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 98, 96, 71, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 74, 75, 76, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 89, 90, 91, 95, 69, 71, 
	69, 69, 69, 69, 69, 69, 69, 72, 
	73, 74, 75, 76, 69, 69, 69, 69, 
	69, 69, 82, 83, 84, 69, 85, 86, 
	87, 69, 69, 69, 69, 69, 89, 90, 
	91, 95, 69, 69, 69, 69, 73, 69, 
	71, 69, 69, 69, 69, 69, 69, 69, 
	69, 73, 74, 75, 76, 69, 69, 69, 
	69, 69, 69, 82, 83, 84, 69, 85, 
	86, 87, 69, 69, 69, 69, 69, 89, 
	90, 91, 95, 69, 69, 69, 69, 73, 
	69, 71, 69, 69, 69, 69, 69, 69, 
	69, 69, 73, 74, 75, 76, 69, 69, 
	69, 69, 69, 69, 69, 83, 84, 69, 
	85, 86, 87, 69, 69, 69, 69, 69, 
	89, 90, 91, 95, 69, 69, 69, 69, 
	73, 69, 71, 69, 69, 69, 69, 69, 
	69, 69, 69, 73, 74, 75, 76, 69, 
	69, 69, 69, 69, 69, 69, 69, 84, 
	69, 85, 86, 87, 69, 69, 69, 69, 
	69, 89, 90, 91, 95, 69, 69, 69, 
	69, 73, 69, 99, 69, 71, 69, 69, 
	69, 69, 69, 69, 69, 72, 73, 74, 
	75, 76, 69, 78, 79, 69, 69, 69, 
	82, 83, 84, 69, 85, 86, 87, 69, 
	69, 69, 69, 69, 89, 90, 91, 95, 
	69, 69, 69, 69, 73, 69, 71, 69, 
	69, 69, 69, 69, 69, 69, 69, 73, 
	74, 75, 76, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 85, 86, 87, 
	69, 69, 69, 69, 69, 89, 90, 91, 
	95, 69, 69, 69, 69, 73, 69, 99, 
	69, 71, 69, 69, 69, 69, 69, 69, 
	69, 72, 73, 74, 75, 76, 69, 69, 
	79, 69, 69, 69, 82, 83, 84, 69, 
	85, 86, 87, 69, 69, 69, 69, 69, 
	89, 90, 91, 95, 69, 69, 69, 69, 
	73, 69, 99, 69, 71, 69, 69, 69, 
	69, 69, 69, 69, 72, 73, 74, 75, 
	76, 69, 69, 69, 69, 69, 69, 82, 
	83, 84, 69, 85, 86, 87, 69, 69, 
	69, 69, 69, 89, 90, 91, 95, 69, 
	69, 69, 69, 73, 69, 99, 69, 71, 
	69, 69, 69, 69, 69, 69, 69, 72, 
	73, 74, 75, 76, 77, 78, 79, 69, 
	69, 69, 82, 83, 84, 69, 85, 86, 
	87, 69, 69, 69, 69, 69, 89, 90, 
	91, 95, 69, 69, 69, 69, 73, 69, 
	4, 70, 69, 71, 69, 69, 69, 69, 
	69, 69, 69, 72, 73, 74, 75, 76, 
	77, 78, 79, 80, 69, 81, 82, 83, 
	84, 69, 85, 86, 87, 69, 69, 69, 
	69, 88, 89, 90, 91, 92, 69, 69, 
	69, 69, 93, 69, 69, 94, 69, 4, 
	100, 100, 100, 100, 100, 100, 100, 100, 
	100, 100, 100, 100, 101, 100, 4, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 96, 96, 98, 96, 4, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 71, 69, 69, 69, 69, 69, 
	69, 69, 69, 73, 74, 75, 76, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 85, 86, 87, 69, 69, 69, 69, 
	69, 89, 90, 91, 95, 69, 101, 100, 
	103, 104, 102, 6, 105, 105, 105, 105, 
	105, 105, 105, 105, 105, 106, 105, 107, 
	108, 69, 71, 69, 69, 69, 69, 69, 
	69, 69, 109, 110, 111, 112, 113, 114, 
	115, 116, 117, 107, 118, 119, 120, 121, 
	69, 122, 123, 124, 69, 59, 60, 69, 
	125, 126, 127, 128, 129, 69, 69, 69, 
	69, 130, 69, 69, 131, 69, 107, 108, 
	69, 71, 69, 69, 69, 69, 69, 69, 
	69, 109, 110, 111, 112, 113, 114, 115, 
	116, 117, 107, 118, 119, 120, 121, 69, 
	122, 123, 124, 69, 69, 69, 69, 125, 
	126, 127, 128, 129, 69, 69, 69, 69, 
	130, 69, 69, 131, 69, 107, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 71, 69, 69, 69, 69, 69, 
	69, 69, 69, 110, 111, 112, 113, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 122, 123, 124, 69, 69, 69, 69, 
	69, 126, 127, 128, 132, 69, 69, 69, 
	69, 110, 69, 71, 69, 69, 69, 69, 
	69, 69, 69, 69, 110, 111, 112, 113, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 122, 123, 124, 69, 69, 69, 
	69, 69, 126, 127, 128, 132, 69, 71, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 111, 112, 113, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 126, 127, 
	128, 69, 71, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 112, 113, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 126, 127, 128, 69, 71, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 113, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 126, 127, 128, 69, 
	71, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 126, 
	127, 69, 71, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 127, 69, 71, 69, 71, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	111, 112, 113, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 122, 123, 124, 
	69, 69, 69, 69, 69, 126, 127, 128, 
	132, 69, 71, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 111, 112, 113, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 123, 124, 69, 69, 69, 69, 
	69, 126, 127, 128, 132, 69, 71, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	111, 112, 113, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 124, 
	69, 69, 69, 69, 69, 126, 127, 128, 
	132, 69, 133, 96, 96, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 96, 98, 
	96, 71, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 111, 112, 113, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	126, 127, 128, 132, 69, 71, 69, 69, 
	69, 69, 69, 69, 69, 109, 110, 111, 
	112, 113, 69, 69, 69, 69, 69, 69, 
	119, 120, 121, 69, 122, 123, 124, 69, 
	69, 69, 69, 69, 126, 127, 128, 132, 
	69, 69, 69, 69, 110, 69, 71, 69, 
	69, 69, 69, 69, 69, 69, 69, 110, 
	111, 112, 113, 69, 69, 69, 69, 69, 
	69, 119, 120, 121, 69, 122, 123, 124, 
	69, 69, 69, 69, 69, 126, 127, 128, 
	132, 69, 69, 69, 69, 110, 69, 71, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	110, 111, 112, 113, 69, 69, 69, 69, 
	69, 69, 69, 120, 121, 69, 122, 123, 
	124, 69, 69, 69, 69, 69, 126, 127, 
	128, 132, 69, 69, 69, 69, 110, 69, 
	71, 69, 69, 69, 69, 69, 69, 69, 
	69, 110, 111, 112, 113, 69, 69, 69, 
	69, 69, 69, 69, 69, 121, 69, 122, 
	123, 124, 69, 69, 69, 69, 69, 126, 
	127, 128, 132, 69, 69, 69, 69, 110, 
	69, 134, 69, 71, 69, 69, 69, 69, 
	69, 69, 69, 109, 110, 111, 112, 113, 
	69, 115, 116, 69, 69, 69, 119, 120, 
	121, 69, 122, 123, 124, 69, 69, 69, 
	69, 69, 126, 127, 128, 132, 69, 69, 
	69, 69, 110, 69, 71, 69, 69, 69, 
	69, 69, 69, 69, 69, 110, 111, 112, 
	113, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 122, 123, 124, 69, 69, 
	69, 69, 69, 126, 127, 128, 132, 69, 
	69, 69, 69, 110, 69, 134, 69, 71, 
	69, 69, 69, 69, 69, 69, 69, 109, 
	110, 111, 112, 113, 69, 69, 116, 69, 
	69, 69, 119, 120, 121, 69, 122, 123, 
	124, 69, 69, 69, 69, 69, 126, 127, 
	128, 132, 69, 69, 69, 69, 110, 69, 
	134, 69, 71, 69, 69, 69, 69, 69, 
	69, 69, 109, 110, 111, 112, 113, 69, 
	69, 69, 69, 69, 69, 119, 120, 121, 
	69, 122, 123, 124, 69, 69, 69, 69, 
	69, 126, 127, 128, 132, 69, 69, 69, 
	69, 110, 69, 134, 69, 71, 69, 69, 
	69, 69, 69, 69, 69, 109, 110, 111, 
	112, 113, 114, 115, 116, 69, 69, 69, 
	119, 120, 121, 69, 122, 123, 124, 69, 
	69, 69, 69, 69, 126, 127, 128, 132, 
	69, 69, 69, 69, 110, 69, 107, 108, 
	69, 71, 69, 69, 69, 69, 69, 69, 
	69, 109, 110, 111, 112, 113, 114, 115, 
	116, 117, 69, 118, 119, 120, 121, 69, 
	122, 123, 124, 69, 69, 69, 69, 125, 
	126, 127, 128, 129, 69, 69, 69, 69, 
	130, 69, 69, 131, 69, 107, 100, 100, 
	100, 100, 100, 100, 100, 100, 100, 100, 
	100, 100, 101, 100, 107, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 98, 96, 107, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	71, 69, 69, 69, 69, 69, 69, 69, 
	69, 110, 111, 112, 113, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 122, 
	123, 124, 69, 69, 69, 69, 69, 126, 
	127, 128, 132, 69, 101, 100, 8, 9, 
	135, 11, 135, 135, 135, 135, 135, 135, 
	135, 13, 14, 15, 16, 17, 18, 19, 
	20, 21, 8, 22, 23, 24, 25, 135, 
	26, 27, 28, 135, 135, 135, 135, 32, 
	33, 34, 38, 32, 135, 135, 135, 135, 
	37, 135, 135, 38, 135, 8, 135, 135, 
	135, 135, 135, 135, 135, 135, 135, 135, 
	135, 135, 11, 135, 135, 135, 135, 135, 
	135, 135, 135, 14, 15, 16, 17, 135, 
	135, 135, 135, 135, 135, 135, 135, 135, 
	135, 26, 27, 28, 135, 135, 135, 135, 
	135, 33, 34, 38, 136, 135, 135, 135, 
	135, 14, 135, 11, 135, 135, 135, 135, 
	135, 135, 135, 135, 14, 15, 16, 17, 
	135, 135, 135, 135, 135, 135, 135, 135, 
	135, 135, 26, 27, 28, 135, 135, 135, 
	135, 135, 33, 34, 38, 136, 135, 11, 
	135, 135, 135, 135, 135, 135, 135, 135, 
	135, 15, 16, 17, 135, 135, 135, 135, 
	135, 135, 135, 135, 135, 135, 135, 135, 
	135, 135, 135, 135, 135, 135, 33, 34, 
	38, 135, 11, 135, 135, 135, 135, 135, 
	135, 135, 135, 135, 135, 16, 17, 135, 
	135, 135, 135, 135, 135, 135, 135, 135, 
	135, 135, 135, 135, 135, 135, 135, 135, 
	135, 33, 34, 38, 135, 11, 135, 135, 
	135, 135, 135, 135, 135, 135, 135, 135, 
	135, 17, 135, 135, 135, 135, 135, 135, 
	135, 135, 135, 135, 135, 135, 135, 135, 
	135, 135, 135, 135, 33, 34, 38, 135, 
	11, 135, 135, 135, 135, 135, 135, 135, 
	135, 135, 135, 135, 135, 135, 135, 135, 
	135, 135, 135, 135, 135, 135, 135, 135, 
	135, 135, 135, 135, 135, 135, 135, 33, 
	34, 135, 11, 135, 135, 135, 135, 135, 
	135, 135, 135, 135, 135, 135, 135, 135, 
	135, 135, 135, 135, 135, 135, 135, 135, 
	135, 135, 135, 135, 135, 135, 135, 135, 
	135, 135, 34, 135, 11, 137, 11, 135, 
	135, 135, 135, 135, 135, 135, 135, 135, 
	15, 16, 17, 135, 135, 135, 135, 135, 
	135, 135, 135, 135, 135, 26, 27, 28, 
	135, 135, 135, 135, 135, 33, 34, 38, 
	136, 135, 11, 135, 135, 135, 135, 135, 
	135, 135, 135, 135, 15, 16, 17, 135, 
	135, 135, 135, 135, 135, 135, 135, 135, 
	135, 135, 27, 28, 135, 135, 135, 135, 
	135, 33, 34, 38, 136, 135, 11, 135, 
	135, 135, 135, 135, 135, 135, 135, 135, 
	15, 16, 17, 135, 135, 135, 135, 135, 
	135, 135, 135, 135, 135, 135, 135, 28, 
	135, 135, 135, 135, 135, 33, 34, 38, 
	136, 135, 138, 135, 135, 135, 135, 135, 
	135, 135, 135, 135, 135, 135, 135, 11, 
	135, 11, 135, 135, 135, 135, 135, 135, 
	135, 135, 135, 15, 16, 17, 135, 135, 
	135, 135, 135, 135, 135, 135, 135, 135, 
	135, 135, 135, 135, 135, 135, 135, 135, 
	33, 34, 38, 136, 135, 11, 135, 135, 
	135, 135, 135, 135, 135, 13, 14, 15, 
	16, 17, 135, 135, 135, 135, 135, 135, 
	23, 24, 25, 135, 26, 27, 28, 135, 
	135, 135, 135, 135, 33, 34, 38, 136, 
	135, 135, 135, 135, 14, 135, 11, 135, 
	135, 135, 135, 135, 135, 135, 135, 14, 
	15, 16, 17, 135, 135, 135, 135, 135, 
	135, 23, 24, 25, 135, 26, 27, 28, 
	135, 135, 135, 135, 135, 33, 34, 38, 
	136, 135, 135, 135, 135, 14, 135, 11, 
	135, 135, 135, 135, 135, 135, 135, 135, 
	14, 15, 16, 17, 135, 135, 135, 135, 
	135, 135, 135, 24, 25, 135, 26, 27, 
	28, 135, 135, 135, 135, 135, 33, 34, 
	38, 136, 135, 135, 135, 135, 14, 135, 
	11, 135, 135, 135, 135, 135, 135, 135, 
	135, 14, 15, 16, 17, 135, 135, 135, 
	135, 135, 135, 135, 135, 25, 135, 26, 
	27, 28, 135, 135, 135, 135, 135, 33, 
	34, 38, 136, 135, 135, 135, 135, 14, 
	135, 139, 135, 11, 135, 135, 135, 135, 
	135, 135, 135, 13, 14, 15, 16, 17, 
	135, 19, 20, 135, 135, 135, 23, 24, 
	25, 135, 26, 27, 28, 135, 135, 135, 
	135, 135, 33, 34, 38, 136, 135, 135, 
	135, 135, 14, 135, 11, 135, 135, 135, 
	135, 135, 135, 135, 135, 14, 15, 16, 
	17, 135, 135, 135, 135, 135, 135, 135, 
	135, 135, 135, 26, 27, 28, 135, 135, 
	135, 135, 135, 33, 34, 38, 136, 135, 
	135, 135, 135, 14, 135, 139, 135, 11, 
	135, 135, 135, 135, 135, 135, 135, 13, 
	14, 15, 16, 17, 135, 135, 20, 135, 
	135, 135, 23, 24, 25, 135, 26, 27, 
	28, 135, 135, 135, 135, 135, 33, 34, 
	38, 136, 135, 135, 135, 135, 14, 135, 
	139, 135, 11, 135, 135, 135, 135, 135, 
	135, 135, 13, 14, 15, 16, 17, 135, 
	135, 135, 135, 135, 135, 23, 24, 25, 
	135, 26, 27, 28, 135, 135, 135, 135, 
	135, 33, 34, 38, 136, 135, 135, 135, 
	135, 14, 135, 139, 135, 11, 135, 135, 
	135, 135, 135, 135, 135, 13, 14, 15, 
	16, 17, 18, 19, 20, 135, 135, 135, 
	23, 24, 25, 135, 26, 27, 28, 135, 
	135, 135, 135, 135, 33, 34, 38, 136, 
	135, 135, 135, 135, 14, 135, 8, 9, 
	135, 11, 135, 135, 135, 135, 135, 135, 
	135, 13, 14, 15, 16, 17, 18, 19, 
	20, 21, 135, 22, 23, 24, 25, 135, 
	26, 27, 28, 135, 135, 135, 135, 32, 
	33, 34, 38, 32, 135, 135, 135, 135, 
	37, 135, 135, 38, 135, 8, 135, 135, 
	135, 135, 135, 135, 135, 135, 135, 135, 
	135, 135, 11, 135, 8, 135, 135, 135, 
	135, 135, 135, 135, 135, 135, 135, 135, 
	135, 11, 135, 135, 135, 135, 135, 135, 
	135, 135, 14, 15, 16, 17, 135, 135, 
	135, 135, 135, 135, 135, 135, 135, 135, 
	26, 27, 28, 135, 135, 135, 135, 135, 
	33, 34, 38, 136, 135, 140, 135, 135, 
	135, 135, 135, 135, 135, 135, 135, 11, 
	135, 10, 11, 135, 4, 135, 135, 135, 
	4, 135, 135, 135, 135, 135, 8, 9, 
	10, 11, 135, 135, 135, 135, 135, 135, 
	135, 13, 14, 15, 16, 17, 18, 19, 
	20, 21, 8, 22, 23, 24, 25, 135, 
	26, 27, 28, 135, 29, 30, 135, 32, 
	33, 34, 38, 32, 135, 135, 135, 135, 
	37, 135, 135, 38, 135, 11, 135, 135, 
	135, 135, 135, 135, 135, 135, 135, 135, 
	135, 135, 135, 135, 135, 135, 135, 135, 
	135, 135, 135, 135, 135, 135, 135, 135, 
	29, 30, 135, 11, 135, 135, 135, 135, 
	135, 135, 135, 135, 135, 135, 135, 135, 
	135, 135, 135, 135, 135, 135, 135, 135, 
	135, 135, 135, 135, 135, 135, 135, 30, 
	135, 4, 141, 141, 141, 4, 141, 143, 
	142, 142, 142, 142, 142, 142, 142, 142, 
	142, 142, 142, 142, 142, 142, 142, 142, 
	142, 142, 142, 142, 142, 142, 142, 142, 
	142, 142, 142, 142, 142, 142, 142, 142, 
	142, 142, 142, 144, 142, 145, 142, 145, 
	146, 142, 143, 142, 142, 142, 142, 142, 
	142, 142, 142, 142, 142, 142, 142, 142, 
	142, 142, 142, 142, 142, 142, 142, 142, 
	142, 142, 142, 142, 142, 142, 142, 142, 
	142, 142, 142, 142, 142, 1, 144, 144, 
	142, 143, 142, 142, 142, 142, 142, 142, 
	142, 142, 142, 142, 142, 142, 142, 142, 
	142, 142, 142, 142, 142, 142, 142, 142, 
	142, 142, 142, 142, 142, 142, 142, 142, 
	142, 142, 142, 142, 142, 144, 142, 145, 
	142, 143, 142, 142, 142, 142, 142, 142, 
	142, 142, 142, 142, 142, 142, 142, 142, 
	142, 142, 142, 142, 142, 142, 142, 142, 
	142, 142, 142, 142, 142, 142, 142, 142, 
	142, 142, 142, 142, 142, 144, 142, 145, 
	142, 145, 142, 40, 41, 39, 42, 39, 
	39, 39, 39, 39, 39, 39, 43, 44, 
	45, 46, 47, 48, 49, 50, 51, 40, 
	52, 53, 54, 55, 39, 56, 57, 58, 
	39, 59, 60, 39, 61, 62, 63, 64, 
	61, 1, 39, 2, 39, 65, 39, 39, 
	64, 39, 0
};

static const char _use_syllable_machine_trans_targs[] = {
	1, 122, 0, 2, 31, 1, 59, 61, 
	90, 91, 116, 1, 118, 104, 92, 93, 
	94, 95, 108, 110, 111, 112, 113, 105, 
	106, 107, 99, 100, 101, 119, 120, 121, 
	114, 96, 97, 98, 126, 115, 98, 1, 
	3, 4, 1, 17, 5, 6, 7, 8, 
	21, 23, 24, 25, 26, 18, 19, 20, 
	12, 13, 14, 29, 30, 27, 9, 10, 
	11, 28, 15, 16, 22, 1, 32, 1, 
	45, 33, 34, 35, 36, 49, 51, 52, 
	53, 54, 46, 47, 48, 40, 41, 42, 
	55, 37, 38, 39, 56, 57, 58, 43, 
	1, 44, 1, 50, 1, 1, 1, 60, 
	1, 1, 1, 62, 63, 76, 64, 65, 
	66, 67, 80, 82, 83, 84, 85, 77, 
	78, 79, 71, 72, 73, 86, 68, 69, 
	70, 87, 88, 89, 74, 75, 81, 1, 
	102, 1, 103, 109, 117, 1, 1, 1, 
	123, 124, 125
};

static const char _use_syllable_machine_trans_actions[] = {
	1, 0, 0, 0, 0, 4, 0, 0, 
	0, 0, 0, 5, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 6, 7, 0, 8, 9, 
	0, 0, 10, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 11, 0, 12, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	13, 0, 14, 0, 15, 16, 17, 0, 
	18, 19, 20, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 21, 
	0, 22, 0, 0, 0, 23, 24, 25, 
	0, 0, 0
};

static const char _use_syllable_machine_to_state_actions[] = {
	0, 2, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0
};

static const char _use_syllable_machine_from_state_actions[] = {
	0, 3, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0
};

static const short _use_syllable_machine_eof_trans[] = {
	1, 0, 40, 40, 40, 40, 40, 40, 
	40, 40, 40, 40, 40, 40, 40, 40, 
	40, 40, 40, 40, 40, 40, 40, 40, 
	40, 40, 40, 40, 40, 40, 40, 70, 
	70, 70, 70, 70, 70, 70, 70, 70, 
	70, 70, 70, 97, 70, 70, 70, 70, 
	70, 70, 70, 70, 70, 70, 70, 101, 
	97, 70, 101, 103, 106, 70, 70, 70, 
	70, 70, 70, 70, 70, 70, 70, 70, 
	70, 70, 97, 70, 70, 70, 70, 70, 
	70, 70, 70, 70, 70, 70, 101, 97, 
	70, 101, 136, 136, 136, 136, 136, 136, 
	136, 136, 138, 136, 136, 136, 136, 136, 
	136, 136, 136, 136, 136, 136, 136, 136, 
	136, 136, 136, 136, 136, 136, 136, 136, 
	136, 142, 143, 143, 143, 143, 40
};

static const int use_syllable_machine_start = 1;
static const int use_syllable_machine_first_final = 1;
static const int use_syllable_machine_error = -1;

static const int use_syllable_machine_en_main = 1;


#line 58 "hb-ot-shaper-use-machine.rl"



#line 186 "hb-ot-shaper-use-machine.rl"


#define found_syllable(syllable_type) \
  HB_STMT_START { \
    if (0) fprintf (stderr, "syllable %u..%u %s\n", (*ts).second.first, (*te).second.first, #syllable_type); \
    for (unsigned i = (*ts).second.first; i < (*te).second.first; ++i) \
      info[i].syllable() = (syllable_serial << 4) | syllable_type; \
    syllable_serial++; \
    if (syllable_serial == 16) syllable_serial = 1; \
  } HB_STMT_END


template <typename Iter>
struct machine_index_t :
  hb_iter_with_fallback_t<machine_index_t<Iter>,
			  typename Iter::item_t>
{
  machine_index_t (const Iter& it) : it (it) {}
  machine_index_t (const machine_index_t& o) : hb_iter_with_fallback_t<machine_index_t<Iter>,
								       typename Iter::item_t> (),
					       it (o.it), is_null (o.is_null) {}

  static constexpr bool is_random_access_iterator = Iter::is_random_access_iterator;
  static constexpr bool is_sorted_iterator = Iter::is_sorted_iterator;

  typename Iter::item_t __item__ () const { return *it; }
  typename Iter::item_t __item_at__ (unsigned i) const { return it[i]; }
  unsigned __len__ () const { return it.len (); }
  void __next__ () { ++it; }
  void __forward__ (unsigned n) { it += n; }
  void __prev__ () { --it; }
  void __rewind__ (unsigned n) { it -= n; }

  void operator = (unsigned n)
  {
    assert (n == 0);
    is_null = true;
  }
  explicit operator bool () { return !is_null; }

  void operator = (const machine_index_t& o)
  {
    is_null = o.is_null;
    unsigned index = (*it).first;
    unsigned n = (*o.it).first;
    if (index < n) it += n - index; else if (index > n) it -= index - n;
  }
  bool operator == (const machine_index_t& o) const
  { return is_null ? o.is_null : !o.is_null && (*it).first == (*o.it).first; }
  bool operator != (const machine_index_t& o) const { return !(*this == o); }

  private:
  Iter it;
  bool is_null = false;
};
struct
{
  template <typename Iter,
	    hb_requires (hb_is_iterable (Iter))>
  machine_index_t<hb_iter_type<Iter>>
  operator () (Iter&& it) const
  { return machine_index_t<hb_iter_type<Iter>> (hb_iter (it)); }
}
HB_FUNCOBJ (machine_index);



static bool
not_ccs_default_ignorable (const hb_glyph_info_t &i)
{ return i.use_category() != USE(CGJ); }

static inline void
find_syllables_use (hb_buffer_t *buffer)
{
  hb_glyph_info_t *info = buffer->info;
  auto p =
    + hb_iter (info, buffer->len)
    | hb_enumerate
    | hb_filter ([] (const hb_glyph_info_t &i) { return not_ccs_default_ignorable (i); },
		 hb_second)
    | hb_filter ([&] (const hb_pair_t<unsigned, const hb_glyph_info_t &> p)
		 {
		   if (p.second.use_category() == USE(ZWNJ))
		     for (unsigned i = p.first + 1; i < buffer->len; ++i)
		       if (not_ccs_default_ignorable (info[i]))
			 return !_hb_glyph_info_is_unicode_mark (&info[i]);
		   return true;
		 })
    | hb_enumerate
    | machine_index
    ;
  auto pe = p + p.len ();
  auto eof = +pe;
  auto ts = +p;
  auto te = +p;
  unsigned int act HB_UNUSED;
  int cs;
  
#line 922 "hb-ot-shaper-use-machine.hh"
	{
	cs = use_syllable_machine_start;
	ts = 0;
	te = 0;
	act = 0;
	}

#line 286 "hb-ot-shaper-use-machine.rl"


  unsigned int syllable_serial = 1;
  
#line 931 "hb-ot-shaper-use-machine.hh"
	{
	int _slen;
	int _trans;
	const unsigned char *_keys;
	const unsigned char *_inds;
	if ( p == pe )
		goto _test_eof;
_resume:
	switch ( _use_syllable_machine_from_state_actions[cs] ) {
	case 3:
#line 1 "NONE"
	{ts = p;}
	break;
#line 943 "hb-ot-shaper-use-machine.hh"
	}

	_keys = _use_syllable_machine_trans_keys + (cs<<1);
	_inds = _use_syllable_machine_indicies + _use_syllable_machine_index_offsets[cs];

	_slen = _use_syllable_machine_key_spans[cs];
	_trans = _inds[ _slen > 0 && _keys[0] <=( (*p).second.second.use_category()) &&
		( (*p).second.second.use_category()) <= _keys[1] ?
		( (*p).second.second.use_category()) - _keys[0] : _slen ];

_eof_trans:
	cs = _use_syllable_machine_trans_targs[_trans];

	if ( _use_syllable_machine_trans_actions[_trans] == 0 )
		goto _again;

	switch ( _use_syllable_machine_trans_actions[_trans] ) {
	case 7:
#line 1 "NONE"
	{te = p+1;}
	break;
	case 16:
#line 173 "hb-ot-shaper-use-machine.rl"
	{te = p+1;{ found_syllable (use_virama_terminated_cluster); }}
	break;
	case 14:
#line 174 "hb-ot-shaper-use-machine.rl"
	{te = p+1;{ found_syllable (use_sakot_terminated_cluster); }}
	break;
	case 12:
#line 175 "hb-ot-shaper-use-machine.rl"
	{te = p+1;{ found_syllable (use_standard_cluster); }}
	break;
	case 20:
#line 176 "hb-ot-shaper-use-machine.rl"
	{te = p+1;{ found_syllable (use_number_joiner_terminated_cluster); }}
	break;
	case 18:
#line 177 "hb-ot-shaper-use-machine.rl"
	{te = p+1;{ found_syllable (use_numeral_cluster); }}
	break;
	case 10:
#line 178 "hb-ot-shaper-use-machine.rl"
	{te = p+1;{ found_syllable (use_symbol_cluster); }}
	break;
	case 25:
#line 179 "hb-ot-shaper-use-machine.rl"
	{te = p+1;{ found_syllable (use_hieroglyph_cluster); }}
	break;
	case 5:
#line 181 "hb-ot-shaper-use-machine.rl"
	{te = p+1;{ found_syllable (use_broken_cluster); buffer->scratch_flags |= HB_BUFFER_SCRATCH_FLAG_HAS_BROKEN_SYLLABLE; }}
	break;
	case 4:
#line 182 "hb-ot-shaper-use-machine.rl"
	{te = p+1;{ found_syllable (use_non_cluster); }}
	break;
	case 15:
#line 173 "hb-ot-shaper-use-machine.rl"
	{te = p;p--;{ found_syllable (use_virama_terminated_cluster); }}
	break;
	case 13:
#line 174 "hb-ot-shaper-use-machine.rl"
	{te = p;p--;{ found_syllable (use_sakot_terminated_cluster); }}
	break;
	case 11:
#line 175 "hb-ot-shaper-use-machine.rl"
	{te = p;p--;{ found_syllable (use_standard_cluster); }}
	break;
	case 19:
#line 176 "hb-ot-shaper-use-machine.rl"
	{te = p;p--;{ found_syllable (use_number_joiner_terminated_cluster); }}
	break;
	case 17:
#line 177 "hb-ot-shaper-use-machine.rl"
	{te = p;p--;{ found_syllable (use_numeral_cluster); }}
	break;
	case 9:
#line 178 "hb-ot-shaper-use-machine.rl"
	{te = p;p--;{ found_syllable (use_symbol_cluster); }}
	break;
	case 24:
#line 179 "hb-ot-shaper-use-machine.rl"
	{te = p;p--;{ found_syllable (use_hieroglyph_cluster); }}
	break;
	case 21:
#line 181 "hb-ot-shaper-use-machine.rl"
	{te = p;p--;{ found_syllable (use_broken_cluster); buffer->scratch_flags |= HB_BUFFER_SCRATCH_FLAG_HAS_BROKEN_SYLLABLE; }}
	break;
	case 23:
#line 182 "hb-ot-shaper-use-machine.rl"
	{te = p;p--;{ found_syllable (use_non_cluster); }}
	break;
	case 1:
#line 178 "hb-ot-shaper-use-machine.rl"
	{{p = ((te))-1;}{ found_syllable (use_symbol_cluster); }}
	break;
	case 22:
#line 1 "NONE"
	{	switch( act ) {
	case 8:
	{{p = ((te))-1;} found_syllable (use_non_cluster); }
	break;
	case 9:
	{{p = ((te))-1;} found_syllable (use_broken_cluster); buffer->scratch_flags |= HB_BUFFER_SCRATCH_FLAG_HAS_BROKEN_SYLLABLE; }
	break;
	}
	}
	break;
	case 6:
#line 1 "NONE"
	{te = p+1;}
#line 180 "hb-ot-shaper-use-machine.rl"
	{act = 8;}
	break;
	case 8:
#line 1 "NONE"
	{te = p+1;}
#line 181 "hb-ot-shaper-use-machine.rl"
	{act = 9;}
	break;
#line 1039 "hb-ot-shaper-use-machine.hh"
	}

_again:
	switch ( _use_syllable_machine_to_state_actions[cs] ) {
	case 2:
#line 1 "NONE"
	{ts = 0;}
	break;
#line 1046 "hb-ot-shaper-use-machine.hh"
	}

	if ( ++p != pe )
		goto _resume;
	_test_eof: {}
	if ( p == eof )
	{
	if ( _use_syllable_machine_eof_trans[cs] > 0 ) {
		_trans = _use_syllable_machine_eof_trans[cs] - 1;
		goto _eof_trans;
	}
	}

	}

#line 291 "hb-ot-shaper-use-machine.rl"

}

#undef found_syllable

#endif /* HB_OT_SHAPER_USE_MACHINE_HH */
