/*
 *  ----------------------------------
 * |         libmem - by rdbo         |
 * |      Memory Hacking Library      |
 *  ----------------------------------
 */

/*
 * Copyright (C) 2024    Rdbo
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License version 3
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

/* Generated by rust-bindgen 0.69.4, modified by rdbo */
#![allow(non_camel_case_types)]

pub type lm_void_t = ::std::os::raw::c_void;
pub type lm_bool_t = ::std::os::raw::c_uint;
pub type lm_byte_t = u8;
pub type lm_address_t = usize;
pub type lm_size_t = usize;
pub type lm_char_t = ::std::os::raw::c_char;
pub type lm_string_t = *const lm_char_t;
pub type lm_bytearray_t = *const lm_byte_t;
pub type lm_pid_t = u32;
pub type lm_tid_t = u32;
pub type lm_time_t = u64;
pub type lm_prot_t = u32;
pub type lm_arch_t = u32;

pub const LM_NULL: usize = 0;
pub const LM_PATH_MAX: usize = 4096;
pub const LM_INST_MAX: usize = 16;
pub const LM_FALSE: lm_bool_t = 0;
pub const LM_TRUE: lm_bool_t = 1;
pub const LM_PID_BAD: lm_pid_t = lm_pid_t::MAX;
pub const LM_TID_BAD: lm_tid_t = lm_tid_t::MAX;
pub const LM_ADDRESS_BAD: lm_address_t = lm_address_t::MAX;

pub const LM_PROT_NONE: lm_prot_t = 0;
pub const LM_PROT_R: lm_prot_t = 1;
pub const LM_PROT_W: lm_prot_t = 2;
pub const LM_PROT_X: lm_prot_t = 4;
pub const LM_PROT_XR: lm_prot_t = 5;
pub const LM_PROT_XW: lm_prot_t = 6;
pub const LM_PROT_RW: lm_prot_t = 3;
pub const LM_PROT_XRW: lm_prot_t = 7;

pub const LM_ARCH_GENERIC: lm_arch_t = 0;
pub const LM_ARCH_ARMV7: lm_arch_t = 1;
pub const LM_ARCH_ARMV8: lm_arch_t = 2;
pub const LM_ARCH_THUMBV7: lm_arch_t = 3;
pub const LM_ARCH_THUMBV8: lm_arch_t = 4;
pub const LM_ARCH_ARMV7EB: lm_arch_t = 5;
pub const LM_ARCH_THUMBV7EB: lm_arch_t = 6;
pub const LM_ARCH_ARMV8EB: lm_arch_t = 7;
pub const LM_ARCH_THUMBV8EB: lm_arch_t = 8;
pub const LM_ARCH_AARCH64: lm_arch_t = 9;
pub const LM_ARCH_MIPS: lm_arch_t = 10;
pub const LM_ARCH_MIPS64: lm_arch_t = 11;
pub const LM_ARCH_MIPSEL: lm_arch_t = 12;
pub const LM_ARCH_MIPSEL64: lm_arch_t = 13;
pub const LM_ARCH_X86_16: lm_arch_t = 14;
pub const LM_ARCH_X86: lm_arch_t = 15;
pub const LM_ARCH_X64: lm_arch_t = 16;
pub const LM_ARCH_PPC32: lm_arch_t = 17;
pub const LM_ARCH_PPC64: lm_arch_t = 18;
pub const LM_ARCH_PPC64LE: lm_arch_t = 19;
pub const LM_ARCH_SPARC: lm_arch_t = 20;
pub const LM_ARCH_SPARC64: lm_arch_t = 21;
pub const LM_ARCH_SPARCEL: lm_arch_t = 22;
pub const LM_ARCH_SYSZ: lm_arch_t = 23;
pub const LM_ARCH_MAX: lm_arch_t = 24;

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lm_process_t {
    pub pid: lm_pid_t,
    pub ppid: lm_pid_t,
    pub arch: lm_arch_t,
    pub bits: lm_size_t,
    pub start_time: lm_time_t,
    pub path: [lm_char_t; 4096usize],
    pub name: [lm_char_t; 4096usize],
}

#[test]
fn bindgen_test_layout_lm_process_t() {
    const UNINIT: ::std::mem::MaybeUninit<lm_process_t> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<lm_process_t>(),
        8216usize,
        concat!("Size of: ", stringify!(lm_process_t))
    );
    assert_eq!(
        ::std::mem::align_of::<lm_process_t>(),
        8usize,
        concat!("Alignment of ", stringify!(lm_process_t))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pid) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lm_process_t),
            "::",
            stringify!(pid)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ppid) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(lm_process_t),
            "::",
            stringify!(ppid)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bits) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lm_process_t),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).start_time) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lm_process_t),
            "::",
            stringify!(start_time)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).path) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lm_process_t),
            "::",
            stringify!(path)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).name) as usize - ptr as usize },
        4120usize,
        concat!(
            "Offset of field: ",
            stringify!(lm_process_t),
            "::",
            stringify!(name)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lm_thread_t {
    pub tid: lm_tid_t,
    pub owner_pid: lm_pid_t,
}
#[test]
fn bindgen_test_layout_lm_thread_t() {
    const UNINIT: ::std::mem::MaybeUninit<lm_thread_t> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<lm_thread_t>(),
        8usize,
        concat!("Size of: ", stringify!(lm_thread_t))
    );
    assert_eq!(
        ::std::mem::align_of::<lm_thread_t>(),
        4usize,
        concat!("Alignment of ", stringify!(lm_thread_t))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tid) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lm_thread_t),
            "::",
            stringify!(tid)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).owner_pid) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(lm_thread_t),
            "::",
            stringify!(owner_pid)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lm_module_t {
    pub base: lm_address_t,
    pub end: lm_address_t,
    pub size: lm_size_t,
    pub path: [lm_char_t; 4096usize],
    pub name: [lm_char_t; 4096usize],
}
#[test]
fn bindgen_test_layout_lm_module_t() {
    const UNINIT: ::std::mem::MaybeUninit<lm_module_t> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<lm_module_t>(),
        8216usize,
        concat!("Size of: ", stringify!(lm_module_t))
    );
    assert_eq!(
        ::std::mem::align_of::<lm_module_t>(),
        8usize,
        concat!("Alignment of ", stringify!(lm_module_t))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).base) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lm_module_t),
            "::",
            stringify!(base)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).end) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lm_module_t),
            "::",
            stringify!(end)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lm_module_t),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).path) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lm_module_t),
            "::",
            stringify!(path)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).name) as usize - ptr as usize },
        4120usize,
        concat!(
            "Offset of field: ",
            stringify!(lm_module_t),
            "::",
            stringify!(name)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lm_segment_t {
    pub base: lm_address_t,
    pub end: lm_address_t,
    pub size: lm_size_t,
    pub prot: lm_prot_t,
}
#[test]
fn bindgen_test_layout_lm_segment_t() {
    const UNINIT: ::std::mem::MaybeUninit<lm_segment_t> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<lm_segment_t>(),
        32usize,
        concat!("Size of: ", stringify!(lm_segment_t))
    );
    assert_eq!(
        ::std::mem::align_of::<lm_segment_t>(),
        8usize,
        concat!("Alignment of ", stringify!(lm_segment_t))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).base) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lm_segment_t),
            "::",
            stringify!(base)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).end) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lm_segment_t),
            "::",
            stringify!(end)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lm_segment_t),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).prot) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lm_segment_t),
            "::",
            stringify!(prot)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lm_symbol_t {
    pub name: lm_string_t,
    pub address: lm_address_t,
}
#[test]
fn bindgen_test_layout_lm_symbol_t() {
    const UNINIT: ::std::mem::MaybeUninit<lm_symbol_t> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<lm_symbol_t>(),
        16usize,
        concat!("Size of: ", stringify!(lm_symbol_t))
    );
    assert_eq!(
        ::std::mem::align_of::<lm_symbol_t>(),
        8usize,
        concat!("Alignment of ", stringify!(lm_symbol_t))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).name) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lm_symbol_t),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).address) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lm_symbol_t),
            "::",
            stringify!(address)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lm_inst_t {
    pub address: lm_address_t,
    pub size: lm_size_t,
    pub bytes: [lm_byte_t; 16usize],
    pub mnemonic: [lm_char_t; 32usize],
    pub op_str: [lm_char_t; 160usize],
}
#[test]
fn bindgen_test_layout_lm_inst_t() {
    const UNINIT: ::std::mem::MaybeUninit<lm_inst_t> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<lm_inst_t>(),
        224usize,
        concat!("Size of: ", stringify!(lm_inst_t))
    );
    assert_eq!(
        ::std::mem::align_of::<lm_inst_t>(),
        8usize,
        concat!("Alignment of ", stringify!(lm_inst_t))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).address) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lm_inst_t),
            "::",
            stringify!(address)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lm_inst_t),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bytes) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lm_inst_t),
            "::",
            stringify!(bytes)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mnemonic) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lm_inst_t),
            "::",
            stringify!(mnemonic)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).op_str) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(lm_inst_t),
            "::",
            stringify!(op_str)
        )
    );
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lm_vmt_entry_t {
    pub orig_func: lm_address_t,
    pub index: lm_size_t,
    pub next: *mut lm_vmt_entry_t,
}
#[test]
fn bindgen_test_layout_lm_vmt_entry_t() {
    const UNINIT: ::std::mem::MaybeUninit<lm_vmt_entry_t> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<lm_vmt_entry_t>(),
        24usize,
        concat!("Size of: ", stringify!(lm_vmt_entry_t))
    );
    assert_eq!(
        ::std::mem::align_of::<lm_vmt_entry_t>(),
        8usize,
        concat!("Alignment of ", stringify!(lm_vmt_entry_t))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).orig_func) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lm_vmt_entry_t),
            "::",
            stringify!(orig_func)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).index) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lm_vmt_entry_t),
            "::",
            stringify!(index)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).next) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lm_vmt_entry_t),
            "::",
            stringify!(next)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lm_vmt_t {
    pub vtable: *mut lm_address_t,
    pub hkentries: *mut lm_vmt_entry_t,
}
#[test]
fn bindgen_test_layout_lm_vmt_t() {
    const UNINIT: ::std::mem::MaybeUninit<lm_vmt_t> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<lm_vmt_t>(),
        16usize,
        concat!("Size of: ", stringify!(lm_vmt_t))
    );
    assert_eq!(
        ::std::mem::align_of::<lm_vmt_t>(),
        8usize,
        concat!("Alignment of ", stringify!(lm_vmt_t))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).vtable) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lm_vmt_t),
            "::",
            stringify!(vtable)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hkentries) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lm_vmt_t),
            "::",
            stringify!(hkentries)
        )
    );
}
extern "C" {
    #[doc = " Enumerates processes on a system and calls a callback function for each process found.\n\n @param callback The callback function that will receive the current\n process in the enumeration and an extra argument. This function\n should return `LM_TRUE` to continue the enumeration, or `LM_FALSE`\n to stop it.\n @param arg The user-defined data structure that will be passed to the\n callback function along with the `lm_process_t` structure.\n\n @return `LM_TRUE` on success, or `LM_FALSE` on failure."]
    pub fn LM_EnumProcesses(
        callback: unsafe extern "C" fn(
            process: *mut lm_process_t,
            arg: *mut lm_void_t,
        ) -> lm_bool_t,
        arg: *mut lm_void_t,
    ) -> lm_bool_t;
}
extern "C" {
    #[doc = " Retrieves information about the current process, including its PID,\n parent PID, path, name, start time, and architecture bits.\n\n @param process_out A pointer to the `lm_process_t` structure that will be populated\n with information about the current process.\n\n @return `LM_TRUE` if the process information was successfully\n retrieved or `LM_FALSE` if there was an error."]
    pub fn LM_GetProcess(process_out: *mut lm_process_t) -> lm_bool_t;
}
extern "C" {
    #[doc = " Retrieves information about a specified process identified by its process ID.\n\n @param pid The process ID of the process for which you want to\n retrieve information.\n @param process_out A pointer to the `lm_process_t` structure that will be\n populated with information about the specified process.\n\n @return `LM_TRUE` if the process information was successfully\n retrieved or `LM_FALSE` if there was an issue during the\n retrieval process."]
    pub fn LM_GetProcessEx(pid: lm_pid_t, process_out: *mut lm_process_t) -> lm_bool_t;
}
extern "C" {
    #[doc = "Retrieves the command line arguments of a process."]
    pub fn LM_GetCommandLine(process: *const lm_process_t) -> *mut *mut lm_char_t;
}
extern "C" {
    #[doc = "Frees a command line buffer obtained from `LM_GetCommandLine`"]
    pub fn LM_FreeCommandLine(cmdline: *mut *mut lm_char_t);
}
extern "C" {
    #[doc = " Searches for a process by name and returns whether the process was\n found or not.\n\n @param process_name The name of the process you are trying to find\n (e.g `game.exe`). It can also be a relative path, such as\n `/game/hello` for a process at `/usr/share/game/hello`.\n @param process_out A pointer to the `lm_process_t` structure that will be\n populated with information about the found process.\n\n @return `LM_TRUE` if the process with the specified name was found\n successfully or `LM_FALSE` otherwise."]
    pub fn LM_FindProcess(process_name: lm_string_t, process_out: *mut lm_process_t) -> lm_bool_t;
}
extern "C" {
    #[doc = " Checks if a given process is alive based on its PID and start time.\n\n @param process The process that will be checked.\n\n @return `LM_TRUE` if the process specified by the input `lm_process_t`\n is alive or `LM_FALSE` otherwise."]
    pub fn LM_IsProcessAlive(process: *const lm_process_t) -> lm_bool_t;
}
extern "C" {
    #[doc = " Returns the size of a pointer in bits, which corresponds to the current\n process's bits (32 bits or 64 bits).\n\n @return The size of a pointer in bits."]
    pub fn LM_GetBits() -> lm_size_t;
}
extern "C" {
    #[doc = " Returns the system architecture bits (32 bits or 64 bits).\n\n @return The system bits (32 or 64)."]
    pub fn LM_GetSystemBits() -> lm_size_t;
}
extern "C" {
    #[doc = " Enumerates threads in the current process and calls a callback\n function for each thread found.\n\n @param callback The callback function that will receive the current\n thread in the enumeration and an extra argument. This function\n should return `LM_TRUE` to continue the enumeration, or `LM_FALSE`\n to stop it.\n @param arg The user-defined data structure that will be passed to\n the callback function `callback` during thread enumeration. This\n allows you to pass additional information or context to the\n callback function if needed.\n\n @return The function `LM_EnumThreads` returns a boolean value of\n type `lm_bool_t`, containing `LM_TRUE` if it succeeds, or\n `LM_FALSE` if it fails."]
    pub fn LM_EnumThreads(
        callback: unsafe extern "C" fn(thread: *mut lm_thread_t, arg: *mut lm_void_t) -> lm_bool_t,
        arg: *mut lm_void_t,
    ) -> lm_bool_t;
}
extern "C" {
    #[doc = " Enumerates threads of a given process and invokes a callback\n function for each thread.\n\n @param process The process you want to enumerate the threads from.\n @param callback The callback function that will receive the current\n thread in the enumeration and an extra argument. This function\n should return `LM_TRUE` to continue the enumeration, or `LM_FALSE`\n to stop it.\n @param arg The user-defined data that can be passed to the callback\n function. It allows you to provide additional information or\n context to the callback function when iterating over threads in a\n process.\n\n @return The function `LM_EnumThreadsEx` returns a boolean value,\n either `LM_TRUE` or `LM_FALSE`, depending on the success of the\n operation."]
    pub fn LM_EnumThreadsEx(
        process: *const lm_process_t,
        callback: unsafe extern "C" fn(thread: *mut lm_thread_t, arg: *mut lm_void_t) -> lm_bool_t,
        arg: *mut lm_void_t,
    ) -> lm_bool_t;
}
extern "C" {
    #[doc = " Retrieves information about the thread it's running from.\n\n @param thread_out A pointer to the `lm_thread_t` structure that will be populated\n with information about the current thread, specifically the thread ID (`tid`) and\n the process ID (`owner_pid`).\n\n @return `LM_TRUE` if the thread information was successfully\n retrieved and stored in the provided `lm_thread_t` structure.\n Otherwise, the function returns `LM_FALSE`."]
    pub fn LM_GetThread(thread_out: *mut lm_thread_t) -> lm_bool_t;
}
extern "C" {
    #[doc = " Retrieves information about a thread in a process.\n\n @param process The process that the thread will be retrieved from.\n @param thread_out A pointer to the `lm_thread_t` variable where the function will\n store the thread information retrieved from the process.\n\n @return `LM_TRUE` if the thread was retrieved successfully, or\n `LM_FALSE` if it fails."]
    pub fn LM_GetThreadEx(process: *const lm_process_t, thread_out: *mut lm_thread_t) -> lm_bool_t;
}
extern "C" {
    #[doc = " Retrieves the process that owns a given thread.\n\n @param thread The thread whose process will be retrieved.\n @param process_out A pointer to the `lm_process_t` structure where the function\n `LM_GetThreadProcess` will store the process information related to\n the given thread.\n\n @return `LM_TRUE` if the operation was successful or `LM_FALSE`\n otherwise."]
    pub fn LM_GetThreadProcess(
        thread: *const lm_thread_t,
        process_out: *mut lm_process_t,
    ) -> lm_bool_t;
}
extern "C" {
    #[doc = " Enumerates modules in the current process and calls a callback function\n for each module found.\n\n @param callback The callback function that will receive the current module in\n the enumeration and an extra argument. This function should return `LM_TRUE`\n to continue the enumeration, or `LM_FALSE` to stop it.\n @param arg An extra argument that is passed to the callback function. This allows\n you to provide additional information or context to the callback function when\n it is invoked during the enumeration of modules.\n\n @return Returns `LM_TRUE` if the enumeration succeeds, or `LM_FALSE` if it fails."]
    pub fn LM_EnumModules(
        callback: unsafe extern "C" fn(module: *mut lm_module_t, arg: *mut lm_void_t) -> lm_bool_t,
        arg: *mut lm_void_t,
    ) -> lm_bool_t;
}
extern "C" {
    #[doc = " Enumerates modules in a specified process and calls a callback function\n for each module found.\n\n @param process The process that the modules will be enumerated from.\n @param callback The callback function that will receive the current module in\n the enumeration and an extra argument. This function should return `LM_TRUE`\n to continue the enumeration, or `LM_FALSE` to stop it.\n @param arg An extra argument that is passed to the callback function. This allows\n you to provide additional information or context to the callback function when\n it is invoked during the enumeration of modules.\n\n @return Returns `LM_TRUE` if the enumeration succeeds, or `LM_FALSE` if it fails."]
    pub fn LM_EnumModulesEx(
        process: *const lm_process_t,
        callback: unsafe extern "C" fn(module: *mut lm_module_t, arg: *mut lm_void_t) -> lm_bool_t,
        arg: *mut lm_void_t,
    ) -> lm_bool_t;
}
extern "C" {
    #[doc = " Finds a module by name and populates the `module_out` parameter with the found module information.\n\n @param name The name of the module to find (e.g `game.dll`). It can also be a\n relative path, such as `/game/hello` for a module at `/usr/share/game/hello`.\n @param module_out A pointer to a `lm_module_t` structure. This function populates\n this structure with information about the found module, containing information\n such as base, end, size, path and name.\n\n @return Returns `LM_TRUE` if the module is found successfully, otherwise it\n returns `LM_FALSE`."]
    pub fn LM_FindModule(name: lm_string_t, module_out: *mut lm_module_t) -> lm_bool_t;
}
extern "C" {
    #[doc = " Finds a module by name in a specified process and populates the `module_out` parameter with the found module information.\n\n @param process The process that the module will be searched in.\n @param name The name of the module to find (e.g `game.dll`). It can also be a\n relative path, such as `/game/hello` for a module at `/usr/share/game/hello`.\n @param module_out A pointer to a `lm_module_t` structure. This function populates\n this structure with information about the found module, containing information\n such as base, end, size, path and name.\n\n @return Returns `LM_TRUE` if the module is found successfully, otherwise it\n returns `LM_FALSE`."]
    pub fn LM_FindModuleEx(
        process: *const lm_process_t,
        name: lm_string_t,
        module_out: *mut lm_module_t,
    ) -> lm_bool_t;
}
extern "C" {
    #[doc = " Loads a module from a specified path into the current process.\n\n @param path The path of the module to be loaded.\n @param module_out A pointer to a `lm_module_t` type, which is used to store information\n about the loaded module (optional).\n\n @return Returns `LM_TRUE` is the module was loaded successfully, or `LM_FALSE` if it fails."]
    pub fn LM_LoadModule(path: lm_string_t, module_out: *mut lm_module_t) -> lm_bool_t;
}
extern "C" {
    #[doc = " Loads a module from a specified path into a specified process.\n\n @param process The process that the module will be loaded into.\n @param path The path of the module to be loaded.\n @param module_out A pointer to a `lm_module_t` type, which is used to store information\n about the loaded module (optional).\n\n @return Returns `LM_TRUE` is the module was loaded successfully, or `LM_FALSE` if it fails."]
    pub fn LM_LoadModuleEx(
        process: *const lm_process_t,
        path: lm_string_t,
        module_out: *mut lm_module_t,
    ) -> lm_bool_t;
}
extern "C" {
    #[doc = " Unloads a module from the current process.\n\n @param module The module that you want to unload from the process.\n\n @return Returns `LM_TRUE` if the module was successfully unloaded, and `LM_FALSE` if it fails."]
    pub fn LM_UnloadModule(module: *const lm_module_t) -> lm_bool_t;
}
extern "C" {
    #[doc = " Unloads a module from a specified process.\n\n @param process The process that the module will be unloaded from.\n @param module The module that you want to unload from the process.\n\n @return Returns `LM_TRUE` if the module was successfully unloaded, and `LM_FALSE` if it fails."]
    pub fn LM_UnloadModuleEx(process: *const lm_process_t, module: *const lm_module_t)
        -> lm_bool_t;
}
extern "C" {
    #[doc = " Enumerates symbols in a module and calls a callback function for each symbol found.\n\n @param module The module where the symbols will be enumerated from.\n @param callback A function pointer that will receive each symbol in the enumeration and an extra argument.\n The callback function should return `LM_TRUE` to continue the enumeration or `LM_FALSE` to stop it.\n @param arg A pointer to user-defined data that can be passed to the callback function.\n It allows you to provide additional information or context.\n\n @return Returns `LM_TRUE` if the enumeration succeeds, `LM_FALSE` otherwise."]
    pub fn LM_EnumSymbols(
        module: *const lm_module_t,
        callback: unsafe extern "C" fn(symbol: *mut lm_symbol_t, arg: *mut lm_void_t) -> lm_bool_t,
        arg: *mut lm_void_t,
    ) -> lm_bool_t;
}
extern "C" {
    #[doc = " Finds the address of a symbol within a module.\n\n @param module The module where the symbol will be looked up from.\n @param symbol_name The name of the symbol to look up.\n\n @return Returns the address of the symbol, or `LM_ADDRESS_BAD` if it fails."]
    pub fn LM_FindSymbolAddress(
        module: *const lm_module_t,
        symbol_name: lm_string_t,
    ) -> lm_address_t;
}
extern "C" {
    #[doc = " Demangles a symbol name.\n\n @param symbol_name The symbol name to demangle.\n @param demangled_buf The buffer where the demangled symbol name will be stored.\n If this is `NULL`, the symbol will be dynamically allocated and `maxsize` is ignored.\n @param maxsize The maximum size of the buffer where the demangled symbol name will be stored.\n\n @return Returns a pointer to the demangled symbol string, or `NULL` if it fails.\n If the symbol was dynamically allocated, you need to free it with `LM_FreeDemangledSymbol`."]
    pub fn LM_DemangleSymbol(
        symbol_name: lm_string_t,
        demangled_buf: *mut lm_char_t,
        maxsize: lm_size_t,
    ) -> *mut lm_char_t;
}
extern "C" {
    #[doc = " Frees the memory allocated for a demangled symbol name.\n\n @param symbol_name The demangled symbol name to free."]
    pub fn LM_FreeDemangledSymbol(symbol_name: *mut lm_char_t);
}
extern "C" {
    #[doc = " Enumerates symbols in a module with demangled names and calls a provided callback function for each\n symbol found.\n\n @param module The module where the symbols will be enumerated from.\n @param callback A function pointer that will receive each demangled symbol in the enumeration and\n an extra argument. The callback function should return `LM_TRUE` to continue the enumeration or\n `LM_FALSE` to stop it.\n @param arg A pointer to user-defined data that can be passed to the callback function.\n It allows you to provide additional information or context.\n\n @return Returns `LM_TRUE` if the enumeration succeeds, `LM_FALSE` otherwise."]
    pub fn LM_EnumSymbolsDemangled(
        module: *const lm_module_t,
        callback: unsafe extern "C" fn(symbol: *mut lm_symbol_t, arg: *mut lm_void_t) -> lm_bool_t,
        arg: *mut lm_void_t,
    ) -> lm_bool_t;
}
extern "C" {
    #[doc = " Finds the address of a demangled symbol within a module.\n\n @param module The module where the symbol will be looked up from.\n @param symbol_name The name of the symbol to look up.\n\n @return Returns the address of the symbol, or `LM_ADDRESS_BAD` if it fails."]
    pub fn LM_FindSymbolAddressDemangled(
        module: *const lm_module_t,
        symbol_name: lm_string_t,
    ) -> lm_address_t;
}
extern "C" {
    #[doc = " Enumerates the memory segments of the current process and invokes a callback function for each segment.\n\n @param callback A function pointer that will receive each segment in the enumeration and an extra argument.\n The callback function should return `LM_TRUE` to continue the enumeration or `LM_FALSE` to stop it.\n @param arg A pointer to user-defined data that can be passed to the callback function.\n It allows you to provide additional information or context to the callback function when iterating over segments.\n\n @return The function returns `LM_TRUE` if the enumeration was successful, or `LM_FALSE` otherwise."]
    pub fn LM_EnumSegments(
        callback: unsafe extern "C" fn(
            segment: *mut lm_segment_t,
            arg: *mut lm_void_t,
        ) -> lm_bool_t,
        arg: *mut lm_void_t,
    ) -> lm_bool_t;
}
extern "C" {
    #[doc = " Enumerates the memory segments of a given process and invokes a callback function for each segment.\n\n @param process A pointer to a structure containing information about the process whose segments\n will be enumerated.\n @param callback A function pointer that will receive each segment in the enumeration and an extra argument.\n The callback function should return `LM_TRUE` to continue the enumeration or `LM_FALSE` to stop it.\n @param arg A pointer to user-defined data that can be passed to the callback function.\n It allows you to provide additional information or context to the callback function when iterating over segments.\n\n @return The function returns `LM_TRUE` if the enumeration was successful, or `LM_FALSE` otherwise."]
    pub fn LM_EnumSegmentsEx(
        process: *const lm_process_t,
        callback: unsafe extern "C" fn(
            segment: *mut lm_segment_t,
            arg: *mut lm_void_t,
        ) -> lm_bool_t,
        arg: *mut lm_void_t,
    ) -> lm_bool_t;
}
extern "C" {
    #[doc = " The function `LM_FindSegment` searches for a memory segment that a given address is within and populates the\n `segment_out` parameter with the result.\n\n @param address The address to search for.\n @param segment_out A pointer to an `lm_segment_t` structure to populate with information about the\n segment that contains the specified address.\n\n @return The function returns `LM_TRUE` if the specified address is found within a segment, or `LM_FALSE` otherwise."]
    pub fn LM_FindSegment(address: lm_address_t, segment_out: *mut lm_segment_t) -> lm_bool_t;
}
extern "C" {
    #[doc = " The function `LM_FindSegment` searches for a memory segment that a given address is within and populates the\n `segment_out` parameter with the result.\n\n @param process A pointer to a structure containing information about the process whose memory\n segments will be searched.\n @param address The address to search for.\n @param segment_out A pointer to an `lm_segment_t` structure to populate with information about the\n segment that contains the specified address.\n\n @return The function returns `LM_TRUE` if the specified address is found within a segment, or `LM_FALSE` otherwise."]
    pub fn LM_FindSegmentEx(
        process: *const lm_process_t,
        address: lm_address_t,
        segment_out: *mut lm_segment_t,
    ) -> lm_bool_t;
}
extern "C" {
    #[doc = " Reads memory from a source address and copies it to a destination\n address.\n\n @param source The memory address from which data will be read.\n @param dest A pointer to a memory location where the data read from the\n source address will be stored.\n @param size The number of bytes to read from the memory starting at the\n source address and write into the dest buffer.\n\n @return The number of bytes read from memory."]
    pub fn LM_ReadMemory(source: lm_address_t, dest: *mut lm_byte_t, size: lm_size_t) -> lm_size_t;
}
extern "C" {
    #[doc = " Reads memory from a process and returns the number of bytes read.\n\n @param process A pointer to the process that the memory will be read from.\n @param source The starting address in the target process from which\n you want to read memory.\n @param dest A pointer to the destination buffer where the memory read\n operation will store the data read from the specified source address.\n @param size The number of bytes to read from the memory location\n specified by the `source` address.\n\n @return The number of bytes successfully read from the specified\n memory address in the target process. If an error occurs during the\n read operation, it returns 0."]
    pub fn LM_ReadMemoryEx(
        process: *const lm_process_t,
        source: lm_address_t,
        dest: *mut lm_byte_t,
        size: lm_size_t,
    ) -> lm_size_t;
}
extern "C" {
    #[doc = " Writes data from a source address to a destination address in memory.\n\n @param dest The destination memory address where the data from the\n `source` array will be written to.\n @param source A pointer to the data that needs to be written to the\n memory starting at the destination address `dest`.\n @param size The number of bytes to be written from the `source`\n array to the memory starting at the `dest` address.\n\n @return The number of bytes written to the destination memory\n address."]
    pub fn LM_WriteMemory(dest: lm_address_t, source: lm_bytearray_t, size: lm_size_t)
        -> lm_size_t;
}
extern "C" {
    #[doc = " Writes data from a source address to a destination address in a\n specified process.\n\n @param process A pointer to a structure representing a process in the\n system.\n @param dest The destination address in the target process where the\n data from the `source` array will be written to.\n @param source A pointer to the data that needs to be written to the\n memory of the target process.\n @param size The number of bytes to be written from the `source`\n bytearray to the memory address specified by `dest`.\n\n @return The number of bytes that were successfully written to the\n destination address in the process's memory. If an error occurs\n during the write operation, it returns 0."]
    pub fn LM_WriteMemoryEx(
        process: *const lm_process_t,
        dest: lm_address_t,
        source: lm_bytearray_t,
        size: lm_size_t,
    ) -> lm_size_t;
}
extern "C" {
    #[doc = " Sets a specified memory region to a given byte value.\n\n @param dest The destination memory address where the `byte` value will\n be written to, starting from this address.\n @param byte The value of the byte that will be written to the memory\n locations starting from the `dest` address.\n @param size The number of bytes to set in the memory starting from\n the `dest` address.\n\n @return The number of bytes that were successfully set to the\n specified value `byte` in the memory region starting at address\n `dest`."]
    pub fn LM_SetMemory(dest: lm_address_t, byte: lm_byte_t, size: lm_size_t) -> lm_size_t;
}
extern "C" {
    #[doc = " Sets a specified memory region to a given byte value in a target\n process.\n\n @param process A pointer to the process that the memory will be set.\n @param dest The destination address in the target process where the\n `byte` value will be written to.\n @param byte The value of the byte that will be written to the memory\n locations starting from the `dest` address.\n @param size The number of bytes to set in the memory starting from\n the `dest` address.\n\n @return The number of bytes that were successfully set to the\n specified value `byte` in the memory region starting at address\n `dest` in the target process. If there are any errors, it returns 0."]
    pub fn LM_SetMemoryEx(
        process: *const lm_process_t,
        dest: lm_address_t,
        byte: lm_byte_t,
        size: lm_size_t,
    ) -> lm_size_t;
}
extern "C" {
    #[doc = " The function sets memory protection flags for a specified memory address range.\n\n @param address The memory address to be protected.\n @param size The size of memory to be protected. If the size is 0,\n the function will default to using the system's page size for the operation.\n @param prot The new protection flags that will be applied to the memory region\n starting at the specified address. It is a bit mask of `LM_PROT_X`\n (execute), `LM_PROT_R` (read), `LM_PROT_W` (write).\n @param oldprot_out A pointer to a `lm_prot_t` type variable that will be used to\n store the old protection flags of a memory segment before they are updated with\n the new protection settings specified by the `prot` parameter.\n\n @return The function returns a boolean value, either `LM_TRUE` or `LM_FALSE`, based on the\n success of the memory protection operation."]
    pub fn LM_ProtMemory(
        address: lm_address_t,
        size: lm_size_t,
        prot: lm_prot_t,
        oldprot_out: *mut lm_prot_t,
    ) -> lm_bool_t;
}
extern "C" {
    #[doc = " The function modifies memory protection flags for a specified address range in a given\n process.\n\n @param process A pointer to the process that the memory flags will be modified from.\n @param address The memory address to be protected.\n @param size The size of memory to be protected. If the size is 0,\n the function will default to using the system's page size for the operation.\n @param prot The new protection flags that will be applied to the memory region\n starting at the specified address. It is a bit mask of `LM_PROT_X`\n (execute), `LM_PROT_R` (read), `LM_PROT_W` (write).\n @param oldprot_out A pointer to a `lm_prot_t` type variable that will be used to\n store the old protection flags of a memory segment before they are updated with\n the new protection settings specified by the `prot` parameter.\n\n @return The function returns a boolean value indicating whether the memory\n protection operation was successful or not. It returns `LM_TRUE` if the\n operation was successful and `LM_FALSE` if it was not."]
    pub fn LM_ProtMemoryEx(
        process: *const lm_process_t,
        address: lm_address_t,
        size: lm_size_t,
        prot: lm_prot_t,
        oldprot_out: *mut lm_prot_t,
    ) -> lm_bool_t;
}
extern "C" {
    #[doc = " The function allocates memory with a specified size and protection flags,\n returning the allocated memory address.\n\n @param size The size of memory to be allocated. If the size is 0, the\n function will allocate a full page of memory. If a specific size is\n provided, that amount of memory will be allocated, aligned to the next\n page size.\n @param prot The memory protection flags for the allocated memory region.\n It is a bit mask of `LM_PROT_X` (execute), `LM_PROT_R` (read), `LM_PROT_W`\n (write).\n\n @return The function returns the memory address of the allocated memory with\n the specified allocation options, or `LM_ADDRESS_BAD` if it fails."]
    pub fn LM_AllocMemory(size: lm_size_t, prot: lm_prot_t) -> lm_address_t;
}
extern "C" {
    #[doc = " The function allocates memory in a specified process with the given size\n and memory protection flags.\n\n @param process A pointer to the process that the memory will be allocated to.\n @param size The size of memory to be allocated. If the size is 0, the\n function will allocate a full page of memory. If a specific size is\n provided, that amount of memory will be allocated, aligned to the next\n page size.\n @param prot The memory protection flags for the allocated memory region.\n It is a bit mask of `LM_PROT_X` (execute), `LM_PROT_R` (read), `LM_PROT_W`\n (write).\n\n @return The function returns a memory address of type `lm_address_t` if the\n memory allocation is successful. If there are any issues, it returns\n `LM_ADDRESS_BAD`."]
    pub fn LM_AllocMemoryEx(
        process: *const lm_process_t,
        size: lm_size_t,
        prot: lm_prot_t,
    ) -> lm_address_t;
}
extern "C" {
    #[doc = " The function deallocates memory that was previously allocated with\n `LM_AllocMemory`.\n\n @param alloc The address of the memory block that was previously allocated.\n @param size The size of the memory block that was previously allocated.\n If the size is 0, the function will use the system's page size for unmapping\n the memory.\n\n @return The function returns `LM_TRUE` if the memory deallocation operation\n is successful, and `LM_FALSE` if the operation fails."]
    pub fn LM_FreeMemory(alloc: lm_address_t, size: lm_size_t) -> lm_bool_t;
}
extern "C" {
    #[doc = " The function deallocates memory that was previously allocated with\n `LM_AllocMemoryEx` on a given process.\n\n @param process A pointer to the process that the memory will be deallocated from.\n @param alloc The address of the memory block that was previously allocated\n and needs to be freed.\n @param size The size of the memory block that was previously allocated\n and now needs to be freed. If the size is 0, the function will use the\n system's page size as the default size for freeing the memory.\n\n @return The function returns a boolean value (`LM_TRUE` or `LM_FALSE`)\n indicating whether the memory deallocation operation was successful or\n not."]
    pub fn LM_FreeMemoryEx(
        process: *const lm_process_t,
        alloc: lm_address_t,
        size: lm_size_t,
    ) -> lm_bool_t;
}
extern "C" {
    #[doc = " The function calculates a deep pointer address by applying a series of\n offsets to a base address and dereferencing intermediate pointers.\n\n @param base The starting address from which to calculate the deep pointer.\n @param offsets An array of offsets used to navigate through the memory addresses.\n @param noffsets The number of offsets in the `offsets` array.\n\n @return The function returns a deep pointer calculated based on the provided\n base address, offsets, and number of offsets. The function iterates through\n the offsets, adjusting the base address and dereferencing accordingly."]
    pub fn LM_DeepPointer(
        base: lm_address_t,
        offsets: *const lm_address_t,
        noffsets: usize,
    ) -> lm_address_t;
}
extern "C" {
    #[doc = " The function calculates a deep pointer address by applying a series of\noffsets to a base address and dereferencing intermediate pointers in a given\nprocess's memory space.\n *\n@param process A pointer to the process that the deep pointer will be calculated from.\n@param base The starting address from which to calculate the deep pointer.\n@param offsets An array of offsets used to navigate through the memory addresses.\n@param noffsets The number of offsets in the `offsets` array.\n *\n@return The function returns a deep pointer calculated based on the provided\nbase address, offsets, and number of offsets.\n"]
    pub fn LM_DeepPointerEx(
        process: *const lm_process_t,
        base: lm_address_t,
        offsets: *const lm_address_t,
        noffsets: usize,
    ) -> lm_address_t;
}
extern "C" {
    #[doc = " The function scans a specified memory address range for a specific data\n pattern and returns the address where the data is found.\n\n @param data The data to be scanned for in memory.\n @param datasize The size of the data array. It indicates the number of\n bytes that need to match consecutively in order to consider it a match.\n @param address The starting memory address where the scanning operation\n will begin. The function will scan a range of memory starting from this\n address to find the data.\n @param scansize The size of the memory region to scan starting from the\n specified `address`. It determines the range within which the function will\n search for a match with the provided `data` array.\n\n @return The function returns the memory address where a match for the\n provided data was found. If no match is found, it returns\n `LM_ADDRESS_BAD`."]
    pub fn LM_DataScan(
        data: lm_bytearray_t,
        datasize: lm_size_t,
        address: lm_address_t,
        scansize: lm_size_t,
    ) -> lm_address_t;
}
extern "C" {
    #[doc = " The function scans a specified memory address range for a specific data\n pattern in a given process and returns the address where the data is\n found.\n\n @param process The process whose memory will be scanned.\n @param data The data to be scanned for in memory.\n @param datasize The size of the data array. It indicates the number of\n bytes that need to match consecutively in order to consider it a match.\n @param address The starting memory address where the scanning operation\n will begin. The function will scan a range of memory starting from this\n address to find the data.\n @param scansize The size of the memory region to scan starting from the\n specified `address`. It determines the range within which the function will\n search for a match with the provided `data` array.\n\n @return The function returns the memory address where a match for the\n provided data was found. If no match is found, it returns\n `LM_ADDRESS_BAD`."]
    pub fn LM_DataScanEx(
        process: *const lm_process_t,
        data: lm_bytearray_t,
        datasize: lm_size_t,
        address: lm_address_t,
        scansize: lm_size_t,
    ) -> lm_address_t;
}
extern "C" {
    #[doc = " The function searches for a specific pattern in memory based on a given\n mask.\n\n @param pattern The pattern to be searched for in memory.\n @param mask The pattern mask used for scanning memory. It is used to\n specify which bytes in the pattern should be matched against the memory\n content. The mask can contain characters such as '?' which act as\n wildcards, allowing any byte to be matched. You can also use 'x' to have\n an exact match.\n @param address The starting memory address where the scanning operation\n will begin. The function will scan the memory starting from this address\n to find the pattern match.\n @param scansize The size of the memory region to scan starting from the\n specified `address`. It determines the range within which the function\n will search for the specified pattern based on the provided `pattern` and\n `mask`.\n\n @return The function returns the memory address where a match for the\n given pattern and mask is found within the specified scan size starting\n from the provided address. If no match is found or if an error occurs,\n the function returns `LM_ADDRESS_BAD`."]
    pub fn LM_PatternScan(
        pattern: lm_bytearray_t,
        mask: lm_string_t,
        address: lm_address_t,
        scansize: lm_size_t,
    ) -> lm_address_t;
}
extern "C" {
    #[doc = " The function searches for a specific pattern in memory in a given process based on a mask.\n\n @param process The process whose memory will be scanned.\n @param pattern The pattern to be searched for in memory.\n @param mask The pattern mask used for scanning memory. It is used to specify which bytes in the\n pattern should be matched against the memory content. The mask can contain characters such as\n '?' which act as wildcards, allowing any byte to be matched. You can also use 'x' to have an exact\n match.\n @param address The starting memory address where the scanning operation will begin. The function\n will scan the memory starting from this address to find the pattern match.\n @param scansize The size of the memory region to scan starting from the specified `address`. It\n determines the range within which the function will search for the specified pattern based on the\n provided `pattern` and `mask`.\n\n @return The function returns the memory address where a match for the given pattern and mask is\n found within the specified scan size starting from the provided address. If no match is found or\n if an error occurs, the function returns `LM_ADDRESS_BAD`."]
    pub fn LM_PatternScanEx(
        process: *const lm_process_t,
        pattern: lm_bytearray_t,
        mask: lm_string_t,
        address: lm_address_t,
        scansize: lm_size_t,
    ) -> lm_address_t;
}
extern "C" {
    #[doc = " The function searches for a specific signature pattern in memory starting from a given address\n within a specified scan size.\n\n @param signature The signature to be scanned for in memory. It is used to identify a specific\n pattern of bytes in memory. You can use `??` to match against any byte, or the byte's hexadecimal\n value. Example: `\"DE AD BE EF ?? ?? 13 37\"`.\n @param address The starting memory address where the signature scanning will begin. The function\n will scan the memory starting from this address to find the pattern match.\n @param scansize The size of the memory region to scan starting from the `address` parameter. It\n specifies the number of bytes to search for the signature pattern within the memory region.\n\n @return The function retuns either the address of the pattern match found in the specified memory range\n or `LM_ADDRESS_BAD` if no match is found (or an error occurs)."]
    pub fn LM_SigScan(
        signature: lm_string_t,
        address: lm_address_t,
        scansize: lm_size_t,
    ) -> lm_address_t;
}
extern "C" {
    #[doc = " The function searches for a specific signature pattern in memory from a given process starting\n from a specific address within a specified scan size.\n\n @param process The process whose memory will be scanned.\n @param signature The signature to be scanned for in memory. It is used to identify a specific\n pattern of bytes in memory. You can use `??` to match against any byte, or the byte's hexadecimal\n value. Example: `\"DE AD BE EF ?? ?? 13 37\"`.\n @param address The starting memory address where the signature scanning will begin. The function\n will scan the memory starting from this address to find the pattern match.\n @param scansize The size of the memory region to scan starting from the `address` parameter. It\n specifies the number of bytes to search for the signature pattern within the memory region.\n\n @return The function retuns either the address of the pattern match found in the specified memory range\n or `LM_ADDRESS_BAD` if no match is found (or an error occurs)."]
    pub fn LM_SigScanEx(
        process: *const lm_process_t,
        signature: lm_string_t,
        address: lm_address_t,
        scansize: lm_size_t,
    ) -> lm_address_t;
}
extern "C" {
    #[doc = " The function returns the current architecture.\n\n @return The function returns the architecture of the system. It can be one of:\n - `LM_ARCH_X86` for 32-bit x86.\n - `LM_ARCH_AMD64` for 64-bit x86.\n - Others (check the enum for `lm_arch_t`)"]
    pub fn LM_GetArchitecture() -> lm_arch_t;
}
extern "C" {
    #[doc = " The function assembles a single instruction into machine code.\n\n @param code The instruction to be assembled.\n Example: `\"mov eax, ebx\"`.\n @param instruction_out The assembled instruction is populated into this parameter.\n\n @return The function returns `LM_TRUE` if it succeeds in assembling the instruction, and\n populates the `instruction_out` parameter with the assembled instruction.\n If the instruction could not be assembled successfully, then the function returns `LM_FALSE`."]
    pub fn LM_Assemble(code: lm_string_t, instruction_out: *mut lm_inst_t) -> lm_bool_t;
}
extern "C" {
    #[doc = " The function assembles instructions into machine code.\n\n @param code The instructions to be assembled.\n Example: `\"mov eax, ebx ; jmp eax\"`.\n @param arch The architecture to be assembled.\n @param runtime_address The runtime address to resolve\n the addressing (for example, relative jumps will be resolved using this address).\n @param payload_out A pointer to the buffer that will receive the assembled instructions.\n The buffer should be freed with `LM_FreePayload` after use.\n\n @return On success, it returns the size of the assembled instructions, in bytes.\n On failure, it returns `0`."]
    pub fn LM_AssembleEx(
        code: lm_string_t,
        arch: lm_arch_t,
        runtime_address: lm_address_t,
        payload_out: *mut *mut lm_byte_t,
    ) -> lm_size_t;
}
extern "C" {
    #[doc = " The function deallocates memory allocated by `LM_AssembleEx`.\n\n @param payload The memory to be freed that was allocated by `LM_AssembleEx`."]
    pub fn LM_FreePayload(payload: *mut lm_byte_t);
}
extern "C" {
    #[doc = " The function disassembles one instruction into an `lm_inst_t` struct.\n\n @param machine_code The address of the instruction to be disassembled.\n @param instruction_out The disassembled instruction is populated into this parameter.\n\n @return `LM_TRUE` on success, `LM_FALSE` on failure."]
    pub fn LM_Disassemble(machine_code: lm_address_t, instruction_out: *mut lm_inst_t)
        -> lm_bool_t;
}
extern "C" {
    #[doc = " The function disassembles instructions into an array of\n `lm_inst_t` structs.\n\n @param machine_code The address of the instructions to be disassembled.\n @param arch The architecture to be disassembled.\n @param max_size The maximum number of bytes to disassemble (0 for as\n many as possible, limited by `instruction_count`).\n @param instruction_count The amount of instructions\n to disassemble (0 for as many as possible, limited by `max_size`).\n @param runtime_address The runtime address to resolve\n the addressing (for example, relative jumps will be resolved using this address).\n @param instructions_out A pointer to the buffer that will receive the disassembled instructions.\n The buffer should be freed with `LM_FreeInstructions` after use.\n\n @return On success, it returns the count of the instructions disassembled. On failure, it\n returns `0`."]
    pub fn LM_DisassembleEx(
        machine_code: lm_address_t,
        arch: lm_arch_t,
        max_size: lm_size_t,
        instruction_count: lm_size_t,
        runtime_address: lm_address_t,
        instructions_out: *mut *mut lm_inst_t,
    ) -> lm_size_t;
}
extern "C" {
    #[doc = " The function deallocates the memory allocated by `LM_DisassembleEx` for the disassembled instructions.\n\n @param instructions The disassembled instructions allocated by `LM_DisassembleEx`."]
    pub fn LM_FreeInstructions(instructions: *mut lm_inst_t);
}
extern "C" {
    #[doc = " The function calculates the size aligned to the instruction length, based on a minimum size.\n\n @param machine_code The address of the instructions.\n @param min_length The minimum size to be aligned to instruction length.\n\n @return On success, it returns the aligned size to the next instruction's length. On failure, it returns `0`."]
    pub fn LM_CodeLength(machine_code: lm_address_t, min_length: lm_size_t) -> lm_size_t;
}
extern "C" {
    #[doc = " The function calculates the size aligned to the instruction length, based on a minimum size, in a remote process.\n\n @param process The remote process to get the aligned length from.\n @param machine_code The address of the instructions in the remote process.\n @param min_length The minimum size to be aligned to instruction length.\n\n @return On success, it returns the aligned size to the next instruction's length. On failure, it returns `0`."]
    pub fn LM_CodeLengthEx(
        process: *const lm_process_t,
        machine_code: lm_address_t,
        min_length: lm_size_t,
    ) -> lm_size_t;
}
extern "C" {
    #[doc = " The function places a hook/detour onto the address `from`, redirecting it to the address `to`.\n Optionally, it generates a trampoline in `trampoline_out` to call the original function.\n\n @param from The address where the hook will be placed.\n @param to The address where the hook will jump to.\n @param trampoline_out Optional pointer to an `lm_address_t` variable that will receive a trampoline/gateway to call the original function.\n\n @return The amount of bytes occupied by the hook (aligned to the nearest instruction)."]
    pub fn LM_HookCode(
        from: lm_address_t,
        to: lm_address_t,
        trampoline_out: *mut lm_address_t,
    ) -> lm_size_t;
}
extern "C" {
    #[doc = " The function places a hook/detour onto the address `from` in a remote process, redirecting it to the address `to`.\n Optionally, it generates a trampoline in `trampoline_out` to call the original function in the remote process.\n\n @param process The remote process to place the hook in.\n @param from The address where the hook will be placed in the remote process.\n @param to The address where the hook will jump to in the remote process.\n @param trampoline_out Optional pointer to an `lm_address_t` variable that will receive a trampoline/gateway to call the\n original function in the remote process.\n\n @return The amount of bytes occupied by the hook (aligned to the nearest instruction) in the remote process."]
    pub fn LM_HookCodeEx(
        process: *const lm_process_t,
        from: lm_address_t,
        to: lm_address_t,
        trampoline_out: *mut lm_address_t,
    ) -> lm_size_t;
}
extern "C" {
    #[doc = " The function removes a hook/detour placed on the address `from`, restoring it to its original state.\n The function also frees the trampoline allocated by `LM_HookCode`.\n\n @param from The address where the hook was placed.\n @param trampoline The address of the trampoline generated by `LM_HookCode`.\n @param size The amount of bytes occupied by the hook (aligned to the nearest instruction).\n\n @return `LM_TRUE` on success, `LM_FALSE` on failure."]
    pub fn LM_UnhookCode(
        from: lm_address_t,
        trampoline: lm_address_t,
        size: lm_size_t,
    ) -> lm_bool_t;
}
extern "C" {
    #[doc = " The function removes a hook/detour placed on the address `from` in a remote process, restoring it to its original state.\n The function also frees the trampoline allocated by `LM_HookCodeEx`.\n\n @param process The remote process where the hook was placed.\n @param from The address where the hook was placed in the remote process.\n @param trampoline The address of the trampoline generated by `LM_HookCodeEx`.\n @param size The amount of bytes occupied by the hook (aligned to the nearest instruction) in the remote process.\n\n @return `LM_TRUE` on success, `LM_FALSE` on failure."]
    pub fn LM_UnhookCodeEx(
        process: *const lm_process_t,
        from: lm_address_t,
        trampoline: lm_address_t,
        size: lm_size_t,
    ) -> lm_bool_t;
}
extern "C" {
    #[doc = " The function creates a new VMT manager from the VMT at `vtable`.\n\n @param vtable The virtual method table to manage.\n @param vmt_out A pointer to the VMT manager that will be populated by this function.\n\n @return On success, it returns `LM_TRUE`. On failure, it returns `LM_FALSE`."]
    pub fn LM_VmtNew(vtable: *mut lm_address_t, vmt_out: *mut lm_vmt_t) -> lm_bool_t;
}
extern "C" {
    #[doc = " The function hooks the VMT function at index `from_fn_index` in the VMT managed by `vmt`,\n changing it to `to`.\n\n @param vmt The VMT manager.\n @param from_fn_index The index of the VMT function to hook.\n @param to The function that will replace the original VMT function.\n\n @return On success, it returns `LM_TRUE`. On failure, it returns `LM_FALSE`."]
    pub fn LM_VmtHook(vmt: *mut lm_vmt_t, from_fn_index: lm_size_t, to: lm_address_t) -> lm_bool_t;
}
extern "C" {
    #[doc = " The function unhooks the VMT function at index `fn_index` in the VMT managed by `vmt`,\n restoring the original function.\n\n @param vmt The VMT manager.\n @param fn_index The index of the VMT function to unhook."]
    pub fn LM_VmtUnhook(vmt: *mut lm_vmt_t, fn_index: lm_size_t) -> lm_bool_t;
}
extern "C" {
    #[doc = " The function returns the original VMT function at index `fn_index` in the VMT managed by `vmt`.\n If the function has not been hooked before, it returns the function pointer at that index in the VMT array.\n\n @param vmt The VMT manager.\n @param fn_index The index of the VMT function to query.\n\n @return The original VMT function at index `fn_index` in the VMT managed by `vmt`."]
    pub fn LM_VmtGetOriginal(vmt: *const lm_vmt_t, fn_index: lm_size_t) -> lm_address_t;
}
extern "C" {
    #[doc = " The function resets all the VMT functions back to their original addresses.\n\n @param vmt The VMT manager."]
    pub fn LM_VmtReset(vmt: *mut lm_vmt_t);
}
extern "C" {
    #[doc = " The function frees the VMT manager, restoring everything.\n\n @param vmt The VMT manager."]
    pub fn LM_VmtFree(vmt: *mut lm_vmt_t);
}
