---
date: "2016-08-14T10:15:42+02:00"
title: "Directory structure"
description: "Description of the directory layout of the git repository"
weight: 2

menu:
  main:
    Parent: "documentation"
    Weight: 2
---

## Introduction

In the following the directory layout of the it repository content and the
purpose of the various directories is described. Note that all files and
directories are mentioned, we are just describinf the most important ones.

## Core libraries

libosmscout/
: The libosmscout base library.

libosmscout-import/
: Library containing the import code, allowing conversion of *.osm and *.pbf
files into the libosmscout-specific database.

libosmscout-map/
: Base library for all map renderer.

libosmscout-map-agg/
: Library containing the agg render backend.

libosmscout-map-cairo/
: Library containing the cairo render backend.

libosmscout-map-directx/
: Library containing the DirectX render backend.

libosmscout-map-gdi/
: Library containing the GDI+ render backend.

libosmscout-map-iOSX/
: Library containing the Mac OS and iOS render backend.

libosmscout-map-opengl/
: Library containing the OpenGL render backend.

libosmscout-map-qt/
: Library containing the Qt render backend.

libosmscout-client-qt/
: Library containing common Qt application code (shared by OSMScout2 and
  StyleEditor).

libosmscout-map-avg/
: Library containing the SVG render backend.

## Demos

Demos/
: Command line based demo applications

OSMScout2/
: QT based demo application.

## Tools

DumpData/
: Tool to dump parts of the internal database generated during import of OSM
  data.
  
Import/
: The importer, creating an libosmscout-specific database from OSM export files.

BasemapImport/
: A second importer, that allows you to create a world-wide basic map, to be used
  as background for the actual more details maps based on the normal import.

StyelEditor/
: Variant of the Qt demo application that allows editing the style sheet in the
  application, showing results of the change directly in the map.

## Accessory files

cmake/
: Contains additional CMake helper files.

stylesheets/
: Contains the default libosmscout type definition (*.ost) and stylesheet
  (*.oss) files.
  
maps/
: Directory with helper script for genertaing databases from OSM files.

## Additional directories

Android/
: Source code of manual written JNI wrappers for Android. The wrappers
  are not up to date anymore. Current goal is, to finish the SWIG wrappers
  instead.
    
Apple/
: Apple specific project files and demo applications.

ci/
: Directory with files for continuous integration. You can find the Travis-ci
  and Appveyor files here. The docker files are also placed here.
  
Documentation/
: In-project documentation for specific aspects of the library. It is planed to
  move these files to the web site.
  
Java/
: A Java Maven project with a number of demo classes, accessing the libosmscout
  library via the JNI wrappers generated by SWIG.
  
libosmscout-extern/
: Plugin for accesing libosmscout from Matlab.

libosmscout-binding/
: Project calling SWIG to generate stubs for interfacing libosmscout from
  various languages (currently Java, C#).

libosmscout-java/
: The target of the SWIG generation. Creates a jar containing the JNI stubs.

webpage/
: The source of the webpage. The webpage is generated using
  [Hugo](https://gohugo.io/).
