; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc -mtriple=aarch64 -mattr=+sha3 < %s | FileCheck --check-prefix=SHA3 %s
; RUN: llc -mtriple=aarch64 -mattr=-sha3 < %s | FileCheck --check-prefix=NOSHA3 %s

define <2 x i64> @xar(<2 x i64> %x, <2 x i64> %y) {
; SHA3-LABEL: xar:
; SHA3:       // %bb.0:
; SHA3-NEXT:    xar v0.2d, v0.2d, v1.2d, #54
; SHA3-NEXT:    ret
;
; NOSHA3-LABEL: xar:
; NOSHA3:       // %bb.0:
; NOSHA3-NEXT:    eor v1.16b, v0.16b, v1.16b
; NOSHA3-NEXT:    shl v0.2d, v1.2d, #10
; NOSHA3-NEXT:    usra v0.2d, v1.2d, #54
; NOSHA3-NEXT:    ret
    %a = xor <2 x i64> %x, %y
    %b = call <2 x i64> @llvm.fshl.v2i64(<2 x i64> %a, <2 x i64> %a, <2 x i64> <i64 10, i64 10>)
    ret <2 x i64> %b
}

define <1 x i64> @xar_v1i64(<1 x i64> %a, <1 x i64> %b) {
; SHA3-LABEL: xar_v1i64:
; SHA3:       // %bb.0:
; SHA3-NEXT:    // kill: def $d0 killed $d0 def $q0
; SHA3-NEXT:    // kill: def $d1 killed $d1 def $q1
; SHA3-NEXT:    xar v0.2d, v0.2d, v1.2d, #63
; SHA3-NEXT:    // kill: def $d0 killed $d0 killed $q0
; SHA3-NEXT:    ret
;
; NOSHA3-LABEL: xar_v1i64:
; NOSHA3:       // %bb.0:
; NOSHA3-NEXT:    eor v1.8b, v0.8b, v1.8b
; NOSHA3-NEXT:    shl d0, d1, #1
; NOSHA3-NEXT:    usra d0, d1, #63
; NOSHA3-NEXT:    ret
  %v.val = xor <1 x i64> %a, %b
  %fshl = tail call <1 x i64> @llvm.fshl.v1i64(<1 x i64> %v.val, <1 x i64> %v.val, <1 x i64> splat (i64 1))
  ret <1 x i64> %fshl
}

declare <2 x i64> @llvm.fshl.v2i64(<2 x i64>, <2 x i64>, <2 x i64>)
