; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=amdgcn -mcpu=tahiti -verify-machineinstrs < %s | FileCheck -check-prefix=SI %s

define amdgpu_kernel void @s_clear_msb(ptr addrspace(1) %out, i32 %in) {
; SI-LABEL: s_clear_msb:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s6, s[4:5], 0xb
; SI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_and_b32 s4, s6, 0x7fffffff
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
  %x = and i32 %in, 2147483647
  store i32 %x, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @s_set_msb(ptr addrspace(1) %out, i32 %in) {
; SI-LABEL: s_set_msb:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s6, s[4:5], 0xb
; SI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_or_b32 s4, s6, 0x80000000
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
  %x = or i32 %in, 2147483648
  store i32 %x, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @s_clear_lsb(ptr addrspace(1) %out, i32 %in) {
; SI-LABEL: s_clear_lsb:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s6, s[4:5], 0xb
; SI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_and_b32 s4, s6, -2
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
  %x = and i32 %in, 4294967294
  store i32 %x, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @s_set_lsb(ptr addrspace(1) %out, i32 %in) {
; SI-LABEL: s_set_lsb:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s6, s[4:5], 0xb
; SI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_or_b32 s4, s6, 1
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
  %x = or i32 %in, 1
  store i32 %x, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @s_clear_midbit(ptr addrspace(1) %out, i32 %in) {
; SI-LABEL: s_clear_midbit:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s6, s[4:5], 0xb
; SI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_and_b32 s4, s6, 0xfffffeff
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
  %x = and i32 %in, 4294967039
  store i32 %x, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @s_set_midbit(ptr addrspace(1) %out, i32 %in) {
; SI-LABEL: s_set_midbit:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s6, s[4:5], 0xb
; SI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_or_b32 s4, s6, 0x100
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
  %x = or i32 %in, 256
  store i32 %x, ptr addrspace(1) %out
  ret void
}

@gv = external addrspace(1) global i32

; Make sure there's no verifier error with an undef source.
define void @bitset_verifier_error() local_unnamed_addr #0 {
; SI-LABEL: bitset_verifier_error:
; SI:       ; %bb.0: ; %bb
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_getpc_b64 s[4:5]
; SI-NEXT:    s_add_u32 s4, s4, gv@gotpcrel32@lo+4
; SI-NEXT:    s_addc_u32 s5, s5, gv@gotpcrel32@hi+12
; SI-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x0
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_and_b32 s8, s4, 0x7fffffff
; SI-NEXT:    v_mov_b32_e32 v0, s8
; SI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v0, 0x3f7fbe77
; SI-NEXT:    v_cmp_ge_f32_e64 s[4:5], |s4|, v0
; SI-NEXT:    s_and_b64 vcc, exec, s[4:5]
; SI-NEXT:    s_cbranch_vccnz .LBB6_2
; SI-NEXT:  ; %bb.1: ; %bb5
; SI-NEXT:  .LBB6_2: ; %bb6
bb:
  %i = call float @llvm.fabs.f32(float undef) #0
  %i1 = bitcast float %i to i32
  store i32 %i1, ptr addrspace(1) @gv
  br label %bb2

bb2:
  %i3 = call float @llvm.fabs.f32(float undef) #0
  %i4 = fcmp fast ult float %i3, 0x3FEFF7CEE0000000
  br i1 %i4, label %bb5, label %bb6

bb5:
  unreachable

bb6:
  unreachable
}

declare float @llvm.fabs.f32(float) #0

attributes #0 = { nounwind readnone speculatable willreturn }
