; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=aarch64 < %s | FileCheck %s

; Verify the cost of (vector) multiply instructions.

target datalayout = "e-m:e-i8:8:32-i16:16:32-i64:64-i128:128-n32:64-S128"

define <2 x i8> @t1(<2 x i8> %a, <2 x i8> %b)  {
; CHECK-LABEL: 't1'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %1 = mul <2 x i8> %a, %b
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <2 x i8> %1
;
  %1 = mul <2 x i8> %a, %b
  ret <2 x i8> %1
}

define <4 x i8> @t2(<4 x i8> %a, <4 x i8> %b)  {
; CHECK-LABEL: 't2'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %1 = mul <4 x i8> %a, %b
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i8> %1
;
  %1 = mul <4 x i8> %a, %b
  ret <4 x i8> %1
}

define <8 x i8> @t3(<8 x i8> %a, <8 x i8> %b)  {
; CHECK-LABEL: 't3'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %1 = mul <8 x i8> %a, %b
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i8> %1
;
  %1 = mul <8 x i8> %a, %b
  ret <8 x i8> %1
}

define <16 x i8> @t4(<16 x i8> %a, <16 x i8> %b)  {
; CHECK-LABEL: 't4'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %1 = mul <16 x i8> %a, %b
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i8> %1
;
  %1 = mul <16 x i8> %a, %b
  ret <16 x i8> %1
}

define <32 x i8> @t5(<32 x i8> %a, <32 x i8> %b)  {
; CHECK-LABEL: 't5'
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %1 = mul <32 x i8> %a, %b
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i8> %1
;
  %1 = mul <32 x i8> %a, %b
  ret <32 x i8> %1
}

define <2 x i16> @t6(<2 x i16> %a, <2 x i16> %b)  {
; CHECK-LABEL: 't6'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %1 = mul <2 x i16> %a, %b
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <2 x i16> %1
;
  %1 = mul <2 x i16> %a, %b
  ret <2 x i16> %1
}

define <4 x i16> @t7(<4 x i16> %a, <4 x i16> %b)  {
; CHECK-LABEL: 't7'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %1 = mul <4 x i16> %a, %b
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i16> %1
;
  %1 = mul <4 x i16> %a, %b
  ret <4 x i16> %1
}

define <8 x i16> @t8(<8 x i16> %a, <8 x i16> %b)  {
; CHECK-LABEL: 't8'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %1 = mul <8 x i16> %a, %b
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i16> %1
;
  %1 = mul <8 x i16> %a, %b
  ret <8 x i16> %1
}

define <16 x i16> @t9(<16 x i16> %a, <16 x i16> %b)  {
; CHECK-LABEL: 't9'
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %1 = mul <16 x i16> %a, %b
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i16> %1
;
  %1 = mul <16 x i16> %a, %b
  ret <16 x i16> %1
}

define <2 x i32> @t10(<2 x i32> %a, <2 x i32> %b)  {
; CHECK-LABEL: 't10'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %1 = mul <2 x i32> %a, %b
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <2 x i32> %1
;
  %1 = mul <2 x i32> %a, %b
  ret <2 x i32> %1
}

define <4 x i32> @t11(<4 x i32> %a, <4 x i32> %b)  {
; CHECK-LABEL: 't11'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %1 = mul <4 x i32> %a, %b
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i32> %1
;
  %1 = mul <4 x i32> %a, %b
  ret <4 x i32> %1
}

define <8 x i32> @t12(<8 x i32> %a, <8 x i32> %b)  {
; CHECK-LABEL: 't12'
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %1 = mul <8 x i32> %a, %b
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i32> %1
;
  %1 = mul <8 x i32> %a, %b
  ret <8 x i32> %1
}

define <2 x i64> @t13(<2 x i64> %a, <2 x i64> %b)  {
; CHECK-LABEL: 't13'
; CHECK-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:1 Lat:1 SizeLat:1 for: %1 = mul nsw <2 x i64> %a, %b
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <2 x i64> %1
;
  %1 = mul nsw <2 x i64> %a, %b
  ret <2 x i64> %1
}

define <4 x i64> @t14(<4 x i64> %a, <4 x i64> %b)  {
; CHECK-LABEL: 't14'
; CHECK-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:1 Lat:1 SizeLat:1 for: %1 = mul nsw <4 x i64> %a, %b
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i64> %1
;
  %1 = mul nsw <4 x i64> %a, %b
  ret <4 x i64> %1
}
