; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc < %s -mtriple=x86_64-unknown-linux-gnu | FileCheck %s

define i32 @test_scalar(i32 %x) {
; CHECK-LABEL: test_scalar:
; CHECK:       # %bb.0:
; CHECK-NEXT:    # kill: def $edi killed $edi def $rdi
; CHECK-NEXT:    leal (,%rdi,4), %eax
; CHECK-NEXT:    retq
  %mul = mul i32 %x, 3
  %add = add i32 %mul, %x
  ret i32 %add
}

define i32 @test_scalar_commuted(i32 %x) {
; CHECK-LABEL: test_scalar_commuted:
; CHECK:       # %bb.0:
; CHECK-NEXT:    # kill: def $edi killed $edi def $rdi
; CHECK-NEXT:    leal (,%rdi,4), %eax
; CHECK-NEXT:    retq
  %mul = mul i32 %x, 3
  %add = add i32 %x, %mul
  ret i32 %add
}

define <4 x i32> @test_vector(<4 x i32> %x) {
; CHECK-LABEL: test_vector:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pslld $2, %xmm0
; CHECK-NEXT:    retq
  %mul = mul <4 x i32> %x, <i32 3, i32 3, i32 3, i32 3>
  %add = add <4 x i32> %mul, %x
  ret <4 x i32> %add
}

define ptr @test_ptr(ptr %p) {
; CHECK-LABEL: test_ptr:
; CHECK:       # %bb.0:
; CHECK-NEXT:    leaq (,%rdi,4), %rax
; CHECK-NEXT:    retq
  %addr = ptrtoint ptr %p to i64
  %mul = mul i64 %addr, 3
  %res = getelementptr i8, ptr %p, i64 %mul
  ret ptr %res
}

define i32 @test_extra_use(i32 %x, ptr %p) {
; CHECK-LABEL: test_extra_use:
; CHECK:       # %bb.0:
; CHECK-NEXT:    # kill: def $edi killed $edi def $rdi
; CHECK-NEXT:    leal (%rdi,%rdi,2), %eax
; CHECK-NEXT:    movl %eax, (%rsi)
; CHECK-NEXT:    addl %edi, %eax
; CHECK-NEXT:    retq
  %mul = mul i32 %x, 3
  store i32 %mul, ptr %p
  %add = add i32 %mul, %x
  ret i32 %add
}

define i32 @test_different_operand(i32 %x, i32 %y) {
; CHECK-LABEL: test_different_operand:
; CHECK:       # %bb.0:
; CHECK-NEXT:    # kill: def $edi killed $edi def $rdi
; CHECK-NEXT:    leal (%rdi,%rdi,2), %eax
; CHECK-NEXT:    addl %esi, %eax
; CHECK-NEXT:    retq
  %mul = mul i32 %x, 3
  %add = add i32 %mul, %y
  ret i32 %add
}
