/*
 * Copyright (c) 2022 Samsung Electronics Co., Ltd.
 * All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice,
 *   this list of conditions and the following disclaimer.
 *
 * - Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 *
 * - Neither the name of the copyright owner, nor the names of its contributors
 *   may be used to endorse or promote products derived from this software
 *   without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "oapv_def.h"

#define NA 255 //never split
#define NB 14  //not reach in current setting of max AR 1:4
#define NC 15  //not reach in current setting of max AR 1:4

// clang-format off
const u8 oapv_tbl_log2[257] = {
    /* 0, 1 */
    0, 0,
    /* 2, 3 */
    1, 1,
    /* 4 ~ 7 */
    2, 2, 2, 2,
    /* 8 ~ 15 */
    3, 3, 3, 3, 3, 3, 3, 3,
    /* 16 ~ 31 */
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    /* 31 ~ 63 */
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    /* 64 ~ 127 */
    6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
    /* 128 ~ 255 */
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    /* 256 */
    8
};

const s8 oapv_tbl_tm8[8][8] = {
    { 64, 64, 64, 64, 64, 64, 64, 64},
    { 89, 75, 50, 18,-18,-50,-75,-89},
    { 84, 35,-35,-84,-84,-35, 35, 84},
    { 75,-18,-89,-50, 50, 89, 18,-75},
    { 64,-64,-64, 64, 64,-64,-64, 64},
    { 50,-89, 18, 75,-75,-18, 89,-50},
    { 35,-84, 84,-35,-35, 84,-84, 35},
    { 18,-50, 75,-89, 89,-75, 50,-18}
};

const u8 oapv_tbl_dq_scale[6] = {40, 45, 51, 57, 64, 71};

const u8 oapv_tbl_scan[OAPV_BLK_D] = {
    0,    1,    8,    16,   9,    2,    3,   10,
    17,   24,   32,   25,   18,   11,   4,    5,
    12,   19,   26,   33,   40,   48,   41,   34,
    27,   20,   13,   6,    7,    14,   21,   28,
    35,   42,   49,   56,   57,   50,   43,   36,
    29,   22,   15,   23,   30,   37,   44,   51,
    58,   59,   52,   45,   38,   31,   39,   46,
    53,   60,   61,   54,   47,   55,   62,   63
};

const u16 oapve_tbl_vlc_code[100][5][2] = {
    {{0x0001,  1}, {0x0002,  2}, {0x0004,  3}, {0x0008,  4}, {0x0010,  5}},
    {{0x0000,  2}, {0x0003,  2}, {0x0005,  3}, {0x0009,  4}, {0x0011,  5}},
    {{0x0003,  3}, {0x0000,  3}, {0x0006,  3}, {0x000A,  4}, {0x0012,  5}},
    {{0x000A,  5}, {0x0001,  3}, {0x0007,  3}, {0x000B,  4}, {0x0013,  5}},
    {{0x000B,  5}, {0x0006,  4}, {0x0000,  4}, {0x000C,  4}, {0x0014,  5}},
    {{0x0024,  7}, {0x0007,  4}, {0x0001,  4}, {0x000D,  4}, {0x0015,  5}},
    {{0x0025,  7}, {0x0014,  6}, {0x0002,  4}, {0x000E,  4}, {0x0016,  5}},
    {{0x0026,  7}, {0x0015,  6}, {0x0003,  4}, {0x000F,  4}, {0x0017,  5}},
    {{0x0027,  7}, {0x0016,  6}, {0x000C,  5}, {0x0000,  5}, {0x0018,  5}},
    {{0x0088,  9}, {0x0017,  6}, {0x000D,  5}, {0x0001,  5}, {0x0019,  5}},
    {{0x0089,  9}, {0x0048,  8}, {0x000E,  5}, {0x0002,  5}, {0x001A,  5}},
    {{0x008A,  9}, {0x0049,  8}, {0x000F,  5}, {0x0003,  5}, {0x001B,  5}},
    {{0x008B,  9}, {0x004A,  8}, {0x0028,  7}, {0x0004,  5}, {0x001C,  5}},
    {{0x008C,  9}, {0x004B,  8}, {0x0029,  7}, {0x0005,  5}, {0x001D,  5}},
    {{0x008D,  9}, {0x004C,  8}, {0x002A,  7}, {0x0006,  5}, {0x001E,  5}},
    {{0x008E,  9}, {0x004D,  8}, {0x002B,  7}, {0x0007,  5}, {0x001F,  5}},
    {{0x008F,  9}, {0x004E,  8}, {0x002C,  7}, {0x0018,  6}, {0x0000,  6}},
    {{0x0210, 11}, {0x004F,  8}, {0x002D,  7}, {0x0019,  6}, {0x0001,  6}},
    {{0x0211, 11}, {0x0110, 10}, {0x002E,  7}, {0x001A,  6}, {0x0002,  6}},
    {{0x0212, 11}, {0x0111, 10}, {0x002F,  7}, {0x001B,  6}, {0x0003,  6}},
    {{0x0213, 11}, {0x0112, 10}, {0x0090,  9}, {0x001C,  6}, {0x0004,  6}},
    {{0x0214, 11}, {0x0113, 10}, {0x0091,  9}, {0x001D,  6}, {0x0005,  6}},
    {{0x0215, 11}, {0x0114, 10}, {0x0092,  9}, {0x001E,  6}, {0x0006,  6}},
    {{0x0216, 11}, {0x0115, 10}, {0x0093,  9}, {0x001F,  6}, {0x0007,  6}},
    {{0x0217, 11}, {0x0116, 10}, {0x0094,  9}, {0x0050,  8}, {0x0008,  6}},
    {{0x0218, 11}, {0x0117, 10}, {0x0095,  9}, {0x0051,  8}, {0x0009,  6}},
    {{0x0219, 11}, {0x0118, 10}, {0x0096,  9}, {0x0052,  8}, {0x000A,  6}},
    {{0x021A, 11}, {0x0119, 10}, {0x0097,  9}, {0x0053,  8}, {0x000B,  6}},
    {{0x021B, 11}, {0x011A, 10}, {0x0098,  9}, {0x0054,  8}, {0x000C,  6}},
    {{0x021C, 11}, {0x011B, 10}, {0x0099,  9}, {0x0055,  8}, {0x000D,  6}},
    {{0x021D, 11}, {0x011C, 10}, {0x009A,  9}, {0x0056,  8}, {0x000E,  6}},
    {{0x021E, 11}, {0x011D, 10}, {0x009B,  9}, {0x0057,  8}, {0x000F,  6}},
    {{0x021F, 11}, {0x011E, 10}, {0x009C,  9}, {0x0058,  8}, {0x0030,  7}},
    {{0x0820, 13}, {0x011F, 10}, {0x009D,  9}, {0x0059,  8}, {0x0031,  7}},
    {{0x0821, 13}, {0x0420, 12}, {0x009E,  9}, {0x005A,  8}, {0x0032,  7}},
    {{0x0822, 13}, {0x0421, 12}, {0x009F,  9}, {0x005B,  8}, {0x0033,  7}},
    {{0x0823, 13}, {0x0422, 12}, {0x0220, 11}, {0x005C,  8}, {0x0034,  7}},
    {{0x0824, 13}, {0x0423, 12}, {0x0221, 11}, {0x005D,  8}, {0x0035,  7}},
    {{0x0825, 13}, {0x0424, 12}, {0x0222, 11}, {0x005E,  8}, {0x0036,  7}},
    {{0x0826, 13}, {0x0425, 12}, {0x0223, 11}, {0x005F,  8}, {0x0037,  7}},
    {{0x0827, 13}, {0x0426, 12}, {0x0224, 11}, {0x0120, 10}, {0x0038,  7}},
    {{0x0828, 13}, {0x0427, 12}, {0x0225, 11}, {0x0121, 10}, {0x0039,  7}},
    {{0x0829, 13}, {0x0428, 12}, {0x0226, 11}, {0x0122, 10}, {0x003A,  7}},
    {{0x082A, 13}, {0x0429, 12}, {0x0227, 11}, {0x0123, 10}, {0x003B,  7}},
    {{0x082B, 13}, {0x042A, 12}, {0x0228, 11}, {0x0124, 10}, {0x003C,  7}},
    {{0x082C, 13}, {0x042B, 12}, {0x0229, 11}, {0x0125, 10}, {0x003D,  7}},
    {{0x082D, 13}, {0x042C, 12}, {0x022A, 11}, {0x0126, 10}, {0x003E,  7}},
    {{0x082E, 13}, {0x042D, 12}, {0x022B, 11}, {0x0127, 10}, {0x003F,  7}},
    {{0x082F, 13}, {0x042E, 12}, {0x022C, 11}, {0x0128, 10}, {0x00A0,  9}},
    {{0x0830, 13}, {0x042F, 12}, {0x022D, 11}, {0x0129, 10}, {0x00A1,  9}},
    {{0x0831, 13}, {0x0430, 12}, {0x022E, 11}, {0x012A, 10}, {0x00A2,  9}},
    {{0x0832, 13}, {0x0431, 12}, {0x022F, 11}, {0x012B, 10}, {0x00A3,  9}},
    {{0x0833, 13}, {0x0432, 12}, {0x0230, 11}, {0x012C, 10}, {0x00A4,  9}},
    {{0x0834, 13}, {0x0433, 12}, {0x0231, 11}, {0x012D, 10}, {0x00A5,  9}},
    {{0x0835, 13}, {0x0434, 12}, {0x0232, 11}, {0x012E, 10}, {0x00A6,  9}},
    {{0x0836, 13}, {0x0435, 12}, {0x0233, 11}, {0x012F, 10}, {0x00A7,  9}},
    {{0x0837, 13}, {0x0436, 12}, {0x0234, 11}, {0x0130, 10}, {0x00A8,  9}},
    {{0x0838, 13}, {0x0437, 12}, {0x0235, 11}, {0x0131, 10}, {0x00A9,  9}},
    {{0x0839, 13}, {0x0438, 12}, {0x0236, 11}, {0x0132, 10}, {0x00AA,  9}},
    {{0x083A, 13}, {0x0439, 12}, {0x0237, 11}, {0x0133, 10}, {0x00AB,  9}},
    {{0x083B, 13}, {0x043A, 12}, {0x0238, 11}, {0x0134, 10}, {0x00AC,  9}},
    {{0x083C, 13}, {0x043B, 12}, {0x0239, 11}, {0x0135, 10}, {0x00AD,  9}},
    {{0x083D, 13}, {0x043C, 12}, {0x023A, 11}, {0x0136, 10}, {0x00AE,  9}},
    {{0x083E, 13}, {0x043D, 12}, {0x023B, 11}, {0x0137, 10}, {0x00AF,  9}},
    {{0x083F, 13}, {0x043E, 12}, {0x023C, 11}, {0x0138, 10}, {0x00B0,  9}},
    {{0x2040, 15}, {0x043F, 12}, {0x023D, 11}, {0x0139, 10}, {0x00B1,  9}},
    {{0x2041, 15}, {0x1040, 14}, {0x023E, 11}, {0x013A, 10}, {0x00B2,  9}},
    {{0x2042, 15}, {0x1041, 14}, {0x023F, 11}, {0x013B, 10}, {0x00B3,  9}},
    {{0x2043, 15}, {0x1042, 14}, {0x0840, 13}, {0x013C, 10}, {0x00B4,  9}},
    {{0x2044, 15}, {0x1043, 14}, {0x0841, 13}, {0x013D, 10}, {0x00B5,  9}},
    {{0x2045, 15}, {0x1044, 14}, {0x0842, 13}, {0x013E, 10}, {0x00B6,  9}},
    {{0x2046, 15}, {0x1045, 14}, {0x0843, 13}, {0x013F, 10}, {0x00B7,  9}},
    {{0x2047, 15}, {0x1046, 14}, {0x0844, 13}, {0x0440, 12}, {0x00B8,  9}},
    {{0x2048, 15}, {0x1047, 14}, {0x0845, 13}, {0x0441, 12}, {0x00B9,  9}},
    {{0x2049, 15}, {0x1048, 14}, {0x0846, 13}, {0x0442, 12}, {0x00BA,  9}},
    {{0x204A, 15}, {0x1049, 14}, {0x0847, 13}, {0x0443, 12}, {0x00BB,  9}},
    {{0x204B, 15}, {0x104A, 14}, {0x0848, 13}, {0x0444, 12}, {0x00BC,  9}},
    {{0x204C, 15}, {0x104B, 14}, {0x0849, 13}, {0x0445, 12}, {0x00BD,  9}},
    {{0x204D, 15}, {0x104C, 14}, {0x084A, 13}, {0x0446, 12}, {0x00BE,  9}},
    {{0x204E, 15}, {0x104D, 14}, {0x084B, 13}, {0x0447, 12}, {0x00BF,  9}},
    {{0x204F, 15}, {0x104E, 14}, {0x084C, 13}, {0x0448, 12}, {0x0240, 11}},
    {{0x2050, 15}, {0x104F, 14}, {0x084D, 13}, {0x0449, 12}, {0x0241, 11}},
    {{0x2051, 15}, {0x1050, 14}, {0x084E, 13}, {0x044A, 12}, {0x0242, 11}},
    {{0x2052, 15}, {0x1051, 14}, {0x084F, 13}, {0x044B, 12}, {0x0243, 11}},
    {{0x2053, 15}, {0x1052, 14}, {0x0850, 13}, {0x044C, 12}, {0x0244, 11}},
    {{0x2054, 15}, {0x1053, 14}, {0x0851, 13}, {0x044D, 12}, {0x0245, 11}},
    {{0x2055, 15}, {0x1054, 14}, {0x0852, 13}, {0x044E, 12}, {0x0246, 11}},
    {{0x2056, 15}, {0x1055, 14}, {0x0853, 13}, {0x044F, 12}, {0x0247, 11}},
    {{0x2057, 15}, {0x1056, 14}, {0x0854, 13}, {0x0450, 12}, {0x0248, 11}},
    {{0x2058, 15}, {0x1057, 14}, {0x0855, 13}, {0x0451, 12}, {0x0249, 11}},
    {{0x2059, 15}, {0x1058, 14}, {0x0856, 13}, {0x0452, 12}, {0x024A, 11}},
    {{0x205A, 15}, {0x1059, 14}, {0x0857, 13}, {0x0453, 12}, {0x024B, 11}},
    {{0x205B, 15}, {0x105A, 14}, {0x0858, 13}, {0x0454, 12}, {0x024C, 11}},
    {{0x205C, 15}, {0x105B, 14}, {0x0859, 13}, {0x0455, 12}, {0x024D, 11}},
    {{0x205D, 15}, {0x105C, 14}, {0x085A, 13}, {0x0456, 12}, {0x024E, 11}},
    {{0x205E, 15}, {0x105D, 14}, {0x085B, 13}, {0x0457, 12}, {0x024F, 11}},
    {{0x205F, 15}, {0x105E, 14}, {0x085C, 13}, {0x0458, 12}, {0x0250, 11}},
    {{0x2060, 15}, {0x105F, 14}, {0x085D, 13}, {0x0459, 12}, {0x0251, 11}},
    {{0x2061, 15}, {0x1060, 14}, {0x085E, 13}, {0x045A, 12}, {0x0252, 11}},
    {{0x2062, 15}, {0x1061, 14}, {0x085F, 13}, {0x045B, 12}, {0x0253, 11}}
};

s16 oapv_itrans_diff[64][64] = {
     {
          16019, 16019, 16019, 16019, 16748, 16748, 16748, 16748, 
          16019, 16019, 16019, 16019, 16748, 16748, 16748, 16748, 
          16748, 16748, 16748, 16748, 16748, 16748, 16748, 16748, 
          16748, 16748, 16748, 16748, 16748, 16748, 16748, 16748, 
          16019, 16019, 16019, 16019, 16019, 16019, 16019, 16019, 
          16019, 16019, 16019, 16019, 16019, 16019, 16019, 16019, 
          16019, 16019, 16019, 16019, 16748, 16748, 16748, 16748, 
          16019, 16019, 16019, 16019, 16748, 16748, 16748, 16748
     },
     {
          23290, 19626, 13084, 4710, 22277, 18773, 12515, 4505, 
          -4710, -13084, -19626, -23290, -4505, -12515, -18773, -22277, 
          23290, 19626, 13084, 4710, 23290, 19626, 13084, 4710, 
          -4710, -13084, -19626, -23290, -4710, -13084, -19626, -23290, 
          22277, 18773, 12515, 4505, 22277, 18773, 12515, 4505, 
          -4505, -12515, -18773, -22277, -4505, -12515, -18773, -22277, 
          22277, 18773, 12515, 4505, 22277, 18773, 12515, 4505, 
          -4505, -12515, -18773, -22277, -4505, -12515, -18773, -22277
     },
     {
          22573, 22573, 22573, 22573, 19660, 19660, 19660, 19660, 
          22573, 22573, 22573, 22573, 19660, 19660, 19660, 19660, 
          13107, 13107, 13107, 13107, 5097, 5097, 5097, 5097, 
          13107, 13107, 13107, 13107, 5097, 5097, 5097, 5097, 
          -5097, -5097, -5097, -5097, -13107, -13107, -13107, -13107, 
          -5097, -5097, -5097, -5097, -13107, -13107, -13107, -13107, 
          -19660, -19660, -19660, -19660, -22573, -22573, -22573, -22573, 
          -19660, -19660, -19660, -19660, -22573, -22573, -22573, -22573
     },
     {
          21117, 21117, 21117, 21117, 9466, 9466, 9466, 9466, 
          21117, 21117, 21117, 21117, 9466, 9466, 9466, 9466, 
          -8738, -8738, -8738, -8738, -21117, -21117, -21117, -21117, 
          -8738, -8738, -8738, -8738, -21117, -21117, -21117, -21117, 
          -21845, -21845, -21845, -21845, -9466, -9466, -9466, -9466, 
          -21845, -21845, -21845, -21845, -9466, -9466, -9466, -9466, 
          8738, 8738, 8738, 8738, 21845, 21845, 21845, 21845, 
          8738, 8738, 8738, 8738, 21845, 21845, 21845, 21845
     },
     {
          32403, 27306, 18204, 6553, 26328, 22186, 14791, 5324, 
          -6553, -18204, -27306, -32403, -5324, -14791, -22186, -26328, 
          18227, 15360, 10240, 3686, 6075, 5120, 3413, 1228, 
          -3686, -10240, -15360, -18227, -1228, -3413, -5120, -6075, 
          -6075, -5120, -3413, -1228, -18227, -15360, -10240, -3686, 
          1228, 3413, 5120, 6075, 3686, 10240, 15360, 18227, 
          -26328, -22186, -14791, -5324, -32403, -27306, -18204, -6553, 
          5324, 14791, 22186, 26328, 6553, 18204, 27306, 32403
     },
     {
          21981, 9159, -9159, -21981, 21026, 8760, -8760, -21026, 
          -21981, -9159, 9159, 21981, -21026, -8760, 8760, 21026, 
          21026, 8760, -8760, -21026, 21026, 8760, -8760, -21026, 
          -21026, -8760, 8760, 21026, -21026, -8760, 8760, 21026, 
          21026, 8760, -8760, -21026, 21981, 9159, -9159, -21981, 
          -21026, -8760, 8760, 21026, -21981, -9159, 9159, 21981, 
          21981, 9159, -9159, -21981, 21981, 9159, -9159, -21981, 
          -21981, -9159, 9159, 21981, -21981, -9159, 9159, 21981
     },
     {
          18773, -4505, -22277, -12515, 18773, -4505, -22277, -12515, 
          12515, 22277, 4505, -18773, 12515, 22277, 4505, -18773, 
          19626, -4710, -23290, -13084, 18773, -4505, -22277, -12515, 
          13084, 23290, 4710, -19626, 12515, 22277, 4505, -18773, 
          18773, -4505, -22277, -12515, 19626, -4710, -23290, -13084, 
          12515, 22277, 4505, -18773, 13084, 23290, 4710, -19626, 
          18773, -4505, -22277, -12515, 19626, -4710, -23290, -13084, 
          12515, 22277, 4505, -18773, 13084, 23290, 4710, -19626
     },
     {
          30583, 12743, -12743, -30583, 24849, 10353, -10353, -24849, 
          -30583, -12743, 12743, 30583, -24849, -10353, 10353, 24849, 
          16247, 6769, -6769, -16247, 5734, 2389, -2389, -5734, 
          -16247, -6769, 6769, 16247, -5734, -2389, 2389, 5734, 
          -6690, -2787, 2787, 6690, -16247, -6769, 6769, 16247, 
          6690, 2787, -2787, -6690, 16247, 6769, -6769, -16247, 
          -24849, -10353, 10353, 24849, -29627, -12344, 12344, 29627, 
          24849, 10353, -10353, -24849, 29627, 12344, -12344, -29627
     },
     {
          30378, 25600, 17066, 6144, 12151, 10240, 6826, 2457, 
          -6144, -17066, -25600, -30378, -2457, -6826, -10240, -12151, 
          -12151, -10240, -6826, -2457, -29366, -24746, -16497, -5939, 
          2457, 6826, 10240, 12151, 5939, 16497, 24746, 29366, 
          -30378, -25600, -17066, -6144, -13164, -11093, -7395, -2662, 
          6144, 17066, 25600, 30378, 2662, 7395, 11093, 13164, 
          12151, 10240, 6826, 2457, 29366, 24746, 16497, 5939, 
          -2457, -6826, -10240, -12151, -5939, -16497, -24746, -29366
     },
     {
          18932, 18932, 18932, 18932, -4369, -4369, -4369, -4369, 
          18932, 18932, 18932, 18932, -4369, -4369, -4369, -4369, 
          -22573, -22573, -22573, -22573, -12379, -12379, -12379, -12379, 
          -22573, -22573, -22573, -22573, -12379, -12379, -12379, -12379, 
          12379, 12379, 12379, 12379, 22573, 22573, 22573, 22573, 
          12379, 12379, 12379, 12379, 22573, 22573, 22573, 22573, 
          4369, 4369, 4369, 4369, -18932, -18932, -18932, -18932, 
          4369, 4369, 4369, 4369, -18932, -18932, -18932, -18932
     },
     {
          16019, 16019, 16019, 16019, -16019, -16019, -16019, -16019, 
          16019, 16019, 16019, 16019, -16019, -16019, -16019, -16019, 
          -16019, -16019, -16019, -16019, 16748, 16748, 16748, 16748, 
          -16019, -16019, -16019, -16019, 16748, 16748, 16748, 16748, 
          16019, 16019, 16019, 16019, -16748, -16748, -16748, -16748, 
          16019, 16019, 16019, 16019, -16748, -16748, -16748, -16748, 
          -16748, -16748, -16748, -16748, 16748, 16748, 16748, 16748, 
          -16748, -16748, -16748, -16748, 16748, 16748, 16748, 16748
     },
     {
          27340, 23040, 15360, 5529, -6075, -5120, -3413, -1228, 
          -5529, -15360, -23040, -27340, 1228, 3413, 5120, 6075, 
          -31391, -26453, -17635, -6348, -17214, -14506, -9671, -3481, 
          6348, 17635, 26453, 31391, 3481, 9671, 14506, 17214, 
          17214, 14506, 9671, 3481, 31391, 26453, 17635, 6348, 
          -3481, -9671, -14506, -17214, -6348, -17635, -26453, -31391, 
          6075, 5120, 3413, 1228, -27340, -23040, -15360, -5529, 
          -1228, -3413, -5120, -6075, 5529, 15360, 23040, 27340
     },
     {
          28672, 11946, -11946, -28672, 11468, 4778, -4778, -11468, 
          -28672, -11946, 11946, 28672, -11468, -4778, 4778, 11468, 
          -12424, -5176, 5176, 12424, -28672, -11946, 11946, 28672, 
          12424, 5176, -5176, -12424, 28672, 11946, -11946, -28672, 
          -28672, -11946, 11946, 28672, -11468, -4778, 4778, 11468, 
          28672, 11946, -11946, -28672, 11468, 4778, -4778, -11468, 
          12424, 5176, -5176, -12424, 28672, 11946, -11946, -28672, 
          -12424, -5176, 5176, 12424, -28672, -11946, 11946, 28672
     },
     {
          26453, -6348, -31391, -17635, 22186, -5324, -26328, -14791, 
          17635, 31391, 6348, -26453, 14791, 26328, 5324, -22186, 
          15360, -3686, -18227, -10240, 5120, -1228, -6075, -3413, 
          10240, 18227, 3686, -15360, 3413, 6075, 1228, -5120, 
          -5973, 1433, 7088, 3982, -14506, 3481, 17214, 9671, 
          -3982, -7088, -1433, 5973, -9671, -17214, -3481, 14506, 
          -23040, 5529, 27340, 15360, -26453, 6348, 31391, 17635, 
          -15360, -27340, -5529, 23040, -17635, -31391, -6348, 26453
     },
     {
          16748, -16748, -16748, 16748, 16019, -16019, -16019, 16019, 
          16748, -16748, -16748, 16748, 16019, -16019, -16019, 16019, 
          16019, -16019, -16019, 16019, 16748, -16748, -16748, 16748, 
          16019, -16019, -16019, 16019, 16748, -16748, -16748, 16748, 
          16748, -16748, -16748, 16748, 16748, -16748, -16748, 16748, 
          16748, -16748, -16748, 16748, 16748, -16748, -16748, 16748, 
          16748, -16748, -16748, 16748, 16748, -16748, -16748, 16748, 
          16748, -16748, -16748, 16748, 16748, -16748, -16748, 16748
     },
     {
          12515, -22277, 4505, 18773, 13084, -23290, 4710, 19626, 
          -18773, -4505, 22277, -12515, -19626, -4710, 23290, -13084, 
          13084, -23290, 4710, 19626, 12515, -22277, 4505, 18773, 
          -19626, -4710, 23290, -13084, -18773, -4505, 22277, -12515, 
          13084, -23290, 4710, 19626, 12515, -22277, 4505, 18773, 
          -19626, -4710, 23290, -13084, -18773, -4505, 22277, -12515, 
          12515, -22277, 4505, 18773, 13084, -23290, 4710, 19626, 
          -18773, -4505, 22277, -12515, -19626, -4710, 23290, -13084
     },
     {
          23301, -23301, -23301, 23301, 18932, -18932, -18932, 18932, 
          23301, -23301, -23301, 23301, 18932, -18932, -18932, 18932, 
          12379, -12379, -12379, 12379, 4369, -4369, -4369, 4369, 
          12379, -12379, -12379, 12379, 4369, -4369, -4369, 4369, 
          -4369, 4369, 4369, -4369, -12379, 12379, 12379, -12379, 
          -4369, 4369, 4369, -4369, -12379, 12379, 12379, -12379, 
          -18932, 18932, 18932, -18932, -22573, 22573, 22573, -22573, 
          -18932, 18932, 18932, -18932, -22573, 22573, 22573, -22573
     },
     {
          24746, -5939, -29366, -16497, 10240, -2457, -12151, -6826, 
          16497, 29366, 5939, -24746, 6826, 12151, 2457, -10240, 
          -10240, 2457, 12151, 6826, -25600, 6144, 30378, 17066, 
          -6826, -12151, -2457, 10240, -17066, -30378, -6144, 25600, 
          -25600, 6144, 30378, 17066, -10240, 2457, 12151, 6826, 
          -17066, -30378, -6144, 25600, -6826, -12151, -2457, 10240, 
          10240, -2457, -12151, -6826, 25600, -6144, -30378, -17066, 
          6826, 12151, 2457, -10240, 17066, 30378, 6144, -25600
     },
     {
          25804, 10752, -10752, -25804, -5734, -2389, 2389, 5734, 
          -25804, -10752, 10752, 25804, 5734, 2389, -2389, -5734, 
          -30583, -12743, 12743, 30583, -17203, -7168, 7168, 17203, 
          30583, 12743, -12743, -30583, 17203, 7168, -7168, -17203, 
          16247, 6769, -6769, -16247, 29627, 12344, -12344, -29627, 
          -16247, -6769, 6769, 16247, -29627, -12344, 12344, 29627, 
          6690, 2787, -2787, -6690, -24849, -10353, 10353, 24849, 
          -6690, -2787, 2787, 6690, 24849, 10353, -10353, -24849
     },
     {
          23290, 19626, 13084, 4710, -23290, -19626, -13084, -4710, 
          -4710, -13084, -19626, -23290, 4710, 13084, 19626, 23290, 
          -22277, -18773, -12515, -4505, 23290, 19626, 13084, 4710, 
          4505, 12515, 18773, 22277, -4710, -13084, -19626, -23290, 
          22277, 18773, 12515, 4505, -23290, -19626, -13084, -4710, 
          -4505, -12515, -18773, -22277, 4710, 13084, 19626, 23290, 
          -23290, -19626, -13084, -4710, 22277, 18773, 12515, 4505, 
          4710, 13084, 19626, 23290, -4505, -12515, -18773, -22277
     },
     {
          12379, 12379, 12379, 12379, -22573, -22573, -22573, -22573, 
          12379, 12379, 12379, 12379, -22573, -22573, -22573, -22573, 
          5097, 5097, 5097, 5097, 19660, 19660, 19660, 19660, 
          5097, 5097, 5097, 5097, 19660, 19660, 19660, 19660, 
          -19660, -19660, -19660, -19660, -5097, -5097, -5097, -5097, 
          -19660, -19660, -19660, -19660, -5097, -5097, -5097, -5097, 
          22573, 22573, 22573, 22573, -12379, -12379, -12379, -12379, 
          22573, 22573, 22573, 22573, -12379, -12379, -12379, -12379
     },
     {
          8738, 8738, 8738, 8738, -21117, -21117, -21117, -21117, 
          8738, 8738, 8738, 8738, -21117, -21117, -21117, -21117, 
          21845, 21845, 21845, 21845, -8738, -8738, -8738, -8738, 
          21845, 21845, 21845, 21845, -8738, -8738, -8738, -8738, 
          -9466, -9466, -9466, -9466, 21117, 21117, 21117, 21117, 
          -9466, -9466, -9466, -9466, 21117, 21117, 21117, 21117, 
          -21845, -21845, -21845, -21845, 9466, 9466, 9466, 9466, 
          -21845, -21845, -21845, -21845, 9466, 9466, 9466, 9466
     },
     {
          18227, 15360, 10240, 3686, -31391, -26453, -17635, -6348, 
          -3686, -10240, -15360, -18227, 6348, 17635, 26453, 31391, 
          7088, 5973, 3982, 1433, 26328, 22186, 14791, 5324, 
          -1433, -3982, -5973, -7088, -5324, -14791, -22186, -26328, 
          -26328, -22186, -14791, -5324, -7088, -5973, -3982, -1433, 
          5324, 14791, 22186, 26328, 1433, 3982, 5973, 7088, 
          31391, 26453, 17635, 6348, -18227, -15360, -10240, -3686, 
          -6348, -17635, -26453, -31391, 3686, 10240, 15360, 18227
     },
     {
          21981, 9159, -9159, -21981, -21981, -9159, 9159, 21981, 
          -21981, -9159, 9159, 21981, 21981, 9159, -9159, -21981, 
          -21981, -9159, 9159, 21981, 21026, 8760, -8760, -21026, 
          21981, 9159, -9159, -21981, -21026, -8760, 8760, 21026, 
          21026, 8760, -8760, -21026, -21026, -8760, 8760, 21026, 
          -21026, -8760, 8760, 21026, 21026, 8760, -8760, -21026, 
          -21026, -8760, 8760, 21026, 21981, 9159, -9159, -21981, 
          21026, 8760, -8760, -21026, -21981, -9159, 9159, 21981
     },
     {
          22186, -5324, -26328, -14791, -5120, 1228, 6075, 3413, 
          14791, 26328, 5324, -22186, -3413, -6075, -1228, 5120, 
          -26453, 6348, 31391, 17635, -15360, 3686, 18227, 10240, 
          -17635, -31391, -6348, 26453, -10240, -18227, -3686, 15360, 
          14506, -3481, -17214, -9671, 27306, -6553, -32403, -18204, 
          9671, 17214, 3481, -14506, 18204, 32403, 6553, -27306, 
          5120, -1228, -6075, -3413, -22186, 5324, 26328, 14791, 
          3413, 6075, 1228, -5120, -14791, -26328, -5324, 22186
     },
     {
          21845, -21845, -21845, 21845, 8738, -8738, -8738, 8738, 
          21845, -21845, -21845, 21845, 8738, -8738, -8738, 8738, 
          -9466, 9466, 9466, -9466, -21117, 21117, 21117, -21117, 
          -9466, 9466, 9466, -9466, -21117, 21117, 21117, -21117, 
          -21117, 21117, 21117, -21117, -8738, 8738, 8738, -8738, 
          -21117, 21117, 21117, -21117, -8738, 8738, 8738, -8738, 
          9466, -9466, -9466, 9466, 21845, -21845, -21845, 21845, 
          9466, -9466, -9466, 9466, 21845, -21845, -21845, 21845
     },
     {
          17635, -31391, 6348, 26453, 15360, -27340, 5529, 23040, 
          -26453, -6348, 31391, -17635, -23040, -5529, 27340, -15360, 
          10240, -18227, 3686, 15360, 3413, -6075, 1228, 5120, 
          -15360, -3686, 18227, -10240, -5120, -1228, 6075, -3413, 
          -3413, 6075, -1228, -5120, -10240, 18227, -3686, -15360, 
          5120, 1228, -6075, 3413, 15360, 3686, -18227, 10240, 
          -15360, 27340, -5529, -23040, -17635, 31391, -6348, -26453, 
          23040, 5529, -27340, 15360, 26453, 6348, -31391, 17635
     },
     {
          8760, -21026, 21026, -8760, 9159, -21981, 21981, -9159, 
          -8760, 21026, -21026, 8760, -9159, 21981, -21981, 9159, 
          8760, -21026, 21026, -8760, 8760, -21026, 21026, -8760, 
          -8760, 21026, -21026, 8760, -8760, 21026, -21026, 8760, 
          8760, -21026, 21026, -8760, 8760, -21026, 21026, -8760, 
          -8760, 21026, -21026, 8760, -8760, 21026, -21026, 8760, 
          9159, -21981, 21981, -9159, 9159, -21981, 21981, -9159, 
          -9159, 21981, -21981, 9159, -9159, 21981, -21981, 9159
     },
     {
          4505, -12515, 18773, -22277, 4710, -13084, 19626, -23290, 
          22277, -18773, 12515, -4505, 23290, -19626, 13084, -4710, 
          4505, -12515, 18773, -22277, 4505, -12515, 18773, -22277, 
          22277, -18773, 12515, -4505, 22277, -18773, 12515, -4505, 
          4710, -13084, 19626, -23290, 4710, -13084, 19626, -23290, 
          23290, -19626, 13084, -4710, 23290, -19626, 13084, -4710, 
          4505, -12515, 18773, -22277, 4710, -13084, 19626, -23290, 
          22277, -18773, 12515, -4505, 23290, -19626, 13084, -4710
     },
     {
          12344, -29627, 29627, -12344, 10752, -25804, 25804, -10752, 
          -12344, 29627, -29627, 12344, -10752, 25804, -25804, 10752, 
          6769, -16247, 16247, -6769, 2389, -5734, 5734, -2389, 
          -6769, 16247, -16247, 6769, -2389, 5734, -5734, 2389, 
          -2389, 5734, -5734, 2389, -7168, 17203, -17203, 7168, 
          2389, -5734, 5734, -2389, 7168, -17203, 17203, -7168, 
          -10353, 24849, -24849, 10353, -12344, 29627, -29627, 12344, 
          10353, -24849, 24849, -10353, 12344, -29627, 29627, -12344
     },
     {
          16497, -29366, 5939, 24746, 7395, -13164, 2662, 11093, 
          -24746, -5939, 29366, -16497, -11093, -2662, 13164, -7395, 
          -6826, 12151, -2457, -10240, -17066, 30378, -6144, -25600, 
          10240, 2457, -12151, 6826, 25600, 6144, -30378, 17066, 
          -16497, 29366, -5939, -24746, -7395, 13164, -2662, -11093, 
          24746, 5939, -29366, 16497, 11093, 2662, -13164, 7395, 
          6826, -12151, 2457, 10240, 17066, -30378, 6144, 25600, 
          -10240, -2457, 12151, -6826, -25600, -6144, 30378, -17066
     },
     {
          19660, -19660, -19660, 19660, -5097, 5097, 5097, -5097, 
          19660, -19660, -19660, 19660, -5097, 5097, 5097, -5097, 
          -23301, 23301, 23301, -23301, -12379, 12379, 12379, -12379, 
          -23301, 23301, 23301, -23301, -12379, 12379, 12379, -12379, 
          13107, -13107, -13107, 13107, 23301, -23301, -23301, 23301, 
          13107, -13107, -13107, 13107, 23301, -23301, -23301, 23301, 
          5097, -5097, -5097, 5097, -18932, 18932, 18932, -18932, 
          5097, -5097, -5097, 5097, -18932, 18932, 18932, -18932
     },
     {
          18773, -4505, -22277, -12515, -19626, 4710, 23290, 13084, 
          12515, 22277, 4505, -18773, -13084, -23290, -4710, 19626, 
          -18773, 4505, 22277, 12515, 18773, -4505, -22277, -12515, 
          -12515, -22277, -4505, 18773, 12515, 22277, 4505, -18773, 
          18773, -4505, -22277, -12515, -18773, 4505, 22277, 12515, 
          12515, 22277, 4505, -18773, -12515, -22277, -4505, 18773, 
          -19626, 4710, 23290, 13084, 19626, -4710, -23290, -13084, 
          -13084, -23290, -4710, 19626, 13084, 23290, 4710, -19626
     },
     {
          17203, 7168, -7168, -17203, -29627, -12344, 12344, 29627, 
          -17203, -7168, 7168, 17203, 29627, 12344, -12344, -29627, 
          5734, 2389, -2389, -5734, 24849, 10353, -10353, -24849, 
          -5734, -2389, 2389, 5734, -24849, -10353, 10353, 24849, 
          -25804, -10752, 10752, 25804, -5734, -2389, 2389, 5734, 
          25804, 10752, -10752, -25804, 5734, 2389, -2389, -5734, 
          29627, 12344, -12344, -29627, -17203, -7168, 7168, 17203, 
          -29627, -12344, 12344, 29627, 17203, 7168, -7168, -17203
     },
     {
          13164, 11093, 7395, 2662, -30378, -25600, -17066, -6144, 
          -2662, -7395, -11093, -13164, 6144, 17066, 25600, 30378, 
          30378, 25600, 17066, 6144, -12151, -10240, -6826, -2457, 
          -6144, -17066, -25600, -30378, 2457, 6826, 10240, 12151, 
          -12151, -10240, -6826, -2457, 29366, 24746, 16497, 5939, 
          2457, 6826, 10240, 12151, -5939, -16497, -24746, -29366, 
          -30378, -25600, -17066, -6144, 12151, 10240, 6826, 2457, 
          6144, 17066, 25600, 30378, -2457, -6826, -10240, -12151
     },
     {
          4369, 4369, 4369, 4369, -12379, -12379, -12379, -12379, 
          4369, 4369, 4369, 4369, -12379, -12379, -12379, -12379, 
          19660, 19660, 19660, 19660, -22573, -22573, -22573, -22573, 
          19660, 19660, 19660, 19660, -22573, -22573, -22573, -22573, 
          22573, 22573, 22573, 22573, -19660, -19660, -19660, -19660, 
          22573, 22573, 22573, 22573, -19660, -19660, -19660, -19660, 
          12379, 12379, 12379, 12379, -4369, -4369, -4369, -4369, 
          12379, 12379, 12379, 12379, -4369, -4369, -4369, -4369
     },
     {
          7088, 5973, 3982, 1433, -18227, -15360, -10240, -3686, 
          -1433, -3982, -5973, -7088, 3686, 10240, 15360, 18227, 
          27340, 23040, 15360, 5529, -31391, -26453, -17635, -6348, 
          -5529, -15360, -23040, -27340, 6348, 17635, 26453, 31391, 
          31391, 26453, 17635, 6348, -27340, -23040, -15360, -5529, 
          -6348, -17635, -26453, -31391, 5529, 15360, 23040, 27340, 
          18227, 15360, 10240, 3686, -7088, -5973, -3982, -1433, 
          -3686, -10240, -15360, -18227, 1433, 3982, 5973, 7088
     },
     {
          12424, 5176, -5176, -12424, -28672, -11946, 11946, 28672, 
          -12424, -5176, 5176, 12424, 28672, 11946, -11946, -28672, 
          27716, 11548, -11548, -27716, -11468, -4778, 4778, 11468, 
          -27716, -11548, 11548, 27716, 11468, 4778, -4778, -11468, 
          -12424, -5176, 5176, 12424, 28672, 11946, -11946, -28672, 
          12424, 5176, -5176, -12424, -28672, -11946, 11946, 28672, 
          -27716, -11548, 11548, 27716, 11468, 4778, -4778, -11468, 
          27716, 11548, -11548, -27716, -11468, -4778, 4778, 11468
     },
     {
          14506, -3481, -17214, -9671, -26453, 6348, 31391, 17635, 
          9671, 17214, 3481, -14506, -17635, -31391, -6348, 26453, 
          5973, -1433, -7088, -3982, 22186, -5324, -26328, -14791, 
          3982, 7088, 1433, -5973, 14791, 26328, 5324, -22186, 
          -23040, 5529, 27340, 15360, -5120, 1228, 6075, 3413, 
          -15360, -27340, -5529, 23040, -3413, -6075, -1228, 5120, 
          26453, -6348, -31391, -17635, -14506, 3481, 17214, 9671, 
          17635, 31391, 6348, -26453, -9671, -17214, -3481, 14506
     },
     {
          16748, -16748, -16748, 16748, -16748, 16748, 16748, -16748, 
          16748, -16748, -16748, 16748, -16748, 16748, 16748, -16748, 
          -16748, 16748, 16748, -16748, 16748, -16748, -16748, 16748, 
          -16748, 16748, 16748, -16748, 16748, -16748, -16748, 16748, 
          16748, -16748, -16748, 16748, -16019, 16019, 16019, -16019, 
          16748, -16748, -16748, 16748, -16019, 16019, 16019, -16019, 
          -16019, 16019, 16019, -16019, 16748, -16748, -16748, 16748, 
          -16019, 16019, 16019, -16019, 16748, -16748, -16748, 16748
     },
     {
          14791, -26328, 5324, 22186, -3413, 6075, -1228, -5120, 
          -22186, -5324, 26328, -14791, 5120, 1228, -6075, 3413, 
          -17635, 31391, -6348, -26453, -10240, 18227, -3686, -15360, 
          26453, 6348, -31391, 17635, 15360, 3686, -18227, 10240, 
          10240, -18227, 3686, 15360, 17635, -31391, 6348, 26453, 
          -15360, -3686, 18227, -10240, -26453, -6348, 31391, -17635, 
          3413, -6075, 1228, 5120, -14791, 26328, -5324, -22186, 
          -5120, -1228, 6075, -3413, 22186, 5324, -26328, 14791
     },
     {
          11548, -27716, 27716, -11548, 5176, -12424, 12424, -5176, 
          -11548, 27716, -27716, 11548, -5176, 12424, -12424, 5176, 
          -5176, 12424, -12424, 5176, -11946, 28672, -28672, 11946, 
          5176, -12424, 12424, -5176, 11946, -28672, 28672, -11946, 
          -11946, 28672, -28672, 11946, -5176, 12424, -12424, 5176, 
          11946, -28672, 28672, -11946, 5176, -12424, 12424, -5176, 
          4778, -11468, 11468, -4778, 11946, -28672, 28672, -11946, 
          -4778, 11468, -11468, 4778, -11946, 28672, -28672, 11946
     },
     {
          6348, -17635, 26453, -31391, 5529, -15360, 23040, -27340, 
          31391, -26453, 17635, -6348, 27340, -23040, 15360, -5529, 
          3481, -9671, 14506, -17214, 1228, -3413, 5120, -6075, 
          17214, -14506, 9671, -3481, 6075, -5120, 3413, -1228, 
          -1228, 3413, -5120, 6075, -3481, 9671, -14506, 17214, 
          -6075, 5120, -3413, 1228, -17214, 14506, -9671, 3481, 
          -5324, 14791, -22186, 26328, -6348, 17635, -26453, 31391, 
          -26328, 22186, -14791, 5324, -31391, 26453, -17635, 6348
     },
     {
          5939, -16497, 24746, -29366, 2662, -7395, 11093, -13164, 
          29366, -24746, 16497, -5939, 13164, -11093, 7395, -2662, 
          -2662, 7395, -11093, 13164, -6144, 17066, -25600, 30378, 
          -13164, 11093, -7395, 2662, -30378, 25600, -17066, 6144, 
          -5939, 16497, -24746, 29366, -2457, 6826, -10240, 12151, 
          -29366, 24746, -16497, 5939, -12151, 10240, -6826, 2457, 
          2457, -6826, 10240, -12151, 6144, -17066, 25600, -30378, 
          12151, -10240, 6826, -2457, 30378, -25600, 17066, -6144
     },
     {
          10353, -24849, 24849, -10353, -2389, 5734, -5734, 2389, 
          -10353, 24849, -24849, 10353, 2389, -5734, 5734, -2389, 
          -12743, 30583, -30583, 12743, -7168, 17203, -17203, 7168, 
          12743, -30583, 30583, -12743, 7168, -17203, 17203, -7168, 
          7168, -17203, 17203, -7168, 12344, -29627, 29627, -12344, 
          -7168, 17203, -17203, 7168, -12344, 29627, -29627, 12344, 
          2389, -5734, 5734, -2389, -10353, 24849, -24849, 10353, 
          -2389, 5734, -5734, 2389, 10353, -24849, 24849, -10353
     },
     {
          12515, -22277, 4505, 18773, -12515, 22277, -4505, -18773, 
          -18773, -4505, 22277, -12515, 18773, 4505, -22277, 12515, 
          -12515, 22277, -4505, -18773, 12515, -22277, 4505, 18773, 
          18773, 4505, -22277, 12515, -18773, -4505, 22277, -12515, 
          13084, -23290, 4710, 19626, -13084, 23290, -4710, -19626, 
          -19626, -4710, 23290, -13084, 19626, 4710, -23290, 13084, 
          -13084, 23290, -4710, -19626, 13084, -23290, 4710, 19626, 
          19626, 4710, -23290, 13084, -19626, -4710, 23290, -13084
     },
     {
          13107, -13107, -13107, 13107, -23301, 23301, 23301, -23301, 
          13107, -13107, -13107, 13107, -23301, 23301, 23301, -23301, 
          4369, -4369, -4369, 4369, 19660, -19660, -19660, 19660, 
          4369, -4369, -4369, 4369, 19660, -19660, -19660, 19660, 
          -18932, 18932, 18932, -18932, -4369, 4369, 4369, -4369, 
          -18932, 18932, 18932, -18932, -4369, 4369, 4369, -4369, 
          23301, -23301, -23301, 23301, -12379, 12379, 12379, -12379, 
          23301, -23301, -23301, 23301, -12379, 12379, 12379, -12379
     },
     {
          10240, -2457, -12151, -6826, -25600, 6144, 30378, 17066, 
          6826, 12151, 2457, -10240, -17066, -30378, -6144, 25600, 
          25600, -6144, -30378, -17066, -11093, 2662, 13164, 7395, 
          17066, 30378, 6144, -25600, -7395, -13164, -2662, 11093, 
          -11093, 2662, 13164, 7395, 25600, -6144, -30378, -17066, 
          -7395, -13164, -2662, 11093, 17066, 30378, 6144, -25600, 
          -25600, 6144, 30378, 17066, 10240, -2457, -12151, -6826, 
          -17066, -30378, -6144, 25600, 6826, 12151, 2457, -10240
     },
     {
          6690, 2787, -2787, -6690, -17203, -7168, 7168, 17203, 
          -6690, -2787, 2787, 6690, 17203, 7168, -7168, -17203, 
          24849, 10353, -10353, -24849, -29627, -12344, 12344, 29627, 
          -24849, -10353, 10353, 24849, 29627, 12344, -12344, -29627, 
          29627, 12344, -12344, -29627, -24849, -10353, 10353, 24849, 
          -29627, -12344, 12344, 29627, 24849, 10353, -10353, -24849, 
          17203, 7168, -7168, -17203, -5734, -2389, 2389, 5734, 
          -17203, -7168, 7168, 17203, 5734, 2389, -2389, -5734
     },
     {
          5120, -1228, -6075, -3413, -15360, 3686, 18227, 10240, 
          3413, 6075, 1228, -5120, -10240, -18227, -3686, 15360, 
          23040, -5529, -27340, -15360, -27306, 6553, 32403, 18204, 
          15360, 27340, 5529, -23040, -18204, -32403, -6553, 27306, 
          26453, -6348, -31391, -17635, -22186, 5324, 26328, 14791, 
          17635, 31391, 6348, -26453, -14791, -26328, -5324, 22186, 
          14506, -3481, -17214, -9671, -5120, 1228, 6075, 3413, 
          9671, 17214, 3481, -14506, -3413, -6075, -1228, 5120
     },
     {
          9466, -9466, -9466, 9466, -21845, 21845, 21845, -21845, 
          9466, -9466, -9466, 9466, -21845, 21845, 21845, -21845, 
          21117, -21117, -21117, 21117, -8738, 8738, 8738, -8738, 
          21117, -21117, -21117, 21117, -8738, 8738, 8738, -8738, 
          -8738, 8738, 8738, -8738, 21845, -21845, -21845, 21845, 
          -8738, 8738, 8738, -8738, 21845, -21845, -21845, 21845, 
          -21117, 21117, 21117, -21117, 9466, -9466, -9466, 9466, 
          -21117, 21117, 21117, -21117, 9466, -9466, -9466, 9466
     },
     {
          9671, -17214, 3481, 14506, -17635, 31391, -6348, -26453, 
          -14506, -3481, 17214, -9671, 26453, 6348, -31391, 17635, 
          3982, -7088, 1433, 5973, 14791, -26328, 5324, 22186, 
          -5973, -1433, 7088, -3982, -22186, -5324, 26328, -14791, 
          -14791, 26328, -5324, -22186, -3982, 7088, -1433, -5973, 
          22186, 5324, -26328, 14791, 5973, 1433, -7088, 3982, 
          17635, -31391, 6348, 26453, -9671, 17214, -3481, -14506, 
          -26453, -6348, 31391, -17635, 14506, 3481, -17214, 9671
     },
     {
          8760, -21026, 21026, -8760, -8760, 21026, -21026, 8760, 
          -8760, 21026, -21026, 8760, 8760, -21026, 21026, -8760, 
          -9159, 21981, -21981, 9159, 8760, -21026, 21026, -8760, 
          9159, -21981, 21981, -9159, -8760, 21026, -21026, 8760, 
          8760, -21026, 21026, -8760, -9159, 21981, -21981, 9159, 
          -8760, 21026, -21026, 8760, 9159, -21981, 21981, -9159, 
          -8760, 21026, -21026, 8760, 9159, -21981, 21981, -9159, 
          8760, -21026, 21026, -8760, -9159, 21981, -21981, 9159
     },
     {
          5324, -14791, 22186, -26328, -1228, 3413, -5120, 6075, 
          26328, -22186, 14791, -5324, -6075, 5120, -3413, 1228, 
          -6553, 18204, -27306, 32403, -3686, 10240, -15360, 18227, 
          -32403, 27306, -18204, 6553, -18227, 15360, -10240, 3686, 
          3686, -10240, 15360, -18227, 6348, -17635, 26453, -31391, 
          18227, -15360, 10240, -3686, 31391, -26453, 17635, -6348, 
          1228, -3413, 5120, -6075, -5324, 14791, -22186, 26328, 
          6075, -5120, 3413, -1228, -26328, 22186, -14791, 5324
     },
     {
          4505, -12515, 18773, -22277, -4505, 12515, -18773, 22277, 
          22277, -18773, 12515, -4505, -22277, 18773, -12515, 4505, 
          -4710, 13084, -19626, 23290, 4505, -12515, 18773, -22277, 
          -23290, 19626, -13084, 4710, 22277, -18773, 12515, -4505, 
          4710, -13084, 19626, -23290, -4505, 12515, -18773, 22277, 
          23290, -19626, 13084, -4710, -22277, 18773, -12515, 4505, 
          -4710, 13084, -19626, 23290, 4710, -13084, 19626, -23290, 
          -23290, 19626, -13084, 4710, 23290, -19626, 13084, -4710
     },
     {
          6769, -16247, 16247, -6769, -12344, 29627, -29627, 12344, 
          -6769, 16247, -16247, 6769, 12344, -29627, 29627, -12344, 
          2389, -5734, 5734, -2389, 10353, -24849, 24849, -10353, 
          -2389, 5734, -5734, 2389, -10353, 24849, -24849, 10353, 
          -10353, 24849, -24849, 10353, -2787, 6690, -6690, 2787, 
          10353, -24849, 24849, -10353, 2787, -6690, 6690, -2787, 
          12344, -29627, 29627, -12344, -6769, 16247, -16247, 6769, 
          -12344, 29627, -29627, 12344, 6769, -16247, 16247, -6769
     },
     {
          6826, -12151, 2457, 10240, -16497, 29366, -5939, -24746, 
          -10240, -2457, 12151, -6826, 24746, 5939, -29366, 16497, 
          17066, -30378, 6144, 25600, -7395, 13164, -2662, -11093, 
          -25600, -6144, 30378, -17066, 11093, 2662, -13164, 7395, 
          -6826, 12151, -2457, -10240, 16497, -29366, 5939, 24746, 
          10240, 2457, -12151, 6826, -24746, -5939, 29366, -16497, 
          -17066, 30378, -6144, -25600, 6826, -12151, 2457, 10240, 
          25600, 6144, -30378, 17066, -10240, -2457, 12151, -6826
     },
     {
          5097, -5097, -5097, 5097, -13107, 13107, 13107, -13107, 
          5097, -5097, -5097, 5097, -13107, 13107, 13107, -13107, 
          18932, -18932, -18932, 18932, -22573, 22573, 22573, -22573, 
          18932, -18932, -18932, 18932, -22573, 22573, 22573, -22573, 
          23301, -23301, -23301, 23301, -18932, 18932, 18932, -18932, 
          23301, -23301, -23301, 23301, -18932, 18932, 18932, -18932, 
          13107, -13107, -13107, 13107, -4369, 4369, 4369, -4369, 
          13107, -13107, -13107, 13107, -4369, 4369, 4369, -4369
     },
     {
          3413, -6075, 1228, 5120, -9671, 17214, -3481, -14506, 
          -5120, -1228, 6075, -3413, 14506, 3481, -17214, 9671, 
          15360, -27340, 5529, 23040, -18204, 32403, -6553, -27306, 
          -23040, -5529, 27340, -15360, 27306, 6553, -32403, 18204, 
          18204, -32403, 6553, 27306, -15360, 27340, -5529, -23040, 
          -27306, -6553, 32403, -18204, 23040, 5529, -27340, 15360, 
          9671, -17214, 3481, 14506, -3413, 6075, -1228, -5120, 
          -14506, -3481, 17214, -9671, 5120, 1228, -6075, 3413
     },
     {
          4778, -11468, 11468, -4778, -11548, 27716, -27716, 11548, 
          -4778, 11468, -11468, 4778, 11548, -27716, 27716, -11548, 
          11548, -27716, 27716, -11548, -4778, 11468, -11468, 4778, 
          -11548, 27716, -27716, 11548, 4778, -11468, 11468, -4778, 
          -4778, 11468, -11468, 4778, 11548, -27716, 27716, -11548, 
          4778, -11468, 11468, -4778, -11548, 27716, -27716, 11548, 
          -11548, 27716, -27716, 11548, 5176, -12424, 12424, -5176, 
          11548, -27716, 27716, -11548, -5176, 12424, -12424, 5176
     },
     {
          3481, -9671, 14506, -17214, -6348, 17635, -26453, 31391, 
          17214, -14506, 9671, -3481, -31391, 26453, -17635, 6348, 
          1228, -3413, 5120, -6075, 5324, -14791, 22186, -26328, 
          6075, -5120, 3413, -1228, 26328, -22186, 14791, -5324, 
          -5324, 14791, -22186, 26328, -1228, 3413, -5120, 6075, 
          -26328, 22186, -14791, 5324, -6075, 5120, -3413, 1228, 
          6348, -17635, 26453, -31391, -3481, 9671, -14506, 17214, 
          31391, -26453, 17635, -6348, -17214, 14506, -9671, 3481
     },
     {
          2457, -6826, 10240, -12151, -5939, 16497, -24746, 29366, 
          12151, -10240, 6826, -2457, -29366, 24746, -16497, 5939, 
          5939, -16497, 24746, -29366, -2662, 7395, -11093, 13164, 
          29366, -24746, 16497, -5939, -13164, 11093, -7395, 2662, 
          -2457, 6826, -10240, 12151, 6144, -17066, 25600, -30378, 
          -12151, 10240, -6826, 2457, 30378, -25600, 17066, -6144, 
          -6144, 17066, -25600, 30378, 2662, -7395, 11093, -13164, 
          -30378, 25600, -17066, 6144, 13164, -11093, 7395, -2662
     },
     {
          2389, -5734, 5734, -2389, -6769, 16247, -16247, 6769, 
          -2389, 5734, -5734, 2389, 6769, -16247, 16247, -6769, 
          10353, -24849, 24849, -10353, -12344, 29627, -29627, 12344, 
          -10353, 24849, -24849, 10353, 12344, -29627, 29627, -12344, 
          12344, -29627, 29627, -12344, -10752, 25804, -25804, 10752, 
          -12344, 29627, -29627, 12344, 10752, -25804, 25804, -10752, 
          7168, -17203, 17203, -7168, -2389, 5734, -5734, 2389, 
          -7168, 17203, -17203, 7168, 2389, -5734, 5734, -2389
     },
     {
          1228, -3413, 5120, -6075, -3481, 9671, -14506, 17214, 
          6075, -5120, 3413, -1228, -17214, 14506, -9671, 3481, 
          5324, -14791, 22186, -26328, -6553, 18204, -27306, 32403, 
          26328, -22186, 14791, -5324, -32403, 27306, -18204, 6553, 
          6553, -18204, 27306, -32403, -5324, 14791, -22186, 26328, 
          32403, -27306, 18204, -6553, -26328, 22186, -14791, 5324, 
          3481, -9671, 14506, -17214, -1228, 3413, -5120, 6075, 
          17214, -14506, 9671, -3481, -6075, 5120, -3413, 1228
     }
};
// clang-format on
