# Помочь FastAPI - Получить помощь { #help-fastapi-get-help }

Нравится ли Вам **FastAPI**?

Хотели бы Вы помочь FastAPI, другим пользователям и автору?

Или Вы хотите получить помощь по **FastAPI**?

Есть несколько очень простых способов помочь (иногда достаточно всего лишь одного-двух кликов).

И также есть несколько способов получить помощь.

## Подписаться на новостную рассылку { #subscribe-to-the-newsletter }

Вы можете подписаться на редкую [новостную рассылку **FastAPI и его друзья**](newsletter.md){.internal-link target=_blank} и быть в курсе о:

* Новостях о FastAPI и его друзьях 🚀
* Руководствах 📝
* Возможностях ✨
* Ломающих изменениях 🚨
* Подсказках и хитростях ✅

## Подписаться на FastAPI в X (Twitter) { #follow-fastapi-on-x-twitter }

<a href="https://x.com/fastapi" class="external-link" target="_blank">Подписаться на @fastapi в **X (Twitter)**</a> для получения наисвежайших новостей о **FastAPI**. 🐦

## Добавить **FastAPI** звезду на GitHub { #star-fastapi-in-github }

Вы можете добавить FastAPI "звезду" на GitHub (кликнув на кнопку звезды в правом верхнем углу): <a href="https://github.com/fastapi/fastapi" class="external-link" target="_blank">https://github.com/fastapi/fastapi</a>. ⭐️

Чем больше звёзд, тем легче другим пользователям найти проект и увидеть, что он уже оказался полезным для многих.

## Отслеживать свежие выпуски в репозитории на GitHub { #watch-the-github-repository-for-releases }

Вы можете "отслеживать" FastAPI на GitHub (кликнув по кнопке "watch" наверху справа): <a href="https://github.com/fastapi/fastapi" class="external-link" target="_blank">https://github.com/fastapi/fastapi</a>. 👀

Там же Вы можете выбрать "Releases only".

С такой настройкой Вы будете получать уведомления на вашу электронную почту каждый раз, когда появится новый релиз (новая версия) **FastAPI** с исправлениями ошибок и новыми возможностями.

## Связаться с автором { #connect-with-the-author }

Можно связаться со <a href="https://tiangolo.com" class="external-link" target="_blank">мной (Sebastián Ramírez / `tiangolo`)</a>, автором.

Вы можете:

* <a href="https://github.com/tiangolo" class="external-link" target="_blank">Подписаться на меня на **GitHub**</a>.
    * Посмотреть другие мои проекты с открытым кодом, которые могут быть полезны Вам.
    * Подписаться, чтобы видеть, когда я создаю новый проект с открытым кодом.
* <a href="https://x.com/tiangolo" class="external-link" target="_blank">Подписаться на меня в **X (Twitter)**</a> или в <a href="https://fosstodon.org/@tiangolo" class="external-link" target="_blank">Mastodon</a>.
    * Поделиться со мной, как Вы используете FastAPI (я обожаю это читать).
    * Узнавать, когда я делаю объявления или выпускаю новые инструменты.
    * Вы также можете <a href="https://x.com/fastapi" class="external-link" target="_blank">подписаться на @fastapi в X (Twitter)</a> (это отдельный аккаунт).
* <a href="https://www.linkedin.com/in/tiangolo/" class="external-link" target="_blank">Подписаться на меня в **LinkedIn**</a>.
    * Узнавать, когда я делаю объявления или выпускаю новые инструменты (хотя чаще я использую X (Twitter) 🤷‍♂).
* Читать, что я пишу (или подписаться на меня) на <a href="https://dev.to/tiangolo" class="external-link" target="_blank">**Dev.to**</a> или <a href="https://medium.com/@tiangolo" class="external-link" target="_blank">**Medium**</a>.
    * Читать другие идеи, статьи и о созданных мной инструментах.
    * Подписаться, чтобы читать, когда я публикую что-то новое.

## Оставить сообщение в X (Twitter) о **FastAPI** { #tweet-about-fastapi }

<a href="https://x.com/compose/tweet?text=I'm loving @fastapi because... https://github.com/fastapi/fastapi" class="external-link" target="_blank">Оставьте сообщение в X (Twitter) о **FastAPI**</a> и позвольте мне и другим узнать, почему он Вам нравится. 🎉

Я люблю узнавать о том, как **FastAPI** используется, что Вам понравилось в нём, в каких проектах/компаниях Вы его используете и т.д.

## Оставить голос за FastAPI { #vote-for-fastapi }

* <a href="https://www.slant.co/options/34241/~fastapi-review" class="external-link" target="_blank">Голосуйте за **FastAPI** в Slant</a>.
* <a href="https://alternativeto.net/software/fastapi/about/" class="external-link" target="_blank">Голосуйте за **FastAPI** в AlternativeTo</a>.
* <a href="https://stackshare.io/pypi-fastapi" class="external-link" target="_blank">Расскажите, что Вы используете **FastAPI** на StackShare</a>.

## Помочь другим с вопросами на GitHub { #help-others-with-questions-in-github }

Вы можете попробовать помочь другим с их вопросами в:

* <a href="https://github.com/fastapi/fastapi/discussions/categories/questions?discussions_q=category%3AQuestions+is%3Aunanswered" class="external-link" target="_blank">GitHub Discussions</a>
* <a href="https://github.com/fastapi/fastapi/issues?q=is%3Aissue+is%3Aopen+sort%3Aupdated-desc+label%3Aquestion+-label%3Aanswered+" class="external-link" target="_blank">GitHub Issues</a>

Во многих случаях Вы уже можете знать ответы на эти вопросы. 🤓

Если Вы много помогаете людям с их вопросами, Вы станете официальным [Экспертом FastAPI](fastapi-people.md#fastapi-experts){.internal-link target=_blank}. 🎉

Только помните, самое важное — постарайтесь быть добрыми. Люди приходят со своими разочарованиями и часто задают вопросы не лучшим образом, но постарайтесь, насколько можете, быть доброжелательными. 🤗

Идея сообщества **FastAPI** — быть доброжелательным и гостеприимным. В то же время не допускайте травлю или неуважительное поведение по отношению к другим. Мы должны заботиться друг о друге.

---

Как помочь другим с вопросами (в обсуждениях или Issues):

### Понять вопрос { #understand-the-question }

* Убедитесь, что поняли **цель** и кейс использования задающего вопрос.

* Затем проверьте, что вопрос (в подавляющем большинстве это вопросы) сформулирован **ясно**.

* Во многих случаях спрашивают о воображаемом решении пользователя, но может быть решение **получше**. Если Вы лучше поймёте проблему и кейс, сможете предложить **альтернативное решение**.

* Если вопрос непонятен, запросите больше **деталей**.

### Воспроизвести проблему { #reproduce-the-problem }

В большинстве случаев и вопросов есть что-то связанное с **исходным кодом** автора.

Во многих случаях предоставляют только фрагмент кода, но этого недостаточно, чтобы **воспроизвести проблему**.

* Попросите предоставить <a href="https://stackoverflow.com/help/minimal-reproducible-example" class="external-link" target="_blank">минимальный воспроизводимый пример</a>, который Вы сможете **скопировать-вставить** и запустить локально, чтобы увидеть ту же ошибку или поведение, или лучше понять их кейс.

* Если чувствуете себя особенно великодушными, можете попытаться **создать такой пример** сами, основываясь только на описании проблемы. Просто помните, что это может занять много времени, и, возможно, сначала лучше попросить уточнить проблему.

### Предложить решение { #suggest-solutions }

* После того как Вы поняли вопрос, Вы можете дать возможный **ответ**.

* Во многих случаях лучше понять **исходную проблему или кейс**, потому что может существовать способ решить её лучше, чем то, что пытаются сделать.

### Попросить закрыть { #ask-to-close }

Если Вам ответили, велика вероятность, что Вы решили их проблему, поздравляю, **Вы — герой**! 🦸

* Теперь, если проблема решена, можно попросить их:
    * В GitHub Discussions: пометить комментарий как **answer** (ответ).
    * В GitHub Issues: **закрыть** Issue.

## Отслеживать репозиторий на GitHub { #watch-the-github-repository }

Вы можете "отслеживать" FastAPI на GitHub (кликнув по кнопке "watch" наверху справа): <a href="https://github.com/fastapi/fastapi" class="external-link" target="_blank">https://github.com/fastapi/fastapi</a>. 👀

Если Вы выберете "Watching" вместо "Releases only", то будете получать уведомления, когда кто-либо создаёт новый вопрос или Issue. Вы также можете указать, что хотите получать уведомления только о новых Issues, или обсуждениях, или пулл-реквестах и т.д.

Тогда Вы можете попробовать помочь им с решением этих вопросов.

## Задать вопросы { #ask-questions }

Вы можете <a href="https://github.com/fastapi/fastapi/discussions/new?category=questions" class="external-link" target="_blank">создать новый вопрос</a> в репозитории GitHub, например:

* Задать **вопрос** или спросить о **проблеме**.
* Предложить новую **возможность**.

**Заметка**: если Вы это сделаете, то я попрошу Вас также помогать другим. 😉

## Проверять пулл-реквесты { #review-pull-requests }

Вы можете помочь мне проверять пулл-реквесты других участников.

И, снова, постарайтесь быть доброжелательными. 🤗

---

О том, что нужно иметь в виду и как проверять пулл-реквест:

### Понять проблему { #understand-the-problem }

* Во-первых, убедитесь, что **поняли проблему**, которую пулл-реквест пытается решить. Возможно, это обсуждалось более подробно в GitHub Discussion или Issue.

* Также есть вероятность, что пулл-реквест не нужен, так как проблему можно решить **другим путём**. Тогда Вы можете предложить или спросить об этом.

### Не переживайте о стиле { #dont-worry-about-style }

* Не стоит слишком беспокоиться о таких вещах, как стиль сообщений в коммитах — при слиянии я выполню squash и настрою коммит вручную.

* Также не беспокойтесь о правилах стиля, это уже проверяют автоматизированные инструменты.

Если будет нужна какая-то другая стилистика или единообразие, я попрошу об этом напрямую или добавлю поверх свои коммиты с нужными изменениями.

### Проверить код { #check-the-code }

* Проверьте и прочитайте код, посмотрите, логичен ли он, **запустите его локально** и проверьте, действительно ли он решает проблему.

* Затем оставьте **комментарий**, что Вы это сделали, так я пойму, что Вы действительно проверили код.

/// info | Информация

К сожалению, я не могу просто доверять PR-ам только потому, что у них есть несколько одобрений.

Несколько раз было так, что у PR-ов было 3, 5 или больше одобрений, вероятно из-за привлекательного описания, но когда я их проверял, они оказывались сломанными, содержали баги или вовсе не решали заявленную проблему. 😅

Поэтому очень важно действительно прочитать и запустить код и сообщить мне об этом в комментарии. 🤓

///

* Если PR можно упростить, Вы можете попросить об этом, но не нужно быть слишком придирчивым — может быть много субъективных мнений (и у меня тоже 🙈), поэтому лучше сосредоточиться на фундаментальных вещах.

### Тестировать { #tests }

* Помогите мне проверить, что у PR есть **тесты**.

* Проверьте, что тесты **падают** до PR. 🚨

* Затем проверьте, что тесты **проходят** после PR. ✅

* Многие PR не имеют тестов — Вы можете **напомнить** добавить тесты или даже **предложить** некоторые тесты сами. Это одна из самых трудозатратных частей, и здесь Вы можете очень помочь.

* Затем добавьте комментарий, что Вы попробовали, чтобы я знал, что Вы это проверили. 🤓

## Создать пулл-реквест { #create-a-pull-request }

Вы можете [сделать вклад](contributing.md){.internal-link target=_blank} в исходный код пулл-реквестами, например:

* Исправить опечатку, найденную в документации.
* Поделиться статьёй, видео или подкастом о FastAPI, которые Вы создали или нашли, <a href="https://github.com/fastapi/fastapi/edit/master/docs/en/data/external_links.yml" class="external-link" target="_blank">изменив этот файл</a>.
    * Убедитесь, что добавили свою ссылку в начало соответствующего раздела.
* Помочь с [переводом документации](contributing.md#translations){.internal-link target=_blank} на Ваш язык.
    * Вы также можете проверять переводы, сделанные другими.
* Предложить новые разделы документации.
* Исправить существующую проблему/баг.
    * Убедитесь, что добавили тесты.
* Добавить новую возможность.
    * Убедитесь, что добавили тесты.
    * Убедитесь, что добавили документацию, если это уместно.

## Помочь поддерживать FastAPI { #help-maintain-fastapi }

Помогите мне поддерживать **FastAPI**! 🤓

Предстоит ещё много работы, и, по большей части, **ВЫ** можете её сделать.

Основные задачи, которые Вы можете выполнить прямо сейчас:

* [Помочь другим с вопросами на GitHub](#help-others-with-questions-in-github){.internal-link target=_blank} (смотрите секцию выше).
* [Проверять пулл-реквесты](#review-pull-requests){.internal-link target=_blank} (смотрите секцию выше).

Именно эти две задачи **забирают больше всего времени**. Это основная работа по поддержке FastAPI.

Если Вы можете помочь мне с этим, **Вы помогаете поддерживать FastAPI** и делаете так, чтобы он продолжал **развиваться быстрее и лучше**. 🚀

## Подключиться к чату { #join-the-chat }

Подключайтесь к 👥 <a href="https://discord.gg/VQjSZaeJmf" class="external-link" target="_blank">серверу чата в Discord</a> 👥 и общайтесь с другими участниками сообщества FastAPI.

/// tip | Подсказка

По вопросам — задавайте их в <a href="https://github.com/fastapi/fastapi/discussions/new?category=questions" class="external-link" target="_blank">GitHub Discussions</a>, так гораздо выше шанс, что Вы получите помощь от [Экспертов FastAPI](fastapi-people.md#fastapi-experts){.internal-link target=_blank}.

Используйте чат только для прочих общих бесед.

///

### Не используйте чат для вопросов { #dont-use-the-chat-for-questions }

Имейте в виду, что в чатах, благодаря "свободному общению", легко задать вопросы, которые слишком общие и на которые сложнее ответить, поэтому Вы можете не получить ответы.

На GitHub шаблон поможет Вам правильно сформулировать вопрос, чтобы Вам было легче получить хороший ответ или даже решить проблему самостоятельно ещё до того, как спросите. И на GitHub я могу следить за тем, чтобы всегда отвечать на всё, даже если это занимает время. А с чатами я не могу сделать этого лично. 😅

Кроме того, переписка в чатах хуже ищется, чем на GitHub, поэтому вопросы и ответы могут теряться среди остальных сообщений. И только те, что на GitHub, учитываются для получения лычки [Эксперт FastAPI](fastapi-people.md#fastapi-experts){.internal-link target=_blank}, так что вероятнее всего Вы получите больше внимания именно на GitHub.

С другой стороны, в чатах тысячи пользователей, так что почти всегда есть шанс найти там кого-то для разговора. 😄

## Спонсировать автора { #sponsor-the-author }

Если Ваш **продукт/компания** зависят от **FastAPI** или связаны с ним и Вы хотите донести до пользователей информацию о себе, Вы можете спонсировать автора (меня) через <a href="https://github.com/sponsors/tiangolo" class="external-link" target="_blank">GitHub Sponsors</a>. В зависимости от уровня поддержки Вы можете получить дополнительные бонусы, например, бейдж в документации. 🎁

---

Спасибо! 🚀
