# Тіло — Поля { #body-fields }

Так само як ви можете оголошувати додаткову валідацію та метадані в параметрах *функції операції шляху* за допомогою `Query`, `Path` та `Body`, ви можете оголошувати валідацію та метадані всередині моделей Pydantic, використовуючи `Field` від Pydantic.

## Імпорт `Field` { #import-field }

Спочатку вам потрібно імпортувати це:

{* ../../docs_src/body_fields/tutorial001_an_py310.py hl[4] *}


/// warning | Попередження

Зверніть увагу, що `Field` імпортується безпосередньо з `pydantic`, а не з `fastapi`, як усе інше (`Query`, `Path`, `Body` тощо).

///

## Оголошення атрибутів моделі { #declare-model-attributes }

Потім ви можете використовувати `Field` з атрибутами моделі:

{* ../../docs_src/body_fields/tutorial001_an_py310.py hl[11:14] *}

`Field` працює так само, як `Query`, `Path` і `Body`, має ті самі параметри тощо.

/// note | Технічні деталі

Насправді `Query`, `Path` та інші, які ви побачите далі, створюють об'єкти підкласів спільного класу `Param`, який сам є підкласом класу `FieldInfo` з Pydantic.

І `Field` від Pydantic також повертає екземпляр `FieldInfo`.

`Body` також безпосередньо повертає об'єкти підкласу `FieldInfo`. І є інші, які ви побачите пізніше, що є підкласами класу `Body`.

Пам'ятайте, що коли ви імпортуєте `Query`, `Path` та інші з `fastapi`, це фактично функції, які повертають спеціальні класи.

///

/// tip | Порада

Зверніть увагу, що кожен атрибут моделі з типом, значенням за замовчуванням і `Field` має ту саму структуру, що й параметр *функції операції шляху*, з `Field` замість `Path`, `Query` і `Body`.

///

## Додавання додаткової інформації { #add-extra-information }

Ви можете оголошувати додаткову інформацію в `Field`, `Query`, `Body` тощо. І вона буде включена до згенерованої JSON Schema.

Ви дізнаєтеся більше про додавання додаткової інформації пізніше в документації, коли вивчатимете, як оголошувати приклади.

/// warning | Попередження

Додаткові ключі, передані в `Field`, також будуть присутні в отриманій схемі OpenAPI для вашого застосунку.
Оскільки ці ключі не обов'язково є частиною специфікації OpenAPI, деякі інструменти OpenAPI, наприклад [валідатор OpenAPI](https://validator.swagger.io/), можуть не працювати з вашою згенерованою схемою.

///

## Підсумок { #recap }

Ви можете використовувати `Field` від Pydantic, щоб оголошувати додаткову валідацію та метадані для атрибутів моделі.

Ви також можете використовувати додаткові keyword arguments, щоб передавати додаткові метадані JSON Schema.
